/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;

public class ResourceFileManager {
    public void copyResourceToFile(Class<?> callingClass, String sourceResource, File destinationFile) {
        byte[] buffer = new byte[4096];
        try (InputStream is = callingClass.getResourceAsStream(sourceResource);){
            if (is == null) {
                throw new FileNotFoundException("Could not find " + sourceResource);
            }
            try (FileOutputStream os = new FileOutputStream(destinationFile);){
                int bytesRead;
                while ((bytesRead = is.read(buffer)) >= 0) {
                    ((OutputStream)os).write(buffer, 0, bytesRead);
                }
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to copy resource " + sourceResource + " to file " + destinationFile);
        }
    }
}

