/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.ComparableComparator;
import org.openstreetmap.osmosis.core.store.IndexStore;
import org.openstreetmap.osmosis.core.store.IndexStoreReader;
import org.openstreetmap.osmosis.core.store.LongLongIndexElement;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SegmentedObjectStore;
import org.openstreetmap.osmosis.core.store.Storeable;

public class ChunkedObjectStore<T extends Storeable>
implements Completable {
    private SegmentedObjectStore<T> objectStore;
    private IndexStore<Long, LongLongIndexElement> indexStore;
    private IndexStoreReader<Long, LongLongIndexElement> indexStoreReader;
    private long chunkCount;
    private boolean chunkInProgress;
    private long newChunkFilePosition;
    private long chunkObjectCount;

    public ChunkedObjectStore(ObjectSerializationFactory serializationFactory, String storageFilePrefix, String indexFilePrefix, boolean useCompression) {
        this.objectStore = new SegmentedObjectStore(serializationFactory, storageFilePrefix, useCompression);
        this.indexStore = new IndexStore(LongLongIndexElement.class, new ComparableComparator(), indexFilePrefix);
        this.chunkCount = 0L;
        this.chunkInProgress = false;
        this.newChunkFilePosition = 0L;
        this.chunkObjectCount = 0L;
    }

    public void add(T data) {
        this.objectStore.add(data);
        ++this.chunkObjectCount;
        if (!this.chunkInProgress) {
            this.indexStore.write(new LongLongIndexElement(this.chunkCount * 2L, this.newChunkFilePosition));
            this.chunkInProgress = true;
        }
    }

    public void closeChunk() {
        if (this.chunkInProgress) {
            this.newChunkFilePosition = this.objectStore.closeChunk();
            this.chunkInProgress = false;
            this.indexStore.write(new LongLongIndexElement(this.chunkCount * 2L + 1L, this.chunkObjectCount));
            this.chunkObjectCount = 0L;
            ++this.chunkCount;
        }
    }

    public long getChunkCount() {
        if (this.chunkInProgress) {
            return this.chunkCount + 1L;
        }
        return this.chunkCount;
    }

    public ReleasableIterator<T> iterate(long chunk) {
        this.complete();
        if (this.indexStoreReader == null) {
            this.indexStoreReader = this.indexStore.createReader();
        }
        return this.objectStore.iterate(this.indexStoreReader.get(chunk * 2L).getValue(), this.indexStoreReader.get(chunk * 2L + 1L).getValue());
    }

    @Override
    public void complete() {
        this.closeChunk();
        this.indexStore.complete();
    }

    @Override
    public void close() {
        this.objectStore.close();
        if (this.indexStoreReader != null) {
            this.indexStoreReader.close();
            this.indexStoreReader = null;
        }
        this.indexStore.close();
    }
}

