/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.store.EndOfStoreException;
import org.openstreetmap.osmosis.core.store.ObjectReader;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.store.StoreableConstructorCache;

public abstract class BaseObjectReader
implements ObjectReader {
    private StoreReader storeReader;
    private StoreClassRegister storeClassRegister;
    private StoreableConstructorCache constructorCache;

    public BaseObjectReader(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        this.storeReader = storeReader;
        this.storeClassRegister = storeClassRegister;
        this.constructorCache = new StoreableConstructorCache();
    }

    protected abstract Class<?> readClassFromIdentifier(StoreReader var1, StoreClassRegister var2);

    @Override
    public Storeable readObject() {
        Class<?> clazz = this.readClassFromIdentifier(this.storeReader, this.storeClassRegister);
        Constructor<?> constructor = this.constructorCache.getStoreableConstructor(clazz);
        try {
            return (Storeable)constructor.newInstance(this.storeReader, this.storeClassRegister);
        }
        catch (IllegalAccessException e) {
            throw new OsmosisRuntimeException("The class " + constructor.getDeclaringClass().getName() + " could not be instantiated.", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EndOfStoreException) {
                throw (EndOfStoreException)cause;
            }
            throw new OsmosisRuntimeException("The class " + constructor.getDeclaringClass().getName() + " could not be instantiated.", e);
        }
        catch (InstantiationException e) {
            throw new OsmosisRuntimeException("The class " + constructor.getDeclaringClass().getName() + " could not be instantiated.", e);
        }
    }
}

