/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.filter.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;
import org.openstreetmap.osmosis.core.util.LongAsInt;

public class ListIdTracker
implements IdTracker {
    private static final double LIST_SIZE_EXTENSION_FACTOR = 1.5;
    int[] idList = new int[1];
    int idOffset = 0;
    private int maxIdAdded = Integer.MIN_VALUE;
    private boolean sorted = true;

    private void extendIdList() {
        int newListLength = (int)((double)this.idList.length * 1.5);
        if (newListLength == this.idList.length) {
            ++newListLength;
        }
        int[] newIdList = new int[newListLength];
        System.arraycopy(this.idList, 0, newIdList, 0, this.idList.length);
        this.idList = newIdList;
    }

    private void ensureListIsSorted() {
        if (!this.sorted) {
            int i;
            ArrayList<Integer> tmpList = new ArrayList<Integer>(this.idOffset);
            for (i = 0; i < this.idOffset; ++i) {
                tmpList.add(this.idList[i]);
            }
            Collections.sort(tmpList);
            int newIdOffset = 0;
            for (i = 0; i < this.idOffset; ++i) {
                int nextValue = (Integer)tmpList.get(i);
                if (newIdOffset > 0 && nextValue <= this.idList[newIdOffset - 1]) continue;
                this.idList[newIdOffset++] = nextValue;
            }
            this.idOffset = newIdOffset;
            this.sorted = true;
        }
    }

    @Override
    public void set(long id) {
        int integerId = LongAsInt.longToInt(id);
        if (this.idOffset >= this.idList.length) {
            this.extendIdList();
        }
        this.idList[this.idOffset++] = integerId;
        if (integerId < this.maxIdAdded) {
            this.sorted = false;
        } else {
            this.maxIdAdded = integerId;
        }
    }

    @Override
    public boolean get(long id) {
        int integerId = LongAsInt.longToInt(id);
        this.ensureListIsSorted();
        int intervalBegin = 0;
        int intervalEnd = this.idOffset;
        boolean idFound = false;
        boolean searchComplete = false;
        while (!searchComplete) {
            int currentId;
            int intervalSize = intervalEnd - intervalBegin;
            if (intervalSize >= 2) {
                int intervalMid = intervalSize / 2 + intervalBegin;
                currentId = this.idList[intervalMid];
                if (currentId == integerId) {
                    idFound = true;
                    searchComplete = true;
                    continue;
                }
                if (currentId < integerId) {
                    intervalBegin = intervalMid + 1;
                    continue;
                }
                intervalEnd = intervalMid;
                continue;
            }
            for (int currentOffset = intervalBegin; currentOffset < intervalEnd; ++currentOffset) {
                currentId = this.idList[currentOffset];
                if (currentId != integerId) continue;
                idFound = true;
                break;
            }
            searchComplete = true;
        }
        return idFound;
    }

    @Override
    public Iterator<Long> iterator() {
        this.ensureListIsSorted();
        return new IdIterator();
    }

    @Override
    public void setAll(IdTracker idTracker) {
        for (Long id : idTracker) {
            this.set(id);
        }
    }

    private class IdIterator
    implements Iterator<Long> {
        private int iteratorOffset = 0;

        IdIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iteratorOffset < ListIdTracker.this.idOffset;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ListIdTracker.this.idList[this.iteratorOffset++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

