/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagfilter.v0_6;

import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;
import org.openstreetmap.osmosis.core.filter.common.IdTrackerFactory;
import org.openstreetmap.osmosis.core.filter.common.IdTrackerType;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SimpleObjectStore;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class UsedNodeFilter
implements SinkSource,
EntityProcessor {
    private Sink sink;
    private SimpleObjectStore<NodeContainer> allNodes = new SimpleObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(NodeContainer.class), "afnd", true);
    private SimpleObjectStore<WayContainer> allWays = new SimpleObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(WayContainer.class), "afwy", true);
    private SimpleObjectStore<RelationContainer> allRelations = new SimpleObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(RelationContainer.class), "afrl", true);
    private IdTracker requiredNodes;

    public UsedNodeFilter(IdTrackerType idTrackerType) {
        this.requiredNodes = IdTrackerFactory.createInstance((IdTrackerType)idTrackerType);
    }

    public void initialize(Map<String, Object> metaData) {
        this.sink.initialize(metaData);
    }

    public void process(EntityContainer entityContainer) {
        entityContainer.process((EntityProcessor)this);
    }

    public void process(BoundContainer boundContainer) {
        this.sink.process((EntityContainer)boundContainer);
    }

    public void process(NodeContainer container) {
        this.allNodes.add((Storeable)container);
    }

    public void process(WayContainer container) {
        Way way = container.getEntity();
        for (WayNode nodeReference : way.getWayNodes()) {
            long nodeId = nodeReference.getNodeId();
            this.requiredNodes.set(nodeId);
        }
        this.allWays.add((Storeable)container);
    }

    public void process(RelationContainer container) {
        Relation relation = container.getEntity();
        for (RelationMember memberReference : relation.getMembers()) {
            if (memberReference.getMemberType() != EntityType.Node) continue;
            long nodeId = memberReference.getMemberId();
            this.requiredNodes.set(nodeId);
        }
        this.allRelations.add((Storeable)container);
    }

    public void complete() {
        ReleasableIterator nodeIterator = this.allNodes.iterate();
        while (nodeIterator.hasNext()) {
            NodeContainer nodeContainer = (NodeContainer)nodeIterator.next();
            long nodeId = nodeContainer.getEntity().getId();
            if (!this.requiredNodes.get(nodeId)) continue;
            this.sink.process((EntityContainer)nodeContainer);
        }
        nodeIterator.close();
        nodeIterator = null;
        ReleasableIterator wayIterator = this.allWays.iterate();
        while (wayIterator.hasNext()) {
            this.sink.process((EntityContainer)wayIterator.next());
        }
        wayIterator.close();
        wayIterator = null;
        ReleasableIterator relationIterator = this.allRelations.iterate();
        while (relationIterator.hasNext()) {
            this.sink.process((EntityContainer)relationIterator.next());
        }
        relationIterator.close();
        relationIterator = null;
        this.sink.complete();
    }

    public void close() {
        if (this.allNodes != null) {
            this.allNodes.close();
        }
        if (this.allWays != null) {
            this.allWays.close();
        }
        if (this.allRelations != null) {
            this.allRelations.close();
        }
        this.sink.close();
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

