# Generated by Django 3.1.6 on 2021-02-04 21:21

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('questionnaires', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Answer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('custom', models.TextField(blank=True, default=None, null=True, verbose_name='custom')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('option', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='questionnaires.option', verbose_name='option')),
                ('option_column', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='option_column', to='questionnaires.option', verbose_name='option column')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='questionnaires.question', verbose_name='question')),
            ],
            options={
                'verbose_name': 'answer',
                'verbose_name_plural': 'answers',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='VotedQuestion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('weight', models.PositiveIntegerField(db_index=True, default=0, verbose_name='weight')),
                ('page', models.PositiveIntegerField(default=1, verbose_name='page')),
                ('quiz_result', models.FloatField(blank=True, db_index=True, default=None, null=True, verbose_name='quiz result')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='questionnaires.question', verbose_name='question')),
            ],
            options={
                'verbose_name': 'voted question',
                'verbose_name_plural': 'voted questions',
                'ordering': ('weight', 'pk'),
            },
        ),
        migrations.CreateModel(
            name='Voter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(choices=[('sk', 'Slovak'), ('hu', 'Hungarian')], max_length=2, verbose_name='language')),
                ('quiz_result', models.FloatField(blank=True, db_index=True, default=None, null=True, verbose_name='quiz result')),
                ('hash_key', models.CharField(blank=True, db_index=True, default=None, max_length=255, null=True, verbose_name='hash key')),
                ('ip_address', models.CharField(blank=True, max_length=255, verbose_name='IP address')),
                ('voting_started', models.DateTimeField(blank=True, default=None, null=True, verbose_name='voting started')),
                ('voting_ended', models.DateTimeField(blank=True, default=None, null=True, verbose_name='voting ended')),
                ('voting_duration', models.PositiveIntegerField(blank=True, db_index=True, default=None, null=True, verbose_name='voting duration')),
                ('flag', models.CharField(blank=True, max_length=256, verbose_name='custom flag')),
                ('is_quiz_result_sent', models.BooleanField(db_index=True, default=False, verbose_name='quiz result sent')),
                ('is_api_voter', models.BooleanField(default=False, verbose_name='API voter')),
                ('is_irrelevant', models.BooleanField(default=False, verbose_name='irrelevant')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('answered_questions', models.ManyToManyField(related_name='voter_set_answered', through='voting.Answer', to='questionnaires.Question')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='questionnaires.survey', verbose_name='survey')),
                ('user', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
                ('voted_questions', models.ManyToManyField(related_name='voter_set_voted', through='voting.VotedQuestion', to='questionnaires.Question')),
            ],
            options={
                'verbose_name': 'voter',
                'verbose_name_plural': 'voters',
                'ordering': ('-created',),
            },
        ),
        migrations.AddField(
            model_name='votedquestion',
            name='voter',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='voting.voter', verbose_name='voter'),
        ),
        migrations.AddField(
            model_name='answer',
            name='voter',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='voting.voter', verbose_name='voter'),
        ),
    ]
