# Generated by Django 3.1.6 on 2021-02-04 21:21

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import modeltrans.fields
import pragmatic.mixins
import tinymce.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Survey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=150, verbose_name='title')),
                ('slug', models.SlugField(blank=True, max_length=150, unique=True)),
                ('hash_key', models.CharField(blank=True, db_index=True, max_length=30, unique=True, verbose_name='hash key')),
                ('preface', models.TextField(blank=True, verbose_name='preface')),
                ('postface', models.TextField(blank=True, verbose_name='postface')),
                ('date_from', models.DateTimeField(blank=True, db_index=True, default=django.utils.timezone.now, help_text='Users can start voting beginning this date.', null=True, verbose_name='valid from')),
                ('date_to', models.DateTimeField(blank=True, db_index=True, default=None, help_text='Users will be able to vote until this date. Keep blank to unlimited.', null=True, verbose_name='valid to')),
                ('password', models.CharField(blank=True, default=None, max_length=20, null=True, verbose_name='password')),
                ('permission_level', models.CharField(choices=[('PUBLIC', 'Public - for everyone'), ('REGISTERED', 'Registered users only')], default='PUBLIC', max_length=10, verbose_name='permission level')),
                ('statistics_policy', models.CharField(choices=[('PUBLIC', 'Public - for everyone'), ('SECRET', 'Secret - for voters only'), ('PRIVATE', 'Private - for creator only')], default='PRIVATE', max_length=7, verbose_name='statistics policy')),
                ('finish_url', models.URLField(blank=True, help_text='Fill in if you want to show custom finish URL to voter after voting.', verbose_name='Finish URL')),
                ('finish_url_title', models.CharField(blank=True, max_length=200, verbose_name='Finish URL title')),
                ('is_active', models.BooleanField(db_index=True, default=True, help_text='Current survey status. Users will not be able to start voting if inactive.', verbose_name='active')),
                ('is_repeatable', models.BooleanField(db_index=True, default=False, help_text='Set checked if users can vote multiple times in survey.', verbose_name='repeatable voting')),
                ('is_quiz_result_visible', models.BooleanField(db_index=True, default=False, help_text='Set checked if you want to show quiz results in percentage to voters.', verbose_name='show quiz results')),
                ('is_quiz_correct_options_visible', models.BooleanField(db_index=True, default=False, help_text='Set checked if you want to show correct options to voters.', verbose_name='show quiz correct options')),
                ('is_viewable', models.BooleanField(default=True, verbose_name='view survey')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('i18n', modeltrans.fields.TranslationField(fields=('title', 'slug', 'preface', 'postface'), required_languages=(), virtual_fields=True)),
            ],
            options={
                'verbose_name': 'survey',
                'verbose_name_plural': 'surveys',
                'ordering': ('-created',),
            },
            bases=(pragmatic.mixins.SlugMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tag', models.CharField(blank=True, db_index=True, max_length=6, verbose_name='tag')),
                ('kind', models.CharField(choices=[('RADIO', 'Radio'), ('CHECKBOX', 'Checkbox'), ('TEXTAREA', 'Textarea'), ('MATRIX_RADIO', 'Matrix radio'), ('MATRIX_CHECKBOX', 'Matrix checkbox'), ('TRUE_FALSE', 'True/False')], db_index=True, max_length=15, verbose_name='kind')),
                ('title', tinymce.models.HTMLField(verbose_name='title')),
                ('category', models.CharField(blank=True, db_index=True, max_length=255, verbose_name='category')),
                ('weight', models.PositiveIntegerField(db_index=True, default=0, verbose_name='weight')),
                ('true_label', models.CharField(default='True', max_length=20, verbose_name='true label')),
                ('false_label', models.CharField(default='False', max_length=20, verbose_name='false label')),
                ('is_required', models.BooleanField(default=False, verbose_name='mandatory')),
                ('is_quiz', models.BooleanField(db_index=True, default=False, verbose_name='quiz')),
                ('is_unique_answers', models.BooleanField(default=False, help_text='for matrix questions', verbose_name='unique answers')),
                ('is_empty_row_enabled', models.BooleanField(default=True, help_text='for matrix questions with required answer', verbose_name='enabled empty rows')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('i18n', modeltrans.fields.TranslationField(fields=('title', 'true_label', 'false_label'), required_languages=(), virtual_fields=True)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='questionnaires.survey', verbose_name='survey')),
            ],
            options={
                'verbose_name': 'question',
                'verbose_name_plural': 'questions',
                'ordering': ('weight', 'created'),
            },
        ),
        migrations.CreateModel(
            name='Option',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', tinymce.models.HTMLField(verbose_name='title')),
                ('orientation', models.CharField(choices=[('ROW', 'Row'), ('ROW', 'Column')], default='ROW', max_length=6, verbose_name='orientation')),
                ('is_correct', models.BooleanField(db_index=True, default=False, verbose_name='correct')),
                ('weight', models.PositiveIntegerField(db_index=True, default=0, verbose_name='weight')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('i18n', modeltrans.fields.TranslationField(fields=('title',), required_languages=(), virtual_fields=True)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='questionnaires.question', verbose_name='question')),
            ],
            options={
                'verbose_name': 'option',
                'verbose_name_plural': 'options',
                'ordering': ('weight', 'created'),
            },
        ),
    ]
