import tempfile

from galaxy.util.checkers import check_html


def test_check_html():
    html_text = '<p>\n<a href="url">Link</a>\n</p>\n'
    assert check_html(html_text, file_path=False)
    # Test a non-HTML binary string
    assert not check_html(b'No HTML here\nSecond line\n', file_path=False)
    with tempfile.NamedTemporaryFile(mode='w') as tmp:
        tmp.write(html_text)
        tmp.flush()
        assert check_html(tmp.name)
    # Test a non-UTF8 binary file
    with tempfile.NamedTemporaryFile(mode='wb') as tmp:
        tmp.write(b'\x1f\x8b')
        tmp.flush()
        assert not check_html(tmp.name)
