# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mango_explorer_v4',
 'mango_explorer_v4.accounts',
 'mango_explorer_v4.errors',
 'mango_explorer_v4.instructions',
 'mango_explorer_v4.types']

package_data = \
{'': ['*']}

install_requires = \
['anchorpy-core==0.1.2',
 'anchorpy==0.14.0',
 'anyio==3.6.2',
 'apischema==0.16.6',
 'appnope==0.1.3',
 'asttokens==2.2.1',
 'attrs==22.1.0',
 'autoflake==2.0.0',
 'backcall==0.2.0',
 'base58==2.1.1',
 'based58==0.1.1',
 'black==22.12.0',
 'borsh-construct==0.1.0',
 'cachetools==4.2.4',
 'certifi==2022.12.7',
 'cffi==1.15.1',
 'charset-normalizer==2.1.1',
 'click==8.1.3',
 'construct-typing==0.5.3',
 'construct==2.10.68',
 'decorator==5.1.1',
 'exceptiongroup==1.0.4',
 'executing==1.2.0',
 'genpy==2022.1',
 'h11==0.14.0',
 'httpcore==0.16.3',
 'httpx==0.23.1',
 'idna==3.4',
 'iniconfig==1.1.1',
 'ipython==8.7.0',
 'jedi==0.18.2',
 'jsonalias==0.1.1',
 'jsonrpcclient==4.0.2',
 'jsonrpcserver==5.0.9',
 'jsonschema==4.17.3',
 'mangopyserum>=0.6.0a0,<0.7.0',
 'matplotlib-inline==0.1.6',
 'more-itertools==8.14.0',
 'mypy-extensions==0.4.3',
 'numpy==1.24.0',
 'oslash==0.6.3',
 'packaging==22.0',
 'parso==0.8.3',
 'pathspec==0.10.3',
 'pexpect==4.8.0',
 'pickleshare==0.7.5',
 'platformdirs==2.6.0',
 'pluggy==1.0.0',
 'prompt-toolkit==3.0.36',
 'psutil==5.9.4',
 'ptyprocess==0.7.0',
 'pure-eval==0.2.2',
 'py==1.11.0',
 'pycparser==2.21',
 'pyflakes==3.0.1',
 'pygments==2.13.0',
 'pyheck==0.1.5',
 'pynacl==1.5.0',
 'pyrsistent==0.19.2',
 'pytest-asyncio==0.20.3',
 'pytest-xprocess==0.18.1',
 'pytest==7.2.0',
 'pytools==2022.1.13',
 'requests==2.28.1',
 'rfc3986==1.5.0',
 'six==1.16.0',
 'sniffio==1.3.0',
 'solana==0.28.1',
 'solders==0.10.0',
 'stack-data==0.6.2',
 'sumtypes==0.1a6',
 'tomli==2.0.1',
 'toolz==0.11.2',
 'traitlets==5.8.0',
 'typer==0.7.0',
 'types-cachetools==4.2.10',
 'typing-extensions==4.4.0',
 'urllib3==1.26.13',
 'wcwidth==0.2.5',
 'websockets==10.4',
 'zstandard==0.17.0']

setup_kwargs = {
    'name': 'mango-explorer-v4',
    'version': '0.3.0',
    'description': '',
    'long_description': '# mango-explorer-v4\n\nPython client library for interacting with Mango Markets v4.\n\n## 📦 Installation\n\n![PyPI](https://img.shields.io/pypi/v/mango-explorer-v4)\n\n`mango-explorer-v4` is available as a [Python package on PyPI](https://pypi.org/project/mango-explorer-v4) and can be installed as:\n\n```\npip install mango-explorer-v4\n```\n\n## Example usage\n\nThis example assumes that you have a wallet already set up: visit https://v4alpha.mango.markets to create a Mango account and fund it so that you can place orders. You can find the full sources [here](./examples).\n\n```python\nimport asyncio\nfrom mango_explorer_v4 import MangoClient\n\nasync def main():\n    mango_client = await MangoClient.connect(\n        secret_key=\'YOUR_SECRET_KEY\', # Output from Phantom\'s "Export Private Key"\n        mango_account_pk=\'YOUR_MANGO_ACCOUNT_PK\'\n    )\n\n    print(await mango_client.symbols())\n    # [\n    #   {\n    #       \'name\': \'SOL/USDC\',\n    #       \'baseCurrency\': \'SOL\',\n    #       \'quoteCurrency\': \'USDC\',\n    #       \'makerFees\': -5e-05,\n    #       \'takerFees\': 0.0001\n    #   }\n    #   ...\n    # ]\n\n    print(await mango_client.place_order(\'SOL/USDC\', \'bid\', 10, 0.1, \'limit\'))\n    # (Refresh the UI to see the newly opened order)\n\n    print(await mango_client.orderbook_l2(\'SOL/USDC\', 3))\n    # {\n    #   \'symbol\': \'SOL/USDC\',\n    #   \'bids\': [\n    #       [11.826, 0.899],\n    #       [11.824, 39.436],\n    #       [11.82, 316.421],\n    #    ],\n    #  \'asks\': [\n    #       [11.839, 0.78],\n    #       [11.84, 44.392],\n    #       [11.841, 1.1],\n    #   ]}\n\n    print(await mango_client.balances())\n    # [\n    #   {\'symbol\': \'USDC\', \'balance\': 2.7435726906761744},\n    #   {\'symbol\': \'SOL\', \'balance\': 0.1690007074236178},\n    #   ...\n    # ]\n\nasyncio.run(main())\n```',
    'author': 'waterquarks',
    'author_email': 'waterquarks@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
