"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayToSqsToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_certificatemanager_1 = require("aws-cdk-lib/aws-certificatemanager");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const aws_route53_1 = require("aws-cdk-lib/aws-route53");
const aws_route53_targets_1 = require("aws-cdk-lib/aws-route53-targets");
const constructs_1 = require("constructs");
/**
 * @summary The ApiGatewayToSqsToLambda class. Class is very opinionated and does not allow for existing queues or lambdas.
 * Class assumes a pulic domain should be created and the corresponding alias in route53 shall be created
 */
class ApiGatewayToSqsToLambda extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the ApiGatewayToSqsToLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {ApiGatewayToSqsToLambdaProps} props - user provided props for the construct.
     */
    constructor(scope, id, props) {
        super(scope, id);
        const { serviceName, domain, domainCertArn, route53HostedZoneId, deployDeadLetterQueue, lambdaFunction, } = props;
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            deployDeadLetterQueue: deployDeadLetterQueue,
            deadLetterQueueProps: { queueName: `${serviceName}-dl-queue` },
        });
        // this is not very clean, by default lambda has a 3 seconds timeout
        const lambdaTimeout = lambdaFunction.timeout != aws_cdk_lib_1.Duration.seconds(3)
            ? lambdaFunction.timeout
            : aws_cdk_lib_1.Duration.seconds(30);
        // Setup the queue
        this.sqsQueue = defaults.buildQueue(this, `${serviceName}-queue`, {
            deadLetterQueue: this.deadLetterQueue,
            queueProps: {
                queueName: `${serviceName}-queue`,
                visibilityTimeout: lambdaTimeout ? lambdaTimeout : aws_cdk_lib_1.Duration.seconds(30),
            },
        }).queue;
        const certificate = aws_certificatemanager_1.Certificate.fromCertificateArn(this, `*.${domain}`, domainCertArn);
        const apiGatewayProps = {
            domainName: {
                domainName: `${serviceName}.${domain}`,
                certificate: certificate,
            },
            restApiName: serviceName,
        };
        // Setup API Gateway
        this.apiGateway = new aws_apigateway_1.RestApi(this, `${serviceName}-api-gateway`, apiGatewayProps);
        this.apiGatewayRole = new aws_iam_1.Role(this, `${serviceName}-api-gateway-role`, {
            assumedBy: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
        });
        this.apiGatewayRole.addToPolicy(new aws_iam_1.PolicyStatement({
            resources: [this.sqsQueue.queueArn],
            actions: ['sqs:SendMessage'],
        }));
        core_1.addProxyMethodToApiResource({
            service: 'sqs',
            path: `${aws_cdk_lib_1.Aws.ACCOUNT_ID}/${this.sqsQueue.queueName}`,
            apiGatewayRole: this.apiGatewayRole,
            apiMethod: 'POST',
            apiResource: this.apiGateway.root,
            requestTemplate: 'Action=SendMessage&MessageBody=$util.urlEncode("$input.body")',
            contentType: "'application/x-www-form-urlencoded'",
            methodOptions: {
                authorizationType: aws_apigateway_1.AuthorizationType.NONE,
            },
        });
        // infering throws error, which is why we have to provide both
        const hostedZone = aws_route53_1.HostedZone.fromHostedZoneAttributes(this, `${domain}-zone`, {
            hostedZoneId: route53HostedZoneId,
            zoneName: domain,
        });
        new aws_route53_1.ARecord(this, `${serviceName}-alias-record`, {
            zone: hostedZone,
            recordName: serviceName,
            target: aws_route53_1.RecordTarget.fromAlias(new aws_route53_targets_1.ApiGateway(this.apiGateway)),
        });
        lambdaFunction.addEventSource(new aws_lambda_event_sources_1.SqsEventSource(this.sqsQueue, { reportBatchItemFailures: true }));
    }
}
exports.ApiGatewayToSqsToLambda = ApiGatewayToSqsToLambda;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayToSqsToLambda[_a] = { fqn: "everdrop-aws-cdk-constructs.ApiGatewayToSqsToLambda", version: "0.0.121" };
//# sourceMappingURL=data:application/json;base64,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