"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9661
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.connector_platform_param_base import ConnectorPlatformParamBase
    from intersight.model.display_names import DisplayNames
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_mo_ref import MoMoRef
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.techsupportmanagement_tech_support_bundle import TechsupportmanagementTechSupportBundle
    from intersight.model.techsupportmanagement_tech_support_status_relationship import TechsupportmanagementTechSupportStatusRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['ConnectorPlatformParamBase'] = ConnectorPlatformParamBase
    globals()['DisplayNames'] = DisplayNames
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoMoRef'] = MoMoRef
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['TechsupportmanagementTechSupportBundle'] = TechsupportmanagementTechSupportBundle
    globals()['TechsupportmanagementTechSupportStatusRelationship'] = TechsupportmanagementTechSupportStatusRelationship


class TechsupportmanagementTechSupportBundleRelationship(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'MO.MOREF': "mo.MoRef",
        },
        ('platform_type',): {
            'EMPTY': "",
            'APIC': "APIC",
            'CAPIC': "CAPIC",
            'DCNM': "DCNM",
            'UCSFI': "UCSFI",
            'UCSFIISM': "UCSFIISM",
            'IMC': "IMC",
            'IMCM4': "IMCM4",
            'IMCM5': "IMCM5",
            'IMCRACK': "IMCRack",
            'UCSIOM': "UCSIOM",
            'HX': "HX",
            'HYPERFLEXAP': "HyperFlexAP",
            'IWE': "IWE",
            'UCSD': "UCSD",
            'INTERSIGHTAPPLIANCE': "IntersightAppliance",
            'INTERSIGHTASSIST': "IntersightAssist",
            'PURESTORAGEFLASHARRAY': "PureStorageFlashArray",
            'NEXUSDEVICE': "NexusDevice",
            'ACISWITCH': "ACISwitch",
            'NEXUSSWITCH': "NexusSwitch",
            'MDSSWITCH': "MDSSwitch",
            'MDSDEVICE': "MDSDevice",
            'UCSC890': "UCSC890",
            'REDFISHSERVER': "RedfishServer",
            'NETAPPONTAP': "NetAppOntap",
            'NETAPPACTIVEIQUNIFIEDMANAGER': "NetAppActiveIqUnifiedManager",
            'EMCSCALEIO': "EmcScaleIo",
            'EMCVMAX': "EmcVmax",
            'EMCVPLEX': "EmcVplex",
            'EMCXTREMIO': "EmcXtremIo",
            'VMWAREVCENTER': "VmwareVcenter",
            'MICROSOFTHYPERV': "MicrosoftHyperV",
            'APPDYNAMICS': "AppDynamics",
            'DYNATRACE': "Dynatrace",
            'NEWRELIC': "NewRelic",
            'SERVICENOW': "ServiceNow",
            'READHATOPENSTACK': "ReadHatOpenStack",
            'CLOUDFOUNDRY': "CloudFoundry",
            'MICROSOFTAZUREAPPLICATIONINSIGHTS': "MicrosoftAzureApplicationInsights",
            'OPENSTACK': "OpenStack",
            'MICROSOFTSQLSERVER': "MicrosoftSqlServer",
            'MYSQLSERVER': "MySqlServer",
            'ORACLEDATABASESERVER': "OracleDatabaseServer",
            'IBMWEBSPHEREAPPLICATIONSERVER': "IBMWebSphereApplicationServer",
            'ORACLEWEBLOGICSERVER': "OracleWebLogicServer",
            'APACHETOMCATSERVER': "ApacheTomcatServer",
            'JAVAVIRTUALMACHINE': "JavaVirtualMachine",
            'REDHATJBOSSAPPLICATIONSERVER': "RedHatJBossApplicationServer",
            'KUBERNETES': "Kubernetes",
            'AMAZONWEBSERVICE': "AmazonWebService",
            'AMAZONWEBSERVICEBILLING': "AmazonWebServiceBilling",
            'GOOGLECLOUDPLATFORM': "GoogleCloudPlatform",
            'GOOGLECLOUDPLATFORMBILLING': "GoogleCloudPlatformBilling",
            'MICROSOFTAZURESERVICEPRINCIPAL': "MicrosoftAzureServicePrincipal",
            'MICROSOFTAZUREENTERPRISEAGREEMENT': "MicrosoftAzureEnterpriseAgreement",
            'MICROSOFTAZUREBILLING': "MicrosoftAzureBilling",
            'DELLCOMPELLENT': "DellCompellent",
            'HPE3PAR': "HPE3Par",
            'REDHATENTERPRISEVIRTUALIZATION': "RedHatEnterpriseVirtualization",
            'NUTANIXACROPOLIS': "NutanixAcropolis",
            'HPEONEVIEW': "HPEOneView",
            'SERVICEENGINE': "ServiceEngine",
            'HITACHIVIRTUALSTORAGEPLATFORM': "HitachiVirtualStoragePlatform",
            'IMCBLADE': "IMCBlade",
            'TERRAFORMCLOUD': "TerraformCloud",
            'TERRAFORMAGENT': "TerraformAgent",
            'CUSTOMTARGET': "CustomTarget",
            'ANSIBLEENDPOINT': "AnsibleEndpoint",
            'HTTPENDPOINT': "HTTPEndpoint",
            'SSHENDPOINT': "SSHEndpoint",
            'CISCOCATALYST': "CiscoCatalyst",
            'POWERSHELLENDPOINT': "PowerShellEndpoint",
        },
        ('object_type',): {
            'AAA.AUDITRECORD': "aaa.AuditRecord",
            'AAA.RETENTIONCONFIG': "aaa.RetentionConfig",
            'AAA.RETENTIONPOLICY': "aaa.RetentionPolicy",
            'ACCESS.POLICY': "access.Policy",
            'ACCESS.POLICYINVENTORY': "access.PolicyInventory",
            'ADAPTER.CONFIGPOLICY': "adapter.ConfigPolicy",
            'ADAPTER.EXTETHINTERFACE': "adapter.ExtEthInterface",
            'ADAPTER.HOSTETHINTERFACE': "adapter.HostEthInterface",
            'ADAPTER.HOSTFCINTERFACE': "adapter.HostFcInterface",
            'ADAPTER.HOSTISCSIINTERFACE': "adapter.HostIscsiInterface",
            'ADAPTER.UNIT': "adapter.Unit",
            'ADAPTER.UNITEXPANDER': "adapter.UnitExpander",
            'APPLIANCE.APPSTATUS': "appliance.AppStatus",
            'APPLIANCE.AUTORMAPOLICY': "appliance.AutoRmaPolicy",
            'APPLIANCE.BACKUP': "appliance.Backup",
            'APPLIANCE.BACKUPPOLICY': "appliance.BackupPolicy",
            'APPLIANCE.CERTIFICATESETTING': "appliance.CertificateSetting",
            'APPLIANCE.CLUSTERINFO': "appliance.ClusterInfo",
            'APPLIANCE.CLUSTERINSTALL': "appliance.ClusterInstall",
            'APPLIANCE.CLUSTERREPLACENODE': "appliance.ClusterReplaceNode",
            'APPLIANCE.DATAEXPORTPOLICY': "appliance.DataExportPolicy",
            'APPLIANCE.DEVICECERTIFICATE': "appliance.DeviceCertificate",
            'APPLIANCE.DEVICECLAIM': "appliance.DeviceClaim",
            'APPLIANCE.DEVICECLUSTERINSTALL': "appliance.DeviceClusterInstall",
            'APPLIANCE.DEVICEUPGRADEPOLICY': "appliance.DeviceUpgradePolicy",
            'APPLIANCE.DIAGSETTING': "appliance.DiagSetting",
            'APPLIANCE.EXTERNALSYSLOGSETTING': "appliance.ExternalSyslogSetting",
            'APPLIANCE.FILEGATEWAY': "appliance.FileGateway",
            'APPLIANCE.FILESYSTEMSTATUS': "appliance.FileSystemStatus",
            'APPLIANCE.GROUPSTATUS': "appliance.GroupStatus",
            'APPLIANCE.IMAGEBUNDLE': "appliance.ImageBundle",
            'APPLIANCE.METAMANIFEST': "appliance.MetaManifest",
            'APPLIANCE.NODEINFO': "appliance.NodeInfo",
            'APPLIANCE.NODESTATUS': "appliance.NodeStatus",
            'APPLIANCE.RELEASENOTE': "appliance.ReleaseNote",
            'APPLIANCE.REMOTEFILEIMPORT': "appliance.RemoteFileImport",
            'APPLIANCE.RESTORE': "appliance.Restore",
            'APPLIANCE.SETUPINFO': "appliance.SetupInfo",
            'APPLIANCE.SYSTEMINFO': "appliance.SystemInfo",
            'APPLIANCE.SYSTEMSTATUS': "appliance.SystemStatus",
            'APPLIANCE.UPGRADE': "appliance.Upgrade",
            'APPLIANCE.UPGRADEPOLICY': "appliance.UpgradePolicy",
            'ASSET.CLUSTERMEMBER': "asset.ClusterMember",
            'ASSET.DEPLOYMENT': "asset.Deployment",
            'ASSET.DEPLOYMENTDEVICE': "asset.DeploymentDevice",
            'ASSET.DEVICECLAIM': "asset.DeviceClaim",
            'ASSET.DEVICECONFIGURATION': "asset.DeviceConfiguration",
            'ASSET.DEVICECONNECTORMANAGER': "asset.DeviceConnectorManager",
            'ASSET.DEVICECONTRACTINFORMATION': "asset.DeviceContractInformation",
            'ASSET.DEVICECONTRACTNOTIFICATION': "asset.DeviceContractNotification",
            'ASSET.DEVICEREGISTRATION': "asset.DeviceRegistration",
            'ASSET.SUBSCRIPTION': "asset.Subscription",
            'ASSET.SUBSCRIPTIONACCOUNT': "asset.SubscriptionAccount",
            'ASSET.SUBSCRIPTIONDEVICECONTRACTINFORMATION': "asset.SubscriptionDeviceContractInformation",
            'ASSET.TARGET': "asset.Target",
            'BIOS.BOOTDEVICE': "bios.BootDevice",
            'BIOS.BOOTMODE': "bios.BootMode",
            'BIOS.POLICY': "bios.Policy",
            'BIOS.SYSTEMBOOTORDER': "bios.SystemBootOrder",
            'BIOS.TOKENSETTINGS': "bios.TokenSettings",
            'BIOS.UNIT': "bios.Unit",
            'BIOS.VFSELECTMEMORYRASCONFIGURATION': "bios.VfSelectMemoryRasConfiguration",
            'BOOT.CDDDEVICE': "boot.CddDevice",
            'BOOT.DEVICEBOOTMODE': "boot.DeviceBootMode",
            'BOOT.DEVICEBOOTSECURITY': "boot.DeviceBootSecurity",
            'BOOT.HDDDEVICE': "boot.HddDevice",
            'BOOT.ISCSIDEVICE': "boot.IscsiDevice",
            'BOOT.NVMEDEVICE': "boot.NvmeDevice",
            'BOOT.PCHSTORAGEDEVICE': "boot.PchStorageDevice",
            'BOOT.PRECISIONPOLICY': "boot.PrecisionPolicy",
            'BOOT.PXEDEVICE': "boot.PxeDevice",
            'BOOT.SANDEVICE': "boot.SanDevice",
            'BOOT.SDDEVICE': "boot.SdDevice",
            'BOOT.UEFISHELLDEVICE': "boot.UefiShellDevice",
            'BOOT.USBDEVICE': "boot.UsbDevice",
            'BOOT.VMEDIADEVICE': "boot.VmediaDevice",
            'BULK.EXPORT': "bulk.Export",
            'BULK.EXPORTEDITEM': "bulk.ExportedItem",
            'BULK.MOCLONER': "bulk.MoCloner",
            'BULK.MOMERGER': "bulk.MoMerger",
            'BULK.REQUEST': "bulk.Request",
            'BULK.SUBREQUESTOBJ': "bulk.SubRequestObj",
            'CAPABILITY.ACTIONSMETADATA': "capability.ActionsMetaData",
            'CAPABILITY.ADAPTERDEPRECATEDDEF': "capability.AdapterDeprecatedDef",
            'CAPABILITY.ADAPTERUNITDESCRIPTOR': "capability.AdapterUnitDescriptor",
            'CAPABILITY.CATALOG': "capability.Catalog",
            'CAPABILITY.CHASSISDESCRIPTOR': "capability.ChassisDescriptor",
            'CAPABILITY.CHASSISMANUFACTURINGDEF': "capability.ChassisManufacturingDef",
            'CAPABILITY.CIMCFIRMWAREDESCRIPTOR': "capability.CimcFirmwareDescriptor",
            'CAPABILITY.EQUIPMENTPHYSICALDEF': "capability.EquipmentPhysicalDef",
            'CAPABILITY.EQUIPMENTSLOTARRAY': "capability.EquipmentSlotArray",
            'CAPABILITY.FANMODULEDESCRIPTOR': "capability.FanModuleDescriptor",
            'CAPABILITY.FANMODULEMANUFACTURINGDEF': "capability.FanModuleManufacturingDef",
            'CAPABILITY.FEXCAPABILITYDEF': "capability.FexCapabilityDef",
            'CAPABILITY.FEXDESCRIPTOR': "capability.FexDescriptor",
            'CAPABILITY.FEXMANUFACTURINGDEF': "capability.FexManufacturingDef",
            'CAPABILITY.IOCARDCAPABILITYDEF': "capability.IoCardCapabilityDef",
            'CAPABILITY.IOCARDDESCRIPTOR': "capability.IoCardDescriptor",
            'CAPABILITY.IOCARDMANUFACTURINGDEF': "capability.IoCardManufacturingDef",
            'CAPABILITY.PORTGROUPAGGREGATIONDEF': "capability.PortGroupAggregationDef",
            'CAPABILITY.PSUDESCRIPTOR': "capability.PsuDescriptor",
            'CAPABILITY.PSUMANUFACTURINGDEF': "capability.PsuManufacturingDef",
            'CAPABILITY.SERVERDESCRIPTOR': "capability.ServerDescriptor",
            'CAPABILITY.SERVERMODELSCAPABILITYDEF': "capability.ServerModelsCapabilityDef",
            'CAPABILITY.SERVERSCHEMADESCRIPTOR': "capability.ServerSchemaDescriptor",
            'CAPABILITY.SIOCMODULECAPABILITYDEF': "capability.SiocModuleCapabilityDef",
            'CAPABILITY.SIOCMODULEDESCRIPTOR': "capability.SiocModuleDescriptor",
            'CAPABILITY.SIOCMODULEMANUFACTURINGDEF': "capability.SiocModuleManufacturingDef",
            'CAPABILITY.SWITCHCAPABILITY': "capability.SwitchCapability",
            'CAPABILITY.SWITCHDESCRIPTOR': "capability.SwitchDescriptor",
            'CAPABILITY.SWITCHMANUFACTURINGDEF': "capability.SwitchManufacturingDef",
            'CERTIFICATEMANAGEMENT.POLICY': "certificatemanagement.Policy",
            'CERTIFICATEMANAGEMENT.POLICYINVENTORY': "certificatemanagement.PolicyInventory",
            'CHASSIS.CONFIGCHANGEDETAIL': "chassis.ConfigChangeDetail",
            'CHASSIS.CONFIGIMPORT': "chassis.ConfigImport",
            'CHASSIS.CONFIGRESULT': "chassis.ConfigResult",
            'CHASSIS.CONFIGRESULTENTRY': "chassis.ConfigResultEntry",
            'CHASSIS.IOMPROFILE': "chassis.IomProfile",
            'CHASSIS.PROFILE': "chassis.Profile",
            'CLOUD.AWSBILLINGUNIT': "cloud.AwsBillingUnit",
            'CLOUD.AWSKEYPAIR': "cloud.AwsKeyPair",
            'CLOUD.AWSNETWORKINTERFACE': "cloud.AwsNetworkInterface",
            'CLOUD.AWSORGANIZATIONALUNIT': "cloud.AwsOrganizationalUnit",
            'CLOUD.AWSSECURITYGROUP': "cloud.AwsSecurityGroup",
            'CLOUD.AWSSUBNET': "cloud.AwsSubnet",
            'CLOUD.AWSVIRTUALMACHINE': "cloud.AwsVirtualMachine",
            'CLOUD.AWSVOLUME': "cloud.AwsVolume",
            'CLOUD.AWSVPC': "cloud.AwsVpc",
            'CLOUD.COLLECTINVENTORY': "cloud.CollectInventory",
            'CLOUD.REGIONS': "cloud.Regions",
            'CLOUD.SKUCONTAINERTYPE': "cloud.SkuContainerType",
            'CLOUD.SKUDATABASETYPE': "cloud.SkuDatabaseType",
            'CLOUD.SKUINSTANCETYPE': "cloud.SkuInstanceType",
            'CLOUD.SKUNETWORKTYPE': "cloud.SkuNetworkType",
            'CLOUD.SKUREGIONRATECARDS': "cloud.SkuRegionRateCards",
            'CLOUD.SKUVOLUMETYPE': "cloud.SkuVolumeType",
            'CLOUD.TFCAGENTPOOL': "cloud.TfcAgentpool",
            'CLOUD.TFCORGANIZATION': "cloud.TfcOrganization",
            'CLOUD.TFCWORKSPACE': "cloud.TfcWorkspace",
            'COMM.HTTPPROXYPOLICY': "comm.HttpProxyPolicy",
            'COMPUTE.BLADE': "compute.Blade",
            'COMPUTE.BLADEIDENTITY': "compute.BladeIdentity",
            'COMPUTE.BOARD': "compute.Board",
            'COMPUTE.MAPPING': "compute.Mapping",
            'COMPUTE.PERSONALITY': "compute.Personality",
            'COMPUTE.PHYSICALSUMMARY': "compute.PhysicalSummary",
            'COMPUTE.RACKUNIT': "compute.RackUnit",
            'COMPUTE.RACKUNITIDENTITY': "compute.RackUnitIdentity",
            'COMPUTE.SERVERIDPOOL': "compute.ServerIdPool",
            'COMPUTE.SERVERPOWERPOLICY': "compute.ServerPowerPolicy",
            'COMPUTE.SERVERSETTING': "compute.ServerSetting",
            'COMPUTE.VMEDIA': "compute.Vmedia",
            'COND.ALARM': "cond.Alarm",
            'COND.ALARMAGGREGATION': "cond.AlarmAggregation",
            'COND.ALARMDEFINITION': "cond.AlarmDefinition",
            'COND.HCLSTATUS': "cond.HclStatus",
            'COND.HCLSTATUSDETAIL': "cond.HclStatusDetail",
            'COND.HCLSTATUSJOB': "cond.HclStatusJob",
            'CONNECTORPACK.CONNECTORPACKUPGRADE': "connectorpack.ConnectorPackUpgrade",
            'CONNECTORPACK.UPGRADEIMPACT': "connectorpack.UpgradeImpact",
            'CONSOLE.CONSOLECONFIG': "console.ConsoleConfig",
            'CONVERGEDINFRA.ADAPTERCOMPLIANCEDETAILS': "convergedinfra.AdapterComplianceDetails",
            'CONVERGEDINFRA.POD': "convergedinfra.Pod",
            'CONVERGEDINFRA.PODCOMPLIANCEINFO': "convergedinfra.PodComplianceInfo",
            'CONVERGEDINFRA.SERVERCOMPLIANCEDETAILS': "convergedinfra.ServerComplianceDetails",
            'CONVERGEDINFRA.STORAGECOMPLIANCEDETAILS': "convergedinfra.StorageComplianceDetails",
            'CONVERGEDINFRA.SWITCHCOMPLIANCEDETAILS': "convergedinfra.SwitchComplianceDetails",
            'CRD.CUSTOMRESOURCE': "crd.CustomResource",
            'DEVICECONNECTOR.POLICY': "deviceconnector.Policy",
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
            'EQUIPMENT.CHASSISIDPOOL': "equipment.ChassisIdPool",
            'EQUIPMENT.CHASSISIDENTITY': "equipment.ChassisIdentity",
            'EQUIPMENT.CHASSISOPERATION': "equipment.ChassisOperation",
            'EQUIPMENT.DEVICESUMMARY': "equipment.DeviceSummary",
            'EQUIPMENT.EXPANDERMODULE': "equipment.ExpanderModule",
            'EQUIPMENT.FAN': "equipment.Fan",
            'EQUIPMENT.FANCONTROL': "equipment.FanControl",
            'EQUIPMENT.FANMODULE': "equipment.FanModule",
            'EQUIPMENT.FEX': "equipment.Fex",
            'EQUIPMENT.FEXIDENTITY': "equipment.FexIdentity",
            'EQUIPMENT.FEXOPERATION': "equipment.FexOperation",
            'EQUIPMENT.FRU': "equipment.Fru",
            'EQUIPMENT.IDENTITYSUMMARY': "equipment.IdentitySummary",
            'EQUIPMENT.IOCARD': "equipment.IoCard",
            'EQUIPMENT.IOCARDOPERATION': "equipment.IoCardOperation",
            'EQUIPMENT.IOEXPANDER': "equipment.IoExpander",
            'EQUIPMENT.LOCATORLED': "equipment.LocatorLed",
            'EQUIPMENT.PSU': "equipment.Psu",
            'EQUIPMENT.PSUCONTROL': "equipment.PsuControl",
            'EQUIPMENT.RACKENCLOSURE': "equipment.RackEnclosure",
            'EQUIPMENT.RACKENCLOSURESLOT': "equipment.RackEnclosureSlot",
            'EQUIPMENT.SENSOR': "equipment.Sensor",
            'EQUIPMENT.SHAREDIOMODULE': "equipment.SharedIoModule",
            'EQUIPMENT.SWITCHCARD': "equipment.SwitchCard",
            'EQUIPMENT.SYSTEMIOCONTROLLER': "equipment.SystemIoController",
            'EQUIPMENT.TPM': "equipment.Tpm",
            'EQUIPMENT.TRANSCEIVER': "equipment.Transceiver",
            'ETHER.HOSTPORT': "ether.HostPort",
            'ETHER.NETWORKPORT': "ether.NetworkPort",
            'ETHER.PHYSICALPORT': "ether.PhysicalPort",
            'ETHER.PORTCHANNEL': "ether.PortChannel",
            'EXTERNALSITE.AUTHORIZATION': "externalsite.Authorization",
            'FABRIC.APPLIANCEPCROLE': "fabric.AppliancePcRole",
            'FABRIC.APPLIANCEROLE': "fabric.ApplianceRole",
            'FABRIC.CONFIGCHANGEDETAIL': "fabric.ConfigChangeDetail",
            'FABRIC.CONFIGRESULT': "fabric.ConfigResult",
            'FABRIC.CONFIGRESULTENTRY': "fabric.ConfigResultEntry",
            'FABRIC.ELEMENTIDENTITY': "fabric.ElementIdentity",
            'FABRIC.ESTIMATEIMPACT': "fabric.EstimateImpact",
            'FABRIC.ETHNETWORKCONTROLPOLICY': "fabric.EthNetworkControlPolicy",
            'FABRIC.ETHNETWORKCONTROLPOLICYINVENTORY': "fabric.EthNetworkControlPolicyInventory",
            'FABRIC.ETHNETWORKGROUPPOLICY': "fabric.EthNetworkGroupPolicy",
            'FABRIC.ETHNETWORKGROUPPOLICYINVENTORY': "fabric.EthNetworkGroupPolicyInventory",
            'FABRIC.ETHNETWORKPOLICY': "fabric.EthNetworkPolicy",
            'FABRIC.FCNETWORKPOLICY': "fabric.FcNetworkPolicy",
            'FABRIC.FCSTORAGEROLE': "fabric.FcStorageRole",
            'FABRIC.FCUPLINKPCROLE': "fabric.FcUplinkPcRole",
            'FABRIC.FCUPLINKROLE': "fabric.FcUplinkRole",
            'FABRIC.FCZONEPOLICY': "fabric.FcZonePolicy",
            'FABRIC.FCOEUPLINKPCROLE': "fabric.FcoeUplinkPcRole",
            'FABRIC.FCOEUPLINKROLE': "fabric.FcoeUplinkRole",
            'FABRIC.FLOWCONTROLPOLICY': "fabric.FlowControlPolicy",
            'FABRIC.LANPINGROUP': "fabric.LanPinGroup",
            'FABRIC.LINKAGGREGATIONPOLICY': "fabric.LinkAggregationPolicy",
            'FABRIC.LINKCONTROLPOLICY': "fabric.LinkControlPolicy",
            'FABRIC.MULTICASTPOLICY': "fabric.MulticastPolicy",
            'FABRIC.PCMEMBER': "fabric.PcMember",
            'FABRIC.PCOPERATION': "fabric.PcOperation",
            'FABRIC.PORTMODE': "fabric.PortMode",
            'FABRIC.PORTOPERATION': "fabric.PortOperation",
            'FABRIC.PORTPOLICY': "fabric.PortPolicy",
            'FABRIC.SANPINGROUP': "fabric.SanPinGroup",
            'FABRIC.SERVERROLE': "fabric.ServerRole",
            'FABRIC.SWITCHCLUSTERPROFILE': "fabric.SwitchClusterProfile",
            'FABRIC.SWITCHCONTROLPOLICY': "fabric.SwitchControlPolicy",
            'FABRIC.SWITCHPROFILE': "fabric.SwitchProfile",
            'FABRIC.SYSTEMQOSPOLICY': "fabric.SystemQosPolicy",
            'FABRIC.UPLINKPCROLE': "fabric.UplinkPcRole",
            'FABRIC.UPLINKROLE': "fabric.UplinkRole",
            'FABRIC.VLAN': "fabric.Vlan",
            'FABRIC.VLANINVENTORY': "fabric.VlanInventory",
            'FABRIC.VLANSET': "fabric.VlanSet",
            'FABRIC.VSAN': "fabric.Vsan",
            'FABRIC.VSANINVENTORY': "fabric.VsanInventory",
            'FAULT.INSTANCE': "fault.Instance",
            'FC.NEIGHBOR': "fc.Neighbor",
            'FC.PHYSICALPORT': "fc.PhysicalPort",
            'FC.PORTCHANNEL': "fc.PortChannel",
            'FCPOOL.FCBLOCK': "fcpool.FcBlock",
            'FCPOOL.LEASE': "fcpool.Lease",
            'FCPOOL.POOL': "fcpool.Pool",
            'FCPOOL.POOLMEMBER': "fcpool.PoolMember",
            'FCPOOL.RESERVATION': "fcpool.Reservation",
            'FCPOOL.UNIVERSE': "fcpool.Universe",
            'FEEDBACK.FEEDBACKPOST': "feedback.FeedbackPost",
            'FIRMWARE.BIOSDESCRIPTOR': "firmware.BiosDescriptor",
            'FIRMWARE.BOARDCONTROLLERDESCRIPTOR': "firmware.BoardControllerDescriptor",
            'FIRMWARE.CHASSISUPGRADE': "firmware.ChassisUpgrade",
            'FIRMWARE.CIMCDESCRIPTOR': "firmware.CimcDescriptor",
            'FIRMWARE.DIMMDESCRIPTOR': "firmware.DimmDescriptor",
            'FIRMWARE.DISTRIBUTABLE': "firmware.Distributable",
            'FIRMWARE.DISTRIBUTABLEMETA': "firmware.DistributableMeta",
            'FIRMWARE.DRIVEDESCRIPTOR': "firmware.DriveDescriptor",
            'FIRMWARE.DRIVERDISTRIBUTABLE': "firmware.DriverDistributable",
            'FIRMWARE.EULA': "firmware.Eula",
            'FIRMWARE.FIRMWARESUMMARY': "firmware.FirmwareSummary",
            'FIRMWARE.GPUDESCRIPTOR': "firmware.GpuDescriptor",
            'FIRMWARE.HBADESCRIPTOR': "firmware.HbaDescriptor",
            'FIRMWARE.IOMDESCRIPTOR': "firmware.IomDescriptor",
            'FIRMWARE.MSWITCHDESCRIPTOR': "firmware.MswitchDescriptor",
            'FIRMWARE.NXOSDESCRIPTOR': "firmware.NxosDescriptor",
            'FIRMWARE.PCIEDESCRIPTOR': "firmware.PcieDescriptor",
            'FIRMWARE.PSUDESCRIPTOR': "firmware.PsuDescriptor",
            'FIRMWARE.RUNNINGFIRMWARE': "firmware.RunningFirmware",
            'FIRMWARE.SASEXPANDERDESCRIPTOR': "firmware.SasExpanderDescriptor",
            'FIRMWARE.SERVERCONFIGURATIONUTILITYDISTRIBUTABLE': "firmware.ServerConfigurationUtilityDistributable",
            'FIRMWARE.STORAGECONTROLLERDESCRIPTOR': "firmware.StorageControllerDescriptor",
            'FIRMWARE.SWITCHUPGRADE': "firmware.SwitchUpgrade",
            'FIRMWARE.UNSUPPORTEDVERSIONUPGRADE': "firmware.UnsupportedVersionUpgrade",
            'FIRMWARE.UPGRADE': "firmware.Upgrade",
            'FIRMWARE.UPGRADEIMPACT': "firmware.UpgradeImpact",
            'FIRMWARE.UPGRADEIMPACTSTATUS': "firmware.UpgradeImpactStatus",
            'FIRMWARE.UPGRADESTATUS': "firmware.UpgradeStatus",
            'FIRMWARE.UPGRADEVALIDITY': "firmware.UpgradeValidity",
            'FORECAST.CATALOG': "forecast.Catalog",
            'FORECAST.DEFINITION': "forecast.Definition",
            'FORECAST.INSTANCE': "forecast.Instance",
            'GRAPHICS.CARD': "graphics.Card",
            'GRAPHICS.CONTROLLER': "graphics.Controller",
            'HCL.COMPATIBILITYSTATUS': "hcl.CompatibilityStatus",
            'HCL.DRIVERIMAGE': "hcl.DriverImage",
            'HCL.EXEMPTEDCATALOG': "hcl.ExemptedCatalog",
            'HCL.HWCATALOGINFO': "hcl.HwCatalogInfo",
            'HCL.HYPERFLEXSOFTWARECOMPATIBILITYINFO': "hcl.HyperflexSoftwareCompatibilityInfo",
            'HCL.OPERATINGSYSTEM': "hcl.OperatingSystem",
            'HCL.OPERATINGSYSTEMVENDOR': "hcl.OperatingSystemVendor",
            'HCL.SERVERHWCATALOGINFO': "hcl.ServerHwCatalogInfo",
            'HCL.SUPPORTEDDRIVERNAME': "hcl.SupportedDriverName",
            'HYPERFLEX.ALARM': "hyperflex.Alarm",
            'HYPERFLEX.APPCATALOG': "hyperflex.AppCatalog",
            'HYPERFLEX.AUTOSUPPORTPOLICY': "hyperflex.AutoSupportPolicy",
            'HYPERFLEX.BACKUPCLUSTER': "hyperflex.BackupCluster",
            'HYPERFLEX.CAPABILITYINFO': "hyperflex.CapabilityInfo",
            'HYPERFLEX.CLUSTER': "hyperflex.Cluster",
            'HYPERFLEX.CLUSTERBACKUPPOLICY': "hyperflex.ClusterBackupPolicy",
            'HYPERFLEX.CLUSTERBACKUPPOLICYDEPLOYMENT': "hyperflex.ClusterBackupPolicyDeployment",
            'HYPERFLEX.CLUSTERBACKUPPOLICYINVENTORY': "hyperflex.ClusterBackupPolicyInventory",
            'HYPERFLEX.CLUSTERHEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.ClusterHealthCheckExecutionSnapshot",
            'HYPERFLEX.CLUSTERNETWORKPOLICY': "hyperflex.ClusterNetworkPolicy",
            'HYPERFLEX.CLUSTERPROFILE': "hyperflex.ClusterProfile",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICY': "hyperflex.ClusterReplicationNetworkPolicy",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICYDEPLOYMENT': "hyperflex.ClusterReplicationNetworkPolicyDeployment",
            'HYPERFLEX.CLUSTERSTORAGEPOLICY': "hyperflex.ClusterStoragePolicy",
            'HYPERFLEX.CONFIGRESULT': "hyperflex.ConfigResult",
            'HYPERFLEX.CONFIGRESULTENTRY': "hyperflex.ConfigResultEntry",
            'HYPERFLEX.DATAPROTECTIONPEER': "hyperflex.DataProtectionPeer",
            'HYPERFLEX.DATASTORESTATISTIC': "hyperflex.DatastoreStatistic",
            'HYPERFLEX.DEVICEPACKAGEDOWNLOADSTATE': "hyperflex.DevicePackageDownloadState",
            'HYPERFLEX.DRIVE': "hyperflex.Drive",
            'HYPERFLEX.ENCRYPTION': "hyperflex.Encryption",
            'HYPERFLEX.EXTFCSTORAGEPOLICY': "hyperflex.ExtFcStoragePolicy",
            'HYPERFLEX.EXTISCSISTORAGEPOLICY': "hyperflex.ExtIscsiStoragePolicy",
            'HYPERFLEX.FEATURELIMITEXTERNAL': "hyperflex.FeatureLimitExternal",
            'HYPERFLEX.FEATURELIMITINTERNAL': "hyperflex.FeatureLimitInternal",
            'HYPERFLEX.HEALTH': "hyperflex.Health",
            'HYPERFLEX.HEALTHCHECKDEFINITION': "hyperflex.HealthCheckDefinition",
            'HYPERFLEX.HEALTHCHECKEXECUTION': "hyperflex.HealthCheckExecution",
            'HYPERFLEX.HEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.HealthCheckExecutionSnapshot",
            'HYPERFLEX.HEALTHCHECKPACKAGECHECKSUM': "hyperflex.HealthCheckPackageChecksum",
            'HYPERFLEX.HWCATALOG': "hyperflex.HwCatalog",
            'HYPERFLEX.HXDPVERSION': "hyperflex.HxdpVersion",
            'HYPERFLEX.HYPERVISORHOST': "hyperflex.HypervisorHost",
            'HYPERFLEX.HYPERVISORVIRTUALMACHINE': "hyperflex.HypervisorVirtualMachine",
            'HYPERFLEX.INITIATORGROUP': "hyperflex.InitiatorGroup",
            'HYPERFLEX.ISCSINETWORK': "hyperflex.IscsiNetwork",
            'HYPERFLEX.KEYENCRYPTIONKEY': "hyperflex.KeyEncryptionKey",
            'HYPERFLEX.LICENSE': "hyperflex.License",
            'HYPERFLEX.LOCALCREDENTIALPOLICY': "hyperflex.LocalCredentialPolicy",
            'HYPERFLEX.LUN': "hyperflex.Lun",
            'HYPERFLEX.NODE': "hyperflex.Node",
            'HYPERFLEX.NODECONFIGPOLICY': "hyperflex.NodeConfigPolicy",
            'HYPERFLEX.NODEPROFILE': "hyperflex.NodeProfile",
            'HYPERFLEX.PROTECTEDCLUSTER': "hyperflex.ProtectedCluster",
            'HYPERFLEX.PROXYSETTINGPOLICY': "hyperflex.ProxySettingPolicy",
            'HYPERFLEX.SERVERFIRMWAREVERSION': "hyperflex.ServerFirmwareVersion",
            'HYPERFLEX.SERVERFIRMWAREVERSIONENTRY': "hyperflex.ServerFirmwareVersionEntry",
            'HYPERFLEX.SERVERMODEL': "hyperflex.ServerModel",
            'HYPERFLEX.SERVICEAUTHTOKEN': "hyperflex.ServiceAuthToken",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONCOMPONENT': "hyperflex.SoftwareDistributionComponent",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONENTRY': "hyperflex.SoftwareDistributionEntry",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONVERSION': "hyperflex.SoftwareDistributionVersion",
            'HYPERFLEX.SOFTWAREVERSIONPOLICY': "hyperflex.SoftwareVersionPolicy",
            'HYPERFLEX.STORAGECONTAINER': "hyperflex.StorageContainer",
            'HYPERFLEX.SYSCONFIGPOLICY': "hyperflex.SysConfigPolicy",
            'HYPERFLEX.TARGET': "hyperflex.Target",
            'HYPERFLEX.UCSMCONFIGPOLICY': "hyperflex.UcsmConfigPolicy",
            'HYPERFLEX.VCENTERCONFIGPOLICY': "hyperflex.VcenterConfigPolicy",
            'HYPERFLEX.VMBACKUPINFO': "hyperflex.VmBackupInfo",
            'HYPERFLEX.VMIMPORTOPERATION': "hyperflex.VmImportOperation",
            'HYPERFLEX.VMRESTOREOPERATION': "hyperflex.VmRestoreOperation",
            'HYPERFLEX.VMSNAPSHOTINFO': "hyperflex.VmSnapshotInfo",
            'HYPERFLEX.VOLUME': "hyperflex.Volume",
            'HYPERFLEX.WITNESSCONFIGURATION': "hyperflex.WitnessConfiguration",
            'IAAS.CONNECTORPACK': "iaas.ConnectorPack",
            'IAAS.CUSTOMTASKINFO': "iaas.CustomTaskInfo",
            'IAAS.DEVICESTATUS': "iaas.DeviceStatus",
            'IAAS.DIAGNOSTICMESSAGES': "iaas.DiagnosticMessages",
            'IAAS.LICENSEINFO': "iaas.LicenseInfo",
            'IAAS.MOSTRUNTASKS': "iaas.MostRunTasks",
            'IAAS.SERVICEREQUEST': "iaas.ServiceRequest",
            'IAAS.SYSTEMTASKINFO': "iaas.SystemTaskInfo",
            'IAAS.UCSDINFO': "iaas.UcsdInfo",
            'IAAS.UCSDMANAGEDINFRA': "iaas.UcsdManagedInfra",
            'IAAS.UCSDMESSAGES': "iaas.UcsdMessages",
            'IAM.ACCOUNT': "iam.Account",
            'IAM.ACCOUNTEXPERIENCE': "iam.AccountExperience",
            'IAM.APIKEY': "iam.ApiKey",
            'IAM.APPREGISTRATION': "iam.AppRegistration",
            'IAM.BANNERMESSAGE': "iam.BannerMessage",
            'IAM.CERTIFICATE': "iam.Certificate",
            'IAM.CERTIFICATEREQUEST': "iam.CertificateRequest",
            'IAM.DOMAINGROUP': "iam.DomainGroup",
            'IAM.DOMAINNAMEINFO': "iam.DomainNameInfo",
            'IAM.ENDPOINTPRIVILEGE': "iam.EndPointPrivilege",
            'IAM.ENDPOINTROLE': "iam.EndPointRole",
            'IAM.ENDPOINTUSER': "iam.EndPointUser",
            'IAM.ENDPOINTUSERINVENTORY': "iam.EndPointUserInventory",
            'IAM.ENDPOINTUSERPOLICY': "iam.EndPointUserPolicy",
            'IAM.ENDPOINTUSERPOLICYINVENTORY': "iam.EndPointUserPolicyInventory",
            'IAM.ENDPOINTUSERROLE': "iam.EndPointUserRole",
            'IAM.ENDPOINTUSERROLEINVENTORY': "iam.EndPointUserRoleInventory",
            'IAM.IDP': "iam.Idp",
            'IAM.IDPREFERENCE': "iam.IdpReference",
            'IAM.IPACCESSMANAGEMENT': "iam.IpAccessManagement",
            'IAM.IPADDRESS': "iam.IpAddress",
            'IAM.LDAPCONFIGPARAMS': "iam.LdapConfigParams",
            'IAM.LDAPGROUP': "iam.LdapGroup",
            'IAM.LDAPPOLICY': "iam.LdapPolicy",
            'IAM.LDAPPROVIDER': "iam.LdapProvider",
            'IAM.LOCALUSERPASSWORD': "iam.LocalUserPassword",
            'IAM.LOCALUSERPASSWORDPOLICY': "iam.LocalUserPasswordPolicy",
            'IAM.OAUTHTOKEN': "iam.OAuthToken",
            'IAM.PERMISSION': "iam.Permission",
            'IAM.PRIVATEKEYSPEC': "iam.PrivateKeySpec",
            'IAM.PRIVILEGE': "iam.Privilege",
            'IAM.PRIVILEGESET': "iam.PrivilegeSet",
            'IAM.QUALIFIER': "iam.Qualifier",
            'IAM.RESOURCELIMITS': "iam.ResourceLimits",
            'IAM.RESOURCEPERMISSION': "iam.ResourcePermission",
            'IAM.RESOURCEROLES': "iam.ResourceRoles",
            'IAM.ROLE': "iam.Role",
            'IAM.SECURITYHOLDER': "iam.SecurityHolder",
            'IAM.SERVICEPROVIDER': "iam.ServiceProvider",
            'IAM.SESSION': "iam.Session",
            'IAM.SESSIONLIMITS': "iam.SessionLimits",
            'IAM.SYSTEM': "iam.System",
            'IAM.TRUSTPOINT': "iam.TrustPoint",
            'IAM.USER': "iam.User",
            'IAM.USERGROUP': "iam.UserGroup",
            'IAM.USERPREFERENCE': "iam.UserPreference",
            'IAM.USERSETTING': "iam.UserSetting",
            'INVENTORY.DEVICEINFO': "inventory.DeviceInfo",
            'INVENTORY.DNMOBINDING': "inventory.DnMoBinding",
            'INVENTORY.GENERICINVENTORY': "inventory.GenericInventory",
            'INVENTORY.GENERICINVENTORYHOLDER': "inventory.GenericInventoryHolder",
            'INVENTORY.REQUEST': "inventory.Request",
            'IPMIOVERLAN.POLICY': "ipmioverlan.Policy",
            'IPMIOVERLAN.POLICYINVENTORY': "ipmioverlan.PolicyInventory",
            'IPPOOL.BLOCKLEASE': "ippool.BlockLease",
            'IPPOOL.IPLEASE': "ippool.IpLease",
            'IPPOOL.POOL': "ippool.Pool",
            'IPPOOL.POOLMEMBER': "ippool.PoolMember",
            'IPPOOL.RESERVATION': "ippool.Reservation",
            'IPPOOL.SHADOWBLOCK': "ippool.ShadowBlock",
            'IPPOOL.SHADOWPOOL': "ippool.ShadowPool",
            'IPPOOL.UNIVERSE': "ippool.Universe",
            'IQNPOOL.BLOCK': "iqnpool.Block",
            'IQNPOOL.LEASE': "iqnpool.Lease",
            'IQNPOOL.POOL': "iqnpool.Pool",
            'IQNPOOL.POOLMEMBER': "iqnpool.PoolMember",
            'IQNPOOL.RESERVATION': "iqnpool.Reservation",
            'IQNPOOL.UNIVERSE': "iqnpool.Universe",
            'IWOTENANT.MAINTENANCENOTIFICATION': "iwotenant.MaintenanceNotification",
            'IWOTENANT.TENANTSTATUS': "iwotenant.TenantStatus",
            'KUBERNETES.ACICNIAPIC': "kubernetes.AciCniApic",
            'KUBERNETES.ACICNIPROFILE': "kubernetes.AciCniProfile",
            'KUBERNETES.ACICNITENANTCLUSTERALLOCATION': "kubernetes.AciCniTenantClusterAllocation",
            'KUBERNETES.ADDONDEFINITION': "kubernetes.AddonDefinition",
            'KUBERNETES.ADDONPOLICY': "kubernetes.AddonPolicy",
            'KUBERNETES.ADDONREPOSITORY': "kubernetes.AddonRepository",
            'KUBERNETES.BAREMETALNODEPROFILE': "kubernetes.BaremetalNodeProfile",
            'KUBERNETES.CATALOG': "kubernetes.Catalog",
            'KUBERNETES.CLUSTER': "kubernetes.Cluster",
            'KUBERNETES.CLUSTERADDONPROFILE': "kubernetes.ClusterAddonProfile",
            'KUBERNETES.CLUSTERPROFILE': "kubernetes.ClusterProfile",
            'KUBERNETES.CONFIGRESULT': "kubernetes.ConfigResult",
            'KUBERNETES.CONFIGRESULTENTRY': "kubernetes.ConfigResultEntry",
            'KUBERNETES.CONTAINERRUNTIMEPOLICY': "kubernetes.ContainerRuntimePolicy",
            'KUBERNETES.DAEMONSET': "kubernetes.DaemonSet",
            'KUBERNETES.DEPLOYMENT': "kubernetes.Deployment",
            'KUBERNETES.HTTPPROXYPOLICY': "kubernetes.HttpProxyPolicy",
            'KUBERNETES.INGRESS': "kubernetes.Ingress",
            'KUBERNETES.NETWORKPOLICY': "kubernetes.NetworkPolicy",
            'KUBERNETES.NODE': "kubernetes.Node",
            'KUBERNETES.NODEGROUPPROFILE': "kubernetes.NodeGroupProfile",
            'KUBERNETES.NVIDIAGPUPRODUCT': "kubernetes.NvidiaGpuProduct",
            'KUBERNETES.POD': "kubernetes.Pod",
            'KUBERNETES.SERVICE': "kubernetes.Service",
            'KUBERNETES.STATEFULSET': "kubernetes.StatefulSet",
            'KUBERNETES.SYSCONFIGPOLICY': "kubernetes.SysConfigPolicy",
            'KUBERNETES.TRUSTEDREGISTRIESPOLICY': "kubernetes.TrustedRegistriesPolicy",
            'KUBERNETES.VERSION': "kubernetes.Version",
            'KUBERNETES.VERSIONPOLICY': "kubernetes.VersionPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRACONFIGPOLICY': "kubernetes.VirtualMachineInfraConfigPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRASTRUCTUREPROVIDER': "kubernetes.VirtualMachineInfrastructureProvider",
            'KUBERNETES.VIRTUALMACHINEINSTANCETYPE': "kubernetes.VirtualMachineInstanceType",
            'KUBERNETES.VIRTUALMACHINENODEPROFILE': "kubernetes.VirtualMachineNodeProfile",
            'KVM.POLICY': "kvm.Policy",
            'KVM.POLICYINVENTORY': "kvm.PolicyInventory",
            'KVM.SESSION': "kvm.Session",
            'KVM.TUNNEL': "kvm.Tunnel",
            'KVM.TUNNELEDKVMPOLICY': "kvm.TunneledKvmPolicy",
            'LICENSE.ACCOUNTLICENSEDATA': "license.AccountLicenseData",
            'LICENSE.CUSTOMEROP': "license.CustomerOp",
            'LICENSE.IKSCUSTOMEROP': "license.IksCustomerOp",
            'LICENSE.IKSLICENSECOUNT': "license.IksLicenseCount",
            'LICENSE.INCCUSTOMEROP': "license.IncCustomerOp",
            'LICENSE.INCLICENSECOUNT': "license.IncLicenseCount",
            'LICENSE.IWOCUSTOMEROP': "license.IwoCustomerOp",
            'LICENSE.IWOLICENSECOUNT': "license.IwoLicenseCount",
            'LICENSE.LICENSEINFO': "license.LicenseInfo",
            'LICENSE.LICENSEINFOVIEW': "license.LicenseInfoView",
            'LICENSE.LICENSEREGISTRATIONSTATUS': "license.LicenseRegistrationStatus",
            'LICENSE.LICENSERESERVATIONOP': "license.LicenseReservationOp",
            'LICENSE.SMARTLICENSETOKEN': "license.SmartlicenseToken",
            'LS.SERVICEPROFILE': "ls.ServiceProfile",
            'MACPOOL.IDBLOCK': "macpool.IdBlock",
            'MACPOOL.LEASE': "macpool.Lease",
            'MACPOOL.POOL': "macpool.Pool",
            'MACPOOL.POOLMEMBER': "macpool.PoolMember",
            'MACPOOL.RESERVATION': "macpool.Reservation",
            'MACPOOL.UNIVERSE': "macpool.Universe",
            'MANAGEMENT.CONTROLLER': "management.Controller",
            'MANAGEMENT.ENTITY': "management.Entity",
            'MANAGEMENT.INTERFACE': "management.Interface",
            'MEMORY.ARRAY': "memory.Array",
            'MEMORY.PERSISTENTMEMORYCONFIGRESULT': "memory.PersistentMemoryConfigResult",
            'MEMORY.PERSISTENTMEMORYCONFIGURATION': "memory.PersistentMemoryConfiguration",
            'MEMORY.PERSISTENTMEMORYNAMESPACE': "memory.PersistentMemoryNamespace",
            'MEMORY.PERSISTENTMEMORYNAMESPACECONFIGRESULT': "memory.PersistentMemoryNamespaceConfigResult",
            'MEMORY.PERSISTENTMEMORYPOLICY': "memory.PersistentMemoryPolicy",
            'MEMORY.PERSISTENTMEMORYREGION': "memory.PersistentMemoryRegion",
            'MEMORY.PERSISTENTMEMORYUNIT': "memory.PersistentMemoryUnit",
            'MEMORY.UNIT': "memory.Unit",
            'META.DEFINITION': "meta.Definition",
            'MONITORING.HEALTHSTATUS': "monitoring.HealthStatus",
            'NETWORK.DISCOVEREDNEIGHBOR': "network.DiscoveredNeighbor",
            'NETWORK.DNS': "network.Dns",
            'NETWORK.ELEMENT': "network.Element",
            'NETWORK.ELEMENTSUMMARY': "network.ElementSummary",
            'NETWORK.FCZONEINFO': "network.FcZoneInfo",
            'NETWORK.FEATURECONTROL': "network.FeatureControl",
            'NETWORK.INTERFACELIST': "network.InterfaceList",
            'NETWORK.LICENSEFILE': "network.LicenseFile",
            'NETWORK.SUPERVISORCARD': "network.SupervisorCard",
            'NETWORK.TELEMETRYCHECK': "network.TelemetryCheck",
            'NETWORK.VLANPORTINFO': "network.VlanPortInfo",
            'NETWORK.VPCDOMAIN': "network.VpcDomain",
            'NETWORK.VPCMEMBER': "network.VpcMember",
            'NETWORK.VPCPEER': "network.VpcPeer",
            'NETWORK.VRF': "network.Vrf",
            'NETWORKCONFIG.POLICY': "networkconfig.Policy",
            'NETWORKCONFIG.POLICYINVENTORY': "networkconfig.PolicyInventory",
            'NIAAPI.APICCCOPOST': "niaapi.ApicCcoPost",
            'NIAAPI.APICFIELDNOTICE': "niaapi.ApicFieldNotice",
            'NIAAPI.APICHWEOL': "niaapi.ApicHweol",
            'NIAAPI.APICLATESTMAINTAINEDRELEASE': "niaapi.ApicLatestMaintainedRelease",
            'NIAAPI.APICRELEASERECOMMEND': "niaapi.ApicReleaseRecommend",
            'NIAAPI.APICSWEOL': "niaapi.ApicSweol",
            'NIAAPI.DCNMCCOPOST': "niaapi.DcnmCcoPost",
            'NIAAPI.DCNMFIELDNOTICE': "niaapi.DcnmFieldNotice",
            'NIAAPI.DCNMHWEOL': "niaapi.DcnmHweol",
            'NIAAPI.DCNMLATESTMAINTAINEDRELEASE': "niaapi.DcnmLatestMaintainedRelease",
            'NIAAPI.DCNMRELEASERECOMMEND': "niaapi.DcnmReleaseRecommend",
            'NIAAPI.DCNMSWEOL': "niaapi.DcnmSweol",
            'NIAAPI.FILEDOWNLOADER': "niaapi.FileDownloader",
            'NIAAPI.NIAMETADATA': "niaapi.NiaMetadata",
            'NIAAPI.NIBFILEDOWNLOADER': "niaapi.NibFileDownloader",
            'NIAAPI.NIBMETADATA': "niaapi.NibMetadata",
            'NIAAPI.PUVSCRIPTDOWNLOADER': "niaapi.PuvScriptDownloader",
            'NIAAPI.UPGRADEASSISTFILE': "niaapi.UpgradeAssistFile",
            'NIAAPI.VERSIONREGEX': "niaapi.VersionRegex",
            'NIATELEMETRY.AAALDAPPROVIDERDETAILS': "niatelemetry.AaaLdapProviderDetails",
            'NIATELEMETRY.AAARADIUSPROVIDERDETAILS': "niatelemetry.AaaRadiusProviderDetails",
            'NIATELEMETRY.AAATACACSPROVIDERDETAILS': "niatelemetry.AaaTacacsProviderDetails",
            'NIATELEMETRY.APICAPPPLUGINDETAILS': "niatelemetry.ApicAppPluginDetails",
            'NIATELEMETRY.APICCOREFILEDETAILS': "niatelemetry.ApicCoreFileDetails",
            'NIATELEMETRY.APICDBGEXPRSEXPORTDEST': "niatelemetry.ApicDbgexpRsExportDest",
            'NIATELEMETRY.APICDBGEXPRSTSSCHEDULER': "niatelemetry.ApicDbgexpRsTsScheduler",
            'NIATELEMETRY.APICFANDETAILS': "niatelemetry.ApicFanDetails",
            'NIATELEMETRY.APICFEXDETAILS': "niatelemetry.ApicFexDetails",
            'NIATELEMETRY.APICFLASHDETAILS': "niatelemetry.ApicFlashDetails",
            'NIATELEMETRY.APICNTPAUTH': "niatelemetry.ApicNtpAuth",
            'NIATELEMETRY.APICPERFORMANCEDATA': "niatelemetry.ApicPerformanceData",
            'NIATELEMETRY.APICPODDATA': "niatelemetry.ApicPodData",
            'NIATELEMETRY.APICPSUDETAILS': "niatelemetry.ApicPsuDetails",
            'NIATELEMETRY.APICREALMDETAILS': "niatelemetry.ApicRealmDetails",
            'NIATELEMETRY.APICSNMPCLIENTGRPDETAILS': "niatelemetry.ApicSnmpClientGrpDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYACCESSDETAILS': "niatelemetry.ApicSnmpCommunityAccessDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYDETAILS': "niatelemetry.ApicSnmpCommunityDetails",
            'NIATELEMETRY.APICSNMPTRAPDETAILS': "niatelemetry.ApicSnmpTrapDetails",
            'NIATELEMETRY.APICSNMPTRAPFWDSERVERDETAILS': "niatelemetry.ApicSnmpTrapFwdServerDetails",
            'NIATELEMETRY.APICSNMPVERSIONTHREEDETAILS': "niatelemetry.ApicSnmpVersionThreeDetails",
            'NIATELEMETRY.APICSYSLOGGRP': "niatelemetry.ApicSysLogGrp",
            'NIATELEMETRY.APICSYSLOGSRC': "niatelemetry.ApicSysLogSrc",
            'NIATELEMETRY.APICTRANSCEIVERDETAILS': "niatelemetry.ApicTransceiverDetails",
            'NIATELEMETRY.APICUIPAGECOUNTS': "niatelemetry.ApicUiPageCounts",
            'NIATELEMETRY.APPDETAILS': "niatelemetry.AppDetails",
            'NIATELEMETRY.CLOUDDETAILS': "niatelemetry.CloudDetails",
            'NIATELEMETRY.COMMONPOLICIES': "niatelemetry.CommonPolicies",
            'NIATELEMETRY.DCNMFANDETAILS': "niatelemetry.DcnmFanDetails",
            'NIATELEMETRY.DCNMFEXDETAILS': "niatelemetry.DcnmFexDetails",
            'NIATELEMETRY.DCNMMODULEDETAILS': "niatelemetry.DcnmModuleDetails",
            'NIATELEMETRY.DCNMPSUDETAILS': "niatelemetry.DcnmPsuDetails",
            'NIATELEMETRY.DCNMTRANSCEIVERDETAILS': "niatelemetry.DcnmTransceiverDetails",
            'NIATELEMETRY.EPG': "niatelemetry.Epg",
            'NIATELEMETRY.FABRICMODULEDETAILS': "niatelemetry.FabricModuleDetails",
            'NIATELEMETRY.FABRICNODECONTROLDETAILS': "niatelemetry.FabricNodeControlDetails",
            'NIATELEMETRY.FABRICPODPROFILE': "niatelemetry.FabricPodProfile",
            'NIATELEMETRY.FABRICPODSS': "niatelemetry.FabricPodSs",
            'NIATELEMETRY.FAULT': "niatelemetry.Fault",
            'NIATELEMETRY.HCLOUDDETAILS': "niatelemetry.HcloudDetails",
            'NIATELEMETRY.HEALTHINSIGHTSDATA': "niatelemetry.HealthInsightsData",
            'NIATELEMETRY.HTTPSACLCONTRACTDETAILS': "niatelemetry.HttpsAclContractDetails",
            'NIATELEMETRY.HTTPSACLCONTRACTFILTERMAP': "niatelemetry.HttpsAclContractFilterMap",
            'NIATELEMETRY.HTTPSACLEPGCONTRACTMAP': "niatelemetry.HttpsAclEpgContractMap",
            'NIATELEMETRY.HTTPSACLEPGDETAILS': "niatelemetry.HttpsAclEpgDetails",
            'NIATELEMETRY.HTTPSACLFILTERDETAILS': "niatelemetry.HttpsAclFilterDetails",
            'NIATELEMETRY.INSIGHTGROUPDETAILS': "niatelemetry.InsightGroupDetails",
            'NIATELEMETRY.LC': "niatelemetry.Lc",
            'NIATELEMETRY.LEAFPOLGRPDETAILS': "niatelemetry.LeafPolGrpDetails",
            'NIATELEMETRY.MDSAUTOCLAIM': "niatelemetry.MdsAutoClaim",
            'NIATELEMETRY.MSOCONTRACTDETAILS': "niatelemetry.MsoContractDetails",
            'NIATELEMETRY.MSOEPGDETAILS': "niatelemetry.MsoEpgDetails",
            'NIATELEMETRY.MSOSCHEMADETAILS': "niatelemetry.MsoSchemaDetails",
            'NIATELEMETRY.MSOSITEDETAILS': "niatelemetry.MsoSiteDetails",
            'NIATELEMETRY.MSOTENANTDETAILS': "niatelemetry.MsoTenantDetails",
            'NIATELEMETRY.NEXUSCLOUDACCOUNT': "niatelemetry.NexusCloudAccount",
            'NIATELEMETRY.NEXUSCLOUDSITE': "niatelemetry.NexusCloudSite",
            'NIATELEMETRY.NEXUSDASHBOARDCONTROLLERDETAILS': "niatelemetry.NexusDashboardControllerDetails",
            'NIATELEMETRY.NEXUSDASHBOARDDETAILS': "niatelemetry.NexusDashboardDetails",
            'NIATELEMETRY.NEXUSDASHBOARDMEMORYDETAILS': "niatelemetry.NexusDashboardMemoryDetails",
            'NIATELEMETRY.NEXUSDASHBOARDS': "niatelemetry.NexusDashboards",
            'NIATELEMETRY.NIAFEATUREUSAGE': "niatelemetry.NiaFeatureUsage",
            'NIATELEMETRY.NIAINVENTORY': "niatelemetry.NiaInventory",
            'NIATELEMETRY.NIAINVENTORYDCNM': "niatelemetry.NiaInventoryDcnm",
            'NIATELEMETRY.NIAINVENTORYFABRIC': "niatelemetry.NiaInventoryFabric",
            'NIATELEMETRY.NIALICENSESTATE': "niatelemetry.NiaLicenseState",
            'NIATELEMETRY.PASSWORDSTRENGTHCHECK': "niatelemetry.PasswordStrengthCheck",
            'NIATELEMETRY.PODCOMMPOLICIES': "niatelemetry.PodCommPolicies",
            'NIATELEMETRY.PODSNMPPOLICIES': "niatelemetry.PodSnmpPolicies",
            'NIATELEMETRY.PODTIMESERVERPOLICIES': "niatelemetry.PodTimeServerPolicies",
            'NIATELEMETRY.SITEINVENTORY': "niatelemetry.SiteInventory",
            'NIATELEMETRY.SNMPSRC': "niatelemetry.SnmpSrc",
            'NIATELEMETRY.SPINEPOLGRPDETAILS': "niatelemetry.SpinePolGrpDetails",
            'NIATELEMETRY.SSHVERSIONTWO': "niatelemetry.SshVersionTwo",
            'NIATELEMETRY.SUPERVISORMODULEDETAILS': "niatelemetry.SupervisorModuleDetails",
            'NIATELEMETRY.SYSLOGREMOTEDEST': "niatelemetry.SyslogRemoteDest",
            'NIATELEMETRY.SYSLOGSYSMSG': "niatelemetry.SyslogSysMsg",
            'NIATELEMETRY.SYSLOGSYSMSGFACFILTER': "niatelemetry.SyslogSysMsgFacFilter",
            'NIATELEMETRY.SYSTEMCONTROLLERDETAILS': "niatelemetry.SystemControllerDetails",
            'NIATELEMETRY.TENANT': "niatelemetry.Tenant",
            'NOTIFICATION.ACCOUNTSUBSCRIPTION': "notification.AccountSubscription",
            'NTP.NTPSERVER': "ntp.NtpServer",
            'NTP.POLICY': "ntp.Policy",
            'OAUTH.ACCESSTOKEN': "oauth.AccessToken",
            'OAUTH.AUTHORIZATION': "oauth.Authorization",
            'OPRS.DEPLOYMENT': "oprs.Deployment",
            'OPRS.SYNCTARGETLISTMESSAGE': "oprs.SyncTargetListMessage",
            'ORGANIZATION.ORGANIZATION': "organization.Organization",
            'OS.BULKINSTALLINFO': "os.BulkInstallInfo",
            'OS.CATALOG': "os.Catalog",
            'OS.CONFIGURATIONFILE': "os.ConfigurationFile",
            'OS.DISTRIBUTION': "os.Distribution",
            'OS.INSTALL': "os.Install",
            'OS.OSSUPPORT': "os.OsSupport",
            'OS.SUPPORTEDVERSION': "os.SupportedVersion",
            'OS.TEMPLATEFILE': "os.TemplateFile",
            'OS.VALIDINSTALLTARGET': "os.ValidInstallTarget",
            'PCI.COPROCESSORCARD': "pci.CoprocessorCard",
            'PCI.DEVICE': "pci.Device",
            'PCI.LINK': "pci.Link",
            'PCI.NODE': "pci.Node",
            'PCI.SWITCH': "pci.Switch",
            'PORT.GROUP': "port.Group",
            'PORT.MACBINDING': "port.MacBinding",
            'PORT.SUBGROUP': "port.SubGroup",
            'POWER.CONTROLSTATE': "power.ControlState",
            'POWER.POLICY': "power.Policy",
            'POWER.POLICYINVENTORY': "power.PolicyInventory",
            'PROCESSOR.UNIT': "processor.Unit",
            'RACK.UNITPERSONALITY': "rack.UnitPersonality",
            'RECOMMENDATION.CAPACITYRUNWAY': "recommendation.CapacityRunway",
            'RECOMMENDATION.CLUSTEREXPANSION': "recommendation.ClusterExpansion",
            'RECOMMENDATION.HARDWAREEXPANSIONREQUEST': "recommendation.HardwareExpansionRequest",
            'RECOMMENDATION.HARDWAREEXPANSIONREQUESTITEM': "recommendation.HardwareExpansionRequestItem",
            'RECOMMENDATION.PHYSICALITEM': "recommendation.PhysicalItem",
            'RECOMMENDATION.PURCHASEORDERESTIMATE': "recommendation.PurchaseOrderEstimate",
            'RECOMMENDATION.SOFTWAREITEM': "recommendation.SoftwareItem",
            'RECOVERY.BACKUPCONFIGPOLICY': "recovery.BackupConfigPolicy",
            'RECOVERY.BACKUPPROFILE': "recovery.BackupProfile",
            'RECOVERY.CONFIGRESULT': "recovery.ConfigResult",
            'RECOVERY.CONFIGRESULTENTRY': "recovery.ConfigResultEntry",
            'RECOVERY.ONDEMANDBACKUP': "recovery.OnDemandBackup",
            'RECOVERY.RESTORE': "recovery.Restore",
            'RECOVERY.SCHEDULECONFIGPOLICY': "recovery.ScheduleConfigPolicy",
            'RESOURCE.GROUP': "resource.Group",
            'RESOURCE.GROUPMEMBER': "resource.GroupMember",
            'RESOURCE.LICENSERESOURCECOUNT': "resource.LicenseResourceCount",
            'RESOURCE.MEMBERSHIP': "resource.Membership",
            'RESOURCE.MEMBERSHIPHOLDER': "resource.MembershipHolder",
            'RESOURCE.RESERVATION': "resource.Reservation",
            'RESOURCEPOOL.LEASE': "resourcepool.Lease",
            'RESOURCEPOOL.LEASERESOURCE': "resourcepool.LeaseResource",
            'RESOURCEPOOL.POOL': "resourcepool.Pool",
            'RESOURCEPOOL.POOLMEMBER': "resourcepool.PoolMember",
            'RESOURCEPOOL.UNIVERSE': "resourcepool.Universe",
            'RPROXY.REVERSEPROXY': "rproxy.ReverseProxy",
            'SDCARD.POLICY': "sdcard.Policy",
            'SDCARD.POLICYINVENTORY': "sdcard.PolicyInventory",
            'SEARCH.SEARCHITEM': "search.SearchItem",
            'SEARCH.TAGITEM': "search.TagItem",
            'SECURITY.UNIT': "security.Unit",
            'SERVER.CONFIGCHANGEDETAIL': "server.ConfigChangeDetail",
            'SERVER.CONFIGIMPORT': "server.ConfigImport",
            'SERVER.CONFIGRESULT': "server.ConfigResult",
            'SERVER.CONFIGRESULTENTRY': "server.ConfigResultEntry",
            'SERVER.PROFILE': "server.Profile",
            'SERVER.PROFILETEMPLATE': "server.ProfileTemplate",
            'SMTP.POLICY': "smtp.Policy",
            'SNMP.POLICY': "snmp.Policy",
            'SNMP.POLICYINVENTORY': "snmp.PolicyInventory",
            'SOFTWARE.APPLIANCEDISTRIBUTABLE': "software.ApplianceDistributable",
            'SOFTWARE.DOWNLOADHISTORY': "software.DownloadHistory",
            'SOFTWARE.HCLMETA': "software.HclMeta",
            'SOFTWARE.HYPERFLEXBUNDLEDISTRIBUTABLE': "software.HyperflexBundleDistributable",
            'SOFTWARE.HYPERFLEXDISTRIBUTABLE': "software.HyperflexDistributable",
            'SOFTWARE.IKSBUNDLEDISTRIBUTABLE': "software.IksBundleDistributable",
            'SOFTWARE.RELEASEMETA': "software.ReleaseMeta",
            'SOFTWARE.SOLUTIONDISTRIBUTABLE': "software.SolutionDistributable",
            'SOFTWARE.UCSDBUNDLEDISTRIBUTABLE': "software.UcsdBundleDistributable",
            'SOFTWARE.UCSDDISTRIBUTABLE': "software.UcsdDistributable",
            'SOFTWAREREPOSITORY.AUTHORIZATION': "softwarerepository.Authorization",
            'SOFTWAREREPOSITORY.CACHEDIMAGE': "softwarerepository.CachedImage",
            'SOFTWAREREPOSITORY.CATALOG': "softwarerepository.Catalog",
            'SOFTWAREREPOSITORY.CATEGORYMAPPER': "softwarerepository.CategoryMapper",
            'SOFTWAREREPOSITORY.CATEGORYMAPPERMODEL': "softwarerepository.CategoryMapperModel",
            'SOFTWAREREPOSITORY.CATEGORYSUPPORTCONSTRAINT': "softwarerepository.CategorySupportConstraint",
            'SOFTWAREREPOSITORY.DOWNLOADSPEC': "softwarerepository.DownloadSpec",
            'SOFTWAREREPOSITORY.OPERATINGSYSTEMFILE': "softwarerepository.OperatingSystemFile",
            'SOFTWAREREPOSITORY.RELEASE': "softwarerepository.Release",
            'SOL.POLICY': "sol.Policy",
            'SOL.POLICYINVENTORY': "sol.PolicyInventory",
            'SSH.POLICY': "ssh.Policy",
            'SSH.POLICYINVENTORY': "ssh.PolicyInventory",
            'STORAGE.BATTERYBACKUPUNIT': "storage.BatteryBackupUnit",
            'STORAGE.CONTROLLER': "storage.Controller",
            'STORAGE.DISKGROUP': "storage.DiskGroup",
            'STORAGE.DISKSLOT': "storage.DiskSlot",
            'STORAGE.DRIVEGROUP': "storage.DriveGroup",
            'STORAGE.ENCLOSURE': "storage.Enclosure",
            'STORAGE.ENCLOSUREDISK': "storage.EnclosureDisk",
            'STORAGE.ENCLOSUREDISKSLOTEP': "storage.EnclosureDiskSlotEp",
            'STORAGE.FLEXFLASHCONTROLLER': "storage.FlexFlashController",
            'STORAGE.FLEXFLASHCONTROLLERPROPS': "storage.FlexFlashControllerProps",
            'STORAGE.FLEXFLASHPHYSICALDRIVE': "storage.FlexFlashPhysicalDrive",
            'STORAGE.FLEXFLASHVIRTUALDRIVE': "storage.FlexFlashVirtualDrive",
            'STORAGE.FLEXUTILCONTROLLER': "storage.FlexUtilController",
            'STORAGE.FLEXUTILPHYSICALDRIVE': "storage.FlexUtilPhysicalDrive",
            'STORAGE.FLEXUTILVIRTUALDRIVE': "storage.FlexUtilVirtualDrive",
            'STORAGE.HITACHIARRAY': "storage.HitachiArray",
            'STORAGE.HITACHICONTROLLER': "storage.HitachiController",
            'STORAGE.HITACHIDISK': "storage.HitachiDisk",
            'STORAGE.HITACHIHOST': "storage.HitachiHost",
            'STORAGE.HITACHIHOSTLUN': "storage.HitachiHostLun",
            'STORAGE.HITACHIPARITYGROUP': "storage.HitachiParityGroup",
            'STORAGE.HITACHIPOOL': "storage.HitachiPool",
            'STORAGE.HITACHIPORT': "storage.HitachiPort",
            'STORAGE.HITACHIREMOTEREPLICATION': "storage.HitachiRemoteReplication",
            'STORAGE.HITACHISNAPSHOT': "storage.HitachiSnapshot",
            'STORAGE.HITACHIVOLUME': "storage.HitachiVolume",
            'STORAGE.HYPERFLEXSTORAGECONTAINER': "storage.HyperFlexStorageContainer",
            'STORAGE.HYPERFLEXVOLUME': "storage.HyperFlexVolume",
            'STORAGE.ITEM': "storage.Item",
            'STORAGE.NETAPPAGGREGATE': "storage.NetAppAggregate",
            'STORAGE.NETAPPAGGREGATEEVENT': "storage.NetAppAggregateEvent",
            'STORAGE.NETAPPBASEDISK': "storage.NetAppBaseDisk",
            'STORAGE.NETAPPCIFSSERVICE': "storage.NetAppCifsService",
            'STORAGE.NETAPPCIFSSHARE': "storage.NetAppCifsShare",
            'STORAGE.NETAPPCLUSTER': "storage.NetAppCluster",
            'STORAGE.NETAPPCLUSTEREVENT': "storage.NetAppClusterEvent",
            'STORAGE.NETAPPCLUSTERSNAPMIRRORPOLICY': "storage.NetAppClusterSnapMirrorPolicy",
            'STORAGE.NETAPPDATAIPINTERFACE': "storage.NetAppDataIpInterface",
            'STORAGE.NETAPPDATAIPINTERFACEEVENT': "storage.NetAppDataIpInterfaceEvent",
            'STORAGE.NETAPPDISKEVENT': "storage.NetAppDiskEvent",
            'STORAGE.NETAPPETHERNETPORT': "storage.NetAppEthernetPort",
            'STORAGE.NETAPPETHERNETPORTEVENT': "storage.NetAppEthernetPortEvent",
            'STORAGE.NETAPPEXPORTPOLICY': "storage.NetAppExportPolicy",
            'STORAGE.NETAPPFCINTERFACE': "storage.NetAppFcInterface",
            'STORAGE.NETAPPFCINTERFACEEVENT': "storage.NetAppFcInterfaceEvent",
            'STORAGE.NETAPPFCPORT': "storage.NetAppFcPort",
            'STORAGE.NETAPPFCPORTEVENT': "storage.NetAppFcPortEvent",
            'STORAGE.NETAPPINITIATORGROUP': "storage.NetAppInitiatorGroup",
            'STORAGE.NETAPPIPINTERFACE': "storage.NetAppIpInterface",
            'STORAGE.NETAPPIPINTERFACEEVENT': "storage.NetAppIpInterfaceEvent",
            'STORAGE.NETAPPISCSISERVICE': "storage.NetAppIscsiService",
            'STORAGE.NETAPPLICENSE': "storage.NetAppLicense",
            'STORAGE.NETAPPLUN': "storage.NetAppLun",
            'STORAGE.NETAPPLUNEVENT': "storage.NetAppLunEvent",
            'STORAGE.NETAPPLUNMAP': "storage.NetAppLunMap",
            'STORAGE.NETAPPNFSSERVICE': "storage.NetAppNfsService",
            'STORAGE.NETAPPNODE': "storage.NetAppNode",
            'STORAGE.NETAPPNODECDPNEIGHBOR': "storage.NetAppNodeCdpNeighbor",
            'STORAGE.NETAPPNODEEVENT': "storage.NetAppNodeEvent",
            'STORAGE.NETAPPNONDATAIPINTERFACE': "storage.NetAppNonDataIpInterface",
            'STORAGE.NETAPPNONDATAIPINTERFACEEVENT': "storage.NetAppNonDataIpInterfaceEvent",
            'STORAGE.NETAPPNTPSERVER': "storage.NetAppNtpServer",
            'STORAGE.NETAPPQTREE': "storage.NetAppQtree",
            'STORAGE.NETAPPSCHEDULE': "storage.NetAppSchedule",
            'STORAGE.NETAPPSENSOR': "storage.NetAppSensor",
            'STORAGE.NETAPPSTORAGEVM': "storage.NetAppStorageVm",
            'STORAGE.NETAPPSVMEVENT': "storage.NetAppSvmEvent",
            'STORAGE.NETAPPSVMSNAPMIRRORPOLICY': "storage.NetAppSvmSnapMirrorPolicy",
            'STORAGE.NETAPPVOLUME': "storage.NetAppVolume",
            'STORAGE.NETAPPVOLUMEEVENT': "storage.NetAppVolumeEvent",
            'STORAGE.NETAPPVOLUMESNAPSHOT': "storage.NetAppVolumeSnapshot",
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
            'STORAGE.PHYSICALDISKEXTENSION': "storage.PhysicalDiskExtension",
            'STORAGE.PHYSICALDISKUSAGE': "storage.PhysicalDiskUsage",
            'STORAGE.PUREARRAY': "storage.PureArray",
            'STORAGE.PURECONTROLLER': "storage.PureController",
            'STORAGE.PUREDISK': "storage.PureDisk",
            'STORAGE.PUREHOST': "storage.PureHost",
            'STORAGE.PUREHOSTGROUP': "storage.PureHostGroup",
            'STORAGE.PUREHOSTLUN': "storage.PureHostLun",
            'STORAGE.PUREPORT': "storage.PurePort",
            'STORAGE.PUREPROTECTIONGROUP': "storage.PureProtectionGroup",
            'STORAGE.PUREPROTECTIONGROUPSNAPSHOT': "storage.PureProtectionGroupSnapshot",
            'STORAGE.PUREREPLICATIONSCHEDULE': "storage.PureReplicationSchedule",
            'STORAGE.PURESNAPSHOTSCHEDULE': "storage.PureSnapshotSchedule",
            'STORAGE.PUREVOLUME': "storage.PureVolume",
            'STORAGE.PUREVOLUMESNAPSHOT': "storage.PureVolumeSnapshot",
            'STORAGE.SASEXPANDER': "storage.SasExpander",
            'STORAGE.SASPORT': "storage.SasPort",
            'STORAGE.SPAN': "storage.Span",
            'STORAGE.STORAGEPOLICY': "storage.StoragePolicy",
            'STORAGE.VDMEMBEREP': "storage.VdMemberEp",
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
            'STORAGE.VIRTUALDRIVECONTAINER': "storage.VirtualDriveContainer",
            'STORAGE.VIRTUALDRIVEEXTENSION': "storage.VirtualDriveExtension",
            'STORAGE.VIRTUALDRIVEIDENTITY': "storage.VirtualDriveIdentity",
            'SYSLOG.POLICY': "syslog.Policy",
            'SYSLOG.POLICYINVENTORY': "syslog.PolicyInventory",
            'TAM.ADVISORYCOUNT': "tam.AdvisoryCount",
            'TAM.ADVISORYDEFINITION': "tam.AdvisoryDefinition",
            'TAM.ADVISORYINFO': "tam.AdvisoryInfo",
            'TAM.ADVISORYINSTANCE': "tam.AdvisoryInstance",
            'TAM.SECURITYADVISORY': "tam.SecurityAdvisory",
            'TASK.FABRICMOSSCOPEDINVENTORY': "task.FabricMosScopedInventory",
            'TASK.HITACHISCOPEDINVENTORY': "task.HitachiScopedInventory",
            'TASK.HYPERFLEXMANAGEMENTSCOPEDINVENTORY': "task.HyperFlexManagementScopedInventory",
            'TASK.HYPERFLEXSCOPEDINVENTORY': "task.HyperflexScopedInventory",
            'TASK.IWESCOPEDINVENTORY': "task.IweScopedInventory",
            'TASK.MDSSCOPEDINVENTORY': "task.MdsScopedInventory",
            'TASK.MDSSYSTEMSCOPEDINVENTORY': "task.MdsSystemScopedInventory",
            'TASK.NETAPPSCOPEDINVENTORY': "task.NetAppScopedInventory",
            'TASK.NEXUSSCOPEDINVENTORY': "task.NexusScopedInventory",
            'TASK.NEXUSSYSTEMSCOPEDINVENTORY': "task.NexusSystemScopedInventory",
            'TASK.NEXUSVLANSCOPEDINVENTORY': "task.NexusVlanScopedInventory",
            'TASK.PUBLICCLOUDSCOPEDINVENTORY': "task.PublicCloudScopedInventory",
            'TASK.PURESCOPEDINVENTORY': "task.PureScopedInventory",
            'TASK.SERVERSCOPEDINVENTORY': "task.ServerScopedInventory",
            'TECHSUPPORTMANAGEMENT.COLLECTIONCONTROLPOLICY': "techsupportmanagement.CollectionControlPolicy",
            'TECHSUPPORTMANAGEMENT.DOWNLOAD': "techsupportmanagement.Download",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTBUNDLE': "techsupportmanagement.TechSupportBundle",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTSTATUS': "techsupportmanagement.TechSupportStatus",
            'TERMINAL.AUDITLOG': "terminal.AuditLog",
            'TERRAFORM.EXECUTOR': "terraform.Executor",
            'THERMAL.POLICY': "thermal.Policy",
            'TOP.SYSTEM': "top.System",
            'UCSD.BACKUPINFO': "ucsd.BackupInfo",
            'UUIDPOOL.BLOCK': "uuidpool.Block",
            'UUIDPOOL.POOL': "uuidpool.Pool",
            'UUIDPOOL.POOLMEMBER': "uuidpool.PoolMember",
            'UUIDPOOL.RESERVATION': "uuidpool.Reservation",
            'UUIDPOOL.UNIVERSE': "uuidpool.Universe",
            'UUIDPOOL.UUIDLEASE': "uuidpool.UuidLease",
            'VIEW.HEALTHSTATUS': "view.HealthStatus",
            'VIEW.SERVER': "view.Server",
            'VIRTUALIZATION.CISCOHYPERVISORMANAGER': "virtualization.CiscoHypervisorManager",
            'VIRTUALIZATION.ESXICONSOLE': "virtualization.EsxiConsole",
            'VIRTUALIZATION.HOST': "virtualization.Host",
            'VIRTUALIZATION.IWECLUSTER': "virtualization.IweCluster",
            'VIRTUALIZATION.IWEDATACENTER': "virtualization.IweDatacenter",
            'VIRTUALIZATION.IWEDVUPLINK': "virtualization.IweDvUplink",
            'VIRTUALIZATION.IWEDVSWITCH': "virtualization.IweDvswitch",
            'VIRTUALIZATION.IWEHOST': "virtualization.IweHost",
            'VIRTUALIZATION.IWEHOSTINTERFACE': "virtualization.IweHostInterface",
            'VIRTUALIZATION.IWEHOSTVSWITCH': "virtualization.IweHostVswitch",
            'VIRTUALIZATION.IWENETWORK': "virtualization.IweNetwork",
            'VIRTUALIZATION.IWEVIRTUALDISK': "virtualization.IweVirtualDisk",
            'VIRTUALIZATION.IWEVIRTUALMACHINE': "virtualization.IweVirtualMachine",
            'VIRTUALIZATION.IWEVIRTUALMACHINENETWORKINTERFACE': "virtualization.IweVirtualMachineNetworkInterface",
            'VIRTUALIZATION.VIRTUALDISK': "virtualization.VirtualDisk",
            'VIRTUALIZATION.VIRTUALMACHINE': "virtualization.VirtualMachine",
            'VIRTUALIZATION.VIRTUALNETWORK': "virtualization.VirtualNetwork",
            'VIRTUALIZATION.VMWARECLUSTER': "virtualization.VmwareCluster",
            'VIRTUALIZATION.VMWAREDATACENTER': "virtualization.VmwareDatacenter",
            'VIRTUALIZATION.VMWAREDATASTORE': "virtualization.VmwareDatastore",
            'VIRTUALIZATION.VMWAREDATASTORECLUSTER': "virtualization.VmwareDatastoreCluster",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDNETWORK': "virtualization.VmwareDistributedNetwork",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDSWITCH': "virtualization.VmwareDistributedSwitch",
            'VIRTUALIZATION.VMWAREFOLDER': "virtualization.VmwareFolder",
            'VIRTUALIZATION.VMWAREHOST': "virtualization.VmwareHost",
            'VIRTUALIZATION.VMWAREHOSTGPU': "virtualization.VmwareHostGpu",
            'VIRTUALIZATION.VMWAREKERNELNETWORK': "virtualization.VmwareKernelNetwork",
            'VIRTUALIZATION.VMWARENETWORK': "virtualization.VmwareNetwork",
            'VIRTUALIZATION.VMWAREPHYSICALNETWORKINTERFACE': "virtualization.VmwarePhysicalNetworkInterface",
            'VIRTUALIZATION.VMWAREUPLINKPORT': "virtualization.VmwareUplinkPort",
            'VIRTUALIZATION.VMWAREVCENTER': "virtualization.VmwareVcenter",
            'VIRTUALIZATION.VMWAREVIRTUALDISK': "virtualization.VmwareVirtualDisk",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINE': "virtualization.VmwareVirtualMachine",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINEGPU': "virtualization.VmwareVirtualMachineGpu",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINESNAPSHOT': "virtualization.VmwareVirtualMachineSnapshot",
            'VIRTUALIZATION.VMWAREVIRTUALNETWORKINTERFACE': "virtualization.VmwareVirtualNetworkInterface",
            'VIRTUALIZATION.VMWAREVIRTUALSWITCH': "virtualization.VmwareVirtualSwitch",
            'VMEDIA.POLICY': "vmedia.Policy",
            'VMEDIA.POLICYINVENTORY': "vmedia.PolicyInventory",
            'VMRC.CONSOLE': "vmrc.Console",
            'VNC.CONSOLE': "vnc.Console",
            'VNIC.ETHADAPTERPOLICY': "vnic.EthAdapterPolicy",
            'VNIC.ETHADAPTERPOLICYINVENTORY': "vnic.EthAdapterPolicyInventory",
            'VNIC.ETHIF': "vnic.EthIf",
            'VNIC.ETHIFINVENTORY': "vnic.EthIfInventory",
            'VNIC.ETHNETWORKPOLICY': "vnic.EthNetworkPolicy",
            'VNIC.ETHNETWORKPOLICYINVENTORY': "vnic.EthNetworkPolicyInventory",
            'VNIC.ETHQOSPOLICY': "vnic.EthQosPolicy",
            'VNIC.ETHQOSPOLICYINVENTORY': "vnic.EthQosPolicyInventory",
            'VNIC.ETHVETHINVENTORY': "vnic.EthVethInventory",
            'VNIC.ETHVNICINVENTORY': "vnic.EthVnicInventory",
            'VNIC.FCADAPTERPOLICY': "vnic.FcAdapterPolicy",
            'VNIC.FCADAPTERPOLICYINVENTORY': "vnic.FcAdapterPolicyInventory",
            'VNIC.FCIF': "vnic.FcIf",
            'VNIC.FCIFINVENTORY': "vnic.FcIfInventory",
            'VNIC.FCNETWORKPOLICY': "vnic.FcNetworkPolicy",
            'VNIC.FCNETWORKPOLICYINVENTORY': "vnic.FcNetworkPolicyInventory",
            'VNIC.FCQOSPOLICY': "vnic.FcQosPolicy",
            'VNIC.FCQOSPOLICYINVENTORY': "vnic.FcQosPolicyInventory",
            'VNIC.FCVETHINVENTORY': "vnic.FcVethInventory",
            'VNIC.FCVHBAPOLICYINVENTORY': "vnic.FcVhbaPolicyInventory",
            'VNIC.ISCSIADAPTERPOLICY': "vnic.IscsiAdapterPolicy",
            'VNIC.ISCSIADAPTERPOLICYINVENTORY': "vnic.IscsiAdapterPolicyInventory",
            'VNIC.ISCSIBOOTPOLICY': "vnic.IscsiBootPolicy",
            'VNIC.ISCSIBOOTPOLICYINVENTORY': "vnic.IscsiBootPolicyInventory",
            'VNIC.ISCSISTATICTARGETPOLICY': "vnic.IscsiStaticTargetPolicy",
            'VNIC.ISCSISTATICTARGETPOLICYINVENTORY': "vnic.IscsiStaticTargetPolicyInventory",
            'VNIC.LANCONNECTIVITYPOLICY': "vnic.LanConnectivityPolicy",
            'VNIC.LANCONNECTIVITYPOLICYINVENTORY': "vnic.LanConnectivityPolicyInventory",
            'VNIC.LCPSTATUS': "vnic.LcpStatus",
            'VNIC.SANCONNECTIVITYPOLICY': "vnic.SanConnectivityPolicy",
            'VNIC.SANCONNECTIVITYPOLICYINVENTORY': "vnic.SanConnectivityPolicyInventory",
            'VNIC.SCPSTATUS': "vnic.ScpStatus",
            'VRF.VRF': "vrf.Vrf",
            'WORKFLOW.ANSIBLEBATCHEXECUTOR': "workflow.AnsibleBatchExecutor",
            'WORKFLOW.BATCHAPIEXECUTOR': "workflow.BatchApiExecutor",
            'WORKFLOW.BUILDTASKMETA': "workflow.BuildTaskMeta",
            'WORKFLOW.BUILDTASKMETAOWNER': "workflow.BuildTaskMetaOwner",
            'WORKFLOW.CATALOG': "workflow.Catalog",
            'WORKFLOW.CUSTOMDATATYPEDEFINITION': "workflow.CustomDataTypeDefinition",
            'WORKFLOW.ERRORRESPONSEHANDLER': "workflow.ErrorResponseHandler",
            'WORKFLOW.PENDINGDYNAMICWORKFLOWINFO': "workflow.PendingDynamicWorkflowInfo",
            'WORKFLOW.POWERSHELLBATCHAPIEXECUTOR': "workflow.PowerShellBatchApiExecutor",
            'WORKFLOW.ROLLBACKWORKFLOW': "workflow.RollbackWorkflow",
            'WORKFLOW.SERVICEITEMACTIONDEFINITION': "workflow.ServiceItemActionDefinition",
            'WORKFLOW.SERVICEITEMACTIONINSTANCE': "workflow.ServiceItemActionInstance",
            'WORKFLOW.SERVICEITEMDEFINITION': "workflow.ServiceItemDefinition",
            'WORKFLOW.SERVICEITEMHEALTHCHECKDEFINITION': "workflow.ServiceItemHealthCheckDefinition",
            'WORKFLOW.SERVICEITEMHEALTHCHECKEXECUTION': "workflow.ServiceItemHealthCheckExecution",
            'WORKFLOW.SERVICEITEMINSTANCE': "workflow.ServiceItemInstance",
            'WORKFLOW.SERVICEITEMOUTPUT': "workflow.ServiceItemOutput",
            'WORKFLOW.SOLUTIONACTIONDEFINITION': "workflow.SolutionActionDefinition",
            'WORKFLOW.SOLUTIONACTIONINSTANCE': "workflow.SolutionActionInstance",
            'WORKFLOW.SOLUTIONDEFINITION': "workflow.SolutionDefinition",
            'WORKFLOW.SOLUTIONINSTANCE': "workflow.SolutionInstance",
            'WORKFLOW.SOLUTIONOUTPUT': "workflow.SolutionOutput",
            'WORKFLOW.SSHBATCHEXECUTOR': "workflow.SshBatchExecutor",
            'WORKFLOW.TASKDEBUGLOG': "workflow.TaskDebugLog",
            'WORKFLOW.TASKDEFINITION': "workflow.TaskDefinition",
            'WORKFLOW.TASKINFO': "workflow.TaskInfo",
            'WORKFLOW.TASKMETADATA': "workflow.TaskMetadata",
            'WORKFLOW.TASKNOTIFICATION': "workflow.TaskNotification",
            'WORKFLOW.TEMPLATEEVALUATION': "workflow.TemplateEvaluation",
            'WORKFLOW.TEMPLATEFUNCTIONMETA': "workflow.TemplateFunctionMeta",
            'WORKFLOW.TEMPLATEPARSER': "workflow.TemplateParser",
            'WORKFLOW.WORKFLOWDEFINITION': "workflow.WorkflowDefinition",
            'WORKFLOW.WORKFLOWINFO': "workflow.WorkflowInfo",
            'WORKFLOW.WORKFLOWMETA': "workflow.WorkflowMeta",
            'WORKFLOW.WORKFLOWMETADATA': "workflow.WorkflowMetadata",
            'WORKFLOW.WORKFLOWNOTIFICATION': "workflow.WorkflowNotification",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'selector': (str,),  # noqa: E501
            'link': (str,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'device_identifier': (str,),  # noqa: E501
            'device_type': (str,),  # noqa: E501
            'pid': (str,),  # noqa: E501
            'platform_param': (ConnectorPlatformParamBase,),  # noqa: E501
            'platform_type': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'device_registration': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'target_resource': (MoBaseMoRelationship,),  # noqa: E501
            'tech_support_status': (TechsupportmanagementTechSupportStatusRelationship,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'mo.MoRef': MoMoRef,
            'techsupportmanagement.TechSupportBundle': TechsupportmanagementTechSupportBundle,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'selector': 'Selector',  # noqa: E501
        'link': 'link',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'device_identifier': 'DeviceIdentifier',  # noqa: E501
        'device_type': 'DeviceType',  # noqa: E501
        'pid': 'Pid',  # noqa: E501
        'platform_param': 'PlatformParam',  # noqa: E501
        'platform_type': 'PlatformType',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'device_registration': 'DeviceRegistration',  # noqa: E501
        'target_resource': 'TargetResource',  # noqa: E501
        'tech_support_status': 'TechSupportStatus',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
    }

    read_only_vars = {
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'device_identifier',  # noqa: E501
        'device_type',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """TechsupportmanagementTechSupportBundleRelationship - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "mo.MoRef", must be one of ["mo.MoRef", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            moid (str): The Moid of the referenced REST resource.. [optional]  # noqa: E501
            selector (str): An OData $filter expression which describes the REST resource to be referenced. This field may be set instead of 'moid' by clients. 1. If 'moid' is set this field is ignored. 1. If 'selector' is set and 'moid' is empty/absent from the request, Intersight determines the Moid of the resource matching the filter expression and populates it in the MoRef that is part of the object instance being inserted/updated to fulfill the REST request. An error is returned if the filter matches zero or more than one REST resource. An example filter string is: Serial eq '3AA8B7T11'.. [optional]  # noqa: E501
            link (str): A URL to an instance of the 'mo.MoRef' class.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_identifier (str): The device identifier used to uniquely identify an individual device.. [optional]  # noqa: E501
            device_type (str): The device type obtained from the inventory.. [optional]  # noqa: E501
            pid (str): Product identification of the device.. [optional]  # noqa: E501
            platform_param (ConnectorPlatformParamBase): [optional]  # noqa: E501
            platform_type (str): The platform type of the device. * `` - The device reported an empty or unrecognized platform type. * `APIC` - An Application Policy Infrastructure Controller cluster. * `CAPIC` - A Cloud Application Policy Infrastructure Controller instance. * `DCNM` - A Data Center Network Manager instance. Data Center Network Manager (DCNM) is the network management platform for all NX-OS-enabled deployments, spanning new fabric architectures, IP Fabric for Media, and storage networking deployments for the Cisco Nexus-powered data center. * `UCSFI` - A UCS Fabric Interconnect in HA or standalone mode, which is being managed by UCS Manager (UCSM). * `UCSFIISM` - A UCS Fabric Interconnect in HA or standalone mode, managed directly by Intersight. * `IMC` - A standalone UCS Server Integrated Management Controller. * `IMCM4` - A standalone UCS M4 Server. * `IMCM5` - A standalone UCS M5 server. * `IMCRack` - A standalone UCS M6 and above server. * `UCSIOM` - An UCS Chassis IO module. * `HX` - A HyperFlex storage controller. * `HyperFlexAP` - A HyperFlex Application Platform. * `IWE` - An Intersight Workload Engine. * `UCSD` - A UCS Director virtual appliance. Cisco UCS Director automates, orchestrates, and manages Cisco and third-party hardware. * `IntersightAppliance` - A Cisco Intersight Connected Virtual Appliance. * `IntersightAssist` - A Cisco Intersight Assist. * `PureStorageFlashArray` - A Pure Storage FlashArray device. * `NexusDevice` - A generic platform type to support Nexus Network Device. This can also be extended to support all network devices later on. * `ACISwitch` - A platform type to support ACI Switches. * `NexusSwitch` - A platform type to support Cisco Nexus Switches. * `MDSSwitch` - A platform type to support Cisco MDS Switches. * `MDSDevice` - A platform type to support MDS devices. * `UCSC890` - A standalone Cisco UCSC890 server. * `RedfishServer` - A generic target type for servers that support Redfish. Current support is limited to managing HPE and Dell servers on Intersight. * `NetAppOntap` - A NetApp ONTAP storage system. * `NetAppActiveIqUnifiedManager` - A NetApp Active IQ Unified Manager. * `EmcScaleIo` - An EMC ScaleIO storage system. * `EmcVmax` - An EMC VMAX storage system. * `EmcVplex` - An EMC VPLEX storage system. * `EmcXtremIo` - An EMC XtremIO storage system. * `VmwareVcenter` - A VMware vCenter device that manages Virtual Machines. * `MicrosoftHyperV` - A Microsoft Hyper-V system that manages Virtual Machines. * `AppDynamics` - An AppDynamics controller that monitors applications. * `Dynatrace` - A software-intelligence monitoring platform that simplifies enterprise cloud complexity and accelerates digital transformation. * `NewRelic` - A software-intelligence monitoring platform that simplifies enterprise cloud complexity and accelerates digital transformation. * `ServiceNow` - A cloud-based workflow automation platform that enables enterprise organizations to improve operational efficiencies by streamlining and automating routine work tasks. * `ReadHatOpenStack` - An OpenStack target manages Virtual Machines, Physical Machines, Datacenters and Virtual Datacenters using different OpenStack services as administrative endpoints. * `CloudFoundry` - An open source cloud platform on which developers can build, deploy, run and scale applications. * `MicrosoftAzureApplicationInsights` - A feature of Azure Monitor, is an extensible Application Performance Management service for developers and DevOps professionals to monitor their live applications. * `OpenStack` - An OpenStack target manages Virtual Machines, Physical Machines, Datacenters and Virtual Datacenters using different OpenStack services as administrative endpoints. * `MicrosoftSqlServer` - A Microsoft SQL database server. * `MySqlServer` - An instance of either Oracle MySQL Database or the open source MariaDB. * `OracleDatabaseServer` - The Oracle Server is a relational database management system that provides an open, comprehensive, and integrated approach to information management. * `IBMWebSphereApplicationServer` - WebSphere Application Server (WAS) is a software product that performs the role of a web application server. More specifically it is a software framework and middleware that hosts Java based web applications. * `OracleWebLogicServer` - Oracle WebLogic Server is a unified and extensible platform for developing, deploying and running enterprise applications, such as Java, for on-premises and in the cloud. WebLogic Server offers a robust, mature, and scalable implementation of Java Enterprise Edition (EE) and Jakarta EE. * `ApacheTomcatServer` - Apache Tomcat is a web container. It allows the users to run Servlet and JAVA Server Pages that are based on the web-applications. * `JavaVirtualMachine` - The Java Virtual Machine (JVM) is the runtime engine of the Java Platform, which allows any program written in Java or other language compiled into Java bytecode to run on any computer that has a native JVM. * `RedHatJBossApplicationServer` - JBoss Application Server is an open-source, cross-platform Java application server developed by JBoss, a division of Red Hat Inc. It is an open-source implementation of Java 2 Enterprise Edition (J2EE) that is used for implementing Java applications and other Web-based applications and software. * `Kubernetes` - A Kubernetes cluster that runs containerized applications. * `AmazonWebService` - An Amazon web service target that discovers and monitors different services like EC2. It discovers entities like VMs, Volumes, regions etc. and monitors attributes like Mem, CPU, cost. * `AmazonWebServiceBilling` - An Amazon web service billing target to retrieve billing information stored in S3 bucket. * `GoogleCloudPlatform` - Google Cloud Platform (GCP), offered by Google, is a suite of cloud computing services that runs on the same infrastructure that Google uses internally for its end-user products, such as Google Search, Gmail, Google Drive, and YouTube. Alongside a set of management tools, it provides a series of modular cloud services including computing, data storage, data analytics and machine learning. Google Cloud Platform provides infrastructure as a service, platform as a service, and serverless computing environments. * `GoogleCloudPlatformBilling` - Google Cloud Platform (GCP) offers flexible ways to set up and manage billing for your resources. A billing account is how a user pays for the resources being consumed. A billing account is associated with a method of payment and access is established using Cloud IAM roles. For a resource to be deployed in a project, the project has to be associated with a billing account. More than one project can be associated with a billing account. * `MicrosoftAzureServicePrincipal` - A Microsoft Azure Service Principal target that discovers all the associated Azure subscriptions. * `MicrosoftAzureEnterpriseAgreement` - A Microsoft Azure Enterprise Agreement target that discovers cost, billing and RIs. * `MicrosoftAzureBilling` - A Microsoft Azure Billing target that discovers Billing families, Reserved Instances and Cost data. * `DellCompellent` - A Dell Compellent storage system. * `HPE3Par` - A HPE 3PAR storage system. * `RedHatEnterpriseVirtualization` - A Red Hat Enterprise Virtualization Hypervisor system that manages Virtual Machines. * `NutanixAcropolis` - A Nutanix Acropolis system that combines servers and storage into a distributed infrastructure platform. * `HPEOneView` - A HPE Oneview management system that manages compute, storage, and networking. * `ServiceEngine` - Cisco Application Services Engine. Cisco Application Services Engine is a platform to deploy and manage applications. * `HitachiVirtualStoragePlatform` - A Hitachi Virtual Storage Platform also referred to as Hitachi VSP. It includes various storage systems designed for data centers. * `IMCBlade` - An Intersight managed UCS Blade Server. * `TerraformCloud` - A Terraform Cloud account. * `TerraformAgent` - A Terraform Cloud Agent that Intersight will deploy in datacenter. The agent will execute Terraform plan for Terraform Cloud workspace configured to use the agent. * `CustomTarget` - An external endpoint added as Target that can be accessed through its HTTP API interface in Intersight Orchestrator automation workflow.Standard HTTP authentication scheme supported: Basic. * `AnsibleEndpoint` - An external endpoint added as Target that can be accessed through Ansible in Intersight Cloud Orchestrator automation workflow. * `HTTPEndpoint` - An external endpoint added as Target that can be accessed through its HTTP API interface in Intersight Orchestrator automation workflow.Standard HTTP authentication scheme supported: Basic, Bearer Token. * `SSHEndpoint` - An external endpoint added as Target that can be accessed through SSH in Intersight Cloud Orchestrator automation workflow. * `CiscoCatalyst` - A Cisco Catalyst networking switch device. * `PowerShellEndpoint` - A Windows machine on which PowerShell scripts can be executed remotely.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            serial (str): Serial number of the device.. [optional]  # noqa: E501
            device_registration (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            target_resource (MoBaseMoRelationship): [optional]  # noqa: E501
            tech_support_status (TechsupportmanagementTechSupportStatusRelationship): [optional]  # noqa: E501
            object_type (str): The fully-qualified name of the remote type referred by this relationship.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "mo.MoRef")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """TechsupportmanagementTechSupportBundleRelationship - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "mo.MoRef", must be one of ["mo.MoRef", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            moid (str): The Moid of the referenced REST resource.. [optional]  # noqa: E501
            selector (str): An OData $filter expression which describes the REST resource to be referenced. This field may be set instead of 'moid' by clients. 1. If 'moid' is set this field is ignored. 1. If 'selector' is set and 'moid' is empty/absent from the request, Intersight determines the Moid of the resource matching the filter expression and populates it in the MoRef that is part of the object instance being inserted/updated to fulfill the REST request. An error is returned if the filter matches zero or more than one REST resource. An example filter string is: Serial eq '3AA8B7T11'.. [optional]  # noqa: E501
            link (str): A URL to an instance of the 'mo.MoRef' class.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_identifier (str): The device identifier used to uniquely identify an individual device.. [optional]  # noqa: E501
            device_type (str): The device type obtained from the inventory.. [optional]  # noqa: E501
            pid (str): Product identification of the device.. [optional]  # noqa: E501
            platform_param (ConnectorPlatformParamBase): [optional]  # noqa: E501
            platform_type (str): The platform type of the device. * `` - The device reported an empty or unrecognized platform type. * `APIC` - An Application Policy Infrastructure Controller cluster. * `CAPIC` - A Cloud Application Policy Infrastructure Controller instance. * `DCNM` - A Data Center Network Manager instance. Data Center Network Manager (DCNM) is the network management platform for all NX-OS-enabled deployments, spanning new fabric architectures, IP Fabric for Media, and storage networking deployments for the Cisco Nexus-powered data center. * `UCSFI` - A UCS Fabric Interconnect in HA or standalone mode, which is being managed by UCS Manager (UCSM). * `UCSFIISM` - A UCS Fabric Interconnect in HA or standalone mode, managed directly by Intersight. * `IMC` - A standalone UCS Server Integrated Management Controller. * `IMCM4` - A standalone UCS M4 Server. * `IMCM5` - A standalone UCS M5 server. * `IMCRack` - A standalone UCS M6 and above server. * `UCSIOM` - An UCS Chassis IO module. * `HX` - A HyperFlex storage controller. * `HyperFlexAP` - A HyperFlex Application Platform. * `IWE` - An Intersight Workload Engine. * `UCSD` - A UCS Director virtual appliance. Cisco UCS Director automates, orchestrates, and manages Cisco and third-party hardware. * `IntersightAppliance` - A Cisco Intersight Connected Virtual Appliance. * `IntersightAssist` - A Cisco Intersight Assist. * `PureStorageFlashArray` - A Pure Storage FlashArray device. * `NexusDevice` - A generic platform type to support Nexus Network Device. This can also be extended to support all network devices later on. * `ACISwitch` - A platform type to support ACI Switches. * `NexusSwitch` - A platform type to support Cisco Nexus Switches. * `MDSSwitch` - A platform type to support Cisco MDS Switches. * `MDSDevice` - A platform type to support MDS devices. * `UCSC890` - A standalone Cisco UCSC890 server. * `RedfishServer` - A generic target type for servers that support Redfish. Current support is limited to managing HPE and Dell servers on Intersight. * `NetAppOntap` - A NetApp ONTAP storage system. * `NetAppActiveIqUnifiedManager` - A NetApp Active IQ Unified Manager. * `EmcScaleIo` - An EMC ScaleIO storage system. * `EmcVmax` - An EMC VMAX storage system. * `EmcVplex` - An EMC VPLEX storage system. * `EmcXtremIo` - An EMC XtremIO storage system. * `VmwareVcenter` - A VMware vCenter device that manages Virtual Machines. * `MicrosoftHyperV` - A Microsoft Hyper-V system that manages Virtual Machines. * `AppDynamics` - An AppDynamics controller that monitors applications. * `Dynatrace` - A software-intelligence monitoring platform that simplifies enterprise cloud complexity and accelerates digital transformation. * `NewRelic` - A software-intelligence monitoring platform that simplifies enterprise cloud complexity and accelerates digital transformation. * `ServiceNow` - A cloud-based workflow automation platform that enables enterprise organizations to improve operational efficiencies by streamlining and automating routine work tasks. * `ReadHatOpenStack` - An OpenStack target manages Virtual Machines, Physical Machines, Datacenters and Virtual Datacenters using different OpenStack services as administrative endpoints. * `CloudFoundry` - An open source cloud platform on which developers can build, deploy, run and scale applications. * `MicrosoftAzureApplicationInsights` - A feature of Azure Monitor, is an extensible Application Performance Management service for developers and DevOps professionals to monitor their live applications. * `OpenStack` - An OpenStack target manages Virtual Machines, Physical Machines, Datacenters and Virtual Datacenters using different OpenStack services as administrative endpoints. * `MicrosoftSqlServer` - A Microsoft SQL database server. * `MySqlServer` - An instance of either Oracle MySQL Database or the open source MariaDB. * `OracleDatabaseServer` - The Oracle Server is a relational database management system that provides an open, comprehensive, and integrated approach to information management. * `IBMWebSphereApplicationServer` - WebSphere Application Server (WAS) is a software product that performs the role of a web application server. More specifically it is a software framework and middleware that hosts Java based web applications. * `OracleWebLogicServer` - Oracle WebLogic Server is a unified and extensible platform for developing, deploying and running enterprise applications, such as Java, for on-premises and in the cloud. WebLogic Server offers a robust, mature, and scalable implementation of Java Enterprise Edition (EE) and Jakarta EE. * `ApacheTomcatServer` - Apache Tomcat is a web container. It allows the users to run Servlet and JAVA Server Pages that are based on the web-applications. * `JavaVirtualMachine` - The Java Virtual Machine (JVM) is the runtime engine of the Java Platform, which allows any program written in Java or other language compiled into Java bytecode to run on any computer that has a native JVM. * `RedHatJBossApplicationServer` - JBoss Application Server is an open-source, cross-platform Java application server developed by JBoss, a division of Red Hat Inc. It is an open-source implementation of Java 2 Enterprise Edition (J2EE) that is used for implementing Java applications and other Web-based applications and software. * `Kubernetes` - A Kubernetes cluster that runs containerized applications. * `AmazonWebService` - An Amazon web service target that discovers and monitors different services like EC2. It discovers entities like VMs, Volumes, regions etc. and monitors attributes like Mem, CPU, cost. * `AmazonWebServiceBilling` - An Amazon web service billing target to retrieve billing information stored in S3 bucket. * `GoogleCloudPlatform` - Google Cloud Platform (GCP), offered by Google, is a suite of cloud computing services that runs on the same infrastructure that Google uses internally for its end-user products, such as Google Search, Gmail, Google Drive, and YouTube. Alongside a set of management tools, it provides a series of modular cloud services including computing, data storage, data analytics and machine learning. Google Cloud Platform provides infrastructure as a service, platform as a service, and serverless computing environments. * `GoogleCloudPlatformBilling` - Google Cloud Platform (GCP) offers flexible ways to set up and manage billing for your resources. A billing account is how a user pays for the resources being consumed. A billing account is associated with a method of payment and access is established using Cloud IAM roles. For a resource to be deployed in a project, the project has to be associated with a billing account. More than one project can be associated with a billing account. * `MicrosoftAzureServicePrincipal` - A Microsoft Azure Service Principal target that discovers all the associated Azure subscriptions. * `MicrosoftAzureEnterpriseAgreement` - A Microsoft Azure Enterprise Agreement target that discovers cost, billing and RIs. * `MicrosoftAzureBilling` - A Microsoft Azure Billing target that discovers Billing families, Reserved Instances and Cost data. * `DellCompellent` - A Dell Compellent storage system. * `HPE3Par` - A HPE 3PAR storage system. * `RedHatEnterpriseVirtualization` - A Red Hat Enterprise Virtualization Hypervisor system that manages Virtual Machines. * `NutanixAcropolis` - A Nutanix Acropolis system that combines servers and storage into a distributed infrastructure platform. * `HPEOneView` - A HPE Oneview management system that manages compute, storage, and networking. * `ServiceEngine` - Cisco Application Services Engine. Cisco Application Services Engine is a platform to deploy and manage applications. * `HitachiVirtualStoragePlatform` - A Hitachi Virtual Storage Platform also referred to as Hitachi VSP. It includes various storage systems designed for data centers. * `IMCBlade` - An Intersight managed UCS Blade Server. * `TerraformCloud` - A Terraform Cloud account. * `TerraformAgent` - A Terraform Cloud Agent that Intersight will deploy in datacenter. The agent will execute Terraform plan for Terraform Cloud workspace configured to use the agent. * `CustomTarget` - An external endpoint added as Target that can be accessed through its HTTP API interface in Intersight Orchestrator automation workflow.Standard HTTP authentication scheme supported: Basic. * `AnsibleEndpoint` - An external endpoint added as Target that can be accessed through Ansible in Intersight Cloud Orchestrator automation workflow. * `HTTPEndpoint` - An external endpoint added as Target that can be accessed through its HTTP API interface in Intersight Orchestrator automation workflow.Standard HTTP authentication scheme supported: Basic, Bearer Token. * `SSHEndpoint` - An external endpoint added as Target that can be accessed through SSH in Intersight Cloud Orchestrator automation workflow. * `CiscoCatalyst` - A Cisco Catalyst networking switch device. * `PowerShellEndpoint` - A Windows machine on which PowerShell scripts can be executed remotely.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            serial (str): Serial number of the device.. [optional]  # noqa: E501
            device_registration (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            target_resource (MoBaseMoRelationship): [optional]  # noqa: E501
            tech_support_status (TechsupportmanagementTechSupportStatusRelationship): [optional]  # noqa: E501
            object_type (str): The fully-qualified name of the remote type referred by this relationship.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "mo.MoRef")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
          ],
          'oneOf': [
              MoMoRef,
              TechsupportmanagementTechSupportBundle,
              none_type,
          ],
        }
