"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9661
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    from intersight.model.storage_controller_relationship import StorageControllerRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship
    globals()['StorageControllerRelationship'] = StorageControllerRelationship


class StorageBatteryBackupUnitAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'STORAGE.BATTERYBACKUPUNIT': "storage.BatteryBackupUnit",
        },
        ('object_type',): {
            'STORAGE.BATTERYBACKUPUNIT': "storage.BatteryBackupUnit",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'capacitance_in_percent': (int,),  # noqa: E501
            'charging_state': (str,),  # noqa: E501
            'current_in_amps': (float,),  # noqa: E501
            'design_capacity_in_joules': (str,),  # noqa: E501
            'design_voltage_in_volts': (float,),  # noqa: E501
            'device_name': (str,),  # noqa: E501
            'is_battery_present': (bool,),  # noqa: E501
            'is_capacitor': (bool,),  # noqa: E501
            'is_learn_cycle_requested': (bool,),  # noqa: E501
            'is_learn_cycle_transparent': (bool,),  # noqa: E501
            'is_temperature_high': (bool,),  # noqa: E501
            'is_voltage_low': (bool,),  # noqa: E501
            'learn_cycle_progress_end_time_stamp': (str,),  # noqa: E501
            'learn_cycle_progress_start_time_stamp': (str,),  # noqa: E501
            'learn_cycle_progress_status': (str,),  # noqa: E501
            'learn_mode': (str,),  # noqa: E501
            'manufacturing_date': (str,),  # noqa: E501
            'module_version': (str,),  # noqa: E501
            'next_learn_cycle_time_stamp': (str,),  # noqa: E501
            'pack_energy_in_joules': (str,),  # noqa: E501
            'remaining_pool_space_in_percent': (int,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'temperature_in_cel': (int,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'voltage_in_volts': (str,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'storage_controller': (StorageControllerRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'capacitance_in_percent': 'CapacitanceInPercent',  # noqa: E501
        'charging_state': 'ChargingState',  # noqa: E501
        'current_in_amps': 'CurrentInAmps',  # noqa: E501
        'design_capacity_in_joules': 'DesignCapacityInJoules',  # noqa: E501
        'design_voltage_in_volts': 'DesignVoltageInVolts',  # noqa: E501
        'device_name': 'DeviceName',  # noqa: E501
        'is_battery_present': 'IsBatteryPresent',  # noqa: E501
        'is_capacitor': 'IsCapacitor',  # noqa: E501
        'is_learn_cycle_requested': 'IsLearnCycleRequested',  # noqa: E501
        'is_learn_cycle_transparent': 'IsLearnCycleTransparent',  # noqa: E501
        'is_temperature_high': 'IsTemperatureHigh',  # noqa: E501
        'is_voltage_low': 'IsVoltageLow',  # noqa: E501
        'learn_cycle_progress_end_time_stamp': 'LearnCycleProgressEndTimeStamp',  # noqa: E501
        'learn_cycle_progress_start_time_stamp': 'LearnCycleProgressStartTimeStamp',  # noqa: E501
        'learn_cycle_progress_status': 'LearnCycleProgressStatus',  # noqa: E501
        'learn_mode': 'LearnMode',  # noqa: E501
        'manufacturing_date': 'ManufacturingDate',  # noqa: E501
        'module_version': 'ModuleVersion',  # noqa: E501
        'next_learn_cycle_time_stamp': 'NextLearnCycleTimeStamp',  # noqa: E501
        'pack_energy_in_joules': 'PackEnergyInJoules',  # noqa: E501
        'remaining_pool_space_in_percent': 'RemainingPoolSpaceInPercent',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'temperature_in_cel': 'TemperatureInCel',  # noqa: E501
        'type': 'Type',  # noqa: E501
        'voltage_in_volts': 'VoltageInVolts',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'storage_controller': 'StorageController',  # noqa: E501
    }

    read_only_vars = {
        'capacitance_in_percent',  # noqa: E501
        'charging_state',  # noqa: E501
        'current_in_amps',  # noqa: E501
        'design_capacity_in_joules',  # noqa: E501
        'design_voltage_in_volts',  # noqa: E501
        'device_name',  # noqa: E501
        'is_battery_present',  # noqa: E501
        'is_capacitor',  # noqa: E501
        'is_learn_cycle_requested',  # noqa: E501
        'is_learn_cycle_transparent',  # noqa: E501
        'is_temperature_high',  # noqa: E501
        'is_voltage_low',  # noqa: E501
        'learn_cycle_progress_end_time_stamp',  # noqa: E501
        'learn_cycle_progress_start_time_stamp',  # noqa: E501
        'learn_cycle_progress_status',  # noqa: E501
        'learn_mode',  # noqa: E501
        'manufacturing_date',  # noqa: E501
        'module_version',  # noqa: E501
        'next_learn_cycle_time_stamp',  # noqa: E501
        'pack_energy_in_joules',  # noqa: E501
        'remaining_pool_space_in_percent',  # noqa: E501
        'status',  # noqa: E501
        'temperature_in_cel',  # noqa: E501
        'type',  # noqa: E501
        'voltage_in_volts',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """StorageBatteryBackupUnitAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "storage.BatteryBackupUnit", must be one of ["storage.BatteryBackupUnit", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "storage.BatteryBackupUnit", must be one of ["storage.BatteryBackupUnit", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            capacitance_in_percent (int): This holds the capacitance (in percent) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            charging_state (str): This holds the charging state of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            current_in_amps (float): This holds the current (in Amps) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            design_capacity_in_joules (str): This holds the design Capacity (in joules) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            design_voltage_in_volts (float): This holds the design volatage (in Volts) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            device_name (str): This refers to the device name of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_battery_present (bool): This indicates whether the battery is present for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_capacitor (bool): This indicates the capacitor for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_learn_cycle_requested (bool): This indicates learn cycle request of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_learn_cycle_transparent (bool): This indicates the learn cycle transparent for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_temperature_high (bool): This indicates the temperature is high for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_voltage_low (bool): This indicates the voltage is Low for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            learn_cycle_progress_end_time_stamp (str): This refers to learn cycle progress end time of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            learn_cycle_progress_start_time_stamp (str): This refers to learn cycle progress start time of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            learn_cycle_progress_status (str): This refers to learn cycle progress status of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            learn_mode (str): This refers to the learn mode of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            manufacturing_date (str): This refers to the manufacture date of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            module_version (str): This refers to the current module version of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            next_learn_cycle_time_stamp (str): This refers to next learn cycle timestamp of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            pack_energy_in_joules (str): This holds the pack energy (in joules) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            remaining_pool_space_in_percent (int): This holds the remaining pool space (in percent) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            status (str): This holds the current status of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            temperature_in_cel (int): This holds the temperature (in Celsius) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            type (str): This refers to the type of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            voltage_in_volts (str): This holds the volatage (in Volts) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            storage_controller (StorageControllerRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "storage.BatteryBackupUnit")
        object_type = kwargs.get('object_type', "storage.BatteryBackupUnit")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """StorageBatteryBackupUnitAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "storage.BatteryBackupUnit", must be one of ["storage.BatteryBackupUnit", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "storage.BatteryBackupUnit", must be one of ["storage.BatteryBackupUnit", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            capacitance_in_percent (int): This holds the capacitance (in percent) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            charging_state (str): This holds the charging state of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            current_in_amps (float): This holds the current (in Amps) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            design_capacity_in_joules (str): This holds the design Capacity (in joules) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            design_voltage_in_volts (float): This holds the design volatage (in Volts) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            device_name (str): This refers to the device name of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_battery_present (bool): This indicates whether the battery is present for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_capacitor (bool): This indicates the capacitor for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_learn_cycle_requested (bool): This indicates learn cycle request of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_learn_cycle_transparent (bool): This indicates the learn cycle transparent for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_temperature_high (bool): This indicates the temperature is high for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            is_voltage_low (bool): This indicates the voltage is Low for the battery backup unit of the storage controller.. [optional]  # noqa: E501
            learn_cycle_progress_end_time_stamp (str): This refers to learn cycle progress end time of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            learn_cycle_progress_start_time_stamp (str): This refers to learn cycle progress start time of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            learn_cycle_progress_status (str): This refers to learn cycle progress status of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            learn_mode (str): This refers to the learn mode of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            manufacturing_date (str): This refers to the manufacture date of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            module_version (str): This refers to the current module version of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            next_learn_cycle_time_stamp (str): This refers to next learn cycle timestamp of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            pack_energy_in_joules (str): This holds the pack energy (in joules) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            remaining_pool_space_in_percent (int): This holds the remaining pool space (in percent) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            status (str): This holds the current status of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            temperature_in_cel (int): This holds the temperature (in Celsius) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            type (str): This refers to the type of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            voltage_in_volts (str): This holds the volatage (in Volts) of the battery backup unit of the storage controller.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            storage_controller (StorageControllerRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "storage.BatteryBackupUnit")
        object_type = kwargs.get('object_type', "storage.BatteryBackupUnit")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
