"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9661
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.adapter_host_fc_interface import AdapterHostFcInterface
    from intersight.model.adapter_host_iscsi_interface import AdapterHostIscsiInterface
    from intersight.model.adapter_unit import AdapterUnit
    from intersight.model.adapter_unit_expander import AdapterUnitExpander
    from intersight.model.bios_unit import BiosUnit
    from intersight.model.boot_cdd_device import BootCddDevice
    from intersight.model.boot_configured_device import BootConfiguredDevice
    from intersight.model.boot_hdd_device import BootHddDevice
    from intersight.model.boot_iscsi_device import BootIscsiDevice
    from intersight.model.boot_nvme_device import BootNvmeDevice
    from intersight.model.boot_pch_storage_device import BootPchStorageDevice
    from intersight.model.boot_pxe_device import BootPxeDevice
    from intersight.model.boot_san_device import BootSanDevice
    from intersight.model.boot_sd_device import BootSdDevice
    from intersight.model.boot_uefi_shell_device import BootUefiShellDevice
    from intersight.model.boot_usb_device import BootUsbDevice
    from intersight.model.boot_vmedia_device import BootVmediaDevice
    from intersight.model.compute_blade import ComputeBlade
    from intersight.model.compute_board import ComputeBoard
    from intersight.model.compute_physical import ComputePhysical
    from intersight.model.compute_rack_unit import ComputeRackUnit
    from intersight.model.display_names import DisplayNames
    from intersight.model.equipment_abstract_device import EquipmentAbstractDevice
    from intersight.model.equipment_base_all_of import EquipmentBaseAllOf
    from intersight.model.equipment_chassis import EquipmentChassis
    from intersight.model.equipment_expander_module import EquipmentExpanderModule
    from intersight.model.equipment_fan import EquipmentFan
    from intersight.model.equipment_fan_control import EquipmentFanControl
    from intersight.model.equipment_fan_module import EquipmentFanModule
    from intersight.model.equipment_fex import EquipmentFex
    from intersight.model.equipment_fru import EquipmentFru
    from intersight.model.equipment_fru_relationship import EquipmentFruRelationship
    from intersight.model.equipment_io_card import EquipmentIoCard
    from intersight.model.equipment_io_card_base import EquipmentIoCardBase
    from intersight.model.equipment_io_expander import EquipmentIoExpander
    from intersight.model.equipment_psu import EquipmentPsu
    from intersight.model.equipment_psu_control import EquipmentPsuControl
    from intersight.model.equipment_rack_enclosure import EquipmentRackEnclosure
    from intersight.model.equipment_rack_enclosure_slot import EquipmentRackEnclosureSlot
    from intersight.model.equipment_shared_io_module import EquipmentSharedIoModule
    from intersight.model.equipment_slot import EquipmentSlot
    from intersight.model.equipment_switch_card import EquipmentSwitchCard
    from intersight.model.equipment_system_io_controller import EquipmentSystemIoController
    from intersight.model.equipment_tpm import EquipmentTpm
    from intersight.model.equipment_transceiver import EquipmentTransceiver
    from intersight.model.graphics_card import GraphicsCard
    from intersight.model.graphics_controller import GraphicsController
    from intersight.model.inventory_base import InventoryBase
    from intersight.model.memory_abstract_unit import MemoryAbstractUnit
    from intersight.model.memory_array import MemoryArray
    from intersight.model.memory_persistent_memory_unit import MemoryPersistentMemoryUnit
    from intersight.model.memory_unit import MemoryUnit
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.network_element import NetworkElement
    from intersight.model.network_supervisor_card import NetworkSupervisorCard
    from intersight.model.pci_coprocessor_card import PciCoprocessorCard
    from intersight.model.pci_device import PciDevice
    from intersight.model.pci_link import PciLink
    from intersight.model.pci_node import PciNode
    from intersight.model.pci_switch import PciSwitch
    from intersight.model.processor_unit import ProcessorUnit
    from intersight.model.security_unit import SecurityUnit
    from intersight.model.storage_base_array import StorageBaseArray
    from intersight.model.storage_base_array_controller import StorageBaseArrayController
    from intersight.model.storage_base_array_disk import StorageBaseArrayDisk
    from intersight.model.storage_battery_backup_unit import StorageBatteryBackupUnit
    from intersight.model.storage_controller import StorageController
    from intersight.model.storage_disk_slot import StorageDiskSlot
    from intersight.model.storage_enclosure import StorageEnclosure
    from intersight.model.storage_enclosure_disk import StorageEnclosureDisk
    from intersight.model.storage_flex_flash_controller import StorageFlexFlashController
    from intersight.model.storage_flex_flash_controller_props import StorageFlexFlashControllerProps
    from intersight.model.storage_flex_flash_physical_drive import StorageFlexFlashPhysicalDrive
    from intersight.model.storage_flex_flash_virtual_drive import StorageFlexFlashVirtualDrive
    from intersight.model.storage_flex_util_physical_drive import StorageFlexUtilPhysicalDrive
    from intersight.model.storage_hitachi_array import StorageHitachiArray
    from intersight.model.storage_hitachi_controller import StorageHitachiController
    from intersight.model.storage_hitachi_disk import StorageHitachiDisk
    from intersight.model.storage_net_app_base_disk import StorageNetAppBaseDisk
    from intersight.model.storage_net_app_cluster import StorageNetAppCluster
    from intersight.model.storage_net_app_node import StorageNetAppNode
    from intersight.model.storage_physical_disk import StoragePhysicalDisk
    from intersight.model.storage_physical_disk_extension import StoragePhysicalDiskExtension
    from intersight.model.storage_pure_array import StoragePureArray
    from intersight.model.storage_pure_controller import StoragePureController
    from intersight.model.storage_pure_disk import StoragePureDisk
    from intersight.model.storage_sas_expander import StorageSasExpander
    from intersight.model.storage_virtual_drive import StorageVirtualDrive
    from intersight.model.storage_virtual_drive_container import StorageVirtualDriveContainer
    globals()['AdapterHostFcInterface'] = AdapterHostFcInterface
    globals()['AdapterHostIscsiInterface'] = AdapterHostIscsiInterface
    globals()['AdapterUnit'] = AdapterUnit
    globals()['AdapterUnitExpander'] = AdapterUnitExpander
    globals()['BiosUnit'] = BiosUnit
    globals()['BootCddDevice'] = BootCddDevice
    globals()['BootConfiguredDevice'] = BootConfiguredDevice
    globals()['BootHddDevice'] = BootHddDevice
    globals()['BootIscsiDevice'] = BootIscsiDevice
    globals()['BootNvmeDevice'] = BootNvmeDevice
    globals()['BootPchStorageDevice'] = BootPchStorageDevice
    globals()['BootPxeDevice'] = BootPxeDevice
    globals()['BootSanDevice'] = BootSanDevice
    globals()['BootSdDevice'] = BootSdDevice
    globals()['BootUefiShellDevice'] = BootUefiShellDevice
    globals()['BootUsbDevice'] = BootUsbDevice
    globals()['BootVmediaDevice'] = BootVmediaDevice
    globals()['ComputeBlade'] = ComputeBlade
    globals()['ComputeBoard'] = ComputeBoard
    globals()['ComputePhysical'] = ComputePhysical
    globals()['ComputeRackUnit'] = ComputeRackUnit
    globals()['DisplayNames'] = DisplayNames
    globals()['EquipmentAbstractDevice'] = EquipmentAbstractDevice
    globals()['EquipmentBaseAllOf'] = EquipmentBaseAllOf
    globals()['EquipmentChassis'] = EquipmentChassis
    globals()['EquipmentExpanderModule'] = EquipmentExpanderModule
    globals()['EquipmentFan'] = EquipmentFan
    globals()['EquipmentFanControl'] = EquipmentFanControl
    globals()['EquipmentFanModule'] = EquipmentFanModule
    globals()['EquipmentFex'] = EquipmentFex
    globals()['EquipmentFru'] = EquipmentFru
    globals()['EquipmentFruRelationship'] = EquipmentFruRelationship
    globals()['EquipmentIoCard'] = EquipmentIoCard
    globals()['EquipmentIoCardBase'] = EquipmentIoCardBase
    globals()['EquipmentIoExpander'] = EquipmentIoExpander
    globals()['EquipmentPsu'] = EquipmentPsu
    globals()['EquipmentPsuControl'] = EquipmentPsuControl
    globals()['EquipmentRackEnclosure'] = EquipmentRackEnclosure
    globals()['EquipmentRackEnclosureSlot'] = EquipmentRackEnclosureSlot
    globals()['EquipmentSharedIoModule'] = EquipmentSharedIoModule
    globals()['EquipmentSlot'] = EquipmentSlot
    globals()['EquipmentSwitchCard'] = EquipmentSwitchCard
    globals()['EquipmentSystemIoController'] = EquipmentSystemIoController
    globals()['EquipmentTpm'] = EquipmentTpm
    globals()['EquipmentTransceiver'] = EquipmentTransceiver
    globals()['GraphicsCard'] = GraphicsCard
    globals()['GraphicsController'] = GraphicsController
    globals()['InventoryBase'] = InventoryBase
    globals()['MemoryAbstractUnit'] = MemoryAbstractUnit
    globals()['MemoryArray'] = MemoryArray
    globals()['MemoryPersistentMemoryUnit'] = MemoryPersistentMemoryUnit
    globals()['MemoryUnit'] = MemoryUnit
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['NetworkElement'] = NetworkElement
    globals()['NetworkSupervisorCard'] = NetworkSupervisorCard
    globals()['PciCoprocessorCard'] = PciCoprocessorCard
    globals()['PciDevice'] = PciDevice
    globals()['PciLink'] = PciLink
    globals()['PciNode'] = PciNode
    globals()['PciSwitch'] = PciSwitch
    globals()['ProcessorUnit'] = ProcessorUnit
    globals()['SecurityUnit'] = SecurityUnit
    globals()['StorageBaseArray'] = StorageBaseArray
    globals()['StorageBaseArrayController'] = StorageBaseArrayController
    globals()['StorageBaseArrayDisk'] = StorageBaseArrayDisk
    globals()['StorageBatteryBackupUnit'] = StorageBatteryBackupUnit
    globals()['StorageController'] = StorageController
    globals()['StorageDiskSlot'] = StorageDiskSlot
    globals()['StorageEnclosure'] = StorageEnclosure
    globals()['StorageEnclosureDisk'] = StorageEnclosureDisk
    globals()['StorageFlexFlashController'] = StorageFlexFlashController
    globals()['StorageFlexFlashControllerProps'] = StorageFlexFlashControllerProps
    globals()['StorageFlexFlashPhysicalDrive'] = StorageFlexFlashPhysicalDrive
    globals()['StorageFlexFlashVirtualDrive'] = StorageFlexFlashVirtualDrive
    globals()['StorageFlexUtilPhysicalDrive'] = StorageFlexUtilPhysicalDrive
    globals()['StorageHitachiArray'] = StorageHitachiArray
    globals()['StorageHitachiController'] = StorageHitachiController
    globals()['StorageHitachiDisk'] = StorageHitachiDisk
    globals()['StorageNetAppBaseDisk'] = StorageNetAppBaseDisk
    globals()['StorageNetAppCluster'] = StorageNetAppCluster
    globals()['StorageNetAppNode'] = StorageNetAppNode
    globals()['StoragePhysicalDisk'] = StoragePhysicalDisk
    globals()['StoragePhysicalDiskExtension'] = StoragePhysicalDiskExtension
    globals()['StoragePureArray'] = StoragePureArray
    globals()['StoragePureController'] = StoragePureController
    globals()['StoragePureDisk'] = StoragePureDisk
    globals()['StorageSasExpander'] = StorageSasExpander
    globals()['StorageVirtualDrive'] = StorageVirtualDrive
    globals()['StorageVirtualDriveContainer'] = StorageVirtualDriveContainer


class EquipmentBase(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'ADAPTER.HOSTFCINTERFACE': "adapter.HostFcInterface",
            'ADAPTER.HOSTISCSIINTERFACE': "adapter.HostIscsiInterface",
            'ADAPTER.UNIT': "adapter.Unit",
            'ADAPTER.UNITEXPANDER': "adapter.UnitExpander",
            'BIOS.UNIT': "bios.Unit",
            'BOOT.CDDDEVICE': "boot.CddDevice",
            'BOOT.HDDDEVICE': "boot.HddDevice",
            'BOOT.ISCSIDEVICE': "boot.IscsiDevice",
            'BOOT.NVMEDEVICE': "boot.NvmeDevice",
            'BOOT.PCHSTORAGEDEVICE': "boot.PchStorageDevice",
            'BOOT.PXEDEVICE': "boot.PxeDevice",
            'BOOT.SANDEVICE': "boot.SanDevice",
            'BOOT.SDDEVICE': "boot.SdDevice",
            'BOOT.UEFISHELLDEVICE': "boot.UefiShellDevice",
            'BOOT.USBDEVICE': "boot.UsbDevice",
            'BOOT.VMEDIADEVICE': "boot.VmediaDevice",
            'COMPUTE.BLADE': "compute.Blade",
            'COMPUTE.BOARD': "compute.Board",
            'COMPUTE.RACKUNIT': "compute.RackUnit",
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
            'EQUIPMENT.EXPANDERMODULE': "equipment.ExpanderModule",
            'EQUIPMENT.FAN': "equipment.Fan",
            'EQUIPMENT.FANCONTROL': "equipment.FanControl",
            'EQUIPMENT.FANMODULE': "equipment.FanModule",
            'EQUIPMENT.FEX': "equipment.Fex",
            'EQUIPMENT.FRU': "equipment.Fru",
            'EQUIPMENT.IOCARD': "equipment.IoCard",
            'EQUIPMENT.IOEXPANDER': "equipment.IoExpander",
            'EQUIPMENT.PSU': "equipment.Psu",
            'EQUIPMENT.PSUCONTROL': "equipment.PsuControl",
            'EQUIPMENT.RACKENCLOSURE': "equipment.RackEnclosure",
            'EQUIPMENT.RACKENCLOSURESLOT': "equipment.RackEnclosureSlot",
            'EQUIPMENT.SHAREDIOMODULE': "equipment.SharedIoModule",
            'EQUIPMENT.SWITCHCARD': "equipment.SwitchCard",
            'EQUIPMENT.SYSTEMIOCONTROLLER': "equipment.SystemIoController",
            'EQUIPMENT.TPM': "equipment.Tpm",
            'EQUIPMENT.TRANSCEIVER': "equipment.Transceiver",
            'GRAPHICS.CARD': "graphics.Card",
            'GRAPHICS.CONTROLLER': "graphics.Controller",
            'MEMORY.ARRAY': "memory.Array",
            'MEMORY.PERSISTENTMEMORYUNIT': "memory.PersistentMemoryUnit",
            'MEMORY.UNIT': "memory.Unit",
            'NETWORK.ELEMENT': "network.Element",
            'NETWORK.SUPERVISORCARD': "network.SupervisorCard",
            'PCI.COPROCESSORCARD': "pci.CoprocessorCard",
            'PCI.DEVICE': "pci.Device",
            'PCI.LINK': "pci.Link",
            'PCI.NODE': "pci.Node",
            'PCI.SWITCH': "pci.Switch",
            'PROCESSOR.UNIT': "processor.Unit",
            'SECURITY.UNIT': "security.Unit",
            'STORAGE.BATTERYBACKUPUNIT': "storage.BatteryBackupUnit",
            'STORAGE.CONTROLLER': "storage.Controller",
            'STORAGE.DISKSLOT': "storage.DiskSlot",
            'STORAGE.ENCLOSURE': "storage.Enclosure",
            'STORAGE.ENCLOSUREDISK': "storage.EnclosureDisk",
            'STORAGE.FLEXFLASHCONTROLLER': "storage.FlexFlashController",
            'STORAGE.FLEXFLASHCONTROLLERPROPS': "storage.FlexFlashControllerProps",
            'STORAGE.FLEXFLASHPHYSICALDRIVE': "storage.FlexFlashPhysicalDrive",
            'STORAGE.FLEXFLASHVIRTUALDRIVE': "storage.FlexFlashVirtualDrive",
            'STORAGE.FLEXUTILPHYSICALDRIVE': "storage.FlexUtilPhysicalDrive",
            'STORAGE.HITACHIARRAY': "storage.HitachiArray",
            'STORAGE.HITACHICONTROLLER': "storage.HitachiController",
            'STORAGE.HITACHIDISK': "storage.HitachiDisk",
            'STORAGE.NETAPPBASEDISK': "storage.NetAppBaseDisk",
            'STORAGE.NETAPPCLUSTER': "storage.NetAppCluster",
            'STORAGE.NETAPPNODE': "storage.NetAppNode",
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
            'STORAGE.PHYSICALDISKEXTENSION': "storage.PhysicalDiskExtension",
            'STORAGE.PUREARRAY': "storage.PureArray",
            'STORAGE.PURECONTROLLER': "storage.PureController",
            'STORAGE.PUREDISK': "storage.PureDisk",
            'STORAGE.SASEXPANDER': "storage.SasExpander",
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
            'STORAGE.VIRTUALDRIVECONTAINER': "storage.VirtualDriveContainer",
        },
        ('object_type',): {
            'ADAPTER.HOSTFCINTERFACE': "adapter.HostFcInterface",
            'ADAPTER.HOSTISCSIINTERFACE': "adapter.HostIscsiInterface",
            'ADAPTER.UNIT': "adapter.Unit",
            'ADAPTER.UNITEXPANDER': "adapter.UnitExpander",
            'BIOS.UNIT': "bios.Unit",
            'BOOT.CDDDEVICE': "boot.CddDevice",
            'BOOT.HDDDEVICE': "boot.HddDevice",
            'BOOT.ISCSIDEVICE': "boot.IscsiDevice",
            'BOOT.NVMEDEVICE': "boot.NvmeDevice",
            'BOOT.PCHSTORAGEDEVICE': "boot.PchStorageDevice",
            'BOOT.PXEDEVICE': "boot.PxeDevice",
            'BOOT.SANDEVICE': "boot.SanDevice",
            'BOOT.SDDEVICE': "boot.SdDevice",
            'BOOT.UEFISHELLDEVICE': "boot.UefiShellDevice",
            'BOOT.USBDEVICE': "boot.UsbDevice",
            'BOOT.VMEDIADEVICE': "boot.VmediaDevice",
            'COMPUTE.BLADE': "compute.Blade",
            'COMPUTE.BOARD': "compute.Board",
            'COMPUTE.RACKUNIT': "compute.RackUnit",
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
            'EQUIPMENT.EXPANDERMODULE': "equipment.ExpanderModule",
            'EQUIPMENT.FAN': "equipment.Fan",
            'EQUIPMENT.FANCONTROL': "equipment.FanControl",
            'EQUIPMENT.FANMODULE': "equipment.FanModule",
            'EQUIPMENT.FEX': "equipment.Fex",
            'EQUIPMENT.FRU': "equipment.Fru",
            'EQUIPMENT.IOCARD': "equipment.IoCard",
            'EQUIPMENT.IOEXPANDER': "equipment.IoExpander",
            'EQUIPMENT.PSU': "equipment.Psu",
            'EQUIPMENT.PSUCONTROL': "equipment.PsuControl",
            'EQUIPMENT.RACKENCLOSURE': "equipment.RackEnclosure",
            'EQUIPMENT.RACKENCLOSURESLOT': "equipment.RackEnclosureSlot",
            'EQUIPMENT.SHAREDIOMODULE': "equipment.SharedIoModule",
            'EQUIPMENT.SWITCHCARD': "equipment.SwitchCard",
            'EQUIPMENT.SYSTEMIOCONTROLLER': "equipment.SystemIoController",
            'EQUIPMENT.TPM': "equipment.Tpm",
            'EQUIPMENT.TRANSCEIVER': "equipment.Transceiver",
            'GRAPHICS.CARD': "graphics.Card",
            'GRAPHICS.CONTROLLER': "graphics.Controller",
            'MEMORY.ARRAY': "memory.Array",
            'MEMORY.PERSISTENTMEMORYUNIT': "memory.PersistentMemoryUnit",
            'MEMORY.UNIT': "memory.Unit",
            'NETWORK.ELEMENT': "network.Element",
            'NETWORK.SUPERVISORCARD': "network.SupervisorCard",
            'PCI.COPROCESSORCARD': "pci.CoprocessorCard",
            'PCI.DEVICE': "pci.Device",
            'PCI.LINK': "pci.Link",
            'PCI.NODE': "pci.Node",
            'PCI.SWITCH': "pci.Switch",
            'PROCESSOR.UNIT': "processor.Unit",
            'SECURITY.UNIT': "security.Unit",
            'STORAGE.BATTERYBACKUPUNIT': "storage.BatteryBackupUnit",
            'STORAGE.CONTROLLER': "storage.Controller",
            'STORAGE.DISKSLOT': "storage.DiskSlot",
            'STORAGE.ENCLOSURE': "storage.Enclosure",
            'STORAGE.ENCLOSUREDISK': "storage.EnclosureDisk",
            'STORAGE.FLEXFLASHCONTROLLER': "storage.FlexFlashController",
            'STORAGE.FLEXFLASHCONTROLLERPROPS': "storage.FlexFlashControllerProps",
            'STORAGE.FLEXFLASHPHYSICALDRIVE': "storage.FlexFlashPhysicalDrive",
            'STORAGE.FLEXFLASHVIRTUALDRIVE': "storage.FlexFlashVirtualDrive",
            'STORAGE.FLEXUTILPHYSICALDRIVE': "storage.FlexUtilPhysicalDrive",
            'STORAGE.HITACHIARRAY': "storage.HitachiArray",
            'STORAGE.HITACHICONTROLLER': "storage.HitachiController",
            'STORAGE.HITACHIDISK': "storage.HitachiDisk",
            'STORAGE.NETAPPBASEDISK': "storage.NetAppBaseDisk",
            'STORAGE.NETAPPCLUSTER': "storage.NetAppCluster",
            'STORAGE.NETAPPNODE': "storage.NetAppNode",
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
            'STORAGE.PHYSICALDISKEXTENSION': "storage.PhysicalDiskExtension",
            'STORAGE.PUREARRAY': "storage.PureArray",
            'STORAGE.PURECONTROLLER': "storage.PureController",
            'STORAGE.PUREDISK': "storage.PureDisk",
            'STORAGE.SASEXPANDER': "storage.SasExpander",
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
            'STORAGE.VIRTUALDRIVECONTAINER': "storage.VirtualDriveContainer",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'model': (str,),  # noqa: E501
            'presence': (str,),  # noqa: E501
            'revision': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'previous_fru': (EquipmentFruRelationship,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'device_mo_id': (str,),  # noqa: E501
            'dn': (str,),  # noqa: E501
            'rn': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'adapter.HostFcInterface': AdapterHostFcInterface,
            'adapter.HostIscsiInterface': AdapterHostIscsiInterface,
            'adapter.Unit': AdapterUnit,
            'adapter.UnitExpander': AdapterUnitExpander,
            'bios.Unit': BiosUnit,
            'boot.CddDevice': BootCddDevice,
            'boot.ConfiguredDevice': BootConfiguredDevice,
            'boot.HddDevice': BootHddDevice,
            'boot.IscsiDevice': BootIscsiDevice,
            'boot.NvmeDevice': BootNvmeDevice,
            'boot.PchStorageDevice': BootPchStorageDevice,
            'boot.PxeDevice': BootPxeDevice,
            'boot.SanDevice': BootSanDevice,
            'boot.SdDevice': BootSdDevice,
            'boot.UefiShellDevice': BootUefiShellDevice,
            'boot.UsbDevice': BootUsbDevice,
            'boot.VmediaDevice': BootVmediaDevice,
            'compute.Blade': ComputeBlade,
            'compute.Board': ComputeBoard,
            'compute.Physical': ComputePhysical,
            'compute.RackUnit': ComputeRackUnit,
            'equipment.AbstractDevice': EquipmentAbstractDevice,
            'equipment.Chassis': EquipmentChassis,
            'equipment.ExpanderModule': EquipmentExpanderModule,
            'equipment.Fan': EquipmentFan,
            'equipment.FanControl': EquipmentFanControl,
            'equipment.FanModule': EquipmentFanModule,
            'equipment.Fex': EquipmentFex,
            'equipment.Fru': EquipmentFru,
            'equipment.IoCard': EquipmentIoCard,
            'equipment.IoCardBase': EquipmentIoCardBase,
            'equipment.IoExpander': EquipmentIoExpander,
            'equipment.Psu': EquipmentPsu,
            'equipment.PsuControl': EquipmentPsuControl,
            'equipment.RackEnclosure': EquipmentRackEnclosure,
            'equipment.RackEnclosureSlot': EquipmentRackEnclosureSlot,
            'equipment.SharedIoModule': EquipmentSharedIoModule,
            'equipment.Slot': EquipmentSlot,
            'equipment.SwitchCard': EquipmentSwitchCard,
            'equipment.SystemIoController': EquipmentSystemIoController,
            'equipment.Tpm': EquipmentTpm,
            'equipment.Transceiver': EquipmentTransceiver,
            'graphics.Card': GraphicsCard,
            'graphics.Controller': GraphicsController,
            'memory.AbstractUnit': MemoryAbstractUnit,
            'memory.Array': MemoryArray,
            'memory.PersistentMemoryUnit': MemoryPersistentMemoryUnit,
            'memory.Unit': MemoryUnit,
            'network.Element': NetworkElement,
            'network.SupervisorCard': NetworkSupervisorCard,
            'pci.CoprocessorCard': PciCoprocessorCard,
            'pci.Device': PciDevice,
            'pci.Link': PciLink,
            'pci.Node': PciNode,
            'pci.Switch': PciSwitch,
            'processor.Unit': ProcessorUnit,
            'security.Unit': SecurityUnit,
            'storage.BaseArray': StorageBaseArray,
            'storage.BaseArrayController': StorageBaseArrayController,
            'storage.BaseArrayDisk': StorageBaseArrayDisk,
            'storage.BatteryBackupUnit': StorageBatteryBackupUnit,
            'storage.Controller': StorageController,
            'storage.DiskSlot': StorageDiskSlot,
            'storage.Enclosure': StorageEnclosure,
            'storage.EnclosureDisk': StorageEnclosureDisk,
            'storage.FlexFlashController': StorageFlexFlashController,
            'storage.FlexFlashControllerProps': StorageFlexFlashControllerProps,
            'storage.FlexFlashPhysicalDrive': StorageFlexFlashPhysicalDrive,
            'storage.FlexFlashVirtualDrive': StorageFlexFlashVirtualDrive,
            'storage.FlexUtilPhysicalDrive': StorageFlexUtilPhysicalDrive,
            'storage.HitachiArray': StorageHitachiArray,
            'storage.HitachiController': StorageHitachiController,
            'storage.HitachiDisk': StorageHitachiDisk,
            'storage.NetAppBaseDisk': StorageNetAppBaseDisk,
            'storage.NetAppCluster': StorageNetAppCluster,
            'storage.NetAppNode': StorageNetAppNode,
            'storage.PhysicalDisk': StoragePhysicalDisk,
            'storage.PhysicalDiskExtension': StoragePhysicalDiskExtension,
            'storage.PureArray': StoragePureArray,
            'storage.PureController': StoragePureController,
            'storage.PureDisk': StoragePureDisk,
            'storage.SasExpander': StorageSasExpander,
            'storage.VirtualDrive': StorageVirtualDrive,
            'storage.VirtualDriveContainer': StorageVirtualDriveContainer,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'model': 'Model',  # noqa: E501
        'presence': 'Presence',  # noqa: E501
        'revision': 'Revision',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'previous_fru': 'PreviousFru',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'device_mo_id': 'DeviceMoId',  # noqa: E501
        'dn': 'Dn',  # noqa: E501
        'rn': 'Rn',  # noqa: E501
    }

    read_only_vars = {
        'model',  # noqa: E501
        'presence',  # noqa: E501
        'revision',  # noqa: E501
        'serial',  # noqa: E501
        'vendor',  # noqa: E501
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
        'device_mo_id',  # noqa: E501
        'dn',  # noqa: E501
        'rn',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """EquipmentBase - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            model (str): This field identifies the model of the given component.. [optional]  # noqa: E501
            presence (str): This field identifies the presence (equipped) or absence of the given component.. [optional]  # noqa: E501
            revision (str): This field identifies the revision of the given component.. [optional]  # noqa: E501
            serial (str): This field identifies the serial of the given component.. [optional]  # noqa: E501
            vendor (str): This field identifies the vendor of the given component.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """EquipmentBase - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            model (str): This field identifies the model of the given component.. [optional]  # noqa: E501
            presence (str): This field identifies the presence (equipped) or absence of the given component.. [optional]  # noqa: E501
            revision (str): This field identifies the revision of the given component.. [optional]  # noqa: E501
            serial (str): This field identifies the serial of the given component.. [optional]  # noqa: E501
            vendor (str): This field identifies the vendor of the given component.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              EquipmentBaseAllOf,
              InventoryBase,
          ],
          'oneOf': [
          ],
        }
