"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9661
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.compute_physical_summary_relationship import ComputePhysicalSummaryRelationship
    from intersight.model.convergedinfra_pod_compliance_info_relationship import ConvergedinfraPodComplianceInfoRelationship
    globals()['ComputePhysicalSummaryRelationship'] = ComputePhysicalSummaryRelationship
    globals()['ConvergedinfraPodComplianceInfoRelationship'] = ConvergedinfraPodComplianceInfoRelationship


class ConvergedinfraServerComplianceDetailsAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'CONVERGEDINFRA.SERVERCOMPLIANCEDETAILS': "convergedinfra.ServerComplianceDetails",
        },
        ('object_type',): {
            'CONVERGEDINFRA.SERVERCOMPLIANCEDETAILS': "convergedinfra.ServerComplianceDetails",
        },
        ('hcl_status',): {
            'NOTEVALUATED': "NotEvaluated",
            'APPROVED': "Approved",
            'NOTAPPROVED': "NotApproved",
            'INCOMPLETE': "Incomplete",
        },
        ('hcl_status_reason',): {
            'MISSING-OS-DRIVER-INFO': "Missing-Os-Driver-Info",
            'INCOMPATIBLE-SERVER': "Incompatible-Server",
            'INCOMPATIBLE-PROCESSOR': "Incompatible-Processor",
            'INCOMPATIBLE-OS-INFO': "Incompatible-Os-Info",
            'INCOMPATIBLE-FIRMWARE': "Incompatible-Firmware",
            'SERVICE-UNAVAILABLE': "Service-Unavailable",
            'SERVICE-ERROR': "Service-Error",
            'NOT-EVALUATED': "Not-Evaluated",
            'INCOMPATIBLE-COMPONENTS': "Incompatible-Components",
            'COMPATIBLE': "Compatible",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'adapter_count': (int,),  # noqa: E501
            'firmware': (str,),  # noqa: E501
            'hcl_status': (str,),  # noqa: E501
            'hcl_status_reason': (str,),  # noqa: E501
            'model': (str,),  # noqa: E501
            'os': (str,),  # noqa: E501
            'platform': (str,),  # noqa: E501
            'processor': (str,),  # noqa: E501
            'pod_compliance': (ConvergedinfraPodComplianceInfoRelationship,),  # noqa: E501
            'server': (ComputePhysicalSummaryRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'adapter_count': 'AdapterCount',  # noqa: E501
        'firmware': 'Firmware',  # noqa: E501
        'hcl_status': 'HclStatus',  # noqa: E501
        'hcl_status_reason': 'HclStatusReason',  # noqa: E501
        'model': 'Model',  # noqa: E501
        'os': 'Os',  # noqa: E501
        'platform': 'Platform',  # noqa: E501
        'processor': 'Processor',  # noqa: E501
        'pod_compliance': 'PodCompliance',  # noqa: E501
        'server': 'Server',  # noqa: E501
    }

    read_only_vars = {
        'adapter_count',  # noqa: E501
        'firmware',  # noqa: E501
        'hcl_status',  # noqa: E501
        'hcl_status_reason',  # noqa: E501
        'model',  # noqa: E501
        'os',  # noqa: E501
        'platform',  # noqa: E501
        'processor',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """ConvergedinfraServerComplianceDetailsAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "convergedinfra.ServerComplianceDetails", must be one of ["convergedinfra.ServerComplianceDetails", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "convergedinfra.ServerComplianceDetails", must be one of ["convergedinfra.ServerComplianceDetails", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            adapter_count (int): The number of ethernet NIC adapters in the server.. [optional]  # noqa: E501
            firmware (str): The Cisco IMC firmware version of the server.. [optional]  # noqa: E501
            hcl_status (str): The HCL compatibility status of the server. * `NotEvaluated` - The interoperability compliance for the component has not be checked. * `Approved` - The component is valid as per the interoperability compliance check. * `NotApproved` - The component is not valid as per the interoperability compliance check. * `Incomplete` - The interoperability compliance check could not be completed for the component due to incomplete data.. [optional] if omitted the server will use the default value of "NotEvaluated"  # noqa: E501
            hcl_status_reason (str): The reason for server's HCL status. * `Missing-Os-Driver-Info` - The validation failed becaue the given server has no OS driver information available in the inventory. Either install UCS Tools VIB on the host ESXi or use OS Discovery Tool scripts to provide proper OS information. * `Incompatible-Server` - The validation failed for this server because the server's model was not listed in the HCL. * `Incompatible-Processor` - The validation failed because the given processor was not listed for the given server model. * `Incompatible-Os-Info` - The validation failed because the given OS vendor or version was not listed in HCL for the server PID and processor combination. * `Incompatible-Firmware` - The validation failed because the given server firmware was not listed in the HCL for the given server PID, processor, OS vendor and version. * `Service-Unavailable` - The validation has failed because HCL data service is temporarily not available. The server will be re-evaluated once HCL data service is back online or finished importing new HCL data. * `Service-Error` - The validation has failed because the HCL data service has returned a service error or unrecognized result. * `Not-Evaluated` - This means the HclStatus for the sever has not been evaluated because it is exempted. * `Incompatible-Components` - The validation has failed for this server because one or more components have \"Not-Listed\" status. * `Compatible` - The validation has passed for this server's model, processor, OS vendor and version.. [optional] if omitted the server will use the default value of "Missing-Os-Driver-Info"  # noqa: E501
            model (str): The model information of the server.. [optional]  # noqa: E501
            os (str): Details of name and version of the operating system running on the server.. [optional]  # noqa: E501
            platform (str): Details of platform of the server, examples are B-Series, C-Series, X-Series etc.. [optional]  # noqa: E501
            processor (str): The processor information of the server.. [optional]  # noqa: E501
            pod_compliance (ConvergedinfraPodComplianceInfoRelationship): [optional]  # noqa: E501
            server (ComputePhysicalSummaryRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "convergedinfra.ServerComplianceDetails")
        object_type = kwargs.get('object_type', "convergedinfra.ServerComplianceDetails")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """ConvergedinfraServerComplianceDetailsAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "convergedinfra.ServerComplianceDetails", must be one of ["convergedinfra.ServerComplianceDetails", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "convergedinfra.ServerComplianceDetails", must be one of ["convergedinfra.ServerComplianceDetails", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            adapter_count (int): The number of ethernet NIC adapters in the server.. [optional]  # noqa: E501
            firmware (str): The Cisco IMC firmware version of the server.. [optional]  # noqa: E501
            hcl_status (str): The HCL compatibility status of the server. * `NotEvaluated` - The interoperability compliance for the component has not be checked. * `Approved` - The component is valid as per the interoperability compliance check. * `NotApproved` - The component is not valid as per the interoperability compliance check. * `Incomplete` - The interoperability compliance check could not be completed for the component due to incomplete data.. [optional] if omitted the server will use the default value of "NotEvaluated"  # noqa: E501
            hcl_status_reason (str): The reason for server's HCL status. * `Missing-Os-Driver-Info` - The validation failed becaue the given server has no OS driver information available in the inventory. Either install UCS Tools VIB on the host ESXi or use OS Discovery Tool scripts to provide proper OS information. * `Incompatible-Server` - The validation failed for this server because the server's model was not listed in the HCL. * `Incompatible-Processor` - The validation failed because the given processor was not listed for the given server model. * `Incompatible-Os-Info` - The validation failed because the given OS vendor or version was not listed in HCL for the server PID and processor combination. * `Incompatible-Firmware` - The validation failed because the given server firmware was not listed in the HCL for the given server PID, processor, OS vendor and version. * `Service-Unavailable` - The validation has failed because HCL data service is temporarily not available. The server will be re-evaluated once HCL data service is back online or finished importing new HCL data. * `Service-Error` - The validation has failed because the HCL data service has returned a service error or unrecognized result. * `Not-Evaluated` - This means the HclStatus for the sever has not been evaluated because it is exempted. * `Incompatible-Components` - The validation has failed for this server because one or more components have \"Not-Listed\" status. * `Compatible` - The validation has passed for this server's model, processor, OS vendor and version.. [optional] if omitted the server will use the default value of "Missing-Os-Driver-Info"  # noqa: E501
            model (str): The model information of the server.. [optional]  # noqa: E501
            os (str): Details of name and version of the operating system running on the server.. [optional]  # noqa: E501
            platform (str): Details of platform of the server, examples are B-Series, C-Series, X-Series etc.. [optional]  # noqa: E501
            processor (str): The processor information of the server.. [optional]  # noqa: E501
            pod_compliance (ConvergedinfraPodComplianceInfoRelationship): [optional]  # noqa: E501
            server (ComputePhysicalSummaryRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "convergedinfra.ServerComplianceDetails")
        object_type = kwargs.get('object_type', "convergedinfra.ServerComplianceDetails")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
