"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9661
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.bios_policy_all_of import BiosPolicyAllOf
    from intersight.model.display_names import DisplayNames
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.organization_organization_relationship import OrganizationOrganizationRelationship
    from intersight.model.policy_abstract_config_profile_relationship import PolicyAbstractConfigProfileRelationship
    from intersight.model.policy_abstract_policy import PolicyAbstractPolicy
    globals()['BiosPolicyAllOf'] = BiosPolicyAllOf
    globals()['DisplayNames'] = DisplayNames
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['OrganizationOrganizationRelationship'] = OrganizationOrganizationRelationship
    globals()['PolicyAbstractConfigProfileRelationship'] = PolicyAbstractConfigProfileRelationship
    globals()['PolicyAbstractPolicy'] = PolicyAbstractPolicy


class BiosPolicy(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'BIOS.POLICY': "bios.Policy",
        },
        ('object_type',): {
            'BIOS.POLICY': "bios.Policy",
        },
        ('acs_control_gpu1state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_gpu2state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_gpu3state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_gpu4state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_gpu5state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_gpu6state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_gpu7state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_gpu8state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_slot11state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_slot12state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_slot13state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('acs_control_slot14state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('adjacent_cache_line_prefetch',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('advanced_mem_test',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('all_usb_devices',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('altitude',): {
            'PLATFORM-DEFAULT': "platform-default",
            '300-M': "300-m",
            '900-M': "900-m",
            '1500-M': "1500-m",
            '3000-M': "3000-m",
            'AUTO': "auto",
        },
        ('aspm_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'FORCE_L0S': "Force L0s",
            'L1_ONLY': "L1 Only",
        },
        ('assert_nmi_on_perr',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('assert_nmi_on_serr',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('auto_cc_state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('autonumous_cstate_enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('baud_rate',): {
            'PLATFORM-DEFAULT': "platform-default",
            '9600': "9600",
            '19200': "19200",
            '38400': "38400",
            '57600': "57600",
            '115200': "115200",
        },
        ('bme_dma_mitigation',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('boot_option_num_retry',): {
            'PLATFORM-DEFAULT': "platform-default",
            '5': "5",
            '13': "13",
            'INFINITE': "Infinite",
        },
        ('boot_option_re_cool_down',): {
            'PLATFORM-DEFAULT': "platform-default",
            '15': "15",
            '45': "45",
            '90': "90",
        },
        ('boot_option_retry',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('boot_performance_mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            'MAX_EFFICIENT': "Max Efficient",
            'MAX_PERFORMANCE': "Max Performance",
            'SET_BY_INTEL_NM': "Set by Intel NM",
        },
        ('burst_and_postponed_refresh',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('c1auto_demotion',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('c1auto_un_demotion',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('cbs_cmn_apbdis',): {
            'PLATFORM-DEFAULT': "platform-default",
            '0': "0",
            '1': "1",
            'AUTO': "Auto",
        },
        ('cbs_cmn_cpu_cpb',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
        },
        ('cbs_cmn_cpu_gen_downcore_ctrl',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'FOUR_(2_+_2)': "FOUR (2 + 2)",
            'FOUR_(4_+_0)': "FOUR (4 + 0)",
            'SIX_(3_+_3)': "SIX (3 + 3)",
            'THREE_(3_+_0)': "THREE (3 + 0)",
            'TWO_(1_+_1)': "TWO (1 + 1)",
            'TWO_(2_+_0)': "TWO (2 + 0)",
        },
        ('cbs_cmn_cpu_global_cstate_ctrl',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_cmn_cpu_l1stream_hw_prefetcher',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_cmn_cpu_l2stream_hw_prefetcher',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_cmn_cpu_smee',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_cmn_cpu_streaming_stores_ctrl',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_cmn_determinism_slider',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'PERFORMANCE': "Performance",
            'POWER': "Power",
        },
        ('cbs_cmn_efficiency_mode_en',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'ENABLED': "Enabled",
        },
        ('cbs_cmn_fixed_soc_pstate',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'P0': "P0",
            'P1': "P1",
            'P2': "P2",
            'P3': "P3",
        },
        ('cbs_cmn_gnb_nb_iommu',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_cmn_gnb_smu_df_cstates',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_cmn_gnb_smucppc',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_cmn_mem_ctrl_bank_group_swap_ddr4',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_cmn_mem_map_bank_interleave_ddr4',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
        },
        ('cbs_cmnc_tdp_ctl',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'MANUAL': "Manual",
        },
        ('cbs_cpu_ccd_ctrl_ssp',): {
            'PLATFORM-DEFAULT': "platform-default",
            '2_CCDS': "2 CCDs",
            '3_CCDS': "3 CCDs",
            '4_CCDS': "4 CCDs",
            '6_CCDS': "6 CCDs",
            'AUTO': "Auto",
        },
        ('cbs_cpu_core_ctrl',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'FIVE_(5_+_0)': "FIVE (5 + 0)",
            'FOUR_(4_+_0)': "FOUR (4 + 0)",
            'ONE_(1_+_0)': "ONE (1 + 0)",
            'SEVEN_(7_+_0)': "SEVEN (7 + 0)",
            'SIX_(6_+_0)': "SIX (6 + 0)",
            'THREE_(3_+_0)': "THREE (3 + 0)",
            'TWO_(2_+_0)': "TWO (2 + 0)",
        },
        ('cbs_cpu_smt_ctrl',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_dbg_cpu_snp_mem_cover',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'CUSTOM': "Custom",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_df_cmn_acpi_srat_l3numa',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('cbs_df_cmn_dram_nps',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'NPS0': "NPS0",
            'NPS1': "NPS1",
            'NPS2': "NPS2",
            'NPS4': "NPS4",
        },
        ('cbs_df_cmn_mem_intlv',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'CHANNEL': "Channel",
            'DIE': "Die",
            'NONE': "None",
            'SOCKET': "Socket",
        },
        ('cbs_df_cmn_mem_intlv_size',): {
            'PLATFORM-DEFAULT': "platform-default",
            '256_BYTES': "256 Bytes",
            '512_BYTES': "512 Bytes",
            '1_KB': "1 KB",
            '2_KB': "2 KB",
            '4_KB': "4 KB",
            'AUTO': "Auto",
        },
        ('cbs_sev_snp_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('cdn_enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('cdn_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LOMS_ONLY': "LOMs Only",
        },
        ('channel_inter_leave',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1-WAY': "1-way",
            '2-WAY': "2-way",
            '3-WAY': "3-way",
            '4-WAY': "4-way",
            'AUTO': "auto",
        },
        ('cisco_adaptive_mem_training',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('cisco_debug_level',): {
            'PLATFORM-DEFAULT': "platform-default",
            'MAXIMUM': "Maximum",
            'MINIMUM': "Minimum",
            'NORMAL': "Normal",
        },
        ('cisco_oprom_launch_optimization',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('cisco_xgmi_max_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('cke_low_policy',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "auto",
            'DISABLED': "disabled",
            'FAST': "fast",
            'SLOW': "slow",
        },
        ('closed_loop_therm_throtl',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('cmci_enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('config_tdp',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('config_tdp_level',): {
            'PLATFORM-DEFAULT': "platform-default",
            'LEVEL_1': "Level 1",
            'LEVEL_2': "Level 2",
            'NORMAL': "Normal",
        },
        ('console_redirection',): {
            'PLATFORM-DEFAULT': "platform-default",
            'COM-0': "com-0",
            'COM-1': "com-1",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'SERIAL-PORT-A': "serial-port-a",
        },
        ('core_multi_processing',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1': "1",
            '2': "2",
            '3': "3",
            '4': "4",
            '5': "5",
            '6': "6",
            '7': "7",
            '8': "8",
            '9': "9",
            '10': "10",
            '11': "11",
            '12': "12",
            '13': "13",
            '14': "14",
            '15': "15",
            '16': "16",
            '17': "17",
            '18': "18",
            '19': "19",
            '20': "20",
            '21': "21",
            '22': "22",
            '23': "23",
            '24': "24",
            '25': "25",
            '26': "26",
            '27': "27",
            '28': "28",
            '29': "29",
            '30': "30",
            '31': "31",
            '32': "32",
            '33': "33",
            '34': "34",
            '35': "35",
            '36': "36",
            '37': "37",
            '38': "38",
            '39': "39",
            '40': "40",
            '41': "41",
            '42': "42",
            '43': "43",
            '44': "44",
            '45': "45",
            '46': "46",
            '47': "47",
            '48': "48",
            'ALL': "all",
        },
        ('cpu_energy_performance',): {
            'PLATFORM-DEFAULT': "platform-default",
            'BALANCED-ENERGY': "balanced-energy",
            'BALANCED-PERFORMANCE': "balanced-performance",
            'BALANCED-POWER': "balanced-power",
            'ENERGY-EFFICIENT': "energy-efficient",
            'PERFORMANCE': "performance",
            'POWER': "power",
        },
        ('cpu_frequency_floor',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('cpu_pa_limit',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('cpu_perf_enhancement',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
        },
        ('cpu_performance',): {
            'PLATFORM-DEFAULT': "platform-default",
            'CUSTOM': "custom",
            'ENTERPRISE': "enterprise",
            'HIGH-THROUGHPUT': "high-throughput",
            'HPC': "hpc",
        },
        ('cpu_power_management',): {
            'PLATFORM-DEFAULT': "platform-default",
            'CUSTOM': "custom",
            'DISABLED': "disabled",
            'ENERGY-EFFICIENT': "energy-efficient",
            'PERFORMANCE': "performance",
        },
        ('cr_qos',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "Disabled",
            'MODE_0_-_DISABLE_THE_PMEM_QOS_FEATURE': "Mode 0 - Disable the PMem QoS Feature",
            'MODE_1_-_M2M_QOS_ENABLE_AND_CHA_QOS_DISABLE': "Mode 1 - M2M QoS Enable and CHA QoS Disable",
            'MODE_2_-_M2M_QOS_ENABLE_AND_CHA_QOS_ENABLE': "Mode 2 - M2M QoS Enable and CHA QoS Enable",
            'RECIPE_1': "Recipe 1",
            'RECIPE_2': "Recipe 2",
            'RECIPE_3': "Recipe 3",
        },
        ('crfastgo_config',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DEFAULT': "Default",
            'DISABLE_OPTIMIZATION': "Disable optimization",
            'ENABLE_OPTIMIZATION': "Enable optimization",
            'OPTION_1': "Option 1",
            'OPTION_2': "Option 2",
            'OPTION_3': "Option 3",
            'OPTION_4': "Option 4",
            'OPTION_5': "Option 5",
        },
        ('dcpmm_firmware_downgrade',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('demand_scrub',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('direct_cache_access',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('dram_clock_throttling',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'BALANCED': "Balanced",
            'ENERGY_EFFICIENT': "Energy Efficient",
            'PERFORMANCE': "Performance",
        },
        ('dram_refresh_rate',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1X': "1x",
            '2X': "2x",
            '3X': "3x",
            '4X': "4x",
            'AUTO': "Auto",
        },
        ('dram_sw_thermal_throttling',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('eadr_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('edpc_en',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "Disabled",
            'ON_FATAL_ERROR': "On Fatal Error",
            'ON_FATAL_AND_NON-FATAL_ERRORS': "On Fatal and Non-Fatal Errors",
        },
        ('enable_clock_spread_spec',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('enable_mktme',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('enable_sgx',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('enable_tme',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('energy_efficient_turbo',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('eng_perf_tuning',): {
            'PLATFORM-DEFAULT': "platform-default",
            'BIOS': "BIOS",
            'OS': "OS",
        },
        ('enhanced_intel_speed_step_tech',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('epoch_update',): {
            'PLATFORM-DEFAULT': "platform-default",
            'CHANGE_TO_NEW_RANDOM_OWNER_EPOCHS': "Change to New Random Owner EPOCHs",
            'MANUAL_USER_DEFINED_OWNER_EPOCHS': "Manual User Defined Owner EPOCHs",
            'SGX_OWNER_EPOCH_ACTIVATED': "SGX Owner EPOCH activated",
        },
        ('epp_enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('epp_profile',): {
            'PLATFORM-DEFAULT': "platform-default",
            'BALANCED_PERFORMANCE': "Balanced Performance",
            'BALANCED_POWER': "Balanced Power",
            'PERFORMANCE': "Performance",
            'POWER': "Power",
        },
        ('execute_disable_bit',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('extended_apic',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'X2APIC': "X2APIC",
            'XAPIC': "XAPIC",
        },
        ('flow_control',): {
            'PLATFORM-DEFAULT': "platform-default",
            'NONE': "none",
            'RTS-CTS': "rts-cts",
        },
        ('frb2enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('hardware_prefetch',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('hwpm_enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "Disabled",
            'HWPM_NATIVE_MODE': "HWPM Native Mode",
            'HWPM_OOB_MODE': "HWPM OOB Mode",
            'NATIVE_MODE': "NATIVE MODE",
            'NATIVE_MODE_WITH_NO_LEGACY': "Native Mode with no Legacy",
            'OOB_MODE': "OOB MODE",
        },
        ('imc_interleave',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1-WAY_INTERLEAVE': "1-way Interleave",
            '2-WAY_INTERLEAVE': "2-way Interleave",
            'AUTO': "Auto",
        },
        ('intel_dynamic_speed_select',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('intel_hyper_threading_tech',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('intel_speed_select',): {
            'PLATFORM-DEFAULT': "platform-default",
            'BASE': "Base",
            'CONFIG_1': "Config 1",
            'CONFIG_2': "Config 2",
            'CONFIG_3': "Config 3",
            'CONFIG_4': "Config 4",
        },
        ('intel_turbo_boost_tech',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('intel_virtualization_technology',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('intel_vt_for_directed_io',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('intel_vtd_coherency_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('intel_vtd_interrupt_remapping',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('intel_vtd_pass_through_dma_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('intel_vtdats_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('ioh_error_enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'NO': "No",
            'YES': "Yes",
        },
        ('ioh_resource',): {
            'PLATFORM-DEFAULT': "platform-default",
            'IOH0_24K_IOH1_40K': "IOH0 24k IOH1 40k",
            'IOH0_32K_IOH1_32K': "IOH0 32k IOH1 32k",
            'IOH0_40K_IOH1_24K': "IOH0 40k IOH1 24k",
            'IOH0_48K_IOH1_16K': "IOH0 48k IOH1 16k",
            'IOH0_56K_IOH1_8K': "IOH0 56k IOH1 8k",
        },
        ('ip_prefetch',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('ipv4http',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('ipv4pxe',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('ipv6http',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('ipv6pxe',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('kti_prefetch',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('legacy_os_redirection',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('legacy_usb_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('llc_alloc',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('llc_prefetch',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('lom_port0state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('lom_port1state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('lom_port2state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('lom_port3state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('lom_ports_all_state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('lv_ddr_mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "auto",
            'PERFORMANCE-MODE': "performance-mode",
            'POWER-SAVING-MODE': "power-saving-mode",
        },
        ('make_device_non_bootable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('memory_bandwidth_boost',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('memory_inter_leave',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1_WAY_NODE_INTERLEAVE': "1 Way Node Interleave",
            '2_WAY_NODE_INTERLEAVE': "2 Way Node Interleave",
            '4_WAY_NODE_INTERLEAVE': "4 Way Node Interleave",
            '8_WAY_NODE_INTERLEAVE': "8 Way Node Interleave",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('memory_mapped_io_above4gb',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('memory_refresh_rate',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1X_REFRESH': "1x Refresh",
            '2X_REFRESH': "2x Refresh",
        },
        ('memory_thermal_throttling',): {
            'PLATFORM-DEFAULT': "platform-default",
            'CLTT_WITH_PECI': "CLTT with PECI",
            'DISABLED': "Disabled",
        },
        ('mirroring_mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            'INTER-SOCKET': "inter-socket",
            'INTRA-SOCKET': "intra-socket",
        },
        ('mmcfg_base',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1_GB': "1 GB",
            '2_GB': "2 GB",
            '2.5_GB': "2.5 GB",
            '3_GB': "3 GB",
            'AUTO': "Auto",
        },
        ('network_stack',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('numa_optimized',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('nvmdimm_perform_config',): {
            'PLATFORM-DEFAULT': "platform-default",
            'BW_OPTIMIZED': "BW Optimized",
            'BALANCED_PROFILE': "Balanced Profile",
            'LATENCY_OPTIMIZED': "Latency Optimized",
        },
        ('onboard10gbit_lom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('onboard_gbit_lom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('onboard_scu_storage_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('onboard_scu_storage_sw_stack',): {
            'PLATFORM-DEFAULT': "platform-default",
            'INTEL_RSTE': "Intel RSTe",
            'LSI_SW_RAID': "LSI SW RAID",
        },
        ('operation_mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            'TEST_ONLY': "Test Only",
            'TEST_AND_REPAIR': "Test and Repair",
        },
        ('os_boot_watchdog_timer',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('os_boot_watchdog_timer_policy',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DO-NOTHING': "do-nothing",
            'POWER-OFF': "power-off",
            'RESET': "reset",
        },
        ('os_boot_watchdog_timer_timeout',): {
            'PLATFORM-DEFAULT': "platform-default",
            '5-MINUTES': "5-minutes",
            '10-MINUTES': "10-minutes",
            '15-MINUTES': "15-minutes",
            '20-MINUTES': "20-minutes",
        },
        ('out_of_band_mgmt_port',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('package_cstate_limit',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'C0_C1_STATE': "C0 C1 State",
            'C0/C1': "C0/C1",
            'C2': "C2",
            'C6_NON_RETENTION': "C6 Non Retention",
            'C6_RETENTION': "C6 Retention",
            'NO_LIMIT': "No Limit",
        },
        ('panic_high_watermark',): {
            'PLATFORM-DEFAULT': "platform-default",
            'HIGH': "High",
            'LOW': "Low",
        },
        ('partial_cache_line_sparing',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('partial_mirror_mode_config',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'PERCENTAGE': "Percentage",
            'VALUE_IN_GB': "Value in GB",
        },
        ('patrol_scrub',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLE_AT_END_OF_POST': "Enable at End of POST",
            'ENABLED': "enabled",
        },
        ('pc_ie_ras_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pc_ie_ssd_hot_plug_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pch_usb30mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pci_option_ro_ms',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('pci_rom_clp',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_ari_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('pcie_pll_ssc',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'ZEROPOINTFIVE': "ZeroPointFive",
        },
        ('pcie_slot_mraid1link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('pcie_slot_mraid1option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_slot_mraid2link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('pcie_slot_mraid2option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_slot_mstorraid_link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('pcie_slot_mstorraid_option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_slot_nvme1link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('pcie_slot_nvme1option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_slot_nvme2link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('pcie_slot_nvme2option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_slot_nvme3link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('pcie_slot_nvme3option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_slot_nvme4link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('pcie_slot_nvme4option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_slot_nvme5link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('pcie_slot_nvme5option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_slot_nvme6link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('pcie_slot_nvme6option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pcie_slots_cdn_enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('pop_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('post_error_pause',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('post_package_repair',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "Disabled",
            'HARD_PPR': "Hard PPR",
        },
        ('processor_c1e',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('processor_c3report',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('processor_c6report',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('processor_cstate',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('psata',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AHCI': "AHCI",
            'DISABLED': "Disabled",
            'LSI_SW_RAID': "LSI SW RAID",
        },
        ('pstate_coord_type',): {
            'PLATFORM-DEFAULT': "platform-default",
            'HW_ALL': "HW ALL",
            'SW_ALL': "SW ALL",
            'SW_ANY': "SW ANY",
        },
        ('putty_key_pad',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ESCN': "ESCN",
            'LINUX': "LINUX",
            'SCO': "SCO",
            'VT100': "VT100",
            'VT400': "VT400",
            'XTERMR6': "XTERMR6",
        },
        ('pwr_perf_tuning',): {
            'PLATFORM-DEFAULT': "platform-default",
            'BIOS': "bios",
            'OS': "os",
            'PECI': "peci",
        },
        ('qpi_link_frequency',): {
            'PLATFORM-DEFAULT': "platform-default",
            '6.4-GT/S': "6.4-gt/s",
            '7.2-GT/S': "7.2-gt/s",
            '8.0-GT/S': "8.0-gt/s",
            '9.6-GT/S': "9.6-gt/s",
            'AUTO': "auto",
        },
        ('qpi_link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            '10.4GT/S': "10.4GT/s",
            '11.2GT/S': "11.2GT/s",
            '9.6GT/S': "9.6GT/s",
            'AUTO': "Auto",
        },
        ('qpi_snoop_mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "auto",
            'CLUSTER-ON-DIE': "cluster-on-die",
            'EARLY-SNOOP': "early-snoop",
            'HOME-DIRECTORY-SNOOP': "home-directory-snoop",
            'HOME-DIRECTORY-SNOOP-WITH-OSB': "home-directory-snoop-with-osb",
            'HOME-SNOOP': "home-snoop",
        },
        ('rank_inter_leave',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1-WAY': "1-way",
            '2-WAY': "2-way",
            '4-WAY': "4-way",
            '8-WAY': "8-way",
            'AUTO': "auto",
        },
        ('redirection_after_post',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ALWAYS_ENABLE': "Always Enable",
            'BOOTLOADER': "Bootloader",
        },
        ('sata_mode_select',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AHCI': "AHCI",
            'DISABLED': "Disabled",
            'LSI_SW_RAID': "LSI SW RAID",
        },
        ('select_memory_ras_configuration',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ADDDC-SPARING': "adddc-sparing",
            'LOCKSTEP': "lockstep",
            'MAXIMUM-PERFORMANCE': "maximum-performance",
            'MIRROR-MODE-1LM': "mirror-mode-1lm",
            'MIRRORING': "mirroring",
            'PARTIAL-MIRROR-MODE-1LM': "partial-mirror-mode-1lm",
            'SPARING': "sparing",
        },
        ('select_ppr_type',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'HARD_PPR': "Hard PPR",
            'SOFT_PPR': "Soft PPR",
        },
        ('serial_port_aenable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('sev',): {
            'PLATFORM-DEFAULT': "platform-default",
            '253_ASIDS': "253 ASIDs",
            '509_ASIDS': "509 ASIDs",
            'AUTO': "Auto",
        },
        ('sgx_auto_registration_agent',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('sgx_factory_reset',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('sgx_le_wr',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('sgx_package_info_in_band_access',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('sgx_qos',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('sha1pcr_bank',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('sha256pcr_bank',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('single_pctl_enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'NO': "No",
            'YES': "Yes",
        },
        ('slot10link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot10state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot11link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot11state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot12link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot12state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot13state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot14state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot1link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot1state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot2link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot2state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot3link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot3state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot4link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot4state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot5link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot5state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot6link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot6state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot7link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot7state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot8link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot8state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot9link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot9state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot_flom_link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_front_nvme10link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme10option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme11link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme11option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme12link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme12option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme13option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme14option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme15option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme16option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme17option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme18option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme19option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme1link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme1option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme20option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme21option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme22option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme23option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme24option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme2link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme2option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme3link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme3option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme4link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme4option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme5link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme5option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme6link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme6option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme7link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme7option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme8link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme8option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_nvme9link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_front_nvme9option_rom',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_front_slot5link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_front_slot6link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_gpu1state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_gpu2state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_gpu3state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_gpu4state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_gpu5state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_gpu6state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_gpu7state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_gpu8state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_hba_link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_hba_state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot_lom1link',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_lom2link',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_mezz_state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot_mlom_link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_mlom_state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot_mraid_link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_mraid_state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n10state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n11state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n12state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n13state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n14state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n15state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n16state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n17state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n18state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n19state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n1state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot_n20state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n21state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n22state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n23state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n24state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n2state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot_n3state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n4state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n5state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n6state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n7state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n8state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_n9state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_raid_link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_raid_state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_rear_nvme1link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_rear_nvme1state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_rear_nvme2link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_rear_nvme2state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_rear_nvme3link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_rear_nvme3state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_rear_nvme4link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
            'GEN4': "GEN4",
        },
        ('slot_rear_nvme4state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_rear_nvme5state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_rear_nvme6state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_rear_nvme7state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_rear_nvme8state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('slot_riser1link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_riser1slot1link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_riser1slot2link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_riser1slot3link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_riser2link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_riser2slot4link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_riser2slot5link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_riser2slot6link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_sas_state',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
            'LEGACY_ONLY': "Legacy Only",
            'UEFI_ONLY': "UEFI Only",
        },
        ('slot_ssd_slot1link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('slot_ssd_slot2link_speed',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "Disabled",
            'GEN1': "GEN1",
            'GEN2': "GEN2",
            'GEN3': "GEN3",
        },
        ('smee',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('smt_mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'OFF': "Off",
        },
        ('snc',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('snoopy_mode_for2lm',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('snoopy_mode_for_ad',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('sparing_mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DIMM-SPARING': "dimm-sparing",
            'RANK-SPARING': "rank-sparing",
        },
        ('sr_iov',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('streamer_prefetch',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('svm_mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('terminal_type',): {
            'PLATFORM-DEFAULT': "platform-default",
            'PC-ANSI': "pc-ansi",
            'VT100': "vt100",
            'VT100-PLUS': "vt100-plus",
            'VT-UTF8': "vt-utf8",
        },
        ('tpm_control',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('tpm_pending_operation',): {
            'PLATFORM-DEFAULT': "platform-default",
            'NONE': "None",
            'TPMCLEAR': "TpmClear",
        },
        ('tpm_ppi_required',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('tpm_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('tsme',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('txt_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('ucsm_boot_order_rule',): {
            'PLATFORM-DEFAULT': "platform-default",
            'LOOSE': "Loose",
            'STRICT': "Strict",
        },
        ('ufs_disable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('uma_based_clustering',): {
            'PLATFORM-DEFAULT': "platform-default",
            'DISABLE_(ALL2ALL)': "Disable (All2All)",
            'HEMISPHERE_(2-CLUSTERS)': "Hemisphere (2-clusters)",
        },
        ('upi_link_enablement',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1': "1",
            '2': "2",
            'AUTO': "Auto",
        },
        ('upi_power_management',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('usb_emul6064',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('usb_port_front',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('usb_port_internal',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('usb_port_kvm',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('usb_port_rear',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('usb_port_sd_card',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('usb_port_vmedia',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('usb_xhci_support',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('vga_priority',): {
            'PLATFORM-DEFAULT': "platform-default",
            'OFFBOARD': "Offboard",
            'ONBOARD': "Onboard",
            'ONBOARD_VGA_DISABLED': "Onboard VGA Disabled",
        },
        ('virtual_numa',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('vmd_enable',): {
            'PLATFORM-DEFAULT': "platform-default",
            'ENABLED': "enabled",
            'DISABLED': "disabled",
        },
        ('vol_memory_mode',): {
            'PLATFORM-DEFAULT': "platform-default",
            '1LM': "1LM",
            '2LM': "2LM",
        },
        ('work_load_config',): {
            'PLATFORM-DEFAULT': "platform-default",
            'BALANCED': "Balanced",
            'I/O_SENSITIVE': "I/O Sensitive",
            'NUMA': "NUMA",
            'UMA': "UMA",
        },
        ('xpt_prefetch',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
        ('xpt_remote_prefetch',): {
            'PLATFORM-DEFAULT': "platform-default",
            'AUTO': "Auto",
            'DISABLED': "disabled",
            'ENABLED': "enabled",
        },
    }

    validations = {
        ('cbs_dbg_cpu_snp_mem_size_cover',): {
            'regex': {
                'pattern': r'^(\d|[1-9]\d|[1-9]\d{2}|[1-9]\d{3}|[1-9]\d{4}|[1-9]\d{5}|10[0-3]\d{4}|104[0-7]\d{3}|1048[0-4]\d{2}|10485[0-6]\d|104857[0-6])$|^(platform-default)$',  # noqa: E501
            },
        },
        ('memory_size_limit',): {
            'regex': {
                'pattern': r'^(\d|[1-9]\d|[1-9]\d{2}|[1-9]\d{3}|[1-5]\d{4}|6[0-4]\d{3}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$|^(platform-default)$',  # noqa: E501
            },
        },
        ('partial_mirror_percent',): {
            'regex': {
                'pattern': r'^(\d\.\d{1,2}|[1-4]\d\.\d{1,2}|50\.[0]{1,2})$|^(platform-default)$',  # noqa: E501
            },
        },
        ('partial_mirror_value1',): {
            'regex': {
                'pattern': r'^(\d|[1-9]\d|[1-9]\d{2}|[1-9]\d{3}|[1-5]\d{4}|6[0-4]\d{3}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$|^(platform-default)$',  # noqa: E501
            },
        },
        ('partial_mirror_value2',): {
            'regex': {
                'pattern': r'^(\d|[1-9]\d|[1-9]\d{2}|[1-9]\d{3}|[1-5]\d{4}|6[0-4]\d{3}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$|^(platform-default)$',  # noqa: E501
            },
        },
        ('partial_mirror_value3',): {
            'regex': {
                'pattern': r'^(\d|[1-9]\d|[1-9]\d{2}|[1-9]\d{3}|[1-5]\d{4}|6[0-4]\d{3}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$|^(platform-default)$',  # noqa: E501
            },
        },
        ('partial_mirror_value4',): {
            'regex': {
                'pattern': r'^(\d|[1-9]\d|[1-9]\d{2}|[1-9]\d{3}|[1-5]\d{4}|6[0-4]\d{3}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$|^(platform-default)$',  # noqa: E501
            },
        },
        ('patrol_scrub_duration',): {
            'regex': {
                'pattern': r'^([5-9]|1\d|2[0-3])$|^(platform-default)$',  # noqa: E501
            },
        },
        ('sgx_epoch0',): {
            'regex': {
                'pattern': r'^([0-9a-fA-F]{1,16})$|^(platform-default)$',  # noqa: E501
            },
        },
        ('sgx_epoch1',): {
            'regex': {
                'pattern': r'^([0-9a-fA-F]{1,16})$|^(platform-default)$',  # noqa: E501
            },
        },
        ('sgx_le_pub_key_hash0',): {
            'regex': {
                'pattern': r'^([0-9a-fA-F]{1,16})$|^(platform-default)$',  # noqa: E501
            },
        },
        ('sgx_le_pub_key_hash1',): {
            'regex': {
                'pattern': r'^([0-9a-fA-F]{1,16})$|^(platform-default)$',  # noqa: E501
            },
        },
        ('sgx_le_pub_key_hash2',): {
            'regex': {
                'pattern': r'^([0-9a-fA-F]{1,16})$|^(platform-default)$',  # noqa: E501
            },
        },
        ('sgx_le_pub_key_hash3',): {
            'regex': {
                'pattern': r'^([0-9a-fA-F]{1,16})$|^(platform-default)$',  # noqa: E501
            },
        },
        ('description',): {
            'max_length': 1024,
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9]+[\x00-\xFF]*$',  # noqa: E501
            },
        },
        ('name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9_.:-]{1,64}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'acs_control_gpu1state': (str,),  # noqa: E501
            'acs_control_gpu2state': (str,),  # noqa: E501
            'acs_control_gpu3state': (str,),  # noqa: E501
            'acs_control_gpu4state': (str,),  # noqa: E501
            'acs_control_gpu5state': (str,),  # noqa: E501
            'acs_control_gpu6state': (str,),  # noqa: E501
            'acs_control_gpu7state': (str,),  # noqa: E501
            'acs_control_gpu8state': (str,),  # noqa: E501
            'acs_control_slot11state': (str,),  # noqa: E501
            'acs_control_slot12state': (str,),  # noqa: E501
            'acs_control_slot13state': (str,),  # noqa: E501
            'acs_control_slot14state': (str,),  # noqa: E501
            'adjacent_cache_line_prefetch': (str,),  # noqa: E501
            'advanced_mem_test': (str,),  # noqa: E501
            'all_usb_devices': (str,),  # noqa: E501
            'altitude': (str,),  # noqa: E501
            'aspm_support': (str,),  # noqa: E501
            'assert_nmi_on_perr': (str,),  # noqa: E501
            'assert_nmi_on_serr': (str,),  # noqa: E501
            'auto_cc_state': (str,),  # noqa: E501
            'autonumous_cstate_enable': (str,),  # noqa: E501
            'baud_rate': (str,),  # noqa: E501
            'bme_dma_mitigation': (str,),  # noqa: E501
            'boot_option_num_retry': (str,),  # noqa: E501
            'boot_option_re_cool_down': (str,),  # noqa: E501
            'boot_option_retry': (str,),  # noqa: E501
            'boot_performance_mode': (str,),  # noqa: E501
            'burst_and_postponed_refresh': (str,),  # noqa: E501
            'c1auto_demotion': (str,),  # noqa: E501
            'c1auto_un_demotion': (str,),  # noqa: E501
            'cbs_cmn_apbdis': (str,),  # noqa: E501
            'cbs_cmn_cpu_cpb': (str,),  # noqa: E501
            'cbs_cmn_cpu_gen_downcore_ctrl': (str,),  # noqa: E501
            'cbs_cmn_cpu_global_cstate_ctrl': (str,),  # noqa: E501
            'cbs_cmn_cpu_l1stream_hw_prefetcher': (str,),  # noqa: E501
            'cbs_cmn_cpu_l2stream_hw_prefetcher': (str,),  # noqa: E501
            'cbs_cmn_cpu_smee': (str,),  # noqa: E501
            'cbs_cmn_cpu_streaming_stores_ctrl': (str,),  # noqa: E501
            'cbs_cmn_determinism_slider': (str,),  # noqa: E501
            'cbs_cmn_efficiency_mode_en': (str,),  # noqa: E501
            'cbs_cmn_fixed_soc_pstate': (str,),  # noqa: E501
            'cbs_cmn_gnb_nb_iommu': (str,),  # noqa: E501
            'cbs_cmn_gnb_smu_df_cstates': (str,),  # noqa: E501
            'cbs_cmn_gnb_smucppc': (str,),  # noqa: E501
            'cbs_cmn_mem_ctrl_bank_group_swap_ddr4': (str,),  # noqa: E501
            'cbs_cmn_mem_map_bank_interleave_ddr4': (str,),  # noqa: E501
            'cbs_cmnc_tdp_ctl': (str,),  # noqa: E501
            'cbs_cpu_ccd_ctrl_ssp': (str,),  # noqa: E501
            'cbs_cpu_core_ctrl': (str,),  # noqa: E501
            'cbs_cpu_smt_ctrl': (str,),  # noqa: E501
            'cbs_dbg_cpu_snp_mem_cover': (str,),  # noqa: E501
            'cbs_dbg_cpu_snp_mem_size_cover': (str,),  # noqa: E501
            'cbs_df_cmn_acpi_srat_l3numa': (str,),  # noqa: E501
            'cbs_df_cmn_dram_nps': (str,),  # noqa: E501
            'cbs_df_cmn_mem_intlv': (str,),  # noqa: E501
            'cbs_df_cmn_mem_intlv_size': (str,),  # noqa: E501
            'cbs_sev_snp_support': (str,),  # noqa: E501
            'cdn_enable': (str,),  # noqa: E501
            'cdn_support': (str,),  # noqa: E501
            'channel_inter_leave': (str,),  # noqa: E501
            'cisco_adaptive_mem_training': (str,),  # noqa: E501
            'cisco_debug_level': (str,),  # noqa: E501
            'cisco_oprom_launch_optimization': (str,),  # noqa: E501
            'cisco_xgmi_max_speed': (str,),  # noqa: E501
            'cke_low_policy': (str,),  # noqa: E501
            'closed_loop_therm_throtl': (str,),  # noqa: E501
            'cmci_enable': (str,),  # noqa: E501
            'config_tdp': (str,),  # noqa: E501
            'config_tdp_level': (str,),  # noqa: E501
            'console_redirection': (str,),  # noqa: E501
            'core_multi_processing': (str,),  # noqa: E501
            'cpu_energy_performance': (str,),  # noqa: E501
            'cpu_frequency_floor': (str,),  # noqa: E501
            'cpu_pa_limit': (str,),  # noqa: E501
            'cpu_perf_enhancement': (str,),  # noqa: E501
            'cpu_performance': (str,),  # noqa: E501
            'cpu_power_management': (str,),  # noqa: E501
            'cr_qos': (str,),  # noqa: E501
            'crfastgo_config': (str,),  # noqa: E501
            'dcpmm_firmware_downgrade': (str,),  # noqa: E501
            'demand_scrub': (str,),  # noqa: E501
            'direct_cache_access': (str,),  # noqa: E501
            'dram_clock_throttling': (str,),  # noqa: E501
            'dram_refresh_rate': (str,),  # noqa: E501
            'dram_sw_thermal_throttling': (str,),  # noqa: E501
            'eadr_support': (str,),  # noqa: E501
            'edpc_en': (str,),  # noqa: E501
            'enable_clock_spread_spec': (str,),  # noqa: E501
            'enable_mktme': (str,),  # noqa: E501
            'enable_sgx': (str,),  # noqa: E501
            'enable_tme': (str,),  # noqa: E501
            'energy_efficient_turbo': (str,),  # noqa: E501
            'eng_perf_tuning': (str,),  # noqa: E501
            'enhanced_intel_speed_step_tech': (str,),  # noqa: E501
            'epoch_update': (str,),  # noqa: E501
            'epp_enable': (str,),  # noqa: E501
            'epp_profile': (str,),  # noqa: E501
            'execute_disable_bit': (str,),  # noqa: E501
            'extended_apic': (str,),  # noqa: E501
            'flow_control': (str,),  # noqa: E501
            'frb2enable': (str,),  # noqa: E501
            'hardware_prefetch': (str,),  # noqa: E501
            'hwpm_enable': (str,),  # noqa: E501
            'imc_interleave': (str,),  # noqa: E501
            'intel_dynamic_speed_select': (str,),  # noqa: E501
            'intel_hyper_threading_tech': (str,),  # noqa: E501
            'intel_speed_select': (str,),  # noqa: E501
            'intel_turbo_boost_tech': (str,),  # noqa: E501
            'intel_virtualization_technology': (str,),  # noqa: E501
            'intel_vt_for_directed_io': (str,),  # noqa: E501
            'intel_vtd_coherency_support': (str,),  # noqa: E501
            'intel_vtd_interrupt_remapping': (str,),  # noqa: E501
            'intel_vtd_pass_through_dma_support': (str,),  # noqa: E501
            'intel_vtdats_support': (str,),  # noqa: E501
            'ioh_error_enable': (str,),  # noqa: E501
            'ioh_resource': (str,),  # noqa: E501
            'ip_prefetch': (str,),  # noqa: E501
            'ipv4http': (str,),  # noqa: E501
            'ipv4pxe': (str,),  # noqa: E501
            'ipv6http': (str,),  # noqa: E501
            'ipv6pxe': (str,),  # noqa: E501
            'kti_prefetch': (str,),  # noqa: E501
            'legacy_os_redirection': (str,),  # noqa: E501
            'legacy_usb_support': (str,),  # noqa: E501
            'llc_alloc': (str,),  # noqa: E501
            'llc_prefetch': (str,),  # noqa: E501
            'lom_port0state': (str,),  # noqa: E501
            'lom_port1state': (str,),  # noqa: E501
            'lom_port2state': (str,),  # noqa: E501
            'lom_port3state': (str,),  # noqa: E501
            'lom_ports_all_state': (str,),  # noqa: E501
            'lv_ddr_mode': (str,),  # noqa: E501
            'make_device_non_bootable': (str,),  # noqa: E501
            'memory_bandwidth_boost': (str,),  # noqa: E501
            'memory_inter_leave': (str,),  # noqa: E501
            'memory_mapped_io_above4gb': (str,),  # noqa: E501
            'memory_refresh_rate': (str,),  # noqa: E501
            'memory_size_limit': (str,),  # noqa: E501
            'memory_thermal_throttling': (str,),  # noqa: E501
            'mirroring_mode': (str,),  # noqa: E501
            'mmcfg_base': (str,),  # noqa: E501
            'network_stack': (str,),  # noqa: E501
            'numa_optimized': (str,),  # noqa: E501
            'nvmdimm_perform_config': (str,),  # noqa: E501
            'onboard10gbit_lom': (str,),  # noqa: E501
            'onboard_gbit_lom': (str,),  # noqa: E501
            'onboard_scu_storage_support': (str,),  # noqa: E501
            'onboard_scu_storage_sw_stack': (str,),  # noqa: E501
            'operation_mode': (str,),  # noqa: E501
            'os_boot_watchdog_timer': (str,),  # noqa: E501
            'os_boot_watchdog_timer_policy': (str,),  # noqa: E501
            'os_boot_watchdog_timer_timeout': (str,),  # noqa: E501
            'out_of_band_mgmt_port': (str,),  # noqa: E501
            'package_cstate_limit': (str,),  # noqa: E501
            'panic_high_watermark': (str,),  # noqa: E501
            'partial_cache_line_sparing': (str,),  # noqa: E501
            'partial_mirror_mode_config': (str,),  # noqa: E501
            'partial_mirror_percent': (str,),  # noqa: E501
            'partial_mirror_value1': (str,),  # noqa: E501
            'partial_mirror_value2': (str,),  # noqa: E501
            'partial_mirror_value3': (str,),  # noqa: E501
            'partial_mirror_value4': (str,),  # noqa: E501
            'patrol_scrub': (str,),  # noqa: E501
            'patrol_scrub_duration': (str,),  # noqa: E501
            'pc_ie_ras_support': (str,),  # noqa: E501
            'pc_ie_ssd_hot_plug_support': (str,),  # noqa: E501
            'pch_usb30mode': (str,),  # noqa: E501
            'pci_option_ro_ms': (str,),  # noqa: E501
            'pci_rom_clp': (str,),  # noqa: E501
            'pcie_ari_support': (str,),  # noqa: E501
            'pcie_pll_ssc': (str,),  # noqa: E501
            'pcie_slot_mraid1link_speed': (str,),  # noqa: E501
            'pcie_slot_mraid1option_rom': (str,),  # noqa: E501
            'pcie_slot_mraid2link_speed': (str,),  # noqa: E501
            'pcie_slot_mraid2option_rom': (str,),  # noqa: E501
            'pcie_slot_mstorraid_link_speed': (str,),  # noqa: E501
            'pcie_slot_mstorraid_option_rom': (str,),  # noqa: E501
            'pcie_slot_nvme1link_speed': (str,),  # noqa: E501
            'pcie_slot_nvme1option_rom': (str,),  # noqa: E501
            'pcie_slot_nvme2link_speed': (str,),  # noqa: E501
            'pcie_slot_nvme2option_rom': (str,),  # noqa: E501
            'pcie_slot_nvme3link_speed': (str,),  # noqa: E501
            'pcie_slot_nvme3option_rom': (str,),  # noqa: E501
            'pcie_slot_nvme4link_speed': (str,),  # noqa: E501
            'pcie_slot_nvme4option_rom': (str,),  # noqa: E501
            'pcie_slot_nvme5link_speed': (str,),  # noqa: E501
            'pcie_slot_nvme5option_rom': (str,),  # noqa: E501
            'pcie_slot_nvme6link_speed': (str,),  # noqa: E501
            'pcie_slot_nvme6option_rom': (str,),  # noqa: E501
            'pcie_slots_cdn_enable': (str,),  # noqa: E501
            'pop_support': (str,),  # noqa: E501
            'post_error_pause': (str,),  # noqa: E501
            'post_package_repair': (str,),  # noqa: E501
            'processor_c1e': (str,),  # noqa: E501
            'processor_c3report': (str,),  # noqa: E501
            'processor_c6report': (str,),  # noqa: E501
            'processor_cstate': (str,),  # noqa: E501
            'psata': (str,),  # noqa: E501
            'pstate_coord_type': (str,),  # noqa: E501
            'putty_key_pad': (str,),  # noqa: E501
            'pwr_perf_tuning': (str,),  # noqa: E501
            'qpi_link_frequency': (str,),  # noqa: E501
            'qpi_link_speed': (str,),  # noqa: E501
            'qpi_snoop_mode': (str,),  # noqa: E501
            'rank_inter_leave': (str,),  # noqa: E501
            'redirection_after_post': (str,),  # noqa: E501
            'sata_mode_select': (str,),  # noqa: E501
            'select_memory_ras_configuration': (str,),  # noqa: E501
            'select_ppr_type': (str,),  # noqa: E501
            'serial_port_aenable': (str,),  # noqa: E501
            'sev': (str,),  # noqa: E501
            'sgx_auto_registration_agent': (str,),  # noqa: E501
            'sgx_epoch0': (str,),  # noqa: E501
            'sgx_epoch1': (str,),  # noqa: E501
            'sgx_factory_reset': (str,),  # noqa: E501
            'sgx_le_pub_key_hash0': (str,),  # noqa: E501
            'sgx_le_pub_key_hash1': (str,),  # noqa: E501
            'sgx_le_pub_key_hash2': (str,),  # noqa: E501
            'sgx_le_pub_key_hash3': (str,),  # noqa: E501
            'sgx_le_wr': (str,),  # noqa: E501
            'sgx_package_info_in_band_access': (str,),  # noqa: E501
            'sgx_qos': (str,),  # noqa: E501
            'sha1pcr_bank': (str,),  # noqa: E501
            'sha256pcr_bank': (str,),  # noqa: E501
            'single_pctl_enable': (str,),  # noqa: E501
            'slot10link_speed': (str,),  # noqa: E501
            'slot10state': (str,),  # noqa: E501
            'slot11link_speed': (str,),  # noqa: E501
            'slot11state': (str,),  # noqa: E501
            'slot12link_speed': (str,),  # noqa: E501
            'slot12state': (str,),  # noqa: E501
            'slot13state': (str,),  # noqa: E501
            'slot14state': (str,),  # noqa: E501
            'slot1link_speed': (str,),  # noqa: E501
            'slot1state': (str,),  # noqa: E501
            'slot2link_speed': (str,),  # noqa: E501
            'slot2state': (str,),  # noqa: E501
            'slot3link_speed': (str,),  # noqa: E501
            'slot3state': (str,),  # noqa: E501
            'slot4link_speed': (str,),  # noqa: E501
            'slot4state': (str,),  # noqa: E501
            'slot5link_speed': (str,),  # noqa: E501
            'slot5state': (str,),  # noqa: E501
            'slot6link_speed': (str,),  # noqa: E501
            'slot6state': (str,),  # noqa: E501
            'slot7link_speed': (str,),  # noqa: E501
            'slot7state': (str,),  # noqa: E501
            'slot8link_speed': (str,),  # noqa: E501
            'slot8state': (str,),  # noqa: E501
            'slot9link_speed': (str,),  # noqa: E501
            'slot9state': (str,),  # noqa: E501
            'slot_flom_link_speed': (str,),  # noqa: E501
            'slot_front_nvme10link_speed': (str,),  # noqa: E501
            'slot_front_nvme10option_rom': (str,),  # noqa: E501
            'slot_front_nvme11link_speed': (str,),  # noqa: E501
            'slot_front_nvme11option_rom': (str,),  # noqa: E501
            'slot_front_nvme12link_speed': (str,),  # noqa: E501
            'slot_front_nvme12option_rom': (str,),  # noqa: E501
            'slot_front_nvme13option_rom': (str,),  # noqa: E501
            'slot_front_nvme14option_rom': (str,),  # noqa: E501
            'slot_front_nvme15option_rom': (str,),  # noqa: E501
            'slot_front_nvme16option_rom': (str,),  # noqa: E501
            'slot_front_nvme17option_rom': (str,),  # noqa: E501
            'slot_front_nvme18option_rom': (str,),  # noqa: E501
            'slot_front_nvme19option_rom': (str,),  # noqa: E501
            'slot_front_nvme1link_speed': (str,),  # noqa: E501
            'slot_front_nvme1option_rom': (str,),  # noqa: E501
            'slot_front_nvme20option_rom': (str,),  # noqa: E501
            'slot_front_nvme21option_rom': (str,),  # noqa: E501
            'slot_front_nvme22option_rom': (str,),  # noqa: E501
            'slot_front_nvme23option_rom': (str,),  # noqa: E501
            'slot_front_nvme24option_rom': (str,),  # noqa: E501
            'slot_front_nvme2link_speed': (str,),  # noqa: E501
            'slot_front_nvme2option_rom': (str,),  # noqa: E501
            'slot_front_nvme3link_speed': (str,),  # noqa: E501
            'slot_front_nvme3option_rom': (str,),  # noqa: E501
            'slot_front_nvme4link_speed': (str,),  # noqa: E501
            'slot_front_nvme4option_rom': (str,),  # noqa: E501
            'slot_front_nvme5link_speed': (str,),  # noqa: E501
            'slot_front_nvme5option_rom': (str,),  # noqa: E501
            'slot_front_nvme6link_speed': (str,),  # noqa: E501
            'slot_front_nvme6option_rom': (str,),  # noqa: E501
            'slot_front_nvme7link_speed': (str,),  # noqa: E501
            'slot_front_nvme7option_rom': (str,),  # noqa: E501
            'slot_front_nvme8link_speed': (str,),  # noqa: E501
            'slot_front_nvme8option_rom': (str,),  # noqa: E501
            'slot_front_nvme9link_speed': (str,),  # noqa: E501
            'slot_front_nvme9option_rom': (str,),  # noqa: E501
            'slot_front_slot5link_speed': (str,),  # noqa: E501
            'slot_front_slot6link_speed': (str,),  # noqa: E501
            'slot_gpu1state': (str,),  # noqa: E501
            'slot_gpu2state': (str,),  # noqa: E501
            'slot_gpu3state': (str,),  # noqa: E501
            'slot_gpu4state': (str,),  # noqa: E501
            'slot_gpu5state': (str,),  # noqa: E501
            'slot_gpu6state': (str,),  # noqa: E501
            'slot_gpu7state': (str,),  # noqa: E501
            'slot_gpu8state': (str,),  # noqa: E501
            'slot_hba_link_speed': (str,),  # noqa: E501
            'slot_hba_state': (str,),  # noqa: E501
            'slot_lom1link': (str,),  # noqa: E501
            'slot_lom2link': (str,),  # noqa: E501
            'slot_mezz_state': (str,),  # noqa: E501
            'slot_mlom_link_speed': (str,),  # noqa: E501
            'slot_mlom_state': (str,),  # noqa: E501
            'slot_mraid_link_speed': (str,),  # noqa: E501
            'slot_mraid_state': (str,),  # noqa: E501
            'slot_n10state': (str,),  # noqa: E501
            'slot_n11state': (str,),  # noqa: E501
            'slot_n12state': (str,),  # noqa: E501
            'slot_n13state': (str,),  # noqa: E501
            'slot_n14state': (str,),  # noqa: E501
            'slot_n15state': (str,),  # noqa: E501
            'slot_n16state': (str,),  # noqa: E501
            'slot_n17state': (str,),  # noqa: E501
            'slot_n18state': (str,),  # noqa: E501
            'slot_n19state': (str,),  # noqa: E501
            'slot_n1state': (str,),  # noqa: E501
            'slot_n20state': (str,),  # noqa: E501
            'slot_n21state': (str,),  # noqa: E501
            'slot_n22state': (str,),  # noqa: E501
            'slot_n23state': (str,),  # noqa: E501
            'slot_n24state': (str,),  # noqa: E501
            'slot_n2state': (str,),  # noqa: E501
            'slot_n3state': (str,),  # noqa: E501
            'slot_n4state': (str,),  # noqa: E501
            'slot_n5state': (str,),  # noqa: E501
            'slot_n6state': (str,),  # noqa: E501
            'slot_n7state': (str,),  # noqa: E501
            'slot_n8state': (str,),  # noqa: E501
            'slot_n9state': (str,),  # noqa: E501
            'slot_raid_link_speed': (str,),  # noqa: E501
            'slot_raid_state': (str,),  # noqa: E501
            'slot_rear_nvme1link_speed': (str,),  # noqa: E501
            'slot_rear_nvme1state': (str,),  # noqa: E501
            'slot_rear_nvme2link_speed': (str,),  # noqa: E501
            'slot_rear_nvme2state': (str,),  # noqa: E501
            'slot_rear_nvme3link_speed': (str,),  # noqa: E501
            'slot_rear_nvme3state': (str,),  # noqa: E501
            'slot_rear_nvme4link_speed': (str,),  # noqa: E501
            'slot_rear_nvme4state': (str,),  # noqa: E501
            'slot_rear_nvme5state': (str,),  # noqa: E501
            'slot_rear_nvme6state': (str,),  # noqa: E501
            'slot_rear_nvme7state': (str,),  # noqa: E501
            'slot_rear_nvme8state': (str,),  # noqa: E501
            'slot_riser1link_speed': (str,),  # noqa: E501
            'slot_riser1slot1link_speed': (str,),  # noqa: E501
            'slot_riser1slot2link_speed': (str,),  # noqa: E501
            'slot_riser1slot3link_speed': (str,),  # noqa: E501
            'slot_riser2link_speed': (str,),  # noqa: E501
            'slot_riser2slot4link_speed': (str,),  # noqa: E501
            'slot_riser2slot5link_speed': (str,),  # noqa: E501
            'slot_riser2slot6link_speed': (str,),  # noqa: E501
            'slot_sas_state': (str,),  # noqa: E501
            'slot_ssd_slot1link_speed': (str,),  # noqa: E501
            'slot_ssd_slot2link_speed': (str,),  # noqa: E501
            'smee': (str,),  # noqa: E501
            'smt_mode': (str,),  # noqa: E501
            'snc': (str,),  # noqa: E501
            'snoopy_mode_for2lm': (str,),  # noqa: E501
            'snoopy_mode_for_ad': (str,),  # noqa: E501
            'sparing_mode': (str,),  # noqa: E501
            'sr_iov': (str,),  # noqa: E501
            'streamer_prefetch': (str,),  # noqa: E501
            'svm_mode': (str,),  # noqa: E501
            'terminal_type': (str,),  # noqa: E501
            'tpm_control': (str,),  # noqa: E501
            'tpm_pending_operation': (str,),  # noqa: E501
            'tpm_ppi_required': (str,),  # noqa: E501
            'tpm_support': (str,),  # noqa: E501
            'tsme': (str,),  # noqa: E501
            'txt_support': (str,),  # noqa: E501
            'ucsm_boot_order_rule': (str,),  # noqa: E501
            'ufs_disable': (str,),  # noqa: E501
            'uma_based_clustering': (str,),  # noqa: E501
            'upi_link_enablement': (str,),  # noqa: E501
            'upi_power_management': (str,),  # noqa: E501
            'usb_emul6064': (str,),  # noqa: E501
            'usb_port_front': (str,),  # noqa: E501
            'usb_port_internal': (str,),  # noqa: E501
            'usb_port_kvm': (str,),  # noqa: E501
            'usb_port_rear': (str,),  # noqa: E501
            'usb_port_sd_card': (str,),  # noqa: E501
            'usb_port_vmedia': (str,),  # noqa: E501
            'usb_xhci_support': (str,),  # noqa: E501
            'vga_priority': (str,),  # noqa: E501
            'virtual_numa': (str,),  # noqa: E501
            'vmd_enable': (str,),  # noqa: E501
            'vol_memory_mode': (str,),  # noqa: E501
            'work_load_config': (str,),  # noqa: E501
            'xpt_prefetch': (str,),  # noqa: E501
            'xpt_remote_prefetch': (str,),  # noqa: E501
            'organization': (OrganizationOrganizationRelationship,),  # noqa: E501
            'profiles': ([PolicyAbstractConfigProfileRelationship], none_type,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'acs_control_gpu1state': 'AcsControlGpu1state',  # noqa: E501
        'acs_control_gpu2state': 'AcsControlGpu2state',  # noqa: E501
        'acs_control_gpu3state': 'AcsControlGpu3state',  # noqa: E501
        'acs_control_gpu4state': 'AcsControlGpu4state',  # noqa: E501
        'acs_control_gpu5state': 'AcsControlGpu5state',  # noqa: E501
        'acs_control_gpu6state': 'AcsControlGpu6state',  # noqa: E501
        'acs_control_gpu7state': 'AcsControlGpu7state',  # noqa: E501
        'acs_control_gpu8state': 'AcsControlGpu8state',  # noqa: E501
        'acs_control_slot11state': 'AcsControlSlot11state',  # noqa: E501
        'acs_control_slot12state': 'AcsControlSlot12state',  # noqa: E501
        'acs_control_slot13state': 'AcsControlSlot13state',  # noqa: E501
        'acs_control_slot14state': 'AcsControlSlot14state',  # noqa: E501
        'adjacent_cache_line_prefetch': 'AdjacentCacheLinePrefetch',  # noqa: E501
        'advanced_mem_test': 'AdvancedMemTest',  # noqa: E501
        'all_usb_devices': 'AllUsbDevices',  # noqa: E501
        'altitude': 'Altitude',  # noqa: E501
        'aspm_support': 'AspmSupport',  # noqa: E501
        'assert_nmi_on_perr': 'AssertNmiOnPerr',  # noqa: E501
        'assert_nmi_on_serr': 'AssertNmiOnSerr',  # noqa: E501
        'auto_cc_state': 'AutoCcState',  # noqa: E501
        'autonumous_cstate_enable': 'AutonumousCstateEnable',  # noqa: E501
        'baud_rate': 'BaudRate',  # noqa: E501
        'bme_dma_mitigation': 'BmeDmaMitigation',  # noqa: E501
        'boot_option_num_retry': 'BootOptionNumRetry',  # noqa: E501
        'boot_option_re_cool_down': 'BootOptionReCoolDown',  # noqa: E501
        'boot_option_retry': 'BootOptionRetry',  # noqa: E501
        'boot_performance_mode': 'BootPerformanceMode',  # noqa: E501
        'burst_and_postponed_refresh': 'BurstAndPostponedRefresh',  # noqa: E501
        'c1auto_demotion': 'C1autoDemotion',  # noqa: E501
        'c1auto_un_demotion': 'C1autoUnDemotion',  # noqa: E501
        'cbs_cmn_apbdis': 'CbsCmnApbdis',  # noqa: E501
        'cbs_cmn_cpu_cpb': 'CbsCmnCpuCpb',  # noqa: E501
        'cbs_cmn_cpu_gen_downcore_ctrl': 'CbsCmnCpuGenDowncoreCtrl',  # noqa: E501
        'cbs_cmn_cpu_global_cstate_ctrl': 'CbsCmnCpuGlobalCstateCtrl',  # noqa: E501
        'cbs_cmn_cpu_l1stream_hw_prefetcher': 'CbsCmnCpuL1streamHwPrefetcher',  # noqa: E501
        'cbs_cmn_cpu_l2stream_hw_prefetcher': 'CbsCmnCpuL2streamHwPrefetcher',  # noqa: E501
        'cbs_cmn_cpu_smee': 'CbsCmnCpuSmee',  # noqa: E501
        'cbs_cmn_cpu_streaming_stores_ctrl': 'CbsCmnCpuStreamingStoresCtrl',  # noqa: E501
        'cbs_cmn_determinism_slider': 'CbsCmnDeterminismSlider',  # noqa: E501
        'cbs_cmn_efficiency_mode_en': 'CbsCmnEfficiencyModeEn',  # noqa: E501
        'cbs_cmn_fixed_soc_pstate': 'CbsCmnFixedSocPstate',  # noqa: E501
        'cbs_cmn_gnb_nb_iommu': 'CbsCmnGnbNbIommu',  # noqa: E501
        'cbs_cmn_gnb_smu_df_cstates': 'CbsCmnGnbSmuDfCstates',  # noqa: E501
        'cbs_cmn_gnb_smucppc': 'CbsCmnGnbSmucppc',  # noqa: E501
        'cbs_cmn_mem_ctrl_bank_group_swap_ddr4': 'CbsCmnMemCtrlBankGroupSwapDdr4',  # noqa: E501
        'cbs_cmn_mem_map_bank_interleave_ddr4': 'CbsCmnMemMapBankInterleaveDdr4',  # noqa: E501
        'cbs_cmnc_tdp_ctl': 'CbsCmncTdpCtl',  # noqa: E501
        'cbs_cpu_ccd_ctrl_ssp': 'CbsCpuCcdCtrlSsp',  # noqa: E501
        'cbs_cpu_core_ctrl': 'CbsCpuCoreCtrl',  # noqa: E501
        'cbs_cpu_smt_ctrl': 'CbsCpuSmtCtrl',  # noqa: E501
        'cbs_dbg_cpu_snp_mem_cover': 'CbsDbgCpuSnpMemCover',  # noqa: E501
        'cbs_dbg_cpu_snp_mem_size_cover': 'CbsDbgCpuSnpMemSizeCover',  # noqa: E501
        'cbs_df_cmn_acpi_srat_l3numa': 'CbsDfCmnAcpiSratL3numa',  # noqa: E501
        'cbs_df_cmn_dram_nps': 'CbsDfCmnDramNps',  # noqa: E501
        'cbs_df_cmn_mem_intlv': 'CbsDfCmnMemIntlv',  # noqa: E501
        'cbs_df_cmn_mem_intlv_size': 'CbsDfCmnMemIntlvSize',  # noqa: E501
        'cbs_sev_snp_support': 'CbsSevSnpSupport',  # noqa: E501
        'cdn_enable': 'CdnEnable',  # noqa: E501
        'cdn_support': 'CdnSupport',  # noqa: E501
        'channel_inter_leave': 'ChannelInterLeave',  # noqa: E501
        'cisco_adaptive_mem_training': 'CiscoAdaptiveMemTraining',  # noqa: E501
        'cisco_debug_level': 'CiscoDebugLevel',  # noqa: E501
        'cisco_oprom_launch_optimization': 'CiscoOpromLaunchOptimization',  # noqa: E501
        'cisco_xgmi_max_speed': 'CiscoXgmiMaxSpeed',  # noqa: E501
        'cke_low_policy': 'CkeLowPolicy',  # noqa: E501
        'closed_loop_therm_throtl': 'ClosedLoopThermThrotl',  # noqa: E501
        'cmci_enable': 'CmciEnable',  # noqa: E501
        'config_tdp': 'ConfigTdp',  # noqa: E501
        'config_tdp_level': 'ConfigTdpLevel',  # noqa: E501
        'console_redirection': 'ConsoleRedirection',  # noqa: E501
        'core_multi_processing': 'CoreMultiProcessing',  # noqa: E501
        'cpu_energy_performance': 'CpuEnergyPerformance',  # noqa: E501
        'cpu_frequency_floor': 'CpuFrequencyFloor',  # noqa: E501
        'cpu_pa_limit': 'CpuPaLimit',  # noqa: E501
        'cpu_perf_enhancement': 'CpuPerfEnhancement',  # noqa: E501
        'cpu_performance': 'CpuPerformance',  # noqa: E501
        'cpu_power_management': 'CpuPowerManagement',  # noqa: E501
        'cr_qos': 'CrQos',  # noqa: E501
        'crfastgo_config': 'CrfastgoConfig',  # noqa: E501
        'dcpmm_firmware_downgrade': 'DcpmmFirmwareDowngrade',  # noqa: E501
        'demand_scrub': 'DemandScrub',  # noqa: E501
        'direct_cache_access': 'DirectCacheAccess',  # noqa: E501
        'dram_clock_throttling': 'DramClockThrottling',  # noqa: E501
        'dram_refresh_rate': 'DramRefreshRate',  # noqa: E501
        'dram_sw_thermal_throttling': 'DramSwThermalThrottling',  # noqa: E501
        'eadr_support': 'EadrSupport',  # noqa: E501
        'edpc_en': 'EdpcEn',  # noqa: E501
        'enable_clock_spread_spec': 'EnableClockSpreadSpec',  # noqa: E501
        'enable_mktme': 'EnableMktme',  # noqa: E501
        'enable_sgx': 'EnableSgx',  # noqa: E501
        'enable_tme': 'EnableTme',  # noqa: E501
        'energy_efficient_turbo': 'EnergyEfficientTurbo',  # noqa: E501
        'eng_perf_tuning': 'EngPerfTuning',  # noqa: E501
        'enhanced_intel_speed_step_tech': 'EnhancedIntelSpeedStepTech',  # noqa: E501
        'epoch_update': 'EpochUpdate',  # noqa: E501
        'epp_enable': 'EppEnable',  # noqa: E501
        'epp_profile': 'EppProfile',  # noqa: E501
        'execute_disable_bit': 'ExecuteDisableBit',  # noqa: E501
        'extended_apic': 'ExtendedApic',  # noqa: E501
        'flow_control': 'FlowControl',  # noqa: E501
        'frb2enable': 'Frb2enable',  # noqa: E501
        'hardware_prefetch': 'HardwarePrefetch',  # noqa: E501
        'hwpm_enable': 'HwpmEnable',  # noqa: E501
        'imc_interleave': 'ImcInterleave',  # noqa: E501
        'intel_dynamic_speed_select': 'IntelDynamicSpeedSelect',  # noqa: E501
        'intel_hyper_threading_tech': 'IntelHyperThreadingTech',  # noqa: E501
        'intel_speed_select': 'IntelSpeedSelect',  # noqa: E501
        'intel_turbo_boost_tech': 'IntelTurboBoostTech',  # noqa: E501
        'intel_virtualization_technology': 'IntelVirtualizationTechnology',  # noqa: E501
        'intel_vt_for_directed_io': 'IntelVtForDirectedIo',  # noqa: E501
        'intel_vtd_coherency_support': 'IntelVtdCoherencySupport',  # noqa: E501
        'intel_vtd_interrupt_remapping': 'IntelVtdInterruptRemapping',  # noqa: E501
        'intel_vtd_pass_through_dma_support': 'IntelVtdPassThroughDmaSupport',  # noqa: E501
        'intel_vtdats_support': 'IntelVtdatsSupport',  # noqa: E501
        'ioh_error_enable': 'IohErrorEnable',  # noqa: E501
        'ioh_resource': 'IohResource',  # noqa: E501
        'ip_prefetch': 'IpPrefetch',  # noqa: E501
        'ipv4http': 'Ipv4http',  # noqa: E501
        'ipv4pxe': 'Ipv4pxe',  # noqa: E501
        'ipv6http': 'Ipv6http',  # noqa: E501
        'ipv6pxe': 'Ipv6pxe',  # noqa: E501
        'kti_prefetch': 'KtiPrefetch',  # noqa: E501
        'legacy_os_redirection': 'LegacyOsRedirection',  # noqa: E501
        'legacy_usb_support': 'LegacyUsbSupport',  # noqa: E501
        'llc_alloc': 'LlcAlloc',  # noqa: E501
        'llc_prefetch': 'LlcPrefetch',  # noqa: E501
        'lom_port0state': 'LomPort0state',  # noqa: E501
        'lom_port1state': 'LomPort1state',  # noqa: E501
        'lom_port2state': 'LomPort2state',  # noqa: E501
        'lom_port3state': 'LomPort3state',  # noqa: E501
        'lom_ports_all_state': 'LomPortsAllState',  # noqa: E501
        'lv_ddr_mode': 'LvDdrMode',  # noqa: E501
        'make_device_non_bootable': 'MakeDeviceNonBootable',  # noqa: E501
        'memory_bandwidth_boost': 'MemoryBandwidthBoost',  # noqa: E501
        'memory_inter_leave': 'MemoryInterLeave',  # noqa: E501
        'memory_mapped_io_above4gb': 'MemoryMappedIoAbove4gb',  # noqa: E501
        'memory_refresh_rate': 'MemoryRefreshRate',  # noqa: E501
        'memory_size_limit': 'MemorySizeLimit',  # noqa: E501
        'memory_thermal_throttling': 'MemoryThermalThrottling',  # noqa: E501
        'mirroring_mode': 'MirroringMode',  # noqa: E501
        'mmcfg_base': 'MmcfgBase',  # noqa: E501
        'network_stack': 'NetworkStack',  # noqa: E501
        'numa_optimized': 'NumaOptimized',  # noqa: E501
        'nvmdimm_perform_config': 'NvmdimmPerformConfig',  # noqa: E501
        'onboard10gbit_lom': 'Onboard10gbitLom',  # noqa: E501
        'onboard_gbit_lom': 'OnboardGbitLom',  # noqa: E501
        'onboard_scu_storage_support': 'OnboardScuStorageSupport',  # noqa: E501
        'onboard_scu_storage_sw_stack': 'OnboardScuStorageSwStack',  # noqa: E501
        'operation_mode': 'OperationMode',  # noqa: E501
        'os_boot_watchdog_timer': 'OsBootWatchdogTimer',  # noqa: E501
        'os_boot_watchdog_timer_policy': 'OsBootWatchdogTimerPolicy',  # noqa: E501
        'os_boot_watchdog_timer_timeout': 'OsBootWatchdogTimerTimeout',  # noqa: E501
        'out_of_band_mgmt_port': 'OutOfBandMgmtPort',  # noqa: E501
        'package_cstate_limit': 'PackageCstateLimit',  # noqa: E501
        'panic_high_watermark': 'PanicHighWatermark',  # noqa: E501
        'partial_cache_line_sparing': 'PartialCacheLineSparing',  # noqa: E501
        'partial_mirror_mode_config': 'PartialMirrorModeConfig',  # noqa: E501
        'partial_mirror_percent': 'PartialMirrorPercent',  # noqa: E501
        'partial_mirror_value1': 'PartialMirrorValue1',  # noqa: E501
        'partial_mirror_value2': 'PartialMirrorValue2',  # noqa: E501
        'partial_mirror_value3': 'PartialMirrorValue3',  # noqa: E501
        'partial_mirror_value4': 'PartialMirrorValue4',  # noqa: E501
        'patrol_scrub': 'PatrolScrub',  # noqa: E501
        'patrol_scrub_duration': 'PatrolScrubDuration',  # noqa: E501
        'pc_ie_ras_support': 'PcIeRasSupport',  # noqa: E501
        'pc_ie_ssd_hot_plug_support': 'PcIeSsdHotPlugSupport',  # noqa: E501
        'pch_usb30mode': 'PchUsb30mode',  # noqa: E501
        'pci_option_ro_ms': 'PciOptionRoMs',  # noqa: E501
        'pci_rom_clp': 'PciRomClp',  # noqa: E501
        'pcie_ari_support': 'PcieAriSupport',  # noqa: E501
        'pcie_pll_ssc': 'PciePllSsc',  # noqa: E501
        'pcie_slot_mraid1link_speed': 'PcieSlotMraid1linkSpeed',  # noqa: E501
        'pcie_slot_mraid1option_rom': 'PcieSlotMraid1optionRom',  # noqa: E501
        'pcie_slot_mraid2link_speed': 'PcieSlotMraid2linkSpeed',  # noqa: E501
        'pcie_slot_mraid2option_rom': 'PcieSlotMraid2optionRom',  # noqa: E501
        'pcie_slot_mstorraid_link_speed': 'PcieSlotMstorraidLinkSpeed',  # noqa: E501
        'pcie_slot_mstorraid_option_rom': 'PcieSlotMstorraidOptionRom',  # noqa: E501
        'pcie_slot_nvme1link_speed': 'PcieSlotNvme1linkSpeed',  # noqa: E501
        'pcie_slot_nvme1option_rom': 'PcieSlotNvme1optionRom',  # noqa: E501
        'pcie_slot_nvme2link_speed': 'PcieSlotNvme2linkSpeed',  # noqa: E501
        'pcie_slot_nvme2option_rom': 'PcieSlotNvme2optionRom',  # noqa: E501
        'pcie_slot_nvme3link_speed': 'PcieSlotNvme3linkSpeed',  # noqa: E501
        'pcie_slot_nvme3option_rom': 'PcieSlotNvme3optionRom',  # noqa: E501
        'pcie_slot_nvme4link_speed': 'PcieSlotNvme4linkSpeed',  # noqa: E501
        'pcie_slot_nvme4option_rom': 'PcieSlotNvme4optionRom',  # noqa: E501
        'pcie_slot_nvme5link_speed': 'PcieSlotNvme5linkSpeed',  # noqa: E501
        'pcie_slot_nvme5option_rom': 'PcieSlotNvme5optionRom',  # noqa: E501
        'pcie_slot_nvme6link_speed': 'PcieSlotNvme6linkSpeed',  # noqa: E501
        'pcie_slot_nvme6option_rom': 'PcieSlotNvme6optionRom',  # noqa: E501
        'pcie_slots_cdn_enable': 'PcieSlotsCdnEnable',  # noqa: E501
        'pop_support': 'PopSupport',  # noqa: E501
        'post_error_pause': 'PostErrorPause',  # noqa: E501
        'post_package_repair': 'PostPackageRepair',  # noqa: E501
        'processor_c1e': 'ProcessorC1e',  # noqa: E501
        'processor_c3report': 'ProcessorC3report',  # noqa: E501
        'processor_c6report': 'ProcessorC6report',  # noqa: E501
        'processor_cstate': 'ProcessorCstate',  # noqa: E501
        'psata': 'Psata',  # noqa: E501
        'pstate_coord_type': 'PstateCoordType',  # noqa: E501
        'putty_key_pad': 'PuttyKeyPad',  # noqa: E501
        'pwr_perf_tuning': 'PwrPerfTuning',  # noqa: E501
        'qpi_link_frequency': 'QpiLinkFrequency',  # noqa: E501
        'qpi_link_speed': 'QpiLinkSpeed',  # noqa: E501
        'qpi_snoop_mode': 'QpiSnoopMode',  # noqa: E501
        'rank_inter_leave': 'RankInterLeave',  # noqa: E501
        'redirection_after_post': 'RedirectionAfterPost',  # noqa: E501
        'sata_mode_select': 'SataModeSelect',  # noqa: E501
        'select_memory_ras_configuration': 'SelectMemoryRasConfiguration',  # noqa: E501
        'select_ppr_type': 'SelectPprType',  # noqa: E501
        'serial_port_aenable': 'SerialPortAenable',  # noqa: E501
        'sev': 'Sev',  # noqa: E501
        'sgx_auto_registration_agent': 'SgxAutoRegistrationAgent',  # noqa: E501
        'sgx_epoch0': 'SgxEpoch0',  # noqa: E501
        'sgx_epoch1': 'SgxEpoch1',  # noqa: E501
        'sgx_factory_reset': 'SgxFactoryReset',  # noqa: E501
        'sgx_le_pub_key_hash0': 'SgxLePubKeyHash0',  # noqa: E501
        'sgx_le_pub_key_hash1': 'SgxLePubKeyHash1',  # noqa: E501
        'sgx_le_pub_key_hash2': 'SgxLePubKeyHash2',  # noqa: E501
        'sgx_le_pub_key_hash3': 'SgxLePubKeyHash3',  # noqa: E501
        'sgx_le_wr': 'SgxLeWr',  # noqa: E501
        'sgx_package_info_in_band_access': 'SgxPackageInfoInBandAccess',  # noqa: E501
        'sgx_qos': 'SgxQos',  # noqa: E501
        'sha1pcr_bank': 'Sha1pcrBank',  # noqa: E501
        'sha256pcr_bank': 'Sha256pcrBank',  # noqa: E501
        'single_pctl_enable': 'SinglePctlEnable',  # noqa: E501
        'slot10link_speed': 'Slot10linkSpeed',  # noqa: E501
        'slot10state': 'Slot10state',  # noqa: E501
        'slot11link_speed': 'Slot11linkSpeed',  # noqa: E501
        'slot11state': 'Slot11state',  # noqa: E501
        'slot12link_speed': 'Slot12linkSpeed',  # noqa: E501
        'slot12state': 'Slot12state',  # noqa: E501
        'slot13state': 'Slot13state',  # noqa: E501
        'slot14state': 'Slot14state',  # noqa: E501
        'slot1link_speed': 'Slot1linkSpeed',  # noqa: E501
        'slot1state': 'Slot1state',  # noqa: E501
        'slot2link_speed': 'Slot2linkSpeed',  # noqa: E501
        'slot2state': 'Slot2state',  # noqa: E501
        'slot3link_speed': 'Slot3linkSpeed',  # noqa: E501
        'slot3state': 'Slot3state',  # noqa: E501
        'slot4link_speed': 'Slot4linkSpeed',  # noqa: E501
        'slot4state': 'Slot4state',  # noqa: E501
        'slot5link_speed': 'Slot5linkSpeed',  # noqa: E501
        'slot5state': 'Slot5state',  # noqa: E501
        'slot6link_speed': 'Slot6linkSpeed',  # noqa: E501
        'slot6state': 'Slot6state',  # noqa: E501
        'slot7link_speed': 'Slot7linkSpeed',  # noqa: E501
        'slot7state': 'Slot7state',  # noqa: E501
        'slot8link_speed': 'Slot8linkSpeed',  # noqa: E501
        'slot8state': 'Slot8state',  # noqa: E501
        'slot9link_speed': 'Slot9linkSpeed',  # noqa: E501
        'slot9state': 'Slot9state',  # noqa: E501
        'slot_flom_link_speed': 'SlotFlomLinkSpeed',  # noqa: E501
        'slot_front_nvme10link_speed': 'SlotFrontNvme10linkSpeed',  # noqa: E501
        'slot_front_nvme10option_rom': 'SlotFrontNvme10optionRom',  # noqa: E501
        'slot_front_nvme11link_speed': 'SlotFrontNvme11linkSpeed',  # noqa: E501
        'slot_front_nvme11option_rom': 'SlotFrontNvme11optionRom',  # noqa: E501
        'slot_front_nvme12link_speed': 'SlotFrontNvme12linkSpeed',  # noqa: E501
        'slot_front_nvme12option_rom': 'SlotFrontNvme12optionRom',  # noqa: E501
        'slot_front_nvme13option_rom': 'SlotFrontNvme13optionRom',  # noqa: E501
        'slot_front_nvme14option_rom': 'SlotFrontNvme14optionRom',  # noqa: E501
        'slot_front_nvme15option_rom': 'SlotFrontNvme15optionRom',  # noqa: E501
        'slot_front_nvme16option_rom': 'SlotFrontNvme16optionRom',  # noqa: E501
        'slot_front_nvme17option_rom': 'SlotFrontNvme17optionRom',  # noqa: E501
        'slot_front_nvme18option_rom': 'SlotFrontNvme18optionRom',  # noqa: E501
        'slot_front_nvme19option_rom': 'SlotFrontNvme19optionRom',  # noqa: E501
        'slot_front_nvme1link_speed': 'SlotFrontNvme1linkSpeed',  # noqa: E501
        'slot_front_nvme1option_rom': 'SlotFrontNvme1optionRom',  # noqa: E501
        'slot_front_nvme20option_rom': 'SlotFrontNvme20optionRom',  # noqa: E501
        'slot_front_nvme21option_rom': 'SlotFrontNvme21optionRom',  # noqa: E501
        'slot_front_nvme22option_rom': 'SlotFrontNvme22optionRom',  # noqa: E501
        'slot_front_nvme23option_rom': 'SlotFrontNvme23optionRom',  # noqa: E501
        'slot_front_nvme24option_rom': 'SlotFrontNvme24optionRom',  # noqa: E501
        'slot_front_nvme2link_speed': 'SlotFrontNvme2linkSpeed',  # noqa: E501
        'slot_front_nvme2option_rom': 'SlotFrontNvme2optionRom',  # noqa: E501
        'slot_front_nvme3link_speed': 'SlotFrontNvme3linkSpeed',  # noqa: E501
        'slot_front_nvme3option_rom': 'SlotFrontNvme3optionRom',  # noqa: E501
        'slot_front_nvme4link_speed': 'SlotFrontNvme4linkSpeed',  # noqa: E501
        'slot_front_nvme4option_rom': 'SlotFrontNvme4optionRom',  # noqa: E501
        'slot_front_nvme5link_speed': 'SlotFrontNvme5linkSpeed',  # noqa: E501
        'slot_front_nvme5option_rom': 'SlotFrontNvme5optionRom',  # noqa: E501
        'slot_front_nvme6link_speed': 'SlotFrontNvme6linkSpeed',  # noqa: E501
        'slot_front_nvme6option_rom': 'SlotFrontNvme6optionRom',  # noqa: E501
        'slot_front_nvme7link_speed': 'SlotFrontNvme7linkSpeed',  # noqa: E501
        'slot_front_nvme7option_rom': 'SlotFrontNvme7optionRom',  # noqa: E501
        'slot_front_nvme8link_speed': 'SlotFrontNvme8linkSpeed',  # noqa: E501
        'slot_front_nvme8option_rom': 'SlotFrontNvme8optionRom',  # noqa: E501
        'slot_front_nvme9link_speed': 'SlotFrontNvme9linkSpeed',  # noqa: E501
        'slot_front_nvme9option_rom': 'SlotFrontNvme9optionRom',  # noqa: E501
        'slot_front_slot5link_speed': 'SlotFrontSlot5linkSpeed',  # noqa: E501
        'slot_front_slot6link_speed': 'SlotFrontSlot6linkSpeed',  # noqa: E501
        'slot_gpu1state': 'SlotGpu1state',  # noqa: E501
        'slot_gpu2state': 'SlotGpu2state',  # noqa: E501
        'slot_gpu3state': 'SlotGpu3state',  # noqa: E501
        'slot_gpu4state': 'SlotGpu4state',  # noqa: E501
        'slot_gpu5state': 'SlotGpu5state',  # noqa: E501
        'slot_gpu6state': 'SlotGpu6state',  # noqa: E501
        'slot_gpu7state': 'SlotGpu7state',  # noqa: E501
        'slot_gpu8state': 'SlotGpu8state',  # noqa: E501
        'slot_hba_link_speed': 'SlotHbaLinkSpeed',  # noqa: E501
        'slot_hba_state': 'SlotHbaState',  # noqa: E501
        'slot_lom1link': 'SlotLom1link',  # noqa: E501
        'slot_lom2link': 'SlotLom2link',  # noqa: E501
        'slot_mezz_state': 'SlotMezzState',  # noqa: E501
        'slot_mlom_link_speed': 'SlotMlomLinkSpeed',  # noqa: E501
        'slot_mlom_state': 'SlotMlomState',  # noqa: E501
        'slot_mraid_link_speed': 'SlotMraidLinkSpeed',  # noqa: E501
        'slot_mraid_state': 'SlotMraidState',  # noqa: E501
        'slot_n10state': 'SlotN10state',  # noqa: E501
        'slot_n11state': 'SlotN11state',  # noqa: E501
        'slot_n12state': 'SlotN12state',  # noqa: E501
        'slot_n13state': 'SlotN13state',  # noqa: E501
        'slot_n14state': 'SlotN14state',  # noqa: E501
        'slot_n15state': 'SlotN15state',  # noqa: E501
        'slot_n16state': 'SlotN16state',  # noqa: E501
        'slot_n17state': 'SlotN17state',  # noqa: E501
        'slot_n18state': 'SlotN18state',  # noqa: E501
        'slot_n19state': 'SlotN19state',  # noqa: E501
        'slot_n1state': 'SlotN1state',  # noqa: E501
        'slot_n20state': 'SlotN20state',  # noqa: E501
        'slot_n21state': 'SlotN21state',  # noqa: E501
        'slot_n22state': 'SlotN22state',  # noqa: E501
        'slot_n23state': 'SlotN23state',  # noqa: E501
        'slot_n24state': 'SlotN24state',  # noqa: E501
        'slot_n2state': 'SlotN2state',  # noqa: E501
        'slot_n3state': 'SlotN3state',  # noqa: E501
        'slot_n4state': 'SlotN4state',  # noqa: E501
        'slot_n5state': 'SlotN5state',  # noqa: E501
        'slot_n6state': 'SlotN6state',  # noqa: E501
        'slot_n7state': 'SlotN7state',  # noqa: E501
        'slot_n8state': 'SlotN8state',  # noqa: E501
        'slot_n9state': 'SlotN9state',  # noqa: E501
        'slot_raid_link_speed': 'SlotRaidLinkSpeed',  # noqa: E501
        'slot_raid_state': 'SlotRaidState',  # noqa: E501
        'slot_rear_nvme1link_speed': 'SlotRearNvme1linkSpeed',  # noqa: E501
        'slot_rear_nvme1state': 'SlotRearNvme1state',  # noqa: E501
        'slot_rear_nvme2link_speed': 'SlotRearNvme2linkSpeed',  # noqa: E501
        'slot_rear_nvme2state': 'SlotRearNvme2state',  # noqa: E501
        'slot_rear_nvme3link_speed': 'SlotRearNvme3linkSpeed',  # noqa: E501
        'slot_rear_nvme3state': 'SlotRearNvme3state',  # noqa: E501
        'slot_rear_nvme4link_speed': 'SlotRearNvme4linkSpeed',  # noqa: E501
        'slot_rear_nvme4state': 'SlotRearNvme4state',  # noqa: E501
        'slot_rear_nvme5state': 'SlotRearNvme5state',  # noqa: E501
        'slot_rear_nvme6state': 'SlotRearNvme6state',  # noqa: E501
        'slot_rear_nvme7state': 'SlotRearNvme7state',  # noqa: E501
        'slot_rear_nvme8state': 'SlotRearNvme8state',  # noqa: E501
        'slot_riser1link_speed': 'SlotRiser1linkSpeed',  # noqa: E501
        'slot_riser1slot1link_speed': 'SlotRiser1slot1linkSpeed',  # noqa: E501
        'slot_riser1slot2link_speed': 'SlotRiser1slot2linkSpeed',  # noqa: E501
        'slot_riser1slot3link_speed': 'SlotRiser1slot3linkSpeed',  # noqa: E501
        'slot_riser2link_speed': 'SlotRiser2linkSpeed',  # noqa: E501
        'slot_riser2slot4link_speed': 'SlotRiser2slot4linkSpeed',  # noqa: E501
        'slot_riser2slot5link_speed': 'SlotRiser2slot5linkSpeed',  # noqa: E501
        'slot_riser2slot6link_speed': 'SlotRiser2slot6linkSpeed',  # noqa: E501
        'slot_sas_state': 'SlotSasState',  # noqa: E501
        'slot_ssd_slot1link_speed': 'SlotSsdSlot1linkSpeed',  # noqa: E501
        'slot_ssd_slot2link_speed': 'SlotSsdSlot2linkSpeed',  # noqa: E501
        'smee': 'Smee',  # noqa: E501
        'smt_mode': 'SmtMode',  # noqa: E501
        'snc': 'Snc',  # noqa: E501
        'snoopy_mode_for2lm': 'SnoopyModeFor2lm',  # noqa: E501
        'snoopy_mode_for_ad': 'SnoopyModeForAd',  # noqa: E501
        'sparing_mode': 'SparingMode',  # noqa: E501
        'sr_iov': 'SrIov',  # noqa: E501
        'streamer_prefetch': 'StreamerPrefetch',  # noqa: E501
        'svm_mode': 'SvmMode',  # noqa: E501
        'terminal_type': 'TerminalType',  # noqa: E501
        'tpm_control': 'TpmControl',  # noqa: E501
        'tpm_pending_operation': 'TpmPendingOperation',  # noqa: E501
        'tpm_ppi_required': 'TpmPpiRequired',  # noqa: E501
        'tpm_support': 'TpmSupport',  # noqa: E501
        'tsme': 'Tsme',  # noqa: E501
        'txt_support': 'TxtSupport',  # noqa: E501
        'ucsm_boot_order_rule': 'UcsmBootOrderRule',  # noqa: E501
        'ufs_disable': 'UfsDisable',  # noqa: E501
        'uma_based_clustering': 'UmaBasedClustering',  # noqa: E501
        'upi_link_enablement': 'UpiLinkEnablement',  # noqa: E501
        'upi_power_management': 'UpiPowerManagement',  # noqa: E501
        'usb_emul6064': 'UsbEmul6064',  # noqa: E501
        'usb_port_front': 'UsbPortFront',  # noqa: E501
        'usb_port_internal': 'UsbPortInternal',  # noqa: E501
        'usb_port_kvm': 'UsbPortKvm',  # noqa: E501
        'usb_port_rear': 'UsbPortRear',  # noqa: E501
        'usb_port_sd_card': 'UsbPortSdCard',  # noqa: E501
        'usb_port_vmedia': 'UsbPortVmedia',  # noqa: E501
        'usb_xhci_support': 'UsbXhciSupport',  # noqa: E501
        'vga_priority': 'VgaPriority',  # noqa: E501
        'virtual_numa': 'VirtualNuma',  # noqa: E501
        'vmd_enable': 'VmdEnable',  # noqa: E501
        'vol_memory_mode': 'VolMemoryMode',  # noqa: E501
        'work_load_config': 'WorkLoadConfig',  # noqa: E501
        'xpt_prefetch': 'XptPrefetch',  # noqa: E501
        'xpt_remote_prefetch': 'XptRemotePrefetch',  # noqa: E501
        'organization': 'Organization',  # noqa: E501
        'profiles': 'Profiles',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'name': 'Name',  # noqa: E501
    }

    read_only_vars = {
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """BiosPolicy - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "bios.Policy", must be one of ["bios.Policy", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "bios.Policy", must be one of ["bios.Policy", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            acs_control_gpu1state (str): BIOS Token for setting ACS Control GPU 1 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu2state (str): BIOS Token for setting ACS Control GPU 2 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu3state (str): BIOS Token for setting ACS Control GPU 3 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu4state (str): BIOS Token for setting ACS Control GPU 4 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu5state (str): BIOS Token for setting ACS Control GPU 5 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu6state (str): BIOS Token for setting ACS Control GPU 6 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu7state (str): BIOS Token for setting ACS Control GPU 7 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu8state (str): BIOS Token for setting ACS Control GPU 8 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_slot11state (str): BIOS Token for setting ACS Control Slot 11 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_slot12state (str): BIOS Token for setting ACS Control Slot 12 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_slot13state (str): BIOS Token for setting ACS Control Slot 13 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_slot14state (str): BIOS Token for setting ACS Control Slot 14 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            adjacent_cache_line_prefetch (str): BIOS Token for setting Adjacent Cache Line Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            advanced_mem_test (str): BIOS Token for setting Enhanced Memory Test configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring AdvancedMemTest token. * `disabled` - Value - disabled for configuring AdvancedMemTest token. * `enabled` - Value - enabled for configuring AdvancedMemTest token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            all_usb_devices (str): BIOS Token for setting All USB Devices configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            altitude (str): BIOS Token for setting Altitude configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `300-m` - Value - 300-m for configuring Altitude token. * `900-m` - Value - 900-m for configuring Altitude token. * `1500-m` - Value - 1500-m for configuring Altitude token. * `3000-m` - Value - 3000-m for configuring Altitude token. * `auto` - Value - auto for configuring Altitude token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            aspm_support (str): BIOS Token for setting ASPM Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring AspmSupport token. * `Disabled` - Value - Disabled for configuring AspmSupport token. * `Force L0s` - Value - Force L0s for configuring AspmSupport token. * `L1 Only` - Value - L1 Only for configuring AspmSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            assert_nmi_on_perr (str): BIOS Token for setting Assert NMI on PERR configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            assert_nmi_on_serr (str): BIOS Token for setting Assert NMI on SERR configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            auto_cc_state (str): BIOS Token for setting Autonomous Core C State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            autonumous_cstate_enable (str): BIOS Token for setting CPU Autonomous C State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            baud_rate (str): BIOS Token for setting Baud Rate configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `9600` - Value - 9600 for configuring BaudRate token. * `19200` - Value - 19200 for configuring BaudRate token. * `38400` - Value - 38400 for configuring BaudRate token. * `57600` - Value - 57600 for configuring BaudRate token. * `115200` - Value - 115200 for configuring BaudRate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            bme_dma_mitigation (str): BIOS Token for setting BME DMA Mitigation configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            boot_option_num_retry (str): BIOS Token for setting Number of Retries configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `5` - Value - 5 for configuring BootOptionNumRetry token. * `13` - Value - 13 for configuring BootOptionNumRetry token. * `Infinite` - Value - Infinite for configuring BootOptionNumRetry token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            boot_option_re_cool_down (str): BIOS Token for setting Cool Down Time  (sec) configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `15` - Value - 15 for configuring BootOptionReCoolDown token. * `45` - Value - 45 for configuring BootOptionReCoolDown token. * `90` - Value - 90 for configuring BootOptionReCoolDown token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            boot_option_retry (str): BIOS Token for setting Boot Option Retry configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            boot_performance_mode (str): BIOS Token for setting Boot Performance Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Max Efficient` - Value - Max Efficient for configuring BootPerformanceMode token. * `Max Performance` - Value - Max Performance for configuring BootPerformanceMode token. * `Set by Intel NM` - Value - Set by Intel NM for configuring BootPerformanceMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            burst_and_postponed_refresh (str): BIOS Token for setting Burst and Postponed Refresh configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            c1auto_demotion (str): BIOS Token for setting C1 Auto Demotion configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            c1auto_un_demotion (str): BIOS Token for setting C1 Auto UnDemotion configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_apbdis (str): BIOS Token for setting APBDIS configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `0` - Value - 0 for configuring CbsCmnApbdis token. * `1` - Value - 1 for configuring CbsCmnApbdis token. * `Auto` - Value - Auto for configuring CbsCmnApbdis token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_cpb (str): BIOS Token for setting Core Performance Boost configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuCpb token. * `disabled` - Value - disabled for configuring CbsCmnCpuCpb token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_gen_downcore_ctrl (str): BIOS Token for setting Downcore Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuGenDowncoreCtrl token. * `FOUR (2 + 2)` - Value - FOUR (2 + 2) for configuring CbsCmnCpuGenDowncoreCtrl token. * `FOUR (4 + 0)` - Value - FOUR (4 + 0) for configuring CbsCmnCpuGenDowncoreCtrl token. * `SIX (3 + 3)` - Value - SIX (3 + 3) for configuring CbsCmnCpuGenDowncoreCtrl token. * `THREE (3 + 0)` - Value - THREE (3 + 0) for configuring CbsCmnCpuGenDowncoreCtrl token. * `TWO (1 + 1)` - Value - TWO (1 + 1) for configuring CbsCmnCpuGenDowncoreCtrl token. * `TWO (2 + 0)` - Value - TWO (2 + 0) for configuring CbsCmnCpuGenDowncoreCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_global_cstate_ctrl (str): BIOS Token for setting Global C State Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuGlobalCstateCtrl token. * `disabled` - Value - disabled for configuring CbsCmnCpuGlobalCstateCtrl token. * `enabled` - Value - enabled for configuring CbsCmnCpuGlobalCstateCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_l1stream_hw_prefetcher (str): BIOS Token for setting L1 Stream HW Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuL1streamHwPrefetcher token. * `disabled` - Value - disabled for configuring CbsCmnCpuL1streamHwPrefetcher token. * `enabled` - Value - enabled for configuring CbsCmnCpuL1streamHwPrefetcher token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_l2stream_hw_prefetcher (str): BIOS Token for setting L2 Stream HW Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuL2streamHwPrefetcher token. * `disabled` - Value - disabled for configuring CbsCmnCpuL2streamHwPrefetcher token. * `enabled` - Value - enabled for configuring CbsCmnCpuL2streamHwPrefetcher token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_smee (str): BIOS Token for setting CPU SMEE configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuSmee token. * `disabled` - Value - disabled for configuring CbsCmnCpuSmee token. * `enabled` - Value - enabled for configuring CbsCmnCpuSmee token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_streaming_stores_ctrl (str): BIOS Token for setting Streaming Stores Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuStreamingStoresCtrl token. * `disabled` - Value - disabled for configuring CbsCmnCpuStreamingStoresCtrl token. * `enabled` - Value - enabled for configuring CbsCmnCpuStreamingStoresCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_determinism_slider (str): BIOS Token for setting Determinism Slider configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnDeterminismSlider token. * `Performance` - Value - Performance for configuring CbsCmnDeterminismSlider token. * `Power` - Value - Power for configuring CbsCmnDeterminismSlider token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_efficiency_mode_en (str): BIOS Token for setting Efficiency Mode Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnEfficiencyModeEn token. * `Enabled` - Value - Enabled for configuring CbsCmnEfficiencyModeEn token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_fixed_soc_pstate (str): BIOS Token for setting Fixed SOC P-State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnFixedSocPstate token. * `P0` - Value - P0 for configuring CbsCmnFixedSocPstate token. * `P1` - Value - P1 for configuring CbsCmnFixedSocPstate token. * `P2` - Value - P2 for configuring CbsCmnFixedSocPstate token. * `P3` - Value - P3 for configuring CbsCmnFixedSocPstate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_gnb_nb_iommu (str): BIOS Token for setting IOMMU configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnGnbNbIommu token. * `disabled` - Value - disabled for configuring CbsCmnGnbNbIommu token. * `enabled` - Value - enabled for configuring CbsCmnGnbNbIommu token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_gnb_smu_df_cstates (str): BIOS Token for setting DF C-States configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnGnbSmuDfCstates token. * `disabled` - Value - disabled for configuring CbsCmnGnbSmuDfCstates token. * `enabled` - Value - enabled for configuring CbsCmnGnbSmuDfCstates token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_gnb_smucppc (str): BIOS Token for setting CPPC configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnGnbSmucppc token. * `disabled` - Value - disabled for configuring CbsCmnGnbSmucppc token. * `enabled` - Value - enabled for configuring CbsCmnGnbSmucppc token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_mem_ctrl_bank_group_swap_ddr4 (str): BIOS Token for setting Bank Group Swap configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnMemCtrlBankGroupSwapDdr4 token. * `disabled` - Value - disabled for configuring CbsCmnMemCtrlBankGroupSwapDdr4 token. * `enabled` - Value - enabled for configuring CbsCmnMemCtrlBankGroupSwapDdr4 token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_mem_map_bank_interleave_ddr4 (str): BIOS Token for setting Chipset Interleave configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnMemMapBankInterleaveDdr4 token. * `disabled` - Value - disabled for configuring CbsCmnMemMapBankInterleaveDdr4 token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmnc_tdp_ctl (str): BIOS Token for setting cTDP Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmncTdpCtl token. * `Manual` - Value - Manual for configuring CbsCmncTdpCtl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cpu_ccd_ctrl_ssp (str): BIOS Token for setting CCD Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `2 CCDs` - Value - 2 CCDs for configuring CbsCpuCcdCtrlSsp token. * `3 CCDs` - Value - 3 CCDs for configuring CbsCpuCcdCtrlSsp token. * `4 CCDs` - Value - 4 CCDs for configuring CbsCpuCcdCtrlSsp token. * `6 CCDs` - Value - 6 CCDs for configuring CbsCpuCcdCtrlSsp token. * `Auto` - Value - Auto for configuring CbsCpuCcdCtrlSsp token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cpu_core_ctrl (str): BIOS Token for setting CPU Downcore control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCpuCoreCtrl token. * `FIVE (5 + 0)` - Value - FIVE (5 + 0) for configuring CbsCpuCoreCtrl token. * `FOUR (4 + 0)` - Value - FOUR (4 + 0) for configuring CbsCpuCoreCtrl token. * `ONE (1 + 0)` - Value - ONE (1 + 0) for configuring CbsCpuCoreCtrl token. * `SEVEN (7 + 0)` - Value - SEVEN (7 + 0) for configuring CbsCpuCoreCtrl token. * `SIX (6 + 0)` - Value - SIX (6 + 0) for configuring CbsCpuCoreCtrl token. * `THREE (3 + 0)` - Value - THREE (3 + 0) for configuring CbsCpuCoreCtrl token. * `TWO (2 + 0)` - Value - TWO (2 + 0) for configuring CbsCpuCoreCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cpu_smt_ctrl (str): BIOS Token for setting CPU SMT Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCpuSmtCtrl token. * `disabled` - Value - disabled for configuring CbsCpuSmtCtrl token. * `enabled` - Value - enabled for configuring CbsCpuSmtCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_dbg_cpu_snp_mem_cover (str): BIOS Token for setting SNP Memory Coverage configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsDbgCpuSnpMemCover token. * `Custom` - Value - Custom for configuring CbsDbgCpuSnpMemCover token. * `disabled` - Value - disabled for configuring CbsDbgCpuSnpMemCover token. * `enabled` - Value - enabled for configuring CbsDbgCpuSnpMemCover token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_dbg_cpu_snp_mem_size_cover (str): BIOS Token for setting SNP Memory Size to Cover in MiB configuration (0 - 1048576 MiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_df_cmn_acpi_srat_l3numa (str): BIOS Token for setting ACPI SRAT L3 Cache As NUMA Domain configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsDfCmnAcpiSratL3numa token. * `disabled` - Value - disabled for configuring CbsDfCmnAcpiSratL3numa token. * `enabled` - Value - enabled for configuring CbsDfCmnAcpiSratL3numa token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_df_cmn_dram_nps (str): BIOS Token for setting NUMA Nodes per Socket configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsDfCmnDramNps token. * `NPS0` - Value - NPS0 for configuring CbsDfCmnDramNps token. * `NPS1` - Value - NPS1 for configuring CbsDfCmnDramNps token. * `NPS2` - Value - NPS2 for configuring CbsDfCmnDramNps token. * `NPS4` - Value - NPS4 for configuring CbsDfCmnDramNps token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_df_cmn_mem_intlv (str): BIOS Token for setting AMD Memory Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsDfCmnMemIntlv token. * `Channel` - Value - Channel for configuring CbsDfCmnMemIntlv token. * `Die` - Value - Die for configuring CbsDfCmnMemIntlv token. * `None` - Value - None for configuring CbsDfCmnMemIntlv token. * `Socket` - Value - Socket for configuring CbsDfCmnMemIntlv token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_df_cmn_mem_intlv_size (str): BIOS Token for setting AMD Memory Interleaving Size configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `256 Bytes` - Value - 256 Bytes for configuring CbsDfCmnMemIntlvSize token. * `512 Bytes` - Value - 512 Bytes for configuring CbsDfCmnMemIntlvSize token. * `1 KB` - Value - 1 KiB for configuring CbsDfCmnMemIntlvSize token. * `2 KB` - Value - 2 KiB for configuring CbsDfCmnMemIntlvSize token. * `4 KB` - Value - 4 KiB for configuring CbsDfCmnMemIntlvSize token. * `Auto` - Value - Auto for configuring CbsDfCmnMemIntlvSize token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_sev_snp_support (str): BIOS Token for setting SEV-SNP Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cdn_enable (str): BIOS Token for setting Consistent Device Naming configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cdn_support (str): BIOS Token for setting CDN Support for LOM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring CdnSupport token. * `enabled` - Value - enabled for configuring CdnSupport token. * `LOMs Only` - Value - LOMs Only for configuring CdnSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            channel_inter_leave (str): BIOS Token for setting Channel Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1-way` - Value - 1-way for configuring ChannelInterLeave token. * `2-way` - Value - 2-way for configuring ChannelInterLeave token. * `3-way` - Value - 3-way for configuring ChannelInterLeave token. * `4-way` - Value - 4-way for configuring ChannelInterLeave token. * `auto` - Value - auto for configuring ChannelInterLeave token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cisco_adaptive_mem_training (str): BIOS Token for setting Adaptive Memory Training configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cisco_debug_level (str): BIOS Token for setting BIOS Techlog Level configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Maximum` - Value - Maximum for configuring CiscoDebugLevel token. * `Minimum` - Value - Minimum for configuring CiscoDebugLevel token. * `Normal` - Value - Normal for configuring CiscoDebugLevel token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cisco_oprom_launch_optimization (str): BIOS Token for setting OptionROM Launch Optimization configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cisco_xgmi_max_speed (str): BIOS Token for setting Cisco xGMI Max Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cke_low_policy (str): BIOS Token for setting CKE Low Policy configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring CkeLowPolicy token. * `disabled` - Value - disabled for configuring CkeLowPolicy token. * `fast` - Value - fast for configuring CkeLowPolicy token. * `slow` - Value - slow for configuring CkeLowPolicy token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            closed_loop_therm_throtl (str): BIOS Token for setting Closed Loop Thermal Throttling configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cmci_enable (str): BIOS Token for setting Processor CMCI configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            config_tdp (str): BIOS Token for setting Config TDP configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            config_tdp_level (str): BIOS Token for setting Configurable TDP Level configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Level 1` - Value - Level 1 for configuring ConfigTdpLevel token. * `Level 2` - Value - Level 2 for configuring ConfigTdpLevel token. * `Normal` - Value - Normal for configuring ConfigTdpLevel token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            console_redirection (str): BIOS Token for setting Console Redirection configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `com-0` - Value - com-0 for configuring ConsoleRedirection token. * `com-1` - Value - com-1 for configuring ConsoleRedirection token. * `disabled` - Value - disabled for configuring ConsoleRedirection token. * `enabled` - Value - enabled for configuring ConsoleRedirection token. * `serial-port-a` - Value - serial-port-a for configuring ConsoleRedirection token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            core_multi_processing (str): BIOS Token for setting Core Multi Processing configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1` - Value - 1 for configuring CoreMultiProcessing token. * `2` - Value - 2 for configuring CoreMultiProcessing token. * `3` - Value - 3 for configuring CoreMultiProcessing token. * `4` - Value - 4 for configuring CoreMultiProcessing token. * `5` - Value - 5 for configuring CoreMultiProcessing token. * `6` - Value - 6 for configuring CoreMultiProcessing token. * `7` - Value - 7 for configuring CoreMultiProcessing token. * `8` - Value - 8 for configuring CoreMultiProcessing token. * `9` - Value - 9 for configuring CoreMultiProcessing token. * `10` - Value - 10 for configuring CoreMultiProcessing token. * `11` - Value - 11 for configuring CoreMultiProcessing token. * `12` - Value - 12 for configuring CoreMultiProcessing token. * `13` - Value - 13 for configuring CoreMultiProcessing token. * `14` - Value - 14 for configuring CoreMultiProcessing token. * `15` - Value - 15 for configuring CoreMultiProcessing token. * `16` - Value - 16 for configuring CoreMultiProcessing token. * `17` - Value - 17 for configuring CoreMultiProcessing token. * `18` - Value - 18 for configuring CoreMultiProcessing token. * `19` - Value - 19 for configuring CoreMultiProcessing token. * `20` - Value - 20 for configuring CoreMultiProcessing token. * `21` - Value - 21 for configuring CoreMultiProcessing token. * `22` - Value - 22 for configuring CoreMultiProcessing token. * `23` - Value - 23 for configuring CoreMultiProcessing token. * `24` - Value - 24 for configuring CoreMultiProcessing token. * `25` - Value - 25 for configuring CoreMultiProcessing token. * `26` - Value - 26 for configuring CoreMultiProcessing token. * `27` - Value - 27 for configuring CoreMultiProcessing token. * `28` - Value - 28 for configuring CoreMultiProcessing token. * `29` - Value - 29 for configuring CoreMultiProcessing token. * `30` - Value - 30 for configuring CoreMultiProcessing token. * `31` - Value - 31 for configuring CoreMultiProcessing token. * `32` - Value - 32 for configuring CoreMultiProcessing token. * `33` - Value - 33 for configuring CoreMultiProcessing token. * `34` - Value - 34 for configuring CoreMultiProcessing token. * `35` - Value - 35 for configuring CoreMultiProcessing token. * `36` - Value - 36 for configuring CoreMultiProcessing token. * `37` - Value - 37 for configuring CoreMultiProcessing token. * `38` - Value - 38 for configuring CoreMultiProcessing token. * `39` - Value - 39 for configuring CoreMultiProcessing token. * `40` - Value - 40 for configuring CoreMultiProcessing token. * `41` - Value - 41 for configuring CoreMultiProcessing token. * `42` - Value - 42 for configuring CoreMultiProcessing token. * `43` - Value - 43 for configuring CoreMultiProcessing token. * `44` - Value - 44 for configuring CoreMultiProcessing token. * `45` - Value - 45 for configuring CoreMultiProcessing token. * `46` - Value - 46 for configuring CoreMultiProcessing token. * `47` - Value - 47 for configuring CoreMultiProcessing token. * `48` - Value - 48 for configuring CoreMultiProcessing token. * `all` - Value - all for configuring CoreMultiProcessing token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_energy_performance (str): BIOS Token for setting Energy Performance configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `balanced-energy` - Value - balanced-energy for configuring CpuEnergyPerformance token. * `balanced-performance` - Value - balanced-performance for configuring CpuEnergyPerformance token. * `balanced-power` - Value - balanced-power for configuring CpuEnergyPerformance token. * `energy-efficient` - Value - energy-efficient for configuring CpuEnergyPerformance token. * `performance` - Value - performance for configuring CpuEnergyPerformance token. * `power` - Value - power for configuring CpuEnergyPerformance token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_frequency_floor (str): BIOS Token for setting Frequency Floor Override configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_pa_limit (str): BIOS Token for setting Limit CPU PA to 46 Bits configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_perf_enhancement (str): BIOS Token for setting Enhanced CPU Performance configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CpuPerfEnhancement token. * `Disabled` - Value - Disabled for configuring CpuPerfEnhancement token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_performance (str): BIOS Token for setting CPU Performance configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `custom` - Value - custom for configuring CpuPerformance token. * `enterprise` - Value - enterprise for configuring CpuPerformance token. * `high-throughput` - Value - high-throughput for configuring CpuPerformance token. * `hpc` - Value - hpc for configuring CpuPerformance token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_power_management (str): BIOS Token for setting Power Technology configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `custom` - Value - custom for configuring CpuPowerManagement token. * `disabled` - Value - disabled for configuring CpuPowerManagement token. * `energy-efficient` - Value - energy-efficient for configuring CpuPowerManagement token. * `performance` - Value - performance for configuring CpuPowerManagement token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cr_qos (str): BIOS Token for setting CR QoS configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disabled` - Value - Disabled for configuring CrQos token. * `Mode 0 - Disable the PMem QoS Feature` - Value - Mode 0 - Disable the PMem QoS Feature for configuring CrQos token. * `Mode 1 - M2M QoS Enable and CHA QoS Disable` - Value - Mode 1 - M2M QoS Enable and CHA QoS Disable for configuring CrQos token. * `Mode 2 - M2M QoS Enable and CHA QoS Enable` - Value - Mode 2 - M2M QoS Enable and CHA QoS Enable for configuring CrQos token. * `Recipe 1` - Value - Recipe 1 for configuring CrQos token. * `Recipe 2` - Value - Recipe 2 for configuring CrQos token. * `Recipe 3` - Value - Recipe 3 for configuring CrQos token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            crfastgo_config (str): BIOS Token for setting CR FastGo Config configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CrfastgoConfig token. * `Default` - Value - Default for configuring CrfastgoConfig token. * `Disable optimization` - Value - Disable optimization for configuring CrfastgoConfig token. * `Enable optimization` - Value - Enable optimization for configuring CrfastgoConfig token. * `Option 1` - Value - Option 1 for configuring CrfastgoConfig token. * `Option 2` - Value - Option 2 for configuring CrfastgoConfig token. * `Option 3` - Value - Option 3 for configuring CrfastgoConfig token. * `Option 4` - Value - Option 4 for configuring CrfastgoConfig token. * `Option 5` - Value - Option 5 for configuring CrfastgoConfig token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            dcpmm_firmware_downgrade (str): BIOS Token for setting DCPMM Firmware Downgrade configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            demand_scrub (str): BIOS Token for setting Demand Scrub configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            direct_cache_access (str): BIOS Token for setting Direct Cache Access Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring DirectCacheAccess token. * `disabled` - Value - disabled for configuring DirectCacheAccess token. * `enabled` - Value - enabled for configuring DirectCacheAccess token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            dram_clock_throttling (str): BIOS Token for setting DRAM Clock Throttling configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring DramClockThrottling token. * `Balanced` - Value - Balanced for configuring DramClockThrottling token. * `Energy Efficient` - Value - Energy Efficient for configuring DramClockThrottling token. * `Performance` - Value - Performance for configuring DramClockThrottling token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            dram_refresh_rate (str): BIOS Token for setting DRAM Refresh Rate configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1x` - Value - 1x for configuring DramRefreshRate token. * `2x` - Value - 2x for configuring DramRefreshRate token. * `3x` - Value - 3x for configuring DramRefreshRate token. * `4x` - Value - 4x for configuring DramRefreshRate token. * `Auto` - Value - Auto for configuring DramRefreshRate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            dram_sw_thermal_throttling (str): BIOS Token for setting DRAM SW Thermal Throttling configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            eadr_support (str): BIOS Token for setting eADR Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring EadrSupport token. * `disabled` - Value - disabled for configuring EadrSupport token. * `enabled` - Value - enabled for configuring EadrSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            edpc_en (str): BIOS Token for setting IIO eDPC Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disabled` - Value - Disabled for configuring EdpcEn token. * `On Fatal Error` - Value - On Fatal Error for configuring EdpcEn token. * `On Fatal and Non-Fatal Errors` - Value - On Fatal and Non-Fatal Errors for configuring EdpcEn token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enable_clock_spread_spec (str): BIOS Token for setting External SSC Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enable_mktme (str): BIOS Token for setting Multikey Total Memory Encryption  (MK-TME) configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enable_sgx (str): BIOS Token for setting Software Guard Extensions  (SGX) configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enable_tme (str): BIOS Token for setting Total Memory Encryption  (TME) configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            energy_efficient_turbo (str): BIOS Token for setting Energy Efficient Turbo configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            eng_perf_tuning (str): BIOS Token for setting Energy Performance Tuning configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `BIOS` - Value - BIOS for configuring EngPerfTuning token. * `OS` - Value - OS for configuring EngPerfTuning token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enhanced_intel_speed_step_tech (str): BIOS Token for setting Enhanced Intel Speedstep (R) Technology configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            epoch_update (str): BIOS Token for setting Select Owner EPOCH Input Type configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Change to New Random Owner EPOCHs` - Value - Change to New Random Owner EPOCHs for configuring EpochUpdate token. * `Manual User Defined Owner EPOCHs` - Value - Manual User Defined Owner EPOCHs for configuring EpochUpdate token. * `SGX Owner EPOCH activated` - Value - SGX Owner EPOCH activated for configuring EpochUpdate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            epp_enable (str): BIOS Token for setting Processor EPP Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            epp_profile (str): BIOS Token for setting EPP Profile configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Balanced Performance` - Value - Balanced Performance for configuring EppProfile token. * `Balanced Power` - Value - Balanced Power for configuring EppProfile token. * `Performance` - Value - Performance for configuring EppProfile token. * `Power` - Value - Power for configuring EppProfile token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            execute_disable_bit (str): BIOS Token for setting Execute Disable Bit configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            extended_apic (str): BIOS Token for setting Local X2 Apic configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring ExtendedApic token. * `enabled` - Value - enabled for configuring ExtendedApic token. * `X2APIC` - Value - X2APIC for configuring ExtendedApic token. * `XAPIC` - Value - XAPIC for configuring ExtendedApic token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            flow_control (str): BIOS Token for setting Flow Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `none` - Value - none for configuring FlowControl token. * `rts-cts` - Value - rts-cts for configuring FlowControl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            frb2enable (str): BIOS Token for setting FRB-2 Timer configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            hardware_prefetch (str): BIOS Token for setting Hardware Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            hwpm_enable (str): BIOS Token for setting CPU Hardware Power Management configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disabled` - Value - Disabled for configuring HwpmEnable token. * `HWPM Native Mode` - Value - HWPM Native Mode for configuring HwpmEnable token. * `HWPM OOB Mode` - Value - HWPM OOB Mode for configuring HwpmEnable token. * `NATIVE MODE` - Value - NATIVE MODE for configuring HwpmEnable token. * `Native Mode with no Legacy` - Value - Native Mode with no Legacy for configuring HwpmEnable token. * `OOB MODE` - Value - OOB MODE for configuring HwpmEnable token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            imc_interleave (str): BIOS Token for setting IMC Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1-way Interleave` - Value - 1-way Interleave for configuring ImcInterleave token. * `2-way Interleave` - Value - 2-way Interleave for configuring ImcInterleave token. * `Auto` - Value - Auto for configuring ImcInterleave token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_dynamic_speed_select (str): BIOS Token for setting Intel Dynamic Speed Select configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_hyper_threading_tech (str): BIOS Token for setting Intel HyperThreading Tech configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_speed_select (str): BIOS Token for setting Intel Speed Select configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Base` - Value - Base for configuring IntelSpeedSelect token. * `Config 1` - Value - Config 1 for configuring IntelSpeedSelect token. * `Config 2` - Value - Config 2 for configuring IntelSpeedSelect token. * `Config 3` - Value - Config 3 for configuring IntelSpeedSelect token. * `Config 4` - Value - Config 4 for configuring IntelSpeedSelect token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_turbo_boost_tech (str): BIOS Token for setting Intel Turbo Boost Tech configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_virtualization_technology (str): BIOS Token for setting Intel (R) VT configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vt_for_directed_io (str): BIOS Token for setting Intel VT for Directed IO configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vtd_coherency_support (str): BIOS Token for setting Intel (R) VT-d Coherency Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vtd_interrupt_remapping (str): BIOS Token for setting Intel (R) VT-d Interrupt Remapping configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vtd_pass_through_dma_support (str): BIOS Token for setting Intel (R) VT-d PassThrough DMA Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vtdats_support (str): BIOS Token for setting Intel VTD ATS Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ioh_error_enable (str): BIOS Token for setting IIO Error Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `No` - Value - No for configuring IohErrorEnable token. * `Yes` - Value - Yes for configuring IohErrorEnable token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ioh_resource (str): BIOS Token for setting IOH Resource Allocation configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `IOH0 24k IOH1 40k` - Value - IOH0 24k IOH1 40k for configuring IohResource token. * `IOH0 32k IOH1 32k` - Value - IOH0 32k IOH1 32k for configuring IohResource token. * `IOH0 40k IOH1 24k` - Value - IOH0 40k IOH1 24k for configuring IohResource token. * `IOH0 48k IOH1 16k` - Value - IOH0 48k IOH1 16k for configuring IohResource token. * `IOH0 56k IOH1 8k` - Value - IOH0 56k IOH1 8k for configuring IohResource token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ip_prefetch (str): BIOS Token for setting DCU IP Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ipv4http (str): BIOS Token for setting IPV4 HTTP Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ipv4pxe (str): BIOS Token for setting IPv4 PXE Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ipv6http (str): BIOS Token for setting IPV6 HTTP Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ipv6pxe (str): BIOS Token for setting IPV6 PXE Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            kti_prefetch (str): BIOS Token for setting KTI Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring KtiPrefetch token. * `disabled` - Value - disabled for configuring KtiPrefetch token. * `enabled` - Value - enabled for configuring KtiPrefetch token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            legacy_os_redirection (str): BIOS Token for setting Legacy OS Redirection configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            legacy_usb_support (str): BIOS Token for setting Legacy USB Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring LegacyUsbSupport token. * `disabled` - Value - disabled for configuring LegacyUsbSupport token. * `enabled` - Value - enabled for configuring LegacyUsbSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            llc_alloc (str): BIOS Token for setting LLC Dead Line configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring LlcAlloc token. * `disabled` - Value - disabled for configuring LlcAlloc token. * `enabled` - Value - enabled for configuring LlcAlloc token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            llc_prefetch (str): BIOS Token for setting LLC Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_port0state (str): BIOS Token for setting LOM Port 0 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring LomPort0state token. * `enabled` - Value - enabled for configuring LomPort0state token. * `Legacy Only` - Value - Legacy Only for configuring LomPort0state token. * `UEFI Only` - Value - UEFI Only for configuring LomPort0state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_port1state (str): BIOS Token for setting LOM Port 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring LomPort1state token. * `enabled` - Value - enabled for configuring LomPort1state token. * `Legacy Only` - Value - Legacy Only for configuring LomPort1state token. * `UEFI Only` - Value - UEFI Only for configuring LomPort1state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_port2state (str): BIOS Token for setting LOM Port 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring LomPort2state token. * `enabled` - Value - enabled for configuring LomPort2state token. * `Legacy Only` - Value - Legacy Only for configuring LomPort2state token. * `UEFI Only` - Value - UEFI Only for configuring LomPort2state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_port3state (str): BIOS Token for setting LOM Port 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring LomPort3state token. * `enabled` - Value - enabled for configuring LomPort3state token. * `Legacy Only` - Value - Legacy Only for configuring LomPort3state token. * `UEFI Only` - Value - UEFI Only for configuring LomPort3state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_ports_all_state (str): BIOS Token for setting All Onboard LOM Ports configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lv_ddr_mode (str): BIOS Token for setting Low Voltage DDR Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring LvDdrMode token. * `performance-mode` - Value - performance-mode for configuring LvDdrMode token. * `power-saving-mode` - Value - power-saving-mode for configuring LvDdrMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            make_device_non_bootable (str): BIOS Token for setting Make Device Non Bootable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_bandwidth_boost (str): BIOS Token for setting Memory Bandwidth Boost configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_inter_leave (str): BIOS Token for setting Intel Memory Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1 Way Node Interleave` - Value - 1 Way Node Interleave for configuring MemoryInterLeave token. * `2 Way Node Interleave` - Value - 2 Way Node Interleave for configuring MemoryInterLeave token. * `4 Way Node Interleave` - Value - 4 Way Node Interleave for configuring MemoryInterLeave token. * `8 Way Node Interleave` - Value - 8 Way Node Interleave for configuring MemoryInterLeave token. * `disabled` - Value - disabled for configuring MemoryInterLeave token. * `enabled` - Value - enabled for configuring MemoryInterLeave token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_mapped_io_above4gb (str): BIOS Token for setting Memory Mapped IO above 4GiB configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_refresh_rate (str): BIOS Token for setting Memory Refresh Rate configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1x Refresh` - Value - 1x Refresh for configuring MemoryRefreshRate token. * `2x Refresh` - Value - 2x Refresh for configuring MemoryRefreshRate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_size_limit (str): BIOS Token for setting Memory Size Limit in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_thermal_throttling (str): BIOS Token for setting Memory Thermal Throttling Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `CLTT with PECI` - Value - CLTT with PECI for configuring MemoryThermalThrottling token. * `Disabled` - Value - Disabled for configuring MemoryThermalThrottling token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            mirroring_mode (str): BIOS Token for setting Mirroring Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `inter-socket` - Value - inter-socket for configuring MirroringMode token. * `intra-socket` - Value - intra-socket for configuring MirroringMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            mmcfg_base (str): BIOS Token for setting MMCFG BASE configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1 GB` - Value - 1 GiB for configuring MmcfgBase token. * `2 GB` - Value - 2 GiB for configuring MmcfgBase token. * `2.5 GB` - Value - 2.5 GiB for configuring MmcfgBase token. * `3 GB` - Value - 3 GiB for configuring MmcfgBase token. * `Auto` - Value - Auto for configuring MmcfgBase token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            network_stack (str): BIOS Token for setting Network Stack configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            numa_optimized (str): BIOS Token for setting NUMA Optimized configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            nvmdimm_perform_config (str): BIOS Token for setting NVM Performance Setting configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `BW Optimized` - Value - BW Optimized for configuring NvmdimmPerformConfig token. * `Balanced Profile` - Value - Balanced Profile for configuring NvmdimmPerformConfig token. * `Latency Optimized` - Value - Latency Optimized for configuring NvmdimmPerformConfig token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            onboard10gbit_lom (str): BIOS Token for setting Onboard 10Gbit LOM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            onboard_gbit_lom (str): BIOS Token for setting Onboard Gbit LOM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            onboard_scu_storage_support (str): BIOS Token for setting Onboard SCU Storage Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            onboard_scu_storage_sw_stack (str): BIOS Token for setting Onboard SCU Storage SW Stack configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Intel RSTe` - Value - Intel RSTe for configuring OnboardScuStorageSwStack token. * `LSI SW RAID` - Value - LSI SW RAID for configuring OnboardScuStorageSwStack token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            operation_mode (str): BIOS Token for setting Operation Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Test Only` - Value - Test Only for configuring OperationMode token. * `Test and Repair` - Value - Test and Repair for configuring OperationMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            os_boot_watchdog_timer (str): BIOS Token for setting OS Boot Watchdog Timer configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            os_boot_watchdog_timer_policy (str): BIOS Token for setting OS Boot Watchdog Timer Policy configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `do-nothing` - Value - do-nothing for configuring OsBootWatchdogTimerPolicy token. * `power-off` - Value - power-off for configuring OsBootWatchdogTimerPolicy token. * `reset` - Value - reset for configuring OsBootWatchdogTimerPolicy token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            os_boot_watchdog_timer_timeout (str): BIOS Token for setting OS Boot Watchdog Timer Timeout configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `5-minutes` - Value - 5-minutes for configuring OsBootWatchdogTimerTimeout token. * `10-minutes` - Value - 10-minutes for configuring OsBootWatchdogTimerTimeout token. * `15-minutes` - Value - 15-minutes for configuring OsBootWatchdogTimerTimeout token. * `20-minutes` - Value - 20-minutes for configuring OsBootWatchdogTimerTimeout token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            out_of_band_mgmt_port (str): BIOS Token for setting Out-of-Band Mgmt Port configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            package_cstate_limit (str): BIOS Token for setting Package C State Limit configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PackageCstateLimit token. * `C0 C1 State` - Value - C0 C1 State for configuring PackageCstateLimit token. * `C0/C1` - Value - C0/C1 for configuring PackageCstateLimit token. * `C2` - Value - C2 for configuring PackageCstateLimit token. * `C6 Non Retention` - Value - C6 Non Retention for configuring PackageCstateLimit token. * `C6 Retention` - Value - C6 Retention for configuring PackageCstateLimit token. * `No Limit` - Value - No Limit for configuring PackageCstateLimit token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            panic_high_watermark (str): BIOS Token for setting Panic and High Watermark configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `High` - Value - High for configuring PanicHighWatermark token. * `Low` - Value - Low for configuring PanicHighWatermark token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_cache_line_sparing (str): BIOS Token for setting Partial Cache Line Sparing configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_mode_config (str): BIOS Token for setting Partial Memory Mirror Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring PartialMirrorModeConfig token. * `Percentage` - Value - Percentage for configuring PartialMirrorModeConfig token. * `Value in GB` - Value - Value in GiB for configuring PartialMirrorModeConfig token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_percent (str): BIOS Token for setting Partial Mirror Percentage configuration (0.00 - 50.00 Percentage).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_value1 (str): BIOS Token for setting Partial Mirror1 Size in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_value2 (str): BIOS Token for setting Partial Mirror2 Size in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_value3 (str): BIOS Token for setting Partial Mirror3 Size in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_value4 (str): BIOS Token for setting Partial Mirror4 Size in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            patrol_scrub (str): BIOS Token for setting Patrol Scrub configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring PatrolScrub token. * `Enable at End of POST` - Value - Enable at End of POST for configuring PatrolScrub token. * `enabled` - Value - enabled for configuring PatrolScrub token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            patrol_scrub_duration (str): BIOS Token for setting Patrol Scrub Interval configuration (5 - 23 Hour).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pc_ie_ras_support (str): BIOS Token for setting PCIe RAS Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pc_ie_ssd_hot_plug_support (str): BIOS Token for setting NVMe SSD Hot-Plug Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pch_usb30mode (str): BIOS Token for setting xHCI Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pci_option_ro_ms (str): BIOS Token for setting All PCIe Slots OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring PciOptionRoMs token. * `enabled` - Value - enabled for configuring PciOptionRoMs token. * `Legacy Only` - Value - Legacy Only for configuring PciOptionRoMs token. * `UEFI Only` - Value - UEFI Only for configuring PciOptionRoMs token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pci_rom_clp (str): BIOS Token for setting PCI ROM CLP configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_ari_support (str): BIOS Token for setting PCIe ARI Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieAriSupport token. * `disabled` - Value - disabled for configuring PcieAriSupport token. * `enabled` - Value - enabled for configuring PcieAriSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_pll_ssc (str): BIOS Token for setting PCIe PLL SSC configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PciePllSsc token. * `Disabled` - Value - Disabled for configuring PciePllSsc token. * `ZeroPointFive` - Value - ZeroPointFive for configuring PciePllSsc token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mraid1link_speed (str): BIOS Token for setting MRAID1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotMraid1linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotMraid1linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotMraid1linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotMraid1linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotMraid1linkSpeed token. * `GEN4` - Value - GEN4 for configuring PcieSlotMraid1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mraid1option_rom (str): BIOS Token for setting MRAID1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mraid2link_speed (str): BIOS Token for setting MRAID2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotMraid2linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotMraid2linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotMraid2linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotMraid2linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotMraid2linkSpeed token. * `GEN4` - Value - GEN4 for configuring PcieSlotMraid2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mraid2option_rom (str): BIOS Token for setting MRAID2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mstorraid_link_speed (str): BIOS Token for setting PCIe Slot MSTOR Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotMstorraidLinkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotMstorraidLinkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotMstorraidLinkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotMstorraidLinkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotMstorraidLinkSpeed token. * `GEN4` - Value - GEN4 for configuring PcieSlotMstorraidLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mstorraid_option_rom (str): BIOS Token for setting PCIe Slot MSTOR RAID OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme1link_speed (str): BIOS Token for setting NVME 1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme1linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme1linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme1linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme1linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme1option_rom (str): BIOS Token for setting NVME 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme2link_speed (str): BIOS Token for setting NVME 2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme2linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme2linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme2linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme2linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme2option_rom (str): BIOS Token for setting NVME 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme3link_speed (str): BIOS Token for setting NVME 3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme3linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme3linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme3linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme3linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme3option_rom (str): BIOS Token for setting NVME 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme4link_speed (str): BIOS Token for setting NVME 4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme4linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme4linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme4linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme4linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme4option_rom (str): BIOS Token for setting NVME 4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme5link_speed (str): BIOS Token for setting NVME 5 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme5linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme5linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme5linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme5linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme5option_rom (str): BIOS Token for setting NVME 5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme6link_speed (str): BIOS Token for setting NVME 6 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme6linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme6linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme6linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme6linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme6option_rom (str): BIOS Token for setting NVME 6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slots_cdn_enable (str): BIOS Token for setting PCIe Slots CDN Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pop_support (str): BIOS Token for setting Power ON Password configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            post_error_pause (str): BIOS Token for setting POST Error Pause configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            post_package_repair (str): BIOS Token for setting Post Package Repair configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disabled` - Value - Disabled for configuring PostPackageRepair token. * `Hard PPR` - Value - Hard PPR for configuring PostPackageRepair token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            processor_c1e (str): BIOS Token for setting Processor C1E configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            processor_c3report (str): BIOS Token for setting Processor C3 Report configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            processor_c6report (str): BIOS Token for setting Processor C6 Report configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            processor_cstate (str): BIOS Token for setting CPU C State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            psata (str): BIOS Token for setting P-SATA Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `AHCI` - Value - AHCI for configuring Psata token. * `Disabled` - Value - Disabled for configuring Psata token. * `LSI SW RAID` - Value - LSI SW RAID for configuring Psata token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pstate_coord_type (str): BIOS Token for setting P-STATE Coordination configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `HW ALL` - Value - HW ALL for configuring PstateCoordType token. * `SW ALL` - Value - SW ALL for configuring PstateCoordType token. * `SW ANY` - Value - SW ANY for configuring PstateCoordType token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            putty_key_pad (str): BIOS Token for setting Putty KeyPad configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `ESCN` - Value - ESCN for configuring PuttyKeyPad token. * `LINUX` - Value - LINUX for configuring PuttyKeyPad token. * `SCO` - Value - SCO for configuring PuttyKeyPad token. * `VT100` - Value - VT100 for configuring PuttyKeyPad token. * `VT400` - Value - VT400 for configuring PuttyKeyPad token. * `XTERMR6` - Value - XTERMR6 for configuring PuttyKeyPad token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pwr_perf_tuning (str): BIOS Token for setting Power Performance Tuning configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `bios` - Value - BIOS for configuring PwrPerfTuning token. * `os` - Value - os for configuring PwrPerfTuning token. * `peci` - Value - peci for configuring PwrPerfTuning token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            qpi_link_frequency (str): BIOS Token for setting QPI Link Frequency Select configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `6.4-gt/s` - Value - 6.4-gt/s for configuring QpiLinkFrequency token. * `7.2-gt/s` - Value - 7.2-gt/s for configuring QpiLinkFrequency token. * `8.0-gt/s` - Value - 8.0-gt/s for configuring QpiLinkFrequency token. * `9.6-gt/s` - Value - 9.6-gt/s for configuring QpiLinkFrequency token. * `auto` - Value - auto for configuring QpiLinkFrequency token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            qpi_link_speed (str): BIOS Token for setting UPI Link Frequency Select configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `10.4GT/s` - Value - 10.4GT/s for configuring QpiLinkSpeed token. * `11.2GT/s` - Value - 11.2GT/s for configuring QpiLinkSpeed token. * `9.6GT/s` - Value - 9.6GT/s for configuring QpiLinkSpeed token. * `Auto` - Value - Auto for configuring QpiLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            qpi_snoop_mode (str): BIOS Token for setting QPI Snoop Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring QpiSnoopMode token. * `cluster-on-die` - Value - cluster-on-die for configuring QpiSnoopMode token. * `early-snoop` - Value - early-snoop for configuring QpiSnoopMode token. * `home-directory-snoop` - Value - home-directory-snoop for configuring QpiSnoopMode token. * `home-directory-snoop-with-osb` - Value - home-directory-snoop-with-osb for configuring QpiSnoopMode token. * `home-snoop` - Value - home-snoop for configuring QpiSnoopMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            rank_inter_leave (str): BIOS Token for setting Rank Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1-way` - Value - 1-way for configuring RankInterLeave token. * `2-way` - Value - 2-way for configuring RankInterLeave token. * `4-way` - Value - 4-way for configuring RankInterLeave token. * `8-way` - Value - 8-way for configuring RankInterLeave token. * `auto` - Value - auto for configuring RankInterLeave token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            redirection_after_post (str): BIOS Token for setting Redirection After BIOS POST configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Always Enable` - Value - Always Enable for configuring RedirectionAfterPost token. * `Bootloader` - Value - Bootloader for configuring RedirectionAfterPost token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sata_mode_select (str): BIOS Token for setting SATA Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `AHCI` - Value - AHCI for configuring SataModeSelect token. * `Disabled` - Value - Disabled for configuring SataModeSelect token. * `LSI SW RAID` - Value - LSI SW RAID for configuring SataModeSelect token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            select_memory_ras_configuration (str): BIOS Token for setting Memory RAS Configuration configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `adddc-sparing` - Value - adddc-sparing for configuring SelectMemoryRasConfiguration token. * `lockstep` - Value - lockstep for configuring SelectMemoryRasConfiguration token. * `maximum-performance` - Value - maximum-performance for configuring SelectMemoryRasConfiguration token. * `mirror-mode-1lm` - Value - mirror-mode-1lm for configuring SelectMemoryRasConfiguration token. * `mirroring` - Value - mirroring for configuring SelectMemoryRasConfiguration token. * `partial-mirror-mode-1lm` - Value - partial-mirror-mode-1lm for configuring SelectMemoryRasConfiguration token. * `sparing` - Value - sparing for configuring SelectMemoryRasConfiguration token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            select_ppr_type (str): BIOS Token for setting PPR Type configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SelectPprType token. * `Hard PPR` - Value - Hard PPR for configuring SelectPprType token. * `Soft PPR` - Value - Soft PPR for configuring SelectPprType token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            serial_port_aenable (str): BIOS Token for setting Serial A Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sev (str): BIOS Token for setting Secured Encrypted Virtualization configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `253 ASIDs` - Value - 253 ASIDs for configuring Sev token. * `509 ASIDs` - Value - 509 ASIDs for configuring Sev token. * `Auto` - Value - Auto for configuring Sev token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_auto_registration_agent (str): BIOS Token for setting SGX Auto MP Registration Agent configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_epoch0 (str): BIOS Token for setting SGX Epoch 0 configuration (0 - ffffffffffffffff Hash byte 7-0).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_epoch1 (str): BIOS Token for setting SGX Epoch 1 configuration (0 - ffffffffffffffff Hash byte 7-0).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_factory_reset (str): BIOS Token for setting SGX Factory Reset configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_pub_key_hash0 (str): BIOS Token for setting SGX PubKey Hash0 configuration (0 - ffffffffffffffff Hash byte 7-0).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_pub_key_hash1 (str): BIOS Token for setting SGX PubKey Hash1 configuration (0 - ffffffffffffffff Hash byte 15-8).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_pub_key_hash2 (str): BIOS Token for setting SGX PubKey Hash2 configuration (0 - ffffffffffffffff Hash byte 23-16).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_pub_key_hash3 (str): BIOS Token for setting SGX PubKey Hash3 configuration (0 - ffffffffffffffff Hash byte 31-24).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_wr (str): BIOS Token for setting SGX Write Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_package_info_in_band_access (str): BIOS Token for setting SGX Package Information In-Band Access configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_qos (str): BIOS Token for setting SGX QoS configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sha1pcr_bank (str): BIOS Token for setting SHA-1 PCR Bank configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sha256pcr_bank (str): BIOS Token for setting SHA256 PCR Bank configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            single_pctl_enable (str): BIOS Token for setting Single PCTL configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `No` - Value - No for configuring SinglePctlEnable token. * `Yes` - Value - Yes for configuring SinglePctlEnable token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot10link_speed (str): BIOS Token for setting PCIe Slot:10 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot10linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot10linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot10linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot10linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot10linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot10state (str): BIOS Token for setting Slot 10 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot10state token. * `enabled` - Value - enabled for configuring Slot10state token. * `Legacy Only` - Value - Legacy Only for configuring Slot10state token. * `UEFI Only` - Value - UEFI Only for configuring Slot10state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot11link_speed (str): BIOS Token for setting PCIe Slot:11 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot11linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot11linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot11linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot11linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot11linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot11state (str): BIOS Token for setting Slot 11 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot12link_speed (str): BIOS Token for setting PCIe Slot:12 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot12linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot12linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot12linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot12linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot12linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot12state (str): BIOS Token for setting Slot 12 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot13state (str): BIOS Token for setting Slot 13 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot14state (str): BIOS Token for setting Slot 14 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot1link_speed (str): BIOS Token for setting PCIe Slot: 1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot1linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot1linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot1linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot1linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot1linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot1state (str): BIOS Token for setting Slot 1 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot1state token. * `enabled` - Value - enabled for configuring Slot1state token. * `Legacy Only` - Value - Legacy Only for configuring Slot1state token. * `UEFI Only` - Value - UEFI Only for configuring Slot1state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot2link_speed (str): BIOS Token for setting PCIe Slot: 2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot2linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot2linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot2linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot2linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot2linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot2state (str): BIOS Token for setting Slot 2 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot2state token. * `enabled` - Value - enabled for configuring Slot2state token. * `Legacy Only` - Value - Legacy Only for configuring Slot2state token. * `UEFI Only` - Value - UEFI Only for configuring Slot2state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot3link_speed (str): BIOS Token for setting PCIe Slot: 3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot3linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot3linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot3linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot3linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot3linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot3state (str): BIOS Token for setting Slot 3 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot3state token. * `enabled` - Value - enabled for configuring Slot3state token. * `Legacy Only` - Value - Legacy Only for configuring Slot3state token. * `UEFI Only` - Value - UEFI Only for configuring Slot3state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot4link_speed (str): BIOS Token for setting PCIe Slot: 4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot4linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot4linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot4linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot4linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot4linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot4state (str): BIOS Token for setting Slot 4 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot4state token. * `enabled` - Value - enabled for configuring Slot4state token. * `Legacy Only` - Value - Legacy Only for configuring Slot4state token. * `UEFI Only` - Value - UEFI Only for configuring Slot4state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot5link_speed (str): BIOS Token for setting PCIe Slot: 5 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot5linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot5linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot5linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot5linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot5linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot5state (str): BIOS Token for setting Slot 5 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot5state token. * `enabled` - Value - enabled for configuring Slot5state token. * `Legacy Only` - Value - Legacy Only for configuring Slot5state token. * `UEFI Only` - Value - UEFI Only for configuring Slot5state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot6link_speed (str): BIOS Token for setting PCIe Slot: 6 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot6linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot6linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot6linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot6linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot6linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot6state (str): BIOS Token for setting Slot 6 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot6state token. * `enabled` - Value - enabled for configuring Slot6state token. * `Legacy Only` - Value - Legacy Only for configuring Slot6state token. * `UEFI Only` - Value - UEFI Only for configuring Slot6state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot7link_speed (str): BIOS Token for setting PCIe Slot: 7 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot7linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot7linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot7linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot7linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot7linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot7linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot7state (str): BIOS Token for setting Slot 7 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot7state token. * `enabled` - Value - enabled for configuring Slot7state token. * `Legacy Only` - Value - Legacy Only for configuring Slot7state token. * `UEFI Only` - Value - UEFI Only for configuring Slot7state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot8link_speed (str): BIOS Token for setting PCIe Slot: 8 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot8linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot8linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot8linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot8linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot8linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot8linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot8state (str): BIOS Token for setting Slot 8 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot8state token. * `enabled` - Value - enabled for configuring Slot8state token. * `Legacy Only` - Value - Legacy Only for configuring Slot8state token. * `UEFI Only` - Value - UEFI Only for configuring Slot8state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot9link_speed (str): BIOS Token for setting PCIe Slot: 9 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot9linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot9linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot9linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot9linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot9linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot9linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot9state (str): BIOS Token for setting Slot 9 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot9state token. * `enabled` - Value - enabled for configuring Slot9state token. * `Legacy Only` - Value - Legacy Only for configuring Slot9state token. * `UEFI Only` - Value - UEFI Only for configuring Slot9state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_flom_link_speed (str): BIOS Token for setting PCIe Slot:FLOM Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFlomLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFlomLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFlomLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFlomLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFlomLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme10link_speed (str): BIOS Token for setting Front NVME 10 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme10linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme10linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme10linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme10linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme10linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme10linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme10option_rom (str): BIOS Token for setting Front NVME 10 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme11link_speed (str): BIOS Token for setting Front NVME 11 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme11linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme11linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme11linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme11linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme11linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme11linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme11option_rom (str): BIOS Token for setting Front NVME 11 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme12link_speed (str): BIOS Token for setting Front NVME 12 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme12linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme12linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme12linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme12linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme12linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme12linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme12option_rom (str): BIOS Token for setting Front NVME 12 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme13option_rom (str): BIOS Token for setting Front NVME 13 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme14option_rom (str): BIOS Token for setting Front NVME 14 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme15option_rom (str): BIOS Token for setting Front NVME 15 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme16option_rom (str): BIOS Token for setting Front NVME 16 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme17option_rom (str): BIOS Token for setting Front NVME 17 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme18option_rom (str): BIOS Token for setting Front NVME 18 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme19option_rom (str): BIOS Token for setting Front NVME 19 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme1link_speed (str): BIOS Token for setting PCIe Slot:Front NVME 1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme1linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme1option_rom (str): BIOS Token for setting Front NVME 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme20option_rom (str): BIOS Token for setting Front NVME 20 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme21option_rom (str): BIOS Token for setting Front NVME 21 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme22option_rom (str): BIOS Token for setting Front NVME 22 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme23option_rom (str): BIOS Token for setting Front NVME 23 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme24option_rom (str): BIOS Token for setting Front NVME 24 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme2link_speed (str): BIOS Token for setting PCIe Slot:Front NVME 2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme2linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme2option_rom (str): BIOS Token for setting Front NVME 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme3link_speed (str): BIOS Token for setting Front NVME 3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme3linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme3linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme3linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme3linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme3linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme3option_rom (str): BIOS Token for setting Front NVME 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme4link_speed (str): BIOS Token for setting Front NVME 4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme4linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme4linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme4linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme4linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme4linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme4option_rom (str): BIOS Token for setting Front NVME 4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme5link_speed (str): BIOS Token for setting Front NVME 5 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme5linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme5linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme5linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme5linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme5linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme5option_rom (str): BIOS Token for setting Front NVME 5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme6link_speed (str): BIOS Token for setting Front NVME 6 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme6linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme6linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme6linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme6linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme6linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme6option_rom (str): BIOS Token for setting Front NVME 6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme7link_speed (str): BIOS Token for setting Front NVME 7 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme7linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme7linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme7linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme7linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme7linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme7linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme7option_rom (str): BIOS Token for setting Front NVME 7 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme8link_speed (str): BIOS Token for setting Front NVME 8 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme8linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme8linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme8linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme8linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme8linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme8linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme8option_rom (str): BIOS Token for setting Front NVME 8 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme9link_speed (str): BIOS Token for setting Front NVME 9 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme9linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme9linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme9linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme9linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme9linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme9linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme9option_rom (str): BIOS Token for setting Front NVME 9 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_slot5link_speed (str): BIOS Token for setting PCIe Slot:Front1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontSlot5linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontSlot5linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontSlot5linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontSlot5linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontSlot5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_slot6link_speed (str): BIOS Token for setting PCIe Slot:Front2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontSlot6linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontSlot6linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontSlot6linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontSlot6linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontSlot6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu1state (str): BIOS Token for setting GPU 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu2state (str): BIOS Token for setting GPU 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu3state (str): BIOS Token for setting GPU 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu4state (str): BIOS Token for setting GPU 4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu5state (str): BIOS Token for setting GPU 5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu6state (str): BIOS Token for setting GPU 6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu7state (str): BIOS Token for setting GPU 7 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu8state (str): BIOS Token for setting GPU 8 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_hba_link_speed (str): BIOS Token for setting PCIe Slot:HBA Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotHbaLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotHbaLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotHbaLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotHbaLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotHbaLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_hba_state (str): BIOS Token for setting PCIe Slot:HBA OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotHbaState token. * `enabled` - Value - enabled for configuring SlotHbaState token. * `Legacy Only` - Value - Legacy Only for configuring SlotHbaState token. * `UEFI Only` - Value - UEFI Only for configuring SlotHbaState token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_lom1link (str): BIOS Token for setting PCIe LOM:1 Link configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_lom2link (str): BIOS Token for setting PCIe LOM:2 Link configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mezz_state (str): BIOS Token for setting Slot Mezz State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotMezzState token. * `enabled` - Value - enabled for configuring SlotMezzState token. * `Legacy Only` - Value - Legacy Only for configuring SlotMezzState token. * `UEFI Only` - Value - UEFI Only for configuring SlotMezzState token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mlom_link_speed (str): BIOS Token for setting PCIe Slot:MLOM Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotMlomLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotMlomLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotMlomLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotMlomLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotMlomLinkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotMlomLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mlom_state (str): BIOS Token for setting PCIe Slot MLOM OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotMlomState token. * `enabled` - Value - enabled for configuring SlotMlomState token. * `Legacy Only` - Value - Legacy Only for configuring SlotMlomState token. * `UEFI Only` - Value - UEFI Only for configuring SlotMlomState token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mraid_link_speed (str): BIOS Token for setting MRAID Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotMraidLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotMraidLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotMraidLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotMraidLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotMraidLinkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotMraidLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mraid_state (str): BIOS Token for setting PCIe Slot MRAID OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n10state (str): BIOS Token for setting PCIe Slot N10 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n11state (str): BIOS Token for setting PCIe Slot N11 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n12state (str): BIOS Token for setting PCIe Slot N12 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n13state (str): BIOS Token for setting PCIe Slot N13 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n14state (str): BIOS Token for setting PCIe Slot N14 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n15state (str): BIOS Token for setting PCIe Slot N15 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n16state (str): BIOS Token for setting PCIe Slot N16 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n17state (str): BIOS Token for setting PCIe Slot N17 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n18state (str): BIOS Token for setting PCIe Slot N18 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n19state (str): BIOS Token for setting PCIe Slot N19 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n1state (str): BIOS Token for setting PCIe Slot N1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotN1state token. * `enabled` - Value - enabled for configuring SlotN1state token. * `Legacy Only` - Value - Legacy Only for configuring SlotN1state token. * `UEFI Only` - Value - UEFI Only for configuring SlotN1state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n20state (str): BIOS Token for setting PCIe Slot N20 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n21state (str): BIOS Token for setting PCIe Slot N21 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n22state (str): BIOS Token for setting PCIe Slot N22 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n23state (str): BIOS Token for setting PCIe Slot N23 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n24state (str): BIOS Token for setting PCIe Slot N24 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n2state (str): BIOS Token for setting PCIe Slot N2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotN2state token. * `enabled` - Value - enabled for configuring SlotN2state token. * `Legacy Only` - Value - Legacy Only for configuring SlotN2state token. * `UEFI Only` - Value - UEFI Only for configuring SlotN2state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n3state (str): BIOS Token for setting PCIe Slot N3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n4state (str): BIOS Token for setting PCIe Slot N4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n5state (str): BIOS Token for setting PCIe Slot N5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n6state (str): BIOS Token for setting PCIe Slot N6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n7state (str): BIOS Token for setting PCIe Slot N7 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n8state (str): BIOS Token for setting PCIe Slot N8 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n9state (str): BIOS Token for setting PCIe Slot N9 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_raid_link_speed (str): BIOS Token for setting RAID Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRaidLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRaidLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRaidLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRaidLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRaidLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_raid_state (str): BIOS Token for setting PCIe Slot RAID OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme1link_speed (str): BIOS Token for setting PCIe Slot:Rear NVME 1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRearNvme1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRearNvme1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRearNvme1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRearNvme1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRearNvme1linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotRearNvme1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme1state (str): BIOS Token for setting PCIe Slot:Rear NVME 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme2link_speed (str): BIOS Token for setting PCIe Slot:Rear NVME 2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRearNvme2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRearNvme2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRearNvme2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRearNvme2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRearNvme2linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotRearNvme2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme2state (str): BIOS Token for setting PCIe Slot:Rear NVME 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme3link_speed (str): BIOS Token for setting Rear NVME 3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRearNvme3linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRearNvme3linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRearNvme3linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRearNvme3linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRearNvme3linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotRearNvme3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme3state (str): BIOS Token for setting PCIe Slot:Rear NVME 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme4link_speed (str): BIOS Token for setting Rear NVME 4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRearNvme4linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRearNvme4linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRearNvme4linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRearNvme4linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRearNvme4linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotRearNvme4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme4state (str): BIOS Token for setting PCIe Slot:Rear NVME 4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme5state (str): BIOS Token for setting PCIe Slot:Rear NVME 5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme6state (str): BIOS Token for setting PCIe Slot:Rear NVME 6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme7state (str): BIOS Token for setting PCIe Slot:Rear NVME 7 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme8state (str): BIOS Token for setting PCIe Slot:Rear NVME 8 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser1link_speed (str): BIOS Token for setting PCIe Slot:Riser1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser1slot1link_speed (str): BIOS Token for setting PCIe Slot:Riser1 Slot1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser1slot1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser1slot1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser1slot1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser1slot1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser1slot1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser1slot2link_speed (str): BIOS Token for setting PCIe Slot:Riser1 Slot2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser1slot2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser1slot2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser1slot2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser1slot2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser1slot2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser1slot3link_speed (str): BIOS Token for setting PCIe Slot:Riser1 Slot3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser1slot3linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser1slot3linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser1slot3linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser1slot3linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser1slot3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser2link_speed (str): BIOS Token for setting PCIe Slot:Riser2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser2slot4link_speed (str): BIOS Token for setting PCIe Slot:Riser2 Slot4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser2slot4linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser2slot4linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser2slot4linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser2slot4linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser2slot4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser2slot5link_speed (str): BIOS Token for setting PCIe Slot:Riser2 Slot5 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser2slot5linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser2slot5linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser2slot5linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser2slot5linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser2slot5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser2slot6link_speed (str): BIOS Token for setting PCIe Slot:Riser2 Slot6 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser2slot6linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser2slot6linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser2slot6linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser2slot6linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser2slot6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_sas_state (str): BIOS Token for setting PCIe Slot:SAS OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotSasState token. * `enabled` - Value - enabled for configuring SlotSasState token. * `Legacy Only` - Value - Legacy Only for configuring SlotSasState token. * `UEFI Only` - Value - UEFI Only for configuring SlotSasState token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_ssd_slot1link_speed (str): BIOS Token for setting PCIe Slot:FrontSSD1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotSsdSlot1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotSsdSlot1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotSsdSlot1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotSsdSlot1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotSsdSlot1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_ssd_slot2link_speed (str): BIOS Token for setting PCIe Slot:FrontSSD2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotSsdSlot2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotSsdSlot2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotSsdSlot2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotSsdSlot2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotSsdSlot2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            smee (str): BIOS Token for setting SMEE configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            smt_mode (str): BIOS Token for setting SMT Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SmtMode token. * `Off` - Value - Off for configuring SmtMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            snc (str): BIOS Token for setting Sub Numa Clustering configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Snc token. * `disabled` - Value - disabled for configuring Snc token. * `enabled` - Value - enabled for configuring Snc token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            snoopy_mode_for2lm (str): BIOS Token for setting Snoopy Mode for 2LM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            snoopy_mode_for_ad (str): BIOS Token for setting Snoopy Mode for AD configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sparing_mode (str): BIOS Token for setting Sparing Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `dimm-sparing` - Value - dimm-sparing for configuring SparingMode token. * `rank-sparing` - Value - rank-sparing for configuring SparingMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sr_iov (str): BIOS Token for setting SR-IOV Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            streamer_prefetch (str): BIOS Token for setting DCU Streamer Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            svm_mode (str): BIOS Token for setting SVM Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            terminal_type (str): BIOS Token for setting Terminal Type configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `pc-ansi` - Value - pc-ansi for configuring TerminalType token. * `vt100` - Value - vt100 for configuring TerminalType token. * `vt100-plus` - Value - vt100-plus for configuring TerminalType token. * `vt-utf8` - Value - vt-utf8 for configuring TerminalType token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tpm_control (str): BIOS Token for setting Trusted Platform Module State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tpm_pending_operation (str): BIOS Token for setting TPM Pending Operation configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `None` - Value - None for configuring TpmPendingOperation token. * `TpmClear` - Value - TpmClear for configuring TpmPendingOperation token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tpm_ppi_required (str): BIOS Token for setting TPM Minimal Physical Presence configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tpm_support (str): BIOS Token for setting TPM Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tsme (str): BIOS Token for setting Transparent Secure Memory Encryption configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Tsme token. * `disabled` - Value - disabled for configuring Tsme token. * `enabled` - Value - enabled for configuring Tsme token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            txt_support (str): BIOS Token for setting Intel Trusted Execution Technology Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ucsm_boot_order_rule (str): BIOS Token for setting Boot Order Rules configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Loose` - Value - Loose for configuring UcsmBootOrderRule token. * `Strict` - Value - Strict for configuring UcsmBootOrderRule token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ufs_disable (str): BIOS Token for setting Uncore Frequency Scaling configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            uma_based_clustering (str): BIOS Token for setting UMA Based Clustering configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disable (All2All)` - Value - Disable (All2All) for configuring UmaBasedClustering token. * `Hemisphere (2-clusters)` - Value - Hemisphere (2-clusters) for configuring UmaBasedClustering token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            upi_link_enablement (str): BIOS Token for setting UPI Link Enablement configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1` - Value - 1 for configuring UpiLinkEnablement token. * `2` - Value - 2 for configuring UpiLinkEnablement token. * `Auto` - Value - Auto for configuring UpiLinkEnablement token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            upi_power_management (str): BIOS Token for setting UPI Power Manangement configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_emul6064 (str): BIOS Token for setting Port 60/64 Emulation configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_front (str): BIOS Token for setting USB Port Front configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_internal (str): BIOS Token for setting USB Port Internal configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_kvm (str): BIOS Token for setting USB Port KVM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_rear (str): BIOS Token for setting USB Port Rear configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_sd_card (str): BIOS Token for setting USB Port SD Card configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_vmedia (str): BIOS Token for setting USB Port VMedia configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_xhci_support (str): BIOS Token for setting XHCI Legacy Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            vga_priority (str): BIOS Token for setting VGA Priority configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Offboard` - Value - Offboard for configuring VgaPriority token. * `Onboard` - Value - Onboard for configuring VgaPriority token. * `Onboard VGA Disabled` - Value - Onboard VGA Disabled for configuring VgaPriority token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            virtual_numa (str): BIOS Token for setting Virtual NUMA configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            vmd_enable (str): BIOS Token for setting VMD Enablement configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            vol_memory_mode (str): BIOS Token for setting Volatile Memory Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1LM` - Value - 1LM for configuring VolMemoryMode token. * `2LM` - Value - 2LM for configuring VolMemoryMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            work_load_config (str): BIOS Token for setting Workload Configuration configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Balanced` - Value - Balanced for configuring WorkLoadConfig token. * `I/O Sensitive` - Value - I/O Sensitive for configuring WorkLoadConfig token. * `NUMA` - Value - NUMA for configuring WorkLoadConfig token. * `UMA` - Value - UMA for configuring WorkLoadConfig token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            xpt_prefetch (str): BIOS Token for setting XPT Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring XptPrefetch token. * `disabled` - Value - disabled for configuring XptPrefetch token. * `enabled` - Value - enabled for configuring XptPrefetch token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            xpt_remote_prefetch (str): BIOS Token for setting XPT Remote Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring XptRemotePrefetch token. * `disabled` - Value - disabled for configuring XptRemotePrefetch token. * `enabled` - Value - enabled for configuring XptRemotePrefetch token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            organization (OrganizationOrganizationRelationship): [optional]  # noqa: E501
            profiles ([PolicyAbstractConfigProfileRelationship], none_type): An array of relationships to policyAbstractConfigProfile resources.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            description (str): Description of the policy.. [optional]  # noqa: E501
            name (str): Name of the concrete policy.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "bios.Policy")
        object_type = kwargs.get('object_type', "bios.Policy")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """BiosPolicy - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "bios.Policy", must be one of ["bios.Policy", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "bios.Policy", must be one of ["bios.Policy", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            acs_control_gpu1state (str): BIOS Token for setting ACS Control GPU 1 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu2state (str): BIOS Token for setting ACS Control GPU 2 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu3state (str): BIOS Token for setting ACS Control GPU 3 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu4state (str): BIOS Token for setting ACS Control GPU 4 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu5state (str): BIOS Token for setting ACS Control GPU 5 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu6state (str): BIOS Token for setting ACS Control GPU 6 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu7state (str): BIOS Token for setting ACS Control GPU 7 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_gpu8state (str): BIOS Token for setting ACS Control GPU 8 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_slot11state (str): BIOS Token for setting ACS Control Slot 11 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_slot12state (str): BIOS Token for setting ACS Control Slot 12 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_slot13state (str): BIOS Token for setting ACS Control Slot 13 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            acs_control_slot14state (str): BIOS Token for setting ACS Control Slot 14 configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            adjacent_cache_line_prefetch (str): BIOS Token for setting Adjacent Cache Line Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            advanced_mem_test (str): BIOS Token for setting Enhanced Memory Test configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring AdvancedMemTest token. * `disabled` - Value - disabled for configuring AdvancedMemTest token. * `enabled` - Value - enabled for configuring AdvancedMemTest token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            all_usb_devices (str): BIOS Token for setting All USB Devices configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            altitude (str): BIOS Token for setting Altitude configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `300-m` - Value - 300-m for configuring Altitude token. * `900-m` - Value - 900-m for configuring Altitude token. * `1500-m` - Value - 1500-m for configuring Altitude token. * `3000-m` - Value - 3000-m for configuring Altitude token. * `auto` - Value - auto for configuring Altitude token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            aspm_support (str): BIOS Token for setting ASPM Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring AspmSupport token. * `Disabled` - Value - Disabled for configuring AspmSupport token. * `Force L0s` - Value - Force L0s for configuring AspmSupport token. * `L1 Only` - Value - L1 Only for configuring AspmSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            assert_nmi_on_perr (str): BIOS Token for setting Assert NMI on PERR configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            assert_nmi_on_serr (str): BIOS Token for setting Assert NMI on SERR configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            auto_cc_state (str): BIOS Token for setting Autonomous Core C State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            autonumous_cstate_enable (str): BIOS Token for setting CPU Autonomous C State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            baud_rate (str): BIOS Token for setting Baud Rate configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `9600` - Value - 9600 for configuring BaudRate token. * `19200` - Value - 19200 for configuring BaudRate token. * `38400` - Value - 38400 for configuring BaudRate token. * `57600` - Value - 57600 for configuring BaudRate token. * `115200` - Value - 115200 for configuring BaudRate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            bme_dma_mitigation (str): BIOS Token for setting BME DMA Mitigation configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            boot_option_num_retry (str): BIOS Token for setting Number of Retries configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `5` - Value - 5 for configuring BootOptionNumRetry token. * `13` - Value - 13 for configuring BootOptionNumRetry token. * `Infinite` - Value - Infinite for configuring BootOptionNumRetry token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            boot_option_re_cool_down (str): BIOS Token for setting Cool Down Time  (sec) configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `15` - Value - 15 for configuring BootOptionReCoolDown token. * `45` - Value - 45 for configuring BootOptionReCoolDown token. * `90` - Value - 90 for configuring BootOptionReCoolDown token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            boot_option_retry (str): BIOS Token for setting Boot Option Retry configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            boot_performance_mode (str): BIOS Token for setting Boot Performance Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Max Efficient` - Value - Max Efficient for configuring BootPerformanceMode token. * `Max Performance` - Value - Max Performance for configuring BootPerformanceMode token. * `Set by Intel NM` - Value - Set by Intel NM for configuring BootPerformanceMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            burst_and_postponed_refresh (str): BIOS Token for setting Burst and Postponed Refresh configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            c1auto_demotion (str): BIOS Token for setting C1 Auto Demotion configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            c1auto_un_demotion (str): BIOS Token for setting C1 Auto UnDemotion configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_apbdis (str): BIOS Token for setting APBDIS configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `0` - Value - 0 for configuring CbsCmnApbdis token. * `1` - Value - 1 for configuring CbsCmnApbdis token. * `Auto` - Value - Auto for configuring CbsCmnApbdis token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_cpb (str): BIOS Token for setting Core Performance Boost configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuCpb token. * `disabled` - Value - disabled for configuring CbsCmnCpuCpb token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_gen_downcore_ctrl (str): BIOS Token for setting Downcore Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuGenDowncoreCtrl token. * `FOUR (2 + 2)` - Value - FOUR (2 + 2) for configuring CbsCmnCpuGenDowncoreCtrl token. * `FOUR (4 + 0)` - Value - FOUR (4 + 0) for configuring CbsCmnCpuGenDowncoreCtrl token. * `SIX (3 + 3)` - Value - SIX (3 + 3) for configuring CbsCmnCpuGenDowncoreCtrl token. * `THREE (3 + 0)` - Value - THREE (3 + 0) for configuring CbsCmnCpuGenDowncoreCtrl token. * `TWO (1 + 1)` - Value - TWO (1 + 1) for configuring CbsCmnCpuGenDowncoreCtrl token. * `TWO (2 + 0)` - Value - TWO (2 + 0) for configuring CbsCmnCpuGenDowncoreCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_global_cstate_ctrl (str): BIOS Token for setting Global C State Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuGlobalCstateCtrl token. * `disabled` - Value - disabled for configuring CbsCmnCpuGlobalCstateCtrl token. * `enabled` - Value - enabled for configuring CbsCmnCpuGlobalCstateCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_l1stream_hw_prefetcher (str): BIOS Token for setting L1 Stream HW Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuL1streamHwPrefetcher token. * `disabled` - Value - disabled for configuring CbsCmnCpuL1streamHwPrefetcher token. * `enabled` - Value - enabled for configuring CbsCmnCpuL1streamHwPrefetcher token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_l2stream_hw_prefetcher (str): BIOS Token for setting L2 Stream HW Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuL2streamHwPrefetcher token. * `disabled` - Value - disabled for configuring CbsCmnCpuL2streamHwPrefetcher token. * `enabled` - Value - enabled for configuring CbsCmnCpuL2streamHwPrefetcher token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_smee (str): BIOS Token for setting CPU SMEE configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuSmee token. * `disabled` - Value - disabled for configuring CbsCmnCpuSmee token. * `enabled` - Value - enabled for configuring CbsCmnCpuSmee token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_cpu_streaming_stores_ctrl (str): BIOS Token for setting Streaming Stores Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnCpuStreamingStoresCtrl token. * `disabled` - Value - disabled for configuring CbsCmnCpuStreamingStoresCtrl token. * `enabled` - Value - enabled for configuring CbsCmnCpuStreamingStoresCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_determinism_slider (str): BIOS Token for setting Determinism Slider configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnDeterminismSlider token. * `Performance` - Value - Performance for configuring CbsCmnDeterminismSlider token. * `Power` - Value - Power for configuring CbsCmnDeterminismSlider token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_efficiency_mode_en (str): BIOS Token for setting Efficiency Mode Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnEfficiencyModeEn token. * `Enabled` - Value - Enabled for configuring CbsCmnEfficiencyModeEn token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_fixed_soc_pstate (str): BIOS Token for setting Fixed SOC P-State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnFixedSocPstate token. * `P0` - Value - P0 for configuring CbsCmnFixedSocPstate token. * `P1` - Value - P1 for configuring CbsCmnFixedSocPstate token. * `P2` - Value - P2 for configuring CbsCmnFixedSocPstate token. * `P3` - Value - P3 for configuring CbsCmnFixedSocPstate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_gnb_nb_iommu (str): BIOS Token for setting IOMMU configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnGnbNbIommu token. * `disabled` - Value - disabled for configuring CbsCmnGnbNbIommu token. * `enabled` - Value - enabled for configuring CbsCmnGnbNbIommu token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_gnb_smu_df_cstates (str): BIOS Token for setting DF C-States configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnGnbSmuDfCstates token. * `disabled` - Value - disabled for configuring CbsCmnGnbSmuDfCstates token. * `enabled` - Value - enabled for configuring CbsCmnGnbSmuDfCstates token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_gnb_smucppc (str): BIOS Token for setting CPPC configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnGnbSmucppc token. * `disabled` - Value - disabled for configuring CbsCmnGnbSmucppc token. * `enabled` - Value - enabled for configuring CbsCmnGnbSmucppc token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_mem_ctrl_bank_group_swap_ddr4 (str): BIOS Token for setting Bank Group Swap configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnMemCtrlBankGroupSwapDdr4 token. * `disabled` - Value - disabled for configuring CbsCmnMemCtrlBankGroupSwapDdr4 token. * `enabled` - Value - enabled for configuring CbsCmnMemCtrlBankGroupSwapDdr4 token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmn_mem_map_bank_interleave_ddr4 (str): BIOS Token for setting Chipset Interleave configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmnMemMapBankInterleaveDdr4 token. * `disabled` - Value - disabled for configuring CbsCmnMemMapBankInterleaveDdr4 token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cmnc_tdp_ctl (str): BIOS Token for setting cTDP Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCmncTdpCtl token. * `Manual` - Value - Manual for configuring CbsCmncTdpCtl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cpu_ccd_ctrl_ssp (str): BIOS Token for setting CCD Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `2 CCDs` - Value - 2 CCDs for configuring CbsCpuCcdCtrlSsp token. * `3 CCDs` - Value - 3 CCDs for configuring CbsCpuCcdCtrlSsp token. * `4 CCDs` - Value - 4 CCDs for configuring CbsCpuCcdCtrlSsp token. * `6 CCDs` - Value - 6 CCDs for configuring CbsCpuCcdCtrlSsp token. * `Auto` - Value - Auto for configuring CbsCpuCcdCtrlSsp token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cpu_core_ctrl (str): BIOS Token for setting CPU Downcore control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCpuCoreCtrl token. * `FIVE (5 + 0)` - Value - FIVE (5 + 0) for configuring CbsCpuCoreCtrl token. * `FOUR (4 + 0)` - Value - FOUR (4 + 0) for configuring CbsCpuCoreCtrl token. * `ONE (1 + 0)` - Value - ONE (1 + 0) for configuring CbsCpuCoreCtrl token. * `SEVEN (7 + 0)` - Value - SEVEN (7 + 0) for configuring CbsCpuCoreCtrl token. * `SIX (6 + 0)` - Value - SIX (6 + 0) for configuring CbsCpuCoreCtrl token. * `THREE (3 + 0)` - Value - THREE (3 + 0) for configuring CbsCpuCoreCtrl token. * `TWO (2 + 0)` - Value - TWO (2 + 0) for configuring CbsCpuCoreCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_cpu_smt_ctrl (str): BIOS Token for setting CPU SMT Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsCpuSmtCtrl token. * `disabled` - Value - disabled for configuring CbsCpuSmtCtrl token. * `enabled` - Value - enabled for configuring CbsCpuSmtCtrl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_dbg_cpu_snp_mem_cover (str): BIOS Token for setting SNP Memory Coverage configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsDbgCpuSnpMemCover token. * `Custom` - Value - Custom for configuring CbsDbgCpuSnpMemCover token. * `disabled` - Value - disabled for configuring CbsDbgCpuSnpMemCover token. * `enabled` - Value - enabled for configuring CbsDbgCpuSnpMemCover token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_dbg_cpu_snp_mem_size_cover (str): BIOS Token for setting SNP Memory Size to Cover in MiB configuration (0 - 1048576 MiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_df_cmn_acpi_srat_l3numa (str): BIOS Token for setting ACPI SRAT L3 Cache As NUMA Domain configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsDfCmnAcpiSratL3numa token. * `disabled` - Value - disabled for configuring CbsDfCmnAcpiSratL3numa token. * `enabled` - Value - enabled for configuring CbsDfCmnAcpiSratL3numa token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_df_cmn_dram_nps (str): BIOS Token for setting NUMA Nodes per Socket configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsDfCmnDramNps token. * `NPS0` - Value - NPS0 for configuring CbsDfCmnDramNps token. * `NPS1` - Value - NPS1 for configuring CbsDfCmnDramNps token. * `NPS2` - Value - NPS2 for configuring CbsDfCmnDramNps token. * `NPS4` - Value - NPS4 for configuring CbsDfCmnDramNps token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_df_cmn_mem_intlv (str): BIOS Token for setting AMD Memory Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CbsDfCmnMemIntlv token. * `Channel` - Value - Channel for configuring CbsDfCmnMemIntlv token. * `Die` - Value - Die for configuring CbsDfCmnMemIntlv token. * `None` - Value - None for configuring CbsDfCmnMemIntlv token. * `Socket` - Value - Socket for configuring CbsDfCmnMemIntlv token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_df_cmn_mem_intlv_size (str): BIOS Token for setting AMD Memory Interleaving Size configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `256 Bytes` - Value - 256 Bytes for configuring CbsDfCmnMemIntlvSize token. * `512 Bytes` - Value - 512 Bytes for configuring CbsDfCmnMemIntlvSize token. * `1 KB` - Value - 1 KiB for configuring CbsDfCmnMemIntlvSize token. * `2 KB` - Value - 2 KiB for configuring CbsDfCmnMemIntlvSize token. * `4 KB` - Value - 4 KiB for configuring CbsDfCmnMemIntlvSize token. * `Auto` - Value - Auto for configuring CbsDfCmnMemIntlvSize token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cbs_sev_snp_support (str): BIOS Token for setting SEV-SNP Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cdn_enable (str): BIOS Token for setting Consistent Device Naming configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cdn_support (str): BIOS Token for setting CDN Support for LOM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring CdnSupport token. * `enabled` - Value - enabled for configuring CdnSupport token. * `LOMs Only` - Value - LOMs Only for configuring CdnSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            channel_inter_leave (str): BIOS Token for setting Channel Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1-way` - Value - 1-way for configuring ChannelInterLeave token. * `2-way` - Value - 2-way for configuring ChannelInterLeave token. * `3-way` - Value - 3-way for configuring ChannelInterLeave token. * `4-way` - Value - 4-way for configuring ChannelInterLeave token. * `auto` - Value - auto for configuring ChannelInterLeave token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cisco_adaptive_mem_training (str): BIOS Token for setting Adaptive Memory Training configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cisco_debug_level (str): BIOS Token for setting BIOS Techlog Level configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Maximum` - Value - Maximum for configuring CiscoDebugLevel token. * `Minimum` - Value - Minimum for configuring CiscoDebugLevel token. * `Normal` - Value - Normal for configuring CiscoDebugLevel token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cisco_oprom_launch_optimization (str): BIOS Token for setting OptionROM Launch Optimization configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cisco_xgmi_max_speed (str): BIOS Token for setting Cisco xGMI Max Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cke_low_policy (str): BIOS Token for setting CKE Low Policy configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring CkeLowPolicy token. * `disabled` - Value - disabled for configuring CkeLowPolicy token. * `fast` - Value - fast for configuring CkeLowPolicy token. * `slow` - Value - slow for configuring CkeLowPolicy token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            closed_loop_therm_throtl (str): BIOS Token for setting Closed Loop Thermal Throttling configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cmci_enable (str): BIOS Token for setting Processor CMCI configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            config_tdp (str): BIOS Token for setting Config TDP configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            config_tdp_level (str): BIOS Token for setting Configurable TDP Level configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Level 1` - Value - Level 1 for configuring ConfigTdpLevel token. * `Level 2` - Value - Level 2 for configuring ConfigTdpLevel token. * `Normal` - Value - Normal for configuring ConfigTdpLevel token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            console_redirection (str): BIOS Token for setting Console Redirection configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `com-0` - Value - com-0 for configuring ConsoleRedirection token. * `com-1` - Value - com-1 for configuring ConsoleRedirection token. * `disabled` - Value - disabled for configuring ConsoleRedirection token. * `enabled` - Value - enabled for configuring ConsoleRedirection token. * `serial-port-a` - Value - serial-port-a for configuring ConsoleRedirection token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            core_multi_processing (str): BIOS Token for setting Core Multi Processing configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1` - Value - 1 for configuring CoreMultiProcessing token. * `2` - Value - 2 for configuring CoreMultiProcessing token. * `3` - Value - 3 for configuring CoreMultiProcessing token. * `4` - Value - 4 for configuring CoreMultiProcessing token. * `5` - Value - 5 for configuring CoreMultiProcessing token. * `6` - Value - 6 for configuring CoreMultiProcessing token. * `7` - Value - 7 for configuring CoreMultiProcessing token. * `8` - Value - 8 for configuring CoreMultiProcessing token. * `9` - Value - 9 for configuring CoreMultiProcessing token. * `10` - Value - 10 for configuring CoreMultiProcessing token. * `11` - Value - 11 for configuring CoreMultiProcessing token. * `12` - Value - 12 for configuring CoreMultiProcessing token. * `13` - Value - 13 for configuring CoreMultiProcessing token. * `14` - Value - 14 for configuring CoreMultiProcessing token. * `15` - Value - 15 for configuring CoreMultiProcessing token. * `16` - Value - 16 for configuring CoreMultiProcessing token. * `17` - Value - 17 for configuring CoreMultiProcessing token. * `18` - Value - 18 for configuring CoreMultiProcessing token. * `19` - Value - 19 for configuring CoreMultiProcessing token. * `20` - Value - 20 for configuring CoreMultiProcessing token. * `21` - Value - 21 for configuring CoreMultiProcessing token. * `22` - Value - 22 for configuring CoreMultiProcessing token. * `23` - Value - 23 for configuring CoreMultiProcessing token. * `24` - Value - 24 for configuring CoreMultiProcessing token. * `25` - Value - 25 for configuring CoreMultiProcessing token. * `26` - Value - 26 for configuring CoreMultiProcessing token. * `27` - Value - 27 for configuring CoreMultiProcessing token. * `28` - Value - 28 for configuring CoreMultiProcessing token. * `29` - Value - 29 for configuring CoreMultiProcessing token. * `30` - Value - 30 for configuring CoreMultiProcessing token. * `31` - Value - 31 for configuring CoreMultiProcessing token. * `32` - Value - 32 for configuring CoreMultiProcessing token. * `33` - Value - 33 for configuring CoreMultiProcessing token. * `34` - Value - 34 for configuring CoreMultiProcessing token. * `35` - Value - 35 for configuring CoreMultiProcessing token. * `36` - Value - 36 for configuring CoreMultiProcessing token. * `37` - Value - 37 for configuring CoreMultiProcessing token. * `38` - Value - 38 for configuring CoreMultiProcessing token. * `39` - Value - 39 for configuring CoreMultiProcessing token. * `40` - Value - 40 for configuring CoreMultiProcessing token. * `41` - Value - 41 for configuring CoreMultiProcessing token. * `42` - Value - 42 for configuring CoreMultiProcessing token. * `43` - Value - 43 for configuring CoreMultiProcessing token. * `44` - Value - 44 for configuring CoreMultiProcessing token. * `45` - Value - 45 for configuring CoreMultiProcessing token. * `46` - Value - 46 for configuring CoreMultiProcessing token. * `47` - Value - 47 for configuring CoreMultiProcessing token. * `48` - Value - 48 for configuring CoreMultiProcessing token. * `all` - Value - all for configuring CoreMultiProcessing token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_energy_performance (str): BIOS Token for setting Energy Performance configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `balanced-energy` - Value - balanced-energy for configuring CpuEnergyPerformance token. * `balanced-performance` - Value - balanced-performance for configuring CpuEnergyPerformance token. * `balanced-power` - Value - balanced-power for configuring CpuEnergyPerformance token. * `energy-efficient` - Value - energy-efficient for configuring CpuEnergyPerformance token. * `performance` - Value - performance for configuring CpuEnergyPerformance token. * `power` - Value - power for configuring CpuEnergyPerformance token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_frequency_floor (str): BIOS Token for setting Frequency Floor Override configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_pa_limit (str): BIOS Token for setting Limit CPU PA to 46 Bits configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_perf_enhancement (str): BIOS Token for setting Enhanced CPU Performance configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CpuPerfEnhancement token. * `Disabled` - Value - Disabled for configuring CpuPerfEnhancement token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_performance (str): BIOS Token for setting CPU Performance configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `custom` - Value - custom for configuring CpuPerformance token. * `enterprise` - Value - enterprise for configuring CpuPerformance token. * `high-throughput` - Value - high-throughput for configuring CpuPerformance token. * `hpc` - Value - hpc for configuring CpuPerformance token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cpu_power_management (str): BIOS Token for setting Power Technology configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `custom` - Value - custom for configuring CpuPowerManagement token. * `disabled` - Value - disabled for configuring CpuPowerManagement token. * `energy-efficient` - Value - energy-efficient for configuring CpuPowerManagement token. * `performance` - Value - performance for configuring CpuPowerManagement token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            cr_qos (str): BIOS Token for setting CR QoS configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disabled` - Value - Disabled for configuring CrQos token. * `Mode 0 - Disable the PMem QoS Feature` - Value - Mode 0 - Disable the PMem QoS Feature for configuring CrQos token. * `Mode 1 - M2M QoS Enable and CHA QoS Disable` - Value - Mode 1 - M2M QoS Enable and CHA QoS Disable for configuring CrQos token. * `Mode 2 - M2M QoS Enable and CHA QoS Enable` - Value - Mode 2 - M2M QoS Enable and CHA QoS Enable for configuring CrQos token. * `Recipe 1` - Value - Recipe 1 for configuring CrQos token. * `Recipe 2` - Value - Recipe 2 for configuring CrQos token. * `Recipe 3` - Value - Recipe 3 for configuring CrQos token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            crfastgo_config (str): BIOS Token for setting CR FastGo Config configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring CrfastgoConfig token. * `Default` - Value - Default for configuring CrfastgoConfig token. * `Disable optimization` - Value - Disable optimization for configuring CrfastgoConfig token. * `Enable optimization` - Value - Enable optimization for configuring CrfastgoConfig token. * `Option 1` - Value - Option 1 for configuring CrfastgoConfig token. * `Option 2` - Value - Option 2 for configuring CrfastgoConfig token. * `Option 3` - Value - Option 3 for configuring CrfastgoConfig token. * `Option 4` - Value - Option 4 for configuring CrfastgoConfig token. * `Option 5` - Value - Option 5 for configuring CrfastgoConfig token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            dcpmm_firmware_downgrade (str): BIOS Token for setting DCPMM Firmware Downgrade configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            demand_scrub (str): BIOS Token for setting Demand Scrub configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            direct_cache_access (str): BIOS Token for setting Direct Cache Access Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring DirectCacheAccess token. * `disabled` - Value - disabled for configuring DirectCacheAccess token. * `enabled` - Value - enabled for configuring DirectCacheAccess token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            dram_clock_throttling (str): BIOS Token for setting DRAM Clock Throttling configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring DramClockThrottling token. * `Balanced` - Value - Balanced for configuring DramClockThrottling token. * `Energy Efficient` - Value - Energy Efficient for configuring DramClockThrottling token. * `Performance` - Value - Performance for configuring DramClockThrottling token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            dram_refresh_rate (str): BIOS Token for setting DRAM Refresh Rate configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1x` - Value - 1x for configuring DramRefreshRate token. * `2x` - Value - 2x for configuring DramRefreshRate token. * `3x` - Value - 3x for configuring DramRefreshRate token. * `4x` - Value - 4x for configuring DramRefreshRate token. * `Auto` - Value - Auto for configuring DramRefreshRate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            dram_sw_thermal_throttling (str): BIOS Token for setting DRAM SW Thermal Throttling configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            eadr_support (str): BIOS Token for setting eADR Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring EadrSupport token. * `disabled` - Value - disabled for configuring EadrSupport token. * `enabled` - Value - enabled for configuring EadrSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            edpc_en (str): BIOS Token for setting IIO eDPC Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disabled` - Value - Disabled for configuring EdpcEn token. * `On Fatal Error` - Value - On Fatal Error for configuring EdpcEn token. * `On Fatal and Non-Fatal Errors` - Value - On Fatal and Non-Fatal Errors for configuring EdpcEn token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enable_clock_spread_spec (str): BIOS Token for setting External SSC Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enable_mktme (str): BIOS Token for setting Multikey Total Memory Encryption  (MK-TME) configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enable_sgx (str): BIOS Token for setting Software Guard Extensions  (SGX) configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enable_tme (str): BIOS Token for setting Total Memory Encryption  (TME) configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            energy_efficient_turbo (str): BIOS Token for setting Energy Efficient Turbo configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            eng_perf_tuning (str): BIOS Token for setting Energy Performance Tuning configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `BIOS` - Value - BIOS for configuring EngPerfTuning token. * `OS` - Value - OS for configuring EngPerfTuning token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            enhanced_intel_speed_step_tech (str): BIOS Token for setting Enhanced Intel Speedstep (R) Technology configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            epoch_update (str): BIOS Token for setting Select Owner EPOCH Input Type configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Change to New Random Owner EPOCHs` - Value - Change to New Random Owner EPOCHs for configuring EpochUpdate token. * `Manual User Defined Owner EPOCHs` - Value - Manual User Defined Owner EPOCHs for configuring EpochUpdate token. * `SGX Owner EPOCH activated` - Value - SGX Owner EPOCH activated for configuring EpochUpdate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            epp_enable (str): BIOS Token for setting Processor EPP Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            epp_profile (str): BIOS Token for setting EPP Profile configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Balanced Performance` - Value - Balanced Performance for configuring EppProfile token. * `Balanced Power` - Value - Balanced Power for configuring EppProfile token. * `Performance` - Value - Performance for configuring EppProfile token. * `Power` - Value - Power for configuring EppProfile token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            execute_disable_bit (str): BIOS Token for setting Execute Disable Bit configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            extended_apic (str): BIOS Token for setting Local X2 Apic configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring ExtendedApic token. * `enabled` - Value - enabled for configuring ExtendedApic token. * `X2APIC` - Value - X2APIC for configuring ExtendedApic token. * `XAPIC` - Value - XAPIC for configuring ExtendedApic token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            flow_control (str): BIOS Token for setting Flow Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `none` - Value - none for configuring FlowControl token. * `rts-cts` - Value - rts-cts for configuring FlowControl token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            frb2enable (str): BIOS Token for setting FRB-2 Timer configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            hardware_prefetch (str): BIOS Token for setting Hardware Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            hwpm_enable (str): BIOS Token for setting CPU Hardware Power Management configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disabled` - Value - Disabled for configuring HwpmEnable token. * `HWPM Native Mode` - Value - HWPM Native Mode for configuring HwpmEnable token. * `HWPM OOB Mode` - Value - HWPM OOB Mode for configuring HwpmEnable token. * `NATIVE MODE` - Value - NATIVE MODE for configuring HwpmEnable token. * `Native Mode with no Legacy` - Value - Native Mode with no Legacy for configuring HwpmEnable token. * `OOB MODE` - Value - OOB MODE for configuring HwpmEnable token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            imc_interleave (str): BIOS Token for setting IMC Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1-way Interleave` - Value - 1-way Interleave for configuring ImcInterleave token. * `2-way Interleave` - Value - 2-way Interleave for configuring ImcInterleave token. * `Auto` - Value - Auto for configuring ImcInterleave token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_dynamic_speed_select (str): BIOS Token for setting Intel Dynamic Speed Select configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_hyper_threading_tech (str): BIOS Token for setting Intel HyperThreading Tech configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_speed_select (str): BIOS Token for setting Intel Speed Select configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Base` - Value - Base for configuring IntelSpeedSelect token. * `Config 1` - Value - Config 1 for configuring IntelSpeedSelect token. * `Config 2` - Value - Config 2 for configuring IntelSpeedSelect token. * `Config 3` - Value - Config 3 for configuring IntelSpeedSelect token. * `Config 4` - Value - Config 4 for configuring IntelSpeedSelect token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_turbo_boost_tech (str): BIOS Token for setting Intel Turbo Boost Tech configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_virtualization_technology (str): BIOS Token for setting Intel (R) VT configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vt_for_directed_io (str): BIOS Token for setting Intel VT for Directed IO configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vtd_coherency_support (str): BIOS Token for setting Intel (R) VT-d Coherency Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vtd_interrupt_remapping (str): BIOS Token for setting Intel (R) VT-d Interrupt Remapping configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vtd_pass_through_dma_support (str): BIOS Token for setting Intel (R) VT-d PassThrough DMA Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            intel_vtdats_support (str): BIOS Token for setting Intel VTD ATS Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ioh_error_enable (str): BIOS Token for setting IIO Error Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `No` - Value - No for configuring IohErrorEnable token. * `Yes` - Value - Yes for configuring IohErrorEnable token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ioh_resource (str): BIOS Token for setting IOH Resource Allocation configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `IOH0 24k IOH1 40k` - Value - IOH0 24k IOH1 40k for configuring IohResource token. * `IOH0 32k IOH1 32k` - Value - IOH0 32k IOH1 32k for configuring IohResource token. * `IOH0 40k IOH1 24k` - Value - IOH0 40k IOH1 24k for configuring IohResource token. * `IOH0 48k IOH1 16k` - Value - IOH0 48k IOH1 16k for configuring IohResource token. * `IOH0 56k IOH1 8k` - Value - IOH0 56k IOH1 8k for configuring IohResource token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ip_prefetch (str): BIOS Token for setting DCU IP Prefetcher configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ipv4http (str): BIOS Token for setting IPV4 HTTP Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ipv4pxe (str): BIOS Token for setting IPv4 PXE Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ipv6http (str): BIOS Token for setting IPV6 HTTP Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ipv6pxe (str): BIOS Token for setting IPV6 PXE Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            kti_prefetch (str): BIOS Token for setting KTI Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring KtiPrefetch token. * `disabled` - Value - disabled for configuring KtiPrefetch token. * `enabled` - Value - enabled for configuring KtiPrefetch token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            legacy_os_redirection (str): BIOS Token for setting Legacy OS Redirection configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            legacy_usb_support (str): BIOS Token for setting Legacy USB Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring LegacyUsbSupport token. * `disabled` - Value - disabled for configuring LegacyUsbSupport token. * `enabled` - Value - enabled for configuring LegacyUsbSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            llc_alloc (str): BIOS Token for setting LLC Dead Line configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring LlcAlloc token. * `disabled` - Value - disabled for configuring LlcAlloc token. * `enabled` - Value - enabled for configuring LlcAlloc token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            llc_prefetch (str): BIOS Token for setting LLC Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_port0state (str): BIOS Token for setting LOM Port 0 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring LomPort0state token. * `enabled` - Value - enabled for configuring LomPort0state token. * `Legacy Only` - Value - Legacy Only for configuring LomPort0state token. * `UEFI Only` - Value - UEFI Only for configuring LomPort0state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_port1state (str): BIOS Token for setting LOM Port 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring LomPort1state token. * `enabled` - Value - enabled for configuring LomPort1state token. * `Legacy Only` - Value - Legacy Only for configuring LomPort1state token. * `UEFI Only` - Value - UEFI Only for configuring LomPort1state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_port2state (str): BIOS Token for setting LOM Port 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring LomPort2state token. * `enabled` - Value - enabled for configuring LomPort2state token. * `Legacy Only` - Value - Legacy Only for configuring LomPort2state token. * `UEFI Only` - Value - UEFI Only for configuring LomPort2state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_port3state (str): BIOS Token for setting LOM Port 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring LomPort3state token. * `enabled` - Value - enabled for configuring LomPort3state token. * `Legacy Only` - Value - Legacy Only for configuring LomPort3state token. * `UEFI Only` - Value - UEFI Only for configuring LomPort3state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lom_ports_all_state (str): BIOS Token for setting All Onboard LOM Ports configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            lv_ddr_mode (str): BIOS Token for setting Low Voltage DDR Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring LvDdrMode token. * `performance-mode` - Value - performance-mode for configuring LvDdrMode token. * `power-saving-mode` - Value - power-saving-mode for configuring LvDdrMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            make_device_non_bootable (str): BIOS Token for setting Make Device Non Bootable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_bandwidth_boost (str): BIOS Token for setting Memory Bandwidth Boost configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_inter_leave (str): BIOS Token for setting Intel Memory Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1 Way Node Interleave` - Value - 1 Way Node Interleave for configuring MemoryInterLeave token. * `2 Way Node Interleave` - Value - 2 Way Node Interleave for configuring MemoryInterLeave token. * `4 Way Node Interleave` - Value - 4 Way Node Interleave for configuring MemoryInterLeave token. * `8 Way Node Interleave` - Value - 8 Way Node Interleave for configuring MemoryInterLeave token. * `disabled` - Value - disabled for configuring MemoryInterLeave token. * `enabled` - Value - enabled for configuring MemoryInterLeave token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_mapped_io_above4gb (str): BIOS Token for setting Memory Mapped IO above 4GiB configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_refresh_rate (str): BIOS Token for setting Memory Refresh Rate configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1x Refresh` - Value - 1x Refresh for configuring MemoryRefreshRate token. * `2x Refresh` - Value - 2x Refresh for configuring MemoryRefreshRate token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_size_limit (str): BIOS Token for setting Memory Size Limit in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            memory_thermal_throttling (str): BIOS Token for setting Memory Thermal Throttling Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `CLTT with PECI` - Value - CLTT with PECI for configuring MemoryThermalThrottling token. * `Disabled` - Value - Disabled for configuring MemoryThermalThrottling token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            mirroring_mode (str): BIOS Token for setting Mirroring Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `inter-socket` - Value - inter-socket for configuring MirroringMode token. * `intra-socket` - Value - intra-socket for configuring MirroringMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            mmcfg_base (str): BIOS Token for setting MMCFG BASE configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1 GB` - Value - 1 GiB for configuring MmcfgBase token. * `2 GB` - Value - 2 GiB for configuring MmcfgBase token. * `2.5 GB` - Value - 2.5 GiB for configuring MmcfgBase token. * `3 GB` - Value - 3 GiB for configuring MmcfgBase token. * `Auto` - Value - Auto for configuring MmcfgBase token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            network_stack (str): BIOS Token for setting Network Stack configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            numa_optimized (str): BIOS Token for setting NUMA Optimized configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            nvmdimm_perform_config (str): BIOS Token for setting NVM Performance Setting configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `BW Optimized` - Value - BW Optimized for configuring NvmdimmPerformConfig token. * `Balanced Profile` - Value - Balanced Profile for configuring NvmdimmPerformConfig token. * `Latency Optimized` - Value - Latency Optimized for configuring NvmdimmPerformConfig token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            onboard10gbit_lom (str): BIOS Token for setting Onboard 10Gbit LOM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            onboard_gbit_lom (str): BIOS Token for setting Onboard Gbit LOM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            onboard_scu_storage_support (str): BIOS Token for setting Onboard SCU Storage Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            onboard_scu_storage_sw_stack (str): BIOS Token for setting Onboard SCU Storage SW Stack configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Intel RSTe` - Value - Intel RSTe for configuring OnboardScuStorageSwStack token. * `LSI SW RAID` - Value - LSI SW RAID for configuring OnboardScuStorageSwStack token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            operation_mode (str): BIOS Token for setting Operation Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Test Only` - Value - Test Only for configuring OperationMode token. * `Test and Repair` - Value - Test and Repair for configuring OperationMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            os_boot_watchdog_timer (str): BIOS Token for setting OS Boot Watchdog Timer configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            os_boot_watchdog_timer_policy (str): BIOS Token for setting OS Boot Watchdog Timer Policy configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `do-nothing` - Value - do-nothing for configuring OsBootWatchdogTimerPolicy token. * `power-off` - Value - power-off for configuring OsBootWatchdogTimerPolicy token. * `reset` - Value - reset for configuring OsBootWatchdogTimerPolicy token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            os_boot_watchdog_timer_timeout (str): BIOS Token for setting OS Boot Watchdog Timer Timeout configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `5-minutes` - Value - 5-minutes for configuring OsBootWatchdogTimerTimeout token. * `10-minutes` - Value - 10-minutes for configuring OsBootWatchdogTimerTimeout token. * `15-minutes` - Value - 15-minutes for configuring OsBootWatchdogTimerTimeout token. * `20-minutes` - Value - 20-minutes for configuring OsBootWatchdogTimerTimeout token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            out_of_band_mgmt_port (str): BIOS Token for setting Out-of-Band Mgmt Port configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            package_cstate_limit (str): BIOS Token for setting Package C State Limit configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PackageCstateLimit token. * `C0 C1 State` - Value - C0 C1 State for configuring PackageCstateLimit token. * `C0/C1` - Value - C0/C1 for configuring PackageCstateLimit token. * `C2` - Value - C2 for configuring PackageCstateLimit token. * `C6 Non Retention` - Value - C6 Non Retention for configuring PackageCstateLimit token. * `C6 Retention` - Value - C6 Retention for configuring PackageCstateLimit token. * `No Limit` - Value - No Limit for configuring PackageCstateLimit token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            panic_high_watermark (str): BIOS Token for setting Panic and High Watermark configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `High` - Value - High for configuring PanicHighWatermark token. * `Low` - Value - Low for configuring PanicHighWatermark token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_cache_line_sparing (str): BIOS Token for setting Partial Cache Line Sparing configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_mode_config (str): BIOS Token for setting Partial Memory Mirror Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring PartialMirrorModeConfig token. * `Percentage` - Value - Percentage for configuring PartialMirrorModeConfig token. * `Value in GB` - Value - Value in GiB for configuring PartialMirrorModeConfig token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_percent (str): BIOS Token for setting Partial Mirror Percentage configuration (0.00 - 50.00 Percentage).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_value1 (str): BIOS Token for setting Partial Mirror1 Size in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_value2 (str): BIOS Token for setting Partial Mirror2 Size in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_value3 (str): BIOS Token for setting Partial Mirror3 Size in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            partial_mirror_value4 (str): BIOS Token for setting Partial Mirror4 Size in GiB configuration (0 - 65535 GiB).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            patrol_scrub (str): BIOS Token for setting Patrol Scrub configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring PatrolScrub token. * `Enable at End of POST` - Value - Enable at End of POST for configuring PatrolScrub token. * `enabled` - Value - enabled for configuring PatrolScrub token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            patrol_scrub_duration (str): BIOS Token for setting Patrol Scrub Interval configuration (5 - 23 Hour).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pc_ie_ras_support (str): BIOS Token for setting PCIe RAS Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pc_ie_ssd_hot_plug_support (str): BIOS Token for setting NVMe SSD Hot-Plug Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pch_usb30mode (str): BIOS Token for setting xHCI Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pci_option_ro_ms (str): BIOS Token for setting All PCIe Slots OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring PciOptionRoMs token. * `enabled` - Value - enabled for configuring PciOptionRoMs token. * `Legacy Only` - Value - Legacy Only for configuring PciOptionRoMs token. * `UEFI Only` - Value - UEFI Only for configuring PciOptionRoMs token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pci_rom_clp (str): BIOS Token for setting PCI ROM CLP configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_ari_support (str): BIOS Token for setting PCIe ARI Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieAriSupport token. * `disabled` - Value - disabled for configuring PcieAriSupport token. * `enabled` - Value - enabled for configuring PcieAriSupport token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_pll_ssc (str): BIOS Token for setting PCIe PLL SSC configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PciePllSsc token. * `Disabled` - Value - Disabled for configuring PciePllSsc token. * `ZeroPointFive` - Value - ZeroPointFive for configuring PciePllSsc token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mraid1link_speed (str): BIOS Token for setting MRAID1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotMraid1linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotMraid1linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotMraid1linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotMraid1linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotMraid1linkSpeed token. * `GEN4` - Value - GEN4 for configuring PcieSlotMraid1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mraid1option_rom (str): BIOS Token for setting MRAID1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mraid2link_speed (str): BIOS Token for setting MRAID2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotMraid2linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotMraid2linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotMraid2linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotMraid2linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotMraid2linkSpeed token. * `GEN4` - Value - GEN4 for configuring PcieSlotMraid2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mraid2option_rom (str): BIOS Token for setting MRAID2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mstorraid_link_speed (str): BIOS Token for setting PCIe Slot MSTOR Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotMstorraidLinkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotMstorraidLinkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotMstorraidLinkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotMstorraidLinkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotMstorraidLinkSpeed token. * `GEN4` - Value - GEN4 for configuring PcieSlotMstorraidLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_mstorraid_option_rom (str): BIOS Token for setting PCIe Slot MSTOR RAID OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme1link_speed (str): BIOS Token for setting NVME 1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme1linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme1linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme1linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme1linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme1option_rom (str): BIOS Token for setting NVME 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme2link_speed (str): BIOS Token for setting NVME 2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme2linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme2linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme2linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme2linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme2option_rom (str): BIOS Token for setting NVME 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme3link_speed (str): BIOS Token for setting NVME 3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme3linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme3linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme3linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme3linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme3option_rom (str): BIOS Token for setting NVME 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme4link_speed (str): BIOS Token for setting NVME 4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme4linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme4linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme4linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme4linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme4option_rom (str): BIOS Token for setting NVME 4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme5link_speed (str): BIOS Token for setting NVME 5 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme5linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme5linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme5linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme5linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme5option_rom (str): BIOS Token for setting NVME 5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme6link_speed (str): BIOS Token for setting NVME 6 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring PcieSlotNvme6linkSpeed token. * `Disabled` - Value - Disabled for configuring PcieSlotNvme6linkSpeed token. * `GEN1` - Value - GEN1 for configuring PcieSlotNvme6linkSpeed token. * `GEN2` - Value - GEN2 for configuring PcieSlotNvme6linkSpeed token. * `GEN3` - Value - GEN3 for configuring PcieSlotNvme6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slot_nvme6option_rom (str): BIOS Token for setting NVME 6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pcie_slots_cdn_enable (str): BIOS Token for setting PCIe Slots CDN Control configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pop_support (str): BIOS Token for setting Power ON Password configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            post_error_pause (str): BIOS Token for setting POST Error Pause configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            post_package_repair (str): BIOS Token for setting Post Package Repair configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disabled` - Value - Disabled for configuring PostPackageRepair token. * `Hard PPR` - Value - Hard PPR for configuring PostPackageRepair token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            processor_c1e (str): BIOS Token for setting Processor C1E configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            processor_c3report (str): BIOS Token for setting Processor C3 Report configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            processor_c6report (str): BIOS Token for setting Processor C6 Report configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            processor_cstate (str): BIOS Token for setting CPU C State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            psata (str): BIOS Token for setting P-SATA Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `AHCI` - Value - AHCI for configuring Psata token. * `Disabled` - Value - Disabled for configuring Psata token. * `LSI SW RAID` - Value - LSI SW RAID for configuring Psata token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pstate_coord_type (str): BIOS Token for setting P-STATE Coordination configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `HW ALL` - Value - HW ALL for configuring PstateCoordType token. * `SW ALL` - Value - SW ALL for configuring PstateCoordType token. * `SW ANY` - Value - SW ANY for configuring PstateCoordType token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            putty_key_pad (str): BIOS Token for setting Putty KeyPad configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `ESCN` - Value - ESCN for configuring PuttyKeyPad token. * `LINUX` - Value - LINUX for configuring PuttyKeyPad token. * `SCO` - Value - SCO for configuring PuttyKeyPad token. * `VT100` - Value - VT100 for configuring PuttyKeyPad token. * `VT400` - Value - VT400 for configuring PuttyKeyPad token. * `XTERMR6` - Value - XTERMR6 for configuring PuttyKeyPad token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            pwr_perf_tuning (str): BIOS Token for setting Power Performance Tuning configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `bios` - Value - BIOS for configuring PwrPerfTuning token. * `os` - Value - os for configuring PwrPerfTuning token. * `peci` - Value - peci for configuring PwrPerfTuning token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            qpi_link_frequency (str): BIOS Token for setting QPI Link Frequency Select configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `6.4-gt/s` - Value - 6.4-gt/s for configuring QpiLinkFrequency token. * `7.2-gt/s` - Value - 7.2-gt/s for configuring QpiLinkFrequency token. * `8.0-gt/s` - Value - 8.0-gt/s for configuring QpiLinkFrequency token. * `9.6-gt/s` - Value - 9.6-gt/s for configuring QpiLinkFrequency token. * `auto` - Value - auto for configuring QpiLinkFrequency token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            qpi_link_speed (str): BIOS Token for setting UPI Link Frequency Select configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `10.4GT/s` - Value - 10.4GT/s for configuring QpiLinkSpeed token. * `11.2GT/s` - Value - 11.2GT/s for configuring QpiLinkSpeed token. * `9.6GT/s` - Value - 9.6GT/s for configuring QpiLinkSpeed token. * `Auto` - Value - Auto for configuring QpiLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            qpi_snoop_mode (str): BIOS Token for setting QPI Snoop Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `auto` - Value - auto for configuring QpiSnoopMode token. * `cluster-on-die` - Value - cluster-on-die for configuring QpiSnoopMode token. * `early-snoop` - Value - early-snoop for configuring QpiSnoopMode token. * `home-directory-snoop` - Value - home-directory-snoop for configuring QpiSnoopMode token. * `home-directory-snoop-with-osb` - Value - home-directory-snoop-with-osb for configuring QpiSnoopMode token. * `home-snoop` - Value - home-snoop for configuring QpiSnoopMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            rank_inter_leave (str): BIOS Token for setting Rank Interleaving configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1-way` - Value - 1-way for configuring RankInterLeave token. * `2-way` - Value - 2-way for configuring RankInterLeave token. * `4-way` - Value - 4-way for configuring RankInterLeave token. * `8-way` - Value - 8-way for configuring RankInterLeave token. * `auto` - Value - auto for configuring RankInterLeave token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            redirection_after_post (str): BIOS Token for setting Redirection After BIOS POST configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Always Enable` - Value - Always Enable for configuring RedirectionAfterPost token. * `Bootloader` - Value - Bootloader for configuring RedirectionAfterPost token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sata_mode_select (str): BIOS Token for setting SATA Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `AHCI` - Value - AHCI for configuring SataModeSelect token. * `Disabled` - Value - Disabled for configuring SataModeSelect token. * `LSI SW RAID` - Value - LSI SW RAID for configuring SataModeSelect token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            select_memory_ras_configuration (str): BIOS Token for setting Memory RAS Configuration configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `adddc-sparing` - Value - adddc-sparing for configuring SelectMemoryRasConfiguration token. * `lockstep` - Value - lockstep for configuring SelectMemoryRasConfiguration token. * `maximum-performance` - Value - maximum-performance for configuring SelectMemoryRasConfiguration token. * `mirror-mode-1lm` - Value - mirror-mode-1lm for configuring SelectMemoryRasConfiguration token. * `mirroring` - Value - mirroring for configuring SelectMemoryRasConfiguration token. * `partial-mirror-mode-1lm` - Value - partial-mirror-mode-1lm for configuring SelectMemoryRasConfiguration token. * `sparing` - Value - sparing for configuring SelectMemoryRasConfiguration token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            select_ppr_type (str): BIOS Token for setting PPR Type configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SelectPprType token. * `Hard PPR` - Value - Hard PPR for configuring SelectPprType token. * `Soft PPR` - Value - Soft PPR for configuring SelectPprType token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            serial_port_aenable (str): BIOS Token for setting Serial A Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sev (str): BIOS Token for setting Secured Encrypted Virtualization configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `253 ASIDs` - Value - 253 ASIDs for configuring Sev token. * `509 ASIDs` - Value - 509 ASIDs for configuring Sev token. * `Auto` - Value - Auto for configuring Sev token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_auto_registration_agent (str): BIOS Token for setting SGX Auto MP Registration Agent configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_epoch0 (str): BIOS Token for setting SGX Epoch 0 configuration (0 - ffffffffffffffff Hash byte 7-0).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_epoch1 (str): BIOS Token for setting SGX Epoch 1 configuration (0 - ffffffffffffffff Hash byte 7-0).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_factory_reset (str): BIOS Token for setting SGX Factory Reset configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_pub_key_hash0 (str): BIOS Token for setting SGX PubKey Hash0 configuration (0 - ffffffffffffffff Hash byte 7-0).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_pub_key_hash1 (str): BIOS Token for setting SGX PubKey Hash1 configuration (0 - ffffffffffffffff Hash byte 15-8).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_pub_key_hash2 (str): BIOS Token for setting SGX PubKey Hash2 configuration (0 - ffffffffffffffff Hash byte 23-16).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_pub_key_hash3 (str): BIOS Token for setting SGX PubKey Hash3 configuration (0 - ffffffffffffffff Hash byte 31-24).. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_le_wr (str): BIOS Token for setting SGX Write Enable configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_package_info_in_band_access (str): BIOS Token for setting SGX Package Information In-Band Access configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sgx_qos (str): BIOS Token for setting SGX QoS configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sha1pcr_bank (str): BIOS Token for setting SHA-1 PCR Bank configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sha256pcr_bank (str): BIOS Token for setting SHA256 PCR Bank configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            single_pctl_enable (str): BIOS Token for setting Single PCTL configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `No` - Value - No for configuring SinglePctlEnable token. * `Yes` - Value - Yes for configuring SinglePctlEnable token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot10link_speed (str): BIOS Token for setting PCIe Slot:10 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot10linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot10linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot10linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot10linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot10linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot10state (str): BIOS Token for setting Slot 10 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot10state token. * `enabled` - Value - enabled for configuring Slot10state token. * `Legacy Only` - Value - Legacy Only for configuring Slot10state token. * `UEFI Only` - Value - UEFI Only for configuring Slot10state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot11link_speed (str): BIOS Token for setting PCIe Slot:11 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot11linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot11linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot11linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot11linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot11linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot11state (str): BIOS Token for setting Slot 11 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot12link_speed (str): BIOS Token for setting PCIe Slot:12 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot12linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot12linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot12linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot12linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot12linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot12state (str): BIOS Token for setting Slot 12 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot13state (str): BIOS Token for setting Slot 13 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot14state (str): BIOS Token for setting Slot 14 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot1link_speed (str): BIOS Token for setting PCIe Slot: 1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot1linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot1linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot1linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot1linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot1linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot1state (str): BIOS Token for setting Slot 1 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot1state token. * `enabled` - Value - enabled for configuring Slot1state token. * `Legacy Only` - Value - Legacy Only for configuring Slot1state token. * `UEFI Only` - Value - UEFI Only for configuring Slot1state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot2link_speed (str): BIOS Token for setting PCIe Slot: 2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot2linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot2linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot2linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot2linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot2linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot2state (str): BIOS Token for setting Slot 2 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot2state token. * `enabled` - Value - enabled for configuring Slot2state token. * `Legacy Only` - Value - Legacy Only for configuring Slot2state token. * `UEFI Only` - Value - UEFI Only for configuring Slot2state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot3link_speed (str): BIOS Token for setting PCIe Slot: 3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot3linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot3linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot3linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot3linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot3linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot3state (str): BIOS Token for setting Slot 3 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot3state token. * `enabled` - Value - enabled for configuring Slot3state token. * `Legacy Only` - Value - Legacy Only for configuring Slot3state token. * `UEFI Only` - Value - UEFI Only for configuring Slot3state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot4link_speed (str): BIOS Token for setting PCIe Slot: 4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot4linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot4linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot4linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot4linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot4linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot4state (str): BIOS Token for setting Slot 4 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot4state token. * `enabled` - Value - enabled for configuring Slot4state token. * `Legacy Only` - Value - Legacy Only for configuring Slot4state token. * `UEFI Only` - Value - UEFI Only for configuring Slot4state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot5link_speed (str): BIOS Token for setting PCIe Slot: 5 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot5linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot5linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot5linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot5linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot5linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot5state (str): BIOS Token for setting Slot 5 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot5state token. * `enabled` - Value - enabled for configuring Slot5state token. * `Legacy Only` - Value - Legacy Only for configuring Slot5state token. * `UEFI Only` - Value - UEFI Only for configuring Slot5state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot6link_speed (str): BIOS Token for setting PCIe Slot: 6 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot6linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot6linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot6linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot6linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot6linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot6state (str): BIOS Token for setting Slot 6 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot6state token. * `enabled` - Value - enabled for configuring Slot6state token. * `Legacy Only` - Value - Legacy Only for configuring Slot6state token. * `UEFI Only` - Value - UEFI Only for configuring Slot6state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot7link_speed (str): BIOS Token for setting PCIe Slot: 7 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot7linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot7linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot7linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot7linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot7linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot7linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot7state (str): BIOS Token for setting Slot 7 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot7state token. * `enabled` - Value - enabled for configuring Slot7state token. * `Legacy Only` - Value - Legacy Only for configuring Slot7state token. * `UEFI Only` - Value - UEFI Only for configuring Slot7state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot8link_speed (str): BIOS Token for setting PCIe Slot: 8 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot8linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot8linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot8linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot8linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot8linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot8linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot8state (str): BIOS Token for setting Slot 8 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot8state token. * `enabled` - Value - enabled for configuring Slot8state token. * `Legacy Only` - Value - Legacy Only for configuring Slot8state token. * `UEFI Only` - Value - UEFI Only for configuring Slot8state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot9link_speed (str): BIOS Token for setting PCIe Slot: 9 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Slot9linkSpeed token. * `Disabled` - Value - Disabled for configuring Slot9linkSpeed token. * `GEN1` - Value - GEN1 for configuring Slot9linkSpeed token. * `GEN2` - Value - GEN2 for configuring Slot9linkSpeed token. * `GEN3` - Value - GEN3 for configuring Slot9linkSpeed token. * `GEN4` - Value - GEN4 for configuring Slot9linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot9state (str): BIOS Token for setting Slot 9 State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring Slot9state token. * `enabled` - Value - enabled for configuring Slot9state token. * `Legacy Only` - Value - Legacy Only for configuring Slot9state token. * `UEFI Only` - Value - UEFI Only for configuring Slot9state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_flom_link_speed (str): BIOS Token for setting PCIe Slot:FLOM Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFlomLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFlomLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFlomLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFlomLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFlomLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme10link_speed (str): BIOS Token for setting Front NVME 10 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme10linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme10linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme10linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme10linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme10linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme10linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme10option_rom (str): BIOS Token for setting Front NVME 10 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme11link_speed (str): BIOS Token for setting Front NVME 11 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme11linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme11linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme11linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme11linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme11linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme11linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme11option_rom (str): BIOS Token for setting Front NVME 11 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme12link_speed (str): BIOS Token for setting Front NVME 12 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme12linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme12linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme12linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme12linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme12linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme12linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme12option_rom (str): BIOS Token for setting Front NVME 12 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme13option_rom (str): BIOS Token for setting Front NVME 13 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme14option_rom (str): BIOS Token for setting Front NVME 14 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme15option_rom (str): BIOS Token for setting Front NVME 15 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme16option_rom (str): BIOS Token for setting Front NVME 16 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme17option_rom (str): BIOS Token for setting Front NVME 17 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme18option_rom (str): BIOS Token for setting Front NVME 18 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme19option_rom (str): BIOS Token for setting Front NVME 19 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme1link_speed (str): BIOS Token for setting PCIe Slot:Front NVME 1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme1linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme1option_rom (str): BIOS Token for setting Front NVME 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme20option_rom (str): BIOS Token for setting Front NVME 20 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme21option_rom (str): BIOS Token for setting Front NVME 21 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme22option_rom (str): BIOS Token for setting Front NVME 22 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme23option_rom (str): BIOS Token for setting Front NVME 23 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme24option_rom (str): BIOS Token for setting Front NVME 24 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme2link_speed (str): BIOS Token for setting PCIe Slot:Front NVME 2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme2linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme2option_rom (str): BIOS Token for setting Front NVME 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme3link_speed (str): BIOS Token for setting Front NVME 3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme3linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme3linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme3linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme3linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme3linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme3option_rom (str): BIOS Token for setting Front NVME 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme4link_speed (str): BIOS Token for setting Front NVME 4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme4linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme4linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme4linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme4linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme4linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme4option_rom (str): BIOS Token for setting Front NVME 4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme5link_speed (str): BIOS Token for setting Front NVME 5 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme5linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme5linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme5linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme5linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme5linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme5option_rom (str): BIOS Token for setting Front NVME 5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme6link_speed (str): BIOS Token for setting Front NVME 6 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme6linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme6linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme6linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme6linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme6linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme6option_rom (str): BIOS Token for setting Front NVME 6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme7link_speed (str): BIOS Token for setting Front NVME 7 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme7linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme7linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme7linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme7linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme7linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme7linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme7option_rom (str): BIOS Token for setting Front NVME 7 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme8link_speed (str): BIOS Token for setting Front NVME 8 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme8linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme8linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme8linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme8linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme8linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme8linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme8option_rom (str): BIOS Token for setting Front NVME 8 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme9link_speed (str): BIOS Token for setting Front NVME 9 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontNvme9linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontNvme9linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontNvme9linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontNvme9linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontNvme9linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotFrontNvme9linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_nvme9option_rom (str): BIOS Token for setting Front NVME 9 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_slot5link_speed (str): BIOS Token for setting PCIe Slot:Front1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontSlot5linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontSlot5linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontSlot5linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontSlot5linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontSlot5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_front_slot6link_speed (str): BIOS Token for setting PCIe Slot:Front2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotFrontSlot6linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotFrontSlot6linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotFrontSlot6linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotFrontSlot6linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotFrontSlot6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu1state (str): BIOS Token for setting GPU 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu2state (str): BIOS Token for setting GPU 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu3state (str): BIOS Token for setting GPU 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu4state (str): BIOS Token for setting GPU 4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu5state (str): BIOS Token for setting GPU 5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu6state (str): BIOS Token for setting GPU 6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu7state (str): BIOS Token for setting GPU 7 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_gpu8state (str): BIOS Token for setting GPU 8 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_hba_link_speed (str): BIOS Token for setting PCIe Slot:HBA Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotHbaLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotHbaLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotHbaLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotHbaLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotHbaLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_hba_state (str): BIOS Token for setting PCIe Slot:HBA OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotHbaState token. * `enabled` - Value - enabled for configuring SlotHbaState token. * `Legacy Only` - Value - Legacy Only for configuring SlotHbaState token. * `UEFI Only` - Value - UEFI Only for configuring SlotHbaState token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_lom1link (str): BIOS Token for setting PCIe LOM:1 Link configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_lom2link (str): BIOS Token for setting PCIe LOM:2 Link configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mezz_state (str): BIOS Token for setting Slot Mezz State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotMezzState token. * `enabled` - Value - enabled for configuring SlotMezzState token. * `Legacy Only` - Value - Legacy Only for configuring SlotMezzState token. * `UEFI Only` - Value - UEFI Only for configuring SlotMezzState token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mlom_link_speed (str): BIOS Token for setting PCIe Slot:MLOM Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotMlomLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotMlomLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotMlomLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotMlomLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotMlomLinkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotMlomLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mlom_state (str): BIOS Token for setting PCIe Slot MLOM OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotMlomState token. * `enabled` - Value - enabled for configuring SlotMlomState token. * `Legacy Only` - Value - Legacy Only for configuring SlotMlomState token. * `UEFI Only` - Value - UEFI Only for configuring SlotMlomState token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mraid_link_speed (str): BIOS Token for setting MRAID Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotMraidLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotMraidLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotMraidLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotMraidLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotMraidLinkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotMraidLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_mraid_state (str): BIOS Token for setting PCIe Slot MRAID OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n10state (str): BIOS Token for setting PCIe Slot N10 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n11state (str): BIOS Token for setting PCIe Slot N11 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n12state (str): BIOS Token for setting PCIe Slot N12 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n13state (str): BIOS Token for setting PCIe Slot N13 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n14state (str): BIOS Token for setting PCIe Slot N14 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n15state (str): BIOS Token for setting PCIe Slot N15 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n16state (str): BIOS Token for setting PCIe Slot N16 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n17state (str): BIOS Token for setting PCIe Slot N17 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n18state (str): BIOS Token for setting PCIe Slot N18 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n19state (str): BIOS Token for setting PCIe Slot N19 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n1state (str): BIOS Token for setting PCIe Slot N1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotN1state token. * `enabled` - Value - enabled for configuring SlotN1state token. * `Legacy Only` - Value - Legacy Only for configuring SlotN1state token. * `UEFI Only` - Value - UEFI Only for configuring SlotN1state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n20state (str): BIOS Token for setting PCIe Slot N20 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n21state (str): BIOS Token for setting PCIe Slot N21 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n22state (str): BIOS Token for setting PCIe Slot N22 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n23state (str): BIOS Token for setting PCIe Slot N23 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n24state (str): BIOS Token for setting PCIe Slot N24 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n2state (str): BIOS Token for setting PCIe Slot N2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotN2state token. * `enabled` - Value - enabled for configuring SlotN2state token. * `Legacy Only` - Value - Legacy Only for configuring SlotN2state token. * `UEFI Only` - Value - UEFI Only for configuring SlotN2state token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n3state (str): BIOS Token for setting PCIe Slot N3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n4state (str): BIOS Token for setting PCIe Slot N4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n5state (str): BIOS Token for setting PCIe Slot N5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n6state (str): BIOS Token for setting PCIe Slot N6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n7state (str): BIOS Token for setting PCIe Slot N7 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n8state (str): BIOS Token for setting PCIe Slot N8 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_n9state (str): BIOS Token for setting PCIe Slot N9 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_raid_link_speed (str): BIOS Token for setting RAID Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRaidLinkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRaidLinkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRaidLinkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRaidLinkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRaidLinkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_raid_state (str): BIOS Token for setting PCIe Slot RAID OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme1link_speed (str): BIOS Token for setting PCIe Slot:Rear NVME 1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRearNvme1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRearNvme1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRearNvme1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRearNvme1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRearNvme1linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotRearNvme1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme1state (str): BIOS Token for setting PCIe Slot:Rear NVME 1 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme2link_speed (str): BIOS Token for setting PCIe Slot:Rear NVME 2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRearNvme2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRearNvme2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRearNvme2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRearNvme2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRearNvme2linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotRearNvme2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme2state (str): BIOS Token for setting PCIe Slot:Rear NVME 2 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme3link_speed (str): BIOS Token for setting Rear NVME 3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRearNvme3linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRearNvme3linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRearNvme3linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRearNvme3linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRearNvme3linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotRearNvme3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme3state (str): BIOS Token for setting PCIe Slot:Rear NVME 3 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme4link_speed (str): BIOS Token for setting Rear NVME 4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRearNvme4linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRearNvme4linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRearNvme4linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRearNvme4linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRearNvme4linkSpeed token. * `GEN4` - Value - GEN4 for configuring SlotRearNvme4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme4state (str): BIOS Token for setting PCIe Slot:Rear NVME 4 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme5state (str): BIOS Token for setting PCIe Slot:Rear NVME 5 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme6state (str): BIOS Token for setting PCIe Slot:Rear NVME 6 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme7state (str): BIOS Token for setting PCIe Slot:Rear NVME 7 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_rear_nvme8state (str): BIOS Token for setting PCIe Slot:Rear NVME 8 OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser1link_speed (str): BIOS Token for setting PCIe Slot:Riser1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser1slot1link_speed (str): BIOS Token for setting PCIe Slot:Riser1 Slot1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser1slot1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser1slot1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser1slot1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser1slot1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser1slot1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser1slot2link_speed (str): BIOS Token for setting PCIe Slot:Riser1 Slot2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser1slot2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser1slot2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser1slot2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser1slot2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser1slot2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser1slot3link_speed (str): BIOS Token for setting PCIe Slot:Riser1 Slot3 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser1slot3linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser1slot3linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser1slot3linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser1slot3linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser1slot3linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser2link_speed (str): BIOS Token for setting PCIe Slot:Riser2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser2slot4link_speed (str): BIOS Token for setting PCIe Slot:Riser2 Slot4 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser2slot4linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser2slot4linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser2slot4linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser2slot4linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser2slot4linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser2slot5link_speed (str): BIOS Token for setting PCIe Slot:Riser2 Slot5 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser2slot5linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser2slot5linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser2slot5linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser2slot5linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser2slot5linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_riser2slot6link_speed (str): BIOS Token for setting PCIe Slot:Riser2 Slot6 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotRiser2slot6linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotRiser2slot6linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotRiser2slot6linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotRiser2slot6linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotRiser2slot6linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_sas_state (str): BIOS Token for setting PCIe Slot:SAS OptionROM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `disabled` - Value - disabled for configuring SlotSasState token. * `enabled` - Value - enabled for configuring SlotSasState token. * `Legacy Only` - Value - Legacy Only for configuring SlotSasState token. * `UEFI Only` - Value - UEFI Only for configuring SlotSasState token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_ssd_slot1link_speed (str): BIOS Token for setting PCIe Slot:FrontSSD1 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotSsdSlot1linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotSsdSlot1linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotSsdSlot1linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotSsdSlot1linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotSsdSlot1linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            slot_ssd_slot2link_speed (str): BIOS Token for setting PCIe Slot:FrontSSD2 Link Speed configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SlotSsdSlot2linkSpeed token. * `Disabled` - Value - Disabled for configuring SlotSsdSlot2linkSpeed token. * `GEN1` - Value - GEN1 for configuring SlotSsdSlot2linkSpeed token. * `GEN2` - Value - GEN2 for configuring SlotSsdSlot2linkSpeed token. * `GEN3` - Value - GEN3 for configuring SlotSsdSlot2linkSpeed token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            smee (str): BIOS Token for setting SMEE configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            smt_mode (str): BIOS Token for setting SMT Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring SmtMode token. * `Off` - Value - Off for configuring SmtMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            snc (str): BIOS Token for setting Sub Numa Clustering configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Snc token. * `disabled` - Value - disabled for configuring Snc token. * `enabled` - Value - enabled for configuring Snc token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            snoopy_mode_for2lm (str): BIOS Token for setting Snoopy Mode for 2LM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            snoopy_mode_for_ad (str): BIOS Token for setting Snoopy Mode for AD configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sparing_mode (str): BIOS Token for setting Sparing Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `dimm-sparing` - Value - dimm-sparing for configuring SparingMode token. * `rank-sparing` - Value - rank-sparing for configuring SparingMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            sr_iov (str): BIOS Token for setting SR-IOV Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            streamer_prefetch (str): BIOS Token for setting DCU Streamer Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            svm_mode (str): BIOS Token for setting SVM Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            terminal_type (str): BIOS Token for setting Terminal Type configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `pc-ansi` - Value - pc-ansi for configuring TerminalType token. * `vt100` - Value - vt100 for configuring TerminalType token. * `vt100-plus` - Value - vt100-plus for configuring TerminalType token. * `vt-utf8` - Value - vt-utf8 for configuring TerminalType token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tpm_control (str): BIOS Token for setting Trusted Platform Module State configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tpm_pending_operation (str): BIOS Token for setting TPM Pending Operation configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `None` - Value - None for configuring TpmPendingOperation token. * `TpmClear` - Value - TpmClear for configuring TpmPendingOperation token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tpm_ppi_required (str): BIOS Token for setting TPM Minimal Physical Presence configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tpm_support (str): BIOS Token for setting TPM Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            tsme (str): BIOS Token for setting Transparent Secure Memory Encryption configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring Tsme token. * `disabled` - Value - disabled for configuring Tsme token. * `enabled` - Value - enabled for configuring Tsme token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            txt_support (str): BIOS Token for setting Intel Trusted Execution Technology Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ucsm_boot_order_rule (str): BIOS Token for setting Boot Order Rules configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Loose` - Value - Loose for configuring UcsmBootOrderRule token. * `Strict` - Value - Strict for configuring UcsmBootOrderRule token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            ufs_disable (str): BIOS Token for setting Uncore Frequency Scaling configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            uma_based_clustering (str): BIOS Token for setting UMA Based Clustering configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Disable (All2All)` - Value - Disable (All2All) for configuring UmaBasedClustering token. * `Hemisphere (2-clusters)` - Value - Hemisphere (2-clusters) for configuring UmaBasedClustering token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            upi_link_enablement (str): BIOS Token for setting UPI Link Enablement configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1` - Value - 1 for configuring UpiLinkEnablement token. * `2` - Value - 2 for configuring UpiLinkEnablement token. * `Auto` - Value - Auto for configuring UpiLinkEnablement token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            upi_power_management (str): BIOS Token for setting UPI Power Manangement configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_emul6064 (str): BIOS Token for setting Port 60/64 Emulation configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_front (str): BIOS Token for setting USB Port Front configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_internal (str): BIOS Token for setting USB Port Internal configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_kvm (str): BIOS Token for setting USB Port KVM configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_rear (str): BIOS Token for setting USB Port Rear configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_sd_card (str): BIOS Token for setting USB Port SD Card configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_port_vmedia (str): BIOS Token for setting USB Port VMedia configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            usb_xhci_support (str): BIOS Token for setting XHCI Legacy Support configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            vga_priority (str): BIOS Token for setting VGA Priority configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Offboard` - Value - Offboard for configuring VgaPriority token. * `Onboard` - Value - Onboard for configuring VgaPriority token. * `Onboard VGA Disabled` - Value - Onboard VGA Disabled for configuring VgaPriority token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            virtual_numa (str): BIOS Token for setting Virtual NUMA configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            vmd_enable (str): BIOS Token for setting VMD Enablement configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `enabled` - Enables the BIOS setting. * `disabled` - Disables the BIOS setting.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            vol_memory_mode (str): BIOS Token for setting Volatile Memory Mode configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `1LM` - Value - 1LM for configuring VolMemoryMode token. * `2LM` - Value - 2LM for configuring VolMemoryMode token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            work_load_config (str): BIOS Token for setting Workload Configuration configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Balanced` - Value - Balanced for configuring WorkLoadConfig token. * `I/O Sensitive` - Value - I/O Sensitive for configuring WorkLoadConfig token. * `NUMA` - Value - NUMA for configuring WorkLoadConfig token. * `UMA` - Value - UMA for configuring WorkLoadConfig token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            xpt_prefetch (str): BIOS Token for setting XPT Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring XptPrefetch token. * `disabled` - Value - disabled for configuring XptPrefetch token. * `enabled` - Value - enabled for configuring XptPrefetch token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            xpt_remote_prefetch (str): BIOS Token for setting XPT Remote Prefetch configuration. * `platform-default` - Default value used by the platform for the BIOS setting. * `Auto` - Value - Auto for configuring XptRemotePrefetch token. * `disabled` - Value - disabled for configuring XptRemotePrefetch token. * `enabled` - Value - enabled for configuring XptRemotePrefetch token.. [optional] if omitted the server will use the default value of "platform-default"  # noqa: E501
            organization (OrganizationOrganizationRelationship): [optional]  # noqa: E501
            profiles ([PolicyAbstractConfigProfileRelationship], none_type): An array of relationships to policyAbstractConfigProfile resources.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            description (str): Description of the policy.. [optional]  # noqa: E501
            name (str): Name of the concrete policy.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "bios.Policy")
        object_type = kwargs.get('object_type', "bios.Policy")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              BiosPolicyAllOf,
              PolicyAbstractPolicy,
          ],
          'oneOf': [
          ],
        }
