# Generated by Django 4.0.3 on 2022-05-29 04:44

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Backlog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='create time')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='latest update time')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='delete tag')),
                ('creator', models.CharField(max_length=64, null=True, verbose_name='creator')),
                ('receiver', models.CharField(max_length=64, verbose_name='receiver')),
                ('is_read', models.BooleanField(default=False, verbose_name='read status')),
                ('read_at', models.DateTimeField(null=True, verbose_name='read time')),
                ('is_done', models.BooleanField(default=False, verbose_name='completed status')),
                ('done_at', models.DateTimeField(null=True, verbose_name='completed datetime')),
                ('candidates', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=64), null=True, size=None, verbose_name='candidates')),
                ('handlers', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=64), null=True, size=None, verbose_name='handler')),
                ('initiator', models.CharField(max_length=64, null=True, verbose_name='initiator')),
                ('initiator_name', models.CharField(max_length=64, null=True, verbose_name='initiator name')),
                ('initiated_at', models.DateTimeField(null=True, verbose_name='initiated datetime')),
                ('obj_name', models.CharField(max_length=64, null=True, verbose_name='obj name')),
                ('obj_key', models.CharField(max_length=64, null=True, verbose_name='obj key')),
                ('obj_status', models.CharField(max_length=64, null=True, verbose_name='obj status')),
                ('batch', models.CharField(max_length=36, null=True, verbose_name='batch')),
                ('data', models.JSONField(null=True, verbose_name='data')),
                ('obj_associated_data', models.CharField(max_length=64, null=True, verbose_name='obj associated data')),
                ('obj_associated_data_type', models.CharField(max_length=64, null=True, verbose_name='obj associated data type')),
                ('company', models.CharField(max_length=64, null=True, verbose_name='company type')),
                ('company_type', models.CharField(max_length=64, null=True, verbose_name='company type')),
            ],
            options={
                'db_table': 'notice_backlog',
            },
        ),
        migrations.CreateModel(
            name='NoticeStore',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='create time')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='latest update time')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='delete tag')),
                ('title', models.CharField(max_length=64, null=True, verbose_name='title')),
                ('content', models.TextField(null=True, verbose_name='content')),
                ('receiver_type_ids', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None, verbose_name='receiver type')),
                ('is_draft', models.BooleanField(default=True, verbose_name='draft tag')),
                ('creator_id', models.IntegerField(verbose_name='creator id')),
                ('publish_at', models.DateTimeField(null=True, verbose_name='publish time')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NoticeType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='create time')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='latest update time')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='delete tag')),
                ('name', models.CharField(max_length=64, verbose_name='name')),
                ('desc', models.CharField(max_length=256, verbose_name='description')),
            ],
            options={
                'db_table': 'notice_type',
            },
        ),
        migrations.CreateModel(
            name='PrivateNotice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='create time')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='latest update time')),
                ('creator', models.CharField(max_length=64, null=True, verbose_name='creator')),
                ('receiver', models.CharField(max_length=64, verbose_name='receiver')),
                ('content', models.TextField(null=True, verbose_name='content')),
                ('title', models.CharField(max_length=64, null=True, verbose_name='title')),
                ('data', models.JSONField(null=True, verbose_name='data')),
                ('is_read', models.BooleanField(default=False, verbose_name='read status')),
                ('read_at', models.DateTimeField(null=True, verbose_name='read time')),
            ],
            options={
                'db_table': 'notice_private_notice',
            },
        ),
        migrations.CreateModel(
            name='ReceiverType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='create time')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='latest update time')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='delete tag')),
                ('name', models.CharField(max_length=64, verbose_name='name')),
                ('desc', models.CharField(max_length=256, verbose_name='description')),
            ],
            options={
                'db_table': 'notice_receiver_type',
            },
        ),
        migrations.CreateModel(
            name='ReceiverTag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='create time')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='latest update time')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='delete tag')),
                ('receiver', models.CharField(max_length=64, verbose_name='receiver')),
                ('read_at', models.DateTimeField(verbose_name='read time')),
                ('noticestore', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='notice.noticestore', verbose_name='notice')),
            ],
            options={
                'db_table': 'notice_receiver_tag',
            },
        ),
        migrations.AddField(
            model_name='noticestore',
            name='notice_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='notice.noticetype', verbose_name='notice type'),
        ),
    ]
