"""mstrio: Simple and Secure Access to MicroStrategy Data

Mstrio provides a high-level interface for Python and is designed
to give data scientists, developers, and administrators simple and secure
access to their MicroStrategy environment.

It wraps MicroStrategy REST APIs into simple workflows, allowing users
to fetch data from cubes and reports, create new datasets, add new data
to existing datasets, and manage Users/User Groups, Servers, Projects,
and more. Since it enforces MicroStrategy’s user and object security model,
you don’t need to worry about setting up separate security rules.

With mstrio-py for data science, it’s easy to integrate cross-departmental,
trustworthy business data in machine learning workflows and enable
decision-makers to take action on predictive insights in MicroStrategy Reports,
Dossiers, HyperIntelligence Cards, and customized, embedded analytical
applications.

With mstrio-py for system administration, it’s easy to minimize costs by
automating critical, time-consuming administrative tasks, even enabling
administrators to leverage the power of Python to address complex
administrative workflows for maintaining a MicroStrategy environment.

MicroStrategy for Jupyter is an extension for Jupyter Notebook which provides
a graphical user interface for mstrio-py methods with the help of which user
can perform all of the import and export actions without writing a single line
of code manually. MicroStrategy for Jupyter is contained within mstrio-py
package and is available after installation and enabling as Jupyter extension.
"""

__title__ = "mstrio-py"
__version__ = "11.3.9.101"  # NOSONAR
__license__ = "Apache License 2.0"
__description__ = "Python interface for the MicroStrategy REST API"
__author__ = "MicroStrategy"
__author_email__ = "pkowal@microstrategy.com"
