/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk.protobuf;

import aialgorithms.proto2.RecordProto2;
import com.amazonaws.services.sagemaker.sparksdk.protobuf.ProtobufConverter$;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class ProtobufConverter$ {
    public static final ProtobufConverter$ MODULE$;
    private final String ValuesIdentifierString;
    private final Integer magicNumber;
    private final byte[] magicNumberBytes;

    static {
        new ProtobufConverter$();
    }

    public String ValuesIdentifierString() {
        return this.ValuesIdentifierString;
    }

    public RecordProto2.Record rowToProtobuf(Row row, String featuresFieldName, Option<String> labelFieldName) {
        block8: {
            RecordProto2.Record.Builder protobufBuilder;
            block7: {
                boolean hasFeaturesColumn;
                block3: {
                    Object object;
                    block6: {
                        RecordProto2.Record.Builder builder;
                        block5: {
                            block4: {
                                boolean hasLabelColumn;
                                Predef$.MODULE$.require(row.schema() != null, (Function0)new Serializable(row){
                                    public static final long serialVersionUID = 0L;
                                    private final Row row$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Row schema is null for row ").append((Object)this.row$1).toString();
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                });
                                protobufBuilder = RecordProto2.Record.newBuilder();
                                Object object2 = labelFieldName.nonEmpty() ? ((hasLabelColumn = Predef$.MODULE$.refArrayOps((Object[])row.schema().fieldNames()).contains(labelFieldName.get())) ? this.setLabel(protobufBuilder, BoxesRunTime.unboxToDouble((Object)row.getAs((String)labelFieldName.get()))) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
                                hasFeaturesColumn = Predef$.MODULE$.refArrayOps((Object[])row.schema().fieldNames()).contains((Object)featuresFieldName);
                                if (!hasFeaturesColumn) break block3;
                                int idx = row.fieldIndex(featuresFieldName);
                                object = row.get(idx);
                                if (!(object instanceof Vector)) break block4;
                                Vector vector = (Vector)object;
                                builder = this.setFeatures(protobufBuilder, vector);
                                break block5;
                            }
                            if (!(object instanceof Matrix)) break block6;
                            Matrix matrix = (Matrix)object;
                            builder = this.setFeatures(protobufBuilder, matrix);
                        }
                        RecordProto2.Record.Builder target = builder;
                        break block7;
                    }
                    throw new MatchError(object);
                }
                if (!hasFeaturesColumn) break block8;
            }
            return protobufBuilder.build();
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Need a features column with a "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vector of doubles named ", " to convert row to protobuf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featuresFieldName}))).toString());
    }

    public Option<String> rowToProtobuf$default$3() {
        return Option$.MODULE$.empty();
    }

    public Iterator<RecordProto2.Record> recordIOByteArrayToProtobufs(byte[] byteArray) {
        MutableList recordList = new MutableList();
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        boolean index = false;
        while (buffer.hasRemaining()) {
            this.validateMagicNumber(Predef$.MODULE$.int2Integer(buffer.getInt()));
            byte[] recordBytes = new byte[buffer.getInt()];
            buffer.get(recordBytes, 0, recordBytes.length);
            RecordProto2.Record protobufRecord = this.byteArrayToProtobuf(recordBytes);
            recordList.$plus$eq((Object)protobufRecord);
            buffer.position(buffer.position() + this.paddingCount(buffer.position()));
        }
        return recordList.iterator();
    }

    private Integer magicNumber() {
        return this.magicNumber;
    }

    private byte[] magicNumberBytes() {
        return this.magicNumberBytes;
    }

    private byte[] intToLittleEndianByteArray(Integer n) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(Predef$.MODULE$.Integer2int(n)).array();
    }

    public byte[] byteArrayToRecordIOEncodedByteArray(byte[] byteArray) {
        byte[] recordLengthBytes = this.intToLittleEndianByteArray(Predef$.MODULE$.int2Integer(byteArray.length));
        ObjectRef recordIOBytes = ObjectRef.create((Object)((byte[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(this.magicNumberBytes()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(recordLengthBytes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(byteArray), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))));
        int paddingNeeded = this.paddingCount(((byte[])recordIOBytes.elem).length);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), paddingNeeded).foreach$mVc$sp((Function1)new Serializable(recordIOBytes){
            public static final long serialVersionUID = 0L;
            private final ObjectRef recordIOBytes$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.recordIOBytes$1.elem = (byte[])Predef$.MODULE$.byteArrayOps((byte[])this.recordIOBytes$1.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
            }
            {
                this.recordIOBytes$1 = recordIOBytes$1;
            }
        });
        return (byte[])recordIOBytes.elem;
    }

    public int paddingCount(int byteCount) {
        int mod = byteCount % 4;
        return mod == 0 ? 0 : 4 - mod;
    }

    public void validateMagicNumber(Integer recordDelimiter) {
        Integer n = recordDelimiter;
        Integer n2 = this.magicNumber();
        if (!(n != null ? !((Object)n).equals(n2) : n2 != null)) {
            return;
        }
        throw new RuntimeException("Incorrectly encoded byte array. Record delimiter did not match RecordIO magic number.");
    }

    public RecordProto2.Record byteArrayToProtobuf(byte[] byteArray) {
        return RecordProto2.Record.parseFrom(byteArray);
    }

    private RecordProto2.Record.Builder setLabel(RecordProto2.Record.Builder protobufBuilder, double label) {
        RecordProto2.Float32Tensor labelTensor = RecordProto2.Value.newBuilder().getFloat32TensorBuilder().addValues((float)label).build();
        RecordProto2.Value labelValue = RecordProto2.Value.newBuilder().setFloat32Tensor(labelTensor).build();
        RecordProto2.MapEntry mapEntry = RecordProto2.MapEntry.newBuilder().setKey(this.ValuesIdentifierString()).setValue(labelValue).build();
        return protobufBuilder.addLabel(mapEntry);
    }

    private RecordProto2.Record.Builder setFeatures(RecordProto2.Record.Builder protobufBuilder, Vector vector) {
        Vector vector2;
        block4: {
            RecordProto2.Float32Tensor float32Tensor;
            block3: {
                RecordProto2.Float32Tensor.Builder featuresTensorBuilder;
                block2: {
                    featuresTensorBuilder = RecordProto2.Value.newBuilder().getFloat32TensorBuilder();
                    vector2 = vector;
                    if (!(vector2 instanceof DenseVector)) break block2;
                    DenseVector denseVector = (DenseVector)vector2;
                    Predef$.MODULE$.doubleArrayOps(denseVector.values()).foreach((Function1)new Serializable(featuresTensorBuilder){
                        public static final long serialVersionUID = 0L;
                        private final RecordProto2.Float32Tensor.Builder featuresTensorBuilder$1;

                        public final RecordProto2.Float32Tensor.Builder apply(double value) {
                            return this.featuresTensorBuilder$1.addValues((float)value);
                        }
                        {
                            this.featuresTensorBuilder$1 = featuresTensorBuilder$1;
                        }
                    });
                    float32Tensor = featuresTensorBuilder.build();
                    break block3;
                }
                if (!(vector2 instanceof SparseVector)) break block4;
                SparseVector sparseVector = (SparseVector)vector2;
                featuresTensorBuilder.addShape(sparseVector.size());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sparseVector.indices().length).foreach((Function1)new Serializable(featuresTensorBuilder, sparseVector){
                    public static final long serialVersionUID = 0L;
                    private final RecordProto2.Float32Tensor.Builder featuresTensorBuilder$1;
                    private final SparseVector x3$1;

                    public final RecordProto2.Float32Tensor.Builder apply(int i) {
                        this.featuresTensorBuilder$1.addKeys(this.x3$1.indices()[i]);
                        return this.featuresTensorBuilder$1.addValues((float)this.x3$1.values()[i]);
                    }
                    {
                        this.featuresTensorBuilder$1 = featuresTensorBuilder$1;
                        this.x3$1 = x3$1;
                    }
                });
                float32Tensor = featuresTensorBuilder.build();
            }
            RecordProto2.Float32Tensor featuresTensor = float32Tensor;
            RecordProto2.Value featuresValue = RecordProto2.Value.newBuilder().setFloat32Tensor(featuresTensor).build();
            RecordProto2.MapEntry mapEntry = RecordProto2.MapEntry.newBuilder().setKey(this.ValuesIdentifierString()).setValue(featuresValue).build();
            return protobufBuilder.addFeatures(mapEntry);
        }
        throw new MatchError((Object)vector2);
    }

    private RecordProto2.Record.Builder setFeatures(RecordProto2.Record.Builder protobufBuilder, Matrix matrix) {
        Matrix matrix2;
        block7: {
            RecordProto2.Float32Tensor float32Tensor;
            block6: {
                RecordProto2.Float32Tensor.Builder featuresTensorBuilder;
                block5: {
                    featuresTensorBuilder = RecordProto2.Value.newBuilder().getFloat32TensorBuilder();
                    featuresTensorBuilder.addShape(matrix.numRows());
                    featuresTensorBuilder.addShape(matrix.numCols());
                    matrix2 = matrix;
                    if (!(matrix2 instanceof DenseMatrix)) break block5;
                    DenseMatrix denseMatrix = (DenseMatrix)matrix2;
                    if (denseMatrix.isTransposed()) {
                        Predef$.MODULE$.doubleArrayOps(denseMatrix.values()).foreach((Function1)new Serializable(featuresTensorBuilder){
                            public static final long serialVersionUID = 0L;
                            private final RecordProto2.Float32Tensor.Builder featuresTensorBuilder$2;

                            public final RecordProto2.Float32Tensor.Builder apply(double value) {
                                return this.featuresTensorBuilder$2.addValues((float)value);
                            }
                            {
                                this.featuresTensorBuilder$2 = featuresTensorBuilder$2;
                            }
                        });
                    } else {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), denseMatrix.numRows() - 1).foreach$mVc$sp((Function1)new Serializable(featuresTensorBuilder, denseMatrix){
                            public static final long serialVersionUID = 0L;
                            public final RecordProto2.Float32Tensor.Builder featuresTensorBuilder$2;
                            public final DenseMatrix x2$1;

                            public final void apply(int row) {
                                this.apply$mcVI$sp(row);
                            }

                            public void apply$mcVI$sp(int row) {
                                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.x2$1.numCols() - 1).foreach((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.1 $outer;
                                    private final int row$2;

                                    public final RecordProto2.Float32Tensor.Builder apply(int col) {
                                        return this.$outer.featuresTensorBuilder$2.addValues((float)this.$outer.x2$1.apply(this.row$2, col));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.row$2 = row$2;
                                    }
                                });
                            }
                            {
                                this.featuresTensorBuilder$2 = featuresTensorBuilder$2;
                                this.x2$1 = x2$1;
                            }
                        });
                    }
                    float32Tensor = featuresTensorBuilder.build();
                    break block6;
                }
                if (!(matrix2 instanceof SparseMatrix)) break block7;
                SparseMatrix sparseMatrix = (SparseMatrix)matrix2;
                IntRef rowIdx = IntRef.create((int)0);
                IntRef colIdx = IntRef.create((int)0);
                Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(sparseMatrix.colPtrs()).slice(1, Predef$.MODULE$.intArrayOps(sparseMatrix.colPtrs()).size())).foreach((Function1)new Serializable(featuresTensorBuilder, rowIdx, colIdx, sparseMatrix){
                    public static final long serialVersionUID = 0L;
                    private final RecordProto2.Float32Tensor.Builder featuresTensorBuilder$2;
                    private final IntRef rowIdx$1;
                    private final IntRef colIdx$1;
                    private final SparseMatrix x3$2;

                    public final void apply(int colStart) {
                        this.apply$mcVI$sp(colStart);
                    }

                    public void apply$mcVI$sp(int colStart) {
                        while (this.rowIdx$1.elem < colStart) {
                            RecordProto2.Float32Tensor.Builder builder = this.x3$2.isTransposed() ? this.featuresTensorBuilder$2.addKeys(this.colIdx$1.elem * this.x3$2.numCols() + this.x3$2.rowIndices()[this.rowIdx$1.elem]) : this.featuresTensorBuilder$2.addKeys(this.x3$2.rowIndices()[this.rowIdx$1.elem] * this.x3$2.numCols() + this.colIdx$1.elem);
                            ++this.rowIdx$1.elem;
                        }
                        ++this.colIdx$1.elem;
                    }
                    {
                        this.featuresTensorBuilder$2 = featuresTensorBuilder$2;
                        this.rowIdx$1 = rowIdx$1;
                        this.colIdx$1 = colIdx$1;
                        this.x3$2 = x3$2;
                    }
                });
                Predef$.MODULE$.doubleArrayOps(sparseMatrix.values()).foreach((Function1)new Serializable(featuresTensorBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RecordProto2.Float32Tensor.Builder featuresTensorBuilder$2;

                    public final RecordProto2.Float32Tensor.Builder apply(double value) {
                        return this.featuresTensorBuilder$2.addValues((float)value);
                    }
                    {
                        this.featuresTensorBuilder$2 = featuresTensorBuilder$2;
                    }
                });
                float32Tensor = featuresTensorBuilder.build();
            }
            RecordProto2.Float32Tensor featuresTensor = float32Tensor;
            RecordProto2.Value featuresValue = RecordProto2.Value.newBuilder().setFloat32Tensor(featuresTensor).build();
            RecordProto2.MapEntry mapEntry = RecordProto2.MapEntry.newBuilder().setKey(this.ValuesIdentifierString()).setValue(featuresValue).build();
            return protobufBuilder.addFeatures(mapEntry);
        }
        throw new MatchError((Object)matrix2);
    }

    private ProtobufConverter$() {
        MODULE$ = this;
        this.ValuesIdentifierString = "values";
        this.magicNumber = Predef$.MODULE$.int2Integer(-824761590);
        this.magicNumberBytes = this.intToLittleEndianByteArray(this.magicNumber());
    }
}

