# Compliance Overview

Auth0 maintains comprehensive compliance with major security standards and regulatory frameworks, providing organizations the foundation for building compliant identity solutions.

## Security Standards

### ISO 27001/27017/27018

Scope: Information security management, cloud security, and privacy protection.

Coverage:
- ISO 27001: Information security management system (ISMS)
- ISO 27017: Cloud-specific security controls
- ISO 27018: Protection of personal data in cloud

Verification:
- Annual independent audits
- Certificate renewal process
- Continuous compliance monitoring

### SOC 2 Type 2

Scope: Service organization controls covering security, availability, processing integrity, confidentiality, and privacy.

Coverage: All five Trust Services Criteria

Type 2 Significance:
- Tests operating effectiveness over time
- Not just point-in-time assessment
- Demonstrates sustained compliance

Audit Cycle: Annual independent audits

### CSA STAR

Cloud Security Alliance Security Trust Assurance and Risk.

Features:
- Cloud-specific security assessment
- Publicly available assessments
- Industry-recognized framework

Access: Self-assessment registry available publicly.

### PCI DSS

Payment Card Industry Data Security Standard.

Coverage:
- Compliant deployment models
- Documentation available for customers
- Supports payment processing requirements

Customer Responsibility:
- Must implement according to guidance
- Shared responsibility model
- Documentation of compliance measures

## Industry-Specific Compliance

### FAPI (Financial-grade API)

Financial-grade API security profiles by OpenID Foundation.

Certification:
- FAPI 1 Advanced OP
- mTLS client authentication
- Private Key JWT authentication

Features:
- Robust authentication requirements
- Enhanced authorization security
- Financial sector specifications

### HIPAA/HITECH

Health Insurance Portability and Accountability Act.

Auth0 Role: Functions as Business Associate

Features:
- Business Associate Agreements available
- Upon request from customers
- Technical safeguards implemented

Customer Responsibility:
- Implement required controls
- Execute BAA with Auth0
- Maintain compliance documentation

### PSD2 (Payment Services Directive 2)

European payment services regulation.

Supported Features:
- Strong Customer Authentication (SCA)
- Dynamic Linking for transactions
- Enhanced authentication requirements

## Data Protection

### GDPR

General Data Protection Regulation (EU).

Auth0 Status: GDPR ready

Role Distribution:
- Customer: Data Controller
- Auth0: Data Processor

Key Features:
- Data processing documentation
- User rights support
- Breach notification procedures

Customer Obligations:
- Define data processing purposes
- Manage user consent
- Handle user rights requests

### Data Handling

Auth0 Documentation:
- What data is stored
- How data is used
- Retention policies
- Processing activities

Data Location:
- Configurable region selection
- Data residency options
- Multi-region deployment

## Compliance Documentation Access

### Auth0 Support Center

Access compliance materials:
- Certificates
- Attestations
- Compliance reports

Requirements:
- Appropriate access level
- NDA where required
- Customer account

### Available Documents

Upon Request:
- SOC 2 Type 2 report
- ISO certificates
- Penetration test summaries
- PCI attestation

## Customer Responsibilities

### Shared Responsibility Model

Auth0 Responsibilities:
- Platform security
- Infrastructure compliance
- Security controls
- Compliance certifications

Customer Responsibilities:
- Application security
- Data classification
- Access management
- Compliance configuration

### Implementation Requirements

For Full Compliance:
- Configure Auth0 per compliance requirements
- Implement required security controls
- Document compliance measures
- Regular compliance review

## Compliance Features

### Security Controls

Available Features:
- Multi-factor authentication
- Encryption at rest and in transit
- Access logging
- Session management

Configuration:
- Enable required features
- Configure appropriate settings
- Monitor compliance status

### Audit Logging

Log Features:
- User activities
- Administrative actions
- Authentication events
- Security events

Log Management:
- Export capabilities
- Retention configuration
- SIEM integration

### Data Protection

Features:
- Encryption
- Access controls
- Data minimization
- Retention management

## Best Practices

### Compliance Assessment

Before Implementation:
1. Identify applicable regulations
2. Review Auth0 compliance coverage
3. Identify gaps and requirements
4. Plan implementation

### Configuration

During Implementation:
1. Enable required security features
2. Configure compliance settings
3. Implement audit logging
4. Test compliance controls

### Ongoing Compliance

Post-Implementation:
1. Regular compliance review
2. Monitor for changes
3. Update configurations
4. Maintain documentation

### Documentation

Maintain Records:
- Configuration decisions
- Compliance mappings
- Risk assessments
- Audit evidence

## Regulatory Updates

### Staying Current

Auth0 Resources:
- Compliance documentation updates
- Feature announcements
- Security bulletins

Customer Actions:
- Monitor regulatory changes
- Update configurations as needed
- Review compliance periodically
