# Philosopher Framework Reference

External resources and foundational materials for the Philosopher Framework.

## Origin and Inspiration

### Claude Code Philosopher Ignition

Repository: https://github.com/lmxxf/claude-code-philosopher-ignition

Key concepts adopted:
- Emphasis on reflection over calculation
- Assumption questioning methodology
- Strategic analysis for business and technical problems

### First Principles Thinking

Origin: Aristotelian philosophy, popularized in business by Elon Musk

Core concept: Break problems down to fundamental truths and reason up from there.

Recommended reading:
- "First Principles: Elon Musk on the Power of Thinking for Yourself" (Farnam Street)
- "The Art of Thinking Clearly" by Rolf Dobelli

### Stanford Design Thinking

Origin: Stanford d.school

Five phases:
1. Empathize: Understand the user
2. Define: State the problem
3. Ideate: Generate ideas
4. Prototype: Create solutions
5. Test: Validate solutions

Adopted concepts:
- Divergent-convergent thinking pattern
- Multiple alternative generation
- User-centered problem definition

### MIT Systems Engineering

Origin: MIT Engineering Systems Division

Key concepts:
- System decomposition and architecture
- Trade-off analysis and optimization
- Risk identification and mitigation
- Validation and verification strategies

Adopted concepts:
- Weighted trade-off matrices
- Risk assessment frameworks
- Validation criteria definition

## Cognitive Bias Research

### Foundational Works

"Thinking, Fast and Slow" by Daniel Kahneman
- System 1 vs System 2 thinking
- Cognitive biases catalog
- Decision-making under uncertainty

"Predictably Irrational" by Dan Ariely
- Behavioral economics perspective
- Common decision-making errors
- Practical implications

### Key Bias Definitions

Anchoring Bias:
- Original research: Tversky and Kahneman (1974)
- "Judgment under Uncertainty: Heuristics and Biases"

Confirmation Bias:
- Original research: Wason (1960)
- "On the failure to eliminate hypotheses in a conceptual task"

Sunk Cost Fallacy:
- Original research: Arkes and Blumer (1985)
- "The psychology of sunk cost"

## Decision-Making Frameworks

### OODA Loop

Origin: John Boyd, military strategy

Phases:
1. Observe: Gather information
2. Orient: Analyze and synthesize
3. Decide: Choose action
4. Act: Execute decision

Application: Fast decision cycles with feedback

### Kepner-Tregoe Decision Analysis

Origin: Kepner and Tregoe (1965)

Process:
1. Situation Appraisal
2. Problem Analysis
3. Decision Analysis
4. Potential Problem Analysis

Application: Structured problem-solving in organizations

### Six Thinking Hats

Origin: Edward de Bono

Hats:
- White: Facts and information
- Red: Emotions and intuition
- Black: Critical judgment
- Yellow: Optimistic assessment
- Green: Creative alternatives
- Blue: Process management

Application: Parallel thinking for group decisions

## Technical Decision Resources

### Architecture Decision Records (ADR)

Template: https://adr.github.io/

Purpose: Document significant architecture decisions with context and consequences.

Adopted concept: Decision documentation template structure

### Technology Radar

Origin: ThoughtWorks

Purpose: Track technology adoption maturity (Adopt, Trial, Assess, Hold)

Application: Technology selection guidance

## Further Reading

Books:
- "The Decision Book" by Mikael Krogerus
- "Superforecasting" by Philip Tetlock
- "Sources of Power" by Gary Klein

Articles:
- "How to Make Good Decisions" (Farnam Street)
- "Mental Models: The Best Way to Make Intelligent Decisions" (fs.blog)

---

Version: 1.0.0
Parent Skill: moai-foundation-philosopher
