# Assumption Matrix Module

Deep dive into systematic assumption identification and validation.

## Assumption Categories

### Technical Assumptions

Common technical assumptions to examine:
- Technology X can handle our scale requirements
- The API will maintain backward compatibility
- Performance will be acceptable with chosen approach
- Integration with existing system will be straightforward
- Development team has necessary expertise

Validation Methods:
- Proof of concept implementation
- Load testing and benchmarking
- API documentation and changelog review
- Architecture review with experienced engineers
- Skill assessment and training gap analysis

### Business Assumptions

Common business assumptions to examine:
- Users will adopt the new feature
- Budget will remain available
- Timeline is realistic
- Requirements are stable and well-understood
- Stakeholder priorities are aligned

Validation Methods:
- User research and feedback sessions
- Budget confirmation with finance
- Historical project data comparison
- Requirements review meetings
- Stakeholder alignment workshops

### Team Assumptions

Common team assumptions to examine:
- Team has capacity for this work
- Skills are available in-house
- Communication channels are effective
- Dependencies on other teams are manageable
- Knowledge transfer is not needed

Validation Methods:
- Capacity planning review
- Skills matrix assessment
- Team retrospective feedback
- Dependency mapping exercise
- Documentation audit

## Assumption Documentation Template

For each significant assumption:

Assumption ID: A-001
Statement: Clear description of what is assumed
Category: Technical, Business, or Team
Confidence: High, Medium, or Low
Evidence: What supports this assumption
Risk if Wrong: Impact on project if assumption fails
Validation Plan: How and when to verify
Owner: Who is responsible for validation
Status: Unvalidated, Validated, or Invalidated

## Integration with AskUserQuestion

When surfacing assumptions, use AskUserQuestion to:
- Confirm which assumptions are critical to validate
- Gather evidence from user's domain knowledge
- Prioritize assumption validation efforts
- Determine acceptable risk levels for unvalidated assumptions

---

Version: 1.0.0
Parent Skill: moai-foundation-philosopher
