# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['majormode', 'majormode.xebus', 'majormode.xebus.tools']

package_data = \
{'': ['*'], 'majormode.xebus.tools': ['fonts/*']}

install_requires = \
['Pillow>=9.2.0,<10.0.0',
 'Unidecode>=1.3.6,<2.0.0',
 'perseus-core-library>=1.18.17,<2.0.0',
 'qrcode>=7.3.1,<8.0.0']

setup_kwargs = {
    'name': 'xebus-id-card-image-generator',
    'version': '1.2.7',
    'description': 'Command-Line Interface (CLI) to generate JPEG images of Xebus ID cards',
    'long_description': '# Xebus ID Card Generator\n\n`Xebus ID Card Generator` is a Command-Line Interface (CLI) written in Python used to generate JPEG images of Xebus ID cards.\n\nThis script generates images which size has the same portrait ratio as [ISO/IEC 7810 Identification cards ID-1](https://en.wikipedia.org/wiki/ISO/IEC_7810#ID-1) (3 3⁄8 in × 2 1⁄8 in, 54mm x 85.6mm).\n\n## Installation\n\n`Xebus ID Card Generator` can be easily installed with [`pipenv`]cod(https://github.com/pypa/pipenv):\n\n```shell\n$ pipenv --python 3.8 shell\n$ pipenv install xebus-id-card-image-generator\n```\n\n_Note: As of October 2020, the Python Image Library (PIL) is not yet compatible with Python 3.9._\n\n## Execution\n\n```shell\n$ ./bin/xidgen --help\nusage: xidgen [-h] [-c TYPE] -f FILE [-d CHAR] [-q CHAR] [-e CHAR]\n              [-s GEOMETRY] [-p SIZE] --header-file FILE [--font-name NAME]\n\nXebus ID Card Images Generator\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -c TYPE, --card-type TYPE\n                        specify the type of ID cards to generate (driver,\n                        guardian, securityguard, student)\n  -f FILE, --csv-file FILE\n                        specify the absolute path and name of the CSV file\n                        containing the information of ID cards to generate\n  -d CHAR, --delimiter CHAR\n                        specify the character used to separate each field\n                        (default to character [,])\n  -q CHAR, --quotechar CHAR\n                        specify the character used to surround fields that\n                        contain the delimiter character (default to character\n                        ["]).\n  -e CHAR, --escapechar CHAR\n                        specify the character used to escape the delimiter\n                        character, in case quotes aren\'t used (default to\n                        character [None]).\n  -s GEOMETRY, --size GEOMETRY\n                        specify the width and/or height in pixels of the image\n                        to build, with the ratio of a CR80 standard credit\n                        card size ID-1 in portrait mode (54mm x 85.6mm)\n  -p SIZE, --padding SIZE\n                        specify the space in pixels or percentage to generate\n                        around the ID card\n  --header-file FILE    specify the absolute path name of the header image\n                        file\n  --font-name NAME      specify the name of the font to display the full name\n                        of each ID card\n  --name-format FORMAT  specify the format of ID card file name\n  --debug LEVEL         specify the logging level (value between 0 and 4, from\n                        critical to debug)\n```\n\nFor example:\n\n```bash\n$ xidgen --card-type student --header-file lfiduras_logo.jpg --csv-file lfiduras-students.csv\n```\n\nThe user can specify the file name of the ID card images by passing the argument `name-format`.  A ID card file name format MUST be composed of field names to build this file name with.  These field names MUST be defined in braces, each field names separated with a character underscore.  For example:\n\n```text\n{id}_{first name}_{grade level}\n```\n\n_Note: The accepted field names correspond to the CSV field names._\n\n### CSV File\n\nThe CSV file passed to the script MUST contain a first row corresponding to the header fields in whatever order:\n\n- `#` (optional): The identification of the registration file of the card owner (as provided by the organization that manages this list)\n- `ID` (required): The identification of the card owner\n- `Card Type` (optional): Specify the type of the ID card (`driver`, `guardian`, `securityguard`, or `student`)\n- `Class Name` (optional)\n- `First Name` (optional)\n- `Full Name` (required)\n- `Grade Level` (optional): The number of the year a pupil has reached in this given educational\n- `Grade Name` (optional): THe name given to this grade\n- `Last Name` (optional)\n\nFor example:\n\n| #             | ID                                   | First Name | Last Name | Full Name                   | Grade Level | Grade Name |\n|---------------|--------------------------------------|------------| --------- | --------------------------- | ----------- | ---------- |\n| `862-295-729` | 3a72a73e-c57b-11ea-8e0d-0008a20c190f | Céline     | CAUNE     | Céline Kim Anh CAUNE LÝ     | 16          | Terminale  |\n| `873-774-763` | d8be1eef-2493-11eb-9dcf-0007cb040bcc | Aline      | CAUNE     | Aline Minh Anh CAUNE LÝ     | 15          | Première   |\n| `457-128-612` | f6315b69-11af-11eb-bb6b-0007cb040bcc | Éline      | CAUNE     | Éline Xuân Anh CAUNE NGUYỄN | 2           | PS         |\n\n## Available Fonts\n\n|                                          |                                      |                                   |\n| ---------------------------------------- | ------------------------------------ | --------------------------------- |\n| `Amorino_beta`                           | `Calibri Light`                      | `Opificio_light_rounded`          |\n| `Barlow-Black`                           | `Calibri Regular`                    | `Opificio_regular`                |\n| `Barlow-BlackItalic`                     | `CaviarDreams`                       | `Opificio_rounded`                |\n| `Barlow-Bold`                            | `CaviarDreams_Bold`                  | `PirataOne-Regular`               |\n| `Barlow-BoldItalic`                      | `CaviarDreams_BoldItalic`            | `PlayfairDisplay-Black`           |\n| `Barlow-ExtraBold`                       | `CaviarDreams_Italic`                | `PlayfairDisplay-BlackItalic`     |\n| `Barlow-ExtraBoldItalic`                 | `Champagne & Limousines Bold Italic` | `PlayfairDisplay-Bold`            |\n| `Barlow-ExtraLight`                      | `Champagne & Limousines Bold`        | `PlayfairDisplay-BoldItalic`      |\n| `Barlow-ExtraLightItalic`                | `Champagne & Limousines Italic`      | `PlayfairDisplay-ExtraBold`       |\n| `Barlow-Italic`                          | `Champagne & Limousines`             | `PlayfairDisplay-ExtraBoldItalic` |\n| `Barlow-Light`                           | `Forgotbi`                           | `PlayfairDisplay-Italic`          |\n| `Barlow-LightItalic`                     | `Forgottb`                           | `PlayfairDisplay-Medium`          |\n| `Barlow-Medium`                          | `Forgotte`                           | `PlayfairDisplay-MediumItalic`    |\n| `Barlow-MediumItalic`                    | `Forgotti`                           | `PlayfairDisplay-Regular`         |\n| `Barlow-Regular`                         | `Forgotts`                           | `PlayfairDisplay-SemiBold`        |\n| `Barlow-SemiBold`                        | `Giorgino`                           | `PlayfairDisplay-SemiBoldItalic`  |\n| `Barlow-SemiBoldItalic`                  | `Jura-Bold`                          | `Quicksand-Bold`                  |\n| `Barlow-Thin`                            | `Jura-Light`                         | `Quicksand-Light`                 |\n| `Barlow-ThinItalic`                      | `Jura-Medium`                        | `Quicksand-Medium`                |\n| `BebasNeue-Bold`                         | `Jura-Regular`                       | `Quicksand-Regular`               |\n| `BebasNeue-Book`                         | `Jura-SemiBold`                      | `Quicksand-SemiBold`              |\n| `BebasNeue-Light`                        | `LibreBaskerville-Bold`              | `Rothwell`                        |\n| `BebasNeue-Regular`                      | `LibreBaskerville-Italic`            | `Skarpa regular`                  |\n| `BebasNeue-Thin`                         | `LibreBaskerville-Regular`           | `SkarpaLt`                        |\n| `Bedizen`                                | `Merriweather-Black`                 | `Steinerlight`                    |\n| `Blacker-Display-Bold-italic-trial`      | `Merriweather-BlackItalic`           | `Teko-Bold`                       |\n| `Blacker-Display-Bold-trial`             | `Merriweather-Bold`                  | `Teko-Light`                      |\n| `Blacker-Display-ExtraBold-Italic-trial` | `Merriweather-BoldItalic`            | `Teko-Medium`                     |\n| `Blacker-Display-ExtraBold-trial`        | `Merriweather-Italic`                | `Teko-Regular`                    |\n| `Blacker-Display-Heavy-Italic-trial`     | `Merriweather-Light`                 | `Teko-SemiBold`                   |\n| `Blacker-Display-Heavy-trial`            | `Merriweather-LightItalic`           | `Verdana`                         |\n| `Blacker-Display-Light-Italic-trial`     | `Merriweather-Regular`               | `quarthck`                        |\n| `Blacker-Display-Light-trial`            | `Montserrat-Black`                   | `quarthin`                        |\n| `Blacker-Display-Medium-Italic-trial`    | `Montserrat-BlackItalic`             | `rokikier`                        |\n| `Blacker-Display-Medium-trial`           | `Montserrat-Bold`                    | `rokikierc`                       |\n| `Blacker-Display-Regular-Italic-trial`   | `Montserrat-BoldItalic`              | `rokikierci`                      |\n| `Blacker-Display-Regular-trial`          | `Montserrat-ExtraBold`               | `rokikiere`                       |\n| `Blacker-Text-Bold-Italic-trial`         | `Montserrat-ExtraBoldItalic`         | `rokikierei`                      |\n| `Blacker-Text-Bold-trial`                | `Montserrat-ExtraLight`              | `rokikieri`                       |\n| `Blacker-Text-Book-Italic-trial`         | `Montserrat-ExtraLightItalic`        | `rokikierl`                       |\n| `Blacker-Text-Book-trial`                | `Montserrat-Italic`                  | `rokikierla`                      |\n| `Blacker-Text-Heavy-Italic-trial`        | `Montserrat-Light`                   | `rokikierlai`                     |\n| `Blacker-Text-Heavy-trial`               | `Montserrat-LightItalic`             | `rokikierp`                       |\n| `Blacker-Text-Light-Italic-trial`        | `Montserrat-Medium`                  | `rokikierpi`                      |\n| `Blacker-Text-Light-trial`               | `Montserrat-MediumItalic`            | `rokikiers`                       |\n| `Blacker-Text-Medium-Italic-trial`       | `Montserrat-Regular`                 | `rokikierse`                      |\n| `Blacker-Text-Medium-trial`              | `Montserrat-SemiBold`                | `rokikiersi`                      |\n| `Blacker-Text-Regular-Italic-trial`      | `Montserrat-SemiBoldItalic`          | `saunder`                         |\n| `Blacker-Text-Regular-trial`             | `Montserrat-Thin`                    | `vibroceb`                        |\n| `Calibri Bold Italic`                    | `Montserrat-ThinItalic`              | `vibrocei`                        |\n| `Calibri Bold`                           | `Opificio_Bold`                      | `vibrocen`                        |\n| `Calibri Italic`                         | `Opificio_Bold_rounded`              | `vibrocex`                        |\n| `Calibri Light Italic`                   | `Opificio_light`                     |                                   |\n\n\n## Development and Publication\n\n`Xebus ID Card Generator` uses [Poetry](https://python-poetry.org/), a packaging and dependency management for Python.  To install the required packages, execute the following command: \n\n```shell\npoetry install\n```\n\nTo activate the virtual environment, run the following command:\n\n```shell\npoetry shell\n```\n\nTo publish a new version of the library `Xebus ID Card Generator` to the [Python Package Index (PyPI)](https://pypi.org/), execute the following command:\n\n```shell\npoetry publish --build --username $PYPI_USERNAME --password $PYPI_PASSWORD\n```\n\n_Note: If you are storing the PyPi credentials in a `.env` file, you can get this file automatically loaded when activating your virtual environment. You need to install the Poetry plugin [`poetry-dotenv-plugin`](https://github.com/mpeteuil/poetry-dotenv-plugin):_ \n\n```shell\npoetry self add poetry-dotenv-plugin\n```',
    'author': 'Daniel CAUNE',
    'author_email': 'daniel.caune@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/xebus/xebus-id-card-image-generator',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
