# Malwoverview

      Copyright (C)  2018-2021 Alexandre Borges <alexandreborges at blackstormsecurity dot com>

      This program is free software: you can redistribute it and/or modify
      it under the terms of the GNU General Public License as published by
      the Free Software Foundation, either version 3 of the License, or
      (at your option) any later version.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      See GNU Public License on <http://www.gnu.org/licenses/>.


# Current Version: 4.4.1

     Important note:  Malwoverview does NOT submit samples to Virus Total or Hybrid 
     Analysis by default. It submits only hashes, so respecting Non-Disclosure 
     Agreements (NDAs). Nonetheless, if you use the "-V" (uppercase), "-A" (uppercase)
     or "-P" (uppercase), so Malwoverview SUBMITS your malware sample to Virus Total,
     Hybrid Analysis and Polyswarm, respectively. Additionally, options "-Y" and "-T"
     also sent the Android package from Android device to Hybrid-Analysis and Virus 
     Total, respectively.  


# ABOUT

Malwoverview.py is a first response tool for threat hunting, which performs an initial and quick 
triage of malware samples, URLs, IP addresses, domains, malware families, IOCs and hashes.

This tool aims to : 

1. Determine similar executable malware samples (PE/PE+) according to the import table (imphash) and group 
   them by different colors (pay attention to the second column from output). Thus, colors matter!
2. Show hash information on Virus Total, Hybrid Analysis, Malshare, Polyswarm, URLhaus, Alien Vault, 
   Malpedia and ThreatCrowd engines. 
3. Determining whether the malware samples contain overlay and, if you want, extract it. 
4. Check suspect files on Virus Total, Hybrid Analysis and Polyswarm.
5. Check URLs on Virus Total, Malshare, Polyswarm, URLhaus engines and Alien Vault. 
6. Download malware samples from Hybrid Analysis, Malshare, URLHaus, Polyswarm and Malpedia engines.
7. Submit malware samples to VirusTotal, Hybrid Analysis and Polyswarm.
8. List last suspected URLs from URLHaus.
9. List last payloads from URLHaus. 
10. Search for specific payloads on the Malshare.
11. Search for similar payloads (PE32/PE32+) on Polyswarm engine.
12. Classify all files in a directory searching information on Virus Total and Hybrid Analysis. 
13. Make reports about a suspect domain using different engines such as VirusTotal, Malpedia and 
    ThreatCrowd. 
14. Check APK packages directly from Android devices against Hybrid Analysis and Virus Total. 
15. Submit APK packages directly from Android devices to Hybrid Analysis and Virus Total. 
16. Show URLs related to an user provided tag from URLHaus.
17. Show payloads related to a tag (signature) from URLHaus.
18. Show information about an IP address from Virus Total, Alien Vault, Malpedia and ThreatCrowd.
19. Show IP address, domain and URL information from Polyswarm. 
21. Perform meta-search on Polyswarm Network using several criteria: imphash, IPv4, domain, URL and
    malware family. 
22. Gather threat hunting information from AlienVault using different criteria. 
23. Gather threat hunting information from Malpedia using different criteria. 
24. Gather threat hunting information from ThreatCrowd using different criteria. 
25. Provide Yara rules and associated information from Valhalla. 
26. Gather threat hunting information from Malware Bazaar using different criteria. 
27. Gather IOC information from ThreatFox using different criteria. 
28. Gather threat hunting information from Triage using different criteria. 



# CONTRIBUTORS:

      Alexandre Borges (project owner)
      Corey Forman (https://github.com/digitalsleuth)
      Christian Clauss (https://github.com/cclauss)

# INSTALLATION 

This tool has been tested on Ubuntu, Kali Linux 2021, REMnux, Windows 8.1 and 10. Malwoverview 
can be installed by executing the following command:

      pip3.9 install git+https://github.com/alexandreborges/malwoverview (preferred method) 
      or...
      python -m pip install -U malwoverview
      or...
      git clone https://github.com/alexandreborges/malwoverview


To use Malwoverview you should insert VirusTotal, Hybrid Analysis, URLHaus, Malshare, Polyswarm,
Alien Vault and Malpedia APIs into the .malwapi.conf configuration file (the default one at the 
home directory (/home/[username] or /root) -- if the file doesn't exist, so you should create it) 
or you could create a custom configuration file and indicate it by using the -c option. 

A special note about the Alien Vault: it is necessary to subscribe to pulses on Alien Vault 
website before using -n 1 option.  

The .malwapi.conf configuration file (from the the home directory -- /home/[username] or /root) 
has the following format:

      [VIRUSTOTAL]
      VTAPI = 

      [HYBRID-ANALYSIS]
      HAAPI = 

      [MALSHARE]
      MALSHAREAPI = 

      [HAUSSUBMIT]
      HAUSSUBMITAPI =

      [POLYSWARM]
      POLYAPI = 

      [ALIENVAULT]
      ALIENAPI = 

      [MALPEDIA]
      MALPEDIAAPI =

      [VALHALLA]
      VALHALLAAPI =

      [TRIAGE]
      TRIAGEAPI =


The APIs can be requested on the respective service websites:

1. Virus Total (community and paid API): https://www.virustotal.com/gui/join-us
2. Hybrid Analysis: https://www.hybrid-analysis.com/signup
3. Malshare: https://malshare.com/doc.php
4. URLHaus: https://urlhaus.abuse.ch/api/#account 
5. Polyswarm: https://docs.polyswarm.io/consumers
6. Alien Vault: https://otx.alienvault.com/api
7. Malpedia: It doesn't offer open registration, but you can request an user account 
directly through Twitter (DM) or feedback e-email. The Malpedia Twitter handle is @malpedia.
8. Valhalla: You can use a demo API key or contract the Valhalla service for a private key.
Valhalla demo-API key is: 1111111111111111111111111111111111111111111111111111111111111111.
9. ThreatCrowd: It isn't necessary an API.
10. Malware Bazaar: It isn't necessary an API.
11. ThreatFox: It isn't necessary an API.
12. Triage: https://tria.ge/signup.
 
----------------------------------------------------
A special note about API requests to the MALPEDIA:
----------------------------------------------------

The service and acceptance is based on the community vetting. Thus, it's recommended 
you send a request for an API from your business e-mail address and NOT 
public/free one (Gmail, Outlook and so on). Additionally, it'd be great whether 
you provided further information about you (LinkedIn account, Twitter and so on) 
because it would make simpler to proof your identity, professional profile and 
legitimacy, so making quicker the approval of your request.  

-----------------------------------------------------

----------------------------------------------------
Additional explanation about Triage:
----------------------------------------------------

Every Triage operation is based on the Triage ID of each artifact, so you need to
use the "-x 1 -X \<attribute\>:\<value\>" to look for the correct ID of the artifact,
so use this ID information with the remaining Triage options (-x [2-7]) for getting 
further threat hunting information from Triage endpoint.

-----------------------------------------------------

In Windows systems, create the .malwapi.conf file in the C:\Users\\[username\] directory 
(Windows home user directory). In Linux systems, create the .malwapi.conf file in 
/home/\[username\] directory (Linux home user directory -- /home/[username] or /root).

Additionally, you don't need to specify "-w 1" option while using malwoverview.py on Windows
anymore. 

To check the installation, execute:

       malwoverview.py --help
       
Further information is available on: 

       (PYPI.org repository) https://pypi.org/project/malwoverview/
       (Github) https://github.com/alexandreborges/malwoverview

If you want to perform the manual steps (usually, it is not necessary), so few steps will be necessary:

## Kali Linux (manual steps)

1. Python version 3.8 or later (Only Python 3.x !!! It does NOT work using Python 2.7) 

       $ apt-get install python3.9  (for example)

2. Python-magic.  

      To install python-magic package you can execute the following command:

       $ pip3.9 install python-magic

      Or compiling it from the github repository:

       $ git clone https://github.com/ahupp/python-magic
       $ cd python-magic/
       $ python3.9 setup.py build
       $ python3.9 setup.py install

      As there are serious problems about existing two versions of python-magic package, my 
      recommendation is to install it from github (second procedure above) and copy the magic.py 
      file to the SAME directory of malwoverview tool. 
      
3. Install several Python packages: 

       $ pip3.9 install -r requirements.txt

       OR

       $ pip3.9 install -U pefile
       $ pip3.9 install -U colorama
       $ pip3.9 install -U simplejson
       $ pip3.9 install -U python-magic
       $ pip3.9 install -U requests
       $ pip3.9 install -U validators
       $ pip3.9 install -U geocoder
       $ pip3.9 install -U polyswarm-api
       $ pip3.9 install -U pathlib
       $ pip3.9 install -U configparser
       $ pip3.9 install -U valhallaAPI
       
4. To check an Android mobile you need to install the "adb" program by executing the following command:

       # apt get install adb

   PS: before trying Android's options, check:

       * If the adb program is listed in the PATH environment variable.
       * If the system has authorized access to the device by using "adb devices -l"

5. Finally, you can install Malwoverview using one of the following methods:

         pip3.9 install git+https://github.com/alexandreborges/malwoverview (preferred method) 

         or...

         python -m pip install -U malwoverview

         or...

         git clone https://github.com/alexandreborges/malwoverview


## Windows (manual steps)

1. Install the Python version 3.8.x or later from https://www.python.org/downloads/windows/ 

2. Python-magic. 

      To install python-magic package you can execute the following command:

       C:\> python.exe -m pip install python-magic

      Or compiling it from the github repository:

       C:\> git clone https://github.com/ahupp/python-magic
       C:\> cd python-magic/
       C:\> python.exe setup.py build
       C:\> python.exe setup.py install

3. Install several Python packages: 

       C:\> python.exe -m pip install -r requirements.txt

       OR: 

       C:\> python.exe -m pip install -U pefile
       C:\> python.exe -m pip install -U colorama
       C:\> python.exe -m pip install -U simplejson
       C:\> python.exe -m pip install -U python-magic
       C:\> python.exe -m pip install -U requests
       C:\> python.exe -m pip install -U validators
       C:\> python.exe -m pip install -U geocoder
       C:\> python.exe -m pip install -U polyswarm-api
       C:\> python.exe -m pip install -U pathlib
       C:\> python.exe -m pip install -U configparser
       C:\> python.exe -m pip install -U python-magic-bin
       C:\> python.exe -m pip install -U valhallaAPI

4. To check an Android mobile you need to install the "adb" program by:

       * Downloading and installing the Android Studio from: https://developer.android.com/
         studio#downloads (Recommended)
       * Downloading it from:
         https://dl.google.com/android/repository/platform-tools-latest-windows.zip

   PS: before trying Android's options, check:

       * If the adb program is listed in the PATH environment variable.
       * If the system has authorized access to the device by using "adb devices -l"

5. Finally, you can install Malwoverview using one of the following methods:

         pip3.9 install git+https://github.com/alexandreborges/malwoverview (preferred method)

         or...

         python -m pip install -U malwoverview

         or...

         git clone https://github.com/alexandreborges/malwoverview
  
       
# USAGE

To use the malwoverview, execute the command as shown below:

      root@ubuntu19:~/malwoverview# python3.9 malwoverview.py  | more

      usage: python malwoverview.py -c <API configuration file> -d <directory> -f <fullpath> 
      -o <0|1> -v <0-4> -a <0-5> -w <0|1> -u <url> -H <hash file> 
      -V <filename> -D <0|1> -e <0-4> -A <filename> -g <job_id> -r <domain> -t <0|1>
      -l <1-14> -L <hash> -U <url> -S <url> -z <tags> -K <0|1|2> -j <hash> -J <hash> 
      -P <filename> -R <PE file, IP address, domain or URL> -G <0-4> -y <0-3> 
      -Y <file name> -Y <file name> -T <file name> -W <tag> -k <signature> -I <ip address>
      -n <1-5> -N <argument> -M <1-8> -m <argument> -Q <1-5> -q <argument> 
      -E <1-5> -C <argument> -b <1-10> -B <arg> -x <1-7> -X <arg>

Malwoverview is a first response tool for threat hunting written by Alexandre Borges.

optional arguments:

      -h, --help        Show this help message and exit
      -c CONFIG FILE, --config CONFIG FILE
                        Use a custom config file to specify API's
      -d DIRECTORY, --directory DIRECTORY
                        Specifies the directory containing malware samples.
      -f FILENAME, --filename FILENAME
                        Specifies a full path to a malware sample. It returns general information 
                        about the file (any filetype)
      -o BACKGROUND, --background BACKGROUND
                        Adapts the output colors to a white terminal. The default is black terminal
      -x OVERLAY, --overlay OVERLAY
                        Extracts the overlay (it is used with -f option).
      -v VIRUSTOTAL, --virustotal VIRUSTOTAL
                        If using "-v 1", so it queries the Virus Total database for positives and 
                        totals. If "v 2" (which can be used only together with -f option), so it 
                        shows antivirus reports from the main players. If "v 3", so the binary's IAT 
                        and EAT are also shown. Remember: you need to edit the .malwapi.conf and insert 
                        your VT API.If "v 4" it extracts the overlay (it must be used with -f 
                        option). Remember: you need to edit the .malwapi.conf and insert your VT API.
      -a HYBRID_ANALYSIS, --hybrid HYBRID_ANALYSIS
                        Queries the Hybrid Analysis database for getting a general report. Possible 
                        values are: 1: Windows 7 32-bit; 2: Windows 7 32-bit (HWP Support); 3: 
                        Windows 64-bit; 4: Android; 5: Linux 64-bit. Remember: you need to edit the
                        .malwapi.conf and insert your HA API and secret.
      -u URL_VT, --vturl URL_VT
                        SUBMITS a URL to the Virus Total scanning.
      -I IP_VT, --ipaddrvt IP_VT
                        This option checks an IP address on Virus Total.
      -r URL_DOMAIN, --urldomain URL_DOMAIN
                        This option gets a domain's report from Virus Total.
      -H FILE_HASH, --hash FILE_HASH
                        This option specifies the hash to be checked on Virus Total and Hybrid Analysis. 
                        For the Hybrid Analysis report you must use it with the -e option.
      -V FILENAME_VT, --vtsubmit FILENAME_VT
                        Submits a file(up to 32MB) for Virus Total scanning and gets the report. Attention: 
                        use forward slash to specify the target file even on Windows systems. Furthermore, 
                        the minimum waiting time is set up in 90 seconds because the Virus Total waiting 
                        queue. If an error occurs, so wait few minutes and try to access the report by 
                        using -f option.
      -A SUBMIT_HA, --submitha SUBMIT_HA
                        Submits a file(up to 32MB) to be scanned by the Hybrid Analysis engine. Use the 
                        -e option to specify the best environment to run the suspicious file.
      -g HA_STATUS, --hastatus HA_STATUS
                        Checks the report's status of submitted samples to Hybrid Analysis engine by 
                        providing the job ID. Possible returned status values are: IN_QUEUE, SUCCESS,
                        ERROR, IN_PROGRESS and PARTIAL_SUCCESS.
      -D DOWNLOAD, --download DOWNLOAD
                        Downloads the sample from Hybrid Analysis, Malshare and Polyswarm. Options 
                        -H or -L (Hybrid Analysis and Malshare, respectively) must be specified as well 
                        -O option for Polyswarm engine.
      -e HA_ENVIRONMENT, --haenv HA_ENVIRONMENT
                        This option specifies the used environment to be used to test the samlple on 
                        Hybrid Analysis: <0> Windows 7 32-bits; <1> Windows 7 32-bits (with HWP Support); 
                        <2> Windows 7 64-bits; <3> Android; <4> Linux 64-bits environment. This option 
                        is used together either -H option or the -A option.
      -t MULTITHREAD, --thread MULTITHREAD
                        (optional) This option has several different meanings according to chosen the 
                        value. Possible values: <1>: This value is used to force multithreads on Linux 
                        whether: the -d option is specified AND you have a PAID Virus Total API or you
                        are NOT checking the VT while using the -d option. PS1: using this option causes 
                        Imphashes not to be grouped anymore; PS2: it also works on Windows, but there is 
                        not gain in performance; <2>: This value should be used with -d option in
                        two scenarios: 1) either including the "-v 1" option (Virus Total -- you'll see 
                        a complete VT response whether you have the private API) for a multithread 
                        searching and reduced output; 2) or including the -a option (Hybrid Analysis) 
                        for a multithread searching to get a complete and amazing output. If you are 
                        using the -a option, so you should pickup the right number represening the 
                        testing environment to adjust the output to your sample types. PS1: certainly,
                        if you have a directory holding many malware samples, so you will want to test
                        this option with -a option; PS2: it also works on Windows, but there is not gain
                        in performance; <3>: You should use this value with -v option if you have a public
                        Virus Total API. It forces a one minute wait every 4 malware samples, but allows
                        obtaining a complete evaluation of the malware repository.
      -l MALSHARE_HASHES, --malsharelist MALSHARE_HASHES
                        This option shows hashes of a specific type from the last 24 hours from Malshare 
                        repository. Possible values are: 1: PE32 (default) ; 2: Dalvik ; 3: ELF ; 4: HTML ;
                        5: ASCII ; 6: PHP ; 7: Java ; 8: RAR ; 9: Zip ; 10: UTF-8 ; 11: MS-DOS ; 12: data ; 
                        13: PDF ; 14: Composite(OLE). You need to insert your Malshare API into the 
                        .malwapi.conf file.
      -L MALSHARE_HASH_SEARCH, --malsharehash MALSHARE_HASH_SEARCH
                        Searches for the provided hash on the Malshare repository. You need to insert your 
                        Malshare API into the .malwapi.conf file. PS: sometimes the Malshare website is 
                        unavailable, so should check the website availability if you get some error message.
      -K HAUS_PAYLOAD_URL, --haus_payloadbatch HAUS_PAYLOAD_URL
                        THis option has few possible values: <1> Retrieves a list of downloadable links of 
                        recent PAYLOADS (last 3 days, limited to 1000 entries) from URLHaus website; <2>: 
                        Retrieves a list of recent URLs (last 3 days, limited to 1000 entries) from URLHaus
                        website. Take care: each link take you to download a passworless zip file 
                        containing a malware, so your AV can generate alerts!
      -U URL_HAUS_QUERY, --haus_query URL_HAUS_QUERY
                        Queries a URL on the URLHaus website.
      -j HAUS_HASH, --haus_hash HAUS_HASH
                        Queries information about a provided payload's hash (md5 or sha256) on the URLHaus 
                        website.
      -S URL_HAUS_SUB, --haus_submission URL_HAUS_SUB
                        Submits a URL used to distribute malware (executable, script, document) to the 
                        URLHaus website. Pay attention: Any other submission will be ignored/deleted from 
                        URLhaus. You have to register your URLHaus API into the .malwapi.conf file.
      -z [HAUSTAG [HAUSTAG ...]], --haustag [HAUSTAG [HAUSTAG ...]]
                        Associates tags (separated by spaces) to the specified URL. Please, only upper case, 
                        lower case, '-' and '.' are allowed. This parameter is optional, which could be used 
                        with the -S option.
      -W [HAUSTAGSEARCH [HAUSTAGSEARCH ...]], --haustagsearch [HAUSTAGSEARCH [HAUSTAGSEARCH ...]]
                        This option is for searching malicious URLs by tag on URLhaus. Tags are 
                        case-senstive and only upper case, lower case, '-' and '.' are allowed.
      -k [HAUSSIGSEARCH [HAUSSIGSEARCH ...]], --haussigsearch [HAUSSIGSEARCH [HAUSSIGSEARCH ...]]
                        This option is for searching malicious payload by tag on URLhaus. Tags are 
                        case-sensitive and only upper case, lower case, '-' and '.' are allowed.
      -J HAUS_DOWNLOAD, --haus_download HAUS_DOWNLOAD
                        Downloads a malware sample (if it is available) from the URLHaus repository. It 
                        is necessary to provide the SHA256 hash.
      -P POLYSWARMFILE, --polyswarm_scan POLYSWARMFILE
                        (Only for Linux) Submits a sample to Polyswarm engine and performs a file scan.
      -O POLYSWARMHASH, --polyswarm_hash POLYSWARMHASH
                        (Only for Linux) Performs a hash scanning using the Polyswarm engine. Optionally, 
                        you can specify -D option to download the sample. Take care: Polyswarm enforces a 
                        restriction to number of downloaded samples in 20/month.
      -R POLYSWARMMETA, --polyswarm_meta POLYSWARMMETA
                        (Only for Linux) Provides the argument value for searches on Polyswarm engine 
                        through imphash (the PE file must be provided), ipv4, domain, URL and family. This
                        argument must be used with -G option, so check it, please. Pay attention: you 
                        should check your metadata search limit on your Polyswarm account because once you
                        have got the limit, so you will got an error.
      -G METATYPE, --metatype METATYPE
                        (Only for Linux) This parameter specifies search type for arguments provided by
                        -R option (above) while searching on Polyswarm engine. Thus, the following values are 
                        valid -- 0: PE Executable (look for samples with the same ImpHash); 1: IP Address ; 
                        2: Domain ; 3. URL; 4. Family
      -y ANDROID_HA, --androidha ANDROID_HA
                        This option has multiple options: <1>: Check all third-party APK packages from the 
                        USB-connected Android device against Hybrid Analysis using multithreads. The Android 
                        device does not need to be rooted and the system does need to
                        have the adb tool in the PATH environment variable; <2>: Check all third-party APK 
                        packages from the USB-connected
                        Android device against VirusTotal using Public API (slower because of 60 seconds 
                        delay for each 4 hashes). The Android device does not need to be rooted and the 
                        system does need to have adb tool in the PATH environment variable; <3>: Check 
                        all third-party APK packages from the USB-connected Android device against 
                        VirusTotal using multithreads (only for Private Virus API). The Android device 
                        does not need to be rooted and the system needs to have adb tool in the PATH 
                        environment variable.
      -Y ANDROID_SEND_HA, --androidsendha ANDROID_SEND_HA
                        Sends an third-party APK package from your USB-connected Android device to Hybrid 
                        Analysis. The Android device does not need to be rooted and the system needs to have 
                        adb tool in the PATH environment variable.
      -T ANDROID_SEND_VT, --androidsendvt ANDROID_SEND_VT
                        Sends an third-party APK package from your USB-connected Android device to Virus 
                        Total. The Android device does not need be rooted and the system needis to have the 
                        adb tool in the PATH environment variable.
      -n ALIENVAULT, --alienvault ALIENVAULT
                        Checks multiple information from AlienVault. The possible values are: 1: Get the 
                        subscribed pulses ; 2: Get information about an IP address; 3: Get information about 
                        a domain; 4: Get information about a hash; 5: Get information about a URL
      -N ALIENVAULT_ARGS, --alienvaultargs ALIENVAULT_ARGS
                        Provides argument to AlienVault -n option.The allowed values are: 1, 2, 3, 4, 5.
      -M MALPEDIA, --malpedia MALPEDIA
                        This option is related to MALPEDIA and presents different meanings depending on the 
                        chosen value. Thus, 1: List meta information for all families ; 2: List all actors 
                        ID ; 3: List all available payloads organized by family from Malpedia; 4: Get meta 
                        information from an specific actor, so it is necessary to use the -m option. 
                        Additionally, try to confirm the correct actor ID by executing malwoverview with 
                        option -M 3; 5: List all families IDs; 6: Get meta information from an specific 
                        family, so it is necessary to use the -m option. Additionally, try to confirm the 
                        correct family ID by executing malwoverview with option -M 5; 7: Get a malware 
                        sample from malpedia (zip format -- password: infected). It is necessary to specify 
                        the requested hash by using -m option; 8: Get a zip file containing Yara rules for 
                        a specific family (get the possible families using -M 5), which must be specified 
                        by using -m option.
      -m MALPEDIAARG, --malpediarg MALPEDIAARG
                        This option provides an argument to the -M option, which is related to MALPEDIA.
      -Q THREATCROWD, --threatcrowd THREATCROWD
                        Checks multiple information from ThreatCrowd. The possible values are: 1: Get 
                        information about the provided e-mail ;
                        2: Get information about an IP address; 3: Get information about a domain; 4: Get 
                        information about a provided MD5 hash; 5: Get information about a specific malware 
                        family.
      -q THREATCROWDARG, --threatcrowdarg THREATCROWDARG
                        This option provides an argument to the -Q option, which is related to THREATCROWD.
      -E VALHALLA, --valhalla VALHALLA
                        This option is used for getting Yara rules from the Valhalla service given an 
                        argument (-C option below). Valid values are 1: searches for Yara rules matching
                        the provided keyword; 2: search for Yara rules matching a minimal score (40-49:
                        anomaly and threat hunting rules / 60-74: rules for suspicious objects / 75-100: 
                        hard malicious matches); 3: Look for Yara rules to the following products, which
                        must be specified using the -C option: FireEyeAX, FireEyeNX, FireEyeEX, CarbonBlack,
                        Tanium, Tenable, SymantecMAA, GRR, osquery, McAfeeATD3 and McAfeeATD4; 4: Given 
                        the hash (SHA 256) through -C option, show associated Yara rules; 5: Shows 
                        information about a specific Yara rule provided through the -C option.
      -C VALHALLAARG, --valhallaarg VALHALLAARG
                        This option is used for providing argument to the Vahalla service (-E option).

      -b BAZAAR, --bazaar BAZAAR
                        Checks multiple information from Malware Bazaar and ThreatFox. The possible values
                        are: 1: (Bazaar) Query information about a malware hash sample ; 2: (Bazaar) Get 
                        information and a list of malware samples associated and according to a specific 
                        tag; 3: (Bazaar) Get a list of malware samples according to a given imphash; 
                        4: (Bazaar) Query latest malware samples; 5: (Bazaar) Download a malware sample 
                        from Malware Bazaar by providing a SHA256 hash. The downloaded sample is zipped 
                        using the following password: infected; 6: (ThreatFox) Get current IOC dataset 
                        from last x days given by option -B; 7: (ThreatFox) Search for the specified IOC on
                        ThreatFox given by option -B; 8: (ThreatFox) Search IOCs according to the specified 
                        tag given by option -B; 9: (ThreatFox) Search IOCs according to the specified malware
                        family provided by option -B; 10. (ThreatFox) List all available malware families.

      -B BAZAAR_ARG, --bazaararg BAZAAR_ARG
                        Provides argument to -b Bazaar and ThreatFox option. If you specified "-b 1" 
                        then the -B's argument must be a hash; If you specified "-b 2" then -B's argument 
                        must be a malware tag; If you specified "-b 3" then the argument must be a imphash;
                        If you specified "-b 4", so the argument must be "100 or time", where "100" lists 
                        last "100 samples" and "time" lists last samples added to Malware Bazaar in the last
                        60 minutes; If you specified "-b 5" then the -B's argument must be a SHA256 hash; If
                        you specified "-b 6", so the -B's value is the number of DAYS to filter IOCs. The 
                        default (and max) is 90 (days); If you used "-b 7" so the -B's argument is the IOC
                        you want to search for; If you used "-b 8", so the -B's argument is the TAG you 
                        want search for; If you used "-b 9", so the -B argument is the malware family you 
                        want to search for;


      -x TRIAGE, --triage TRIAGE
                        Provides information from Triage according to the specified value: <1> this option
                        gets sample's general information by providing an argument with -B option in the
                        following possible formats: sha256:<value>, sha1:<value>, md5:<value>,
                        familily:<value>, score:<value>, tag:<value>, url:<value>, wallet:<value>,
                        ip:<value>; <2> Get a sumary report for a given Triage ID (got from option -x 1) ;
                        <3> Submit a sample for analysis ; <4> Submit a sample through a URL for analysis ;
                        <5> Download sample specified by the Triage ID; <6> Download pcapng file from sample
                        associated to given Triage ID; <7> Get a dynamic report for the given Triage ID (got
                        from option -x 1);
       -X TRIAGE_ARG, --triagearg TRIAGE_ARG
                        Provides argument for options especified by -x option. Pay attention: the format of
                        this argument depends on provided -x value.


      Remember that public VT API only allows 4 searches per second (as shown at the image above). Therefore,
      if you are willing to wait some minutes, so you can use the -p option, which forces a one minute wait 
      every 4 malware samples, but allows obtaining a complete evaluation of the repository.


      * ATTENTION 1: if the directory contains many malware samples while using -d option, so malwoverview.py
                     could take some time. Nonetheless, you can use the new -t option (multithreading) to
                     speed-up things. :)
         
      ** ATTENTION 2: All engines enforces quota of submission and/or verification per day and/or month. 
                      Take care!
       
      *** ATTENTION 3: Some options searching on Hybrid Analysis strongly depend of the "-e" option, which 
                       specifies the environment. Therefore, to check an Android sample (for example) it is 
                       necessary to use the right environment (-e 3 for Android).


## Examples:

      malwoverview.py -d /root/malware/misc/
      malwoverview.py -d /root/malware/misc -t 1
      malwoverview.py -d /root/malware/misc -v 1 -t 3
      malwoverview.py -d /root/malware/misc -v 1 -t 1
      malwoverview.py -d /root/malware/misc -a 1 -t 2
      malwoverview.py -f /root/malware/misc/8a87a1261603af4d976faa57e49ebdd8fd8317e9dd13bd36ff25
      99d1031f53ce -v 2
      malwoverview.py -f /root/malware/misc/806fc33650b7ec35dd01a06be3037674ae3cc0db6ba1e3f690ee
      9ba9403c0627 -a 1 -v 1
      malwoverview.py -f /root/malware/misc/8a87a1261603af4d976faa57e49ebdd8fd8317e9dd13bd36ff25
      99d1031f53ce -v 3
      malwoverview.py -f /root/malware/misc/blackstorm.php -v 4 
      malwoverview.py -u http://mobiletech.net/images/138907/8g7c645373370255099hf4at12buy2lgrdeqo/
      malwoverview.py -r xurl.es
      malwoverview.py -H 9ce861b93e7ddeebec8ed052450fc136162fb3239c502aab8fa9bc8962572457
      malwoverview.py -H 893339624602c7b3a6f481aed9509b53e4e995d6771c72d726ba5a6b319608a7 -e 1
      malwoverview.py -d /root/malware/linux/ -a 5
      malwoverview.py -d /root/malware/android/ -a 4
      malwoverview.py -d /root/malware/android/ -v 1 -t 3
      malwoverview.py -d /root/malware/android/ -a 4 -t 2
      malwoverview.py -V /root/malware/misc/malware999
      malwoverview.py -A /root/malware/android/NubankConvidado.apk -e 3
      malwoverview.py -g 5f2e727f70fa896603576725
      malwoverview.py -A /root/malware/windows/806fc33650b7ec35dd01a06be3037674ae3cc0db6ba1e3f690
      ee9ba9403c0627
      malwoverview.py -l 1
      malwoverview.py -l 6
      malwoverview.py -l 4
      malwoverview.py -L bc9d356f8d08396d620d249b8f34a664c9397467b1a6033013c788df734f8bda
      malwoverview.py -K 1
      malwoverview.py -K 2
      malwoverview.py -U http://pusatppm.poltekkesbandung.com/wp-admin/report/b17892056589733xcz
      cjkjvqctpr9v9sm/ 
      malwoverview.py -J 9e7d263c3c9f155229a7d6fb29dfa4b62bfec31ed0d3bf4cc2dc60ffd9fd6d0e
      malwoverview.py -S http://jamogames.com/templates/JLHk/
      malwoverview.py -S http://pusatppm.poltekkesbandung.com/wp-admin/report/b17892056589733xc
      zcjkjvqctpr9v9sm/
      malwoverview.py -P 9e7d263c3c9f155229a7d6fb29dfa4b62bfec31ed0d3bf4cc2dc60ffd9fd6d0e
      malwoverview.py -O f3ebeeeba13c82daef9731a5f3e8dbe535e963f83e531918ba1a8904b094d3b8
      malwoverview.py -R /root/malware/windows/Scarab_Ransomware -G 0
      malwoverview.py -R 164.132.92.180 -G 1
      malwoverview.py -R sndoffo79.ddns.net -G 2
      malwoverview.py -R http://0uso87.com/bolb/jaent.php?l=liut1.cab -G 3
      malwoverview.py -R *Trickbot* -G 4
      malwoverview.py -R *Trojan* -G 4
      malwoverview.py -R *Ransomware* -G 4
      malwoverview.py -y 1
      malwoverview.py -y 2
      malwoverview.py -y 3
      malwoverview.py -T icompass
      malwoverview.py -Y icompass
      malwoverview.py -k Trickbot | more
      malwoverview.py -W Quakbot
      malwoverview.py -I 149.56.79.215
      malwoverview.py -n 1 -N 12
      malwoverview.py -n 2 -N 79.124.8.24
      malwoverview.py -n 3 -N covid19tracer.ca
      malwoverview.py -n 4 -N ba42665872ea41e3d2edd8978bc38c24
      malwoverview.py -n 5 -N http://ksahosting.net/wp-includes/utf8.php
      malwoverview.py -M 1
      malwoverview.py -M 2 | more
      malwoverview.py -M 3 | more
      malwoverview.py -M 4 -m apt41 | more
      malwoverview.py -M 5 | more
      malwoverview.py -M 6 -m win.locky
      malwoverview.py -M 7 -m efbdb14f38c20c55e32cd98e4b2fdf197709581581d31fac683aabbf361df5f3
      malwoverview.py -M 8 -m win.trickbot
      malwoverview.py -Q 1 -q potrafamin44as@gmail.com
      malwoverview.py -Q 2 -q 188.40.75.132
      malwoverview.py -Q 3 -q aoldaily.com
      malwoverview.py -Q 4 -q fa6fbd1dd2d58885772bd0b37633d5d7
      malwoverview.py -Q 5 -q plugx
      malwoverview.py -E 1 -C apt41
      malwoverview.py -E 2 -C 85 
      malwoverview.py -E 3 -C osquery 
      malwoverview.py -E 4 -C 8a883a74702f83a273e6c292c672f1144fd1cce8ee126cd90c
                              95131e870744af 
      malwoverview.py -E 5 -C Casing_Anomaly_ByPass | more
      malwoverview.py -H 9555ea9a1909120dd9be988d91cad345302b38884d2343ee16ab994ac6c5c7df -D 1
      malwoverview.py -L 081dc7af98fe601e09d81a4698f0df119ac612be1984f1d365b4cd9c21f550a1 -D 1
      malwoverview.py -O 081dc7af98fe601e09d81a4698f0df119ac612be1984f1d365b4cd9c21f550a1 -D 1
      malwoverview -b 1 -B c9d7b5d06cd8ab1a01bf0c5bf41ef2a388e41b4c66b1728494f86ed255a95d48 
      malwoverview -b 2 -B Emotet
      malwoverview.py -b 3 -B f34d5f2d4577ed6d9ceec516c1f5a744
      malwoverview.py -b 4 -B 100
      malwoverview.py -b 4 -B time
      malwoverview.py -b 5 -B 2db2c1be15db4fc71b60ff3f7556156188cac93abcfabc866a2ca020b774347b
      malwoverview.py -b 6 -B 20
      malwoverview.py -b 7 -B  139.180.203.104:443
      malwoverview.py -b 8 -B Magecart
      malwoverview.py -b 9 -B "Cobalt Strike"
      malwoverview.py -b 10 | more
      python3.9 malwoverview/malwoverview.py -x 1 -X score:10 | more
      python3.9 malwoverview/malwoverview.py -x 1 -X sha256:3e27b6b287f0b9f7e85bfe18901d96111
                                                     0ae969d58b44af15b1d75be749022c2
      malwoverview.py -x 1 -X tag:trojan | more
      malwoverview.py -x 1 -X url:https://pcwizardrepair.com/grduoams
      malwoverview.py -x 1 -X family:emotet | more
      malwoverview.py -x 2 -X 210607-5j5bg6q9r2
      malwoverview.py -x 3 -X /root/malware/windows/c3c5dd5504de3725ef9e40d0379cc273a356a90c6
                              b2febb9dbc1f711348a1601 
      malwoverview.py -x 4 -X http://ztechinternational.com/Img/XSD.exe
      malwoverview.py -x 5 -X 210607-37pxrcst8a
      malwoverview.py -x 6 -X 210607-pbt1j18myx
      malwoverview.py -x 7 -X 210607-pbt1j18myx

# HISTORY

Version 4.4.1:

      This version:

            * Improves and fixes a formatting issue with cmd field 
              from option -x 2.

Version 4.4.0.2:

      This version:

            * Improves and fixes a formatting issue with cmd field 
              from option -x 7.

Version 4.4:

      This version:

            * Introduces Triage endpoint and seven associated options. 
            * Changes the overlay extraction option (previously -x) 
              to -v 4. 

Version 4.3.5:

      This version:

            * Fixes formating issues related to option -M 6 from Malpedia. 
            * Fixes formating issues related to option -W from URLHaus. 
            * Fixes formating issues related to option -k from URLHaus. 
            * Fixes working issues related to option -L from Malshare. 
            * Corrects misspelled words.

Version 4.3.4:

      This version:

            * Removes two columns from option -y 1 (Android package checking on HA) 
              to offer better formatting. 

Version 4.3.3:

      This version:

            * Fixes output formatting of option -y (Android package checking on VT and HA) 
            * Fixes issue with option -y while using -o 0. 


Version 4.3.2:

      This version:

            * Fixes output formatting of option -n 2 (Alien Vault).
            * Fixes URL output formatting of long URL when using option -I (Virus Total). 
            * Fixes option -f when using a binary without IAT (Virus Total). 
            * Fixes option -B 10, which caused a endless loop (ThreatFox). 
            * Fixes option formatting issue related to -K 2 when fetched URLs were long
              (URLHaus). 
            * Introduces "FireEye" endpoint in -v 2 output (VirusTotal). This
              addition has been suggested by @vxsh4d0w.

Version 4.3.1:

      This version:

            * Introduces a fix in the "-b 8" ThreatFox option.
            * Corrects sentences in the help's section.

Version 4.3:

      This version:

            * Introduces Malware Bazaar and ThreatFox endpoints, with 5 options for each one.
              to get the APIs.
            * Changes background option from -b to -o.
            * Fixes problems on Malpedia and URLHaus options.

Version 4.2:

      This version:

            * Fixes -L option from Malware.
            * Introduces additional instruction on README.md (this file) to help professionals
              to get the APIs.

Version 4.1:

      This version:

            * Introduces the -E and -C options for Valhalla service 
              (https://www.nextron-systems.com/valhalla/) 
            * Introduces few changes in the setup.py file (contribution from Christian 
              Clauss). 
            * Introduces a new contributor: Christian Clauss (https://github.com/cclauss) 

Version 4.0.3:

      This version:

            * Fixes the fact of Virus Total evaluation wasn't showed when the user specified "-v 2" and 
              "-v 3" options.
            * The version of the Python request package is fixed to prevent issues with Polyswarm API 2.x.

Version 4.0.2:

      This version:

            * Two small bugs (typos) in the functions for Polyswarm downloading and Android package checking
              have been fixed. 
            * An unnecessary and dead code has been removed.
            * Several typos in the README.md and in the help have been corrected. 
            * All fixes for this version have been suggested by Christian Clauss (https://github.com/cclauss)


Version 4.0.1:

      This version:

            * Fixes small typos and the README. 


Version 4.0.0:

      This version:

            * Introduces new engines such as Alien Vault, Malpedia and ThreatCrowd. 
            * The -s option has been removed. Use -v 2 option for antivirus report.
            * The -n option is not longer associated to Malshare. Use -l option with 
              values between 1 and 14.
            * To specify the hash in Malshare use the L option instead of -m option. 
            * The -i option has been removed. Use the -v 3 option for IAT/EAT. 
            * The -a option has been changed to include the system environments in Hybrid 
              Analysis. However, the -e option has been kept to be used with other options. 
            * The -M option is not longer responsible for downloading samples in Malshare. Use
              -D option for this task. 
            * The -B option for list URLs from URLHaus has been replaced by -K 2 option. 
            * The -Z and -X options (related to Android) have been replaced for -y 2 and -y 3, 
              respectively. 
            * The -D option (download a malware sample) has been extended to Polyswarm. 
            * The malware sample's DLL list has been introduced. 
            * The -R and -G options from Polyswarm have been completely fixed. Additionally, both
              ones also include the polyscore in the output. 
            * The -N option is not longer associated to Polyswarm . 
            * The -G 4 option has been introduced and it makes possible to search samples by 
              families and types such as "*Trickbot*", "*Ransomware", "*Trojan*" and so on. 
            * Colors from -I option have been fixed. 
            * The -w option has been removed. 
            * Several issues in the help have been fixed. 


Version 3.1.2:

      This version:

            * Introduces the -c option that allows the user to specify a custom API configuration file. 
            * The API configuration file has been changed to .malwapi.conf file.
            * The project structure has been changed to make easier to install it in different operating 
              systems.
            * Updates for this version are a contribution from Corey Forman (https://github.com/digitalsleuth).

Version 3.0.0:

      This version:

            * Includes fixes in the URL reporting (-u option) from Virus Total.  
            * New players have have been included in the URL reporting (-u option) from Virus Total.
            * Fixes have been included in payload listing (-K option) from URLhaus.
            * Yara information has been include in the hash report (-m option) from Malshare.
            * Fixes have been included in the -l option. 
            * New file types have been included in the -n option: Java, Zip, data, RAR, PDF, Composite (OLE),
              MS_DOS and UTF-8.
            * New -W option, which is used to show URLs related to an user provided tags from URLHaus.
            * New -k option, which is used to show payloads related to a tag from URLHaus
            * New -I option, which is used to show information related to an IP address from Virus Total.
            * The -R option was refactored and now it supports searching for file, IPv4, domain or URL on 
              Polyswarm. 

Version 2.5.0:

      This version:

            * Introduces the following options:
                  * -y to check all third-party APKs from an Android device against 
                       the Hybrid Analysis. 
                  * -Y to send a third-party APKs from an Android device to the Hybrid
                       Analysis. 
                  * -Z to check all third-party APKs from an Android device against 
                       the Virus Total. 
                  * -X to check all third-party APKs from an Android device against the
                       Virus Total (it is necessary private API). 
                  * -T to send a third-party APK from an Android device to Virus Total. 
            * Fixes several issues related to color in command outputs.  
            * Adds the filename identification in the report while sending a sample to Virus Total.

Version 2.1.9.1:

      This version:

            * Fixes several issues about colors in outputs. 
            * Removes the -L option from Malshare (unfortunately, Malshare doesn't provide an 
              URL list anymore). 
            * Removes the -c option.
            * Introduces some verification lines in the URLHaus command. 

Version 2.1:

      This version:

            * Fixes formatting issues related to Hybrid Analysis output (-Q 1 -a 1). 
            * Fixes color issues. 
            * Fixes small issues related to Polyswarm. 

Version 2.0.8.1:

      This version:

            * Introduces installation using: pip3.8 install malwoverview (Linux) or 
              python -m pip install malwoverviewwin (Windows). 
            * Fixes small problems related to Polyswarm usage. 
            * Changes the help to verify whether the APIs were inserted into configmalw.py file. 

Version 2.0.1:

      This version:

            * Fixes a problem related to searching by hash on Malshare (-m option). 
            * Fixes a problem related to searching by hash on Polyswarm (-O option). 

Version 2.0.0:

      This version:

            * Introduces a completely ported version of Malwoverview to Python 3.x (it does not work in 
              Python 2.7.x anymore!)
            * Fixes several bugs related to IAT/EAT listing. 
            * Fixes several bugs related to colors. 
            * Introduces multi-threading to some options. 
            * Introduces several options related to Malshare. 
            * Introduces several options related to URLHaus.
            * Introduces several options related to Polyswarm engine. 
            * Changes the place of the API key configuration. Now you should edit the configmalw.py file. 
            * Changes the help libraries and functions, so making the Malwoverview's help more complete. 
            * Introduces geolocation feature by using the package named Geocoder written by Dennis Carrierre.
            * Fixes problems related to Hybrid Analysis engine. 
            * Fixes several mistaked related to a mix between spaces and Tab.
            * Extends the -d option to include Hybrid Analysis. 
            
Version 1.7.5:

      This version: 

            * It has been fixed a problem related to sample submission to Hybrid Analysis on Windows operating 
              system. Additionally, file name handling has been also fixed. 
            
Version 1.7.3:

      This version: 

            * Malwoverview has been adapted to API version 2.6.0 of Hybrid Analysis.
            * -A option has been fixed according to new version (2.6.0) of Hybrid Analysis.
            * -a option has been modified to work together with  -e option.
            * help information has been modified. 
            
Version 1.7.2:

      This version: 

            * A small fix related to -g option has been included. 
            
Version 1.7.1:

      This version: 

            * Relevant fix of a problem related to options -A and -H options.
            * Includes a new Hybrid Analysis environment to the -e option (Windows 7 32-bits with HWP support).
            * Updates the Malwoverview to support Hybrid Analysis API version 2.5.0.

Version 1.7.0:

      This version: 

            * Includes -A option for submitting a sample to Hybrid Analysis.
            * Includes -g option for checking the status a submission of a sample to Hybrid Analysis.
            * Includes -e option for specifying the testing environment on the Hybrid Analysis.
            * Includes -r option for getting a complete domain report from Virus Total.
            * Modifies the -H options for working together the -e option.
            * Modifies several functions of the tool to prepare it for version 1.8.0

Version 1.6.3:

      This version: 

            * Includes creation of new functions aiming 1.7.0 version.
            * Includes new exception handling blocks.

Version 1.6.2:

      This version: 

            * Includes small fixes.
            * For the Hybrid Analysis API version 2.40 is not longer necessary to include the API Secret.  

Version 1.6.1:

      This version: 

            * Includes small format fixes.

Version 1.6.0:

      This version: 

            * It is using the Hybrid Analysis API version 2.4.0.
            * Includes certificate information in the Hybrid Analysis report. 
            * Includes MITRE information in the Hybrid Analysis report. 
            * Includes an option to download samples from Hybrid Analysis. 

Version 1.5.1:

      This version: 

            * Small change to fix format issue in -d option. 

Version 1.5.0:

      This version: 

            * Includes the -u option to check URLs against Virus Total and associated engines. 
            * Includes the -H option to find existing reports on Virus Total and Hybrid Analysis through the 
              hash.
            * Includes the -V option to submit a file to Virus Total. Additionally, the report is shown after 
              few minutes.
            * Includes two small fixes. 

Version 1.4.5.2:

      This version:

            * Includes two small fixes.

Version 1.4.5.1:

      This version:

            * Includes one small fix. 

Version 1.4.5:

      This version:

            * Adds the -w option to use malwoverview in Windows systems.
            * Improves and fixes colors when using -b option with black window.  

Version 1.4: 

      This version:

            * Adds the -a option for getting the Hybrid Analysis summary report.
            * Adds the -i option for listing imported and exported functions. Therefore, imported/exported
              function report was decoupled for a separated option.  

Version 1.3: 

      This version:

            * Adds the -p option for public Virus Total API.

Version 1.2: 

      This version includes:

            * evaluates a single file (any filetype)
            * shows PE sessions.
            * shows imported functions.
            * shows exported function.
            * extracts overlay.
            * shows AV report from the main players. (any filetype)

Version 1.1: 

      This version:

            * Adds the VT checking feature.


Version 1.0:

      Malwoverview is a tool to perform a first triage of malware samples in a directory and group them 
      according to their import functions (imphash) using colors. This version:

            * Shows the imphash information classified by color. 
            * Checks whether malware samples are packed.  
            * Checks whether malware samples have overlay. 
            * Shows the entropy of the malware samples. 


