"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpPrivateIntegration = void 0;
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * The HTTP Private integration resource for HTTP API
 *
 * @internal
 */
class HttpPrivateIntegration {
    constructor() {
        /**
         * @experimental
         */
        this.httpMethod = aws_apigatewayv2_alpha_1.HttpMethod.ANY;
        /**
         * @experimental
         */
        this.payloadFormatVersion = aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_1_0; // 1.0 is required and is the only supported format
        /**
         * @experimental
         */
        this.integrationType = aws_apigatewayv2_alpha_1.HttpIntegrationType.HTTP_PROXY;
        /**
         * @experimental
         */
        this.connectionType = aws_apigatewayv2_alpha_1.HttpConnectionType.VPC_LINK;
    }
    /**
     * Adds a vpcLink to the API if not passed in the options
     *
     * @internal
     */
    _configureVpcLink(bindOptions, configOptions) {
        let vpcLink = configOptions.vpcLink;
        if (!vpcLink) {
            if (!configOptions.vpc) {
                throw new Error('One of vpcLink or vpc should be provided for private integration');
            }
            vpcLink = bindOptions.route.httpApi.addVpcLink({ vpc: configOptions.vpc });
        }
        return vpcLink;
    }
}
exports.HttpPrivateIntegration = HttpPrivateIntegration;
//# sourceMappingURL=data:application/json;base64,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