import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig } from '@aws-cdk/aws-apigatewayv2-alpha';
import * as elbv2 from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { HttpPrivateIntegrationOptions } from './base-types';
import { HttpPrivateIntegration } from './private/integration';
/**
 * (experimental) Properties to initialize `HttpNlbIntegration`.
 *
 * @experimental
 */
export interface HttpNlbIntegrationProps extends HttpPrivateIntegrationOptions {
    /**
     * (experimental) The listener to the network load balancer used for the integration.
     *
     * @experimental
     */
    readonly listener: elbv2.INetworkListener;
}
/**
 * (experimental) The Network Load Balancer integration resource for HTTP API.
 *
 * @experimental
 */
export declare class HttpNlbIntegration extends HttpPrivateIntegration {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: HttpNlbIntegrationProps);
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
