"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaProxyIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) The Lambda Proxy integration resource for HTTP API.
 *
 * @experimental
 */
class LambdaProxyIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_LambdaProxyIntegrationProps(props);
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        const route = options.route;
        this.props.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(route.node)}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: aws_cdk_lib_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.apiId,
                resourceName: `*/*${(_b = route.path) !== null && _b !== void 0 ? _b : ''}`,
            }),
        });
        return {
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.props.handler.functionArn,
            payloadFormatVersion: (_c = this.props.payloadFormatVersion) !== null && _c !== void 0 ? _c : aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_2_0,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.LambdaProxyIntegration = LambdaProxyIntegration;
_a = JSII_RTTI_SYMBOL_1;
LambdaProxyIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.LambdaProxyIntegration", version: "2.0.0-alpha.9" };
//# sourceMappingURL=data:application/json;base64,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