"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpAlbIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const integration_1 = require("./private/integration");
/**
 * (experimental) The Application Load Balancer integration resource for HTTP API.
 *
 * @experimental
 */
class HttpAlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        super();
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpAlbIntegrationProps(props);
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        let vpc = (_b = this.props.vpcLink) === null || _b === void 0 ? void 0 : _b.vpc;
        if (!vpc && (this.props.listener instanceof elbv2.ApplicationListener)) {
            vpc = this.props.listener.loadBalancer.vpc;
        }
        if (!vpc) {
            throw new Error('The vpcLink property must be specified when using an imported Application Listener.');
        }
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc,
        });
        return {
            method: (_c = this.props.method) !== null && _c !== void 0 ? _c : this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.props.listener.listenerArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpAlbIntegration = HttpAlbIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpAlbIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpAlbIntegration", version: "2.0.0-alpha.9" };
//# sourceMappingURL=data:application/json;base64,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