"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpJwtAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
/**
 * Authorize Http Api routes on whether the requester is registered as part of
 * an AWS Cognito user pool.
 */
class HttpJwtAuthorizer {
    /**
     * Initialize a JWT authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param jwtIssuer The base domain of the identity provider that issues JWT
     * @param props Properties to configure the authorizer
     */
    constructor(id, jwtIssuer, props) {
        this.id = id;
        this.jwtIssuer = jwtIssuer;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_HttpJwtAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(options) {
        var _b, _c;
        if (!this.authorizer) {
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_b = this.props.identitySource) !== null && _b !== void 0 ? _b : ['$request.header.Authorization'],
                type: aws_apigatewayv2_1.HttpAuthorizerType.JWT,
                authorizerName: (_c = this.props.authorizerName) !== null && _c !== void 0 ? _c : this.id,
                jwtAudience: this.props.jwtAudience,
                jwtIssuer: this.jwtIssuer,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpJwtAuthorizer = HttpJwtAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpJwtAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpJwtAuthorizer", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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