(window.webpackJsonp=window.webpackJsonp||[]).push([[292],{1519:function(e,t){e.exports={attributes:{},body:'<div class="start-page__intro" markdown="1">\n\n# Welcome to\n\n## Argilla is a platform to build high-quality AI datasets\n\nIf you need support join the [Argilla Discord community](http://hf.co/join/discord)\n\n</div>\n\n<div class="start-page__content" markdown="1">\n\nGet started by publishing your first dataset.\n\n### 1. Open an IDE, Jupyter or Collab\n\nIf you\'re a Collab user, you can directly use our [introductory tutorial](https://colab.research.google.com/github/argilla-io/argilla/blob/develop/docs/_source/getting_started/quickstart_workflow_feedback.ipynb).\n\n### 2. Install the SDK with pip\n\nTo work with Argilla datasets, you need to use the Argilla SDK. You can install the SDK with pip as follows:\n\n```sh\npip install argilla -U\n```\n\n### 3. Connect to your Argilla server\n\nGet your `ARGILLA_API_URL`:\n\n- If you are using Docker, it is the URL shown in your browser (by default `http://localhost:6900`)\n- If you are using HF Spaces, it should be constructed as follows: `https://[your-owner-name]-[your_space_name].hf.space`\n\nGet your `ARGILLA_API_KEY` you find in ["My settings"](/user-settings) and copy the API key.\n\nMake sure to replace `ARGILLA_API_URL` and `ARGILLA_API_KEY` in the code below. If you are using a private HF Space, you need to specify your `HF_TOKEN` which can be found [here](https://huggingface.co/settings/tokens).\n\n```python\nimport argilla as rg\n\nrg.init(\n    api_url="ARGILLA_API_URL",\n    api_key="ARGILLA_API_KEY",\n    # extra_headers={"Authorization": f"Bearer {"HF_TOKEN"}"}\n)\n```\n\n### 4. Create your first dataset\n\nSpecify a workspace where the dataset will be created. Check your workspaces in ["My settings"](/user-settings). To create a new workspace, check the [docs](https://docs.argilla.io/en/latest/getting_started/installation/configurations/workspace_management.html).\n\nCreate a Dataset with two labels ("sadness" and "joy"). Don\'t forget to replace "<your-workspace>". Here, we are using a task template, check the docs to [create a fully custom dataset](https://docs.argilla.io/en/latest/practical_guides/create_update_dataset/create_dataset.html).\n\n```python\ndataset = rg.FeedbackDataset.for_text_classification(\n    labels=["sadness", "joy"],\n    multi_label=False,\n    use_markdown=True,\n    guidelines=None,\n    metadata_properties=None,\n    vectors_settings=None,\n)\ndataset.push_to_argilla(name="my-first-dataset", workspace="<your-workspace>")\n```\n\n### 5. Add records\n\nCreate a list with the records you want to add. Ensure that you match the fields with the ones specified in the previous step.\n\nYou can also use `pandas` or `load_dataset` to [read an existing dataset and create records from it](https://docs.argilla.io/en/latest/practical_guides/create_update_dataset/records.html#add-records).\n\n```python\nrecords = [\n    rg.FeedbackRecord(\n        fields={\n            "text": "I am so happy today",\n        },\n    ),\n    rg.FeedbackRecord(\n        fields={\n            "text": "I feel sad today",\n        },\n    )\n]\ndataset.add_records(records)\n```\n\n</div>\n'}}}]);