(window.webpackJsonp=window.webpackJsonp||[]).push([[302],{1529:function(n,e){n.exports={attributes:{title:"Transformers",description:"The ArgillaTransformersTrainer leverages the features of transformers to train programmatically with Argilla.",links:[{linkText:"Argilla docs",linkLink:"https://docs.argilla.io/en/latest/practical_guides/fine_tune.html#text-classification"},{linkText:"Transformers docs",linkLink:"https://huggingface.co/docs/transformers/training"}]},body:'*code snippet*\n\n```python\nfrom argilla.training import ArgillaTrainer\n\ntrainer = ArgillaTrainer(\n    name="<my_dataset_name>",\n    workspace="<my_workspace_name>",\n    framework="transformers",\n    train_size=0.8\n)\ntrainer.update_config(num_train_epochs=10)\ntrainer.train(output_dir="text-classification")\nrecords = trainer.predict("The ArgillaTrainer is great!", as_argilla_records=True)\n```\n\n*update training config*\n\n```python\n# `transformers.AutoModelForTextClassification`\ntrainer.update_config(\n    pretrained_model_name_or_path = "distilbert-base-uncased",\n    force_download = False,\n    resume_download = False,\n    proxies = None,\n    token = None,\n    cache_dir = None,\n    local_files_only = False\n)\n# `transformers.TrainingArguments`\ntrainer.update_config(\n    per_device_train_batch_size = 8,\n    per_device_eval_batch_size = 8,\n    gradient_accumulation_steps = 1,\n    learning_rate = 5e-5,\n    weight_decay = 0,\n    adam_beta1 = 0.9,\n    adam_beta2 = 0.9,\n    adam_epsilon = 1e-8,\n    max_grad_norm = 1,\n    learning_rate = 5e-5,\n    num_train_epochs = 3,\n    max_steps = 0,\n    log_level = "passive",\n    logging_strategy = "steps",\n    save_strategy = "steps",\n    save_steps = 500,\n    seed = 42,\n    push_to_hub = False,\n    hub_model_id = "user_name/output_dir_name",\n    hub_strategy = "every_save",\n    hub_token = "1234",\n    hub_private_repo = False\n)\n```\n'}}}]);