#  Copyright 2021-present, the Recognai S.L. team.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

"""create vectors table

Revision ID: bda6fe24314e
Revises: 7850ab5b42d9
Create Date: 2023-09-21 15:41:59.642012

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "bda6fe24314e"
down_revision = "7850ab5b42d9"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "vectors",
        sa.Column("value", sa.JSON(), nullable=False),
        sa.Column("record_id", sa.Uuid(), nullable=False),
        sa.Column("vector_settings_id", sa.Uuid(), nullable=False),
        sa.Column("id", sa.Uuid(), nullable=False),
        sa.Column("inserted_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(["record_id"], ["records.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["vector_settings_id"], ["vectors_settings.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("record_id", "vector_settings_id", name="vector_record_id_vector_settings_id_uq"),
    )
    op.create_index(op.f("ix_vectors_record_id"), "vectors", ["record_id"], unique=False)
    op.create_index(op.f("ix_vectors_vector_settings_id"), "vectors", ["vector_settings_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_vectors_vector_settings_id"), table_name="vectors")
    op.drop_index(op.f("ix_vectors_record_id"), table_name="vectors")
    op.drop_table("vectors")
    # ### end Alembic commands ###
