"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedPolicy = exports.ManagedPolicyProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ram_generated_1 = require("./ram.generated");
Object.defineProperty(exports, "ManagedPolicyProperty", { enumerable: true, get: function () { return ram_generated_1.RosManagedPolicy; } });
/**
 * A ROS resource type:  `ALIYUN::RAM::ManagedPolicy`
 */
class ManagedPolicy extends ros.Resource {
    /**
     * Create a new `ALIYUN::RAM::ManagedPolicy`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosManagedPolicy = new ram_generated_1.RosManagedPolicy(this, id, {
            ignoreExisting: props.ignoreExisting === undefined || props.ignoreExisting === null ? false : props.ignoreExisting,
            description: props.description,
            groups: props.groups,
            policyName: props.policyName,
            policyDocumentUnchecked: props.policyDocumentUnchecked,
            policyDocument: props.policyDocument,
            roles: props.roles,
            users: props.users,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosManagedPolicy;
        this.attrPolicyName = rosManagedPolicy.attrPolicyName;
    }
}
exports.ManagedPolicy = ManagedPolicy;
//# sourceMappingURL=data:application/json;base64,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