"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const cloudwatch_generated_1 = require("./cloudwatch.generated");
const layout_1 = require("./layout");
var PeriodOverride;
(function (PeriodOverride) {
    PeriodOverride["AUTO"] = "auto";
    PeriodOverride["INHERIT"] = "inherit";
})(PeriodOverride = exports.PeriodOverride || (exports.PeriodOverride = {}));
/**
 * A CloudWatch dashboard
 */
class Dashboard extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.dashboardName,
        });
        this.rows = [];
        {
            const { dashboardName } = props;
            if (dashboardName && !core_1.Token.isUnresolved(dashboardName) && !dashboardName.match(/^[\w-]+$/)) {
                throw new Error([
                    `The value ${dashboardName} for field dashboardName contains invalid characters.`,
                    'It can only contain alphanumerics, dash (-) and underscore (_).'
                ].join(' '));
            }
        }
        new cloudwatch_generated_1.CfnDashboard(this, 'Resource', {
            dashboardName: this.physicalName,
            dashboardBody: core_1.Lazy.stringValue({ produce: () => {
                    const column = new layout_1.Column(...this.rows);
                    column.position(0, 0);
                    return core_1.Stack.of(this).toJsonString({
                        start: props.start,
                        end: props.end,
                        periodOverride: props.periodOverride,
                        widgets: column.toJson(),
                    });
                } })
        });
        (props.widgets || []).forEach(row => {
            this.addWidgets(...row);
        });
    }
    /**
     * Add a widget to the dashboard.
     *
     * Widgets given in multiple calls to add() will be laid out stacked on
     * top of each other.
     *
     * Multiple widgets added in the same call to add() will be laid out next
     * to each other.
     */
    addWidgets(...widgets) {
        if (widgets.length === 0) {
            return;
        }
        const w = widgets.length > 1 ? new layout_1.Row(...widgets) : widgets[0];
        this.rows.push(w);
    }
}
exports.Dashboard = Dashboard;
//# sourceMappingURL=data:application/json;base64,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