import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::CloudWatch::Alarm`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 */
export interface CfnAlarmProps {
    /**
     * `AWS::CloudWatch::Alarm.ComparisonOperator`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-comparisonoperator
     */
    readonly comparisonOperator: string;
    /**
     * `AWS::CloudWatch::Alarm.EvaluationPeriods`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluationperiods
     */
    readonly evaluationPeriods: number;
    /**
     * `AWS::CloudWatch::Alarm.ActionsEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
     */
    readonly actionsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::Alarm.AlarmActions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmactions
     */
    readonly alarmActions?: string[];
    /**
     * `AWS::CloudWatch::Alarm.AlarmDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmdescription
     */
    readonly alarmDescription?: string;
    /**
     * `AWS::CloudWatch::Alarm.AlarmName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmname
     */
    readonly alarmName?: string;
    /**
     * `AWS::CloudWatch::Alarm.DatapointsToAlarm`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm
     */
    readonly datapointsToAlarm?: number;
    /**
     * `AWS::CloudWatch::Alarm.Dimensions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
     */
    readonly dimensions?: Array<CfnAlarm.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluatelowsamplecountpercentile
     */
    readonly evaluateLowSampleCountPercentile?: string;
    /**
     * `AWS::CloudWatch::Alarm.ExtendedStatistic`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-extendedstatistic
     */
    readonly extendedStatistic?: string;
    /**
     * `AWS::CloudWatch::Alarm.InsufficientDataActions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-insufficientdataactions
     */
    readonly insufficientDataActions?: string[];
    /**
     * `AWS::CloudWatch::Alarm.MetricName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-metricname
     */
    readonly metricName?: string;
    /**
     * `AWS::CloudWatch::Alarm.Metrics`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
     */
    readonly metrics?: Array<CfnAlarm.MetricDataQueryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::Alarm.Namespace`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-namespace
     */
    readonly namespace?: string;
    /**
     * `AWS::CloudWatch::Alarm.OKActions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-okactions
     */
    readonly okActions?: string[];
    /**
     * `AWS::CloudWatch::Alarm.Period`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-period
     */
    readonly period?: number;
    /**
     * `AWS::CloudWatch::Alarm.Statistic`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-statistic
     */
    readonly statistic?: string;
    /**
     * `AWS::CloudWatch::Alarm.Threshold`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-threshold
     */
    readonly threshold?: number;
    /**
     * `AWS::CloudWatch::Alarm.ThresholdMetricId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dynamic-threshold
     */
    readonly thresholdMetricId?: string;
    /**
     * `AWS::CloudWatch::Alarm.TreatMissingData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-treatmissingdata
     */
    readonly treatMissingData?: string;
    /**
     * `AWS::CloudWatch::Alarm.Unit`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-unit
     */
    readonly unit?: string;
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`
 *
 * @cloudformationResource AWS::CloudWatch::Alarm
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 */
export declare class CfnAlarm extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::Alarm";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CloudWatch::Alarm.ComparisonOperator`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-comparisonoperator
     */
    comparisonOperator: string;
    /**
     * `AWS::CloudWatch::Alarm.EvaluationPeriods`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluationperiods
     */
    evaluationPeriods: number;
    /**
     * `AWS::CloudWatch::Alarm.ActionsEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
     */
    actionsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::Alarm.AlarmActions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmactions
     */
    alarmActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::Alarm.AlarmDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmdescription
     */
    alarmDescription: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.AlarmName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmname
     */
    alarmName: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.DatapointsToAlarm`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm
     */
    datapointsToAlarm: number | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Dimensions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
     */
    dimensions: Array<CfnAlarm.DimensionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluatelowsamplecountpercentile
     */
    evaluateLowSampleCountPercentile: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.ExtendedStatistic`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-extendedstatistic
     */
    extendedStatistic: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.InsufficientDataActions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-insufficientdataactions
     */
    insufficientDataActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::Alarm.MetricName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-metricname
     */
    metricName: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Metrics`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
     */
    metrics: Array<CfnAlarm.MetricDataQueryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Namespace`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-namespace
     */
    namespace: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.OKActions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-okactions
     */
    okActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Period`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-period
     */
    period: number | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Statistic`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-statistic
     */
    statistic: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Threshold`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-threshold
     */
    threshold: number | undefined;
    /**
     * `AWS::CloudWatch::Alarm.ThresholdMetricId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dynamic-threshold
     */
    thresholdMetricId: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.TreatMissingData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-treatmissingdata
     */
    treatMissingData: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Unit`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-unit
     */
    unit: string | undefined;
    /**
     * Create a new `AWS::CloudWatch::Alarm`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAlarmProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnAlarm {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html
     */
    interface DimensionProperty {
        /**
         * `CfnAlarm.DimensionProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html#cfn-cloudwatch-alarm-dimension-name
         */
        readonly name: string;
        /**
         * `CfnAlarm.DimensionProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html#cfn-cloudwatch-alarm-dimension-value
         */
        readonly value: string;
    }
}
export declare namespace CfnAlarm {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html
     */
    interface MetricProperty {
        /**
         * `CfnAlarm.MetricProperty.Dimensions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-dimensions
         */
        readonly dimensions?: Array<CfnAlarm.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAlarm.MetricProperty.MetricName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-metricname
         */
        readonly metricName?: string;
        /**
         * `CfnAlarm.MetricProperty.Namespace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-namespace
         */
        readonly namespace?: string;
    }
}
export declare namespace CfnAlarm {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html
     */
    interface MetricDataQueryProperty {
        /**
         * `CfnAlarm.MetricDataQueryProperty.Expression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-expression
         */
        readonly expression?: string;
        /**
         * `CfnAlarm.MetricDataQueryProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-id
         */
        readonly id: string;
        /**
         * `CfnAlarm.MetricDataQueryProperty.Label`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-label
         */
        readonly label?: string;
        /**
         * `CfnAlarm.MetricDataQueryProperty.MetricStat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-metricstat
         */
        readonly metricStat?: CfnAlarm.MetricStatProperty | cdk.IResolvable;
        /**
         * `CfnAlarm.MetricDataQueryProperty.ReturnData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-returndata
         */
        readonly returnData?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnAlarm {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html
     */
    interface MetricStatProperty {
        /**
         * `CfnAlarm.MetricStatProperty.Metric`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-metric
         */
        readonly metric: CfnAlarm.MetricProperty | cdk.IResolvable;
        /**
         * `CfnAlarm.MetricStatProperty.Period`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-period
         */
        readonly period: number;
        /**
         * `CfnAlarm.MetricStatProperty.Stat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-stat
         */
        readonly stat: string;
        /**
         * `CfnAlarm.MetricStatProperty.Unit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-unit
         */
        readonly unit?: string;
    }
}
/**
 * Properties for defining a `AWS::CloudWatch::AnomalyDetector`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 */
export interface CfnAnomalyDetectorProps {
    /**
     * `AWS::CloudWatch::AnomalyDetector.MetricName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricname
     */
    readonly metricName: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Namespace`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-namespace
     */
    readonly namespace: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Stat`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-stat
     */
    readonly stat: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Configuration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-configuration
     */
    readonly configuration?: CfnAnomalyDetector.ConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Dimensions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-dimensions
     */
    readonly dimensions?: Array<CfnAnomalyDetector.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`
 *
 * @cloudformationResource AWS::CloudWatch::AnomalyDetector
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 */
export declare class CfnAnomalyDetector extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::AnomalyDetector";
    /**
     * `AWS::CloudWatch::AnomalyDetector.MetricName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricname
     */
    metricName: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Namespace`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-namespace
     */
    namespace: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Stat`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-stat
     */
    stat: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Configuration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-configuration
     */
    configuration: CfnAnomalyDetector.ConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Dimensions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-dimensions
     */
    dimensions: Array<CfnAnomalyDetector.DimensionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CloudWatch::AnomalyDetector`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAnomalyDetectorProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnAnomalyDetector {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-configuration.html
     */
    interface ConfigurationProperty {
        /**
         * `CfnAnomalyDetector.ConfigurationProperty.ExcludedTimeRanges`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-configuration.html#cfn-cloudwatch-anomalydetector-configuration-excludedtimeranges
         */
        readonly excludedTimeRanges?: Array<CfnAnomalyDetector.RangeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.ConfigurationProperty.MetricTimeZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-configuration.html#cfn-cloudwatch-anomalydetector-configuration-metrictimezone
         */
        readonly metricTimeZone?: string;
    }
}
export declare namespace CfnAnomalyDetector {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-dimension.html
     */
    interface DimensionProperty {
        /**
         * `CfnAnomalyDetector.DimensionProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-dimension.html#cfn-cloudwatch-anomalydetector-dimension-name
         */
        readonly name: string;
        /**
         * `CfnAnomalyDetector.DimensionProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-dimension.html#cfn-cloudwatch-anomalydetector-dimension-value
         */
        readonly value: string;
    }
}
export declare namespace CfnAnomalyDetector {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-range.html
     */
    interface RangeProperty {
        /**
         * `CfnAnomalyDetector.RangeProperty.EndTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-range.html#cfn-cloudwatch-anomalydetector-range-endtime
         */
        readonly endTime: string;
        /**
         * `CfnAnomalyDetector.RangeProperty.StartTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-range.html#cfn-cloudwatch-anomalydetector-range-starttime
         */
        readonly startTime: string;
    }
}
/**
 * Properties for defining a `AWS::CloudWatch::Dashboard`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html
 */
export interface CfnDashboardProps {
    /**
     * `AWS::CloudWatch::Dashboard.DashboardBody`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardbody
     */
    readonly dashboardBody: string;
    /**
     * `AWS::CloudWatch::Dashboard.DashboardName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardname
     */
    readonly dashboardName?: string;
}
/**
 * A CloudFormation `AWS::CloudWatch::Dashboard`
 *
 * @cloudformationResource AWS::CloudWatch::Dashboard
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html
 */
export declare class CfnDashboard extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::Dashboard";
    /**
     * `AWS::CloudWatch::Dashboard.DashboardBody`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardbody
     */
    dashboardBody: string;
    /**
     * `AWS::CloudWatch::Dashboard.DashboardName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardname
     */
    dashboardName: string | undefined;
    /**
     * Create a new `AWS::CloudWatch::Dashboard`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDashboardProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudWatch::InsightRule`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html
 */
export interface CfnInsightRuleProps {
    /**
     * `AWS::CloudWatch::InsightRule.RuleBody`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulebody
     */
    readonly ruleBody: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulename
     */
    readonly ruleName: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleState`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulestate
     */
    readonly ruleState: string;
}
/**
 * A CloudFormation `AWS::CloudWatch::InsightRule`
 *
 * @cloudformationResource AWS::CloudWatch::InsightRule
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html
 */
export declare class CfnInsightRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::InsightRule";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute RuleName
     */
    readonly attrRuleName: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleBody`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulebody
     */
    ruleBody: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulename
     */
    ruleName: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleState`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulestate
     */
    ruleState: string;
    /**
     * Create a new `AWS::CloudWatch::InsightRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInsightRuleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
