# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['configur']

package_data = \
{'': ['*']}

install_requires = \
['boto3>=1.18.4,<2.0.0',
 'python-box>=5.3.0,<6.0.0',
 'python-dotenv>=0.18.0,<0.19.0',
 'tomlkit>=0.7.2,<0.8.0']

setup_kwargs = {
    'name': 'configur',
    'version': '0.1.4',
    'description': 'TOML-based configuration for Python',
    'long_description': '## Configur\n#### TOML-based configuration for Python\n\n### Features\n* TOML file configuration definition (supports nested tables, multiple environments)\n* Fetching variables from AWS Parameter Store (SSM), secure or standard\n* Override any configuration at runtime with an environment variable\n* Simple logging config: easily set levels per package, special handling for AWS Lambda\n\n\n#### Configuration\nConfiguration variables are stored in a single toml file. The default is expecting a file called `settings.toml`,\nbut you can set a custom path as needed. \n\nCertain secrets (e.g. passwords) that should not be checked into Git can be interpolated from\nenvironment variables. If you declared an item as `my_var = "${EXAMPLE_VALUE}"`, you will\nneed to have an environment variable `EXAMPLE_VALUE` defined. To avoid\npassing secrets in plaintext in the run environment, you can also define variables in AWS Systems Manager\nParameter Store (SSM). To do so, simply prefix the value with `ssm:` and the code will automatically\nfetch and decode the param at runtime, assuming the proper credentials are available to get and decrypt the parameter.\n\nThese configuration files are parsed by the [TOML Kit](https://github.com/sdispater/tomlkit) library, and then stored \nas attributes on an object called [Settings](#Settings). \n\nEvery settings.toml file must have a `default` table. These default values are shared across all environments.\n\n```\n[default]\noutput_file_name = "example.csv"\n```\n\nAfter the `default` table, a table for each environment should exist, e.g. "local", "dev", and "prod". These tables override\nany values that exist in the `default` table with the same name; in other words - environment settings take precedence over default settings.\nBelow we have two environments, `local` and `dev`, each with a custom `database_username` variable. In `dev`, we override the default `output_file_name`.\n```\n[default]\noutput_file_name = "example.csv"\n\n[local]\ndatabase_username = "local_user"\n\n[dev]\noutput_file_name = "example_dev.csv"\ndatabase_username = "dev_user"\n```\n\nSince TOML and TOML Kit support nested tables/sections, we use them within the context of an environment. To declare a group of settings\nfor a given environment, prefix the table name with the name of the environment, e.g. `local.mysql`.\n\n```\n[default]\noutput_file_name = "example.csv"\n\n[local]\n    [local.mysql]\n    username = "local_user"\n    password = "secret password"\n```\n\nRead more below for how these values are accessed in Settings.\n\n#### Settings\nThe [Settings](configur/config.py) class reads `settings.toml` files, and sets attributes on itself for \nevery item in the config file. However, it will only ever load settings from the `default` table and the table (and its children) matching \nthe current environment, e.g., `local`. The environment **must** be set with a variable `PROJECT_ENV`, otherwise the fallback \nis `local` so nothing will ever touch production by accident. The value of this variable needs to match a corresponding section in your `settings.toml` file,\nbut you are free to name environments as you wish. There\'s no difference if you call an environment `dev` or `sandbox` or `test`, so long as\nyou set `PROJECT_ENV=dev` or `PROJECT_ENV=sandbox` or `PROJECT_ENV=test`.\n\nInitialization:\n```\nfrom configur import Settings\nsettings = Settings(config_filepath=custom_path + "settings.toml")\n```\n\nBy default, it extracts the environment from the `PROJECT_ENV` variable, but you can override if needed by passing an `env` argument:\n```\nsettings = Settings(config_filepath=custom_path + "settings.toml", env="dev")\n```\n\nAfter your config file is read, the default and environment-specific values are set to be accessible from the Settings object\nin either dict-notation, or dot-notation. Inspired by [Dynaconf](https://www.dynaconf.com/), this means you can do the following:\n```\n# Get\nsettings.user\nsettings.get("user")\nsettings["user"]\n\n# Get nested settings e.g. from [local.mysql] section of settings.toml\nsettings.mysql.user\nsettings.get("mysql").user\nsettings["mysql"]["user"]\n\n# Set\nsettings.user = "admin"\nsettings["user"] = "admin"\n\n# Iterate\nfor x in settings.items()\nfor x in settings.keys()\nfor x in settings.values()\n```\n\nThis flexibility makes it easier to access settings vs always having to use dict-notation, get environment variables every time, \nor use ConfigParser and pass the section for every variable. \n\nBecause Settings is a dict-like object, you can also set values to update config or store state as your job progresses. \nThis can however introduce side effects since you are bringing state into functions, but it can be handy to throw variables in here\ninstead of passing them down a large tree of functions as standard arguments.\n\n#### Logging\nConfigur provides a function `init_logging` which initializes handlers, formatters, and loggers with Python\'s logging.config.dictConfig.\nSimilar to Settings, you can pass a custom `env` argument but the default is your `PROJECT_ENV` environment variable.\nWe set the root log level based on your environment (local, dev = DEBUG, all others = INFO), but you can also pass this as an\noverride with the `root_level` argument, OR by setting an environment variable `ROOT_LOG_LEVEL`. We also expose the logging.config option\n`disable_existing_loggers` as an argument, defaulted to False. \n\n##### Customizing module loggers: \nYou can customize the log level for any module by passing a dictionary where keys are module names, and values are log levels. \nExample as read from `settings.toml`:\n\n```\n# settings.toml\n[logging]\nboto3 = "DEBUG"\nbotocore = "ERROR"\n\n# main.py\ninit_logging(loggers=settings.logging)\n```\n\n##### Special Handling for AWS Lambda\nSince AWS Lambda controls the logging environment, we can\'t/shouldn\'t set any custom formatters or logging config. What \nwe can do though is set the overall log level. When running a lambda recipe, use the `is_lambda` option, which when set to True\nwill skip the dictConfig initialization and just call `logging.getLogger().setLevel(log_level)` with either the default\nenvironment level, or a custom level passed in like `init_logging(level="DEBUG")`.\n',
    'author': 'Studio Trackr',
    'author_email': 'info@studiotrackr.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/StudioTrackr/configur',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
