"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
const path = require("path");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codedeploy-lambda');
const handler = new lambda.Function(stack, 'Handler', {
    code: lambda.Code.fromAsset(path.join(__dirname, 'handler')),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_10_X,
});
const version = handler.addVersion('1');
const blueGreenAlias = new lambda.Alias(stack, 'Alias', {
    aliasName: 'alias',
    version
});
const preHook = new lambda.Function(stack, 'PreHook', {
    code: lambda.Code.fromAsset(path.join(__dirname, 'preHook')),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_10_X
});
const postHook = new lambda.Function(stack, 'PostHook', {
    code: lambda.Code.fromAsset(path.join(__dirname, 'postHook')),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_10_X
});
new codedeploy.LambdaDeploymentGroup(stack, 'BlueGreenDeployment', {
    alias: blueGreenAlias,
    deploymentConfig: codedeploy.LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE,
    alarms: [
        new cloudwatch.Alarm(stack, 'BlueGreenErrors', {
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_THRESHOLD,
            threshold: 1,
            evaluationPeriods: 1,
            metric: blueGreenAlias.metricErrors()
        })
    ],
    preHook,
    postHook
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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