# -!- coding: utf-8 -!-
from copy import deepcopy

class 数据集():
    class 全国城市:
        item = {
            # 等级: [(简称, 区号), ...]
            1: [('北京', '010'), ('上海', '021'), ('广州', '020'), ('深圳', '0755'), ('成都', '0282'), ('重庆', '023'), ('杭州', '0571'), ('武汉', '027'), ('西安', '029'), ('天津', '022'), ('苏州', '0512'), ('南京', '025'), ('郑州', '03712'), ('长沙', '07318'), ('东莞', '0796'), ('沈阳', '0243'), ('青岛', '0532'), ('合肥', '05512'), ('佛山', '0757')],
            2: [('宁波', '0574'), ('昆明', '0871'), ('福州', '0591'), ('无锡', '0510'), ('厦门', '0592'), ('济南', '0531'), ('大连', '0411'), ('哈尔滨', '0451'), ('温州', '0577'), ('石家庄', '0311'), ('泉州', '0595'), ('南宁', '0771'), ('长春', '0431'), ('南昌', '0791'), ('贵阳', '08513'), ('金华', '0579'), ('常州', '0519'), ('惠州', '0752'), ('嘉兴', '0573'), ('南通', '0513'), ('徐州', '0516'), ('太原', '0351'), ('珠海', '0756'), ('中山', '0760'), ('保定', '0312'), ('兰州', '0931'), ('台州', '0576'), ('绍兴', '0575'), ('烟台廊坊', None)],
            3: [('潍坊', '0536'), ('扬州', '0514'), ('海口', '08982'), ('汕头', '0754'), ('洛阳', '0379'), ('乌鲁木齐', '0991'), ('临沂', '0539'), ('唐山', '0315'), ('镇江', '0511'), ('盐城', '0515'), ('湖州', '0572'), ('赣州', '0797'), ('泰州', '0523'), ('济宁', '0537'), ('呼和浩特', '0471'), ('咸阳', '0291'), ('漳州', '0596'), ('揭阳', '0663'), ('江门', '0750'), ('桂林', '0773'), ('邯郸', '0310'), ('芜湖', '0553'), ('三亚', '0898'), ('阜阳', '0558'), ('淮安', '0517'), ('遵义', '08512'), ('银川', '0951'), ('衡阳', '0734'), ('上饶', '0793'), ('柳州', '0772'), ('淄博', '0533'), ('莆田', '0594'), ('绵阳', '0816'), ('湛江', '0759'), ('商丘', '0370'), ('宜昌', '0717'), ('沧州', '0317'), ('连云港', '0518'), ('南阳', '0377'), ('九江', '0792'), ('新乡', '0373'), ('信阳', '0376'), ('襄阳', '0710'), ('岳阳', '0730'), ('蚌埠', '0552'), ('驻马店', '0396'), ('滁州', '0550'), ('威海', '0631'), ('宿迁', '0527'), ('株洲', '07312'), ('宁德', '0593'), ('邢台', '0319'), ('潮州', '0768'), ('秦皇岛', '0335'), ('肇庆', '0758'), ('荆州', '0716'), ('周口', '0394'), ('马鞍山', '0555'), ('清远', '0763'), ('宿州', '0557'), ('鞍山', '05552'), ('安庆', '0556'), ('菏泽', '0530'), ('宜春', '0795'), ('黄冈', '0713'), ('泰安', '0538'), ('南充', '0817'), ('六安', '0564'), ('大庆', '0459'), ('舟山', '0580')],
            4: [('常德', '0736'), ('渭南', '0913'), ('孝感', None), ('丽水', '0578'), ('运城', '0359'), ('德州', '0534'), ('许昌', '0374'), ('湘潭', '07315'), ('晋中', '0354'), ('安阳', '0372'), ('三明', '0598'), ('开封', '0371'), ('郴州', '0735'), ('茂名', '0668'), ('邵阳', '0739'), ('德阳', '0838'), ('龙岩', '0597'), ('南平', '0599'), ('淮南', '0554'), ('黄石', '0714'), ('营口', '0417'), ('亳州', '05582'), ('日照', '0633'), ('西宁', '0971'), ('衢州', '0570'), ('东营', '0546'), ('吉林', '0432'), ('韶关', '0751'), ('枣庄', '0632'), ('包头', '0472'), ('怀化', '0745'), ('宣城', '0563'), ('临汾', '0357'), ('聊城', '0635'), ('梅州', '0753'), ('盘锦', '0427'), ('锦州', '0416'), ('榆林', '0912'), ('北海', '0779'), ('宝鸡', '0917'), ('抚州', '0794'), ('景德镇', '0798'), ('玉林', '0775'), ('十堰', '0719'), ('汕尾', None), ('咸宁', '0715'), ('宜宾', '0831'), ('焦作', '03912'), ('平顶山', '0375'), ('滨州', None), ('吉安', '07962'), ('永州', '0746'), ('益阳', '0737'), ('黔南', '0854'), ('丹东', '0415'), ('曲靖', '0874'), ('乐山', '08332'), ('黔东南', None), ('张家口', '0313'), ('黄山', '0559'), ('鄂尔多斯', '0477'), ('阳江', '0662'), ('泸州', '0830'), ('恩施', '0718'), ('衡水', None), ('铜陵', '0562'), ('承德', '0314'), ('红河', None), ('大理', '0872'), ('大同', '0352'), ('漯河', '0395'), ('葫芦岛', '0429'), ('河源', '0762'), ('娄底', '0738'), ('延边', None), ('齐齐哈尔', '0452'), ('延安', '0911'), ('抚顺', '02421'), ('拉萨', None), ('铜仁', None), ('长治', None), ('达州', '0818'), ('鄂州', '0711'), ('忻州', None), ('吕梁', '0358'), ('淮北', '0561'), ('濮阳', '0393'), ('眉山', '0283'), ('池州', None), ('荆门', '0724')],
            5: [('汉中', '0916'), ('辽阳', '0419'), ('梧州', None), ('鹰潭', None), ('百色', None), ('毕节', '08572'), ('钦州', '0777'), ('云浮', '0766'), ('佳木斯', None), ('朝阳', '0421'), ('贵港', None), ('丽江', '0888'), ('四平', None), ('内江', '0832'), ('六盘水', '0858'), ('安顺', None), ('三门峡', '0398'), ('赤峰', '0476'), ('新余', '0790'), ('牡丹江', '0453'), ('晋城', '0356'), ('自贡', '0813'), ('本溪', '0241'), ('防城港', None), ('铁岭', '0242'), ('随州', '0722'), ('广安', None), ('广元', '0839'), ('天水', None), ('遂宁', '0825'), ('萍乡', '0799'), ('西双版纳', '0691'), ('绥化', None), ('鹤壁', None), ('湘西', None), ('松原', '0438'), ('阜新', '0418'), ('酒泉', '0937'), ('张家界', '0744'), ('黔西南', None), ('保山', '0875'), ('昭通', None), ('克拉玛依', None), ('呼伦贝尔', '0470'), ('贺州', None), ('通化', None), ('阳泉', None), ('河池', None), ('来宾', None), ('玉溪', '0877'), ('安康', '0915'), ('通辽', '0475'), ('德宏', None), ('楚雄', '0878'), ('朔州', None), ('伊型', None), ('文山', '0876'), ('嘉峪关', None), ('凉山', None), ('资阳', '0281'), ('锡林郭勒', None), ('雅安', '0835'), ('普洱', None), ('崇左', None), ('庆阳', None), ('巴音郭楞', None), ('乌兰察布', '0474'), ('白山', None), ('昌吉', None), ('白城', '0436'), ('兴安', None), ('定西', '0932'), ('喀什', '0998'), ('白银', None), ('陇南', None), ('张掖', None), ('商洛', '0914'), ('黑河', None), ('哈密', '0902'), ('吴忠', '0953'), ('攀枝花', '0812'), ('巴彦淖尔', None), ('巴中', None), ('鸡西', None), ('乌海', None), ('临沧', '0883'), ('海东', None), ('双鸭山', None), ('阿克苏', '0997'), ('石嘴山', None), ('阿拉善', None), ('海西', None), ('平凉', '0933'), ('辽源', None), ('临夏', None), ('铜川', '0919'), ('金昌', None), ('鹤岗', '0468'), ('伊春', None), ('林芝', None), ('固原', '0954'), ('武威', '0935'), ('偏州', None), ('吐鲁番', None), ('甘孜', None), ('中卫', None), ('怒江', None), ('和田', None), ('迪庆', None), ('甘南', None), ('阿坝', None), ('大兴安岭', None), ('七台河', None), ('山南', None), ('日喀则', None), ('塔城', None), ('博尔塔拉', None), ('昌都', None), ('阿勒泰', None), ('玉树', None), ('海南', None), ('克孜勒苏', None), ('阿里', None), ('海北', None), ('黄南', None), ('果洛', None), ('那曲', None), ('三沙', None)],
            6: [('香港', '00852'), ('澳门', '00853'), ('黔东', '0855'), ('巢湖', '0551'), ('澄迈县', '08988'), ('延边朝鲜族自治州', '0433'), ('海南直辖行政单位', '08993'), ('天门', '07283'), ('兴安盟', '0482'), ('凉山彝族自治州', '0834'), ('济源', '0391'), ('伊犁哈萨克自治州', '0999'), ('黔西', '0857'), ('烟台', '0535'), ('金门', '026'), ('红河哈尼族彝族自治州', '0873'), ('潜江', None), ('仙桃', '07281'), ('巴音郭楞蒙古自治州', '0996'), ('廊坊', '0316'), ('东方', '08981')],
        }

        @classmethod
        def 获取城市名称列表(cls): return [y[0] for x in cls.item.values() for y in x]

        @classmethod
        def 获取区号列表(cls): return [y[1] for x in cls.item.values() for y in x if y[1]]
        
        @classmethod
        def 获取城市列表(cls):
            return [dict(等级=等级, 简称=简称, 全称=简称+'市', 区号=区号) for 等级, 城市s in 
            cls.item.items() for 简称, 区号 in 城市s]
        
        @classmethod
        def 获取城市字典(cls):
            item = {}
            for x in cls.获取城市列表(): item[x['简称']] = item[x['全称']] = item[x['区号']] = x
            item.pop(None, '')
            return item

    # 兼容张工的代码
    class 全国城市分级表2020():
        def to_list(): return 数据集.全国城市.获取城市名称列表()

        def to_dict():
            item = {1:'一线', 2:'二线', 3:'三线', 4:'四线', 5:'五线', 6:'六线'}
            return {item[等级]:[城市[0] for 城市 in 城市s] 
            for 等级, 城市s in 数据集.全国城市.item.items()}
