# Copyright (c) 2004 Adam Karpierz
# Licensed under CC BY-NC-ND 4.0
# Licensed under proprietary License
# Please refer to the accompanying LICENSE file.

import jni

from .....jcontext import JContext
from .....jframe   import JFrame
from .....jhost    import JHost


# Class: org.jt.ref.Reference

# Method: native void initialize(long pyobj);

@jni.method("(J)V")
def initialize(env, this,
               pyobj):
    pyobj = jni.from_oid(pyobj)
    jvm, jenv = JContext(env[0])
    with JHost.CallbackState((jvm, jenv)):
        JHost.incRef(pyobj)

# Method: native void release(long pyobj);

@jni.method("(J)V")
def release(env, this,
            pyobj):
    pyobj = jni.from_oid(pyobj)
    jvm, jenv = JContext(env[0])
    with JHost.CallbackState((jvm, jenv)):
        JHost.decRef(pyobj)


__jnimethods__ = (
    initialize,
    release,
)

__javacode__ = bytearray(  # Auto-generated; DO NOT EDIT!
    b"\xca\xfe\xba\xbe\x00\x00\x00\x34\x00\x1c\x0a\x00\x06\x00\x15\x0a\x00\x05\x00\x16"
    b"\x09\x00\x05\x00\x17\x0a\x00\x05\x00\x18\x07\x00\x19\x07\x00\x1a\x01\x00\x05\x70"
    b"\x79\x6f\x62\x6a\x01\x00\x01\x4a\x01\x00\x06\x3c\x69\x6e\x69\x74\x3e\x01\x00\x34"
    b"\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x4a"
    b"\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x72\x65\x66\x2f\x52\x65\x66\x65\x72"
    b"\x65\x6e\x63\x65\x51\x75\x65\x75\x65\x3b\x29\x56\x01\x00\x04\x43\x6f\x64\x65\x01"
    b"\x00\x09\x53\x69\x67\x6e\x61\x74\x75\x72\x65\x01\x00\x48\x28\x4c\x6a\x61\x76\x61"
    b"\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x4a\x4c\x6a\x61\x76\x61\x2f"
    b"\x6c\x61\x6e\x67\x2f\x72\x65\x66\x2f\x52\x65\x66\x65\x72\x65\x6e\x63\x65\x51\x75"
    b"\x65\x75\x65\x3c\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63"
    b"\x74\x3b\x3e\x3b\x29\x56\x01\x00\x07\x64\x69\x73\x70\x6f\x73\x65\x01\x00\x03\x28"
    b"\x29\x56\x01\x00\x0d\x53\x74\x61\x63\x6b\x4d\x61\x70\x54\x61\x62\x6c\x65\x01\x00"
    b"\x0a\x69\x6e\x69\x74\x69\x61\x6c\x69\x7a\x65\x01\x00\x04\x28\x4a\x29\x56\x01\x00"
    b"\x07\x72\x65\x6c\x65\x61\x73\x65\x01\x00\x34\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x72\x65\x66\x2f\x50\x68\x61\x6e\x74\x6f\x6d\x52\x65\x66\x65\x72\x65\x6e"
    b"\x63\x65\x3c\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74"
    b"\x3b\x3e\x3b\x0c\x00\x09\x00\x1b\x0c\x00\x11\x00\x12\x0c\x00\x07\x00\x08\x0c\x00"
    b"\x13\x00\x12\x01\x00\x14\x6f\x72\x67\x2f\x6a\x74\x2f\x72\x65\x66\x2f\x52\x65\x66"
    b"\x65\x72\x65\x6e\x63\x65\x01\x00\x1e\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x72"
    b"\x65\x66\x2f\x50\x68\x61\x6e\x74\x6f\x6d\x52\x65\x66\x65\x72\x65\x6e\x63\x65\x01"
    b"\x00\x33\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74"
    b"\x3b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x72\x65\x66\x2f\x52\x65\x66\x65"
    b"\x72\x65\x6e\x63\x65\x51\x75\x65\x75\x65\x3b\x29\x56\x00\x21\x00\x05\x00\x06\x00"
    b"\x00\x00\x01\x00\x42\x00\x07\x00\x08\x00\x00\x00\x04\x00\x00\x00\x09\x00\x0a\x00"
    b"\x02\x00\x0b\x00\x00\x00\x1e\x00\x03\x00\x05\x00\x00\x00\x12\x2a\x2b\x19\x04\xb7"
    b"\x00\x01\x2a\x20\xb7\x00\x02\x2a\x20\xb5\x00\x03\xb1\x00\x00\x00\x00\x00\x0c\x00"
    b"\x00\x00\x02\x00\x0d\x00\x24\x00\x0e\x00\x0f\x00\x01\x00\x0b\x00\x00\x00\x2f\x00"
    b"\x04\x00\x03\x00\x00\x00\x1a\x2a\xb4\x00\x03\x09\x94\x9a\x00\x04\xb1\x2a\xb4\x00"
    b"\x03\x40\x2a\x09\xb5\x00\x03\x2a\x1f\xb7\x00\x04\xb1\x00\x00\x00\x01\x00\x10\x00"
    b"\x00\x00\x03\x00\x01\x0a\x01\x02\x00\x11\x00\x12\x00\x00\x01\x02\x00\x13\x00\x12"
    b"\x00\x00\x00\x01\x00\x0c\x00\x00\x00\x02\x00\x14"
)
