"""Broadworks OCI-P Interface Type Classes"""

# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2024-03-25T14:43:17.025184
from typing import List
from typing import Tuple

from .base import ElementInfo as E
from .base import OCIType


class AccessDevice(OCIType):
    """
    Uniquely identifies an Identity/device profile created anywhere in the system.


    Attributes:
        device_level (str): deviceLevel
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "device_level",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_level",
                "deviceLevel",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class AccessDeviceKey(OCIType):
    """
    Key to uniquely identify a system, service provider, or group device.


    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class AccessDeviceReorderEndpointIdentity(OCIType):
    """
    Access device end point identity in the context of a reorder command.

    The following elements are only used in XS data mode and ignored in AS data mode:
    privateIdentity

    Attributes:
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
    """

    __slots__: List[str] = [
        "line_port",
        "private_identity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
        )


class AccessDeviceTypeRename(OCIType):
    """
    Pair of DeviceManagementTagSetName

    Attributes:
        original_device_type_name (str): originalDeviceTypeName
        new_device_type_name (str): newDeviceTypeName
    """

    __slots__: List[str] = [
        "original_device_type_name",
        "new_device_type_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "original_device_type_name",
                "originalDeviceTypeName",
                str,
                is_required=True,
            ),
            E(
                "new_device_type_name",
                "newDeviceTypeName",
                str,
                is_required=True,
            ),
        )


class AccountAuthorizationCodeEntry(OCIType):
    """
    Account/Authorization Code.


    Attributes:
        code (str): code
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "code",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class ActivatableDN(OCIType):
    """
    Activatable directory Number in E164 Format.


    Attributes:
        dn (str): DN
        activate (bool): activate *Optional*
    """

    __slots__: List[str] = [
        "dn",
        "activate",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn",
                "DN",
                str,
                is_required=True,
            ),
            E(
                "activate",
                "activate",
                bool,
            ),
        )


class ActivatableDNRange(OCIType):
    """
    Activatable directory number range.

    The minimum and maximum values are inclusive.

    Attributes:
        min_phone_number (str): minPhoneNumber
        max_phone_number (str): maxPhoneNumber
        activate (bool): activate *Optional*
    """

    __slots__: List[str] = [
        "min_phone_number",
        "max_phone_number",
        "activate",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "min_phone_number",
                "minPhoneNumber",
                str,
                is_required=True,
            ),
            E(
                "max_phone_number",
                "maxPhoneNumber",
                str,
                is_required=True,
            ),
            E(
                "activate",
                "activate",
                bool,
            ),
        )


class AdditionalMessageOptionsMenuKeysModifyEntry(OCIType):
    """
    The voice portal additional message options modify entry.


    Attributes:
        save_message (str): saveMessage *Optional*
        delete_message (str): deleteMessage *Optional*
        play_envelope (str): playEnvelope *Optional*
        callback_caller (str): callbackCaller *Optional*
        compose_message (str): composeMessage *Optional*
        reply_message (str): replyMessage *Optional*
        forward_message (str): forwardMessage *Optional*
        personalized_name (str): personalizedName *Optional*
        passcode (str): passcode *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "save_message",
        "delete_message",
        "play_envelope",
        "callback_caller",
        "compose_message",
        "reply_message",
        "forward_message",
        "personalized_name",
        "passcode",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "save_message",
                "saveMessage",
                str,
            ),
            E(
                "delete_message",
                "deleteMessage",
                str,
            ),
            E(
                "play_envelope",
                "playEnvelope",
                str,
            ),
            E(
                "callback_caller",
                "callbackCaller",
                str,
            ),
            E(
                "compose_message",
                "composeMessage",
                str,
            ),
            E(
                "reply_message",
                "replyMessage",
                str,
            ),
            E(
                "forward_message",
                "forwardMessage",
                str,
            ),
            E(
                "personalized_name",
                "personalizedName",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class AdditionalMessageOptionsMenuKeysReadEntry(OCIType):
    """
    The voice portal additional message options menu keys.


    Attributes:
        save_message (str): saveMessage *Optional*
        delete_message (str): deleteMessage *Optional*
        play_envelope (str): playEnvelope *Optional*
        callback_caller (str): callbackCaller *Optional*
        compose_message (str): composeMessage *Optional*
        reply_message (str): replyMessage *Optional*
        forward_message (str): forwardMessage *Optional*
        personalized_name (str): personalizedName *Optional*
        passcode (str): passcode *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "save_message",
        "delete_message",
        "play_envelope",
        "callback_caller",
        "compose_message",
        "reply_message",
        "forward_message",
        "personalized_name",
        "passcode",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "save_message",
                "saveMessage",
                str,
            ),
            E(
                "delete_message",
                "deleteMessage",
                str,
            ),
            E(
                "play_envelope",
                "playEnvelope",
                str,
            ),
            E(
                "callback_caller",
                "callbackCaller",
                str,
            ),
            E(
                "compose_message",
                "composeMessage",
                str,
            ),
            E(
                "reply_message",
                "replyMessage",
                str,
            ),
            E(
                "forward_message",
                "forwardMessage",
                str,
            ),
            E(
                "personalized_name",
                "personalizedName",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class AgentStatistics(OCIType):
    """
    Contains Call Center Agent statistics for a given time frame.


    Attributes:
        number_of_calls_handled (int): numberOfCallsHandled
        number_of_calls_unanswered (int): numberOfCallsUnanswered
        average_call_seconds (int): averageCallSeconds
        total_talk_seconds (int): totalTalkSeconds
        total_staffed_seconds (int): totalStaffedSeconds
    """

    __slots__: List[str] = [
        "number_of_calls_handled",
        "number_of_calls_unanswered",
        "average_call_seconds",
        "total_talk_seconds",
        "total_staffed_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number_of_calls_handled",
                "numberOfCallsHandled",
                int,
                is_required=True,
            ),
            E(
                "number_of_calls_unanswered",
                "numberOfCallsUnanswered",
                int,
                is_required=True,
            ),
            E(
                "average_call_seconds",
                "averageCallSeconds",
                int,
                is_required=True,
            ),
            E(
                "total_talk_seconds",
                "totalTalkSeconds",
                int,
                is_required=True,
            ),
            E(
                "total_staffed_seconds",
                "totalStaffedSeconds",
                int,
                is_required=True,
            ),
        )


class AlternateNumberEntry(OCIType):
    """
    Alternate Number Entry.


    Attributes:
        phone_number (str): phoneNumber *Optional*
        extension (str): extension *Optional*
        ring_pattern (str): ringPattern *Optional*
    """

    __slots__: List[str] = [
        "phone_number",
        "extension",
        "ring_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "extension",
                "extension",
                str,
            ),
            E(
                "ring_pattern",
                "ringPattern",
                str,
            ),
        )


class AlternateNumberEntry17(OCIType):
    """
    Alternate Number Entry.


    Attributes:
        phone_number (str): phoneNumber *Optional*
        extension (str): extension *Optional*
        ring_pattern (str): ringPattern *Optional*
    """

    __slots__: List[str] = [
        "phone_number",
        "extension",
        "ring_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "extension",
                "extension",
                str,
            ),
            E(
                "ring_pattern",
                "ringPattern",
                str,
            ),
        )


class AlternateNumberEntry21(OCIType):
    """
    Alternate Number Entry.


    Attributes:
        phone_number (str): phoneNumber *Optional*
        extension (str): extension *Optional*
        ring_pattern (str): ringPattern *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "phone_number",
        "extension",
        "ring_pattern",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "extension",
                "extension",
                str,
            ),
            E(
                "ring_pattern",
                "ringPattern",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class AlternateUserIdEntry(OCIType):
    """
    Alternate user id.


    Attributes:
        alternate_user_id (str): alternateUserId
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "alternate_user_id",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "alternate_user_id",
                "alternateUserId",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class AnnouncementFileKey(OCIType):
    """
    Uniquely identifies a file within a group or user repository.


    Attributes:
        name (str): name
        media_file_type (str): mediaFileType
    """

    __slots__: List[str] = [
        "name",
        "media_file_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "media_file_type",
                "mediaFileType",
                str,
                is_required=True,
            ),
        )


class AnnouncementFileLevelKey(OCIType):
    """
    Uniquely identifies a file within a group or user repository.

    Includes level to distinguish between group and user announcements in scenarios where
    both are listed.

    Attributes:
        name (str): name
        media_file_type (str): mediaFileType
        level (str): level
    """

    __slots__: List[str] = [
        "name",
        "media_file_type",
        "level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "media_file_type",
                "mediaFileType",
                str,
                is_required=True,
            ),
            E(
                "level",
                "level",
                str,
                is_required=True,
            ),
        )


class AnnouncementMenuKeysModifyEntry(OCIType):
    """
    The voice portal announcement menu keys modify entry.


    Attributes:
        record_audio (str): recordAudio *Optional*
        record_audio_video (str): recordAudioVideo *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "record_audio",
        "record_audio_video",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "record_audio",
                "recordAudio",
                str,
            ),
            E(
                "record_audio_video",
                "recordAudioVideo",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class AnnouncementMenuKeysReadEntry(OCIType):
    """
    The voice portal announcement menu keys.


    Attributes:
        record_audio (str): recordAudio *Optional*
        record_audio_video (str): recordAudioVideo *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "record_audio",
        "record_audio_video",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "record_audio",
                "recordAudio",
                str,
            ),
            E(
                "record_audio_video",
                "recordAudioVideo",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class AnnouncementRecordingMenuKeysModifyEntry(OCIType):
    """
    The voice portal announcement recording menu keys modify entry.


    Attributes:
        accept_recording (str): acceptRecording *Optional*
        reject_rerecord (str): rejectRerecord *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
        end (str): end *Optional*
    """

    __slots__: List[str] = [
        "accept_recording",
        "reject_rerecord",
        "return_to_previous_menu",
        "repeat_menu",
        "end",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "accept_recording",
                "acceptRecording",
                str,
            ),
            E(
                "reject_rerecord",
                "rejectRerecord",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
            E(
                "end",
                "end",
                str,
            ),
        )


class AnnouncementRecordingMenuKeysReadEntry(OCIType):
    """
    The voice portal announcement recording menu keys.


    Attributes:
        accept_recording (str): acceptRecording
        reject_rerecord (str): rejectRerecord
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
        end (str): end
    """

    __slots__: List[str] = [
        "accept_recording",
        "reject_rerecord",
        "return_to_previous_menu",
        "repeat_menu",
        "end",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "accept_recording",
                "acceptRecording",
                str,
                is_required=True,
            ),
            E(
                "reject_rerecord",
                "rejectRerecord",
                str,
                is_required=True,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
            E(
                "end",
                "end",
                str,
                is_required=True,
            ),
        )


class AssignedGroupServicesEntry(OCIType):
    """
    Assigned Group Services List Entry.

    The isActive element is true, false, or could be missing completely.

    Attributes:
        service_name (str): serviceName
        is_active (bool): isActive *Optional*
    """

    __slots__: List[str] = [
        "service_name",
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_name",
                "serviceName",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
        )


class AssignedUserServicesEntry(OCIType):
    """
    Assigned User Services List Entry.

    The isActive element is true, false, or could be missing completely.

    Attributes:
        service_name (str): serviceName
        is_active (bool): isActive *Optional*
    """

    __slots__: List[str] = [
        "service_name",
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_name",
                "serviceName",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
        )


class AutoAttendantKeyConfigurationReadEntry(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.

    The following elements are only used in AS data mode and not returned in XS data mode:
    audioFileDescription audioMediaType videoFileDescription videoMediaType

    Attributes:
        description (str): description *Optional*
        action (str): action
        phone_number (str): phoneNumber *Optional*
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
    """

    __slots__: List[str] = [
        "description",
        "action",
        "phone_number",
        "audio_file_description",
        "audio_media_type",
        "video_file_description",
        "video_media_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
        )


class AutoAttendantKeyConfigurationReadEntry19(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.

    The following data elements are only valid for Standard Auto Attendants: submenuId

    Attributes:
        description (str): description *Optional*
        action (str): action
        phone_number (str): phoneNumber *Optional*
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
        submenu_id (str): submenuId *Optional*
    """

    __slots__: List[str] = [
        "description",
        "action",
        "phone_number",
        "audio_file_description",
        "audio_media_type",
        "video_file_description",
        "video_media_type",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
            ),
        )


class AutomaticCollectCallPrefixDigitsEntry(OCIType):
    """
    The Automatic Collect Call prefix digits entry.


    Attributes:
        country_code (str): countryCode
        prefix_digits (str): prefixDigits
    """

    __slots__: List[str] = [
        "country_code",
        "prefix_digits",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "prefix_digits",
                "prefixDigits",
                str,
                is_required=True,
            ),
        )


class BCCTMaxConnections(OCIType):
    """
    Maximum number of BCCT Server Connections.

    Can either be unlimited or a bounded int quantity.

    Attributes:
        unlimited (bool): unlimited *Optional*
        quantity (int): quantity *Optional*
    """

    __slots__: List[str] = [
        "unlimited",
        "quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "unlimited",
                "unlimited",
                bool,
            ),
            E(
                "quantity",
                "quantity",
                int,
            ),
        )


class BasicCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.

    Replaced By: CallLogsEntry

    Attributes:
        country_code (str): countryCode *Optional*
        phone_number (str): phoneNumber
        name (str): name
        time (str): time
    """

    __slots__: List[str] = [
        "country_code",
        "phone_number",
        "name",
        "time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "country_code",
                "countryCode",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
        )


class BroadWorksMobilityAlertingMobileNumberReplacementList(OCIType):
    """
    A list of Mobile Numbers to be alerted.

    By convention, an element of this type may be set nil to clear the list.

    Attributes:
        mobile_number (List[str]): mobileNumber
    """

    __slots__: List[str] = [
        "mobile_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "mobile_number",
                "mobileNumber",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class BroadWorksMobilityUserMobileIdentityEntry(OCIType):
    """
    User's Mobile Identity Read Entry

    Attributes:
        mobile_number (str): mobileNumber
        description (str): description *Optional*
        is_primary (bool): isPrimary
        enable_alerting (bool): enableAlerting
    """

    __slots__: List[str] = [
        "mobile_number",
        "description",
        "is_primary",
        "enable_alerting",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "mobile_number",
                "mobileNumber",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "is_primary",
                "isPrimary",
                bool,
                is_required=True,
            ),
            E(
                "enable_alerting",
                "enableAlerting",
                bool,
                is_required=True,
            ),
        )


class BroadWorksMobilityUserMobileIdentityModifyEntry(OCIType):
    """
    User's Mobile Identity Modify Entry

    Attributes:
        mobile_number (str): mobileNumber
        description (str): description *Optional*
        is_primary (bool): isPrimary *Optional*
        enable_alerting (bool): enableAlerting *Optional*
    """

    __slots__: List[str] = [
        "mobile_number",
        "description",
        "is_primary",
        "enable_alerting",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "mobile_number",
                "mobileNumber",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "is_primary",
                "isPrimary",
                bool,
            ),
            E(
                "enable_alerting",
                "enableAlerting",
                bool,
            ),
        )


class CPEDeviceOptions(OCIType):
    """
    CPE device's options.

    Replaced by: CPEDeviceOptions14sp6

    Attributes:
        enable_monitoring (bool): enableMonitoring
        reset_event (str): resetEvent *Optional*
        config_type (str): configType
        system_file_name (str): systemFileName
        device_file_format (str): deviceFileFormat
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "reset_event",
        "config_type",
        "system_file_name",
        "device_file_format",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "reset_event",
                "resetEvent",
                str,
            ),
            E(
                "config_type",
                "configType",
                str,
                is_required=True,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
                is_required=True,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
                is_required=True,
            ),
        )


class CallCenterAgentAvailability(OCIType):
    """
    Specifies an agent's login state (availability) for a particular Call Center.


    Attributes:
        service_user_id (str): serviceUserId
        available (bool): available
    """

    __slots__: List[str] = [
        "service_user_id",
        "available",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "available",
                "available",
                bool,
                is_required=True,
            ),
        )


class CallCenterAgentDailyStatistics13mp8(OCIType):
    """
    Contains Call Center Agent statistics for one day.


    Attributes:
        number_of_calls_received (int): numberOfCallsReceived
        number_of_calls_not_answered (int): numberOfCallsNotAnswered
        average_time_per_call_seconds (int): averageTimePerCallSeconds
        time_in_calls_seconds (int): timeInCallsSeconds
        time_logged_off_seconds (int): timeLoggedOffSeconds
        time_logged_on_and_idle_seconds (int): timeLoggedOnAndIdleSeconds
    """

    __slots__: List[str] = [
        "number_of_calls_received",
        "number_of_calls_not_answered",
        "average_time_per_call_seconds",
        "time_in_calls_seconds",
        "time_logged_off_seconds",
        "time_logged_on_and_idle_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number_of_calls_received",
                "numberOfCallsReceived",
                int,
                is_required=True,
            ),
            E(
                "number_of_calls_not_answered",
                "numberOfCallsNotAnswered",
                int,
                is_required=True,
            ),
            E(
                "average_time_per_call_seconds",
                "averageTimePerCallSeconds",
                int,
                is_required=True,
            ),
            E(
                "time_in_calls_seconds",
                "timeInCallsSeconds",
                int,
                is_required=True,
            ),
            E(
                "time_logged_off_seconds",
                "timeLoggedOffSeconds",
                int,
                is_required=True,
            ),
            E(
                "time_logged_on_and_idle_seconds",
                "timeLoggedOnAndIdleSeconds",
                int,
                is_required=True,
            ),
        )


class CallCenterAgentSettings(OCIType):
    """
    Specifies an agent's settings for a particular Call Center.

    The skillLevel only applies to Premium agents.

    Attributes:
        service_user_id (str): serviceUserId
        available (bool): available *Optional*
        skill_level (int): skillLevel *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "available",
        "skill_level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "available",
                "available",
                bool,
            ),
            E(
                "skill_level",
                "skillLevel",
                int,
            ),
        )


class CallCenterAgentThresholdProfileReplacementNotificationEmailList(OCIType):
    """
    List of email addresses to which the Agent Threshold Profile email is sent.

    The list replaces a previously configured list.

    Attributes:
        email_address (List[str]): emailAddress
    """

    __slots__: List[str] = [
        "email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "email_address",
                "emailAddress",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class CallCenterAgentUnavailableCodeStateModify(OCIType):
    """
    Contains a Call Center Agent Unavailable Code and its active state

    Attributes:
        code (str): code
        is_active (bool): isActive
    """

    __slots__: List[str] = [
        "code",
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
        )


class CallCenterAnnouncementDescriptionList(OCIType):
    """
    Contains list of file descriptions for audio or video files

    Attributes:
        file_description1 (str): fileDescription1 *Optional*
        file_description2 (str): fileDescription2 *Optional*
        file_description3 (str): fileDescription3 *Optional*
        file_description4 (str): fileDescription4 *Optional*
    """

    __slots__: List[str] = [
        "file_description1",
        "file_description2",
        "file_description3",
        "file_description4",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_description1",
                "fileDescription1",
                str,
            ),
            E(
                "file_description2",
                "fileDescription2",
                str,
            ),
            E(
                "file_description3",
                "fileDescription3",
                str,
            ),
            E(
                "file_description4",
                "fileDescription4",
                str,
            ),
        )


class CallCenterAnnouncementMediaFileTypeList(OCIType):
    """
    Contains list of file media types for audio or video files

    Attributes:
        media_type1 (str): mediaType1 *Optional*
        media_type2 (str): mediaType2 *Optional*
        media_type3 (str): mediaType3 *Optional*
        media_type4 (str): mediaType4 *Optional*
    """

    __slots__: List[str] = [
        "media_type1",
        "media_type2",
        "media_type3",
        "media_type4",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "media_type1",
                "mediaType1",
                str,
            ),
            E(
                "media_type2",
                "mediaType2",
                str,
            ),
            E(
                "media_type3",
                "mediaType3",
                str,
            ),
            E(
                "media_type4",
                "mediaType4",
                str,
            ),
        )


class CallCenterAnnouncementURLList(OCIType):
    """
    Contains list of urls

    Attributes:
        url1 (str): url1 *Optional*
        url2 (str): url2 *Optional*
        url3 (str): url3 *Optional*
        url4 (str): url4 *Optional*
    """

    __slots__: List[str] = [
        "url1",
        "url2",
        "url3",
        "url4",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "url1",
                "url1",
                str,
            ),
            E(
                "url2",
                "url2",
                str,
            ),
            E(
                "url3",
                "url3",
                str,
            ),
            E(
                "url4",
                "url4",
                str,
            ),
        )


class CallCenterAnnouncementURLListModify(OCIType):
    """
    Contains a list of URLs for modify.


    Attributes:
        url1 (str): url1 *Optional*
        url2 (str): url2 *Optional*
        url3 (str): url3 *Optional*
        url4 (str): url4 *Optional*
    """

    __slots__: List[str] = [
        "url1",
        "url2",
        "url3",
        "url4",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "url1",
                "url1",
                str,
            ),
            E(
                "url2",
                "url2",
                str,
            ),
            E(
                "url3",
                "url3",
                str,
            ),
            E(
                "url4",
                "url4",
                str,
            ),
        )


class CallCenterMusicOnHoldSourceModify(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec *Optional*
        message_source_selection (str): messageSourceSelection *Optional*
        custom_source (customSource): customSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class CallCenterMusicOnHoldSourceRead(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class CallCenterQueueStatistics13mp8(OCIType):
    """
    Contains Call Center Queue statistics.


    Attributes:
        number_of_incoming_calls (int): numberOfIncomingCalls
        number_of_calls_queued (int): numberOfCallsQueued
        number_of_busy_overflows (int): numberOfBusyOverflows
        number_of_calls_answered (int): numberOfCallsAnswered
        average_time_with_agent_seconds (int): averageTimeWithAgentSeconds
        average_time_in_queue_seconds (int): averageTimeInQueueSeconds
        average_number_of_agents_busy (int): averageNumberOfAgentsBusy
        average_number_of_agents_logged_off (int): averageNumberOfAgentsLoggedOff
        average_hold_time_before_call_loss_seconds (int):
            averageHoldTimeBeforeCallLossSeconds
    """

    __slots__: List[str] = [
        "number_of_incoming_calls",
        "number_of_calls_queued",
        "number_of_busy_overflows",
        "number_of_calls_answered",
        "average_time_with_agent_seconds",
        "average_time_in_queue_seconds",
        "average_number_of_agents_busy",
        "average_number_of_agents_logged_off",
        "average_hold_time_before_call_loss_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number_of_incoming_calls",
                "numberOfIncomingCalls",
                int,
                is_required=True,
            ),
            E(
                "number_of_calls_queued",
                "numberOfCallsQueued",
                int,
                is_required=True,
            ),
            E(
                "number_of_busy_overflows",
                "numberOfBusyOverflows",
                int,
                is_required=True,
            ),
            E(
                "number_of_calls_answered",
                "numberOfCallsAnswered",
                int,
                is_required=True,
            ),
            E(
                "average_time_with_agent_seconds",
                "averageTimeWithAgentSeconds",
                int,
                is_required=True,
            ),
            E(
                "average_time_in_queue_seconds",
                "averageTimeInQueueSeconds",
                int,
                is_required=True,
            ),
            E(
                "average_number_of_agents_busy",
                "averageNumberOfAgentsBusy",
                int,
                is_required=True,
            ),
            E(
                "average_number_of_agents_logged_off",
                "averageNumberOfAgentsLoggedOff",
                int,
                is_required=True,
            ),
            E(
                "average_hold_time_before_call_loss_seconds",
                "averageHoldTimeBeforeCallLossSeconds",
                int,
                is_required=True,
            ),
        )


class CallCenterQueueStatistics14sp9(OCIType):
    """
    Contains Call Center Queue statistics.


    Attributes:
        number_of_busy_overflows (int): numberOfBusyOverflows
        number_of_calls_answered (int): numberOfCallsAnswered
        number_of_calls_abandoned (int): numberOfCallsAbandoned
        number_of_calls_transferred (int): numberOfCallsTransferred
        number_of_calls_timedout (int): numberOfCallsTimedout
        average_number_of_agents_talking (int): averageNumberOfAgentsTalking
        average_number_of_agents_staffed (int): averageNumberOfAgentsStaffed
        average_wait_seconds (int): averageWaitSeconds
        average_abandonment_seconds (int): averageAbandonmentSeconds
    """

    __slots__: List[str] = [
        "number_of_busy_overflows",
        "number_of_calls_answered",
        "number_of_calls_abandoned",
        "number_of_calls_transferred",
        "number_of_calls_timedout",
        "average_number_of_agents_talking",
        "average_number_of_agents_staffed",
        "average_wait_seconds",
        "average_abandonment_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number_of_busy_overflows",
                "numberOfBusyOverflows",
                int,
                is_required=True,
            ),
            E(
                "number_of_calls_answered",
                "numberOfCallsAnswered",
                int,
                is_required=True,
            ),
            E(
                "number_of_calls_abandoned",
                "numberOfCallsAbandoned",
                int,
                is_required=True,
            ),
            E(
                "number_of_calls_transferred",
                "numberOfCallsTransferred",
                int,
                is_required=True,
            ),
            E(
                "number_of_calls_timedout",
                "numberOfCallsTimedout",
                int,
                is_required=True,
            ),
            E(
                "average_number_of_agents_talking",
                "averageNumberOfAgentsTalking",
                int,
                is_required=True,
            ),
            E(
                "average_number_of_agents_staffed",
                "averageNumberOfAgentsStaffed",
                int,
                is_required=True,
            ),
            E(
                "average_wait_seconds",
                "averageWaitSeconds",
                int,
                is_required=True,
            ),
            E(
                "average_abandonment_seconds",
                "averageAbandonmentSeconds",
                int,
                is_required=True,
            ),
        )


class CallCenterQueueThresholdReplacementNotificationEmailList(OCIType):
    """
    List of email addresses to which the Call Center Queue Threshold email is sent.

    The list replaces a previously configured list.

    Attributes:
        email_address (List[str]): emailAddress
    """

    __slots__: List[str] = [
        "email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "email_address",
                "emailAddress",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class CallCenterReportAbandonedCallThresholdReplacementList(OCIType):
    """
    A list of call center reporting abandoned call threshold seconds that replaces a
    previously configured list.


    Attributes:
        abandoned_call_threshold_seconds (List[int]): abandonedCallThresholdSeconds
    """

    __slots__: List[str] = [
        "abandoned_call_threshold_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "abandoned_call_threshold_seconds",
                "abandonedCallThresholdSeconds",
                int,
                is_required=True,
                is_array=True,
            ),
        )


class CallCenterReportCurrentInterval(OCIType):
    """
    The call center enhanced reporting report current interval, for example, current week.


    Attributes:
        time_unit (str): timeUnit
    """

    __slots__: List[str] = [
        "time_unit",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "time_unit",
                "timeUnit",
                str,
                is_required=True,
            ),
        )


class CallCenterReportDataTemplateInfo(OCIType):
    """
    Call center reporting data template info.


    Attributes:
        data_template (str): dataTemplate
        report_type (str): reportType
        is_realtime_report (bool): isRealtimeReport
        is_agent_param_required (str): isAgentParamRequired
        is_call_center_param_required (str): isCallCenterParamRequired
        is_call_center_dnis_param_required (str): isCallCenterDnisParamRequired
        is_sampling_period_param_required (str): isSamplingPeriodParamRequired
        is_call_completion_threshold_param_required (str):
            isCallCompletionThresholdParamRequired
        is_short_duration_threshold_param_required (str):
            isShortDurationThresholdParamRequired
        is_service_level_threshold_param_required (str):
            isServiceLevelThresholdParamRequired
        is_service_level_inclusions_param_required (str):
            isServiceLevelInclusionsParamRequired
        is_service_level_objective_threshold_param_required (str):
            isServiceLevelObjectiveThresholdParamRequired
        is_abandoned_call_threshold_param_required (str):
            isAbandonedCallThresholdParamRequired
    """

    __slots__: List[str] = [
        "data_template",
        "report_type",
        "is_realtime_report",
        "is_agent_param_required",
        "is_call_center_param_required",
        "is_call_center_dnis_param_required",
        "is_sampling_period_param_required",
        "is_call_completion_threshold_param_required",
        "is_short_duration_threshold_param_required",
        "is_service_level_threshold_param_required",
        "is_service_level_inclusions_param_required",
        "is_service_level_objective_threshold_param_required",
        "is_abandoned_call_threshold_param_required",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "data_template",
                "dataTemplate",
                str,
                is_required=True,
            ),
            E(
                "report_type",
                "reportType",
                str,
                is_required=True,
            ),
            E(
                "is_realtime_report",
                "isRealtimeReport",
                bool,
                is_required=True,
            ),
            E(
                "is_agent_param_required",
                "isAgentParamRequired",
                str,
                is_required=True,
            ),
            E(
                "is_call_center_param_required",
                "isCallCenterParamRequired",
                str,
                is_required=True,
            ),
            E(
                "is_call_center_dnis_param_required",
                "isCallCenterDnisParamRequired",
                str,
                is_required=True,
            ),
            E(
                "is_sampling_period_param_required",
                "isSamplingPeriodParamRequired",
                str,
                is_required=True,
            ),
            E(
                "is_call_completion_threshold_param_required",
                "isCallCompletionThresholdParamRequired",
                str,
                is_required=True,
            ),
            E(
                "is_short_duration_threshold_param_required",
                "isShortDurationThresholdParamRequired",
                str,
                is_required=True,
            ),
            E(
                "is_service_level_threshold_param_required",
                "isServiceLevelThresholdParamRequired",
                str,
                is_required=True,
            ),
            E(
                "is_service_level_inclusions_param_required",
                "isServiceLevelInclusionsParamRequired",
                str,
                is_required=True,
            ),
            E(
                "is_service_level_objective_threshold_param_required",
                "isServiceLevelObjectiveThresholdParamRequired",
                str,
                is_required=True,
            ),
            E(
                "is_abandoned_call_threshold_param_required",
                "isAbandonedCallThresholdParamRequired",
                str,
                is_required=True,
            ),
        )


class CallCenterReportDataTemplateQueryFilterValueReplacementList(OCIType):
    """
    A list of call center reporting data template query filter values that replaces a
    previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        filter_value (List[str]): filterValue
    """

    __slots__: List[str] = [
        "filter_value",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "filter_value",
                "filterValue",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class CallCenterReportPastInterval(OCIType):
    """
    The call center enhanced reporting report past interval, for example, last 24 month.


    Attributes:
        number (int): number
        time_unit (str): timeUnit
    """

    __slots__: List[str] = [
        "number",
        "time_unit",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number",
                "number",
                int,
                is_required=True,
            ),
            E(
                "time_unit",
                "timeUnit",
                str,
                is_required=True,
            ),
        )


class CallCenterReportReplacementEmailList(OCIType):
    """
    A list of call center reporting email addresses that replaces a previously configured
    list.


    Attributes:
        email_address (List[str]): emailAddress
    """

    __slots__: List[str] = [
        "email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "email_address",
                "emailAddress",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class CallCenterReportServiceLevelThresholdReplacementList(OCIType):
    """
    A list of call center reporting service level threshold seconds that replaces a
    previously configured list.


    Attributes:
        service_level_threshold_seconds (List[int]): serviceLevelThresholdSeconds
    """

    __slots__: List[str] = [
        "service_level_threshold_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_level_threshold_seconds",
                "serviceLevelThresholdSeconds",
                int,
                is_required=True,
                is_array=True,
            ),
        )


class CallCenterReportTemplateKey(OCIType):
    """
    Uniquely identifies a call center report template created in the system.


    Attributes:
        template_level (str): templateLevel
        template_name (str): templateName
    """

    __slots__: List[str] = [
        "template_level",
        "template_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "template_level",
                "templateLevel",
                str,
                is_required=True,
            ),
            E(
                "template_name",
                "templateName",
                str,
                is_required=True,
            ),
        )


class CallCenterRoutingPriorityOrder(OCIType):
    """
    Call center routing order

    Attributes:
        service_user_id (str): serviceUserId
        priority (str): priority
    """

    __slots__: List[str] = [
        "service_user_id",
        "priority",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "priority",
                "priority",
                str,
                is_required=True,
            ),
        )


class CallCenterScheduledReportAgentSelection(OCIType):
    """
    Either all agents or list of agents.


    Attributes:
        all_agent (bool): allAgent *Optional*
        agent_user_id (List[str]): agentUserId *Optional*
    """

    __slots__: List[str] = [
        "all_agent",
        "agent_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "all_agent",
                "allAgent",
                bool,
            ),
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_array=True,
            ),
        )


class CallCenterScheduledReportAgentSelectionAdminRead(OCIType):
    """
    Either all agents or 2 list of agents: one for current and one for past (deleted)
    agents.

    This is used when an admin reads a Scheduled Report.  Each agent table has the
    following column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name"
    and "Hiragana First Name".

    Attributes:
        all_agent (bool): allAgent *Optional*
        current_agent_table (List(currentAgentTable)): currentAgentTable - *Table* array
            of currentAgentTable named tuples *Optional*
        past_agent_table (List(pastAgentTable)): pastAgentTable - *Table* array of
            pastAgentTable named tuples *Optional*
    """

    __slots__: List[str] = [
        "all_agent",
        "current_agent_table",
        "past_agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "all_agent",
                "allAgent",
                bool,
            ),
            E(
                "current_agent_table",
                "currentAgentTable",
                list,
                is_complex=True,
                is_table=True,
            ),
            E(
                "past_agent_table",
                "pastAgentTable",
                list,
                is_complex=True,
                is_table=True,
            ),
        )


class CallCenterScheduledReportAgentSelectionRead(OCIType):
    """
    Either all agents or list of agents.

    The agent table has the following column headings: "User Id", "Last Name", "First
    Name", "Hiragana Last Name" and "Hiragana First Name".

    Attributes:
        all_agent (bool): allAgent *Optional*
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples *Optional*
    """

    __slots__: List[str] = [
        "all_agent",
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "all_agent",
                "allAgent",
                bool,
            ),
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_table=True,
            ),
        )


class CallCenterScheduledReportCallCenterSelection(OCIType):
    """
    Either all call centers or list of call centers.


    Attributes:
        all_call_center (bool): allCallCenter *Optional*
        service_user_id (List[str]): serviceUserId *Optional*
    """

    __slots__: List[str] = [
        "all_call_center",
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "all_call_center",
                "allCallCenter",
                bool,
            ),
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_array=True,
            ),
        )


class CallCenterScheduledReportCallCenterSelectionRead(OCIType):
    """
    User for admin read.

    Either all call centers or 2 lists of call centers: one for current and one for
    deleted call centers.

    Attributes:
        all_call_center (bool): allCallCenter *Optional*
        current_user_id (List[str]): currentUserId *Optional*
        past_user_id (List[str]): pastUserId *Optional*
    """

    __slots__: List[str] = [
        "all_call_center",
        "current_user_id",
        "past_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "all_call_center",
                "allCallCenter",
                bool,
            ),
            E(
                "current_user_id",
                "currentUserId",
                str,
                is_array=True,
            ),
            E(
                "past_user_id",
                "pastUserId",
                str,
                is_array=True,
            ),
        )


class CallCenterScheduledReportDNISSelection(OCIType):
    """
    Either all DNIS under the specified Call Center or list of DNIS.


    Attributes:
        service_user_id (str): serviceUserId
        all_dnis (bool): allDNIS *Optional*
        name (List[str]): name *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "all_dnis",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "all_dnis",
                "allDNIS",
                bool,
            ),
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
        )


class CallCenterScheduledReportDNISSelectionRead(OCIType):
    """
    Either all DNIS under the specified Call Center or 2 lists of DNIS, one for current
    one for past (deleted).


    Attributes:
        service_user_id (str): serviceUserId
        deleted (bool): deleted *Optional*
        all_dnis (bool): allDNIS *Optional*
        current_name (List[str]): currentName *Optional*
        past_name (List[str]): pastName *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "deleted",
        "all_dnis",
        "current_name",
        "past_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "deleted",
                "deleted",
                bool,
            ),
            E(
                "all_dnis",
                "allDNIS",
                bool,
            ),
            E(
                "current_name",
                "currentName",
                str,
                is_array=True,
            ),
            E(
                "past_name",
                "pastName",
                str,
                is_array=True,
            ),
        )


class CallCenterScheduledReportServiceLevelInclusions(OCIType):
    """
    The call center enhanced reporting scheduled report inclusions related to the Service
    Level thresholds

    Attributes:
        include_overflow_time_transfered_in_service_level (bool):
            includeOverflowTimeTransferedInServiceLevel
        include_other_transfers_in_service_level (bool):
            includeOtherTransfersInServiceLevel
        abandoned_calls_in_service_level (str): abandonedCallsInServiceLevel
        abandoned_call_interval_seconds (int): abandonedCallIntervalSeconds *Optional*
    """

    __slots__: List[str] = [
        "include_overflow_time_transfered_in_service_level",
        "include_other_transfers_in_service_level",
        "abandoned_calls_in_service_level",
        "abandoned_call_interval_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "include_overflow_time_transfered_in_service_level",
                "includeOverflowTimeTransferedInServiceLevel",
                bool,
                is_required=True,
            ),
            E(
                "include_other_transfers_in_service_level",
                "includeOtherTransfersInServiceLevel",
                bool,
                is_required=True,
            ),
            E(
                "abandoned_calls_in_service_level",
                "abandonedCallsInServiceLevel",
                str,
                is_required=True,
            ),
            E(
                "abandoned_call_interval_seconds",
                "abandonedCallIntervalSeconds",
                int,
            ),
        )


class CallCenterScheduledReportServiceLevelInclusionsModify(OCIType):
    """
    The call center enhanced reporting scheduled report modified inclusions related to the
    Service Level thresholds

    Attributes:
        include_overflow_time_transfered_in_service_level (bool):
            includeOverflowTimeTransferedInServiceLevel *Optional*
        include_other_transfers_in_service_level (bool):
            includeOtherTransfersInServiceLevel *Optional*
        abandoned_calls_in_service_level (str): abandonedCallsInServiceLevel *Optional*
        abandoned_call_interval_seconds (int): abandonedCallIntervalSeconds *Optional*
    """

    __slots__: List[str] = [
        "include_overflow_time_transfered_in_service_level",
        "include_other_transfers_in_service_level",
        "abandoned_calls_in_service_level",
        "abandoned_call_interval_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "include_overflow_time_transfered_in_service_level",
                "includeOverflowTimeTransferedInServiceLevel",
                bool,
            ),
            E(
                "include_other_transfers_in_service_level",
                "includeOtherTransfersInServiceLevel",
                bool,
            ),
            E(
                "abandoned_calls_in_service_level",
                "abandonedCallsInServiceLevel",
                str,
            ),
            E(
                "abandoned_call_interval_seconds",
                "abandonedCallIntervalSeconds",
                int,
            ),
        )


class CallCenterSkillAgentList(OCIType):
    """
    A list of agents for a particular skill Level.


    Attributes:
        skill_level (int): skillLevel
        agent (List[str]): agent *Optional*
    """

    __slots__: List[str] = [
        "skill_level",
        "agent",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "skill_level",
                "skillLevel",
                int,
                is_required=True,
            ),
            E(
                "agent",
                "agent",
                str,
                is_array=True,
            ),
        )


class CallCenterStatisticsRange(OCIType):
    """
    Statistics Range

    Attributes:
        start (str): start
        end (str): end *Optional*
    """

    __slots__: List[str] = [
        "start",
        "end",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "start",
                "start",
                str,
                is_required=True,
            ),
            E(
                "end",
                "end",
                str,
            ),
        )


class CallDispositionCodeActivation(OCIType):
    """
    Contains a Call Center Call Disposition Code and its active state

    Attributes:
        code (str): code
        is_active (bool): isActive
    """

    __slots__: List[str] = [
        "code",
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
        )


class CallDispositionCodeWithLevel(OCIType):
    """
    Contains a Call Center Call Disposition Code and its Level

    Attributes:
        code (str): code
        level (str): level
    """

    __slots__: List[str] = [
        "code",
        "level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "level",
                "level",
                str,
                is_required=True,
            ),
        )


class CallForwardingOptionsMenuKeysModifyEntry(OCIType):
    """
    The voice portal call forwarding option menu keys modify entry.


    Attributes:
        activate_call_forwarding (str): activateCallForwarding *Optional*
        deactivate_call_forwarding (str): deactivateCallForwarding *Optional*
        change_call_forwarding_destination (str): changeCallForwardingDestination
            *Optional*
        listen_to_call_forwarding_status (str): listenToCallForwardingStatus *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "activate_call_forwarding",
        "deactivate_call_forwarding",
        "change_call_forwarding_destination",
        "listen_to_call_forwarding_status",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "activate_call_forwarding",
                "activateCallForwarding",
                str,
            ),
            E(
                "deactivate_call_forwarding",
                "deactivateCallForwarding",
                str,
            ),
            E(
                "change_call_forwarding_destination",
                "changeCallForwardingDestination",
                str,
            ),
            E(
                "listen_to_call_forwarding_status",
                "listenToCallForwardingStatus",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class CallForwardingOptionsMenuKeysReadEntry(OCIType):
    """

    Attributes:
        activate_call_forwarding (str): activateCallForwarding *Optional*
        deactivate_call_forwarding (str): deactivateCallForwarding *Optional*
        change_call_forwarding_destination (str): changeCallForwardingDestination
            *Optional*
        listen_to_call_forwarding_status (str): listenToCallForwardingStatus *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "activate_call_forwarding",
        "deactivate_call_forwarding",
        "change_call_forwarding_destination",
        "listen_to_call_forwarding_status",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "activate_call_forwarding",
                "activateCallForwarding",
                str,
            ),
            E(
                "deactivate_call_forwarding",
                "deactivateCallForwarding",
                str,
            ),
            E(
                "change_call_forwarding_destination",
                "changeCallForwardingDestination",
                str,
            ),
            E(
                "listen_to_call_forwarding_status",
                "listenToCallForwardingStatus",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class CallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.


    Attributes:
        country_code (str): countryCode *Optional*
        call_log_id (str): callLogId
        phone_number (str): phoneNumber
        name (str): name
        time (str): time
    """

    __slots__: List[str] = [
        "country_code",
        "call_log_id",
        "phone_number",
        "name",
        "time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "country_code",
                "countryCode",
                str,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
        )


class CallLogsEntry22(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.


    Attributes:
        country_code (str): countryCode *Optional*
        call_log_id (str): callLogId
        phone_number (str): phoneNumber
        name (str): name
        time (str): time
        call_filtering_disposition (str): callFilteringDisposition *Optional*
    """

    __slots__: List[str] = [
        "country_code",
        "call_log_id",
        "phone_number",
        "name",
        "time",
        "call_filtering_disposition",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "country_code",
                "countryCode",
                str,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "call_filtering_disposition",
                "callFilteringDisposition",
                str,
            ),
        )


class CallMeNowToDnCriteria(OCIType):
    """
    The To dn criteria used on the call me now external number.


    Attributes:
        to_dn_criteria_selection (str): toDnCriteriaSelection
        phone_number (List[str]): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "to_dn_criteria_selection",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "to_dn_criteria_selection",
                "toDnCriteriaSelection",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
        )


class CallToNumber(OCIType):
    """
    Call to Number.


    Attributes:
        type (str): type
        number (str): number *Optional*
        extension (str): extension *Optional*
    """

    __slots__: List[str] = [
        "type",
        "number",
        "extension",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
            E(
                "number",
                "number",
                str,
            ),
            E(
                "extension",
                "extension",
                str,
            ),
        )


class CallingNameRetrievalWhiteListReplacementList(OCIType):
    """
    A list of DNs to add to the CNAM call filtering DN white list.

    By convention, an element of this type may be set nil to clear the list.

    Attributes:
        number (List[str]): number
    """

    __slots__: List[str] = [
        "number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number",
                "number",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ChangeBusyOrNoAnswerGreetingMenuKeysModifyEntry(OCIType):
    """
    The voice portal change busy or not answer greeting menu keys modify entry.


    Attributes:
        record_new_greeting (str): recordNewGreeting *Optional*
        listen_to_current_greeting (str): listenToCurrentGreeting *Optional*
        revert_to_system_default_greeting (str): revertToSystemDefaultGreeting *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "record_new_greeting",
        "listen_to_current_greeting",
        "revert_to_system_default_greeting",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "record_new_greeting",
                "recordNewGreeting",
                str,
            ),
            E(
                "listen_to_current_greeting",
                "listenToCurrentGreeting",
                str,
            ),
            E(
                "revert_to_system_default_greeting",
                "revertToSystemDefaultGreeting",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class ChangeBusyOrNoAnswerGreetingMenuKeysReadEntry(OCIType):
    """
    The voice portal change busy or not answer greeting menu keys.


    Attributes:
        record_new_greeting (str): recordNewGreeting *Optional*
        listen_to_current_greeting (str): listenToCurrentGreeting *Optional*
        revert_to_system_default_greeting (str): revertToSystemDefaultGreeting *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "record_new_greeting",
        "listen_to_current_greeting",
        "revert_to_system_default_greeting",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "record_new_greeting",
                "recordNewGreeting",
                str,
            ),
            E(
                "listen_to_current_greeting",
                "listenToCurrentGreeting",
                str,
            ),
            E(
                "revert_to_system_default_greeting",
                "revertToSystemDefaultGreeting",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class ChangeCallForwardingDestinationMenuKeysModifyEntry(OCIType):
    """
    The voice portal change call forwarding destination menu keys modify entry.


    Attributes:
        finish_entering_new_destination_number (str): finishEnteringNewDestinationNumber
            *Optional*
    """

    __slots__: List[str] = [
        "finish_entering_new_destination_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "finish_entering_new_destination_number",
                "finishEnteringNewDestinationNumber",
                str,
            ),
        )


class ChangeCallForwardingDestinationMenuKeysReadEntry(OCIType):
    """
    The voice portal change call forwarding destination menu keys.


    Attributes:
        finish_entering_new_destination_number (str): finishEnteringNewDestinationNumber
    """

    __slots__: List[str] = [
        "finish_entering_new_destination_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "finish_entering_new_destination_number",
                "finishEnteringNewDestinationNumber",
                str,
                is_required=True,
            ),
        )


class ChangeCurrentIntroductionOrMessageOrReplyMenuKeysModifyEntry(OCIType):
    """
    The voice portal change current introduction or message or reply menu keys modify
    entry.


    Attributes:
        end_recording (str): endRecording *Optional*
    """

    __slots__: List[str] = [
        "end_recording",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "end_recording",
                "endRecording",
                str,
            ),
        )


class ChangeCurrentIntroductionOrMessageOrReplyMenuKeysReadEntry(OCIType):
    """
    The voice portal change current introduction or message or reply menu keys.


    Attributes:
        end_recording (str): endRecording
    """

    __slots__: List[str] = [
        "end_recording",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "end_recording",
                "endRecording",
                str,
                is_required=True,
            ),
        )


class ChangeExtendedAwayGreetingMenuKeysModifyEntry(OCIType):
    """
    The voice portal change extended away greeting menu keys modify entry.


    Attributes:
        activate_extended_away_greeting (str): activateExtendedAwayGreeting *Optional*
        deactivate_extended_away_greeting (str): deactivateExtendedAwayGreeting *Optional*
        record_new_greeting (str): recordNewGreeting *Optional*
        listen_to_current_greeting (str): listenToCurrentGreeting *Optional*
        enable_message_deposit (str): enableMessageDeposit *Optional*
        disable_message_deposit (str): disableMessageDeposit *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "activate_extended_away_greeting",
        "deactivate_extended_away_greeting",
        "record_new_greeting",
        "listen_to_current_greeting",
        "enable_message_deposit",
        "disable_message_deposit",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "activate_extended_away_greeting",
                "activateExtendedAwayGreeting",
                str,
            ),
            E(
                "deactivate_extended_away_greeting",
                "deactivateExtendedAwayGreeting",
                str,
            ),
            E(
                "record_new_greeting",
                "recordNewGreeting",
                str,
            ),
            E(
                "listen_to_current_greeting",
                "listenToCurrentGreeting",
                str,
            ),
            E(
                "enable_message_deposit",
                "enableMessageDeposit",
                str,
            ),
            E(
                "disable_message_deposit",
                "disableMessageDeposit",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class ChangeExtendedAwayGreetingMenuKeysReadEntry(OCIType):
    """
    The voice portal change extended away greeting menu keys.


    Attributes:
        activate_extended_away_greeting (str): activateExtendedAwayGreeting *Optional*
        deactivate_extended_away_greeting (str): deactivateExtendedAwayGreeting *Optional*
        record_new_greeting (str): recordNewGreeting *Optional*
        listen_to_current_greeting (str): listenToCurrentGreeting *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "activate_extended_away_greeting",
        "deactivate_extended_away_greeting",
        "record_new_greeting",
        "listen_to_current_greeting",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "activate_extended_away_greeting",
                "activateExtendedAwayGreeting",
                str,
            ),
            E(
                "deactivate_extended_away_greeting",
                "deactivateExtendedAwayGreeting",
                str,
            ),
            E(
                "record_new_greeting",
                "recordNewGreeting",
                str,
            ),
            E(
                "listen_to_current_greeting",
                "listenToCurrentGreeting",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class CollaborateBridgeMaximumParticipants(OCIType):
    """
    Maximum number of Collaborate bridge participants.

    Can either be unlimited or limited to a value between 3 and 999999.

    Attributes:
        unlimited (bool): unlimited *Optional*
        quantity (int): quantity *Optional*
    """

    __slots__: List[str] = [
        "unlimited",
        "quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "unlimited",
                "unlimited",
                bool,
            ),
            E(
                "quantity",
                "quantity",
                int,
            ),
        )


class CollaborateGracePeriodDuration(OCIType):
    """
    Collaborate grace period duration.


    Attributes:
        hours (int): hours
        minutes (int): minutes
    """

    __slots__: List[str] = [
        "hours",
        "minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "hours",
                "hours",
                int,
                is_required=True,
            ),
            E(
                "minutes",
                "minutes",
                int,
                is_required=True,
            ),
        )


class CollaborateRoomSchedule(OCIType):
    """
    Collaborate room schedule.


    Attributes:
        schedule_reservationless (scheduleReservationless): scheduleReservationless
            *Optional*
        schedule_one_time (scheduleOneTime): scheduleOneTime *Optional*
        schedule_recurring (scheduleRecurring): scheduleRecurring *Optional*
    """

    __slots__: List[str] = [
        "schedule_reservationless",
        "schedule_one_time",
        "schedule_recurring",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "schedule_reservationless",
                "scheduleReservationless",
                [
                    E(
                        "start_time",
                        "startTime",
                        str,
                        is_required=True,
                    ),
                    E(
                        "end_time",
                        "endTime",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "schedule_one_time",
                "scheduleOneTime",
                [
                    E(
                        "start_time",
                        "startTime",
                        str,
                        is_required=True,
                    ),
                    E(
                        "duration",
                        "duration",
                        CollaborateRoomScheduleDuration,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "schedule_recurring",
                "scheduleRecurring",
                [
                    E(
                        "start_time",
                        "startTime",
                        str,
                        is_required=True,
                    ),
                    E(
                        "duration",
                        "duration",
                        CollaborateRoomScheduleDuration,
                        is_complex=True,
                        is_required=True,
                    ),
                    E(
                        "recurrence",
                        "recurrence",
                        Recurrence,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class CollaborateRoomScheduleDuration(OCIType):
    """
    Collaborate room schedule duration.


    Attributes:
        hours (int): hours
        minutes (int): minutes
    """

    __slots__: List[str] = [
        "hours",
        "minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "hours",
                "hours",
                int,
                is_required=True,
            ),
            E(
                "minutes",
                "minutes",
                int,
                is_required=True,
            ),
        )


class CommPilotExpressEmailNotify(OCIType):
    """
    CommPilot Express Email Notify configuration used in the context of a get.


    Attributes:
        send_email (bool): sendEmail
        email_address (str): emailAddress *Optional*
    """

    __slots__: List[str] = [
        "send_email",
        "email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_email",
                "sendEmail",
                bool,
                is_required=True,
            ),
            E(
                "email_address",
                "emailAddress",
                str,
            ),
        )


class CommPilotExpressEmailNotifyModify(OCIType):
    """
    CommPilot Express Email Notify configuration used in the context of a modify.


    Attributes:
        send_email (bool): sendEmail *Optional*
        email_address (str): emailAddress *Optional*
    """

    __slots__: List[str] = [
        "send_email",
        "email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_email",
                "sendEmail",
                bool,
            ),
            E(
                "email_address",
                "emailAddress",
                str,
            ),
        )


class CommPilotExpressProfileMenuKeysModifyEntry(OCIType):
    """
    The voice portal commPilot express profile menu keys modify entry.


    Attributes:
        activate_available_in_office_profile (str): activateAvailableInOfficeProfile
            *Optional*
        activate_available_out_of_office_profile (str):
            activateAvailableOutOfOfficeProfile *Optional*
        activate_busy_profile (str): activateBusyProfile *Optional*
        activate_unavailable_profile (str): activateUnavailableProfile *Optional*
        no_profile (str): noProfile *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "activate_available_in_office_profile",
        "activate_available_out_of_office_profile",
        "activate_busy_profile",
        "activate_unavailable_profile",
        "no_profile",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "activate_available_in_office_profile",
                "activateAvailableInOfficeProfile",
                str,
            ),
            E(
                "activate_available_out_of_office_profile",
                "activateAvailableOutOfOfficeProfile",
                str,
            ),
            E(
                "activate_busy_profile",
                "activateBusyProfile",
                str,
            ),
            E(
                "activate_unavailable_profile",
                "activateUnavailableProfile",
                str,
            ),
            E(
                "no_profile",
                "noProfile",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class CommPilotExpressProfileMenuKeysReadEntry(OCIType):
    """
    The voice portal commPilot express profile menu keys.


    Attributes:
        activate_available_in_office_profile (str): activateAvailableInOfficeProfile
            *Optional*
        activate_available_out_of_office_profile (str):
            activateAvailableOutOfOfficeProfile *Optional*
        activate_busy_profile (str): activateBusyProfile *Optional*
        activate_unavailable_profile (str): activateUnavailableProfile *Optional*
        no_profile (str): noProfile *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "activate_available_in_office_profile",
        "activate_available_out_of_office_profile",
        "activate_busy_profile",
        "activate_unavailable_profile",
        "no_profile",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "activate_available_in_office_profile",
                "activateAvailableInOfficeProfile",
                str,
            ),
            E(
                "activate_available_out_of_office_profile",
                "activateAvailableOutOfOfficeProfile",
                str,
            ),
            E(
                "activate_busy_profile",
                "activateBusyProfile",
                str,
            ),
            E(
                "activate_unavailable_profile",
                "activateUnavailableProfile",
                str,
            ),
            E(
                "no_profile",
                "noProfile",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class CommPilotExpressRedirection(OCIType):
    """
    CommPilot Express type to transfer to voice Mail or forward to a number used in the
    context of a get.


    Attributes:
        action (str): action
        forwarding_phone_number (str): forwardingPhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "action",
        "forwarding_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "forwarding_phone_number",
                "forwardingPhoneNumber",
                str,
            ),
        )


class CommPilotExpressRedirectionModify(OCIType):
    """
    CommPilot Express type to transfer to voice Mail or forward to a number used in the
    context of a modify.


    Attributes:
        action (str): action *Optional*
        forwarding_phone_number (str): forwardingPhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "action",
        "forwarding_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "action",
                "action",
                str,
            ),
            E(
                "forwarding_phone_number",
                "forwardingPhoneNumber",
                str,
            ),
        )


class CommPilotExpressRedirectionWithException(OCIType):
    """
    CommPilot Express type to transfer to voice mail or forward to a number with certain
    exceptions used in the context of a get.


    Attributes:
        send_calls_to_voice_mail_except_excluded_numbers (bool):
            sendCallsToVoiceMailExceptExcludedNumbers
        excluded_phone_number01 (str): excludedPhoneNumber01 *Optional*
        excluded_phone_number02 (str): excludedPhoneNumber02 *Optional*
        excluded_phone_number03 (str): excludedPhoneNumber03 *Optional*
        forward_excluded_numbers_to (str): forwardExcludedNumbersTo *Optional*
    """

    __slots__: List[str] = [
        "send_calls_to_voice_mail_except_excluded_numbers",
        "excluded_phone_number01",
        "excluded_phone_number02",
        "excluded_phone_number03",
        "forward_excluded_numbers_to",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_calls_to_voice_mail_except_excluded_numbers",
                "sendCallsToVoiceMailExceptExcludedNumbers",
                bool,
                is_required=True,
            ),
            E(
                "excluded_phone_number01",
                "excludedPhoneNumber01",
                str,
            ),
            E(
                "excluded_phone_number02",
                "excludedPhoneNumber02",
                str,
            ),
            E(
                "excluded_phone_number03",
                "excludedPhoneNumber03",
                str,
            ),
            E(
                "forward_excluded_numbers_to",
                "forwardExcludedNumbersTo",
                str,
            ),
        )


class CommPilotExpressRedirectionWithExceptionModify(OCIType):
    """
    CommPilot Express type to transfer to voice mail or forward to a number with certain
    exceptions used in the context of a modify.


    Attributes:
        send_calls_to_voice_mail_except_excluded_numbers (bool):
            sendCallsToVoiceMailExceptExcludedNumbers *Optional*
        excluded_phone_number01 (str): excludedPhoneNumber01 *Optional*
        excluded_phone_number02 (str): excludedPhoneNumber02 *Optional*
        excluded_phone_number03 (str): excludedPhoneNumber03 *Optional*
        forward_excluded_numbers_to (str): forwardExcludedNumbersTo *Optional*
    """

    __slots__: List[str] = [
        "send_calls_to_voice_mail_except_excluded_numbers",
        "excluded_phone_number01",
        "excluded_phone_number02",
        "excluded_phone_number03",
        "forward_excluded_numbers_to",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_calls_to_voice_mail_except_excluded_numbers",
                "sendCallsToVoiceMailExceptExcludedNumbers",
                bool,
            ),
            E(
                "excluded_phone_number01",
                "excludedPhoneNumber01",
                str,
            ),
            E(
                "excluded_phone_number02",
                "excludedPhoneNumber02",
                str,
            ),
            E(
                "excluded_phone_number03",
                "excludedPhoneNumber03",
                str,
            ),
            E(
                "forward_excluded_numbers_to",
                "forwardExcludedNumbersTo",
                str,
            ),
        )


class CommunicationBarringAuthorizationCodeConfiguration(OCIType):
    """
    Communication Barring Authorization Code add entry.


    Attributes:
        code (str): code
        description (str): description *Optional*
        network_class_of_service (str): networkClassOfService *Optional*
    """

    __slots__: List[str] = [
        "code",
        "description",
        "network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
            ),
        )


class CommunicationBarringAuthorizationCodeEntry(OCIType):
    """
    Communication Barring Authorization Code entry.


    Attributes:
        code (str): code
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "code",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class CommunicationBarringCallMeNowRule(OCIType):
    """
    Communication Barring Call Me Now Rule

    Attributes:
        criteria (str): criteria
        action (str): action
        call_timeout_seconds (int): callTimeoutSeconds *Optional*
    """

    __slots__: List[str] = [
        "criteria",
        "action",
        "call_timeout_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria",
                "criteria",
                str,
                is_required=True,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "call_timeout_seconds",
                "callTimeoutSeconds",
                int,
            ),
        )


class CommunicationBarringIncomingRule(OCIType):
    """
    Communication Barring Incoming Rule

    Attributes:
        digit_pattern_criteria (str): digitPatternCriteria
        action (str): action
        call_timeout_seconds (int): callTimeoutSeconds *Optional*
        time_schedule (str): timeSchedule *Optional*
        holiday_schedule (str): holidaySchedule *Optional*
        priority (str): priority
    """

    __slots__: List[str] = [
        "digit_pattern_criteria",
        "action",
        "call_timeout_seconds",
        "time_schedule",
        "holiday_schedule",
        "priority",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_criteria",
                "digitPatternCriteria",
                str,
                is_required=True,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "call_timeout_seconds",
                "callTimeoutSeconds",
                int,
            ),
            E(
                "time_schedule",
                "timeSchedule",
                str,
            ),
            E(
                "holiday_schedule",
                "holidaySchedule",
                str,
            ),
            E(
                "priority",
                "priority",
                str,
                is_required=True,
            ),
        )


class CommunicationBarringIncomingRule19sp1(OCIType):
    """
    Communication Barring Incoming Rule

    Attributes:
        digit_pattern_criteria (str): digitPatternCriteria *Optional*
        incoming_criteria (str): incomingCriteria *Optional*
        action (str): action
        call_timeout_seconds (int): callTimeoutSeconds *Optional*
        time_schedule (str): timeSchedule *Optional*
        holiday_schedule (str): holidaySchedule *Optional*
        priority (str): priority
    """

    __slots__: List[str] = [
        "digit_pattern_criteria",
        "incoming_criteria",
        "action",
        "call_timeout_seconds",
        "time_schedule",
        "holiday_schedule",
        "priority",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_criteria",
                "digitPatternCriteria",
                str,
            ),
            E(
                "incoming_criteria",
                "incomingCriteria",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "call_timeout_seconds",
                "callTimeoutSeconds",
                int,
            ),
            E(
                "time_schedule",
                "timeSchedule",
                str,
            ),
            E(
                "holiday_schedule",
                "holidaySchedule",
                str,
            ),
            E(
                "priority",
                "priority",
                str,
                is_required=True,
            ),
        )


class CommunicationBarringOriginatingRule(OCIType):
    """
    Communication Barring Originating Rule

    Attributes:
        criteria (str): criteria
        action (str): action
        treatment_id (str): treatmentId *Optional*
        transfer_number (str): transferNumber *Optional*
        call_timeout_seconds (int): callTimeoutSeconds *Optional*
    """

    __slots__: List[str] = [
        "criteria",
        "action",
        "treatment_id",
        "transfer_number",
        "call_timeout_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria",
                "criteria",
                str,
                is_required=True,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "treatment_id",
                "treatmentId",
                str,
            ),
            E(
                "transfer_number",
                "transferNumber",
                str,
            ),
            E(
                "call_timeout_seconds",
                "callTimeoutSeconds",
                int,
            ),
        )


class CommunicationBarringOriginatingRule15sp2(OCIType):
    """
    Communication Barring Originating Rule

    Attributes:
        criteria (str): criteria
        action (str): action
        treatment_id (str): treatmentId *Optional*
        transfer_number (str): transferNumber *Optional*
    """

    __slots__: List[str] = [
        "criteria",
        "action",
        "treatment_id",
        "transfer_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria",
                "criteria",
                str,
                is_required=True,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "treatment_id",
                "treatmentId",
                str,
            ),
            E(
                "transfer_number",
                "transferNumber",
                str,
            ),
        )


class CommunicationBarringProfileReplacementList(OCIType):
    """
    A list of communication barring profiles that replaces a previously configured list.

    By convention, an element of this type may be set nil to clear the list.

    Attributes:
        profile_name (List[str]): profileName
    """

    __slots__: List[str] = [
        "profile_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class CommunicationBarringRedirectingRule(OCIType):
    """
    Communication Barring Redirecting Rule

    Attributes:
        criteria (str): criteria
        action (str): action
        call_timeout_seconds (int): callTimeoutSeconds *Optional*
    """

    __slots__: List[str] = [
        "criteria",
        "action",
        "call_timeout_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria",
                "criteria",
                str,
                is_required=True,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "call_timeout_seconds",
                "callTimeoutSeconds",
                int,
            ),
        )


class CommunicationBarringRedirectingRule15sp2(OCIType):
    """
    Communication Barring Redirecting Rule

    Attributes:
        criteria (str): criteria
        action (str): action
    """

    __slots__: List[str] = [
        "criteria",
        "action",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria",
                "criteria",
                str,
                is_required=True,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
        )


class ConferenceGreetingMenuKeysModifyEntry(OCIType):
    """
    The voice portal greeting menu keys modify entry.


    Attributes:
        activate_conf_greeting (str): activateConfGreeting *Optional*
        deactivate_conf_greeting (str): deactivateConfGreeting *Optional*
        record_new_conf_greeting (str): recordNewConfGreeting *Optional*
        listen_to_current_conf_greeting (str): listenToCurrentConfGreeting *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "activate_conf_greeting",
        "deactivate_conf_greeting",
        "record_new_conf_greeting",
        "listen_to_current_conf_greeting",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "activate_conf_greeting",
                "activateConfGreeting",
                str,
            ),
            E(
                "deactivate_conf_greeting",
                "deactivateConfGreeting",
                str,
            ),
            E(
                "record_new_conf_greeting",
                "recordNewConfGreeting",
                str,
            ),
            E(
                "listen_to_current_conf_greeting",
                "listenToCurrentConfGreeting",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class ConferenceGreetingMenuKeysReadEntry(OCIType):
    """
    The voice portal conference greeting menu keys.


    Attributes:
        activate_conf_greeting (str): activateConfGreeting *Optional*
        deactivate_conf_greeting (str): deactivateConfGreeting *Optional*
        record_new_conf_greeting (str): recordNewConfGreeting *Optional*
        listen_to_current_conf_greeting (str): listenToCurrentConfGreeting *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "activate_conf_greeting",
        "deactivate_conf_greeting",
        "record_new_conf_greeting",
        "listen_to_current_conf_greeting",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "activate_conf_greeting",
                "activateConfGreeting",
                str,
            ),
            E(
                "deactivate_conf_greeting",
                "deactivateConfGreeting",
                str,
            ),
            E(
                "record_new_conf_greeting",
                "recordNewConfGreeting",
                str,
            ),
            E(
                "listen_to_current_conf_greeting",
                "listenToCurrentConfGreeting",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class Contact(OCIType):
    """
    Contact information.


    Attributes:
        contact_name (str): contactName *Optional*
        contact_number (str): contactNumber *Optional*
        contact_email (str): contactEmail *Optional*
    """

    __slots__: List[str] = [
        "contact_name",
        "contact_number",
        "contact_email",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "contact_name",
                "contactName",
                str,
            ),
            E(
                "contact_number",
                "contactNumber",
                str,
            ),
            E(
                "contact_email",
                "contactEmail",
                str,
            ),
        )


class CriteriaActivation(OCIType):
    """
    Criteria active status indicator

    Attributes:
        criteria_name (str): criteriaName
        is_active (bool): isActive
    """

    __slots__: List[str] = [
        "criteria_name",
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria_name",
                "criteriaName",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
        )


class CriteriaFromDn(OCIType):
    """
    The from dn criteria used within an add/get request.


    Attributes:
        from_dn_criteria_selection (str): fromDnCriteriaSelection
        include_anonymous_callers (bool): includeAnonymousCallers
        include_unavailable_callers (bool): includeUnavailableCallers
        phone_number (List[str]): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "from_dn_criteria_selection",
        "include_anonymous_callers",
        "include_unavailable_callers",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "from_dn_criteria_selection",
                "fromDnCriteriaSelection",
                str,
                is_required=True,
            ),
            E(
                "include_anonymous_callers",
                "includeAnonymousCallers",
                bool,
                is_required=True,
            ),
            E(
                "include_unavailable_callers",
                "includeUnavailableCallers",
                bool,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
        )


class CriteriaFromDn23(OCIType):
    """
    The from dn criteria added with the option for selecting internal and external
    callers, used within an add/get request.


    Attributes:
        from_dn_criteria_selection (str): fromDnCriteriaSelection
        include_anonymous_callers (bool): includeAnonymousCallers
        include_unavailable_callers (bool): includeUnavailableCallers
        include_internal_callers (bool): includeInternalCallers
        include_external_callers (bool): includeExternalCallers
        phone_number (List[str]): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "from_dn_criteria_selection",
        "include_anonymous_callers",
        "include_unavailable_callers",
        "include_internal_callers",
        "include_external_callers",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "from_dn_criteria_selection",
                "fromDnCriteriaSelection",
                str,
                is_required=True,
            ),
            E(
                "include_anonymous_callers",
                "includeAnonymousCallers",
                bool,
                is_required=True,
            ),
            E(
                "include_unavailable_callers",
                "includeUnavailableCallers",
                bool,
                is_required=True,
            ),
            E(
                "include_internal_callers",
                "includeInternalCallers",
                bool,
                is_required=True,
            ),
            E(
                "include_external_callers",
                "includeExternalCallers",
                bool,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
        )


class CriteriaReplacementDNList(OCIType):
    """
    A list of criteria DNs that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number (List[str]): phoneNumber
    """

    __slots__: List[str] = [
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class CustomContactDirectoryEntry(OCIType):
    """
    Represents either an existing user's Id or an existing Virtual On-Net user's DN.

    For a DN the groupId is used to make it unique within an Enterprise, however the
    groupId is not used with Service Providers.

    Attributes:
        user_id (str): userId *Optional*
        virtual_on_net_phone_number (str): virtualOnNetPhoneNumber *Optional*
        group_id (str): groupId *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "virtual_on_net_phone_number",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "virtual_on_net_phone_number",
                "virtualOnNetPhoneNumber",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
        )


class DNISKey(OCIType):
    """
    Uniquely identifies a Call Center DNIS.


    Attributes:
        service_user_id (str): serviceUserId
        name (str): name
    """

    __slots__: List[str] = [
        "service_user_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class DNRange(OCIType):
    """
    Directory number range.

    The minimum and maximum values are inclusive.

    Attributes:
        min_phone_number (str): minPhoneNumber
        max_phone_number (str): maxPhoneNumber
    """

    __slots__: List[str] = [
        "min_phone_number",
        "max_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "min_phone_number",
                "minPhoneNumber",
                str,
                is_required=True,
            ),
            E(
                "max_phone_number",
                "maxPhoneNumber",
                str,
                is_required=True,
            ),
        )


class DNValidationStatusMessage(OCIType):
    """
    The message contains the status and error reason that prevents DN to be
    assigned/validated

    Attributes:
        dn (str): dn
        status (str): status
        message_code (int): messageCode *Optional*
        summary (str): summary *Optional*
        summary_english (str): summaryEnglish *Optional*
    """

    __slots__: List[str] = [
        "dn",
        "status",
        "message_code",
        "summary",
        "summary_english",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn",
                "dn",
                str,
                is_required=True,
            ),
            E(
                "status",
                "status",
                str,
                is_required=True,
            ),
            E(
                "message_code",
                "messageCode",
                int,
            ),
            E(
                "summary",
                "summary",
                str,
            ),
            E(
                "summary_english",
                "summaryEnglish",
                str,
            ),
        )


class DefaultNetworkClassOfService(OCIType):
    """
    The default Network Class of Service to set during assignation/unassignation.


    Attributes:
        use_existing (bool): useExisting *Optional*
        network_class_of_service_name (str): networkClassOfServiceName *Optional*
    """

    __slots__: List[str] = [
        "use_existing",
        "network_class_of_service_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_existing",
                "useExisting",
                bool,
            ),
            E(
                "network_class_of_service_name",
                "networkClassOfServiceName",
                str,
            ),
        )


class DeleteAllMessagesMenuKeysModifyEntry(OCIType):
    """
    The voice portal delete all messages menu keys modify entry modify entry.


    Attributes:
        confirm_deletion (str): confirmDeletion *Optional*
        cancel_deletion (str): cancelDeletion *Optional*
    """

    __slots__: List[str] = [
        "confirm_deletion",
        "cancel_deletion",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "confirm_deletion",
                "confirmDeletion",
                str,
            ),
            E(
                "cancel_deletion",
                "cancelDeletion",
                str,
            ),
        )


class DeleteAllMessagesMenuKeysReadEntry(OCIType):
    """
    The voice portal delete all messages menu keys.


    Attributes:
        confirm_deletion (str): confirmDeletion
        cancel_deletion (str): cancelDeletion
    """

    __slots__: List[str] = [
        "confirm_deletion",
        "cancel_deletion",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "confirm_deletion",
                "confirmDeletion",
                str,
                is_required=True,
            ),
            E(
                "cancel_deletion",
                "cancelDeletion",
                str,
                is_required=True,
            ),
        )


class DepartmentKey(OCIType):
    """
    Uniquely identifies a department system-wide.

    Departments are contained in either an enterprise or a group.  Enterprise departments
    can be used by any or all groups within the enterprise.  Department names are unique
    within a group and within an enterprise, but the same department name can exist in 2
    different groups or in both a group and its parent enterprise.  Therefore, to uniquely
    identify a department, we must know the department name and which enterprise or group
    contains the department.  This type is extended by group and enterprise department
    keys.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class DeviceManagementAutoRebuildConfigEntry(OCIType):
    """
    Contains one automatic rebuild configuration list entry.


    Attributes:
        oci_request_prefix (str): ociRequestPrefix
        auto_rebuild_enabled (bool): autoRebuildEnabled *Optional*
    """

    __slots__: List[str] = [
        "oci_request_prefix",
        "auto_rebuild_enabled",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "oci_request_prefix",
                "ociRequestPrefix",
                str,
                is_required=True,
            ),
            E(
                "auto_rebuild_enabled",
                "autoRebuildEnabled",
                bool,
            ),
        )


class DeviceManagementDeviceTypeOptionsRead(OCIType):
    """
    Device Management System device type options.


    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (str): accessDeviceCredentials *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_format_in_non_request_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
        )


class DeviceManagementDeviceTypeOptionsRead16(OCIType):
    """
    Device Management System device type options.


    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (str): accessDeviceCredentials *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_format_in_non_request_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
        )


class DeviceManagementDeviceTypeOptionsRead21sp1(OCIType):
    """
    Device Management System device type options.

    Note: For the elements listed below, when device configuration is set to
    deviceManagement, those elements apply to the creation of the Polycom Phone Services
    directory file only.  For all other files, they are not used.  Those elements are
    instead configured on a per-file basis at the Device Type File level.  When device
    configuration is set to legacy, those elements apply to all configuration files.
    useHttpDigestAuthentication macBasedFileAuthentication
    userNamePasswordFileAuthentication macInNonRequestURI macInCert
    macFormatInNonRequestURI

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (str): accessDeviceCredentials *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_in_cert (bool): macInCert
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
        )


class DeviceManagementDeviceTypeOptionsRead22(OCIType):
    """
    Device Management System device type options.

    Note: For the elements listed below, when device configuration is set to
    deviceManagement, those elements apply to the creation of the Polycom Phone Services
    directory file only.  For all other files, they are not used.  Those elements are
    instead configured on a per-file basis at the Device Type File level.  When device
    configuration is set to legacy, those elements apply to all configuration files.
    useHttpDigestAuthentication macBasedFileAuthentication
    userNamePasswordFileAuthentication macInNonRequestURI macInCert
    macFormatInNonRequestURI

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (str): accessDeviceCredentials *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_in_cert (bool): macInCert
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
        )


class DeviceManagementDeviceTypeOptionsRead22V2(OCIType):
    """
    Device Management System device type options.

    Note: For the elements listed below, when device configuration is set to
    deviceManagement, those elements apply to the creation of the Polycom Phone Services
    directory file only.  For all other files, they are not used.  Those elements are
    instead configured on a per-file basis at the Device Type File level.  When device
    configuration is set to legacy, those elements apply to all configuration files.
    useHttpDigestAuthentication macBasedFileAuthentication
    userNamePasswordFileAuthentication macInNonRequestURI macInCert
    macFormatInNonRequestURI

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (str): accessDeviceCredentials *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_in_cert (bool): macInCert
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
        )


class DeviceManagementDeviceTypeOptionsRead22V3(OCIType):
    """
    Device Management System device type options.

    Note: For the elements listed below, when device configuration is set to
    deviceManagement, those elements apply to the creation of the Polycom Phone Services
    directory file only.  For all other files, they are not used.  Those elements are
    instead configured on a per-file basis at the Device Type File level.  When device
    configuration is set to legacy, those elements apply to all configuration files.
    useHttpDigestAuthentication macBasedFileAuthentication
    userNamePasswordFileAuthentication bearerFileAuthentication macInNonRequestURI
    macInCert macFormatInNonRequestURI The following data elements are only used in AS
    data mode: enableDeviceActivation, value ‘false’ is returned The following elements
    are only used in AS data mode and not returned in XS data mode deviceModel

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (str): accessDeviceCredentials *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_in_cert (bool): macInCert
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        enable_device_activation (bool): enableDeviceActivation
        device_model (str): deviceModel *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "enable_device_activation",
        "device_model",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "enable_device_activation",
                "enableDeviceActivation",
                bool,
                is_required=True,
            ),
            E(
                "device_model",
                "deviceModel",
                str,
            ),
        )


class DeviceManagementDeviceTypeOptionsRead22V4(OCIType):
    """
    Device Management System device type options.

    Note: For the elements listed below, when device configuration is set to
    deviceManagement, those elements apply to the creation of the Polycom Phone Services
    directory file only.  For all other files, they are not used.  Those elements are
    instead configured on a per-file basis at the Device Type File level.  When device
    configuration is set to legacy, those elements apply to all configuration files.
    useHttpDigestAuthentication macBasedFileAuthentication
    userNamePasswordFileAuthentication macInNonRequestURI macInCert
    macFormatInNonRequestURI The following data elements are only used in AS data mode:
    enableDeviceActivation, value ‘false’ is returned supportLinks, value ‘Not Supported’
    is returned The following elements are only used in AS data mode and not returned in
    XS data mode deviceModel

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (str): accessDeviceCredentials *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_in_cert (bool): macInCert
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        enable_device_activation (bool): enableDeviceActivation
        device_model (str): deviceModel *Optional*
        support_links (str): supportLinks
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "enable_device_activation",
        "device_model",
        "support_links",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "enable_device_activation",
                "enableDeviceActivation",
                bool,
                is_required=True,
            ),
            E(
                "device_model",
                "deviceModel",
                str,
            ),
            E(
                "support_links",
                "supportLinks",
                str,
                is_required=True,
            ),
        )


class DeviceManagementDeviceTypeOptionsRead22V5(OCIType):
    """
    Device Management System device type options.

    Note: For the elements listed below, when device configuration is set to
    deviceManagement, those elements apply to the creation of the Polycom Phone Services
    directory file only.  For all other files, they are not used.  Those elements are
    instead configured on a per-file basis at the Device Type File level.  When device
    configuration is set to legacy, those elements apply to all configuration files.
    useHttpDigestAuthentication macBasedFileAuthentication
    userNamePasswordFileAuthentication macInNonRequestURI macInCert
    macFormatInNonRequestURI The following data elements are only used in AS data mode:
    enableDeviceActivation, value "false" is returned supportLinks, value "Not Supported"
    is returned The following elements are only used in AS data mode and not returned in
    XS data mode deviceModel autoLinkingDeviceType autoCreateDevicesLevel

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (str): accessDeviceCredentials *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_in_cert (bool): macInCert
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        enable_device_activation (bool): enableDeviceActivation
        device_model (str): deviceModel *Optional*
        support_links (str): supportLinks
        auto_linking_device_type (str): autoLinkingDeviceType *Optional*
        auto_create_devices_level (str): autoCreateDevicesLevel *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "enable_device_activation",
        "device_model",
        "support_links",
        "auto_linking_device_type",
        "auto_create_devices_level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "enable_device_activation",
                "enableDeviceActivation",
                bool,
                is_required=True,
            ),
            E(
                "device_model",
                "deviceModel",
                str,
            ),
            E(
                "support_links",
                "supportLinks",
                str,
                is_required=True,
            ),
            E(
                "auto_linking_device_type",
                "autoLinkingDeviceType",
                str,
            ),
            E(
                "auto_create_devices_level",
                "autoCreateDevicesLevel",
                str,
            ),
        )


class DeviceManagementDeviceTypeOptionsRead22V6(OCIType):
    """
    Device Management System device type options.

    Note: For the elements listed below, when device configuration is set to
    deviceManagement, those elements apply to the creation of the Polycom Phone Services
    directory file only.  For all other files, they are not used.  Those elements are
    instead configured on a per-file basis at the Device Type File level.  When device
    configuration is set to legacy, those elements apply to all configuration files except
    bearerFileAuthentication which is not supported.  useHttpDigestAuthentication
    macBasedFileAuthentication userNamePasswordFileAuthentication macInNonRequestURI
    macInCert macFormatInNonRequestURI The following data elements are only used in AS
    data mode: enableDeviceActivation, value ‘false’ is returned supportLinks, value ‘Not
    Supported’ is returned The following elements are only used in AS data mode and not
    returned in XS data mode deviceModel autoLinkingDeviceType autoCreateDevicesLevel
    isActivationCodeThroughMessagingServer bearerFileAuthentication

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (str): accessDeviceCredentials *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_in_cert (bool): macInCert
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        enable_device_activation (bool): enableDeviceActivation
        device_model (str): deviceModel *Optional*
        support_links (str): supportLinks
        auto_linking_device_type (str): autoLinkingDeviceType *Optional*
        auto_create_devices_level (str): autoCreateDevicesLevel *Optional*
        is_activation_code_through_messaging_server (bool):
            isActivationCodeThroughMessagingServer *Optional*
        bearer_file_authentication (bool): bearerFileAuthentication
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "enable_device_activation",
        "device_model",
        "support_links",
        "auto_linking_device_type",
        "auto_create_devices_level",
        "is_activation_code_through_messaging_server",
        "bearer_file_authentication",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "enable_device_activation",
                "enableDeviceActivation",
                bool,
                is_required=True,
            ),
            E(
                "device_model",
                "deviceModel",
                str,
            ),
            E(
                "support_links",
                "supportLinks",
                str,
                is_required=True,
            ),
            E(
                "auto_linking_device_type",
                "autoLinkingDeviceType",
                str,
            ),
            E(
                "auto_create_devices_level",
                "autoCreateDevicesLevel",
                str,
            ),
            E(
                "is_activation_code_through_messaging_server",
                "isActivationCodeThroughMessagingServer",
                bool,
            ),
            E(
                "bearer_file_authentication",
                "bearerFileAuthentication",
                bool,
                is_required=True,
            ),
        )


class DeviceManagementLanguageMapping(OCIType):
    """
    Maps a BroadWorks language to a device-equivalent language.


    Attributes:
        broad_works_language (str): broadWorksLanguage
        device_language (str): deviceLanguage
    """

    __slots__: List[str] = [
        "broad_works_language",
        "device_language",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "broad_works_language",
                "broadWorksLanguage",
                str,
                is_required=True,
            ),
            E(
                "device_language",
                "deviceLanguage",
                str,
                is_required=True,
            ),
        )


class DeviceManagementTag(OCIType):
    """
    Represents a tag name with its associated value.


    Attributes:
        tag_name (str): tagName
        tag_value (str): tagValue *Optional*
    """

    __slots__: List[str] = [
        "tag_name",
        "tag_value",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
            ),
            E(
                "tag_value",
                "tagValue",
                str,
            ),
        )


class DeviceManagementTagSetRename(OCIType):
    """
    Pair of DeviceManagementTagSetName

    Attributes:
        original_tag_set_name (str): originalTagSetName
        new_tag_set_name (str): newTagSetName
    """

    __slots__: List[str] = [
        "original_tag_set_name",
        "new_tag_set_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "original_tag_set_name",
                "originalTagSetName",
                str,
                is_required=True,
            ),
            E(
                "new_tag_set_name",
                "newTagSetName",
                str,
                is_required=True,
            ),
        )


class DeviceManagementUserNamePassword(OCIType):
    """
    Access device credentials.


    Attributes:
        user_name (str): userName
        password (str): password
    """

    __slots__: List[str] = [
        "user_name",
        "password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_name",
                "userName",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
                is_required=True,
            ),
        )


class DeviceManagementUserNamePassword16(OCIType):
    """
    Access device credentials.


    Attributes:
        user_name (str): userName
        password (str): password
    """

    __slots__: List[str] = [
        "user_name",
        "password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_name",
                "userName",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
                is_required=True,
            ),
        )


class DialPlanPolicy(OCIType):
    """
    Dial Plan Access Code attributes.


    Attributes:
        use_setting (str): useSetting *Optional*
        requires_access_code_for_public_calls (bool): requiresAccessCodeForPublicCalls
            *Optional*
        allow_e164_public_calls (bool): allowE164PublicCalls *Optional*
        prefer_e164_number_format_for_callback_services (bool):
            preferE164NumberFormatForCallbackServices *Optional*
        public_digit_map (str): publicDigitMap *Optional*
        private_digit_map (str): privateDigitMap *Optional*
    """

    __slots__: List[str] = [
        "use_setting",
        "requires_access_code_for_public_calls",
        "allow_e164_public_calls",
        "prefer_e164_number_format_for_callback_services",
        "public_digit_map",
        "private_digit_map",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting",
                "useSetting",
                str,
            ),
            E(
                "requires_access_code_for_public_calls",
                "requiresAccessCodeForPublicCalls",
                bool,
            ),
            E(
                "allow_e164_public_calls",
                "allowE164PublicCalls",
                bool,
            ),
            E(
                "prefer_e164_number_format_for_callback_services",
                "preferE164NumberFormatForCallbackServices",
                bool,
            ),
            E(
                "public_digit_map",
                "publicDigitMap",
                str,
            ),
            E(
                "private_digit_map",
                "privateDigitMap",
                str,
            ),
        )


class DialPlanPolicyAccessCode(OCIType):
    """
    Dial Plan Access Code attributes.


    Attributes:
        access_code (str): accessCode
        description (str): description *Optional*
        include_code_for_network_translations_and_routing (bool):
            includeCodeForNetworkTranslationsAndRouting *Optional*
        include_code_for_screening_services (bool): includeCodeForScreeningServices
            *Optional*
        enable_secondary_dial_tone (bool): enableSecondaryDialTone *Optional*
    """

    __slots__: List[str] = [
        "access_code",
        "description",
        "include_code_for_network_translations_and_routing",
        "include_code_for_screening_services",
        "enable_secondary_dial_tone",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_code",
                "accessCode",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "include_code_for_network_translations_and_routing",
                "includeCodeForNetworkTranslationsAndRouting",
                bool,
            ),
            E(
                "include_code_for_screening_services",
                "includeCodeForScreeningServices",
                bool,
            ),
            E(
                "enable_secondary_dial_tone",
                "enableSecondaryDialTone",
                bool,
            ),
        )


class DialableCallerIDCriteriaPriorityOrder(OCIType):
    """
    Dialable Caller ID routing order

    Attributes:
        criteria_name (str): criteriaName
        priority (str): priority
    """

    __slots__: List[str] = [
        "criteria_name",
        "priority",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria_name",
                "criteriaName",
                str,
                is_required=True,
            ),
            E(
                "priority",
                "priority",
                str,
                is_required=True,
            ),
        )


class DirectRouteIdentifiers(OCIType):
    """
    Direct Route identifiers.


    Attributes:
        dtg_identity (str): dtgIdentity *Optional*
        trunk_identity (str): trunkIdentity *Optional*
    """

    __slots__: List[str] = [
        "dtg_identity",
        "trunk_identity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dtg_identity",
                "dtgIdentity",
                str,
            ),
            E(
                "trunk_identity",
                "trunkIdentity",
                str,
            ),
        )


class DirectRouteReplacementIdentityList(OCIType):
    """
    A replacement list of direct route parameters.


    Attributes:
        dtg_identity (str): dtgIdentity *Optional*
        trunk_identity (str): trunkIdentity *Optional*
    """

    __slots__: List[str] = [
        "dtg_identity",
        "trunk_identity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dtg_identity",
                "dtgIdentity",
                str,
            ),
            E(
                "trunk_identity",
                "trunkIdentity",
                str,
            ),
        )


class DisableMessageDepositMenuKeysModifyEntry(OCIType):
    """
    The voice portal disable message deposit menu keys modify entry.


    Attributes:
        disconnect_after_greeting (str): disconnectAfterGreeting *Optional*
        forward_after_greeting (str): forwardAfterGreeting *Optional*
        change_forwarding_destination (str): changeForwardingDestination *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "disconnect_after_greeting",
        "forward_after_greeting",
        "change_forwarding_destination",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disconnect_after_greeting",
                "disconnectAfterGreeting",
                str,
            ),
            E(
                "forward_after_greeting",
                "forwardAfterGreeting",
                str,
            ),
            E(
                "change_forwarding_destination",
                "changeForwardingDestination",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class DisableMessageDepositMenuKeysReadEntry(OCIType):
    """
    The voice portal disable message deposit menu keys.


    Attributes:
        disconnect_after_greeting (str): disconnectAfterGreeting *Optional*
        forward_after_greeting (str): forwardAfterGreeting *Optional*
        change_forwarding_destination (str): changeForwardingDestination *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "disconnect_after_greeting",
        "forward_after_greeting",
        "change_forwarding_destination",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disconnect_after_greeting",
                "disconnectAfterGreeting",
                str,
            ),
            E(
                "forward_after_greeting",
                "forwardAfterGreeting",
                str,
            ),
            E(
                "change_forwarding_destination",
                "changeForwardingDestination",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class EmailAddressList(OCIType):
    """
    A list of 50 email addresses is configured in the "Forward it to these e-mail
    addresses" section on the Voice Management configuration page Change History: R25.

    0 - Added

    Attributes:
        email_address (List[str]): emailAddress
    """

    __slots__: List[str] = [
        "email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "email_address",
                "emailAddress",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class EnhancedCallLogsAccountAuthorizationCodeFilter(OCIType):
    """
    Filter criteria based on the account code.

    When "callsWithCodes" is set to true, all call logs with account/authorization codes
    are returned.  When it set to false, all call logs without account/authorization codes
    are returned.

    Attributes:
        calls_with_codes (bool): callsWithCodes *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
    """

    __slots__: List[str] = [
        "calls_with_codes",
        "account_authorization_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "calls_with_codes",
                "callsWithCodes",
                bool,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
        )


class EnhancedCallLogsCallAuthorizationCodeFilter(OCIType):
    """
    Filter criteria based on call authorization code.

    Note that this code filter is different than
    EnhancedCallLogsAccountAuthorizationCodeFilter, which applies strictly to codes
    entered using the account/authorization code service.  When "callsWithCodes" is set to
    true, all call logs with authorization codes are returned.  When it set to false, all
    call logs without authorization codes are returned.  If "authorizationCode" is set,
    all call logs matching that specific authorization code are returned.

    Attributes:
        calls_with_codes (bool): callsWithCodes *Optional*
        authorization_code (str): authorizationCode *Optional*
    """

    __slots__: List[str] = [
        "calls_with_codes",
        "authorization_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "calls_with_codes",
                "callsWithCodes",
                bool,
            ),
            E(
                "authorization_code",
                "authorizationCode",
                str,
            ),
        )


class EnhancedCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.

    Replaced By: CallLogsEntry

    Attributes:
        country_code (str): countryCode *Optional*
        phone_number (str): phoneNumber
        name (str): name
        time (str): time
    """

    __slots__: List[str] = [
        "country_code",
        "phone_number",
        "name",
        "time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "country_code",
                "countryCode",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
        )


class EnhancedCallLogsRedirectedCallSelection(OCIType):
    """
    Redirected call selection.

    When " redirectedCall " is set to true, all call logs with redirected call are
    returned.  When it set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.  If none included, any call has a ServiceInvocationDisposition value
    defined in ServiceInvocationDisposition is considered as a redirected call.

    Attributes:
        redirected_call (bool): redirectedCall
        redirect_type (List[str]): redirectType *Optional*
    """

    __slots__: List[str] = [
        "redirected_call",
        "redirect_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "redirected_call",
                "redirectedCall",
                bool,
                is_required=True,
            ),
            E(
                "redirect_type",
                "redirectType",
                str,
                is_array=True,
            ),
        )


class EnhancedCallLogsRedirectedCallSelection20sp1(OCIType):
    """
    Redirected call selection.

    When " redirectedCall " is set to true, all call logs with redirected call are
    returned.  When it set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.  If none included, any call has a ServiceInvocationDisposition value
    defined in ServiceInvocationDisposition21sp1 is considered as a redirected call.

    Attributes:
        redirected_call (bool): redirectedCall
        redirect_type (List[str]): redirectType *Optional*
    """

    __slots__: List[str] = [
        "redirected_call",
        "redirect_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "redirected_call",
                "redirectedCall",
                bool,
                is_required=True,
            ),
            E(
                "redirect_type",
                "redirectType",
                str,
                is_array=True,
            ),
        )


class EnhancedCallLogsRedirectedCallSelection21(OCIType):
    """
    Redirected call selection.

    When " redirectedCall " is set to true, all call logs with redirected call are
    returned.  When it set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.  If none included, any call has a ServiceInvocationDisposition value
    defined in ServiceInvocationDisposition21 is considered as a redirected call.

    Attributes:
        redirected_call (bool): redirectedCall
        redirect_type (List[str]): redirectType *Optional*
    """

    __slots__: List[str] = [
        "redirected_call",
        "redirect_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "redirected_call",
                "redirectedCall",
                bool,
                is_required=True,
            ),
            E(
                "redirect_type",
                "redirectType",
                str,
                is_array=True,
            ),
        )


class EnhancedCallLogsRedirectedCallSelection21sp1(OCIType):
    """
    Redirected call selection.

    When " redirectedCall " is set to true, all call logs with redirected call are
    returned.  When it set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.  If none included, any call has a ServiceInvocationDisposition value
    defined in ServiceInvocationDisposition21sp1 is considered as a redirected call.

    Attributes:
        redirected_call (bool): redirectedCall
        redirect_type (List[str]): redirectType *Optional*
    """

    __slots__: List[str] = [
        "redirected_call",
        "redirect_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "redirected_call",
                "redirectedCall",
                bool,
                is_required=True,
            ),
            E(
                "redirect_type",
                "redirectType",
                str,
                is_array=True,
            ),
        )


class EnhancedCallLogsRedirectedCallSelection23(OCIType):
    """
    Redirected call selection.

    When " redirectedCall " is set to true, all call logs with redirected call are
    returned.  When it set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.  If none included, any call has a ServiceInvocationDisposition value
    defined in ServiceInvocationDisposition21sp1 is considered as a redirected call.

    Attributes:
        redirected_call (bool): redirectedCall
        redirect_type (List[str]): redirectType *Optional*
    """

    __slots__: List[str] = [
        "redirected_call",
        "redirect_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "redirected_call",
                "redirectedCall",
                bool,
                is_required=True,
            ),
            E(
                "redirect_type",
                "redirectType",
                str,
                is_array=True,
            ),
        )


class EnhancedCallLogsResponsePagingControl(OCIType):
    """
    Used in enhanced call logs group and enterprise queries to restrict the set of result
    rows when making a request that can result in a large dataset.

    The client specifies the starting row and the number of rows requested.  The server
    only provides those rows in results, if available.

    Attributes:
        response_start_index (int): responseStartIndex
        response_page_size (int): responsePageSize
    """

    __slots__: List[str] = [
        "response_start_index",
        "response_page_size",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "response_start_index",
                "responseStartIndex",
                int,
                is_required=True,
            ),
            E(
                "response_page_size",
                "responsePageSize",
                int,
                is_required=True,
            ),
        )


class EnhancedCallLogsTimeRange(OCIType):
    """
    Time range used to filter call logs.


    Attributes:
        start_date_time (str): startDateTime
        end_date_time (str): endDateTime
    """

    __slots__: List[str] = [
        "start_date_time",
        "end_date_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "start_date_time",
                "startDateTime",
                str,
                is_required=True,
            ),
            E(
                "end_date_time",
                "endDateTime",
                str,
                is_required=True,
            ),
        )


class EnterpriseSessionAdmissionControlGroupGetRequest21sp1V2(OCIType):
    """
    Request to get a session admission control group for the enterprise.

    The response is either an EnterpriseSessionAdmissionControlGroupGetResponse21sp1V2 or
    an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class EnterpriseTrunkNumberRangeModify(OCIType):
    """
    Directory number range for modification.


    Attributes:
        dn_range_start (str): dnRangeStart
        extension_length (int): extensionLength *Optional*
    """

    __slots__: List[str] = [
        "dn_range_start",
        "extension_length",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn_range_start",
                "dnRangeStart",
                str,
                is_required=True,
            ),
            E(
                "extension_length",
                "extensionLength",
                int,
            ),
        )


class EnterpriseTrunkReplacementNumberPrefixList(OCIType):
    """
    A list of prefixes that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        number_prefix (List[str]): numberPrefix
    """

    __slots__: List[str] = [
        "number_prefix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number_prefix",
                "numberPrefix",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class EnterpriseTrunkTrunkGroupKey(OCIType):
    """
    Identifies a trunk group within an Enterprise Trunk where the service provider id is
    already known.


    Attributes:
        group_id (str): groupId
        trunk_group_name (str): trunkGroupName
    """

    __slots__: List[str] = [
        "group_id",
        "trunk_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_name",
                "trunkGroupName",
                str,
                is_required=True,
            ),
        )


class EnterpriseVoiceVPNDigitManipulation(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry.

    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class EnterpriseVoiceVPNTreatmentEntry(OCIType):
    """
    Enterprise Voice VPN Treatment entry

    Attributes:
        id (str): id
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "id",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "id",
                "id",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class EstimatedWaitMessageOptionsModify(OCIType):
    """
    Estimated Wait Message Options

    Attributes:
        enabled (bool): enabled *Optional*
        operating_mode (str): operatingMode *Optional*
        play_position_high_volume (bool): playPositionHighVolume *Optional*
        play_time_high_volume (bool): playTimeHighVolume *Optional*
        maximum_positions (int): maximumPositions *Optional*
        maximum_waiting_minutes (int): maximumWaitingMinutes *Optional*
        default_call_handling_minutes (int): defaultCallHandlingMinutes *Optional*
        play_updated_ewm (bool): playUpdatedEWM *Optional*
        time_between_ewm_updates_seconds (int): timeBetweenEWMUpdatesSeconds *Optional*
    """

    __slots__: List[str] = [
        "enabled",
        "operating_mode",
        "play_position_high_volume",
        "play_time_high_volume",
        "maximum_positions",
        "maximum_waiting_minutes",
        "default_call_handling_minutes",
        "play_updated_ewm",
        "time_between_ewm_updates_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enabled",
                "enabled",
                bool,
            ),
            E(
                "operating_mode",
                "operatingMode",
                str,
            ),
            E(
                "play_position_high_volume",
                "playPositionHighVolume",
                bool,
            ),
            E(
                "play_time_high_volume",
                "playTimeHighVolume",
                bool,
            ),
            E(
                "maximum_positions",
                "maximumPositions",
                int,
            ),
            E(
                "maximum_waiting_minutes",
                "maximumWaitingMinutes",
                int,
            ),
            E(
                "default_call_handling_minutes",
                "defaultCallHandlingMinutes",
                int,
            ),
            E(
                "play_updated_ewm",
                "playUpdatedEWM",
                bool,
            ),
            E(
                "time_between_ewm_updates_seconds",
                "timeBetweenEWMUpdatesSeconds",
                int,
            ),
        )


class EstimatedWaitMessageOptionsRead(OCIType):
    """
    Estimated Wait Message Options Replaced by EstimatedWaitMessageOptionsRead17sp4

    Attributes:
        enabled (bool): enabled
        operating_mode (str): operatingMode
        play_position_high_volume (bool): playPositionHighVolume
        play_time_high_volume (bool): playTimeHighVolume
        maximum_positions (int): maximumPositions
        maximum_waiting_minutes (int): maximumWaitingMinutes
        default_call_handling_minutes (int): defaultCallHandlingMinutes
    """

    __slots__: List[str] = [
        "enabled",
        "operating_mode",
        "play_position_high_volume",
        "play_time_high_volume",
        "maximum_positions",
        "maximum_waiting_minutes",
        "default_call_handling_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enabled",
                "enabled",
                bool,
                is_required=True,
            ),
            E(
                "operating_mode",
                "operatingMode",
                str,
                is_required=True,
            ),
            E(
                "play_position_high_volume",
                "playPositionHighVolume",
                bool,
                is_required=True,
            ),
            E(
                "play_time_high_volume",
                "playTimeHighVolume",
                bool,
                is_required=True,
            ),
            E(
                "maximum_positions",
                "maximumPositions",
                int,
                is_required=True,
            ),
            E(
                "maximum_waiting_minutes",
                "maximumWaitingMinutes",
                int,
                is_required=True,
            ),
            E(
                "default_call_handling_minutes",
                "defaultCallHandlingMinutes",
                int,
                is_required=True,
            ),
        )


class EstimatedWaitMessageOptionsRead17sp4(OCIType):
    """
    Estimated Wait Message Options

    Attributes:
        enabled (bool): enabled
        operating_mode (str): operatingMode
        play_position_high_volume (bool): playPositionHighVolume
        play_time_high_volume (bool): playTimeHighVolume
        maximum_positions (int): maximumPositions
        maximum_waiting_minutes (int): maximumWaitingMinutes
        default_call_handling_minutes (int): defaultCallHandlingMinutes
        play_updated_ewm (bool): playUpdatedEWM
        time_between_ewm_updates_seconds (int): timeBetweenEWMUpdatesSeconds *Optional*
    """

    __slots__: List[str] = [
        "enabled",
        "operating_mode",
        "play_position_high_volume",
        "play_time_high_volume",
        "maximum_positions",
        "maximum_waiting_minutes",
        "default_call_handling_minutes",
        "play_updated_ewm",
        "time_between_ewm_updates_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enabled",
                "enabled",
                bool,
                is_required=True,
            ),
            E(
                "operating_mode",
                "operatingMode",
                str,
                is_required=True,
            ),
            E(
                "play_position_high_volume",
                "playPositionHighVolume",
                bool,
                is_required=True,
            ),
            E(
                "play_time_high_volume",
                "playTimeHighVolume",
                bool,
                is_required=True,
            ),
            E(
                "maximum_positions",
                "maximumPositions",
                int,
                is_required=True,
            ),
            E(
                "maximum_waiting_minutes",
                "maximumWaitingMinutes",
                int,
                is_required=True,
            ),
            E(
                "default_call_handling_minutes",
                "defaultCallHandlingMinutes",
                int,
                is_required=True,
            ),
            E(
                "play_updated_ewm",
                "playUpdatedEWM",
                bool,
                is_required=True,
            ),
            E(
                "time_between_ewm_updates_seconds",
                "timeBetweenEWMUpdatesSeconds",
                int,
            ),
        )


class ExchangeUserNamePassword(OCIType):
    """
    Exchange server user name and password.


    Attributes:
        user_name (str): userName
        password (str): password
    """

    __slots__: List[str] = [
        "user_name",
        "password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_name",
                "userName",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
                is_required=True,
            ),
        )


class ExecutiveAssistantOptInStatus(OCIType):
    """
    Executive assistant Opt-in status with executive.


    Attributes:
        executive_user_id (str): executiveUserId
        opt_in (bool): optIn
    """

    __slots__: List[str] = [
        "executive_user_id",
        "opt_in",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "executive_user_id",
                "executiveUserId",
                str,
                is_required=True,
            ),
            E(
                "opt_in",
                "optIn",
                bool,
                is_required=True,
            ),
        )


class ExecutiveCallFilteringCriteriaFromDn(OCIType):
    """
    The from dn criteria used within an executive call filtering criteria add/get request.


    Attributes:
        from_dn_criteria_selection (str): fromDnCriteriaSelection
        include_anonymous_callers (bool): includeAnonymousCallers
        include_unavailable_callers (bool): includeUnavailableCallers
        phone_number (List[str]): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "from_dn_criteria_selection",
        "include_anonymous_callers",
        "include_unavailable_callers",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "from_dn_criteria_selection",
                "fromDnCriteriaSelection",
                str,
                is_required=True,
            ),
            E(
                "include_anonymous_callers",
                "includeAnonymousCallers",
                bool,
                is_required=True,
            ),
            E(
                "include_unavailable_callers",
                "includeUnavailableCallers",
                bool,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
        )


class ExtendedMixedCallLogsEntry(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachTime" represents the time when the call is successfully
    redirected by the system.  "releaseTime" represents the time when the call is
    released.  This time corresponds to the moment the call is released by the system, and
    not necessarily when one party hangs up, since this does not always mean the call is
    released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  Replaced by
    ExtendedMixedCallLogsEntry17sp4. Originally deprecated in release 20.

    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode
        call_log_id (str): callLogId
        call_id (str): callId
        subscriber_type (str): subscriberType
        dialed_number (str): dialedNumber *Optional*
        called_number (str): calledNumber *Optional*
        network_translated_address (str): networkTranslatedAddress *Optional*
        calling_asserted_number (str): callingAssertedNumber *Optional*
        calling_presentation_number (str): callingPresentationNumber *Optional*
        calling_presentation_number_source (str): callingPresentationNumberSource
            *Optional*
        calling_presentation_name (str): callingPresentationName *Optional*
        calling_presentation_indicator (str): callingPresentationIndicator
        calling_group_id (str): callingGroupId *Optional*
        called_directory_name (str): calledDirectoryName *Optional*
        called_group_id (str): calledGroupId *Optional*
        connected_number (str): connectedNumber *Optional*
        connected_number_source (str): connectedNumberSource *Optional*
        connected_name (str): connectedName *Optional*
        connected_presentation_indicator (str): connectedPresentationIndicator *Optional*
        type_of_network (str): typeOfNetwork *Optional*
        call_category (str): callCategory *Optional*
        basic_call_type (str): basicCallType
        configurable_call_type (str): configurableCallType *Optional*
        alternate_call_indicator (str): alternateCallIndicator *Optional*
        virtual_on_net_call_type (str): virtualOnNetCallType *Optional*
        time (str): time
        start_time (int): startTime
        answer_time (int): answerTime *Optional*
        release_time (int): releaseTime *Optional*
        detached_time (int): detachedTime *Optional*
        detached_answer_time (int): detachedAnswerTime *Optional*
        outgoing_dnis (str): outgoingDnis *Optional*
        service_invocation_disposition (str): serviceInvocationDisposition *Optional*
        service_invocation_dialed_number (str): serviceInvocationDialedNumber *Optional*
        service_invocation_called_number (str): serviceInvocationCalledNumber *Optional*
        service_invocation_network_translated_address (str):
            serviceInvocationNetworkTranslatedAddress *Optional*
        service_invocation_type_of_network (str): serviceInvocationTypeOfNetwork
            *Optional*
        service_invocation_call_category (str): serviceInvocationCallCategory *Optional*
        service_invocation_basic_call_type (str): serviceInvocationBasicCallType
            *Optional*
        service_invocation_configurable_call_type (str):
            serviceInvocationConfigurableCallType *Optional*
        service_invocation_alternate_call_indicator (str):
            serviceInvocationAlternateCallIndicator *Optional*
        service_invocation_virtual_on_net_call_type (str):
            serviceInvocationVirtualOnNetCallType *Optional*
        service_invocation_called_directory_name (str):
            serviceInvocationCalledDirectoryName *Optional*
        service_invocation_called_group_id (str): serviceInvocationCalledGroupId
            *Optional*
        redirecting_number (str): redirectingNumber *Optional*
        redirecting_name (str): redirectingName *Optional*
        redirecting_presentation_indicator (str): redirectingPresentationIndicator
            *Optional*
        redirecting_reason (str): RedirectingReason *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
        user_group_id (str): userGroupId *Optional*
        user_id (str): userId *Optional*
        user_primary_dn (str): userPrimaryDn *Optional*
        user_primary_extension (str): userPrimaryExtension *Optional*
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "call_id",
        "subscriber_type",
        "dialed_number",
        "called_number",
        "network_translated_address",
        "calling_asserted_number",
        "calling_presentation_number",
        "calling_presentation_number_source",
        "calling_presentation_name",
        "calling_presentation_indicator",
        "calling_group_id",
        "called_directory_name",
        "called_group_id",
        "connected_number",
        "connected_number_source",
        "connected_name",
        "connected_presentation_indicator",
        "type_of_network",
        "call_category",
        "basic_call_type",
        "configurable_call_type",
        "alternate_call_indicator",
        "virtual_on_net_call_type",
        "time",
        "start_time",
        "answer_time",
        "release_time",
        "detached_time",
        "detached_answer_time",
        "outgoing_dnis",
        "service_invocation_disposition",
        "service_invocation_dialed_number",
        "service_invocation_called_number",
        "service_invocation_network_translated_address",
        "service_invocation_type_of_network",
        "service_invocation_call_category",
        "service_invocation_basic_call_type",
        "service_invocation_configurable_call_type",
        "service_invocation_alternate_call_indicator",
        "service_invocation_virtual_on_net_call_type",
        "service_invocation_called_directory_name",
        "service_invocation_called_group_id",
        "redirecting_number",
        "redirecting_name",
        "redirecting_presentation_indicator",
        "redirecting_reason",
        "account_authorization_code",
        "user_group_id",
        "user_id",
        "user_primary_dn",
        "user_primary_extension",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "call_id",
                "callId",
                str,
                is_required=True,
            ),
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
            ),
            E(
                "dialed_number",
                "dialedNumber",
                str,
            ),
            E(
                "called_number",
                "calledNumber",
                str,
            ),
            E(
                "network_translated_address",
                "networkTranslatedAddress",
                str,
            ),
            E(
                "calling_asserted_number",
                "callingAssertedNumber",
                str,
            ),
            E(
                "calling_presentation_number",
                "callingPresentationNumber",
                str,
            ),
            E(
                "calling_presentation_number_source",
                "callingPresentationNumberSource",
                str,
            ),
            E(
                "calling_presentation_name",
                "callingPresentationName",
                str,
            ),
            E(
                "calling_presentation_indicator",
                "callingPresentationIndicator",
                str,
                is_required=True,
            ),
            E(
                "calling_group_id",
                "callingGroupId",
                str,
            ),
            E(
                "called_directory_name",
                "calledDirectoryName",
                str,
            ),
            E(
                "called_group_id",
                "calledGroupId",
                str,
            ),
            E(
                "connected_number",
                "connectedNumber",
                str,
            ),
            E(
                "connected_number_source",
                "connectedNumberSource",
                str,
            ),
            E(
                "connected_name",
                "connectedName",
                str,
            ),
            E(
                "connected_presentation_indicator",
                "connectedPresentationIndicator",
                str,
            ),
            E(
                "type_of_network",
                "typeOfNetwork",
                str,
            ),
            E(
                "call_category",
                "callCategory",
                str,
            ),
            E(
                "basic_call_type",
                "basicCallType",
                str,
                is_required=True,
            ),
            E(
                "configurable_call_type",
                "configurableCallType",
                str,
            ),
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
            ),
            E(
                "virtual_on_net_call_type",
                "virtualOnNetCallType",
                str,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                int,
                is_required=True,
            ),
            E(
                "answer_time",
                "answerTime",
                int,
            ),
            E(
                "release_time",
                "releaseTime",
                int,
            ),
            E(
                "detached_time",
                "detachedTime",
                int,
            ),
            E(
                "detached_answer_time",
                "detachedAnswerTime",
                int,
            ),
            E(
                "outgoing_dnis",
                "outgoingDnis",
                str,
            ),
            E(
                "service_invocation_disposition",
                "serviceInvocationDisposition",
                str,
            ),
            E(
                "service_invocation_dialed_number",
                "serviceInvocationDialedNumber",
                str,
            ),
            E(
                "service_invocation_called_number",
                "serviceInvocationCalledNumber",
                str,
            ),
            E(
                "service_invocation_network_translated_address",
                "serviceInvocationNetworkTranslatedAddress",
                str,
            ),
            E(
                "service_invocation_type_of_network",
                "serviceInvocationTypeOfNetwork",
                str,
            ),
            E(
                "service_invocation_call_category",
                "serviceInvocationCallCategory",
                str,
            ),
            E(
                "service_invocation_basic_call_type",
                "serviceInvocationBasicCallType",
                str,
            ),
            E(
                "service_invocation_configurable_call_type",
                "serviceInvocationConfigurableCallType",
                str,
            ),
            E(
                "service_invocation_alternate_call_indicator",
                "serviceInvocationAlternateCallIndicator",
                str,
            ),
            E(
                "service_invocation_virtual_on_net_call_type",
                "serviceInvocationVirtualOnNetCallType",
                str,
            ),
            E(
                "service_invocation_called_directory_name",
                "serviceInvocationCalledDirectoryName",
                str,
            ),
            E(
                "service_invocation_called_group_id",
                "serviceInvocationCalledGroupId",
                str,
            ),
            E(
                "redirecting_number",
                "redirectingNumber",
                str,
            ),
            E(
                "redirecting_name",
                "redirectingName",
                str,
            ),
            E(
                "redirecting_presentation_indicator",
                "redirectingPresentationIndicator",
                str,
            ),
            E(
                "redirecting_reason",
                "RedirectingReason",
                str,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
            E(
                "user_group_id",
                "userGroupId",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "user_primary_dn",
                "userPrimaryDn",
                str,
            ),
            E(
                "user_primary_extension",
                "userPrimaryExtension",
                str,
            ),
        )


class ExtendedMixedCallLogsEntry17sp4(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode and not returned in XS data mode: callAuthorizationCode

    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode
        call_log_id (str): callLogId
        call_id (str): callId
        subscriber_type (str): subscriberType
        dialed_number (str): dialedNumber *Optional*
        called_number (str): calledNumber *Optional*
        network_translated_address (str): networkTranslatedAddress *Optional*
        calling_asserted_number (str): callingAssertedNumber *Optional*
        calling_presentation_number (str): callingPresentationNumber *Optional*
        calling_presentation_number_source (str): callingPresentationNumberSource
            *Optional*
        calling_presentation_name (str): callingPresentationName *Optional*
        calling_presentation_indicator (str): callingPresentationIndicator
        calling_group_id (str): callingGroupId *Optional*
        called_directory_name (str): calledDirectoryName *Optional*
        called_group_id (str): calledGroupId *Optional*
        connected_number (str): connectedNumber *Optional*
        connected_number_source (str): connectedNumberSource *Optional*
        connected_name (str): connectedName *Optional*
        connected_presentation_indicator (str): connectedPresentationIndicator *Optional*
        type_of_network (str): typeOfNetwork *Optional*
        call_category (str): callCategory *Optional*
        basic_call_type (str): basicCallType
        configurable_call_type (str): configurableCallType *Optional*
        alternate_call_indicator (str): alternateCallIndicator *Optional*
        virtual_on_net_call_type (str): virtualOnNetCallType *Optional*
        time (str): time
        start_time (int): startTime
        answer_time (int): answerTime *Optional*
        release_time (int): releaseTime *Optional*
        detached_time (int): detachedTime *Optional*
        detached_answer_time (int): detachedAnswerTime *Optional*
        outgoing_dnis (str): outgoingDnis *Optional*
        service_invocation_disposition (str): serviceInvocationDisposition *Optional*
        service_invocation_dialed_number (str): serviceInvocationDialedNumber *Optional*
        service_invocation_called_number (str): serviceInvocationCalledNumber *Optional*
        service_invocation_network_translated_address (str):
            serviceInvocationNetworkTranslatedAddress *Optional*
        service_invocation_type_of_network (str): serviceInvocationTypeOfNetwork
            *Optional*
        service_invocation_call_category (str): serviceInvocationCallCategory *Optional*
        service_invocation_basic_call_type (str): serviceInvocationBasicCallType
            *Optional*
        service_invocation_configurable_call_type (str):
            serviceInvocationConfigurableCallType *Optional*
        service_invocation_alternate_call_indicator (str):
            serviceInvocationAlternateCallIndicator *Optional*
        service_invocation_virtual_on_net_call_type (str):
            serviceInvocationVirtualOnNetCallType *Optional*
        service_invocation_called_directory_name (str):
            serviceInvocationCalledDirectoryName *Optional*
        service_invocation_called_group_id (str): serviceInvocationCalledGroupId
            *Optional*
        redirecting_number (str): redirectingNumber *Optional*
        redirecting_name (str): redirectingName *Optional*
        redirecting_presentation_indicator (str): redirectingPresentationIndicator
            *Optional*
        redirecting_reason (str): RedirectingReason *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
        call_authorization_code (str): callAuthorizationCode *Optional*
        user_group_id (str): userGroupId *Optional*
        user_id (str): userId *Optional*
        user_primary_dn (str): userPrimaryDn *Optional*
        user_primary_extension (str): userPrimaryExtension *Optional*
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "call_id",
        "subscriber_type",
        "dialed_number",
        "called_number",
        "network_translated_address",
        "calling_asserted_number",
        "calling_presentation_number",
        "calling_presentation_number_source",
        "calling_presentation_name",
        "calling_presentation_indicator",
        "calling_group_id",
        "called_directory_name",
        "called_group_id",
        "connected_number",
        "connected_number_source",
        "connected_name",
        "connected_presentation_indicator",
        "type_of_network",
        "call_category",
        "basic_call_type",
        "configurable_call_type",
        "alternate_call_indicator",
        "virtual_on_net_call_type",
        "time",
        "start_time",
        "answer_time",
        "release_time",
        "detached_time",
        "detached_answer_time",
        "outgoing_dnis",
        "service_invocation_disposition",
        "service_invocation_dialed_number",
        "service_invocation_called_number",
        "service_invocation_network_translated_address",
        "service_invocation_type_of_network",
        "service_invocation_call_category",
        "service_invocation_basic_call_type",
        "service_invocation_configurable_call_type",
        "service_invocation_alternate_call_indicator",
        "service_invocation_virtual_on_net_call_type",
        "service_invocation_called_directory_name",
        "service_invocation_called_group_id",
        "redirecting_number",
        "redirecting_name",
        "redirecting_presentation_indicator",
        "redirecting_reason",
        "account_authorization_code",
        "call_authorization_code",
        "user_group_id",
        "user_id",
        "user_primary_dn",
        "user_primary_extension",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "call_id",
                "callId",
                str,
                is_required=True,
            ),
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
            ),
            E(
                "dialed_number",
                "dialedNumber",
                str,
            ),
            E(
                "called_number",
                "calledNumber",
                str,
            ),
            E(
                "network_translated_address",
                "networkTranslatedAddress",
                str,
            ),
            E(
                "calling_asserted_number",
                "callingAssertedNumber",
                str,
            ),
            E(
                "calling_presentation_number",
                "callingPresentationNumber",
                str,
            ),
            E(
                "calling_presentation_number_source",
                "callingPresentationNumberSource",
                str,
            ),
            E(
                "calling_presentation_name",
                "callingPresentationName",
                str,
            ),
            E(
                "calling_presentation_indicator",
                "callingPresentationIndicator",
                str,
                is_required=True,
            ),
            E(
                "calling_group_id",
                "callingGroupId",
                str,
            ),
            E(
                "called_directory_name",
                "calledDirectoryName",
                str,
            ),
            E(
                "called_group_id",
                "calledGroupId",
                str,
            ),
            E(
                "connected_number",
                "connectedNumber",
                str,
            ),
            E(
                "connected_number_source",
                "connectedNumberSource",
                str,
            ),
            E(
                "connected_name",
                "connectedName",
                str,
            ),
            E(
                "connected_presentation_indicator",
                "connectedPresentationIndicator",
                str,
            ),
            E(
                "type_of_network",
                "typeOfNetwork",
                str,
            ),
            E(
                "call_category",
                "callCategory",
                str,
            ),
            E(
                "basic_call_type",
                "basicCallType",
                str,
                is_required=True,
            ),
            E(
                "configurable_call_type",
                "configurableCallType",
                str,
            ),
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
            ),
            E(
                "virtual_on_net_call_type",
                "virtualOnNetCallType",
                str,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                int,
                is_required=True,
            ),
            E(
                "answer_time",
                "answerTime",
                int,
            ),
            E(
                "release_time",
                "releaseTime",
                int,
            ),
            E(
                "detached_time",
                "detachedTime",
                int,
            ),
            E(
                "detached_answer_time",
                "detachedAnswerTime",
                int,
            ),
            E(
                "outgoing_dnis",
                "outgoingDnis",
                str,
            ),
            E(
                "service_invocation_disposition",
                "serviceInvocationDisposition",
                str,
            ),
            E(
                "service_invocation_dialed_number",
                "serviceInvocationDialedNumber",
                str,
            ),
            E(
                "service_invocation_called_number",
                "serviceInvocationCalledNumber",
                str,
            ),
            E(
                "service_invocation_network_translated_address",
                "serviceInvocationNetworkTranslatedAddress",
                str,
            ),
            E(
                "service_invocation_type_of_network",
                "serviceInvocationTypeOfNetwork",
                str,
            ),
            E(
                "service_invocation_call_category",
                "serviceInvocationCallCategory",
                str,
            ),
            E(
                "service_invocation_basic_call_type",
                "serviceInvocationBasicCallType",
                str,
            ),
            E(
                "service_invocation_configurable_call_type",
                "serviceInvocationConfigurableCallType",
                str,
            ),
            E(
                "service_invocation_alternate_call_indicator",
                "serviceInvocationAlternateCallIndicator",
                str,
            ),
            E(
                "service_invocation_virtual_on_net_call_type",
                "serviceInvocationVirtualOnNetCallType",
                str,
            ),
            E(
                "service_invocation_called_directory_name",
                "serviceInvocationCalledDirectoryName",
                str,
            ),
            E(
                "service_invocation_called_group_id",
                "serviceInvocationCalledGroupId",
                str,
            ),
            E(
                "redirecting_number",
                "redirectingNumber",
                str,
            ),
            E(
                "redirecting_name",
                "redirectingName",
                str,
            ),
            E(
                "redirecting_presentation_indicator",
                "redirectingPresentationIndicator",
                str,
            ),
            E(
                "redirecting_reason",
                "RedirectingReason",
                str,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
            E(
                "call_authorization_code",
                "callAuthorizationCode",
                str,
            ),
            E(
                "user_group_id",
                "userGroupId",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "user_primary_dn",
                "userPrimaryDn",
                str,
            ),
            E(
                "user_primary_extension",
                "userPrimaryExtension",
                str,
            ),
        )


class ExtendedMixedCallLogsEntry20(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode and not returned in XS data mode: callAuthorizationCode
    callSecurityClassification

    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode
        call_log_id (str): callLogId
        call_id (str): callId
        subscriber_type (str): subscriberType
        dialed_number (str): dialedNumber *Optional*
        called_number (str): calledNumber *Optional*
        network_translated_address (str): networkTranslatedAddress *Optional*
        calling_asserted_number (str): callingAssertedNumber *Optional*
        calling_presentation_number (str): callingPresentationNumber *Optional*
        calling_presentation_number_source (str): callingPresentationNumberSource
            *Optional*
        calling_presentation_name (str): callingPresentationName *Optional*
        calling_presentation_indicator (str): callingPresentationIndicator
        calling_group_id (str): callingGroupId *Optional*
        called_directory_name (str): calledDirectoryName *Optional*
        called_group_id (str): calledGroupId *Optional*
        connected_number (str): connectedNumber *Optional*
        connected_number_source (str): connectedNumberSource *Optional*
        connected_name (str): connectedName *Optional*
        connected_presentation_indicator (str): connectedPresentationIndicator *Optional*
        type_of_network (str): typeOfNetwork *Optional*
        call_category (str): callCategory *Optional*
        basic_call_type (str): basicCallType
        configurable_call_type (str): configurableCallType *Optional*
        alternate_call_indicator (str): alternateCallIndicator *Optional*
        virtual_on_net_call_type (str): virtualOnNetCallType *Optional*
        time (str): time
        start_time (int): startTime
        answer_time (int): answerTime *Optional*
        release_time (int): releaseTime *Optional*
        detached_time (int): detachedTime *Optional*
        detached_answer_time (int): detachedAnswerTime *Optional*
        outgoing_dnis (str): outgoingDnis *Optional*
        service_invocation_disposition (str): serviceInvocationDisposition *Optional*
        service_invocation_dialed_number (str): serviceInvocationDialedNumber *Optional*
        service_invocation_called_number (str): serviceInvocationCalledNumber *Optional*
        service_invocation_network_translated_address (str):
            serviceInvocationNetworkTranslatedAddress *Optional*
        service_invocation_type_of_network (str): serviceInvocationTypeOfNetwork
            *Optional*
        service_invocation_call_category (str): serviceInvocationCallCategory *Optional*
        service_invocation_basic_call_type (str): serviceInvocationBasicCallType
            *Optional*
        service_invocation_configurable_call_type (str):
            serviceInvocationConfigurableCallType *Optional*
        service_invocation_alternate_call_indicator (str):
            serviceInvocationAlternateCallIndicator *Optional*
        service_invocation_virtual_on_net_call_type (str):
            serviceInvocationVirtualOnNetCallType *Optional*
        service_invocation_called_directory_name (str):
            serviceInvocationCalledDirectoryName *Optional*
        service_invocation_called_group_id (str): serviceInvocationCalledGroupId
            *Optional*
        redirecting_number (str): redirectingNumber *Optional*
        redirecting_name (str): redirectingName *Optional*
        redirecting_presentation_indicator (str): redirectingPresentationIndicator
            *Optional*
        redirecting_reason (str): RedirectingReason *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
        call_authorization_code (str): callAuthorizationCode *Optional*
        user_group_id (str): userGroupId *Optional*
        user_id (str): userId *Optional*
        user_primary_dn (str): userPrimaryDn *Optional*
        user_primary_extension (str): userPrimaryExtension *Optional*
        security_classification (str): securityClassification *Optional*
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "call_id",
        "subscriber_type",
        "dialed_number",
        "called_number",
        "network_translated_address",
        "calling_asserted_number",
        "calling_presentation_number",
        "calling_presentation_number_source",
        "calling_presentation_name",
        "calling_presentation_indicator",
        "calling_group_id",
        "called_directory_name",
        "called_group_id",
        "connected_number",
        "connected_number_source",
        "connected_name",
        "connected_presentation_indicator",
        "type_of_network",
        "call_category",
        "basic_call_type",
        "configurable_call_type",
        "alternate_call_indicator",
        "virtual_on_net_call_type",
        "time",
        "start_time",
        "answer_time",
        "release_time",
        "detached_time",
        "detached_answer_time",
        "outgoing_dnis",
        "service_invocation_disposition",
        "service_invocation_dialed_number",
        "service_invocation_called_number",
        "service_invocation_network_translated_address",
        "service_invocation_type_of_network",
        "service_invocation_call_category",
        "service_invocation_basic_call_type",
        "service_invocation_configurable_call_type",
        "service_invocation_alternate_call_indicator",
        "service_invocation_virtual_on_net_call_type",
        "service_invocation_called_directory_name",
        "service_invocation_called_group_id",
        "redirecting_number",
        "redirecting_name",
        "redirecting_presentation_indicator",
        "redirecting_reason",
        "account_authorization_code",
        "call_authorization_code",
        "user_group_id",
        "user_id",
        "user_primary_dn",
        "user_primary_extension",
        "security_classification",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "call_id",
                "callId",
                str,
                is_required=True,
            ),
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
            ),
            E(
                "dialed_number",
                "dialedNumber",
                str,
            ),
            E(
                "called_number",
                "calledNumber",
                str,
            ),
            E(
                "network_translated_address",
                "networkTranslatedAddress",
                str,
            ),
            E(
                "calling_asserted_number",
                "callingAssertedNumber",
                str,
            ),
            E(
                "calling_presentation_number",
                "callingPresentationNumber",
                str,
            ),
            E(
                "calling_presentation_number_source",
                "callingPresentationNumberSource",
                str,
            ),
            E(
                "calling_presentation_name",
                "callingPresentationName",
                str,
            ),
            E(
                "calling_presentation_indicator",
                "callingPresentationIndicator",
                str,
                is_required=True,
            ),
            E(
                "calling_group_id",
                "callingGroupId",
                str,
            ),
            E(
                "called_directory_name",
                "calledDirectoryName",
                str,
            ),
            E(
                "called_group_id",
                "calledGroupId",
                str,
            ),
            E(
                "connected_number",
                "connectedNumber",
                str,
            ),
            E(
                "connected_number_source",
                "connectedNumberSource",
                str,
            ),
            E(
                "connected_name",
                "connectedName",
                str,
            ),
            E(
                "connected_presentation_indicator",
                "connectedPresentationIndicator",
                str,
            ),
            E(
                "type_of_network",
                "typeOfNetwork",
                str,
            ),
            E(
                "call_category",
                "callCategory",
                str,
            ),
            E(
                "basic_call_type",
                "basicCallType",
                str,
                is_required=True,
            ),
            E(
                "configurable_call_type",
                "configurableCallType",
                str,
            ),
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
            ),
            E(
                "virtual_on_net_call_type",
                "virtualOnNetCallType",
                str,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                int,
                is_required=True,
            ),
            E(
                "answer_time",
                "answerTime",
                int,
            ),
            E(
                "release_time",
                "releaseTime",
                int,
            ),
            E(
                "detached_time",
                "detachedTime",
                int,
            ),
            E(
                "detached_answer_time",
                "detachedAnswerTime",
                int,
            ),
            E(
                "outgoing_dnis",
                "outgoingDnis",
                str,
            ),
            E(
                "service_invocation_disposition",
                "serviceInvocationDisposition",
                str,
            ),
            E(
                "service_invocation_dialed_number",
                "serviceInvocationDialedNumber",
                str,
            ),
            E(
                "service_invocation_called_number",
                "serviceInvocationCalledNumber",
                str,
            ),
            E(
                "service_invocation_network_translated_address",
                "serviceInvocationNetworkTranslatedAddress",
                str,
            ),
            E(
                "service_invocation_type_of_network",
                "serviceInvocationTypeOfNetwork",
                str,
            ),
            E(
                "service_invocation_call_category",
                "serviceInvocationCallCategory",
                str,
            ),
            E(
                "service_invocation_basic_call_type",
                "serviceInvocationBasicCallType",
                str,
            ),
            E(
                "service_invocation_configurable_call_type",
                "serviceInvocationConfigurableCallType",
                str,
            ),
            E(
                "service_invocation_alternate_call_indicator",
                "serviceInvocationAlternateCallIndicator",
                str,
            ),
            E(
                "service_invocation_virtual_on_net_call_type",
                "serviceInvocationVirtualOnNetCallType",
                str,
            ),
            E(
                "service_invocation_called_directory_name",
                "serviceInvocationCalledDirectoryName",
                str,
            ),
            E(
                "service_invocation_called_group_id",
                "serviceInvocationCalledGroupId",
                str,
            ),
            E(
                "redirecting_number",
                "redirectingNumber",
                str,
            ),
            E(
                "redirecting_name",
                "redirectingName",
                str,
            ),
            E(
                "redirecting_presentation_indicator",
                "redirectingPresentationIndicator",
                str,
            ),
            E(
                "redirecting_reason",
                "RedirectingReason",
                str,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
            E(
                "call_authorization_code",
                "callAuthorizationCode",
                str,
            ),
            E(
                "user_group_id",
                "userGroupId",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "user_primary_dn",
                "userPrimaryDn",
                str,
            ),
            E(
                "user_primary_extension",
                "userPrimaryExtension",
                str,
            ),
            E(
                "security_classification",
                "securityClassification",
                str,
            ),
        )


class ExtendedMixedCallLogsEntry20sp1(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode callSecurityClassification

    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode
        call_log_id (str): callLogId
        call_id (str): callId
        subscriber_type (str): subscriberType
        dialed_number (str): dialedNumber *Optional*
        called_number (str): calledNumber *Optional*
        network_translated_address (str): networkTranslatedAddress *Optional*
        calling_asserted_number (str): callingAssertedNumber *Optional*
        calling_presentation_number (str): callingPresentationNumber *Optional*
        calling_presentation_number_source (str): callingPresentationNumberSource
            *Optional*
        calling_presentation_name (str): callingPresentationName *Optional*
        calling_presentation_indicator (str): callingPresentationIndicator
        calling_group_id (str): callingGroupId *Optional*
        called_directory_name (str): calledDirectoryName *Optional*
        called_group_id (str): calledGroupId *Optional*
        connected_number (str): connectedNumber *Optional*
        connected_number_source (str): connectedNumberSource *Optional*
        connected_name (str): connectedName *Optional*
        connected_presentation_indicator (str): connectedPresentationIndicator *Optional*
        type_of_network (str): typeOfNetwork *Optional*
        call_category (str): callCategory *Optional*
        basic_call_type (str): basicCallType
        configurable_call_type (str): configurableCallType *Optional*
        alternate_call_indicator (str): alternateCallIndicator *Optional*
        virtual_on_net_call_type (str): virtualOnNetCallType *Optional*
        time (str): time
        start_time (int): startTime
        answer_time (int): answerTime *Optional*
        release_time (int): releaseTime *Optional*
        detached_time (int): detachedTime *Optional*
        detached_answer_time (int): detachedAnswerTime *Optional*
        outgoing_dnis (str): outgoingDnis *Optional*
        service_invocation_disposition (str): serviceInvocationDisposition *Optional*
        service_invocation_dialed_number (str): serviceInvocationDialedNumber *Optional*
        service_invocation_called_number (str): serviceInvocationCalledNumber *Optional*
        service_invocation_network_translated_address (str):
            serviceInvocationNetworkTranslatedAddress *Optional*
        service_invocation_type_of_network (str): serviceInvocationTypeOfNetwork
            *Optional*
        service_invocation_call_category (str): serviceInvocationCallCategory *Optional*
        service_invocation_basic_call_type (str): serviceInvocationBasicCallType
            *Optional*
        service_invocation_configurable_call_type (str):
            serviceInvocationConfigurableCallType *Optional*
        service_invocation_alternate_call_indicator (str):
            serviceInvocationAlternateCallIndicator *Optional*
        service_invocation_virtual_on_net_call_type (str):
            serviceInvocationVirtualOnNetCallType *Optional*
        service_invocation_called_directory_name (str):
            serviceInvocationCalledDirectoryName *Optional*
        service_invocation_called_group_id (str): serviceInvocationCalledGroupId
            *Optional*
        redirecting_number (str): redirectingNumber *Optional*
        redirecting_name (str): redirectingName *Optional*
        redirecting_presentation_indicator (str): redirectingPresentationIndicator
            *Optional*
        redirecting_reason (str): RedirectingReason *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
        call_authorization_code (str): callAuthorizationCode *Optional*
        user_group_id (str): userGroupId *Optional*
        user_id (str): userId *Optional*
        user_primary_dn (str): userPrimaryDn *Optional*
        user_primary_extension (str): userPrimaryExtension *Optional*
        security_classification (str): securityClassification *Optional*
        direct_route_number (str): directRouteNumber *Optional*
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "call_id",
        "subscriber_type",
        "dialed_number",
        "called_number",
        "network_translated_address",
        "calling_asserted_number",
        "calling_presentation_number",
        "calling_presentation_number_source",
        "calling_presentation_name",
        "calling_presentation_indicator",
        "calling_group_id",
        "called_directory_name",
        "called_group_id",
        "connected_number",
        "connected_number_source",
        "connected_name",
        "connected_presentation_indicator",
        "type_of_network",
        "call_category",
        "basic_call_type",
        "configurable_call_type",
        "alternate_call_indicator",
        "virtual_on_net_call_type",
        "time",
        "start_time",
        "answer_time",
        "release_time",
        "detached_time",
        "detached_answer_time",
        "outgoing_dnis",
        "service_invocation_disposition",
        "service_invocation_dialed_number",
        "service_invocation_called_number",
        "service_invocation_network_translated_address",
        "service_invocation_type_of_network",
        "service_invocation_call_category",
        "service_invocation_basic_call_type",
        "service_invocation_configurable_call_type",
        "service_invocation_alternate_call_indicator",
        "service_invocation_virtual_on_net_call_type",
        "service_invocation_called_directory_name",
        "service_invocation_called_group_id",
        "redirecting_number",
        "redirecting_name",
        "redirecting_presentation_indicator",
        "redirecting_reason",
        "account_authorization_code",
        "call_authorization_code",
        "user_group_id",
        "user_id",
        "user_primary_dn",
        "user_primary_extension",
        "security_classification",
        "direct_route_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "call_id",
                "callId",
                str,
                is_required=True,
            ),
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
            ),
            E(
                "dialed_number",
                "dialedNumber",
                str,
            ),
            E(
                "called_number",
                "calledNumber",
                str,
            ),
            E(
                "network_translated_address",
                "networkTranslatedAddress",
                str,
            ),
            E(
                "calling_asserted_number",
                "callingAssertedNumber",
                str,
            ),
            E(
                "calling_presentation_number",
                "callingPresentationNumber",
                str,
            ),
            E(
                "calling_presentation_number_source",
                "callingPresentationNumberSource",
                str,
            ),
            E(
                "calling_presentation_name",
                "callingPresentationName",
                str,
            ),
            E(
                "calling_presentation_indicator",
                "callingPresentationIndicator",
                str,
                is_required=True,
            ),
            E(
                "calling_group_id",
                "callingGroupId",
                str,
            ),
            E(
                "called_directory_name",
                "calledDirectoryName",
                str,
            ),
            E(
                "called_group_id",
                "calledGroupId",
                str,
            ),
            E(
                "connected_number",
                "connectedNumber",
                str,
            ),
            E(
                "connected_number_source",
                "connectedNumberSource",
                str,
            ),
            E(
                "connected_name",
                "connectedName",
                str,
            ),
            E(
                "connected_presentation_indicator",
                "connectedPresentationIndicator",
                str,
            ),
            E(
                "type_of_network",
                "typeOfNetwork",
                str,
            ),
            E(
                "call_category",
                "callCategory",
                str,
            ),
            E(
                "basic_call_type",
                "basicCallType",
                str,
                is_required=True,
            ),
            E(
                "configurable_call_type",
                "configurableCallType",
                str,
            ),
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
            ),
            E(
                "virtual_on_net_call_type",
                "virtualOnNetCallType",
                str,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                int,
                is_required=True,
            ),
            E(
                "answer_time",
                "answerTime",
                int,
            ),
            E(
                "release_time",
                "releaseTime",
                int,
            ),
            E(
                "detached_time",
                "detachedTime",
                int,
            ),
            E(
                "detached_answer_time",
                "detachedAnswerTime",
                int,
            ),
            E(
                "outgoing_dnis",
                "outgoingDnis",
                str,
            ),
            E(
                "service_invocation_disposition",
                "serviceInvocationDisposition",
                str,
            ),
            E(
                "service_invocation_dialed_number",
                "serviceInvocationDialedNumber",
                str,
            ),
            E(
                "service_invocation_called_number",
                "serviceInvocationCalledNumber",
                str,
            ),
            E(
                "service_invocation_network_translated_address",
                "serviceInvocationNetworkTranslatedAddress",
                str,
            ),
            E(
                "service_invocation_type_of_network",
                "serviceInvocationTypeOfNetwork",
                str,
            ),
            E(
                "service_invocation_call_category",
                "serviceInvocationCallCategory",
                str,
            ),
            E(
                "service_invocation_basic_call_type",
                "serviceInvocationBasicCallType",
                str,
            ),
            E(
                "service_invocation_configurable_call_type",
                "serviceInvocationConfigurableCallType",
                str,
            ),
            E(
                "service_invocation_alternate_call_indicator",
                "serviceInvocationAlternateCallIndicator",
                str,
            ),
            E(
                "service_invocation_virtual_on_net_call_type",
                "serviceInvocationVirtualOnNetCallType",
                str,
            ),
            E(
                "service_invocation_called_directory_name",
                "serviceInvocationCalledDirectoryName",
                str,
            ),
            E(
                "service_invocation_called_group_id",
                "serviceInvocationCalledGroupId",
                str,
            ),
            E(
                "redirecting_number",
                "redirectingNumber",
                str,
            ),
            E(
                "redirecting_name",
                "redirectingName",
                str,
            ),
            E(
                "redirecting_presentation_indicator",
                "redirectingPresentationIndicator",
                str,
            ),
            E(
                "redirecting_reason",
                "RedirectingReason",
                str,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
            E(
                "call_authorization_code",
                "callAuthorizationCode",
                str,
            ),
            E(
                "user_group_id",
                "userGroupId",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "user_primary_dn",
                "userPrimaryDn",
                str,
            ),
            E(
                "user_primary_extension",
                "userPrimaryExtension",
                str,
            ),
            E(
                "security_classification",
                "securityClassification",
                str,
            ),
            E(
                "direct_route_number",
                "directRouteNumber",
                str,
            ),
        )


class ExtendedMixedCallLogsEntry21(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode and not returned in XS data mode: callAuthorizationCode
    securityClassification

    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode
        call_log_id (str): callLogId
        call_id (str): callId
        subscriber_type (str): subscriberType
        dialed_number (str): dialedNumber *Optional*
        called_number (str): calledNumber *Optional*
        network_translated_address (str): networkTranslatedAddress *Optional*
        calling_asserted_number (str): callingAssertedNumber *Optional*
        calling_presentation_number (str): callingPresentationNumber *Optional*
        calling_presentation_number_source (str): callingPresentationNumberSource
            *Optional*
        calling_presentation_name (str): callingPresentationName *Optional*
        calling_presentation_indicator (str): callingPresentationIndicator
        calling_group_id (str): callingGroupId *Optional*
        called_directory_name (str): calledDirectoryName *Optional*
        called_group_id (str): calledGroupId *Optional*
        connected_number (str): connectedNumber *Optional*
        connected_number_source (str): connectedNumberSource *Optional*
        connected_name (str): connectedName *Optional*
        connected_presentation_indicator (str): connectedPresentationIndicator *Optional*
        type_of_network (str): typeOfNetwork *Optional*
        call_category (str): callCategory *Optional*
        basic_call_type (str): basicCallType
        configurable_call_type (str): configurableCallType *Optional*
        alternate_call_indicator (str): alternateCallIndicator *Optional*
        virtual_on_net_call_type (str): virtualOnNetCallType *Optional*
        time (str): time
        start_time (int): startTime
        answer_time (int): answerTime *Optional*
        release_time (int): releaseTime *Optional*
        detached_time (int): detachedTime *Optional*
        detached_answer_time (int): detachedAnswerTime *Optional*
        outgoing_dnis (str): outgoingDnis *Optional*
        service_invocation_disposition (str): serviceInvocationDisposition *Optional*
        service_invocation_dialed_number (str): serviceInvocationDialedNumber *Optional*
        service_invocation_called_number (str): serviceInvocationCalledNumber *Optional*
        service_invocation_network_translated_address (str):
            serviceInvocationNetworkTranslatedAddress *Optional*
        service_invocation_type_of_network (str): serviceInvocationTypeOfNetwork
            *Optional*
        service_invocation_call_category (str): serviceInvocationCallCategory *Optional*
        service_invocation_basic_call_type (str): serviceInvocationBasicCallType
            *Optional*
        service_invocation_configurable_call_type (str):
            serviceInvocationConfigurableCallType *Optional*
        service_invocation_alternate_call_indicator (str):
            serviceInvocationAlternateCallIndicator *Optional*
        service_invocation_virtual_on_net_call_type (str):
            serviceInvocationVirtualOnNetCallType *Optional*
        service_invocation_called_directory_name (str):
            serviceInvocationCalledDirectoryName *Optional*
        service_invocation_called_group_id (str): serviceInvocationCalledGroupId
            *Optional*
        redirecting_number (str): redirectingNumber *Optional*
        redirecting_name (str): redirectingName *Optional*
        redirecting_presentation_indicator (str): redirectingPresentationIndicator
            *Optional*
        redirecting_reason (str): RedirectingReason *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
        call_authorization_code (str): callAuthorizationCode *Optional*
        user_group_id (str): userGroupId *Optional*
        user_id (str): userId *Optional*
        user_primary_dn (str): userPrimaryDn *Optional*
        user_primary_extension (str): userPrimaryExtension *Optional*
        security_classification (str): securityClassification *Optional*
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "call_id",
        "subscriber_type",
        "dialed_number",
        "called_number",
        "network_translated_address",
        "calling_asserted_number",
        "calling_presentation_number",
        "calling_presentation_number_source",
        "calling_presentation_name",
        "calling_presentation_indicator",
        "calling_group_id",
        "called_directory_name",
        "called_group_id",
        "connected_number",
        "connected_number_source",
        "connected_name",
        "connected_presentation_indicator",
        "type_of_network",
        "call_category",
        "basic_call_type",
        "configurable_call_type",
        "alternate_call_indicator",
        "virtual_on_net_call_type",
        "time",
        "start_time",
        "answer_time",
        "release_time",
        "detached_time",
        "detached_answer_time",
        "outgoing_dnis",
        "service_invocation_disposition",
        "service_invocation_dialed_number",
        "service_invocation_called_number",
        "service_invocation_network_translated_address",
        "service_invocation_type_of_network",
        "service_invocation_call_category",
        "service_invocation_basic_call_type",
        "service_invocation_configurable_call_type",
        "service_invocation_alternate_call_indicator",
        "service_invocation_virtual_on_net_call_type",
        "service_invocation_called_directory_name",
        "service_invocation_called_group_id",
        "redirecting_number",
        "redirecting_name",
        "redirecting_presentation_indicator",
        "redirecting_reason",
        "account_authorization_code",
        "call_authorization_code",
        "user_group_id",
        "user_id",
        "user_primary_dn",
        "user_primary_extension",
        "security_classification",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "call_id",
                "callId",
                str,
                is_required=True,
            ),
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
            ),
            E(
                "dialed_number",
                "dialedNumber",
                str,
            ),
            E(
                "called_number",
                "calledNumber",
                str,
            ),
            E(
                "network_translated_address",
                "networkTranslatedAddress",
                str,
            ),
            E(
                "calling_asserted_number",
                "callingAssertedNumber",
                str,
            ),
            E(
                "calling_presentation_number",
                "callingPresentationNumber",
                str,
            ),
            E(
                "calling_presentation_number_source",
                "callingPresentationNumberSource",
                str,
            ),
            E(
                "calling_presentation_name",
                "callingPresentationName",
                str,
            ),
            E(
                "calling_presentation_indicator",
                "callingPresentationIndicator",
                str,
                is_required=True,
            ),
            E(
                "calling_group_id",
                "callingGroupId",
                str,
            ),
            E(
                "called_directory_name",
                "calledDirectoryName",
                str,
            ),
            E(
                "called_group_id",
                "calledGroupId",
                str,
            ),
            E(
                "connected_number",
                "connectedNumber",
                str,
            ),
            E(
                "connected_number_source",
                "connectedNumberSource",
                str,
            ),
            E(
                "connected_name",
                "connectedName",
                str,
            ),
            E(
                "connected_presentation_indicator",
                "connectedPresentationIndicator",
                str,
            ),
            E(
                "type_of_network",
                "typeOfNetwork",
                str,
            ),
            E(
                "call_category",
                "callCategory",
                str,
            ),
            E(
                "basic_call_type",
                "basicCallType",
                str,
                is_required=True,
            ),
            E(
                "configurable_call_type",
                "configurableCallType",
                str,
            ),
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
            ),
            E(
                "virtual_on_net_call_type",
                "virtualOnNetCallType",
                str,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                int,
                is_required=True,
            ),
            E(
                "answer_time",
                "answerTime",
                int,
            ),
            E(
                "release_time",
                "releaseTime",
                int,
            ),
            E(
                "detached_time",
                "detachedTime",
                int,
            ),
            E(
                "detached_answer_time",
                "detachedAnswerTime",
                int,
            ),
            E(
                "outgoing_dnis",
                "outgoingDnis",
                str,
            ),
            E(
                "service_invocation_disposition",
                "serviceInvocationDisposition",
                str,
            ),
            E(
                "service_invocation_dialed_number",
                "serviceInvocationDialedNumber",
                str,
            ),
            E(
                "service_invocation_called_number",
                "serviceInvocationCalledNumber",
                str,
            ),
            E(
                "service_invocation_network_translated_address",
                "serviceInvocationNetworkTranslatedAddress",
                str,
            ),
            E(
                "service_invocation_type_of_network",
                "serviceInvocationTypeOfNetwork",
                str,
            ),
            E(
                "service_invocation_call_category",
                "serviceInvocationCallCategory",
                str,
            ),
            E(
                "service_invocation_basic_call_type",
                "serviceInvocationBasicCallType",
                str,
            ),
            E(
                "service_invocation_configurable_call_type",
                "serviceInvocationConfigurableCallType",
                str,
            ),
            E(
                "service_invocation_alternate_call_indicator",
                "serviceInvocationAlternateCallIndicator",
                str,
            ),
            E(
                "service_invocation_virtual_on_net_call_type",
                "serviceInvocationVirtualOnNetCallType",
                str,
            ),
            E(
                "service_invocation_called_directory_name",
                "serviceInvocationCalledDirectoryName",
                str,
            ),
            E(
                "service_invocation_called_group_id",
                "serviceInvocationCalledGroupId",
                str,
            ),
            E(
                "redirecting_number",
                "redirectingNumber",
                str,
            ),
            E(
                "redirecting_name",
                "redirectingName",
                str,
            ),
            E(
                "redirecting_presentation_indicator",
                "redirectingPresentationIndicator",
                str,
            ),
            E(
                "redirecting_reason",
                "RedirectingReason",
                str,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
            E(
                "call_authorization_code",
                "callAuthorizationCode",
                str,
            ),
            E(
                "user_group_id",
                "userGroupId",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "user_primary_dn",
                "userPrimaryDn",
                str,
            ),
            E(
                "user_primary_extension",
                "userPrimaryExtension",
                str,
            ),
            E(
                "security_classification",
                "securityClassification",
                str,
            ),
        )


class ExtendedMixedCallLogsEntry21sp1(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode securityClassification
    ExtendedMixedCallLogsEntry21sp1 version: only the ServiceInvocationDisposition21sp1
    name changed.

    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode
        call_log_id (str): callLogId
        call_id (str): callId
        subscriber_type (str): subscriberType
        dialed_number (str): dialedNumber *Optional*
        called_number (str): calledNumber *Optional*
        network_translated_address (str): networkTranslatedAddress *Optional*
        calling_asserted_number (str): callingAssertedNumber *Optional*
        calling_presentation_number (str): callingPresentationNumber *Optional*
        calling_presentation_number_source (str): callingPresentationNumberSource
            *Optional*
        calling_presentation_name (str): callingPresentationName *Optional*
        calling_presentation_indicator (str): callingPresentationIndicator
        calling_group_id (str): callingGroupId *Optional*
        called_directory_name (str): calledDirectoryName *Optional*
        called_group_id (str): calledGroupId *Optional*
        connected_number (str): connectedNumber *Optional*
        connected_number_source (str): connectedNumberSource *Optional*
        connected_name (str): connectedName *Optional*
        connected_presentation_indicator (str): connectedPresentationIndicator *Optional*
        type_of_network (str): typeOfNetwork *Optional*
        call_category (str): callCategory *Optional*
        basic_call_type (str): basicCallType
        configurable_call_type (str): configurableCallType *Optional*
        alternate_call_indicator (str): alternateCallIndicator *Optional*
        virtual_on_net_call_type (str): virtualOnNetCallType *Optional*
        time (str): time
        start_time (int): startTime
        answer_time (int): answerTime *Optional*
        release_time (int): releaseTime *Optional*
        detached_time (int): detachedTime *Optional*
        detached_answer_time (int): detachedAnswerTime *Optional*
        outgoing_dnis (str): outgoingDnis *Optional*
        service_invocation_disposition (str): serviceInvocationDisposition *Optional*
        service_invocation_dialed_number (str): serviceInvocationDialedNumber *Optional*
        service_invocation_called_number (str): serviceInvocationCalledNumber *Optional*
        service_invocation_network_translated_address (str):
            serviceInvocationNetworkTranslatedAddress *Optional*
        service_invocation_type_of_network (str): serviceInvocationTypeOfNetwork
            *Optional*
        service_invocation_call_category (str): serviceInvocationCallCategory *Optional*
        service_invocation_basic_call_type (str): serviceInvocationBasicCallType
            *Optional*
        service_invocation_configurable_call_type (str):
            serviceInvocationConfigurableCallType *Optional*
        service_invocation_alternate_call_indicator (str):
            serviceInvocationAlternateCallIndicator *Optional*
        service_invocation_virtual_on_net_call_type (str):
            serviceInvocationVirtualOnNetCallType *Optional*
        service_invocation_called_directory_name (str):
            serviceInvocationCalledDirectoryName *Optional*
        service_invocation_called_group_id (str): serviceInvocationCalledGroupId
            *Optional*
        redirecting_number (str): redirectingNumber *Optional*
        redirecting_name (str): redirectingName *Optional*
        redirecting_presentation_indicator (str): redirectingPresentationIndicator
            *Optional*
        redirecting_reason (str): RedirectingReason *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
        call_authorization_code (str): callAuthorizationCode *Optional*
        user_group_id (str): userGroupId *Optional*
        user_id (str): userId *Optional*
        user_primary_dn (str): userPrimaryDn *Optional*
        user_primary_extension (str): userPrimaryExtension *Optional*
        security_classification (str): securityClassification *Optional*
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "call_id",
        "subscriber_type",
        "dialed_number",
        "called_number",
        "network_translated_address",
        "calling_asserted_number",
        "calling_presentation_number",
        "calling_presentation_number_source",
        "calling_presentation_name",
        "calling_presentation_indicator",
        "calling_group_id",
        "called_directory_name",
        "called_group_id",
        "connected_number",
        "connected_number_source",
        "connected_name",
        "connected_presentation_indicator",
        "type_of_network",
        "call_category",
        "basic_call_type",
        "configurable_call_type",
        "alternate_call_indicator",
        "virtual_on_net_call_type",
        "time",
        "start_time",
        "answer_time",
        "release_time",
        "detached_time",
        "detached_answer_time",
        "outgoing_dnis",
        "service_invocation_disposition",
        "service_invocation_dialed_number",
        "service_invocation_called_number",
        "service_invocation_network_translated_address",
        "service_invocation_type_of_network",
        "service_invocation_call_category",
        "service_invocation_basic_call_type",
        "service_invocation_configurable_call_type",
        "service_invocation_alternate_call_indicator",
        "service_invocation_virtual_on_net_call_type",
        "service_invocation_called_directory_name",
        "service_invocation_called_group_id",
        "redirecting_number",
        "redirecting_name",
        "redirecting_presentation_indicator",
        "redirecting_reason",
        "account_authorization_code",
        "call_authorization_code",
        "user_group_id",
        "user_id",
        "user_primary_dn",
        "user_primary_extension",
        "security_classification",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "call_id",
                "callId",
                str,
                is_required=True,
            ),
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
            ),
            E(
                "dialed_number",
                "dialedNumber",
                str,
            ),
            E(
                "called_number",
                "calledNumber",
                str,
            ),
            E(
                "network_translated_address",
                "networkTranslatedAddress",
                str,
            ),
            E(
                "calling_asserted_number",
                "callingAssertedNumber",
                str,
            ),
            E(
                "calling_presentation_number",
                "callingPresentationNumber",
                str,
            ),
            E(
                "calling_presentation_number_source",
                "callingPresentationNumberSource",
                str,
            ),
            E(
                "calling_presentation_name",
                "callingPresentationName",
                str,
            ),
            E(
                "calling_presentation_indicator",
                "callingPresentationIndicator",
                str,
                is_required=True,
            ),
            E(
                "calling_group_id",
                "callingGroupId",
                str,
            ),
            E(
                "called_directory_name",
                "calledDirectoryName",
                str,
            ),
            E(
                "called_group_id",
                "calledGroupId",
                str,
            ),
            E(
                "connected_number",
                "connectedNumber",
                str,
            ),
            E(
                "connected_number_source",
                "connectedNumberSource",
                str,
            ),
            E(
                "connected_name",
                "connectedName",
                str,
            ),
            E(
                "connected_presentation_indicator",
                "connectedPresentationIndicator",
                str,
            ),
            E(
                "type_of_network",
                "typeOfNetwork",
                str,
            ),
            E(
                "call_category",
                "callCategory",
                str,
            ),
            E(
                "basic_call_type",
                "basicCallType",
                str,
                is_required=True,
            ),
            E(
                "configurable_call_type",
                "configurableCallType",
                str,
            ),
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
            ),
            E(
                "virtual_on_net_call_type",
                "virtualOnNetCallType",
                str,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                int,
                is_required=True,
            ),
            E(
                "answer_time",
                "answerTime",
                int,
            ),
            E(
                "release_time",
                "releaseTime",
                int,
            ),
            E(
                "detached_time",
                "detachedTime",
                int,
            ),
            E(
                "detached_answer_time",
                "detachedAnswerTime",
                int,
            ),
            E(
                "outgoing_dnis",
                "outgoingDnis",
                str,
            ),
            E(
                "service_invocation_disposition",
                "serviceInvocationDisposition",
                str,
            ),
            E(
                "service_invocation_dialed_number",
                "serviceInvocationDialedNumber",
                str,
            ),
            E(
                "service_invocation_called_number",
                "serviceInvocationCalledNumber",
                str,
            ),
            E(
                "service_invocation_network_translated_address",
                "serviceInvocationNetworkTranslatedAddress",
                str,
            ),
            E(
                "service_invocation_type_of_network",
                "serviceInvocationTypeOfNetwork",
                str,
            ),
            E(
                "service_invocation_call_category",
                "serviceInvocationCallCategory",
                str,
            ),
            E(
                "service_invocation_basic_call_type",
                "serviceInvocationBasicCallType",
                str,
            ),
            E(
                "service_invocation_configurable_call_type",
                "serviceInvocationConfigurableCallType",
                str,
            ),
            E(
                "service_invocation_alternate_call_indicator",
                "serviceInvocationAlternateCallIndicator",
                str,
            ),
            E(
                "service_invocation_virtual_on_net_call_type",
                "serviceInvocationVirtualOnNetCallType",
                str,
            ),
            E(
                "service_invocation_called_directory_name",
                "serviceInvocationCalledDirectoryName",
                str,
            ),
            E(
                "service_invocation_called_group_id",
                "serviceInvocationCalledGroupId",
                str,
            ),
            E(
                "redirecting_number",
                "redirectingNumber",
                str,
            ),
            E(
                "redirecting_name",
                "redirectingName",
                str,
            ),
            E(
                "redirecting_presentation_indicator",
                "redirectingPresentationIndicator",
                str,
            ),
            E(
                "redirecting_reason",
                "RedirectingReason",
                str,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
            E(
                "call_authorization_code",
                "callAuthorizationCode",
                str,
            ),
            E(
                "user_group_id",
                "userGroupId",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "user_primary_dn",
                "userPrimaryDn",
                str,
            ),
            E(
                "user_primary_extension",
                "userPrimaryExtension",
                str,
            ),
            E(
                "security_classification",
                "securityClassification",
                str,
            ),
        )


class ExtendedMixedCallLogsEntry21sp1V2(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode securityClassification
    ExtendedMixedCallLogsEntry21sp1 version: only the ServiceInvocationDisposition21sp1
    name changed.

    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode
        call_log_id (str): callLogId
        call_id (str): callId
        subscriber_type (str): subscriberType
        dialed_number (str): dialedNumber *Optional*
        called_number (str): calledNumber *Optional*
        network_translated_address (str): networkTranslatedAddress *Optional*
        calling_asserted_number (str): callingAssertedNumber *Optional*
        calling_presentation_number (str): callingPresentationNumber *Optional*
        calling_presentation_number_source (str): callingPresentationNumberSource
            *Optional*
        calling_presentation_name (str): callingPresentationName *Optional*
        calling_presentation_indicator (str): callingPresentationIndicator
        calling_group_id (str): callingGroupId *Optional*
        called_directory_name (str): calledDirectoryName *Optional*
        called_group_id (str): calledGroupId *Optional*
        connected_number (str): connectedNumber *Optional*
        connected_number_source (str): connectedNumberSource *Optional*
        connected_name (str): connectedName *Optional*
        connected_presentation_indicator (str): connectedPresentationIndicator *Optional*
        type_of_network (str): typeOfNetwork *Optional*
        call_category (str): callCategory *Optional*
        basic_call_type (str): basicCallType
        configurable_call_type (str): configurableCallType *Optional*
        alternate_call_indicator (str): alternateCallIndicator *Optional*
        virtual_on_net_call_type (str): virtualOnNetCallType *Optional*
        time (str): time
        start_time (int): startTime
        answer_time (int): answerTime *Optional*
        release_time (int): releaseTime *Optional*
        detached_time (int): detachedTime *Optional*
        detached_answer_time (int): detachedAnswerTime *Optional*
        outgoing_dnis (str): outgoingDnis *Optional*
        service_invocation_disposition (str): serviceInvocationDisposition *Optional*
        service_invocation_dialed_number (str): serviceInvocationDialedNumber *Optional*
        service_invocation_called_number (str): serviceInvocationCalledNumber *Optional*
        service_invocation_network_translated_address (str):
            serviceInvocationNetworkTranslatedAddress *Optional*
        service_invocation_type_of_network (str): serviceInvocationTypeOfNetwork
            *Optional*
        service_invocation_call_category (str): serviceInvocationCallCategory *Optional*
        service_invocation_basic_call_type (str): serviceInvocationBasicCallType
            *Optional*
        service_invocation_configurable_call_type (str):
            serviceInvocationConfigurableCallType *Optional*
        service_invocation_alternate_call_indicator (str):
            serviceInvocationAlternateCallIndicator *Optional*
        service_invocation_virtual_on_net_call_type (str):
            serviceInvocationVirtualOnNetCallType *Optional*
        service_invocation_called_directory_name (str):
            serviceInvocationCalledDirectoryName *Optional*
        service_invocation_called_group_id (str): serviceInvocationCalledGroupId
            *Optional*
        redirecting_number (str): redirectingNumber *Optional*
        redirecting_name (str): redirectingName *Optional*
        redirecting_presentation_indicator (str): redirectingPresentationIndicator
            *Optional*
        redirecting_reason (str): RedirectingReason *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
        call_authorization_code (str): callAuthorizationCode *Optional*
        user_group_id (str): userGroupId *Optional*
        user_id (str): userId *Optional*
        user_primary_dn (str): userPrimaryDn *Optional*
        user_primary_extension (str): userPrimaryExtension *Optional*
        security_classification (str): securityClassification *Optional*
        direct_route_number (str): directRouteNumber *Optional*
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "call_id",
        "subscriber_type",
        "dialed_number",
        "called_number",
        "network_translated_address",
        "calling_asserted_number",
        "calling_presentation_number",
        "calling_presentation_number_source",
        "calling_presentation_name",
        "calling_presentation_indicator",
        "calling_group_id",
        "called_directory_name",
        "called_group_id",
        "connected_number",
        "connected_number_source",
        "connected_name",
        "connected_presentation_indicator",
        "type_of_network",
        "call_category",
        "basic_call_type",
        "configurable_call_type",
        "alternate_call_indicator",
        "virtual_on_net_call_type",
        "time",
        "start_time",
        "answer_time",
        "release_time",
        "detached_time",
        "detached_answer_time",
        "outgoing_dnis",
        "service_invocation_disposition",
        "service_invocation_dialed_number",
        "service_invocation_called_number",
        "service_invocation_network_translated_address",
        "service_invocation_type_of_network",
        "service_invocation_call_category",
        "service_invocation_basic_call_type",
        "service_invocation_configurable_call_type",
        "service_invocation_alternate_call_indicator",
        "service_invocation_virtual_on_net_call_type",
        "service_invocation_called_directory_name",
        "service_invocation_called_group_id",
        "redirecting_number",
        "redirecting_name",
        "redirecting_presentation_indicator",
        "redirecting_reason",
        "account_authorization_code",
        "call_authorization_code",
        "user_group_id",
        "user_id",
        "user_primary_dn",
        "user_primary_extension",
        "security_classification",
        "direct_route_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "call_id",
                "callId",
                str,
                is_required=True,
            ),
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
            ),
            E(
                "dialed_number",
                "dialedNumber",
                str,
            ),
            E(
                "called_number",
                "calledNumber",
                str,
            ),
            E(
                "network_translated_address",
                "networkTranslatedAddress",
                str,
            ),
            E(
                "calling_asserted_number",
                "callingAssertedNumber",
                str,
            ),
            E(
                "calling_presentation_number",
                "callingPresentationNumber",
                str,
            ),
            E(
                "calling_presentation_number_source",
                "callingPresentationNumberSource",
                str,
            ),
            E(
                "calling_presentation_name",
                "callingPresentationName",
                str,
            ),
            E(
                "calling_presentation_indicator",
                "callingPresentationIndicator",
                str,
                is_required=True,
            ),
            E(
                "calling_group_id",
                "callingGroupId",
                str,
            ),
            E(
                "called_directory_name",
                "calledDirectoryName",
                str,
            ),
            E(
                "called_group_id",
                "calledGroupId",
                str,
            ),
            E(
                "connected_number",
                "connectedNumber",
                str,
            ),
            E(
                "connected_number_source",
                "connectedNumberSource",
                str,
            ),
            E(
                "connected_name",
                "connectedName",
                str,
            ),
            E(
                "connected_presentation_indicator",
                "connectedPresentationIndicator",
                str,
            ),
            E(
                "type_of_network",
                "typeOfNetwork",
                str,
            ),
            E(
                "call_category",
                "callCategory",
                str,
            ),
            E(
                "basic_call_type",
                "basicCallType",
                str,
                is_required=True,
            ),
            E(
                "configurable_call_type",
                "configurableCallType",
                str,
            ),
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
            ),
            E(
                "virtual_on_net_call_type",
                "virtualOnNetCallType",
                str,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                int,
                is_required=True,
            ),
            E(
                "answer_time",
                "answerTime",
                int,
            ),
            E(
                "release_time",
                "releaseTime",
                int,
            ),
            E(
                "detached_time",
                "detachedTime",
                int,
            ),
            E(
                "detached_answer_time",
                "detachedAnswerTime",
                int,
            ),
            E(
                "outgoing_dnis",
                "outgoingDnis",
                str,
            ),
            E(
                "service_invocation_disposition",
                "serviceInvocationDisposition",
                str,
            ),
            E(
                "service_invocation_dialed_number",
                "serviceInvocationDialedNumber",
                str,
            ),
            E(
                "service_invocation_called_number",
                "serviceInvocationCalledNumber",
                str,
            ),
            E(
                "service_invocation_network_translated_address",
                "serviceInvocationNetworkTranslatedAddress",
                str,
            ),
            E(
                "service_invocation_type_of_network",
                "serviceInvocationTypeOfNetwork",
                str,
            ),
            E(
                "service_invocation_call_category",
                "serviceInvocationCallCategory",
                str,
            ),
            E(
                "service_invocation_basic_call_type",
                "serviceInvocationBasicCallType",
                str,
            ),
            E(
                "service_invocation_configurable_call_type",
                "serviceInvocationConfigurableCallType",
                str,
            ),
            E(
                "service_invocation_alternate_call_indicator",
                "serviceInvocationAlternateCallIndicator",
                str,
            ),
            E(
                "service_invocation_virtual_on_net_call_type",
                "serviceInvocationVirtualOnNetCallType",
                str,
            ),
            E(
                "service_invocation_called_directory_name",
                "serviceInvocationCalledDirectoryName",
                str,
            ),
            E(
                "service_invocation_called_group_id",
                "serviceInvocationCalledGroupId",
                str,
            ),
            E(
                "redirecting_number",
                "redirectingNumber",
                str,
            ),
            E(
                "redirecting_name",
                "redirectingName",
                str,
            ),
            E(
                "redirecting_presentation_indicator",
                "redirectingPresentationIndicator",
                str,
            ),
            E(
                "redirecting_reason",
                "RedirectingReason",
                str,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
            E(
                "call_authorization_code",
                "callAuthorizationCode",
                str,
            ),
            E(
                "user_group_id",
                "userGroupId",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "user_primary_dn",
                "userPrimaryDn",
                str,
            ),
            E(
                "user_primary_extension",
                "userPrimaryExtension",
                str,
            ),
            E(
                "security_classification",
                "securityClassification",
                str,
            ),
            E(
                "direct_route_number",
                "directRouteNumber",
                str,
            ),
        )


class ExtendedMixedCallLogsEntry22(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode securityClassification
    ExtendedMixedCallLogsEntry21sp1 version: only the ServiceInvocationDisposition21sp1
    name changed.

    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode
        call_log_id (str): callLogId
        call_id (str): callId
        subscriber_type (str): subscriberType
        dialed_number (str): dialedNumber *Optional*
        called_number (str): calledNumber *Optional*
        network_translated_address (str): networkTranslatedAddress *Optional*
        calling_asserted_number (str): callingAssertedNumber *Optional*
        calling_presentation_number (str): callingPresentationNumber *Optional*
        calling_presentation_number_source (str): callingPresentationNumberSource
            *Optional*
        calling_presentation_name (str): callingPresentationName *Optional*
        calling_presentation_indicator (str): callingPresentationIndicator
        calling_group_id (str): callingGroupId *Optional*
        called_directory_name (str): calledDirectoryName *Optional*
        called_group_id (str): calledGroupId *Optional*
        connected_number (str): connectedNumber *Optional*
        connected_number_source (str): connectedNumberSource *Optional*
        connected_name (str): connectedName *Optional*
        connected_presentation_indicator (str): connectedPresentationIndicator *Optional*
        type_of_network (str): typeOfNetwork *Optional*
        call_category (str): callCategory *Optional*
        basic_call_type (str): basicCallType
        configurable_call_type (str): configurableCallType *Optional*
        alternate_call_indicator (str): alternateCallIndicator *Optional*
        virtual_on_net_call_type (str): virtualOnNetCallType *Optional*
        time (str): time
        start_time (int): startTime
        answer_time (int): answerTime *Optional*
        release_time (int): releaseTime *Optional*
        detached_time (int): detachedTime *Optional*
        detached_answer_time (int): detachedAnswerTime *Optional*
        outgoing_dnis (str): outgoingDnis *Optional*
        service_invocation_disposition (str): serviceInvocationDisposition *Optional*
        service_invocation_dialed_number (str): serviceInvocationDialedNumber *Optional*
        service_invocation_called_number (str): serviceInvocationCalledNumber *Optional*
        service_invocation_network_translated_address (str):
            serviceInvocationNetworkTranslatedAddress *Optional*
        service_invocation_type_of_network (str): serviceInvocationTypeOfNetwork
            *Optional*
        service_invocation_call_category (str): serviceInvocationCallCategory *Optional*
        service_invocation_basic_call_type (str): serviceInvocationBasicCallType
            *Optional*
        service_invocation_configurable_call_type (str):
            serviceInvocationConfigurableCallType *Optional*
        service_invocation_alternate_call_indicator (str):
            serviceInvocationAlternateCallIndicator *Optional*
        service_invocation_virtual_on_net_call_type (str):
            serviceInvocationVirtualOnNetCallType *Optional*
        service_invocation_called_directory_name (str):
            serviceInvocationCalledDirectoryName *Optional*
        service_invocation_called_group_id (str): serviceInvocationCalledGroupId
            *Optional*
        redirecting_number (str): redirectingNumber *Optional*
        redirecting_name (str): redirectingName *Optional*
        redirecting_presentation_indicator (str): redirectingPresentationIndicator
            *Optional*
        redirecting_reason (str): RedirectingReason *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
        call_authorization_code (str): callAuthorizationCode *Optional*
        user_group_id (str): userGroupId *Optional*
        user_id (str): userId *Optional*
        user_primary_dn (str): userPrimaryDn *Optional*
        user_primary_extension (str): userPrimaryExtension *Optional*
        security_classification (str): securityClassification *Optional*
        direct_route_number (str): directRouteNumber *Optional*
        route_list_dn (str): routeListDN *Optional*
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "call_id",
        "subscriber_type",
        "dialed_number",
        "called_number",
        "network_translated_address",
        "calling_asserted_number",
        "calling_presentation_number",
        "calling_presentation_number_source",
        "calling_presentation_name",
        "calling_presentation_indicator",
        "calling_group_id",
        "called_directory_name",
        "called_group_id",
        "connected_number",
        "connected_number_source",
        "connected_name",
        "connected_presentation_indicator",
        "type_of_network",
        "call_category",
        "basic_call_type",
        "configurable_call_type",
        "alternate_call_indicator",
        "virtual_on_net_call_type",
        "time",
        "start_time",
        "answer_time",
        "release_time",
        "detached_time",
        "detached_answer_time",
        "outgoing_dnis",
        "service_invocation_disposition",
        "service_invocation_dialed_number",
        "service_invocation_called_number",
        "service_invocation_network_translated_address",
        "service_invocation_type_of_network",
        "service_invocation_call_category",
        "service_invocation_basic_call_type",
        "service_invocation_configurable_call_type",
        "service_invocation_alternate_call_indicator",
        "service_invocation_virtual_on_net_call_type",
        "service_invocation_called_directory_name",
        "service_invocation_called_group_id",
        "redirecting_number",
        "redirecting_name",
        "redirecting_presentation_indicator",
        "redirecting_reason",
        "account_authorization_code",
        "call_authorization_code",
        "user_group_id",
        "user_id",
        "user_primary_dn",
        "user_primary_extension",
        "security_classification",
        "direct_route_number",
        "route_list_dn",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "call_id",
                "callId",
                str,
                is_required=True,
            ),
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
            ),
            E(
                "dialed_number",
                "dialedNumber",
                str,
            ),
            E(
                "called_number",
                "calledNumber",
                str,
            ),
            E(
                "network_translated_address",
                "networkTranslatedAddress",
                str,
            ),
            E(
                "calling_asserted_number",
                "callingAssertedNumber",
                str,
            ),
            E(
                "calling_presentation_number",
                "callingPresentationNumber",
                str,
            ),
            E(
                "calling_presentation_number_source",
                "callingPresentationNumberSource",
                str,
            ),
            E(
                "calling_presentation_name",
                "callingPresentationName",
                str,
            ),
            E(
                "calling_presentation_indicator",
                "callingPresentationIndicator",
                str,
                is_required=True,
            ),
            E(
                "calling_group_id",
                "callingGroupId",
                str,
            ),
            E(
                "called_directory_name",
                "calledDirectoryName",
                str,
            ),
            E(
                "called_group_id",
                "calledGroupId",
                str,
            ),
            E(
                "connected_number",
                "connectedNumber",
                str,
            ),
            E(
                "connected_number_source",
                "connectedNumberSource",
                str,
            ),
            E(
                "connected_name",
                "connectedName",
                str,
            ),
            E(
                "connected_presentation_indicator",
                "connectedPresentationIndicator",
                str,
            ),
            E(
                "type_of_network",
                "typeOfNetwork",
                str,
            ),
            E(
                "call_category",
                "callCategory",
                str,
            ),
            E(
                "basic_call_type",
                "basicCallType",
                str,
                is_required=True,
            ),
            E(
                "configurable_call_type",
                "configurableCallType",
                str,
            ),
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
            ),
            E(
                "virtual_on_net_call_type",
                "virtualOnNetCallType",
                str,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                int,
                is_required=True,
            ),
            E(
                "answer_time",
                "answerTime",
                int,
            ),
            E(
                "release_time",
                "releaseTime",
                int,
            ),
            E(
                "detached_time",
                "detachedTime",
                int,
            ),
            E(
                "detached_answer_time",
                "detachedAnswerTime",
                int,
            ),
            E(
                "outgoing_dnis",
                "outgoingDnis",
                str,
            ),
            E(
                "service_invocation_disposition",
                "serviceInvocationDisposition",
                str,
            ),
            E(
                "service_invocation_dialed_number",
                "serviceInvocationDialedNumber",
                str,
            ),
            E(
                "service_invocation_called_number",
                "serviceInvocationCalledNumber",
                str,
            ),
            E(
                "service_invocation_network_translated_address",
                "serviceInvocationNetworkTranslatedAddress",
                str,
            ),
            E(
                "service_invocation_type_of_network",
                "serviceInvocationTypeOfNetwork",
                str,
            ),
            E(
                "service_invocation_call_category",
                "serviceInvocationCallCategory",
                str,
            ),
            E(
                "service_invocation_basic_call_type",
                "serviceInvocationBasicCallType",
                str,
            ),
            E(
                "service_invocation_configurable_call_type",
                "serviceInvocationConfigurableCallType",
                str,
            ),
            E(
                "service_invocation_alternate_call_indicator",
                "serviceInvocationAlternateCallIndicator",
                str,
            ),
            E(
                "service_invocation_virtual_on_net_call_type",
                "serviceInvocationVirtualOnNetCallType",
                str,
            ),
            E(
                "service_invocation_called_directory_name",
                "serviceInvocationCalledDirectoryName",
                str,
            ),
            E(
                "service_invocation_called_group_id",
                "serviceInvocationCalledGroupId",
                str,
            ),
            E(
                "redirecting_number",
                "redirectingNumber",
                str,
            ),
            E(
                "redirecting_name",
                "redirectingName",
                str,
            ),
            E(
                "redirecting_presentation_indicator",
                "redirectingPresentationIndicator",
                str,
            ),
            E(
                "redirecting_reason",
                "RedirectingReason",
                str,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
            E(
                "call_authorization_code",
                "callAuthorizationCode",
                str,
            ),
            E(
                "user_group_id",
                "userGroupId",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "user_primary_dn",
                "userPrimaryDn",
                str,
            ),
            E(
                "user_primary_extension",
                "userPrimaryExtension",
                str,
            ),
            E(
                "security_classification",
                "securityClassification",
                str,
            ),
            E(
                "direct_route_number",
                "directRouteNumber",
                str,
            ),
            E(
                "route_list_dn",
                "routeListDN",
                str,
            ),
        )


class ExtendedMixedCallLogsEntry23(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.

    "countryCode" is the user's country code The following time elements are represented
    as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation message
    (e.g.  for placed calls) or receives a call invitation message (e.g.  for
    missed/received calls). "answerTime" represents the time when the call is answered by
    the terminating party.  "detachedTime" represents the time when the call is
    successfully redirected by the system.  "releaseTime" represents the time when the
    call is released.  This time corresponds to the moment the call is released by the
    system, and not necessarily when one party hangs up, since this does not always mean
    the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
    "userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
    enterprise or group level requests are used.  The following elements are only used in
    AS data mode: callAuthorizationCode securityClassification
    ExtendedMixedCallLogsEntry21sp1 version: only the ServiceInvocationDisposition21sp1
    name changed.

    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode
        call_log_id (str): callLogId
        call_id (str): callId
        subscriber_type (str): subscriberType
        dialed_number (str): dialedNumber *Optional*
        called_number (str): calledNumber *Optional*
        network_translated_address (str): networkTranslatedAddress *Optional*
        calling_asserted_number (str): callingAssertedNumber *Optional*
        calling_presentation_number (str): callingPresentationNumber *Optional*
        calling_presentation_number_source (str): callingPresentationNumberSource
            *Optional*
        calling_presentation_name (str): callingPresentationName *Optional*
        calling_presentation_indicator (str): callingPresentationIndicator
        calling_group_id (str): callingGroupId *Optional*
        called_directory_name (str): calledDirectoryName *Optional*
        called_group_id (str): calledGroupId *Optional*
        connected_number (str): connectedNumber *Optional*
        connected_number_source (str): connectedNumberSource *Optional*
        connected_name (str): connectedName *Optional*
        connected_presentation_indicator (str): connectedPresentationIndicator *Optional*
        type_of_network (str): typeOfNetwork *Optional*
        call_category (str): callCategory *Optional*
        basic_call_type (str): basicCallType
        configurable_call_type (str): configurableCallType *Optional*
        alternate_call_indicator (str): alternateCallIndicator *Optional*
        virtual_on_net_call_type (str): virtualOnNetCallType *Optional*
        time (str): time
        start_time (int): startTime
        answer_time (int): answerTime *Optional*
        release_time (int): releaseTime *Optional*
        detached_time (int): detachedTime *Optional*
        detached_answer_time (int): detachedAnswerTime *Optional*
        outgoing_dnis (str): outgoingDnis *Optional*
        service_invocation_disposition (str): serviceInvocationDisposition *Optional*
        service_invocation_dialed_number (str): serviceInvocationDialedNumber *Optional*
        service_invocation_called_number (str): serviceInvocationCalledNumber *Optional*
        service_invocation_network_translated_address (str):
            serviceInvocationNetworkTranslatedAddress *Optional*
        service_invocation_type_of_network (str): serviceInvocationTypeOfNetwork
            *Optional*
        service_invocation_call_category (str): serviceInvocationCallCategory *Optional*
        service_invocation_basic_call_type (str): serviceInvocationBasicCallType
            *Optional*
        service_invocation_configurable_call_type (str):
            serviceInvocationConfigurableCallType *Optional*
        service_invocation_alternate_call_indicator (str):
            serviceInvocationAlternateCallIndicator *Optional*
        service_invocation_virtual_on_net_call_type (str):
            serviceInvocationVirtualOnNetCallType *Optional*
        service_invocation_called_directory_name (str):
            serviceInvocationCalledDirectoryName *Optional*
        service_invocation_called_group_id (str): serviceInvocationCalledGroupId
            *Optional*
        redirecting_number (str): redirectingNumber *Optional*
        redirecting_name (str): redirectingName *Optional*
        redirecting_presentation_indicator (str): redirectingPresentationIndicator
            *Optional*
        redirecting_reason (str): RedirectingReason *Optional*
        account_authorization_code (str): accountAuthorizationCode *Optional*
        call_authorization_code (str): callAuthorizationCode *Optional*
        user_group_id (str): userGroupId *Optional*
        user_id (str): userId *Optional*
        user_primary_dn (str): userPrimaryDn *Optional*
        user_primary_extension (str): userPrimaryExtension *Optional*
        security_classification (str): securityClassification *Optional*
        direct_route_number (str): directRouteNumber *Optional*
        route_list_dn (str): routeListDN *Optional*
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "call_id",
        "subscriber_type",
        "dialed_number",
        "called_number",
        "network_translated_address",
        "calling_asserted_number",
        "calling_presentation_number",
        "calling_presentation_number_source",
        "calling_presentation_name",
        "calling_presentation_indicator",
        "calling_group_id",
        "called_directory_name",
        "called_group_id",
        "connected_number",
        "connected_number_source",
        "connected_name",
        "connected_presentation_indicator",
        "type_of_network",
        "call_category",
        "basic_call_type",
        "configurable_call_type",
        "alternate_call_indicator",
        "virtual_on_net_call_type",
        "time",
        "start_time",
        "answer_time",
        "release_time",
        "detached_time",
        "detached_answer_time",
        "outgoing_dnis",
        "service_invocation_disposition",
        "service_invocation_dialed_number",
        "service_invocation_called_number",
        "service_invocation_network_translated_address",
        "service_invocation_type_of_network",
        "service_invocation_call_category",
        "service_invocation_basic_call_type",
        "service_invocation_configurable_call_type",
        "service_invocation_alternate_call_indicator",
        "service_invocation_virtual_on_net_call_type",
        "service_invocation_called_directory_name",
        "service_invocation_called_group_id",
        "redirecting_number",
        "redirecting_name",
        "redirecting_presentation_indicator",
        "redirecting_reason",
        "account_authorization_code",
        "call_authorization_code",
        "user_group_id",
        "user_id",
        "user_primary_dn",
        "user_primary_extension",
        "security_classification",
        "direct_route_number",
        "route_list_dn",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
                is_required=True,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "call_id",
                "callId",
                str,
                is_required=True,
            ),
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
            ),
            E(
                "dialed_number",
                "dialedNumber",
                str,
            ),
            E(
                "called_number",
                "calledNumber",
                str,
            ),
            E(
                "network_translated_address",
                "networkTranslatedAddress",
                str,
            ),
            E(
                "calling_asserted_number",
                "callingAssertedNumber",
                str,
            ),
            E(
                "calling_presentation_number",
                "callingPresentationNumber",
                str,
            ),
            E(
                "calling_presentation_number_source",
                "callingPresentationNumberSource",
                str,
            ),
            E(
                "calling_presentation_name",
                "callingPresentationName",
                str,
            ),
            E(
                "calling_presentation_indicator",
                "callingPresentationIndicator",
                str,
                is_required=True,
            ),
            E(
                "calling_group_id",
                "callingGroupId",
                str,
            ),
            E(
                "called_directory_name",
                "calledDirectoryName",
                str,
            ),
            E(
                "called_group_id",
                "calledGroupId",
                str,
            ),
            E(
                "connected_number",
                "connectedNumber",
                str,
            ),
            E(
                "connected_number_source",
                "connectedNumberSource",
                str,
            ),
            E(
                "connected_name",
                "connectedName",
                str,
            ),
            E(
                "connected_presentation_indicator",
                "connectedPresentationIndicator",
                str,
            ),
            E(
                "type_of_network",
                "typeOfNetwork",
                str,
            ),
            E(
                "call_category",
                "callCategory",
                str,
            ),
            E(
                "basic_call_type",
                "basicCallType",
                str,
                is_required=True,
            ),
            E(
                "configurable_call_type",
                "configurableCallType",
                str,
            ),
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
            ),
            E(
                "virtual_on_net_call_type",
                "virtualOnNetCallType",
                str,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                int,
                is_required=True,
            ),
            E(
                "answer_time",
                "answerTime",
                int,
            ),
            E(
                "release_time",
                "releaseTime",
                int,
            ),
            E(
                "detached_time",
                "detachedTime",
                int,
            ),
            E(
                "detached_answer_time",
                "detachedAnswerTime",
                int,
            ),
            E(
                "outgoing_dnis",
                "outgoingDnis",
                str,
            ),
            E(
                "service_invocation_disposition",
                "serviceInvocationDisposition",
                str,
            ),
            E(
                "service_invocation_dialed_number",
                "serviceInvocationDialedNumber",
                str,
            ),
            E(
                "service_invocation_called_number",
                "serviceInvocationCalledNumber",
                str,
            ),
            E(
                "service_invocation_network_translated_address",
                "serviceInvocationNetworkTranslatedAddress",
                str,
            ),
            E(
                "service_invocation_type_of_network",
                "serviceInvocationTypeOfNetwork",
                str,
            ),
            E(
                "service_invocation_call_category",
                "serviceInvocationCallCategory",
                str,
            ),
            E(
                "service_invocation_basic_call_type",
                "serviceInvocationBasicCallType",
                str,
            ),
            E(
                "service_invocation_configurable_call_type",
                "serviceInvocationConfigurableCallType",
                str,
            ),
            E(
                "service_invocation_alternate_call_indicator",
                "serviceInvocationAlternateCallIndicator",
                str,
            ),
            E(
                "service_invocation_virtual_on_net_call_type",
                "serviceInvocationVirtualOnNetCallType",
                str,
            ),
            E(
                "service_invocation_called_directory_name",
                "serviceInvocationCalledDirectoryName",
                str,
            ),
            E(
                "service_invocation_called_group_id",
                "serviceInvocationCalledGroupId",
                str,
            ),
            E(
                "redirecting_number",
                "redirectingNumber",
                str,
            ),
            E(
                "redirecting_name",
                "redirectingName",
                str,
            ),
            E(
                "redirecting_presentation_indicator",
                "redirectingPresentationIndicator",
                str,
            ),
            E(
                "redirecting_reason",
                "RedirectingReason",
                str,
            ),
            E(
                "account_authorization_code",
                "accountAuthorizationCode",
                str,
            ),
            E(
                "call_authorization_code",
                "callAuthorizationCode",
                str,
            ),
            E(
                "user_group_id",
                "userGroupId",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "user_primary_dn",
                "userPrimaryDn",
                str,
            ),
            E(
                "user_primary_extension",
                "userPrimaryExtension",
                str,
            ),
            E(
                "security_classification",
                "securityClassification",
                str,
            ),
            E(
                "direct_route_number",
                "directRouteNumber",
                str,
            ),
            E(
                "route_list_dn",
                "routeListDN",
                str,
            ),
        )


class ExtensionRange(OCIType):
    """
    Extension range.

    The minimum and maximum values are inclusive.

    Attributes:
        min_extension (str): minExtension
        max_extension (str): maxExtension
    """

    __slots__: List[str] = [
        "min_extension",
        "max_extension",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "min_extension",
                "minExtension",
                str,
                is_required=True,
            ),
            E(
                "max_extension",
                "maxExtension",
                str,
                is_required=True,
            ),
        )


class ExtensionRange17(OCIType):
    """
    Extension range.

    The minimum and maximum values are inclusive.

    Attributes:
        min_extension (str): minExtension
        max_extension (str): maxExtension
    """

    __slots__: List[str] = [
        "min_extension",
        "max_extension",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "min_extension",
                "minExtension",
                str,
                is_required=True,
            ),
            E(
                "max_extension",
                "maxExtension",
                str,
                is_required=True,
            ),
        )


class FaxMessagingMenuKeysModifyEntry(OCIType):
    """
    The voice portal fax messaging menu keys modify entry.


    Attributes:
        save_fax_message_and_skip_to_next (str): saveFaxMessageAndSkipToNext *Optional*
        previous_fax_message (str): previousFaxMessage *Optional*
        play_envelope (str): playEnvelope *Optional*
        next_fax_message (str): nextFaxMessage *Optional*
        delete_fax_message (str): deleteFaxMessage *Optional*
        print_fax_message (str): printFaxMessage *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
    """

    __slots__: List[str] = [
        "save_fax_message_and_skip_to_next",
        "previous_fax_message",
        "play_envelope",
        "next_fax_message",
        "delete_fax_message",
        "print_fax_message",
        "return_to_previous_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "save_fax_message_and_skip_to_next",
                "saveFaxMessageAndSkipToNext",
                str,
            ),
            E(
                "previous_fax_message",
                "previousFaxMessage",
                str,
            ),
            E(
                "play_envelope",
                "playEnvelope",
                str,
            ),
            E(
                "next_fax_message",
                "nextFaxMessage",
                str,
            ),
            E(
                "delete_fax_message",
                "deleteFaxMessage",
                str,
            ),
            E(
                "print_fax_message",
                "printFaxMessage",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
        )


class FaxMessagingMenuKeysReadEntry(OCIType):
    """
    The voice portal fax messaging menu keys.


    Attributes:
        save_fax_message_and_skip_to_next (str): saveFaxMessageAndSkipToNext *Optional*
        previous_fax_message (str): previousFaxMessage *Optional*
        play_envelope (str): playEnvelope *Optional*
        next_fax_message (str): nextFaxMessage *Optional*
        delete_fax_message (str): deleteFaxMessage *Optional*
        print_fax_message (str): printFaxMessage *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
    """

    __slots__: List[str] = [
        "save_fax_message_and_skip_to_next",
        "previous_fax_message",
        "play_envelope",
        "next_fax_message",
        "delete_fax_message",
        "print_fax_message",
        "return_to_previous_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "save_fax_message_and_skip_to_next",
                "saveFaxMessageAndSkipToNext",
                str,
            ),
            E(
                "previous_fax_message",
                "previousFaxMessage",
                str,
            ),
            E(
                "play_envelope",
                "playEnvelope",
                str,
            ),
            E(
                "next_fax_message",
                "nextFaxMessage",
                str,
            ),
            E(
                "delete_fax_message",
                "deleteFaxMessage",
                str,
            ),
            E(
                "print_fax_message",
                "printFaxMessage",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
        )


class FeatureAccessCodeEntry(OCIType):
    """
    Feature Access Code Entry

    Attributes:
        feature_access_code_name (str): featureAccessCodeName
        main_code (str): mainCode *Optional*
        alternate_code (str): alternateCode *Optional*
    """

    __slots__: List[str] = [
        "feature_access_code_name",
        "main_code",
        "alternate_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "feature_access_code_name",
                "featureAccessCodeName",
                str,
                is_required=True,
            ),
            E(
                "main_code",
                "mainCode",
                str,
            ),
            E(
                "alternate_code",
                "alternateCode",
                str,
            ),
        )


class FeatureAccessCodeModifyEntry(OCIType):
    """
    Feature Access Code Entry to be used in all the system, service provider and group
    modify commands.


    Attributes:
        feature_access_code_name (str): featureAccessCodeName
        main_code (str): mainCode *Optional*
        alternate_code (str): alternateCode *Optional*
        enable_fac (bool): enableFAC *Optional*
    """

    __slots__: List[str] = [
        "feature_access_code_name",
        "main_code",
        "alternate_code",
        "enable_fac",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "feature_access_code_name",
                "featureAccessCodeName",
                str,
                is_required=True,
            ),
            E(
                "main_code",
                "mainCode",
                str,
            ),
            E(
                "alternate_code",
                "alternateCode",
                str,
            ),
            E(
                "enable_fac",
                "enableFAC",
                bool,
            ),
        )


class FeatureAccessCodeReadEntry(OCIType):
    """
    Feature Access Code Entry to be used in all GET commands.


    Attributes:
        feature_access_code_name (str): featureAccessCodeName
        main_code (str): mainCode *Optional*
        alternate_code (str): alternateCode *Optional*
        enable_fac (bool): enableFAC *Optional*
    """

    __slots__: List[str] = [
        "feature_access_code_name",
        "main_code",
        "alternate_code",
        "enable_fac",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "feature_access_code_name",
                "featureAccessCodeName",
                str,
                is_required=True,
            ),
            E(
                "main_code",
                "mainCode",
                str,
            ),
            E(
                "alternate_code",
                "alternateCode",
                str,
            ),
            E(
                "enable_fac",
                "enableFAC",
                bool,
            ),
        )


class FileRepositoryProtocolFTP(OCIType):
    """
    Attributes of the FTP protocol when the file repository interface is using FTP.


    Attributes:
        ftp_passive (bool): ftpPassive
        net_address (str): netAddress
    """

    __slots__: List[str] = [
        "ftp_passive",
        "net_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "ftp_passive",
                "ftpPassive",
                bool,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
        )


class FileRepositoryProtocolFTP16(OCIType):
    """
    Attributes of the FTP protocol when the file repository interface is using FTP.


    Attributes:
        ftp_passive (bool): ftpPassive
        net_address (str): netAddress
        ftp_remote_verification (bool): ftpRemoteVerification
    """

    __slots__: List[str] = [
        "ftp_passive",
        "net_address",
        "ftp_remote_verification",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "ftp_passive",
                "ftpPassive",
                bool,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "ftp_remote_verification",
                "ftpRemoteVerification",
                bool,
                is_required=True,
            ),
        )


class FileRepositoryProtocolWebDAV(OCIType):
    """
    Attributes of the WebDav protocol when the file repository interface is using WebDav.


    Attributes:
        secure (bool): secure
        net_address (str): netAddress
    """

    __slots__: List[str] = [
        "secure",
        "net_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "secure",
                "secure",
                bool,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
        )


class FileRepositoryProtocolWebDAV20(OCIType):
    """
    Attributes of the WebDav protocol when the file repository interface is using WebDav.


    Attributes:
        secure (bool): secure
        net_address (str): netAddress
        extended_file_capture_support (bool): extendedFileCaptureSupport
    """

    __slots__: List[str] = [
        "secure",
        "net_address",
        "extended_file_capture_support",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "secure",
                "secure",
                bool,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "extended_file_capture_support",
                "extendedFileCaptureSupport",
                bool,
                is_required=True,
            ),
        )


class FileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer.


    Attributes:
        source_file_name (str): sourceFileName *Optional*
        file_content (str): fileContent *Optional*
    """

    __slots__: List[str] = [
        "source_file_name",
        "file_content",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "source_file_name",
                "sourceFileName",
                str,
            ),
            E(
                "file_content",
                "fileContent",
                str,
            ),
        )


class FindMeFollowMeAlertingGroupReplacementOutgoingDNSIPURIorUserIdList(OCIType):
    """
    A list of phone numbers/sipuris or user ids that replaces a previously configured
    list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number (str): phoneNumber *Optional*
        user_id (str): userId *Optional*
    """

    __slots__: List[str] = [
        "phone_number",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
        )


class ForwardOrComposeMessageMenuKeysModifyEntry(OCIType):
    """
    The voice portal forward or compose message menu keys modify entry.


    Attributes:
        send_to_person (str): sendToPerson *Optional*
        send_to_all_group_members (str): sendToAllGroupMembers *Optional*
        send_to_distribution_list (str): sendToDistributionList *Optional*
        change_current_introduction_or_message (str): changeCurrentIntroductionOrMessage
            *Optional*
        listen_to_current_introduction_or_message (str):
            listenToCurrentIntroductionOrMessage *Optional*
        set_or_clear_urgent_indicator (str): setOrClearUrgentIndicator *Optional*
        set_or_clear_confidential_indicator (str): setOrClearConfidentialIndicator
            *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "send_to_person",
        "send_to_all_group_members",
        "send_to_distribution_list",
        "change_current_introduction_or_message",
        "listen_to_current_introduction_or_message",
        "set_or_clear_urgent_indicator",
        "set_or_clear_confidential_indicator",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_to_person",
                "sendToPerson",
                str,
            ),
            E(
                "send_to_all_group_members",
                "sendToAllGroupMembers",
                str,
            ),
            E(
                "send_to_distribution_list",
                "sendToDistributionList",
                str,
            ),
            E(
                "change_current_introduction_or_message",
                "changeCurrentIntroductionOrMessage",
                str,
            ),
            E(
                "listen_to_current_introduction_or_message",
                "listenToCurrentIntroductionOrMessage",
                str,
            ),
            E(
                "set_or_clear_urgent_indicator",
                "setOrClearUrgentIndicator",
                str,
            ),
            E(
                "set_or_clear_confidential_indicator",
                "setOrClearConfidentialIndicator",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class ForwardOrComposeMessageMenuKeysReadEntry(OCIType):
    """
    The voice portal forward or compose message menu keys.


    Attributes:
        send_to_person (str): sendToPerson *Optional*
        send_to_all_group_members (str): sendToAllGroupMembers *Optional*
        send_to_distribution_list (str): sendToDistributionList *Optional*
        change_current_introduction_or_message (str): changeCurrentIntroductionOrMessage
            *Optional*
        listen_to_current_introduction_or_message (str):
            listenToCurrentIntroductionOrMessage *Optional*
        set_or_clear_urgent_indicator (str): setOrClearUrgentIndicator *Optional*
        set_or_clear_confidential_indicator (str): setOrClearConfidentialIndicator
            *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "send_to_person",
        "send_to_all_group_members",
        "send_to_distribution_list",
        "change_current_introduction_or_message",
        "listen_to_current_introduction_or_message",
        "set_or_clear_urgent_indicator",
        "set_or_clear_confidential_indicator",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_to_person",
                "sendToPerson",
                str,
            ),
            E(
                "send_to_all_group_members",
                "sendToAllGroupMembers",
                str,
            ),
            E(
                "send_to_distribution_list",
                "sendToDistributionList",
                str,
            ),
            E(
                "change_current_introduction_or_message",
                "changeCurrentIntroductionOrMessage",
                str,
            ),
            E(
                "listen_to_current_introduction_or_message",
                "listenToCurrentIntroductionOrMessage",
                str,
            ),
            E(
                "set_or_clear_urgent_indicator",
                "setOrClearUrgentIndicator",
                str,
            ),
            E(
                "set_or_clear_confidential_indicator",
                "setOrClearConfidentialIndicator",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class GreetingOnlyForwardingDestinationMenuKeysModifyEntry(OCIType):
    """
    The voice portal greeting only forwarding destination menu keys modify entry.


    Attributes:
        greeting_only_forwarding_destination (str): greetingOnlyForwardingDestination
            *Optional*
    """

    __slots__: List[str] = [
        "greeting_only_forwarding_destination",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "greeting_only_forwarding_destination",
                "greetingOnlyForwardingDestination",
                str,
            ),
        )


class GreetingOnlyForwardingDestinationMenuKeysReadEntry(OCIType):
    """
    The voice portal greeting only forwarding destination menu keys.


    Attributes:
        greeting_only_forwarding_destination (str): greetingOnlyForwardingDestination
            *Optional*
    """

    __slots__: List[str] = [
        "greeting_only_forwarding_destination",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "greeting_only_forwarding_destination",
                "greetingOnlyForwardingDestination",
                str,
            ),
        )


class GreetingsMenuKeysModifyEntry(OCIType):
    """
    The voice portal greeting menu keys modify entry.


    Attributes:
        personalized_name (str): personalizedName *Optional*
        conference_greeting (str): conferenceGreeting *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "personalized_name",
        "conference_greeting",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "personalized_name",
                "personalizedName",
                str,
            ),
            E(
                "conference_greeting",
                "conferenceGreeting",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class GreetingsMenuKeysReadEntry(OCIType):
    """
    The voice portal greeting menu keys.


    Attributes:
        personalized_name (str): personalizedName *Optional*
        conference_greeting (str): conferenceGreeting *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "personalized_name",
        "conference_greeting",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "personalized_name",
                "personalizedName",
                str,
            ),
            E(
                "conference_greeting",
                "conferenceGreeting",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class GroupAdmin(OCIType):
    """
    The common Group Admin elements.


    Attributes:
        user_id (str): userId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        password (str): password *Optional*
        language (str): language *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "first_name",
        "last_name",
        "password",
        "language",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "language",
                "language",
                str,
            ),
        )


class GroupBroadWorksMobilityGetRequest21sp1V2(OCIType):
    """
    Get the group's BroadWorks Mobility settings.

    The response is either a GroupBroadWorksMobilityGetResponse21sp1V2 or an
    `ErrorResponse()`. Replaced by `GroupBroadWorksMobilityGetRequest22V2()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetResponse21sp1V2(OCIType):
    """
    The response to a GroupBroadWorksMobilityGetRequest21sp1V2.

    Replaced by `GroupBroadWorksMobilityGetResponse22V2()`.

    Attributes:
        use_setting_level (str): useSettingLevel
        enable_location_services (bool): enableLocationServices
        enable_msrn_lookup (bool): enableMSRNLookup
        enable_mobile_state_checking (bool): enableMobileStateChecking
        deny_call_originations (bool): denyCallOriginations
        deny_call_terminations (bool): denyCallTerminations
        enable_announcement_suppression (bool): enableAnnouncementSuppression
        enable_internal_clid_delivery_access_locations (bool):
            enableInternalCLIDDeliveryAccessLocations
        enable_enhanced_unreachable_state_checking (bool):
            enableEnhancedUnreachableStateChecking
        enable_network_call_barring_status_check (bool):
            enableNetworkCallBarringStatusCheck
    """

    __slots__: List[str] = [
        "use_setting_level",
        "enable_location_services",
        "enable_msrn_lookup",
        "enable_mobile_state_checking",
        "deny_call_originations",
        "deny_call_terminations",
        "enable_announcement_suppression",
        "enable_internal_clid_delivery_access_locations",
        "enable_enhanced_unreachable_state_checking",
        "enable_network_call_barring_status_check",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting_level",
                "useSettingLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_location_services",
                "enableLocationServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_msrn_lookup",
                "enableMSRNLookup",
                bool,
                is_required=True,
            ),
            E(
                "enable_mobile_state_checking",
                "enableMobileStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_originations",
                "denyCallOriginations",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_terminations",
                "denyCallTerminations",
                bool,
                is_required=True,
            ),
            E(
                "enable_announcement_suppression",
                "enableAnnouncementSuppression",
                bool,
                is_required=True,
            ),
            E(
                "enable_internal_clid_delivery_access_locations",
                "enableInternalCLIDDeliveryAccessLocations",
                bool,
                is_required=True,
            ),
            E(
                "enable_enhanced_unreachable_state_checking",
                "enableEnhancedUnreachableStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "enable_network_call_barring_status_check",
                "enableNetworkCallBarringStatusCheck",
                bool,
                is_required=True,
            ),
        )


class GroupEnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group

    Attributes:
        trunk_group (str): trunkGroup
        priority (int): priority
        weight (int): weight
    """

    __slots__: List[str] = [
        "trunk_group",
        "priority",
        "weight",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "trunk_group",
                "trunkGroup",
                str,
                is_required=True,
            ),
            E(
                "priority",
                "priority",
                int,
                is_required=True,
            ),
            E(
                "weight",
                "weight",
                int,
                is_required=True,
            ),
        )


class GroupExtensionLengthSettings(OCIType):
    """
    Group extension length settings

    Attributes:
        min_extension_length (int): minExtensionLength *Optional*
        max_extension_length (int): maxExtensionLength *Optional*
        default_extension_length (int): defaultExtensionLength *Optional*
        use_enterprise_extension_length_setting (bool):
            useEnterpriseExtensionLengthSetting *Optional*
    """

    __slots__: List[str] = [
        "min_extension_length",
        "max_extension_length",
        "default_extension_length",
        "use_enterprise_extension_length_setting",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "min_extension_length",
                "minExtensionLength",
                int,
            ),
            E(
                "max_extension_length",
                "maxExtensionLength",
                int,
            ),
            E(
                "default_extension_length",
                "defaultExtensionLength",
                int,
            ),
            E(
                "use_enterprise_extension_length_setting",
                "useEnterpriseExtensionLengthSetting",
                bool,
            ),
        )


class GroupHuntGroupGetInstanceRequest17sp1V1(OCIType):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either GroupHuntGroupGetInstanceResponse17sp1V1 or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupPasswordRulesGetRequestRI(OCIType):
    """
    Requests the group's password rules setting that is applicable to users within the
    group.

    The response is either GroupPasswordRulesGetResponseRI or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPasswordRulesGetResponseRI(OCIType):
    """
    Response to GroupPasswordRulesGetRequestRI.

    Contains the password rules applicable to users within the group.  The following
    element is only used in AS data mode: forcePasswordChangeAfterReset, value “false” is
    returned in XS data mode reenableLogin lockOutInMinutes

    Attributes:
        disallow_user_id (bool): disallowUserId
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        max_failed_login_attempts (int): maxFailedLoginAttempts
        password_expires_days (int): passwordExpiresDays
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_rules_modification (bool): disallowRulesModification
        disallow_previous_passwords (bool): disallowPreviousPasswords
        number_of_previous_passwords (int): numberOfPreviousPasswords
        force_password_change_after_reset (bool): forcePasswordChangeAfterReset
        use_password_validation_service (bool): usePasswordValidationService
        reenable_login (bool): reenableLogin
        lock_out_in_minutes (int): lockOutInMinutes
    """

    __slots__: List[str] = [
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_rules_modification",
        "disallow_previous_passwords",
        "number_of_previous_passwords",
        "force_password_change_after_reset",
        "use_password_validation_service",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
                is_required=True,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_rules_modification",
                "disallowRulesModification",
                bool,
                is_required=True,
            ),
            E(
                "disallow_previous_passwords",
                "disallowPreviousPasswords",
                bool,
                is_required=True,
            ),
            E(
                "number_of_previous_passwords",
                "numberOfPreviousPasswords",
                int,
                is_required=True,
            ),
            E(
                "force_password_change_after_reset",
                "forcePasswordChangeAfterReset",
                bool,
                is_required=True,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
                is_required=True,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
                is_required=True,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
                is_required=True,
            ),
        )


class GroupPortalPasscodeRulesGetRequestRI(OCIType):
    """
    Requests the group's passcode rules setting.

    The response is either GroupPortalPasscodeRulesGetResponseRI or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPortalPasscodeRulesGetResponseRI(OCIType):
    """
    Response to GroupPortalPasscodeRulesGetRequestRI.

    Contains the group's passcode rules setting.  The following elements are only used in
    AS data mode: numberOfRepeatedDigits disallowRepeatedPatterns
    disallowContiguousSequences numberOfAscendingDigits numberOfDescendingDigits
    numberOfPreviousPasscodes reenableLogin lockOutInMinutes

    Attributes:
        use_rule_level (str): useRuleLevel
        disallow_repeated_digits (bool): disallowRepeatedDigits
        number_of_repeated_digits (int): numberOfRepeatedDigits
        disallow_repeated_patterns (bool): disallowRepeatedPatterns
        disallow_contiguous_sequences (bool): disallowContiguousSequences
        number_of_ascending_digits (int): numberOfAscendingDigits
        number_of_descending_digits (int): numberOfDescendingDigits
        disallow_user_number (bool): disallowUserNumber
        disallow_reversed_user_number (bool): disallowReversedUserNumber
        disallow_old_passcode (bool): disallowOldPasscode
        number_of_previous_passcodes (int): numberOfPreviousPasscodes
        disallow_reversed_old_passcode (bool): disallowReversedOldPasscode
        min_code_length (int): minCodeLength
        max_code_length (int): maxCodeLength
        disable_login_after_max_failed_login_attempts (bool):
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        expire_password (bool): expirePassword
        passcode_expires_days (int): passcodeExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        reenable_login (bool): reenableLogin
        lock_out_in_minutes (int): lockOutInMinutes
    """

    __slots__: List[str] = [
        "use_rule_level",
        "disallow_repeated_digits",
        "number_of_repeated_digits",
        "disallow_repeated_patterns",
        "disallow_contiguous_sequences",
        "number_of_ascending_digits",
        "number_of_descending_digits",
        "disallow_user_number",
        "disallow_reversed_user_number",
        "disallow_old_passcode",
        "number_of_previous_passcodes",
        "disallow_reversed_old_passcode",
        "min_code_length",
        "max_code_length",
        "disable_login_after_max_failed_login_attempts",
        "max_failed_login_attempts",
        "expire_password",
        "passcode_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_rule_level",
                "useRuleLevel",
                str,
                is_required=True,
            ),
            E(
                "disallow_repeated_digits",
                "disallowRepeatedDigits",
                bool,
                is_required=True,
            ),
            E(
                "number_of_repeated_digits",
                "numberOfRepeatedDigits",
                int,
                is_required=True,
            ),
            E(
                "disallow_repeated_patterns",
                "disallowRepeatedPatterns",
                bool,
                is_required=True,
            ),
            E(
                "disallow_contiguous_sequences",
                "disallowContiguousSequences",
                bool,
                is_required=True,
            ),
            E(
                "number_of_ascending_digits",
                "numberOfAscendingDigits",
                int,
                is_required=True,
            ),
            E(
                "number_of_descending_digits",
                "numberOfDescendingDigits",
                int,
                is_required=True,
            ),
            E(
                "disallow_user_number",
                "disallowUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_user_number",
                "disallowReversedUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_passcode",
                "disallowOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "number_of_previous_passcodes",
                "numberOfPreviousPasscodes",
                int,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_passcode",
                "disallowReversedOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "min_code_length",
                "minCodeLength",
                int,
                is_required=True,
            ),
            E(
                "max_code_length",
                "maxCodeLength",
                int,
                is_required=True,
            ),
            E(
                "disable_login_after_max_failed_login_attempts",
                "disableLoginAfterMaxFailedLoginAttempts",
                bool,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "expire_password",
                "expirePassword",
                bool,
                is_required=True,
            ),
            E(
                "passcode_expires_days",
                "passcodeExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
                is_required=True,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
                is_required=True,
            ),
        )


class GroupPreferredCarrierName(OCIType):
    """
    Group can either use it's service provider/enterprise's preferred carrier or use it's
    own.

    The group carrier name is exposed if it was previously configured.

    Attributes:
        use_service_provider_preferred_carrier (bool): useServiceProviderPreferredCarrier
        carrier (str): carrier *Optional*
    """

    __slots__: List[str] = [
        "use_service_provider_preferred_carrier",
        "carrier",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_service_provider_preferred_carrier",
                "useServiceProviderPreferredCarrier",
                bool,
                is_required=True,
            ),
            E(
                "carrier",
                "carrier",
                str,
            ),
        )


class GroupPreferredCarrierNameModify(OCIType):
    """
    Group can either use it's service provider/enterprise's preferred carrier or use it's
    own.

    You can use the Service Provider preferred carrier without clearing the group carrier
    name -- in this case, the group carrier name is retained.

    Attributes:
        use_service_provider_preferred_carrier (bool): useServiceProviderPreferredCarrier
        carrier (str): carrier *Optional*
    """

    __slots__: List[str] = [
        "use_service_provider_preferred_carrier",
        "carrier",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_service_provider_preferred_carrier",
                "useServiceProviderPreferredCarrier",
                bool,
                is_required=True,
            ),
            E(
                "carrier",
                "carrier",
                str,
            ),
        )


class GroupSessionAdmissionControlGroupGetRequest21sp1V2(OCIType):
    """
    Request to get a session admission control group for the group.

    The response is either a GroupSessionAdmissionControlGroupGetResponse21sp1V2 or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class Holiday(OCIType):
    """
    Holiday entry.


    Attributes:
        holiday_name (str): holidayName
        start_date (str): startDate
        end_date (str): endDate *Optional*
    """

    __slots__: List[str] = [
        "holiday_name",
        "start_date",
        "end_date",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "holiday_name",
                "holidayName",
                str,
                is_required=True,
            ),
            E(
                "start_date",
                "startDate",
                str,
                is_required=True,
            ),
            E(
                "end_date",
                "endDate",
                str,
            ),
        )


class HolidaySchedule(OCIType):
    """
    Holiday Schedule.


    Attributes:
        type (str): type
        name (str): name
    """

    __slots__: List[str] = [
        "type",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class HotelingMenuKeysModifyEntry(OCIType):
    """
    The voice portal hoteling menu keys modify entry.


    Attributes:
        check_host_status (str): checkHostStatus *Optional*
        associate_with_host (str): associateWithHost *Optional*
        disassociate_from_host (str): disassociateFromHost *Optional*
        disassociate_from_remote_host (str): disassociateFromRemoteHost *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "check_host_status",
        "associate_with_host",
        "disassociate_from_host",
        "disassociate_from_remote_host",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "check_host_status",
                "checkHostStatus",
                str,
            ),
            E(
                "associate_with_host",
                "associateWithHost",
                str,
            ),
            E(
                "disassociate_from_host",
                "disassociateFromHost",
                str,
            ),
            E(
                "disassociate_from_remote_host",
                "disassociateFromRemoteHost",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class HotelingMenuKeysReadEntry(OCIType):
    """
    The voice portal hoteling menu keys.


    Attributes:
        check_host_status (str): checkHostStatus *Optional*
        associate_with_host (str): associateWithHost *Optional*
        disassociate_from_host (str): disassociateFromHost *Optional*
        disassociate_from_remote_host (str): disassociateFromRemoteHost *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "check_host_status",
        "associate_with_host",
        "disassociate_from_host",
        "disassociate_from_remote_host",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "check_host_status",
                "checkHostStatus",
                str,
            ),
            E(
                "associate_with_host",
                "associateWithHost",
                str,
            ),
            E(
                "disassociate_from_host",
                "disassociateFromHost",
                str,
            ),
            E(
                "disassociate_from_remote_host",
                "disassociateFromRemoteHost",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class HourMinute(OCIType):
    """
    Represents a specific time with hour and minute granularity

    Attributes:
        hour (int): hour
        minute (int): minute
    """

    __slots__: List[str] = [
        "hour",
        "minute",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "hour",
                "hour",
                int,
                is_required=True,
            ),
            E(
                "minute",
                "minute",
                int,
                is_required=True,
            ),
        )


class HuntAgentWeight(OCIType):
    """
    The weighted call distribution weight for an agent.


    Attributes:
        agent_user_id (str): agentUserId
        weight (int): weight
    """

    __slots__: List[str] = [
        "agent_user_id",
        "weight",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_required=True,
            ),
            E(
                "weight",
                "weight",
                int,
                is_required=True,
            ),
        )


class IPAddressRange(OCIType):
    """
    IP Address Range.


    Attributes:
        min_ip_address (str): minIpAddress
        max_ip_address (str): maxIpAddress
    """

    __slots__: List[str] = [
        "min_ip_address",
        "max_ip_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "min_ip_address",
                "minIpAddress",
                str,
                is_required=True,
            ),
            E(
                "max_ip_address",
                "maxIpAddress",
                str,
                is_required=True,
            ),
        )


class IncomingCallingPlanDigitPatternPermission(OCIType):
    """
    Indicates whether calls from specified digit patterns are permitted.


    Attributes:
        digit_pattern_name (str): digitPatternName
        allow (bool): allow
    """

    __slots__: List[str] = [
        "digit_pattern_name",
        "allow",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_name",
                "digitPatternName",
                str,
                is_required=True,
            ),
            E(
                "allow",
                "allow",
                bool,
                is_required=True,
            ),
        )


class InterceptDNListEntry(OCIType):
    """
    Intercept User Entry containing the phone number and a Description.


    Attributes:
        phone_number (str): phoneNumber
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "phone_number",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class LabeledFileNameResource(OCIType):
    """
    Represents an existing file for the application server to use, along with a
    description and mediaType.


    Attributes:
        description (str): description
        media_type (str): mediaType
        source_file_name (str): sourceFileName
    """

    __slots__: List[str] = [
        "description",
        "media_type",
        "source_file_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
                is_required=True,
            ),
            E(
                "media_type",
                "mediaType",
                str,
                is_required=True,
            ),
            E(
                "source_file_name",
                "sourceFileName",
                str,
                is_required=True,
            ),
        )


class LabeledFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer with a description.


    Attributes:
        description (str): description
        source_file_name (str): sourceFileName *Optional*
        content (str): content *Optional*
    """

    __slots__: List[str] = [
        "description",
        "source_file_name",
        "content",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
                is_required=True,
            ),
            E(
                "source_file_name",
                "sourceFileName",
                str,
            ),
            E(
                "content",
                "content",
                str,
            ),
        )


class LabeledMediaFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or the contents
    of a file to transfer with a description.


    Attributes:
        description (str): description
        media_type (str): mediaType
        source_file_name (str): sourceFileName *Optional*
        content (str): content *Optional*
    """

    __slots__: List[str] = [
        "description",
        "media_type",
        "source_file_name",
        "content",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
                is_required=True,
            ),
            E(
                "media_type",
                "mediaType",
                str,
                is_required=True,
            ),
            E(
                "source_file_name",
                "sourceFileName",
                str,
            ),
            E(
                "content",
                "content",
                str,
            ),
        )


class MWIDeliveryToMobileEndpointTemplateActivation(OCIType):
    """
    MWI Delivery To Mobile Endpoint enabled status indicator

    Attributes:
        language (str): language
        type (str): type
        is_enabled (bool): isEnabled
    """

    __slots__: List[str] = [
        "language",
        "type",
        "is_enabled",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
            E(
                "is_enabled",
                "isEnabled",
                bool,
                is_required=True,
            ),
        )


class MWIDeliveryToMobileEndpointTemplateActivation23(OCIType):
    """
    MWI Delivery To Mobile Endpoint enabled status indicator

    Attributes:
        language (str): language
        type (str): type
        is_enabled (bool): isEnabled
    """

    __slots__: List[str] = [
        "language",
        "type",
        "is_enabled",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
            E(
                "is_enabled",
                "isEnabled",
                bool,
                is_required=True,
            ),
        )


class MWIDeliveryToMobileEndpointTemplateLine(OCIType):
    """
    MWI Delivery To Mobile Endpoint template section associated with a specific tag.


    Attributes:
        prefix (str): prefix *Optional*
        tag (str): tag *Optional*
        postfix (str): postfix *Optional*
    """

    __slots__: List[str] = [
        "prefix",
        "tag",
        "postfix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "prefix",
                "prefix",
                str,
            ),
            E(
                "tag",
                "tag",
                str,
            ),
            E(
                "postfix",
                "postfix",
                str,
            ),
        )


class MWIDeliveryToMobileEndpointTemplateLine23(OCIType):
    """
    MWI Delivery To Mobile Endpoint template section associated with a specific tag.


    Attributes:
        prefix (str): prefix *Optional*
        tag (str): tag *Optional*
        postfix (str): postfix *Optional*
    """

    __slots__: List[str] = [
        "prefix",
        "tag",
        "postfix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "prefix",
                "prefix",
                str,
            ),
            E(
                "tag",
                "tag",
                str,
            ),
            E(
                "postfix",
                "postfix",
                str,
            ),
        )


class MaliciousCallTraceTimePeriod(OCIType):
    """
    Modify the user level data associated with Malicious Call Trace.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        start_date_time (str): startDateTime
        stop_date_time (str): stopDateTime
    """

    __slots__: List[str] = [
        "start_date_time",
        "stop_date_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "start_date_time",
                "startDateTime",
                str,
                is_required=True,
            ),
            E(
                "stop_date_time",
                "stopDateTime",
                str,
                is_required=True,
            ),
        )


class MeetMeConferencingConferenceDuration(OCIType):
    """
    Conference duration.


    Attributes:
        hours (int): hours
        minutes (int): minutes
    """

    __slots__: List[str] = [
        "hours",
        "minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "hours",
                "hours",
                int,
                is_required=True,
            ),
            E(
                "minutes",
                "minutes",
                int,
                is_required=True,
            ),
        )


class MeetMeConferencingConferenceKey(OCIType):
    """
    Identifier for conference.


    Attributes:
        bridge_id (str): bridgeId
        conference_id (str): conferenceId
    """

    __slots__: List[str] = [
        "bridge_id",
        "conference_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "bridge_id",
                "bridgeId",
                str,
                is_required=True,
            ),
            E(
                "conference_id",
                "conferenceId",
                str,
                is_required=True,
            ),
        )


class MeetMeConferencingConferencePorts(OCIType):
    """
    Number of conference ports.

    Can either be unlimited or limited to a value between 0 and 999999.

    Attributes:
        unlimited (bool): unlimited *Optional*
        quantity (int): quantity *Optional*
    """

    __slots__: List[str] = [
        "unlimited",
        "quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "unlimited",
                "unlimited",
                bool,
            ),
            E(
                "quantity",
                "quantity",
                int,
            ),
        )


class MeetMeConferencingConferenceRecordingKey(OCIType):
    """
    Identifier for conference recording.

    startTime is the recording start timestamp.

    Attributes:
        bridge_id (str): bridgeId
        conference_id (str): conferenceId
        start_time (str): startTime
    """

    __slots__: List[str] = [
        "bridge_id",
        "conference_id",
        "start_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "bridge_id",
                "bridgeId",
                str,
                is_required=True,
            ),
            E(
                "conference_id",
                "conferenceId",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                str,
                is_required=True,
            ),
        )


class MeetMeConferencingConferenceSchedule(OCIType):
    """
    Conference schedule.


    Attributes:
        schedule_reservationless (scheduleReservationless): scheduleReservationless
            *Optional*
        schedule_one_time (scheduleOneTime): scheduleOneTime *Optional*
        schedule_recurring (scheduleRecurring): scheduleRecurring *Optional*
    """

    __slots__: List[str] = [
        "schedule_reservationless",
        "schedule_one_time",
        "schedule_recurring",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "schedule_reservationless",
                "scheduleReservationless",
                [
                    E(
                        "start_time",
                        "startTime",
                        str,
                        is_required=True,
                    ),
                    E(
                        "end_time",
                        "endTime",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "schedule_one_time",
                "scheduleOneTime",
                [
                    E(
                        "start_time",
                        "startTime",
                        str,
                        is_required=True,
                    ),
                    E(
                        "duration",
                        "duration",
                        MeetMeConferencingConferenceDuration,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "schedule_recurring",
                "scheduleRecurring",
                [
                    E(
                        "start_time",
                        "startTime",
                        str,
                        is_required=True,
                    ),
                    E(
                        "duration",
                        "duration",
                        MeetMeConferencingConferenceDuration,
                        is_complex=True,
                        is_required=True,
                    ),
                    E(
                        "recurrence",
                        "recurrence",
                        Recurrence,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MessageDepositMenuKeysModifyEntry(OCIType):
    """
    The voice portal message deposit menu keys modify entry.


    Attributes:
        enable_message_deposit (str): enableMessageDeposit *Optional*
        disable_message_deposit (str): disableMessageDeposit *Optional*
        listen_to_message_deposit_status (str): listenToMessageDepositStatus *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "enable_message_deposit",
        "disable_message_deposit",
        "listen_to_message_deposit_status",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_message_deposit",
                "enableMessageDeposit",
                str,
            ),
            E(
                "disable_message_deposit",
                "disableMessageDeposit",
                str,
            ),
            E(
                "listen_to_message_deposit_status",
                "listenToMessageDepositStatus",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class MessageDepositMenuKeysReadEntry(OCIType):
    """
    The voice portal message deposit menu keys.


    Attributes:
        enable_message_deposit (str): enableMessageDeposit *Optional*
        disable_message_deposit (str): disableMessageDeposit *Optional*
        listen_to_message_deposit_status (str): listenToMessageDepositStatus *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "enable_message_deposit",
        "disable_message_deposit",
        "listen_to_message_deposit_status",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_message_deposit",
                "enableMessageDeposit",
                str,
            ),
            E(
                "disable_message_deposit",
                "disableMessageDeposit",
                str,
            ),
            E(
                "listen_to_message_deposit_status",
                "listenToMessageDepositStatus",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class MixedCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.


    Attributes:
        call_log_type (str): callLogType
        country_code (str): countryCode *Optional*
        call_log_id (str): callLogId
        phone_number (str): phoneNumber
        name (str): name
        time (str): time
    """

    __slots__: List[str] = [
        "call_log_type",
        "country_code",
        "call_log_id",
        "phone_number",
        "name",
        "time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_log_type",
                "callLogType",
                str,
                is_required=True,
            ),
            E(
                "country_code",
                "countryCode",
                str,
            ),
            E(
                "call_log_id",
                "callLogId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "time",
                "time",
                str,
                is_required=True,
            ),
        )


class MusicOnHoldSourceAdd(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointAdd,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceAdd16(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointAdd,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceAdd19sp1(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceAdd20

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointAdd,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceAdd20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceAdd21

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointAdd,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceAdd21(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles The following elements are only used in AS data mode and ignored in
    HSS data mode: announcementMediaFiles

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        labeled_custom_source_media_files (labeledCustomSourceMediaFiles):
            labeledCustomSourceMediaFiles *Optional*
        announcement_custom_source_media_files (announcementCustomSourceMediaFiles):
            announcementCustomSourceMediaFiles *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "labeled_custom_source_media_files",
        "announcement_custom_source_media_files",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "labeled_custom_source_media_files",
                "labeledCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "announcement_custom_source_media_files",
                "announcementCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointAdd,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceAdd22(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles The following elements are only used in AS data mode and ignored in
    HSS data mode: announcementMediaFiles authenticationRequired authenticationUserName
    authenticationPassword

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        labeled_custom_source_media_files (labeledCustomSourceMediaFiles):
            labeledCustomSourceMediaFiles *Optional*
        announcement_custom_source_media_files (announcementCustomSourceMediaFiles):
            announcementCustomSourceMediaFiles *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "labeled_custom_source_media_files",
        "announcement_custom_source_media_files",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "labeled_custom_source_media_files",
                "labeledCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "announcement_custom_source_media_files",
                "announcementCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointAdd,
                        is_complex=True,
                        is_required=True,
                    ),
                    E(
                        "authentication_required",
                        "authenticationRequired",
                        bool,
                    ),
                    E(
                        "authentication_user_name",
                        "authenticationUserName",
                        str,
                    ),
                    E(
                        "authentication_password",
                        "authenticationPassword",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceModify(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec *Optional*
        message_source_selection (str): messageSourceSelection *Optional*
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointModify,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceModify16(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec *Optional*
        message_source_selection (str): messageSourceSelection *Optional*
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointModify,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceModify19sp1(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceModify20

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec *Optional*
        message_source_selection (str): messageSourceSelection *Optional*
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointModify,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceModify20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceModify21

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec *Optional*
        message_source_selection (str): messageSourceSelection *Optional*
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointModify,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceModify21(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles The following elements are only used in AS data mode and ignored in
    HSS data mode: announcementMediaFiles

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec *Optional*
        message_source_selection (str): messageSourceSelection *Optional*
        labeled_custom_source_media_files (labeledCustomSourceMediaFiles):
            labeledCustomSourceMediaFiles *Optional*
        announcement_custom_source_media_files (announcementCustomSourceMediaFiles):
            announcementCustomSourceMediaFiles *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "labeled_custom_source_media_files",
        "announcement_custom_source_media_files",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "labeled_custom_source_media_files",
                "labeledCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "announcement_custom_source_media_files",
                "announcementCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointModify,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceModify22(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles The following elements are only used in AS data mode and ignored in
    HSS data mode: announcementMediaFiles authenticationRequired authenticationUserName
    authenticationPassword

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec *Optional*
        message_source_selection (str): messageSourceSelection *Optional*
        labeled_custom_source_media_files (labeledCustomSourceMediaFiles):
            labeledCustomSourceMediaFiles *Optional*
        announcement_custom_source_media_files (announcementCustomSourceMediaFiles):
            announcementCustomSourceMediaFiles *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "labeled_custom_source_media_files",
        "announcement_custom_source_media_files",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "labeled_custom_source_media_files",
                "labeledCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "announcement_custom_source_media_files",
                "announcementCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointModify,
                        is_complex=True,
                        is_required=True,
                    ),
                    E(
                        "authentication_required",
                        "authenticationRequired",
                        bool,
                    ),
                    E(
                        "authentication_user_name",
                        "authenticationUserName",
                        str,
                    ),
                    E(
                        "authentication_password",
                        "authenticationPassword",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceRead(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointRead14,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceRead16(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceRead19.

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "audio_media_type",
                        "audioMediaType",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                    E(
                        "video_media_type",
                        "videoMediaType",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointRead14,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceRead19(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "audio_media_type",
                        "audioMediaType",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                    E(
                        "video_media_type",
                        "videoMediaType",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointWithPortNumberRead,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceRead19sp1(OCIType):
    """
    Contains the music on hold source configuration.


    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "audio_media_type",
                        "audioMediaType",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                    E(
                        "video_media_type",
                        "videoMediaType",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointWithPortNumberRead,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceRead20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced by: MusicOnHoldSourceRead21

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "custom_source",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointWithPortNumberRead,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceRead21(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in XS data mode and not returned in AS data mode:
    labeledCustomSourceMediaFiles The following elements are only used in AS data mode and
    not returned in XS data mode: announcementMediaFiles

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        labeled_custom_source_media_files (labeledCustomSourceMediaFiles):
            labeledCustomSourceMediaFiles *Optional*
        announcement_custom_source_media_files (announcementCustomSourceMediaFiles):
            announcementCustomSourceMediaFiles *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "labeled_custom_source_media_files",
        "announcement_custom_source_media_files",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "labeled_custom_source_media_files",
                "labeledCustomSourceMediaFiles",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "audio_media_type",
                        "audioMediaType",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                    E(
                        "video_media_type",
                        "videoMediaType",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "announcement_custom_source_media_files",
                "announcementCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointWithPortNumberRead,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceRead22(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in XS data mode and not returned in AS data mode:
    labeledCustomSourceMediaFiles The following elements are only used in AS data mode and
    not returned in XS data mode: announcementMediaFiles

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        labeled_custom_source_media_files (labeledCustomSourceMediaFiles):
            labeledCustomSourceMediaFiles *Optional*
        announcement_custom_source_media_files (announcementCustomSourceMediaFiles):
            announcementCustomSourceMediaFiles *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "labeled_custom_source_media_files",
        "announcement_custom_source_media_files",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "labeled_custom_source_media_files",
                "labeledCustomSourceMediaFiles",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "audio_media_type",
                        "audioMediaType",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                    E(
                        "video_media_type",
                        "videoMediaType",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "announcement_custom_source_media_files",
                "announcementCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointWithPortNumberRead,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceRead22V2(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in XS data mode and not returned in AS data mode:
    labeledCustomSourceMediaFiles The following elements are only used in AS data mode and
    not returned in XS data mode: announcementMediaFiles

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        labeled_custom_source_media_files (labeledCustomSourceMediaFiles):
            labeledCustomSourceMediaFiles *Optional*
        announcement_custom_source_media_files (announcementCustomSourceMediaFiles):
            announcementCustomSourceMediaFiles *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "labeled_custom_source_media_files",
        "announcement_custom_source_media_files",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "labeled_custom_source_media_files",
                "labeledCustomSourceMediaFiles",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "audio_media_type",
                        "audioMediaType",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                    E(
                        "video_media_type",
                        "videoMediaType",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "announcement_custom_source_media_files",
                "announcementCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointWithPortNumberRead22,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldSourceRead22V3(OCIType):
    """
    Contains the music on hold source configuration.

    The following elements are only used in XS data mode and not returned in AS data mode:
    labeledCustomSourceMediaFiles The following elements are only used in AS data mode and
    not returned in XS data mode: announcementMediaFiles authenticationUserName The
    following element is only used in AS data mode: authenticationRequired, value "false"
    is returned in XS data mode

    Attributes:
        audio_file_preferred_codec (str): audioFilePreferredCodec
        message_source_selection (str): messageSourceSelection
        labeled_custom_source_media_files (labeledCustomSourceMediaFiles):
            labeledCustomSourceMediaFiles *Optional*
        announcement_custom_source_media_files (announcementCustomSourceMediaFiles):
            announcementCustomSourceMediaFiles *Optional*
        external_source (externalSource): externalSource *Optional*
    """

    __slots__: List[str] = [
        "audio_file_preferred_codec",
        "message_source_selection",
        "labeled_custom_source_media_files",
        "announcement_custom_source_media_files",
        "external_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "audio_file_preferred_codec",
                "audioFilePreferredCodec",
                str,
                is_required=True,
            ),
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "labeled_custom_source_media_files",
                "labeledCustomSourceMediaFiles",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "audio_media_type",
                        "audioMediaType",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                    E(
                        "video_media_type",
                        "videoMediaType",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "announcement_custom_source_media_files",
                "announcementCustomSourceMediaFiles",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "external_source",
                "externalSource",
                [
                    E(
                        "access_device_endpoint",
                        "accessDeviceEndpoint",
                        AccessDeviceEndpointWithPortNumberRead22,
                        is_complex=True,
                        is_required=True,
                    ),
                    E(
                        "authentication_required",
                        "authenticationRequired",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "authentication_user_name",
                        "authenticationUserName",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldUserSourceModify(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection (str): messageSourceSelection *Optional*
        custom_source (customSource): customSource *Optional*
    """

    __slots__: List[str] = [
        "message_source_selection",
        "custom_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldUserSourceModify16(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection (str): messageSourceSelection *Optional*
        custom_source (customSource): customSource *Optional*
    """

    __slots__: List[str] = [
        "message_source_selection",
        "custom_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        LabeledMediaFileResource,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldUserSourceModify20(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection (str): messageSourceSelection *Optional*
        custom_source (customSource): customSource *Optional*
    """

    __slots__: List[str] = [
        "message_source_selection",
        "custom_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldUserSourceRead(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
    """

    __slots__: List[str] = [
        "message_source_selection",
        "custom_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldUserSourceRead16(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
    """

    __slots__: List[str] = [
        "message_source_selection",
        "custom_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file_description",
                        "audioFileDescription",
                        str,
                    ),
                    E(
                        "audio_media_type",
                        "audioMediaType",
                        str,
                    ),
                    E(
                        "video_file_description",
                        "videoFileDescription",
                        str,
                    ),
                    E(
                        "video_media_type",
                        "videoMediaType",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class MusicOnHoldUserSourceRead20(OCIType):
    """
    Contains the music on hold user source configuration.


    Attributes:
        message_source_selection (str): messageSourceSelection
        custom_source (customSource): customSource *Optional*
    """

    __slots__: List[str] = [
        "message_source_selection",
        "custom_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "message_source_selection",
                "messageSourceSelection",
                str,
                is_required=True,
            ),
            E(
                "custom_source",
                "customSource",
                [
                    E(
                        "audio_file",
                        "audioFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                    E(
                        "video_file",
                        "videoFile",
                        AnnouncementFileKey,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class NameDialingName(OCIType):
    """
    Name dialing last and first names.


    Attributes:
        name_dialing_last_name (str): nameDialingLastName
        name_dialing_first_name (str): nameDialingFirstName
    """

    __slots__: List[str] = [
        "name_dialing_last_name",
        "name_dialing_first_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name_dialing_last_name",
                "nameDialingLastName",
                str,
                is_required=True,
            ),
            E(
                "name_dialing_first_name",
                "nameDialingFirstName",
                str,
                is_required=True,
            ),
        )


class NetworkClassOfServiceCommunicationBarringProfile(OCIType):
    """
    Communication Barring Profile defined as part of the Network Class Of Service.

    There can be only one primary profile within a Network Class Of Service.

    Attributes:
        name (str): name
        is_primary (bool): isPrimary
    """

    __slots__: List[str] = [
        "name",
        "is_primary",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "is_primary",
                "isPrimary",
                bool,
                is_required=True,
            ),
        )


class OrderedCriteriaList(OCIType):
    """
    A list of criteria names that defines the order priority.


    Attributes:
        criteria_name (List[str]): criteriaName
    """

    __slots__: List[str] = [
        "criteria_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria_name",
                "criteriaName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class OutgoingCallingPlanAuthorizationCodeEntry(OCIType):
    """
    Outgoing Calling Plan Authorization Code.


    Attributes:
        code (str): code
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "code",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class OutgoingCallingPlanCallMeNowPermissions(OCIType):
    """
    Outgoing Calling Plan for Call Me Now call permissions.


    Attributes:
        group (bool): group
        local (bool): local
        toll_free (bool): tollFree
        toll (bool): toll
        international (bool): international
        operator_assisted (bool): operatorAssisted
        chargeable_directory_assisted (bool): chargeableDirectoryAssisted
        special_services_i (bool): specialServicesI
        special_services_ii (bool): specialServicesII
        premium_services_i (bool): premiumServicesI
        premium_services_ii (bool): premiumServicesII
        casual (bool): casual
        url_dialing (bool): urlDialing
        unknown (bool): unknown
    """

    __slots__: List[str] = [
        "group",
        "local",
        "toll_free",
        "toll",
        "international",
        "operator_assisted",
        "chargeable_directory_assisted",
        "special_services_i",
        "special_services_ii",
        "premium_services_i",
        "premium_services_ii",
        "casual",
        "url_dialing",
        "unknown",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group",
                "group",
                bool,
                is_required=True,
            ),
            E(
                "local",
                "local",
                bool,
                is_required=True,
            ),
            E(
                "toll_free",
                "tollFree",
                bool,
                is_required=True,
            ),
            E(
                "toll",
                "toll",
                bool,
                is_required=True,
            ),
            E(
                "international",
                "international",
                bool,
                is_required=True,
            ),
            E(
                "operator_assisted",
                "operatorAssisted",
                bool,
                is_required=True,
            ),
            E(
                "chargeable_directory_assisted",
                "chargeableDirectoryAssisted",
                bool,
                is_required=True,
            ),
            E(
                "special_services_i",
                "specialServicesI",
                bool,
                is_required=True,
            ),
            E(
                "special_services_ii",
                "specialServicesII",
                bool,
                is_required=True,
            ),
            E(
                "premium_services_i",
                "premiumServicesI",
                bool,
                is_required=True,
            ),
            E(
                "premium_services_ii",
                "premiumServicesII",
                bool,
                is_required=True,
            ),
            E(
                "casual",
                "casual",
                bool,
                is_required=True,
            ),
            E(
                "url_dialing",
                "urlDialing",
                bool,
                is_required=True,
            ),
            E(
                "unknown",
                "unknown",
                bool,
                is_required=True,
            ),
        )


class OutgoingCallingPlanCallMeNowPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan for Call Me Now call permissions.


    Attributes:
        group (bool): group *Optional*
        local (bool): local *Optional*
        toll_free (bool): tollFree *Optional*
        toll (bool): toll *Optional*
        international (bool): international *Optional*
        operator_assisted (bool): operatorAssisted *Optional*
        chargeable_directory_assisted (bool): chargeableDirectoryAssisted *Optional*
        special_services_i (bool): specialServicesI *Optional*
        special_services_ii (bool): specialServicesII *Optional*
        premium_services_i (bool): premiumServicesI *Optional*
        premium_services_ii (bool): premiumServicesII *Optional*
        casual (bool): casual *Optional*
        url_dialing (bool): urlDialing *Optional*
        unknown (bool): unknown *Optional*
    """

    __slots__: List[str] = [
        "group",
        "local",
        "toll_free",
        "toll",
        "international",
        "operator_assisted",
        "chargeable_directory_assisted",
        "special_services_i",
        "special_services_ii",
        "premium_services_i",
        "premium_services_ii",
        "casual",
        "url_dialing",
        "unknown",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group",
                "group",
                bool,
            ),
            E(
                "local",
                "local",
                bool,
            ),
            E(
                "toll_free",
                "tollFree",
                bool,
            ),
            E(
                "toll",
                "toll",
                bool,
            ),
            E(
                "international",
                "international",
                bool,
            ),
            E(
                "operator_assisted",
                "operatorAssisted",
                bool,
            ),
            E(
                "chargeable_directory_assisted",
                "chargeableDirectoryAssisted",
                bool,
            ),
            E(
                "special_services_i",
                "specialServicesI",
                bool,
            ),
            E(
                "special_services_ii",
                "specialServicesII",
                bool,
            ),
            E(
                "premium_services_i",
                "premiumServicesI",
                bool,
            ),
            E(
                "premium_services_ii",
                "premiumServicesII",
                bool,
            ),
            E(
                "casual",
                "casual",
                bool,
            ),
            E(
                "url_dialing",
                "urlDialing",
                bool,
            ),
            E(
                "unknown",
                "unknown",
                bool,
            ),
        )


class OutgoingCallingPlanDigitPatternCallMeNowPermission(OCIType):
    """
    Indicates whether Call Me Now calls using specified digit patterns are permitted.


    Attributes:
        digit_pattern_name (str): digitPatternName
        permission (bool): permission
    """

    __slots__: List[str] = [
        "digit_pattern_name",
        "permission",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_name",
                "digitPatternName",
                str,
                is_required=True,
            ),
            E(
                "permission",
                "permission",
                bool,
                is_required=True,
            ),
        )


class OutgoingCallingPlanDigitPatternOriginatingPermission(OCIType):
    """
    Indicates whether originating calls using specified digit patterns are permitted.


    Attributes:
        digit_pattern_name (str): digitPatternName
        permission (str): permission
    """

    __slots__: List[str] = [
        "digit_pattern_name",
        "permission",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_name",
                "digitPatternName",
                str,
                is_required=True,
            ),
            E(
                "permission",
                "permission",
                str,
                is_required=True,
            ),
        )


class OutgoingCallingPlanDigitPatternRedirectingPermission(OCIType):
    """
    Indicates whether redirecting calls using specified digit patterns are permitted.


    Attributes:
        digit_pattern_name (str): digitPatternName
        permission (bool): permission
    """

    __slots__: List[str] = [
        "digit_pattern_name",
        "permission",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_name",
                "digitPatternName",
                str,
                is_required=True,
            ),
            E(
                "permission",
                "permission",
                bool,
                is_required=True,
            ),
        )


class OutgoingCallingPlanOriginatingPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions.


    Attributes:
        group (str): group
        local (str): local
        toll_free (str): tollFree
        toll (str): toll
        international (str): international
        operator_assisted (str): operatorAssisted
        chargeable_directory_assisted (str): chargeableDirectoryAssisted
        special_services_i (str): specialServicesI
        special_services_ii (str): specialServicesII
        premium_services_i (str): premiumServicesI
        premium_services_ii (str): premiumServicesII
        casual (str): casual
        url_dialing (str): urlDialing
        unknown (str): unknown
    """

    __slots__: List[str] = [
        "group",
        "local",
        "toll_free",
        "toll",
        "international",
        "operator_assisted",
        "chargeable_directory_assisted",
        "special_services_i",
        "special_services_ii",
        "premium_services_i",
        "premium_services_ii",
        "casual",
        "url_dialing",
        "unknown",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group",
                "group",
                str,
                is_required=True,
            ),
            E(
                "local",
                "local",
                str,
                is_required=True,
            ),
            E(
                "toll_free",
                "tollFree",
                str,
                is_required=True,
            ),
            E(
                "toll",
                "toll",
                str,
                is_required=True,
            ),
            E(
                "international",
                "international",
                str,
                is_required=True,
            ),
            E(
                "operator_assisted",
                "operatorAssisted",
                str,
                is_required=True,
            ),
            E(
                "chargeable_directory_assisted",
                "chargeableDirectoryAssisted",
                str,
                is_required=True,
            ),
            E(
                "special_services_i",
                "specialServicesI",
                str,
                is_required=True,
            ),
            E(
                "special_services_ii",
                "specialServicesII",
                str,
                is_required=True,
            ),
            E(
                "premium_services_i",
                "premiumServicesI",
                str,
                is_required=True,
            ),
            E(
                "premium_services_ii",
                "premiumServicesII",
                str,
                is_required=True,
            ),
            E(
                "casual",
                "casual",
                str,
                is_required=True,
            ),
            E(
                "url_dialing",
                "urlDialing",
                str,
                is_required=True,
            ),
            E(
                "unknown",
                "unknown",
                str,
                is_required=True,
            ),
        )


class OutgoingCallingPlanOriginatingPermissionsModify(OCIType):
    """
    Outgoing Calling Plan originating call permissions.


    Attributes:
        group (str): group *Optional*
        local (str): local *Optional*
        toll_free (str): tollFree *Optional*
        toll (str): toll *Optional*
        international (str): international *Optional*
        operator_assisted (str): operatorAssisted *Optional*
        chargeable_directory_assisted (str): chargeableDirectoryAssisted *Optional*
        special_services_i (str): specialServicesI *Optional*
        special_services_ii (str): specialServicesII *Optional*
        premium_services_i (str): premiumServicesI *Optional*
        premium_services_ii (str): premiumServicesII *Optional*
        casual (str): casual *Optional*
        url_dialing (str): urlDialing *Optional*
        unknown (str): unknown *Optional*
    """

    __slots__: List[str] = [
        "group",
        "local",
        "toll_free",
        "toll",
        "international",
        "operator_assisted",
        "chargeable_directory_assisted",
        "special_services_i",
        "special_services_ii",
        "premium_services_i",
        "premium_services_ii",
        "casual",
        "url_dialing",
        "unknown",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group",
                "group",
                str,
            ),
            E(
                "local",
                "local",
                str,
            ),
            E(
                "toll_free",
                "tollFree",
                str,
            ),
            E(
                "toll",
                "toll",
                str,
            ),
            E(
                "international",
                "international",
                str,
            ),
            E(
                "operator_assisted",
                "operatorAssisted",
                str,
            ),
            E(
                "chargeable_directory_assisted",
                "chargeableDirectoryAssisted",
                str,
            ),
            E(
                "special_services_i",
                "specialServicesI",
                str,
            ),
            E(
                "special_services_ii",
                "specialServicesII",
                str,
            ),
            E(
                "premium_services_i",
                "premiumServicesI",
                str,
            ),
            E(
                "premium_services_ii",
                "premiumServicesII",
                str,
            ),
            E(
                "casual",
                "casual",
                str,
            ),
            E(
                "url_dialing",
                "urlDialing",
                str,
            ),
            E(
                "unknown",
                "unknown",
                str,
            ),
        )


class OutgoingCallingPlanRedirectedPermissions(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions.


    Attributes:
        outside_group (bool): outsideGroup
    """

    __slots__: List[str] = [
        "outside_group",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "outside_group",
                "outsideGroup",
                bool,
                is_required=True,
            ),
        )


class OutgoingCallingPlanRedirectedPermissionsModify(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions.


    Attributes:
        outside_group (bool): outsideGroup *Optional*
    """

    __slots__: List[str] = [
        "outside_group",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "outside_group",
                "outsideGroup",
                bool,
            ),
        )


class OutgoingCallingPlanRedirectingPermissions(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions.


    Attributes:
        group (bool): group
        local (bool): local
        toll_free (bool): tollFree
        toll (bool): toll
        international (bool): international
        operator_assisted (bool): operatorAssisted
        chargeable_directory_assisted (bool): chargeableDirectoryAssisted
        special_services_i (bool): specialServicesI
        special_services_ii (bool): specialServicesII
        premium_services_i (bool): premiumServicesI
        premium_services_ii (bool): premiumServicesII
        casual (bool): casual
        url_dialing (bool): urlDialing
        unknown (bool): unknown
    """

    __slots__: List[str] = [
        "group",
        "local",
        "toll_free",
        "toll",
        "international",
        "operator_assisted",
        "chargeable_directory_assisted",
        "special_services_i",
        "special_services_ii",
        "premium_services_i",
        "premium_services_ii",
        "casual",
        "url_dialing",
        "unknown",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group",
                "group",
                bool,
                is_required=True,
            ),
            E(
                "local",
                "local",
                bool,
                is_required=True,
            ),
            E(
                "toll_free",
                "tollFree",
                bool,
                is_required=True,
            ),
            E(
                "toll",
                "toll",
                bool,
                is_required=True,
            ),
            E(
                "international",
                "international",
                bool,
                is_required=True,
            ),
            E(
                "operator_assisted",
                "operatorAssisted",
                bool,
                is_required=True,
            ),
            E(
                "chargeable_directory_assisted",
                "chargeableDirectoryAssisted",
                bool,
                is_required=True,
            ),
            E(
                "special_services_i",
                "specialServicesI",
                bool,
                is_required=True,
            ),
            E(
                "special_services_ii",
                "specialServicesII",
                bool,
                is_required=True,
            ),
            E(
                "premium_services_i",
                "premiumServicesI",
                bool,
                is_required=True,
            ),
            E(
                "premium_services_ii",
                "premiumServicesII",
                bool,
                is_required=True,
            ),
            E(
                "casual",
                "casual",
                bool,
                is_required=True,
            ),
            E(
                "url_dialing",
                "urlDialing",
                bool,
                is_required=True,
            ),
            E(
                "unknown",
                "unknown",
                bool,
                is_required=True,
            ),
        )


class OutgoingCallingPlanRedirectingPermissionsModify(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions.


    Attributes:
        group (bool): group *Optional*
        local (bool): local *Optional*
        toll_free (bool): tollFree *Optional*
        toll (bool): toll *Optional*
        international (bool): international *Optional*
        operator_assisted (bool): operatorAssisted *Optional*
        chargeable_directory_assisted (bool): chargeableDirectoryAssisted *Optional*
        special_services_i (bool): specialServicesI *Optional*
        special_services_ii (bool): specialServicesII *Optional*
        premium_services_i (bool): premiumServicesI *Optional*
        premium_services_ii (bool): premiumServicesII *Optional*
        casual (bool): casual *Optional*
        url_dialing (bool): urlDialing *Optional*
        unknown (bool): unknown *Optional*
    """

    __slots__: List[str] = [
        "group",
        "local",
        "toll_free",
        "toll",
        "international",
        "operator_assisted",
        "chargeable_directory_assisted",
        "special_services_i",
        "special_services_ii",
        "premium_services_i",
        "premium_services_ii",
        "casual",
        "url_dialing",
        "unknown",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group",
                "group",
                bool,
            ),
            E(
                "local",
                "local",
                bool,
            ),
            E(
                "toll_free",
                "tollFree",
                bool,
            ),
            E(
                "toll",
                "toll",
                bool,
            ),
            E(
                "international",
                "international",
                bool,
            ),
            E(
                "operator_assisted",
                "operatorAssisted",
                bool,
            ),
            E(
                "chargeable_directory_assisted",
                "chargeableDirectoryAssisted",
                bool,
            ),
            E(
                "special_services_i",
                "specialServicesI",
                bool,
            ),
            E(
                "special_services_ii",
                "specialServicesII",
                bool,
            ),
            E(
                "premium_services_i",
                "premiumServicesI",
                bool,
            ),
            E(
                "premium_services_ii",
                "premiumServicesII",
                bool,
            ),
            E(
                "casual",
                "casual",
                bool,
            ),
            E(
                "url_dialing",
                "urlDialing",
                bool,
            ),
            E(
                "unknown",
                "unknown",
                bool,
            ),
        )


class OutgoingCallingPlanTransferNumbers(OCIType):
    """
    Outgoing Calling Plan transfer numbers.


    Attributes:
        phone_number01 (str): phoneNumber01 *Optional*
        phone_number02 (str): phoneNumber02 *Optional*
        phone_number03 (str): phoneNumber03 *Optional*
    """

    __slots__: List[str] = [
        "phone_number01",
        "phone_number02",
        "phone_number03",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number01",
                "phoneNumber01",
                str,
            ),
            E(
                "phone_number02",
                "phoneNumber02",
                str,
            ),
            E(
                "phone_number03",
                "phoneNumber03",
                str,
            ),
        )


class OutgoingCallingPlanTransferNumbersModify(OCIType):
    """
    Outgoing Calling Plan transfer numbers.


    Attributes:
        phone_number01 (str): phoneNumber01 *Optional*
        phone_number02 (str): phoneNumber02 *Optional*
        phone_number03 (str): phoneNumber03 *Optional*
    """

    __slots__: List[str] = [
        "phone_number01",
        "phone_number02",
        "phone_number03",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number01",
                "phoneNumber01",
                str,
            ),
            E(
                "phone_number02",
                "phoneNumber02",
                str,
            ),
            E(
                "phone_number03",
                "phoneNumber03",
                str,
            ),
        )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission(OCIType):
    """
    Indicates whether Call Me Now calls using specified Pinhole digit patterns are
    permitted.


    Attributes:
        digit_pattern_name (str): digitPatternName
        permission (str): permission
    """

    __slots__: List[str] = [
        "digit_pattern_name",
        "permission",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_name",
                "digitPatternName",
                str,
                is_required=True,
            ),
            E(
                "permission",
                "permission",
                str,
                is_required=True,
            ),
        )


class OutgoingPinholeDigitPlanDigitPatternOriginatingPermission(OCIType):
    """
    Indicates whether originating calls using specified Pinhole digit patterns are
    permitted.


    Attributes:
        digit_pattern_name (str): digitPatternName
        permission (str): permission
    """

    __slots__: List[str] = [
        "digit_pattern_name",
        "permission",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_name",
                "digitPatternName",
                str,
                is_required=True,
            ),
            E(
                "permission",
                "permission",
                str,
                is_required=True,
            ),
        )


class OutgoingPinholeDigitPlanDigitPatternRedirectingPermission(OCIType):
    """
    Indicates whether redirecting calls using specified Pinhole digit patterns are
    permitted.


    Attributes:
        digit_pattern_name (str): digitPatternName
        permission (str): permission
    """

    __slots__: List[str] = [
        "digit_pattern_name",
        "permission",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_name",
                "digitPatternName",
                str,
                is_required=True,
            ),
            E(
                "permission",
                "permission",
                str,
                is_required=True,
            ),
        )


class PasscodeMenuKeysModifyEntry(OCIType):
    """
    The voice portal passcode menu keys modify entry.


    Attributes:
        finish_entering_or_reentering_passcode (str): finishEnteringOrReenteringPasscode
            *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
    """

    __slots__: List[str] = [
        "finish_entering_or_reentering_passcode",
        "return_to_previous_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "finish_entering_or_reentering_passcode",
                "finishEnteringOrReenteringPasscode",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
        )


class PasscodeMenuKeysReadEntry(OCIType):
    """
    The voice portal passcode menu keys.


    Attributes:
        finish_entering_or_reentering_passcode (str): finishEnteringOrReenteringPasscode
        return_to_previous_menu (str): returnToPreviousMenu
    """

    __slots__: List[str] = [
        "finish_entering_or_reentering_passcode",
        "return_to_previous_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "finish_entering_or_reentering_passcode",
                "finishEnteringOrReenteringPasscode",
                str,
                is_required=True,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
        )


class PasswordForAccessDevice(OCIType):
    """
    Passwords to be generated for an access device.

    The combination of serviceProviderId, groupId, and deviceName will be used to find the
    device if it exists.  If the device doesn't exist yet, then the serviceProviderId and
    groupId will be used to choose the password rules with which to generate the device
    password.

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName *Optional*
        generate_device_authentication_password (bool):
            generateDeviceAuthenticationPassword
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "generate_device_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "generate_device_authentication_password",
                "generateDeviceAuthenticationPassword",
                bool,
                is_required=True,
            ),
        )


class PasswordForGroupAdministrator(OCIType):
    """
    Password to be generated for a group administrator.

    If the administratorId is not included, or included but is not an exiting
    administrator for the group, a password will be generated based on only the rules
    applicable for a new user.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        administrator_id (str): administratorId *Optional*
        generate_password (bool): generatePassword
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "administrator_id",
        "generate_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "administrator_id",
                "administratorId",
                str,
            ),
            E(
                "generate_password",
                "generatePassword",
                bool,
                is_required=True,
            ),
        )


class PasswordForServiceProviderAdministrator(OCIType):
    """
    Password to be generated for a service provider administrator.

    If the administratorId is not included, or included but is not an exiting
    administrator for the service provider, a password will be generated based on only the
    rules applicable for a new user.

    Attributes:
        service_provider_id (str): serviceProviderId
        administrator_id (str): administratorId *Optional*
        generate_password (bool): generatePassword
    """

    __slots__: List[str] = [
        "service_provider_id",
        "administrator_id",
        "generate_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "administrator_id",
                "administratorId",
                str,
            ),
            E(
                "generate_password",
                "generatePassword",
                bool,
                is_required=True,
            ),
        )


class PasswordForSystemAdministrator(OCIType):
    """
    Password to be generated for a System or Provisioning administrator.

    If the administratorId is not included, or included but is not an exiting
    administrator for the service provider, a password will be generated based on only the
    rules applicable for a new user.

    Attributes:
        administrator_id (str): administratorId *Optional*
        generate_password (bool): generatePassword
    """

    __slots__: List[str] = [
        "administrator_id",
        "generate_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "administrator_id",
                "administratorId",
                str,
            ),
            E(
                "generate_password",
                "generatePassword",
                bool,
                is_required=True,
            ),
        )


class PasswordForTrunkGroup(OCIType):
    """
    Passwords to be generated for a trunk group.

    The combination of serviceProviderId, groupId, and name will be used to find the trunk
    group if it exists.  If the trunk group doesn't exist yet, then the serviceProviderId
    and groupId will be used to choose the password rules with which to generate the trunk
    group password.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name *Optional*
        generate_trunk_group_authentication_password (bool):
            generateTrunkGroupAuthenticationPassword
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "generate_trunk_group_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
            ),
            E(
                "generate_trunk_group_authentication_password",
                "generateTrunkGroupAuthenticationPassword",
                bool,
                is_required=True,
            ),
        )


class PasswordForUser(OCIType):
    """
    Passwords, passcode and SIP authentication passwords to be generated for a user.

    If the userId is not included or included but is not an existing user in the group, a
    password will be generated based on only the rules applicable for a new user.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        user_id (str): userId *Optional*
        generate_password (bool): generatePassword *Optional*
        generate_passcode (bool): generatePasscode *Optional*
        generate_sip_password (bool): generateSipPassword *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "user_id",
        "generate_password",
        "generate_passcode",
        "generate_sip_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "generate_password",
                "generatePassword",
                bool,
            ),
            E(
                "generate_passcode",
                "generatePasscode",
                bool,
            ),
            E(
                "generate_sip_password",
                "generateSipPassword",
                bool,
            ),
        )


class PersonalAssistantMenuKeysModifyEntry(OCIType):
    """
    The voice portal personal assistant menu keys modify entry.


    Attributes:
        set_presence_to_none (str): setPresenceToNone *Optional*
        set_presence_to_business_trip (str): setPresenceToBusinessTrip *Optional*
        set_presence_to_gone_for_the_day (str): setPresenceToGoneForTheDay *Optional*
        set_presence_to_lunch (str): setPresenceToLunch *Optional*
        set_presence_to_meeting (str): setPresenceToMeeting *Optional*
        set_presence_to_out_of_office (str): setPresenceToOutOfOffice *Optional*
        set_presence_to_temporarily_out (str): setPresenceToTemporarilyOut *Optional*
        set_presence_to_training (str): setPresenceToTraining *Optional*
        set_presence_to_unavailable (str): setPresenceToUnavailable *Optional*
        set_presence_to_vacation (str): setPresenceToVacation *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "set_presence_to_none",
        "set_presence_to_business_trip",
        "set_presence_to_gone_for_the_day",
        "set_presence_to_lunch",
        "set_presence_to_meeting",
        "set_presence_to_out_of_office",
        "set_presence_to_temporarily_out",
        "set_presence_to_training",
        "set_presence_to_unavailable",
        "set_presence_to_vacation",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "set_presence_to_none",
                "setPresenceToNone",
                str,
            ),
            E(
                "set_presence_to_business_trip",
                "setPresenceToBusinessTrip",
                str,
            ),
            E(
                "set_presence_to_gone_for_the_day",
                "setPresenceToGoneForTheDay",
                str,
            ),
            E(
                "set_presence_to_lunch",
                "setPresenceToLunch",
                str,
            ),
            E(
                "set_presence_to_meeting",
                "setPresenceToMeeting",
                str,
            ),
            E(
                "set_presence_to_out_of_office",
                "setPresenceToOutOfOffice",
                str,
            ),
            E(
                "set_presence_to_temporarily_out",
                "setPresenceToTemporarilyOut",
                str,
            ),
            E(
                "set_presence_to_training",
                "setPresenceToTraining",
                str,
            ),
            E(
                "set_presence_to_unavailable",
                "setPresenceToUnavailable",
                str,
            ),
            E(
                "set_presence_to_vacation",
                "setPresenceToVacation",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class PersonalAssistantMenuKeysReadEntry(OCIType):
    """
    The voice portal personal assistant menu keys.


    Attributes:
        set_presence_to_none (str): setPresenceToNone *Optional*
        set_presence_to_business_trip (str): setPresenceToBusinessTrip *Optional*
        set_presence_to_gone_for_the_day (str): setPresenceToGoneForTheDay *Optional*
        set_presence_to_lunch (str): setPresenceToLunch *Optional*
        set_presence_to_meeting (str): setPresenceToMeeting *Optional*
        set_presence_to_out_of_office (str): setPresenceToOutOfOffice *Optional*
        set_presence_to_temporarily_out (str): setPresenceToTemporarilyOut *Optional*
        set_presence_to_training (str): setPresenceToTraining *Optional*
        set_presence_to_unavailable (str): setPresenceToUnavailable *Optional*
        set_presence_to_vacation (str): setPresenceToVacation *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "set_presence_to_none",
        "set_presence_to_business_trip",
        "set_presence_to_gone_for_the_day",
        "set_presence_to_lunch",
        "set_presence_to_meeting",
        "set_presence_to_out_of_office",
        "set_presence_to_temporarily_out",
        "set_presence_to_training",
        "set_presence_to_unavailable",
        "set_presence_to_vacation",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "set_presence_to_none",
                "setPresenceToNone",
                str,
            ),
            E(
                "set_presence_to_business_trip",
                "setPresenceToBusinessTrip",
                str,
            ),
            E(
                "set_presence_to_gone_for_the_day",
                "setPresenceToGoneForTheDay",
                str,
            ),
            E(
                "set_presence_to_lunch",
                "setPresenceToLunch",
                str,
            ),
            E(
                "set_presence_to_meeting",
                "setPresenceToMeeting",
                str,
            ),
            E(
                "set_presence_to_out_of_office",
                "setPresenceToOutOfOffice",
                str,
            ),
            E(
                "set_presence_to_temporarily_out",
                "setPresenceToTemporarilyOut",
                str,
            ),
            E(
                "set_presence_to_training",
                "setPresenceToTraining",
                str,
            ),
            E(
                "set_presence_to_unavailable",
                "setPresenceToUnavailable",
                str,
            ),
            E(
                "set_presence_to_vacation",
                "setPresenceToVacation",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class PersonalizedNameMenuKeysModifyEntry(OCIType):
    """
    The voice portal personalized name menu keys modify entry.


    Attributes:
        record_new_personalized_name (str): recordNewPersonalizedName *Optional*
        listen_to_current_personalized_name (str): listenToCurrentPersonalizedName
            *Optional*
        delete_personalized_name (str): deletePersonalizedName *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "record_new_personalized_name",
        "listen_to_current_personalized_name",
        "delete_personalized_name",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "record_new_personalized_name",
                "recordNewPersonalizedName",
                str,
            ),
            E(
                "listen_to_current_personalized_name",
                "listenToCurrentPersonalizedName",
                str,
            ),
            E(
                "delete_personalized_name",
                "deletePersonalizedName",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class PersonalizedNameMenuKeysReadEntry(OCIType):
    """
    The voice portal personalized name menu keys.


    Attributes:
        record_new_personalized_name (str): recordNewPersonalizedName *Optional*
        listen_to_current_personalized_name (str): listenToCurrentPersonalizedName
            *Optional*
        delete_personalized_name (str): deletePersonalizedName *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "record_new_personalized_name",
        "listen_to_current_personalized_name",
        "delete_personalized_name",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "record_new_personalized_name",
                "recordNewPersonalizedName",
                str,
            ),
            E(
                "listen_to_current_personalized_name",
                "listenToCurrentPersonalizedName",
                str,
            ),
            E(
                "delete_personalized_name",
                "deletePersonalizedName",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class PhoneListEntry(OCIType):
    """
    Phone list entry.


    Attributes:
        entry_name (str): entryName
        phone_number (str): phoneNumber
    """

    __slots__: List[str] = [
        "entry_name",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "entry_name",
                "entryName",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
        )


class PlayGreetingMenuKeysModifyEntry(OCIType):
    """
    The voice portal play greeting menu keys modify entry.


    Attributes:
        skip_backward (str): skipBackward *Optional*
        pause_or_resume (str): pauseOrResume *Optional*
        skip_forward (str): skipForward *Optional*
        jump_to_begin (str): jumpToBegin *Optional*
        jump_to_end (str): jumpToEnd *Optional*
    """

    __slots__: List[str] = [
        "skip_backward",
        "pause_or_resume",
        "skip_forward",
        "jump_to_begin",
        "jump_to_end",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "skip_backward",
                "skipBackward",
                str,
            ),
            E(
                "pause_or_resume",
                "pauseOrResume",
                str,
            ),
            E(
                "skip_forward",
                "skipForward",
                str,
            ),
            E(
                "jump_to_begin",
                "jumpToBegin",
                str,
            ),
            E(
                "jump_to_end",
                "jumpToEnd",
                str,
            ),
        )


class PlayGreetingMenuKeysReadEntry(OCIType):
    """
    The voice portal play greeting menu keys.


    Attributes:
        skip_backward (str): skipBackward *Optional*
        pause_or_resume (str): pauseOrResume *Optional*
        skip_forward (str): skipForward *Optional*
        jump_to_begin (str): jumpToBegin *Optional*
        jump_to_end (str): jumpToEnd *Optional*
    """

    __slots__: List[str] = [
        "skip_backward",
        "pause_or_resume",
        "skip_forward",
        "jump_to_begin",
        "jump_to_end",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "skip_backward",
                "skipBackward",
                str,
            ),
            E(
                "pause_or_resume",
                "pauseOrResume",
                str,
            ),
            E(
                "skip_forward",
                "skipForward",
                str,
            ),
            E(
                "jump_to_begin",
                "jumpToBegin",
                str,
            ),
            E(
                "jump_to_end",
                "jumpToEnd",
                str,
            ),
        )


class PlayMessageMenuKeysModifyEntry(OCIType):
    """
    The voice portal play message menu keys modify entry.


    Attributes:
        skip_backward (str): skipBackward *Optional*
        pause_or_resume (str): pauseOrResume *Optional*
        skip_forward (str): skipForward *Optional*
        jump_to_begin (str): jumpToBegin *Optional*
        jump_to_end (str): jumpToEnd *Optional*
    """

    __slots__: List[str] = [
        "skip_backward",
        "pause_or_resume",
        "skip_forward",
        "jump_to_begin",
        "jump_to_end",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "skip_backward",
                "skipBackward",
                str,
            ),
            E(
                "pause_or_resume",
                "pauseOrResume",
                str,
            ),
            E(
                "skip_forward",
                "skipForward",
                str,
            ),
            E(
                "jump_to_begin",
                "jumpToBegin",
                str,
            ),
            E(
                "jump_to_end",
                "jumpToEnd",
                str,
            ),
        )


class PlayMessageMenuKeysReadEntry(OCIType):
    """
    The voice portal play message menu keys.


    Attributes:
        skip_backward (str): skipBackward *Optional*
        pause_or_resume (str): pauseOrResume *Optional*
        skip_forward (str): skipForward *Optional*
        jump_to_begin (str): jumpToBegin *Optional*
        jump_to_end (str): jumpToEnd *Optional*
    """

    __slots__: List[str] = [
        "skip_backward",
        "pause_or_resume",
        "skip_forward",
        "jump_to_begin",
        "jump_to_end",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "skip_backward",
                "skipBackward",
                str,
            ),
            E(
                "pause_or_resume",
                "pauseOrResume",
                str,
            ),
            E(
                "skip_forward",
                "skipForward",
                str,
            ),
            E(
                "jump_to_begin",
                "jumpToBegin",
                str,
            ),
            E(
                "jump_to_end",
                "jumpToEnd",
                str,
            ),
        )


class PlayMessagesMenuKeysModifyEntry(OCIType):
    """
    The voice portal play message menu keys modify entry.


    Attributes:
        save_message (str): saveMessage *Optional*
        delete_message (str): deleteMessage *Optional*
        play_message (str): playMessage *Optional*
        previous_message (str): previousMessage *Optional*
        play_envelope (str): playEnvelope *Optional*
        next_message (str): nextMessage *Optional*
        callback_caller (str): callbackCaller *Optional*
        compose_message (str): composeMessage *Optional*
        reply_message (str): replyMessage *Optional*
        forward_message (str): forwardMessage *Optional*
        additional_message_options (str): additionalMessageOptions *Optional*
        personalized_name (str): personalizedName *Optional*
        passcode (str): passcode *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "save_message",
        "delete_message",
        "play_message",
        "previous_message",
        "play_envelope",
        "next_message",
        "callback_caller",
        "compose_message",
        "reply_message",
        "forward_message",
        "additional_message_options",
        "personalized_name",
        "passcode",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "save_message",
                "saveMessage",
                str,
            ),
            E(
                "delete_message",
                "deleteMessage",
                str,
            ),
            E(
                "play_message",
                "playMessage",
                str,
            ),
            E(
                "previous_message",
                "previousMessage",
                str,
            ),
            E(
                "play_envelope",
                "playEnvelope",
                str,
            ),
            E(
                "next_message",
                "nextMessage",
                str,
            ),
            E(
                "callback_caller",
                "callbackCaller",
                str,
            ),
            E(
                "compose_message",
                "composeMessage",
                str,
            ),
            E(
                "reply_message",
                "replyMessage",
                str,
            ),
            E(
                "forward_message",
                "forwardMessage",
                str,
            ),
            E(
                "additional_message_options",
                "additionalMessageOptions",
                str,
            ),
            E(
                "personalized_name",
                "personalizedName",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class PlayMessagesMenuKeysReadEntry(OCIType):
    """
    The voice portal play message menu keys.


    Attributes:
        save_message (str): saveMessage *Optional*
        delete_message (str): deleteMessage *Optional*
        play_message (str): playMessage *Optional*
        previous_message (str): previousMessage *Optional*
        play_envelope (str): playEnvelope *Optional*
        next_message (str): nextMessage *Optional*
        callback_caller (str): callbackCaller *Optional*
        compose_message (str): composeMessage *Optional*
        reply_message (str): replyMessage *Optional*
        forward_message (str): forwardMessage *Optional*
        additional_message_options (str): additionalMessageOptions *Optional*
        personalized_name (str): personalizedName *Optional*
        passcode (str): passcode *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "save_message",
        "delete_message",
        "play_message",
        "previous_message",
        "play_envelope",
        "next_message",
        "callback_caller",
        "compose_message",
        "reply_message",
        "forward_message",
        "additional_message_options",
        "personalized_name",
        "passcode",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "save_message",
                "saveMessage",
                str,
            ),
            E(
                "delete_message",
                "deleteMessage",
                str,
            ),
            E(
                "play_message",
                "playMessage",
                str,
            ),
            E(
                "previous_message",
                "previousMessage",
                str,
            ),
            E(
                "play_envelope",
                "playEnvelope",
                str,
            ),
            E(
                "next_message",
                "nextMessage",
                str,
            ),
            E(
                "callback_caller",
                "callbackCaller",
                str,
            ),
            E(
                "compose_message",
                "composeMessage",
                str,
            ),
            E(
                "reply_message",
                "replyMessage",
                str,
            ),
            E(
                "forward_message",
                "forwardMessage",
                str,
            ),
            E(
                "additional_message_options",
                "additionalMessageOptions",
                str,
            ),
            E(
                "personalized_name",
                "personalizedName",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class PrimaryUserInfo(OCIType):
    """
    Primary user information.


    Attributes:
        user_id (str): userId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        user_first_name (str): userFirstName *Optional*
        user_last_name (str): userLastName *Optional*
        user_phone_number (str): userPhoneNumber *Optional*
        user_extension (str): userExtension *Optional*
        end_point_type (str): endPointType *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "service_provider_id",
        "group_id",
        "user_first_name",
        "user_last_name",
        "user_phone_number",
        "user_extension",
        "end_point_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "user_first_name",
                "userFirstName",
                str,
            ),
            E(
                "user_last_name",
                "userLastName",
                str,
            ),
            E(
                "user_phone_number",
                "userPhoneNumber",
                str,
            ),
            E(
                "user_extension",
                "userExtension",
                str,
            ),
            E(
                "end_point_type",
                "endPointType",
                str,
            ),
        )


class PriorityAlertCriteriaFromDn(OCIType):
    """
    The from dn criteria used within an add/get request.


    Attributes:
        from_dn_criteria_selection (str): fromDnCriteriaSelection
        include_anonymous_callers (bool): includeAnonymousCallers
        include_unavailable_callers (bool): includeUnavailableCallers
        phone_number (List[str]): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "from_dn_criteria_selection",
        "include_anonymous_callers",
        "include_unavailable_callers",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "from_dn_criteria_selection",
                "fromDnCriteriaSelection",
                str,
                is_required=True,
            ),
            E(
                "include_anonymous_callers",
                "includeAnonymousCallers",
                bool,
                is_required=True,
            ),
            E(
                "include_unavailable_callers",
                "includeUnavailableCallers",
                bool,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
        )


class ProfileAndServiceAnonymousCallRejectionInfo(OCIType):
    """
    This is the configuration parameters for anonymous Call Rejection service

    Attributes:
        is_active (bool): isActive
    """

    __slots__: List[str] = [
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServiceAutomaticCallbackInfo(OCIType):
    """
    This is the configuration parameters for anonymous Call Rejection service

    Attributes:
        is_active (bool): isActive
    """

    __slots__: List[str] = [
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServiceBusyLampFieldInfo(OCIType):
    """
    This is the configuration parameters for Busy Lamp Field service The
    monitoredUserTable has column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension",
    "Department", "Email Address", "IMP Id".


    Attributes:
        list_uri (str): listURI *Optional*
        enable_call_park_notification (bool): enableCallParkNotification
        monitored_user_table (List(monitoredUserTable)): monitoredUserTable - *Table*
            array of monitoredUserTable named tuples
    """

    __slots__: List[str] = [
        "list_uri",
        "enable_call_park_notification",
        "monitored_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "list_uri",
                "listURI",
                str,
            ),
            E(
                "enable_call_park_notification",
                "enableCallParkNotification",
                bool,
                is_required=True,
            ),
            E(
                "monitored_user_table",
                "monitoredUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class ProfileAndServiceCallForwardAlwaysInfo(OCIType):
    """
    This is the configuration parameters for Call Forward Always service

    Attributes:
        is_active (bool): isActive
        forward_to_phone_number (str): forwardToPhoneNumber *Optional*
        is_ring_splash_active (bool): isRingSplashActive
    """

    __slots__: List[str] = [
        "is_active",
        "forward_to_phone_number",
        "is_ring_splash_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "forward_to_phone_number",
                "forwardToPhoneNumber",
                str,
            ),
            E(
                "is_ring_splash_active",
                "isRingSplashActive",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServiceCallForwardingBusyInfo(OCIType):
    """
    This is the configuration parameters for Call Forwarding Busy service

    Attributes:
        is_active (bool): isActive
        forward_to_phone_number (str): forwardToPhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "forward_to_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "forward_to_phone_number",
                "forwardToPhoneNumber",
                str,
            ),
        )


class ProfileAndServiceCallForwardingNoAnswerInfo(OCIType):
    """
    This is the configuration parameters for Call Forwarding No Answer service

    Attributes:
        is_active (bool): isActive
        forward_to_phone_number (str): forwardToPhoneNumber *Optional*
        number_of_rings (int): numberOfRings
    """

    __slots__: List[str] = [
        "is_active",
        "forward_to_phone_number",
        "number_of_rings",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "forward_to_phone_number",
                "forwardToPhoneNumber",
                str,
            ),
            E(
                "number_of_rings",
                "numberOfRings",
                int,
                is_required=True,
            ),
        )


class ProfileAndServiceCallForwardingSelectiveInfo(OCIType):
    """
    This is the configuration parameters for Call Forwarding Selective service The
    criteria table's column headings are: "Is Active", "Criteria Name", "Time Schedule",
    "Calls From", "Forward To", "Blacklisted", "Holiday Schedule" The "Calls From" column
    is a string containing call numbers

    Attributes:
        is_active (bool): isActive
        default_forward_to_phone_number (str): defaultForwardToPhoneNumber *Optional*
        play_ring_reminder (bool): playRingReminder
        criteria_table (List(criteriaTable)): criteriaTable - *Table* array of
            criteriaTable named tuples
    """

    __slots__: List[str] = [
        "is_active",
        "default_forward_to_phone_number",
        "play_ring_reminder",
        "criteria_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "default_forward_to_phone_number",
                "defaultForwardToPhoneNumber",
                str,
            ),
            E(
                "play_ring_reminder",
                "playRingReminder",
                bool,
                is_required=True,
            ),
            E(
                "criteria_table",
                "criteriaTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class ProfileAndServiceCallNotifyInfo(OCIType):
    """
    This is the configuration parameters for Call Notify service The criteria table's
    column headings are: "Is Active", "Criteria Name", "Time Schedule", "Calls From",
    "Blacklisted" ,"Holiday Schedule" The "Calls From" column is a string containing call
    numbers

    Attributes:
        call_notify_email_address (str): callNotifyEmailAddress *Optional*
        criteria_table (List(criteriaTable)): criteriaTable - *Table* array of
            criteriaTable named tuples
    """

    __slots__: List[str] = [
        "call_notify_email_address",
        "criteria_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_notify_email_address",
                "callNotifyEmailAddress",
                str,
            ),
            E(
                "criteria_table",
                "criteriaTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class ProfileAndServiceCallTransferInfo(OCIType):
    """
    This is the configuration parameters for Call Transfer service

    Attributes:
        is_recall_active (bool): isRecallActive
        recall_number_of_rings (int): recallNumberOfRings
        use_diversion_inhibitor_for_blind_transfer (bool):
            useDiversionInhibitorForBlindTransfer
        use_diversion_inhibitor_for_consultative_calls (bool):
            useDiversionInhibitorForConsultativeCalls
        enable_busy_camp_on (bool): enableBusyCampOn
        busy_camp_on_seconds (int): busyCampOnSeconds
    """

    __slots__: List[str] = [
        "is_recall_active",
        "recall_number_of_rings",
        "use_diversion_inhibitor_for_blind_transfer",
        "use_diversion_inhibitor_for_consultative_calls",
        "enable_busy_camp_on",
        "busy_camp_on_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_recall_active",
                "isRecallActive",
                bool,
                is_required=True,
            ),
            E(
                "recall_number_of_rings",
                "recallNumberOfRings",
                int,
                is_required=True,
            ),
            E(
                "use_diversion_inhibitor_for_blind_transfer",
                "useDiversionInhibitorForBlindTransfer",
                bool,
                is_required=True,
            ),
            E(
                "use_diversion_inhibitor_for_consultative_calls",
                "useDiversionInhibitorForConsultativeCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_busy_camp_on",
                "enableBusyCampOn",
                bool,
                is_required=True,
            ),
            E(
                "busy_camp_on_seconds",
                "busyCampOnSeconds",
                int,
                is_required=True,
            ),
        )


class ProfileAndServiceCallWaitingInfo(OCIType):
    """
    This is the configuration parameters for Call Transfer service

    Attributes:
        is_active (bool): isActive
        disable_calling_line_id_delivery (bool): disableCallingLineIdDelivery
    """

    __slots__: List[str] = [
        "is_active",
        "disable_calling_line_id_delivery",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "disable_calling_line_id_delivery",
                "disableCallingLineIdDelivery",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServiceCallingLineIDDeliveryBlockingInfo(OCIType):
    """
    This is the configuration parameters for Calling Line ID Delivery Blocking service

    Attributes:
        is_active (bool): isActive
    """

    __slots__: List[str] = [
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServiceCommunicationBarringUserControlInfo(OCIType):
    """
    This is the configuration parameters for Communication Barring User Control service
    profileTable has column headings: "Name", "Code", "Activated" and "Primary".


    Attributes:
        lockout_status (bool): lockoutStatus
        profile_table (List(profileTable)): profileTable - *Table* array of profileTable
            named tuples
    """

    __slots__: List[str] = [
        "lockout_status",
        "profile_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "lockout_status",
                "lockoutStatus",
                bool,
                is_required=True,
            ),
            E(
                "profile_table",
                "profileTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class ProfileAndServiceCustomRingbackInfo(OCIType):
    """
    This is the configuration parameters for Custom Ringback service The criteria table's
    column headings are: "Is Active", "Criteria Name", "Time Schedule", "Calls From",
    "Blacklisted", "Holiday Schedule".

    The "Calls From" column is a string containing call numbers

    Attributes:
        criteria_table (List(criteriaTable)): criteriaTable - *Table* array of
            criteriaTable named tuples
    """

    __slots__: List[str] = [
        "criteria_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria_table",
                "criteriaTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class ProfileAndServiceDirectedCallPickupWithBargeInInfo(OCIType):
    """
    This is the configuration parameters for Directed Call Pickup With Barge In service

    Attributes:
        enable_barge_in_warning_tone (bool): enableBargeInWarningTone
        enable_automatic_target_selection (bool): enableAutomaticTargetSelection
    """

    __slots__: List[str] = [
        "enable_barge_in_warning_tone",
        "enable_automatic_target_selection",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_barge_in_warning_tone",
                "enableBargeInWarningTone",
                bool,
                is_required=True,
            ),
            E(
                "enable_automatic_target_selection",
                "enableAutomaticTargetSelection",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServiceDoNotDisturbInfo(OCIType):
    """
    This is the configuration parameters for Do Not Disturb service

    Attributes:
        is_active (bool): isActive
        ring_splash (bool): ringSplash
    """

    __slots__: List[str] = [
        "is_active",
        "ring_splash",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "ring_splash",
                "ringSplash",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServiceExternalLineIDDeliveryInfo(OCIType):
    """
    This is the configuration parameters for External Line ID Delivery service

    Attributes:
        is_active (bool): isActive
    """

    __slots__: List[str] = [
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServiceInternalCallingLineIDDeliveryInfo(OCIType):
    """
    This is the configuration parameters for Internal Calling Line ID Delivery service

    Attributes:
        is_active (bool): isActive
    """

    __slots__: List[str] = [
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServicePreAlertingAnnouncementInfo(OCIType):
    """
    This is the configuration parameters for Pre Alerting Announcement service The
    criteria table's column headings are: "Is Active", "Criteria Name", "Blacklisted", and
    "Calls From".

    The "Calls From" column is a string containing call numbers

    Attributes:
        is_active (bool): isActive
        audio_selection (str): audioSelection
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        audio_file_url (str): audioFileUrl *Optional*
        video_selection (str): videoSelection
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
        video_file_url (str): videoFileUrl *Optional*
        criteria_table (List(criteriaTable)): criteriaTable - *Table* array of
            criteriaTable named tuples
    """

    __slots__: List[str] = [
        "is_active",
        "audio_selection",
        "audio_file_description",
        "audio_media_type",
        "audio_file_url",
        "video_selection",
        "video_file_description",
        "video_media_type",
        "video_file_url",
        "criteria_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "audio_selection",
                "audioSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "video_selection",
                "videoSelection",
                str,
                is_required=True,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
            E(
                "criteria_table",
                "criteriaTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class ProfileAndServiceSelectiveCallRejectionInfo(OCIType):
    """
    This is the configuration parameters for Selective Call Rejection service The criteria
    table's column headings are: "Is Active", "Criteria Name", "Time Schedule", "Calls
    From", "Blacklisted", "Holiday Schedule" The "Calls From" column is a string
    containing call numbers

    Attributes:
        criteria_table (List(criteriaTable)): criteriaTable - *Table* array of
            criteriaTable named tuples
    """

    __slots__: List[str] = [
        "criteria_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria_table",
                "criteriaTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class ProfileAndServiceSharedCallAppearanceInfo(OCIType):
    """
    This is the configuration parameters for shared call appearance service The
    endpointTable contains columns: "Device Level", "Device Name", "Device Type",
    "Line/Port", "SIP Contact", "Port Number".

    "Private Identity" . The "Device Level" column contains one of the AccessDeviceLevel
    enumerated constants.  Port numbers are only used by devices with static line
    ordering.

    Attributes:
        alert_all_appearances_for_click_to_dial_calls (bool):
            alertAllAppearancesForClickToDialCalls
        alert_all_appearances_for_group_paging_calls (bool):
            alertAllAppearancesForGroupPagingCalls
        max_appearances (int): maxAppearances
        allow_sca_call_retrieve (bool): allowSCACallRetrieve
        enable_multiple_call_arrangement (bool): enableMultipleCallArrangement
        multiple_call_arrangement_is_active (bool): multipleCallArrangementIsActive
        endpoint_table (List(endpointTable)): endpointTable - *Table* array of
            endpointTable named tuples
        allow_bridging_between_locations (bool): allowBridgingBetweenLocations
        bridge_warning_tone (str): bridgeWarningTone
        enable_call_park_notification (bool): enableCallParkNotification
        use_user_primary_with_alternate_calls_setting (bool):
            useUserPrimaryWithAlternateCallsSetting
        allow_simultaneous_primary_and_alternate (bool):
            allowSimultaneousPrimaryAndAlternate
        restrict_call_retrieve_of_primary (bool): restrictCallRetrieveOfPrimary
        restrict_call_bridging_of_primary (bool): restrictCallBridgingOfPrimary
    """

    __slots__: List[str] = [
        "alert_all_appearances_for_click_to_dial_calls",
        "alert_all_appearances_for_group_paging_calls",
        "max_appearances",
        "allow_sca_call_retrieve",
        "enable_multiple_call_arrangement",
        "multiple_call_arrangement_is_active",
        "endpoint_table",
        "allow_bridging_between_locations",
        "bridge_warning_tone",
        "enable_call_park_notification",
        "use_user_primary_with_alternate_calls_setting",
        "allow_simultaneous_primary_and_alternate",
        "restrict_call_retrieve_of_primary",
        "restrict_call_bridging_of_primary",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "alert_all_appearances_for_click_to_dial_calls",
                "alertAllAppearancesForClickToDialCalls",
                bool,
                is_required=True,
            ),
            E(
                "alert_all_appearances_for_group_paging_calls",
                "alertAllAppearancesForGroupPagingCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_appearances",
                "maxAppearances",
                int,
                is_required=True,
            ),
            E(
                "allow_sca_call_retrieve",
                "allowSCACallRetrieve",
                bool,
                is_required=True,
            ),
            E(
                "enable_multiple_call_arrangement",
                "enableMultipleCallArrangement",
                bool,
                is_required=True,
            ),
            E(
                "multiple_call_arrangement_is_active",
                "multipleCallArrangementIsActive",
                bool,
                is_required=True,
            ),
            E(
                "endpoint_table",
                "endpointTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
            E(
                "allow_bridging_between_locations",
                "allowBridgingBetweenLocations",
                bool,
                is_required=True,
            ),
            E(
                "bridge_warning_tone",
                "bridgeWarningTone",
                str,
                is_required=True,
            ),
            E(
                "enable_call_park_notification",
                "enableCallParkNotification",
                bool,
                is_required=True,
            ),
            E(
                "use_user_primary_with_alternate_calls_setting",
                "useUserPrimaryWithAlternateCallsSetting",
                bool,
                is_required=True,
            ),
            E(
                "allow_simultaneous_primary_and_alternate",
                "allowSimultaneousPrimaryAndAlternate",
                bool,
                is_required=True,
            ),
            E(
                "restrict_call_retrieve_of_primary",
                "restrictCallRetrieveOfPrimary",
                bool,
                is_required=True,
            ),
            E(
                "restrict_call_bridging_of_primary",
                "restrictCallBridgingOfPrimary",
                bool,
                is_required=True,
            ),
        )


class ProfileAndServiceThirdPartyVoiceMailInfo(OCIType):
    """
    This is the configuration parameters for Third Party Voice Mail service

    Attributes:
        is_active (bool): isActive
        busy_redirect_to_voice_mail (bool): busyRedirectToVoiceMail
        no_answer_redirect_to_voice_mail (bool): noAnswerRedirectToVoiceMail
        server_selection (str): serverSelection
        user_server (str): userServer *Optional*
        mailbox_id_type (str): mailboxIdType
        mailbox_url (str): mailboxURL *Optional*
        no_answer_number_of_rings (int): noAnswerNumberOfRings
        always_redirect_to_voice_mail (bool): alwaysRedirectToVoiceMail
        out_of_primary_zone_redirect_to_voice_mail (bool):
            outOfPrimaryZoneRedirectToVoiceMail
    """

    __slots__: List[str] = [
        "is_active",
        "busy_redirect_to_voice_mail",
        "no_answer_redirect_to_voice_mail",
        "server_selection",
        "user_server",
        "mailbox_id_type",
        "mailbox_url",
        "no_answer_number_of_rings",
        "always_redirect_to_voice_mail",
        "out_of_primary_zone_redirect_to_voice_mail",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "busy_redirect_to_voice_mail",
                "busyRedirectToVoiceMail",
                bool,
                is_required=True,
            ),
            E(
                "no_answer_redirect_to_voice_mail",
                "noAnswerRedirectToVoiceMail",
                bool,
                is_required=True,
            ),
            E(
                "server_selection",
                "serverSelection",
                str,
                is_required=True,
            ),
            E(
                "user_server",
                "userServer",
                str,
            ),
            E(
                "mailbox_id_type",
                "mailboxIdType",
                str,
                is_required=True,
            ),
            E(
                "mailbox_url",
                "mailboxURL",
                str,
            ),
            E(
                "no_answer_number_of_rings",
                "noAnswerNumberOfRings",
                int,
                is_required=True,
            ),
            E(
                "always_redirect_to_voice_mail",
                "alwaysRedirectToVoiceMail",
                bool,
                is_required=True,
            ),
            E(
                "out_of_primary_zone_redirect_to_voice_mail",
                "outOfPrimaryZoneRedirectToVoiceMail",
                bool,
                is_required=True,
            ),
        )


class PublicUserIdentity(OCIType):
    """
    Public User Identity

    Attributes:
        sip_uri (str): sipURI *Optional*
        tel_uri (str): telURI *Optional*
    """

    __slots__: List[str] = [
        "sip_uri",
        "tel_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "sip_uri",
                "sipURI",
                str,
            ),
            E(
                "tel_uri",
                "telURI",
                str,
            ),
        )


class PushNotificationEventData(OCIType):
    """
    The common push notification event elements.


    Attributes:
        event_name (str): eventName
        silent (bool): silent
        mutable_content (bool): mutableContent
        push_notification_event_parameters (str): pushNotificationEventParameters
            *Optional*
    """

    __slots__: List[str] = [
        "event_name",
        "silent",
        "mutable_content",
        "push_notification_event_parameters",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "event_name",
                "eventName",
                str,
                is_required=True,
            ),
            E(
                "silent",
                "silent",
                bool,
                is_required=True,
            ),
            E(
                "mutable_content",
                "mutableContent",
                bool,
                is_required=True,
            ),
            E(
                "push_notification_event_parameters",
                "pushNotificationEventParameters",
                str,
            ),
        )


class PushNotificationEventData23(OCIType):
    """
    The common push notification event elements.

    The mobileNumber element is only returned for MOBILE_CALL_INFO events.

    Attributes:
        event_name (str): eventName
        silent (bool): silent
        mutable_content (bool): mutableContent
        push_notification_event_parameters (str): pushNotificationEventParameters
            *Optional*
        mobile_number (str): mobileNumber *Optional*
    """

    __slots__: List[str] = [
        "event_name",
        "silent",
        "mutable_content",
        "push_notification_event_parameters",
        "mobile_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "event_name",
                "eventName",
                str,
                is_required=True,
            ),
            E(
                "silent",
                "silent",
                bool,
                is_required=True,
            ),
            E(
                "mutable_content",
                "mutableContent",
                bool,
                is_required=True,
            ),
            E(
                "push_notification_event_parameters",
                "pushNotificationEventParameters",
                str,
            ),
            E(
                "mobile_number",
                "mobileNumber",
                str,
            ),
        )


class RandomPort(OCIType):
    """
    Represents either a random port number, or a specific port number.


    Attributes:
        random (str): random *Optional*
        port (int): port *Optional*
    """

    __slots__: List[str] = [
        "random",
        "port",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "random",
                "random",
                str,
            ),
            E(
                "port",
                "port",
                int,
            ),
        )


class RecordNewGreetingOrPersonalizedNameMenuKeysModifyEntry(OCIType):
    """
    The voice portal record new greeting or personalized name menu keys modify entry.


    Attributes:
        end_recording (str): endRecording *Optional*
    """

    __slots__: List[str] = [
        "end_recording",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "end_recording",
                "endRecording",
                str,
            ),
        )


class RecordNewGreetingOrPersonalizedNameMenuKeysReadEntry(OCIType):
    """
    The voice portal record new greeting or personalized name menu keys.


    Attributes:
        end_recording (str): endRecording
    """

    __slots__: List[str] = [
        "end_recording",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "end_recording",
                "endRecording",
                str,
                is_required=True,
            ),
        )


class Recurrence(OCIType):
    """
    Defines recurrence.


    Attributes:
        recur_daily (recurDaily): recurDaily *Optional*
        recur_weekly (recurWeekly): recurWeekly *Optional*
        recur_monthly_by_day (recurMonthlyByDay): recurMonthlyByDay *Optional*
        recur_monthly_by_week (recurMonthlyByWeek): recurMonthlyByWeek *Optional*
        recur_yearly_by_day (recurYearlyByDay): recurYearlyByDay *Optional*
        recur_yearly_by_week (recurYearlyByWeek): recurYearlyByWeek *Optional*
        recur_for_ever (bool): recurForEver *Optional*
        recur_end_date (str): recurEndDate *Optional*
        recur_end_occurrence (int): recurEndOccurrence *Optional*
    """

    __slots__: List[str] = [
        "recur_daily",
        "recur_weekly",
        "recur_monthly_by_day",
        "recur_monthly_by_week",
        "recur_yearly_by_day",
        "recur_yearly_by_week",
        "recur_for_ever",
        "recur_end_date",
        "recur_end_occurrence",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "recur_daily",
                "recurDaily",
                [
                    E(
                        "recur_interval",
                        "recurInterval",
                        int,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "recur_weekly",
                "recurWeekly",
                [
                    E(
                        "recur_interval",
                        "recurInterval",
                        int,
                    ),
                    E(
                        "sunday",
                        "sunday",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "monday",
                        "monday",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "tuesday",
                        "tuesday",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "wednesday",
                        "wednesday",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "thursday",
                        "thursday",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "friday",
                        "friday",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "saturday",
                        "saturday",
                        bool,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "recur_monthly_by_day",
                "recurMonthlyByDay",
                [
                    E(
                        "recur_interval",
                        "recurInterval",
                        int,
                    ),
                    E(
                        "day_of_month",
                        "dayOfMonth",
                        int,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "recur_monthly_by_week",
                "recurMonthlyByWeek",
                [
                    E(
                        "recur_interval",
                        "recurInterval",
                        int,
                    ),
                    E(
                        "day_of_week_in_month",
                        "dayOfWeekInMonth",
                        str,
                        is_required=True,
                    ),
                    E(
                        "day_of_week",
                        "dayOfWeek",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "recur_yearly_by_day",
                "recurYearlyByDay",
                [
                    E(
                        "recur_interval",
                        "recurInterval",
                        int,
                    ),
                    E(
                        "day_of_month",
                        "dayOfMonth",
                        int,
                        is_required=True,
                    ),
                    E(
                        "month",
                        "month",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "recur_yearly_by_week",
                "recurYearlyByWeek",
                [
                    E(
                        "recur_interval",
                        "recurInterval",
                        int,
                    ),
                    E(
                        "day_of_week",
                        "dayOfWeek",
                        str,
                        is_required=True,
                    ),
                    E(
                        "day_of_week_in_month",
                        "dayOfWeekInMonth",
                        str,
                        is_required=True,
                    ),
                    E(
                        "month",
                        "month",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "recur_for_ever",
                "recurForEver",
                bool,
            ),
            E(
                "recur_end_date",
                "recurEndDate",
                str,
            ),
            E(
                "recur_end_occurrence",
                "recurEndOccurrence",
                int,
            ),
        )


class ReplacementCallProcessingPolicyProfileSubscriberTypeList(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType.

    The list replaces a previously configured list.

    Attributes:
        subscriber_type (List[str]): subscriberType
    """

    __slots__: List[str] = [
        "subscriber_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementCallProcessingPolicyProfileSubscriberTypeList20(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType20.

    The list replaces a previously configured list.

    Attributes:
        subscriber_type (List[str]): subscriberType
    """

    __slots__: List[str] = [
        "subscriber_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementCallProcessingPolicyProfileSubscriberTypeList21(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType21.

    The list replaces a previously configured list.

    Attributes:
        subscriber_type (List[str]): subscriberType
    """

    __slots__: List[str] = [
        "subscriber_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "subscriber_type",
                "subscriberType",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementCombinedNetworkClassOfServiceList(OCIType):
    """
    A list of network class of services that replaces a previously network class of
    services.


    Attributes:
        network_class_of_service (List[str]): networkClassOfService
    """

    __slots__: List[str] = [
        "network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementCommunicationBarringAlternateCallIndicatorList(OCIType):
    """
    A list of Communication Barring Alternate Call Indicator that replaces a previously
    configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        alternate_call_indicator (List[str]): alternateCallIndicator
    """

    __slots__: List[str] = [
        "alternate_call_indicator",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "alternate_call_indicator",
                "alternateCallIndicator",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementCommunicationBarringCallTypeList(OCIType):
    """
    A list of Communication Barring Call Types that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        call_type (List[str]): callType
    """

    __slots__: List[str] = [
        "call_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_type",
                "callType",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementContactList(OCIType):
    """
    A list of SIP contacts that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        contact (List[str]): contact
    """

    __slots__: List[str] = [
        "contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "contact",
                "contact",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementDNList(OCIType):
    """
    A list of dns that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number (List[str]): phoneNumber
    """

    __slots__: List[str] = [
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementDeviceTypeList(OCIType):
    """
    A list of device types that replaces the previously assigned list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        device_type (List[str]): deviceType
    """

    __slots__: List[str] = [
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementEnterpriseTrunkTrunkGroupList(OCIType):
    """
    A list of Group Trunk Krunk Group Names that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        trunk_group (List[str]): trunkGroup
    """

    __slots__: List[str] = [
        "trunk_group",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "trunk_group",
                "trunkGroup",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementGroupEnterpriseTrunkTrunkGroupList(OCIType):
    """
    A list of Group Trunk Krunk Group Names that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        trunk_group (List[str]): trunkGroup
    """

    __slots__: List[str] = [
        "trunk_group",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "trunk_group",
                "trunkGroup",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementMediaNameList(OCIType):
    """
    A list of media that replaces a previously configured list.


    Attributes:
        media_name (List[str]): mediaName
    """

    __slots__: List[str] = [
        "media_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "media_name",
                "mediaName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementNumberPortabilityStatusList(OCIType):
    """
    A list of Number Portability Query Statuses that replaces a previously configured
    list.

    By convention, an element of this type may be set to nill to clear the list.

    Attributes:
        status (List[str]): status
    """

    __slots__: List[str] = [
        "status",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "status",
                "status",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementOCICallControlApplicationIdList(OCIType):
    """
    A list of applicationIds that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        application_id (List[str]): applicationId
    """

    __slots__: List[str] = [
        "application_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "application_id",
                "applicationId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementOutgoingDNList(OCIType):
    """
    A list of outgoing dns that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number (List[str]): phoneNumber
    """

    __slots__: List[str] = [
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementOutgoingDNorSIPURIList(OCIType):
    """
    A list of phone numbers or sipuris that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        phone_number (List[str]): phoneNumber
    """

    __slots__: List[str] = [
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementSIPAliasList(OCIType):
    """
    A list of SIP aliases that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        sip_alias (List[str]): sipAlias
    """

    __slots__: List[str] = [
        "sip_alias",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "sip_alias",
                "sipAlias",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementServicePackNameList(OCIType):
    """
    A list of service packs that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        service_pack_name (List[str]): servicePackName
    """

    __slots__: List[str] = [
        "service_pack_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementTagSetList(OCIType):
    """
    A list of tag sets that replaces the previously assigned list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        tag_set (List[str]): tagSet
    """

    __slots__: List[str] = [
        "tag_set",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "tag_set",
                "tagSet",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementUserIdList(OCIType):
    """
    A list of userIds that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        user_id (List[str]): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementUserServiceList(OCIType):
    """
    A list of user services that replaces a previously configured list.

    By convention, an element of this type may be set nill to clear the list.

    Attributes:
        service_name (List[str]): serviceName
    """

    __slots__: List[str] = [
        "service_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_name",
                "serviceName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementVirtualOnNetCallTypeNameList(OCIType):
    """
    A list of Virtual On-Net Call Types that replaces a previously configured list.

    By convention, an element of this type may be set to nill to clear the list.

    Attributes:
        virtual_on_net_call_type_name (List[str]): virtualOnNetCallTypeName
    """

    __slots__: List[str] = [
        "virtual_on_net_call_type_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "virtual_on_net_call_type_name",
                "virtualOnNetCallTypeName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplacementZoneList(OCIType):
    """
    Contains an ordered list of zones to use to replace the current list of zones in an
    Office Zone.


    Attributes:
        zone_name (List[str]): zoneName
    """

    __slots__: List[str] = [
        "zone_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "zone_name",
                "zoneName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ReplyMessageMenuKeysModifyEntry(OCIType):
    """
    The voice portal reply message menu keys modify entry.


    Attributes:
        send_reply_to_caller (str): sendReplyToCaller *Optional*
        change_current_reply (str): changeCurrentReply *Optional*
        listen_to_current_reply (str): listenToCurrentReply *Optional*
        set_or_clear_urgent_indicator (str): setOrClearUrgentIndicator *Optional*
        set_or_clear_confidential_indicator (str): setOrClearConfidentialIndicator
            *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "send_reply_to_caller",
        "change_current_reply",
        "listen_to_current_reply",
        "set_or_clear_urgent_indicator",
        "set_or_clear_confidential_indicator",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_reply_to_caller",
                "sendReplyToCaller",
                str,
            ),
            E(
                "change_current_reply",
                "changeCurrentReply",
                str,
            ),
            E(
                "listen_to_current_reply",
                "listenToCurrentReply",
                str,
            ),
            E(
                "set_or_clear_urgent_indicator",
                "setOrClearUrgentIndicator",
                str,
            ),
            E(
                "set_or_clear_confidential_indicator",
                "setOrClearConfidentialIndicator",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class ReplyMessageMenuKeysReadEntry(OCIType):
    """
    The voice portal reply message menu keys.


    Attributes:
        send_reply_to_caller (str): sendReplyToCaller
        change_current_reply (str): changeCurrentReply *Optional*
        listen_to_current_reply (str): listenToCurrentReply *Optional*
        set_or_clear_urgent_indicator (str): setOrClearUrgentIndicator *Optional*
        set_or_clear_confidential_indicator (str): setOrClearConfidentialIndicator
            *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "send_reply_to_caller",
        "change_current_reply",
        "listen_to_current_reply",
        "set_or_clear_urgent_indicator",
        "set_or_clear_confidential_indicator",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_reply_to_caller",
                "sendReplyToCaller",
                str,
                is_required=True,
            ),
            E(
                "change_current_reply",
                "changeCurrentReply",
                str,
            ),
            E(
                "listen_to_current_reply",
                "listenToCurrentReply",
                str,
            ),
            E(
                "set_or_clear_urgent_indicator",
                "setOrClearUrgentIndicator",
                str,
            ),
            E(
                "set_or_clear_confidential_indicator",
                "setOrClearConfidentialIndicator",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class ResponsePagingControl(OCIType):
    """
    Used in queries to restrict the set of result rows when making a request that can
    result in a large dataset.

    The client specifies the starting row and the number of rows requested.  The server
    only provides those rows in results, if available.

    Attributes:
        response_start_index (int): responseStartIndex
        response_page_size (int): responsePageSize
    """

    __slots__: List[str] = [
        "response_start_index",
        "response_page_size",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "response_start_index",
                "responseStartIndex",
                int,
                is_required=True,
            ),
            E(
                "response_page_size",
                "responsePageSize",
                int,
                is_required=True,
            ),
        )


class ReviewSelectedDistributionListMenuKeysModifyEntry(OCIType):
    """
    The voice portal review selected distribution list menu keys modify entry.


    Attributes:
        interrupt_playback_and_return_to_previous_menu (str):
            interruptPlaybackAndReturnToPreviousMenu *Optional*
    """

    __slots__: List[str] = [
        "interrupt_playback_and_return_to_previous_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "interrupt_playback_and_return_to_previous_menu",
                "interruptPlaybackAndReturnToPreviousMenu",
                str,
            ),
        )


class ReviewSelectedDistributionListMenuKeysReadEntry(OCIType):
    """
    The voice portal review selected distribution list menu keys.


    Attributes:
        interrupt_playback_and_return_to_previous_menu (str):
            interruptPlaybackAndReturnToPreviousMenu
    """

    __slots__: List[str] = [
        "interrupt_playback_and_return_to_previous_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "interrupt_playback_and_return_to_previous_menu",
                "interruptPlaybackAndReturnToPreviousMenu",
                str,
                is_required=True,
            ),
        )


class SIPAuthenticationUserNamePassword(OCIType):
    """
    User's authentication service information.


    Attributes:
        sip_authentication_user_name (str): sipAuthenticationUserName
        sip_authentication_password (str): sipAuthenticationPassword
    """

    __slots__: List[str] = [
        "sip_authentication_user_name",
        "sip_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "sip_authentication_user_name",
                "sipAuthenticationUserName",
                str,
                is_required=True,
            ),
            E(
                "sip_authentication_password",
                "sipAuthenticationPassword",
                str,
                is_required=True,
            ),
        )


class SIPContactInfo(OCIType):
    """
    A SIP Contact info contains the SIP registration Contact and its associated Header
    path The following element is only used in AS data mode and ignored in XS data mode:
    pathHeader

    Attributes:
        sip_contact (str): sipContact
        path_header (str): pathHeader *Optional*
    """

    __slots__: List[str] = [
        "sip_contact",
        "path_header",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "sip_contact",
                "sipContact",
                str,
                is_required=True,
            ),
            E(
                "path_header",
                "pathHeader",
                str,
            ),
        )


class ScheduleKey(OCIType):
    """
    Uniquely identifies Holiday and Time Schedules within a level(System, Service
    Provider, Group or User level).


    Attributes:
        schedule_name (str): scheduleName
        schedule_type (str): scheduleType
    """

    __slots__: List[str] = [
        "schedule_name",
        "schedule_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "schedule_name",
                "scheduleName",
                str,
                is_required=True,
            ),
            E(
                "schedule_type",
                "scheduleType",
                str,
                is_required=True,
            ),
        )


class SearchCriteria(OCIType):
    """
    Abstract base type for specifying search criteria.

    A search criteria is an optional element used to restrict the number of rows returned
    when requesting a potentially large set of data from the provisioning server.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class SearchCriteriaComposedOr(OCIType):
    """
    Abstract base type for specifying search criteria where the search criteria params are
    OR'ed.

    A search criteria is an optional element used to restrict the number of rows returned
    when requesting a potentially large set of data from the provisioning server.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class SelectDistributionListMenuKeysModifyEntry(OCIType):
    """
    The voice portal select distribution list menu keys modify entry.


    Attributes:
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu_or_finish_entering_distribution_list_number (str):
            repeatMenuOrFinishEnteringDistributionListNumber *Optional*
    """

    __slots__: List[str] = [
        "return_to_previous_menu",
        "repeat_menu_or_finish_entering_distribution_list_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu_or_finish_entering_distribution_list_number",
                "repeatMenuOrFinishEnteringDistributionListNumber",
                str,
            ),
        )


class SelectDistributionListMenuKeysReadEntry(OCIType):
    """
    The voice portal select distribution list menu keys.


    Attributes:
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu_or_finish_entering_distribution_list_number (str):
            repeatMenuOrFinishEnteringDistributionListNumber *Optional*
    """

    __slots__: List[str] = [
        "return_to_previous_menu",
        "repeat_menu_or_finish_entering_distribution_list_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu_or_finish_entering_distribution_list_number",
                "repeatMenuOrFinishEnteringDistributionListNumber",
                str,
            ),
        )


class SelectiveCallRejectionCriteriaCallType(OCIType):
    """
    The call type criteria used within an add/get request.


    Attributes:
        from_dn_criteria_selection (str): fromDnCriteriaSelection
        include_anonymous_callers (bool): includeAnonymousCallers
        include_unavailable_callers (bool): includeUnavailableCallers
        phone_number (List[str]): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "from_dn_criteria_selection",
        "include_anonymous_callers",
        "include_unavailable_callers",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "from_dn_criteria_selection",
                "fromDnCriteriaSelection",
                str,
                is_required=True,
            ),
            E(
                "include_anonymous_callers",
                "includeAnonymousCallers",
                bool,
                is_required=True,
            ),
            E(
                "include_unavailable_callers",
                "includeUnavailableCallers",
                bool,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
        )


class SendMessageToSelectedDistributionListMenuKeysModifyEntry(OCIType):
    """
    The voice portal send message to selected distribution list menu keys modify entry.


    Attributes:
        confirm_sending_to_distribution_list (str): confirmSendingToDistributionList
            *Optional*
        cancel_sending_to_distribution_list (str): cancelSendingToDistributionList
            *Optional*
    """

    __slots__: List[str] = [
        "confirm_sending_to_distribution_list",
        "cancel_sending_to_distribution_list",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "confirm_sending_to_distribution_list",
                "confirmSendingToDistributionList",
                str,
            ),
            E(
                "cancel_sending_to_distribution_list",
                "cancelSendingToDistributionList",
                str,
            ),
        )


class SendMessageToSelectedDistributionListMenuKeysReadEntry(OCIType):
    """
    The voice portal send message to selected distribution list menu keys.


    Attributes:
        confirm_sending_to_distribution_list (str): confirmSendingToDistributionList
            *Optional*
        cancel_sending_to_distribution_list (str): cancelSendingToDistributionList
    """

    __slots__: List[str] = [
        "confirm_sending_to_distribution_list",
        "cancel_sending_to_distribution_list",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "confirm_sending_to_distribution_list",
                "confirmSendingToDistributionList",
                str,
            ),
            E(
                "cancel_sending_to_distribution_list",
                "cancelSendingToDistributionList",
                str,
                is_required=True,
            ),
        )


class SendToAllGroupMembersMenuKeysModifyEntry(OCIType):
    """
    The voice portal send to all group memeber menu keys modify entry.


    Attributes:
        confirm_sending_to_entire_group (str): confirmSendingToEntireGroup *Optional*
        cancel_sending_to_entire_group (str): cancelSendingToEntireGroup *Optional*
    """

    __slots__: List[str] = [
        "confirm_sending_to_entire_group",
        "cancel_sending_to_entire_group",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "confirm_sending_to_entire_group",
                "confirmSendingToEntireGroup",
                str,
            ),
            E(
                "cancel_sending_to_entire_group",
                "cancelSendingToEntireGroup",
                str,
            ),
        )


class SendToAllGroupMembersMenuKeysReadEntry(OCIType):
    """
    The voice portal send to all group memeber menu keys.


    Attributes:
        confirm_sending_to_entire_group (str): confirmSendingToEntireGroup
        cancel_sending_to_entire_group (str): cancelSendingToEntireGroup
    """

    __slots__: List[str] = [
        "confirm_sending_to_entire_group",
        "cancel_sending_to_entire_group",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "confirm_sending_to_entire_group",
                "confirmSendingToEntireGroup",
                str,
                is_required=True,
            ),
            E(
                "cancel_sending_to_entire_group",
                "cancelSendingToEntireGroup",
                str,
                is_required=True,
            ),
        )


class SendToDistributionListMenuKeysModifyEntry(OCIType):
    """
    The voice portal send to distribution list menu keys modify entry.


    Attributes:
        send_message_to_selected_distribution_list (str):
            sendMessageToSelectedDistributionList *Optional*
        select_distribution_list (str): selectDistributionList *Optional*
        review_selected_distribution_list (str): reviewSelectedDistributionList *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "send_message_to_selected_distribution_list",
        "select_distribution_list",
        "review_selected_distribution_list",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_message_to_selected_distribution_list",
                "sendMessageToSelectedDistributionList",
                str,
            ),
            E(
                "select_distribution_list",
                "selectDistributionList",
                str,
            ),
            E(
                "review_selected_distribution_list",
                "reviewSelectedDistributionList",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class SendToDistributionListMenuKeysReadEntry(OCIType):
    """
    The voice portal send to distribution list menu keys.


    Attributes:
        send_message_to_selected_distribution_list (str):
            sendMessageToSelectedDistributionList
        select_distribution_list (str): selectDistributionList *Optional*
        review_selected_distribution_list (str): reviewSelectedDistributionList *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "send_message_to_selected_distribution_list",
        "select_distribution_list",
        "review_selected_distribution_list",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_message_to_selected_distribution_list",
                "sendMessageToSelectedDistributionList",
                str,
                is_required=True,
            ),
            E(
                "select_distribution_list",
                "selectDistributionList",
                str,
            ),
            E(
                "review_selected_distribution_list",
                "reviewSelectedDistributionList",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class SendToPersonMenuKeysModifyEntry(OCIType):
    """
    The voice portal send to person menu keys modify entry.


    Attributes:
        confirm_sending_message (str): confirmSendingMessage *Optional*
        cancel_sending_message (str): cancelSendingMessage *Optional*
        finish_entering_number_where_to_send_message_to (str):
            finishEnteringNumberWhereToSendMessageTo *Optional*
        finish_forwarding_or_sending_message (str): finishForwardingOrSendingMessage
            *Optional*
    """

    __slots__: List[str] = [
        "confirm_sending_message",
        "cancel_sending_message",
        "finish_entering_number_where_to_send_message_to",
        "finish_forwarding_or_sending_message",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "confirm_sending_message",
                "confirmSendingMessage",
                str,
            ),
            E(
                "cancel_sending_message",
                "cancelSendingMessage",
                str,
            ),
            E(
                "finish_entering_number_where_to_send_message_to",
                "finishEnteringNumberWhereToSendMessageTo",
                str,
            ),
            E(
                "finish_forwarding_or_sending_message",
                "finishForwardingOrSendingMessage",
                str,
            ),
        )


class SendToPersonMenuKeysReadEntry(OCIType):
    """
    The voice portal send to person menu keys.


    Attributes:
        confirm_sending_message (str): confirmSendingMessage
        cancel_sending_message (str): cancelSendingMessage
        finish_entering_number_where_to_send_message_to (str):
            finishEnteringNumberWhereToSendMessageTo
        finish_forwarding_or_sending_message (str): finishForwardingOrSendingMessage
    """

    __slots__: List[str] = [
        "confirm_sending_message",
        "cancel_sending_message",
        "finish_entering_number_where_to_send_message_to",
        "finish_forwarding_or_sending_message",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "confirm_sending_message",
                "confirmSendingMessage",
                str,
                is_required=True,
            ),
            E(
                "cancel_sending_message",
                "cancelSendingMessage",
                str,
                is_required=True,
            ),
            E(
                "finish_entering_number_where_to_send_message_to",
                "finishEnteringNumberWhereToSendMessageTo",
                str,
                is_required=True,
            ),
            E(
                "finish_forwarding_or_sending_message",
                "finishForwardingOrSendingMessage",
                str,
                is_required=True,
            ),
        )


class SequentialRingLocation(OCIType):
    """
    Sequential Ring Location.

    Replaced By: SequentialRingLocation14sp4

    Attributes:
        phone_number (str): phoneNumber *Optional*
        number_of_rings (int): numberOfRings
    """

    __slots__: List[str] = [
        "phone_number",
        "number_of_rings",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "number_of_rings",
                "numberOfRings",
                int,
                is_required=True,
            ),
        )


class SequentialRingLocation14sp4(OCIType):
    """
    Sequential Ring Location.


    Attributes:
        phone_number (str): phoneNumber *Optional*
        number_of_rings (int): numberOfRings
        answer_confirmation_required (bool): answerConfirmationRequired
    """

    __slots__: List[str] = [
        "phone_number",
        "number_of_rings",
        "answer_confirmation_required",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "number_of_rings",
                "numberOfRings",
                int,
                is_required=True,
            ),
            E(
                "answer_confirmation_required",
                "answerConfirmationRequired",
                bool,
                is_required=True,
            ),
        )


class SequentialRingLocationModify(OCIType):
    """
    Sequential Ring Location.


    Attributes:
        phone_number (str): phoneNumber *Optional*
        number_of_rings (int): numberOfRings *Optional*
        answer_confirmation_required (bool): answerConfirmationRequired *Optional*
    """

    __slots__: List[str] = [
        "phone_number",
        "number_of_rings",
        "answer_confirmation_required",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "number_of_rings",
                "numberOfRings",
                int,
            ),
            E(
                "answer_confirmation_required",
                "answerConfirmationRequired",
                bool,
            ),
        )


class ServiceActivation(OCIType):
    """
    Service Instance active status indicator

    Attributes:
        service_user_id (str): serviceUserId
        is_active (bool): isActive
    """

    __slots__: List[str] = [
        "service_user_id",
        "is_active",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
        )


class ServiceAttributeEntry(OCIType):
    """
    The service attributes name and value pair.


    Attributes:
        name (str): name
        value (str): value
    """

    __slots__: List[str] = [
        "name",
        "value",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "value",
                "value",
                str,
                is_required=True,
            ),
        )


class ServiceAttributeEntryRead(OCIType):
    """
    The service attributes name and value pair.


    Attributes:
        name (str): name
        value (str): value *Optional*
    """

    __slots__: List[str] = [
        "name",
        "value",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "value",
                "value",
                str,
            ),
        )


class ServiceProviderAdmin(OCIType):
    """
    The common Service Provider Admin elements.


    Attributes:
        user_id (str): userId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        password (str): password *Optional*
        language (str): language *Optional*
        administrator_type (str): administratorType
    """

    __slots__: List[str] = [
        "user_id",
        "first_name",
        "last_name",
        "password",
        "language",
        "administrator_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "language",
                "language",
                str,
            ),
            E(
                "administrator_type",
                "administratorType",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAdministratorPasswordRulesGetRequestRI(OCIType):
    """
    Requests the effective password rules setting for a service provider administrator The
    response is either ServiceProviderAdministratorPasswordRulesGetResponseRI or
    `ErrorResponse()`.


    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAdministratorPasswordRulesGetResponseRI(OCIType):
    """
    Response to ServiceProviderAdministratorPasswordRulesGetRequestRI.


    Attributes:
        use_external_authentication (bool): useExternalAuthentication *Optional*
        allow_web_add_external_authentication_users (bool):
            allowWebAddExternalAuthenticationUsers *Optional*
        disallow_user_id (bool): disallowUserId *Optional*
        disallow_old_password (bool): disallowOldPassword *Optional*
        disallow_reversed_old_password (bool): disallowReversedOldPassword *Optional*
        restrict_min_digits (bool): restrictMinDigits *Optional*
        min_digits (int): minDigits *Optional*
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters *Optional*
        min_upper_case_letters (int): minUpperCaseLetters *Optional*
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters *Optional*
        min_lower_case_letters (int): minLowerCaseLetters *Optional*
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters *Optional*
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters *Optional*
        min_length (int): minLength *Optional*
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        password_expires_days (int): passwordExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail *Optional*
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_previous_passwords (bool): disallowPreviousPasswords *Optional*
        number_of_previous_passwords (int): numberOfPreviousPasswords *Optional*
        use_password_validation_service (bool): usePasswordValidationService *Optional*
        reenable_login (bool): reenableLogin *Optional*
        lock_out_in_minutes (int): lockOutInMinutes *Optional*
    """

    __slots__: List[str] = [
        "use_external_authentication",
        "allow_web_add_external_authentication_users",
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_previous_passwords",
        "number_of_previous_passwords",
        "use_password_validation_service",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_external_authentication",
                "useExternalAuthentication",
                bool,
            ),
            E(
                "allow_web_add_external_authentication_users",
                "allowWebAddExternalAuthenticationUsers",
                bool,
            ),
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
            ),
            E(
                "min_length",
                "minLength",
                int,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_previous_passwords",
                "disallowPreviousPasswords",
                bool,
            ),
            E(
                "number_of_previous_passwords",
                "numberOfPreviousPasswords",
                int,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
            ),
        )


class ServiceProviderBroadWorksMobilityGetRequest21sp1V2(OCIType):
    """
    Get the service provider BroadWorks Mobility service settings.

    The response is either a ServiceProviderBroadWorksMobilityGetResponse21sp1V2 or an
    `ErrorResponse()`. Replaced by `ServiceProviderBroadWorksMobilityGetRequest22V2()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class ServiceProviderBroadWorksMobilityGetResponse21sp1V2(OCIType):
    """
    The response to a ServiceProviderBroadWorksMobilityGetRequest21sp1V2.

    Replaced by `ServiceProviderBroadWorksMobilityGetResponse22V2()`.

    Attributes:
        use_setting_level (str): useSettingLevel
        enable_location_services (bool): enableLocationServices
        enable_msrn_lookup (bool): enableMSRNLookup
        enable_mobile_state_checking (bool): enableMobileStateChecking
        deny_call_originations (bool): denyCallOriginations
        deny_call_terminations (bool): denyCallTerminations
        enable_announcement_suppression (bool): enableAnnouncementSuppression
        enable_internal_clid_delivery_access_locations (bool):
            enableInternalCLIDDeliveryAccessLocations
        enable_enhanced_unreachable_state_checking (bool):
            enableEnhancedUnreachableStateChecking
        enable_network_call_barring_status_check (bool):
            enableNetworkCallBarringStatusCheck
    """

    __slots__: List[str] = [
        "use_setting_level",
        "enable_location_services",
        "enable_msrn_lookup",
        "enable_mobile_state_checking",
        "deny_call_originations",
        "deny_call_terminations",
        "enable_announcement_suppression",
        "enable_internal_clid_delivery_access_locations",
        "enable_enhanced_unreachable_state_checking",
        "enable_network_call_barring_status_check",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting_level",
                "useSettingLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_location_services",
                "enableLocationServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_msrn_lookup",
                "enableMSRNLookup",
                bool,
                is_required=True,
            ),
            E(
                "enable_mobile_state_checking",
                "enableMobileStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_originations",
                "denyCallOriginations",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_terminations",
                "denyCallTerminations",
                bool,
                is_required=True,
            ),
            E(
                "enable_announcement_suppression",
                "enableAnnouncementSuppression",
                bool,
                is_required=True,
            ),
            E(
                "enable_internal_clid_delivery_access_locations",
                "enableInternalCLIDDeliveryAccessLocations",
                bool,
                is_required=True,
            ),
            E(
                "enable_enhanced_unreachable_state_checking",
                "enableEnhancedUnreachableStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "enable_network_call_barring_status_check",
                "enableNetworkCallBarringStatusCheck",
                bool,
                is_required=True,
            ),
        )


class ServiceProviderCommunicationBarringHierarchicalCallMeNowRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Call Me Now Rule

    Attributes:
        criteria (str): criteria *Optional*
        digit_pattern_criteria (str): digitPatternCriteria *Optional*
        action (str): action
        call_timeout_seconds (int): callTimeoutSeconds *Optional*
        time_schedule (str): timeSchedule *Optional*
        holiday_schedule (str): holidaySchedule *Optional*
        priority (str): priority
    """

    __slots__: List[str] = [
        "criteria",
        "digit_pattern_criteria",
        "action",
        "call_timeout_seconds",
        "time_schedule",
        "holiday_schedule",
        "priority",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria",
                "criteria",
                str,
            ),
            E(
                "digit_pattern_criteria",
                "digitPatternCriteria",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "call_timeout_seconds",
                "callTimeoutSeconds",
                int,
            ),
            E(
                "time_schedule",
                "timeSchedule",
                str,
            ),
            E(
                "holiday_schedule",
                "holidaySchedule",
                str,
            ),
            E(
                "priority",
                "priority",
                str,
                is_required=True,
            ),
        )


class ServiceProviderCommunicationBarringHierarchicalOriginatingRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Originating Rule

    Attributes:
        criteria (str): criteria *Optional*
        digit_pattern_criteria (str): digitPatternCriteria *Optional*
        action (str): action
        treatment_id (str): treatmentId *Optional*
        transfer_number (str): transferNumber *Optional*
        call_timeout_seconds (int): callTimeoutSeconds *Optional*
        time_schedule (str): timeSchedule *Optional*
        holiday_schedule (str): holidaySchedule *Optional*
        priority (str): priority
    """

    __slots__: List[str] = [
        "criteria",
        "digit_pattern_criteria",
        "action",
        "treatment_id",
        "transfer_number",
        "call_timeout_seconds",
        "time_schedule",
        "holiday_schedule",
        "priority",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria",
                "criteria",
                str,
            ),
            E(
                "digit_pattern_criteria",
                "digitPatternCriteria",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "treatment_id",
                "treatmentId",
                str,
            ),
            E(
                "transfer_number",
                "transferNumber",
                str,
            ),
            E(
                "call_timeout_seconds",
                "callTimeoutSeconds",
                int,
            ),
            E(
                "time_schedule",
                "timeSchedule",
                str,
            ),
            E(
                "holiday_schedule",
                "holidaySchedule",
                str,
            ),
            E(
                "priority",
                "priority",
                str,
                is_required=True,
            ),
        )


class ServiceProviderCommunicationBarringHierarchicalRedirectingRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Redirecting Rule

    Attributes:
        criteria (str): criteria *Optional*
        digit_pattern_criteria (str): digitPatternCriteria *Optional*
        action (str): action
        call_timeout_seconds (int): callTimeoutSeconds *Optional*
        time_schedule (str): timeSchedule *Optional*
        holiday_schedule (str): holidaySchedule *Optional*
        priority (str): priority
    """

    __slots__: List[str] = [
        "criteria",
        "digit_pattern_criteria",
        "action",
        "call_timeout_seconds",
        "time_schedule",
        "holiday_schedule",
        "priority",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "criteria",
                "criteria",
                str,
            ),
            E(
                "digit_pattern_criteria",
                "digitPatternCriteria",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "call_timeout_seconds",
                "callTimeoutSeconds",
                int,
            ),
            E(
                "time_schedule",
                "timeSchedule",
                str,
            ),
            E(
                "holiday_schedule",
                "holidaySchedule",
                str,
            ),
            E(
                "priority",
                "priority",
                str,
                is_required=True,
            ),
        )


class ServiceProviderCommunicationBarringProfileGetRequest19sp1V2(OCIType):
    """
    Get an existing Communication Barring Profile.

    The response is either a ServiceProviderCommunicationBarringProfileGetResponse19sp1V2
    or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequestRI(OCIType):
    """
    Request to get the service provider level device profile authentication password rule
    settings.

    The response is either a
    ServiceProviderDeviceProfileAuthenticationPasswordRulesGetResponseRI or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class ServiceProviderDeviceProfileAuthenticationPasswordRulesGetResponseRI(OCIType):
    """
    Response to ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequestRI.

    Contains the device profile authentication password rules for the service provider.

    Attributes:
        use_service_provider_settings (bool): useServiceProviderSettings
        disallow_authentication_name (bool): disallowAuthenticationName
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        send_permanent_lockout_notification (bool): sendPermanentLockoutNotification
        permanent_lockout_notify_email_address (str): permanentLockoutNotifyEmailAddress
            *Optional*
        device_profile_authentication_lockout_type (str):
            deviceProfileAuthenticationLockoutType
        device_profile_temporary_lockout_threshold (int):
            deviceProfileTemporaryLockoutThreshold
        device_profile_wait_algorithm (str): deviceProfileWaitAlgorithm
        device_profile_lockout_fixed_minutes (str): deviceProfileLockoutFixedMinutes
        device_profile_permanent_lockout_threshold (int):
            deviceProfilePermanentLockoutThreshold
        use_password_validation_service (bool): usePasswordValidationService
    """

    __slots__: List[str] = [
        "use_service_provider_settings",
        "disallow_authentication_name",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "send_permanent_lockout_notification",
        "permanent_lockout_notify_email_address",
        "device_profile_authentication_lockout_type",
        "device_profile_temporary_lockout_threshold",
        "device_profile_wait_algorithm",
        "device_profile_lockout_fixed_minutes",
        "device_profile_permanent_lockout_threshold",
        "use_password_validation_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_service_provider_settings",
                "useServiceProviderSettings",
                bool,
                is_required=True,
            ),
            E(
                "disallow_authentication_name",
                "disallowAuthenticationName",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "send_permanent_lockout_notification",
                "sendPermanentLockoutNotification",
                bool,
                is_required=True,
            ),
            E(
                "permanent_lockout_notify_email_address",
                "permanentLockoutNotifyEmailAddress",
                str,
            ),
            E(
                "device_profile_authentication_lockout_type",
                "deviceProfileAuthenticationLockoutType",
                str,
                is_required=True,
            ),
            E(
                "device_profile_temporary_lockout_threshold",
                "deviceProfileTemporaryLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "device_profile_wait_algorithm",
                "deviceProfileWaitAlgorithm",
                str,
                is_required=True,
            ),
            E(
                "device_profile_lockout_fixed_minutes",
                "deviceProfileLockoutFixedMinutes",
                str,
                is_required=True,
            ),
            E(
                "device_profile_permanent_lockout_threshold",
                "deviceProfilePermanentLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
                is_required=True,
            ),
        )


class ServiceProviderPasswordRulesGetRequestRI(OCIType):
    """
    Requests the service provider's password rules setting applicable to Administrators
    (Group and Department) and Users.

    The response is either ServiceProviderPasswordRulesGetResponseRI or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class ServiceProviderPasswordRulesGetResponseRI(OCIType):
    """
    Response to ServiceProviderPasswordRulesGetRequestRI.

    Contains the group, department administrator and/or user password rules setting.  The
    following element is only used in AS data mode: forcePasswordChangeAfterReset, value
    "false" is returned in XS data mode reenableLogin lockOutInMinutes

    Attributes:
        rules_apply_to (str): rulesApplyTo
        allow_web_add_external_authentication_users (bool):
            allowWebAddExternalAuthenticationUsers
        disallow_user_id (bool): disallowUserId
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        max_failed_login_attempts (int): maxFailedLoginAttempts
        password_expires_days (int): passwordExpiresDays
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_rules_modification (bool): disallowRulesModification
        disallow_previous_passwords (bool): disallowPreviousPasswords
        number_of_previous_passwords (int): numberOfPreviousPasswords
        force_password_change_after_reset (bool): forcePasswordChangeAfterReset
        use_password_validation_service (bool): usePasswordValidationService
        reenable_login (bool): reenableLogin
        lock_out_in_minutes (int): lockOutInMinutes
    """

    __slots__: List[str] = [
        "rules_apply_to",
        "allow_web_add_external_authentication_users",
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_rules_modification",
        "disallow_previous_passwords",
        "number_of_previous_passwords",
        "force_password_change_after_reset",
        "use_password_validation_service",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "rules_apply_to",
                "rulesApplyTo",
                str,
                is_required=True,
            ),
            E(
                "allow_web_add_external_authentication_users",
                "allowWebAddExternalAuthenticationUsers",
                bool,
                is_required=True,
            ),
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
                is_required=True,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_rules_modification",
                "disallowRulesModification",
                bool,
                is_required=True,
            ),
            E(
                "disallow_previous_passwords",
                "disallowPreviousPasswords",
                bool,
                is_required=True,
            ),
            E(
                "number_of_previous_passwords",
                "numberOfPreviousPasswords",
                int,
                is_required=True,
            ),
            E(
                "force_password_change_after_reset",
                "forcePasswordChangeAfterReset",
                bool,
                is_required=True,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
                is_required=True,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
                is_required=True,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
                is_required=True,
            ),
        )


class ServiceProviderPortalPasscodeRulesGetRequestRI(OCIType):
    """
    Requests the service provider's passcode rules setting.

    The response is either ServiceProviderPortalPasscodeRulesGetResponseRI or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class ServiceProviderPortalPasscodeRulesGetResponseRI(OCIType):
    """
    Response to ServiceProviderPortalPasscodeRulesGetRequestRI.

    Contains the service provider's passcode rules setting.  The following elements are
    only used in AS data mode: numberOfRepeatedDigits disallowRepeatedPatterns
    disallowContiguousSequences numberOfAscendingDigits numberOfDescendingDigits
    numberOfPreviousPasscodes enableDefaultPasscode defaultPasscode reenableLogin
    lockOutInMinutes

    Attributes:
        disallow_repeated_digits (bool): disallowRepeatedDigits
        number_of_repeated_digits (int): numberOfRepeatedDigits
        disallow_repeated_patterns (bool): disallowRepeatedPatterns
        disallow_contiguous_sequences (bool): disallowContiguousSequences
        number_of_ascending_digits (int): numberOfAscendingDigits
        number_of_descending_digits (int): numberOfDescendingDigits
        disallow_user_number (bool): disallowUserNumber
        disallow_reversed_user_number (bool): disallowReversedUserNumber
        disallow_old_passcode (bool): disallowOldPasscode
        number_of_previous_passcodes (int): numberOfPreviousPasscodes
        disallow_reversed_old_passcode (bool): disallowReversedOldPasscode
        min_code_length (int): minCodeLength
        max_code_length (int): maxCodeLength
        disable_login_after_max_failed_login_attempts (bool):
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        expire_password (bool): expirePassword
        passcode_expires_days (int): passcodeExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        enable_default_passcode (bool): enableDefaultPasscode
        default_passcode (str): defaultPasscode *Optional*
        reenable_login (bool): reenableLogin
        lock_out_in_minutes (int): lockOutInMinutes
    """

    __slots__: List[str] = [
        "disallow_repeated_digits",
        "number_of_repeated_digits",
        "disallow_repeated_patterns",
        "disallow_contiguous_sequences",
        "number_of_ascending_digits",
        "number_of_descending_digits",
        "disallow_user_number",
        "disallow_reversed_user_number",
        "disallow_old_passcode",
        "number_of_previous_passcodes",
        "disallow_reversed_old_passcode",
        "min_code_length",
        "max_code_length",
        "disable_login_after_max_failed_login_attempts",
        "max_failed_login_attempts",
        "expire_password",
        "passcode_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "enable_default_passcode",
        "default_passcode",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disallow_repeated_digits",
                "disallowRepeatedDigits",
                bool,
                is_required=True,
            ),
            E(
                "number_of_repeated_digits",
                "numberOfRepeatedDigits",
                int,
                is_required=True,
            ),
            E(
                "disallow_repeated_patterns",
                "disallowRepeatedPatterns",
                bool,
                is_required=True,
            ),
            E(
                "disallow_contiguous_sequences",
                "disallowContiguousSequences",
                bool,
                is_required=True,
            ),
            E(
                "number_of_ascending_digits",
                "numberOfAscendingDigits",
                int,
                is_required=True,
            ),
            E(
                "number_of_descending_digits",
                "numberOfDescendingDigits",
                int,
                is_required=True,
            ),
            E(
                "disallow_user_number",
                "disallowUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_user_number",
                "disallowReversedUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_passcode",
                "disallowOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "number_of_previous_passcodes",
                "numberOfPreviousPasscodes",
                int,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_passcode",
                "disallowReversedOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "min_code_length",
                "minCodeLength",
                int,
                is_required=True,
            ),
            E(
                "max_code_length",
                "maxCodeLength",
                int,
                is_required=True,
            ),
            E(
                "disable_login_after_max_failed_login_attempts",
                "disableLoginAfterMaxFailedLoginAttempts",
                bool,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "expire_password",
                "expirePassword",
                bool,
                is_required=True,
            ),
            E(
                "passcode_expires_days",
                "passcodeExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "enable_default_passcode",
                "enableDefaultPasscode",
                bool,
                is_required=True,
            ),
            E(
                "default_passcode",
                "defaultPasscode",
                str,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
                is_required=True,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
                is_required=True,
            ),
        )


class ServiceProviderSIPAuthenticationPasswordRulesGetRequestRI(OCIType):
    """
    Request to get the service provider level SIP authentication password rule settings.

    The response is either a ServiceProviderSIPAuthenticationPasswordRulesGetResponseRI or
    an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class ServiceProviderSIPAuthenticationPasswordRulesGetResponseRI(OCIType):
    """
    Response to ServiceProviderSIPAuthenticationPasswordRulesGetRequestRI.

    Contains the SIP authentication password rules for the service provider.

    Attributes:
        use_service_provider_settings (bool): useServiceProviderSettings
        disallow_authentication_name (bool): disallowAuthenticationName
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        send_permanent_lockout_notification (bool): sendPermanentLockoutNotification
        permanent_lockout_notify_email_address (str): permanentLockoutNotifyEmailAddress
            *Optional*
        endpoint_authentication_lockout_type (str): endpointAuthenticationLockoutType
        endpoint_temporary_lockout_threshold (int): endpointTemporaryLockoutThreshold
        endpoint_wait_algorithm (str): endpointWaitAlgorithm
        endpoint_lockout_fixed_minutes (str): endpointLockoutFixedMinutes
        endpoint_permanent_lockout_threshold (int): endpointPermanentLockoutThreshold
        trunk_group_temporary_lockout_threshold (int): trunkGroupTemporaryLockoutThreshold
        trunk_group_authentication_lockout_type (str): trunkGroupAuthenticationLockoutType
        trunk_group_wait_algorithm (str): trunkGroupWaitAlgorithm
        trunk_group_lockout_fixed_minutes (str): trunkGroupLockoutFixedMinutes
        trunk_group_permanent_lockout_threshold (int): trunkGroupPermanentLockoutThreshold
        use_password_validation_service (bool): usePasswordValidationService
    """

    __slots__: List[str] = [
        "use_service_provider_settings",
        "disallow_authentication_name",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "send_permanent_lockout_notification",
        "permanent_lockout_notify_email_address",
        "endpoint_authentication_lockout_type",
        "endpoint_temporary_lockout_threshold",
        "endpoint_wait_algorithm",
        "endpoint_lockout_fixed_minutes",
        "endpoint_permanent_lockout_threshold",
        "trunk_group_temporary_lockout_threshold",
        "trunk_group_authentication_lockout_type",
        "trunk_group_wait_algorithm",
        "trunk_group_lockout_fixed_minutes",
        "trunk_group_permanent_lockout_threshold",
        "use_password_validation_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_service_provider_settings",
                "useServiceProviderSettings",
                bool,
                is_required=True,
            ),
            E(
                "disallow_authentication_name",
                "disallowAuthenticationName",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "send_permanent_lockout_notification",
                "sendPermanentLockoutNotification",
                bool,
                is_required=True,
            ),
            E(
                "permanent_lockout_notify_email_address",
                "permanentLockoutNotifyEmailAddress",
                str,
            ),
            E(
                "endpoint_authentication_lockout_type",
                "endpointAuthenticationLockoutType",
                str,
                is_required=True,
            ),
            E(
                "endpoint_temporary_lockout_threshold",
                "endpointTemporaryLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "endpoint_wait_algorithm",
                "endpointWaitAlgorithm",
                str,
                is_required=True,
            ),
            E(
                "endpoint_lockout_fixed_minutes",
                "endpointLockoutFixedMinutes",
                str,
                is_required=True,
            ),
            E(
                "endpoint_permanent_lockout_threshold",
                "endpointPermanentLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "trunk_group_temporary_lockout_threshold",
                "trunkGroupTemporaryLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "trunk_group_authentication_lockout_type",
                "trunkGroupAuthenticationLockoutType",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_wait_algorithm",
                "trunkGroupWaitAlgorithm",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_lockout_fixed_minutes",
                "trunkGroupLockoutFixedMinutes",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_permanent_lockout_threshold",
                "trunkGroupPermanentLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
                is_required=True,
            ),
        )


class ServiceProviderVoiceMessagingGroupSettingsAdd(OCIType):
    """
    A service provider's or enterprise's voice messaging settings used in the context of
    add.


    Attributes:
        delivery_from_address (str): deliveryFromAddress *Optional*
        notification_from_address (str): notificationFromAddress *Optional*
        voice_portal_lockout_from_address (str): voicePortalLockoutFromAddress *Optional*
        use_system_default_delivery_from_address (bool):
            useSystemDefaultDeliveryFromAddress
        use_system_default_notification_from_address (bool):
            useSystemDefaultNotificationFromAddress
        use_system_default_voice_portal_lockout_from_address (bool):
            useSystemDefaultVoicePortalLockoutFromAddress
    """

    __slots__: List[str] = [
        "delivery_from_address",
        "notification_from_address",
        "voice_portal_lockout_from_address",
        "use_system_default_delivery_from_address",
        "use_system_default_notification_from_address",
        "use_system_default_voice_portal_lockout_from_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "delivery_from_address",
                "deliveryFromAddress",
                str,
            ),
            E(
                "notification_from_address",
                "notificationFromAddress",
                str,
            ),
            E(
                "voice_portal_lockout_from_address",
                "voicePortalLockoutFromAddress",
                str,
            ),
            E(
                "use_system_default_delivery_from_address",
                "useSystemDefaultDeliveryFromAddress",
                bool,
                is_required=True,
            ),
            E(
                "use_system_default_notification_from_address",
                "useSystemDefaultNotificationFromAddress",
                bool,
                is_required=True,
            ),
            E(
                "use_system_default_voice_portal_lockout_from_address",
                "useSystemDefaultVoicePortalLockoutFromAddress",
                bool,
                is_required=True,
            ),
        )


class SimultaneousRingNumber(OCIType):
    """
    Simultaneous Ring number entry.


    Attributes:
        phone_number (str): phoneNumber
        answer_confirmation_required (bool): answerConfirmationRequired
    """

    __slots__: List[str] = [
        "phone_number",
        "answer_confirmation_required",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "answer_confirmation_required",
                "answerConfirmationRequired",
                bool,
                is_required=True,
            ),
        )


class SortCriteria(OCIType):
    """
    The sort criteria specifies whether sort is ascending or descending, and whether the
    sort is case sensitive.

    Sort order defaults to ascending and case sensitive.

    Attributes:
        is_ascending (bool): isAscending
        is_case_sensitive (bool): isCaseSensitive
    """

    __slots__: List[str] = [
        "is_ascending",
        "is_case_sensitive",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_ascending",
                "isAscending",
                bool,
                is_required=True,
            ),
            E(
                "is_case_sensitive",
                "isCaseSensitive",
                bool,
                is_required=True,
            ),
        )


class SortCriteriaNumeric(OCIType):
    """
    The sort criteria specifies whether sort is ascending or descending.

    Sort order defaults to ascending.

    Attributes:
        is_ascending (bool): isAscending
    """

    __slots__: List[str] = [
        "is_ascending",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_ascending",
                "isAscending",
                bool,
                is_required=True,
            ),
        )


class SpeedDial100Entry(OCIType):
    """
    Modify the speed dial 100 prefix setting for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        speed_code (int): speedCode
        phone_number (str): phoneNumber
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "speed_code",
        "phone_number",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "speed_code",
                "speedCode",
                int,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class SpeedDial100EntryModify(OCIType):
    """
    Modify the speed dial 100 prefix setting for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        speed_code (int): speedCode
        phone_number (str): phoneNumber *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "speed_code",
        "phone_number",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "speed_code",
                "speedCode",
                int,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class SpeedDial8Entry(OCIType):
    """
    Modify the speed dial 8 prefix setting for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        speed_code (int): speedCode
        phone_number (str): phoneNumber *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "speed_code",
        "phone_number",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "speed_code",
                "speedCode",
                int,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class StreetAddress(OCIType):
    """
    Street address information.


    Attributes:
        address_line1 (str): addressLine1 *Optional*
        address_line2 (str): addressLine2 *Optional*
        city (str): city *Optional*
        state_or_province (str): stateOrProvince *Optional*
        state_or_province_display_name (str): stateOrProvinceDisplayName *Optional*
        zip_or_postal_code (str): zipOrPostalCode *Optional*
        country (str): country *Optional*
    """

    __slots__: List[str] = [
        "address_line1",
        "address_line2",
        "city",
        "state_or_province",
        "state_or_province_display_name",
        "zip_or_postal_code",
        "country",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "address_line1",
                "addressLine1",
                str,
            ),
            E(
                "address_line2",
                "addressLine2",
                str,
            ),
            E(
                "city",
                "city",
                str,
            ),
            E(
                "state_or_province",
                "stateOrProvince",
                str,
            ),
            E(
                "state_or_province_display_name",
                "stateOrProvinceDisplayName",
                str,
            ),
            E(
                "zip_or_postal_code",
                "zipOrPostalCode",
                str,
            ),
            E(
                "country",
                "country",
                str,
            ),
        )


class SystemBroadWorksMobilityGetRequest21sp1V2(OCIType):
    """
    Get the broadworks mobility system parameters.

    The response is either a SystemBroadWorksMobilityGetResponse21sp1V2 or an
    `ErrorResponse()`. Replaced by `SystemBroadWorksMobilityGetRequest22V2()`.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class SystemBroadWorksMobilityGetResponse21sp1V2(OCIType):
    """
    The response to a SystemBroadWorksMobilityGetRequest21sp1V2.

    Replaced by `SystemBroadWorksMobilityGetResponse22V2()`.

    Attributes:
        enable_location_services (bool): enableLocationServices
        enable_msrn_lookup (bool): enableMSRNLookup
        enable_mobile_state_checking (bool): enableMobileStateChecking
        deny_call_originations (bool): denyCallOriginations
        deny_call_terminations (bool): denyCallTerminations
        imrn_timeout_millisecnds (int): imrnTimeoutMillisecnds
        enable_internal_clid_delivery_access_locations (bool):
            enableInternalCLIDDeliveryAccessLocations
        enable_enhanced_unreachable_state_checking (bool):
            enableEnhancedUnreachableStateChecking
        enable_network_call_barring_status_check (bool):
            enableNetworkCallBarringStatusCheck
    """

    __slots__: List[str] = [
        "enable_location_services",
        "enable_msrn_lookup",
        "enable_mobile_state_checking",
        "deny_call_originations",
        "deny_call_terminations",
        "imrn_timeout_millisecnds",
        "enable_internal_clid_delivery_access_locations",
        "enable_enhanced_unreachable_state_checking",
        "enable_network_call_barring_status_check",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_location_services",
                "enableLocationServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_msrn_lookup",
                "enableMSRNLookup",
                bool,
                is_required=True,
            ),
            E(
                "enable_mobile_state_checking",
                "enableMobileStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_originations",
                "denyCallOriginations",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_terminations",
                "denyCallTerminations",
                bool,
                is_required=True,
            ),
            E(
                "imrn_timeout_millisecnds",
                "imrnTimeoutMillisecnds",
                int,
                is_required=True,
            ),
            E(
                "enable_internal_clid_delivery_access_locations",
                "enableInternalCLIDDeliveryAccessLocations",
                bool,
                is_required=True,
            ),
            E(
                "enable_enhanced_unreachable_state_checking",
                "enableEnhancedUnreachableStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "enable_network_call_barring_status_check",
                "enableNetworkCallBarringStatusCheck",
                bool,
                is_required=True,
            ),
        )


class SystemCollaborateGetRequest20sp1V2(OCIType):
    """
    Request the system level data associated with collaborate services.

    The response is either a SystemCollaborateGetResponse20sp1V2 or an `ErrorResponse()`.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class SystemCommunicationBarringProfileGetRequest19sp1V2(OCIType):
    """
    Get an existing Communication Barring Profile.

    The response is either a SystemCommunicationBarringProfileGetResponse19sp1V2 or an
    `ErrorResponse()`.

    Attributes:
        name (str): name
    """

    __slots__: List[str] = [
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class SystemDeviceProfileAuthenticationPasswordRulesGetRequestRI(OCIType):
    """
    Request to get the system level device profile authentication password rule settings.

    The response is either a SystemDeviceProfileAuthenticationPasswordRulesGetResponseRI
    or an `ErrorResponse()`.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class SystemDeviceProfileAuthenticationPasswordRulesGetResponseRI(OCIType):
    """
    Response to SystemDeviceProfileAuthenticationPasswordRulesGetRequestRI.

    Contains the device profile authentication password rules for the system.

    Attributes:
        disallow_authentication_name (bool): disallowAuthenticationName
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        send_permanent_lockout_notification (bool): sendPermanentLockoutNotification
        permanent_lockout_notify_email_address (str): permanentLockoutNotifyEmailAddress
            *Optional*
        device_profile_authentication_lockout_type (str):
            deviceProfileAuthenticationLockoutType
        device_profile_temporary_lockout_threshold (int):
            deviceProfileTemporaryLockoutThreshold
        device_profile_wait_algorithm (str): deviceProfileWaitAlgorithm
        device_profile_lockout_fixed_minutes (str): deviceProfileLockoutFixedMinutes
        device_profile_permanent_lockout_threshold (int):
            deviceProfilePermanentLockoutThreshold
        use_password_validation_service (bool): usePasswordValidationService
    """

    __slots__: List[str] = [
        "disallow_authentication_name",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "send_permanent_lockout_notification",
        "permanent_lockout_notify_email_address",
        "device_profile_authentication_lockout_type",
        "device_profile_temporary_lockout_threshold",
        "device_profile_wait_algorithm",
        "device_profile_lockout_fixed_minutes",
        "device_profile_permanent_lockout_threshold",
        "use_password_validation_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disallow_authentication_name",
                "disallowAuthenticationName",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "send_permanent_lockout_notification",
                "sendPermanentLockoutNotification",
                bool,
                is_required=True,
            ),
            E(
                "permanent_lockout_notify_email_address",
                "permanentLockoutNotifyEmailAddress",
                str,
            ),
            E(
                "device_profile_authentication_lockout_type",
                "deviceProfileAuthenticationLockoutType",
                str,
                is_required=True,
            ),
            E(
                "device_profile_temporary_lockout_threshold",
                "deviceProfileTemporaryLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "device_profile_wait_algorithm",
                "deviceProfileWaitAlgorithm",
                str,
                is_required=True,
            ),
            E(
                "device_profile_lockout_fixed_minutes",
                "deviceProfileLockoutFixedMinutes",
                str,
                is_required=True,
            ),
            E(
                "device_profile_permanent_lockout_threshold",
                "deviceProfilePermanentLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
                is_required=True,
            ),
        )


class SystemPasswordRulesGetRequestRI(OCIType):
    """
    Requests the system's password rules setting applicable to System administrator,
    Provisioning Administrator, and/or Service Provider Administrator, Group
    Administrator, Department Administrator, user.

    The response is either SystemPasswordRulesGetResponseRI or `ErrorResponse()`.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class SystemPasswordRulesGetResponseRI(OCIType):
    """
    Response to SystemPasswordRulesGetRequestRI.

    Contains the password rules for System administrator, Provisioning Administrator,
    and/or Service Provider Administrator, Group Administrator, Department Administrator,
    user.  The following element is only used in AS data mode:
    forcePasswordChangeAfterReset, value "false" is returned in XS data mode The two
    following enumeration values are only application in AS data mode: System,
    Provisioning Administrator.  All other administrators and users use external
    authentication System, Provisioning Administrator.  All other administrators and users
    use their organization's password rules In XS data mode only System, Provisioning
    Administrator.  All other administrators and users use external authentication will be
    returned and it behave the same as System, Provisioning, Service Provider
    Administrator from the data type SystemPasswordRulesApplyTo The following element is
    only returned in AS data mode: enforceExternalAuthForRoutePoint reenableLogin
    lockOutInMinutes

    Attributes:
        rules_apply_to (str): rulesApplyTo
        allow_web_add_external_authentication_users (bool):
            allowWebAddExternalAuthenticationUsers
        disallow_user_id (bool): disallowUserId
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        max_failed_login_attempts (int): maxFailedLoginAttempts
        password_expires_days (int): passwordExpiresDays
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_rules_modification (bool): disallowRulesModification
        disallow_previous_passwords (bool): disallowPreviousPasswords
        number_of_previous_passwords (int): numberOfPreviousPasswords
        force_password_change_after_reset (bool): forcePasswordChangeAfterReset
        enforce_external_auth_for_route_point (bool): enforceExternalAuthForRoutePoint
            *Optional*
        use_password_validation_service (bool): usePasswordValidationService
        reenable_login (bool): reenableLogin
        lock_out_in_minutes (int): lockOutInMinutes
    """

    __slots__: List[str] = [
        "rules_apply_to",
        "allow_web_add_external_authentication_users",
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_rules_modification",
        "disallow_previous_passwords",
        "number_of_previous_passwords",
        "force_password_change_after_reset",
        "enforce_external_auth_for_route_point",
        "use_password_validation_service",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "rules_apply_to",
                "rulesApplyTo",
                str,
                is_required=True,
            ),
            E(
                "allow_web_add_external_authentication_users",
                "allowWebAddExternalAuthenticationUsers",
                bool,
                is_required=True,
            ),
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
                is_required=True,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_rules_modification",
                "disallowRulesModification",
                bool,
                is_required=True,
            ),
            E(
                "disallow_previous_passwords",
                "disallowPreviousPasswords",
                bool,
                is_required=True,
            ),
            E(
                "number_of_previous_passwords",
                "numberOfPreviousPasswords",
                int,
                is_required=True,
            ),
            E(
                "force_password_change_after_reset",
                "forcePasswordChangeAfterReset",
                bool,
                is_required=True,
            ),
            E(
                "enforce_external_auth_for_route_point",
                "enforceExternalAuthForRoutePoint",
                bool,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
                is_required=True,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
                is_required=True,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
                is_required=True,
            ),
        )


class SystemPasswordRulesModifyRequestRI(OCIType):
    """
    Request to modify the system providers password rule setting applicable to System
    Adminstrator, Provisioning Administrator, and/or Service Provider Administrator, Group
    Administrator, Department Administrator, User.

    The following elements are only used in AS data mode and ignored in XS data mode:
    forcePasswordChangeAfterReset reenableLogin lockOutInMinutes

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        rules_apply_to (str): rulesApplyTo *Optional*
        allow_web_add_external_authentication_users (bool):
            allowWebAddExternalAuthenticationUsers *Optional*
        disallow_user_id (bool): disallowUserId *Optional*
        disallow_old_password (bool): disallowOldPassword *Optional*
        disallow_reversed_old_password (bool): disallowReversedOldPassword *Optional*
        restrict_min_digits (bool): restrictMinDigits *Optional*
        min_digits (int): minDigits *Optional*
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters *Optional*
        min_upper_case_letters (int): minUpperCaseLetters *Optional*
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters *Optional*
        min_lower_case_letters (int): minLowerCaseLetters *Optional*
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters *Optional*
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters *Optional*
        min_length (int): minLength *Optional*
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        password_expires_days (int): passwordExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail *Optional*
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_previous_passwords (bool): disallowPreviousPasswords *Optional*
        number_of_previous_passwords (int): numberOfPreviousPasswords *Optional*
        force_password_change_after_reset (bool): forcePasswordChangeAfterReset *Optional*
        enforce_external_auth_for_route_point (bool): enforceExternalAuthForRoutePoint
            *Optional*
        use_password_validation_service (bool): usePasswordValidationService *Optional*
        reenable_login (bool): reenableLogin *Optional*
        lock_out_in_minutes (int): lockOutInMinutes *Optional*
    """

    __slots__: List[str] = [
        "rules_apply_to",
        "allow_web_add_external_authentication_users",
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_previous_passwords",
        "number_of_previous_passwords",
        "force_password_change_after_reset",
        "enforce_external_auth_for_route_point",
        "use_password_validation_service",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "rules_apply_to",
                "rulesApplyTo",
                str,
            ),
            E(
                "allow_web_add_external_authentication_users",
                "allowWebAddExternalAuthenticationUsers",
                bool,
            ),
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
            ),
            E(
                "min_length",
                "minLength",
                int,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_previous_passwords",
                "disallowPreviousPasswords",
                bool,
            ),
            E(
                "number_of_previous_passwords",
                "numberOfPreviousPasswords",
                int,
            ),
            E(
                "force_password_change_after_reset",
                "forcePasswordChangeAfterReset",
                bool,
            ),
            E(
                "enforce_external_auth_for_route_point",
                "enforceExternalAuthForRoutePoint",
                bool,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
            ),
        )


class SystemPortalPasscodeRulesGetRequestRI(OCIType):
    """
    Requests the system passcode rules setting.

    The response is either SystemPortalPasscodeRulesGetResponseRI or `ErrorResponse()`.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class SystemPortalPasscodeRulesGetResponseRI(OCIType):
    """
    Response to SystemPortalPasscodeRulesGetRequestRI.

    Contains the system passcode rules setting.  The following elements are only used in
    AS data mode: numberOfRepeatedDigits disallowRepeatedPatterns
    disallowContiguousSequences numberOfAscendingDigits numberOfDescendingDigits
    numberOfPreviousPasscodes reenableLogin lockOutInMinutes

    Attributes:
        disallow_repeated_digits (bool): disallowRepeatedDigits
        number_of_repeated_digits (int): numberOfRepeatedDigits
        disallow_repeated_patterns (bool): disallowRepeatedPatterns
        disallow_contiguous_sequences (bool): disallowContiguousSequences
        number_of_ascending_digits (int): numberOfAscendingDigits
        number_of_descending_digits (int): numberOfDescendingDigits
        disallow_user_number (bool): disallowUserNumber
        disallow_reversed_user_number (bool): disallowReversedUserNumber
        disallow_old_passcode (bool): disallowOldPasscode
        number_of_previous_passcodes (int): numberOfPreviousPasscodes
        disallow_reversed_old_passcode (bool): disallowReversedOldPasscode
        min_code_length (int): minCodeLength
        max_code_length (int): maxCodeLength
        disable_login_after_max_failed_login_attempts (bool):
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        expire_password (bool): expirePassword
        passcode_expires_days (int): passcodeExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        default_password (str): defaultPassword
        reenable_login (bool): reenableLogin
        lock_out_in_minutes (int): lockOutInMinutes
    """

    __slots__: List[str] = [
        "disallow_repeated_digits",
        "number_of_repeated_digits",
        "disallow_repeated_patterns",
        "disallow_contiguous_sequences",
        "number_of_ascending_digits",
        "number_of_descending_digits",
        "disallow_user_number",
        "disallow_reversed_user_number",
        "disallow_old_passcode",
        "number_of_previous_passcodes",
        "disallow_reversed_old_passcode",
        "min_code_length",
        "max_code_length",
        "disable_login_after_max_failed_login_attempts",
        "max_failed_login_attempts",
        "expire_password",
        "passcode_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "default_password",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disallow_repeated_digits",
                "disallowRepeatedDigits",
                bool,
                is_required=True,
            ),
            E(
                "number_of_repeated_digits",
                "numberOfRepeatedDigits",
                int,
                is_required=True,
            ),
            E(
                "disallow_repeated_patterns",
                "disallowRepeatedPatterns",
                bool,
                is_required=True,
            ),
            E(
                "disallow_contiguous_sequences",
                "disallowContiguousSequences",
                bool,
                is_required=True,
            ),
            E(
                "number_of_ascending_digits",
                "numberOfAscendingDigits",
                int,
                is_required=True,
            ),
            E(
                "number_of_descending_digits",
                "numberOfDescendingDigits",
                int,
                is_required=True,
            ),
            E(
                "disallow_user_number",
                "disallowUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_user_number",
                "disallowReversedUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_passcode",
                "disallowOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "number_of_previous_passcodes",
                "numberOfPreviousPasscodes",
                int,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_passcode",
                "disallowReversedOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "min_code_length",
                "minCodeLength",
                int,
                is_required=True,
            ),
            E(
                "max_code_length",
                "maxCodeLength",
                int,
                is_required=True,
            ),
            E(
                "disable_login_after_max_failed_login_attempts",
                "disableLoginAfterMaxFailedLoginAttempts",
                bool,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "expire_password",
                "expirePassword",
                bool,
                is_required=True,
            ),
            E(
                "passcode_expires_days",
                "passcodeExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "default_password",
                "defaultPassword",
                str,
                is_required=True,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
                is_required=True,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
                is_required=True,
            ),
        )


class SystemSIPAuthenticationPasswordRulesGetRequestRI(OCIType):
    """
    Request to get the system level SIP authentication password rule settings.

    The response is either a SystemSIPAuthenticationPasswordRulesGetResponseRI or an
    `ErrorResponse()`.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class SystemSIPAuthenticationPasswordRulesGetResponseRI(OCIType):
    """
    Response to SystemSIPAuthenticationPasswordRulesGetRequestRI.

    Contains the SIP authentication password rules for the system.

    Attributes:
        disallow_authentication_name (bool): disallowAuthenticationName
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        send_permanent_lockout_notification (bool): sendPermanentLockoutNotification
        permanent_lockout_notify_email_address (str): permanentLockoutNotifyEmailAddress
            *Optional*
        endpoint_authentication_lockout_type (str): endpointAuthenticationLockoutType
        endpoint_temporary_lockout_threshold (int): endpointTemporaryLockoutThreshold
        endpoint_wait_algorithm (str): endpointWaitAlgorithm
        endpoint_lockout_fixed_minutes (str): endpointLockoutFixedMinutes
        endpoint_permanent_lockout_threshold (int): endpointPermanentLockoutThreshold
        trunk_group_authentication_lockout_type (str): trunkGroupAuthenticationLockoutType
        trunk_group_temporary_lockout_threshold (int): trunkGroupTemporaryLockoutThreshold
        trunk_group_wait_algorithm (str): trunkGroupWaitAlgorithm
        trunk_group_lockout_fixed_minutes (str): trunkGroupLockoutFixedMinutes
        trunk_group_permanent_lockout_threshold (int): trunkGroupPermanentLockoutThreshold
        use_password_validation_service (bool): usePasswordValidationService
    """

    __slots__: List[str] = [
        "disallow_authentication_name",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "send_permanent_lockout_notification",
        "permanent_lockout_notify_email_address",
        "endpoint_authentication_lockout_type",
        "endpoint_temporary_lockout_threshold",
        "endpoint_wait_algorithm",
        "endpoint_lockout_fixed_minutes",
        "endpoint_permanent_lockout_threshold",
        "trunk_group_authentication_lockout_type",
        "trunk_group_temporary_lockout_threshold",
        "trunk_group_wait_algorithm",
        "trunk_group_lockout_fixed_minutes",
        "trunk_group_permanent_lockout_threshold",
        "use_password_validation_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disallow_authentication_name",
                "disallowAuthenticationName",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "send_permanent_lockout_notification",
                "sendPermanentLockoutNotification",
                bool,
                is_required=True,
            ),
            E(
                "permanent_lockout_notify_email_address",
                "permanentLockoutNotifyEmailAddress",
                str,
            ),
            E(
                "endpoint_authentication_lockout_type",
                "endpointAuthenticationLockoutType",
                str,
                is_required=True,
            ),
            E(
                "endpoint_temporary_lockout_threshold",
                "endpointTemporaryLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "endpoint_wait_algorithm",
                "endpointWaitAlgorithm",
                str,
                is_required=True,
            ),
            E(
                "endpoint_lockout_fixed_minutes",
                "endpointLockoutFixedMinutes",
                str,
                is_required=True,
            ),
            E(
                "endpoint_permanent_lockout_threshold",
                "endpointPermanentLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "trunk_group_authentication_lockout_type",
                "trunkGroupAuthenticationLockoutType",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_temporary_lockout_threshold",
                "trunkGroupTemporaryLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "trunk_group_wait_algorithm",
                "trunkGroupWaitAlgorithm",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_lockout_fixed_minutes",
                "trunkGroupLockoutFixedMinutes",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_permanent_lockout_threshold",
                "trunkGroupPermanentLockoutThreshold",
                int,
                is_required=True,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
                is_required=True,
            ),
        )


class SystemSIPDeviceTypeGetRequest18sp1V2(OCIType):
    """
    Request to get a sip device type.

    See Also: `SystemDeviceTypeGetRequest()`

    The response is either `SystemSIPDeviceTypeGetResponse19()` or `ErrorResponse()`.
    Replaced by: `SystemSIPDeviceTypeGetRequest19()`.

    Attributes:
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class SystemSIPDeviceTypeGetRequest21sp1V2(OCIType):
    """
    Request to get a sip device type.

    See Also: `SystemDeviceTypeGetRequest()`

    The response is either SystemSIPDeviceTypeGetResponse21sp1V2 or `ErrorResponse()`.
    Replaced by: `SystemSIPDeviceTypeGetRequest22()` in AS data mode.

    Attributes:
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class SystemVoiceMessagingGroupGetRequestRI(OCIType):
    """
    Request the system level data associated with Voice Messaging.

    The response is either a SystemVoiceMessagingGroupGetResponseRI or an
    `ErrorResponse()`.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class SystemVoiceMessagingGroupGetResponseRI(OCIType):
    """
    Response to SystemVoiceMessagingGroupGetRequestRI.

    The following elements are only used in AS data mode: realDeleteForImap
    useDnInMailBody useShortSubjectLine maxMessageLengthMinutes maxMailboxLengthMinutes
    doesMessageAge holdPeriodDays mailServerNetAddress mailServerProtocol
    defaultDeliveryFromAddress defaultNotificationFromAddress useOutgoingMWIOnSMDI
    mwiDelayInSeconds voicePortalScope enterpriseVoicePortalLicensed networkWideMessaging
    useExternalRouting defaultExternalRoutingAddress vmOnlySystem
    clientInitiatedMailServerSessionTimeoutMinutes recordingAudioFileFormat
    allowVoicePortalAccessFromVMDepositMenu allowVoicePortalAutoLoginForMobileDevicesOnly
    selectMwiTemplatePerCaller

    Attributes:
        real_delete_for_imap (bool): realDeleteForImap
        use_dn_in_mail_body (bool): useDnInMailBody
        use_short_subject_line (bool): useShortSubjectLine
        max_message_length_minutes (int): maxMessageLengthMinutes
        max_mailbox_length_minutes (int): maxMailboxLengthMinutes
        does_message_age (bool): doesMessageAge
        hold_period_days (int): holdPeriodDays
        mail_server_net_address (str): mailServerNetAddress *Optional*
        mail_server_protocol (str): mailServerProtocol
        default_delivery_from_address (str): defaultDeliveryFromAddress
        default_notification_from_address (str): defaultNotificationFromAddress
        default_voice_portal_lockout_from_address (str):
            defaultVoicePortalLockoutFromAddress
        use_outgoing_mwi_on_smdi (bool): useOutgoingMWIOnSMDI
        mwi_delay_in_seconds (int): mwiDelayInSeconds
        voice_portal_scope (str): voicePortalScope
        enterprise_voice_portal_licensed (bool): enterpriseVoicePortalLicensed
        network_wide_messaging (bool): networkWideMessaging
        use_external_routing (bool): useExternalRouting
        default_external_routing_address (str): defaultExternalRoutingAddress *Optional*
        vm_only_system (bool): vmOnlySystem
        client_initiated_mail_server_session_timeout_minutes (int):
            clientInitiatedMailServerSessionTimeoutMinutes
        recording_audio_file_format (str): recordingAudioFileFormat
        allow_voice_portal_access_from_vm_deposit_menu (bool):
            allowVoicePortalAccessFromVMDepositMenu
        allow_voice_portal_auto_login_for_mobile_devices_only (bool):
            allowVoicePortalAutoLoginForMobileDevicesOnly
        select_mwi_template_per_caller (bool): selectMwiTemplatePerCaller
    """

    __slots__: List[str] = [
        "real_delete_for_imap",
        "use_dn_in_mail_body",
        "use_short_subject_line",
        "max_message_length_minutes",
        "max_mailbox_length_minutes",
        "does_message_age",
        "hold_period_days",
        "mail_server_net_address",
        "mail_server_protocol",
        "default_delivery_from_address",
        "default_notification_from_address",
        "default_voice_portal_lockout_from_address",
        "use_outgoing_mwi_on_smdi",
        "mwi_delay_in_seconds",
        "voice_portal_scope",
        "enterprise_voice_portal_licensed",
        "network_wide_messaging",
        "use_external_routing",
        "default_external_routing_address",
        "vm_only_system",
        "client_initiated_mail_server_session_timeout_minutes",
        "recording_audio_file_format",
        "allow_voice_portal_access_from_vm_deposit_menu",
        "allow_voice_portal_auto_login_for_mobile_devices_only",
        "select_mwi_template_per_caller",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "real_delete_for_imap",
                "realDeleteForImap",
                bool,
                is_required=True,
            ),
            E(
                "use_dn_in_mail_body",
                "useDnInMailBody",
                bool,
                is_required=True,
            ),
            E(
                "use_short_subject_line",
                "useShortSubjectLine",
                bool,
                is_required=True,
            ),
            E(
                "max_message_length_minutes",
                "maxMessageLengthMinutes",
                int,
                is_required=True,
            ),
            E(
                "max_mailbox_length_minutes",
                "maxMailboxLengthMinutes",
                int,
                is_required=True,
            ),
            E(
                "does_message_age",
                "doesMessageAge",
                bool,
                is_required=True,
            ),
            E(
                "hold_period_days",
                "holdPeriodDays",
                int,
                is_required=True,
            ),
            E(
                "mail_server_net_address",
                "mailServerNetAddress",
                str,
            ),
            E(
                "mail_server_protocol",
                "mailServerProtocol",
                str,
                is_required=True,
            ),
            E(
                "default_delivery_from_address",
                "defaultDeliveryFromAddress",
                str,
                is_required=True,
            ),
            E(
                "default_notification_from_address",
                "defaultNotificationFromAddress",
                str,
                is_required=True,
            ),
            E(
                "default_voice_portal_lockout_from_address",
                "defaultVoicePortalLockoutFromAddress",
                str,
                is_required=True,
            ),
            E(
                "use_outgoing_mwi_on_smdi",
                "useOutgoingMWIOnSMDI",
                bool,
                is_required=True,
            ),
            E(
                "mwi_delay_in_seconds",
                "mwiDelayInSeconds",
                int,
                is_required=True,
            ),
            E(
                "voice_portal_scope",
                "voicePortalScope",
                str,
                is_required=True,
            ),
            E(
                "enterprise_voice_portal_licensed",
                "enterpriseVoicePortalLicensed",
                bool,
                is_required=True,
            ),
            E(
                "network_wide_messaging",
                "networkWideMessaging",
                bool,
                is_required=True,
            ),
            E(
                "use_external_routing",
                "useExternalRouting",
                bool,
                is_required=True,
            ),
            E(
                "default_external_routing_address",
                "defaultExternalRoutingAddress",
                str,
            ),
            E(
                "vm_only_system",
                "vmOnlySystem",
                bool,
                is_required=True,
            ),
            E(
                "client_initiated_mail_server_session_timeout_minutes",
                "clientInitiatedMailServerSessionTimeoutMinutes",
                int,
                is_required=True,
            ),
            E(
                "recording_audio_file_format",
                "recordingAudioFileFormat",
                str,
                is_required=True,
            ),
            E(
                "allow_voice_portal_access_from_vm_deposit_menu",
                "allowVoicePortalAccessFromVMDepositMenu",
                bool,
                is_required=True,
            ),
            E(
                "allow_voice_portal_auto_login_for_mobile_devices_only",
                "allowVoicePortalAutoLoginForMobileDevicesOnly",
                bool,
                is_required=True,
            ),
            E(
                "select_mwi_template_per_caller",
                "selectMwiTemplatePerCaller",
                bool,
                is_required=True,
            ),
        )


class SystemVoiceMessagingGroupModifyRequestRI(OCIType):
    """
    Modify the system level data associated with Voice Messaging.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode: realDeleteForImap useDnInMailBody
    useShortSubjectLine maxMessageLengthMinutes maxMailboxLengthMinutes doesMessageAge
    holdPeriodDays mailServerNetAddress mailServerProtocol defaultDeliveryFromAddress
    defaultNotificationFromAddress useOutgoingMWIOnSMDI mwiDelayInSeconds voicePortalScope
    enterpriseVoicePortalLicensed networkWideMessaging useExternalRouting
    defaultExternalRoutingAddress vmOnlySystem
    clientInitiatedMailServerSessionTimeoutMinutes recordingAudioFileFormat
    allowVoicePortalAccessFromVMDepositMenu allowVoicePortalAutoLoginForMobileDevicesOnly
    selectMwiTemplatePerCaller

    Attributes:
        real_delete_for_imap (bool): realDeleteForImap *Optional*
        use_dn_in_mail_body (bool): useDnInMailBody *Optional*
        use_short_subject_line (bool): useShortSubjectLine *Optional*
        max_message_length_minutes (int): maxMessageLengthMinutes *Optional*
        max_mailbox_length_minutes (int): maxMailboxLengthMinutes *Optional*
        does_message_age (bool): doesMessageAge *Optional*
        hold_period_days (int): holdPeriodDays *Optional*
        mail_server_net_address (str): mailServerNetAddress *Optional*
        mail_server_protocol (str): mailServerProtocol *Optional*
        default_delivery_from_address (str): defaultDeliveryFromAddress *Optional*
        default_notification_from_address (str): defaultNotificationFromAddress *Optional*
        default_voice_portal_lockout_from_address (str):
            defaultVoicePortalLockoutFromAddress *Optional*
        use_outgoing_mwi_on_smdi (bool): useOutgoingMWIOnSMDI *Optional*
        mwi_delay_in_seconds (int): mwiDelayInSeconds *Optional*
        voice_portal_scope (str): voicePortalScope *Optional*
        network_wide_messaging (bool): networkWideMessaging *Optional*
        use_external_routing (bool): useExternalRouting *Optional*
        default_external_routing_address (str): defaultExternalRoutingAddress *Optional*
        vm_only_system (bool): vmOnlySystem *Optional*
        client_initiated_mail_server_session_timeout_minutes (int):
            clientInitiatedMailServerSessionTimeoutMinutes *Optional*
        recording_audio_file_format (str): recordingAudioFileFormat *Optional*
        allow_voice_portal_access_from_vm_deposit_menu (bool):
            allowVoicePortalAccessFromVMDepositMenu *Optional*
        allow_voice_portal_auto_login_for_mobile_devices_only (bool):
            allowVoicePortalAutoLoginForMobileDevicesOnly *Optional*
        select_mwi_template_per_caller (bool): selectMwiTemplatePerCaller *Optional*
    """

    __slots__: List[str] = [
        "real_delete_for_imap",
        "use_dn_in_mail_body",
        "use_short_subject_line",
        "max_message_length_minutes",
        "max_mailbox_length_minutes",
        "does_message_age",
        "hold_period_days",
        "mail_server_net_address",
        "mail_server_protocol",
        "default_delivery_from_address",
        "default_notification_from_address",
        "default_voice_portal_lockout_from_address",
        "use_outgoing_mwi_on_smdi",
        "mwi_delay_in_seconds",
        "voice_portal_scope",
        "network_wide_messaging",
        "use_external_routing",
        "default_external_routing_address",
        "vm_only_system",
        "client_initiated_mail_server_session_timeout_minutes",
        "recording_audio_file_format",
        "allow_voice_portal_access_from_vm_deposit_menu",
        "allow_voice_portal_auto_login_for_mobile_devices_only",
        "select_mwi_template_per_caller",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "real_delete_for_imap",
                "realDeleteForImap",
                bool,
            ),
            E(
                "use_dn_in_mail_body",
                "useDnInMailBody",
                bool,
            ),
            E(
                "use_short_subject_line",
                "useShortSubjectLine",
                bool,
            ),
            E(
                "max_message_length_minutes",
                "maxMessageLengthMinutes",
                int,
            ),
            E(
                "max_mailbox_length_minutes",
                "maxMailboxLengthMinutes",
                int,
            ),
            E(
                "does_message_age",
                "doesMessageAge",
                bool,
            ),
            E(
                "hold_period_days",
                "holdPeriodDays",
                int,
            ),
            E(
                "mail_server_net_address",
                "mailServerNetAddress",
                str,
            ),
            E(
                "mail_server_protocol",
                "mailServerProtocol",
                str,
            ),
            E(
                "default_delivery_from_address",
                "defaultDeliveryFromAddress",
                str,
            ),
            E(
                "default_notification_from_address",
                "defaultNotificationFromAddress",
                str,
            ),
            E(
                "default_voice_portal_lockout_from_address",
                "defaultVoicePortalLockoutFromAddress",
                str,
            ),
            E(
                "use_outgoing_mwi_on_smdi",
                "useOutgoingMWIOnSMDI",
                bool,
            ),
            E(
                "mwi_delay_in_seconds",
                "mwiDelayInSeconds",
                int,
            ),
            E(
                "voice_portal_scope",
                "voicePortalScope",
                str,
            ),
            E(
                "network_wide_messaging",
                "networkWideMessaging",
                bool,
            ),
            E(
                "use_external_routing",
                "useExternalRouting",
                bool,
            ),
            E(
                "default_external_routing_address",
                "defaultExternalRoutingAddress",
                str,
            ),
            E(
                "vm_only_system",
                "vmOnlySystem",
                bool,
            ),
            E(
                "client_initiated_mail_server_session_timeout_minutes",
                "clientInitiatedMailServerSessionTimeoutMinutes",
                int,
            ),
            E(
                "recording_audio_file_format",
                "recordingAudioFileFormat",
                str,
            ),
            E(
                "allow_voice_portal_access_from_vm_deposit_menu",
                "allowVoicePortalAccessFromVMDepositMenu",
                bool,
            ),
            E(
                "allow_voice_portal_auto_login_for_mobile_devices_only",
                "allowVoicePortalAutoLoginForMobileDevicesOnly",
                bool,
            ),
            E(
                "select_mwi_template_per_caller",
                "selectMwiTemplatePerCaller",
                bool,
            ),
        )


class TimeInterval(OCIType):
    """
    Time Interval.


    Attributes:
        start_day_of_week (str): startDayOfWeek
        start_hour (int): startHour
        start_minute (int): startMinute
        end_day_of_week (str): endDayOfWeek
        end_hour (int): endHour
        end_minute (int): endMinute
    """

    __slots__: List[str] = [
        "start_day_of_week",
        "start_hour",
        "start_minute",
        "end_day_of_week",
        "end_hour",
        "end_minute",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "start_day_of_week",
                "startDayOfWeek",
                str,
                is_required=True,
            ),
            E(
                "start_hour",
                "startHour",
                int,
                is_required=True,
            ),
            E(
                "start_minute",
                "startMinute",
                int,
                is_required=True,
            ),
            E(
                "end_day_of_week",
                "endDayOfWeek",
                str,
                is_required=True,
            ),
            E(
                "end_hour",
                "endHour",
                int,
                is_required=True,
            ),
            E(
                "end_minute",
                "endMinute",
                int,
                is_required=True,
            ),
        )


class TimeSchedule(OCIType):
    """
    The from dn criteria.


    Attributes:
        type (str): type
        name (str): name
    """

    __slots__: List[str] = [
        "type",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class TrunkGroupDeviceEndpointAdd(OCIType):
    """
    Trunk group device endpoint used in the context of modify.


    Attributes:
        name (str): name
        line_port (str): linePort
        contact (str): contact *Optional*
    """

    __slots__: List[str] = [
        "name",
        "line_port",
        "contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
        )


class TrunkGroupDeviceEndpointModify(OCIType):
    """
    Trunk group device endpoint used in the context of modify.


    Attributes:
        name (str): name
        line_port (str): linePort
        contact (str): contact *Optional*
    """

    __slots__: List[str] = [
        "name",
        "line_port",
        "contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
        )


class TrunkGroupDeviceEndpointRead(OCIType):
    """
    Trunk group device endpoint.


    Attributes:
        service_user_id (str): serviceUserId
        name (str): name
        line_port (str): linePort
        contact (str): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
    """

    __slots__: List[str] = [
        "service_user_id",
        "name",
        "line_port",
        "contact",
        "static_registration_capable",
        "use_domain",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
        )


class TrunkGroupDeviceEndpointRead14sp4(OCIType):
    """
    Trunk group device endpoint.


    Attributes:
        name (str): name
        line_port (str): linePort
        contact (str): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        is_pilot_user (bool): isPilotUser
    """

    __slots__: List[str] = [
        "name",
        "line_port",
        "contact",
        "static_registration_capable",
        "use_domain",
        "is_pilot_user",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "is_pilot_user",
                "isPilotUser",
                bool,
                is_required=True,
            ),
        )


class TrunkGroupDeviceMultipleContactEndpointAdd(OCIType):
    """
    Trunk group device endpoint used in the context of modify that can have multiple
    contacts.


    Attributes:
        name (str): name
        line_port (str): linePort
        contact (List[str]): contact *Optional*
    """

    __slots__: List[str] = [
        "name",
        "line_port",
        "contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
        )


class TrunkGroupDeviceMultipleContactEndpointRead(OCIType):
    """
    Trunk group device endpoint that can have multiple contacts.


    Attributes:
        name (str): name
        line_port (str): linePort
        contact (List[str]): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        is_pilot_user (bool): isPilotUser
    """

    __slots__: List[str] = [
        "name",
        "line_port",
        "contact",
        "static_registration_capable",
        "use_domain",
        "is_pilot_user",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "is_pilot_user",
                "isPilotUser",
                bool,
                is_required=True,
            ),
        )


class TrunkGroupKey(OCIType):
    """
    Uniquely identifies a Trunk Group system-wide.

    The trunkGroupName is unique within a group, but not unique system-wide.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class UnboundedNonNegativeInt(OCIType):
    """
    Unbounded Quantity.

    Can either be unlimited or a non-negative int quantity.

    Attributes:
        unlimited (bool): unlimited *Optional*
        quantity (int): quantity *Optional*
    """

    __slots__: List[str] = [
        "unlimited",
        "quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "unlimited",
                "unlimited",
                bool,
            ),
            E(
                "quantity",
                "quantity",
                int,
            ),
        )


class UnboundedPositiveInt(OCIType):
    """
    Unbounded Quantity.

    Can either be unlimited or a positive int quantity.

    Attributes:
        unlimited (bool): unlimited *Optional*
        quantity (int): quantity *Optional*
    """

    __slots__: List[str] = [
        "unlimited",
        "quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "unlimited",
                "unlimited",
                bool,
            ),
            E(
                "quantity",
                "quantity",
                int,
            ),
        )


class UserBroadWorksMobilityMobileIdentityGetRequest21sp1V2(OCIType):
    """
    Get the settings for a user's specified mobile identity.

    The response is either a UserBroadWorksMobilityMobileIdentityGetResponse21sp1V2 or an
    `ErrorResponse()`. Replaced by: `UserBroadWorksMobilityMobileIdentityGetRequest22()`.

    Attributes:
        user_id (str): userId
        mobile_number (str): mobileNumber
    """

    __slots__: List[str] = [
        "user_id",
        "mobile_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "mobile_number",
                "mobileNumber",
                str,
                is_required=True,
            ),
        )


class UserDNExtension(OCIType):
    """
    User's DN and extension.

    Used in SearchCriteriaComposedOrDnExtension when either a DN or an extension can be
    used as a search criteria.

    Attributes:
        dn (str): dn *Optional*
        extension (str): extension *Optional*
    """

    __slots__: List[str] = [
        "dn",
        "extension",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn",
                "dn",
                str,
            ),
            E(
                "extension",
                "extension",
                str,
            ),
        )


class UserDisplayNames(OCIType):
    """
    The parts of a user's display name that a client can display in whatever way is
    appropriate for the client application.


    Attributes:
        last_name (str): lastName
        first_name (str): firstName
        hiragana_last_name (str): hiraganaLastName *Optional*
        hiragana_first_name (str): hiraganaFirstName *Optional*
    """

    __slots__: List[str] = [
        "last_name",
        "first_name",
        "hiragana_last_name",
        "hiragana_first_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "last_name",
                "lastName",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
                is_required=True,
            ),
            E(
                "hiragana_last_name",
                "hiraganaLastName",
                str,
            ),
            E(
                "hiragana_first_name",
                "hiraganaFirstName",
                str,
            ),
        )


class UserEndpointKey(OCIType):
    """
    Key to uniquely identify a user endpoint.


    Attributes:
        user_id (str): userId
        line_port (str): linePort
    """

    __slots__: List[str] = [
        "user_id",
        "line_port",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
        )


class UserEnhancedCallLogsGetListResponse17sp4V2(OCIType):
    """
    Response to UserEnhancedCallLogsGetListRequest17sp4V2.

    Total numbers of rows is: - the total number of retrievable logs of the call log type
    that was specified in the UserEnhancedCallLogsGetListRequest17sp4V2, if a call log
    type was specified in the request.  - the total number of retrievable logs, if no call
    log type was specified in the request.  A list of MixedCallLogsEntry will be returned
    if the call logs are stored on CDS A list of ExtendedMixedCallLogsEntry17sp4 will be
    returned if the call logs are stored on DBS The logs are sorted by date/time of the
    call.

    Attributes:
        total_number_of_rows (int): totalNumberOfRows
        legacy_entry (legacyEntry): legacyEntry *Optional*
        extended_entry (extendedEntry): extendedEntry *Optional*
    """

    __slots__: List[str] = [
        "total_number_of_rows",
        "legacy_entry",
        "extended_entry",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_number_of_rows",
                "totalNumberOfRows",
                int,
                is_required=True,
            ),
            E(
                "legacy_entry",
                "legacyEntry",
                [
                    E(
                        "call_log",
                        "callLog",
                        MixedCallLogsEntry,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "extended_entry",
                "extendedEntry",
                [
                    E(
                        "extended_call_log",
                        "extendedCallLog",
                        ExtendedMixedCallLogsEntry17sp4,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class UserEnhancedCallLogsGetListResponse21sp1V2(OCIType):
    """
    Response to UserEnhancedCallLogsGetListRequest21sp1V2.

    Total numbers of rows is: - the total number of retrievable logs of the call log type
    that was specified in the UserEnhancedCallLogsGetListRequest21sp1V2, if a call log
    type was specified in the request.  - the total number of retrievable logs, if no call
    log type was specified in the request.  A list of MixedCallLogsEntry will be returned
    if the call logs are stored on CDS A list of ExtendedMixedCallLogsEntry21sp1V2 will be
    returned if the call logs are stored on DBS The logs are sorted by date/time of the
    call.

    Attributes:
        total_number_of_rows (int): totalNumberOfRows
        legacy_entry (legacyEntry): legacyEntry *Optional*
        extended_entry (extendedEntry): extendedEntry *Optional*
    """

    __slots__: List[str] = [
        "total_number_of_rows",
        "legacy_entry",
        "extended_entry",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_number_of_rows",
                "totalNumberOfRows",
                int,
                is_required=True,
            ),
            E(
                "legacy_entry",
                "legacyEntry",
                [
                    E(
                        "call_log",
                        "callLog",
                        MixedCallLogsEntry,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "extended_entry",
                "extendedEntry",
                [
                    E(
                        "extended_call_log",
                        "extendedCallLog",
                        ExtendedMixedCallLogsEntry21sp1V2,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class UserFeatureAccessCodeModifyEntry(OCIType):
    """
    Feature Access Code Entry to be used in all user modify command.


    Attributes:
        feature_access_code_name (str): featureAccessCodeName
        enable_fac (bool): enableFAC *Optional*
    """

    __slots__: List[str] = [
        "feature_access_code_name",
        "enable_fac",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "feature_access_code_name",
                "featureAccessCodeName",
                str,
                is_required=True,
            ),
            E(
                "enable_fac",
                "enableFAC",
                bool,
            ),
        )


class UserGetLoginInfoRequestRI(OCIType):
    """
    UserGetLoginInfoRequestRI is used to access login information for a user either by a
    userId, dn or lineport.

    The phone number may be any DN associated with a user.  The lineport may be any
    lineport associated with a user.

    The response is a UserGetLoginInfoResponseRI or an `ErrorResponse()`. The following
    elements are only used in AS data mode and ignored in XS data mode.  loginRole

    Attributes:
        user_id (str): userId *Optional*
        login_role (str): loginRole *Optional*
        phone_number (str): phoneNumber *Optional*
        line_port (str): linePort *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "login_role",
        "phone_number",
        "line_port",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "login_role",
                "loginRole",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
        )


class UserGetLoginInfoResponseRI(OCIType):
    """
    Response to UserGetLoginInfoRequestRI The following data elements are only used in AS
    data mode: resellerId lockoutPeriodExpiry If a phoneNumber is returned, it will be the
    primary DN of the user The parameter tokenRevocationTime is represented in the number
    of milliseconds since January 1, 1970, 00:00:00 GMT, and it is set to the more current
    time between the system level token revocation time and user level token revocation
    time.

    The parameter lockoutPeriodExpiry represents the time remaining (in minutes) to re-
    enable the locked user.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        last_name (str): lastName *Optional*
        first_name (str): firstName *Optional*
        user_id (str): userId
        phone_number (str): phoneNumber *Optional*
        reseller_id (str): resellerId *Optional*
        token_revocation_time (int): tokenRevocationTime *Optional*
        lockout_period_expiry (int): lockoutPeriodExpiry *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "last_name",
        "first_name",
        "user_id",
        "phone_number",
        "reseller_id",
        "token_revocation_time",
        "lockout_period_expiry",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "token_revocation_time",
                "tokenRevocationTime",
                int,
            ),
            E(
                "lockout_period_expiry",
                "lockoutPeriodExpiry",
                int,
            ),
        )


class UserGetRequest21sp1V2(OCIType):
    """
    Request to get the user information.

    The response is either UserGetResponse21sp1V2 or `ErrorResponse()`. Replaced by
    `UserGetRequest22V3()` in AS data mode

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class UserMoveMessage(OCIType):
    """
    The message describes the impact made when moving a user from one group to another
    group within the enterprise.

    The message could also contain the error condition that prevents the user move.

    Attributes:
        message_code (int): messageCode
        summary (str): summary
        summary_english (str): summaryEnglish
    """

    __slots__: List[str] = [
        "message_code",
        "summary",
        "summary_english",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "message_code",
                "messageCode",
                int,
                is_required=True,
            ),
            E(
                "summary",
                "summary",
                str,
                is_required=True,
            ),
            E(
                "summary_english",
                "summaryEnglish",
                str,
                is_required=True,
            ),
        )


class UserPreferredCarrierName(OCIType):
    """
    User can either use it's group's preferred carrier or use it's own.

    The user carrier name is exposed if it was previously configured.

    Attributes:
        use_group_preferred_carrier (bool): useGroupPreferredCarrier
        carrier (str): carrier *Optional*
    """

    __slots__: List[str] = [
        "use_group_preferred_carrier",
        "carrier",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_preferred_carrier",
                "useGroupPreferredCarrier",
                bool,
                is_required=True,
            ),
            E(
                "carrier",
                "carrier",
                str,
            ),
        )


class UserPreferredCarrierNameModify(OCIType):
    """
    User can either use it's group's preferred carrier or use it's own.

    You can use the group's preferred carrier without clearing the user carrier name -- in
    this case, the user carrier name is retained.

    Attributes:
        use_group_preferred_carrier (bool): useGroupPreferredCarrier
        carrier (str): carrier *Optional*
    """

    __slots__: List[str] = [
        "use_group_preferred_carrier",
        "carrier",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_preferred_carrier",
                "useGroupPreferredCarrier",
                bool,
                is_required=True,
            ),
            E(
                "carrier",
                "carrier",
                str,
            ),
        )


class UserTwoStageDialingGetRequest13Mp20(OCIType):
    """
    Request the user level data associated with Two Stage Dialing.

    The response is either a UserTwoStageDialingGetResponse13Mp20 or an `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class UserTwoStageDialingGetResponse13Mp20(OCIType):
    """
    Response to UserTwoStageDialingGetRequest13Mp20.


    Attributes:
        is_active (bool): isActive
        allow_activation_with_user_addresses (bool): allowActivationWithUserAddresses
    """

    __slots__: List[str] = [
        "is_active",
        "allow_activation_with_user_addresses",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "allow_activation_with_user_addresses",
                "allowActivationWithUserAddresses",
                bool,
                is_required=True,
            ),
        )


class VerifyTranslationAndRoutingOrigination(OCIType):
    """
    Verification Translation and Routing origination value.

    The following element is only used in AS mode: userId

    Attributes:
        line_port (str): linePort *Optional*
        phone (str): phone *Optional*
        user_id (str): userId *Optional*
        url (str): url *Optional*
    """

    __slots__: List[str] = [
        "line_port",
        "phone",
        "user_id",
        "url",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "phone",
                "phone",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "url",
                "url",
                str,
            ),
        )


class VirtualOnNetUser(OCIType):
    """
    Virtual On-Net User.


    Attributes:
        phone_number (str): phoneNumber
        extension (str): extension
        first_name (str): firstName
        last_name (str): lastName
        calling_line_id_first_name (str): callingLineIdFirstName
        calling_line_id_last_name (str): callingLineIdLastName
        virtual_on_net_call_type_name (str): virtualOnNetCallTypeName
    """

    __slots__: List[str] = [
        "phone_number",
        "extension",
        "first_name",
        "last_name",
        "calling_line_id_first_name",
        "calling_line_id_last_name",
        "virtual_on_net_call_type_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "extension",
                "extension",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
                is_required=True,
            ),
            E(
                "last_name",
                "lastName",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_first_name",
                "callingLineIdFirstName",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_last_name",
                "callingLineIdLastName",
                str,
                is_required=True,
            ),
            E(
                "virtual_on_net_call_type_name",
                "virtualOnNetCallTypeName",
                str,
                is_required=True,
            ),
        )


class VirtualOnNetUserKey(OCIType):
    """
    Virtual On-Net User identifier which is the Service Provider ID, Group ID, and phone
    number (in E.

    164 format).

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        phone_number (str): phoneNumber
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
        )


class VoiceMessagingAliasListModify(OCIType):
    """
    A list of dns that is added to a previously configured list.


    Attributes:
        phone_number (List[str]): phoneNumber
    """

    __slots__: List[str] = [
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class VoiceMessagingAliasReplacementList(OCIType):
    """
    A list of dns that that replaces a previously configured list.

    By convention, an element of this type may be set nil to clear the list.

    Attributes:
        phone_number (List[str]): phoneNumber
    """

    __slots__: List[str] = [
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class VoiceMessagingAlternateNoAnswerGreetingRead(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when geting a user's voice messaging greeting.

    Attributes:
        name (str): name
        audio_file (str): audioFile *Optional*
        video_file (str): videoFile *Optional*
    """

    __slots__: List[str] = [
        "name",
        "audio_file",
        "video_file",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "audio_file",
                "audioFile",
                str,
            ),
            E(
                "video_file",
                "videoFile",
                str,
            ),
        )


class VoiceMessagingAlternateNoAnswerGreetingRead16(OCIType):
    """
    The configuration of a alternate no answer greeting.

    It is used when geting a user's voice messaging greeting.

    Attributes:
        name (str): name
        audio_file (str): audioFile *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_file (str): videoFile *Optional*
        video_media_type (str): videoMediaType *Optional*
    """

    __slots__: List[str] = [
        "name",
        "audio_file",
        "audio_media_type",
        "video_file",
        "video_media_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "audio_file",
                "audioFile",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_file",
                "videoFile",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
        )


class VoiceMessagingMenuKeysModifyEntry(OCIType):
    """
    The voice portal voice messaging menu keys modify entry.


    Attributes:
        play_messages (str): playMessages *Optional*
        change_busy_greeting (str): changeBusyGreeting *Optional*
        change_no_answer_greeting (str): changeNoAnswerGreeting *Optional*
        change_extended_away_greeting (str): changeExtendedAwayGreeting *Optional*
        compose_message (str): composeMessage *Optional*
        delete_all_messages (str): deleteAllMessages *Optional*
        passcode (str): passcode *Optional*
        personalized_name (str): personalizedName *Optional*
        message_deposit (str): messageDeposit *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "play_messages",
        "change_busy_greeting",
        "change_no_answer_greeting",
        "change_extended_away_greeting",
        "compose_message",
        "delete_all_messages",
        "passcode",
        "personalized_name",
        "message_deposit",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "play_messages",
                "playMessages",
                str,
            ),
            E(
                "change_busy_greeting",
                "changeBusyGreeting",
                str,
            ),
            E(
                "change_no_answer_greeting",
                "changeNoAnswerGreeting",
                str,
            ),
            E(
                "change_extended_away_greeting",
                "changeExtendedAwayGreeting",
                str,
            ),
            E(
                "compose_message",
                "composeMessage",
                str,
            ),
            E(
                "delete_all_messages",
                "deleteAllMessages",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "personalized_name",
                "personalizedName",
                str,
            ),
            E(
                "message_deposit",
                "messageDeposit",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class VoiceMessagingMenuKeysReadEntry(OCIType):
    """
    The voice portal voice messaging menu keys.


    Attributes:
        play_messages (str): playMessages *Optional*
        change_busy_greeting (str): changeBusyGreeting *Optional*
        change_no_answer_greeting (str): changeNoAnswerGreeting *Optional*
        change_extended_away_greeting (str): changeExtendedAwayGreeting *Optional*
        compose_message (str): composeMessage *Optional*
        delete_all_messages (str): deleteAllMessages *Optional*
        passcode (str): passcode *Optional*
        personalized_name (str): personalizedName *Optional*
        message_deposit (str): messageDeposit *Optional*
        return_to_previous_menu (str): returnToPreviousMenu
        repeat_menu (str): repeatMenu *Optional*
    """

    __slots__: List[str] = [
        "play_messages",
        "change_busy_greeting",
        "change_no_answer_greeting",
        "change_extended_away_greeting",
        "compose_message",
        "delete_all_messages",
        "passcode",
        "personalized_name",
        "message_deposit",
        "return_to_previous_menu",
        "repeat_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "play_messages",
                "playMessages",
                str,
            ),
            E(
                "change_busy_greeting",
                "changeBusyGreeting",
                str,
            ),
            E(
                "change_no_answer_greeting",
                "changeNoAnswerGreeting",
                str,
            ),
            E(
                "change_extended_away_greeting",
                "changeExtendedAwayGreeting",
                str,
            ),
            E(
                "compose_message",
                "composeMessage",
                str,
            ),
            E(
                "delete_all_messages",
                "deleteAllMessages",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "personalized_name",
                "personalizedName",
                str,
            ),
            E(
                "message_deposit",
                "messageDeposit",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
        )


class VoicePortalCallingMenuKeysModifyEntry(OCIType):
    """
    The voice portal calling menu keys modify entry.


    Attributes:
        end_current_call_and_go_back_to_previous_menu (str):
            endCurrentCallAndGoBackToPreviousMenu *Optional*
        return_to_previous_menu (str): returnToPreviousMenu *Optional*
    """

    __slots__: List[str] = [
        "end_current_call_and_go_back_to_previous_menu",
        "return_to_previous_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "end_current_call_and_go_back_to_previous_menu",
                "endCurrentCallAndGoBackToPreviousMenu",
                str,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
            ),
        )


class VoicePortalCallingMenuKeysReadEntry(OCIType):
    """
    The voice portal change calling menu keys.


    Attributes:
        end_current_call_and_go_back_to_previous_menu (str):
            endCurrentCallAndGoBackToPreviousMenu
        return_to_previous_menu (str): returnToPreviousMenu
    """

    __slots__: List[str] = [
        "end_current_call_and_go_back_to_previous_menu",
        "return_to_previous_menu",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "end_current_call_and_go_back_to_previous_menu",
                "endCurrentCallAndGoBackToPreviousMenu",
                str,
                is_required=True,
            ),
            E(
                "return_to_previous_menu",
                "returnToPreviousMenu",
                str,
                is_required=True,
            ),
        )


class VoicePortalLoginMenuKeysModifyEntry(OCIType):
    """
    The voice portal voice portal login menu keys modify entry.


    Attributes:
        access_using_other_mailbox_id (str): accessUsingOtherMailboxId *Optional*
    """

    __slots__: List[str] = [
        "access_using_other_mailbox_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_using_other_mailbox_id",
                "accessUsingOtherMailboxId",
                str,
            ),
        )


class VoicePortalLoginMenuKeysReadEntry(OCIType):
    """
    The voice portal login menu keys.


    Attributes:
        access_using_other_mailbox_id (str): accessUsingOtherMailboxId *Optional*
    """

    __slots__: List[str] = [
        "access_using_other_mailbox_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_using_other_mailbox_id",
                "accessUsingOtherMailboxId",
                str,
            ),
        )


class VoicePortalMainMenuKeysModifyEntry(OCIType):
    """
    The voice portal main menu keys modify entry.


    Attributes:
        voice_messaging (str): voiceMessaging *Optional*
        comm_pilot_express_profile (str): commPilotExpressProfile *Optional*
        greetings (str): greetings *Optional*
        call_forwarding_options (str): callForwardingOptions *Optional*
        voice_portal_calling (str): voicePortalCalling *Optional*
        hoteling (str): hoteling *Optional*
        passcode (str): passcode *Optional*
        exit_voice_portal (str): exitVoicePortal *Optional*
        repeat_menu (str): repeatMenu *Optional*
        external_routing (str): externalRouting *Optional*
        announcement (str): announcement *Optional*
        personal_assistant (str): personalAssistant *Optional*
    """

    __slots__: List[str] = [
        "voice_messaging",
        "comm_pilot_express_profile",
        "greetings",
        "call_forwarding_options",
        "voice_portal_calling",
        "hoteling",
        "passcode",
        "exit_voice_portal",
        "repeat_menu",
        "external_routing",
        "announcement",
        "personal_assistant",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "voice_messaging",
                "voiceMessaging",
                str,
            ),
            E(
                "comm_pilot_express_profile",
                "commPilotExpressProfile",
                str,
            ),
            E(
                "greetings",
                "greetings",
                str,
            ),
            E(
                "call_forwarding_options",
                "callForwardingOptions",
                str,
            ),
            E(
                "voice_portal_calling",
                "voicePortalCalling",
                str,
            ),
            E(
                "hoteling",
                "hoteling",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "exit_voice_portal",
                "exitVoicePortal",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
            E(
                "external_routing",
                "externalRouting",
                str,
            ),
            E(
                "announcement",
                "announcement",
                str,
            ),
            E(
                "personal_assistant",
                "personalAssistant",
                str,
            ),
        )


class VoicePortalMainMenuKeysReadEntry(OCIType):
    """
    The voice portal main menu keys.


    Attributes:
        voice_messaging (str): voiceMessaging *Optional*
        comm_pilot_express_profile (str): commPilotExpressProfile *Optional*
        greetings (str): greetings *Optional*
        call_forwarding_options (str): callForwardingOptions *Optional*
        voice_portal_calling (str): voicePortalCalling *Optional*
        hoteling (str): hoteling *Optional*
        passcode (str): passcode *Optional*
        exit_voice_portal (str): exitVoicePortal *Optional*
        repeat_menu (str): repeatMenu *Optional*
        external_routing (str): externalRouting *Optional*
        announcement (str): announcement *Optional*
        personal_assistant (str): personalAssistant *Optional*
    """

    __slots__: List[str] = [
        "voice_messaging",
        "comm_pilot_express_profile",
        "greetings",
        "call_forwarding_options",
        "voice_portal_calling",
        "hoteling",
        "passcode",
        "exit_voice_portal",
        "repeat_menu",
        "external_routing",
        "announcement",
        "personal_assistant",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "voice_messaging",
                "voiceMessaging",
                str,
            ),
            E(
                "comm_pilot_express_profile",
                "commPilotExpressProfile",
                str,
            ),
            E(
                "greetings",
                "greetings",
                str,
            ),
            E(
                "call_forwarding_options",
                "callForwardingOptions",
                str,
            ),
            E(
                "voice_portal_calling",
                "voicePortalCalling",
                str,
            ),
            E(
                "hoteling",
                "hoteling",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "exit_voice_portal",
                "exitVoicePortal",
                str,
            ),
            E(
                "repeat_menu",
                "repeatMenu",
                str,
            ),
            E(
                "external_routing",
                "externalRouting",
                str,
            ),
            E(
                "announcement",
                "announcement",
                str,
            ),
            E(
                "personal_assistant",
                "personalAssistant",
                str,
            ),
        )


class XsiApplicationIdEntry(OCIType):
    """
    The system application Id entry.


    Attributes:
        xsi_application_id (str): xsiApplicationId
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "xsi_application_id",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "xsi_application_id",
                "xsiApplicationId",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class XsiPolicyProfileAssignEntry(OCIType):
    """
    The Xsi policy profile assign entry contains multiple Xsi policy profile and one
    default xsi policy profile.


    Attributes:
        name (List[str]): name *Optional*
        default (str): default *Optional*
    """

    __slots__: List[str] = [
        "name",
        "default",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
            E(
                "default",
                "default",
                str,
            ),
        )


class XsiPolicyProfileKey(OCIType):
    """
    The system Xsi policy profile key.


    Attributes:
        name (str): name
        level (str): level
    """

    __slots__: List[str] = [
        "name",
        "level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "level",
                "level",
                str,
                is_required=True,
            ),
        )


class XsiPolicyProfileUnassignEntry(OCIType):
    """
    The Xsi policy profile unassign entry contains mutiltipe Xsi policy profile and a new
    replacement default xsi policy profile.


    Attributes:
        name (List[str]): name *Optional*
        new_default (str): newDefault *Optional*
    """

    __slots__: List[str] = [
        "name",
        "new_default",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
            E(
                "new_default",
                "newDefault",
                str,
            ),
        )


class AccessDeviceEndpointAdd(OCIType):
    """
    Access device end point used in the context of add.

    Port numbers are only used by devices with static line ordering.  The following
    element is only used in AS data mode and ignored in XS data mode: pathHeader

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (str): contact *Optional*
        path_header (str): pathHeader *Optional*
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "path_header",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "path_header",
                "pathHeader",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceEndpointAndHotlineAdd(OCIType):
    """
    Access device end point used in the context of add.

    Port numbers are only used by devices with static line ordering.  The following
    element is only used in AS data mode and ignored in XS data mode: pathHeader
    useHotline, use value false in XS data mode hotlineContact The following element is
    only used in XS data mode and ignored in AS data mode: privateIdentity

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (str): contact *Optional*
        path_header (str): pathHeader *Optional*
        port_number (int): portNumber *Optional*
        use_hotline (bool): useHotline
        hotline_contact (str): hotlineContact *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "path_header",
        "port_number",
        "use_hotline",
        "hotline_contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "path_header",
                "pathHeader",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "use_hotline",
                "useHotline",
                bool,
                is_required=True,
            ),
            E(
                "hotline_contact",
                "hotlineContact",
                str,
            ),
        )


class AccessDeviceEndpointAndHotlineModify(OCIType):
    """
    Access device end point used in the context of modify.

    Port numbers are only used by devices with static line ordering.  The following
    element is only used in AS data mode and ignored in XS data mode: pathHeader
    useHotline hotlineContact

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (str): contact *Optional*
        path_header (str): pathHeader *Optional*
        port_number (int): portNumber *Optional*
        use_hotline (bool): useHotline *Optional*
        hotline_contact (str): hotlineContact *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "path_header",
        "port_number",
        "use_hotline",
        "hotline_contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "path_header",
                "pathHeader",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "use_hotline",
                "useHotline",
                bool,
            ),
            E(
                "hotline_contact",
                "hotlineContact",
                str,
            ),
        )


class AccessDeviceEndpointKey(OCIType):
    """
    Access device end point in the context of a modify or delete command.


    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
        )


class AccessDeviceEndpointModify(OCIType):
    """
    Access device end point used in the context of modify.

    Port numbers are only used by devices with static line ordering.  The following
    element is only used in AS data mode and ignored in XS data mode: pathHeader

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (str): contact *Optional*
        path_header (str): pathHeader *Optional*
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "path_header",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "path_header",
                "pathHeader",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceEndpointRead14(OCIType):
    """
    Access device end point.


    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (str): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "static_registration_capable",
        "use_domain",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
        )


class AccessDeviceEndpointWithPortNumberRead(OCIType):
    """
    Access device end point.

    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (str): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "static_registration_capable",
        "use_domain",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceEndpointWithPortNumberRead22(OCIType):
    """
    Access device end point.

    Port numbers are only used by devices with static line ordering.  The following
    element is only used in AS data mode and ignored in XS data mode: pathHeader

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (str): contact *Optional*
        path_header (str): pathHeader *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "path_header",
        "static_registration_capable",
        "use_domain",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "path_header",
                "pathHeader",
                str,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceEndpointWithPortNumberRead22V2(OCIType):
    """
    Access device end point.

    Port numbers are only used by devices with static line ordering.  The following
    element is only used in AS data mode and ignored in XS data mode: pathHeader
    hotlineContact The following elements are only used in AS data mode and a value false
    is returned in the XS mode: useHotline

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (str): contact *Optional*
        path_header (str): pathHeader *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        port_number (int): portNumber *Optional*
        use_hotline (bool): useHotline
        hotline_contact (str): hotlineContact *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "path_header",
        "static_registration_capable",
        "use_domain",
        "port_number",
        "use_hotline",
        "hotline_contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "path_header",
                "pathHeader",
                str,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "use_hotline",
                "useHotline",
                bool,
                is_required=True,
            ),
            E(
                "hotline_contact",
                "hotlineContact",
                str,
            ),
        )


class AccessDeviceMultipleContactEndpointAdd(OCIType):
    """
    Access device end point used in the context of add that can have more than one contact
    defined.

    Only Static Registration capabable devices may have more than one contact defined.
    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (List[str]): contact *Optional*
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceMultipleContactEndpointAdd22(OCIType):
    """
    Access device end point used in the context of add that can have more than one contact
    defined.

    Only Static Registration capabable devices may have more than one contact defined.
    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (List[contact]): contact *Optional*
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                SIPContactInfo,
                is_complex=True,
                is_array=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceMultipleContactEndpointModify(OCIType):
    """
    Access device end point used in the context of modify that can have more than one
    contact defined.

    Only Static Registration capable devices may have more than one contact defined.  Port
    numbers are only used by devices with static line ordering.

    Attributes:
        access_device (accessDevice): accessDevice *Optional*
        line_port (str): linePort *Optional*
        contact_list (contactList): contactList *Optional*
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact_list",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "contact_list",
                "contactList",
                ReplacementContactList,
                is_complex=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceMultipleContactEndpointRead(OCIType):
    """
    Access device end point that can have multiple contacts.

    Replaced by AccessDeviceMultipleContactEndpointRead19.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (List[str]): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "static_registration_capable",
        "use_domain",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
        )


class AccessDeviceMultipleContactEndpointRead19(OCIType):
    """
    Access device end point that can have multiple contacts.

    Port numbers are only used by devices with static line ordering.  Replaced by
    AccessDeviceMultipleContactEndpointRead20.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (List[str]): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "static_registration_capable",
        "use_domain",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceMultipleContactEndpointRead20(OCIType):
    """
    Access device end point that can have multiple contacts.

    Port numbers are only used by devices with static line ordering.  Replaced by
    AccessDeviceMultipleContactEndpointRead22.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (List[str]): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        port_number (int): portNumber *Optional*
        support_visual_device_management (bool): supportVisualDeviceManagement
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "static_registration_capable",
        "use_domain",
        "port_number",
        "support_visual_device_management",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "support_visual_device_management",
                "supportVisualDeviceManagement",
                bool,
                is_required=True,
            ),
        )


class AccessDeviceMultipleContactEndpointRead22(OCIType):
    """
    Access device end point that can have multiple contacts.

    Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        contact (List[contact]): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        port_number (int): portNumber *Optional*
        support_visual_device_management (bool): supportVisualDeviceManagement
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "contact",
        "static_registration_capable",
        "use_domain",
        "port_number",
        "support_visual_device_management",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "contact",
                "contact",
                SIPContactInfo,
                is_complex=True,
                is_array=True,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "support_visual_device_management",
                "supportVisualDeviceManagement",
                bool,
                is_required=True,
            ),
        )


class AccessDeviceMultipleIdentityAndContactEndpointAdd(OCIType):
    """
    Access device end point used in the context of add that can have more than one contact
    defined.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Only Static Registration capabable devices may have more than one contact
    defined.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    privateIdentity

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (List[str]): contact *Optional*
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceMultipleIdentityAndContactEndpointAdd22(OCIType):
    """
    Access device end point used in the context of add that can have more than one contact
    defined.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Only Static Registration capabable devices may have more than one contact
    defined.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    privateIdentity

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (List[contact]): contact *Optional*
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                SIPContactInfo,
                is_complex=True,
                is_array=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceMultipleIdentityAndContactEndpointAdd22V2(OCIType):
    """
    Access device end point used in the context of add that can have more than one contact
    defined.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Only Static Registration capabable devices may have more than one contact
    defined.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    privateIdentity The following elements are only used in AS data mode and ignored in XS
    data mode: useHotline, use value false in XS data mode hotlineContact

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (List[contact]): contact *Optional*
        port_number (int): portNumber *Optional*
        use_hotline (bool): useHotline
        hotline_contact (str): hotlineContact *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
        "use_hotline",
        "hotline_contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                SIPContactInfo,
                is_complex=True,
                is_array=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "use_hotline",
                "useHotline",
                bool,
                is_required=True,
            ),
            E(
                "hotline_contact",
                "hotlineContact",
                str,
            ),
        )


class AccessDeviceMultipleIdentityAndContactEndpointModify(OCIType):
    """
    Access device end point used in the context of modify that can have more than one
    contact defined.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Only Static Registration capabable devices may have more than one contact
    defined.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    privateIdentity

    Attributes:
        access_device (accessDevice): accessDevice *Optional*
        line_port (str): linePort *Optional*
        private_identity (str): privateIdentity *Optional*
        contact_list (contactList): contactList *Optional*
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact_list",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact_list",
                "contactList",
                ReplacementContactList,
                is_complex=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceMultipleIdentityAndContactEndpointRead(OCIType):
    """
    Access device end point that can have multiple contacts.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in XS data mode and not returned in AS data mode:
    privateIdentity The following elements are only used in AS data mode and a value false
    is returned in the XS mode: supportVisualDeviceManagement

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (List[str]): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        port_number (int): portNumber *Optional*
        support_visual_device_management (bool): supportVisualDeviceManagement
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "static_registration_capable",
        "use_domain",
        "port_number",
        "support_visual_device_management",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "support_visual_device_management",
                "supportVisualDeviceManagement",
                bool,
                is_required=True,
            ),
        )


class AccessDeviceMultipleIdentityAndContactEndpointRead22(OCIType):
    """
    Access device end point that can have multiple contacts.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in XS data mode and not returned in AS data mode:
    privateIdentity The following elements are only used in AS data mode and a value false
    is returned in the XS mode: supportVisualDeviceManagement

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (List[contact]): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        port_number (int): portNumber *Optional*
        support_visual_device_management (bool): supportVisualDeviceManagement
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "static_registration_capable",
        "use_domain",
        "port_number",
        "support_visual_device_management",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                SIPContactInfo,
                is_complex=True,
                is_array=True,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "support_visual_device_management",
                "supportVisualDeviceManagement",
                bool,
                is_required=True,
            ),
        )


class AccessDeviceMultipleIdentityAndContactEndpointRead22V2(OCIType):
    """
    Access device end point that can have multiple contacts.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in XS data mode and not returned in AS data mode:
    privateIdentity The following elements are only used in AS data mode and a value false
    is returned in the XS mode: supportVisualDeviceManagement useHotline The following
    elements are only used in AS data mode and not returned in XS data mode:
    hotlineContact

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (List[contact]): contact *Optional*
        static_registration_capable (bool): staticRegistrationCapable
        use_domain (bool): useDomain
        port_number (int): portNumber *Optional*
        support_visual_device_management (bool): supportVisualDeviceManagement
        use_hotline (bool): useHotline
        hotline_contact (str): hotlineContact *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "static_registration_capable",
        "use_domain",
        "port_number",
        "support_visual_device_management",
        "use_hotline",
        "hotline_contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                SIPContactInfo,
                is_complex=True,
                is_array=True,
            ),
            E(
                "static_registration_capable",
                "staticRegistrationCapable",
                bool,
                is_required=True,
            ),
            E(
                "use_domain",
                "useDomain",
                bool,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "support_visual_device_management",
                "supportVisualDeviceManagement",
                bool,
                is_required=True,
            ),
            E(
                "use_hotline",
                "useHotline",
                bool,
                is_required=True,
            ),
            E(
                "hotline_contact",
                "hotlineContact",
                str,
            ),
        )


class AccessDeviceMultipleIdentityEndpointAdd(OCIType):
    """
    Access device end point used in the context of add.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    privateIdentity

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (str): contact *Optional*
        port_number (int): portNumber *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
        )


class AccessDeviceMultipleIdentityEndpointKey(OCIType):
    """
    Access device end point in the context of a modify or delete command.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  The following elements are only used in XS data mode and ignored in AS data
    mode: privateIdentity

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
        )


class AccessDeviceMultipleIdentityEndpointWithType(OCIType):
    """
    Access device end point that can have multiple contacts.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.

    Attributes:
        access_device (accessDevice): accessDevice
        device_type (str): deviceType
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (str): contact *Optional*
        port_number (int): portNumber *Optional*
        mac_address (str): macAddress *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "device_type",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
        "mac_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
        )


class AutoAttendantKeyConfigurationEntry(OCIType):
    """
    The configuration entry of a key for Auto Attendant.

    The following elements are only used in AS data mode: audioFile videoFile

    Attributes:
        description (str): description *Optional*
        action (str): action
        phone_number (str): phoneNumber *Optional*
        audio_file (audioFile): audioFile *Optional*
        video_file (videoFile): videoFile *Optional*
    """

    __slots__: List[str] = [
        "description",
        "action",
        "phone_number",
        "audio_file",
        "video_file",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "audio_file",
                "audioFile",
                LabeledMediaFileResource,
                is_complex=True,
            ),
            E(
                "video_file",
                "videoFile",
                LabeledMediaFileResource,
                is_complex=True,
            ),
        )


class AutoAttendantKeyConfigurationEntry19(OCIType):
    """
    The configuration entry of a key for Auto Attendant.

    The following data elements are only valid for Standard Auto Attendants: submenuId

    Attributes:
        description (str): description *Optional*
        action (str): action
        phone_number (str): phoneNumber *Optional*
        audio_file (audioFile): audioFile *Optional*
        video_file (videoFile): videoFile *Optional*
        submenu_id (str): submenuId *Optional*
    """

    __slots__: List[str] = [
        "description",
        "action",
        "phone_number",
        "audio_file",
        "video_file",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "audio_file",
                "audioFile",
                LabeledMediaFileResource,
                is_complex=True,
            ),
            E(
                "video_file",
                "videoFile",
                LabeledMediaFileResource,
                is_complex=True,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
            ),
        )


class AutoAttendantKeyConfigurationEntry20(OCIType):
    """
    The configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId

    Attributes:
        description (str): description *Optional*
        action (str): action
        phone_number (str): phoneNumber *Optional*
        audio_file (audioFile): audioFile *Optional*
        video_file (videoFile): videoFile *Optional*
        submenu_id (str): submenuId *Optional*
    """

    __slots__: List[str] = [
        "description",
        "action",
        "phone_number",
        "audio_file",
        "video_file",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "audio_file",
                "audioFile",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "video_file",
                "videoFile",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
            ),
        )


class AutoAttendantKeyConfigurationModifyEntry(OCIType):
    """
    The modify configuration entry of a key for Auto Attendant.

    The following data elements are only valid for Standard Auto Attendants: submenuId

    Attributes:
        description (str): description *Optional*
        action (str): action
        phone_number (str): phoneNumber *Optional*
        audio_file (audioFile): audioFile *Optional*
        video_file (videoFile): videoFile *Optional*
        submenu_id (str): submenuId *Optional*
    """

    __slots__: List[str] = [
        "description",
        "action",
        "phone_number",
        "audio_file",
        "video_file",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "audio_file",
                "audioFile",
                LabeledMediaFileResource,
                is_complex=True,
            ),
            E(
                "video_file",
                "videoFile",
                LabeledMediaFileResource,
                is_complex=True,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
            ),
        )


class AutoAttendantKeyConfigurationModifyEntry20(OCIType):
    """
    The modify configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: audioFile videoFile
    submenuId The following data elements are only valid for Standard Auto Attendants:
    submenuId

    Attributes:
        description (str): description *Optional*
        action (str): action
        phone_number (str): phoneNumber *Optional*
        audio_file (audioFile): audioFile *Optional*
        video_file (videoFile): videoFile *Optional*
        submenu_id (str): submenuId *Optional*
    """

    __slots__: List[str] = [
        "description",
        "action",
        "phone_number",
        "audio_file",
        "video_file",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "audio_file",
                "audioFile",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "video_file",
                "videoFile",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
            ),
        )


class AutoAttendantKeyConfigurationReadEntry20(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.

    The following data elements are only used in AS data mode: submenuId The following
    data elements are only valid for Standard Auto Attendants: submenuId

    Attributes:
        description (str): description *Optional*
        action (str): action
        phone_number (str): phoneNumber *Optional*
        audio_file (audioFile): audioFile *Optional*
        video_file (videoFile): videoFile *Optional*
        submenu_id (str): submenuId *Optional*
    """

    __slots__: List[str] = [
        "description",
        "action",
        "phone_number",
        "audio_file",
        "video_file",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "audio_file",
                "audioFile",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "video_file",
                "videoFile",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
            ),
        )


class AutoAttendantKeyReadConfiguration(OCIType):
    """
    The read configuration of a key for Auto Attendant.


    Attributes:
        key (str): key
        entry (entry): entry
    """

    __slots__: List[str] = [
        "key",
        "entry",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "key",
                "key",
                str,
                is_required=True,
            ),
            E(
                "entry",
                "entry",
                AutoAttendantKeyConfigurationReadEntry,
                is_complex=True,
                is_required=True,
            ),
        )


class AutoAttendantKeyReadConfiguration19(OCIType):
    """
    The read configuration of a key for Auto Attendant.


    Attributes:
        key (str): key
        entry (entry): entry
    """

    __slots__: List[str] = [
        "key",
        "entry",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "key",
                "key",
                str,
                is_required=True,
            ),
            E(
                "entry",
                "entry",
                AutoAttendantKeyConfigurationReadEntry19,
                is_complex=True,
                is_required=True,
            ),
        )


class AutoAttendantModifyMenuExecutionServer(OCIType):
    """
    The configuration of an auto attendant menu greeting prompt.

    Engineering Note: This command can only be executed from the Execution Server

    Attributes:
        announcement_selection (str): announcementSelection *Optional*
        audio_file (audioFile): audioFile *Optional*
        video_file (videoFile): videoFile *Optional*
    """

    __slots__: List[str] = [
        "announcement_selection",
        "audio_file",
        "video_file",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "announcement_selection",
                "announcementSelection",
                str,
            ),
            E(
                "audio_file",
                "audioFile",
                LabeledFileNameResource,
                is_complex=True,
            ),
            E(
                "video_file",
                "videoFile",
                LabeledFileNameResource,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        reset_event (str): resetEvent *Optional*
        config_type (str): configType
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "reset_event",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "reset_event",
                "resetEvent",
                str,
            ),
            E(
                "config_type",
                "configType",
                str,
                is_required=True,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead16(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        reset_event (str): resetEvent *Optional*
        config_type (str): configType
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "reset_event",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "reset_event",
                "resetEvent",
                str,
            ),
            E(
                "config_type",
                "configType",
                str,
                is_required=True,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead16,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead16sp1(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        config_type (str): configType *Optional*
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "config_type",
                "configType",
                str,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead16,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead21sp1(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        config_type (str): configType *Optional*
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "config_type",
                "configType",
                str,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead21sp1,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead22(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        config_type (str): configType *Optional*
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "config_type",
                "configType",
                str,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead22,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead22V2(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        config_type (str): configType *Optional*
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "config_type",
                "configType",
                str,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead22V2,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead22V3(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        config_type (str): configType *Optional*
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "config_type",
                "configType",
                str,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead22V3,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead22V4(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        config_type (str): configType *Optional*
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "config_type",
                "configType",
                str,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead22V4,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead22V5(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        config_type (str): configType *Optional*
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "config_type",
                "configType",
                str,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead22V5,
                is_complex=True,
            ),
        )


class CPEDeviceOptionsRead22V6(OCIType):
    """
    CPE device's options.


    Attributes:
        enable_monitoring (bool): enableMonitoring
        config_type (str): configType *Optional*
        system_file_name (str): systemFileName *Optional*
        device_file_format (str): deviceFileFormat *Optional*
        device_management_device_type_options (deviceManagementDeviceTypeOptions):
            deviceManagementDeviceTypeOptions *Optional*
    """

    __slots__: List[str] = [
        "enable_monitoring",
        "config_type",
        "system_file_name",
        "device_file_format",
        "device_management_device_type_options",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_monitoring",
                "enableMonitoring",
                bool,
                is_required=True,
            ),
            E(
                "config_type",
                "configType",
                str,
            ),
            E(
                "system_file_name",
                "systemFileName",
                str,
            ),
            E(
                "device_file_format",
                "deviceFileFormat",
                str,
            ),
            E(
                "device_management_device_type_options",
                "deviceManagementDeviceTypeOptions",
                DeviceManagementDeviceTypeOptionsRead22V6,
                is_complex=True,
            ),
        )


class CallCenterAgentStatistics13mp8(OCIType):
    """
    Contains Call Center statistics for a specified agent.


    Attributes:
        agent_user_id (str): agentUserId
        agent_display_names (agentDisplayNames): agentDisplayNames
        available (bool): available
        statistics_yesterday (statisticsYesterday): statisticsYesterday
        statistics_today (statisticsToday): statisticsToday
    """

    __slots__: List[str] = [
        "agent_user_id",
        "agent_display_names",
        "available",
        "statistics_yesterday",
        "statistics_today",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_required=True,
            ),
            E(
                "agent_display_names",
                "agentDisplayNames",
                UserDisplayNames,
                is_complex=True,
                is_required=True,
            ),
            E(
                "available",
                "available",
                bool,
                is_required=True,
            ),
            E(
                "statistics_yesterday",
                "statisticsYesterday",
                CallCenterAgentDailyStatistics13mp8,
                is_complex=True,
                is_required=True,
            ),
            E(
                "statistics_today",
                "statisticsToday",
                CallCenterAgentDailyStatistics13mp8,
                is_complex=True,
                is_required=True,
            ),
        )


class CallCenterAgentStatistics14sp9(OCIType):
    """
    Contains Call Center statistics for a specified agent.


    Attributes:
        agent_user_id (str): agentUserId
        agent_display_names (agentDisplayNames): agentDisplayNames
        available (bool): available
        statistics (statistics): statistics
    """

    __slots__: List[str] = [
        "agent_user_id",
        "agent_display_names",
        "available",
        "statistics",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_required=True,
            ),
            E(
                "agent_display_names",
                "agentDisplayNames",
                UserDisplayNames,
                is_complex=True,
                is_required=True,
            ),
            E(
                "available",
                "available",
                bool,
                is_required=True,
            ),
            E(
                "statistics",
                "statistics",
                AgentStatistics,
                is_complex=True,
                is_required=True,
            ),
        )


class CallCenterAnnouncementFileListModify(OCIType):
    """
    Contains a list of audio or video files to modify.


    Attributes:
        file1 (file1): file1 *Optional*
        file2 (file2): file2 *Optional*
        file3 (file3): file3 *Optional*
        file4 (file4): file4 *Optional*
    """

    __slots__: List[str] = [
        "file1",
        "file2",
        "file3",
        "file4",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file1",
                "file1",
                LabeledMediaFileResource,
                is_complex=True,
            ),
            E(
                "file2",
                "file2",
                LabeledMediaFileResource,
                is_complex=True,
            ),
            E(
                "file3",
                "file3",
                LabeledMediaFileResource,
                is_complex=True,
            ),
            E(
                "file4",
                "file4",
                LabeledMediaFileResource,
                is_complex=True,
            ),
        )


class CallCenterAnnouncementFileListModify20(OCIType):
    """
    Contains a list of announcement repository files

    Attributes:
        file1 (file1): file1 *Optional*
        file2 (file2): file2 *Optional*
        file3 (file3): file3 *Optional*
        file4 (file4): file4 *Optional*
    """

    __slots__: List[str] = [
        "file1",
        "file2",
        "file3",
        "file4",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file1",
                "file1",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "file2",
                "file2",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "file3",
                "file3",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "file4",
                "file4",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
        )


class CallCenterAnnouncementFileListRead20(OCIType):
    """
    Contains a list of announcement repository files

    Attributes:
        file1 (file1): file1 *Optional*
        file2 (file2): file2 *Optional*
        file3 (file3): file3 *Optional*
        file4 (file4): file4 *Optional*
    """

    __slots__: List[str] = [
        "file1",
        "file2",
        "file3",
        "file4",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file1",
                "file1",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "file2",
                "file2",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "file3",
                "file3",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
            E(
                "file4",
                "file4",
                AnnouncementFileLevelKey,
                is_complex=True,
            ),
        )


class CallCenterReplacementSkilledAgents(OCIType):
    """
    A list of agents grouped by skill levels.


    Attributes:
        skill_level (int): skillLevel
        agents (agents): agents
    """

    __slots__: List[str] = [
        "skill_level",
        "agents",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "skill_level",
                "skillLevel",
                int,
                is_required=True,
            ),
            E(
                "agents",
                "agents",
                ReplacementUserIdList,
                is_complex=True,
                is_required=True,
            ),
        )


class CallCenterReportIntervalDates(OCIType):
    """
    The call center enhanced reporting report interval, using dates.


    Attributes:
        start_date (str): startDate
        start_time (startTime): startTime
        end_date (str): endDate
        end_time (endTime): endTime
    """

    __slots__: List[str] = [
        "start_date",
        "start_time",
        "end_date",
        "end_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "start_date",
                "startDate",
                str,
                is_required=True,
            ),
            E(
                "start_time",
                "startTime",
                HourMinute,
                is_complex=True,
                is_required=True,
            ),
            E(
                "end_date",
                "endDate",
                str,
                is_required=True,
            ),
            E(
                "end_time",
                "endTime",
                HourMinute,
                is_complex=True,
                is_required=True,
            ),
        )


class CallCenterReportScheduleRecurrence(OCIType):
    """
    A recurring schedule for call center enhanced reporting scheduled report.


    Attributes:
        time_zone (str): timeZone
        start_date (str): startDate
        schedule_time (scheduleTime): scheduleTime
        recurrence (recurrence): recurrence
    """

    __slots__: List[str] = [
        "time_zone",
        "start_date",
        "schedule_time",
        "recurrence",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "time_zone",
                "timeZone",
                str,
                is_required=True,
            ),
            E(
                "start_date",
                "startDate",
                str,
                is_required=True,
            ),
            E(
                "schedule_time",
                "scheduleTime",
                HourMinute,
                is_complex=True,
                is_required=True,
            ),
            E(
                "recurrence",
                "recurrence",
                Recurrence,
                is_complex=True,
                is_required=True,
            ),
        )


class CallCenterReportScheduleTime(OCIType):
    """
    A scheduled time for call center enhanced reporting scheduled report.


    Attributes:
        time_zone (str): timeZone
        schedule_date (str): scheduleDate
        schedule_time (scheduleTime): scheduleTime
    """

    __slots__: List[str] = [
        "time_zone",
        "schedule_date",
        "schedule_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "time_zone",
                "timeZone",
                str,
                is_required=True,
            ),
            E(
                "schedule_date",
                "scheduleDate",
                str,
                is_required=True,
            ),
            E(
                "schedule_time",
                "scheduleTime",
                HourMinute,
                is_complex=True,
                is_required=True,
            ),
        )


class CallMeNowToDnCriteriaModify(OCIType):
    """
    The To dn criteria used on the call me now external number to be modified.


    Attributes:
        to_dn_criteria_selection (str): toDnCriteriaSelection *Optional*
        phone_number_list (phoneNumberList): phoneNumberList *Optional*
    """

    __slots__: List[str] = [
        "to_dn_criteria_selection",
        "phone_number_list",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "to_dn_criteria_selection",
                "toDnCriteriaSelection",
                str,
            ),
            E(
                "phone_number_list",
                "phoneNumberList",
                CriteriaReplacementDNList,
                is_complex=True,
            ),
        )


class CombinedAccessDeviceMultipleIdentityEndpointAdd(OCIType):
    """
    Access device end point used in the context of add.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Only Static Registration capable devices may have more than one contact
    defined.  Port numbers are only used by devices with static line ordering.  In the
    case an access device referenced by accessDevice does not exist, the device will be
    added.  The device attributes deviceType, protocol, netAddress, port,
    outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
    description, physicalLocation, transportProtocol, useCustomUserNamePassword and
    accessDeviceCredentials will be ignored if the access device already exists.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (str): contact *Optional*
        port_number (int): portNumber *Optional*
        device_type (str): deviceType *Optional*
        protocol (str): protocol *Optional*
        net_address (str): netAddress *Optional*
        port (int): port *Optional*
        outbound_proxy_server_net_address (str): outboundProxyServerNetAddress *Optional*
        stun_server_net_address (str): stunServerNetAddress *Optional*
        mac_address (str): macAddress *Optional*
        serial_number (str): serialNumber *Optional*
        description (str): description *Optional*
        physical_location (str): physicalLocation *Optional*
        transport_protocol (str): transportProtocol *Optional*
        use_custom_user_name_password (bool): useCustomUserNamePassword *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
        "device_type",
        "protocol",
        "net_address",
        "port",
        "outbound_proxy_server_net_address",
        "stun_server_net_address",
        "mac_address",
        "serial_number",
        "description",
        "physical_location",
        "transport_protocol",
        "use_custom_user_name_password",
        "access_device_credentials",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "device_type",
                "deviceType",
                str,
            ),
            E(
                "protocol",
                "protocol",
                str,
            ),
            E(
                "net_address",
                "netAddress",
                str,
            ),
            E(
                "port",
                "port",
                int,
            ),
            E(
                "outbound_proxy_server_net_address",
                "outboundProxyServerNetAddress",
                str,
            ),
            E(
                "stun_server_net_address",
                "stunServerNetAddress",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "serial_number",
                "serialNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "physical_location",
                "physicalLocation",
                str,
            ),
            E(
                "transport_protocol",
                "transportProtocol",
                str,
            ),
            E(
                "use_custom_user_name_password",
                "useCustomUserNamePassword",
                bool,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
        )


class CombinedAccessDeviceMultipleIdentityEndpointModify(OCIType):
    """
    Access device end point used in the context of modify.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Only Static Registration capable devices may have more than one contact
    defined.  Port numbers are only used by devices with static line ordering.  In the
    case an access device referenced by accessDevice does not exist, the device will be
    added.  When the device needs to be added, if the linePort is not specified, the
    request will fail The device attributes deviceType, protocol, netAddress, port,
    outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
    description, physicalLocation, transportProtocol, useCustomUserNamePassword and
    accessDeviceCredentials will be ignored if the access device already exists.

    Attributes:
        access_device (accessDevice): accessDevice *Optional*
        line_port (str): linePort *Optional*
        private_identity (str): privateIdentity *Optional*
        contact (str): contact *Optional*
        port_number (int): portNumber *Optional*
        device_type (str): deviceType *Optional*
        protocol (str): protocol *Optional*
        net_address (str): netAddress *Optional*
        port (int): port *Optional*
        outbound_proxy_server_net_address (str): outboundProxyServerNetAddress *Optional*
        stun_server_net_address (str): stunServerNetAddress *Optional*
        mac_address (str): macAddress *Optional*
        serial_number (str): serialNumber *Optional*
        description (str): description *Optional*
        physical_location (str): physicalLocation *Optional*
        transport_protocol (str): transportProtocol *Optional*
        use_custom_user_name_password (bool): useCustomUserNamePassword *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
        "device_type",
        "protocol",
        "net_address",
        "port",
        "outbound_proxy_server_net_address",
        "stun_server_net_address",
        "mac_address",
        "serial_number",
        "description",
        "physical_location",
        "transport_protocol",
        "use_custom_user_name_password",
        "access_device_credentials",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "device_type",
                "deviceType",
                str,
            ),
            E(
                "protocol",
                "protocol",
                str,
            ),
            E(
                "net_address",
                "netAddress",
                str,
            ),
            E(
                "port",
                "port",
                int,
            ),
            E(
                "outbound_proxy_server_net_address",
                "outboundProxyServerNetAddress",
                str,
            ),
            E(
                "stun_server_net_address",
                "stunServerNetAddress",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "serial_number",
                "serialNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "physical_location",
                "physicalLocation",
                str,
            ),
            E(
                "transport_protocol",
                "transportProtocol",
                str,
            ),
            E(
                "use_custom_user_name_password",
                "useCustomUserNamePassword",
                bool,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
        )


class CombinedGroupServiceAuthorization(OCIType):
    """
    Authorize a group service.


    Attributes:
        service_name (str): serviceName
        authorized_quantity (authorizedQuantity): authorizedQuantity *Optional*
    """

    __slots__: List[str] = [
        "service_name",
        "authorized_quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_name",
                "serviceName",
                str,
                is_required=True,
            ),
            E(
                "authorized_quantity",
                "authorizedQuantity",
                UnboundedPositiveInt,
                is_complex=True,
            ),
        )


class CombinedServiceInstanceAddProfile(OCIType):
    """
    Service Profile Information for group service.

    When name, callingLineIdLastName and callingLineIdFirstName are not included, the
    values in the corresponding service instance template (if this is used to add a Hunt
    Group, for example, the name will come from the Hunt Group template) will be used.
    Otherwise, the request will fail.  If the phoneNumber has not been assigned to the
    group, it will be added to group and service provider if needed.

    Attributes:
        name (str): name *Optional*
        calling_line_id_last_name (str): callingLineIdLastName *Optional*
        calling_line_id_first_name (str): callingLineIdFirstName *Optional*
        hiragana_last_name (str): hiraganaLastName *Optional*
        hiragana_first_name (str): hiraganaFirstName *Optional*
        phone_number (str): phoneNumber *Optional*
        extension (str): extension *Optional*
        password (str): password *Optional*
        department (department): department *Optional*
        language (str): language *Optional*
        time_zone (str): timeZone *Optional*
        alias (List[str]): alias *Optional*
        public_user_identity (str): publicUserIdentity *Optional*
        calling_line_id_phone_number (str): callingLineIdPhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "name",
        "calling_line_id_last_name",
        "calling_line_id_first_name",
        "hiragana_last_name",
        "hiragana_first_name",
        "phone_number",
        "extension",
        "password",
        "department",
        "language",
        "time_zone",
        "alias",
        "public_user_identity",
        "calling_line_id_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
            ),
            E(
                "calling_line_id_last_name",
                "callingLineIdLastName",
                str,
            ),
            E(
                "calling_line_id_first_name",
                "callingLineIdFirstName",
                str,
            ),
            E(
                "hiragana_last_name",
                "hiraganaLastName",
                str,
            ),
            E(
                "hiragana_first_name",
                "hiraganaFirstName",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "extension",
                "extension",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "department",
                "department",
                DepartmentKey,
                is_complex=True,
                is_abstract=True,
            ),
            E(
                "language",
                "language",
                str,
            ),
            E(
                "time_zone",
                "timeZone",
                str,
            ),
            E(
                "alias",
                "alias",
                str,
                is_array=True,
            ),
            E(
                "public_user_identity",
                "publicUserIdentity",
                str,
            ),
            E(
                "calling_line_id_phone_number",
                "callingLineIdPhoneNumber",
                str,
            ),
        )


class CombinedServicePackAssignment(OCIType):
    """
    Assign a service pack to user.

    If the service pack has not been authorized to service provider or group, it will be
    authorized.  If the service pack needs to be authorized at group/service provider
    levels, the authorizedQuantity will be used.  Otherwise, it will be ignored.  If the
    authorizedQuantity is not included, the quantity will come from the group template for
    the service pack.  If a template does not exist, the service quantity will be set to
    unlimited.

    Attributes:
        service_pack_name (str): servicePackName
        authorized_quantity (authorizedQuantity): authorizedQuantity *Optional*
    """

    __slots__: List[str] = [
        "service_pack_name",
        "authorized_quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_required=True,
            ),
            E(
                "authorized_quantity",
                "authorizedQuantity",
                UnboundedPositiveInt,
                is_complex=True,
            ),
        )


class CombinedServicePackAuthorization(OCIType):
    """
    Authorize a service pack.


    Attributes:
        service_pack_name (str): servicePackName
        authorized_quantity (authorizedQuantity): authorizedQuantity *Optional*
    """

    __slots__: List[str] = [
        "service_pack_name",
        "authorized_quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_required=True,
            ),
            E(
                "authorized_quantity",
                "authorizedQuantity",
                UnboundedPositiveInt,
                is_complex=True,
            ),
        )


class CombinedSharedCallAppearanceAccessDeviceMultipleIdentityEndpoint(OCIType):
    """
    Access device end point for Shared Call Appearance Service used in the context of add.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.  In the
    case an access device referenced by accessDevice does not exist, the device will be
    added.  When elements for isActive, allowOrigination, allowTermination and allowVideo
    are not included in the request, the values for them will come for the Shared Call
    Appearance endpoints template.  If the template does not exist, the request using this
    data type will fail.  The device attributes deviceType, protocol, netAddress, port,
    outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
    description, physicalLocation, transportProtocol, useCustomUserNamePassword and
    accessDeviceCredentials will be ignored if the access device already exists.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (str): contact *Optional*
        port_number (int): portNumber *Optional*
        is_active (bool): isActive *Optional*
        allow_origination (bool): allowOrigination *Optional*
        allow_termination (bool): allowTermination *Optional*
        allow_video (bool): allowVideo *Optional*
        device_type (str): deviceType *Optional*
        protocol (str): protocol *Optional*
        net_address (str): netAddress *Optional*
        port (int): port *Optional*
        outbound_proxy_server_net_address (str): outboundProxyServerNetAddress *Optional*
        stun_server_net_address (str): stunServerNetAddress *Optional*
        mac_address (str): macAddress *Optional*
        serial_number (str): serialNumber *Optional*
        description (str): description *Optional*
        physical_location (str): physicalLocation *Optional*
        transport_protocol (str): transportProtocol *Optional*
        use_custom_user_name_password (bool): useCustomUserNamePassword *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
        "is_active",
        "allow_origination",
        "allow_termination",
        "allow_video",
        "device_type",
        "protocol",
        "net_address",
        "port",
        "outbound_proxy_server_net_address",
        "stun_server_net_address",
        "mac_address",
        "serial_number",
        "description",
        "physical_location",
        "transport_protocol",
        "use_custom_user_name_password",
        "access_device_credentials",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "allow_origination",
                "allowOrigination",
                bool,
            ),
            E(
                "allow_termination",
                "allowTermination",
                bool,
            ),
            E(
                "allow_video",
                "allowVideo",
                bool,
            ),
            E(
                "device_type",
                "deviceType",
                str,
            ),
            E(
                "protocol",
                "protocol",
                str,
            ),
            E(
                "net_address",
                "netAddress",
                str,
            ),
            E(
                "port",
                "port",
                int,
            ),
            E(
                "outbound_proxy_server_net_address",
                "outboundProxyServerNetAddress",
                str,
            ),
            E(
                "stun_server_net_address",
                "stunServerNetAddress",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "serial_number",
                "serialNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "physical_location",
                "physicalLocation",
                str,
            ),
            E(
                "transport_protocol",
                "transportProtocol",
                str,
            ),
            E(
                "use_custom_user_name_password",
                "useCustomUserNamePassword",
                bool,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
        )


class CombinedUserServiceAssignment(OCIType):
    """
    Assign a service user.

    If the service has not been authorized to service provider or group, it will be
    authorized.  If the service needs to be authorized at group/service provider levels,
    the authorizedQuantity will be used.  Otherwise, it will be ignored.  If the
    authorizedQuantity is not included, the quantity will come from the group template for
    the service.  If a template does not exist, the service quantity will be set to
    unlimited.

    Attributes:
        user_service (str): userService
        authorized_quantity (authorizedQuantity): authorizedQuantity *Optional*
    """

    __slots__: List[str] = [
        "user_service",
        "authorized_quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_service",
                "userService",
                str,
                is_required=True,
            ),
            E(
                "authorized_quantity",
                "authorizedQuantity",
                UnboundedPositiveInt,
                is_complex=True,
            ),
        )


class CombinedUserServiceAuthorization(OCIType):
    """
    Authorize a user service.


    Attributes:
        service_name (str): serviceName
        authorized_quantity (authorizedQuantity): authorizedQuantity *Optional*
    """

    __slots__: List[str] = [
        "service_name",
        "authorized_quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_name",
                "serviceName",
                str,
                is_required=True,
            ),
            E(
                "authorized_quantity",
                "authorizedQuantity",
                UnboundedPositiveInt,
                is_complex=True,
            ),
        )


class CommPilotExpressAvailableInOffice(OCIType):
    """
    CommPilot Express Available In Office Settings.


    Attributes:
        additional_phone_number_to_ring (str): additionalPhoneNumberToRing *Optional*
        busy_setting (busySetting): busySetting
        no_answer_setting (noAnswerSetting): noAnswerSetting
    """

    __slots__: List[str] = [
        "additional_phone_number_to_ring",
        "busy_setting",
        "no_answer_setting",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "additional_phone_number_to_ring",
                "additionalPhoneNumberToRing",
                str,
            ),
            E(
                "busy_setting",
                "busySetting",
                CommPilotExpressRedirection,
                is_complex=True,
                is_required=True,
            ),
            E(
                "no_answer_setting",
                "noAnswerSetting",
                CommPilotExpressRedirection,
                is_complex=True,
                is_required=True,
            ),
        )


class CommPilotExpressAvailableInOfficeModify(OCIType):
    """
    CommPilot Express Available In Office Settings.


    Attributes:
        additional_phone_number_to_ring (str): additionalPhoneNumberToRing *Optional*
        busy_setting (busySetting): busySetting *Optional*
        no_answer_setting (noAnswerSetting): noAnswerSetting *Optional*
    """

    __slots__: List[str] = [
        "additional_phone_number_to_ring",
        "busy_setting",
        "no_answer_setting",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "additional_phone_number_to_ring",
                "additionalPhoneNumberToRing",
                str,
            ),
            E(
                "busy_setting",
                "busySetting",
                CommPilotExpressRedirectionModify,
                is_complex=True,
            ),
            E(
                "no_answer_setting",
                "noAnswerSetting",
                CommPilotExpressRedirectionModify,
                is_complex=True,
            ),
        )


class CommPilotExpressAvailableOutOfOffice(OCIType):
    """
    CommPilot Express Available Out Of Office Configuration used in the context of a get.


    Attributes:
        incoming_calls (incomingCalls): incomingCalls
        incoming_call_notify (incomingCallNotify): incomingCallNotify
    """

    __slots__: List[str] = [
        "incoming_calls",
        "incoming_call_notify",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "incoming_calls",
                "incomingCalls",
                CommPilotExpressRedirection,
                is_complex=True,
                is_required=True,
            ),
            E(
                "incoming_call_notify",
                "incomingCallNotify",
                CommPilotExpressEmailNotify,
                is_complex=True,
                is_required=True,
            ),
        )


class CommPilotExpressAvailableOutOfOfficeModify(OCIType):
    """
    CommPilot Express Available Out Of Office Configuration used in the context of a
    modify.


    Attributes:
        incoming_calls (incomingCalls): incomingCalls *Optional*
        incoming_call_notify (incomingCallNotify): incomingCallNotify *Optional*
    """

    __slots__: List[str] = [
        "incoming_calls",
        "incoming_call_notify",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "incoming_calls",
                "incomingCalls",
                CommPilotExpressRedirectionModify,
                is_complex=True,
            ),
            E(
                "incoming_call_notify",
                "incomingCallNotify",
                CommPilotExpressEmailNotifyModify,
                is_complex=True,
            ),
        )


class CommPilotExpressBusy(OCIType):
    """
    CommPilot Express Available In Office Configuration used in the context of a get.


    Attributes:
        incoming_calls (incomingCalls): incomingCalls
        voice_mail_notify (voiceMailNotify): voiceMailNotify
    """

    __slots__: List[str] = [
        "incoming_calls",
        "voice_mail_notify",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "incoming_calls",
                "incomingCalls",
                CommPilotExpressRedirectionWithException,
                is_complex=True,
                is_required=True,
            ),
            E(
                "voice_mail_notify",
                "voiceMailNotify",
                CommPilotExpressEmailNotify,
                is_complex=True,
                is_required=True,
            ),
        )


class CommPilotExpressBusyModify(OCIType):
    """
    CommPilot Express Available In Office Configuration used in the context of a modify.


    Attributes:
        incoming_calls (incomingCalls): incomingCalls *Optional*
        voice_mail_notify (voiceMailNotify): voiceMailNotify *Optional*
    """

    __slots__: List[str] = [
        "incoming_calls",
        "voice_mail_notify",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "incoming_calls",
                "incomingCalls",
                CommPilotExpressRedirectionWithExceptionModify,
                is_complex=True,
            ),
            E(
                "voice_mail_notify",
                "voiceMailNotify",
                CommPilotExpressEmailNotifyModify,
                is_complex=True,
            ),
        )


class CommPilotExpressUnavailable(OCIType):
    """
    CommPilot Express Unavailable Configuration used in the context of a get.


    Attributes:
        incoming_calls (incomingCalls): incomingCalls
        voice_mail_greeting (str): voiceMailGreeting
    """

    __slots__: List[str] = [
        "incoming_calls",
        "voice_mail_greeting",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "incoming_calls",
                "incomingCalls",
                CommPilotExpressRedirectionWithException,
                is_complex=True,
                is_required=True,
            ),
            E(
                "voice_mail_greeting",
                "voiceMailGreeting",
                str,
                is_required=True,
            ),
        )


class CommPilotExpressUnavailableModify(OCIType):
    """
    CommPilot Express Unavailable Configuration used in the context of a modify.


    Attributes:
        incoming_calls (incomingCalls): incomingCalls *Optional*
        voice_mail_greeting (str): voiceMailGreeting *Optional*
    """

    __slots__: List[str] = [
        "incoming_calls",
        "voice_mail_greeting",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "incoming_calls",
                "incomingCalls",
                CommPilotExpressRedirectionWithExceptionModify,
                is_complex=True,
            ),
            E(
                "voice_mail_greeting",
                "voiceMailGreeting",
                str,
            ),
        )


class ConsolidatedAccessDeviceMultipleIdentityEndpointAndContactAdd(OCIType):
    """
    Access device end point used in the context of add.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  In XS data mode, only one contact can be defined.  Only Static Registration
    capable devices may have more than one contact defined.  Port numbers are only used by
    devices with static line ordering.  In the case an access device referenced by
    accessDevice does not exist, the device will be added.  The device attributes
    deviceType, protocol, netAddress, port, outboundProxyServerNetAddress,
    stunServerNetAddress, macAddress, serialNumber, description, physicalLocation,
    transportProtocol, useCustomUserNamePassword and accessDeviceCredentials will be
    ignored if the access device already exists.

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (List[str]): contact *Optional*
        port_number (int): portNumber *Optional*
        device_type (str): deviceType *Optional*
        protocol (str): protocol *Optional*
        net_address (str): netAddress *Optional*
        port (int): port *Optional*
        outbound_proxy_server_net_address (str): outboundProxyServerNetAddress *Optional*
        stun_server_net_address (str): stunServerNetAddress *Optional*
        mac_address (str): macAddress *Optional*
        serial_number (str): serialNumber *Optional*
        description (str): description *Optional*
        physical_location (str): physicalLocation *Optional*
        transport_protocol (str): transportProtocol *Optional*
        use_custom_user_name_password (bool): useCustomUserNamePassword *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
        "device_type",
        "protocol",
        "net_address",
        "port",
        "outbound_proxy_server_net_address",
        "stun_server_net_address",
        "mac_address",
        "serial_number",
        "description",
        "physical_location",
        "transport_protocol",
        "use_custom_user_name_password",
        "access_device_credentials",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "device_type",
                "deviceType",
                str,
            ),
            E(
                "protocol",
                "protocol",
                str,
            ),
            E(
                "net_address",
                "netAddress",
                str,
            ),
            E(
                "port",
                "port",
                int,
            ),
            E(
                "outbound_proxy_server_net_address",
                "outboundProxyServerNetAddress",
                str,
            ),
            E(
                "stun_server_net_address",
                "stunServerNetAddress",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "serial_number",
                "serialNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "physical_location",
                "physicalLocation",
                str,
            ),
            E(
                "transport_protocol",
                "transportProtocol",
                str,
            ),
            E(
                "use_custom_user_name_password",
                "useCustomUserNamePassword",
                bool,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
        )


class ConsolidatedAccessDeviceMultipleIdentityEndpointAndContactAdd22(OCIType):
    """
    Access device end point used in the context of add.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  In XS data mode, only one contact can be defined.  Only Static Registration
    capable devices may have more than one contact defined.  Port numbers are only used by
    devices with static line ordering.  In the case an access device referenced by
    accessDevice does not exist, the device will be added.  The device attributes
    deviceType, protocol, netAddress, port, outboundProxyServerNetAddress,
    stunServerNetAddress, macAddress, serialNumber, description, physicalLocation,
    transportProtocol, useCustomUserNamePassword and accessDeviceCredentials will be
    ignored if the access device already exists.  The following elements are only used in
    AS data mode and ignored in XS data mode: useHotline, use value false in XS data mode
    hotlineContact

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (List[str]): contact *Optional*
        port_number (int): portNumber *Optional*
        device_type (str): deviceType *Optional*
        protocol (str): protocol *Optional*
        net_address (str): netAddress *Optional*
        port (int): port *Optional*
        outbound_proxy_server_net_address (str): outboundProxyServerNetAddress *Optional*
        stun_server_net_address (str): stunServerNetAddress *Optional*
        mac_address (str): macAddress *Optional*
        serial_number (str): serialNumber *Optional*
        description (str): description *Optional*
        physical_location (str): physicalLocation *Optional*
        transport_protocol (str): transportProtocol *Optional*
        use_custom_user_name_password (bool): useCustomUserNamePassword *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_hotline (bool): useHotline
        hotline_contact (str): hotlineContact *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
        "device_type",
        "protocol",
        "net_address",
        "port",
        "outbound_proxy_server_net_address",
        "stun_server_net_address",
        "mac_address",
        "serial_number",
        "description",
        "physical_location",
        "transport_protocol",
        "use_custom_user_name_password",
        "access_device_credentials",
        "use_hotline",
        "hotline_contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
                is_array=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "device_type",
                "deviceType",
                str,
            ),
            E(
                "protocol",
                "protocol",
                str,
            ),
            E(
                "net_address",
                "netAddress",
                str,
            ),
            E(
                "port",
                "port",
                int,
            ),
            E(
                "outbound_proxy_server_net_address",
                "outboundProxyServerNetAddress",
                str,
            ),
            E(
                "stun_server_net_address",
                "stunServerNetAddress",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "serial_number",
                "serialNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "physical_location",
                "physicalLocation",
                str,
            ),
            E(
                "transport_protocol",
                "transportProtocol",
                str,
            ),
            E(
                "use_custom_user_name_password",
                "useCustomUserNamePassword",
                bool,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
            E(
                "use_hotline",
                "useHotline",
                bool,
                is_required=True,
            ),
            E(
                "hotline_contact",
                "hotlineContact",
                str,
            ),
        )


class ConsolidatedAccessDeviceMultipleIdentityEndpointAndContactModify(OCIType):
    """
    Access device end point used in the context of modify.

    . The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Only Static Registration capable devices may have more than one contact
    defined.  Only the first contact in contactList is used in XS data mode.  Port numbers
    are only used by devices with static line ordering.  In the case an access device
    referenced by accessDevice does not exist, the device will be added.  When the device
    needs to be added, if the linePort is not specified, the request will fail If the
    deviceType is included in the request a new device will be created using the type
    unless a device with the same name already exists.  The device attributes protocol,
    netAddress, port, outboundProxyServerNetAddress, stunServerNetAddress, macAddress,
    serialNumber, description, physicalLocation, transportProtocol,
    useCustomUserNamePassword and accessDeviceCredentials will be ignored if the access
    device already exists.  The following elements are only used in AS data mode and
    ignored in XS data mode: useHotline hotlineContact

    Attributes:
        access_device (accessDevice): accessDevice *Optional*
        line_port (str): linePort *Optional*
        private_identity (str): privateIdentity *Optional*
        contact_list (contactList): contactList *Optional*
        port_number (int): portNumber *Optional*
        device_type (str): deviceType *Optional*
        protocol (str): protocol *Optional*
        net_address (str): netAddress *Optional*
        port (int): port *Optional*
        outbound_proxy_server_net_address (str): outboundProxyServerNetAddress *Optional*
        stun_server_net_address (str): stunServerNetAddress *Optional*
        mac_address (str): macAddress *Optional*
        serial_number (str): serialNumber *Optional*
        description (str): description *Optional*
        physical_location (str): physicalLocation *Optional*
        transport_protocol (str): transportProtocol *Optional*
        use_custom_user_name_password (bool): useCustomUserNamePassword *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_hotline (bool): useHotline *Optional*
        hotline_contact (str): hotlineContact *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact_list",
        "port_number",
        "device_type",
        "protocol",
        "net_address",
        "port",
        "outbound_proxy_server_net_address",
        "stun_server_net_address",
        "mac_address",
        "serial_number",
        "description",
        "physical_location",
        "transport_protocol",
        "use_custom_user_name_password",
        "access_device_credentials",
        "use_hotline",
        "hotline_contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact_list",
                "contactList",
                ReplacementContactList,
                is_complex=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "device_type",
                "deviceType",
                str,
            ),
            E(
                "protocol",
                "protocol",
                str,
            ),
            E(
                "net_address",
                "netAddress",
                str,
            ),
            E(
                "port",
                "port",
                int,
            ),
            E(
                "outbound_proxy_server_net_address",
                "outboundProxyServerNetAddress",
                str,
            ),
            E(
                "stun_server_net_address",
                "stunServerNetAddress",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "serial_number",
                "serialNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "physical_location",
                "physicalLocation",
                str,
            ),
            E(
                "transport_protocol",
                "transportProtocol",
                str,
            ),
            E(
                "use_custom_user_name_password",
                "useCustomUserNamePassword",
                bool,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
            E(
                "use_hotline",
                "useHotline",
                bool,
            ),
            E(
                "hotline_contact",
                "hotlineContact",
                str,
            ),
        )


class ConsolidatedGroupServiceAssignment(OCIType):
    """
    Authorize and assign a group service.

    The authorizedQuantity will be used at the group level if provided; otherwise, the
    service quantity will be set to unlimited.  The command will fail if the authorized
    quantity set at the service provider level is insufficient.

    Attributes:
        group_service_name (str): groupServiceName
        authorized_quantity (authorizedQuantity): authorizedQuantity *Optional*
    """

    __slots__: List[str] = [
        "group_service_name",
        "authorized_quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_service_name",
                "groupServiceName",
                str,
                is_required=True,
            ),
            E(
                "authorized_quantity",
                "authorizedQuantity",
                UnboundedPositiveInt,
                is_complex=True,
            ),
        )


class ConsolidatedServicePackAssignment(OCIType):
    """
    Assign a service pack to user.

    If the service pack has not been authorized to the group, it will be authorized.  The
    authorizedQuantity will be used at the group level if provided; otherwise, the service
    quantity will be set to unlimited.  The command will fail if the authorized quantity
    set at the service provider level is insufficient.

    Attributes:
        service_pack_name (str): servicePackName
        authorized_quantity (authorizedQuantity): authorizedQuantity *Optional*
    """

    __slots__: List[str] = [
        "service_pack_name",
        "authorized_quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_required=True,
            ),
            E(
                "authorized_quantity",
                "authorizedQuantity",
                UnboundedPositiveInt,
                is_complex=True,
            ),
        )


class ConsolidatedSharedCallAppearanceAccessDeviceMultipleIdentityEndpoint(OCIType):
    """
    Access device end point for Shared Call Appearance Service used in the context of add.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.  In the
    case an access device referenced by accessDevice does not exist, the device will be
    added.  The device attributes deviceType, protocol, netAddress, port,
    outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
    description, physicalLocation, transportProtocol, useCustomUserNamePassword and
    accessDeviceCredentials will be ignored if the access device already exists.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    privateIdentity

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (str): contact *Optional*
        port_number (int): portNumber *Optional*
        is_active (bool): isActive
        allow_origination (bool): allowOrigination
        allow_termination (bool): allowTermination
        device_type (str): deviceType *Optional*
        protocol (str): protocol *Optional*
        net_address (str): netAddress *Optional*
        port (int): port *Optional*
        outbound_proxy_server_net_address (str): outboundProxyServerNetAddress *Optional*
        stun_server_net_address (str): stunServerNetAddress *Optional*
        mac_address (str): macAddress *Optional*
        serial_number (str): serialNumber *Optional*
        description (str): description *Optional*
        physical_location (str): physicalLocation *Optional*
        transport_protocol (str): transportProtocol *Optional*
        use_custom_user_name_password (bool): useCustomUserNamePassword *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_hotline (bool): useHotline *Optional*
        hotline_contact (str): hotlineContact *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
        "is_active",
        "allow_origination",
        "allow_termination",
        "device_type",
        "protocol",
        "net_address",
        "port",
        "outbound_proxy_server_net_address",
        "stun_server_net_address",
        "mac_address",
        "serial_number",
        "description",
        "physical_location",
        "transport_protocol",
        "use_custom_user_name_password",
        "access_device_credentials",
        "use_hotline",
        "hotline_contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "allow_origination",
                "allowOrigination",
                bool,
                is_required=True,
            ),
            E(
                "allow_termination",
                "allowTermination",
                bool,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
            ),
            E(
                "protocol",
                "protocol",
                str,
            ),
            E(
                "net_address",
                "netAddress",
                str,
            ),
            E(
                "port",
                "port",
                int,
            ),
            E(
                "outbound_proxy_server_net_address",
                "outboundProxyServerNetAddress",
                str,
            ),
            E(
                "stun_server_net_address",
                "stunServerNetAddress",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "serial_number",
                "serialNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "physical_location",
                "physicalLocation",
                str,
            ),
            E(
                "transport_protocol",
                "transportProtocol",
                str,
            ),
            E(
                "use_custom_user_name_password",
                "useCustomUserNamePassword",
                bool,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
            E(
                "use_hotline",
                "useHotline",
                bool,
            ),
            E(
                "hotline_contact",
                "hotlineContact",
                str,
            ),
        )


class ConsolidatedSharedCallAppearanceAccessDeviceMultipleIdentityEndpointAdd22(OCIType):
    """
    Access device end point for Shared Call Appearance Service used in the context of add.

    The endpoint is identified by its linePort (public Identity) and possibly a private
    Identity.  Port numbers are only used by devices with static line ordering.  In the
    case an access device referenced by accessDevice does not exist, the device will be
    added.  The device attributes deviceType, protocol, netAddress, port,
    outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
    description, physicalLocation, transportProtocol, useCustomUserNamePassword and
    accessDeviceCredentials will be ignored if the access device already exists.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    privateIdentity The following elements are only used in AS data mode and ignored in XS
    data mode: useHotline, use value false in XS data mode hotlineContact

    Attributes:
        access_device (accessDevice): accessDevice
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        contact (str): contact *Optional*
        port_number (int): portNumber *Optional*
        is_active (bool): isActive
        allow_origination (bool): allowOrigination
        allow_termination (bool): allowTermination
        device_type (str): deviceType *Optional*
        protocol (str): protocol *Optional*
        net_address (str): netAddress *Optional*
        port (int): port *Optional*
        outbound_proxy_server_net_address (str): outboundProxyServerNetAddress *Optional*
        stun_server_net_address (str): stunServerNetAddress *Optional*
        mac_address (str): macAddress *Optional*
        serial_number (str): serialNumber *Optional*
        description (str): description *Optional*
        physical_location (str): physicalLocation *Optional*
        transport_protocol (str): transportProtocol *Optional*
        use_custom_user_name_password (bool): useCustomUserNamePassword *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_hotline (bool): useHotline
        hotline_contact (str): hotlineContact *Optional*
    """

    __slots__: List[str] = [
        "access_device",
        "line_port",
        "private_identity",
        "contact",
        "port_number",
        "is_active",
        "allow_origination",
        "allow_termination",
        "device_type",
        "protocol",
        "net_address",
        "port",
        "outbound_proxy_server_net_address",
        "stun_server_net_address",
        "mac_address",
        "serial_number",
        "description",
        "physical_location",
        "transport_protocol",
        "use_custom_user_name_password",
        "access_device_credentials",
        "use_hotline",
        "hotline_contact",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device",
                "accessDevice",
                AccessDevice,
                is_complex=True,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "contact",
                "contact",
                str,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "allow_origination",
                "allowOrigination",
                bool,
                is_required=True,
            ),
            E(
                "allow_termination",
                "allowTermination",
                bool,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
            ),
            E(
                "protocol",
                "protocol",
                str,
            ),
            E(
                "net_address",
                "netAddress",
                str,
            ),
            E(
                "port",
                "port",
                int,
            ),
            E(
                "outbound_proxy_server_net_address",
                "outboundProxyServerNetAddress",
                str,
            ),
            E(
                "stun_server_net_address",
                "stunServerNetAddress",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "serial_number",
                "serialNumber",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "physical_location",
                "physicalLocation",
                str,
            ),
            E(
                "transport_protocol",
                "transportProtocol",
                str,
            ),
            E(
                "use_custom_user_name_password",
                "useCustomUserNamePassword",
                bool,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
            E(
                "use_hotline",
                "useHotline",
                bool,
                is_required=True,
            ),
            E(
                "hotline_contact",
                "hotlineContact",
                str,
            ),
        )


class ConsolidatedUserServiceAssignment(OCIType):
    """
    Assign a user service.

    If the service has not been authorized to the group, it will be authorized.  The
    authorizedQuantity will be used at the group level if provided; otherwise, the service
    quantity will be set to unlimited.  The command will fail if the authorized quantity
    set at the service provider level is insufficient.

    Attributes:
        user_service_name (str): userServiceName
        authorized_quantity (authorizedQuantity): authorizedQuantity *Optional*
    """

    __slots__: List[str] = [
        "user_service_name",
        "authorized_quantity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_service_name",
                "userServiceName",
                str,
                is_required=True,
            ),
            E(
                "authorized_quantity",
                "authorizedQuantity",
                UnboundedPositiveInt,
                is_complex=True,
            ),
        )


class CriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within a modify request.


    Attributes:
        from_dn_criteria_selection (str): fromDnCriteriaSelection *Optional*
        include_anonymous_callers (bool): includeAnonymousCallers *Optional*
        include_unavailable_callers (bool): includeUnavailableCallers *Optional*
        phone_number_list (phoneNumberList): phoneNumberList *Optional*
    """

    __slots__: List[str] = [
        "from_dn_criteria_selection",
        "include_anonymous_callers",
        "include_unavailable_callers",
        "phone_number_list",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "from_dn_criteria_selection",
                "fromDnCriteriaSelection",
                str,
            ),
            E(
                "include_anonymous_callers",
                "includeAnonymousCallers",
                bool,
            ),
            E(
                "include_unavailable_callers",
                "includeUnavailableCallers",
                bool,
            ),
            E(
                "phone_number_list",
                "phoneNumberList",
                CriteriaReplacementDNList,
                is_complex=True,
            ),
        )


class CriteriaFromDnModify23(OCIType):
    """
    The from dn criteria added with the option for selecting internal and external
    callers, used within a modify request.


    Attributes:
        from_dn_criteria_selection (str): fromDnCriteriaSelection *Optional*
        include_anonymous_callers (bool): includeAnonymousCallers *Optional*
        include_unavailable_callers (bool): includeUnavailableCallers *Optional*
        include_internal_callers (bool): includeInternalCallers *Optional*
        include_external_callers (bool): includeExternalCallers *Optional*
        phone_number_list (phoneNumberList): phoneNumberList *Optional*
    """

    __slots__: List[str] = [
        "from_dn_criteria_selection",
        "include_anonymous_callers",
        "include_unavailable_callers",
        "include_internal_callers",
        "include_external_callers",
        "phone_number_list",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "from_dn_criteria_selection",
                "fromDnCriteriaSelection",
                str,
            ),
            E(
                "include_anonymous_callers",
                "includeAnonymousCallers",
                bool,
            ),
            E(
                "include_unavailable_callers",
                "includeUnavailableCallers",
                bool,
            ),
            E(
                "include_internal_callers",
                "includeInternalCallers",
                bool,
            ),
            E(
                "include_external_callers",
                "includeExternalCallers",
                bool,
            ),
            E(
                "phone_number_list",
                "phoneNumberList",
                CriteriaReplacementDNList,
                is_complex=True,
            ),
        )


class DeviceManagementDeviceTypeModifyOptions(OCIType):
    """
    Device Management System device type options during a modify request.


    Attributes:
        device_access_protocol (str): deviceAccessProtocol *Optional*
        tag_mode (str): tagMode *Optional*
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
            *Optional*
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet *Optional*
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure *Optional*
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_format_in_non_request_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword,
                is_complex=True,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
        )


class DeviceManagementDeviceTypeModifyOptions16(OCIType):
    """
    Device Management System device type options during a modify request.


    Attributes:
        device_access_protocol (str): deviceAccessProtocol *Optional*
        tag_mode (str): tagMode *Optional*
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
            *Optional*
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet *Optional*
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet *Optional*
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure *Optional*
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
        )


class DeviceManagementDeviceTypeModifyOptions22(OCIType):
    """
    Device Management System device type options during a modify request.

    The following data elements are only used in AS data mode and ignored in XS data mode:
    enableDeviceActivation deviceModel

    Attributes:
        device_access_protocol (str): deviceAccessProtocol *Optional*
        tag_mode (str): tagMode *Optional*
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
            *Optional*
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet *Optional*
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet *Optional*
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure *Optional*
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        enable_device_activation (bool): enableDeviceActivation *Optional*
        device_model (str): deviceModel *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "enable_device_activation",
        "device_model",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "enable_device_activation",
                "enableDeviceActivation",
                bool,
            ),
            E(
                "device_model",
                "deviceModel",
                str,
            ),
        )


class DeviceManagementDeviceTypeModifyOptions22V2(OCIType):
    """
    Device Management System device type options during a modify request.

    The following data elements are only used in AS data mode and ignored in XS data mode:
    enableDeviceActivation deviceModel autoLinkingDeviceType autoCreateDevicesLevel

    Attributes:
        device_access_protocol (str): deviceAccessProtocol *Optional*
        tag_mode (str): tagMode *Optional*
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
            *Optional*
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet *Optional*
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet *Optional*
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure *Optional*
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        enable_device_activation (bool): enableDeviceActivation *Optional*
        device_model (str): deviceModel *Optional*
        auto_linking_device_type (str): autoLinkingDeviceType *Optional*
        auto_create_devices_level (str): autoCreateDevicesLevel *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "enable_device_activation",
        "device_model",
        "auto_linking_device_type",
        "auto_create_devices_level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "enable_device_activation",
                "enableDeviceActivation",
                bool,
            ),
            E(
                "device_model",
                "deviceModel",
                str,
            ),
            E(
                "auto_linking_device_type",
                "autoLinkingDeviceType",
                str,
            ),
            E(
                "auto_create_devices_level",
                "autoCreateDevicesLevel",
                str,
            ),
        )


class DeviceManagementDeviceTypeModifyOptions22V3(OCIType):
    """
    Device Management System device type options during a modify request.

    The following data elements are only used in AS data mode and ignored in XS data mode:
    enableDeviceActivation deviceModel autoLinkingDeviceType autoCreateDevicesLevel
    isActivationCodeThroughMessagingServer bearerFileAuthentication

    Attributes:
        device_access_protocol (str): deviceAccessProtocol *Optional*
        tag_mode (str): tagMode *Optional*
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
            *Optional*
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet *Optional*
        allow_sp_custom_tag_set (bool): allowSpCustomTagSet *Optional*
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure *Optional*
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        enable_device_activation (bool): enableDeviceActivation *Optional*
        device_model (str): deviceModel *Optional*
        auto_linking_device_type (str): autoLinkingDeviceType *Optional*
        auto_create_devices_level (str): autoCreateDevicesLevel *Optional*
        is_activation_code_through_messaging_server (bool):
            isActivationCodeThroughMessagingServer *Optional*
        bearer_file_authentication (bool): bearerFileAuthentication *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "allow_sp_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "enable_device_activation",
        "device_model",
        "auto_linking_device_type",
        "auto_create_devices_level",
        "is_activation_code_through_messaging_server",
        "bearer_file_authentication",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
            ),
            E(
                "allow_sp_custom_tag_set",
                "allowSpCustomTagSet",
                bool,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "enable_device_activation",
                "enableDeviceActivation",
                bool,
            ),
            E(
                "device_model",
                "deviceModel",
                str,
            ),
            E(
                "auto_linking_device_type",
                "autoLinkingDeviceType",
                str,
            ),
            E(
                "auto_create_devices_level",
                "autoCreateDevicesLevel",
                str,
            ),
            E(
                "is_activation_code_through_messaging_server",
                "isActivationCodeThroughMessagingServer",
                bool,
            ),
            E(
                "bearer_file_authentication",
                "bearerFileAuthentication",
                bool,
            ),
        )


class DeviceManagementDeviceTypeOptions(OCIType):
    """
    Device Management System device type options.


    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_format_in_non_request_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword,
                is_complex=True,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
        )


class DeviceManagementDeviceTypeOptions16(OCIType):
    """
    Device Management System device type options.


    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optional*
        access_device_credentials (accessDeviceCredentials): accessDeviceCredentials
            *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication
        mac_based_file_authentication (bool): macBasedFileAuthentication
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
        mac_in_non_request_uri (bool): macInNonRequestURI
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "tag_mode",
        "tag_set",
        "allow_device_profile_custom_tag_set",
        "allow_group_custom_tag_set",
        "send_email_upon_reset_failure",
        "device_access_net_address",
        "device_access_port",
        "device_access_context",
        "device_access_uri",
        "default_device_language",
        "default_device_encoding",
        "access_device_credentials",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "mac_in_non_request_uri",
        "mac_format_in_non_request_uri",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "tag_mode",
                "tagMode",
                str,
                is_required=True,
            ),
            E(
                "tag_set",
                "tagSet",
                str,
            ),
            E(
                "allow_device_profile_custom_tag_set",
                "allowDeviceProfileCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "allow_group_custom_tag_set",
                "allowGroupCustomTagSet",
                bool,
                is_required=True,
            ),
            E(
                "send_email_upon_reset_failure",
                "sendEmailUponResetFailure",
                bool,
                is_required=True,
            ),
            E(
                "device_access_net_address",
                "deviceAccessNetAddress",
                str,
            ),
            E(
                "device_access_port",
                "deviceAccessPort",
                int,
            ),
            E(
                "device_access_context",
                "deviceAccessContext",
                str,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
            ),
            E(
                "default_device_language",
                "defaultDeviceLanguage",
                str,
            ),
            E(
                "default_device_encoding",
                "defaultDeviceEncoding",
                str,
            ),
            E(
                "access_device_credentials",
                "accessDeviceCredentials",
                DeviceManagementUserNamePassword16,
                is_complex=True,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
                is_required=True,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
                is_required=True,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
        )


class DeviceManagementDeviceTypeOptions21sp1(OCIType):
    """
    Device Management System device type options.

    Note: For the elements listed below, when device configuration is set to
    deviceManagement, those elements apply to the creation of the Polycom Phone Services
    directory file only.  For all other files, they are not used.  Those elements are
    instead configured on a per-file basis at the Device Type File level.  When device
    configuration is set to legacy, those elements apply to all configuration files.
    useHttpDigestAuthentication macBasedFileAuthentication
    userNamePasswordFileAuthentication macInNonRequestURI macInCert
    macFormatInNonRequestURI

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        tag_mode (str): tagMode
        tag_set (str): tagSet *Optional*
        allow_device_profile_custom_tag_set (bool): allowDeviceProfileCustomTagSet
        allow_group_custom_tag_set (bool): allowGroupCustomTagSet
        send_email_upon_reset_failure (bool): sendEmailUponResetFailure
        device_access_net_address (str): deviceAccessNetAddress *Optional*
        device_access_port (int): deviceAccessPort *Optional*
        device_access_context (str): deviceAccessContext *Optional*
        device_access_uri (str): deviceAccessURI *Optional*
        default_device_language (str): defaultDeviceLanguage *Optional*
        default_device_encoding (str): defaultDeviceEncoding *Optio