"""Broadworks OCI-P Interface Response Classes"""

# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2024-03-25T14:43:17.025184
from typing import List
from typing import Tuple

import broadworks_ocip.types as OCI
from .base import ElementInfo as E
from .base import OCIResponse


class AuthenticationResponse(OCIResponse):
    """
    `AuthenticationRequest()`/Response is 1st stage of the 2 stage OCI login process.


    Attributes:
        user_id (str): userId
        nonce (str): nonce
        password_algorithm (str): passwordAlgorithm
    """

    __slots__: List[str] = [
        "user_id",
        "nonce",
        "password_algorithm",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "nonce",
                "nonce",
                str,
                is_required=True,
            ),
            E(
                "password_algorithm",
                "passwordAlgorithm",
                str,
                is_required=True,
            ),
        )


class AuthenticationVerifyResponse(OCIResponse):
    """
    Response to `AuthenticationVerifyRequest()`

    Replaced By: `AuthenticationVerifyResponse14sp8()`

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        user_domain (str): userDomain
        last_name (str): lastName *Optional*
        first_name (str): firstName *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "user_domain",
        "last_name",
        "first_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "user_domain",
                "userDomain",
                str,
                is_required=True,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
        )


class AuthenticationVerifyResponse14sp8(OCIResponse):
    """
    Response to `AuthenticationVerifyRequest14sp8()` If a phoneNumber is returned, it will
    be the primay DN of the user

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        last_name (str): lastName *Optional*
        first_name (str): firstName *Optional*
        user_id (str): userId
        phone_number (str): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "last_name",
        "first_name",
        "user_id",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
        )


class AuthenticationVerifyResponse21sp1(OCIResponse):
    """
    Response to `AuthenticationVerifyRequest21sp1()` If a phoneNumber is returned, it will
    be the primay DN of the user The parameter tokenRevocationTime is represented in the
    number of milliseconds since January 1, 1970, 00:00:00 GMT, and it is set to the more
    current time between the system level token revocation time and user level token
    revocation time.

    Replaced by `AuthenticationVerifyResponse22V2()`.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        last_name (str): lastName *Optional*
        first_name (str): firstName *Optional*
        user_id (str): userId
        phone_number (str): phoneNumber *Optional*
        token_revocation_time (int): tokenRevocationTime *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "last_name",
        "first_name",
        "user_id",
        "phone_number",
        "token_revocation_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "token_revocation_time",
                "tokenRevocationTime",
                int,
            ),
        )


class AuthenticationVerifyResponse22(OCIResponse):
    """
    Response to `AuthenticationVerifyRequest22()` If a phoneNumber is returned, it will be
    the primary DN of the user Replaced by `AuthenticationVerifyResponse22V2()`.


    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        last_name (str): lastName *Optional*
        first_name (str): firstName *Optional*
        user_id (str): userId
        phone_number (str): phoneNumber *Optional*
        reseller_id (str): resellerId *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "last_name",
        "first_name",
        "user_id",
        "phone_number",
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
        )


class AuthenticationVerifyResponse22V2(OCIResponse):
    """
    Response to `AuthenticationVerifyRequest22V2()` The following data elements are only
    returned in AS data mode: tokenRevocationTime If a phoneNumber is returned, it will be
    the primary DN of the user.

    The parameter tokenRevocationTime is represented in the number of milliseconds since
    January 1, 1970, 00:00:00 GMT, and it is set to the more current time between the
    system level token revocation time and user level token revocation time.  Replaced by
    `AuthenticationVerifyResponse22V3()`

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        last_name (str): lastName *Optional*
        first_name (str): firstName *Optional*
        user_id (str): userId
        phone_number (str): phoneNumber *Optional*
        reseller_id (str): resellerId *Optional*
        token_revocation_time (int): tokenRevocationTime *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "last_name",
        "first_name",
        "user_id",
        "phone_number",
        "reseller_id",
        "token_revocation_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "token_revocation_time",
                "tokenRevocationTime",
                int,
            ),
        )


class AuthenticationVerifyResponse22V3(OCIResponse):
    """
    Response to `AuthenticationVerifyRequest22V3()` The following data elements are only
    returned in AS data mode: resellerId If a phoneNumber is returned, it will be the
    primary DN of the user.

    The parameter tokenRevocationTime is represented in the number of milliseconds since
    January 1, 1970, 00:00:00 GMT, and it is set to the more current time between the
    system level token revocation time and user level token revocation time.  Replaced by
    `AuthenticationVerifyResponse22V4()`.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        last_name (str): lastName *Optional*
        first_name (str): firstName *Optional*
        user_id (str): userId
        phone_number (str): phoneNumber *Optional*
        reseller_id (str): resellerId *Optional*
        token_revocation_time (int): tokenRevocationTime *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "last_name",
        "first_name",
        "user_id",
        "phone_number",
        "reseller_id",
        "token_revocation_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "token_revocation_time",
                "tokenRevocationTime",
                int,
            ),
        )


class AuthenticationVerifyResponse22V4(OCIResponse):
    """
    Response to `AuthenticationVerifyRequest22V4()` The following data elements are only
    returned in AS data mode: resellerId If a phoneNumber is returned, it will be the
    primary DN of the user.

    The parameter tokenRevocationTime is represented in the number of milliseconds since
    January 1, 1970, 00:00:00 GMT, and it is set to the more current time between the
    system level token revocation time and user level token revocation time.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        last_name (str): lastName *Optional*
        first_name (str): firstName *Optional*
        user_id (str): userId
        phone_number (str): phoneNumber *Optional*
        reseller_id (str): resellerId *Optional*
        token_revocation_time (int): tokenRevocationTime *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "last_name",
        "first_name",
        "user_id",
        "phone_number",
        "reseller_id",
        "token_revocation_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "token_revocation_time",
                "tokenRevocationTime",
                int,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested access
    device file.

    Also return the file name and path on the File Repository.  This is a response to
    `DeviceManagementFileAuthLocationGetRequest()`.

    Attributes:
        file_repository_user_name (str): fileRepositoryUserName
        file_repository_password (str): fileRepositoryPassword
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
    """

    __slots__: List[str] = [
        "file_repository_user_name",
        "file_repository_password",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
                is_required=True,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse17(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested access
    device file.

    Also return the file name and path on the File Repository.  This is a response to
    `DeviceManagementFileAuthLocationGetRequest17()`. Replaced by:
    `DeviceManagementFileAuthLocationGetRequest18()`

    Attributes:
        file_repository_user_name (str): fileRepositoryUserName
        file_repository_password (str): fileRepositoryPassword
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
    """

    __slots__: List[str] = [
        "file_repository_user_name",
        "file_repository_password",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
                is_required=True,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse18(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested access
    device file.

    Also return the file name and path on the File Repository.  This is a response to
    `DeviceManagementFileAuthLocationGetRequest18()`. Replaced by:
    `DeviceManagementFileAuthLocationGetResponse21()`.

    Attributes:
        file_repository_user_name (str): fileRepositoryUserName
        file_repository_password (str): fileRepositoryPassword
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
        enable_caching (bool): enableCaching *Optional*
    """

    __slots__: List[str] = [
        "file_repository_user_name",
        "file_repository_password",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
        "enable_caching",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
                is_required=True,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
            E(
                "enable_caching",
                "enableCaching",
                bool,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse20sp1(OCIResponse):
    """
    This is a response to `DeviceManagementFileAuthLocationGetRequest20sp1()`.

    Return the address and credentials of the File Repository hosting the requested access
    device file.  Also return the file name and path on the File Repository.  Replaced by:
    `DeviceManagementFileAuthLocationGetResponse21sp1()`.

    Attributes:
        file_repository_user_name (str): fileRepositoryUserName
        file_repository_password (str): fileRepositoryPassword
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
        enable_caching (bool): enableCaching *Optional*
    """

    __slots__: List[str] = [
        "file_repository_user_name",
        "file_repository_password",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
        "enable_caching",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
                is_required=True,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
            E(
                "enable_caching",
                "enableCaching",
                bool,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse21(OCIResponse):
    """
    This is a response to `DeviceManagementFileAuthLocationGetRequest21()`.

    Return the address and credentials of the File Repository hosting the requested access
    device file.  Also return the file name and path on the File Repository.  Also returns
    the status of the file authentication.  Replaced by:
    `DeviceManagementFileAuthLocationGetResponse21sp1()`.

    Attributes:
        status (str): status *Optional*
        file_repository_user_name (str): fileRepositoryUserName
        file_repository_password (str): fileRepositoryPassword
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
        enable_caching (bool): enableCaching *Optional*
        notify_file_upload (bool): notifyFileUpload *Optional*
    """

    __slots__: List[str] = [
        "status",
        "file_repository_user_name",
        "file_repository_password",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
        "enable_caching",
        "notify_file_upload",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "status",
                "status",
                str,
            ),
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
                is_required=True,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
            E(
                "enable_caching",
                "enableCaching",
                bool,
            ),
            E(
                "notify_file_upload",
                "notifyFileUpload",
                bool,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse21sp1(OCIResponse):
    """
    This is a response to `DeviceManagementFileAuthLocationGetRequest21sp1()`.

    Return the address and credentials of the File Repository hosting the requested access
    device file.  Also return the file name and path on the File Repository.  Also returns
    the status of the file authentication.

    Attributes:
        status (str): status *Optional*
        file_repository_user_name (str): fileRepositoryUserName
        file_repository_password (str): fileRepositoryPassword
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
        enable_caching (bool): enableCaching *Optional*
        notify_file_upload (bool): notifyFileUpload *Optional*
    """

    __slots__: List[str] = [
        "status",
        "file_repository_user_name",
        "file_repository_password",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
        "enable_caching",
        "notify_file_upload",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "status",
                "status",
                str,
            ),
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
                is_required=True,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
            E(
                "enable_caching",
                "enableCaching",
                bool,
            ),
            E(
                "notify_file_upload",
                "notifyFileUpload",
                bool,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse22(OCIResponse):
    """
    This is a response to `DeviceManagementFileAuthLocationGetRequest22()`.

    Return the address and credentials of the File Repository hosting the requested access
    device file.  Also return the file name and path on the File Repository.  Also returns
    the status of the file authentication.

    Attributes:
        status (str): status *Optional*
        file_repository_user_name (str): fileRepositoryUserName
        file_repository_password (str): fileRepositoryPassword
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
        enable_caching (bool): enableCaching *Optional*
        notify_file_upload (bool): notifyFileUpload *Optional*
    """

    __slots__: List[str] = [
        "status",
        "file_repository_user_name",
        "file_repository_password",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
        "enable_caching",
        "notify_file_upload",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "status",
                "status",
                str,
            ),
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
                is_required=True,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
            E(
                "enable_caching",
                "enableCaching",
                bool,
            ),
            E(
                "notify_file_upload",
                "notifyFileUpload",
                bool,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse22V2(OCIResponse):
    """
    This is a response to `DeviceManagementFileAuthLocationGetRequest22V2()`.

    Return the address and credentials of the File Repository hosting the requested access
    device file.  Also return the file name and path on the File Repository.  Also returns
    the status of the file authentication.

    Attributes:
        status (str): status *Optional*
        file_repository_user_name (str): fileRepositoryUserName
        file_repository_password (str): fileRepositoryPassword
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
        enable_caching (bool): enableCaching *Optional*
        notify_file_upload (bool): notifyFileUpload *Optional*
    """

    __slots__: List[str] = [
        "status",
        "file_repository_user_name",
        "file_repository_password",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
        "enable_caching",
        "notify_file_upload",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "status",
                "status",
                str,
            ),
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
                is_required=True,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
            E(
                "enable_caching",
                "enableCaching",
                bool,
            ),
            E(
                "notify_file_upload",
                "notifyFileUpload",
                bool,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse22V3(OCIResponse):
    """
    This is a response to `DeviceManagementFileAuthLocationGetRequest22V3()`.

    Return the address and credentials of the File Repository hosting the requested access
    device file.  Also return the file name and path on the File Repository.  Also returns
    the status of the file authentication.

    Attributes:
        status (str): status *Optional*
        file_repository_user_name (str): fileRepositoryUserName
        file_repository_password (str): fileRepositoryPassword
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
        enable_caching (bool): enableCaching *Optional*
        notify_file_upload (bool): notifyFileUpload *Optional*
    """

    __slots__: List[str] = [
        "status",
        "file_repository_user_name",
        "file_repository_password",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
        "enable_caching",
        "notify_file_upload",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "status",
                "status",
                str,
            ),
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
                is_required=True,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
                is_required=True,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
            E(
                "enable_caching",
                "enableCaching",
                bool,
            ),
            E(
                "notify_file_upload",
                "notifyFileUpload",
                bool,
            ),
        )


class DeviceManagementFileAuthLocationGetResponse22V4(OCIResponse):
    """
    This is a response to `DeviceManagementFileAuthLocationGetRequest22V4()`.

    Return the address and credentials of the File Repository hosting the requested access
    device file.  Also return the file name and path on the File Repository.  Also returns
    the status of the file authentication.

    Attributes:
        status (str): status *Optional*
        file_repository_user_name (str): fileRepositoryUserName *Optional*
        file_repository_password (str): fileRepositoryPassword *Optional*
        file_repos_access_token (str): fileReposAccessToken *Optional*
        net_address (str): netAddress
        remote_file_format (str): remoteFileFormat
        port_number (int): portNumber *Optional*
        root_directory (str): rootDirectory *Optional*
        cpe_file_directory (str): cpeFileDirectory *Optional*
        secure (bool): secure *Optional*
        mac_in_non_request_uri (bool): macInNonRequestURI *Optional*
        mac_in_cert (bool): macInCert *Optional*
        mac_format_in_non_request_uri (str): macFormatInNonRequestURI *Optional*
        use_http_digest_authentication (bool): useHttpDigestAuthentication *Optional*
        mac_based_file_authentication (bool): macBasedFileAuthentication *Optional*
        user_name_password_file_authentication (bool): userNamePasswordFileAuthentication
            *Optional*
        completion_notification (bool): completionNotification *Optional*
        file_category (str): fileCategory *Optional*
        enable_caching (bool): enableCaching *Optional*
        notify_file_upload (bool): notifyFileUpload *Optional*
    """

    __slots__: List[str] = [
        "status",
        "file_repository_user_name",
        "file_repository_password",
        "file_repos_access_token",
        "net_address",
        "remote_file_format",
        "port_number",
        "root_directory",
        "cpe_file_directory",
        "secure",
        "mac_in_non_request_uri",
        "mac_in_cert",
        "mac_format_in_non_request_uri",
        "use_http_digest_authentication",
        "mac_based_file_authentication",
        "user_name_password_file_authentication",
        "completion_notification",
        "file_category",
        "enable_caching",
        "notify_file_upload",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "status",
                "status",
                str,
            ),
            E(
                "file_repository_user_name",
                "fileRepositoryUserName",
                str,
            ),
            E(
                "file_repository_password",
                "fileRepositoryPassword",
                str,
            ),
            E(
                "file_repos_access_token",
                "fileReposAccessToken",
                str,
            ),
            E(
                "net_address",
                "netAddress",
                str,
                is_required=True,
            ),
            E(
                "remote_file_format",
                "remoteFileFormat",
                str,
                is_required=True,
            ),
            E(
                "port_number",
                "portNumber",
                int,
            ),
            E(
                "root_directory",
                "rootDirectory",
                str,
            ),
            E(
                "cpe_file_directory",
                "cpeFileDirectory",
                str,
            ),
            E(
                "secure",
                "secure",
                bool,
            ),
            E(
                "mac_in_non_request_uri",
                "macInNonRequestURI",
                bool,
            ),
            E(
                "mac_in_cert",
                "macInCert",
                bool,
            ),
            E(
                "mac_format_in_non_request_uri",
                "macFormatInNonRequestURI",
                str,
            ),
            E(
                "use_http_digest_authentication",
                "useHttpDigestAuthentication",
                bool,
            ),
            E(
                "mac_based_file_authentication",
                "macBasedFileAuthentication",
                bool,
            ),
            E(
                "user_name_password_file_authentication",
                "userNamePasswordFileAuthentication",
                bool,
            ),
            E(
                "completion_notification",
                "completionNotification",
                bool,
            ),
            E(
                "file_category",
                "fileCategory",
                str,
            ),
            E(
                "enable_caching",
                "enableCaching",
                bool,
            ),
            E(
                "notify_file_upload",
                "notifyFileUpload",
                bool,
            ),
        )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListResponse(OCIResponse):
    """
    Response to
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest()`.

    The response contains a table with columns: "Mobile Number", "User Id", "Last Name",
    "First Name","Phone Number","Extension", "Group Id", "Department" and "Mobile
    Network". The "Mobile Number" column contains a single DN. The "User Id", "Last Name"
    and "First Name" columns contains the corresponding attributes of the user possessing
    the DN(s). The "Phone Number" column contains a single DN. The "Group Id" column
    contains the Group Id of the user.  The "Department" column contains the department of
    the user if it is part of a department.  The "Mobile Network" column contains the
    Mobile Network the number belongs to.

    Attributes:
        mobile_subscriber_directory_numbers_assignment_table
            (List(mobileSubscriberDirectoryNumbersAssignmentTable)):
            mobileSubscriberDirectoryNumbersAssignmentTable - *Table* array of
            mobileSubscriberDirectoryNumbersAssignmentTable named tuples
    """

    __slots__: List[str] = [
        "mobile_subscriber_directory_numbers_assignment_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "mobile_subscriber_directory_numbers_assignment_table",
                "mobileSubscriberDirectoryNumbersAssignmentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentPagedSortedListResponse(OCIResponse):
    """
    Response to
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentPagedSortedListRequest()`.

    The response contains a table with columns: "Mobile Number", "User Id", "Last Name",
    "First Name", "Phone Number", "Extension", "Group Id", "Department", "Department
    Type", "Parent Department", "Parent Department Type", "Mobile Network", "Country
    Code", "National Prefix", "Available", "Mobile Country Code", "Mobile National
    Prefix". The "Mobile Number" column contains a single DN. The "User Id", "Last Name"
    and "First Name" columns contains the corresponding attributes of the user possessing
    the DN(s). The "Phone Number" column contains a single DN. The "Group Id" column
    contains the Group Id of the user.  The "Group Name" column contains the Group Name of
    the user.  The "Department" column contains the department of the user if it is part
    of a department.  The "Parent Department" column contains the parent department of the
    user if it is part of a department.  The "Department Type" and "Parent Department
    Type" columns will contain the values "Enterprise" or "Group". The "Mobile Network"
    column contains the Mobile Network the number belongs to.  The "Country Code" column
    indicates the dialing prefix for the phone number.  The "National Prefix" column
    indicates the digit sequence to be dialed before the telephone number.  The
    "Available" column indicates if the Mobile Number is available.  The "Mobile Country
    Code" column indicates the dialing prefix for the mobile number.  The "Mobile National
    Prefix" column indicates the digit sequence to be dialed before the mobile number.
    Replaced by:
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentPagedSortedListResponse22()`

    Attributes:
        mobile_subscriber_directory_numbers_assignment_table
            (List(mobileSubscriberDirectoryNumbersAssignmentTable)):
            mobileSubscriberDirectoryNumbersAssignmentTable - *Table* array of
            mobileSubscriberDirectoryNumbersAssignmentTable named tuples
    """

    __slots__: List[str] = [
        "mobile_subscriber_directory_numbers_assignment_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "mobile_subscriber_directory_numbers_assignment_table",
                "mobileSubscriberDirectoryNumbersAssignmentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentPagedSortedListResponse22(OCIResponse):
    """
    Response to
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentPagedSortedListRequest22()`.

    The response contains the number of entries that would be returned if the response was
    not page size restricted.  Contains a table with columns: "Mobile Number", "User Id",
    "Last Name", "First Name", "Phone Number", "Extension", "Group Id", "Department",
    "Department Type", "Parent Department", "Parent Department Type", "Mobile Network",
    "Country Code", "National Prefix", "Available", "Mobile Country Code", "Mobile
    National Prefix". The "Mobile Number" column contains a single DN. The "User Id",
    "Last Name" and "First Name" columns contains the corresponding attributes of the user
    possessing the DN(s). The "Phone Number" column contains a single DN. The "Group Id"
    column contains the Group Id of the user.  The "Group Name" column contains the Group
    Name of the user.  The "Department" column contains the department of the user if it
    is part of a department.  The "Parent Department" column contains the parent
    department of the user if it is part of a department.  The "Department Type" and
    "Parent Department Type" columns will contain the values "Enterprise" or "Group". The
    "Mobile Network" column contains the Mobile Network the number belongs to.  The
    "Country Code" column indicates the dialing prefix for the phone number.  The
    "National Prefix" column indicates the digit sequence to be dialed before the
    telephone number.  The "Available" column indicates if the Mobile Number is available.
    The "Mobile Country Code" column indicates the dialing prefix for the mobile number.
    The "Mobile National Prefix" column indicates the digit sequence to be dialed before
    the mobile number.

    Attributes:
        total_number_of_rows (int): totalNumberOfRows *Optional*
        mobile_subscriber_directory_numbers_assignment_table
            (List(mobileSubscriberDirectoryNumbersAssignmentTable)):
            mobileSubscriberDirectoryNumbersAssignmentTable - *Table* array of
            mobileSubscriberDirectoryNumbersAssignmentTable named tuples
    """

    __slots__: List[str] = [
        "total_number_of_rows",
        "mobile_subscriber_directory_numbers_assignment_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_number_of_rows",
                "totalNumberOfRows",
                int,
            ),
            E(
                "mobile_subscriber_directory_numbers_assignment_table",
                "mobileSubscriberDirectoryNumbersAssignmentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(OCIResponse):
    """
    Response to
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()`.

    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    Attributes:
        available_mobile_subscriber_directory_number (List[str]):
            availableMobileSubscriberDirectoryNumber *Optional*
    """

    __slots__: List[str] = [
        "available_mobile_subscriber_directory_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_mobile_subscriber_directory_number",
                "availableMobileSubscriberDirectoryNumber",
                str,
                is_array=True,
            ),
        )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse22(OCIResponse):
    """
    Response to
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest22()`.

    The response contains a table with columns: "Phone Number", "E164 Phone Number". The
    "Phone Number" column contains Mobile Subscriber DNs not yet assigned to any user.
    The "E164 Phone Number" column contains Mobile Subscriber DNs not yet assigned to any
    user in E.164 format.

    Attributes:
        available_mobile_subscriber_directory_number_table
            (List(availableMobileSubscriberDirectoryNumberTable)):
            availableMobileSubscriberDirectoryNumberTable - *Table* array of
            availableMobileSubscriberDirectoryNumberTable named tuples
    """

    __slots__: List[str] = [
        "available_mobile_subscriber_directory_number_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_mobile_subscriber_directory_number_table",
                "availableMobileSubscriberDirectoryNumberTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailablePagedSortedListResponse(OCIResponse):
    """
    Response to
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailablePagedSortedListRequest()`.

    The response contains a table with columns: "Mobile Number", "Mobile Network", "Mobile
    Country Code", "Mobile National Prefix". The "Mobile Number" column contains a single
    DN. The "Mobile Network" column contains the Mobile Network the number belongs to.
    The "Mobile Country Code" column indicates the dialing prefix for the mobile number.
    The "Mobile National Prefix" column indicates the digit sequence to be dialed before
    the mobile number.  Replaced by:
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailablePagedSortedListResponse22()`

    Attributes:
        available_mobile_subscriber_directory_number_table
            (List(availableMobileSubscriberDirectoryNumberTable)):
            availableMobileSubscriberDirectoryNumberTable - *Table* array of
            availableMobileSubscriberDirectoryNumberTable named tuples
    """

    __slots__: List[str] = [
        "available_mobile_subscriber_directory_number_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_mobile_subscriber_directory_number_table",
                "availableMobileSubscriberDirectoryNumberTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailablePagedSortedListResponse22(OCIResponse):
    """
    Response to
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailablePagedSortedListRequest22()`.

    The response contains the number of entries that would be returned if the response was
    not page size restricted.  Contains a table with columns: "Mobile Number", "Mobile
    Network", "Mobile Country Code", "Mobile National Prefix". The "Mobile Number" column
    contains a single DN. The "Mobile Network" column contains the Mobile Network the
    number belongs to.  The "Mobile Country Code" column indicates the dialing prefix for
    the mobile number.  The "Mobile National Prefix" column indicates the digit sequence
    to be dialed before the mobile number.

    Attributes:
        total_number_of_rows (int): totalNumberOfRows *Optional*
        available_mobile_subscriber_directory_number_table
            (List(availableMobileSubscriberDirectoryNumberTable)):
            availableMobileSubscriberDirectoryNumberTable - *Table* array of
            availableMobileSubscriberDirectoryNumberTable named tuples
    """

    __slots__: List[str] = [
        "total_number_of_rows",
        "available_mobile_subscriber_directory_number_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_number_of_rows",
                "totalNumberOfRows",
                int,
            ),
            E(
                "available_mobile_subscriber_directory_number_table",
                "availableMobileSubscriberDirectoryNumberTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdDefaultProfileGetResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterAgentThresholdDefaultProfileGetRequest()`.

    The agent table contains the agents assigned to the profile and has column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_name (str): profileName
        profile_description (str): profileDescription *Optional*
        threshold_current_call_state_idle_time_yellow (int):
            thresholdCurrentCallStateIdleTimeYellow *Optional*
        threshold_current_call_state_idle_time_red (int):
            thresholdCurrentCallStateIdleTimeRed *Optional*
        threshold_current_call_state_on_call_time_yellow (int):
            thresholdCurrentCallStateOnCallTimeYellow *Optional*
        threshold_current_call_state_on_call_time_red (int):
            thresholdCurrentCallStateOnCallTimeRed *Optional*
        threshold_current_agent_state_unavailable_time_yellow (int):
            thresholdCurrentAgentStateUnavailableTimeYellow *Optional*
        threshold_current_agent_state_unavailable_time_red (int):
            thresholdCurrentAgentStateUnavailableTimeRed *Optional*
        threshold_average_busy_in_time_yellow (int): thresholdAverageBusyInTimeYellow
            *Optional*
        threshold_average_busy_in_time_red (int): thresholdAverageBusyInTimeRed *Optional*
        threshold_average_busy_out_time_yellow (int): thresholdAverageBusyOutTimeYellow
            *Optional*
        threshold_average_busy_out_time_red (int): thresholdAverageBusyOutTimeRed
            *Optional*
        threshold_average_wrap_up_time_yellow (int): thresholdAverageWrapUpTimeYellow
            *Optional*
        threshold_average_wrap_up_time_red (int): thresholdAverageWrapUpTimeRed *Optional*
        enable_notification_email (bool): enableNotificationEmail
        notification_email_address (List[str]): notificationEmailAddress *Optional*
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples *Optional*
    """

    __slots__: List[str] = [
        "profile_name",
        "profile_description",
        "threshold_current_call_state_idle_time_yellow",
        "threshold_current_call_state_idle_time_red",
        "threshold_current_call_state_on_call_time_yellow",
        "threshold_current_call_state_on_call_time_red",
        "threshold_current_agent_state_unavailable_time_yellow",
        "threshold_current_agent_state_unavailable_time_red",
        "threshold_average_busy_in_time_yellow",
        "threshold_average_busy_in_time_red",
        "threshold_average_busy_out_time_yellow",
        "threshold_average_busy_out_time_red",
        "threshold_average_wrap_up_time_yellow",
        "threshold_average_wrap_up_time_red",
        "enable_notification_email",
        "notification_email_address",
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
            E(
                "profile_description",
                "profileDescription",
                str,
            ),
            E(
                "threshold_current_call_state_idle_time_yellow",
                "thresholdCurrentCallStateIdleTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_idle_time_red",
                "thresholdCurrentCallStateIdleTimeRed",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_yellow",
                "thresholdCurrentCallStateOnCallTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_red",
                "thresholdCurrentCallStateOnCallTimeRed",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_yellow",
                "thresholdCurrentAgentStateUnavailableTimeYellow",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_red",
                "thresholdCurrentAgentStateUnavailableTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_in_time_yellow",
                "thresholdAverageBusyInTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_in_time_red",
                "thresholdAverageBusyInTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_out_time_yellow",
                "thresholdAverageBusyOutTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_out_time_red",
                "thresholdAverageBusyOutTimeRed",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_yellow",
                "thresholdAverageWrapUpTimeYellow",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_red",
                "thresholdAverageWrapUpTimeRed",
                int,
            ),
            E(
                "enable_notification_email",
                "enableNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "notification_email_address",
                "notificationEmailAddress",
                str,
                is_array=True,
            ),
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the
    `EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address", "Agent Threshold Profile";

    Attributes:
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentPagedSortedListResponse(OCIResponse):
    """
    Response to the
    `EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentPagedSortedListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address", "Agent Threshold Profile";

    Attributes:
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterAgentThresholdProfileGetListRequest()`.

    Contains a table with all the Call Center Agent Threshold Profiles in the Enterprise.
    The column headings are: "Default", "Name", "Description".

    Attributes:
        profiles_table (List(profilesTable)): profilesTable - *Table* array of
            profilesTable named tuples
    """

    __slots__: List[str] = [
        "profiles_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profiles_table",
                "profilesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileGetPagedSortedResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterAgentThresholdProfileGetPagedSortedRequest()`.

    The agentTable contains the agents assigned to the profile and has the column
    headings: "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_description (str): profileDescription *Optional*
        threshold_current_call_state_idle_time_yellow (int):
            thresholdCurrentCallStateIdleTimeYellow *Optional*
        threshold_current_call_state_idle_time_red (int):
            thresholdCurrentCallStateIdleTimeRed *Optional*
        threshold_current_call_state_on_call_time_yellow (int):
            thresholdCurrentCallStateOnCallTimeYellow *Optional*
        threshold_current_call_state_on_call_time_red (int):
            thresholdCurrentCallStateOnCallTimeRed *Optional*
        threshold_current_agent_state_unavailable_time_yellow (int):
            thresholdCurrentAgentStateUnavailableTimeYellow *Optional*
        threshold_current_agent_state_unavailable_time_red (int):
            thresholdCurrentAgentStateUnavailableTimeRed *Optional*
        threshold_average_busy_in_time_yellow (int): thresholdAverageBusyInTimeYellow
            *Optional*
        threshold_average_busy_in_time_red (int): thresholdAverageBusyInTimeRed *Optional*
        threshold_average_busy_out_time_yellow (int): thresholdAverageBusyOutTimeYellow
            *Optional*
        threshold_average_busy_out_time_red (int): thresholdAverageBusyOutTimeRed
            *Optional*
        threshold_average_wrap_up_time_yellow (int): thresholdAverageWrapUpTimeYellow
            *Optional*
        threshold_average_wrap_up_time_red (int): thresholdAverageWrapUpTimeRed *Optional*
        enable_notification_email (bool): enableNotificationEmail
        notification_email_address (List[str]): notificationEmailAddress *Optional*
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "profile_description",
        "threshold_current_call_state_idle_time_yellow",
        "threshold_current_call_state_idle_time_red",
        "threshold_current_call_state_on_call_time_yellow",
        "threshold_current_call_state_on_call_time_red",
        "threshold_current_agent_state_unavailable_time_yellow",
        "threshold_current_agent_state_unavailable_time_red",
        "threshold_average_busy_in_time_yellow",
        "threshold_average_busy_in_time_red",
        "threshold_average_busy_out_time_yellow",
        "threshold_average_busy_out_time_red",
        "threshold_average_wrap_up_time_yellow",
        "threshold_average_wrap_up_time_red",
        "enable_notification_email",
        "notification_email_address",
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_description",
                "profileDescription",
                str,
            ),
            E(
                "threshold_current_call_state_idle_time_yellow",
                "thresholdCurrentCallStateIdleTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_idle_time_red",
                "thresholdCurrentCallStateIdleTimeRed",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_yellow",
                "thresholdCurrentCallStateOnCallTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_red",
                "thresholdCurrentCallStateOnCallTimeRed",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_yellow",
                "thresholdCurrentAgentStateUnavailableTimeYellow",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_red",
                "thresholdCurrentAgentStateUnavailableTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_in_time_yellow",
                "thresholdAverageBusyInTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_in_time_red",
                "thresholdAverageBusyInTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_out_time_yellow",
                "thresholdAverageBusyOutTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_out_time_red",
                "thresholdAverageBusyOutTimeRed",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_yellow",
                "thresholdAverageWrapUpTimeYellow",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_red",
                "thresholdAverageWrapUpTimeRed",
                int,
            ),
            E(
                "enable_notification_email",
                "enableNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "notification_email_address",
                "notificationEmailAddress",
                str,
                is_array=True,
            ),
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileGetResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterAgentThresholdProfileGetRequest()`.

    The agentTable contains the agents assigned to the profile and has the column
    headings: "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_description (str): profileDescription *Optional*
        threshold_current_call_state_idle_time_yellow (int):
            thresholdCurrentCallStateIdleTimeYellow *Optional*
        threshold_current_call_state_idle_time_red (int):
            thresholdCurrentCallStateIdleTimeRed *Optional*
        threshold_current_call_state_on_call_time_yellow (int):
            thresholdCurrentCallStateOnCallTimeYellow *Optional*
        threshold_current_call_state_on_call_time_red (int):
            thresholdCurrentCallStateOnCallTimeRed *Optional*
        threshold_current_agent_state_unavailable_time_yellow (int):
            thresholdCurrentAgentStateUnavailableTimeYellow *Optional*
        threshold_current_agent_state_unavailable_time_red (int):
            thresholdCurrentAgentStateUnavailableTimeRed *Optional*
        threshold_average_busy_in_time_yellow (int): thresholdAverageBusyInTimeYellow
            *Optional*
        threshold_average_busy_in_time_red (int): thresholdAverageBusyInTimeRed *Optional*
        threshold_average_busy_out_time_yellow (int): thresholdAverageBusyOutTimeYellow
            *Optional*
        threshold_average_busy_out_time_red (int): thresholdAverageBusyOutTimeRed
            *Optional*
        threshold_average_wrap_up_time_yellow (int): thresholdAverageWrapUpTimeYellow
            *Optional*
        threshold_average_wrap_up_time_red (int): thresholdAverageWrapUpTimeRed *Optional*
        enable_notification_email (bool): enableNotificationEmail
        notification_email_address (List[str]): notificationEmailAddress *Optional*
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "profile_description",
        "threshold_current_call_state_idle_time_yellow",
        "threshold_current_call_state_idle_time_red",
        "threshold_current_call_state_on_call_time_yellow",
        "threshold_current_call_state_on_call_time_red",
        "threshold_current_agent_state_unavailable_time_yellow",
        "threshold_current_agent_state_unavailable_time_red",
        "threshold_average_busy_in_time_yellow",
        "threshold_average_busy_in_time_red",
        "threshold_average_busy_out_time_yellow",
        "threshold_average_busy_out_time_red",
        "threshold_average_wrap_up_time_yellow",
        "threshold_average_wrap_up_time_red",
        "enable_notification_email",
        "notification_email_address",
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_description",
                "profileDescription",
                str,
            ),
            E(
                "threshold_current_call_state_idle_time_yellow",
                "thresholdCurrentCallStateIdleTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_idle_time_red",
                "thresholdCurrentCallStateIdleTimeRed",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_yellow",
                "thresholdCurrentCallStateOnCallTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_red",
                "thresholdCurrentCallStateOnCallTimeRed",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_yellow",
                "thresholdCurrentAgentStateUnavailableTimeYellow",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_red",
                "thresholdCurrentAgentStateUnavailableTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_in_time_yellow",
                "thresholdAverageBusyInTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_in_time_red",
                "thresholdAverageBusyInTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_out_time_yellow",
                "thresholdAverageBusyOutTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_out_time_red",
                "thresholdAverageBusyOutTimeRed",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_yellow",
                "thresholdAverageWrapUpTimeYellow",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_red",
                "thresholdAverageWrapUpTimeRed",
                int,
            ),
            E(
                "enable_notification_email",
                "enableNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "notification_email_address",
                "notificationEmailAddress",
                str,
                is_array=True,
            ),
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterAgentUnavailableCodeGetListRequest()`.

    Contains a table with column headings: "Is Active", "Code", "Description".

    Attributes:
        unavailable_codes_table (List(unavailableCodesTable)): unavailableCodesTable -
            *Table* array of unavailableCodesTable named tuples
    """

    __slots__: List[str] = [
        "unavailable_codes_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "unavailable_codes_table",
                "unavailableCodesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeGetResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterAgentUnavailableCodeGetRequest()`

    Attributes:
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse(OCIResponse):
    """
    Response to `EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest()`.

    Replaced by `EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()`.

    Attributes:
        enable_agent_unavailable_codes (bool): enableAgentUnavailableCodes
        default_agent_unavailable_code_on_dnd (str): defaultAgentUnavailableCodeOnDND
            *Optional*
        default_agent_unavailable_code_on_personal_calls (str):
            defaultAgentUnavailableCodeOnPersonalCalls *Optional*
        default_agent_unavailable_code_on_consecutive_bounces (str):
            defaultAgentUnavailableCodeOnConsecutiveBounces *Optional*
        force_use_of_agent_unavailable_codes (bool): forceUseOfAgentUnavailableCodes
        default_agent_unavailable_code (str): defaultAgentUnavailableCode *Optional*
    """

    __slots__: List[str] = [
        "enable_agent_unavailable_codes",
        "default_agent_unavailable_code_on_dnd",
        "default_agent_unavailable_code_on_personal_calls",
        "default_agent_unavailable_code_on_consecutive_bounces",
        "force_use_of_agent_unavailable_codes",
        "default_agent_unavailable_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_agent_unavailable_codes",
                "enableAgentUnavailableCodes",
                bool,
                is_required=True,
            ),
            E(
                "default_agent_unavailable_code_on_dnd",
                "defaultAgentUnavailableCodeOnDND",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_personal_calls",
                "defaultAgentUnavailableCodeOnPersonalCalls",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_consecutive_bounces",
                "defaultAgentUnavailableCodeOnConsecutiveBounces",
                str,
            ),
            E(
                "force_use_of_agent_unavailable_codes",
                "forceUseOfAgentUnavailableCodes",
                bool,
                is_required=True,
            ),
            E(
                "default_agent_unavailable_code",
                "defaultAgentUnavailableCode",
                str,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4(OCIResponse):
    """
    Response to `EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()`.


    Attributes:
        enable_agent_unavailable_codes (bool): enableAgentUnavailableCodes
        default_agent_unavailable_code_on_dnd (str): defaultAgentUnavailableCodeOnDND
            *Optional*
        default_agent_unavailable_code_on_personal_calls (str):
            defaultAgentUnavailableCodeOnPersonalCalls *Optional*
        default_agent_unavailable_code_on_consecutive_bounces (str):
            defaultAgentUnavailableCodeOnConsecutiveBounces *Optional*
        default_agent_unavailable_code_on_not_reachable (str):
            defaultAgentUnavailableCodeOnNotReachable *Optional*
        force_use_of_agent_unavailable_codes (bool): forceUseOfAgentUnavailableCodes
        default_agent_unavailable_code (str): defaultAgentUnavailableCode *Optional*
    """

    __slots__: List[str] = [
        "enable_agent_unavailable_codes",
        "default_agent_unavailable_code_on_dnd",
        "default_agent_unavailable_code_on_personal_calls",
        "default_agent_unavailable_code_on_consecutive_bounces",
        "default_agent_unavailable_code_on_not_reachable",
        "force_use_of_agent_unavailable_codes",
        "default_agent_unavailable_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_agent_unavailable_codes",
                "enableAgentUnavailableCodes",
                bool,
                is_required=True,
            ),
            E(
                "default_agent_unavailable_code_on_dnd",
                "defaultAgentUnavailableCodeOnDND",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_personal_calls",
                "defaultAgentUnavailableCodeOnPersonalCalls",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_consecutive_bounces",
                "defaultAgentUnavailableCodeOnConsecutiveBounces",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_not_reachable",
                "defaultAgentUnavailableCodeOnNotReachable",
                str,
            ),
            E(
                "force_use_of_agent_unavailable_codes",
                "forceUseOfAgentUnavailableCodes",
                bool,
                is_required=True,
            ),
            E(
                "default_agent_unavailable_code",
                "defaultAgentUnavailableCode",
                str,
            ),
        )


class EnterpriseCallCenterCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterCallDispositionCodeGetListRequest()`.

    Contains a table with column headings: "Is Active", "Code", "Description".

    Attributes:
        disposition_codes_table (List(dispositionCodesTable)): dispositionCodesTable -
            *Table* array of dispositionCodesTable named tuples
    """

    __slots__: List[str] = [
        "disposition_codes_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disposition_codes_table",
                "dispositionCodesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterCallDispositionCodeGetRequest()`

    Attributes:
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class EnterpriseCallCenterCallDispositionCodeGetUsageListResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterCallDispositionCodeGetUsageListRequest()`.

    The Type column contains either "Call Center" or "Route Point". Contains a table with
    column headings: "Group Id", "Id", "Name" and "Type".

    Attributes:
        call_center_table (List(callCenterTable)): callCenterTable - *Table* array of
            callCenterTable named tuples
    """

    __slots__: List[str] = [
        "call_center_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_center_table",
                "callCenterTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterCurrentAndPastAgentGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterCurrentAndPastAgentGetListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_user_table (List(agentUserTable)): agentUserTable - *Table* array of
            agentUserTable named tuples
        deleted_agent_user_table (List(deletedAgentUserTable)): deletedAgentUserTable -
            *Table* array of deletedAgentUserTable named tuples
    """

    __slots__: List[str] = [
        "agent_user_table",
        "deleted_agent_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_user_table",
                "agentUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
            E(
                "deleted_agent_user_table",
                "deletedAgentUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterCurrentAndPastCallCenterGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterCurrentAndPastCallCenterGetListRequest()`.


    Attributes:
        service_user_id (List[str]): serviceUserId *Optional*
        deleted_service_user_id (List[str]): deletedServiceUserId *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "deleted_service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_array=True,
            ),
            E(
                "deleted_service_user_id",
                "deletedServiceUserId",
                str,
                is_array=True,
            ),
        )


class EnterpriseCallCenterCurrentAndPastDNISGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterCurrentAndPastDNISGetListRequest()`.


    Attributes:
        name (List[str]): name *Optional*
        deleted_name (List[str]): deletedName *Optional*
    """

    __slots__: List[str] = [
        "name",
        "deleted_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
            E(
                "deleted_name",
                "deletedName",
                str,
                is_array=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the `EnterpriseCallCenterEnhancedReportingBrandingGetRequest()`.


    Attributes:
        branding_choice (str): brandingChoice
        branding_file_description (str): brandingFileDescription *Optional*
    """

    __slots__: List[str] = [
        "branding_choice",
        "branding_file_description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "branding_choice",
                "brandingChoice",
                str,
                is_required=True,
            ),
            E(
                "branding_file_description",
                "brandingFileDescription",
                str,
            ),
        )


class EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListResponse(OCIResponse):
    """
    Response to
    `EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest()`.

    Contains a table with column headings: "Name", "Description" and "Level", "Is Agent
    Required", "Is Call Center Required", "Is Call Center Dnis Required", "Is Real Time
    Report", "Is Sampling Period Required", "Call Completion Threshold Parameter", "Short
    Duration Threshold Parameter", "Service Level Threshold Parameter", "Service Level
    Inclusions Parameter", "Service Level Objective Threshold Parameter", "Abandoned Call
    Threshold Parameter", "Service Level Threshold Parameter Number", "Abandoned Call
    Threshold Parameter Number" and "Scope". The possible values for "Level" are "System"
    and "Enterprise". The possible values for "Is Agent Required", "Is Call Center
    Required", "Is Call Center Dnis Required", "Is Real Time Report" and "Is Sampling
    Period Required" are "true" and "false". The possible values for "Call Completion
    Threshold Parameter", "Short Duration Threshold Parameter", "Service Level Threshold
    Parameter", "Service Level Inclusions Parameter", "Service Level Objective Threshold
    Parameter" and "Abandoned Call Threshold Parameter" are "Required", "Hidden" and "Does
    Not Apply". The possible values for "Scope" are "Supervisor Only" and "Supervisor and
    Agent".

    Attributes:
        report_template_table (List(reportTemplateTable)): reportTemplateTable - *Table*
            array of reportTemplateTable named tuples
    """

    __slots__: List[str] = [
        "report_template_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "report_template_table",
                "reportTemplateTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to `EnterpriseCallCenterEnhancedReportingGetRequest()`.

    Replaced by `EnterpriseCallCenterEnhancedReportingGetResponse19()`

    Attributes:
        reporting_server (str): reportingServer
        web_statistic_source (str): webStatisticSource
    """

    __slots__: List[str] = [
        "reporting_server",
        "web_statistic_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reporting_server",
                "reportingServer",
                str,
                is_required=True,
            ),
            E(
                "web_statistic_source",
                "webStatisticSource",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingGetResponse19(OCIResponse):
    """
    Response to `EnterpriseCallCenterEnhancedReportingGetRequest19()`.


    Attributes:
        reporting_server (str): reportingServer
    """

    __slots__: List[str] = [
        "reporting_server",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reporting_server",
                "reportingServer",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to `EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest()`.

    Contains a table with column headings: "Name", "Description", "Type" and "Enabled".

    Attributes:
        report_template_table (List(reportTemplateTable)): reportTemplateTable - *Table*
            array of reportTemplateTable named tuples
    """

    __slots__: List[str] = [
        "report_template_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "report_template_table",
                "reportTemplateTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to `EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest()`.


    Attributes:
        description (str): description *Optional*
        data_template (str): dataTemplate
        filter_number (int): filterNumber *Optional*
        xslt_template_description (str): xsltTemplateDescription
        scope (str): scope
        is_enabled (bool): isEnabled
        is_realtime_report (bool): isRealtimeReport *Optional*
        call_completion_threshold_param (str): callCompletionThresholdParam *Optional*
        short_duration_threshold_param (str): shortDurationThresholdParam *Optional*
        service_level_threshold_param (str): serviceLevelThresholdParam *Optional*
        service_level_inclusions_param (str): serviceLevelInclusionsParam *Optional*
        service_level_objective_threshold_param (str): serviceLevelObjectiveThresholdParam
            *Optional*
        abandoned_call_threshold_param (str): abandonedCallThresholdParam *Optional*
        service_level_threshold_param_number (int): serviceLevelThresholdParamNumber
            *Optional*
        abandoned_call_threshold_param_number (int): abandonedCallThresholdParamNumber
            *Optional*
        filter_value (List[str]): filterValue *Optional*
    """

    __slots__: List[str] = [
        "description",
        "data_template",
        "filter_number",
        "xslt_template_description",
        "scope",
        "is_enabled",
        "is_realtime_report",
        "call_completion_threshold_param",
        "short_duration_threshold_param",
        "service_level_threshold_param",
        "service_level_inclusions_param",
        "service_level_objective_threshold_param",
        "abandoned_call_threshold_param",
        "service_level_threshold_param_number",
        "abandoned_call_threshold_param_number",
        "filter_value",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "data_template",
                "dataTemplate",
                str,
                is_required=True,
            ),
            E(
                "filter_number",
                "filterNumber",
                int,
            ),
            E(
                "xslt_template_description",
                "xsltTemplateDescription",
                str,
                is_required=True,
            ),
            E(
                "scope",
                "scope",
                str,
                is_required=True,
            ),
            E(
                "is_enabled",
                "isEnabled",
                bool,
                is_required=True,
            ),
            E(
                "is_realtime_report",
                "isRealtimeReport",
                bool,
            ),
            E(
                "call_completion_threshold_param",
                "callCompletionThresholdParam",
                str,
            ),
            E(
                "short_duration_threshold_param",
                "shortDurationThresholdParam",
                str,
            ),
            E(
                "service_level_threshold_param",
                "serviceLevelThresholdParam",
                str,
            ),
            E(
                "service_level_inclusions_param",
                "serviceLevelInclusionsParam",
                str,
            ),
            E(
                "service_level_objective_threshold_param",
                "serviceLevelObjectiveThresholdParam",
                str,
            ),
            E(
                "abandoned_call_threshold_param",
                "abandonedCallThresholdParam",
                str,
            ),
            E(
                "service_level_threshold_param_number",
                "serviceLevelThresholdParamNumber",
                int,
            ),
            E(
                "abandoned_call_threshold_param_number",
                "abandonedCallThresholdParamNumber",
                int,
            ),
            E(
                "filter_value",
                "filterValue",
                str,
                is_array=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListResponse(OCIResponse):
    """
    Response to
    `EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListRequest()`.

    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring". The "Created By" can be either "Administrator" or user id if created by
    supervisor.  The possible values for "Recurring" are "None", "Daily", "Weekly",
    "Monthly" and "Yearly". The possible values for "Report Level" are "System" and
    "Enterprise".

    Attributes:
        scheduled_report_table (List(scheduledReportTable)): scheduledReportTable -
            *Table* array of scheduledReportTable named tuples
    """

    __slots__: List[str] = [
        "scheduled_report_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "scheduled_report_table",
                "scheduledReportTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(OCIResponse):
    """
    Response to
    `EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()`
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Level" are "System" and "Enterprise".

    Attributes:
        scheduled_report_table (List(scheduledReportTable)): scheduledReportTable -
            *Table* array of scheduledReportTable named tuples
    """

    __slots__: List[str] = [
        "scheduled_report_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "scheduled_report_table",
                "scheduledReportTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to `EnterpriseCallCenterEnhancedReportingScheduledReportGetListRequest()`.

    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Status", "Report Template Name", "Report Template Level" and
    "Recurring". The "Created By" can be either "Administrator" or user id if created by
    supervisor.  The possible values for "Status" are "Active", and "Completed". The
    possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Level" are "System" and "Enterprise".

    Attributes:
        scheduled_report_table (List(scheduledReportTable)): scheduledReportTable -
            *Table* array of scheduledReportTable named tuples
    """

    __slots__: List[str] = [
        "scheduled_report_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "scheduled_report_table",
                "scheduledReportTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(OCIResponse):
    """
    Response to
    `EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()`.

    Contains a table with column headings: "Schedule Name", "Created By", "Created By
    Supervisor", and "Is Active". The "Created By" can be either "Administrator" or user
    id if created by supervisor.

    Attributes:
        schedule_report_table (List(scheduleReportTable)): scheduleReportTable - *Table*
            array of scheduleReportTable named tuples
    """

    __slots__: List[str] = [
        "schedule_report_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "schedule_report_table",
                "scheduleReportTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterGetResponse(OCIResponse):
    """
    Response to `EnterpriseCallCenterGetRequest()`.

    Replaced by `EnterpriseCallCenterGetResponse17sp4()`.

    Attributes:
        use_system_default_guard_timer (bool): useSystemDefaultGuardTimer
        enable_guard_timer (bool): enableGuardTimer
        guard_timer_seconds (int): guardTimerSeconds
        use_system_default_unavailable_settings (bool):
            useSystemDefaultUnavailableSettings *Optional*
        force_agent_unavailable_on_dnd_activation (bool):
            forceAgentUnavailableOnDNDActivation *Optional*
        force_agent_unavailable_on_personal_calls (bool):
            forceAgentUnavailableOnPersonalCalls *Optional*
        force_agent_unavailable_on_bounced_call_limit (bool):
            forceAgentUnavailableOnBouncedCallLimit *Optional*
        number_consecutive_bounced_calls_to_force_agent_unavailable (int):
            numberConsecutiveBouncedCallsToForceAgentUnavailable *Optional*
    """

    __slots__: List[str] = [
        "use_system_default_guard_timer",
        "enable_guard_timer",
        "guard_timer_seconds",
        "use_system_default_unavailable_settings",
        "force_agent_unavailable_on_dnd_activation",
        "force_agent_unavailable_on_personal_calls",
        "force_agent_unavailable_on_bounced_call_limit",
        "number_consecutive_bounced_calls_to_force_agent_unavailable",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_system_default_guard_timer",
                "useSystemDefaultGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "enable_guard_timer",
                "enableGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "guard_timer_seconds",
                "guardTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "use_system_default_unavailable_settings",
                "useSystemDefaultUnavailableSettings",
                bool,
            ),
            E(
                "force_agent_unavailable_on_dnd_activation",
                "forceAgentUnavailableOnDNDActivation",
                bool,
            ),
            E(
                "force_agent_unavailable_on_personal_calls",
                "forceAgentUnavailableOnPersonalCalls",
                bool,
            ),
            E(
                "force_agent_unavailable_on_bounced_call_limit",
                "forceAgentUnavailableOnBouncedCallLimit",
                bool,
            ),
            E(
                "number_consecutive_bounced_calls_to_force_agent_unavailable",
                "numberConsecutiveBouncedCallsToForceAgentUnavailable",
                int,
            ),
        )


class EnterpriseCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to `EnterpriseCallCenterGetRequest17sp4()`.

    The following elements are only used in AS data mode and not returned in XS data mode:
    useSystemDefaultUnavailableSettings forceAgentUnavailableOnDNDActivation
    forceAgentUnavailableOnPersonalCalls forceAgentUnavailableOnBouncedCallLimit
    numberConsecutiveBouncedCallsToForceAgentUnavailable
    forceAgentUnavailableOnNotReachable Replaced by: `EnterpriseCallCenterGetResponse23()`
    in AS data mode

    Attributes:
        use_system_default_guard_timer (bool): useSystemDefaultGuardTimer
        enable_guard_timer (bool): enableGuardTimer
        guard_timer_seconds (int): guardTimerSeconds
        use_system_default_unavailable_settings (bool):
            useSystemDefaultUnavailableSettings *Optional*
        force_agent_unavailable_on_dnd_activation (bool):
            forceAgentUnavailableOnDNDActivation *Optional*
        force_agent_unavailable_on_personal_calls (bool):
            forceAgentUnavailableOnPersonalCalls *Optional*
        force_agent_unavailable_on_bounced_call_limit (bool):
            forceAgentUnavailableOnBouncedCallLimit *Optional*
        number_consecutive_bounced_calls_to_force_agent_unavailable (int):
            numberConsecutiveBouncedCallsToForceAgentUnavailable *Optional*
        force_agent_unavailable_on_not_reachable (bool):
            forceAgentUnavailableOnNotReachable *Optional*
    """

    __slots__: List[str] = [
        "use_system_default_guard_timer",
        "enable_guard_timer",
        "guard_timer_seconds",
        "use_system_default_unavailable_settings",
        "force_agent_unavailable_on_dnd_activation",
        "force_agent_unavailable_on_personal_calls",
        "force_agent_unavailable_on_bounced_call_limit",
        "number_consecutive_bounced_calls_to_force_agent_unavailable",
        "force_agent_unavailable_on_not_reachable",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_system_default_guard_timer",
                "useSystemDefaultGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "enable_guard_timer",
                "enableGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "guard_timer_seconds",
                "guardTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "use_system_default_unavailable_settings",
                "useSystemDefaultUnavailableSettings",
                bool,
            ),
            E(
                "force_agent_unavailable_on_dnd_activation",
                "forceAgentUnavailableOnDNDActivation",
                bool,
            ),
            E(
                "force_agent_unavailable_on_personal_calls",
                "forceAgentUnavailableOnPersonalCalls",
                bool,
            ),
            E(
                "force_agent_unavailable_on_bounced_call_limit",
                "forceAgentUnavailableOnBouncedCallLimit",
                bool,
            ),
            E(
                "number_consecutive_bounced_calls_to_force_agent_unavailable",
                "numberConsecutiveBouncedCallsToForceAgentUnavailable",
                int,
            ),
            E(
                "force_agent_unavailable_on_not_reachable",
                "forceAgentUnavailableOnNotReachable",
                bool,
            ),
        )


class EnterpriseCallCenterGetResponse23(OCIResponse):
    """
    Response to `EnterpriseCallCenterGetRequest23()`.

    The following elements are only used in AS data mode and not returned in XS data mode:
    useSystemDefaultUnavailableSettings forceAgentUnavailableOnDNDActivation
    forceAgentUnavailableOnPersonalCalls forceAgentUnavailableOnBouncedCallLimit
    numberConsecutiveBouncedCallsToForceAgentUnavailable
    forceAgentUnavailableOnNotReachable wrapUpDestination

    Attributes:
        use_system_default_guard_timer (bool): useSystemDefaultGuardTimer
        enable_guard_timer (bool): enableGuardTimer
        guard_timer_seconds (int): guardTimerSeconds
        use_system_default_unavailable_settings (bool):
            useSystemDefaultUnavailableSettings *Optional*
        force_agent_unavailable_on_dnd_activation (bool):
            forceAgentUnavailableOnDNDActivation *Optional*
        force_agent_unavailable_on_personal_calls (bool):
            forceAgentUnavailableOnPersonalCalls *Optional*
        force_agent_unavailable_on_bounced_call_limit (bool):
            forceAgentUnavailableOnBouncedCallLimit *Optional*
        number_consecutive_bounced_calls_to_force_agent_unavailable (int):
            numberConsecutiveBouncedCallsToForceAgentUnavailable *Optional*
        force_agent_unavailable_on_not_reachable (bool):
            forceAgentUnavailableOnNotReachable *Optional*
        wrap_up_destination (str): wrapUpDestination *Optional*
    """

    __slots__: List[str] = [
        "use_system_default_guard_timer",
        "enable_guard_timer",
        "guard_timer_seconds",
        "use_system_default_unavailable_settings",
        "force_agent_unavailable_on_dnd_activation",
        "force_agent_unavailable_on_personal_calls",
        "force_agent_unavailable_on_bounced_call_limit",
        "number_consecutive_bounced_calls_to_force_agent_unavailable",
        "force_agent_unavailable_on_not_reachable",
        "wrap_up_destination",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_system_default_guard_timer",
                "useSystemDefaultGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "enable_guard_timer",
                "enableGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "guard_timer_seconds",
                "guardTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "use_system_default_unavailable_settings",
                "useSystemDefaultUnavailableSettings",
                bool,
            ),
            E(
                "force_agent_unavailable_on_dnd_activation",
                "forceAgentUnavailableOnDNDActivation",
                bool,
            ),
            E(
                "force_agent_unavailable_on_personal_calls",
                "forceAgentUnavailableOnPersonalCalls",
                bool,
            ),
            E(
                "force_agent_unavailable_on_bounced_call_limit",
                "forceAgentUnavailableOnBouncedCallLimit",
                bool,
            ),
            E(
                "number_consecutive_bounced_calls_to_force_agent_unavailable",
                "numberConsecutiveBouncedCallsToForceAgentUnavailable",
                int,
            ),
            E(
                "force_agent_unavailable_on_not_reachable",
                "forceAgentUnavailableOnNotReachable",
                bool,
            ),
            E(
                "wrap_up_destination",
                "wrapUpDestination",
                str,
            ),
        )


class EnterpriseCallCenterGetRoutingPolicyResponse(OCIResponse):
    """
    Response to `EnterpriseCallCenterGetRoutingPolicyRequest()`.

    Contains a table with column headings: "Service User Id", "Name" and "Priority".

    Attributes:
        routing_policy (str): routingPolicy
        call_center_table (List(callCenterTable)): callCenterTable - *Table* array of
            callCenterTable named tuples
    """

    __slots__: List[str] = [
        "routing_policy",
        "call_center_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "routing_policy",
                "routingPolicy",
                str,
                is_required=True,
            ),
            E(
                "call_center_table",
                "callCenterTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseCallCenterMonitoringGetResponse(OCIResponse):
    """
    Response to `EnterpriseCallCenterMonitoringGetRequest()`.


    Attributes:
        enable_supervisor_coaching (bool): enableSupervisorCoaching
    """

    __slots__: List[str] = [
        "enable_supervisor_coaching",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_supervisor_coaching",
                "enableSupervisorCoaching",
                bool,
                is_required=True,
            ),
        )


class EnterpriseCallCenterMonitoringGetResponse23(OCIResponse):
    """
    Response to `EnterpriseCallCenterMonitoringGetRequest23()`.


    Attributes:
        enable_supervisor_coaching (bool): enableSupervisorCoaching
        bypass_enforcement_of_supervisor_agent_relationship (bool):
            bypassEnforcementOfSupervisorAgentRelationship *Optional*
    """

    __slots__: List[str] = [
        "enable_supervisor_coaching",
        "bypass_enforcement_of_supervisor_agent_relationship",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_supervisor_coaching",
                "enableSupervisorCoaching",
                bool,
                is_required=True,
            ),
            E(
                "bypass_enforcement_of_supervisor_agent_relationship",
                "bypassEnforcementOfSupervisorAgentRelationship",
                bool,
            ),
        )


class EnterpriseCallRecordingGetResponse(OCIResponse):
    """
    Response to the `EnterpriseCallRecordingGetRequest()`.

    The response contains the enterprise's Call Recording attributes.

    Attributes:
        use_cloud_pbx (bool): useCloudPBX
        use_enterprise_setting (bool): useEnterpriseSetting *Optional*
        fqdn (str): FQDN *Optional*
    """

    __slots__: List[str] = [
        "use_cloud_pbx",
        "use_enterprise_setting",
        "fqdn",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_cloud_pbx",
                "useCloudPBX",
                bool,
                is_required=True,
            ),
            E(
                "use_enterprise_setting",
                "useEnterpriseSetting",
                bool,
            ),
            E(
                "fqdn",
                "FQDN",
                str,
            ),
        )


class EnterpriseCommunicationBarringAuthorizationCodeGetResponse(OCIResponse):
    """
    Response to `EntepriseCommunicationBarringAuthorizationCodeGetRequest()`.


    Attributes:
        description (str): description *Optional*
        network_class_of_service (str): networkClassOfService *Optional*
    """

    __slots__: List[str] = [
        "description",
        "network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
            ),
        )


class EnterpriseEnterpriseTrunkGetAvailableUserListResponse(OCIResponse):
    """
    Response to `EnterpriseEnterpriseTrunkGetAvailableUserListRequest()`.

    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number",
    "Extension", "Department", "Email Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseEnterpriseTrunkGetListResponse(OCIResponse):
    """
    Response to `EnterpriseEnterpriseTrunkGetListRequest()`.

    Contains a table of enterprise trunks defined in the enterprise The column headings
    are: "Enterprise Trunk Name", "Routing Type"

    Attributes:
        enterprise_trunk_table (List(enterpriseTrunkTable)): enterpriseTrunkTable -
            *Table* array of enterpriseTrunkTable named tuples
    """

    __slots__: List[str] = [
        "enterprise_trunk_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enterprise_trunk_table",
                "enterpriseTrunkTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseEnterpriseTrunkGetResponse(OCIResponse):
    """
    Response to `EnterpriseEnterpriseTrunkGetRequest()`.

    Replaced by: `EnterpriseEnterpriseTrunkGetResponse21()`.

    Attributes:
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
    """

    __slots__: List[str] = [
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        OCI.EnterpriseTrunkTrunkGroupKey,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class EnterpriseEnterpriseTrunkGetResponse21(OCIResponse):
    """
    Response to `EnterpriseEnterpriseTrunkGetRequest21()`.


    Attributes:
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
        enable_capacity_management (bool): enableCapacityManagement
        max_active_calls (int): maxActiveCalls *Optional*
        capacity_exceeded_trap_initial_calls (int): capacityExceededTrapInitialCalls
            *Optional*
        capacity_exceeded_trap_offset_calls (int): capacityExceededTrapOffsetCalls
            *Optional*
    """

    __slots__: List[str] = [
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
        "enable_capacity_management",
        "max_active_calls",
        "capacity_exceeded_trap_initial_calls",
        "capacity_exceeded_trap_offset_calls",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        OCI.EnterpriseTrunkTrunkGroupKey,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "enable_capacity_management",
                "enableCapacityManagement",
                bool,
                is_required=True,
            ),
            E(
                "max_active_calls",
                "maxActiveCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_initial_calls",
                "capacityExceededTrapInitialCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_offset_calls",
                "capacityExceededTrapOffsetCalls",
                int,
            ),
        )


class EnterpriseEnterpriseTrunkGetResponse22(OCIResponse):
    """
    Response to `EnterpriseEnterpriseTrunkGetRequest22()`.


    Attributes:
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
        enable_capacity_management (bool): enableCapacityManagement
        max_active_calls (int): maxActiveCalls *Optional*
        capacity_exceeded_trap_initial_calls (int): capacityExceededTrapInitialCalls
            *Optional*
        capacity_exceeded_trap_offset_calls (int): capacityExceededTrapOffsetCalls
            *Optional*
        maximum_active_incoming_calls_allowed (int): maximumActiveIncomingCallsAllowed
            *Optional*
        maximum_active_outgoing_calls_allowed (int): maximumActiveOutgoingCallsAllowed
            *Optional*
        minimum_active_calls_reserved (int): minimumActiveCallsReserved *Optional*
    """

    __slots__: List[str] = [
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
        "enable_capacity_management",
        "max_active_calls",
        "capacity_exceeded_trap_initial_calls",
        "capacity_exceeded_trap_offset_calls",
        "maximum_active_incoming_calls_allowed",
        "maximum_active_outgoing_calls_allowed",
        "minimum_active_calls_reserved",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        OCI.EnterpriseTrunkTrunkGroupKey,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "enable_capacity_management",
                "enableCapacityManagement",
                bool,
                is_required=True,
            ),
            E(
                "max_active_calls",
                "maxActiveCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_initial_calls",
                "capacityExceededTrapInitialCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_offset_calls",
                "capacityExceededTrapOffsetCalls",
                int,
            ),
            E(
                "maximum_active_incoming_calls_allowed",
                "maximumActiveIncomingCallsAllowed",
                int,
            ),
            E(
                "maximum_active_outgoing_calls_allowed",
                "maximumActiveOutgoingCallsAllowed",
                int,
            ),
            E(
                "minimum_active_calls_reserved",
                "minimumActiveCallsReserved",
                int,
            ),
        )


class EnterpriseEnterpriseTrunkGetUserListResponse(OCIResponse):
    """
    Response to `EnterpriseEnterpriseTrunkGetUserListRequest()`.

    The column headings for the enterpriseTrunkUserTable are: "Group Id", "User Id", "Last
    Name", "First Name", "Phone Number", "Alternate Trunk Identity", "Hiragana Last Name",
    "Hiragana First Name", "Extension", "Department", "Email Address" and "Route List
    Assigned".

    Attributes:
        enterprise_trunk_user_table (List(enterpriseTrunkUserTable)):
            enterpriseTrunkUserTable - *Table* array of enterpriseTrunkUserTable named
            tuples
    """

    __slots__: List[str] = [
        "enterprise_trunk_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enterprise_trunk_user_table",
                "enterpriseTrunkUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseLocalGatewayGetPagedSortedListResponse(OCIResponse):
    """
    Response to `EnterpriseLocalGatewayGetPagedSortedListRequest()`.

    Contains a table with column headings "Name", "Device Name", "Device Level", "Group
    Id", "Group Name" and "Group External Id". The "Device Level" column contains one of
    the AccessDeviceLevel enumerated constants.  The following columns are only populated
    in AS data mode "Group External Id"

    Attributes:
        local_gateway_table (List(localGatewayTable)): localGatewayTable - *Table* array
            of localGatewayTable named tuples
    """

    __slots__: List[str] = [
        "local_gateway_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "local_gateway_table",
                "localGatewayTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseLocalGatewayGetUsageResponse(OCIResponse):
    """
    Response to `EnterpriseLocalGatewayGetUsageRequest()`.

    Returns the group ID and group name where the local gateway belongs to, a boolean
    value to indicate if the local gateway is used in the enterprise call processing
    policy.  It also returns an OCITable containing the groups using the given local
    gateway.  Column headings are: "Group Id", "Group Name" and "Group External Id". The
    following columns are only populated in AS data mode "Group External Id"

    Attributes:
        gateway_group_id (str): gatewayGroupId
        gateway_group_name (str): gatewayGroupName *Optional*
        used_by_enterprise (bool): usedByEnterprise
        group_table (List(groupTable)): groupTable - *Table* array of groupTable named
            tuples
    """

    __slots__: List[str] = [
        "gateway_group_id",
        "gateway_group_name",
        "used_by_enterprise",
        "group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "gateway_group_id",
                "gatewayGroupId",
                str,
                is_required=True,
            ),
            E(
                "gateway_group_name",
                "gatewayGroupName",
                str,
            ),
            E(
                "used_by_enterprise",
                "usedByEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "group_table",
                "groupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterprisePhoneDirectoryGetListResponse(OCIResponse):
    """
    Response to `EnterprisePhoneDirectoryGetListRequest()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id". If extended directory information is requested, the following
    columns are also included: "First Name", "Last Name", "User Id", "Pager", "Title",
    "Time Zone", "Location", "Address Line 1", "Address Line 2", "City", "State", "Zip",
    "Country". Replace by: `EnterprisePhoneDirectoryGetListResponse17()`

    Attributes:
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterprisePhoneDirectoryGetListResponse17(OCIResponse):
    """
    Response to `EnterprisePhoneDirectoryGetListRequest17()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "Is Virtual On-Net User". If extended directory information is
    requested, the following columns are also included: "First Name", "Last Name", "User
    Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country". Replaced by:
    `EnterprisePhoneDirectoryGetListResponse18()`

    Attributes:
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterprisePhoneDirectoryGetListResponse17sp3(OCIResponse):
    """
    Response to `EnterprisePhoneDirectoryGetListRequest17sp3()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "IMP Id", "Is Virtual On-Net User". If extended directory
    information is requested, the following columns are also included: "First Name", "Last
    Name", "User Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country". Replaced by:
    `EnterprisePhoneDirectoryGetListResponse18()`

    Attributes:
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterprisePhoneDirectoryGetListResponse18(OCIResponse):
    """
    Response to `EnterprisePhoneDirectoryGetListRequest18()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id", "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country", "Service Name". The Service Name
    represents the localized service name for service instances.  The localized values are
    taken from the BroadworksLabel.properties file.  Service Name is currently supporting:
    AutoAttendant, AutoAttendantStandard, AutoAttendantVideo, CallCenter,
    CallCenterStandard, CallCenterPremium HuntGroup, InstantGroupCall,
    VoiceMessagingGroup, RoutePoint, BroadWorksAnywhere, GroupPaging, FindmeFollowme,
    VoiceXML, FlexibleSeatingGuest, CollaborateAudio, MeetMeConferencing.  For a Regular
    User or a Virtual On Network Enterprise Extensions, the Service Name is empty.  The
    following columns are returned in AS data mode only: "Service Name"

    Replaced By: `EnterprisePhoneDirectoryGetPagedSortedListResponse()`

    Attributes:
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterprisePhoneDirectoryGetPagedListResponse(OCIResponse):
    """
    Response to `EnterprisePhoneDirectoryGetPagedListRequest()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id", "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country", "Service Name". The Service Name
    represents the localized service name for service instances.  The localized values are
    taken from the BroadworksLabel.properties file.  Service Name is currently supporting:
    AutoAttendant, AutoAttendantStandard, AutoAttendantVideo, CallCenter,
    CallCenterStandard, CallCenterPremium HuntGroup, InstantGroupCall,
    VoiceMessagingGroup, RoutePoint, BroadWorksAnywhere, GroupPaging, FindmeFollowme,
    VoiceXML, FlexibleSeatingGuest, CollaborateAudio, MeetMeConferencing.  For a Regular
    User or a Virtual On Network Enterprise Extensions, the Service Name is empty.  The
    following columns are returned in AS data mode only: "Service Name"

    Replaced By: `EnterprisePhoneDirectoryGetPagedSortedListResponse()`

    Attributes:
        total_number_of_rows (int): totalNumberOfRows
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "total_number_of_rows",
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_number_of_rows",
                "totalNumberOfRows",
                int,
                is_required=True,
            ),
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterprisePhoneDirectoryGetPagedSortedListResponse(OCIResponse):
    """
    Response to `EnterprisePhoneDirectoryGetPagedSortedListRequest()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id", "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country", "Service Name". The Service Name
    represents the localized service name for service instances.  The localized values are
    taken from the BroadworksLabel.properties file.  Service Name is currently supporting:
    AutoAttendant, AutoAttendantStandard, AutoAttendantVideo, CallCenter,
    CallCenterStandard, CallCenterPremium HuntGroup, InstantGroupCall,
    VoiceMessagingGroup, RoutePoint, BroadWorksAnywhere, GroupPaging, FindmeFollowme,
    VoiceXML, FlexibleSeatingGuest, CollaborateAudio, MeetMeConferencing.  For a Regular
    User or a Virtual On Network Enterprise Extensions, the Service Name is empty.  The
    following columns are populated in AS data mode only: "IMP Id"

    Attributes:
        total_number_of_rows (int): totalNumberOfRows
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "total_number_of_rows",
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_number_of_rows",
                "totalNumberOfRows",
                int,
                is_required=True,
            ),
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterprisePreAlertingAnnouncementGetResponse(OCIResponse):
    """
    Get the Enterprise level pre-alerting service settings.

    The response is either a `EnterprisePreAlertingAnnouncementGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        announcement_interruption (str): announcementInterruption
        interruption_digit_sequence (str): interruptionDigitSequence *Optional*
        audio_selection (str): audioSelection
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        audio_file_url (str): audioFileUrl *Optional*
        video_selection (str): videoSelection
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
        video_file_url (str): videoFileUrl *Optional*
    """

    __slots__: List[str] = [
        "announcement_interruption",
        "interruption_digit_sequence",
        "audio_selection",
        "audio_file_description",
        "audio_media_type",
        "audio_file_url",
        "video_selection",
        "video_file_description",
        "video_media_type",
        "video_file_url",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "announcement_interruption",
                "announcementInterruption",
                str,
                is_required=True,
            ),
            E(
                "interruption_digit_sequence",
                "interruptionDigitSequence",
                str,
            ),
            E(
                "audio_selection",
                "audioSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "video_selection",
                "videoSelection",
                str,
                is_required=True,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
        )


class EnterpriseRouteListEnterpriseTrunkNumberPrefixGetAvailableListResponse(OCIResponse):
    """
    Response to `EnterpriseRouteListEnterpriseTrunkNumberPrefixGetAvailableListRequest()`.

    Contains a list of number prefixes that are assigned to an enterprise and still
    available for assignment to users within the enterprise.  The column headings are
    "Number Prefix" ","Is Active", "Extension Range Start" and "Extension Range End".

    Attributes:
        available_number_prefix_table (List(availableNumberPrefixTable)):
            availableNumberPrefixTable - *Table* array of availableNumberPrefixTable named
            tuples
    """

    __slots__: List[str] = [
        "available_number_prefix_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_number_prefix_table",
                "availableNumberPrefixTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseRouteListEnterpriseTrunkNumberPrefixGetSummaryListResponse(OCIResponse):
    """
    Response to `EnterpriseRouteListEnterpriseTrunkNumberPrefixGetSummaryListRequest()`.

    The response contains a table with columns: "Number Prefix", "Group Id", "User Id",
    "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone
    Number", "Extension", "Department", "Email Address", "Enterprise Trunk"","Is Active",
    "Extension Range Start" and "Extension Range End". The "User Id", "Last Name", "First
    Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension",
    "Department" and "Email Address" columns contains the corresponding attributes of the
    user possessing the number range.  The "Enterprise Trunk" column contains the
    enterprise trunk the user possessing the number range belongs to.  The "Is Active"
    column indicates if the number range has been activated.  The "Extension Range Start"
    column indicates the start for an extension range.  The "Extension Range End" column
    indicates the end for an extension range.

    Attributes:
        prefix_summary_table (List(prefixSummaryTable)): prefixSummaryTable - *Table*
            array of prefixSummaryTable named tuples
    """

    __slots__: List[str] = [
        "prefix_summary_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "prefix_summary_table",
                "prefixSummaryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(OCIResponse):
    """
    Response to `EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()`.

    Contains a list of number ranges that are assigned to an enterprise and still
    available for assignment to users within the enterprise.  The column headings are
    "Number Range Start", "Number Range End" ,"Is Active" and "Extension Length"..

    Attributes:
        available_number_range_table (List(availableNumberRangeTable)):
            availableNumberRangeTable - *Table* array of availableNumberRangeTable named
            tuples
    """

    __slots__: List[str] = [
        "available_number_range_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_number_range_table",
                "availableNumberRangeTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to `EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()`.

    The response contains a table with columns: "Number Range Start", "Number Range End",
    "Group Id", "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name", "Phone Number", "Extension", "Department", "Email Address", "Enterprise
    Trunk", "Is Active" and "Extension Length". The "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department"
    and "Email Address" columns contains the corresponding attributes of the user
    possessing the number range.  The "Enterprise Trunk" column contains the enterprise
    trunk the user possessing the number range belongs to.  The "Is Active" column
    indicates if the number range has been activated.  The "Extension Length" column
    indicates the length of the extension for the enterpris trunk number range.

    Attributes:
        number_range_summary_table (List(numberRangeSummaryTable)):
            numberRangeSummaryTable - *Table* array of numberRangeSummaryTable named
            tuples
    """

    __slots__: List[str] = [
        "number_range_summary_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number_range_summary_table",
                "numberRangeSummaryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseSecurityClassificationCustomizationGetAvailableListResponse(OCIResponse):
    """
    Response to `EnterpriseSecurityClassificationCustomizationGetAvailableListRequest()`.

    Returns the available group security classifications.  Contains a table with column
    headings: "SystemSecurityClassification", "CustomizedSecurityClassification"

    Attributes:
        security_classification_name_table (List(securityClassificationNameTable)):
            securityClassificationNameTable - *Table* array of
            securityClassificationNameTable named tuples
    """

    __slots__: List[str] = [
        "security_classification_name_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "security_classification_name_table",
                "securityClassificationNameTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseSessionAdmissionControlGroupGetListResponse(OCIResponse):
    """
    Response to `EnterpriseSessionAdmissionControlGroupGetListRequest()`.

    Contains a table of session admission control group configured in the enterprise.  The
    column headings are: "Name", "Is Default", "Maximum Sessions", "Maximum Originating
    Sessions", "Maximum Terminating Sessions"..

    Attributes:
        session_admission_control_group_table (List(sessionAdmissionControlGroupTable)):
            sessionAdmissionControlGroupTable - *Table* array of
            sessionAdmissionControlGroupTable named tuples
    """

    __slots__: List[str] = [
        "session_admission_control_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "session_admission_control_group_table",
                "sessionAdmissionControlGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseUserCallForwardingSettingsGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseUserCallForwardingSettingsGetListRequest()`.

    Contains a table with column headings: "Group Id", "User Id", "Last Name", "First
    Name", "Hiragana Last Name", and "Hiragana First Name", "Phone Number", "Extension",
    "Department", "In Trunk Group", "Email Address", "Is Active", "Forwarding Address".
    "Is Active" is "true" or "false". The "Forwarding Address" is the Call Forwarding
    service's forwarding address.  If the service is Call Forwarding Selective, the
    default forwarding address is returned.  "Phone Number" field is presented in the E164
    format.

    Attributes:
        user_call_forwarding_table (List(userCallForwardingTable)):
            userCallForwardingTable - *Table* array of userCallForwardingTable named
            tuples
    """

    __slots__: List[str] = [
        "user_call_forwarding_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_call_forwarding_table",
                "userCallForwardingTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseUserCallWaitingSettingsGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseUserCallWaitingSettingsGetListRequest()`.

    Contains a table with column headings: "Group Id", "User Id", "Last Name", "First
    Name", "Hiragana Last Name", and "Hiragana First Name", "Phone Number", "Extension",
    "Department", "In Trunk Group", "Email Address", "Is Active". "Is Active" is "true" or
    "false". "Phone Number" is presented in the E164 format.

    Attributes:
        user_call_waiting_table (List(userCallWaitingTable)): userCallWaitingTable -
            *Table* array of userCallWaitingTable named tuples
    """

    __slots__: List[str] = [
        "user_call_waiting_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_call_waiting_table",
                "userCallWaitingTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseUserCallingPlanSettingsGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseUserCallingPlanSettingsGetListRequest()`.

    Contains a table with column headings: "Group Id", "User Id", "Last Name", "First
    Name", "Hiragana Last Name", and "Hiragana First Name", "Phone Number", "Extension",
    "Department", "In Trunk Group", "Email Address", "Use Custom Settings". "Use Custom
    Settings" is "true" or "false". "Phone Number" is presented in the E164 format.

    Attributes:
        user_calling_plan_table (List(userCallingPlanTable)): userCallingPlanTable -
            *Table* array of userCallingPlanTable named tuples
    """

    __slots__: List[str] = [
        "user_calling_plan_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_calling_plan_table",
                "userCallingPlanTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseUserHotelingGuestSettingsGetListResponse(OCIResponse):
    """
    Response to the `EnterpriseUserHotelingGuestSettingsGetListRequest()`.

    Contains a table with column headings: "Group Id", "User Id", "Last Name", "First
    Name", "Hiragana Last Name", and "Hiragana First Name", "Phone Number", "Extension",
    "Department", "In Trunk Group", "Email Address", "Is Active". "Is Active" is "true" or
    "false". "Phone Number" is presented in the E164 format.

    Attributes:
        user_hoteling_guest_table (List(userHotelingGuestTable)): userHotelingGuestTable -
            *Table* array of userHotelingGuestTable named tuples
    """

    __slots__: List[str] = [
        "user_hoteling_guest_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_hoteling_guest_table",
                "userHotelingGuestTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListResponse(OCIResponse):
    """
    Response to `EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListRequest()`.

    Contains a table with column headings : "Group Id", "Last Name", "First Name", "Phone
    Number", "Extension", "Virtual On-Net Call Type" in a row for each user.

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseVoiceVPNGetPolicyListResponse(OCIResponse):
    """
    Response to `EnterpriseVoiceVPNGetListResponse()`.

    Returns a 4 column table with column headings: "Location Code", "Min Extension
    Length", "Max Extension Length", "Location Selection".

    Attributes:
        location_list (List(locationList)): locationList - *Table* array of locationList
            named tuples
    """

    __slots__: List[str] = [
        "location_list",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "location_list",
                "locationList",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class EnterpriseVoiceVPNGetResponse(OCIResponse):
    """
    Response to `EnterpriseVoiceVPNGetRequest()`.

    Replaced By: `EnterpriseVoiceVPNGetResponse14sp3()`

    Attributes:
        is_active (bool): isActive
        default_selection (str): defaultSelection
        e164_selection (str): e164Selection
    """

    __slots__: List[str] = [
        "is_active",
        "default_selection",
        "e164_selection",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "default_selection",
                "defaultSelection",
                str,
                is_required=True,
            ),
            E(
                "e164_selection",
                "e164Selection",
                str,
                is_required=True,
            ),
        )


class EnterpriseVoiceVPNGetResponse14sp3(OCIResponse):
    """
    Response to `EnterpriseVoiceVPNGetRequest14sp3()`.


    Attributes:
        is_active (bool): isActive
        default_selection (str): defaultSelection
        e164_selection (str): e164Selection
        use_phone_context (bool): usePhoneContext
    """

    __slots__: List[str] = [
        "is_active",
        "default_selection",
        "e164_selection",
        "use_phone_context",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "default_selection",
                "defaultSelection",
                str,
                is_required=True,
            ),
            E(
                "e164_selection",
                "e164Selection",
                str,
                is_required=True,
            ),
            E(
                "use_phone_context",
                "usePhoneContext",
                bool,
                is_required=True,
            ),
        )


class ExternalAuthenticationCreateLoginTokenResponse(OCIResponse):
    """
    Response to `ExternalAuthenticationCreateLoginTokenRequest()`.


    Attributes:
        login_token (str): loginToken
    """

    __slots__: List[str] = [
        "login_token",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_token",
                "loginToken",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceAvailablePortGetListResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceAvailablePortGetListRequest()`.

    Contains a list of available ports in a device using static mode.  The list is empty
    in case the device is using dynamic mode.

    Attributes:
        port_number (List[int]): portNumber *Optional*
    """

    __slots__: List[str] = [
        "port_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "port_number",
                "portNumber",
                int,
                is_array=True,
            ),
        )


class GroupAccessDeviceCustomTagGetListResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceCustomTagGetListRequest()`.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device profile basis.  In AS data mode, the column headings are: "Tag Name",
    "Tag Value", "Actual Tag Value". In XS data mode, the column headings are: "Tag Name",
    "Tag Value", "Actual Tag Value" if request is invoked by an admin without system
    privileges.  "Tag Name", "Tag Value", "Is Encrypted", "Actual Tag Value" if request is
    invoked by an admin with system privileges.

    Attributes:
        device_custom_tags_table (List(deviceCustomTagsTable)): deviceCustomTagsTable -
            *Table* array of deviceCustomTagsTable named tuples
    """

    __slots__: List[str] = [
        "device_custom_tags_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_custom_tags_table",
                "deviceCustomTagsTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceDeviceActivationGetResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceDeviceActivationGetRequest()`.

    The response contains the activation code (if available), the expiry time (if
    available) and the activation state.  The expiryTime is represented as a timestamp,
    i.e.  the number of milliseconds since January 1, 1970, 00:00:00 GMT.

    Attributes:
        activation_code (str): activationCode *Optional*
        expiry_time (int): expiryTime *Optional*
        activation_state (str): activationState
    """

    __slots__: List[str] = [
        "activation_code",
        "expiry_time",
        "activation_state",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "activation_code",
                "activationCode",
                str,
            ),
            E(
                "expiry_time",
                "expiryTime",
                int,
            ),
            E(
                "activation_state",
                "activationState",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceFileGetListResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceFileGetListRequest()`.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: `GroupAccessDeviceFileGetListResponse14sp8()`

    Attributes:
        device_files_table (List(deviceFilesTable)): deviceFilesTable - *Table* array of
            deviceFilesTable named tuples
    """

    __slots__: List[str] = [
        "device_files_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_files_table",
                "deviceFilesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceFileGetListResponse14sp8(OCIResponse):
    """
    Response to `GroupAccessDeviceFileGetListRequest14sp8()`.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Format", "Is Authenticated",
    "Access URL", "Repository URL", "Template URL", "Extended Capture URL", "Is File
    Linked". The following column is only populated in AS data mode for leaf devices.  "Is
    File Linked"

    Attributes:
        device_files_table (List(deviceFilesTable)): deviceFilesTable - *Table* array of
            deviceFilesTable named tuples
    """

    __slots__: List[str] = [
        "device_files_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_files_table",
                "deviceFilesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceFileGetResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceFileGetRequest()`.

    Replaced By: `GroupAccessDeviceFileGetResponse14sp8()`

    Attributes:
        file_source (str): fileSource
        configuration_file_name (str): configurationFileName *Optional*
    """

    __slots__: List[str] = [
        "file_source",
        "configuration_file_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_source",
                "fileSource",
                str,
                is_required=True,
            ),
            E(
                "configuration_file_name",
                "configurationFileName",
                str,
            ),
        )


class GroupAccessDeviceFileGetResponse14sp8(OCIResponse):
    """
    Response to `GroupAccessDeviceFileGetRequest14sp8()`.

    Replaced by: `GroupAccessDeviceFileGetResponse16sp1()`

    Attributes:
        file_source (str): fileSource
        configuration_file_name (str): configurationFileName *Optional*
    """

    __slots__: List[str] = [
        "file_source",
        "configuration_file_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_source",
                "fileSource",
                str,
                is_required=True,
            ),
            E(
                "configuration_file_name",
                "configurationFileName",
                str,
            ),
        )


class GroupAccessDeviceFileGetResponse16sp1(OCIResponse):
    """
    Response to `GroupAccessDeviceFileGetRequest16sp1()`.

    Replaced by: `GroupAccessDeviceFileGetResponse20()`

    Attributes:
        file_source (str): fileSource
        configuration_file_name (str): configurationFileName *Optional*
        access_url (str): accessUrl
        repository_url (str): repositoryUrl *Optional*
        template_url (str): templateUrl *Optional*
    """

    __slots__: List[str] = [
        "file_source",
        "configuration_file_name",
        "access_url",
        "repository_url",
        "template_url",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_source",
                "fileSource",
                str,
                is_required=True,
            ),
            E(
                "configuration_file_name",
                "configurationFileName",
                str,
            ),
            E(
                "access_url",
                "accessUrl",
                str,
                is_required=True,
            ),
            E(
                "repository_url",
                "repositoryUrl",
                str,
            ),
            E(
                "template_url",
                "templateUrl",
                str,
            ),
        )


class GroupAccessDeviceFileGetResponse20(OCIResponse):
    """
    Response to `GroupAccessDeviceFileGetRequest20()`.


    Attributes:
        file_source (str): fileSource
        configuration_file_name (str): configurationFileName *Optional*
        access_url (str): accessUrl
        repository_url (str): repositoryUrl *Optional*
        template_url (str): templateUrl *Optional*
        extended_capture_enabled (bool): extendedCaptureEnabled *Optional*
        extended_capture_url (str): extendedCaptureURL *Optional*
    """

    __slots__: List[str] = [
        "file_source",
        "configuration_file_name",
        "access_url",
        "repository_url",
        "template_url",
        "extended_capture_enabled",
        "extended_capture_url",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_source",
                "fileSource",
                str,
                is_required=True,
            ),
            E(
                "configuration_file_name",
                "configurationFileName",
                str,
            ),
            E(
                "access_url",
                "accessUrl",
                str,
                is_required=True,
            ),
            E(
                "repository_url",
                "repositoryUrl",
                str,
            ),
            E(
                "template_url",
                "templateUrl",
                str,
            ),
            E(
                "extended_capture_enabled",
                "extendedCaptureEnabled",
                bool,
            ),
            E(
                "extended_capture_url",
                "extendedCaptureURL",
                str,
            ),
        )


class GroupAccessDeviceGetAvailableCustomTagListResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceGetAvailableCustomTagListRequest()`.

    Contains a table of all available custom tags managed by the Device Management System
    on a per-device profile basis.  In AS data mode, the column headings are: "Tag Name",
    "Tag Value", "Tag Level", "Tag Set Name", "Region Name". In XS data mode: the column
    headings are: "Tag Name", "Tag Value", "Tag Level", "Tag Set Name", "Is Encrypted" if
    request is invoked by a System administrator or by an administrator with higher
    priviledges, otherwise the column headings are: "Tag Name", "Tag Value", "Tag Level",
    "Tag Source", "Tag Set Name". "Tag Level" can take the value: "System Default",
    "System", "Service Provider", "Group" or "Device Profile".

    Attributes:
        device_available_custom_tags_table (List(deviceAvailableCustomTagsTable)):
            deviceAvailableCustomTagsTable - *Table* array of
            deviceAvailableCustomTagsTable named tuples
    """

    __slots__: List[str] = [
        "device_available_custom_tags_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_available_custom_tags_table",
                "deviceAvailableCustomTagsTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceGetAvailableDetailListResponse14(OCIResponse):
    """
    Response to `GroupAccessDeviceGetAvailableDetailListRequest14()`.


    Attributes:
        available_access_device (List[OCI.availableAccessDevice]): availableAccessDevice
            *Optional*
    """

    __slots__: List[str] = [
        "available_access_device",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_access_device",
                "availableAccessDevice",
                [
                    E(
                        "access_device",
                        "accessDevice",
                        OCI.AccessDevice,
                        is_complex=True,
                        is_required=True,
                    ),
                    E(
                        "static_registration_capable",
                        "staticRegistrationCapable",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "use_domain",
                        "useDomain",
                        bool,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_array=True,
                is_container=True,
            ),
        )


class GroupAccessDeviceGetAvailableDetailListResponse19(OCIResponse):
    """
    Response to `GroupAccessDeviceGetAvailableDetailListRequest19()`.


    Attributes:
        available_access_device (List[OCI.availableAccessDevice]): availableAccessDevice
            *Optional*
    """

    __slots__: List[str] = [
        "available_access_device",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_access_device",
                "availableAccessDevice",
                [
                    E(
                        "access_device",
                        "accessDevice",
                        OCI.AccessDevice,
                        is_complex=True,
                        is_required=True,
                    ),
                    E(
                        "static_registration_capable",
                        "staticRegistrationCapable",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "use_domain",
                        "useDomain",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "static_line_ordering",
                        "staticLineOrdering",
                        bool,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_array=True,
                is_container=True,
            ),
        )


class GroupAccessDeviceGetEnhancedConfigurationTypeListResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceGetEnhancedConfigurationTypeListRequest()`.


    Attributes:
        device_type (List[str]): deviceType *Optional*
    """

    __slots__: List[str] = [
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_type",
                "deviceType",
                str,
                is_array=True,
            ),
        )


class GroupAccessDeviceGetEnhancedConfigurationTypeResponse14(OCIResponse):
    """
    Response to `GroupAccessDeviceGetEnhancedConfigurationTypeRequest14()`.


    Attributes:
        supports_enhanced_configuration (bool): supportsEnhancedConfiguration
        supports_reset (bool): supportsReset
        configuration_type (str): configurationType *Optional*
        configuration_file_name (str): configurationFileName *Optional*
    """

    __slots__: List[str] = [
        "supports_enhanced_configuration",
        "supports_reset",
        "configuration_type",
        "configuration_file_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "supports_enhanced_configuration",
                "supportsEnhancedConfiguration",
                bool,
                is_required=True,
            ),
            E(
                "supports_reset",
                "supportsReset",
                bool,
                is_required=True,
            ),
            E(
                "configuration_type",
                "configurationType",
                str,
            ),
            E(
                "configuration_file_name",
                "configurationFileName",
                str,
            ),
        )


class GroupAccessDeviceGetListResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceGetListRequest()`.

    Contains a table of devices configured in the group.  The column headings are: "Device
    Name", "Device Type", "Available Ports", "Net Address", "MAC Address", "Status",
    "Version", and "Access Device External Id". The following columns are only populated
    in AS data mode: "Access Device External Id"

    Attributes:
        access_device_table (List(accessDeviceTable)): accessDeviceTable - *Table* array
            of accessDeviceTable named tuples
    """

    __slots__: List[str] = [
        "access_device_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device_table",
                "accessDeviceTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceGetNativeTagsWithLogicListResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceGetNativeTagsWithLogicListRequest()`.

    Contains a table of all native tags with logic managed by the Device Management System
    on a per-device profile basis.  The column headings are: "Tag Name", "Tag Value".

    Attributes:
        device_native_tags_with_logic_table (List(deviceNativeTagsWithLogicTable)):
            deviceNativeTagsWithLogicTable - *Table* array of
            deviceNativeTagsWithLogicTable named tuples
    """

    __slots__: List[str] = [
        "device_native_tags_with_logic_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_native_tags_with_logic_table",
                "deviceNativeTagsWithLogicTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceGetPagedSortedListResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceGetPagedSortedListRequest()`.

    Contains a table of devices configured in the group.  The column headings are: "Device
    Name", "Device Type", "Available Ports", "Net Address", "MAC Address", "Status",
    "Version", and "Support Visual Device Management API". When CloudPBX is not licensed,
    the column "Support Visual Device Management API" values are not returned.  Replaced
    by `GroupAccessDeviceGetPagedSortedListResponse22()`.

    Attributes:
        access_device_table (List(accessDeviceTable)): accessDeviceTable - *Table* array
            of accessDeviceTable named tuples
    """

    __slots__: List[str] = [
        "access_device_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device_table",
                "accessDeviceTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceGetPagedSortedListResponse22(OCIResponse):
    """
    Response to `GroupAccessDeviceGetPagedSortedListRequest22()`.

    Contains a table of devices configured in the group.  The column headings are: "Device
    Name", "Device Type", "Available Ports", "Net Address", "MAC Address", "Status",
    "Version", and "Support Visual Device Management API". When CloudPBX is not licensed,
    the column "Support Visual Device Management API" values are not returned.

    Attributes:
        total_number_of_rows (int): totalNumberOfRows *Optional*
        access_device_table (List(accessDeviceTable)): accessDeviceTable - *Table* array
            of accessDeviceTable named tuples
    """

    __slots__: List[str] = [
        "total_number_of_rows",
        "access_device_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_number_of_rows",
                "totalNumberOfRows",
                int,
            ),
            E(
                "access_device_table",
                "accessDeviceTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceGetUserListResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceGetUserListRequest()`.

    The column headings for the deviceUserTable are: "Line/Port", "Last Name", "First
    Name", "Phone Number", "User Id", "User Type", "Endpoint Type", "Order", "Primary
    Line/Port", "Extension", "Department", "Email Address", "Private Identity". In IMS
    mode, the table will contain a row for each TEL-URI in the Phone Number column.  In
    Standalone mode, rows for the alternate numbers are not included.  The User Type
    column contains one of the enumerated UserType values.  The Endpoint Type column
    contains one of the enumerated EndpointType values.  The Private Identity column is
    empty is AS mode.  Replaced by: `GroupAccessDeviceGetUserListResponse21sp1()` in AS
    data mode.

    Attributes:
        device_user_table (List(deviceUserTable)): deviceUserTable - *Table* array of
            deviceUserTable named tuples
    """

    __slots__: List[str] = [
        "device_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_user_table",
                "deviceUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceGetUserListResponse21sp1(OCIResponse):
    """
    Response to `GroupAccessDeviceGetUserListRequest21sp1()`.

    The column headings for the deviceUserTable are: "Line/Port", "Last Name", "First
    Name", "Phone Number", "User Id", "User Type", "Endpoint Type", "Order", "Primary
    Line/Port", "Extension", "Department", "Email Address", "Private Identity". In IMS
    mode, the table will contain a row for each TEL-URI in the Phone Number column.  In
    Standalone mode, rows for the alternate numbers are not included.  The User Type
    column contains one of the enumerated UserType values.  The Endpoint Type column
    contains one of the enumerated EndpointType21sp1 values.  The value Mobility in
    Endpoint Type column is only applicable in AS data mode.  The Private Identity column
    is empty is AS mode.

    Attributes:
        device_user_table (List(deviceUserTable)): deviceUserTable - *Table* array of
            deviceUserTable named tuples
    """

    __slots__: List[str] = [
        "device_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_user_table",
                "deviceUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccessDeviceTagSetGetResponse(OCIResponse):
    """
    Response to `GroupAccessDeviceTagSetGetRequest()`.

    The response includes a tag set name defined in the access device.

    Attributes:
        tag_set_name (str): tagSetName *Optional*
    """

    __slots__: List[str] = [
        "tag_set_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "tag_set_name",
                "tagSetName",
                str,
            ),
        )


class GroupAccountAuthorizationCodesGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupAccountAuthorizationCodesGetAvailableUserListRequest()`.

    The column headings are: "User Id", "Last Name", "First Name", "Hiragana Last Name"
    and "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAccountAuthorizationCodesGetResponse(OCIResponse):
    """
    Response to `GroupAccountAuthorizationCodesGetRequest()`.

    The tables has the following column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension",
    "Department", "Email Address".

    Attributes:
        type (str): type
        number_of_digits (int): numberOfDigits
        allow_local_and_toll_free_calls (bool): allowLocalAndTollFreeCalls
        mandatory_usage_user_table (List(mandatoryUsageUserTable)):
            mandatoryUsageUserTable - *Table* array of mandatoryUsageUserTable named
            tuples
        optional_usage_user_table (List(optionalUsageUserTable)): optionalUsageUserTable -
            *Table* array of optionalUsageUserTable named tuples
    """

    __slots__: List[str] = [
        "type",
        "number_of_digits",
        "allow_local_and_toll_free_calls",
        "mandatory_usage_user_table",
        "optional_usage_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
            E(
                "number_of_digits",
                "numberOfDigits",
                int,
                is_required=True,
            ),
            E(
                "allow_local_and_toll_free_calls",
                "allowLocalAndTollFreeCalls",
                bool,
                is_required=True,
            ),
            E(
                "mandatory_usage_user_table",
                "mandatoryUsageUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
            E(
                "optional_usage_user_table",
                "optionalUsageUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAdminAlternateIdGetListResponse(OCIResponse):
    """
    Response to `GroupAdminAlternateIdGetListRequest()`.

    Contains a table of the main admin user id and the alternate admin user ids, the
    column headings are: "User Id", "Description", "Alternate". The possible values for
    "Alternate" are "true" and "false". The "Description" is only present for alternate
    admin user Ids.

    Attributes:
        admin_user_id_table (List(adminUserIdTable)): adminUserIdTable - *Table* array of
            adminUserIdTable named tuples
    """

    __slots__: List[str] = [
        "admin_user_id_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "admin_user_id_table",
                "adminUserIdTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAdminGetListResponse(OCIResponse):
    """
    Response to `GroupAdminGetListRequest()`.

    Contains a 7 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Department", "Language", "Locale" and "Encoding". The following columns are
    only returned in AS data mode: "Locale" and "Encoding"

    Attributes:
        group_admin_table (List(groupAdminTable)): groupAdminTable - *Table* array of
            groupAdminTable named tuples
    """

    __slots__: List[str] = [
        "group_admin_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_admin_table",
                "groupAdminTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAdminGetPagedSortedListResponse(OCIResponse):
    """
    Response to `GroupAdminGetPagedSortedListRequest()`.

    Contains a 8 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Administrator Type", "Department", "Language", "Locale" and "Encoding". The
    following columns are only returned in AS data mode: "Locale" and "Encoding".

    Attributes:
        group_admin_table (List(groupAdminTable)): groupAdminTable - *Table* array of
            groupAdminTable named tuples
    """

    __slots__: List[str] = [
        "group_admin_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_admin_table",
                "groupAdminTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAdminGetPolicyResponse(OCIResponse):
    """
    Response to `GroupAdminGetPolicyRequest()`.

    Contains the policy settings for the group administrator.

    Attributes:
        profile_access (str): profileAccess
        user_access (str): userAccess
        admin_access (str): adminAccess
        department_access (str): departmentAccess
        access_device_access (str): accessDeviceAccess
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess
        feature_access_code_access (str): featureAccessCodeAccess
        phone_number_extension_access (str): phoneNumberExtensionAccess
        service_access (str): serviceAccess
    """

    __slots__: List[str] = [
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "service_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_access",
                "profileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_access",
                "userAccess",
                str,
                is_required=True,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
                is_required=True,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
                is_required=True,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
                is_required=True,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
                is_required=True,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
                is_required=True,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyResponse14sp1(OCIResponse):
    """
    Response to `GroupAdminGetPolicyRequest14sp1()`.

    Contains the policy settings for the group administrator.

    Attributes:
        profile_access (str): profileAccess
        user_access (str): userAccess
        admin_access (str): adminAccess
        department_access (str): departmentAccess
        access_device_access (str): accessDeviceAccess
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess
        feature_access_code_access (str): featureAccessCodeAccess
        phone_number_extension_access (str): phoneNumberExtensionAccess
        service_access (str): serviceAccess
        trunk_group_access (str): trunkGroupAccess
    """

    __slots__: List[str] = [
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "service_access",
        "trunk_group_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_access",
                "profileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_access",
                "userAccess",
                str,
                is_required=True,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
                is_required=True,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
                is_required=True,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
                is_required=True,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
                is_required=True,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
                is_required=True,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_access",
                "trunkGroupAccess",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyResponse16sp1(OCIResponse):
    """
    Response to `GroupAdminGetPolicyRequest16sp1()`.

    Contains the policy settings for the group administrator.  Replaced by:
    `GroupAdminGetPolicyRequest17()`

    Attributes:
        profile_access (str): profileAccess
        user_access (str): userAccess
        admin_access (str): adminAccess
        department_access (str): departmentAccess
        access_device_access (str): accessDeviceAccess
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess
        feature_access_code_access (str): featureAccessCodeAccess
        phone_number_extension_access (str): phoneNumberExtensionAccess
        service_access (str): serviceAccess
        trunk_group_access (str): trunkGroupAccess
        session_admission_control_access (str): sessionAdmissionControlAccess
    """

    __slots__: List[str] = [
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "service_access",
        "trunk_group_access",
        "session_admission_control_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_access",
                "profileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_access",
                "userAccess",
                str,
                is_required=True,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
                is_required=True,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
                is_required=True,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
                is_required=True,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
                is_required=True,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
                is_required=True,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_access",
                "trunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "session_admission_control_access",
                "sessionAdmissionControlAccess",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyResponse16sp2(OCIResponse):
    """
    Response to `GroupAdminGetPolicyRequest16sp2()`.

    Contains the policy settings for the group administrator.

    Attributes:
        profile_access (str): profileAccess
        user_access (str): userAccess
        admin_access (str): adminAccess
        department_access (str): departmentAccess
        access_device_access (str): accessDeviceAccess
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess
        feature_access_code_access (str): featureAccessCodeAccess
        phone_number_extension_access (str): phoneNumberExtensionAccess
        calling_line_id_number_access (str): callingLineIdNumberAccess
        service_access (str): serviceAccess
        trunk_group_access (str): trunkGroupAccess
        session_admission_control_access (str): sessionAdmissionControlAccess
        dialable_caller_id_access (str): dialableCallerIDAccess
    """

    __slots__: List[str] = [
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "calling_line_id_number_access",
        "service_access",
        "trunk_group_access",
        "session_admission_control_access",
        "dialable_caller_id_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_access",
                "profileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_access",
                "userAccess",
                str,
                is_required=True,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
                is_required=True,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
                is_required=True,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
                is_required=True,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
                is_required=True,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
                is_required=True,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_number_access",
                "callingLineIdNumberAccess",
                str,
                is_required=True,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_access",
                "trunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "session_admission_control_access",
                "sessionAdmissionControlAccess",
                str,
                is_required=True,
            ),
            E(
                "dialable_caller_id_access",
                "dialableCallerIDAccess",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyResponse17(OCIResponse):
    """
    Response to `GroupAdminGetPolicyRequest17()`.

    Contains the policy settings for the group administrator.

    Attributes:
        profile_access (str): profileAccess
        user_access (str): userAccess
        admin_access (str): adminAccess
        department_access (str): departmentAccess
        access_device_access (str): accessDeviceAccess
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess
        feature_access_code_access (str): featureAccessCodeAccess
        phone_number_extension_access (str): phoneNumberExtensionAccess
        calling_line_id_number_access (str): callingLineIdNumberAccess
        service_access (str): serviceAccess
        trunk_group_access (str): trunkGroupAccess
        session_admission_control_access (str): sessionAdmissionControlAccess
        office_zone_access (str): officeZoneAccess
    """

    __slots__: List[str] = [
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "calling_line_id_number_access",
        "service_access",
        "trunk_group_access",
        "session_admission_control_access",
        "office_zone_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_access",
                "profileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_access",
                "userAccess",
                str,
                is_required=True,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
                is_required=True,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
                is_required=True,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
                is_required=True,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
                is_required=True,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
                is_required=True,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_number_access",
                "callingLineIdNumberAccess",
                str,
                is_required=True,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_access",
                "trunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "session_admission_control_access",
                "sessionAdmissionControlAccess",
                str,
                is_required=True,
            ),
            E(
                "office_zone_access",
                "officeZoneAccess",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyResponse17sp3(OCIResponse):
    """
    Response to `GroupAdminGetPolicyRequest17sp3()`.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess

    Attributes:
        profile_access (str): profileAccess
        user_access (str): userAccess
        admin_access (str): adminAccess
        department_access (str): departmentAccess
        access_device_access (str): accessDeviceAccess
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess
        feature_access_code_access (str): featureAccessCodeAccess
        phone_number_extension_access (str): phoneNumberExtensionAccess
        calling_line_id_number_access (str): callingLineIdNumberAccess
        service_access (str): serviceAccess
        trunk_group_access (str): trunkGroupAccess
        session_admission_control_access (str): sessionAdmissionControlAccess
        office_zone_access (str): officeZoneAccess
        dialable_caller_id_access (str): dialableCallerIDAccess
    """

    __slots__: List[str] = [
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "calling_line_id_number_access",
        "service_access",
        "trunk_group_access",
        "session_admission_control_access",
        "office_zone_access",
        "dialable_caller_id_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_access",
                "profileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_access",
                "userAccess",
                str,
                is_required=True,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
                is_required=True,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
                is_required=True,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
                is_required=True,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
                is_required=True,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
                is_required=True,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_number_access",
                "callingLineIdNumberAccess",
                str,
                is_required=True,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_access",
                "trunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "session_admission_control_access",
                "sessionAdmissionControlAccess",
                str,
                is_required=True,
            ),
            E(
                "office_zone_access",
                "officeZoneAccess",
                str,
                is_required=True,
            ),
            E(
                "dialable_caller_id_access",
                "dialableCallerIDAccess",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyResponse18(OCIResponse):
    """
    Response to `GroupAdminGetPolicyRequest18()`.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess

    Attributes:
        profile_access (str): profileAccess
        user_access (str): userAccess
        admin_access (str): adminAccess
        department_access (str): departmentAccess
        access_device_access (str): accessDeviceAccess
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess
        feature_access_code_access (str): featureAccessCodeAccess
        phone_number_extension_access (str): phoneNumberExtensionAccess
        calling_line_id_number_access (str): callingLineIdNumberAccess
        service_access (str): serviceAccess
        trunk_group_access (str): trunkGroupAccess
        session_admission_control_access (str): sessionAdmissionControlAccess
        office_zone_access (str): officeZoneAccess
        number_activation_access (str): numberActivationAccess
        dialable_caller_id_access (str): dialableCallerIDAccess
    """

    __slots__: List[str] = [
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "calling_line_id_number_access",
        "service_access",
        "trunk_group_access",
        "session_admission_control_access",
        "office_zone_access",
        "number_activation_access",
        "dialable_caller_id_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_access",
                "profileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_access",
                "userAccess",
                str,
                is_required=True,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
                is_required=True,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
                is_required=True,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
                is_required=True,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
                is_required=True,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
                is_required=True,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_number_access",
                "callingLineIdNumberAccess",
                str,
                is_required=True,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_access",
                "trunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "session_admission_control_access",
                "sessionAdmissionControlAccess",
                str,
                is_required=True,
            ),
            E(
                "office_zone_access",
                "officeZoneAccess",
                str,
                is_required=True,
            ),
            E(
                "number_activation_access",
                "numberActivationAccess",
                str,
                is_required=True,
            ),
            E(
                "dialable_caller_id_access",
                "dialableCallerIDAccess",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyResponse19sp1(OCIResponse):
    """
    Response to `GroupAdminGetPolicyRequest19sp1()`.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess The following elements are only used
    in AS data mode and not returned in XS data mode communicationBarringUserProfileAccess
    (This element will not be returned in the response for Service Provider group
    administrators)

    Attributes:
        profile_access (str): profileAccess
        user_access (str): userAccess
        admin_access (str): adminAccess
        department_access (str): departmentAccess
        access_device_access (str): accessDeviceAccess
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess
        feature_access_code_access (str): featureAccessCodeAccess
        phone_number_extension_access (str): phoneNumberExtensionAccess
        calling_line_id_number_access (str): callingLineIdNumberAccess
        service_access (str): serviceAccess
        trunk_group_access (str): trunkGroupAccess
        session_admission_control_access (str): sessionAdmissionControlAccess
        office_zone_access (str): officeZoneAccess
        number_activation_access (str): numberActivationAccess
        dialable_caller_id_access (str): dialableCallerIDAccess
        communication_barring_user_profile_access (str):
            communicationBarringUserProfileAccess *Optional*
    """

    __slots__: List[str] = [
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "calling_line_id_number_access",
        "service_access",
        "trunk_group_access",
        "session_admission_control_access",
        "office_zone_access",
        "number_activation_access",
        "dialable_caller_id_access",
        "communication_barring_user_profile_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_access",
                "profileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_access",
                "userAccess",
                str,
                is_required=True,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
                is_required=True,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
                is_required=True,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
                is_required=True,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
                is_required=True,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
                is_required=True,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_number_access",
                "callingLineIdNumberAccess",
                str,
                is_required=True,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_access",
                "trunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "session_admission_control_access",
                "sessionAdmissionControlAccess",
                str,
                is_required=True,
            ),
            E(
                "office_zone_access",
                "officeZoneAccess",
                str,
                is_required=True,
            ),
            E(
                "number_activation_access",
                "numberActivationAccess",
                str,
                is_required=True,
            ),
            E(
                "dialable_caller_id_access",
                "dialableCallerIDAccess",
                str,
                is_required=True,
            ),
            E(
                "communication_barring_user_profile_access",
                "communicationBarringUserProfileAccess",
                str,
            ),
        )


class GroupAdminGetPolicyResponse20(OCIResponse):
    """
    Response to `GroupAdminGetPolicyRequest20()`.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess verifyTranslationAndroutingAccess,
    value "None" is returned in XS data mode The following elements are only used in AS
    data mode and not returned in XS data mode: communicationBarringUserProfileAccess
    (This element is only returned for groups in an enterprise)

    Attributes:
        profile_access (str): profileAccess
        user_access (str): userAccess
        admin_access (str): adminAccess
        department_access (str): departmentAccess
        access_device_access (str): accessDeviceAccess
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess
        feature_access_code_access (str): featureAccessCodeAccess
        phone_number_extension_access (str): phoneNumberExtensionAccess
        calling_line_id_number_access (str): callingLineIdNumberAccess
        service_access (str): serviceAccess
        trunk_group_access (str): trunkGroupAccess
        session_admission_control_access (str): sessionAdmissionControlAccess
        office_zone_access (str): officeZoneAccess
        number_activation_access (str): numberActivationAccess
        dialable_caller_id_access (str): dialableCallerIDAccess
        verify_translation_and_routing_access (str): verifyTranslationAndRoutingAccess
        communication_barring_user_profile_access (str):
            communicationBarringUserProfileAccess *Optional*
    """

    __slots__: List[str] = [
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "calling_line_id_number_access",
        "service_access",
        "trunk_group_access",
        "session_admission_control_access",
        "office_zone_access",
        "number_activation_access",
        "dialable_caller_id_access",
        "verify_translation_and_routing_access",
        "communication_barring_user_profile_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_access",
                "profileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_access",
                "userAccess",
                str,
                is_required=True,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
                is_required=True,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
                is_required=True,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
                is_required=True,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
                is_required=True,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
                is_required=True,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_number_access",
                "callingLineIdNumberAccess",
                str,
                is_required=True,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_access",
                "trunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "session_admission_control_access",
                "sessionAdmissionControlAccess",
                str,
                is_required=True,
            ),
            E(
                "office_zone_access",
                "officeZoneAccess",
                str,
                is_required=True,
            ),
            E(
                "number_activation_access",
                "numberActivationAccess",
                str,
                is_required=True,
            ),
            E(
                "dialable_caller_id_access",
                "dialableCallerIDAccess",
                str,
                is_required=True,
            ),
            E(
                "verify_translation_and_routing_access",
                "verifyTranslationAndRoutingAccess",
                str,
                is_required=True,
            ),
            E(
                "communication_barring_user_profile_access",
                "communicationBarringUserProfileAccess",
                str,
            ),
        )


class GroupAdminGetResponse(OCIResponse):
    """
    Response to the `GroupAdminGetRequest()`.

    The response contains the group administrators profile information.  Replaced by
    `GroupAdminGetResponse21sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        language (str): language
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "first_name",
        "last_name",
        "language",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetResponse21sp1(OCIResponse):
    """
    Response to the `GroupAdminGetRequest21sp1()`.

    The response contains the group administrators profile information.  Replaced by:
    `GroupAdminGetResponse22()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        language (str): language
        locale (str): locale
        encoding (str): encoding
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "first_name",
        "last_name",
        "language",
        "locale",
        "encoding",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetResponse22(OCIResponse):
    """
    Response to the `GroupAdminGetRequest22()`.

    The response contains the group administrators profile information.  Replaced by:
    `GroupAdminGetResponse22V2()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        language (str): language
        locale (str): locale
        encoding (str): encoding
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "first_name",
        "last_name",
        "language",
        "locale",
        "encoding",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetResponse22V2(OCIResponse):
    """
    Response to the `GroupAdminGetRequest22V2()`.

    The response contains the group administrators profile information.  The following
    elements are only used in AS data mode and ignored in XS data mode.  accountDisabled
    lastAuthenticatedDate Replaced by: `GroupAdminGetResponse22V3()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        language (str): language
        locale (str): locale
        encoding (str): encoding
        account_disabled (bool): accountDisabled
        last_authenticated_date (str): lastAuthenticatedDate
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "first_name",
        "last_name",
        "language",
        "locale",
        "encoding",
        "account_disabled",
        "last_authenticated_date",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "account_disabled",
                "accountDisabled",
                bool,
                is_required=True,
            ),
            E(
                "last_authenticated_date",
                "lastAuthenticatedDate",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetResponse22V3(OCIResponse):
    """
    Response to the `GroupAdminGetRequest22V3()`.

    The response contains the group administrators profile information.  The following
    elements are only used in AS data mode and ignored in XS data mode.  accountDisabled
    lastAuthenticatedDate hasPassword

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        language (str): language
        locale (str): locale
        encoding (str): encoding
        account_disabled (bool): accountDisabled
        last_authenticated_date (str): lastAuthenticatedDate
        has_password (bool): hasPassword
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "first_name",
        "last_name",
        "language",
        "locale",
        "encoding",
        "account_disabled",
        "last_authenticated_date",
        "has_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "account_disabled",
                "accountDisabled",
                bool,
                is_required=True,
            ),
            E(
                "last_authenticated_date",
                "lastAuthenticatedDate",
                str,
                is_required=True,
            ),
            E(
                "has_password",
                "hasPassword",
                bool,
                is_required=True,
            ),
        )


class GroupAdministratorPasswordRulesGetResponse(OCIResponse):
    """
    Response to `GroupAdministratorPasswordRulesGetRequest()`.


    Attributes:
        use_external_authentication (bool): useExternalAuthentication *Optional*
        allow_web_add_external_authentication_users (bool):
            allowWebAddExternalAuthenticationUsers *Optional*
        disallow_user_id (bool): disallowUserId *Optional*
        disallow_old_password (bool): disallowOldPassword *Optional*
        disallow_reversed_old_password (bool): disallowReversedOldPassword *Optional*
        restrict_min_digits (bool): restrictMinDigits *Optional*
        min_digits (int): minDigits *Optional*
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters *Optional*
        min_upper_case_letters (int): minUpperCaseLetters *Optional*
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters *Optional*
        min_lower_case_letters (int): minLowerCaseLetters *Optional*
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters *Optional*
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters *Optional*
        min_length (int): minLength *Optional*
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        password_expires_days (int): passwordExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail *Optional*
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_previous_passwords (bool): disallowPreviousPasswords *Optional*
        number_of_previous_passwords (int): numberOfPreviousPasswords *Optional*
    """

    __slots__: List[str] = [
        "use_external_authentication",
        "allow_web_add_external_authentication_users",
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_previous_passwords",
        "number_of_previous_passwords",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_external_authentication",
                "useExternalAuthentication",
                bool,
            ),
            E(
                "allow_web_add_external_authentication_users",
                "allowWebAddExternalAuthenticationUsers",
                bool,
            ),
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
            ),
            E(
                "min_length",
                "minLength",
                int,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_previous_passwords",
                "disallowPreviousPasswords",
                bool,
            ),
            E(
                "number_of_previous_passwords",
                "numberOfPreviousPasswords",
                int,
            ),
        )


class GroupAdviceOfChargeGetResponse(OCIResponse):
    """
    Response to `GroupAdviceOfChargeGetRequest()`.

    Contains a list of Advice of Charge group parameters.

    Attributes:
        use_group_level_ao_c_settings (bool): useGroupLevelAoCSettings
        delay_between_notification_seconds (int): delayBetweenNotificationSeconds
    """

    __slots__: List[str] = [
        "use_group_level_ao_c_settings",
        "delay_between_notification_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_level_ao_c_settings",
                "useGroupLevelAoCSettings",
                bool,
                is_required=True,
            ),
            E(
                "delay_between_notification_seconds",
                "delayBetweenNotificationSeconds",
                int,
                is_required=True,
            ),
        )


class GroupAlternateUserIdGetListResponse(OCIResponse):
    """
    Response to `GroupAlternateUserIdGetListRequest()`.

    The "User Type" column contains the corresponding enumerated UserType value.  Contains
    a table of alternate user ids, the column headings are: "User Id", "Alternate User Id"
    and "User Type".

    Attributes:
        alternate_user_id_table (List(alternateUserIdTable)): alternateUserIdTable -
            *Table* array of alternateUserIdTable named tuples
    """

    __slots__: List[str] = [
        "alternate_user_id_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "alternate_user_id_table",
                "alternateUserIdTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAnnouncementFileGetListResponse(OCIResponse):
    """
    Response to `GroupAnnouncementFileGetListRequest()`.

    When requested, the response contains a table with columns: "Name", "Media Type",
    "File Size", "Announcement File External Id". The "Name" column contains the name of
    the announcement file.  The "Media Type" column contains the media type of the
    announcement File with the possible values: WMA - Windows Media Audio file WAV - A WAV
    file 3GP - A 3GP file MOV - A MOV file using a H.263 or H.264 codec.  The "File Size"
    column contains the file size (KB) of the announcement file.  The "Announcement File
    External Id" column contains the External ID of the announcement file.

    The response also contains the current total file size (KB) for the group across all
    media types and the maximum total file size (MB) allowed for the group.  The following
    columns are populated in AS data mode only: "Announcement File External Id"

    Attributes:
        announcement_table (List(announcementTable)): announcementTable - *Table* array of
            announcementTable named tuples *Optional*
        total_file_size (int): totalFileSize
        max_file_size (int): maxFileSize
    """

    __slots__: List[str] = [
        "announcement_table",
        "total_file_size",
        "max_file_size",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "announcement_table",
                "announcementTable",
                list,
                is_complex=True,
                is_table=True,
            ),
            E(
                "total_file_size",
                "totalFileSize",
                int,
                is_required=True,
            ),
            E(
                "max_file_size",
                "maxFileSize",
                int,
                is_required=True,
            ),
        )


class GroupAnnouncementFileGetPagedSortedListResponse(OCIResponse):
    """
    Response to `GroupAnnouncementFileGetPagedSortedListRequest()`.

    The response contains a table with columns: "Name", "Media Type", "File Size", and
    "Announcement File External Id". The "Name" column contains the name of the
    announcement file.  The "Media Type" column contains the media type of the
    announcement File with the possible values: WMA - Windows Media Audio file WAV - A WAV
    file 3GP - A 3GP file MOV - A MOV file using a H.263 or H.264 codec.  The "File Size"
    column contains the file size (KB) of the announcement file.  The following columns
    are populated in AS data mode only: "Announcement File External Id"

    Attributes:
        announcement_table (List(announcementTable)): announcementTable - *Table* array of
            announcementTable named tuples *Optional*
    """

    __slots__: List[str] = [
        "announcement_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "announcement_table",
                "announcementTable",
                list,
                is_complex=True,
                is_table=True,
            ),
        )


class GroupAnnouncementFileGetResponse(OCIResponse):
    """
    Response to `GroupAnnouncementFileGetRequest()`.

    The response contains the file size, uploaded timestamp, description and usage for an
    announcement file in the user announcement repository.  The usage table has columns
    "Service Name", and "Instance Name". The Service Name values correspond to string
    values of the GroupService and UserService data types.  With the exception of the
    string "Voice Portal" which is returned when the announcement is being used by Voice
    Portal Personalized Name.  Replaced by: `GroupAnnouncementFileGetResponse22()`.

    Attributes:
        description (str): description
        filesize (int): filesize
        last_uploaded (str): lastUploaded
        usage_table (List(usageTable)): usageTable - *Table* array of usageTable named
            tuples
    """

    __slots__: List[str] = [
        "description",
        "filesize",
        "last_uploaded",
        "usage_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
                is_required=True,
            ),
            E(
                "filesize",
                "filesize",
                int,
                is_required=True,
            ),
            E(
                "last_uploaded",
                "lastUploaded",
                str,
                is_required=True,
            ),
            E(
                "usage_table",
                "usageTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAnnouncementRepositoryGetSettingsResponse(OCIResponse):
    """
    Response to `GroupAnnouncementFileGetSettingsRequest()`.

    The response contains the current total file size (KB) for the group across all media
    types and the maximum total file size (MB) allowed for the group.  It also indicates
    the maximum file size for individual audio and video files.

    Attributes:
        total_file_size (int): totalFileSize
        max_audio_file_size (int): maxAudioFileSize
        max_video_file_size (int): maxVideoFileSize
        max_file_size (int): maxFileSize
    """

    __slots__: List[str] = [
        "total_file_size",
        "max_audio_file_size",
        "max_video_file_size",
        "max_file_size",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_file_size",
                "totalFileSize",
                int,
                is_required=True,
            ),
            E(
                "max_audio_file_size",
                "maxAudioFileSize",
                int,
                is_required=True,
            ),
            E(
                "max_video_file_size",
                "maxVideoFileSize",
                int,
                is_required=True,
            ),
            E(
                "max_file_size",
                "maxFileSize",
                int,
                is_required=True,
            ),
        )


class GroupApplicationServerSetGetResponse(OCIResponse):
    """
    Response to the `GroupApplicationServerSetGetRequest()`.

    The response contains the group's Application Server set information.

    Attributes:
        application_server_set_name (str): applicationServerSetName *Optional*
    """

    __slots__: List[str] = [
        "application_server_set_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "application_server_set_name",
                "applicationServerSetName",
                str,
            ),
        )


class GroupAutoAttendantGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupAutoAttendantGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active", "Type". The column values for "Video"
    and "Is Active" can either be true, or false.  The column values for "Type" can either
    be Basic or Standard.  In XS Mode the value for the "Type" column will always be
    populated with Basic.

    Attributes:
        auto_attendant_table (List(autoAttendantTable)): autoAttendantTable - *Table*
            array of autoAttendantTable named tuples
    """

    __slots__: List[str] = [
        "auto_attendant_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "auto_attendant_table",
                "autoAttendantTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAutoAttendantGetInstancePagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupAutoAttendantGetInstancePagedSortedListRequest()`.

    The response contains a table with columns: "Service User Id", "Name", "Phone Number",
    "Is Phone Number Activated", "Country Code", "National Prefix", "Extension",
    "Department", "Department Type", "Parent Department", "Parent Department Type", "Is
    Active", "Type". The column values for "Is Active" can either be true, or false.  The
    column values for "Type" can either be Basic or Standard.  The "Department Type" and
    "Parent Department Type" columns will contain the values "Enterprise" or "Group". In
    XS Mode the value for the "Type" column will always be populated with Basic.

    Attributes:
        auto_attendant_table (List(autoAttendantTable)): autoAttendantTable - *Table*
            array of autoAttendantTable named tuples
    """

    __slots__: List[str] = [
        "auto_attendant_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "auto_attendant_table",
                "autoAttendantTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAutoAttendantSubmenuGetListResponse(OCIResponse):
    """
    Response to the `GroupAutoAttendantSubmenuGetListRequest()`.

    Contains a table with column headings: "Submenu Id" "Is Used". The column values for
    "Is Used" can either be true, or false.

    Attributes:
        submenu_table (List(submenuTable)): submenuTable - *Table* array of submenuTable
            named tuples
    """

    __slots__: List[str] = [
        "submenu_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "submenu_table",
                "submenuTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupAutoAttendantSubmenuGetUsageListResponse(OCIResponse):
    """
    Response to the `GroupAutoAttendantSubmenuGetUsageListRequest()`.

    Contains a table with column headings: "Type" and "Submenu ID". The "Type" Column will
    contain one of the following: Business Hours Menu, After Hours Menu, Holiday Menu or
    Submenu.  The "Submenu ID" Column will be left blank when the "Type" Column contains
    one of the base menu types (Business Hours Menu, After Hours Menu or Holiday Menu),
    and will contain the Submenu ID when the "Type" Column contains type Submenu.

    Attributes:
        submenu_table (List(submenuTable)): submenuTable - *Table* array of submenuTable
            named tuples
    """

    __slots__: List[str] = [
        "submenu_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "submenu_table",
                "submenuTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupBroadWorksAnywhereGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupBroadWorksAnywhereGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.

    Attributes:
        broad_works_anywhere_table (List(broadWorksAnywhereTable)):
            broadWorksAnywhereTable - *Table* array of broadWorksAnywhereTable named
            tuples
    """

    __slots__: List[str] = [
        "broad_works_anywhere_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "broad_works_anywhere_table",
                "broadWorksAnywhereTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupBroadWorksMobilityGetResponse(OCIResponse):
    """
    The response to a `GroupBroadWorksMobilityGetRequest()`.


    Attributes:
        use_setting_level (str): useSettingLevel
        enable_location_services (bool): enableLocationServices
        enable_msrn_lookup (bool): enableMSRNLookup
        enable_mobile_state_checking (bool): enableMobileStateChecking
        deny_call_originations (bool): denyCallOriginations
        deny_call_terminations (bool): denyCallTerminations
    """

    __slots__: List[str] = [
        "use_setting_level",
        "enable_location_services",
        "enable_msrn_lookup",
        "enable_mobile_state_checking",
        "deny_call_originations",
        "deny_call_terminations",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting_level",
                "useSettingLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_location_services",
                "enableLocationServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_msrn_lookup",
                "enableMSRNLookup",
                bool,
                is_required=True,
            ),
            E(
                "enable_mobile_state_checking",
                "enableMobileStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_originations",
                "denyCallOriginations",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_terminations",
                "denyCallTerminations",
                bool,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetResponse19sp1(OCIResponse):
    """
    The response to a `GroupBroadWorksMobilityGetRequest19sp1()`.

    Replaced by: `GroupBroadWorksMobilityGetResponse22()` in AS data mode

    Attributes:
        use_setting_level (str): useSettingLevel
        enable_location_services (bool): enableLocationServices
        enable_msrn_lookup (bool): enableMSRNLookup
        enable_mobile_state_checking (bool): enableMobileStateChecking
        deny_call_originations (bool): denyCallOriginations
        deny_call_terminations (bool): denyCallTerminations
        enable_announcement_suppression (bool): enableAnnouncementSuppression
    """

    __slots__: List[str] = [
        "use_setting_level",
        "enable_location_services",
        "enable_msrn_lookup",
        "enable_mobile_state_checking",
        "deny_call_originations",
        "deny_call_terminations",
        "enable_announcement_suppression",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting_level",
                "useSettingLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_location_services",
                "enableLocationServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_msrn_lookup",
                "enableMSRNLookup",
                bool,
                is_required=True,
            ),
            E(
                "enable_mobile_state_checking",
                "enableMobileStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_originations",
                "denyCallOriginations",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_terminations",
                "denyCallTerminations",
                bool,
                is_required=True,
            ),
            E(
                "enable_announcement_suppression",
                "enableAnnouncementSuppression",
                bool,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetResponse21sp1(OCIResponse):
    """
    The response to a `GroupBroadWorksMobilityGetRequest21sp1()`.

    Replaced by `GroupBroadWorksMobilityGetResponse22V2()`.

    Attributes:
        use_setting_level (str): useSettingLevel
        enable_location_services (bool): enableLocationServices
        enable_msrn_lookup (bool): enableMSRNLookup
        enable_mobile_state_checking (bool): enableMobileStateChecking
        deny_call_originations (bool): denyCallOriginations
        deny_call_terminations (bool): denyCallTerminations
        enable_announcement_suppression (bool): enableAnnouncementSuppression
        enable_internal_clid_delivery_access_locations (bool):
            enableInternalCLIDDeliveryAccessLocations
    """

    __slots__: List[str] = [
        "use_setting_level",
        "enable_location_services",
        "enable_msrn_lookup",
        "enable_mobile_state_checking",
        "deny_call_originations",
        "deny_call_terminations",
        "enable_announcement_suppression",
        "enable_internal_clid_delivery_access_locations",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting_level",
                "useSettingLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_location_services",
                "enableLocationServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_msrn_lookup",
                "enableMSRNLookup",
                bool,
                is_required=True,
            ),
            E(
                "enable_mobile_state_checking",
                "enableMobileStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_originations",
                "denyCallOriginations",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_terminations",
                "denyCallTerminations",
                bool,
                is_required=True,
            ),
            E(
                "enable_announcement_suppression",
                "enableAnnouncementSuppression",
                bool,
                is_required=True,
            ),
            E(
                "enable_internal_clid_delivery_access_locations",
                "enableInternalCLIDDeliveryAccessLocations",
                bool,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetResponse22(OCIResponse):
    """
    The response to a `GroupBroadWorksMobilityGetRequest22()`.

    Replaced by `GroupBroadWorksMobilityGetResponse22V2()`.

    Attributes:
        use_setting_level (str): useSettingLevel
        enable_location_services (bool): enableLocationServices
        enable_msrn_lookup (bool): enableMSRNLookup
        enable_mobile_state_checking (bool): enableMobileStateChecking
        deny_call_originations (bool): denyCallOriginations
        deny_call_terminations (bool): denyCallTerminations
        enable_announcement_suppression (bool): enableAnnouncementSuppression
        enable_internal_clid_delivery (bool): enableInternalCLIDDelivery
    """

    __slots__: List[str] = [
        "use_setting_level",
        "enable_location_services",
        "enable_msrn_lookup",
        "enable_mobile_state_checking",
        "deny_call_originations",
        "deny_call_terminations",
        "enable_announcement_suppression",
        "enable_internal_clid_delivery",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting_level",
                "useSettingLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_location_services",
                "enableLocationServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_msrn_lookup",
                "enableMSRNLookup",
                bool,
                is_required=True,
            ),
            E(
                "enable_mobile_state_checking",
                "enableMobileStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_originations",
                "denyCallOriginations",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_terminations",
                "denyCallTerminations",
                bool,
                is_required=True,
            ),
            E(
                "enable_announcement_suppression",
                "enableAnnouncementSuppression",
                bool,
                is_required=True,
            ),
            E(
                "enable_internal_clid_delivery",
                "enableInternalCLIDDelivery",
                bool,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetResponse22V2(OCIResponse):
    """
    The response to a `GroupBroadWorksMobilityGetRequest22V2()`.

    Replaced by `GroupBroadWorksMobilityGetResponse22V3()`.

    Attributes:
        use_setting_level (str): useSettingLevel
        enable_location_services (bool): enableLocationServices
        enable_msrn_lookup (bool): enableMSRNLookup
        enable_mobile_state_checking (bool): enableMobileStateChecking
        deny_call_originations (bool): denyCallOriginations
        deny_call_terminations (bool): denyCallTerminations
        enable_announcement_suppression (bool): enableAnnouncementSuppression
        enable_internal_clid_delivery (bool): enableInternalCLIDDelivery
        enable_internal_clid_delivery_access_locations (bool):
            enableInternalCLIDDeliveryAccessLocations
        enable_enhanced_unreachable_state_checking (bool):
            enableEnhancedUnreachableStateChecking
        enable_network_call_barring_status_check (bool):
            enableNetworkCallBarringStatusCheck
    """

    __slots__: List[str] = [
        "use_setting_level",
        "enable_location_services",
        "enable_msrn_lookup",
        "enable_mobile_state_checking",
        "deny_call_originations",
        "deny_call_terminations",
        "enable_announcement_suppression",
        "enable_internal_clid_delivery",
        "enable_internal_clid_delivery_access_locations",
        "enable_enhanced_unreachable_state_checking",
        "enable_network_call_barring_status_check",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting_level",
                "useSettingLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_location_services",
                "enableLocationServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_msrn_lookup",
                "enableMSRNLookup",
                bool,
                is_required=True,
            ),
            E(
                "enable_mobile_state_checking",
                "enableMobileStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_originations",
                "denyCallOriginations",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_terminations",
                "denyCallTerminations",
                bool,
                is_required=True,
            ),
            E(
                "enable_announcement_suppression",
                "enableAnnouncementSuppression",
                bool,
                is_required=True,
            ),
            E(
                "enable_internal_clid_delivery",
                "enableInternalCLIDDelivery",
                bool,
                is_required=True,
            ),
            E(
                "enable_internal_clid_delivery_access_locations",
                "enableInternalCLIDDeliveryAccessLocations",
                bool,
                is_required=True,
            ),
            E(
                "enable_enhanced_unreachable_state_checking",
                "enableEnhancedUnreachableStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "enable_network_call_barring_status_check",
                "enableNetworkCallBarringStatusCheck",
                bool,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetResponse22V3(OCIResponse):
    """
    The response to a `GroupBroadWorksMobilityGetRequest22V3()`.

    Replaced by `GroupBroadWorksMobilityGetResponse22V4()`.

    Attributes:
        use_setting_level (str): useSettingLevel
        enable_location_services (bool): enableLocationServices
        enable_msrn_lookup (bool): enableMSRNLookup
        enable_mobile_state_checking (bool): enableMobileStateChecking
        deny_call_originations (bool): denyCallOriginations
        deny_call_terminations (bool): denyCallTerminations
        enable_announcement_suppression (bool): enableAnnouncementSuppression
        enable_internal_clid_delivery (bool): enableInternalCLIDDelivery
        enable_internal_clid_delivery_access_locations (bool):
            enableInternalCLIDDeliveryAccessLocations
        enable_enhanced_unreachable_state_checking (bool):
            enableEnhancedUnreachableStateChecking
        enable_network_call_barring_status_check (bool):
            enableNetworkCallBarringStatusCheck
        network_translation_index (str): networkTranslationIndex *Optional*
    """

    __slots__: List[str] = [
        "use_setting_level",
        "enable_location_services",
        "enable_msrn_lookup",
        "enable_mobile_state_checking",
        "deny_call_originations",
        "deny_call_terminations",
        "enable_announcement_suppression",
        "enable_internal_clid_delivery",
        "enable_internal_clid_delivery_access_locations",
        "enable_enhanced_unreachable_state_checking",
        "enable_network_call_barring_status_check",
        "network_translation_index",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting_level",
                "useSettingLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_location_services",
                "enableLocationServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_msrn_lookup",
                "enableMSRNLookup",
                bool,
                is_required=True,
            ),
            E(
                "enable_mobile_state_checking",
                "enableMobileStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_originations",
                "denyCallOriginations",
                bool,
                is_required=True,
            ),
            E(
                "deny_call_terminations",
                "denyCallTerminations",
                bool,
                is_required=True,
            ),
            E(
                "enable_announcement_suppression",
                "enableAnnouncementSuppression",
                bool,
                is_required=True,
            ),
            E(
                "enable_internal_clid_delivery",
                "enableInternalCLIDDelivery",
                bool,
                is_required=True,
            ),
            E(
                "enable_internal_clid_delivery_access_locations",
                "enableInternalCLIDDeliveryAccessLocations",
                bool,
                is_required=True,
            ),
            E(
                "enable_enhanced_unreachable_state_checking",
                "enableEnhancedUnreachableStateChecking",
                bool,
                is_required=True,
            ),
            E(
                "enable_network_call_barring_status_check",
                "enableNetworkCallBarringStatusCheck",
                bool,
                is_required=True,
            ),
            E(
                "network_translation_index",
                "networkTranslationIndex",
                str,
            ),
        )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListResponse(OCIResponse):
    """
    Response to the
    `GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest()`.

    The response contains a table with columns: "Mobile Number", "User Id", "Last Name",
    "First Name","Phone Number", "Extension", "Department",. The "Mobile Number" column
    contains a single DN. The "User Id", "Last Name" and "First Name" columns contains the
    corresponding attributes of the user possessing the DN(s). The "Phone Number" column
    contains a single DN. The "Department" column contains the department of the user if
    it is part of a department.

    Attributes:
        mobile_subscriber_directory_number_table
            (List(mobileSubscriberDirectoryNumberTable)):
            mobileSubscriberDirectoryNumberTable - *Table* array of
            mobileSubscriberDirectoryNumberTable named tuples
    """

    __slots__: List[str] = [
        "mobile_subscriber_directory_number_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "mobile_subscriber_directory_number_table",
                "mobileSubscriberDirectoryNumberTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(OCIResponse):
    """
    Response to
    `GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()`.

    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    Attributes:
        mobile_subscriber_directory_number (List[str]): mobileSubscriberDirectoryNumber
            *Optional*
    """

    __slots__: List[str] = [
        "mobile_subscriber_directory_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "mobile_subscriber_directory_number",
                "mobileSubscriberDirectoryNumber",
                str,
                is_array=True,
            ),
        )


class GroupCallCapacityManagementGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupCallCapacityManagementGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCapacityManagementGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupCallCapacityManagementGetInstanceListRequest()`.

    Contains a table with column headings: "Name", "Is Default", "Maximum Calls", "Maximum
    Incoming Calls", "Maximum Outgoing Calls".

    Attributes:
        call_capacity_group_table (List(callCapacityGroupTable)): callCapacityGroupTable -
            *Table* array of callCapacityGroupTable named tuples
    """

    __slots__: List[str] = [
        "call_capacity_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_capacity_group_table",
                "callCapacityGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCapacityManagementGetInstanceResponse(OCIResponse):
    """
    Response to the `GroupCallCapacityManagementGetInstanceRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        name (str): name
        max_active_calls_allowed (int): maxActiveCallsAllowed
        max_incoming_active_calls_allowed (int): maxIncomingActiveCallsAllowed *Optional*
        max_outgoing_active_calls_allowed (int): maxOutgoingActiveCallsAllowed *Optional*
        default_group_for_new_users (bool): defaultGroupForNewUsers
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "name",
        "max_active_calls_allowed",
        "max_incoming_active_calls_allowed",
        "max_outgoing_active_calls_allowed",
        "default_group_for_new_users",
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "max_active_calls_allowed",
                "maxActiveCallsAllowed",
                int,
                is_required=True,
            ),
            E(
                "max_incoming_active_calls_allowed",
                "maxIncomingActiveCallsAllowed",
                int,
            ),
            E(
                "max_outgoing_active_calls_allowed",
                "maxOutgoingActiveCallsAllowed",
                int,
            ),
            E(
                "default_group_for_new_users",
                "defaultGroupForNewUsers",
                bool,
                is_required=True,
            ),
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterAgentThresholdDefaultProfileGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterAgentThresholdDefaultProfileGetRequest()`.

    The agent table contains the agents assigned to the profile and has column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_name (str): profileName
        profile_description (str): profileDescription *Optional*
        threshold_current_call_state_idle_time_yellow (int):
            thresholdCurrentCallStateIdleTimeYellow *Optional*
        threshold_current_call_state_idle_time_red (int):
            thresholdCurrentCallStateIdleTimeRed *Optional*
        threshold_current_call_state_on_call_time_yellow (int):
            thresholdCurrentCallStateOnCallTimeYellow *Optional*
        threshold_current_call_state_on_call_time_red (int):
            thresholdCurrentCallStateOnCallTimeRed *Optional*
        threshold_current_agent_state_unavailable_time_yellow (int):
            thresholdCurrentAgentStateUnavailableTimeYellow *Optional*
        threshold_current_agent_state_unavailable_time_red (int):
            thresholdCurrentAgentStateUnavailableTimeRed *Optional*
        threshold_average_busy_in_time_yellow (int): thresholdAverageBusyInTimeYellow
            *Optional*
        threshold_average_busy_in_time_red (int): thresholdAverageBusyInTimeRed *Optional*
        threshold_average_busy_out_time_yellow (int): thresholdAverageBusyOutTimeYellow
            *Optional*
        threshold_average_busy_out_time_red (int): thresholdAverageBusyOutTimeRed
            *Optional*
        threshold_average_wrap_up_time_yellow (int): thresholdAverageWrapUpTimeYellow
            *Optional*
        threshold_average_wrap_up_time_red (int): thresholdAverageWrapUpTimeRed *Optional*
        enable_notification_email (bool): enableNotificationEmail
        notification_email_address (List[str]): notificationEmailAddress *Optional*
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples *Optional*
    """

    __slots__: List[str] = [
        "profile_name",
        "profile_description",
        "threshold_current_call_state_idle_time_yellow",
        "threshold_current_call_state_idle_time_red",
        "threshold_current_call_state_on_call_time_yellow",
        "threshold_current_call_state_on_call_time_red",
        "threshold_current_agent_state_unavailable_time_yellow",
        "threshold_current_agent_state_unavailable_time_red",
        "threshold_average_busy_in_time_yellow",
        "threshold_average_busy_in_time_red",
        "threshold_average_busy_out_time_yellow",
        "threshold_average_busy_out_time_red",
        "threshold_average_wrap_up_time_yellow",
        "threshold_average_wrap_up_time_red",
        "enable_notification_email",
        "notification_email_address",
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
            E(
                "profile_description",
                "profileDescription",
                str,
            ),
            E(
                "threshold_current_call_state_idle_time_yellow",
                "thresholdCurrentCallStateIdleTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_idle_time_red",
                "thresholdCurrentCallStateIdleTimeRed",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_yellow",
                "thresholdCurrentCallStateOnCallTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_red",
                "thresholdCurrentCallStateOnCallTimeRed",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_yellow",
                "thresholdCurrentAgentStateUnavailableTimeYellow",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_red",
                "thresholdCurrentAgentStateUnavailableTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_in_time_yellow",
                "thresholdAverageBusyInTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_in_time_red",
                "thresholdAverageBusyInTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_out_time_yellow",
                "thresholdAverageBusyOutTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_out_time_red",
                "thresholdAverageBusyOutTimeRed",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_yellow",
                "thresholdAverageWrapUpTimeYellow",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_red",
                "thresholdAverageWrapUpTimeRed",
                int,
            ),
            E(
                "enable_notification_email",
                "enableNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "notification_email_address",
                "notificationEmailAddress",
                str,
                is_array=True,
            ),
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_table=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterAgentThresholdProfileGetAvailableAgentListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address", "Agent Threshold Profile";

    Attributes:
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileGetAvailableAgentPagedSortedListResponse(OCIResponse):
    """
    Response to the
    `GroupCallCenterAgentThresholdProfileGetAvailableAgentPagedSortedListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address", "Agent Threshold Profile";

    Attributes:
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileGetListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterAgentThresholdProfileGetListRequest()`.

    Contains a table with all the Call Center Agent Threshold Profiles in the Group.  The
    column headings are: "Default", "Name", "Description".

    Attributes:
        profiles_table (List(profilesTable)): profilesTable - *Table* array of
            profilesTable named tuples
    """

    __slots__: List[str] = [
        "profiles_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profiles_table",
                "profilesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileGetPagedSortedResponse(OCIResponse):
    """
    Response to the `GroupCallCenterAgentThresholdProfileGetPagedSortedRequest()`.

    The agentTable contains the agents assigned to the profile and has the column
    headings: "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_description (str): profileDescription *Optional*
        threshold_current_call_state_idle_time_yellow (int):
            thresholdCurrentCallStateIdleTimeYellow *Optional*
        threshold_current_call_state_idle_time_red (int):
            thresholdCurrentCallStateIdleTimeRed *Optional*
        threshold_current_call_state_on_call_time_yellow (int):
            thresholdCurrentCallStateOnCallTimeYellow *Optional*
        threshold_current_call_state_on_call_time_red (int):
            thresholdCurrentCallStateOnCallTimeRed *Optional*
        threshold_current_agent_state_unavailable_time_yellow (int):
            thresholdCurrentAgentStateUnavailableTimeYellow *Optional*
        threshold_current_agent_state_unavailable_time_red (int):
            thresholdCurrentAgentStateUnavailableTimeRed *Optional*
        threshold_average_busy_in_time_yellow (int): thresholdAverageBusyInTimeYellow
            *Optional*
        threshold_average_busy_in_time_red (int): thresholdAverageBusyInTimeRed *Optional*
        threshold_average_busy_out_time_yellow (int): thresholdAverageBusyOutTimeYellow
            *Optional*
        threshold_average_busy_out_time_red (int): thresholdAverageBusyOutTimeRed
            *Optional*
        threshold_average_wrap_up_time_yellow (int): thresholdAverageWrapUpTimeYellow
            *Optional*
        threshold_average_wrap_up_time_red (int): thresholdAverageWrapUpTimeRed *Optional*
        enable_notification_email (bool): enableNotificationEmail
        notification_email_address (List[str]): notificationEmailAddress *Optional*
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "profile_description",
        "threshold_current_call_state_idle_time_yellow",
        "threshold_current_call_state_idle_time_red",
        "threshold_current_call_state_on_call_time_yellow",
        "threshold_current_call_state_on_call_time_red",
        "threshold_current_agent_state_unavailable_time_yellow",
        "threshold_current_agent_state_unavailable_time_red",
        "threshold_average_busy_in_time_yellow",
        "threshold_average_busy_in_time_red",
        "threshold_average_busy_out_time_yellow",
        "threshold_average_busy_out_time_red",
        "threshold_average_wrap_up_time_yellow",
        "threshold_average_wrap_up_time_red",
        "enable_notification_email",
        "notification_email_address",
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_description",
                "profileDescription",
                str,
            ),
            E(
                "threshold_current_call_state_idle_time_yellow",
                "thresholdCurrentCallStateIdleTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_idle_time_red",
                "thresholdCurrentCallStateIdleTimeRed",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_yellow",
                "thresholdCurrentCallStateOnCallTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_red",
                "thresholdCurrentCallStateOnCallTimeRed",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_yellow",
                "thresholdCurrentAgentStateUnavailableTimeYellow",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_red",
                "thresholdCurrentAgentStateUnavailableTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_in_time_yellow",
                "thresholdAverageBusyInTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_in_time_red",
                "thresholdAverageBusyInTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_out_time_yellow",
                "thresholdAverageBusyOutTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_out_time_red",
                "thresholdAverageBusyOutTimeRed",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_yellow",
                "thresholdAverageWrapUpTimeYellow",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_red",
                "thresholdAverageWrapUpTimeRed",
                int,
            ),
            E(
                "enable_notification_email",
                "enableNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "notification_email_address",
                "notificationEmailAddress",
                str,
                is_array=True,
            ),
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterAgentThresholdProfileGetRequest()`.

    The agentTable contains the agents assigned to the profile and has the column
    headings: "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_description (str): profileDescription *Optional*
        threshold_current_call_state_idle_time_yellow (int):
            thresholdCurrentCallStateIdleTimeYellow *Optional*
        threshold_current_call_state_idle_time_red (int):
            thresholdCurrentCallStateIdleTimeRed *Optional*
        threshold_current_call_state_on_call_time_yellow (int):
            thresholdCurrentCallStateOnCallTimeYellow *Optional*
        threshold_current_call_state_on_call_time_red (int):
            thresholdCurrentCallStateOnCallTimeRed *Optional*
        threshold_current_agent_state_unavailable_time_yellow (int):
            thresholdCurrentAgentStateUnavailableTimeYellow *Optional*
        threshold_current_agent_state_unavailable_time_red (int):
            thresholdCurrentAgentStateUnavailableTimeRed *Optional*
        threshold_average_busy_in_time_yellow (int): thresholdAverageBusyInTimeYellow
            *Optional*
        threshold_average_busy_in_time_red (int): thresholdAverageBusyInTimeRed *Optional*
        threshold_average_busy_out_time_yellow (int): thresholdAverageBusyOutTimeYellow
            *Optional*
        threshold_average_busy_out_time_red (int): thresholdAverageBusyOutTimeRed
            *Optional*
        threshold_average_wrap_up_time_yellow (int): thresholdAverageWrapUpTimeYellow
            *Optional*
        threshold_average_wrap_up_time_red (int): thresholdAverageWrapUpTimeRed *Optional*
        enable_notification_email (bool): enableNotificationEmail
        notification_email_address (List[str]): notificationEmailAddress *Optional*
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "profile_description",
        "threshold_current_call_state_idle_time_yellow",
        "threshold_current_call_state_idle_time_red",
        "threshold_current_call_state_on_call_time_yellow",
        "threshold_current_call_state_on_call_time_red",
        "threshold_current_agent_state_unavailable_time_yellow",
        "threshold_current_agent_state_unavailable_time_red",
        "threshold_average_busy_in_time_yellow",
        "threshold_average_busy_in_time_red",
        "threshold_average_busy_out_time_yellow",
        "threshold_average_busy_out_time_red",
        "threshold_average_wrap_up_time_yellow",
        "threshold_average_wrap_up_time_red",
        "enable_notification_email",
        "notification_email_address",
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_description",
                "profileDescription",
                str,
            ),
            E(
                "threshold_current_call_state_idle_time_yellow",
                "thresholdCurrentCallStateIdleTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_idle_time_red",
                "thresholdCurrentCallStateIdleTimeRed",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_yellow",
                "thresholdCurrentCallStateOnCallTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_red",
                "thresholdCurrentCallStateOnCallTimeRed",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_yellow",
                "thresholdCurrentAgentStateUnavailableTimeYellow",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_red",
                "thresholdCurrentAgentStateUnavailableTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_in_time_yellow",
                "thresholdAverageBusyInTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_in_time_red",
                "thresholdAverageBusyInTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_out_time_yellow",
                "thresholdAverageBusyOutTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_out_time_red",
                "thresholdAverageBusyOutTimeRed",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_yellow",
                "thresholdAverageWrapUpTimeYellow",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_red",
                "thresholdAverageWrapUpTimeRed",
                int,
            ),
            E(
                "enable_notification_email",
                "enableNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "notification_email_address",
                "notificationEmailAddress",
                str,
                is_array=True,
            ),
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterAgentUnavailableCodeGetListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterAgentUnavailableCodeGetListRequest()`.

    Contains a table with column headings: "Is Active", "Code", "Description".

    Attributes:
        unavailable_codes_table (List(unavailableCodesTable)): unavailableCodesTable -
            *Table* array of unavailableCodesTable named tuples
    """

    __slots__: List[str] = [
        "unavailable_codes_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "unavailable_codes_table",
                "unavailableCodesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterAgentUnavailableCodeGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterAgentUnavailableCodeGetRequest()`

    Attributes:
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupCallCenterAgentUnavailableCodeSettingsGetResponse(OCIResponse):
    """
    Response to `GroupCallCenterAgentUnavailableCodeSettingsGetRequest()`.

    Replaced by `GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()`.

    Attributes:
        enable_agent_unavailable_codes (bool): enableAgentUnavailableCodes
        default_agent_unavailable_code_on_dnd (str): defaultAgentUnavailableCodeOnDND
            *Optional*
        default_agent_unavailable_code_on_personal_calls (str):
            defaultAgentUnavailableCodeOnPersonalCalls *Optional*
        default_agent_unavailable_code_on_consecutive_bounces (str):
            defaultAgentUnavailableCodeOnConsecutiveBounces *Optional*
        force_use_of_agent_unavailable_codes (bool): forceUseOfAgentUnavailableCodes
        default_agent_unavailable_code (str): defaultAgentUnavailableCode *Optional*
    """

    __slots__: List[str] = [
        "enable_agent_unavailable_codes",
        "default_agent_unavailable_code_on_dnd",
        "default_agent_unavailable_code_on_personal_calls",
        "default_agent_unavailable_code_on_consecutive_bounces",
        "force_use_of_agent_unavailable_codes",
        "default_agent_unavailable_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_agent_unavailable_codes",
                "enableAgentUnavailableCodes",
                bool,
                is_required=True,
            ),
            E(
                "default_agent_unavailable_code_on_dnd",
                "defaultAgentUnavailableCodeOnDND",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_personal_calls",
                "defaultAgentUnavailableCodeOnPersonalCalls",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_consecutive_bounces",
                "defaultAgentUnavailableCodeOnConsecutiveBounces",
                str,
            ),
            E(
                "force_use_of_agent_unavailable_codes",
                "forceUseOfAgentUnavailableCodes",
                bool,
                is_required=True,
            ),
            E(
                "default_agent_unavailable_code",
                "defaultAgentUnavailableCode",
                str,
            ),
        )


class GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4(OCIResponse):
    """
    Response to `GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()`.


    Attributes:
        enable_agent_unavailable_codes (bool): enableAgentUnavailableCodes
        default_agent_unavailable_code_on_dnd (str): defaultAgentUnavailableCodeOnDND
            *Optional*
        default_agent_unavailable_code_on_personal_calls (str):
            defaultAgentUnavailableCodeOnPersonalCalls *Optional*
        default_agent_unavailable_code_on_consecutive_bounces (str):
            defaultAgentUnavailableCodeOnConsecutiveBounces *Optional*
        default_agent_unavailable_code_on_not_reachable (str):
            defaultAgentUnavailableCodeOnNotReachable *Optional*
        force_use_of_agent_unavailable_codes (bool): forceUseOfAgentUnavailableCodes
        default_agent_unavailable_code (str): defaultAgentUnavailableCode *Optional*
    """

    __slots__: List[str] = [
        "enable_agent_unavailable_codes",
        "default_agent_unavailable_code_on_dnd",
        "default_agent_unavailable_code_on_personal_calls",
        "default_agent_unavailable_code_on_consecutive_bounces",
        "default_agent_unavailable_code_on_not_reachable",
        "force_use_of_agent_unavailable_codes",
        "default_agent_unavailable_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_agent_unavailable_codes",
                "enableAgentUnavailableCodes",
                bool,
                is_required=True,
            ),
            E(
                "default_agent_unavailable_code_on_dnd",
                "defaultAgentUnavailableCodeOnDND",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_personal_calls",
                "defaultAgentUnavailableCodeOnPersonalCalls",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_consecutive_bounces",
                "defaultAgentUnavailableCodeOnConsecutiveBounces",
                str,
            ),
            E(
                "default_agent_unavailable_code_on_not_reachable",
                "defaultAgentUnavailableCodeOnNotReachable",
                str,
            ),
            E(
                "force_use_of_agent_unavailable_codes",
                "forceUseOfAgentUnavailableCodes",
                bool,
                is_required=True,
            ),
            E(
                "default_agent_unavailable_code",
                "defaultAgentUnavailableCode",
                str,
            ),
        )


class GroupCallCenterBouncedCallGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterBouncedCallGetRequest()`.


    Attributes:
        is_active (bool): isActive
        number_of_rings_before_bouncing_call (int): numberOfRingsBeforeBouncingCall
        enable_transfer (bool): enableTransfer *Optional*
        transfer_phone_number (str): transferPhoneNumber *Optional*
        bounce_call_when_agent_unavailable (bool): bounceCallWhenAgentUnavailable
    """

    __slots__: List[str] = [
        "is_active",
        "number_of_rings_before_bouncing_call",
        "enable_transfer",
        "transfer_phone_number",
        "bounce_call_when_agent_unavailable",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "number_of_rings_before_bouncing_call",
                "numberOfRingsBeforeBouncingCall",
                int,
                is_required=True,
            ),
            E(
                "enable_transfer",
                "enableTransfer",
                bool,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "bounce_call_when_agent_unavailable",
                "bounceCallWhenAgentUnavailable",
                bool,
                is_required=True,
            ),
        )


class GroupCallCenterBouncedCallGetResponse17(OCIResponse):
    """
    Response to the `GroupCallCenterBouncedCallGetRequest17()`.

    The following elements are only used in AS data mode and not returned in XS data mode:
    enableTransfer transferPhoneNumber bounceCallWhenAgentUnavailable
    alertCallCenterCallOnHold alertCallCenterCallOnHoldSeconds bounceCallCenterCallOnHold
    bounceCallCenterCallOnHoldSeconds

    Attributes:
        is_active (bool): isActive
        number_of_rings_before_bouncing_call (int): numberOfRingsBeforeBouncingCall
        enable_transfer (bool): enableTransfer *Optional*
        transfer_phone_number (str): transferPhoneNumber *Optional*
        bounce_call_when_agent_unavailable (bool): bounceCallWhenAgentUnavailable
            *Optional*
        alert_call_center_call_on_hold (bool): alertCallCenterCallOnHold *Optional*
        alert_call_center_call_on_hold_seconds (int): alertCallCenterCallOnHoldSeconds
            *Optional*
        bounce_call_center_call_on_hold (bool): bounceCallCenterCallOnHold *Optional*
        bounce_call_center_call_on_hold_seconds (int): bounceCallCenterCallOnHoldSeconds
            *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "number_of_rings_before_bouncing_call",
        "enable_transfer",
        "transfer_phone_number",
        "bounce_call_when_agent_unavailable",
        "alert_call_center_call_on_hold",
        "alert_call_center_call_on_hold_seconds",
        "bounce_call_center_call_on_hold",
        "bounce_call_center_call_on_hold_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "number_of_rings_before_bouncing_call",
                "numberOfRingsBeforeBouncingCall",
                int,
                is_required=True,
            ),
            E(
                "enable_transfer",
                "enableTransfer",
                bool,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "bounce_call_when_agent_unavailable",
                "bounceCallWhenAgentUnavailable",
                bool,
            ),
            E(
                "alert_call_center_call_on_hold",
                "alertCallCenterCallOnHold",
                bool,
            ),
            E(
                "alert_call_center_call_on_hold_seconds",
                "alertCallCenterCallOnHoldSeconds",
                int,
            ),
            E(
                "bounce_call_center_call_on_hold",
                "bounceCallCenterCallOnHold",
                bool,
            ),
            E(
                "bounce_call_center_call_on_hold_seconds",
                "bounceCallCenterCallOnHoldSeconds",
                int,
            ),
        )


class GroupCallCenterCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterCallDispositionCodeGetListRequest()`.

    Contains a table with column headings: "Is Active", "Code", "Description".

    Attributes:
        disposition_codes_table (List(dispositionCodesTable)): dispositionCodesTable -
            *Table* array of dispositionCodesTable named tuples
    """

    __slots__: List[str] = [
        "disposition_codes_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disposition_codes_table",
                "dispositionCodesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterCallDispositionCodeGetRequest()`

    Attributes:
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupCallCenterCallDispositionCodeGetUsageListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterCallDispositionCodeGetUsageListRequest()`.

    The Type column contains either "Call Center" or "Route Point". Contains a table with
    column headings: "Id", "Name" and "Type".

    Attributes:
        call_center_table (List(callCenterTable)): callCenterTable - *Table* array of
            callCenterTable named tuples
    """

    __slots__: List[str] = [
        "call_center_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_center_table",
                "callCenterTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterComfortMessageBypassGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterComfortMessageBypassGetRequest()`.


    Attributes:
        is_active (bool): isActive
        call_waiting_age_threshold_seconds (int): callWaitingAgeThresholdSeconds
        play_announcement_after_ringing (bool): playAnnouncementAfterRinging
        ring_time_before_playing_announcement_seconds (int):
            ringTimeBeforePlayingAnnouncementSeconds
        audio_message_selection (str): audioMessageSelection
        audio_file_url (str): audioFileUrl *Optional*
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_message_selection (str): videoMessageSelection
        video_file_url (str): videoFileUrl *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "call_waiting_age_threshold_seconds",
        "play_announcement_after_ringing",
        "ring_time_before_playing_announcement_seconds",
        "audio_message_selection",
        "audio_file_url",
        "audio_file_description",
        "audio_media_type",
        "video_message_selection",
        "video_file_url",
        "video_file_description",
        "video_media_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "call_waiting_age_threshold_seconds",
                "callWaitingAgeThresholdSeconds",
                int,
                is_required=True,
            ),
            E(
                "play_announcement_after_ringing",
                "playAnnouncementAfterRinging",
                bool,
                is_required=True,
            ),
            E(
                "ring_time_before_playing_announcement_seconds",
                "ringTimeBeforePlayingAnnouncementSeconds",
                int,
                is_required=True,
            ),
            E(
                "audio_message_selection",
                "audioMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_message_selection",
                "videoMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
        )


class GroupCallCenterCurrentAndPastAgentGetListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterCurrentAndPastAgentGetListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_user_table (List(agentUserTable)): agentUserTable - *Table* array of
            agentUserTable named tuples
        deleted_agent_user_table (List(deletedAgentUserTable)): deletedAgentUserTable -
            *Table* array of deletedAgentUserTable named tuples
    """

    __slots__: List[str] = [
        "agent_user_table",
        "deleted_agent_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_user_table",
                "agentUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
            E(
                "deleted_agent_user_table",
                "deletedAgentUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterCurrentAndPastCallCenterGetListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterCurrentAndPastCallCenterGetListRequest()`.


    Attributes:
        service_user_id (List[str]): serviceUserId *Optional*
        deleted_service_user_id (List[str]): deletedServiceUserId *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "deleted_service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_array=True,
            ),
            E(
                "deleted_service_user_id",
                "deletedServiceUserId",
                str,
                is_array=True,
            ),
        )


class GroupCallCenterCurrentAndPastDNISGetListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterCurrentAndPastDNISGetListRequest()`.


    Attributes:
        name (List[str]): name *Optional*
        deleted_name (List[str]): deletedName *Optional*
    """

    __slots__: List[str] = [
        "name",
        "deleted_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
            E(
                "deleted_name",
                "deletedName",
                str,
                is_array=True,
            ),
        )


class GroupCallCenterDistinctiveRingingGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterDistinctiveRingingGetRequest()`.

    The following element is only used in AS data mode and not returned in XS data mode:
    distinctiveRingingForceDeliveryRingPattern

    Attributes:
        distinctive_ringing_call_center_calls (bool): distinctiveRingingCallCenterCalls
        distinctive_ringing_ring_pattern_for_call_center (str):
            distinctiveRingingRingPatternForCallCenter
        distinctive_ringing_force_delivery_ring_pattern (str):
            distinctiveRingingForceDeliveryRingPattern *Optional*
    """

    __slots__: List[str] = [
        "distinctive_ringing_call_center_calls",
        "distinctive_ringing_ring_pattern_for_call_center",
        "distinctive_ringing_force_delivery_ring_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "distinctive_ringing_call_center_calls",
                "distinctiveRingingCallCenterCalls",
                bool,
                is_required=True,
            ),
            E(
                "distinctive_ringing_ring_pattern_for_call_center",
                "distinctiveRingingRingPatternForCallCenter",
                str,
                is_required=True,
            ),
            E(
                "distinctive_ringing_force_delivery_ring_pattern",
                "distinctiveRingingForceDeliveryRingPattern",
                str,
            ),
        )


class GroupCallCenterEnhancedGetResponse(OCIResponse):
    """
    Response to `GroupCallCenterEnhancedGetRequest()`.


    Attributes:
        override_agent_wrap_up_time (bool): overrideAgentWrapUpTime
        wrap_up_seconds (int): wrapUpSeconds *Optional*
    """

    __slots__: List[str] = [
        "override_agent_wrap_up_time",
        "wrap_up_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "override_agent_wrap_up_time",
                "overrideAgentWrapUpTime",
                bool,
                is_required=True,
            ),
            E(
                "wrap_up_seconds",
                "wrapUpSeconds",
                int,
            ),
        )


class GroupCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterEnhancedReportingBrandingGetRequest()`.


    Attributes:
        branding_choice (str): brandingChoice
        branding_file_description (str): brandingFileDescription *Optional*
    """

    __slots__: List[str] = [
        "branding_choice",
        "branding_file_description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "branding_choice",
                "brandingChoice",
                str,
                is_required=True,
            ),
            E(
                "branding_file_description",
                "brandingFileDescription",
                str,
            ),
        )


class GroupCallCenterEnhancedReportingGetAvailableReportTemplateListResponse(OCIResponse):
    """
    Response to `GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest()`.

    Contains a table with column headings: "Name", "Description" and "Level", "Is Agent
    Required", "Is Call Center Required", "Is Call Center Dnis Required","Is Real Time
    Report", "Is Sampling Period Required", "Call Completion Threshold Parameter", "Short
    Duration Threshold Parameter", "Service Level Threshold Parameter", "Service Level
    Inclusions Parameter", "Service Level Objective Threshold Parameter", "Abandoned Call
    Threshold Parameter", "Service Level Threshold Parameter Number", and "Abandoned Call
    Threshold Parameter Number". The possible values for "Level" are "System" and "Group".
    The possible values for "Is Agent Required", "Is Call Center Required", "Is Call
    Center Dnis Required", "Is Real Time Report" and "Is Sampling Period Required" are
    "true" and "false". The possible values for "Call Completion Threshold Parameter",
    "Short Duration Threshold Parameter", "Service Level Threshold Parameter", "Service
    Level Inclusions Parameter","Service Level Objective Threshold Parameter" and
    "Abandoned Call Threshold Parameter" are "Required", "Hidden" and "Does Not Apply".

    Attributes:
        report_template_table (List(reportTemplateTable)): reportTemplateTable - *Table*
            array of reportTemplateTable named tuples
    """

    __slots__: List[str] = [
        "report_template_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "report_template_table",
                "reportTemplateTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to `GroupCallCenterEnhancedReportingGetRequest()`.

    Replaced by `GroupCallCenterEnhancedReportingGetResponse19()`

    Attributes:
        reporting_server (str): reportingServer
        web_statistic_source (str): webStatisticSource
    """

    __slots__: List[str] = [
        "reporting_server",
        "web_statistic_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reporting_server",
                "reportingServer",
                str,
                is_required=True,
            ),
            E(
                "web_statistic_source",
                "webStatisticSource",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingGetResponse19(OCIResponse):
    """
    Response to `GroupCallCenterEnhancedReportingGetRequest19()`.


    Attributes:
        reporting_server (str): reportingServer
    """

    __slots__: List[str] = [
        "reporting_server",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reporting_server",
                "reportingServer",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to `GroupCallCenterEnhancedReportingReportTemplateGetListRequest()`.

    Contains a table with column headings: "Name", "Description", "Type" and "Enabled"

    Attributes:
        report_template_table (List(reportTemplateTable)): reportTemplateTable - *Table*
            array of reportTemplateTable named tuples
    """

    __slots__: List[str] = [
        "report_template_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "report_template_table",
                "reportTemplateTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to `GroupCallCenterEnhancedReportingReportTemplateGetRequest()`.


    Attributes:
        description (str): description *Optional*
        data_template (str): dataTemplate
        filter_number (int): filterNumber *Optional*
        xslt_template_description (str): xsltTemplateDescription
        scope (str): scope
        is_enabled (bool): isEnabled
        is_realtime_report (bool): isRealtimeReport *Optional*
        call_completion_threshold_param (str): callCompletionThresholdParam *Optional*
        short_duration_threshold_param (str): shortDurationThresholdParam *Optional*
        service_level_threshold_param (str): serviceLevelThresholdParam *Optional*
        service_level_inclusions_param (str): serviceLevelInclusionsParam *Optional*
        service_level_objective_threshold_param (str): serviceLevelObjectiveThresholdParam
            *Optional*
        abandoned_call_threshold_param (str): abandonedCallThresholdParam *Optional*
        service_level_threshold_param_number (int): serviceLevelThresholdParamNumber
            *Optional*
        abandoned_call_threshold_param_number (int): abandonedCallThresholdParamNumber
            *Optional*
        filter_value (List[str]): filterValue *Optional*
    """

    __slots__: List[str] = [
        "description",
        "data_template",
        "filter_number",
        "xslt_template_description",
        "scope",
        "is_enabled",
        "is_realtime_report",
        "call_completion_threshold_param",
        "short_duration_threshold_param",
        "service_level_threshold_param",
        "service_level_inclusions_param",
        "service_level_objective_threshold_param",
        "abandoned_call_threshold_param",
        "service_level_threshold_param_number",
        "abandoned_call_threshold_param_number",
        "filter_value",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "data_template",
                "dataTemplate",
                str,
                is_required=True,
            ),
            E(
                "filter_number",
                "filterNumber",
                int,
            ),
            E(
                "xslt_template_description",
                "xsltTemplateDescription",
                str,
                is_required=True,
            ),
            E(
                "scope",
                "scope",
                str,
                is_required=True,
            ),
            E(
                "is_enabled",
                "isEnabled",
                bool,
                is_required=True,
            ),
            E(
                "is_realtime_report",
                "isRealtimeReport",
                bool,
            ),
            E(
                "call_completion_threshold_param",
                "callCompletionThresholdParam",
                str,
            ),
            E(
                "short_duration_threshold_param",
                "shortDurationThresholdParam",
                str,
            ),
            E(
                "service_level_threshold_param",
                "serviceLevelThresholdParam",
                str,
            ),
            E(
                "service_level_inclusions_param",
                "serviceLevelInclusionsParam",
                str,
            ),
            E(
                "service_level_objective_threshold_param",
                "serviceLevelObjectiveThresholdParam",
                str,
            ),
            E(
                "abandoned_call_threshold_param",
                "abandonedCallThresholdParam",
                str,
            ),
            E(
                "service_level_threshold_param_number",
                "serviceLevelThresholdParamNumber",
                int,
            ),
            E(
                "abandoned_call_threshold_param_number",
                "abandonedCallThresholdParamNumber",
                int,
            ),
            E(
                "filter_value",
                "filterValue",
                str,
                is_array=True,
            ),
        )


class GroupCallCenterEnhancedReportingScheduledReportGetActiveListResponse(OCIResponse):
    """
    Response to `GroupCallCenterEnhancedReportingScheduledReportGetActiveListRequest()`
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System" and "Group".

    Attributes:
        scheduled_report_table (List(scheduledReportTable)): scheduledReportTable -
            *Table* array of scheduledReportTable named tuples
    """

    __slots__: List[str] = [
        "scheduled_report_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "scheduled_report_table",
                "scheduledReportTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(OCIResponse):
    """
    Response to `GroupCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()`
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System" and "Group".

    Attributes:
        scheduled_report_table (List(scheduledReportTable)): scheduledReportTable -
            *Table* array of scheduledReportTable named tuples
    """

    __slots__: List[str] = [
        "scheduled_report_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "scheduled_report_table",
                "scheduledReportTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to `GroupCallCenterEnhancedReportingScheduledReportGetListRequest()`.

    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Status", "Report Template Name", "Report Template Level" and
    "Recurring". The "Created By" can be either "Administrator" or user id if created by
    supervisor.  The possible values for "Status" are "Active", and "Completed". The
    possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Template Level" are "System" and "Group".

    Attributes:
        scheduled_report_table (List(scheduledReportTable)): scheduledReportTable -
            *Table* array of scheduledReportTable named tuples
    """

    __slots__: List[str] = [
        "scheduled_report_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "scheduled_report_table",
                "scheduledReportTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(OCIResponse):
    """
    Response to
    `GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()`.

    Contains a table with column headings: "Schedule Name", "Created By", "Created By
    Supervisor", and "Is Active". The "Created By" can be either "Administrator" or user
    id if created by supervisor.

    Attributes:
        schedule_report_table (List(scheduleReportTable)): scheduleReportTable - *Table*
            array of scheduleReportTable named tuples
    """

    __slots__: List[str] = [
        "schedule_report_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "schedule_report_table",
                "scheduleReportTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterForcedForwardingGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterForcedForwardingGetRequest()`.


    Attributes:
        is_active (bool): isActive
        forward_to_phone_number (str): forwardToPhoneNumber *Optional*
        allow_enable_via_fac (bool): allowEnableViaFAC
        play_announcement_before_forwarding (bool): playAnnouncementBeforeForwarding
        audio_message_selection (str): audioMessageSelection
        audio_file_url (str): audioFileUrl *Optional*
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_message_selection (str): videoMessageSelection
        video_file_url (str): videoFileUrl *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "forward_to_phone_number",
        "allow_enable_via_fac",
        "play_announcement_before_forwarding",
        "audio_message_selection",
        "audio_file_url",
        "audio_file_description",
        "audio_media_type",
        "video_message_selection",
        "video_file_url",
        "video_file_description",
        "video_media_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "forward_to_phone_number",
                "forwardToPhoneNumber",
                str,
            ),
            E(
                "allow_enable_via_fac",
                "allowEnableViaFAC",
                bool,
                is_required=True,
            ),
            E(
                "play_announcement_before_forwarding",
                "playAnnouncementBeforeForwarding",
                bool,
                is_required=True,
            ),
            E(
                "audio_message_selection",
                "audioMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_message_selection",
                "videoMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
        )


class GroupCallCenterGetAgentListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetAgentListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Weight", "Phone Number", "Extension",
    "Department", "Email Address", "Skill Level". The following column is only returned in
    AS data mode: "Skill Level"

    Attributes:
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetAgentPagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetAgentPagedSortedListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Weight", "Phone Number", "Extension",
    "Department", "Email Address", "Skill Level".

    Attributes:
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetAnnouncementResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetAnnouncementRequest()`.


    Attributes:
        entrance_message_selection (str): entranceMessageSelection
        entrance_message_audio_file_description (str): entranceMessageAudioFileDescription
            *Optional*
        entrance_message_video_file_description (str): entranceMessageVideoFileDescription
            *Optional*
        periodic_comfort_message_selection (str): periodicComfortMessageSelection
        periodic_comfort_message_audio_file_description (str):
            periodicComfortMessageAudioFileDescription *Optional*
        periodic_comfort_message_video_file_description (str):
            periodicComfortMessageVideoFileDescription *Optional*
        on_hold_message_selection (str): onHoldMessageSelection
        on_hold_message_audio_file_description (str): onHoldMessageAudioFileDescription
            *Optional*
        on_hold_message_video_file_description (str): onHoldMessageVideoFileDescription
            *Optional*
    """

    __slots__: List[str] = [
        "entrance_message_selection",
        "entrance_message_audio_file_description",
        "entrance_message_video_file_description",
        "periodic_comfort_message_selection",
        "periodic_comfort_message_audio_file_description",
        "periodic_comfort_message_video_file_description",
        "on_hold_message_selection",
        "on_hold_message_audio_file_description",
        "on_hold_message_video_file_description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "entrance_message_selection",
                "entranceMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "entrance_message_audio_file_description",
                "entranceMessageAudioFileDescription",
                str,
            ),
            E(
                "entrance_message_video_file_description",
                "entranceMessageVideoFileDescription",
                str,
            ),
            E(
                "periodic_comfort_message_selection",
                "periodicComfortMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "periodic_comfort_message_audio_file_description",
                "periodicComfortMessageAudioFileDescription",
                str,
            ),
            E(
                "periodic_comfort_message_video_file_description",
                "periodicComfortMessageVideoFileDescription",
                str,
            ),
            E(
                "on_hold_message_selection",
                "onHoldMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "on_hold_message_audio_file_description",
                "onHoldMessageAudioFileDescription",
                str,
            ),
            E(
                "on_hold_message_video_file_description",
                "onHoldMessageVideoFileDescription",
                str,
            ),
        )


class GroupCallCenterGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetAvailableAgentListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetAvailableAgentPagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetAvailableAgentPagedSortedListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetAvailableSupervisorListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetAvailableSupervisorListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetDNISAgentListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetDNISAgentListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetDNISListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetDNISListResponse()`.

    Contains a table with column headings: "Name", "Phone Number", "Extension",
    "Priority", "Is Primary DNIS".

    Attributes:
        display_dnis_number (bool): displayDNISNumber
        display_dnis_name (bool): displayDNISName
        promote_calls_from_priority1to0 (bool): promoteCallsFromPriority1to0
        promote_calls_from_priority2to1 (bool): promoteCallsFromPriority2to1
        promote_calls_from_priority3to2 (bool): promoteCallsFromPriority3to2
        promote_calls_from_priority1to0_seconds (int): promoteCallsFromPriority1to0Seconds
        promote_calls_from_priority2to1_seconds (int): promoteCallsFromPriority2to1Seconds
        promote_calls_from_priority3to2_seconds (int): promoteCallsFromPriority3to2Seconds
        dnis_table (List(dnisTable)): dnisTable - *Table* array of dnisTable named tuples
    """

    __slots__: List[str] = [
        "display_dnis_number",
        "display_dnis_name",
        "promote_calls_from_priority1to0",
        "promote_calls_from_priority2to1",
        "promote_calls_from_priority3to2",
        "promote_calls_from_priority1to0_seconds",
        "promote_calls_from_priority2to1_seconds",
        "promote_calls_from_priority3to2_seconds",
        "dnis_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "display_dnis_number",
                "displayDNISNumber",
                bool,
                is_required=True,
            ),
            E(
                "display_dnis_name",
                "displayDNISName",
                bool,
                is_required=True,
            ),
            E(
                "promote_calls_from_priority1to0",
                "promoteCallsFromPriority1to0",
                bool,
                is_required=True,
            ),
            E(
                "promote_calls_from_priority2to1",
                "promoteCallsFromPriority2to1",
                bool,
                is_required=True,
            ),
            E(
                "promote_calls_from_priority3to2",
                "promoteCallsFromPriority3to2",
                bool,
                is_required=True,
            ),
            E(
                "promote_calls_from_priority1to0_seconds",
                "promoteCallsFromPriority1to0Seconds",
                int,
                is_required=True,
            ),
            E(
                "promote_calls_from_priority2to1_seconds",
                "promoteCallsFromPriority2to1Seconds",
                int,
                is_required=True,
            ),
            E(
                "promote_calls_from_priority3to2_seconds",
                "promoteCallsFromPriority3to2Seconds",
                int,
                is_required=True,
            ),
            E(
                "dnis_table",
                "dnisTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetDNISResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetDNISResponse()`.


    Attributes:
        dnis_phone_number (str): dnisPhoneNumber *Optional*
        extension (str): extension *Optional*
        use_custom_clid_settings (bool): useCustomCLIDSettings
        calling_line_id_phone_number (str): callingLineIdPhoneNumber *Optional*
        calling_line_id_last_name (str): callingLineIdLastName *Optional*
        calling_line_id_first_name (str): callingLineIdFirstName *Optional*
        use_custom_dnis_announcement_settings (bool): useCustomDnisAnnouncementSettings
        priority (str): priority
        allow_outgoing_acd_call (bool): allowOutgoingACDCall
    """

    __slots__: List[str] = [
        "dnis_phone_number",
        "extension",
        "use_custom_clid_settings",
        "calling_line_id_phone_number",
        "calling_line_id_last_name",
        "calling_line_id_first_name",
        "use_custom_dnis_announcement_settings",
        "priority",
        "allow_outgoing_acd_call",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dnis_phone_number",
                "dnisPhoneNumber",
                str,
            ),
            E(
                "extension",
                "extension",
                str,
            ),
            E(
                "use_custom_clid_settings",
                "useCustomCLIDSettings",
                bool,
                is_required=True,
            ),
            E(
                "calling_line_id_phone_number",
                "callingLineIdPhoneNumber",
                str,
            ),
            E(
                "calling_line_id_last_name",
                "callingLineIdLastName",
                str,
            ),
            E(
                "calling_line_id_first_name",
                "callingLineIdFirstName",
                str,
            ),
            E(
                "use_custom_dnis_announcement_settings",
                "useCustomDnisAnnouncementSettings",
                bool,
                is_required=True,
            ),
            E(
                "priority",
                "priority",
                str,
                is_required=True,
            ),
            E(
                "allow_outgoing_acd_call",
                "allowOutgoingACDCall",
                bool,
                is_required=True,
            ),
        )


class GroupCallCenterGetDistinctiveRingingResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetDistinctiveRingingRequest()`.


    Attributes:
        distinctive_ringing_call_center_calls (bool): distinctiveRingingCallCenterCalls
        distinctive_ringing_ring_pattern_for_call_center (str):
            distinctiveRingingRingPatternForCallCenter
        distinctive_ringing_force_delivery_ring_pattern (str):
            distinctiveRingingForceDeliveryRingPattern *Optional*
    """

    __slots__: List[str] = [
        "distinctive_ringing_call_center_calls",
        "distinctive_ringing_ring_pattern_for_call_center",
        "distinctive_ringing_force_delivery_ring_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "distinctive_ringing_call_center_calls",
                "distinctiveRingingCallCenterCalls",
                bool,
                is_required=True,
            ),
            E(
                "distinctive_ringing_ring_pattern_for_call_center",
                "distinctiveRingingRingPatternForCallCenter",
                str,
                is_required=True,
            ),
            E(
                "distinctive_ringing_force_delivery_ring_pattern",
                "distinctiveRingingForceDeliveryRingPattern",
                str,
            ),
        )


class GroupCallCenterGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active", "Policy", "Type". The column values
    for "Video" and "Is Active" can either be true, or false.  The column values for
    "Type" can be "Basic", "Standard" or "Premium" in AS data mode and "Basic" in XS data
    mode.  NOTE: prior to release 14, the policy column did not match the HuntPolicy
    enumerated type.

    Attributes:
        call_center_table (List(callCenterTable)): callCenterTable - *Table* array of
            callCenterTable named tuples
    """

    __slots__: List[str] = [
        "call_center_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_center_table",
                "callCenterTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetInstancePagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetInstancePagedSortedListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active", "Policy", "Type". The column values
    for "Video" and "Is Active" can either be true, or false.  The column values for
    "Type" can be "Basic", "Standard" or "Premium". NOTE: prior to release 14, the policy
    column did not match the HuntPolicy enumerated type.

    Attributes:
        call_center_table (List(callCenterTable)): callCenterTable - *Table* array of
            callCenterTable named tuples
    """

    __slots__: List[str] = [
        "call_center_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "call_center_table",
                "callCenterTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetInstanceQueueStatusResponse(OCIResponse):
    """
    Contains Call Center queue status and a table with column headings: "User Id", "First
    Name", "Last Name", "Phone Number", "Extension", "Department", "Email Address".


    Attributes:
        number_of_calls_queued_now (int): numberOfCallsQueuedNow
        agents_currently_staffed (List(agentsCurrentlyStaffed)): agentsCurrentlyStaffed -
            *Table* array of agentsCurrentlyStaffed named tuples
    """

    __slots__: List[str] = [
        "number_of_calls_queued_now",
        "agents_currently_staffed",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number_of_calls_queued_now",
                "numberOfCallsQueuedNow",
                int,
                is_required=True,
            ),
            E(
                "agents_currently_staffed",
                "agentsCurrentlyStaffed",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetInstanceStatisticsReportingResponse(OCIResponse):
    """
    Contains Call Center statistics reporting settings.


    Attributes:
        generate_daily_report (bool): generateDailyReport
        collection_period_minutes (int): collectionPeriodMinutes
        reporting_email_address1 (str): reportingEmailAddress1 *Optional*
        reporting_email_address2 (str): reportingEmailAddress2 *Optional*
    """

    __slots__: List[str] = [
        "generate_daily_report",
        "collection_period_minutes",
        "reporting_email_address1",
        "reporting_email_address2",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "generate_daily_report",
                "generateDailyReport",
                bool,
                is_required=True,
            ),
            E(
                "collection_period_minutes",
                "collectionPeriodMinutes",
                int,
                is_required=True,
            ),
            E(
                "reporting_email_address1",
                "reportingEmailAddress1",
                str,
            ),
            E(
                "reporting_email_address2",
                "reportingEmailAddress2",
                str,
            ),
        )


class GroupCallCenterGetInstanceStatisticsReportingResponse16(OCIResponse):
    """
    Contains Call Center statistics reporting settings.


    Attributes:
        generate_daily_report (bool): generateDailyReport
        collection_period_minutes (int): collectionPeriodMinutes
        reporting_email_address1 (str): reportingEmailAddress1 *Optional*
        reporting_email_address2 (str): reportingEmailAddress2 *Optional*
        statistics_source (str): statisticsSource
    """

    __slots__: List[str] = [
        "generate_daily_report",
        "collection_period_minutes",
        "reporting_email_address1",
        "reporting_email_address2",
        "statistics_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "generate_daily_report",
                "generateDailyReport",
                bool,
                is_required=True,
            ),
            E(
                "collection_period_minutes",
                "collectionPeriodMinutes",
                int,
                is_required=True,
            ),
            E(
                "reporting_email_address1",
                "reportingEmailAddress1",
                str,
            ),
            E(
                "reporting_email_address2",
                "reportingEmailAddress2",
                str,
            ),
            E(
                "statistics_source",
                "statisticsSource",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceStatisticsReportingResponse17sp1(OCIResponse):
    """
    Response to `GroupCallCenterGetInstanceStatisticsReportingRequest17sp1()`.

    Contains Call Center statistics reporting settings.

    Attributes:
        generate_daily_report (bool): generateDailyReport
        collection_period_minutes (int): collectionPeriodMinutes
        reporting_email_address1 (str): reportingEmailAddress1 *Optional*
        reporting_email_address2 (str): reportingEmailAddress2 *Optional*
        statistics_source (str): statisticsSource
    """

    __slots__: List[str] = [
        "generate_daily_report",
        "collection_period_minutes",
        "reporting_email_address1",
        "reporting_email_address2",
        "statistics_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "generate_daily_report",
                "generateDailyReport",
                bool,
                is_required=True,
            ),
            E(
                "collection_period_minutes",
                "collectionPeriodMinutes",
                int,
                is_required=True,
            ),
            E(
                "reporting_email_address1",
                "reportingEmailAddress1",
                str,
            ),
            E(
                "reporting_email_address2",
                "reportingEmailAddress2",
                str,
            ),
            E(
                "statistics_source",
                "statisticsSource",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetResponse(OCIResponse):
    """
    Response to `GroupCallCenterGetRequest()`.

    Replaced by `GroupCallCenterGetResponse17sp4()`.

    Attributes:
        use_system_default_guard_timer (bool): useSystemDefaultGuardTimer
        enable_guard_timer (bool): enableGuardTimer
        guard_timer_seconds (int): guardTimerSeconds
        use_system_default_unavailable_settings (bool):
            useSystemDefaultUnavailableSettings *Optional*
        force_agent_unavailable_on_dnd_activation (bool):
            forceAgentUnavailableOnDNDActivation *Optional*
        force_agent_unavailable_on_personal_calls (bool):
            forceAgentUnavailableOnPersonalCalls *Optional*
        force_agent_unavailable_on_bounced_call_limit (bool):
            forceAgentUnavailableOnBouncedCallLimit *Optional*
        number_consecutive_bounced_calls_to_force_agent_unavailable (int):
            numberConsecutiveBouncedCallsToForceAgentUnavailable *Optional*
    """

    __slots__: List[str] = [
        "use_system_default_guard_timer",
        "enable_guard_timer",
        "guard_timer_seconds",
        "use_system_default_unavailable_settings",
        "force_agent_unavailable_on_dnd_activation",
        "force_agent_unavailable_on_personal_calls",
        "force_agent_unavailable_on_bounced_call_limit",
        "number_consecutive_bounced_calls_to_force_agent_unavailable",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_system_default_guard_timer",
                "useSystemDefaultGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "enable_guard_timer",
                "enableGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "guard_timer_seconds",
                "guardTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "use_system_default_unavailable_settings",
                "useSystemDefaultUnavailableSettings",
                bool,
            ),
            E(
                "force_agent_unavailable_on_dnd_activation",
                "forceAgentUnavailableOnDNDActivation",
                bool,
            ),
            E(
                "force_agent_unavailable_on_personal_calls",
                "forceAgentUnavailableOnPersonalCalls",
                bool,
            ),
            E(
                "force_agent_unavailable_on_bounced_call_limit",
                "forceAgentUnavailableOnBouncedCallLimit",
                bool,
            ),
            E(
                "number_consecutive_bounced_calls_to_force_agent_unavailable",
                "numberConsecutiveBouncedCallsToForceAgentUnavailable",
                int,
            ),
        )


class GroupCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to `GroupCallCenterGetRequest17sp4()`.

    The following elements are only used in AS data mode and not returned in XS data mode:
    useSystemDefaultUnavailableSettings forceAgentUnavailableOnDNDActivation
    forceAgentUnavailableOnPersonalCalls forceAgentUnavailableOnBouncedCallLimit
    numberConsecutiveBouncedCallsToForceAgentUnavailable
    forceAgentUnavailableOnNotReachable Replaced by: `GroupCallCenterGetResponse23()`

    Attributes:
        use_system_default_guard_timer (bool): useSystemDefaultGuardTimer
        enable_guard_timer (bool): enableGuardTimer
        guard_timer_seconds (int): guardTimerSeconds
        use_system_default_unavailable_settings (bool):
            useSystemDefaultUnavailableSettings *Optional*
        force_agent_unavailable_on_dnd_activation (bool):
            forceAgentUnavailableOnDNDActivation *Optional*
        force_agent_unavailable_on_personal_calls (bool):
            forceAgentUnavailableOnPersonalCalls *Optional*
        force_agent_unavailable_on_bounced_call_limit (bool):
            forceAgentUnavailableOnBouncedCallLimit *Optional*
        number_consecutive_bounced_calls_to_force_agent_unavailable (int):
            numberConsecutiveBouncedCallsToForceAgentUnavailable *Optional*
        force_agent_unavailable_on_not_reachable (bool):
            forceAgentUnavailableOnNotReachable *Optional*
    """

    __slots__: List[str] = [
        "use_system_default_guard_timer",
        "enable_guard_timer",
        "guard_timer_seconds",
        "use_system_default_unavailable_settings",
        "force_agent_unavailable_on_dnd_activation",
        "force_agent_unavailable_on_personal_calls",
        "force_agent_unavailable_on_bounced_call_limit",
        "number_consecutive_bounced_calls_to_force_agent_unavailable",
        "force_agent_unavailable_on_not_reachable",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_system_default_guard_timer",
                "useSystemDefaultGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "enable_guard_timer",
                "enableGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "guard_timer_seconds",
                "guardTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "use_system_default_unavailable_settings",
                "useSystemDefaultUnavailableSettings",
                bool,
            ),
            E(
                "force_agent_unavailable_on_dnd_activation",
                "forceAgentUnavailableOnDNDActivation",
                bool,
            ),
            E(
                "force_agent_unavailable_on_personal_calls",
                "forceAgentUnavailableOnPersonalCalls",
                bool,
            ),
            E(
                "force_agent_unavailable_on_bounced_call_limit",
                "forceAgentUnavailableOnBouncedCallLimit",
                bool,
            ),
            E(
                "number_consecutive_bounced_calls_to_force_agent_unavailable",
                "numberConsecutiveBouncedCallsToForceAgentUnavailable",
                int,
            ),
            E(
                "force_agent_unavailable_on_not_reachable",
                "forceAgentUnavailableOnNotReachable",
                bool,
            ),
        )


class GroupCallCenterGetResponse23(OCIResponse):
    """
    Response to `GroupCallCenterGetRequest23()`.

    The following elements are only used in AS data mode and not returned in XS data mode:
    useSystemDefaultUnavailableSettings forceAgentUnavailableOnDNDActivation
    forceAgentUnavailableOnPersonalCalls forceAgentUnavailableOnBouncedCallLimit
    numberConsecutiveBouncedCallsToForceAgentUnavailable
    forceAgentUnavailableOnNotReachable wrapUpDestination

    Attributes:
        use_system_default_guard_timer (bool): useSystemDefaultGuardTimer
        enable_guard_timer (bool): enableGuardTimer
        guard_timer_seconds (int): guardTimerSeconds
        use_system_default_unavailable_settings (bool):
            useSystemDefaultUnavailableSettings *Optional*
        force_agent_unavailable_on_dnd_activation (bool):
            forceAgentUnavailableOnDNDActivation *Optional*
        force_agent_unavailable_on_personal_calls (bool):
            forceAgentUnavailableOnPersonalCalls *Optional*
        force_agent_unavailable_on_bounced_call_limit (bool):
            forceAgentUnavailableOnBouncedCallLimit *Optional*
        number_consecutive_bounced_calls_to_force_agent_unavailable (int):
            numberConsecutiveBouncedCallsToForceAgentUnavailable *Optional*
        force_agent_unavailable_on_not_reachable (bool):
            forceAgentUnavailableOnNotReachable *Optional*
        wrap_up_destination (str): wrapUpDestination *Optional*
    """

    __slots__: List[str] = [
        "use_system_default_guard_timer",
        "enable_guard_timer",
        "guard_timer_seconds",
        "use_system_default_unavailable_settings",
        "force_agent_unavailable_on_dnd_activation",
        "force_agent_unavailable_on_personal_calls",
        "force_agent_unavailable_on_bounced_call_limit",
        "number_consecutive_bounced_calls_to_force_agent_unavailable",
        "force_agent_unavailable_on_not_reachable",
        "wrap_up_destination",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_system_default_guard_timer",
                "useSystemDefaultGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "enable_guard_timer",
                "enableGuardTimer",
                bool,
                is_required=True,
            ),
            E(
                "guard_timer_seconds",
                "guardTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "use_system_default_unavailable_settings",
                "useSystemDefaultUnavailableSettings",
                bool,
            ),
            E(
                "force_agent_unavailable_on_dnd_activation",
                "forceAgentUnavailableOnDNDActivation",
                bool,
            ),
            E(
                "force_agent_unavailable_on_personal_calls",
                "forceAgentUnavailableOnPersonalCalls",
                bool,
            ),
            E(
                "force_agent_unavailable_on_bounced_call_limit",
                "forceAgentUnavailableOnBouncedCallLimit",
                bool,
            ),
            E(
                "number_consecutive_bounced_calls_to_force_agent_unavailable",
                "numberConsecutiveBouncedCallsToForceAgentUnavailable",
                int,
            ),
            E(
                "force_agent_unavailable_on_not_reachable",
                "forceAgentUnavailableOnNotReachable",
                bool,
            ),
            E(
                "wrap_up_destination",
                "wrapUpDestination",
                str,
            ),
        )


class GroupCallCenterGetRoutingPolicyResponse(OCIResponse):
    """
    Response to `GroupCallCenterGetRoutingPolicyRequest()`.

    Contains a table with column headings: "Service User Id", "Name" and "Priority".

    Attributes:
        routing_policy (str): routingPolicy
        call_center_table (List(callCenterTable)): callCenterTable - *Table* array of
            callCenterTable named tuples
    """

    __slots__: List[str] = [
        "routing_policy",
        "call_center_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "routing_policy",
                "routingPolicy",
                str,
                is_required=True,
            ),
            E(
                "call_center_table",
                "callCenterTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetSupervisorListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetSupervisorListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name". Element "reportingServerURL"" will always be blank.

    Replaced By: `GroupCallCenterSupervisorReportingGetResponse()`

    Attributes:
        reporting_server_url (str): reportingServerURL *Optional*
        supervisor_table (List(supervisorTable)): supervisorTable - *Table* array of
            supervisorTable named tuples
    """

    __slots__: List[str] = [
        "reporting_server_url",
        "supervisor_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reporting_server_url",
                "reportingServerURL",
                str,
            ),
            E(
                "supervisor_table",
                "supervisorTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetSupervisorListResponse16(OCIResponse):
    """
    Response to the `GroupCallCenterGetSupervisorListRequest16()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        supervisor_table (List(supervisorTable)): supervisorTable - *Table* array of
            supervisorTable named tuples
    """

    __slots__: List[str] = [
        "supervisor_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "supervisor_table",
                "supervisorTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterGetUnlicensedAgentListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterGetUnlicensedAgentListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Group Id", "Extension",
    "Department", "Email Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterHolidayServiceGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterHolidayServiceGetRequest()`.


    Attributes:
        action (str): action
        holiday_schedule (str): holidaySchedule *Optional*
        transfer_phone_number (str): transferPhoneNumber *Optional*
        play_announcement_before_action (bool): playAnnouncementBeforeAction
        audio_message_selection (str): audioMessageSelection
        audio_file_url (str): audioFileUrl *Optional*
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_message_selection (str): videoMessageSelection
        video_file_url (str): videoFileUrl *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
    """

    __slots__: List[str] = [
        "action",
        "holiday_schedule",
        "transfer_phone_number",
        "play_announcement_before_action",
        "audio_message_selection",
        "audio_file_url",
        "audio_file_description",
        "audio_media_type",
        "video_message_selection",
        "video_file_url",
        "video_file_description",
        "video_media_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "holiday_schedule",
                "holidaySchedule",
                str,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "play_announcement_before_action",
                "playAnnouncementBeforeAction",
                bool,
                is_required=True,
            ),
            E(
                "audio_message_selection",
                "audioMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_message_selection",
                "videoMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
        )


class GroupCallCenterMonitoringGetResponse(OCIResponse):
    """
    Response to `GroupCallCenterMonitoringGetRequest()`.


    Attributes:
        enable_supervisor_coaching (bool): enableSupervisorCoaching
    """

    __slots__: List[str] = [
        "enable_supervisor_coaching",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_supervisor_coaching",
                "enableSupervisorCoaching",
                bool,
                is_required=True,
            ),
        )


class GroupCallCenterNightServiceGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterNightServiceGetRequest()`.


    Attributes:
        action (str): action
        business_hours (str): businessHours *Optional*
        force_night_service (bool): forceNightService
        allow_manual_override_via_fac (bool): allowManualOverrideViaFAC
        transfer_phone_number (str): transferPhoneNumber *Optional*
        play_announcement_before_action (bool): playAnnouncementBeforeAction
        audio_message_selection (str): audioMessageSelection
        audio_file_url (str): audioFileUrl *Optional*
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_message_selection (str): videoMessageSelection
        video_file_url (str): videoFileUrl *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
        manual_announcement_mode (str): manualAnnouncementMode
        manual_audio_message_selection (str): manualAudioMessageSelection
        manual_audio_file_url (str): manualAudioFileUrl *Optional*
        manual_audio_file_description (str): manualAudioFileDescription *Optional*
        manual_audio_media_type (str): manualAudioMediaType *Optional*
        manual_video_message_selection (str): manualVideoMessageSelection
        manual_video_file_url (str): manualVideoFileUrl *Optional*
        manual_video_file_description (str): manualVideoFileDescription *Optional*
        manual_video_media_type (str): manualVideoMediaType *Optional*
    """

    __slots__: List[str] = [
        "action",
        "business_hours",
        "force_night_service",
        "allow_manual_override_via_fac",
        "transfer_phone_number",
        "play_announcement_before_action",
        "audio_message_selection",
        "audio_file_url",
        "audio_file_description",
        "audio_media_type",
        "video_message_selection",
        "video_file_url",
        "video_file_description",
        "video_media_type",
        "manual_announcement_mode",
        "manual_audio_message_selection",
        "manual_audio_file_url",
        "manual_audio_file_description",
        "manual_audio_media_type",
        "manual_video_message_selection",
        "manual_video_file_url",
        "manual_video_file_description",
        "manual_video_media_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "business_hours",
                "businessHours",
                str,
            ),
            E(
                "force_night_service",
                "forceNightService",
                bool,
                is_required=True,
            ),
            E(
                "allow_manual_override_via_fac",
                "allowManualOverrideViaFAC",
                bool,
                is_required=True,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "play_announcement_before_action",
                "playAnnouncementBeforeAction",
                bool,
                is_required=True,
            ),
            E(
                "audio_message_selection",
                "audioMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_message_selection",
                "videoMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
            E(
                "manual_announcement_mode",
                "manualAnnouncementMode",
                str,
                is_required=True,
            ),
            E(
                "manual_audio_message_selection",
                "manualAudioMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "manual_audio_file_url",
                "manualAudioFileUrl",
                str,
            ),
            E(
                "manual_audio_file_description",
                "manualAudioFileDescription",
                str,
            ),
            E(
                "manual_audio_media_type",
                "manualAudioMediaType",
                str,
            ),
            E(
                "manual_video_message_selection",
                "manualVideoMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "manual_video_file_url",
                "manualVideoFileUrl",
                str,
            ),
            E(
                "manual_video_file_description",
                "manualVideoFileDescription",
                str,
            ),
            E(
                "manual_video_media_type",
                "manualVideoMediaType",
                str,
            ),
        )


class GroupCallCenterOverflowGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterOverflowGetRequest()`.


    Attributes:
        action (str): action
        transfer_phone_number (str): transferPhoneNumber *Optional*
        overflow_after_timeout (bool): overflowAfterTimeout
        timeout_seconds (int): timeoutSeconds
        play_announcement_before_overflow_processing (bool):
            playAnnouncementBeforeOverflowProcessing
        audio_message_selection (str): audioMessageSelection
        audio_file_url (str): audioFileUrl *Optional*
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_message_selection (str): videoMessageSelection *Optional*
        video_file_url (str): videoFileUrl *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
    """

    __slots__: List[str] = [
        "action",
        "transfer_phone_number",
        "overflow_after_timeout",
        "timeout_seconds",
        "play_announcement_before_overflow_processing",
        "audio_message_selection",
        "audio_file_url",
        "audio_file_description",
        "audio_media_type",
        "video_message_selection",
        "video_file_url",
        "video_file_description",
        "video_media_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "overflow_after_timeout",
                "overflowAfterTimeout",
                bool,
                is_required=True,
            ),
            E(
                "timeout_seconds",
                "timeoutSeconds",
                int,
                is_required=True,
            ),
            E(
                "play_announcement_before_overflow_processing",
                "playAnnouncementBeforeOverflowProcessing",
                bool,
                is_required=True,
            ),
            E(
                "audio_message_selection",
                "audioMessageSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_message_selection",
                "videoMessageSelection",
                str,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
        )


class GroupCallCenterQueueCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the `GroupCallCenterQueueCallDispositionCodeGetListRequest()`.

    Contains a table with column headings: "Is Active", "Code", "Description" and "Level".
    Level column can be any of the values in the data type CallDispositionCodeLevel.

    Attributes:
        disposition_codes_table (List(dispositionCodesTable)): dispositionCodesTable -
            *Table* array of dispositionCodesTable named tuples
    """

    __slots__: List[str] = [
        "disposition_codes_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disposition_codes_table",
                "dispositionCodesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallCenterQueueCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterQueueCallDispositionCodeGetRequest()`

    Attributes:
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupCallCenterQueueStatusNotificationGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterQueueStatusNotificationGetRequest()`.

    The response contains the call center status configuration information.

    Attributes:
        enable_queue_status_notification (bool): enableQueueStatusNotification
        enable_queue_depth_threshold (bool): enableQueueDepthThreshold
        enable_waiting_time_threshold (bool): enableWaitingTimeThreshold
        number_of_calls_threshold (int): numberOfCallsThreshold
        waiting_time_of_calls_threshold (int): waitingTimeOfCallsThreshold
    """

    __slots__: List[str] = [
        "enable_queue_status_notification",
        "enable_queue_depth_threshold",
        "enable_waiting_time_threshold",
        "number_of_calls_threshold",
        "waiting_time_of_calls_threshold",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_queue_status_notification",
                "enableQueueStatusNotification",
                bool,
                is_required=True,
            ),
            E(
                "enable_queue_depth_threshold",
                "enableQueueDepthThreshold",
                bool,
                is_required=True,
            ),
            E(
                "enable_waiting_time_threshold",
                "enableWaitingTimeThreshold",
                bool,
                is_required=True,
            ),
            E(
                "number_of_calls_threshold",
                "numberOfCallsThreshold",
                int,
                is_required=True,
            ),
            E(
                "waiting_time_of_calls_threshold",
                "waitingTimeOfCallsThreshold",
                int,
                is_required=True,
            ),
        )


class GroupCallCenterQueueThresholdsGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterQueueThresholdsGetRequest()`.


    Attributes:
        is_active (bool): isActive
        threshold_current_calls_in_queue_yellow (int): thresholdCurrentCallsInQueueYellow
            *Optional*
        threshold_current_calls_in_queue_red (int): thresholdCurrentCallsInQueueRed
            *Optional*
        threshold_current_longest_waiting_call_yellow (int):
            thresholdCurrentLongestWaitingCallYellow *Optional*
        threshold_current_longest_waiting_call_red (int):
            thresholdCurrentLongestWaitingCallRed *Optional*
        threshold_average_estimated_wait_time_yellow (int):
            thresholdAverageEstimatedWaitTimeYellow *Optional*
        threshold_average_estimated_wait_time_red (int):
            thresholdAverageEstimatedWaitTimeRed *Optional*
        threshold_average_handling_time_yellow (int): thresholdAverageHandlingTimeYellow
            *Optional*
        threshold_average_handling_time_red (int): thresholdAverageHandlingTimeRed
            *Optional*
        threshold_average_speed_of_answer_yellow (int):
            thresholdAverageSpeedOfAnswerYellow *Optional*
        threshold_average_speed_of_answer_red (int): thresholdAverageSpeedOfAnswerRed
            *Optional*
        enable_notification_email (bool): enableNotificationEmail
        notification_email_address (List[str]): notificationEmailAddress *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "threshold_current_calls_in_queue_yellow",
        "threshold_current_calls_in_queue_red",
        "threshold_current_longest_waiting_call_yellow",
        "threshold_current_longest_waiting_call_red",
        "threshold_average_estimated_wait_time_yellow",
        "threshold_average_estimated_wait_time_red",
        "threshold_average_handling_time_yellow",
        "threshold_average_handling_time_red",
        "threshold_average_speed_of_answer_yellow",
        "threshold_average_speed_of_answer_red",
        "enable_notification_email",
        "notification_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "threshold_current_calls_in_queue_yellow",
                "thresholdCurrentCallsInQueueYellow",
                int,
            ),
            E(
                "threshold_current_calls_in_queue_red",
                "thresholdCurrentCallsInQueueRed",
                int,
            ),
            E(
                "threshold_current_longest_waiting_call_yellow",
                "thresholdCurrentLongestWaitingCallYellow",
                int,
            ),
            E(
                "threshold_current_longest_waiting_call_red",
                "thresholdCurrentLongestWaitingCallRed",
                int,
            ),
            E(
                "threshold_average_estimated_wait_time_yellow",
                "thresholdAverageEstimatedWaitTimeYellow",
                int,
            ),
            E(
                "threshold_average_estimated_wait_time_red",
                "thresholdAverageEstimatedWaitTimeRed",
                int,
            ),
            E(
                "threshold_average_handling_time_yellow",
                "thresholdAverageHandlingTimeYellow",
                int,
            ),
            E(
                "threshold_average_handling_time_red",
                "thresholdAverageHandlingTimeRed",
                int,
            ),
            E(
                "threshold_average_speed_of_answer_yellow",
                "thresholdAverageSpeedOfAnswerYellow",
                int,
            ),
            E(
                "threshold_average_speed_of_answer_red",
                "thresholdAverageSpeedOfAnswerRed",
                int,
            ),
            E(
                "enable_notification_email",
                "enableNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "notification_email_address",
                "notificationEmailAddress",
                str,
                is_array=True,
            ),
        )


class GroupCallCenterStrandedCallGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterStrandedCallGetRequest()`.


    Attributes:
        action (str): action
        transfer_phone_number (str): transferPhoneNumber *Optional*
        audio_message_selection (str): audioMessageSelection *Optional*
        audio_file_url (str): audioFileUrl *Optional*
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_message_selection (str): videoMessageSelection *Optional*
        video_file_url (str): videoFileUrl *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
    """

    __slots__: List[str] = [
        "action",
        "transfer_phone_number",
        "audio_message_selection",
        "audio_file_url",
        "audio_file_description",
        "audio_media_type",
        "video_message_selection",
        "video_file_url",
        "video_file_description",
        "video_media_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "action",
                "action",
                str,
                is_required=True,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "audio_message_selection",
                "audioMessageSelection",
                str,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_message_selection",
                "videoMessageSelection",
                str,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
        )


class GroupCallCenterSupervisorReportingGetResponse(OCIResponse):
    """
    Response to the `GroupCallCenterSupervisorReportingGetRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name".

    Attributes:
        reporting_server_name (str): reportingServerName *Optional*
        supervisor_table (List(supervisorTable)): supervisorTable - *Table* array of
            supervisorTable named tuples
    """

    __slots__: List[str] = [
        "reporting_server_name",
        "supervisor_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reporting_server_name",
                "reportingServerName",
                str,
            ),
            E(
                "supervisor_table",
                "supervisorTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallParkGetAvailableAlternateRecallUserListResponse(OCIResponse):
    """
    Response to the `GroupCallParkGetAvailableAlternateRecallUserListResponse()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name".

    Attributes:
        available_hunt_group_table (List(availableHuntGroupTable)):
            availableHuntGroupTable - *Table* array of availableHuntGroupTable named
            tuples
    """

    __slots__: List[str] = [
        "available_hunt_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_hunt_group_table",
                "availableHuntGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallParkGetAvailableAlternateRecallUserPagedSortedListResponse(OCIResponse):
    """
    Response to the
    `GroupCallParkGetAvailableAlternateRecallUserPagedSortedListResponse()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address". The Email Address will never be populated, since Hunt Groups don't have
    Email Addresses.

    Attributes:
        available_hunt_group_table (List(availableHuntGroupTable)):
            availableHuntGroupTable - *Table* array of availableHuntGroupTable named
            tuples
    """

    __slots__: List[str] = [
        "available_hunt_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_hunt_group_table",
                "availableHuntGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallParkGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupCallParkGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallParkGetAvailableUserPagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupCallParkGetAvailableUserPagedSortedListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallParkGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupCallParkGetInstanceListRequest()`.


    Attributes:
        name (List[str]): name *Optional*
    """

    __slots__: List[str] = [
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
        )


class GroupCallParkGetInstancePagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupCallParkGetInstancePagedSortedListRequest()`.


    Attributes:
        name (List[str]): name *Optional*
    """

    __slots__: List[str] = [
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
        )


class GroupCallParkGetInstancePagedSortedResponse(OCIResponse):
    """
    Response to the `GroupCallParkGetInstancePagedSortedRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address". The users are in the table are in the order they will try to be parked on.

    Attributes:
        recall_alternate_user_id (str): recallAlternateUserId *Optional*
        recall_to (str): recallTo
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "recall_alternate_user_id",
        "recall_to",
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "recall_alternate_user_id",
                "recallAlternateUserId",
                str,
            ),
            E(
                "recall_to",
                "recallTo",
                str,
                is_required=True,
            ),
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallParkGetInstanceResponse(OCIResponse):
    """
    Response to the `GroupCallParkGetInstanceRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name". The users are in the table are in the order they
    will try to be parked on.

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallParkGetInstanceResponse16sp2(OCIResponse):
    """
    Response to the `GroupCallParkGetInstanceRequest16sp2()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address". The users are in the table are in the order they will try to be parked on.

    Attributes:
        recall_alternate_user_id (str): recallAlternateUserId *Optional*
        recall_to (str): recallTo
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "recall_alternate_user_id",
        "recall_to",
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "recall_alternate_user_id",
                "recallAlternateUserId",
                str,
            ),
            E(
                "recall_to",
                "recallTo",
                str,
                is_required=True,
            ),
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallParkGetResponse(OCIResponse):
    """
    Response to the `GroupCallParkGetRequest()`.

    Contains the settings that apply to the whole group for Call Park.

    Attributes:
        recall_timer_seconds (int): recallTimerSeconds
        display_timer_seconds (int): displayTimerSeconds
        enable_destination_announcement (bool): enableDestinationAnnouncement
    """

    __slots__: List[str] = [
        "recall_timer_seconds",
        "display_timer_seconds",
        "enable_destination_announcement",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "recall_timer_seconds",
                "recallTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "display_timer_seconds",
                "displayTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "enable_destination_announcement",
                "enableDestinationAnnouncement",
                bool,
                is_required=True,
            ),
        )


class GroupCallParkGetResponse16sp2(OCIResponse):
    """
    Response to the `GroupCallParkGetRequest16sp2()`.

    Contains the settings that apply to the whole group for Call Park.

    Attributes:
        recall_timer_seconds (int): recallTimerSeconds
        display_timer_seconds (int): displayTimerSeconds
        enable_destination_announcement (bool): enableDestinationAnnouncement
        recall_alternate_user_id (str): recallAlternateUserId *Optional*
        recall_ring_pattern (str): recallRingPattern
        recall_to (str): recallTo
        alternate_user_recall_timer_seconds (int): alternateUserRecallTimerSeconds
    """

    __slots__: List[str] = [
        "recall_timer_seconds",
        "display_timer_seconds",
        "enable_destination_announcement",
        "recall_alternate_user_id",
        "recall_ring_pattern",
        "recall_to",
        "alternate_user_recall_timer_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "recall_timer_seconds",
                "recallTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "display_timer_seconds",
                "displayTimerSeconds",
                int,
                is_required=True,
            ),
            E(
                "enable_destination_announcement",
                "enableDestinationAnnouncement",
                bool,
                is_required=True,
            ),
            E(
                "recall_alternate_user_id",
                "recallAlternateUserId",
                str,
            ),
            E(
                "recall_ring_pattern",
                "recallRingPattern",
                str,
                is_required=True,
            ),
            E(
                "recall_to",
                "recallTo",
                str,
                is_required=True,
            ),
            E(
                "alternate_user_recall_timer_seconds",
                "alternateUserRecallTimerSeconds",
                int,
                is_required=True,
            ),
        )


class GroupCallPickupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupCallPickupGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallPickupGetAvailableUserPagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupCallPickupGetAvailableUserPagedSortedListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallPickupGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupCallPickupGetInstanceListRequest()`.


    Attributes:
        name (List[str]): name *Optional*
    """

    __slots__: List[str] = [
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
        )


class GroupCallPickupGetInstancePagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupCallPickupGetInstancePagedSortedListRequest()`.


    Attributes:
        name (List[str]): name *Optional*
    """

    __slots__: List[str] = [
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
        )


class GroupCallPickupGetInstancePagedSortedResponse(OCIResponse):
    """
    Response to the `GroupCallPickupGetInstancePagedSortedRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallPickupGetInstanceResponse(OCIResponse):
    """
    Response to the `GroupCallPickupGetInstanceRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse14(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest14()`.


    Attributes:
        use_group_setting (bool): useGroupSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
    """

    __slots__: List[str] = [
        "use_group_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_setting",
                "useGroupSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse14sp1(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest14sp1()`.


    Attributes:
        use_group_setting (bool): useGroupSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
    """

    __slots__: List[str] = [
        "use_group_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_setting",
                "useGroupSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse14sp4(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest14sp4()`.

    Replaced By : `GroupCallProcessingGetPolicyResponse15()`

    Attributes:
        use_group_setting (bool): useGroupSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan (bool):
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
    """

    __slots__: List[str] = [
        "use_group_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_external_calls_via_private_dialing_plan",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_setting",
                "useGroupSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_external_calls_via_private_dialing_plan",
                "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse14sp7(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest14sp7()`.


    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan (bool):
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_external_calls_via_private_dialing_plan",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_external_calls_via_private_dialing_plan",
                "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse15(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest15()`.


    Attributes:
        use_group_setting (bool): useGroupSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
    """

    __slots__: List[str] = [
        "use_group_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_setting",
                "useGroupSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
                is_required=True,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
                is_required=True,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse15sp2(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest15sp2()`.


    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse16(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest16()`.


    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse16sp2(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest16sp2()`.


    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        enable_dialable_caller_id (bool): enableDialableCallerID
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "enable_dialable_caller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse17(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest17()`.


    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse17sp3(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest17sp3()`.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID Replaced by `GroupCallProcessingGetPolicyResponse17sp4()`

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse17sp4(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest17sp4()`.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity Replaced by
    `GroupCallProcessingGetPolicyResponse18()`

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse18(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest18()`.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override (bool): allowDepartmentCLIDNameOverride
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
        "allow_department_clid_name_override",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "allow_department_clid_name_override",
                "allowDepartmentCLIDNameOverride",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse18sp1(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest18sp1()`.

    The following elements are only used in AS data mode : useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride enterpriseCallsCLIDPolicy, value "Use Location Code
    plus Extension" is returned in XS data mode.  groupCallsCLIDPolicy, value "Use
    Extension" is returned in XS data mode.  Replaced by:
    `GroupCallProcessingGetPolicyResponse19sp1()`

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override (bool): allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy (str): enterpriseCallsCLIDPolicy
        group_calls_clid_policy (str): groupCallsCLIDPolicy
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
        "allow_department_clid_name_override",
        "enterprise_calls_clid_policy",
        "group_calls_clid_policy",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "allow_department_clid_name_override",
                "allowDepartmentCLIDNameOverride",
                bool,
                is_required=True,
            ),
            E(
                "enterprise_calls_clid_policy",
                "enterpriseCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "group_calls_clid_policy",
                "groupCallsCLIDPolicy",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse19sp1(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest19sp1()`.

    The following elements are only used in AS data mode : useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride enterpriseCallsCLIDPolicy, value "Use Location Code
    plus Extension" is returned in XS data mode.  groupCallsCLIDPolicy, value "Use
    Extension" is returned in XS data mode.  Replaced by:
    `GroupCallProcessingGetPolicyResponse21sp1()`

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override (bool): allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy (str): enterpriseCallsCLIDPolicy
        group_calls_clid_policy (str): groupCallsCLIDPolicy
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
        "allow_department_clid_name_override",
        "enterprise_calls_clid_policy",
        "group_calls_clid_policy",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "allow_department_clid_name_override",
                "allowDepartmentCLIDNameOverride",
                bool,
                is_required=True,
            ),
            E(
                "enterprise_calls_clid_policy",
                "enterpriseCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "group_calls_clid_policy",
                "groupCallsCLIDPolicy",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse21sp1(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest21sp1()`.

    The following elements are only used in AS data mode : useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride enterpriseCallsCLIDPolicy, value "Use Location Code
    plus Extension" is returned in XS data mode.  groupCallsCLIDPolicy, value "Use
    Extension" is returned in XS data mode.  useGroupPhoneListLookupSetting, value "false"
    is returned in XS data mode.  enablePhoneListLookup, value "false" is returned in XS
    data mode.  Replaced by: `GroupCallProcessingGetPolicyResponse21sp2()`

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override (bool): allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy (str): enterpriseCallsCLIDPolicy
        group_calls_clid_policy (str): groupCallsCLIDPolicy
        use_group_phone_list_lookup_setting (bool): useGroupPhoneListLookupSetting
        enable_phone_list_lookup (bool): enablePhoneListLookup
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
        "allow_department_clid_name_override",
        "enterprise_calls_clid_policy",
        "group_calls_clid_policy",
        "use_group_phone_list_lookup_setting",
        "enable_phone_list_lookup",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "allow_department_clid_name_override",
                "allowDepartmentCLIDNameOverride",
                bool,
                is_required=True,
            ),
            E(
                "enterprise_calls_clid_policy",
                "enterpriseCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "group_calls_clid_policy",
                "groupCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "use_group_phone_list_lookup_setting",
                "useGroupPhoneListLookupSetting",
                bool,
                is_required=True,
            ),
            E(
                "enable_phone_list_lookup",
                "enablePhoneListLookup",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse21sp2(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest21sp2()`.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride useGroupPhoneListLookupSetting, value "false" is
    returned in XS data mode.  enablePhoneListLookup, value "false" is returned in XS data
    mode.  The following elements are only used in XS data mode and not returned in AS
    data mode: routeOverrideDomain routeOverridePrefix Replaced by:
    `GroupCallProcessingGetPolicyResponse22()` in AS data mode

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override (bool): allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy (str): enterpriseCallsCLIDPolicy
        group_calls_clid_policy (str): groupCallsCLIDPolicy
        use_group_phone_list_lookup_setting (bool): useGroupPhoneListLookupSetting
        enable_phone_list_lookup (bool): enablePhoneListLookup
        route_override_domain (str): routeOverrideDomain *Optional*
        route_override_prefix (str): routeOverridePrefix *Optional*
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
        "allow_department_clid_name_override",
        "enterprise_calls_clid_policy",
        "group_calls_clid_policy",
        "use_group_phone_list_lookup_setting",
        "enable_phone_list_lookup",
        "route_override_domain",
        "route_override_prefix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "allow_department_clid_name_override",
                "allowDepartmentCLIDNameOverride",
                bool,
                is_required=True,
            ),
            E(
                "enterprise_calls_clid_policy",
                "enterpriseCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "group_calls_clid_policy",
                "groupCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "use_group_phone_list_lookup_setting",
                "useGroupPhoneListLookupSetting",
                bool,
                is_required=True,
            ),
            E(
                "enable_phone_list_lookup",
                "enablePhoneListLookup",
                bool,
                is_required=True,
            ),
            E(
                "route_override_domain",
                "routeOverrideDomain",
                str,
            ),
            E(
                "route_override_prefix",
                "routeOverridePrefix",
                str,
            ),
        )


class GroupCallProcessingGetPolicyResponse22(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest22()`.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride enterpriseCallsCLIDPolicy, value "Use Location Code
    plus Extension" is returned in XS data mode.  groupCallsCLIDPolicy, value "Use
    Extension" is returned in XS data mode.  useGroupPhoneListLookupSetting, value "false"
    is returned in XS data mode.  enablePhoneListLookup, value "false" is returned in XS
    data mode.  useMaxConcurrentTerminatingAlertingRequests, value "false" is returned in
    XS data mode.  maxConcurrentTerminatingAlertingRequests, value "10" is returned in XS
    data mode.  includeRedirectionsInMaximumNumberOfConcurrentCalls, value "false" is
    returned in XS data mode.  useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable,
    value "false" is returned in XS data mode.
    useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable, value "false" is
    returned in XS data mode.  The following elements are only used in XS data mode and
    not returned in AS data mode: routeOverrideDomain routeOverridePrefix Replaced by:
    `GroupCallProcessingGetPolicyRequest22V2()` in AS data mode.

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override (bool): allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy (str): enterpriseCallsCLIDPolicy
        group_calls_clid_policy (str): groupCallsCLIDPolicy
        use_group_phone_list_lookup_setting (bool): useGroupPhoneListLookupSetting
        enable_phone_list_lookup (bool): enablePhoneListLookup
        use_max_concurrent_terminating_alerting_requests (bool):
            useMaxConcurrentTerminatingAlertingRequests
        max_concurrent_terminating_alerting_requests (int):
            maxConcurrentTerminatingAlertingRequests
        include_redirections_in_maximum_number_of_concurrent_calls (bool):
            includeRedirectionsInMaximumNumberOfConcurrentCalls
        use_user_phone_number_for_group_calls_when_internal_clid_unavailable (bool):
            useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable
        use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable (bool):
            useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable
        route_override_domain (str): routeOverrideDomain *Optional*
        route_override_prefix (str): routeOverridePrefix *Optional*
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
        "allow_department_clid_name_override",
        "enterprise_calls_clid_policy",
        "group_calls_clid_policy",
        "use_group_phone_list_lookup_setting",
        "enable_phone_list_lookup",
        "use_max_concurrent_terminating_alerting_requests",
        "max_concurrent_terminating_alerting_requests",
        "include_redirections_in_maximum_number_of_concurrent_calls",
        "use_user_phone_number_for_group_calls_when_internal_clid_unavailable",
        "use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable",
        "route_override_domain",
        "route_override_prefix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "allow_department_clid_name_override",
                "allowDepartmentCLIDNameOverride",
                bool,
                is_required=True,
            ),
            E(
                "enterprise_calls_clid_policy",
                "enterpriseCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "group_calls_clid_policy",
                "groupCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "use_group_phone_list_lookup_setting",
                "useGroupPhoneListLookupSetting",
                bool,
                is_required=True,
            ),
            E(
                "enable_phone_list_lookup",
                "enablePhoneListLookup",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_terminating_alerting_requests",
                "useMaxConcurrentTerminatingAlertingRequests",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_terminating_alerting_requests",
                "maxConcurrentTerminatingAlertingRequests",
                int,
                is_required=True,
            ),
            E(
                "include_redirections_in_maximum_number_of_concurrent_calls",
                "includeRedirectionsInMaximumNumberOfConcurrentCalls",
                bool,
                is_required=True,
            ),
            E(
                "use_user_phone_number_for_group_calls_when_internal_clid_unavailable",
                "useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable",
                bool,
                is_required=True,
            ),
            E(
                "use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable",
                "useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable",
                bool,
                is_required=True,
            ),
            E(
                "route_override_domain",
                "routeOverrideDomain",
                str,
            ),
            E(
                "route_override_prefix",
                "routeOverridePrefix",
                str,
            ),
        )


class GroupCallProcessingGetPolicyResponse22V2(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest22V2()`.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride enterpriseCallsCLIDPolicy, value "Use Location Code
    plus Extension" is returned in XS data mode.  groupCallsCLIDPolicy, value "Use
    Extension" is returned in XS data mode.  useGroupPhoneListLookupSetting, value "false"
    is returned in XS data mode.  enablePhoneListLookup, value "false" is returned in XS
    data mode.  useMaxConcurrentTerminatingAlertingRequests, value "false" is returned in
    XS data mode.  maxConcurrentTerminatingAlertingRequests, value "10" is returned in XS
    data mode.  includeRedirectionsInMaximumNumberOfConcurrentCalls, value "false" is
    returned in XS data mode.  useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable,
    value "false" is returned in XS data mode.
    useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable, value "false" is
    returned in XS data mode.  allowMobileDNForRedirectingIdentity,value "false" is
    returned in XS data mode.  The following elements are only used in XS data mode and
    not returned in AS data mode: routeOverrideDomain routeOverridePrefix Replaced by:
    `GroupCallProcessingGetPolicyResponse22V3()` in AS data mode.

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override (bool): allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy (str): enterpriseCallsCLIDPolicy
        group_calls_clid_policy (str): groupCallsCLIDPolicy
        use_group_phone_list_lookup_setting (bool): useGroupPhoneListLookupSetting
        enable_phone_list_lookup (bool): enablePhoneListLookup
        use_max_concurrent_terminating_alerting_requests (bool):
            useMaxConcurrentTerminatingAlertingRequests
        max_concurrent_terminating_alerting_requests (int):
            maxConcurrentTerminatingAlertingRequests
        include_redirections_in_maximum_number_of_concurrent_calls (bool):
            includeRedirectionsInMaximumNumberOfConcurrentCalls
        use_user_phone_number_for_group_calls_when_internal_clid_unavailable (bool):
            useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable
        use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable (bool):
            useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable
        route_override_domain (str): routeOverrideDomain *Optional*
        route_override_prefix (str): routeOverridePrefix *Optional*
        allow_mobile_dn_for_redirecting_identity (bool):
            allowMobileDNForRedirectingIdentity
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
        "allow_department_clid_name_override",
        "enterprise_calls_clid_policy",
        "group_calls_clid_policy",
        "use_group_phone_list_lookup_setting",
        "enable_phone_list_lookup",
        "use_max_concurrent_terminating_alerting_requests",
        "max_concurrent_terminating_alerting_requests",
        "include_redirections_in_maximum_number_of_concurrent_calls",
        "use_user_phone_number_for_group_calls_when_internal_clid_unavailable",
        "use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable",
        "route_override_domain",
        "route_override_prefix",
        "allow_mobile_dn_for_redirecting_identity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "allow_department_clid_name_override",
                "allowDepartmentCLIDNameOverride",
                bool,
                is_required=True,
            ),
            E(
                "enterprise_calls_clid_policy",
                "enterpriseCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "group_calls_clid_policy",
                "groupCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "use_group_phone_list_lookup_setting",
                "useGroupPhoneListLookupSetting",
                bool,
                is_required=True,
            ),
            E(
                "enable_phone_list_lookup",
                "enablePhoneListLookup",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_terminating_alerting_requests",
                "useMaxConcurrentTerminatingAlertingRequests",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_terminating_alerting_requests",
                "maxConcurrentTerminatingAlertingRequests",
                int,
                is_required=True,
            ),
            E(
                "include_redirections_in_maximum_number_of_concurrent_calls",
                "includeRedirectionsInMaximumNumberOfConcurrentCalls",
                bool,
                is_required=True,
            ),
            E(
                "use_user_phone_number_for_group_calls_when_internal_clid_unavailable",
                "useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable",
                bool,
                is_required=True,
            ),
            E(
                "use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable",
                "useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable",
                bool,
                is_required=True,
            ),
            E(
                "route_override_domain",
                "routeOverrideDomain",
                str,
            ),
            E(
                "route_override_prefix",
                "routeOverridePrefix",
                str,
            ),
            E(
                "allow_mobile_dn_for_redirecting_identity",
                "allowMobileDNForRedirectingIdentity",
                bool,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyResponse22V3(OCIResponse):
    """
    Response to `GroupCallProcessingGetPolicyRequest22V3()`.

    The following elements are not returned for a group within a service provider:
    enableGatewayRoutePolicy networkCallsGatewayRouteIdentity
    networkURLCallsGatewayRouteIdentity emergencyCallsGatewayRouteIdentity
    repairCallsGatewayRouteIdentity callTypingErrorsGatewayRouteIdentity The following
    elements are only used in AS data mode: useGroupDCLIDSetting enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity allowDepartmentCLIDNameOverride
    enterpriseCallsCLIDPolicy, value "Use Location Code plus Extension" is returned in XS
    data mode.  groupCallsCLIDPolicy, value "Use Extension" is returned in XS data mode.
    useGroupPhoneListLookupSetting, value "false" is returned in XS data mode.
    enablePhoneListLookup, value "false" is returned in XS data mode.
    useMaxConcurrentTerminatingAlertingRequests, value "false" is returned in XS data
    mode.  maxConcurrentTerminatingAlertingRequests, value "10" is returned in XS data
    mode.  includeRedirectionsInMaximumNumberOfConcurrentCalls, value "false" is returned
    in XS data mode.  useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable, value
    "false" is returned in XS data mode.
    useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable, value "false" is
    returned in XS data mode.  allowMobileDNForRedirectingIdentity,value "false" is
    returned in XS data mode.  The following elements are only used in AS data mode and
    not returned in XS data mode: enableGatewayRoutePolicy
    networkCallsGatewayRouteIdentity networkURLCallsGatewayRouteIdentity
    emergencyCallsGatewayRouteIdentity repairCallsGatewayRouteIdentity
    callTypingErrorsGatewayRouteIdentity The following elements are only used in XS data
    mode and not returned in AS data mode: routeOverrideDomain routeOverridePrefix

    Attributes:
        use_group_clid_setting (bool): useGroupCLIDSetting
        use_group_media_setting (bool): useGroupMediaSetting
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
        use_group_dclid_setting (bool): useGroupDCLIDSetting
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls
        max_simultaneous_calls (int): maxSimultaneousCalls
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes
        media_policy_selection (str): mediaPolicySelection
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth
        max_redirection_depth (int): maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations
        clid_policy (str): clidPolicy
        emergency_clid_policy (str): emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity
        use_group_name (bool): useGroupName
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
        enable_dialable_caller_id (bool): enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override (bool): allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy (str): enterpriseCallsCLIDPolicy
        group_calls_clid_policy (str): groupCallsCLIDPolicy
        use_group_phone_list_lookup_setting (bool): useGroupPhoneListLookupSetting
        enable_phone_list_lookup (bool): enablePhoneListLookup
        use_max_concurrent_terminating_alerting_requests (bool):
            useMaxConcurrentTerminatingAlertingRequests
        max_concurrent_terminating_alerting_requests (int):
            maxConcurrentTerminatingAlertingRequests
        include_redirections_in_maximum_number_of_concurrent_calls (bool):
            includeRedirectionsInMaximumNumberOfConcurrentCalls
        use_user_phone_number_for_group_calls_when_internal_clid_unavailable (bool):
            useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable
        use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable (bool):
            useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable
        route_override_domain (str): routeOverrideDomain *Optional*
        route_override_prefix (str): routeOverridePrefix *Optional*
        allow_mobile_dn_for_redirecting_identity (bool):
            allowMobileDNForRedirectingIdentity
        enable_gateway_route_policy (bool): enableGatewayRoutePolicy *Optional*
        network_calls_gateway_route_identity (str): networkCallsGatewayRouteIdentity
            *Optional*
        network_url_calls_gateway_route_identity (str):
            networkURLCallsGatewayRouteIdentity *Optional*
        emergency_calls_gateway_route_identity (str): emergencyCallsGatewayRouteIdentity
            *Optional*
        repair_calls_gateway_route_identity (str): repairCallsGatewayRouteIdentity
            *Optional*
        call_typing_errors_gateway_route_identity (str):
            callTypingErrorsGatewayRouteIdentity *Optional*
    """

    __slots__: List[str] = [
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
        "allow_department_clid_name_override",
        "enterprise_calls_clid_policy",
        "group_calls_clid_policy",
        "use_group_phone_list_lookup_setting",
        "enable_phone_list_lookup",
        "use_max_concurrent_terminating_alerting_requests",
        "max_concurrent_terminating_alerting_requests",
        "include_redirections_in_maximum_number_of_concurrent_calls",
        "use_user_phone_number_for_group_calls_when_internal_clid_unavailable",
        "use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable",
        "route_override_domain",
        "route_override_prefix",
        "allow_mobile_dn_for_redirecting_identity",
        "enable_gateway_route_policy",
        "network_calls_gateway_route_identity",
        "network_url_calls_gateway_route_identity",
        "emergency_calls_gateway_route_identity",
        "repair_calls_gateway_route_identity",
        "call_typing_errors_gateway_route_identity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
                is_required=True,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
                is_required=True,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
                is_required=True,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
                is_required=True,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
                is_required=True,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
                is_required=True,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
                is_required=True,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
                is_required=True,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
                is_required=True,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
                is_required=True,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
                is_required=True,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
                is_required=True,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
                is_required=True,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "allow_department_clid_name_override",
                "allowDepartmentCLIDNameOverride",
                bool,
                is_required=True,
            ),
            E(
                "enterprise_calls_clid_policy",
                "enterpriseCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "group_calls_clid_policy",
                "groupCallsCLIDPolicy",
                str,
                is_required=True,
            ),
            E(
                "use_group_phone_list_lookup_setting",
                "useGroupPhoneListLookupSetting",
                bool,
                is_required=True,
            ),
            E(
                "enable_phone_list_lookup",
                "enablePhoneListLookup",
                bool,
                is_required=True,
            ),
            E(
                "use_max_concurrent_terminating_alerting_requests",
                "useMaxConcurrentTerminatingAlertingRequests",
                bool,
                is_required=True,
            ),
            E(
                "max_concurrent_terminating_alerting_requests",
                "maxConcurrentTerminatingAlertingRequests",
                int,
                is_required=True,
            ),
            E(
                "include_redirections_in_maximum_number_of_concurrent_calls",
                "includeRedirectionsInMaximumNumberOfConcurrentCalls",
                bool,
                is_required=True,
            ),
            E(
                "use_user_phone_number_for_group_calls_when_internal_clid_unavailable",
                "useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable",
                bool,
                is_required=True,
            ),
            E(
                "use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable",
                "useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable",
                bool,
                is_required=True,
            ),
            E(
                "route_override_domain",
                "routeOverrideDomain",
                str,
            ),
            E(
                "route_override_prefix",
                "routeOverridePrefix",
                str,
            ),
            E(
                "allow_mobile_dn_for_redirecting_identity",
                "allowMobileDNForRedirectingIdentity",
                bool,
                is_required=True,
            ),
            E(
                "enable_gateway_route_policy",
                "enableGatewayRoutePolicy",
                bool,
            ),
            E(
                "network_calls_gateway_route_identity",
                "networkCallsGatewayRouteIdentity",
                str,
            ),
            E(
                "network_url_calls_gateway_route_identity",
                "networkURLCallsGatewayRouteIdentity",
                str,
            ),
            E(
                "emergency_calls_gateway_route_identity",
                "emergencyCallsGatewayRouteIdentity",
                str,
            ),
            E(
                "repair_calls_gateway_route_identity",
                "repairCallsGatewayRouteIdentity",
                str,
            ),
            E(
                "call_typing_errors_gateway_route_identity",
                "callTypingErrorsGatewayRouteIdentity",
                str,
            ),
        )


class GroupCallRecordingGetResponse(OCIResponse):
    """
    Response to the `GroupCallRecordingGetRequest()`.

    The response contains the group's Call Recording platform information.

    Attributes:
        name (str): name *Optional*
    """

    __slots__: List[str] = [
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
            ),
        )


class GroupCallingLineIdGetResponse(OCIResponse):
    """
    Response to the `GroupCallingLineIdGetRequest()`.

    The response contains the group's calling line id settings.

    Attributes:
        use_group_number (bool): useGroupNumber
        use_group_name (bool): useGroupName
        calling_line_id_phone_number (str): callingLineIdPhoneNumber *Optional*
        calling_line_id_name (str): callingLineIdName *Optional*
    """

    __slots__: List[str] = [
        "use_group_number",
        "use_group_name",
        "calling_line_id_phone_number",
        "calling_line_id_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_number",
                "useGroupNumber",
                bool,
                is_required=True,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
                is_required=True,
            ),
            E(
                "calling_line_id_phone_number",
                "callingLineIdPhoneNumber",
                str,
            ),
            E(
                "calling_line_id_name",
                "callingLineIdName",
                str,
            ),
        )


class GroupCallingPlanGetDigitPatternListResponse(OCIResponse):
    """
    Response to `GroupCallingPlanGetDigitPatternListRequest()`.

    Contains a table with column headings: "Name", "Digit Pattern".

    Attributes:
        digit_pattern_table (List(digitPatternTable)): digitPatternTable - *Table* array
            of digitPatternTable named tuples
    """

    __slots__: List[str] = [
        "digit_pattern_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_table",
                "digitPatternTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCollaborateBridgeGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupCollaborateBridgeGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Department Type", "Parent Department", "Parent Department Type", "Email Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCollaborateBridgeGetAvailableUserPagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupCollaborateBridgeGetAvailableUserPagedSortedListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Is Phone Number Activated",
    "Country Code","National Prefix", "Extension", "Department", "Department Type",
    "Parent Department", "Parent Department Type", "Email Address", "IMP Id", "Mobile
    Number", "Group Id", "Group Name".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCollaborateBridgeGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupCollaborateBridgeGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Participants", and "Is Default". The column values for "Is
    default" can either be true, or false.

    Attributes:
        collaborate_bridge_table (List(collaborateBridgeTable)): collaborateBridgeTable -
            *Table* array of collaborateBridgeTable named tuples
    """

    __slots__: List[str] = [
        "collaborate_bridge_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "collaborate_bridge_table",
                "collaborateBridgeTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCollaborateBridgeGetInstancePagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupCollaborateBridgeGetInstancePagedSortedListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number", "Is
    Phone Number Activated", "Country Code","National Prefix", "Extension", "Department",
    "Department Type", "Parent Department", "Parent Department Type", "Participants", "Is
    Default", "Max Room Participants", "Is Support Outdial". The column values for "Is
    default", "Is Support Outdial" can either be true, or false.

    Attributes:
        collaborate_bridge_table (List(collaborateBridgeTable)): collaborateBridgeTable -
            *Table* array of collaborateBridgeTable named tuples
    """

    __slots__: List[str] = [
        "collaborate_bridge_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "collaborate_bridge_table",
                "collaborateBridgeTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCommunicationBarringAuthorizationCodeGetResponse(OCIResponse):
    """
    Response to `GroupCommunicationBarringAuthorizationCodeGetRequest()`.


    Attributes:
        description (str): description *Optional*
        network_class_of_service (str): networkClassOfService *Optional*
    """

    __slots__: List[str] = [
        "description",
        "network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
            ),
        )


class GroupCommunicationBarringGetResponse(OCIResponse):
    """
    Response to `GroupCommunicationBarringGetRequest()`.


    Attributes:
        use_default_service_provider_profile (bool): useDefaultServiceProviderProfile
        profile (str): profile *Optional*
    """

    __slots__: List[str] = [
        "use_default_service_provider_profile",
        "profile",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_default_service_provider_profile",
                "useDefaultServiceProviderProfile",
                bool,
                is_required=True,
            ),
            E(
                "profile",
                "profile",
                str,
            ),
        )


class GroupCommunicationBarringProfileGetAssignedListResponse(OCIResponse):
    """
    Response to the `GroupCommunicationBarringProfileGetAssignedListRequest()`.

    The response contains a simple list of all communication barring profiles assigned to
    the group.

    Attributes:
        profile_name (List[str]): profileName *Optional*
    """

    __slots__: List[str] = [
        "profile_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "profile_name",
                "profileName",
                str,
                is_array=True,
            ),
        )


class GroupCustomContactDirectoryGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupCustomContactDirectoryGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name". Replace by:
    `GroupCustomContactDirectoryGetAvailableUserListResponse17()`

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCustomContactDirectoryGetAvailableUserListResponse17(OCIResponse):
    """
    Response to the `GroupCustomContactDirectoryGetAvailableUserListRequest17()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Virtual On-Net Phone Number", "Group Id", "Is
    Virtual On-Net User", "Phone Number", "Extension", "Department", "Email Address". If
    the entry represents a Virtual On-Net user then "User Id" is blank, the "Virtual On-
    Net Phone Number" contains the phone Number of the Virtual On-Net user, the "Group Id"
    contains the Virtual On-Net user's group and the "Is Virtual On-Net User" contains
    true.  If the entry represents a BroadWorks user then the "User Id" contains his
    BroadWorks userId, the "Virtual On-Net Phone Number" and "Group Id" fields are blank
    and the "Is Virtual On-Net User" contains false.

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCustomContactDirectoryGetListResponse(OCIResponse):
    """
    Response to the `GroupCustomContactDirectoryGetListRequest()`.

    The response contains all the group's custom contact directory names.

    Attributes:
        name (List[str]): name *Optional*
    """

    __slots__: List[str] = [
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
        )


class GroupCustomContactDirectoryGetResponse(OCIResponse):
    """
    Response to the `GroupCustomContactDirectoryGetRequest()`.

    The response contains all the group's custom contact directory names.  Contains a
    table with column headings: "User Id", "Last Name", "First Name", "Hiragana Last
    Name", "Hiragana First Name". Replace by: `GroupCustomContactDirectoryGetResponse17()`

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCustomContactDirectoryGetResponse17(OCIResponse):
    """
    Response to the `GroupCustomContactDirectoryGetRequest17()`.

    The response contains all the contacts in the group's given custom contact directory.
    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Virtual On-Net Phone Number", "Group Id", "Is
    Virtual On-Net User", "Department", "Phone Number", "Extension", "Mobile", "Email
    Address", "Yahoo Id", "Title", "IMP Id", "Receptionist Note". If the entry represents
    a Virtual On-Net user then "User Id" is blank, the "Virtual On-Net Phone Number"
    contains the phone Number of the Virtual On-Net user, the "Group Id" contains the
    Virtual On-Net user's group and the "Is Virtual On-Net User" contains true.  If the
    entry represents a BroadWorks user then the "User Id" contains his BroadWorks userId,
    the "Virtual On-Net Phone Number" and "Group Id" fields are field is blank and the "Is
    Virtual On-Net User" contains false.  The Receptionist Note column is only populated
    in AS Mode, if the user sending the request is the owner of the Receptionist Note and
    a Note exists.

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupCustomRingbackGroupGetResponse(OCIResponse):
    """
    Response to the `GroupCustomRingbackGroupGetRequest()`.

    Replaced By: `GroupCustomRingbackGroupGetResponse16()`

    Attributes:
        is_active (bool): isActive
        audio_selection (str): audioSelection
        audio_file_description (str): audioFileDescription *Optional*
        audio_file_url (str): audioFileUrl *Optional*
        video_selection (str): videoSelection
        video_file_description (str): videoFileDescription *Optional*
        video_file_url (str): videoFileUrl *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "audio_selection",
        "audio_file_description",
        "audio_file_url",
        "video_selection",
        "video_file_description",
        "video_file_url",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "audio_selection",
                "audioSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "video_selection",
                "videoSelection",
                str,
                is_required=True,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
        )


class GroupCustomRingbackGroupGetResponse16(OCIResponse):
    """
    Response to the `GroupCustomRingbackGroupGetRequest16()`.

    Replaced by: `GroupCustomRingbackGroupGetResponse20()` in AS data mode

    Attributes:
        is_active (bool): isActive
        audio_selection (str): audioSelection
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        audio_file_url (str): audioFileUrl *Optional*
        video_selection (str): videoSelection
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
        video_file_url (str): videoFileUrl *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "audio_selection",
        "audio_file_description",
        "audio_media_type",
        "audio_file_url",
        "video_selection",
        "video_file_description",
        "video_media_type",
        "video_file_url",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "audio_selection",
                "audioSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "video_selection",
                "videoSelection",
                str,
                is_required=True,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
        )


class GroupDepartmentAdminGetListResponse(OCIResponse):
    """
    Response to `GroupDepartmentAdminGetListRequest()`.

    Contains a 5 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Department", "Language".

    Attributes:
        department_admin_table (List(departmentAdminTable)): departmentAdminTable -
            *Table* array of departmentAdminTable named tuples
    """

    __slots__: List[str] = [
        "department_admin_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "department_admin_table",
                "departmentAdminTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDepartmentGetListResponse18(OCIResponse):
    """
    Response to `GroupDepartmentGetListRequest18()`.

    Contains a table of department attributes.  The column headings are: "Is Enterprise
    Department", "Department Name", "Full Path Name", "Calling Line Id Name", and "Calling
    Line Id Phone Number"

    Attributes:
        department_table (List(departmentTable)): departmentTable - *Table* array of
            departmentTable named tuples
    """

    __slots__: List[str] = [
        "department_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "department_table",
                "departmentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDeviceActivationPolicyGetResponse(OCIResponse):
    """
    Response to `GroupDeviceActivationPolicyGetRequest()`.


    Attributes:
        use_group_settings (bool): useGroupSettings
        allow_activation_code_request_by_user (bool): allowActivationCodeRequestByUser
        send_activation_code_in_email (bool): sendActivationCodeInEmail
    """

    __slots__: List[str] = [
        "use_group_settings",
        "allow_activation_code_request_by_user",
        "send_activation_code_in_email",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_settings",
                "useGroupSettings",
                bool,
                is_required=True,
            ),
            E(
                "allow_activation_code_request_by_user",
                "allowActivationCodeRequestByUser",
                bool,
                is_required=True,
            ),
            E(
                "send_activation_code_in_email",
                "sendActivationCodeInEmail",
                bool,
                is_required=True,
            ),
        )


class GroupDeviceManagementEventGetListResponse(OCIResponse):
    """
    Response to `GroupDeviceManagementEventGetListRequest()`.

    Contains a table with column headings: "Event Id", "Status", "Action", "Level",
    "Type", "Additional Info", "Is Local", "Completion %", "Pushed/ Same Hash/ Not
    Pushed", "Login Id", "Start Time", "Process Time". "Event Id" is a unique identifer
    for the event.  "Status" can be: Pending, Queued, In Progress, Process On Other Host,
    Stale, Completed, Canceled.  "Action" can be: Delete, Download, Rebuild, Reset,
    Upload.  "Level" can be: Device, Device Type, Device Type Group, Group, User.  "Type"
    can be: Automatic, Manual.  "Additional Info" includes the affected device type,
    device or group.  It depends on the level of the event: Device Profile: "Device Name"
    "Service Provider Id" "Group Id" Device Type: "Device Type Name" Device Type Group:
    "Service Provider Id" "Group Id" "Device Type Name" Group: "Service Provider Id"
    "Group Id" User: "User Id" "Is Local" is set to "yes" if the event is processed on the
    server who received the request, "no" otherwise meaning that the event is processed on
    another server.  "Completion %" provides an estimate of the completion of the event.
    A percentage is given, the current number of completed expanded event, and the total
    number of expanded event.  "Pushed/ Same Hash/ Not Pushed" gives the total number of
    files that were pushed, not pushed because of same hash, and not pushed when
    processing the event.  "LoginId" is the user or admin id who triggered the event.
    "Start Time" is the date when the event was started.  The display shows the month,
    days, hours, and minutes (MM-dd hh:mm). "Process Time" is the time taken to process
    the event in hours, minutes, seconds, and milliseconds (hhhh:mm:ss.SSS). Each row
    represents an event sorted by priority of processing.  The first row in the table is
    an event that has an associated expanded event currently being processed or next in
    line to be processed.

    Attributes:
        event_table (List(eventTable)): eventTable - *Table* array of eventTable named
            tuples
    """

    __slots__: List[str] = [
        "event_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "event_table",
                "eventTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDeviceManagementEventGetListResponse22(OCIResponse):
    """
    Response to `GroupDeviceManagementEventGetListRequest22()`.

    Contains a table with column headings: "Event Id", "Status", "Action", "Level",
    "Type", "Additional Info", "Is Local", "Completion %", "Pushed/ Same Hash/ Not
    Pushed", "Login Id", "Start Time", "Process Time", "Rx Time", "Total Time", "Request",
    "Priority", "Tracking Id", "End Time". "Event Id" is a unique identifier for the
    event.  "Status" can be: Pending, Queued, In Progress, Process On Other Host, Stale,
    Completed, Canceled.  "Action" can be: Delete, Download, Rebuild, Reset, Upload.
    "Level" can be: Device, Device Type, Device Type Group, Group, User.  "Type" can be:
    Automatic, Manual.  "Additional Info" includes the affected device type, device or
    group.  It depends on the level of the event: Device Profile: "Device Name" "Service
    Provider Id" "Group Id" Device Type: "Device Type Name" Device Type Service Provider:
    "Service Provider Id" "Device Type Name" Service Provider: "Service Provider Id"
    Device Type Group: "Service Provider Id" "Group Id" "Device Type Name" Group: "Service
    Provider Id" "Group Id" User: "User Id" "Is Local" is set to "yes" if the event is
    processed on the server who received the request, "no" otherwise meaning that the
    event is processed on another server.  "Completion %" provides an estimate of the
    completion of the event.  A percentage is given, the current number of completed
    expanded event, and the total number of expanded event.  "Pushed/ Same Hash/ Not
    Pushed" gives the total number of files that were pushed, not pushed because of same
    hash, and not pushed when processing the event.  "LoginId" is the user or admin id who
    triggered the event.  "Start Time" is the date when the event's processing started.
    The display shows the month, day, hours, minutes, and seconds (MM-dd hh:mm:ss).
    "Process Time" is the time taken to process the event in hours, minutes, seconds, and
    milliseconds (hhhh:mm:ss.SSS). "Rx Time" is the date when the event was received via
    OCI-P and stored in the system.  The display shows the month, day, hours, minutes, and
    seconds (MM-dd hh:mm:ss). "Total Time" is the total time the event was in the system,
    from the moment it was received and stored until its processing ended, in hours,
    minutes, seconds, and milliseconds (hhhh:mm:ss.SSS). "Request" is the name of the
    OCI-P request that triggered the event.  "Priority" is the priority of the event.
    "Tracking Id" is the tracking id of the OCI-P request that triggered the event.  "End
    Time" is the difference, measured in milliseconds, between the event's end time and
    midnight, January 1, 1970 UTC

    Attributes:
        event_table (List(eventTable)): eventTable - *Table* array of eventTable named
            tuples
    """

    __slots__: List[str] = [
        "event_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "event_table",
                "eventTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupResponse(OCIResponse):
    """
    Response to `GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest()`.


    Attributes:
        access_device_count (int): accessDeviceCount
    """

    __slots__: List[str] = [
        "access_device_count",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_device_count",
                "accessDeviceCount",
                int,
                is_required=True,
            ),
        )


class GroupDeviceTypeCustomTagGetListResponse(OCIResponse):
    """
    Response to `GroupDeviceTypeCustomTagGetListRequest()`.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device type basis for a group.  In As data mode, the column headings are:
    "Tag Name", "Tag Value", "Actual Tag Value". In XS data mode, the column headings are:
    "Tag Name", "Tag Value", "Actual Tag Value" if request is invoked by an admin without
    system privileges.  "Tag Name", "Tag Value", "Is Encrypted", "Actual Tag Value" if
    request is invoked by an admin with system privileges.

    Attributes:
        group_device_type_custom_tags_table (List(groupDeviceTypeCustomTagsTable)):
            groupDeviceTypeCustomTagsTable - *Table* array of
            groupDeviceTypeCustomTagsTable named tuples
    """

    __slots__: List[str] = [
        "group_device_type_custom_tags_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_device_type_custom_tags_table",
                "groupDeviceTypeCustomTagsTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDeviceTypeFileGetListResponse(OCIResponse):
    """
    Response to `GroupDeviceTypeFileGetListRequest()`.

    Contains a table of device type files managed by the Device Management System, on a
    per-group basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: `GroupDeviceTypeFileGetListResponse14sp8()`

    Attributes:
        group_device_type_files_table (List(groupDeviceTypeFilesTable)):
            groupDeviceTypeFilesTable - *Table* array of groupDeviceTypeFilesTable named
            tuples
    """

    __slots__: List[str] = [
        "group_device_type_files_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_device_type_files_table",
                "groupDeviceTypeFilesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDeviceTypeFileGetListResponse14sp8(OCIResponse):
    """
    Response to `GroupDeviceTypeFileGetListRequest14sp8()`.

    Contains a table of device type files managed by the Device Management System, on a
    per-group basis.  The column headings are: "File Format", "Is Authenticated", "Access
    URL", "Repository URL", "Template URL". Replaced by:
    `GroupDeviceTypeFileGetListResponse21()`

    Attributes:
        group_device_type_files_table (List(groupDeviceTypeFilesTable)):
            groupDeviceTypeFilesTable - *Table* array of groupDeviceTypeFilesTable named
            tuples
    """

    __slots__: List[str] = [
        "group_device_type_files_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_device_type_files_table",
                "groupDeviceTypeFilesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDeviceTypeFileGetListResponse21(OCIResponse):
    """
    Response to `GroupDeviceTypeFileGetListRequest21()`.

    Contains a table of device type files managed by the Device Management System, on a
    per-group basis.  The column headings are: "File Format", "Is Authenticated", "Access
    URL", "Repository URL", "Template URL".

    Attributes:
        group_device_type_files_table (List(groupDeviceTypeFilesTable)):
            groupDeviceTypeFilesTable - *Table* array of groupDeviceTypeFilesTable named
            tuples
        group_has_customizable_dynamic_files (bool): groupHasCustomizableDynamicFiles
    """

    __slots__: List[str] = [
        "group_device_type_files_table",
        "group_has_customizable_dynamic_files",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_device_type_files_table",
                "groupDeviceTypeFilesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
            E(
                "group_has_customizable_dynamic_files",
                "groupHasCustomizableDynamicFiles",
                bool,
                is_required=True,
            ),
        )


class GroupDeviceTypeFileGetResponse(OCIResponse):
    """
    Response to `GroupDeviceTypeFileGetRequest()`.

    Replaced By: `GroupDeviceTypeFileGetResponse14sp8()`

    Attributes:
        file_source (str): fileSource *Optional*
        configuration_file_name (str): configurationFileName *Optional*
    """

    __slots__: List[str] = [
        "file_source",
        "configuration_file_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_source",
                "fileSource",
                str,
            ),
            E(
                "configuration_file_name",
                "configurationFileName",
                str,
            ),
        )


class GroupDeviceTypeFileGetResponse14sp8(OCIResponse):
    """
    Response to `GroupDeviceTypeFileGetRequest14sp8()`.

    Replaced by: `GroupDeviceTypeFileGetResponse16sp1()`

    Attributes:
        file_source (str): fileSource *Optional*
        configuration_file_name (str): configurationFileName *Optional*
    """

    __slots__: List[str] = [
        "file_source",
        "configuration_file_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_source",
                "fileSource",
                str,
            ),
            E(
                "configuration_file_name",
                "configurationFileName",
                str,
            ),
        )


class GroupDeviceTypeFileGetResponse16sp1(OCIResponse):
    """
    Response to `GroupDeviceTypeFileGetRequest16sp1()`.


    Attributes:
        file_source (str): fileSource *Optional*
        configuration_file_name (str): configurationFileName *Optional*
        access_url (str): accessUrl
        repository_url (str): repositoryUrl *Optional*
        template_url (str): templateUrl *Optional*
    """

    __slots__: List[str] = [
        "file_source",
        "configuration_file_name",
        "access_url",
        "repository_url",
        "template_url",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_source",
                "fileSource",
                str,
            ),
            E(
                "configuration_file_name",
                "configurationFileName",
                str,
            ),
            E(
                "access_url",
                "accessUrl",
                str,
                is_required=True,
            ),
            E(
                "repository_url",
                "repositoryUrl",
                str,
            ),
            E(
                "template_url",
                "templateUrl",
                str,
            ),
        )


class GroupDeviceTypeTagSetGetResponse(OCIResponse):
    """
    Response to `GroupDeviceTypeTagSetGetRequest()`.


    Attributes:
        tag_set_name (str): tagSetName *Optional*
    """

    __slots__: List[str] = [
        "tag_set_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "tag_set_name",
                "tagSetName",
                str,
            ),
        )


class GroupDialPlanPolicyGetAccessCodeListResponse(OCIResponse):
    """
    Response to `GroupDialPlanPolicyGetAccessCodeListRequest()` Contains a table with
    column headings: "Access Code", "Enable Secondary Dial Tone", "Description"

    Attributes:
        access_code_table (List(accessCodeTable)): accessCodeTable - *Table* array of
            accessCodeTable named tuples
    """

    __slots__: List[str] = [
        "access_code_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "access_code_table",
                "accessCodeTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDialPlanPolicyGetAccessCodeResponse(OCIResponse):
    """
    Response to `GroupDialPlanPolicyGetAccessCodeRequest()`

    Attributes:
        include_code_for_network_translations_and_routing (bool):
            includeCodeForNetworkTranslationsAndRouting
        include_code_for_screening_services (bool): includeCodeForScreeningServices
        enable_secondary_dial_tone (bool): enableSecondaryDialTone
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "include_code_for_network_translations_and_routing",
        "include_code_for_screening_services",
        "enable_secondary_dial_tone",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "include_code_for_network_translations_and_routing",
                "includeCodeForNetworkTranslationsAndRouting",
                bool,
                is_required=True,
            ),
            E(
                "include_code_for_screening_services",
                "includeCodeForScreeningServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_secondary_dial_tone",
                "enableSecondaryDialTone",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupDialPlanPolicyGetResponse(OCIResponse):
    """
    Response to `GroupDialPlanPolicyGetRequest()` Replaced by:
    `GroupDialPlanPolicyGetResponse17()`

    Attributes:
        use_setting (str): useSetting
        requires_access_code_for_public_calls (bool): requiresAccessCodeForPublicCalls
        allow_e164_public_calls (bool): allowE164PublicCalls
        public_digit_map (str): publicDigitMap *Optional*
        private_digit_map (str): privateDigitMap *Optional*
    """

    __slots__: List[str] = [
        "use_setting",
        "requires_access_code_for_public_calls",
        "allow_e164_public_calls",
        "public_digit_map",
        "private_digit_map",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting",
                "useSetting",
                str,
                is_required=True,
            ),
            E(
                "requires_access_code_for_public_calls",
                "requiresAccessCodeForPublicCalls",
                bool,
                is_required=True,
            ),
            E(
                "allow_e164_public_calls",
                "allowE164PublicCalls",
                bool,
                is_required=True,
            ),
            E(
                "public_digit_map",
                "publicDigitMap",
                str,
            ),
            E(
                "private_digit_map",
                "privateDigitMap",
                str,
            ),
        )


class GroupDialPlanPolicyGetResponse17(OCIResponse):
    """
    Response to `GroupDialPlanPolicyGetRequest17()`

    Attributes:
        use_setting (str): useSetting
        requires_access_code_for_public_calls (bool): requiresAccessCodeForPublicCalls
        allow_e164_public_calls (bool): allowE164PublicCalls
        prefer_e164_number_format_for_callback_services (bool):
            preferE164NumberFormatForCallbackServices
        public_digit_map (str): publicDigitMap *Optional*
        private_digit_map (str): privateDigitMap *Optional*
    """

    __slots__: List[str] = [
        "use_setting",
        "requires_access_code_for_public_calls",
        "allow_e164_public_calls",
        "prefer_e164_number_format_for_callback_services",
        "public_digit_map",
        "private_digit_map",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting",
                "useSetting",
                str,
                is_required=True,
            ),
            E(
                "requires_access_code_for_public_calls",
                "requiresAccessCodeForPublicCalls",
                bool,
                is_required=True,
            ),
            E(
                "allow_e164_public_calls",
                "allowE164PublicCalls",
                bool,
                is_required=True,
            ),
            E(
                "prefer_e164_number_format_for_callback_services",
                "preferE164NumberFormatForCallbackServices",
                bool,
                is_required=True,
            ),
            E(
                "public_digit_map",
                "publicDigitMap",
                str,
            ),
            E(
                "private_digit_map",
                "privateDigitMap",
                str,
            ),
        )


class GroupDialPlanPolicyGetResponse22(OCIResponse):
    """
    Response to `GroupDialPlanPolicyGetRequest22()` The following elements are only used
    in AS data mode: overrideResolvedDeviceDigitMap The following elements are only used
    in AS data mode and not returned in XS data mode: deviceDigitMap

    Attributes:
        use_setting (str): useSetting
        requires_access_code_for_public_calls (bool): requiresAccessCodeForPublicCalls
        allow_e164_public_calls (bool): allowE164PublicCalls
        prefer_e164_number_format_for_callback_services (bool):
            preferE164NumberFormatForCallbackServices
        public_digit_map (str): publicDigitMap *Optional*
        private_digit_map (str): privateDigitMap *Optional*
        override_resolved_device_digit_map (bool): overrideResolvedDeviceDigitMap
        device_digit_map (str): deviceDigitMap *Optional*
    """

    __slots__: List[str] = [
        "use_setting",
        "requires_access_code_for_public_calls",
        "allow_e164_public_calls",
        "prefer_e164_number_format_for_callback_services",
        "public_digit_map",
        "private_digit_map",
        "override_resolved_device_digit_map",
        "device_digit_map",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting",
                "useSetting",
                str,
                is_required=True,
            ),
            E(
                "requires_access_code_for_public_calls",
                "requiresAccessCodeForPublicCalls",
                bool,
                is_required=True,
            ),
            E(
                "allow_e164_public_calls",
                "allowE164PublicCalls",
                bool,
                is_required=True,
            ),
            E(
                "prefer_e164_number_format_for_callback_services",
                "preferE164NumberFormatForCallbackServices",
                bool,
                is_required=True,
            ),
            E(
                "public_digit_map",
                "publicDigitMap",
                str,
            ),
            E(
                "private_digit_map",
                "privateDigitMap",
                str,
            ),
            E(
                "override_resolved_device_digit_map",
                "overrideResolvedDeviceDigitMap",
                bool,
                is_required=True,
            ),
            E(
                "device_digit_map",
                "deviceDigitMap",
                str,
            ),
        )


class GroupDialableCallerIDCriteriaGetResponse(OCIResponse):
    """
    Response to the `GroupDialableCallerIDCriteriaGetRequest()`.

    The response contains the Dialable Caller ID Criteria information.

    Attributes:
        description (str): description *Optional*
        prefix_digits (str): prefixDigits *Optional*
        match_call_type (List[str]): matchCallType *Optional*
        match_alternate_call_indicator (List[str]): matchAlternateCallIndicator *Optional*
        match_local_category (bool): matchLocalCategory
        match_national_category (bool): matchNationalCategory
        match_interlata_category (bool): matchInterlataCategory
        match_intralata_category (bool): matchIntralataCategory
        match_international_category (bool): matchInternationalCategory
        match_private_category (bool): matchPrivateCategory
        match_emergency_category (bool): matchEmergencyCategory
        match_other_category (bool): matchOtherCategory
    """

    __slots__: List[str] = [
        "description",
        "prefix_digits",
        "match_call_type",
        "match_alternate_call_indicator",
        "match_local_category",
        "match_national_category",
        "match_interlata_category",
        "match_intralata_category",
        "match_international_category",
        "match_private_category",
        "match_emergency_category",
        "match_other_category",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "description",
                "description",
                str,
            ),
            E(
                "prefix_digits",
                "prefixDigits",
                str,
            ),
            E(
                "match_call_type",
                "matchCallType",
                str,
                is_array=True,
            ),
            E(
                "match_alternate_call_indicator",
                "matchAlternateCallIndicator",
                str,
                is_array=True,
            ),
            E(
                "match_local_category",
                "matchLocalCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_national_category",
                "matchNationalCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_interlata_category",
                "matchInterlataCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_intralata_category",
                "matchIntralataCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_international_category",
                "matchInternationalCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_private_category",
                "matchPrivateCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_emergency_category",
                "matchEmergencyCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_other_category",
                "matchOtherCategory",
                bool,
                is_required=True,
            ),
        )


class GroupDialableCallerIDGetResponse(OCIResponse):
    """
    Response to the `GroupDialableCallerIDGetRequest()`.

    The criteria table's column headings are "Active", "Name", "Description", "Prefix
    Digits", "Priority".

    Attributes:
        use_group_criteria (bool): useGroupCriteria
        ns_screening_failure_policy (str): nsScreeningFailurePolicy
        criteria_table (List(criteriaTable)): criteriaTable - *Table* array of
            criteriaTable named tuples
    """

    __slots__: List[str] = [
        "use_group_criteria",
        "ns_screening_failure_policy",
        "criteria_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_group_criteria",
                "useGroupCriteria",
                bool,
                is_required=True,
            ),
            E(
                "ns_screening_failure_policy",
                "nsScreeningFailurePolicy",
                str,
                is_required=True,
            ),
            E(
                "criteria_table",
                "criteriaTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDigitCollectionGetResponse13mp4(OCIResponse):
    """
    Response to `GroupDigitCollectionGetRequest13mp4()`.


    Attributes:
        use_setting (str): useSetting
        access_code (str): accessCode *Optional*
        public_digit_map (str): publicDigitMap *Optional*
        private_digit_map (str): privateDigitMap *Optional*
    """

    __slots__: List[str] = [
        "use_setting",
        "access_code",
        "public_digit_map",
        "private_digit_map",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting",
                "useSetting",
                str,
                is_required=True,
            ),
            E(
                "access_code",
                "accessCode",
                str,
            ),
            E(
                "public_digit_map",
                "publicDigitMap",
                str,
            ),
            E(
                "private_digit_map",
                "privateDigitMap",
                str,
            ),
        )


class GroupDirectoryNumberHuntingGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupDirectoryNumberHuntingGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDirectoryNumberHuntingGetResponse(OCIResponse):
    """
    Response to the `GroupDirectoryNumberHuntingGetRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address". Replaced by: `GroupDirectoryNumberHuntingGetResponse17sp1()`

    Attributes:
        agent_user_table (List(agentUserTable)): agentUserTable - *Table* array of
            agentUserTable named tuples
    """

    __slots__: List[str] = [
        "agent_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_user_table",
                "agentUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDirectoryNumberHuntingGetResponse17sp1(OCIResponse):
    """
    Response to the `GroupDirectoryNumberHuntingGetRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_user_table (List(agentUserTable)): agentUserTable - *Table* array of
            agentUserTable named tuples
        use_terminate_call_to_agent_first (bool): useTerminateCallToAgentFirst
        use_original_agent_services_for_busy_and_no_answer_calls (bool):
            useOriginalAgentServicesForBusyAndNoAnswerCalls
    """

    __slots__: List[str] = [
        "agent_user_table",
        "use_terminate_call_to_agent_first",
        "use_original_agent_services_for_busy_and_no_answer_calls",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_user_table",
                "agentUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
            E(
                "use_terminate_call_to_agent_first",
                "useTerminateCallToAgentFirst",
                bool,
                is_required=True,
            ),
            E(
                "use_original_agent_services_for_busy_and_no_answer_calls",
                "useOriginalAgentServicesForBusyAndNoAnswerCalls",
                bool,
                is_required=True,
            ),
        )


class GroupDnGetActivationListResponse(OCIResponse):
    """
    Response to the `GroupDnGetActivationListRequest()`.

    The response contains a table with columns: "Phone Numbers", and "Activated". ". Phone
    Numbers are only returned if assigned to a user.  The "Phone Numbers" column contains
    either a single DN or a range of DNs.  The "Activated" column indicates if the phone
    number(s) are activated or not.

    Attributes:
        dn_table (List(dnTable)): dnTable - *Table* array of dnTable named tuples
    """

    __slots__: List[str] = [
        "dn_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn_table",
                "dnTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDnGetAssignmentListResponse(OCIResponse):
    """
    Response to the `GroupDnGetAssignmentListRequest()`.

    The response contains a table with columns: "Phone Numbers", "Assigned To",
    "Department", "Activated". The "Phone Numbers" column contains either a single DN or a
    range of DNs.  The "Assigned To" column contains the user name or service instance
    name possessing the DN(s). The "Department" column contains the department of the DN,
    not the department of the user or service instance.  The "Activated" column indicates
    if the DN or DN range has been activated.  Only has a value if the DN(s) is assigned
    to a user.  Replaced by: `GroupDnGetAssignmentListResponse18()`

    Attributes:
        dn_table (List(dnTable)): dnTable - *Table* array of dnTable named tuples
    """

    __slots__: List[str] = [
        "dn_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn_table",
                "dnTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDnGetAssignmentListResponse18(OCIResponse):
    """
    Response to the `GroupDnGetAssignmentListRequest18()`.

    The response contains a table with columns: "Phone Numbers", "Department",
    "Activated", "User Id", "Last Name", "First Name", "Extension", "Email Address", "User
    Type", "Country Code", "National Prefix". The "Phone Numbers" column contains either a
    single DN or a range of DNs.  The "User Id", "Last Name" and "First Name" columns
    contains the corresponding attributes of the user possessing the DN(s). For a service
    instance, "Last Name" contains the service instance name and "First Name" column
    contains the corresponding enumerated UserType value.  The "Department" column
    contains the department of the DN, not the department of the user or service instance.
    The "Activated" column indicates if the DN or DN range has been activated.  The "User
    Type" column contains the corresponding enumerated UserType value.  The "Country Code"
    column indicates the dialing prefix for the phone number.  The "National Prefix"
    column indicates the digit sequence to be dialed before the telephone number.  NOTE:
    the same phone number can show up in the list twice if the phone number is being used
    as the group calling line Id.

    Attributes:
        dn_table (List(dnTable)): dnTable - *Table* array of dnTable named tuples
    """

    __slots__: List[str] = [
        "dn_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn_table",
                "dnTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDnGetAssignmentPagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupDnGetAssignmentPagedSortedListRequest()`.

    The response contains a table with columns: "Phone Numbers", "Department", "Department
    Type", "Parent Department", "Parent Department Type", "Activated", "Available", "User
    Id", "Last Name", "First Name", "Extension", "Email Address", "User Type", "Country
    Code", "National Prefix". The "Phone Numbers" column contains either a single DN or a
    range of DNs.  The "User Id", "Last Name" and "First Name" columns contains the
    corresponding attributes of the user possessing the DN(s). For a service instance,
    "Last Name" contains the service instance name and "First Name" column contains the
    corresponding enumerated UserType value.  The "Department" column contains the
    department of the DN, not the department of the user or service instance.  The
    "Department Type" and "Parent Department Type" columns will contain the values
    "Enterprise" or "Group". The "Activated" column indicates if the DN or DN range has
    been activated.  Only has a value if the DN(s) is assigned to a user.  The "User Type"
    column contains the corresponding enumerated UserType value.  The "Country Code"
    column indicates the dialing prefix for the phone number.  The "National Prefix"
    column indicates the digit sequence to be dialed before the telephone number.  NOTE:
    the same phone number can show up in the list twice if the phone number is being used
    as the group calling line Id.

    Attributes:
        dn_table (List(dnTable)): dnTable - *Table* array of dnTable named tuples
    """

    __slots__: List[str] = [
        "dn_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn_table",
                "dnTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDnGetAvailableListResponse(OCIResponse):
    """
    Response to the `GroupDnGetAvailableListRequest()`.

    The response contains the list of DNs that are assigned to a group and still available
    for assignment to users or service instances within the group.

    Attributes:
        phone_number (List[str]): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
        )


class GroupDnGetAvailableRangesListResponse(OCIResponse):
    """
    Response to the `GroupDnGetAvailableRangesListRequest()`.

    The response contains the list of group DNs that are not assigned to user, service
    instances or IMRN pool.  The Dns are returned in a list of DNs or DN ranges and
    formated in E164 format for display.

    Attributes:
        phone_number (List[str]): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
        )


class GroupDnGetDetailedAvailableListResponse(OCIResponse):
    """
    Response to the `GroupDnGetDetailedAvailableListRequest()`.

    The response contains a table with columns: "Phone Number", "Department". The "Phone
    Numbers" column contains a single DN. The "Department" column contains the department
    of the DN if the DN is part of the department.  The "Activated" column indicates if
    the DN has been activated.  Only has a value if the DN(s) is assigned to a user or if
    "Group Enable Activation Mode" is enabled.

    Attributes:
        dn_table (List(dnTable)): dnTable - *Table* array of dnTable named tuples
    """

    __slots__: List[str] = [
        "dn_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn_table",
                "dnTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDnGetListResponse(OCIResponse):
    """
    Response to the `GroupDnGetListRequest()`.

    The response contains the list of DNs assigned to the group.

    Attributes:
        phone_number (List[str]): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
        )


class GroupDnGetSummaryListResponse(OCIResponse):
    """
    Response to the `GroupDnGetSummaryListRequest()`.

    The response contains a table with columns: "Phone Numbers", "Assigned". The "Phone
    Numbers" column contains either a single DN or a range of DNs.  The "Assigned" column
    contains a boolean flag indicating if the DN(s) are currently assigned to a user or
    service instance.  The "Activated" column indicates if the DN or DN range has been
    activated.  Only has a value if the DN(s) is assigned to a user or if either “User
    Enable Activation mode “ or "Group and User Enable Activation Mode" is enabled.

    Attributes:
        dn_table (List(dnTable)): dnTable - *Table* array of dnTable named tuples
    """

    __slots__: List[str] = [
        "dn_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dn_table",
                "dnTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupDomainGetAssignedListResponse(OCIResponse):
    """
    Contains a simple list of all group domain names.


    Attributes:
        group_default_domain (str): groupDefaultDomain
        domain (List[str]): domain *Optional*
    """

    __slots__: List[str] = [
        "group_default_domain",
        "domain",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_default_domain",
                "groupDefaultDomain",
                str,
                is_required=True,
            ),
            E(
                "domain",
                "domain",
                str,
                is_array=True,
            ),
        )


class GroupDomainGetAssignedUserListResponse(OCIResponse):
    """
    Response to `GroupDomainGetAssignedUserListRequest()`.

    The table columns are: "User Id", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Service Provider Id", "Group Id", "Hiragana Last Name" and
    "Hiragana First Name", "Extension".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupEmergencyCallNotificationGetResponse(OCIResponse):
    """
    Response to `GroupEmergencyCallNotificationGetRequest()`.


    Attributes:
        send_emergency_call_notification_email (bool): sendEmergencyCallNotificationEmail
        emergency_call_notify_email_address (str): emergencyCallNotifyEmailAddress
            *Optional*
    """

    __slots__: List[str] = [
        "send_emergency_call_notification_email",
        "emergency_call_notify_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "send_emergency_call_notification_email",
                "sendEmergencyCallNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "emergency_call_notify_email_address",
                "emergencyCallNotifyEmailAddress",
                str,
            ),
        )


class GroupEmergencyZonesGetResponse(OCIResponse):
    """
    Response to `GroupEmergencyZonesGetRequest()`.


    Attributes:
        is_active (bool): isActive
        emergency_zones_prohibition (str): emergencyZonesProhibition
        send_emergency_call_notify_email (bool): sendEmergencyCallNotifyEmail
        emergency_call_notify_email_address (str): emergencyCallNotifyEmailAddress
            *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "emergency_zones_prohibition",
        "send_emergency_call_notify_email",
        "emergency_call_notify_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "emergency_zones_prohibition",
                "emergencyZonesProhibition",
                str,
                is_required=True,
            ),
            E(
                "send_emergency_call_notify_email",
                "sendEmergencyCallNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "emergency_call_notify_email_address",
                "emergencyCallNotifyEmailAddress",
                str,
            ),
        )


class GroupEndpointGetListResponse(OCIResponse):
    """
    Response to `GroupEndpointGetListRequest()`.

    The column headings for the endpointTable are: "Line/Port", "Last Name", "First Name",
    "User Id", "User Type", "Phone Number", "Extension", "Device Type", "Device Name",
    "Net Address", "MAC Address", "Department", "Email Address". Possible values for User
    Type are "User", "CCBasic", "CCStandard", "CCPremium", "RP", "MOH", "MOHVideo".

    Attributes:
        endpoint_table (List(endpointTable)): endpointTable - *Table* array of
            endpointTable named tuples
    """

    __slots__: List[str] = [
        "endpoint_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "endpoint_table",
                "endpointTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupEnhancedCallLogsSchemaInstanceGetResponse(OCIResponse):
    """
    Response to `GroupEnhancedCallLogsSchemaInstanceGetRequest()`.


    Attributes:
        name (str): name *Optional*
    """

    __slots__: List[str] = [
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
            ),
        )


class GroupEnterpriseTrunkGetAvailableTrunkGroupListResponse(OCIResponse):
    """
    Response to `GroupEnterpriseTrunkGetAvailableTrunkGroupListRequest()`.


    Attributes:
        trunk_group_name (List[str]): trunkGroupName *Optional*
    """

    __slots__: List[str] = [
        "trunk_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "trunk_group_name",
                "trunkGroupName",
                str,
                is_array=True,
            ),
        )


class GroupEnterpriseTrunkGetAvailableUserListResponse(OCIResponse):
    """
    Response to `GroupEnterpriseTrunkGetAvailableUserListRequest()`.

    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number",
    "Extension", "Department", "Email Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupEnterpriseTrunkGetListResponse(OCIResponse):
    """
    Response to `GroupEnterpriseTrunkGetListRequest()`.

    Contains a table of enterprise trunks defined in the enterprise The column headings
    are: "Enterprise Trunk Name", "Routing Type"

    Attributes:
        enterprise_trunk_table (List(enterpriseTrunkTable)): enterpriseTrunkTable -
            *Table* array of enterpriseTrunkTable named tuples
    """

    __slots__: List[str] = [
        "enterprise_trunk_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enterprise_trunk_table",
                "enterpriseTrunkTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupEnterpriseTrunkGetResponse(OCIResponse):
    """
    Response to `GroupEnterpriseTrunkGetRequest()`.

    Replaced by: `GroupEnterpriseTrunkGetResponse21()`.

    Attributes:
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
    """

    __slots__: List[str] = [
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        OCI.EnterpriseTrunkTrunkGroupKey,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.GroupEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class GroupEnterpriseTrunkGetResponse21(OCIResponse):
    """
    Response to `GroupEnterpriseTrunkGetRequest21()`.


    Attributes:
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
        enable_capacity_management (bool): enableCapacityManagement
        max_active_calls (int): maxActiveCalls *Optional*
        capacity_exceeded_trap_initial_calls (int): capacityExceededTrapInitialCalls
            *Optional*
        capacity_exceeded_trap_offset_calls (int): capacityExceededTrapOffsetCalls
            *Optional*
    """

    __slots__: List[str] = [
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
        "enable_capacity_management",
        "max_active_calls",
        "capacity_exceeded_trap_initial_calls",
        "capacity_exceeded_trap_offset_calls",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        OCI.EnterpriseTrunkTrunkGroupKey,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.GroupEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "enable_capacity_management",
                "enableCapacityManagement",
                bool,
                is_required=True,
            ),
            E(
                "max_active_calls",
                "maxActiveCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_initial_calls",
                "capacityExceededTrapInitialCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_offset_calls",
                "capacityExceededTrapOffsetCalls",
                int,
            ),
        )


class GroupEnterpriseTrunkGetResponse22(OCIResponse):
    """
    Response to `GroupEnterpriseTrunkGetRequest22()`.


    Attributes:
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
        enable_capacity_management (bool): enableCapacityManagement
        max_active_calls (int): maxActiveCalls *Optional*
        capacity_exceeded_trap_initial_calls (int): capacityExceededTrapInitialCalls
            *Optional*
        capacity_exceeded_trap_offset_calls (int): capacityExceededTrapOffsetCalls
            *Optional*
        maximum_active_incoming_calls_allowed (int): maximumActiveIncomingCallsAllowed
            *Optional*
        maximum_active_outgoing_calls_allowed (int): maximumActiveOutgoingCallsAllowed
            *Optional*
        minimum_active_calls_reserved (int): minimumActiveCallsReserved *Optional*
    """

    __slots__: List[str] = [
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
        "enable_capacity_management",
        "max_active_calls",
        "capacity_exceeded_trap_initial_calls",
        "capacity_exceeded_trap_offset_calls",
        "maximum_active_incoming_calls_allowed",
        "maximum_active_outgoing_calls_allowed",
        "minimum_active_calls_reserved",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        OCI.EnterpriseTrunkTrunkGroupKey,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.GroupEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "enable_capacity_management",
                "enableCapacityManagement",
                bool,
                is_required=True,
            ),
            E(
                "max_active_calls",
                "maxActiveCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_initial_calls",
                "capacityExceededTrapInitialCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_offset_calls",
                "capacityExceededTrapOffsetCalls",
                int,
            ),
            E(
                "maximum_active_incoming_calls_allowed",
                "maximumActiveIncomingCallsAllowed",
                int,
            ),
            E(
                "maximum_active_outgoing_calls_allowed",
                "maximumActiveOutgoingCallsAllowed",
                int,
            ),
            E(
                "minimum_active_calls_reserved",
                "minimumActiveCallsReserved",
                int,
            ),
        )


class GroupEnterpriseTrunkGetUserListResponse(OCIResponse):
    """
    Response to `GroupEnterpriseTrunkGetUserListRequest()`.

    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Phone Number", "Alternate Trunk Identity", "Hiragana Last Name",
    "Hiragana First Name", "Extension", "Department", "Email Address" and "Route List
    Assigned".

    Attributes:
        enterprise_trunk_user_table (List(enterpriseTrunkUserTable)):
            enterpriseTrunkUserTable - *Table* array of enterpriseTrunkUserTable named
            tuples
    """

    __slots__: List[str] = [
        "enterprise_trunk_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enterprise_trunk_user_table",
                "enterpriseTrunkUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupExchangeIntegrationGetResponse(OCIResponse):
    """
    Response to `GroupExchangeIntegrationGetRequest()`.


    Attributes:
        enable_exchange_integration (bool): enableExchangeIntegration
        exchange_url (str): exchangeURL *Optional*
        exchange_user_name (str): exchangeUserName *Optional*
    """

    __slots__: List[str] = [
        "enable_exchange_integration",
        "exchange_url",
        "exchange_user_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_exchange_integration",
                "enableExchangeIntegration",
                bool,
                is_required=True,
            ),
            E(
                "exchange_url",
                "exchangeURL",
                str,
            ),
            E(
                "exchange_user_name",
                "exchangeUserName",
                str,
            ),
        )


class GroupExtensionLengthGetResponse(OCIResponse):
    """
    Response to `GroupExtensionLengthGetRequest()`.


    Attributes:
        extension_length (int): extensionLength
    """

    __slots__: List[str] = [
        "extension_length",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "extension_length",
                "extensionLength",
                int,
                is_required=True,
            ),
        )


class GroupExtensionLengthGetResponse17(OCIResponse):
    """
    Response to `GroupExtensionLengthGetRequest17()`.

    Replaced by: `GroupExtensionLengthGetResponse22()` in AS data mode

    Attributes:
        min_extension_length (int): minExtensionLength
        max_extension_length (int): maxExtensionLength
        default_extension_length (int): defaultExtensionLength
    """

    __slots__: List[str] = [
        "min_extension_length",
        "max_extension_length",
        "default_extension_length",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "min_extension_length",
                "minExtensionLength",
                int,
                is_required=True,
            ),
            E(
                "max_extension_length",
                "maxExtensionLength",
                int,
                is_required=True,
            ),
            E(
                "default_extension_length",
                "defaultExtensionLength",
                int,
                is_required=True,
            ),
        )


class GroupExtensionLengthGetResponse22(OCIResponse):
    """
    Response to `GroupExtensionLengthGetRequest22()`.

    The following elements are only used in AS data mode and not returned in XS data mode:
    useExterpriseExtensionLengthSetting

    Attributes:
        min_extension_length (int): minExtensionLength
        max_extension_length (int): maxExtensionLength
        default_extension_length (int): defaultExtensionLength
        use_enterprise_extension_length_setting (bool):
            useEnterpriseExtensionLengthSetting *Optional*
    """

    __slots__: List[str] = [
        "min_extension_length",
        "max_extension_length",
        "default_extension_length",
        "use_enterprise_extension_length_setting",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "min_extension_length",
                "minExtensionLength",
                int,
                is_required=True,
            ),
            E(
                "max_extension_length",
                "maxExtensionLength",
                int,
                is_required=True,
            ),
            E(
                "default_extension_length",
                "defaultExtensionLength",
                int,
                is_required=True,
            ),
            E(
                "use_enterprise_extension_length_setting",
                "useEnterpriseExtensionLengthSetting",
                bool,
            ),
        )


class GroupFileRepositoryDeviceUserGetListResponse(OCIResponse):
    """
    Response to `GroupFileRepositoryDeviceUserGetListRequest()`.

    Contains a table with column headings : "User Name","Allow Delete","Allow Get","Allow
    Put" in a row for each file repository service provider user.

    Attributes:
        file_repository_user_table (List(fileRepositoryUserTable)):
            fileRepositoryUserTable - *Table* array of fileRepositoryUserTable named
            tuples
    """

    __slots__: List[str] = [
        "file_repository_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "file_repository_user_table",
                "fileRepositoryUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupFindMeFollowMeAlertingGroupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupFindMeFollowMeAlertingGroupGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupFindMeFollowMeGetAlertingGroupListResponse(OCIResponse):
    """
    Response to the `GroupFindMeFollowMeGetAlertingGroupListRequest()`.

    Contains a table with column headings: "Name", "Priority".

    Attributes:
        alerting_group_table (List(alertingGroupTable)): alertingGroupTable - *Table*
            array of alertingGroupTable named tuples
    """

    __slots__: List[str] = [
        "alerting_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "alerting_group_table",
                "alertingGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupFindMeFollowMeGetAlertingGroupResponse(OCIResponse):
    """
    Response to `GroupFindMeFollowMeGetAlertingGroupRequest()`.

    Contains the alerting group information.  The user table’s column headings are: "User
    Id", "Last Name", "First Name", "Hiragana Last Name" and "Hiragana First Name", "Phone
    Number", "Extension", "Department", "Email Address". The criteria table's column
    headings are: "Is Active", "Criteria Name", "Time Schedule", "Calls From",
    "Blacklisted", "Holiday Schedule"", "Calls To Type", "Calls To Number" and "Calls To
    Extension". The possible values for the "Calls To Type" column are the following or a
    combination of them separated by comma: - Primary - Alternate X (where x is a number
    between 1 and 10) The possible values for the "Calls To Number" column are the
    following or a combination of them separated by comma: - The value of the phone number
    for the corresponding Calls To Type, when the number is available.  i.e.  Alternate 1
    may have extension, but no number.  - When no number is available a blank space is
    provided instead.  The possible values for the "Calls To Extension" column are the
    following or a combination of them separated by comma: - The value of the extension
    for the corresponding Calls To Type, when the extension is available.  i.e.  Primary
    may have number, but no extension.  - When no extension is available a blank space is
    provided instead.

    Attributes:
        alerting_group_description (str): alertingGroupDescription *Optional*
        use_diversion_inhibitor (bool): useDiversionInhibitor
        answer_confirmation_required (bool): answerConfirmationRequired
        number_of_rings (int): numberOfRings
        phone_number (List[str]): phoneNumber *Optional*
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
        criteria_table (List(criteriaTable)): criteriaTable - *Table* array of
            criteriaTable named tuples
    """

    __slots__: List[str] = [
        "alerting_group_description",
        "use_diversion_inhibitor",
        "answer_confirmation_required",
        "number_of_rings",
        "phone_number",
        "user_table",
        "criteria_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "alerting_group_description",
                "alertingGroupDescription",
                str,
            ),
            E(
                "use_diversion_inhibitor",
                "useDiversionInhibitor",
                bool,
                is_required=True,
            ),
            E(
                "answer_confirmation_required",
                "answerConfirmationRequired",
                bool,
                is_required=True,
            ),
            E(
                "number_of_rings",
                "numberOfRings",
                int,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_array=True,
            ),
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
            E(
                "criteria_table",
                "criteriaTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupFindMeFollowMeGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupFindMeFollowMeGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.

    Attributes:
        find_me_follow_me_table (List(findMeFollowMeTable)): findMeFollowMeTable - *Table*
            array of findMeFollowMeTable named tuples
    """

    __slots__: List[str] = [
        "find_me_follow_me_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "find_me_follow_me_table",
                "findMeFollowMeTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupFlexibleSeatingAccessDeviceGetListResponse(OCIResponse):
    """
    Response to `GroupFlexibleSeatingAccessDeviceGetListRequest()`

    Attributes:
        available_access_device (List[OCI.availableAccessDevice]): availableAccessDevice
            *Optional*
    """

    __slots__: List[str] = [
        "available_access_device",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_access_device",
                "availableAccessDevice",
                [
                    E(
                        "access_device",
                        "accessDevice",
                        OCI.AccessDevice,
                        is_complex=True,
                        is_required=True,
                    ),
                    E(
                        "static_registration_capable",
                        "staticRegistrationCapable",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "use_domain",
                        "useDomain",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "static_line_ordering",
                        "staticLineOrdering",
                        bool,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_array=True,
                is_container=True,
            ),
        )


class GroupFlexibleSeatingHostGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupFlexibleSeatingHostGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.

    Attributes:
        flexible_seating_host_table (List(flexibleSeatingHostTable)):
            flexibleSeatingHostTable - *Table* array of flexibleSeatingHostTable named
            tuples
    """

    __slots__: List[str] = [
        "flexible_seating_host_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "flexible_seating_host_table",
                "flexibleSeatingHostTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupFlexibleSeatingHostGuestAssociationGetResponse(OCIResponse):
    """
    Response to `GroupFlexibleSeatingHostGuestAssociationGetRequest()`.


    Attributes:
        enforce_association_limit (bool): enforceAssociationLimit
        association_limit_hours (int): associationLimitHours
        access_level (str): accessLevel
        guest_last_name (str): guestLastName *Optional*
        guest_first_name (str): guestFirstName *Optional*
        guest_phone_number (str): guestPhoneNumber *Optional*
        guest_extension (str): guestExtension *Optional*
        guest_location_dialing_code (str): guestLocationDialingCode *Optional*
        guest_association_date_time (str): guestAssociationDateTime *Optional*
    """

    __slots__: List[str] = [
        "enforce_association_limit",
        "association_limit_hours",
        "access_level",
        "guest_last_name",
        "guest_first_name",
        "guest_phone_number",
        "guest_extension",
        "guest_location_dialing_code",
        "guest_association_date_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enforce_association_limit",
                "enforceAssociationLimit",
                bool,
                is_required=True,
            ),
            E(
                "association_limit_hours",
                "associationLimitHours",
                int,
                is_required=True,
            ),
            E(
                "access_level",
                "accessLevel",
                str,
                is_required=True,
            ),
            E(
                "guest_last_name",
                "guestLastName",
                str,
            ),
            E(
                "guest_first_name",
                "guestFirstName",
                str,
            ),
            E(
                "guest_phone_number",
                "guestPhoneNumber",
                str,
            ),
            E(
                "guest_extension",
                "guestExtension",
                str,
            ),
            E(
                "guest_location_dialing_code",
                "guestLocationDialingCode",
                str,
            ),
            E(
                "guest_association_date_time",
                "guestAssociationDateTime",
                str,
            ),
        )


class GroupFlexibleSeatingHostRoutingPoliciesGetResponse(OCIResponse):
    """
    Response to the `GroupFlexibleSeatingHostRoutingPoliciesGetRequest()`.


    Attributes:
        allow_emergency_calls (bool): allowEmergencyCalls
        allow_calls_to_voice_portal (bool): allowCallsToVoicePortal
    """

    __slots__: List[str] = [
        "allow_emergency_calls",
        "allow_calls_to_voice_portal",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "allow_emergency_calls",
                "allowEmergencyCalls",
                bool,
                is_required=True,
            ),
            E(
                "allow_calls_to_voice_portal",
                "allowCallsToVoicePortal",
                bool,
                is_required=True,
            ),
        )


class GroupGetDefaultResponse(OCIResponse):
    """
    Response to the `GroupGetDefaultRequest()`.

    All values are default values for a group's profile.

    Attributes:
        default_domain (str): defaultDomain
        user_limit (int): userLimit
        time_zone (str): timeZone
        time_zone_display_name (str): timeZoneDisplayName
    """

    __slots__: List[str] = [
        "default_domain",
        "user_limit",
        "time_zone",
        "time_zone_display_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "default_domain",
                "defaultDomain",
                str,
                is_required=True,
            ),
            E(
                "user_limit",
                "userLimit",
                int,
                is_required=True,
            ),
            E(
                "time_zone",
                "timeZone",
                str,
                is_required=True,
            ),
            E(
                "time_zone_display_name",
                "timeZoneDisplayName",
                str,
                is_required=True,
            ),
        )


class GroupGetListInServiceProviderPagedSortedListResponse(OCIResponse):
    """
    Response to `GroupGetListInServiceProviderPagedSortedListRequest()`.

    Contains a table with column headings: "Group Id", "Group Name", "User Limit" and
    "Group External Id" and a row for each group.  The following columns are only
    populated in AS data mode: "Group External Id".

    Attributes:
        group_table (List(groupTable)): groupTable - *Table* array of groupTable named
            tuples
    """

    __slots__: List[str] = [
        "group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_table",
                "groupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupGetListInServiceProviderResponse(OCIResponse):
    """
    Response to `GroupGetListInServiceProviderRequest()`.

    Contains a 3 column table with column headings: "Group Id", "Group Name", "User Limit"
    and a row for each group.

    Attributes:
        group_table (List(groupTable)): groupTable - *Table* array of groupTable named
            tuples
    """

    __slots__: List[str] = [
        "group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_table",
                "groupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupGetListInSystemResponse(OCIResponse):
    """
    Response to `GroupGetListInSystemRequest()`.

    Contains a table with column headings: "Group Id", "Group Name", "User Limit",
    "Organization Id", "Organization Type", "Reseller Id" and a row for each group.  The
    "Organization Id" column is populated with either a service provider Id or an
    enterprise Id.  The "Organization Type" column is populated with one of the enumerated
    strings defined in the OrganizationType OCI data type.  Please see
    OCISchemaDataTypes.xsd for details on OrganizationType.  The following columns are
    only returned in AS data mode: Reseller Id

    Attributes:
        group_table (List(groupTable)): groupTable - *Table* array of groupTable named
            tuples
    """

    __slots__: List[str] = [
        "group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "group_table",
                "groupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupGetUserServiceAssignedUserListResponse(OCIResponse):
    """
    Return a table containing the list of users assigned the user service or service pack.

    The table contains columns: "User Id", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Hiragana Last Name"; "Hiragana First Name", "Extension".
    This is a response to the `GroupGetUserServiceAssignedUserListRequest()`.

    Attributes:
        user_list_table (List(userListTable)): userListTable - *Table* array of
            userListTable named tuples
    """

    __slots__: List[str] = [
        "user_list_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_list_table",
                "userListTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupGroupPagingGetAvailableOriginatorListResponse(OCIResponse):
    """
    Response to the `GroupGroupPagingGetAvailableOriginatorListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name" and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupGroupPagingGetAvailableTargetListResponse(OCIResponse):
    """
    Response to the `GroupGroupPagingGetAvailableTargetListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name" and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupGroupPagingGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupGroupPagingGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.

    Attributes:
        paging_group_table (List(pagingGroupTable)): pagingGroupTable - *Table* array of
            pagingGroupTable named tuples
    """

    __slots__: List[str] = [
        "paging_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "paging_group_table",
                "pagingGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupGroupPagingGetOriginatorListResponse(OCIResponse):
    """
    Response to the `GroupGroupPagingGetOriginatorListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        originator_table (List(originatorTable)): originatorTable - *Table* array of
            originatorTable named tuples
    """

    __slots__: List[str] = [
        "originator_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "originator_table",
                "originatorTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupGroupPagingGetTargetListResponse(OCIResponse):
    """
    Response to the `GroupGroupPagingGetTargetListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        target_table (List(targetTable)): targetTable - *Table* array of targetTable named
            tuples
    """

    __slots__: List[str] = [
        "target_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "target_table",
                "targetTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupGroupPagingTargetsCapacityGetResponse(OCIResponse):
    """
    Response to `GroupGroupPagingTargetsCapacityGetRequest()`.

    Replaced by: `GroupGroupPagingTargetsCapacityGetResponse22()` in AS data mode.

    Attributes:
        maximum_target_users_from_service_provider (int):
            maximumTargetUsersFromServiceProvider
        maximum_target_users (int): maximumTargetUsers
    """

    __slots__: List[str] = [
        "maximum_target_users_from_service_provider",
        "maximum_target_users",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "maximum_target_users_from_service_provider",
                "maximumTargetUsersFromServiceProvider",
                int,
                is_required=True,
            ),
            E(
                "maximum_target_users",
                "maximumTargetUsers",
                int,
                is_required=True,
            ),
        )


class GroupGroupPagingTargetsCapacityGetResponse22(OCIResponse):
    """
    Response to `GroupGroupPagingTargetsCapacityGetRequest22()`.


    Attributes:
        maximum_target_users_from_service_provider (int):
            maximumTargetUsersFromServiceProvider
        maximum_target_users (int): maximumTargetUsers
    """

    __slots__: List[str] = [
        "maximum_target_users_from_service_provider",
        "maximum_target_users",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "maximum_target_users_from_service_provider",
                "maximumTargetUsersFromServiceProvider",
                int,
                is_required=True,
            ),
            E(
                "maximum_target_users",
                "maximumTargetUsers",
                int,
                is_required=True,
            ),
        )


class GroupHolidayScheduleGetListResponse(OCIResponse):
    """
    Response to the `GroupHolidayScheduleGetListRequest()`.

    The response contains all the group's holiday schedule name.

    Attributes:
        holiday_schedule_name (List[str]): holidayScheduleName *Optional*
    """

    __slots__: List[str] = [
        "holiday_schedule_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "holiday_schedule_name",
                "holidayScheduleName",
                str,
                is_array=True,
            ),
        )


class GroupHuntGroupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupHuntGroupGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupHuntGroupGetAvailableUserPagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupHuntGroupGetAvailableUserPagedSortedListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Is Phone Number Activated",
    "Country Code","National Prefix", "Extension", "Department", "Department Type",
    "Parent Department", "Parent Department Type", "Email Address", "IMP Id", "Mobile
    Number", "Group Id", "Group Name".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupHuntGroupGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupHuntGroupGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active", "Policy". The column values for "Is Active"
    can either be true, or false.  NOTE: prior to release 14, the policy column did not
    match the HuntPolicy enumerated type.

    Attributes:
        hunt_group_table (List(huntGroupTable)): huntGroupTable - *Table* array of
            huntGroupTable named tuples
    """

    __slots__: List[str] = [
        "hunt_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "hunt_group_table",
                "huntGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupHuntGroupGetInstancePagedSortedListResponse(OCIResponse):
    """
    Response to the `GroupHuntGroupGetInstancePagedSortedListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number", "Is
    Phone Number Activated", "Country Code","National Prefix", "Extension", "Department",
    "Department Type", "Parent Department", "Parent Department Type", "Is Active",
    "Policy". The column values for "Is Active" can either be true, or false.  NOTE: prior
    to release 14, the policy column did not match the HuntPolicy enumerated type.

    Attributes:
        hunt_group_table (List(huntGroupTable)): huntGroupTable - *Table* array of
            huntGroupTable named tuples
    """

    __slots__: List[str] = [
        "hunt_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "hunt_group_table",
                "huntGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupIMRNGetListResponse(OCIResponse):
    """
    Response to `GroupIMRNGetListRequest()`.


    Attributes:
        imrn (List[str]): imrn *Optional*
    """

    __slots__: List[str] = [
        "imrn",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "imrn",
                "imrn",
                str,
                is_array=True,
            ),
        )


class GroupInstantGroupCallGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupInstantGroupCallGetInstanceListRequest()`.

    Contains a 6 column table with column headings: "Service User Id", "Name", "Phone
    Number", "Extension", "Department", "Is Active". The column values for Is Active can
    either be true, or false.

    Attributes:
        instant_group_call_table (List(instantGroupCallTable)): instantGroupCallTable -
            *Table* array of instantGroupCallTable named tuples
    """

    __slots__: List[str] = [
        "instant_group_call_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "instant_group_call_table",
                "instantGroupCallTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupIntegratedIMPGetResponse(OCIResponse):
    """
    Response to the `GroupIntegratedIMPGetRequest()`.

    The response contains the group Integrated IMP service attributes.  Replaced by:
    `GroupIntegratedIMPGetResponse21sp1()` in AS data mode

    Attributes:
        use_service_provider_setting (bool): useServiceProviderSetting
        service_domain (str): serviceDomain *Optional*
    """

    __slots__: List[str] = [
        "use_service_provider_setting",
        "service_domain",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_service_provider_setting",
                "useServiceProviderSetting",
                bool,
                is_required=True,
            ),
            E(
                "service_domain",
                "serviceDomain",
                str,
            ),
        )


class GroupIntegratedIMPGetResponse21sp1(OCIResponse):
    """
    Response to the `GroupIntegratedIMPGetRequest21sp1()`.

    The response contains the group Integrated IMP service attributes.  Replaced by
    `GroupIntegratedIMPGetResponse22()`

    Attributes:
        use_service_provider_setting (bool): useServiceProviderSetting
        service_domain (str): serviceDomain *Optional*
        effective_service_domain (str): effectiveServiceDomain *Optional*
        add_service_provider_in_imp_user_id (bool): addServiceProviderInIMPUserId
        default_imp_id_type (str): defaultImpIdType
    """

    __slots__: List[str] = [
        "use_service_provider_setting",
        "service_domain",
        "effective_service_domain",
        "add_service_provider_in_imp_user_id",
        "default_imp_id_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_service_provider_setting",
                "useServiceProviderSetting",
                bool,
                is_required=True,
            ),
            E(
                "service_domain",
                "serviceDomain",
                str,
            ),
            E(
                "effective_service_domain",
                "effectiveServiceDomain",
                str,
            ),
            E(
                "add_service_provider_in_imp_user_id",
                "addServiceProviderInIMPUserId",
                bool,
                is_required=True,
            ),
            E(
                "default_imp_id_type",
                "defaultImpIdType",
                str,
                is_required=True,
            ),
        )


class GroupIntegratedIMPGetResponse22(OCIResponse):
    """
    Response to the `GroupIntegratedIMPGetRequest22()`.

    The response contains the group Integrated IMP service attributes.  The following
    elements are only returned to a reseller administrator or above:
    useServiceProviderMessagingServer provisioningUrl provisioningUserId Replaced by
    `GroupIntegratedIMPGetResponse23()`

    Attributes:
        use_service_provider_setting (bool): useServiceProviderSetting
        service_domain (str): serviceDomain *Optional*
        effective_service_domain (str): effectiveServiceDomain *Optional*
        add_service_provider_in_imp_user_id (bool): addServiceProviderInIMPUserId
        default_imp_id_type (str): defaultImpIdType
        use_service_provider_messaging_server (bool): useServiceProviderMessagingServer
            *Optional*
        provisioning_url (str): provisioningUrl *Optional*
        provisioning_user_id (str): provisioningUserId *Optional*
    """

    __slots__: List[str] = [
        "use_service_provider_setting",
        "service_domain",
        "effective_service_domain",
        "add_service_provider_in_imp_user_id",
        "default_imp_id_type",
        "use_service_provider_messaging_server",
        "provisioning_url",
        "provisioning_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_service_provider_setting",
                "useServiceProviderSetting",
                bool,
                is_required=True,
            ),
            E(
                "service_domain",
                "serviceDomain",
                str,
            ),
            E(
                "effective_service_domain",
                "effectiveServiceDomain",
                str,
            ),
            E(
                "add_service_provider_in_imp_user_id",
                "addServiceProviderInIMPUserId",
                bool,
                is_required=True,
            ),
            E(
                "default_imp_id_type",
                "defaultImpIdType",
                str,
                is_required=True,
            ),
            E(
                "use_service_provider_messaging_server",
                "useServiceProviderMessagingServer",
                bool,
            ),
            E(
                "provisioning_url",
                "provisioningUrl",
                str,
            ),
            E(
                "provisioning_user_id",
                "provisioningUserId",
                str,
            ),
        )


class GroupIntegratedIMPGetResponse23(OCIResponse):
    """
    Response to the `GroupIntegratedIMPGetRequest23()`.

    The response contains the group Integrated IMP service attributes.  The following
    elements are only returned to a reseller administrator or above:
    useServiceProviderMessagingServer provisioningUrl provisioningUserId

    Attributes:
        use_service_provider_setting (bool): useServiceProviderSetting
        service_domain (str): serviceDomain *Optional*
        effective_service_domain (str): effectiveServiceDomain *Optional*
        add_service_provider_in_imp_user_id (bool): addServiceProviderInIMPUserId
        default_imp_id_type (str): defaultImpIdType
        use_service_provider_messaging_server (bool): useServiceProviderMessagingServer
            *Optional*
        provisioning_url (str): provisioningUrl *Optional*
        provisioning_user_id (str): provisioningUserId *Optional*
    """

    __slots__: List[str] = [
        "use_service_provider_setting",
        "service_domain",
        "effective_service_domain",
        "add_service_provider_in_imp_user_id",
        "default_imp_id_type",
        "use_service_provider_messaging_server",
        "provisioning_url",
        "provisioning_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_service_provider_setting",
                "useServiceProviderSetting",
                bool,
                is_required=True,
            ),
            E(
                "service_domain",
                "serviceDomain",
                str,
            ),
            E(
                "effective_service_domain",
                "effectiveServiceDomain",
                str,
            ),
            E(
                "add_service_provider_in_imp_user_id",
                "addServiceProviderInIMPUserId",
                bool,
                is_required=True,
            ),
            E(
                "default_imp_id_type",
                "defaultImpIdType",
                str,
                is_required=True,
            ),
            E(
                "use_service_provider_messaging_server",
                "useServiceProviderMessagingServer",
                bool,
            ),
            E(
                "provisioning_url",
                "provisioningUrl",
                str,
            ),
            E(
                "provisioning_user_id",
                "provisioningUserId",
                str,
            ),
        )


class GroupInterceptGroupGetResponse(OCIResponse):
    """
    Response to the `GroupInterceptGroupGetRequest()`.

    Replaced By: `GroupInterceptGroupGetResponse16()`

    Attributes:
        is_active (bool): isActive
        announcement_selection (str): announcementSelection
        audio_file_description (str): audioFileDescription *Optional*
        video_file_description (str): videoFileDescription *Optional*
        play_new_phone_number (bool): playNewPhoneNumber
        new_phone_number (str): newPhoneNumber *Optional*
        transfer_on_zero_to_phone_number (bool): transferOnZeroToPhoneNumber
        transfer_phone_number (str): transferPhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "announcement_selection",
        "audio_file_description",
        "video_file_description",
        "play_new_phone_number",
        "new_phone_number",
        "transfer_on_zero_to_phone_number",
        "transfer_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "announcement_selection",
                "announcementSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "play_new_phone_number",
                "playNewPhoneNumber",
                bool,
                is_required=True,
            ),
            E(
                "new_phone_number",
                "newPhoneNumber",
                str,
            ),
            E(
                "transfer_on_zero_to_phone_number",
                "transferOnZeroToPhoneNumber",
                bool,
                is_required=True,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
        )


class GroupInterceptGroupGetResponse16(OCIResponse):
    """
    Response to the `GroupInterceptGroupGetRequest16()`.

    Replaced By: `GroupInterceptGroupGetResponse16sp1()`

    Attributes:
        is_active (bool): isActive
        announcement_selection (str): announcementSelection
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
        play_new_phone_number (bool): playNewPhoneNumber
        new_phone_number (str): newPhoneNumber *Optional*
        transfer_on_zero_to_phone_number (bool): transferOnZeroToPhoneNumber
        transfer_phone_number (str): transferPhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "announcement_selection",
        "audio_file_description",
        "audio_media_type",
        "video_file_description",
        "video_media_type",
        "play_new_phone_number",
        "new_phone_number",
        "transfer_on_zero_to_phone_number",
        "transfer_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "announcement_selection",
                "announcementSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
            E(
                "play_new_phone_number",
                "playNewPhoneNumber",
                bool,
                is_required=True,
            ),
            E(
                "new_phone_number",
                "newPhoneNumber",
                str,
            ),
            E(
                "transfer_on_zero_to_phone_number",
                "transferOnZeroToPhoneNumber",
                bool,
                is_required=True,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
        )


class GroupInterceptGroupGetResponse16sp1(OCIResponse):
    """
    Response to the `GroupInterceptGroupGetRequest16sp1()`.

    Replaced by: `GroupInterceptGroupGetResponse21sp1()` in AS data mode

    Attributes:
        is_active (bool): isActive
        announcement_selection (str): announcementSelection
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
        play_new_phone_number (bool): playNewPhoneNumber
        new_phone_number (str): newPhoneNumber *Optional*
        transfer_on_zero_to_phone_number (bool): transferOnZeroToPhoneNumber
        transfer_phone_number (str): transferPhoneNumber *Optional*
        reroute_outbound_calls (bool): rerouteOutboundCalls
        outbound_reroute_phone_number (str): outboundReroutePhoneNumber *Optional*
        allow_outbound_local_calls (bool): allowOutboundLocalCalls
        inbound_call_mode (str): inboundCallMode
        alternate_blocking_announcement (bool): alternateBlockingAnnouncement
        route_to_voice_mail (bool): routeToVoiceMail
    """

    __slots__: List[str] = [
        "is_active",
        "announcement_selection",
        "audio_file_description",
        "audio_media_type",
        "video_file_description",
        "video_media_type",
        "play_new_phone_number",
        "new_phone_number",
        "transfer_on_zero_to_phone_number",
        "transfer_phone_number",
        "reroute_outbound_calls",
        "outbound_reroute_phone_number",
        "allow_outbound_local_calls",
        "inbound_call_mode",
        "alternate_blocking_announcement",
        "route_to_voice_mail",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "announcement_selection",
                "announcementSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
            E(
                "play_new_phone_number",
                "playNewPhoneNumber",
                bool,
                is_required=True,
            ),
            E(
                "new_phone_number",
                "newPhoneNumber",
                str,
            ),
            E(
                "transfer_on_zero_to_phone_number",
                "transferOnZeroToPhoneNumber",
                bool,
                is_required=True,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "reroute_outbound_calls",
                "rerouteOutboundCalls",
                bool,
                is_required=True,
            ),
            E(
                "outbound_reroute_phone_number",
                "outboundReroutePhoneNumber",
                str,
            ),
            E(
                "allow_outbound_local_calls",
                "allowOutboundLocalCalls",
                bool,
                is_required=True,
            ),
            E(
                "inbound_call_mode",
                "inboundCallMode",
                str,
                is_required=True,
            ),
            E(
                "alternate_blocking_announcement",
                "alternateBlockingAnnouncement",
                bool,
                is_required=True,
            ),
            E(
                "route_to_voice_mail",
                "routeToVoiceMail",
                bool,
                is_required=True,
            ),
        )


class GroupInterceptGroupGetResponse21sp1(OCIResponse):
    """
    Response to the `GroupInterceptGroupGetRequest21sp1()`.

    The following elements are only used in AS data mode: exemptInboundMobilityCalls
    exemptOutboundMobilityCalls disableParallelRingingToNetworkLocations

    Attributes:
        is_active (bool): isActive
        announcement_selection (str): announcementSelection
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
        inbound_call_mode (str): inboundCallMode
        alternate_blocking_announcement (bool): alternateBlockingAnnouncement
        exempt_inbound_mobility_calls (bool): exemptInboundMobilityCalls
        disable_parallel_ringing_to_network_locations (bool):
            disableParallelRingingToNetworkLocations
        route_to_voice_mail (bool): routeToVoiceMail
        play_new_phone_number (bool): playNewPhoneNumber
        new_phone_number (str): newPhoneNumber *Optional*
        transfer_on_zero_to_phone_number (bool): transferOnZeroToPhoneNumber
        transfer_phone_number (str): transferPhoneNumber *Optional*
        outbound_call_mode (str): outboundCallMode
        exempt_outbound_mobility_calls (bool): exemptOutboundMobilityCalls
        reroute_outbound_calls (bool): rerouteOutboundCalls
        outbound_reroute_phone_number (str): outboundReroutePhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "announcement_selection",
        "audio_file_description",
        "audio_media_type",
        "video_file_description",
        "video_media_type",
        "inbound_call_mode",
        "alternate_blocking_announcement",
        "exempt_inbound_mobility_calls",
        "disable_parallel_ringing_to_network_locations",
        "route_to_voice_mail",
        "play_new_phone_number",
        "new_phone_number",
        "transfer_on_zero_to_phone_number",
        "transfer_phone_number",
        "outbound_call_mode",
        "exempt_outbound_mobility_calls",
        "reroute_outbound_calls",
        "outbound_reroute_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "announcement_selection",
                "announcementSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
            E(
                "inbound_call_mode",
                "inboundCallMode",
                str,
                is_required=True,
            ),
            E(
                "alternate_blocking_announcement",
                "alternateBlockingAnnouncement",
                bool,
                is_required=True,
            ),
            E(
                "exempt_inbound_mobility_calls",
                "exemptInboundMobilityCalls",
                bool,
                is_required=True,
            ),
            E(
                "disable_parallel_ringing_to_network_locations",
                "disableParallelRingingToNetworkLocations",
                bool,
                is_required=True,
            ),
            E(
                "route_to_voice_mail",
                "routeToVoiceMail",
                bool,
                is_required=True,
            ),
            E(
                "play_new_phone_number",
                "playNewPhoneNumber",
                bool,
                is_required=True,
            ),
            E(
                "new_phone_number",
                "newPhoneNumber",
                str,
            ),
            E(
                "transfer_on_zero_to_phone_number",
                "transferOnZeroToPhoneNumber",
                bool,
                is_required=True,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "outbound_call_mode",
                "outboundCallMode",
                str,
                is_required=True,
            ),
            E(
                "exempt_outbound_mobility_calls",
                "exemptOutboundMobilityCalls",
                bool,
                is_required=True,
            ),
            E(
                "reroute_outbound_calls",
                "rerouteOutboundCalls",
                bool,
                is_required=True,
            ),
            E(
                "outbound_reroute_phone_number",
                "outboundReroutePhoneNumber",
                str,
            ),
        )


class GroupInventoryReportGetResponse(OCIResponse):
    """
    Response to `GroupInventoryReportGetRequest()`.


    Attributes:
        inventory_report_table (List(inventoryReportTable)): inventoryReportTable -
            *Table* array of inventoryReportTable named tuples
    """

    __slots__: List[str] = [
        "inventory_report_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "inventory_report_table",
                "inventoryReportTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupMWIDeliveryToMobileEndpointGetResponse(OCIResponse):
    """
    Response to `GroupMWIDeliveryToMobileEndpointGetRequest()`.

    The templateActivationTable contains the list of templates defined for the group.  The
    column headings are "Enable", "Language", "Type".

    Attributes:
        use_setting_level (str): useSettingLevel
        template_activation_table (List(templateActivationTable)): templateActivationTable
            - *Table* array of templateActivationTable named tuples
    """

    __slots__: List[str] = [
        "use_setting_level",
        "template_activation_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_setting_level",
                "useSettingLevel",
                str,
                is_required=True,
            ),
            E(
                "template_activation_table",
                "templateActivationTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupMeetMeConferencingGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupMeetMeConferencingGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupMeetMeConferencingGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupMeetMeConferencingGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Ports", and "Is Active". The column values for "Is Active"
    can either be true, or false.

    Attributes:
        conference_bridge_table (List(conferenceBridgeTable)): conferenceBridgeTable -
            *Table* array of conferenceBridgeTable named tuples
    """

    __slots__: List[str] = [
        "conference_bridge_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "conference_bridge_table",
                "conferenceBridgeTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupNetworkClassOfServiceGetAssignedListResponse(OCIResponse):
    """
    Response to `GroupNetworkClassOfServiceGetAssignedListRequest()`.

    Contains a table of all Network Classes of Service assigned to the group.  The column
    headings are: "Name", "Description" and "Default".

    Attributes:
        network_class_of_service_table (List(networkClassOfServiceTable)):
            networkClassOfServiceTable - *Table* array of networkClassOfServiceTable named
            tuples
    """

    __slots__: List[str] = [
        "network_class_of_service_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "network_class_of_service_table",
                "networkClassOfServiceTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupNetworkClassOfServiceGetAssignedUserListResponse(OCIResponse):
    """
    Response to `GroupNetworkClassOfServiceGetAssignedUserListRequest()`.

    Contains a table of users that have the Network Class of Service assigned.  The column
    headings are: "User Id", "User Type", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Service Provider Id", "Group Id", "Hiragana Last Name" and
    "Hiragana First Name" , "Extension".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupNetworkClassOfServiceGetAssignedUserListResponse21(OCIResponse):
    """
    Response to `GroupNetworkClassOfServiceGetAssignedUserListRequest21()`.

    Contains a table of users that have the Network Class of Service assigned.  The column
    headings are: "User Id", "User Type", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Service Provider Id", "Group Id", "Hiragana Last Name" and
    "Hiragana First Name" , "Extension". The User type column will display Auto Attendant
    and the Call Center subtype.  Call Center - Basic, Call Center - Standard and Call
    Center - Premium will be displayed instead of Call Center and Auto Attendant (for the
    Basic Auto Attendant) and Auto Attendant - Standard instead of Auto Attendant.

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupOfficeZoneGetAssignedListResponse(OCIResponse):
    """
    Response to `GroupOfficeZoneGetAssignedListRequest()`.

    Contains a table of all Office Zones assigned to the group.  The column headings are:
    "Name", "Description" and "Default".

    Attributes:
        office_zone_table (List(officeZoneTable)): officeZoneTable - *Table* array of
            officeZoneTable named tuples
    """

    __slots__: List[str] = [
        "office_zone_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "office_zone_table",
                "officeZoneTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupOfficeZoneGetAssignedUserListResponse(OCIResponse):
    """
    Response to `GroupOfiiceZoneGetAssignedUserListRequest()`.

    Contains a table of users that have the Office Zone assigned.  The column headings
    are: "User Id", "User Type", "Last Name", "First Name", "Department", "Phone Number",
    "Email Address", "Hiragana Last Name" and "Hiragana First Name", "Extension". Office
    Zones can only be unassigned if the Location-Based Calling Restrictions has been
    authorized to the group otherwise the request will fail.

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupOutgoingCallingPlanPinholeDigitPatternGetListResponse(OCIResponse):
    """
    Response to `GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest()`.

    Contains a table with column headings: "Name", "Digit Pattern".

    Attributes:
        digit_pattern_table (List(digitPatternTable)): digitPatternTable - *Table* array
            of digitPatternTable named tuples
    """

    __slots__: List[str] = [
        "digit_pattern_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "digit_pattern_table",
                "digitPatternTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupPasswordRulesGetResponse(OCIResponse):
    """
    Response to `GroupPasswordRulesGetRequest()`.

    Contains the password rules applicable to users within the group.  Repleced by:
    `GroupPasswordRulesGetResponse16()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        disallow_user_id (bool): disallowUserId
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        max_failed_login_attempts (int): maxFailedLoginAttempts
        password_expires_days (int): passwordExpiresDays
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_rules_modification (bool): disallowRulesModification
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_rules_modification",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
                is_required=True,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_rules_modification",
                "disallowRulesModification",
                bool,
                is_required=True,
            ),
        )


class GroupPasswordRulesGetResponse16(OCIResponse):
    """
    Response to `GroupPasswordRulesGetRequest16()`.

    Contains the password rules applicable to users within the group.  Replaced by:
    `GroupPasswordRulesGetResponse22()` in AS data mode.

    Attributes:
        disallow_user_id (bool): disallowUserId
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        max_failed_login_attempts (int): maxFailedLoginAttempts
        password_expires_days (int): passwordExpiresDays
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_rules_modification (bool): disallowRulesModification
        disallow_previous_passwords (bool): disallowPreviousPasswords
        number_of_previous_passwords (int): numberOfPreviousPasswords
    """

    __slots__: List[str] = [
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_rules_modification",
        "disallow_previous_passwords",
        "number_of_previous_passwords",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
                is_required=True,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_rules_modification",
                "disallowRulesModification",
                bool,
                is_required=True,
            ),
            E(
                "disallow_previous_passwords",
                "disallowPreviousPasswords",
                bool,
                is_required=True,
            ),
            E(
                "number_of_previous_passwords",
                "numberOfPreviousPasswords",
                int,
                is_required=True,
            ),
        )


class GroupPasswordRulesGetResponse22(OCIResponse):
    """
    Response to `GroupPasswordRulesGetRequest22()`.

    Contains the password rules applicable to users within the group.

    Attributes:
        disallow_user_id (bool): disallowUserId
        disallow_old_password (bool): disallowOldPassword
        disallow_reversed_old_password (bool): disallowReversedOldPassword
        restrict_min_digits (bool): restrictMinDigits
        min_digits (int): minDigits
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters
        min_upper_case_letters (int): minUpperCaseLetters
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters
        min_lower_case_letters (int): minLowerCaseLetters
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters
        min_length (int): minLength
        max_failed_login_attempts (int): maxFailedLoginAttempts
        password_expires_days (int): passwordExpiresDays
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_rules_modification (bool): disallowRulesModification
        disallow_previous_passwords (bool): disallowPreviousPasswords
        number_of_previous_passwords (int): numberOfPreviousPasswords
        force_password_change_after_reset (bool): forcePasswordChangeAfterReset
    """

    __slots__: List[str] = [
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_rules_modification",
        "disallow_previous_passwords",
        "number_of_previous_passwords",
        "force_password_change_after_reset",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
                is_required=True,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
                is_required=True,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
                is_required=True,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
                is_required=True,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
                is_required=True,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
                is_required=True,
            ),
            E(
                "min_length",
                "minLength",
                int,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
                is_required=True,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_rules_modification",
                "disallowRulesModification",
                bool,
                is_required=True,
            ),
            E(
                "disallow_previous_passwords",
                "disallowPreviousPasswords",
                bool,
                is_required=True,
            ),
            E(
                "number_of_previous_passwords",
                "numberOfPreviousPasswords",
                int,
                is_required=True,
            ),
            E(
                "force_password_change_after_reset",
                "forcePasswordChangeAfterReset",
                bool,
                is_required=True,
            ),
        )


class GroupPhoneDirectoryGetListResponse(OCIResponse):
    """
    Response to `GroupPhoneDirectoryGetListRequest()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id". If extended directory information is requested, the following
    columns are also included: "First Name", "Last Name", "User Id", "Pager", "Title",
    "Time Zone", "Location", "Address Line 1", "Address Line 2", "City", "State", "Zip",
    "Country". Replace by: `GroupPhoneDirectoryGetListResponse17()`

    Attributes:
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupPhoneDirectoryGetListResponse17(OCIResponse):
    """
    Response to `GroupPhoneDirectoryGetListRequest17()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "Is Virtual On-Net User" If extended directory information is
    requested, the following columns are also included: "First Name", "Last Name", "User
    Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country". Replaced by:
    `GroupPhoneDirectoryGetListResponse18()`

    Attributes:
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupPhoneDirectoryGetListResponse17sp3(OCIResponse):
    """
    Response to `GroupPhoneDirectoryGetListRequest17sp3()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "IMP Id" and "Is Virtual On-Net User" If extended directory
    information is requested, the following columns are also included: "First Name", "Last
    Name", "User Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country". Replaced by:
    `GroupPhoneDirectoryGetListResponse18()`

    Attributes:
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupPhoneDirectoryGetListResponse18(OCIResponse):
    """
    Response to `GroupPhoneDirectoryGetListRequest18()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id" and "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country". Finally "Service Name". The
    Service Name represents the localized service name for service instances.  The
    localized values are taken from the BroadworksLabel.properties file.  Service Name is
    currently supporting: AutoAttendant, AutoAttendantStandard, AutoAttendantVideo,
    CallCenter, CallCenterStandard, CallCenterPremium HuntGroup, InstantGroupCall,
    VoiceMessagingGroup, RoutePoint, BroadWorksAnywhere, GroupPaging, FindmeFollowme,
    VoiceXML, FlexibleSeatingGuest, CollaborateAudio, MeetMeConferencing.  For a Regular
    User or a Virtual On Network Enterprise Extensions, the Service Name is empty.  The
    following columns are returned in AS data mode only: "Service Name"

    Replaced By: `GroupPhoneDirectoryGetPagedSortedListResponse()`

    Attributes:
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupPhoneDirectoryGetPagedListResponse(OCIResponse):
    """
    Response to `GroupPhoneDirectoryGetPagedListRequest()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id" and "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country". Finally "Service Name". The
    Service Name represents the localized service name for service instances.  The
    localized values are taken from the BroadworksLabel.properties file.  Service Name is
    currently supporting: AutoAttendant, AutoAttendantStandard, AutoAttendantVideo,
    CallCenter, CallCenterStandard, CallCenterPremium HuntGroup, InstantGroupCall,
    VoiceMessagingGroup, MusicOnHold, MusicOnHoldVideo, RoutePoint, BroadWorksAnywhere
    GroupPaging, FindmeFollowme, VoiceXML, FlexibleSeatingGuest, CollaborateSharing,
    MeetMeConferencing.  For a Regular User or a Virtual On Network Enterprise Extensions,
    the Service Name is empty.

    Replaced By: `GroupPhoneDirectoryGetPagedSortedListResponse()`

    Attributes:
        total_number_of_rows (int): totalNumberOfRows
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "total_number_of_rows",
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_number_of_rows",
                "totalNumberOfRows",
                int,
                is_required=True,
            ),
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupPhoneDirectoryGetPagedSortedListResponse(OCIResponse):
    """
    Response to `GroupPhoneDirectoryGetPagedSortedListRequest()`.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id" and "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country". Finally "Service Name". The
    Service Name represents the localized service name for service instances.  The
    localized values are taken from the BroadworksLabel.properties file.  Service Name is
    currently supporting: AutoAttendant, AutoAttendantStandard, AutoAttendantVideo,
    CallCenter, CallCenterStandard, CallCenterPremium HuntGroup, InstantGroupCall,
    VoiceMessagingGroup, MusicOnHold, MusicOnHoldVideo, RoutePoint, BroadWorksAnywhere
    GroupPaging, FindmeFollowme, VoiceXML, FlexibleSeatingGuest, CollaborateSharing,
    MeetMeConferencing.  For a Regular User or a Virtual On Network Enterprise Extensions,
    the Service Name is empty.  The following columns are populated in AS data mode only:
    "IMP Id"

    Attributes:
        total_number_of_rows (int): totalNumberOfRows
        directory_table (List(directoryTable)): directoryTable - *Table* array of
            directoryTable named tuples
    """

    __slots__: List[str] = [
        "total_number_of_rows",
        "directory_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "total_number_of_rows",
                "totalNumberOfRows",
                int,
                is_required=True,
            ),
            E(
                "directory_table",
                "directoryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupPolicyGetResponse(OCIResponse):
    """
    Response to `GroupPolicyGetRequest()`.

    Contains the policy settings for the group.

    Attributes:
        calling_plan_access (str): callingPlanAccess
        extension_access (str): extensionAccess
        ldap_integration_access (str): ldapIntegrationAccess
        voice_messaging_access (str): voiceMessagingAccess
        department_admin_user_access (str): departmentAdminUserAccess
        user_authentication_access (str): userAuthenticationAccess
        user_group_directory_access (str): userGroupDirectoryAccess
        user_profile_access (str): userProfileAccess
    """

    __slots__: List[str] = [
        "calling_plan_access",
        "extension_access",
        "ldap_integration_access",
        "voice_messaging_access",
        "department_admin_user_access",
        "user_authentication_access",
        "user_group_directory_access",
        "user_profile_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "calling_plan_access",
                "callingPlanAccess",
                str,
                is_required=True,
            ),
            E(
                "extension_access",
                "extensionAccess",
                str,
                is_required=True,
            ),
            E(
                "ldap_integration_access",
                "ldapIntegrationAccess",
                str,
                is_required=True,
            ),
            E(
                "voice_messaging_access",
                "voiceMessagingAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_user_access",
                "departmentAdminUserAccess",
                str,
                is_required=True,
            ),
            E(
                "user_authentication_access",
                "userAuthenticationAccess",
                str,
                is_required=True,
            ),
            E(
                "user_group_directory_access",
                "userGroupDirectoryAccess",
                str,
                is_required=True,
            ),
            E(
                "user_profile_access",
                "userProfileAccess",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetResponse14sp1(OCIResponse):
    """
    Response to `GroupPolicyGetRequest14sp1()`.

    Contains the policy settings for the group.

    Attributes:
        calling_plan_access (str): callingPlanAccess
        extension_access (str): extensionAccess
        ldap_integration_access (str): ldapIntegrationAccess
        voice_messaging_access (str): voiceMessagingAccess
        department_admin_user_access (str): departmentAdminUserAccess
        department_admin_trunk_group_access (str): departmentAdminTrunkGroupAccess
        user_authentication_access (str): userAuthenticationAccess
        user_group_directory_access (str): userGroupDirectoryAccess
        user_profile_access (str): userProfileAccess
    """

    __slots__: List[str] = [
        "calling_plan_access",
        "extension_access",
        "ldap_integration_access",
        "voice_messaging_access",
        "department_admin_user_access",
        "department_admin_trunk_group_access",
        "user_authentication_access",
        "user_group_directory_access",
        "user_profile_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "calling_plan_access",
                "callingPlanAccess",
                str,
                is_required=True,
            ),
            E(
                "extension_access",
                "extensionAccess",
                str,
                is_required=True,
            ),
            E(
                "ldap_integration_access",
                "ldapIntegrationAccess",
                str,
                is_required=True,
            ),
            E(
                "voice_messaging_access",
                "voiceMessagingAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_user_access",
                "departmentAdminUserAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_trunk_group_access",
                "departmentAdminTrunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "user_authentication_access",
                "userAuthenticationAccess",
                str,
                is_required=True,
            ),
            E(
                "user_group_directory_access",
                "userGroupDirectoryAccess",
                str,
                is_required=True,
            ),
            E(
                "user_profile_access",
                "userProfileAccess",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetResponse14sp4(OCIResponse):
    """
    Response to `GroupPolicyGetRequest14sp4()`.

    Contains the policy settings for the group.

    Attributes:
        calling_plan_access (str): callingPlanAccess
        extension_access (str): extensionAccess
        ldap_integration_access (str): ldapIntegrationAccess
        voice_messaging_access (str): voiceMessagingAccess
        department_admin_user_access (str): departmentAdminUserAccess
        department_admin_trunk_group_access (str): departmentAdminTrunkGroupAccess
        user_authentication_access (str): userAuthenticationAccess
        user_group_directory_access (str): userGroupDirectoryAccess
        user_profile_access (str): userProfileAccess
        user_enhanced_call_log_access (str): userEnhancedCallLogAccess
    """

    __slots__: List[str] = [
        "calling_plan_access",
        "extension_access",
        "ldap_integration_access",
        "voice_messaging_access",
        "department_admin_user_access",
        "department_admin_trunk_group_access",
        "user_authentication_access",
        "user_group_directory_access",
        "user_profile_access",
        "user_enhanced_call_log_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "calling_plan_access",
                "callingPlanAccess",
                str,
                is_required=True,
            ),
            E(
                "extension_access",
                "extensionAccess",
                str,
                is_required=True,
            ),
            E(
                "ldap_integration_access",
                "ldapIntegrationAccess",
                str,
                is_required=True,
            ),
            E(
                "voice_messaging_access",
                "voiceMessagingAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_user_access",
                "departmentAdminUserAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_trunk_group_access",
                "departmentAdminTrunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "user_authentication_access",
                "userAuthenticationAccess",
                str,
                is_required=True,
            ),
            E(
                "user_group_directory_access",
                "userGroupDirectoryAccess",
                str,
                is_required=True,
            ),
            E(
                "user_profile_access",
                "userProfileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_enhanced_call_log_access",
                "userEnhancedCallLogAccess",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetResponse17(OCIResponse):
    """
    Response to `GroupPolicyGetRequest17()`.

    Contains the policy settings for the group.  Replaced by: `GroupPolicyGetResponse20()`
    in AS data mode Replaced by: `GroupPolicyGetResponse22()` in XS data mode

    Attributes:
        calling_plan_access (str): callingPlanAccess
        extension_access (str): extensionAccess
        ldap_integration_access (str): ldapIntegrationAccess
        voice_messaging_access (str): voiceMessagingAccess
        department_admin_user_access (str): departmentAdminUserAccess
        department_admin_trunk_group_access (str): departmentAdminTrunkGroupAccess
        department_admin_phone_number_extension_access (str):
            departmentAdminPhoneNumberExtensionAccess
        department_admin_calling_line_id_number_access (str):
            departmentAdminCallingLineIdNumberAccess
        user_authentication_access (str): userAuthenticationAccess
        user_group_directory_access (str): userGroupDirectoryAccess
        user_profile_access (str): userProfileAccess
        user_enhanced_call_log_access (str): userEnhancedCallLogAccess
    """

    __slots__: List[str] = [
        "calling_plan_access",
        "extension_access",
        "ldap_integration_access",
        "voice_messaging_access",
        "department_admin_user_access",
        "department_admin_trunk_group_access",
        "department_admin_phone_number_extension_access",
        "department_admin_calling_line_id_number_access",
        "user_authentication_access",
        "user_group_directory_access",
        "user_profile_access",
        "user_enhanced_call_log_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "calling_plan_access",
                "callingPlanAccess",
                str,
                is_required=True,
            ),
            E(
                "extension_access",
                "extensionAccess",
                str,
                is_required=True,
            ),
            E(
                "ldap_integration_access",
                "ldapIntegrationAccess",
                str,
                is_required=True,
            ),
            E(
                "voice_messaging_access",
                "voiceMessagingAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_user_access",
                "departmentAdminUserAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_trunk_group_access",
                "departmentAdminTrunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_phone_number_extension_access",
                "departmentAdminPhoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_calling_line_id_number_access",
                "departmentAdminCallingLineIdNumberAccess",
                str,
                is_required=True,
            ),
            E(
                "user_authentication_access",
                "userAuthenticationAccess",
                str,
                is_required=True,
            ),
            E(
                "user_group_directory_access",
                "userGroupDirectoryAccess",
                str,
                is_required=True,
            ),
            E(
                "user_profile_access",
                "userProfileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_enhanced_call_log_access",
                "userEnhancedCallLogAccess",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetResponse20(OCIResponse):
    """
    Response to `GroupPolicyGetRequest20()`.

    Contains the policy settings for the group.  Replaced by: `GroupPolicyGetResponse22()`
    in AS data mode

    Attributes:
        calling_plan_access (str): callingPlanAccess
        extension_access (str): extensionAccess
        ldap_integration_access (str): ldapIntegrationAccess
        voice_messaging_access (str): voiceMessagingAccess
        department_admin_user_access (str): departmentAdminUserAccess
        department_admin_trunk_group_access (str): departmentAdminTrunkGroupAccess
        department_admin_phone_number_extension_access (str):
            departmentAdminPhoneNumberExtensionAccess
        department_admin_calling_line_id_number_access (str):
            departmentAdminCallingLineIdNumberAccess
        user_authentication_access (str): userAuthenticationAccess
        user_group_directory_access (str): userGroupDirectoryAccess
        user_profile_access (str): userProfileAccess
        user_enhanced_call_log_access (str): userEnhancedCallLogAccess
        user_auto_attendant_name_dialing_access (str): userAutoAttendantNameDialingAccess
    """

    __slots__: List[str] = [
        "calling_plan_access",
        "extension_access",
        "ldap_integration_access",
        "voice_messaging_access",
        "department_admin_user_access",
        "department_admin_trunk_group_access",
        "department_admin_phone_number_extension_access",
        "department_admin_calling_line_id_number_access",
        "user_authentication_access",
        "user_group_directory_access",
        "user_profile_access",
        "user_enhanced_call_log_access",
        "user_auto_attendant_name_dialing_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "calling_plan_access",
                "callingPlanAccess",
                str,
                is_required=True,
            ),
            E(
                "extension_access",
                "extensionAccess",
                str,
                is_required=True,
            ),
            E(
                "ldap_integration_access",
                "ldapIntegrationAccess",
                str,
                is_required=True,
            ),
            E(
                "voice_messaging_access",
                "voiceMessagingAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_user_access",
                "departmentAdminUserAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_trunk_group_access",
                "departmentAdminTrunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_phone_number_extension_access",
                "departmentAdminPhoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_calling_line_id_number_access",
                "departmentAdminCallingLineIdNumberAccess",
                str,
                is_required=True,
            ),
            E(
                "user_authentication_access",
                "userAuthenticationAccess",
                str,
                is_required=True,
            ),
            E(
                "user_group_directory_access",
                "userGroupDirectoryAccess",
                str,
                is_required=True,
            ),
            E(
                "user_profile_access",
                "userProfileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_enhanced_call_log_access",
                "userEnhancedCallLogAccess",
                str,
                is_required=True,
            ),
            E(
                "user_auto_attendant_name_dialing_access",
                "userAutoAttendantNameDialingAccess",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetResponse22(OCIResponse):
    """
    Response to `GroupPolicyGetRequest22()`.

    Contains the policy settings for the group.  The following elements are only used in
    AS data mode: userAutoAttendantNameDialingAccess, value None is returned in XS data
    mode

    Attributes:
        calling_plan_access (str): callingPlanAccess
        extension_access (str): extensionAccess
        voice_messaging_access (str): voiceMessagingAccess
        department_admin_user_access (str): departmentAdminUserAccess
        department_admin_trunk_group_access (str): departmentAdminTrunkGroupAccess
        department_admin_phone_number_extension_access (str):
            departmentAdminPhoneNumberExtensionAccess
        department_admin_calling_line_id_number_access (str):
            departmentAdminCallingLineIdNumberAccess
        user_authentication_access (str): userAuthenticationAccess
        user_group_directory_access (str): userGroupDirectoryAccess
        user_profile_access (str): userProfileAccess
        user_enhanced_call_log_access (str): userEnhancedCallLogAccess
        user_auto_attendant_name_dialing_access (str): userAutoAttendantNameDialingAccess
    """

    __slots__: List[str] = [
        "calling_plan_access",
        "extension_access",
        "voice_messaging_access",
        "department_admin_user_access",
        "department_admin_trunk_group_access",
        "department_admin_phone_number_extension_access",
        "department_admin_calling_line_id_number_access",
        "user_authentication_access",
        "user_group_directory_access",
        "user_profile_access",
        "user_enhanced_call_log_access",
        "user_auto_attendant_name_dialing_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "calling_plan_access",
                "callingPlanAccess",
                str,
                is_required=True,
            ),
            E(
                "extension_access",
                "extensionAccess",
                str,
                is_required=True,
            ),
            E(
                "voice_messaging_access",
                "voiceMessagingAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_user_access",
                "departmentAdminUserAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_trunk_group_access",
                "departmentAdminTrunkGroupAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_phone_number_extension_access",
                "departmentAdminPhoneNumberExtensionAccess",
                str,
                is_required=True,
            ),
            E(
                "department_admin_calling_line_id_number_access",
                "departmentAdminCallingLineIdNumberAccess",
                str,
                is_required=True,
            ),
            E(
                "user_authentication_access",
                "userAuthenticationAccess",
                str,
                is_required=True,
            ),
            E(
                "user_group_directory_access",
                "userGroupDirectoryAccess",
                str,
                is_required=True,
            ),
            E(
                "user_profile_access",
                "userProfileAccess",
                str,
                is_required=True,
            ),
            E(
                "user_enhanced_call_log_access",
                "userEnhancedCallLogAccess",
                str,
                is_required=True,
            ),
            E(
                "user_auto_attendant_name_dialing_access",
                "userAutoAttendantNameDialingAccess",
                str,
                is_required=True,
            ),
        )


class GroupPolycomPhoneServicesGetResponse(OCIResponse):
    """
    Response to `GroupPolycomPhoneServicesGetRequest()`.


    Attributes:
        include_group_common_phone_list_in_directory (bool):
            includeGroupCommonPhoneListInDirectory
        include_group_custom_contact_directory_in_directory (bool):
            includeGroupCustomContactDirectoryInDirectory
        group_custom_contact_directory (str): groupCustomContactDirectory *Optional*
    """

    __slots__: List[str] = [
        "include_group_common_phone_list_in_directory",
        "include_group_custom_contact_directory_in_directory",
        "group_custom_contact_directory",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "include_group_common_phone_list_in_directory",
                "includeGroupCommonPhoneListInDirectory",
                bool,
                is_required=True,
            ),
            E(
                "include_group_custom_contact_directory_in_directory",
                "includeGroupCustomContactDirectoryInDirectory",
                bool,
                is_required=True,
            ),
            E(
                "group_custom_contact_directory",
                "groupCustomContactDirectory",
                str,
            ),
        )


class GroupPortalPasscodeRulesGetResponse(OCIResponse):
    """
    Response to `GroupPortalPasscodeRulesGetRequest()`.

    Contains the group's passcode rules setting.

    Attributes:
        use_rule_level (str): useRuleLevel
        disallow_repeated_digits (bool): disallowRepeatedDigits
        disallow_user_number (bool): disallowUserNumber
        disallow_reversed_user_number (bool): disallowReversedUserNumber
        disallow_old_passcode (bool): disallowOldPasscode
        disallow_reversed_old_passcode (bool): disallowReversedOldPasscode
        min_code_length (int): minCodeLength
        max_code_length (int): maxCodeLength
        disable_login_after_max_failed_login_attempts (bool):
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        expire_password (bool): expirePassword
        passcode_expires_days (int): passcodeExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
    """

    __slots__: List[str] = [
        "use_rule_level",
        "disallow_repeated_digits",
        "disallow_user_number",
        "disallow_reversed_user_number",
        "disallow_old_passcode",
        "disallow_reversed_old_passcode",
        "min_code_length",
        "max_code_length",
        "disable_login_after_max_failed_login_attempts",
        "max_failed_login_attempts",
        "expire_password",
        "passcode_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_rule_level",
                "useRuleLevel",
                str,
                is_required=True,
            ),
            E(
                "disallow_repeated_digits",
                "disallowRepeatedDigits",
                bool,
                is_required=True,
            ),
            E(
                "disallow_user_number",
                "disallowUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_user_number",
                "disallowReversedUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_passcode",
                "disallowOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_passcode",
                "disallowReversedOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "min_code_length",
                "minCodeLength",
                int,
                is_required=True,
            ),
            E(
                "max_code_length",
                "maxCodeLength",
                int,
                is_required=True,
            ),
            E(
                "disable_login_after_max_failed_login_attempts",
                "disableLoginAfterMaxFailedLoginAttempts",
                bool,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "expire_password",
                "expirePassword",
                bool,
                is_required=True,
            ),
            E(
                "passcode_expires_days",
                "passcodeExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
        )


class GroupPortalPasscodeRulesGetResponse19(OCIResponse):
    """
    Response to `GroupPortalPasscodeRulesGetRequest19()`.

    Contains the group's passcode rules setting.  The following elements are only used in
    AS data mode: numberOfRepeatedDigits disallowRepeatedPatterns
    disallowContiguousSequences numberOfAscendingDigits numberOfDescendingDigits
    numberOfPreviousPasscodes

    Attributes:
        use_rule_level (str): useRuleLevel
        disallow_repeated_digits (bool): disallowRepeatedDigits
        number_of_repeated_digits (int): numberOfRepeatedDigits
        disallow_repeated_patterns (bool): disallowRepeatedPatterns
        disallow_contiguous_sequences (bool): disallowContiguousSequences
        number_of_ascending_digits (int): numberOfAscendingDigits
        number_of_descending_digits (int): numberOfDescendingDigits
        disallow_user_number (bool): disallowUserNumber
        disallow_reversed_user_number (bool): disallowReversedUserNumber
        disallow_old_passcode (bool): disallowOldPasscode
        number_of_previous_passcodes (int): numberOfPreviousPasscodes
        disallow_reversed_old_passcode (bool): disallowReversedOldPasscode
        min_code_length (int): minCodeLength
        max_code_length (int): maxCodeLength
        disable_login_after_max_failed_login_attempts (bool):
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        expire_password (bool): expirePassword
        passcode_expires_days (int): passcodeExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
    """

    __slots__: List[str] = [
        "use_rule_level",
        "disallow_repeated_digits",
        "number_of_repeated_digits",
        "disallow_repeated_patterns",
        "disallow_contiguous_sequences",
        "number_of_ascending_digits",
        "number_of_descending_digits",
        "disallow_user_number",
        "disallow_reversed_user_number",
        "disallow_old_passcode",
        "number_of_previous_passcodes",
        "disallow_reversed_old_passcode",
        "min_code_length",
        "max_code_length",
        "disable_login_after_max_failed_login_attempts",
        "max_failed_login_attempts",
        "expire_password",
        "passcode_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_rule_level",
                "useRuleLevel",
                str,
                is_required=True,
            ),
            E(
                "disallow_repeated_digits",
                "disallowRepeatedDigits",
                bool,
                is_required=True,
            ),
            E(
                "number_of_repeated_digits",
                "numberOfRepeatedDigits",
                int,
                is_required=True,
            ),
            E(
                "disallow_repeated_patterns",
                "disallowRepeatedPatterns",
                bool,
                is_required=True,
            ),
            E(
                "disallow_contiguous_sequences",
                "disallowContiguousSequences",
                bool,
                is_required=True,
            ),
            E(
                "number_of_ascending_digits",
                "numberOfAscendingDigits",
                int,
                is_required=True,
            ),
            E(
                "number_of_descending_digits",
                "numberOfDescendingDigits",
                int,
                is_required=True,
            ),
            E(
                "disallow_user_number",
                "disallowUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_user_number",
                "disallowReversedUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_passcode",
                "disallowOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "number_of_previous_passcodes",
                "numberOfPreviousPasscodes",
                int,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_passcode",
                "disallowReversedOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "min_code_length",
                "minCodeLength",
                int,
                is_required=True,
            ),
            E(
                "max_code_length",
                "maxCodeLength",
                int,
                is_required=True,
            ),
            E(
                "disable_login_after_max_failed_login_attempts",
                "disableLoginAfterMaxFailedLoginAttempts",
                bool,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "expire_password",
                "expirePassword",
                bool,
                is_required=True,
            ),
            E(
                "passcode_expires_days",
                "passcodeExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
        )


class GroupPreAlertingAnnouncementGetResponse(OCIResponse):
    """
    Get the group level pre-alerting service settings.

    The response is either a `GroupPreAlertingAnnouncementGetResponse()` or an
    `ErrorResponse()`. Replaced by: `GroupPreAlertingAnnouncementGetResponse20()` in AS
    data mode

    Attributes:
        announcement_interruption (str): announcementInterruption
        interruption_digit_sequence (str): interruptionDigitSequence *Optional*
        audio_selection (str): audioSelection
        audio_file_description (str): audioFileDescription *Optional*
        audio_media_type (str): audioMediaType *Optional*
        audio_file_url (str): audioFileUrl *Optional*
        video_selection (str): videoSelection
        video_file_description (str): videoFileDescription *Optional*
        video_media_type (str): videoMediaType *Optional*
        video_file_url (str): videoFileUrl *Optional*
    """

    __slots__: List[str] = [
        "announcement_interruption",
        "interruption_digit_sequence",
        "audio_selection",
        "audio_file_description",
        "audio_media_type",
        "audio_file_url",
        "video_selection",
        "video_file_description",
        "video_media_type",
        "video_file_url",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "announcement_interruption",
                "announcementInterruption",
                str,
                is_required=True,
            ),
            E(
                "interruption_digit_sequence",
                "interruptionDigitSequence",
                str,
            ),
            E(
                "audio_selection",
                "audioSelection",
                str,
                is_required=True,
            ),
            E(
                "audio_file_description",
                "audioFileDescription",
                str,
            ),
            E(
                "audio_media_type",
                "audioMediaType",
                str,
            ),
            E(
                "audio_file_url",
                "audioFileUrl",
                str,
            ),
            E(
                "video_selection",
                "videoSelection",
                str,
                is_required=True,
            ),
            E(
                "video_file_description",
                "videoFileDescription",
                str,
            ),
            E(
                "video_media_type",
                "videoMediaType",
                str,
            ),
            E(
                "video_file_url",
                "videoFileUrl",
                str,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberPrefixGetAvailableListResponse(OCIResponse):
    """
    Response to `GroupRouteListEnterpriseTrunkNumberPrefixGetAvailableListRequest()`.

    Contains a list of number prefixess that are assigned to a group and still available
    for assignment to users within the group.  The column headings are "Number
    Prefix"","Is Active", "Extension Range Start" and "Extension Range End".

    Attributes:
        available_number_prefix_table (List(availableNumberPrefixTable)):
            availableNumberPrefixTable - *Table* array of availableNumberPrefixTable named
            tuples
    """

    __slots__: List[str] = [
        "available_number_prefix_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_number_prefix_table",
                "availableNumberPrefixTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberPrefixGetSummaryListResponse(OCIResponse):
    """
    Response to `GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()`.

    The response contains a table with columns: "Number Prefix", "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number",
    "Extension", "Department", "Email Address", "Enterprise Trunk"","Is Active",
    "Extension Range Start" and "Extension Range End". The "User Id", "Last Name", "First
    Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension",
    "Department" and "Email Address" columns contains the corresponding attributes of the
    user possessing the number range.  The "Enterprise Trunk" column contains the
    enterprise trunk the user possessing the number range belongs to.  The "Is Active"
    column indicates if the number prefix has been activated.  The "Extension Range Start"
    column indicates the start for an extension range.  The "Extension Range End" column
    indicates the end for an extension range.

    Attributes:
        number_prefix_summary_table (List(numberPrefixSummaryTable)):
            numberPrefixSummaryTable - *Table* array of numberPrefixSummaryTable named
            tuples
    """

    __slots__: List[str] = [
        "number_prefix_summary_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number_prefix_summary_table",
                "numberPrefixSummaryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(OCIResponse):
    """
    Response to `GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()`.

    Contains a list of number ranges that are assigned to a group and still available for
    assignment to users within the group.  The column headings are "Number Range Start",
    "Number Range End" ,"Is Active" and "Extension Length"..

    Attributes:
        available_number_range_table (List(availableNumberRangeTable)):
            availableNumberRangeTable - *Table* array of availableNumberRangeTable named
            tuples
    """

    __slots__: List[str] = [
        "available_number_range_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "available_number_range_table",
                "availableNumberRangeTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to `GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()`.

    The response contains a table with columns: "Number Range Start", "Number Range End",
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address", "Enterprise Trunk" and "Is
    Active". The "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name", "Phone Number", "Extension", "Department" and "Email Address" columns
    contains the corresponding attributes of the user possessing the number range.  The
    "Enterprise Trunk" column contains the enterprise trunk the user possessing the number
    range belongs to.  The "Is Active" column indicates if the number range has been
    activated.  The "Extension Length" column indicates the length of the extension for
    the enterpris trunk number range.

    Attributes:
        number_range_summary_table (List(numberRangeSummaryTable)):
            numberRangeSummaryTable - *Table* array of numberRangeSummaryTable named
            tuples
    """

    __slots__: List[str] = [
        "number_range_summary_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "number_range_summary_table",
                "numberRangeSummaryTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRoutePointBouncedCallGetResponse(OCIResponse):
    """
    Response to the `GroupRoutePointBouncedCallGetRequest()`.


    Attributes:
        is_active (bool): isActive
        number_of_rings_before_bouncing_call (int): numberOfRingsBeforeBouncingCall
        enable_transfer (bool): enableTransfer *Optional*
        transfer_phone_number (str): transferPhoneNumber *Optional*
        bounce_call_when_agent_unavailable (bool): bounceCallWhenAgentUnavailable
    """

    __slots__: List[str] = [
        "is_active",
        "number_of_rings_before_bouncing_call",
        "enable_transfer",
        "transfer_phone_number",
        "bounce_call_when_agent_unavailable",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "number_of_rings_before_bouncing_call",
                "numberOfRingsBeforeBouncingCall",
                int,
                is_required=True,
            ),
            E(
                "enable_transfer",
                "enableTransfer",
                bool,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "bounce_call_when_agent_unavailable",
                "bounceCallWhenAgentUnavailable",
                bool,
                is_required=True,
            ),
        )


class GroupRoutePointDistinctiveRingingGetResponse(OCIResponse):
    """
    Response to the `GroupRoutePointDistinctiveRingingGetRequest()`.


    Attributes:
        enable_distinctive_ringing (bool): enableDistinctiveRinging
        distinctive_ringing_ring_pattern (str): distinctiveRingingRingPattern
        distinctive_ringing_force_delivery_ring_pattern (str):
            distinctiveRingingForceDeliveryRingPattern
    """

    __slots__: List[str] = [
        "enable_distinctive_ringing",
        "distinctive_ringing_ring_pattern",
        "distinctive_ringing_force_delivery_ring_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_distinctive_ringing",
                "enableDistinctiveRinging",
                bool,
                is_required=True,
            ),
            E(
                "distinctive_ringing_ring_pattern",
                "distinctiveRingingRingPattern",
                str,
                is_required=True,
            ),
            E(
                "distinctive_ringing_force_delivery_ring_pattern",
                "distinctiveRingingForceDeliveryRingPattern",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointExternalSystemGetAssignedListResponse(OCIResponse):
    """
    Response to the `GroupRoutePointExternalSystemGetAssignedListRequest()`.

    Contains a table of all Route Point External Systems assigned to the group.  The
    column headings are: "Name" and "Description".

    Attributes:
        external_system_table (List(externalSystemTable)): externalSystemTable - *Table*
            array of externalSystemTable named tuples
    """

    __slots__: List[str] = [
        "external_system_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "external_system_table",
                "externalSystemTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRoutePointExternalSystemGetAssignedRoutePointListResponse(OCIResponse):
    """
    Response to the `GroupRoutePointExternalSystemGetAssignedRoutePointListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department". The column values for "Video" can either be
    "true", or "false".

    Attributes:
        route_point_table (List(routePointTable)): routePointTable - *Table* array of
            routePointTable named tuples
    """

    __slots__: List[str] = [
        "route_point_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "route_point_table",
                "routePointTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRoutePointGetDNISAgentListResponse(OCIResponse):
    """
    Response to the `GroupRoutePointGetDNISAgentListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_table (List(agentTable)): agentTable - *Table* array of agentTable named
            tuples
    """

    __slots__: List[str] = [
        "agent_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "agent_table",
                "agentTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRoutePointGetDNISListResponse(OCIResponse):
    """
    Response to the `GroupRoutePointGetDNISListRequest()`.

    Contains a table with column headings: "Name", "Phone Number", "Extension".

    Attributes:
        display_dnis_number (bool): displayDNISNumber
        display_dnis_name (bool): displayDNISName
        dnis_table (List(dnisTable)): dnisTable - *Table* array of dnisTable named tuples
    """

    __slots__: List[str] = [
        "display_dnis_number",
        "display_dnis_name",
        "dnis_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "display_dnis_number",
                "displayDNISNumber",
                bool,
                is_required=True,
            ),
            E(
                "display_dnis_name",
                "displayDNISName",
                bool,
                is_required=True,
            ),
            E(
                "dnis_table",
                "dnisTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRoutePointGetDNISResponse(OCIResponse):
    """
    Response to the `GroupRoutePointGetDNISRequest()`.


    Attributes:
        dnis_phone_number (str): dnisPhoneNumber *Optional*
        extension (str): extension *Optional*
        use_custom_clid_settings (bool): useCustomCLIDSettings
        calling_line_id_phone_number (str): callingLineIdPhoneNumber *Optional*
        calling_line_id_last_name (str): callingLineIdLastName *Optional*
        calling_line_id_first_name (str): callingLineIdFirstName *Optional*
        use_custom_dnis_announcement_settings (bool): useCustomDnisAnnouncementSettings
        allow_outgoing_acd_call (bool): allowOutgoingACDCall
    """

    __slots__: List[str] = [
        "dnis_phone_number",
        "extension",
        "use_custom_clid_settings",
        "calling_line_id_phone_number",
        "calling_line_id_last_name",
        "calling_line_id_first_name",
        "use_custom_dnis_announcement_settings",
        "allow_outgoing_acd_call",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "dnis_phone_number",
                "dnisPhoneNumber",
                str,
            ),
            E(
                "extension",
                "extension",
                str,
            ),
            E(
                "use_custom_clid_settings",
                "useCustomCLIDSettings",
                bool,
                is_required=True,
            ),
            E(
                "calling_line_id_phone_number",
                "callingLineIdPhoneNumber",
                str,
            ),
            E(
                "calling_line_id_last_name",
                "callingLineIdLastName",
                str,
            ),
            E(
                "calling_line_id_first_name",
                "callingLineIdFirstName",
                str,
            ),
            E(
                "use_custom_dnis_announcement_settings",
                "useCustomDnisAnnouncementSettings",
                bool,
                is_required=True,
            ),
            E(
                "allow_outgoing_acd_call",
                "allowOutgoingACDCall",
                bool,
                is_required=True,
            ),
        )


class GroupRoutePointGetFailoverPolicyResponse(OCIResponse):
    """
    Response to the `GroupRoutePointGetFailoverPolicyRequest()`.


    Attributes:
        enable_failover_support (bool): enableFailoverSupport
        external_system (str): externalSystem *Optional*
        failover_phone_number (str): failoverPhoneNumber *Optional*
        failover_status (str): failoverStatus
        per_call_enable_failover_support (bool): perCallEnableFailoverSupport
        per_call_call_failure_timeout_seconds (int): perCallCallFailureTimeoutSeconds
        per_call_outbound_call_failure_timeout_seconds (int):
            perCallOutboundCallFailureTimeoutSeconds
        per_call_failover_phone_number (str): perCallFailoverPhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "enable_failover_support",
        "external_system",
        "failover_phone_number",
        "failover_status",
        "per_call_enable_failover_support",
        "per_call_call_failure_timeout_seconds",
        "per_call_outbound_call_failure_timeout_seconds",
        "per_call_failover_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_failover_support",
                "enableFailoverSupport",
                bool,
                is_required=True,
            ),
            E(
                "external_system",
                "externalSystem",
                str,
            ),
            E(
                "failover_phone_number",
                "failoverPhoneNumber",
                str,
            ),
            E(
                "failover_status",
                "failoverStatus",
                str,
                is_required=True,
            ),
            E(
                "per_call_enable_failover_support",
                "perCallEnableFailoverSupport",
                bool,
                is_required=True,
            ),
            E(
                "per_call_call_failure_timeout_seconds",
                "perCallCallFailureTimeoutSeconds",
                int,
                is_required=True,
            ),
            E(
                "per_call_outbound_call_failure_timeout_seconds",
                "perCallOutboundCallFailureTimeoutSeconds",
                int,
                is_required=True,
            ),
            E(
                "per_call_failover_phone_number",
                "perCallFailoverPhoneNumber",
                str,
            ),
        )


class GroupRoutePointGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupRoutePointGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active". The column values for "Video" and "Is
    Active" can either be true, or false.

    Attributes:
        route_point_table (List(routePointTable)): routePointTable - *Table* array of
            routePointTable named tuples
    """

    __slots__: List[str] = [
        "route_point_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "route_point_table",
                "routePointTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRoutePointQueueCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the `GroupRoutePointQueueCallDispositionCodeGetListRequest()`.

    Contains a table with column headings: "Is Active", "Code", "Description" and "Level".
    Level column can be any of the values in the data type CallDispositionCodeLevel.

    Attributes:
        disposition_codes_table (List(dispositionCodesTable)): dispositionCodesTable -
            *Table* array of dispositionCodesTable named tuples
    """

    __slots__: List[str] = [
        "disposition_codes_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "disposition_codes_table",
                "dispositionCodesTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupRoutePointQueueCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the `GroupRoutePointQueueCallDispositionCodeGetRequest()`

    Attributes:
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupRoutingProfileGetResponse(OCIResponse):
    """
    Response to `GroupRoutingProfileGetRequest()`.


    Attributes:
        routing_profile (str): routingProfile *Optional*
    """

    __slots__: List[str] = [
        "routing_profile",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "routing_profile",
                "routingProfile",
                str,
            ),
        )


class GroupScheduleGetEventListResponse(OCIResponse):
    """
    Response to `GroupScheduleGetEventListRequest()`.

    The response contains a list of events.

    Attributes:
        event_name (List[str]): eventName *Optional*
    """

    __slots__: List[str] = [
        "event_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "event_name",
                "eventName",
                str,
                is_array=True,
            ),
        )


class GroupScheduleGetListResponse(OCIResponse):
    """
    Response to `GroupScheduleGetListRequest()`.

    The response contains a list of system schedules.

    Attributes:
        schedule_name (List[str]): scheduleName *Optional*
        schedule_type (List[str]): scheduleType *Optional*
        schedule_level (List[str]): scheduleLevel *Optional*
    """

    __slots__: List[str] = [
        "schedule_name",
        "schedule_type",
        "schedule_level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "schedule_name",
                "scheduleName",
                str,
                is_array=True,
            ),
            E(
                "schedule_type",
                "scheduleType",
                str,
                is_array=True,
            ),
            E(
                "schedule_level",
                "scheduleLevel",
                str,
                is_array=True,
            ),
        )


class GroupScheduleGetPagedSortedListResponse(OCIResponse):
    """
    Response to `GroupScheduleGetPagedSortedListRequest()`.

    Contains a 3 column table with column headings: "Name", "Type", "Level" and a row for
    each schedule.

    Attributes:
        schedule_table (List(scheduleTable)): scheduleTable - *Table* array of
            scheduleTable named tuples
    """

    __slots__: List[str] = [
        "schedule_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "schedule_table",
                "scheduleTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupScheduleUsageResponse(OCIResponse):
    """
    Response to `GroupScheduleUsageRequest()`.

    The response contains a list of service names.  The response contains the usage for
    the requested schedule.  The usage table has columns "Service Name", and "Instance
    Name". The Service Name values correspond to string values of the GroupService and
    UserService data types.

    Attributes:
        usage_table (List(usageTable)): usageTable - *Table* array of usageTable named
            tuples
    """

    __slots__: List[str] = [
        "usage_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "usage_table",
                "usageTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupSecurityClassificationCustomizationGetAvailableListResponse(OCIResponse):
    """
    Response to `GroupClassificationCustomizationGetAvailableListRequest()`.

    Returns the available group security classifications.  Contains a table with column
    headings: "SystemSecurityClassification", "CustomizedSecurityClassification"

    Attributes:
        security_classification_name_table (List(securityClassificationNameTable)):
            securityClassificationNameTable - *Table* array of
            securityClassificationNameTable named tuples
    """

    __slots__: List[str] = [
        "security_classification_name_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "security_classification_name_table",
                "securityClassificationNameTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupSeriesCompletionGetAvailableUserListResponse(OCIResponse):
    """
    Response to the `GroupSeriesCompletionGetAvailableUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupSeriesCompletionGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupSeriesCompletionGetInstanceListRequest()`.


    Attributes:
        name (List[str]): name *Optional*
    """

    __slots__: List[str] = [
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "name",
                "name",
                str,
                is_array=True,
            ),
        )


class GroupSeriesCompletionGetInstanceResponse(OCIResponse):
    """
    Response to the `GroupSeriesCompletionGetInstanceRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupServiceGetAuthorizationListResponse(OCIResponse):
    """
    Response to `GroupServiceGetAuthorizationListRequest()`.

    Contains three tables, one for the service packs, one for the group services, and one
    for the user services.  The user table has the following column headings: "Service
    Name", "Authorized", "Assigned", "Limited", "Quantity", "Usage", "Licensed",
    "Allowed", "User Assignable", "Group Service Assignable". The group service table has
    the following column headings: "Service Name", "Authorized", "Assigned", "Limited",
    "Quantity", "Usage", "Licensed", "Allowed", "Instance Count". The service pack table's
    column headings are: "Service Pack Name", "Authorized", "Assigned", "Limited",
    "Allocated", "Allowed", "Usage", "Description".

    Attributes:
        service_packs_authorization_table (List(servicePacksAuthorizationTable)):
            servicePacksAuthorizationTable - *Table* array of
            servicePacksAuthorizationTable named tuples
        group_services_authorization_table (List(groupServicesAuthorizationTable)):
            groupServicesAuthorizationTable - *Table* array of
            groupServicesAuthorizationTable named tuples
        user_services_authorization_table (List(userServicesAuthorizationTable)):
            userServicesAuthorizationTable - *Table* array of
            userServicesAuthorizationTable named tuples
    """

    __slots__: List[str] = [
        "service_packs_authorization_table",
        "group_services_authorization_table",
        "user_services_authorization_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_packs_authorization_table",
                "servicePacksAuthorizationTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
            E(
                "group_services_authorization_table",
                "groupServicesAuthorizationTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
            E(
                "user_services_authorization_table",
                "userServicesAuthorizationTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupServiceGetAuthorizedListResponse(OCIResponse):
    """
    Response to `GroupServiceGetAuthorizedListRequest()`.


    Attributes:
        service_pack_name (List[str]): servicePackName *Optional*
        group_service_name (List[str]): groupServiceName *Optional*
        user_service_name (List[str]): userServiceName *Optional*
    """

    __slots__: List[str] = [
        "service_pack_name",
        "group_service_name",
        "user_service_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_array=True,
            ),
            E(
                "group_service_name",
                "groupServiceName",
                str,
                is_array=True,
            ),
            E(
                "user_service_name",
                "userServiceName",
                str,
                is_array=True,
            ),
        )


class GroupServiceInstancePrivacyGetResponse(OCIResponse):
    """
    Response to `GroupServiceInstancePrivacyGetRequest()`.

    Replaced by: `GroupServiceInstancePrivacyGetResponse17sp4()`

    Attributes:
        enable_directory_privacy (bool): enableDirectoryPrivacy
        enable_auto_attendant_extension_dialing_privacy (bool):
            enableAutoAttendantExtensionDialingPrivacy
    """

    __slots__: List[str] = [
        "enable_directory_privacy",
        "enable_auto_attendant_extension_dialing_privacy",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_directory_privacy",
                "enableDirectoryPrivacy",
                bool,
                is_required=True,
            ),
            E(
                "enable_auto_attendant_extension_dialing_privacy",
                "enableAutoAttendantExtensionDialingPrivacy",
                bool,
                is_required=True,
            ),
        )


class GroupServiceInstancePrivacyGetResponse17sp4(OCIResponse):
    """
    Response to `GroupServiceInstancePrivacyGetRequest17sp4()`.


    Attributes:
        enable_directory_privacy (bool): enableDirectoryPrivacy
        enable_auto_attendant_extension_dialing_privacy (bool):
            enableAutoAttendantExtensionDialingPrivacy
        enable_auto_attendant_name_dialing_privacy (bool):
            enableAutoAttendantNameDialingPrivacy
    """

    __slots__: List[str] = [
        "enable_directory_privacy",
        "enable_auto_attendant_extension_dialing_privacy",
        "enable_auto_attendant_name_dialing_privacy",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_directory_privacy",
                "enableDirectoryPrivacy",
                bool,
                is_required=True,
            ),
            E(
                "enable_auto_attendant_extension_dialing_privacy",
                "enableAutoAttendantExtensionDialingPrivacy",
                bool,
                is_required=True,
            ),
            E(
                "enable_auto_attendant_name_dialing_privacy",
                "enableAutoAttendantNameDialingPrivacy",
                bool,
                is_required=True,
            ),
        )


class GroupServiceIsAssignedResponse(OCIResponse):
    """
    Returns true if the GroupService is assigned, otherwise false.


    Attributes:
        is_assigned (bool): isAssigned
    """

    __slots__: List[str] = [
        "is_assigned",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_assigned",
                "isAssigned",
                bool,
                is_required=True,
            ),
        )


class GroupServicePhoneNumberLookupResponse(OCIResponse):
    """
    Response to the `GroupServicePhoneNumberLookupRequest()`.

    The column headings for the userTable are: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension" and
    "Department".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupSessionAdmissionControlGetResponse(OCIResponse):
    """
    Response to the `GroupSessionAdmissionControlGetRequest()`.

    The response contains the session admission control capacity allocated for the group.

    Attributes:
        restrict_aggregate_sessions (bool): restrictAggregateSessions
        max_sessions (int): maxSessions *Optional*
        max_user_originating_sessions (int): maxUserOriginatingSessions *Optional*
        max_user_terminating_sessions (int): maxUserTerminatingSessions *Optional*
        count_intra_group_sessions (bool): countIntraGroupSessions
    """

    __slots__: List[str] = [
        "restrict_aggregate_sessions",
        "max_sessions",
        "max_user_originating_sessions",
        "max_user_terminating_sessions",
        "count_intra_group_sessions",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "restrict_aggregate_sessions",
                "restrictAggregateSessions",
                bool,
                is_required=True,
            ),
            E(
                "max_sessions",
                "maxSessions",
                int,
            ),
            E(
                "max_user_originating_sessions",
                "maxUserOriginatingSessions",
                int,
            ),
            E(
                "max_user_terminating_sessions",
                "maxUserTerminatingSessions",
                int,
            ),
            E(
                "count_intra_group_sessions",
                "countIntraGroupSessions",
                bool,
                is_required=True,
            ),
        )


class GroupSessionAdmissionControlGroupGetListResponse(OCIResponse):
    """
    Response to `GroupSessionAdmissionControlGroupGetListRequest()`.

    Contains a table of session admission control group configured in the group.  The
    column headings are: "Name", "Is Default", "Maximum Sessions", "Maximum Originating
    Sessions", "Maximum Terminating Sessions".

    Attributes:
        session_admission_control_group_table (List(sessionAdmissionControlGroupTable)):
            sessionAdmissionControlGroupTable - *Table* array of
            sessionAdmissionControlGroupTable named tuples
    """

    __slots__: List[str] = [
        "session_admission_control_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "session_admission_control_group_table",
                "sessionAdmissionControlGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupSpeedDial100GetResponse(OCIResponse):
    """
    Response to the `GroupSpeedDial100GetRequest()`.


    Attributes:
        prefix (str): prefix
    """

    __slots__: List[str] = [
        "prefix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "prefix",
                "prefix",
                str,
                is_required=True,
            ),
        )


class GroupSpeedDial100GetResponse17sp1(OCIResponse):
    """
    Response to the `GroupSpeedDial100GetRequest17sp1()`.


    Attributes:
        prefix (str): prefix *Optional*
    """

    __slots__: List[str] = [
        "prefix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "prefix",
                "prefix",
                str,
            ),
        )


class GroupStirShakenGetResponse(OCIResponse):
    """
    Response to the `GroupStirShakenGetRequest()`.

    Replaced by: GroupStirShakenGetResponset25.

    Attributes:
        use_parent_level_settings (bool): useParentLevelSettings
        signing_policy (str): signingPolicy
        tagging_policy (str): taggingPolicy
        signing_service_url (str): signingServiceURL *Optional*
        tag_from_or_pai (str): tagFromOrPAI
        verstat_tag (str): verstatTag
        use_os_value_for_orig_id (bool): useOSValueForOrigId
        orig_uuid (str): origUUID *Optional*
        attestation_level (str): attestationLevel
        enable_verification (bool): enableVerification
        verification_service_url (str): verificationServiceURL *Optional*
        verification_error_handling (str): verificationErrorHandling
        proxy_verstat_to_cnam_subscribe (bool): proxyVerstatToCNAMSubscribe
        use_unknown_headers_from_cnam_notify (bool): useUnknownHeadersFromCNAMNotify
        enable_signing_for_unscreened_trunk_group_originations (bool):
            enableSigningForUnscreenedTrunkGroupOriginations
        enable_tagging_for_unscreened_trunk_group_originations (bool):
            enableTaggingForUnscreenedTrunkGroupOriginations
        unscreened_trunk_group_origination_attestation_level (str):
            unscreenedTrunkGroupOriginationAttestationLevel
    """

    __slots__: List[str] = [
        "use_parent_level_settings",
        "signing_policy",
        "tagging_policy",
        "signing_service_url",
        "tag_from_or_pai",
        "verstat_tag",
        "use_os_value_for_orig_id",
        "orig_uuid",
        "attestation_level",
        "enable_verification",
        "verification_service_url",
        "verification_error_handling",
        "proxy_verstat_to_cnam_subscribe",
        "use_unknown_headers_from_cnam_notify",
        "enable_signing_for_unscreened_trunk_group_originations",
        "enable_tagging_for_unscreened_trunk_group_originations",
        "unscreened_trunk_group_origination_attestation_level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_parent_level_settings",
                "useParentLevelSettings",
                bool,
                is_required=True,
            ),
            E(
                "signing_policy",
                "signingPolicy",
                str,
                is_required=True,
            ),
            E(
                "tagging_policy",
                "taggingPolicy",
                str,
                is_required=True,
            ),
            E(
                "signing_service_url",
                "signingServiceURL",
                str,
            ),
            E(
                "tag_from_or_pai",
                "tagFromOrPAI",
                str,
                is_required=True,
            ),
            E(
                "verstat_tag",
                "verstatTag",
                str,
                is_required=True,
            ),
            E(
                "use_os_value_for_orig_id",
                "useOSValueForOrigId",
                bool,
                is_required=True,
            ),
            E(
                "orig_uuid",
                "origUUID",
                str,
            ),
            E(
                "attestation_level",
                "attestationLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_verification",
                "enableVerification",
                bool,
                is_required=True,
            ),
            E(
                "verification_service_url",
                "verificationServiceURL",
                str,
            ),
            E(
                "verification_error_handling",
                "verificationErrorHandling",
                str,
                is_required=True,
            ),
            E(
                "proxy_verstat_to_cnam_subscribe",
                "proxyVerstatToCNAMSubscribe",
                bool,
                is_required=True,
            ),
            E(
                "use_unknown_headers_from_cnam_notify",
                "useUnknownHeadersFromCNAMNotify",
                bool,
                is_required=True,
            ),
            E(
                "enable_signing_for_unscreened_trunk_group_originations",
                "enableSigningForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "enable_tagging_for_unscreened_trunk_group_originations",
                "enableTaggingForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "unscreened_trunk_group_origination_attestation_level",
                "unscreenedTrunkGroupOriginationAttestationLevel",
                str,
                is_required=True,
            ),
        )


class GroupStirShakenGetResponse23(OCIResponse):
    """
    Response to the `GroupStirShakenGetRequest23()`.

    Replaced by `GroupStirShakenGetResponse23V2()`.

    Attributes:
        use_parent_level_settings (bool): useParentLevelSettings
        signing_policy (str): signingPolicy
        tagging_policy (str): taggingPolicy
        signing_service_url (str): signingServiceURL *Optional*
        tag_from_or_pai (str): tagFromOrPAI
        verstat_tag (str): verstatTag
        use_os_value_for_orig_id (bool): useOSValueForOrigId
        orig_uuid (str): origUUID *Optional*
        attestation_level (str): attestationLevel
        enable_verification (bool): enableVerification
        verification_service_url (str): verificationServiceURL *Optional*
        verification_error_handling (str): verificationErrorHandling
        proxy_verstat_to_cnam_subscribe (bool): proxyVerstatToCNAMSubscribe
        use_unknown_headers_from_cnam_notify (bool): useUnknownHeadersFromCNAMNotify
        enable_signing_for_unscreened_trunk_group_originations (bool):
            enableSigningForUnscreenedTrunkGroupOriginations
        enable_tagging_for_unscreened_trunk_group_originations (bool):
            enableTaggingForUnscreenedTrunkGroupOriginations
        unscreened_trunk_group_origination_attestation_level (str):
            unscreenedTrunkGroupOriginationAttestationLevel
        include_tagged_headers_to_access_side (bool): includeTaggedHeadersToAccessSide
        proxy_identity_header_to_access_side (bool): proxyIdentityHeaderToAccessSide
        check_directory_numbers_for_attestation (bool):
            checkDirectoryNumbersForAttestation
        match_unassigned_numbers_only (bool): matchUnassignedNumbersOnly
    """

    __slots__: List[str] = [
        "use_parent_level_settings",
        "signing_policy",
        "tagging_policy",
        "signing_service_url",
        "tag_from_or_pai",
        "verstat_tag",
        "use_os_value_for_orig_id",
        "orig_uuid",
        "attestation_level",
        "enable_verification",
        "verification_service_url",
        "verification_error_handling",
        "proxy_verstat_to_cnam_subscribe",
        "use_unknown_headers_from_cnam_notify",
        "enable_signing_for_unscreened_trunk_group_originations",
        "enable_tagging_for_unscreened_trunk_group_originations",
        "unscreened_trunk_group_origination_attestation_level",
        "include_tagged_headers_to_access_side",
        "proxy_identity_header_to_access_side",
        "check_directory_numbers_for_attestation",
        "match_unassigned_numbers_only",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_parent_level_settings",
                "useParentLevelSettings",
                bool,
                is_required=True,
            ),
            E(
                "signing_policy",
                "signingPolicy",
                str,
                is_required=True,
            ),
            E(
                "tagging_policy",
                "taggingPolicy",
                str,
                is_required=True,
            ),
            E(
                "signing_service_url",
                "signingServiceURL",
                str,
            ),
            E(
                "tag_from_or_pai",
                "tagFromOrPAI",
                str,
                is_required=True,
            ),
            E(
                "verstat_tag",
                "verstatTag",
                str,
                is_required=True,
            ),
            E(
                "use_os_value_for_orig_id",
                "useOSValueForOrigId",
                bool,
                is_required=True,
            ),
            E(
                "orig_uuid",
                "origUUID",
                str,
            ),
            E(
                "attestation_level",
                "attestationLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_verification",
                "enableVerification",
                bool,
                is_required=True,
            ),
            E(
                "verification_service_url",
                "verificationServiceURL",
                str,
            ),
            E(
                "verification_error_handling",
                "verificationErrorHandling",
                str,
                is_required=True,
            ),
            E(
                "proxy_verstat_to_cnam_subscribe",
                "proxyVerstatToCNAMSubscribe",
                bool,
                is_required=True,
            ),
            E(
                "use_unknown_headers_from_cnam_notify",
                "useUnknownHeadersFromCNAMNotify",
                bool,
                is_required=True,
            ),
            E(
                "enable_signing_for_unscreened_trunk_group_originations",
                "enableSigningForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "enable_tagging_for_unscreened_trunk_group_originations",
                "enableTaggingForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "unscreened_trunk_group_origination_attestation_level",
                "unscreenedTrunkGroupOriginationAttestationLevel",
                str,
                is_required=True,
            ),
            E(
                "include_tagged_headers_to_access_side",
                "includeTaggedHeadersToAccessSide",
                bool,
                is_required=True,
            ),
            E(
                "proxy_identity_header_to_access_side",
                "proxyIdentityHeaderToAccessSide",
                bool,
                is_required=True,
            ),
            E(
                "check_directory_numbers_for_attestation",
                "checkDirectoryNumbersForAttestation",
                bool,
                is_required=True,
            ),
            E(
                "match_unassigned_numbers_only",
                "matchUnassignedNumbersOnly",
                bool,
                is_required=True,
            ),
        )


class GroupStirShakenGetResponse23V2(OCIResponse):
    """
    Response to the `GroupStirShakenGetRequest23V2()`.


    Attributes:
        use_parent_level_settings (bool): useParentLevelSettings
        signing_policy (str): signingPolicy
        tagging_policy (str): taggingPolicy
        signing_service_url (str): signingServiceURL *Optional*
        tag_from_or_pai (str): tagFromOrPAI
        verstat_tag (str): verstatTag
        use_os_value_for_orig_id (bool): useOSValueForOrigId
        orig_uuid (str): origUUID *Optional*
        attestation_level (str): attestationLevel
        enable_verification (bool): enableVerification
        verification_service_url (str): verificationServiceURL *Optional*
        verification_error_handling (str): verificationErrorHandling
        proxy_verstat_to_cnam_subscribe (bool): proxyVerstatToCNAMSubscribe
        use_unknown_headers_from_cnam_notify (bool): useUnknownHeadersFromCNAMNotify
        enable_signing_for_unscreened_trunk_group_originations (bool):
            enableSigningForUnscreenedTrunkGroupOriginations
        enable_tagging_for_unscreened_trunk_group_originations (bool):
            enableTaggingForUnscreenedTrunkGroupOriginations
        unscreened_trunk_group_origination_attestation_level (str):
            unscreenedTrunkGroupOriginationAttestationLevel
        include_tagged_headers_to_access_side (bool): includeTaggedHeadersToAccessSide
        proxy_identity_header_to_access_side (bool): proxyIdentityHeaderToAccessSide
        check_directory_numbers_for_attestation (bool):
            checkDirectoryNumbersForAttestation
        match_unassigned_numbers_only (bool): matchUnassignedNumbersOnly
        enable_tagging_for_redirected_calls (bool): enableTaggingForRedirectedCalls
        prefer_ingress_tagging (bool): preferIngressTagging
    """

    __slots__: List[str] = [
        "use_parent_level_settings",
        "signing_policy",
        "tagging_policy",
        "signing_service_url",
        "tag_from_or_pai",
        "verstat_tag",
        "use_os_value_for_orig_id",
        "orig_uuid",
        "attestation_level",
        "enable_verification",
        "verification_service_url",
        "verification_error_handling",
        "proxy_verstat_to_cnam_subscribe",
        "use_unknown_headers_from_cnam_notify",
        "enable_signing_for_unscreened_trunk_group_originations",
        "enable_tagging_for_unscreened_trunk_group_originations",
        "unscreened_trunk_group_origination_attestation_level",
        "include_tagged_headers_to_access_side",
        "proxy_identity_header_to_access_side",
        "check_directory_numbers_for_attestation",
        "match_unassigned_numbers_only",
        "enable_tagging_for_redirected_calls",
        "prefer_ingress_tagging",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_parent_level_settings",
                "useParentLevelSettings",
                bool,
                is_required=True,
            ),
            E(
                "signing_policy",
                "signingPolicy",
                str,
                is_required=True,
            ),
            E(
                "tagging_policy",
                "taggingPolicy",
                str,
                is_required=True,
            ),
            E(
                "signing_service_url",
                "signingServiceURL",
                str,
            ),
            E(
                "tag_from_or_pai",
                "tagFromOrPAI",
                str,
                is_required=True,
            ),
            E(
                "verstat_tag",
                "verstatTag",
                str,
                is_required=True,
            ),
            E(
                "use_os_value_for_orig_id",
                "useOSValueForOrigId",
                bool,
                is_required=True,
            ),
            E(
                "orig_uuid",
                "origUUID",
                str,
            ),
            E(
                "attestation_level",
                "attestationLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_verification",
                "enableVerification",
                bool,
                is_required=True,
            ),
            E(
                "verification_service_url",
                "verificationServiceURL",
                str,
            ),
            E(
                "verification_error_handling",
                "verificationErrorHandling",
                str,
                is_required=True,
            ),
            E(
                "proxy_verstat_to_cnam_subscribe",
                "proxyVerstatToCNAMSubscribe",
                bool,
                is_required=True,
            ),
            E(
                "use_unknown_headers_from_cnam_notify",
                "useUnknownHeadersFromCNAMNotify",
                bool,
                is_required=True,
            ),
            E(
                "enable_signing_for_unscreened_trunk_group_originations",
                "enableSigningForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "enable_tagging_for_unscreened_trunk_group_originations",
                "enableTaggingForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "unscreened_trunk_group_origination_attestation_level",
                "unscreenedTrunkGroupOriginationAttestationLevel",
                str,
                is_required=True,
            ),
            E(
                "include_tagged_headers_to_access_side",
                "includeTaggedHeadersToAccessSide",
                bool,
                is_required=True,
            ),
            E(
                "proxy_identity_header_to_access_side",
                "proxyIdentityHeaderToAccessSide",
                bool,
                is_required=True,
            ),
            E(
                "check_directory_numbers_for_attestation",
                "checkDirectoryNumbersForAttestation",
                bool,
                is_required=True,
            ),
            E(
                "match_unassigned_numbers_only",
                "matchUnassignedNumbersOnly",
                bool,
                is_required=True,
            ),
            E(
                "enable_tagging_for_redirected_calls",
                "enableTaggingForRedirectedCalls",
                bool,
                is_required=True,
            ),
            E(
                "prefer_ingress_tagging",
                "preferIngressTagging",
                bool,
                is_required=True,
            ),
        )


class GroupTemplateOnlyDeviceFileGetListResponse(OCIResponse):
    """
    Response to `GroupTemplateOnlyDeviceFileGetListRequest()`.

    Contains a list of template files used to support a Visual Device Management device.

    Attributes:
        template_file_url (List[str]): templateFileUrl *Optional*
    """

    __slots__: List[str] = [
        "template_file_url",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "template_file_url",
                "templateFileUrl",
                str,
                is_array=True,
            ),
        )


class GroupThirdPartyEmergencyCallingGetResponse(OCIResponse):
    """
    Response to the `GroupThirdPartyEmergencyCallingGetRequest()`.

    The response contains the third-party emergency call service settings for the Group.

    Attributes:
        enable_device_management (bool): enableDeviceManagement
        enable_routing (bool): enableRouting
    """

    __slots__: List[str] = [
        "enable_device_management",
        "enable_routing",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_device_management",
                "enableDeviceManagement",
                bool,
                is_required=True,
            ),
            E(
                "enable_routing",
                "enableRouting",
                bool,
                is_required=True,
            ),
        )


class GroupThirdPartyEmergencyCallingGetResponse22(OCIResponse):
    """
    Response to the `GroupThirdPartyEmergencyCallingGetRequest22()`.

    The response contains the third-party emergency call service settings for the Group.

    Attributes:
        enable_device_management (bool): enableDeviceManagement
        enable_routing (bool): enableRouting
        customer_id (str): customerId *Optional*
        secret_key (str): secretKey *Optional*
    """

    __slots__: List[str] = [
        "enable_device_management",
        "enable_routing",
        "customer_id",
        "secret_key",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enable_device_management",
                "enableDeviceManagement",
                bool,
                is_required=True,
            ),
            E(
                "enable_routing",
                "enableRouting",
                bool,
                is_required=True,
            ),
            E(
                "customer_id",
                "customerId",
                str,
            ),
            E(
                "secret_key",
                "secretKey",
                str,
            ),
        )


class GroupThirdPartyVoiceMailSupportGetResponse(OCIResponse):
    """
    Response to `GroupThirdPartyVoiceMailSupportGetRequest()`.


    Attributes:
        is_active (bool): isActive
        group_server (str): groupServer *Optional*
    """

    __slots__: List[str] = [
        "is_active",
        "group_server",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "group_server",
                "groupServer",
                str,
            ),
        )


class GroupTimeScheduleGetListResponse(OCIResponse):
    """
    Response to the `GroupTimeScheduleGetListRequest()`.

    The response contains all the group's time schedule name.

    Attributes:
        time_schedule (List[str]): timeSchedule *Optional*
    """

    __slots__: List[str] = [
        "time_schedule",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "time_schedule",
                "timeSchedule",
                str,
                is_array=True,
            ),
        )


class GroupTrunkGroupGetAvailableDetailListResponse(OCIResponse):
    """
    Response to `GroupTrunkGroupGetAvailableDetailListRequest()`.


    Attributes:
        trunk_group (List[OCI.trunkGroup]): trunkGroup *Optional*
    """

    __slots__: List[str] = [
        "trunk_group",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "trunk_group",
                "trunkGroup",
                [
                    E(
                        "name",
                        "name",
                        str,
                        is_required=True,
                    ),
                    E(
                        "static_registration_capable",
                        "staticRegistrationCapable",
                        bool,
                        is_required=True,
                    ),
                    E(
                        "use_domain",
                        "useDomain",
                        bool,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_array=True,
                is_container=True,
            ),
        )


class GroupTrunkGroupGetAvailableHostedUserListResponse(OCIResponse):
    """
    Response to the `GroupTrunkGroupGetAvailableHostedUserListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupTrunkGroupGetInstanceListResponse14(OCIResponse):
    """
    Response to `GroupTrunkGroupGetInstanceListRequest14()`.

    Contains a table with column headings "Service User Id", "Name", "Department", "Device
    Name", "Device Level", "Group Id". The "Device Level" column contains one of the
    AccessDeviceLevel enumerated constants.

    Attributes:
        trunk_group_table (List(trunkGroupTable)): trunkGroupTable - *Table* array of
            trunkGroupTable named tuples
    """

    __slots__: List[str] = [
        "trunk_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "trunk_group_table",
                "trunkGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupTrunkGroupGetInstanceListResponse14sp4(OCIResponse):
    """
    Response to `GroupTrunkGroupGetInstanceListRequest14sp4()`.

    Contains a table with column headings "Name", "Department", "Device Name", "Device
    Level", "Group Id". The "Device Level" column contains one of the AccessDeviceLevel
    enumerated constants.

    Attributes:
        trunk_group_table (List(trunkGroupTable)): trunkGroupTable - *Table* array of
            trunkGroupTable named tuples
    """

    __slots__: List[str] = [
        "trunk_group_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "trunk_group_table",
                "trunkGroupTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupTrunkGroupGetInstanceUserListResponse(OCIResponse):
    """
    Response to `GroupTrunkGroupGetInstanceUserListRequest()`.

    The response contains a 7 column table with column headings "User Id", "Last Name",
    "First Name", "Department", "Phone Number", "Hiragana Last Name", "Hiragana First
    Name".

    Attributes:
        trunk_group_user_table (List(trunkGroupUserTable)): trunkGroupUserTable - *Table*
            array of trunkGroupUserTable named tuples
    """

    __slots__: List[str] = [
        "trunk_group_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "trunk_group_user_table",
                "trunkGroupUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupTrunkGroupGetInstanceUserListResponse14sp4(OCIResponse):
    """
    Response to `GroupTrunkGroupGetInstanceUserListRequest14sp4()`.

    The response contains a 9 column table with column headings "User Id", "Last Name",
    "First Name", "Department", "Phone Number", "Hiragana Last Name", "Hiragana First
    Name", "Extension", "Email Address".

    Attributes:
        trunk_group_user_table (List(trunkGroupUserTable)): trunkGroupUserTable - *Table*
            array of trunkGroupUserTable named tuples
    """

    __slots__: List[str] = [
        "trunk_group_user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "trunk_group_user_table",
                "trunkGroupUserTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupTrunkGroupSecurityClassificationGetResponse(OCIResponse):
    """
    Response to the `GroupTrunkGroupSecurityClassificationGetRequest()`.


    Attributes:
        default_security_classification (str): defaultSecurityClassification *Optional*
    """

    __slots__: List[str] = [
        "default_security_classification",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "default_security_classification",
                "defaultSecurityClassification",
                str,
            ),
        )


class GroupTrunkGroupStirShakenGetResponse(OCIResponse):
    """
    Response to the `GroupTrunkGroupStirShakenGetRequest()`.


    Attributes:
        use_parent_level_settings (bool): useParentLevelSettings
        signing_policy (str): signingPolicy
        tagging_policy (str): taggingPolicy
        signing_service_url (str): signingServiceURL *Optional*
        tag_from_or_pai (str): tagFromOrPAI
        verstat_tag (str): verstatTag
        use_os_value_for_orig_id (bool): useOSValueForOrigId
        orig_uuid (str): origUUID *Optional*
        attestation_level (str): attestationLevel
        enable_signing_for_unscreened_trunk_group_originations (bool):
            enableSigningForUnscreenedTrunkGroupOriginations
        enable_tagging_for_unscreened_trunk_group_originations (bool):
            enableTaggingForUnscreenedTrunkGroupOriginations
        unscreened_trunk_group_origination_attestation_level (str):
            unscreenedTrunkGroupOriginationAttestationLevel
    """

    __slots__: List[str] = [
        "use_parent_level_settings",
        "signing_policy",
        "tagging_policy",
        "signing_service_url",
        "tag_from_or_pai",
        "verstat_tag",
        "use_os_value_for_orig_id",
        "orig_uuid",
        "attestation_level",
        "enable_signing_for_unscreened_trunk_group_originations",
        "enable_tagging_for_unscreened_trunk_group_originations",
        "unscreened_trunk_group_origination_attestation_level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_parent_level_settings",
                "useParentLevelSettings",
                bool,
                is_required=True,
            ),
            E(
                "signing_policy",
                "signingPolicy",
                str,
                is_required=True,
            ),
            E(
                "tagging_policy",
                "taggingPolicy",
                str,
                is_required=True,
            ),
            E(
                "signing_service_url",
                "signingServiceURL",
                str,
            ),
            E(
                "tag_from_or_pai",
                "tagFromOrPAI",
                str,
                is_required=True,
            ),
            E(
                "verstat_tag",
                "verstatTag",
                str,
                is_required=True,
            ),
            E(
                "use_os_value_for_orig_id",
                "useOSValueForOrigId",
                bool,
                is_required=True,
            ),
            E(
                "orig_uuid",
                "origUUID",
                str,
            ),
            E(
                "attestation_level",
                "attestationLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_signing_for_unscreened_trunk_group_originations",
                "enableSigningForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "enable_tagging_for_unscreened_trunk_group_originations",
                "enableTaggingForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "unscreened_trunk_group_origination_attestation_level",
                "unscreenedTrunkGroupOriginationAttestationLevel",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupStirShakenGetResponse23(OCIResponse):
    """
    Response to the `GroupTrunkGroupStirShakenGetRequest23()`.

    Replaced by `GroupTrunkGroupStirShakenGetResponse23V2()`.

    Attributes:
        use_parent_level_settings (bool): useParentLevelSettings
        signing_policy (str): signingPolicy
        tagging_policy (str): taggingPolicy
        signing_service_url (str): signingServiceURL *Optional*
        tag_from_or_pai (str): tagFromOrPAI
        verstat_tag (str): verstatTag
        use_os_value_for_orig_id (bool): useOSValueForOrigId
        orig_uuid (str): origUUID *Optional*
        attestation_level (str): attestationLevel
        enable_signing_for_unscreened_trunk_group_originations (bool):
            enableSigningForUnscreenedTrunkGroupOriginations
        enable_tagging_for_unscreened_trunk_group_originations (bool):
            enableTaggingForUnscreenedTrunkGroupOriginations
        unscreened_trunk_group_origination_attestation_level (str):
            unscreenedTrunkGroupOriginationAttestationLevel
        check_directory_numbers_for_attestation (bool):
            checkDirectoryNumbersForAttestation
        match_unassigned_numbers_only (bool): matchUnassignedNumbersOnly
    """

    __slots__: List[str] = [
        "use_parent_level_settings",
        "signing_policy",
        "tagging_policy",
        "signing_service_url",
        "tag_from_or_pai",
        "verstat_tag",
        "use_os_value_for_orig_id",
        "orig_uuid",
        "attestation_level",
        "enable_signing_for_unscreened_trunk_group_originations",
        "enable_tagging_for_unscreened_trunk_group_originations",
        "unscreened_trunk_group_origination_attestation_level",
        "check_directory_numbers_for_attestation",
        "match_unassigned_numbers_only",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_parent_level_settings",
                "useParentLevelSettings",
                bool,
                is_required=True,
            ),
            E(
                "signing_policy",
                "signingPolicy",
                str,
                is_required=True,
            ),
            E(
                "tagging_policy",
                "taggingPolicy",
                str,
                is_required=True,
            ),
            E(
                "signing_service_url",
                "signingServiceURL",
                str,
            ),
            E(
                "tag_from_or_pai",
                "tagFromOrPAI",
                str,
                is_required=True,
            ),
            E(
                "verstat_tag",
                "verstatTag",
                str,
                is_required=True,
            ),
            E(
                "use_os_value_for_orig_id",
                "useOSValueForOrigId",
                bool,
                is_required=True,
            ),
            E(
                "orig_uuid",
                "origUUID",
                str,
            ),
            E(
                "attestation_level",
                "attestationLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_signing_for_unscreened_trunk_group_originations",
                "enableSigningForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "enable_tagging_for_unscreened_trunk_group_originations",
                "enableTaggingForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "unscreened_trunk_group_origination_attestation_level",
                "unscreenedTrunkGroupOriginationAttestationLevel",
                str,
                is_required=True,
            ),
            E(
                "check_directory_numbers_for_attestation",
                "checkDirectoryNumbersForAttestation",
                bool,
                is_required=True,
            ),
            E(
                "match_unassigned_numbers_only",
                "matchUnassignedNumbersOnly",
                bool,
                is_required=True,
            ),
        )


class GroupTrunkGroupStirShakenGetResponse23V2(OCIResponse):
    """
    Response to the `GroupTrunkGroupStirShakenGetRequest23V2()`.


    Attributes:
        use_parent_level_settings (bool): useParentLevelSettings
        signing_policy (str): signingPolicy
        tagging_policy (str): taggingPolicy
        signing_service_url (str): signingServiceURL *Optional*
        tag_from_or_pai (str): tagFromOrPAI
        verstat_tag (str): verstatTag
        use_os_value_for_orig_id (bool): useOSValueForOrigId
        orig_uuid (str): origUUID *Optional*
        attestation_level (str): attestationLevel
        enable_signing_for_unscreened_trunk_group_originations (bool):
            enableSigningForUnscreenedTrunkGroupOriginations
        enable_tagging_for_unscreened_trunk_group_originations (bool):
            enableTaggingForUnscreenedTrunkGroupOriginations
        unscreened_trunk_group_origination_attestation_level (str):
            unscreenedTrunkGroupOriginationAttestationLevel
        check_directory_numbers_for_attestation (bool):
            checkDirectoryNumbersForAttestation
        match_unassigned_numbers_only (bool): matchUnassignedNumbersOnly
        enable_tagging_for_redirected_calls (bool): enableTaggingForRedirectedCalls
    """

    __slots__: List[str] = [
        "use_parent_level_settings",
        "signing_policy",
        "tagging_policy",
        "signing_service_url",
        "tag_from_or_pai",
        "verstat_tag",
        "use_os_value_for_orig_id",
        "orig_uuid",
        "attestation_level",
        "enable_signing_for_unscreened_trunk_group_originations",
        "enable_tagging_for_unscreened_trunk_group_originations",
        "unscreened_trunk_group_origination_attestation_level",
        "check_directory_numbers_for_attestation",
        "match_unassigned_numbers_only",
        "enable_tagging_for_redirected_calls",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_parent_level_settings",
                "useParentLevelSettings",
                bool,
                is_required=True,
            ),
            E(
                "signing_policy",
                "signingPolicy",
                str,
                is_required=True,
            ),
            E(
                "tagging_policy",
                "taggingPolicy",
                str,
                is_required=True,
            ),
            E(
                "signing_service_url",
                "signingServiceURL",
                str,
            ),
            E(
                "tag_from_or_pai",
                "tagFromOrPAI",
                str,
                is_required=True,
            ),
            E(
                "verstat_tag",
                "verstatTag",
                str,
                is_required=True,
            ),
            E(
                "use_os_value_for_orig_id",
                "useOSValueForOrigId",
                bool,
                is_required=True,
            ),
            E(
                "orig_uuid",
                "origUUID",
                str,
            ),
            E(
                "attestation_level",
                "attestationLevel",
                str,
                is_required=True,
            ),
            E(
                "enable_signing_for_unscreened_trunk_group_originations",
                "enableSigningForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "enable_tagging_for_unscreened_trunk_group_originations",
                "enableTaggingForUnscreenedTrunkGroupOriginations",
                bool,
                is_required=True,
            ),
            E(
                "unscreened_trunk_group_origination_attestation_level",
                "unscreenedTrunkGroupOriginationAttestationLevel",
                str,
                is_required=True,
            ),
            E(
                "check_directory_numbers_for_attestation",
                "checkDirectoryNumbersForAttestation",
                bool,
                is_required=True,
            ),
            E(
                "match_unassigned_numbers_only",
                "matchUnassignedNumbersOnly",
                bool,
                is_required=True,
            ),
            E(
                "enable_tagging_for_redirected_calls",
                "enableTaggingForRedirectedCalls",
                bool,
                is_required=True,
            ),
        )


class GroupTrunkGroupUserCreationTaskGetListResponse(OCIResponse):
    """
    Response to `GroupTrunkGroupUserCreationTaskGetListRequest()`.

    Contains a table with a row for each user creation task and column headings : "Name",
    "Status", "Users Created", "Total Users To Create", "Error Count".

    Attributes:
        task_table (List(taskTable)): taskTable - *Table* array of taskTable named tuples
    """

    __slots__: List[str] = [
        "task_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "task_table",
                "taskTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupTrunkGroupUserCreationTaskGetListResponse14sp4(OCIResponse):
    """
    Response to `GroupTrunkGroupUserCreationTaskGetListRequest14sp4()`.

    Contains a table with a row for each user creation task and column headings : "Name",
    "Status", "Users Created", "Total Users To Create", "Error Count".

    Attributes:
        task_table (List(taskTable)): taskTable - *Table* array of taskTable named tuples
    """

    __slots__: List[str] = [
        "task_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "task_table",
                "taskTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupTrunkGroupUserCreationTaskGetResponse(OCIResponse):
    """
    Response to a `GroupTrunkGroupUserCreationTaskGetRequest()`.


    Attributes:
        user_id_format (str): userIdFormat
        user_id_domain (str): userIdDomain
        populate_extension (bool): populateExtension
        line_port_format (str): linePortFormat
        line_port_domain (str): linePortDomain
        populate_contact (bool): populateContact
        contact_format (str): contactFormat *Optional*
        contact_domain (str): contactDomain *Optional*
        users_created (int): usersCreated
        total_users_to_create (int): totalUsersToCreate
        error_count (int): errorCount
        service_pack_name (List[str]): servicePackName *Optional*
        user_service_name (List[str]): userServiceName *Optional*
        status (str): status
        user_creation_mode (str): userCreationMode
        task_summary (str): taskSummary
    """

    __slots__: List[str] = [
        "user_id_format",
        "user_id_domain",
        "populate_extension",
        "line_port_format",
        "line_port_domain",
        "populate_contact",
        "contact_format",
        "contact_domain",
        "users_created",
        "total_users_to_create",
        "error_count",
        "service_pack_name",
        "user_service_name",
        "status",
        "user_creation_mode",
        "task_summary",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id_format",
                "userIdFormat",
                str,
                is_required=True,
            ),
            E(
                "user_id_domain",
                "userIdDomain",
                str,
                is_required=True,
            ),
            E(
                "populate_extension",
                "populateExtension",
                bool,
                is_required=True,
            ),
            E(
                "line_port_format",
                "linePortFormat",
                str,
                is_required=True,
            ),
            E(
                "line_port_domain",
                "linePortDomain",
                str,
                is_required=True,
            ),
            E(
                "populate_contact",
                "populateContact",
                bool,
                is_required=True,
            ),
            E(
                "contact_format",
                "contactFormat",
                str,
            ),
            E(
                "contact_domain",
                "contactDomain",
                str,
            ),
            E(
                "users_created",
                "usersCreated",
                int,
                is_required=True,
            ),
            E(
                "total_users_to_create",
                "totalUsersToCreate",
                int,
                is_required=True,
            ),
            E(
                "error_count",
                "errorCount",
                int,
                is_required=True,
            ),
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_array=True,
            ),
            E(
                "user_service_name",
                "userServiceName",
                str,
                is_array=True,
            ),
            E(
                "status",
                "status",
                str,
                is_required=True,
            ),
            E(
                "user_creation_mode",
                "userCreationMode",
                str,
                is_required=True,
            ),
            E(
                "task_summary",
                "taskSummary",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupUserCreationTaskGetResponse14sp4(OCIResponse):
    """
    Response to a `GroupTrunkGroupUserCreationTaskGetRequest14sp4()`.


    Attributes:
        user_id_format (str): userIdFormat
        user_id_domain (str): userIdDomain
        populate_extension (bool): populateExtension
        line_port_format (str): linePortFormat
        line_port_domain (str): linePortDomain
        populate_contact (bool): populateContact
        contact_format (str): contactFormat *Optional*
        contact_domain (str): contactDomain *Optional*
        users_created (int): usersCreated
        total_users_to_create (int): totalUsersToCreate
        error_count (int): errorCount
        service_pack_name (List[str]): servicePackName *Optional*
        user_service_name (List[str]): userServiceName *Optional*
        status (str): status
        user_creation_mode (str): userCreationMode
        task_summary (str): taskSummary
        report_file_key (str): reportFileKey
    """

    __slots__: List[str] = [
        "user_id_format",
        "user_id_domain",
        "populate_extension",
        "line_port_format",
        "line_port_domain",
        "populate_contact",
        "contact_format",
        "contact_domain",
        "users_created",
        "total_users_to_create",
        "error_count",
        "service_pack_name",
        "user_service_name",
        "status",
        "user_creation_mode",
        "task_summary",
        "report_file_key",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id_format",
                "userIdFormat",
                str,
                is_required=True,
            ),
            E(
                "user_id_domain",
                "userIdDomain",
                str,
                is_required=True,
            ),
            E(
                "populate_extension",
                "populateExtension",
                bool,
                is_required=True,
            ),
            E(
                "line_port_format",
                "linePortFormat",
                str,
                is_required=True,
            ),
            E(
                "line_port_domain",
                "linePortDomain",
                str,
                is_required=True,
            ),
            E(
                "populate_contact",
                "populateContact",
                bool,
                is_required=True,
            ),
            E(
                "contact_format",
                "contactFormat",
                str,
            ),
            E(
                "contact_domain",
                "contactDomain",
                str,
            ),
            E(
                "users_created",
                "usersCreated",
                int,
                is_required=True,
            ),
            E(
                "total_users_to_create",
                "totalUsersToCreate",
                int,
                is_required=True,
            ),
            E(
                "error_count",
                "errorCount",
                int,
                is_required=True,
            ),
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_array=True,
            ),
            E(
                "user_service_name",
                "userServiceName",
                str,
                is_array=True,
            ),
            E(
                "status",
                "status",
                str,
                is_required=True,
            ),
            E(
                "user_creation_mode",
                "userCreationMode",
                str,
                is_required=True,
            ),
            E(
                "task_summary",
                "taskSummary",
                str,
                is_required=True,
            ),
            E(
                "report_file_key",
                "reportFileKey",
                str,
                is_required=True,
            ),
        )


class GroupUserCallForwardingSettingsGetListResponse(OCIResponse):
    """
    Response to the `GroupUserCallForwardingSettingsGetListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department", "In
    Trunk Group", "Email Address", "Is Active", "Forwarding Address". "Is Active" is
    "true" or "false". The "Forwarding Address" is the Call Forwarding service's
    forwarding address.  If the service is Call Forwarding Selective, the default
    forwarding address is returned.  "Phone Number" is presented in the E164 format.

    Attributes:
        user_call_forwarding_table (List(userCallForwardingTable)):
            userCallForwardingTable - *Table* array of userCallForwardingTable named
            tuples
    """

    __slots__: List[str] = [
        "user_call_forwarding_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_call_forwarding_table",
                "userCallForwardingTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupUserCallWaitingSettingsGetListResponse(OCIResponse):
    """
    Response to the `GroupUserCallWaitingSettingsGetListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department", "In
    Trunk Group", "Email Address", "Is Active". "Is Active" is "true" or "false". "Phone
    Number" is presented in the E164 format.

    Attributes:
        user_call_waiting_table (List(userCallWaitingTable)): userCallWaitingTable -
            *Table* array of userCallWaitingTable named tuples
    """

    __slots__: List[str] = [
        "user_call_waiting_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_call_waiting_table",
                "userCallWaitingTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupUserCallingPlanSettingsGetListResponse(OCIResponse):
    """
    Response to the `GroupUserCallingPlanSettingsGetListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department", "In
    Trunk Group", "Email Address", "Use Custom Settings". "Use Custom Settings" is "true"
    or "false". "Phone Number" is presented in the E164 format.

    Attributes:
        user_calling_plan_table (List(userCallingPlanTable)): userCallingPlanTable -
            *Table* array of userCallingPlanTable named tuples
    """

    __slots__: List[str] = [
        "user_calling_plan_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_calling_plan_table",
                "userCallingPlanTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupUserHotelingGuestSettingsGetListResponse(OCIResponse):
    """
    Response to the `GroupUserHotelingGuestSettingsGetListRequest()`.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department", "In
    Trunk Group", "Email Address", "Is Active". "Is Active" is "true" or "false". "Phone
    Number" is presented in the E164 format.

    Attributes:
        user_hoteling_guest_table (List(userHotelingGuestTable)): userHotelingGuestTable -
            *Table* array of userHotelingGuestTable named tuples
    """

    __slots__: List[str] = [
        "user_hoteling_guest_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_hoteling_guest_table",
                "userHotelingGuestTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupVirtualOnNetEnterpriseExtensionsGetUserListResponse(OCIResponse):
    """
    Response to `GroupVirtualOnNetEnterpriseExtensionsGetUserListRequest()`.

    Contains a table with column headings: "Last Name", "First Name", "Phone Number",
    "Extension", "Virtual On-Net Call Type Name" in a row for each user.

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupVirtualOnNetEnterpriseExtensionsGetUserResponse(OCIResponse):
    """
    Response to `GroupVirtualOnNetEnterpriseExtensionsGetUserRequest()`.


    Attributes:
        extension (str): extension
        first_name (str): firstName
        last_name (str): lastName
        calling_line_id_first_name (str): callingLineIdFirstName
        calling_line_id_last_name (str): callingLineIdLastName
        virtual_on_net_call_type_name (str): virtualOnNetCallTypeName
    """

    __slots__: List[str] = [
        "extension",
        "first_name",
        "last_name",
        "calling_line_id_first_name",
        "calling_line_id_last_name",
        "virtual_on_net_call_type_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "extension",
                "extension",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
                is_required=True,
            ),
            E(
                "last_name",
                "lastName",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_first_name",
                "callingLineIdFirstName",
                str,
                is_required=True,
            ),
            E(
                "calling_line_id_last_name",
                "callingLineIdLastName",
                str,
                is_required=True,
            ),
            E(
                "virtual_on_net_call_type_name",
                "virtualOnNetCallTypeName",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetPasscodeRulesResponse(OCIResponse):
    """
    Response to `GroupVoiceMessagingGroupGetPasscodeRulesRequest()`.

    Contains the group's voice portal passcode rules setting.

    Replaced By: `GroupPortalPasscodeRulesGetResponse()`

    Attributes:
        use_rule_level (str): useRuleLevel
        disallow_repeated_digits (bool): disallowRepeatedDigits
        disallow_user_number (bool): disallowUserNumber
        disallow_reversed_user_number (bool): disallowReversedUserNumber
        disallow_old_passcode (bool): disallowOldPasscode
        disallow_reversed_old_passcode (bool): disallowReversedOldPasscode
        min_code_length (int): minCodeLength
        max_code_length (int): maxCodeLength
        disable_login_after_max_failed_login_attempts (bool):
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        expire_password (bool): expirePassword
        passcode_expires_days (int): passcodeExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
    """

    __slots__: List[str] = [
        "use_rule_level",
        "disallow_repeated_digits",
        "disallow_user_number",
        "disallow_reversed_user_number",
        "disallow_old_passcode",
        "disallow_reversed_old_passcode",
        "min_code_length",
        "max_code_length",
        "disable_login_after_max_failed_login_attempts",
        "max_failed_login_attempts",
        "expire_password",
        "passcode_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_rule_level",
                "useRuleLevel",
                str,
                is_required=True,
            ),
            E(
                "disallow_repeated_digits",
                "disallowRepeatedDigits",
                bool,
                is_required=True,
            ),
            E(
                "disallow_user_number",
                "disallowUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_user_number",
                "disallowReversedUserNumber",
                bool,
                is_required=True,
            ),
            E(
                "disallow_old_passcode",
                "disallowOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "disallow_reversed_old_passcode",
                "disallowReversedOldPasscode",
                bool,
                is_required=True,
            ),
            E(
                "min_code_length",
                "minCodeLength",
                int,
                is_required=True,
            ),
            E(
                "max_code_length",
                "maxCodeLength",
                int,
                is_required=True,
            ),
            E(
                "disable_login_after_max_failed_login_attempts",
                "disableLoginAfterMaxFailedLoginAttempts",
                bool,
                is_required=True,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "expire_password",
                "expirePassword",
                bool,
                is_required=True,
            ),
            E(
                "passcode_expires_days",
                "passcodeExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
                is_required=True,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
        )


class GroupVoiceMessagingGroupGetResponse(OCIResponse):
    """
    Response to `GroupVoiceMessagingGroupGetRequest()`.

    Contains the group's voice messaging settings.

    Attributes:
        use_mail_server_setting (str): useMailServerSetting
        warn_caller_before_recording_voice_message (bool):
            warnCallerBeforeRecordingVoiceMessage
        allow_users_configuring_advanced_settings (bool):
            allowUsersConfiguringAdvancedSettings
        allow_compose_or_forward_message_to_entire_group (bool):
            allowComposeOrForwardMessageToEntireGroup
        mail_server_net_address (str): mailServerNetAddress *Optional*
        mail_server_protocol (str): mailServerProtocol
        real_delete_for_imap (bool): realDeleteForImap
        max_mailbox_length_minutes (int): maxMailboxLengthMinutes
        does_message_age (bool): doesMessageAge
        hold_period_days (int): holdPeriodDays
    """

    __slots__: List[str] = [
        "use_mail_server_setting",
        "warn_caller_before_recording_voice_message",
        "allow_users_configuring_advanced_settings",
        "allow_compose_or_forward_message_to_entire_group",
        "mail_server_net_address",
        "mail_server_protocol",
        "real_delete_for_imap",
        "max_mailbox_length_minutes",
        "does_message_age",
        "hold_period_days",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "use_mail_server_setting",
                "useMailServerSetting",
                str,
                is_required=True,
            ),
            E(
                "warn_caller_before_recording_voice_message",
                "warnCallerBeforeRecordingVoiceMessage",
                bool,
                is_required=True,
            ),
            E(
                "allow_users_configuring_advanced_settings",
                "allowUsersConfiguringAdvancedSettings",
                bool,
                is_required=True,
            ),
            E(
                "allow_compose_or_forward_message_to_entire_group",
                "allowComposeOrForwardMessageToEntireGroup",
                bool,
                is_required=True,
            ),
            E(
                "mail_server_net_address",
                "mailServerNetAddress",
                str,
            ),
            E(
                "mail_server_protocol",
                "mailServerProtocol",
                str,
                is_required=True,
            ),
            E(
                "real_delete_for_imap",
                "realDeleteForImap",
                bool,
                is_required=True,
            ),
            E(
                "max_mailbox_length_minutes",
                "maxMailboxLengthMinutes",
                int,
                is_required=True,
            ),
            E(
                "does_message_age",
                "doesMessageAge",
                bool,
                is_required=True,
            ),
            E(
                "hold_period_days",
                "holdPeriodDays",
                int,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalBrandingResponse(OCIResponse):
    """
    Response to the `GroupVoiceMessagingGroupGetVoicePortalBrandingRequest()`.

    Replaced By: `GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16()`

    Attributes:
        voice_portal_greeting_selection (str): voicePortalGreetingSelection
        voice_portal_greeting_file_description (str): voicePortalGreetingFileDescription
            *Optional*
        voice_messaging_greeting_selection (str): voiceMessagingGreetingSelection
        voice_messaging_greeting_file_description (str):
            voiceMessagingGreetingFileDescription *Optional*
    """

    __slots__: List[str] = [
        "voice_portal_greeting_selection",
        "voice_portal_greeting_file_description",
        "voice_messaging_greeting_selection",
        "voice_messaging_greeting_file_description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "voice_portal_greeting_selection",
                "voicePortalGreetingSelection",
                str,
                is_required=True,
            ),
            E(
                "voice_portal_greeting_file_description",
                "voicePortalGreetingFileDescription",
                str,
            ),
            E(
                "voice_messaging_greeting_selection",
                "voiceMessagingGreetingSelection",
                str,
                is_required=True,
            ),
            E(
                "voice_messaging_greeting_file_description",
                "voiceMessagingGreetingFileDescription",
                str,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16(OCIResponse):
    """
    Response to the `GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16()`.

    Replaced by: `GroupVoiceMessagingGroupGetVoicePortalBrandingResponse20()` in AS data
    mode

    Attributes:
        voice_portal_greeting_selection (str): voicePortalGreetingSelection
        voice_portal_greeting_file_description (str): voicePortalGreetingFileDescription
            *Optional*
        voice_portal_greeting_media_type (str): voicePortalGreetingMediaType *Optional*
        voice_messaging_greeting_selection (str): voiceMessagingGreetingSelection
        voice_messaging_greeting_file_description (str):
            voiceMessagingGreetingFileDescription *Optional*
        voice_messaging_greeting_media_type (str): voiceMessagingGreetingMediaType
            *Optional*
    """

    __slots__: List[str] = [
        "voice_portal_greeting_selection",
        "voice_portal_greeting_file_description",
        "voice_portal_greeting_media_type",
        "voice_messaging_greeting_selection",
        "voice_messaging_greeting_file_description",
        "voice_messaging_greeting_media_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "voice_portal_greeting_selection",
                "voicePortalGreetingSelection",
                str,
                is_required=True,
            ),
            E(
                "voice_portal_greeting_file_description",
                "voicePortalGreetingFileDescription",
                str,
            ),
            E(
                "voice_portal_greeting_media_type",
                "voicePortalGreetingMediaType",
                str,
            ),
            E(
                "voice_messaging_greeting_selection",
                "voiceMessagingGreetingSelection",
                str,
                is_required=True,
            ),
            E(
                "voice_messaging_greeting_file_description",
                "voiceMessagingGreetingFileDescription",
                str,
            ),
            E(
                "voice_messaging_greeting_media_type",
                "voiceMessagingGreetingMediaType",
                str,
            ),
        )


class GroupVoiceXmlGetInstanceListResponse(OCIResponse):
    """
    Response to the `GroupVoiceXmlGetInstanceListRequest()`.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active" and "Is Webex Meeting Callback". The column
    values for "Is Active" can either be true, or false.

    Attributes:
        voice_xml_table (List(voiceXmlTable)): voiceXmlTable - *Table* array of
            voiceXmlTable named tuples
    """

    __slots__: List[str] = [
        "voice_xml_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "voice_xml_table",
                "voiceXmlTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupXsiPolicyProfileGetAssignedListResponse(OCIResponse):
    """
    Response to `GroupXsiPolicyProfileGetAssignedListRequest()`.

    Contains a table of all Xsi Policy Profile assigned to.  The column headings are:
    "Name", "Level", "Description" and "Default".

    Attributes:
        assigned_table (List(assignedTable)): assignedTable - *Table* array of
            assignedTable named tuples
    """

    __slots__: List[str] = [
        "assigned_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "assigned_table",
                "assignedTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class GroupXsiPolicyProfileGetAssignedUserListResponse(OCIResponse):
    """
    Response to `GroupXsiPolicyProfileGetAssignedUserListRequest()`.

    Contains a table of user that have the user Xsi Policy Profile assigned.  The column
    headings are: "User Id", "Last Name", "First Name", "Phone Number" "Department" and
    "Extension".

    Attributes:
        user_table (List(userTable)): userTable - *Table* array of userTable named tuples
    """

    __slots__: List[str] = [
        "user_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_table",
                "userTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class LoginResponse13mp10(OCIResponse):
    """
    `LoginRequest13mp10()`/Response13mp10 is 2nd stage of the 2 stage OCI login process.


    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
        )


class LoginResponse14sp4(OCIResponse):
    """
    `LoginRequest14sp4()`/Response14sp4 is 2nd stage of the 2 stage OCI login process.


    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        user_domain (str): userDomain
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "user_domain",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "user_domain",
                "userDomain",
                str,
                is_required=True,
            ),
        )


class LoginResponse21sp1(OCIResponse):
    """
    `LoginRequest21sp1()`/Response21sp1 is 2nd stage of the 2 stage OCI login process.

    The parameter tokenRevocationTime is represented in the number of milliseconds since
    January 1, 1970, 00:00:00 GMT, and it is set to the more current time between the
    system level token revocation time and user level token revocation time.  Replaced by
    `LoginResponse22V3()` in AS data mode.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        user_domain (str): userDomain
        token_revocation_time (int): tokenRevocationTime *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "user_domain",
        "token_revocation_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "user_domain",
                "userDomain",
                str,
                is_required=True,
            ),
            E(
                "token_revocation_time",
                "tokenRevocationTime",
                int,
            ),
        )


class LoginResponse22(OCIResponse):
    """
    Response to the OCI login request.

    Replaced by `LoginResponse22V2()` in AS data mode.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        user_domain (str): userDomain
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "user_domain",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "user_domain",
                "userDomain",
                str,
                is_required=True,
            ),
        )


class LoginResponse22V2(OCIResponse):
    """
    Response to the OCI login request.

    Replaced by `LoginResponse22V3()` in AS data mode.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        user_domain (str): userDomain
        reseller_id (str): resellerId *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "user_domain",
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "user_domain",
                "userDomain",
                str,
                is_required=True,
            ),
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
        )


class LoginResponse22V3(OCIResponse):
    """
    Response to the OCI login request.

    The following data elements are only returned in AS data mode: resellerId
    tokenRevocationTime The parameter tokenRevocationTime is represented in the number of
    milliseconds since January 1, 1970, 00:00:00 GMT, and it is set to the more current
    time between the system level token revocation time and user level token revocation
    time.  Replaced by `LoginRequest22V4()` in AS data mode.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        user_domain (str): userDomain
        reseller_id (str): resellerId *Optional*
        token_revocation_time (int): tokenRevocationTime *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "user_domain",
        "reseller_id",
        "token_revocation_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "user_domain",
                "userDomain",
                str,
                is_required=True,
            ),
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "token_revocation_time",
                "tokenRevocationTime",
                int,
            ),
        )


class LoginResponse22V4(OCIResponse):
    """
    Response to the OCI login request.

    Replaced by: `LoginResponse22V5()`. The following data elements are only returned in
    AS data mode: resellerId The parameter tokenRevocationTime is represented in the
    number of milliseconds since January 1, 1970, 00:00:00 GMT, and it is set to the more
    current time between the system level token revocation time and user level token
    revocation time.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        user_domain (str): userDomain
        reseller_id (str): resellerId *Optional*
        token_revocation_time (int): tokenRevocationTime *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "user_domain",
        "reseller_id",
        "token_revocation_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "user_domain",
                "userDomain",
                str,
                is_required=True,
            ),
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "token_revocation_time",
                "tokenRevocationTime",
                int,
            ),
        )


class LoginResponse22V5(OCIResponse):
    """
    Response to the OCI login request.

    The following data elements are only returned in AS data mode: resellerId The
    parameter tokenRevocationTime is represented in the number of milliseconds since
    January 1, 1970, 00:00:00 GMT, and it is set to the more current time between the
    system level token revocation time and user level token revocation time.

    Attributes:
        login_type (str): loginType
        locale (str): locale
        encoding (str): encoding
        group_id (str): groupId *Optional*
        service_provider_id (str): serviceProviderId *Optional*
        is_enterprise (bool): isEnterprise
        password_expires_days (int): passwordExpiresDays *Optional*
        user_domain (str): userDomain
        reseller_id (str): resellerId *Optional*
        token_revocation_time (int): tokenRevocationTime *Optional*
    """

    __slots__: List[str] = [
        "login_type",
        "locale",
        "encoding",
        "group_id",
        "service_provider_id",
        "is_enterprise",
        "password_expires_days",
        "user_domain",
        "reseller_id",
        "token_revocation_time",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "login_type",
                "loginType",
                str,
                is_required=True,
            ),
            E(
                "locale",
                "locale",
                str,
                is_required=True,
            ),
            E(
                "encoding",
                "encoding",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "is_enterprise",
                "isEnterprise",
                bool,
                is_required=True,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "user_domain",
                "userDomain",
                str,
                is_required=True,
            ),
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "token_revocation_time",
                "tokenRevocationTime",
                int,
            ),
        )


class PasswordGenerateResponse(OCIResponse):
    """
    Response to the `PasswordGenerateRequest()`.

    The response contains the requested passwords.

    Attributes:
        system_administrator_password (str): systemAdministratorPassword *Optional*
        service_provider_administrator_password (str):
            serviceProviderAdministratorPassword *Optional*
        group_administrator_password (str): groupAdministratorPassword *Optional*
        user_password (str): userPassword *Optional*
        user_passcode (str): userPasscode *Optional*
        user_sip_authentication_password (str): userSIPAuthenticationPassword *Optional*
        access_device_authentication_password (str): accessDeviceAuthenticationPassword
            *Optional*
        trunk_group_authentication_password (str): trunkGroupAuthenticationPassword
            *Optional*
    """

    __slots__: List[str] = [
        "system_administrator_password",
        "service_provider_administrator_password",
        "group_administrator_password",
        "user_password",
        "user_passcode",
        "user_sip_authentication_password",
        "access_device_authentication_password",
        "trunk_group_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "system_administrator_password",
                "systemAdministratorPassword",
                str,
            ),
            E(
                "service_provider_administrator_password",
                "serviceProviderAdministratorPassword",
                str,
            ),
            E(
                "group_administrator_password",
                "groupAdministratorPassword",
                str,
            ),
            E(
                "user_password",
                "userPassword",
                str,
            ),
            E(
                "user_passcode",
                "userPasscode",
                str,
            ),
            E(
                "user_sip_authentication_password",
                "userSIPAuthenticationPassword",
                str,
            ),
            E(
                "access_device_authentication_password",
                "accessDeviceAuthenticationPassword",
                str,
            ),
            E(
                "trunk_group_authentication_password",
                "trunkGroupAuthenticationPassword",
                str,
            ),
        )


class PublicClusterGetFullyQualifiedDomainNameResponse(OCIResponse):
    """
    Response to `PublicClusterGetFullyQualifiedDomainNameRequest()`.


    Attributes:
        public_cluster_fqdn (str): publicClusterFQDN *Optional*
    """

    __slots__: List[str] = [
        "public_cluster_fqdn",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "public_cluster_fqdn",
                "publicClusterFQDN",
                str,
            ),
        )


class ResellerAdminAlternateIdGetListResponse(OCIResponse):
    """
    Response to `ResellerAdminAlternateIdGetListRequest()`.

    Contains a table of the main admin user id and the alternate admin user ids, the
    column headings are: "User Id", "Description", "Alternate". The possible values for
    "Alternate" are "true" and "false". The "Description" is only present for alternate
    admin user Ids.

    Attributes:
        admin_user_id_table (List(adminUserIdTable)): adminUserIdTable - *Table* array of
            adminUserIdTable named tuples
    """

    __slots__: List[str] = [
        "admin_user_id_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "admin_user_id_table",
                "adminUserIdTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class ResellerAdminGetListResponse(OCIResponse):
    """
    Response to `ResellerAdminGetListRequest()`.

    Contains a 4 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Language".

    Attributes:
        reseller_admin_table (List(resellerAdminTable)): resellerAdminTable - *Table*
            array of resellerAdminTable named tuples
    """

    __slots__: List[str] = [
        "reseller_admin_table",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_admin_table",
                "resellerAdminTable",
                list,
                is_complex=True,
                is_required=True,
                is_table=True,
            ),
        )


class ResellerAdminGetResponse(OCIResponse):
    """
    Response to the `ResellerAdminGetRequest()`.

    The response contains the reseller administrators profile information.  Replaced by
    `ResellerAdminGetResponse22()`

    Attributes:
        reseller_id (str): resellerId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        language (str): language
    """

    __slots__: List[str] = [
        "reseller_id",
        "first_name",
        "last_name",
        "language",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
        )


class ResellerAdminGetResponse22(OCIResponse):
    """
    Response to the `ResellerAdminGetRequest22()`.

    The response contains the reseller administrators profile information.  Replac