"""Broadworks OCI-P Interface Request Classes"""

# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2024-03-25T14:43:17.025184
from typing import List
from typing import Tuple

import broadworks_ocip.types as OCI
from .base import ElementInfo as E
from .base import OCIRequest


class AuthenticationRequest(OCIRequest):
    """
    `AuthenticationRequest()` is 1st stage of the 2 stage OCI login process.


    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class AuthenticationVerifyRequest(OCIRequest):
    """
    `AuthenticationVerifyRequest()` is used to authenticate a user using the user Id and
    password.

    The response is a `AuthenticationVerifyResponse()` or an `ErrorResponse()`

    Replaced By: `AuthenticationVerifyRequest14sp8()`

    Attributes:
        user_id (str): userId
        password (str): password
    """

    __slots__: List[str] = [
        "user_id",
        "password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
                is_required=True,
            ),
        )


class AuthenticationVerifyRequest14sp8(OCIRequest):
    """
    `AuthenticationVerifyRequest14sp8()` is used to authenticate a user either by
    userId/password, userId/sip username/sip password, dn/passcode or a token previously
    authorized with the `ExternalAuthenticationAuthorizeTokenRequest()`.

    The phone number may be any DN associated with a user.

    The response is a `AuthenticationVerifyResponse14sp8()` or an `ErrorResponse()`
    Replaced by `AuthenticationVerifyRequest22()`.

    Attributes:
        user_id (str): userId *Optional*
        password (str): password *Optional*
        phone_number (str): phoneNumber *Optional*
        passcode (str): passcode *Optional*
        login_token (str): loginToken *Optional*
        sip_authentication_user_name (str): sipAuthenticationUserName *Optional*
        sip_authentication_password (str): sipAuthenticationPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "phone_number",
        "passcode",
        "login_token",
        "sip_authentication_user_name",
        "sip_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "login_token",
                "loginToken",
                str,
            ),
            E(
                "sip_authentication_user_name",
                "sipAuthenticationUserName",
                str,
            ),
            E(
                "sip_authentication_password",
                "sipAuthenticationPassword",
                str,
            ),
        )


class AuthenticationVerifyRequest21sp1(OCIRequest):
    """
    `AuthenticationVerifyRequest21sp1()` is used to authenticate a user either by
    userId/password, userId/sip username/sip password, dn/passcode, lineport/password or a
    token previously authorized with the `ExternalAuthenticationAuthorizeTokenRequest()`.

    The phone number may be any DN associated with a user.  The lineport may be any
    lineport associated with a user.  The password used for the lineport is the user's
    password associated with userId.

    The response is a `AuthenticationVerifyResponse21sp1()` or an `ErrorResponse()`
    Replaced by `AuthenticationVerifyRequest22V2()`.

    Attributes:
        user_id (str): userId *Optional*
        password (str): password *Optional*
        phone_number (str): phoneNumber *Optional*
        passcode (str): passcode *Optional*
        line_port (str): linePort *Optional*
        login_token (str): loginToken *Optional*
        sip_authentication_user_name (str): sipAuthenticationUserName *Optional*
        sip_authentication_password (str): sipAuthenticationPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "phone_number",
        "passcode",
        "line_port",
        "login_token",
        "sip_authentication_user_name",
        "sip_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "login_token",
                "loginToken",
                str,
            ),
            E(
                "sip_authentication_user_name",
                "sipAuthenticationUserName",
                str,
            ),
            E(
                "sip_authentication_password",
                "sipAuthenticationPassword",
                str,
            ),
        )


class AuthenticationVerifyRequest22(OCIRequest):
    """
    `AuthenticationVerifyRequest22()` is used to authenticate a user either by
    userId/password, userId/sip username/sip password, dn/passcode, lineport/password or a
    token previously authorized with the `ExternalAuthenticationAuthorizeTokenRequest()`.

    The phone number may be any DN associated with a user.  The lineport may be any
    lineport associated with a user.  The password used for the lineport is the user's
    password associated with userId.

    The response is a `AuthenticationVerifyResponse22()` or an `ErrorResponse()` Replaced
    by `AuthenticationVerifyRequest22V2()`.

    Attributes:
        user_id (str): userId *Optional*
        password (str): password *Optional*
        phone_number (str): phoneNumber *Optional*
        passcode (str): passcode *Optional*
        line_port (str): linePort *Optional*
        login_token (str): loginToken *Optional*
        sip_authentication_user_name (str): sipAuthenticationUserName *Optional*
        sip_authentication_password (str): sipAuthenticationPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "phone_number",
        "passcode",
        "line_port",
        "login_token",
        "sip_authentication_user_name",
        "sip_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "login_token",
                "loginToken",
                str,
            ),
            E(
                "sip_authentication_user_name",
                "sipAuthenticationUserName",
                str,
            ),
            E(
                "sip_authentication_password",
                "sipAuthenticationPassword",
                str,
            ),
        )


class AuthenticationVerifyRequest22V2(OCIRequest):
    """
    `AuthenticationVerifyRequest22V2()` is used to authenticate a user either by
    userId/password, userId/sip username/sip password, dn/passcode, lineport/password or a
    token previously authorized with the `ExternalAuthenticationAuthorizeTokenRequest()`.

    The phone number may be any DN associated with a user.  The lineport may be any
    lineport associated with a user.  The password used for the lineport is the user's
    password associated with userId.

    The response is a `AuthenticationVerifyResponse22V2()` or an `ErrorResponse()`
    Replaced by `AuthenticationVerifyRequest22V3()`

    Attributes:
        user_id (str): userId *Optional*
        password (str): password *Optional*
        phone_number (str): phoneNumber *Optional*
        passcode (str): passcode *Optional*
        line_port (str): linePort *Optional*
        login_token (str): loginToken *Optional*
        sip_authentication_user_name (str): sipAuthenticationUserName *Optional*
        sip_authentication_password (str): sipAuthenticationPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "phone_number",
        "passcode",
        "line_port",
        "login_token",
        "sip_authentication_user_name",
        "sip_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "login_token",
                "loginToken",
                str,
            ),
            E(
                "sip_authentication_user_name",
                "sipAuthenticationUserName",
                str,
            ),
            E(
                "sip_authentication_password",
                "sipAuthenticationPassword",
                str,
            ),
        )


class AuthenticationVerifyRequest22V3(OCIRequest):
    """
    `AuthenticationVerifyRequest22V3()` is used to authenticate a user either by
    userId/password, userId/sip username/sip password, dn/passcode, lineport/password or a
    token previously authorized with the `ExternalAuthenticationAuthorizeTokenRequest()`.

    The phone number may be any DN associated with a user.  The lineport may be any
    lineport associated with a user.  The password used for the lineport is the user's
    password associated with userId.

    The response is a `AuthenticationVerifyResponse22V3()` or an `ErrorResponse()`
    Replaced by `AuthenticationVerifyRequest22V4()`.

    Attributes:
        user_id (str): userId *Optional*
        password (str): password *Optional*
        phone_number (str): phoneNumber *Optional*
        passcode (str): passcode *Optional*
        line_port (str): linePort *Optional*
        login_token (str): loginToken *Optional*
        sip_authentication_user_name (str): sipAuthenticationUserName *Optional*
        sip_authentication_password (str): sipAuthenticationPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "phone_number",
        "passcode",
        "line_port",
        "login_token",
        "sip_authentication_user_name",
        "sip_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "login_token",
                "loginToken",
                str,
            ),
            E(
                "sip_authentication_user_name",
                "sipAuthenticationUserName",
                str,
            ),
            E(
                "sip_authentication_password",
                "sipAuthenticationPassword",
                str,
            ),
        )


class AuthenticationVerifyRequest22V4(OCIRequest):
    """
    `AuthenticationVerifyRequest22V4()` is used to authenticate a user either by
    userId/password, userId/sip username/sip password, dn/passcode, lineport/password or a
    token previously authorized with the `ExternalAuthenticationAuthorizeTokenRequest()`.

    The phone number may be any DN associated with a user.  The lineport may be any
    lineport associated with a user.  The password used for the lineport is the user's
    password associated with userId.

    The response is a `AuthenticationVerifyResponse22V4()` or an `ErrorResponse()`

    Attributes:
        user_id (str): userId *Optional*
        password (str): password *Optional*
        phone_number (str): phoneNumber *Optional*
        passcode (str): passcode *Optional*
        line_port (str): linePort *Optional*
        login_token (str): loginToken *Optional*
        sip_authentication_user_name (str): sipAuthenticationUserName *Optional*
        sip_authentication_password (str): sipAuthenticationPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "phone_number",
        "passcode",
        "line_port",
        "login_token",
        "sip_authentication_user_name",
        "sip_authentication_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "passcode",
                "passcode",
                str,
            ),
            E(
                "line_port",
                "linePort",
                str,
            ),
            E(
                "login_token",
                "loginToken",
                str,
            ),
            E(
                "sip_authentication_user_name",
                "sipAuthenticationUserName",
                str,
            ),
            E(
                "sip_authentication_password",
                "sipAuthenticationPassword",
                str,
            ),
        )


class AvailabilityTestRequest(OCIRequest):
    """
    `AvailabilityTestRequest()` is for high-availability support.

    Response is either `SuccessResponse()` or `ErrorResponse()`.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class DeviceManagementFileAuthLocationGetRequest(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a `DeviceManagementFileAuthLocationGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetRequest17(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a `DeviceManagementFileAuthLocationGetResponse17()` or an
    `ErrorResponse()`. Replaced by: `DeviceManagementFileAuthLocationGetRequest18()`

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetRequest18(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a `DeviceManagementFileAuthLocationGetResponse18()` or an
    `ErrorResponse()`. Replaced by: `DeviceManagementFileAuthLocationGetRequest21()`.

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetRequest20sp1(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a `DeviceManagementFileAuthLocationGetResponse20sp1()` or an
    `ErrorResponse()`. Replaced by: `DeviceManagementFileAuthLocationGetRequest21sp1()`.

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetRequest21(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either `DeviceManagementFileAuthLocationGetResponse21()` or
    `ErrorResponse()`. The following elements are only used in AS data mode and will fail
    in XS data mode: deviceToken Replaced by:
    `DeviceManagementFileAuthLocationGetRequest21sp1()`.

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        device_token (str): deviceToken *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "device_token",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "device_token",
                "deviceToken",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetRequest21sp1(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either `DeviceManagementFileAuthLocationGetResponse21sp1()` or
    `ErrorResponse()`. The following elements are only used in AS data mode and will fail
    in XS data mode: deviceToken Replaced by
    `DeviceManagementFileAuthLocationGetRequest22()`

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        device_token (str): deviceToken *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "device_token",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "device_token",
                "deviceToken",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetRequest22(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either `DeviceManagementFileAuthLocationGetResponse22()` or
    `ErrorResponse()`. The following elements are only used in AS data mode and will fail
    in XS data mode: deviceToken

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        device_token (str): deviceToken *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "device_token",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "device_token",
                "deviceToken",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetRequest22V2(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either `DeviceManagementFileAuthLocationGetResponse22V2()` or
    `ErrorResponse()`. The following elements are only used in AS data mode and will fail
    in XS data mode: deviceToken The following elements are only used in XS data mode and
    will be ignored in AS data mode: fileNameLookup fileNameOnDisk

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        device_token (str): deviceToken *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
        file_name_lookup (bool): fileNameLookup *Optional*
        file_name_on_disk (str): fileNameOnDisk *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "device_token",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
        "file_name_lookup",
        "file_name_on_disk",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "device_token",
                "deviceToken",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
            E(
                "file_name_lookup",
                "fileNameLookup",
                bool,
            ),
            E(
                "file_name_on_disk",
                "fileNameOnDisk",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetRequest22V3(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either `DeviceManagementFileAuthLocationGetResponse22V3()` or
    `ErrorResponse()`. The following elements are only used in AS data mode and will fail
    in XS data mode: deviceToken The following elements are only used in XS data mode and
    will be ignored in AS data mode: fileNameLookup fileNameOnDisk

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        device_token (str): deviceToken *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
        file_name_lookup (bool): fileNameLookup *Optional*
        file_name_on_disk (str): fileNameOnDisk *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "device_token",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
        "file_name_lookup",
        "file_name_on_disk",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "device_token",
                "deviceToken",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
            E(
                "file_name_lookup",
                "fileNameLookup",
                bool,
            ),
            E(
                "file_name_on_disk",
                "fileNameOnDisk",
                str,
            ),
        )


class DeviceManagementFileAuthLocationGetRequest22V4(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either `DeviceManagementFileAuthLocationGetResponse22V4()` or
    `ErrorResponse()`. The following elements are only used in AS data mode and will fail
    in XS data mode: deviceToken The following elements are only used in XS data mode and
    will be ignored in AS data mode: fileNameLookup fileNameOnDisk

    Attributes:
        device_access_protocol (str): deviceAccessProtocol
        device_access_method (str): deviceAccessMethod
        device_access_uri (str): deviceAccessURI
        access_device_user_name (str): accessDeviceUserName *Optional*
        access_device_user_password (str): accessDeviceUserPassword *Optional*
        device_token (str): deviceToken *Optional*
        signed_password (str): signedPassword *Optional*
        mac_address (str): macAddress *Optional*
        realm_name (str): realmName *Optional*
        digest_ha1_complement (str): digestHa1Complement *Optional*
        digest_response (str): digestResponse *Optional*
        file_name_lookup (bool): fileNameLookup *Optional*
        file_name_on_disk (str): fileNameOnDisk *Optional*
    """

    __slots__: List[str] = [
        "device_access_protocol",
        "device_access_method",
        "device_access_uri",
        "access_device_user_name",
        "access_device_user_password",
        "device_token",
        "signed_password",
        "mac_address",
        "realm_name",
        "digest_ha1_complement",
        "digest_response",
        "file_name_lookup",
        "file_name_on_disk",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_protocol",
                "deviceAccessProtocol",
                str,
                is_required=True,
            ),
            E(
                "device_access_method",
                "deviceAccessMethod",
                str,
                is_required=True,
            ),
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "access_device_user_name",
                "accessDeviceUserName",
                str,
            ),
            E(
                "access_device_user_password",
                "accessDeviceUserPassword",
                str,
            ),
            E(
                "device_token",
                "deviceToken",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "mac_address",
                "macAddress",
                str,
            ),
            E(
                "realm_name",
                "realmName",
                str,
            ),
            E(
                "digest_ha1_complement",
                "digestHa1Complement",
                str,
            ),
            E(
                "digest_response",
                "digestResponse",
                str,
            ),
            E(
                "file_name_lookup",
                "fileNameLookup",
                bool,
            ),
            E(
                "file_name_on_disk",
                "fileNameOnDisk",
                str,
            ),
        )


class DeviceManagementPutFileRequest(OCIRequest):
    """
    Informs BroadWorks that a file was uploaded to the repository.

    The response is always a `SuccessResponse()`.

    Attributes:
        device_access_uri (str): deviceAccessURI
        ip_address (str): ipAddress
    """

    __slots__: List[str] = [
        "device_access_uri",
        "ip_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "device_access_uri",
                "deviceAccessURI",
                str,
                is_required=True,
            ),
            E(
                "ip_address",
                "ipAddress",
                str,
                is_required=True,
            ),
        )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(OCIRequest):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    The response is either
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()`
    or `ErrorResponse()`. Replaced by:
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest22()`

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest22(OCIRequest):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    The response is either
    `EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse22()`
    or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileAddAgentListRequest(OCIRequest):
    """
    Add agent(s) to a Agent Threshold Profile.

    When an agent is assigned (added) to a profile, it is automatically unassigned
    (deleted) from the previous profile it was assigned to.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        profile_name (str): profileName
        agent_user_id (List[str]): agentUserId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "profile_name",
        "agent_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileAddRequest(OCIRequest):
    """
    Add a new Call Center Agent Threshold Profile in an Enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        profile_name (str): profileName
        profile_description (str): profileDescription *Optional*
        threshold_current_call_state_idle_time_yellow (int):
            thresholdCurrentCallStateIdleTimeYellow *Optional*
        threshold_current_call_state_idle_time_red (int):
            thresholdCurrentCallStateIdleTimeRed *Optional*
        threshold_current_call_state_on_call_time_yellow (int):
            thresholdCurrentCallStateOnCallTimeYellow *Optional*
        threshold_current_call_state_on_call_time_red (int):
            thresholdCurrentCallStateOnCallTimeRed *Optional*
        threshold_current_agent_state_unavailable_time_yellow (int):
            thresholdCurrentAgentStateUnavailableTimeYellow *Optional*
        threshold_current_agent_state_unavailable_time_red (int):
            thresholdCurrentAgentStateUnavailableTimeRed *Optional*
        threshold_average_busy_in_time_yellow (int): thresholdAverageBusyInTimeYellow
            *Optional*
        threshold_average_busy_in_time_red (int): thresholdAverageBusyInTimeRed *Optional*
        threshold_average_busy_out_time_yellow (int): thresholdAverageBusyOutTimeYellow
            *Optional*
        threshold_average_busy_out_time_red (int): thresholdAverageBusyOutTimeRed
            *Optional*
        threshold_average_wrap_up_time_yellow (int): thresholdAverageWrapUpTimeYellow
            *Optional*
        threshold_average_wrap_up_time_red (int): thresholdAverageWrapUpTimeRed *Optional*
        enable_notification_email (bool): enableNotificationEmail
        notification_email_address (List[str]): notificationEmailAddress *Optional*
        agent_user_id (List[str]): agentUserId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "profile_name",
        "profile_description",
        "threshold_current_call_state_idle_time_yellow",
        "threshold_current_call_state_idle_time_red",
        "threshold_current_call_state_on_call_time_yellow",
        "threshold_current_call_state_on_call_time_red",
        "threshold_current_agent_state_unavailable_time_yellow",
        "threshold_current_agent_state_unavailable_time_red",
        "threshold_average_busy_in_time_yellow",
        "threshold_average_busy_in_time_red",
        "threshold_average_busy_out_time_yellow",
        "threshold_average_busy_out_time_red",
        "threshold_average_wrap_up_time_yellow",
        "threshold_average_wrap_up_time_red",
        "enable_notification_email",
        "notification_email_address",
        "agent_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
            E(
                "profile_description",
                "profileDescription",
                str,
            ),
            E(
                "threshold_current_call_state_idle_time_yellow",
                "thresholdCurrentCallStateIdleTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_idle_time_red",
                "thresholdCurrentCallStateIdleTimeRed",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_yellow",
                "thresholdCurrentCallStateOnCallTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_red",
                "thresholdCurrentCallStateOnCallTimeRed",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_yellow",
                "thresholdCurrentAgentStateUnavailableTimeYellow",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_red",
                "thresholdCurrentAgentStateUnavailableTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_in_time_yellow",
                "thresholdAverageBusyInTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_in_time_red",
                "thresholdAverageBusyInTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_out_time_yellow",
                "thresholdAverageBusyOutTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_out_time_red",
                "thresholdAverageBusyOutTimeRed",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_yellow",
                "thresholdAverageWrapUpTimeYellow",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_red",
                "thresholdAverageWrapUpTimeRed",
                int,
            ),
            E(
                "enable_notification_email",
                "enableNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "notification_email_address",
                "notificationEmailAddress",
                str,
                is_array=True,
            ),
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_array=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a Agent Threshold Profile.

    Agents cannot be unassigned (deleted) directly from the default profile, they need to
    be assigned (added) to a different profile.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        profile_name (str): profileName
        agent_user_id (List[str]): agentUserId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "profile_name",
        "agent_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Call Center Agent Threshold Profile in an Enterprise.

    The default profile cannot be deleted.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        profile_name (str): profileName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "profile_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Threshold Profiles in the Enterprise.

    The response is either `EnterpriseCallCenterAgentThresholdProfileGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterAgentThresholdProfileGetRequest(OCIRequest):
    """
    Gets an existing non-default Call Center Agent Threshold Profile in an Enterprise.

    The response is either a `EnterpriseCallCenterAgentThresholdProfileGetResponse()` or
    an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        profile_name (str): profileName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "profile_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeAddRequest(OCIRequest):
    """
    Add a Call Center Agent Unavailable Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        is_active (bool): isActive
        code (str): code
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "is_active",
        "code",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Agent Unavailable Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Unavailable Codes.

    The response is either `EnterpriseCallCenterAgentUnavailableCodeGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeGetRequest(OCIRequest):
    """
    Get a Call Center Agent Unavailable Code.

    The response is either `EnterpriseCallCenterAgentUnavailableCodeGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Agent Unavailable Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
        is_active (bool): isActive *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either an
    `EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse()` or an
    `ErrorResponse()`. Replaced by
    `EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either an
    `EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class EnterpriseCallCenterCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Call Disposition Codes.

    The response is either `EnterpriseCallCenterCallDispositionCodeGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.

    The response is either `EnterpriseCallCenterCallDispositionCodeGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterCallDispositionCodeGetUsageListRequest(OCIRequest):
    """
    Get the list of Call Centers and Route Points using the specified disposition code.

    The response is either `EnterpriseCallCenterCallDispositionCodeGetUsageListResponse()`
    or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
        is_active (bool): isActive *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class EnterpriseCallCenterCurrentAndPastDNISGetListRequest(OCIRequest):
    """
    Request to get all the past and current DNIS for the Call Center for the enterprise.

    The response is either `EnterpriseCallCenterCurrentAndPastDNISGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the enterprise branding information.

    The response is either `EnterpriseCallCenterEnhancedReportingBrandingGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest(OCIRequest):
    """
    Request to get all enabled call center report template for an enterprise.

    The response is either an
    `EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center enhanced reporting setting.

    The response is either an `EnterpriseCallCenterEnhancedReportingGetResponse()` or an
    `ErrorResponse()`. Replaced by `EnterpriseCallCenterEnhancedReportingGetRequest19()`

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingGetRequest19(OCIRequest):
    """
    Request to get an enterprise level call center enhanced reporting setting.

    The response is either an `EnterpriseCallCenterEnhancedReportingGetResponse19()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Request to modify enterprise level call center enhanced reporting settings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. Replaced by
    `EnterpriseCallCenterEnhancedReportingModifyRequest19()`

    Attributes:
        service_provider_id (str): serviceProviderId
        reporting_server (str): reportingServer *Optional*
        web_statistic_source (str): webStatisticSource *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "reporting_server",
        "web_statistic_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "reporting_server",
                "reportingServer",
                str,
            ),
            E(
                "web_statistic_source",
                "webStatisticSource",
                str,
            ),
        )


class EnterpriseCallCenterEnhancedReportingModifyRequest19(OCIRequest):
    """
    Request to modify enterprise level call center enhanced reporting settings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        reporting_server (str): reportingServer *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "reporting_server",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "reporting_server",
                "reportingServer",
                str,
            ),
        )


class EnterpriseCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise level call center report template.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get enterprise level call center report template list.

    The response is either an
    `EnterpriseCallCenterEnhancedReportingReportTemplateGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center report template.

    The response is either an
    `EnterpriseCallCenterEnhancedReportingReportTemplateGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingScheduledReportDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise level call center reporting scheduled report.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(OCIRequest):
    """
    Request to get all the call center reporting scheduled report in an enterprise that
    uses a given enterprise level report template.

    The response is either a
    `EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()`
    or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center reporting scheduled report.

    The response is either an
    `EnterpriseCallCenterEnhancedReportingScheduledReportGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Call Center.

    The response is either an `EnterpriseCallCenterGetResponse()` or an `ErrorResponse()`.
    Replaced by `EnterpriseCallCenterGetRequest17sp4()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the enterprise level data associated with Call Center.

    The response is either an `EnterpriseCallCenterGetResponse17sp4()` or an
    `ErrorResponse()`. Replaced by: `EnterpriseCallCenterGetResponse23()` in AS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterGetRequest23(OCIRequest):
    """
    Request the enterprise level data associated with Call Center.

    The response is either an `EnterpriseCallCenterGetResponse23()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterGetRoutingPolicyRequest(OCIRequest):
    """
    Request the enterprise call center routing policy.

    The response is either an `EnterpriseCallCenterGetRoutingPolicyResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterModifyRequest(OCIRequest):
    """
    Modify the enterprise level data associated with Call Center The response is either a
    `SuccessResponse()` or an `ErrorResponse()`.

    The following elements are only used in AS data mode and ignored in XS data mode:
    useSystemDefaultUnavailableSettings forceAgentUnavailableOnDNDActivation
    forceAgentUnavailableOnPersonalCalls forceAgentUnavailableOnBouncedCallLimit
    numberConsecutiveBouncedCallsToForceAgentUnavailable
    forceAgentUnavailableOnNotReachable wrapUpDestination

    Attributes:
        service_provider_id (str): serviceProviderId
        use_system_default_guard_timer (bool): useSystemDefaultGuardTimer *Optional*
        enable_guard_timer (bool): enableGuardTimer *Optional*
        guard_timer_seconds (int): guardTimerSeconds *Optional*
        use_system_default_unavailable_settings (bool):
            useSystemDefaultUnavailableSettings *Optional*
        force_agent_unavailable_on_dnd_activation (bool):
            forceAgentUnavailableOnDNDActivation *Optional*
        force_agent_unavailable_on_personal_calls (bool):
            forceAgentUnavailableOnPersonalCalls *Optional*
        force_agent_unavailable_on_bounced_call_limit (bool):
            forceAgentUnavailableOnBouncedCallLimit *Optional*
        number_consecutive_bounced_calls_to_force_agent_unavailable (int):
            numberConsecutiveBouncedCallsToForceAgentUnavailable *Optional*
        force_agent_unavailable_on_not_reachable (bool):
            forceAgentUnavailableOnNotReachable *Optional*
        wrap_up_destination (str): wrapUpDestination *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "use_system_default_guard_timer",
        "enable_guard_timer",
        "guard_timer_seconds",
        "use_system_default_unavailable_settings",
        "force_agent_unavailable_on_dnd_activation",
        "force_agent_unavailable_on_personal_calls",
        "force_agent_unavailable_on_bounced_call_limit",
        "number_consecutive_bounced_calls_to_force_agent_unavailable",
        "force_agent_unavailable_on_not_reachable",
        "wrap_up_destination",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "use_system_default_guard_timer",
                "useSystemDefaultGuardTimer",
                bool,
            ),
            E(
                "enable_guard_timer",
                "enableGuardTimer",
                bool,
            ),
            E(
                "guard_timer_seconds",
                "guardTimerSeconds",
                int,
            ),
            E(
                "use_system_default_unavailable_settings",
                "useSystemDefaultUnavailableSettings",
                bool,
            ),
            E(
                "force_agent_unavailable_on_dnd_activation",
                "forceAgentUnavailableOnDNDActivation",
                bool,
            ),
            E(
                "force_agent_unavailable_on_personal_calls",
                "forceAgentUnavailableOnPersonalCalls",
                bool,
            ),
            E(
                "force_agent_unavailable_on_bounced_call_limit",
                "forceAgentUnavailableOnBouncedCallLimit",
                bool,
            ),
            E(
                "number_consecutive_bounced_calls_to_force_agent_unavailable",
                "numberConsecutiveBouncedCallsToForceAgentUnavailable",
                int,
            ),
            E(
                "force_agent_unavailable_on_not_reachable",
                "forceAgentUnavailableOnNotReachable",
                bool,
            ),
            E(
                "wrap_up_destination",
                "wrapUpDestination",
                str,
            ),
        )


class EnterpriseCallCenterMonitoringGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Monitoring.

    The response is either an `EnterpriseCallCenterMonitoringGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterMonitoringGetRequest23(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Monitoring.

    The response is either an `EnterpriseCallCenterMonitoringGetResponse23()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallCenterMonitoringModifyRequest(OCIRequest):
    """
    Modify the enterprise level data associated with Call Center Monitoring The response
    is either a `SuccessResponse()` or an `ErrorResponse()`.


    Attributes:
        service_provider_id (str): serviceProviderId
        enable_supervisor_coaching (bool): enableSupervisorCoaching *Optional*
        bypass_enforcement_of_supervisor_agent_relationship (bool):
            bypassEnforcementOfSupervisorAgentRelationship *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enable_supervisor_coaching",
        "bypass_enforcement_of_supervisor_agent_relationship",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enable_supervisor_coaching",
                "enableSupervisorCoaching",
                bool,
            ),
            E(
                "bypass_enforcement_of_supervisor_agent_relationship",
                "bypassEnforcementOfSupervisorAgentRelationship",
                bool,
            ),
        )


class EnterpriseCallRecordingGetRequest(OCIRequest):
    """
    Get the Call Recording attributes for a enterprise.

    The response is either a `EnterpriseCallRecordingGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseCallRecordingModifyRequest(OCIRequest):
    """
    Modify the Call Recording attributes for a enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        use_cloud_pbx (bool): useCloudPBX *Optional*
        use_enterprise_setting (bool): useEnterpriseSetting *Optional*
        fqdn (str): FQDN *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "use_cloud_pbx",
        "use_enterprise_setting",
        "fqdn",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "use_cloud_pbx",
                "useCloudPBX",
                bool,
            ),
            E(
                "use_enterprise_setting",
                "useEnterpriseSetting",
                bool,
            ),
            E(
                "fqdn",
                "FQDN",
                str,
            ),
        )


class EnterpriseCommonPhoneListDeleteListRequest(OCIRequest):
    """
    Delete one or more entries from an enterprise's common phone list.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        entry_name (List[str]): entryName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "entry_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "entry_name",
                "entryName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class EnterpriseCommonPhoneListModifyRequest(OCIRequest):
    """
    Modify an entry in an enterprise's common phone list.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        entry_name (str): entryName
        new_entry_name (str): newEntryName *Optional*
        phone_number (str): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "entry_name",
        "new_entry_name",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "entry_name",
                "entryName",
                str,
                is_required=True,
            ),
            E(
                "new_entry_name",
                "newEntryName",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
        )


class EnterpriseCommunicationBarringAuthorizationCodeDeleteListRequest(OCIRequest):
    """
    Delete a list of Communication Barring Authorization Codes from an enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (List[str]): code *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_array=True,
            ),
        )


class EnterpriseCommunicationBarringAuthorizationCodeGetRequest(OCIRequest):
    """
    Request the enterprise Communication Barring Authorization code settings.

    The response is either a
    `EnterpriseCommunicationBarringAuthorizationCodeGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class EnterpriseCommunicationBarringAuthorizationCodeModifyRequest(OCIRequest):
    """
    Modify the enterprise Communication Barring Authorization code settings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        code (str): code
        description (str): description *Optional*
        network_class_of_service (str): networkClassOfService *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "code",
        "description",
        "network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
            ),
        )


class EnterpriseDepartmentDeleteRequest(OCIRequest):
    """
    Delete a department from an enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        enterprise_id (str): enterpriseId
        department_name (str): departmentName
    """

    __slots__: List[str] = [
        "enterprise_id",
        "department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enterprise_id",
                "enterpriseId",
                str,
                is_required=True,
            ),
            E(
                "department_name",
                "departmentName",
                str,
                is_required=True,
            ),
        )


class EnterpriseDepartmentGetAvailableParentListRequest(OCIRequest):
    """
    Get a list of enterprise level departments in an enterprise that could be the parent
    of the specified department.

    The department itself and all its decendents are not eligible to be the parent
    department.

    The response is either `EnterpriseDepartmentGetAvailableParentListResponse()` or
    `ErrorResponse()`.

    Attributes:
        enterprise_id (str): enterpriseId
        department_name (str): departmentName
    """

    __slots__: List[str] = [
        "enterprise_id",
        "department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enterprise_id",
                "enterpriseId",
                str,
                is_required=True,
            ),
            E(
                "department_name",
                "departmentName",
                str,
                is_required=True,
            ),
        )


class EnterpriseDepartmentGetListRequest(OCIRequest):
    """
    Request a list of departments in an enterprise.

    You may request only the list of departments defined at the enterprise-level, or you
    may request the list of all departments in the enterprise including all the
    departments defined within the groups inside the enterprise.

    The response is either `EnterpriseDepartmentGetListResponse()` or `ErrorResponse()`.

    Attributes:
        enterprise_id (str): enterpriseId
        include_group_departments (bool): includeGroupDepartments
    """

    __slots__: List[str] = [
        "enterprise_id",
        "include_group_departments",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "enterprise_id",
                "enterpriseId",
                str,
                is_required=True,
            ),
            E(
                "include_group_departments",
                "includeGroupDepartments",
                bool,
                is_required=True,
            ),
        )


class EnterpriseEnterpriseTrunkAddRequest(OCIRequest):
    """
    Request to add an enterprise trunk in an enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. Replaced by:
    `EnterpriseEnterpriseTrunkAddRequest21()`

    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        OCI.EnterpriseTrunkTrunkGroupKey,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class EnterpriseEnterpriseTrunkAddRequest21(OCIRequest):
    """
    Request to add an enterprise trunk in an enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
        enable_capacity_management (bool): enableCapacityManagement
        max_active_calls (int): maxActiveCalls *Optional*
        capacity_exceeded_trap_initial_calls (int): capacityExceededTrapInitialCalls
            *Optional*
        capacity_exceeded_trap_offset_calls (int): capacityExceededTrapOffsetCalls
            *Optional*
        maximum_active_incoming_calls_allowed (int): maximumActiveIncomingCallsAllowed
            *Optional*
        maximum_active_outgoing_calls_allowed (int): maximumActiveOutgoingCallsAllowed
            *Optional*
        minimum_active_calls_reserved (int): minimumActiveCallsReserved *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
        "enable_capacity_management",
        "max_active_calls",
        "capacity_exceeded_trap_initial_calls",
        "capacity_exceeded_trap_offset_calls",
        "maximum_active_incoming_calls_allowed",
        "maximum_active_outgoing_calls_allowed",
        "minimum_active_calls_reserved",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        OCI.EnterpriseTrunkTrunkGroupKey,
                        is_complex=True,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "enable_capacity_management",
                "enableCapacityManagement",
                bool,
                is_required=True,
            ),
            E(
                "max_active_calls",
                "maxActiveCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_initial_calls",
                "capacityExceededTrapInitialCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_offset_calls",
                "capacityExceededTrapOffsetCalls",
                int,
            ),
            E(
                "maximum_active_incoming_calls_allowed",
                "maximumActiveIncomingCallsAllowed",
                int,
            ),
            E(
                "maximum_active_outgoing_calls_allowed",
                "maximumActiveOutgoingCallsAllowed",
                int,
            ),
            E(
                "minimum_active_calls_reserved",
                "minimumActiveCallsReserved",
                int,
            ),
        )


class EnterpriseEnterpriseTrunkAddUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in an enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
        user_id (List[str]): userId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class EnterpriseEnterpriseTrunkDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise trunk in an enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
        )


class EnterpriseEnterpriseTrunkDeleteUserListRequest(OCIRequest):
    """
    Request to delete users from an enterprise trunk in an enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
        user_id (List[str]): userId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class EnterpriseEnterpriseTrunkForceAssignUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in an enterprise.

    If the user is already assigned to another enterprise trunk, it will be unassigned
    from the old enterprise trunk and assigned to the new enterprise trunk specified in
    this request.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
        user_id (List[str]): userId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class EnterpriseEnterpriseTrunkGetListRequest(OCIRequest):
    """
    Request to get the list of all enterprise trunks defined in an enterprise.

    The response is either a `EnterpriseEnterpriseTrunkGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseEnterpriseTrunkGetRequest(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    `EnterpriseEnterpriseTrunkGetResponse()` or an `ErrorResponse()`.

    Replaced by: `EnterpriseEnterpriseTrunkGetRequest21()`

    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
        )


class EnterpriseEnterpriseTrunkGetRequest21(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    `EnterpriseEnterpriseTrunkGetResponse21()` or an `ErrorResponse()`.


    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
        )


class EnterpriseEnterpriseTrunkGetRequest22(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    `EnterpriseEnterpriseTrunkGetResponse21()` or an `ErrorResponse()`.


    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
        )


class EnterpriseEnterpriseTrunkModifyRequest(OCIRequest):
    """
    Request to modify an enterprise trunk in an enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        enterprise_trunk_name (str): enterpriseTrunkName
        new_enterprise_trunk_name (str): newEnterpriseTrunkName *Optional*
        maximum_reroute_attempts (int): maximumRerouteAttempts *Optional*
        route_exhaustion_action (str): routeExhaustionAction *Optional*
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
        enable_capacity_management (bool): enableCapacityManagement *Optional*
        max_active_calls (int): maxActiveCalls *Optional*
        capacity_exceeded_trap_initial_calls (int): capacityExceededTrapInitialCalls
            *Optional*
        capacity_exceeded_trap_offset_calls (int): capacityExceededTrapOffsetCalls
            *Optional*
        maximum_active_incoming_calls_allowed (int): maximumActiveIncomingCallsAllowed
            *Optional*
        maximum_active_outgoing_calls_allowed (int): maximumActiveOutgoingCallsAllowed
            *Optional*
        minimum_active_calls_reserved (int): minimumActiveCallsReserved *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "enterprise_trunk_name",
        "new_enterprise_trunk_name",
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
        "enable_capacity_management",
        "max_active_calls",
        "capacity_exceeded_trap_initial_calls",
        "capacity_exceeded_trap_offset_calls",
        "maximum_active_incoming_calls_allowed",
        "maximum_active_outgoing_calls_allowed",
        "minimum_active_calls_reserved",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "new_enterprise_trunk_name",
                "newEnterpriseTrunkName",
                str,
            ),
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group_list",
                        "trunkGroupList",
                        OCI.ReplacementEnterpriseEnterpriseTrunkTrunkGroupKeyList,
                        is_complex=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                    ),
                    E(
                        "priority_weighted_trunk_group_list",
                        "priorityWeightedTrunkGroupList",
                        OCI.ReplacementEnterpriseEnterpriseTrunkPriorityWeightedTrunkGroupList,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "enable_capacity_management",
                "enableCapacityManagement",
                bool,
            ),
            E(
                "max_active_calls",
                "maxActiveCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_initial_calls",
                "capacityExceededTrapInitialCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_offset_calls",
                "capacityExceededTrapOffsetCalls",
                int,
            ),
            E(
                "maximum_active_incoming_calls_allowed",
                "maximumActiveIncomingCallsAllowed",
                int,
            ),
            E(
                "maximum_active_outgoing_calls_allowed",
                "maximumActiveOutgoingCallsAllowed",
                int,
            ),
            E(
                "minimum_active_calls_reserved",
                "minimumActiveCallsReserved",
                int,
            ),
        )


class EnterpriseLocalGatewayGetUsageRequest(OCIRequest):
    """
    Get usage details of a local gateway under an enterprise.

    The response is either `EnterpriseLocalGatewayGetUsageResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        trunk_group_name (str): trunkGroupName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "trunk_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "trunk_group_name",
                "trunkGroupName",
                str,
                is_required=True,
            ),
        )


class EnterprisePreAlertingAnnouncementGetRequest(OCIRequest):
    """
    Get the Enterprise pre-alerting service settings.

    The response is either a `EnterprisePreAlertingAnnouncementGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseRouteListEnterpriseTrunkNumberPrefixGetAvailableListRequest(OCIRequest):
    """
    Request a list of number prefixes that are assigned to an enterprise and still
    available for assignment to users within the enterprise.

    The response is either
    `EnterpriseRouteListEnterpriseTrunkNumberPrefixGetAvailableListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseRouteListEnterpriseTrunkNumberPrefixGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all enterprise trunk number prefixes in the enterprise.

    The response is either
    `EnterpriseRouteListEnterpriseTrunkNumberPrefixGetSummaryListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of number ranges that are assigned to an enterprise and still available
    for assignment to users within the enterprise.

    The response is either
    `EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all enterprise trunk number ranges in the enterprise.

    The response is either
    `EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseSecurityClassificationCustomizationGetAvailableListRequest(OCIRequest):
    """
    Get the enterprise security classification list.

    If it is not customized, it returns the system default list.

    The response is either an
    `EnterpriseSecurityClassificationCustomizationGetAvailableListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseSessionAdmissionControlGroupDeleteListRequest(OCIRequest):
    """
    Request to delete one or more session admission control groups for the enterprise.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (List[str]): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class EnterpriseSessionAdmissionControlGroupGetListRequest(OCIRequest):
    """
    Request to get the list of session admission control group for the enterprise.

    The response is either an `EnterpriseSessionAdmissionControlGroupGetListResponse()` or
    an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseSessionAdmissionControlGroupGetRequest(OCIRequest):
    """
    Request to get a session admission control group for the enterprise.

    The response is either an `EnterpriseSessionAdmissionControlGroupGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class EnterpriseSessionAdmissionControlGroupGetRequest19sp1(OCIRequest):
    """
    Request to get a session admission control group for the enterprise.

    The response is either an `EnterpriseSessionAdmissionControlGroupGetResponse19sp1()`
    or an `ErrorResponse()`. Replaced by:
    `EnterpriseSessionAdmissionControlGroupGetRequest21sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class EnterpriseSessionAdmissionControlGroupGetRequest21sp1(OCIRequest):
    """
    Request to get a session admission control group for the enterprise.

    The response is either an `EnterpriseSessionAdmissionControlGroupGetResponse21sp1()`
    or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class EnterpriseVoiceVPNDeletePolicyRequest(OCIRequest):
    """
    Delete a enterprise voice VPN location.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        location_dialing_code (str): locationDialingCode
    """

    __slots__: List[str] = [
        "service_provider_id",
        "location_dialing_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "location_dialing_code",
                "locationDialingCode",
                str,
                is_required=True,
            ),
        )


class EnterpriseVoiceVPNGetDefaultRequest(OCIRequest):
    """
    Request the Voice VPN default settings for the enterprise.

    The response is `EnterpriseVoiceVPNGetDefaultResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseVoiceVPNGetPolicyRequest(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN location code.

    The response is either a `EnterpriseVoiceVPNGetPolicyResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        location_dialing_code (str): locationDialingCode
    """

    __slots__: List[str] = [
        "service_provider_id",
        "location_dialing_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "location_dialing_code",
                "locationDialingCode",
                str,
                is_required=True,
            ),
        )


class EnterpriseVoiceVPNGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN.

    The response is either a `EnterpriseVoiceVPNGetResponse()` or an `ErrorResponse()`.

    Replaced By: `EnterpriseVoiceVPNGetRequest14sp3()`

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseVoiceVPNGetRequest14sp3(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN.

    The response is either a `EnterpriseVoiceVPNGetResponse14sp3()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class EnterpriseVoiceVPNModifyRequest(OCIRequest):
    """
    Modify the enterprise voice VPN level data associated with voice VPN.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        is_active (bool): isActive *Optional*
        default_selection (str): defaultSelection *Optional*
        e164_selection (str): e164Selection *Optional*
        use_phone_context (bool): usePhoneContext *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "is_active",
        "default_selection",
        "e164_selection",
        "use_phone_context",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "default_selection",
                "defaultSelection",
                str,
            ),
            E(
                "e164_selection",
                "e164Selection",
                str,
            ),
            E(
                "use_phone_context",
                "usePhoneContext",
                bool,
            ),
        )


class ExternalAuthenticationAuthorizeTokenRequest(OCIRequest):
    """
    This command is part of the Portal API.

    Sent when a Web or CLI user logs in using external authentication.  The password must
    be hashed.  The password hashing algorithm is: 1) The message digest of the user's
    plain password is calculated using the SHA algorithm.  2) For every four bits in the
    160-bit digest, starting from the first bit, it is converted into a character in ASCII
    Hex format (0 through 9, a through f). The result is a 40-character string, for
    example, f7a9e24777ec23212c54d7a350bc5bea5477fdbb.  3) The above string then is used
    to populate the password field in the request.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        password (str): password *Optional*
        login_token (str): loginToken
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "login_token",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "login_token",
                "loginToken",
                str,
                is_required=True,
            ),
        )


class ExternalAuthenticationAuthorizeTokenRequest22(OCIRequest):
    """
    This command is part of the Portal API.

    Sent when a Web or CLI user logs in using external authentication.  The hashed
    password value in the request is supported only when the request is sent from the
    CommPilot web portal.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        password (str): password *Optional*
        is_password_hashed (bool): isPasswordHashed *Optional*
        login_token (str): loginToken
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "is_password_hashed",
        "login_token",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "is_password_hashed",
                "isPasswordHashed",
                bool,
            ),
            E(
                "login_token",
                "loginToken",
                str,
                is_required=True,
            ),
        )


class ExternalAuthenticationCreateLoginTokenRequest(OCIRequest):
    """
    This command allows a BroadWorks or Third-Party Client Application to create a Single
    Sign-On token for a user.

    The response is either `ExternalAuthenticationCreateLoginTokenResponse()` or
    `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a group access device.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        tag_name (str): tagName
        tag_value (str): tagValue *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "tag_name",
        "tag_value",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
            ),
            E(
                "tag_value",
                "tagValue",
                str,
            ),
        )


class GroupAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a group access device.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        tag_name (List[str]): tagName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "tag_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device profile basis.

    The response is either `GroupAccessDeviceCustomTagGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a group access device.

    The tagValueToEncrypt element can only be used by a system administrator.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    tagValueToEncrypt

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        tag_name (str): tagName
        tag_value (str): tagValue *Optional*
        tag_value_to_encrypt (str): tagValueToEncrypt *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "tag_name",
        "tag_value",
        "tag_value_to_encrypt",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
            ),
            E(
                "tag_value",
                "tagValue",
                str,
            ),
            E(
                "tag_value_to_encrypt",
                "tagValueToEncrypt",
                str,
            ),
        )


class GroupAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified group access device.

    The following elements are only used in AS data mode and ignored in XS data mode:
    deviceExternalId

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class GroupAccessDeviceDeviceActivationGetRequest(OCIRequest):
    """
    Requests the activation information for a device configured at the Group level.

    Returns a `GroupAccessDeviceDeviceActivationGetResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceDeviceActivationModifyRequest(OCIRequest):
    """
    Activates or deactivates a device configured at the Group level.

    It is only possible for this request to activate a device which is deactivated.
    Trying to activate a device in the activating state will result in an error response
    since only the DAS is allowed to execute this operation.  Returns a
    `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        activate_device (bool): activateDevice
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "activate_device",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "activate_device",
                "activateDevice",
                bool,
                is_required=True,
            ),
        )


class GroupAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either `GroupAccessDeviceFileGetListResponse()` or `ErrorResponse()`.

    Replaced By: `GroupAccessDeviceFileGetListRequest14sp8()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either `GroupAccessDeviceFileGetListResponse14sp8()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either `GroupAccessDeviceFileGetResponse()` or `ErrorResponse()`.

    Replaced By: `GroupAccessDeviceFileGetRequest14sp8()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        file_type (str): fileType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "file_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "file_type",
                "fileType",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either `GroupAccessDeviceFileGetResponse14sp8()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceFileGetRequest16sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        file_format (str): fileFormat
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "file_format",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "file_format",
                "fileFormat",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either `GroupAccessDeviceFileGetResponse16sp1()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceFileGetRequest20()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        file_format (str): fileFormat
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "file_format",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "file_format",
                "fileFormat",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either `GroupAccessDeviceFileGetResponse20()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        file_format (str): fileFormat
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "file_format",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "file_format",
                "fileFormat",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGenerateActivationCodeRequest(OCIRequest):
    """
    Requests a new activation code for a device configured at the Group level.

    Returns a `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetAvailableCustomTagListRequest(OCIRequest):
    """
    Get the list of all available custom tags managed by the Device Management System, on
    a per-device profile basis.

    The response is either `GroupAccessDeviceGetAvailableCustomTagListResponse()` or
    `ErrorResponse()`. The following elements are used in AS mode and ignored in XS data
    mode: tagSetName

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        tag_set_name (str): tagSetName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "tag_set_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "tag_set_name",
                "tagSetName",
                str,
            ),
        )


class GroupAccessDeviceGetAvailableDetailListRequest14(OCIRequest):
    """
    Requests the list of available access devices for assignment to a user within a group.

    The list includes devices created at the system, service provider, and group levels.

    The response is either `GroupAccessDeviceGetAvailableDetailListResponse14()` or
    `ErrorResponse()`. Replaced by: `GroupAccessDeviceGetAvailableDetailListRequest19()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        is_music_on_hold (bool): isMusicOnHold
        only_video_capable (bool): onlyVideoCapable
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "is_music_on_hold",
        "only_video_capable",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "is_music_on_hold",
                "isMusicOnHold",
                bool,
                is_required=True,
            ),
            E(
                "only_video_capable",
                "onlyVideoCapable",
                bool,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetAvailableDetailListRequest19(OCIRequest):
    """
    Requests the list of available access devices for assignment to a user within a group.

    The list includes devices created at the system, service provider, and group levels.
    The following elements are used in AS mode and ignored in XS data mode:
    onlyIntelligentDevice

    The response is either `GroupAccessDeviceGetAvailableDetailListResponse19()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        is_music_on_hold (bool): isMusicOnHold
        only_video_capable (bool): onlyVideoCapable
        only_intelligent_device (bool): onlyIntelligentDevice *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "is_music_on_hold",
        "only_video_capable",
        "only_intelligent_device",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "is_music_on_hold",
                "isMusicOnHold",
                bool,
                is_required=True,
            ),
            E(
                "only_video_capable",
                "onlyVideoCapable",
                bool,
                is_required=True,
            ),
            E(
                "only_intelligent_device",
                "onlyIntelligentDevice",
                bool,
            ),
        )


class GroupAccessDeviceGetEnhancedConfigurationTypeListRequest(OCIRequest):
    """
    Requests the list of configurable device types of devices that have already been added
    to the group.

    The response is either `GroupAccessDeviceGetEnhancedConfigurationTypeListResponse()`
    or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetEnhancedConfigurationTypeRequest14(OCIRequest):
    """
    Requests the details of a specified configurable device type for a group.

    The response is either `GroupAccessDeviceGetEnhancedConfigurationTypeResponse14()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetLinkedLeafDeviceListRequest(OCIRequest):
    """
    Requests the list of linked leaf devices for the group level tree device passed in the
    request.

    A tree device is a device associated with a device type that has the option
    supportLinks set to "Support Links from Devices". Many leaf devices can be linked to
    it.  A leaf device is a device associated with a device type that has the option
    supportLinks set to "Support Link to Device". It can be linked to only one tree
    device.  The list includes devices created at the system, service provider, and group
    levels.

    The response is either `GroupAccessDeviceGetLinkedLeafDeviceListResponse()` or
    `ErrorResponse()`. Replaced by: `GroupAccessDeviceGetLinkedLeafDeviceListRequest22()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetLinkedLeafDeviceListRequest22(OCIRequest):
    """
    Requests the list of linked leaf devices for the group level tree device passed in the
    request.

    A tree device is a device associated with a device type that has the option
    supportLinks set to "Support Links from Devices". Many leaf devices can be linked to
    it.  A leaf device is a device associated with a device type that has the option
    supportLinks set to "Support Link to Device" or "Support Link to Device and User". It
    can be linked to only one tree device.  The list includes devices created at the
    system, service provider, and group levels.  If the leafDeviceCategory is not set in
    the request, then linked leaf devices of all categories are requested, otherwise only
    the linked leaf devices of the specified category are requested.  The category values
    are: "Handset", "Base Station", "All".

    The response is either `GroupAccessDeviceGetLinkedLeafDeviceListResponse22()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        leaf_device_category (str): leafDeviceCategory *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "leaf_device_category",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "leaf_device_category",
                "leafDeviceCategory",
                str,
            ),
        )


class GroupAccessDeviceGetLinkedTreeDeviceRequest(OCIRequest):
    """
    Requests the tree device linked with the group level leaf device passed in the
    request.

    A tree device is a device associated with a device type that has the option
    supportLinks set to "Support Links from Devices". Many leaf devices can be linked to
    it.  A leaf device is a device associated with a device type that has the option
    supportLinks set to "Support Link to Device" or "Support Link to Device and User". It
    can be linked to only one tree device.

    The response is either `GroupAccessDeviceGetLinkedTreeDeviceResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetNativeTagsWithLogicListRequest(OCIRequest):
    """
    Get the list of all native tags with logic managed by the Device Management System, on
    a per-device profile basis.

    The response is either `GroupAccessDeviceGetAvailableCustomTagListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetRequest14(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse14()` or `ErrorResponse()`.

    Replaced By: `GroupAccessDeviceGetRequest14sp3()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse14sp3()` or `ErrorResponse()`.

    Replaced By: `GroupAccessDeviceGetRequest14sp6()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse14sp6()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceGetRequest16()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse16()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceGetRequest18sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse18sp1()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceGetRequest22()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetRequest22(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse22()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceGetRequest24()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceGetRequest22V2(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse22V2()` or `ErrorResponse()`. The
    following elements are only used in AS data mode and ignored in XS data mode:
    deviceExternalId Replaced by: `GroupAccessDeviceGetRequest24()` in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class GroupAccessDeviceGetRequest22V3(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse22V3()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceGetRequest24()`

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class GroupAccessDeviceGetRequest22V4(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse22V4()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceGetRequest24V2()`

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class GroupAccessDeviceGetRequest22V5(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse22V5()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceGetRequest24V3()`

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class GroupAccessDeviceGetRequest24(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse24()` or `ErrorResponse()`.
    Replaced by: `GroupAccessDeviceGetRequest24V2()` in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class GroupAccessDeviceGetRequest24V2(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse24V2()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class GroupAccessDeviceGetRequest24V3(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either `GroupAccessDeviceGetResponse24V3()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class GroupAccessDeviceModifyUserRequest(OCIRequest):
    """
    Request to modify attributes for line/ports assigned on the group device profile.

    The response is either `SuccessResponse()` or `ErrorResponse()`. The following
    elements are only used in XS data mode and ignored in AS data mode: privateIdentity

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        line_port (str): linePort
        private_identity (str): privateIdentity *Optional*
        is_primary_line_port (bool): isPrimaryLinePort *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "line_port",
        "private_identity",
        "is_primary_line_port",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "line_port",
                "linePort",
                str,
                is_required=True,
            ),
            E(
                "private_identity",
                "privateIdentity",
                str,
            ),
            E(
                "is_primary_line_port",
                "isPrimaryLinePort",
                bool,
            ),
        )


class GroupAccessDeviceResetRequest(OCIRequest):
    """
    Reset a specific group SIP device that supports the reset operation.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceTagSetGetRequest(OCIRequest):
    """
    Request to get the custom configuration tag set defined at the access device.

    The response is either `GroupAccessDeviceTagSetGetResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupAccessDeviceTagSetModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag set.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        tag_set_name (str): tagSetName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "tag_set_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "tag_set_name",
                "tagSetName",
                str,
            ),
        )


class GroupAccountAuthorizationCodesDeleteListRequest(OCIRequest):
    """
    Delete a list of account/authorization codes from a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (List[str]): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupAccountAuthorizationCodesGetListRequest(OCIRequest):
    """
    Request the list of account/authorization codes for a group.

    The response is either a `GroupAccountAuthorizationCodesGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupAccountAuthorizationCodesGetRequest(OCIRequest):
    """
    Request the group's account/authorization codes setting.

    The response is either a `GroupAccountAuthorizationCodesGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupAdminAddRequest(OCIRequest):
    """
    Add a group administrator.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        user_id (str): userId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        password (str): password *Optional*
        language (str): language *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "user_id",
        "first_name",
        "last_name",
        "password",
        "language",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "language",
                "language",
                str,
            ),
        )


class GroupAdminAlternateIdAddRequest(OCIRequest):
    """
    Request to add an alternate admin Id to a group administrator.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        alternate_user_id (str): alternateUserId
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "alternate_user_id",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "alternate_user_id",
                "alternateUserId",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupAdminAlternateIdDeleteRequest(OCIRequest):
    """
    Request to delete an alternate admin user id of a group administrator.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        alternate_user_id (str): alternateUserId
    """

    __slots__: List[str] = [
        "user_id",
        "alternate_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "alternate_user_id",
                "alternateUserId",
                str,
                is_required=True,
            ),
        )


class GroupAdminAlternateIdGetListRequest(OCIRequest):
    """
    Request to get the admin id and the list of alternate admin ids of an admin.

    The response is either `GroupAdminAlternateIdGetListResponse()` or `ErrorResponse()`.
    The "userId" can be either the admin user Id or an alternate admin user Id.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminAlternateIdModifyRequest(OCIRequest):
    """
    Request to modify an alternate id of a group admin.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        alternate_user_id (str): alternateUserId
        new_alternate_user_id (str): newAlternateUserId *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "alternate_user_id",
        "new_alternate_user_id",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "alternate_user_id",
                "alternateUserId",
                str,
                is_required=True,
            ),
            E(
                "new_alternate_user_id",
                "newAlternateUserId",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupAdminDeleteRequest(OCIRequest):
    """
    Delete a group administrator.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetListRequest(OCIRequest):
    """
    Get a list of group and department administrators within the group.

    The response is either a `GroupAdminGetListResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyRequest(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either `GroupAdminGetPolicyResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyRequest14sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either `GroupAdminGetPolicyResponse14sp1()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyRequest16sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either `GroupAdminGetPolicyResponse16sp1()` or `ErrorResponse()`.
    Replaced by: `GroupAdminGetPolicyRequest17()`

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyRequest16sp2(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either `GroupAdminGetPolicyResponse16sp2()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyRequest17(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either `GroupAdminGetPolicyResponse17()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyRequest17sp3(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either `GroupAdminGetPolicyResponse17sp3()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyRequest18(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either `GroupAdminGetPolicyResponse18()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyRequest19sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either `GroupAdminGetPolicyResponse19sp1()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetPolicyRequest20(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either `GroupAdminGetPolicyResponse20()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetRequest(OCIRequest):
    """
    Get a group administrators profile.

    The response is either a `GroupAdminGetResponse()` or an `ErrorResponse()`. Replaced
    by `GroupAdminGetRequest21sp1()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetRequest21sp1(OCIRequest):
    """
    Get a group administrators profile.

    The response is either a `GroupAdminGetResponse21sp1()` or an `ErrorResponse()`.
    Replaced by: `GroupAdminGetRequest22()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetRequest22(OCIRequest):
    """
    Get a group administrators profile.

    The response is either a `GroupAdminGetResponse22()` or an `ErrorResponse()`. Replaced
    by: `GroupAdminGetRequest22V2()`

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetRequest22V2(OCIRequest):
    """
    Get a group administrators profile.

    The response is either a `GroupAdminGetResponse22V2()` or an `ErrorResponse()`.
    Replaced by: `GroupAdminGetRequest22V3()`

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminGetRequest22V3(OCIRequest):
    """
    Get a group administrators profile.

    The response is either a `GroupAdminGetResponse22V3()` or an `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupAdminModifyPolicyRequest(OCIRequest):
    """
    Request to modify the group administrator's policy settings.

    The response is either `SuccessResponse()` or `ErrorResponse()`. The following
    elements are only used in AS data mode: dialableCallerIDAccess
    verifyTranslationAndRoutingAccess communicationBarringUserProfileAccess (only
    applicable to groups in an Enterprise)

    Attributes:
        user_id (str): userId
        profile_access (str): profileAccess *Optional*
        user_access (str): userAccess *Optional*
        admin_access (str): adminAccess *Optional*
        department_access (str): departmentAccess *Optional*
        access_device_access (str): accessDeviceAccess *Optional*
        enhanced_service_instance_access (str): enhancedServiceInstanceAccess *Optional*
        feature_access_code_access (str): featureAccessCodeAccess *Optional*
        phone_number_extension_access (str): phoneNumberExtensionAccess *Optional*
        calling_line_id_number_access (str): callingLineIdNumberAccess *Optional*
        service_access (str): serviceAccess *Optional*
        trunk_group_access (str): trunkGroupAccess *Optional*
        session_admission_control_access (str): sessionAdmissionControlAccess *Optional*
        office_zone_access (str): officeZoneAccess *Optional*
        dialable_caller_id_access (str): dialableCallerIDAccess *Optional*
        number_activation_access (str): numberActivationAccess *Optional*
        verify_translation_and_routing_access (str): verifyTranslationAndRoutingAccess
            *Optional*
        communication_barring_user_profile_access (str):
            communicationBarringUserProfileAccess *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "profile_access",
        "user_access",
        "admin_access",
        "department_access",
        "access_device_access",
        "enhanced_service_instance_access",
        "feature_access_code_access",
        "phone_number_extension_access",
        "calling_line_id_number_access",
        "service_access",
        "trunk_group_access",
        "session_admission_control_access",
        "office_zone_access",
        "dialable_caller_id_access",
        "number_activation_access",
        "verify_translation_and_routing_access",
        "communication_barring_user_profile_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "profile_access",
                "profileAccess",
                str,
            ),
            E(
                "user_access",
                "userAccess",
                str,
            ),
            E(
                "admin_access",
                "adminAccess",
                str,
            ),
            E(
                "department_access",
                "departmentAccess",
                str,
            ),
            E(
                "access_device_access",
                "accessDeviceAccess",
                str,
            ),
            E(
                "enhanced_service_instance_access",
                "enhancedServiceInstanceAccess",
                str,
            ),
            E(
                "feature_access_code_access",
                "featureAccessCodeAccess",
                str,
            ),
            E(
                "phone_number_extension_access",
                "phoneNumberExtensionAccess",
                str,
            ),
            E(
                "calling_line_id_number_access",
                "callingLineIdNumberAccess",
                str,
            ),
            E(
                "service_access",
                "serviceAccess",
                str,
            ),
            E(
                "trunk_group_access",
                "trunkGroupAccess",
                str,
            ),
            E(
                "session_admission_control_access",
                "sessionAdmissionControlAccess",
                str,
            ),
            E(
                "office_zone_access",
                "officeZoneAccess",
                str,
            ),
            E(
                "dialable_caller_id_access",
                "dialableCallerIDAccess",
                str,
            ),
            E(
                "number_activation_access",
                "numberActivationAccess",
                str,
            ),
            E(
                "verify_translation_and_routing_access",
                "verifyTranslationAndRoutingAccess",
                str,
            ),
            E(
                "communication_barring_user_profile_access",
                "communicationBarringUserProfileAccess",
                str,
            ),
        )


class GroupAdminModifyRequest(OCIRequest):
    """
    Modify a group administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode and ignored in XS data mode.  accountDisabled

    Attributes:
        user_id (str): userId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        password (str): password *Optional*
        language (str): language *Optional*
        account_disabled (bool): accountDisabled *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "first_name",
        "last_name",
        "password",
        "language",
        "account_disabled",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "language",
                "language",
                str,
            ),
            E(
                "account_disabled",
                "accountDisabled",
                bool,
            ),
        )


class GroupAdministratorPasswordRulesGetRequest(OCIRequest):
    """
    Requests the effective password rules setting for a group administrator.

    The response is either `GroupAdministratorPasswordRulesGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupAdviceOfChargeGetRequest(OCIRequest):
    """
    Request to get the list of Advice of Charge group parameters.

    The response is either `GroupAdviceOfChargeGetResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupAdviceOfChargeModifyRequest(OCIRequest):
    """
    Modify the service provider level Advice Of Charge group settings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_group_level_ao_c_settings (bool): useGroupLevelAoCSettings *Optional*
        delay_between_notification_seconds (int): delayBetweenNotificationSeconds
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_group_level_ao_c_settings",
        "delay_between_notification_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_group_level_ao_c_settings",
                "useGroupLevelAoCSettings",
                bool,
            ),
            E(
                "delay_between_notification_seconds",
                "delayBetweenNotificationSeconds",
                int,
            ),
        )


class GroupAnnouncementRepositoryGetSettingsRequest(OCIRequest):
    """
    Return the disk space being used.


    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupApplicationServerSetGetRequest(OCIRequest):
    """
    Get the Application Server set for a group.

    The response is either a `GroupApplicationServerSetGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupApplicationServerSetModifyRequest(OCIRequest):
    """
    Modify the Application Server set for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        application_server_set_name (str): applicationServerSetName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "application_server_set_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "application_server_set_name",
                "applicationServerSetName",
                str,
            ),
        )


class GroupAutoAttendantConsolidatedDeleteInstanceRequest(OCIRequest):
    """
    Delete a Auto Attendant instance from a group and free up phone numbers.

    If UnassignPhoneNumbersLevel is set to 'Group', the user's primary phone number, fax
    number and any alternate numbers, will be un-assigned from the group if the command is
    executed by a service provider administrator or above.  When set to 'Service
    Provider', they will be un-assigned from the group and service provider if the command
    is executed by a provisioning administrator or above.  When omitted, the number(s)
    will be left assigned to the group.  An `ErrorResponse()` will be returned if any
    number cannot be unassigned because of insufficient privilege.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        unassign_phone_numbers (str): unassignPhoneNumbers *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "unassign_phone_numbers",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "unassign_phone_numbers",
                "unassignPhoneNumbers",
                str,
            ),
        )


class GroupAutoAttendantDeleteInstanceRequest(OCIRequest):
    """
    Delete a Auto Attendant instance from a group.

    If UnassignPhoneNumbersLevel is set to 'Group', the user's primary phone number, fax
    number and any alternate numbers, will be unassigned from the group if the command is
    executed by a service provider administrator or above.  When set to 'Service
    Provider', they will be unassigned from the group and service provider if the command
    is executed by a provisioning administrator or above.  When omitted, the number(s)
    will be left assigned to the group.  An `ErrorResponse()` with the type warning will
    be returned if any number cannot be unassigned because of insufficient privilege.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantGetInstanceListRequest(OCIRequest):
    """
    Get a list of Auto Attendant instances within a group.

    The response is either `GroupAutoAttendantGetInstanceListResponse()` or
    `ErrorResponse()`. It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
        )


class GroupAutoAttendantGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either `GroupAutoAttendantGetInstanceResponse()` or `ErrorResponse()`.

    Replaced By: `GroupAutoAttendantGetInstanceRequest16()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantGetInstanceRequest16(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either `GroupAutoAttendantGetInstanceResponse16()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either `GroupAutoAttendantGetInstanceResponse17()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantGetInstanceRequest17sp1(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either `GroupAutoAttendantGetInstanceResponse17sp1()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either `GroupAutoAttendantGetInstanceResponse19()` or
    `ErrorResponse()`. Replaced by: `GroupAutoAttendantGetInstanceRequest19sp1()` in AS
    data mode

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either `GroupAutoAttendantGetInstanceResponse19sp1()` or
    `ErrorResponse()`. Replaced by: `GroupAutoAttendantGetInstanceRequest20()` in AS data
    mode

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantGetInstanceRequest20(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either `GroupAutoAttendantGetInstanceResponse20()` or
    `ErrorResponse()`. Replaced by: `GroupAutoAttendantGetInstanceRequest24()` in AS data
    mode

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantGetInstanceRequest24(OCIRequest):
    """
    Request to get all the information of an Auto Attendant instance.

    The response is either `GroupAutoAttendantGetInstanceResponse24()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantSubmenuDeleteListRequest(OCIRequest):
    """
    Delete a submenu form an auto attendant.

    The response is either `SuccessResponse()` or `ErrorResponse()`. This request is only
    valid for Standard auto attendants.

    Attributes:
        service_user_id (str): serviceUserId
        submenu_id (List[str]): submenuId
    """

    __slots__: List[str] = [
        "service_user_id",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupAutoAttendantSubmenuGetListRequest(OCIRequest):
    """
    Get a list of Auto Attendant Submenus.

    The response is either `GroupAutoAttendantSubmenuGetListResponse()` or
    `ErrorResponse()`. This request is only valid for Standard auto attendants.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantSubmenuGetRequest(OCIRequest):
    """
    Request to get an Auto Attendant submenu instance.

    The response is either `GroupAutoAttendantSubmenuGetResponse()` or `ErrorResponse()`.
    This request is only valid for Standard auto attendants.  Replaced by:
    `GroupAutoAttendantSubmenuGetRequest20()` in AS data mode

    Attributes:
        service_user_id (str): serviceUserId
        submenu_id (str): submenuId
    """

    __slots__: List[str] = [
        "service_user_id",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantSubmenuGetRequest20(OCIRequest):
    """
    Request to get an Auto Attendant submenu instance.

    The response is either `GroupAutoAttendantSubmenuGetResponse20()` or
    `ErrorResponse()`. This request is only valid for Standard auto attendants.

    Attributes:
        service_user_id (str): serviceUserId
        submenu_id (str): submenuId
    """

    __slots__: List[str] = [
        "service_user_id",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
                is_required=True,
            ),
        )


class GroupAutoAttendantSubmenuGetUsageListRequest(OCIRequest):
    """
    Get a list of Auto Attendant Business Hours Menu,After Hours Menu,Holiday Menu and
    Submenus that use this submenu.

    The response is either `GroupAutoAttendantSubmenuGetUsageListResponse()` or
    `ErrorResponse()`. This request is only valid for Standard auto attendants.

    Attributes:
        service_user_id (str): serviceUserId
        submenu_id (str): submenuId
    """

    __slots__: List[str] = [
        "service_user_id",
        "submenu_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "submenu_id",
                "submenuId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksAnywhereDeleteInstanceRequest(OCIRequest):
    """
    Delete a BroadWorks Anywhere instance from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksAnywhereGetInstanceListRequest(OCIRequest):
    """
    Get a list of BroadWorks Anywhere instances within a group.

    The response is either `GroupBroadWorksAnywhereGetInstanceListResponse()` or
    `ErrorResponse()`. It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
        )


class GroupBroadWorksAnywhereGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.

    The response is either `GroupBroadWorksAnywhereGetInstanceResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksAnywhereGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.

    The response is either `GroupBroadWorksAnywhereGetInstanceResponse17()` or
    `ErrorResponse()`. Replaced by: `GroupBroadWorksAnywhereGetInstanceRequest19sp1()` in
    AS data mode

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksAnywhereGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.

    The response is either `GroupBroadWorksAnywhereGetInstanceResponse19sp1()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetRequest(OCIRequest):
    """
    Get the groups BroadWorks Mobility settings.

    The response is either a `GroupBroadWorksMobilityGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetRequest19sp1(OCIRequest):
    """
    Get the group's BroadWorks Mobility settings.

    The response is either a `GroupBroadWorksMobilityGetResponse19sp1()` or an
    `ErrorResponse()`. Replaced by: `GroupBroadWorksMobilityGetRequest22()` in AS data
    mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetRequest21sp1(OCIRequest):
    """
    Get the group's BroadWorks Mobility settings.

    The response is either a `GroupBroadWorksMobilityGetResponse21sp1()` or an
    `ErrorResponse()`. Replaced by `GroupBroadWorksMobilityGetRequest22V2()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetRequest22(OCIRequest):
    """
    Get the group's BroadWorks Mobility settings.

    The response is either a `GroupBroadWorksMobilityGetResponse22()` or an
    `ErrorResponse()`. Replaced by `GroupBroadWorksMobilityGetRequest22V2()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetRequest22V2(OCIRequest):
    """
    Get the group's BroadWorks Mobility settings.

    The response is either a `GroupBroadWorksMobilityGetResponse22V2()` or an
    `ErrorResponse()`. Replaced by `GroupBroadWorksMobilityGetRequest22V3()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetRequest22V3(OCIRequest):
    """
    Get the group's BroadWorks Mobility settings.

    The response is either a `GroupBroadWorksMobilityGetResponse22V3()` or an
    `ErrorResponse()`. Replaced by `GroupBroadWorksMobilityGetRequest22V4()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityGetRequest22V4(OCIRequest):
    """
    Get the group's BroadWorks Mobility settings.

    The response is either a `GroupBroadWorksMobilityGetResponse22V4()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberAssignListRequest(OCIRequest):
    """
    Assign Mobile Subscriber Directory Numbers to a group.

    It is possible to add a single DN,or a list of DNs.  . This command is applicable only
    for group in a service provider and will fail for a group in an enterprise.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        mobile_subscriber_directory_number (List[str]): mobileSubscriberDirectoryNumber
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "mobile_subscriber_directory_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "mobile_subscriber_directory_number",
                "mobileSubscriberDirectoryNumber",
                str,
                is_array=True,
            ),
        )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(OCIRequest):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    . This command is applicable only for group in a service provider and will fail for a
    group in an enterprise.

    The response is either
    `GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberUnassignListRequest(OCIRequest):
    """
    Unassign Mobile Subscriber Directory Numbers from a group.

    It is possible to unassign either: a single DN, or a list of DNs.  . This command is
    applicable only for group in a service provider and will fail for a group in an
    enterprise.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        mobile_subscriber_directory_number (List[str]): mobileSubscriberDirectoryNumber
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "mobile_subscriber_directory_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "mobile_subscriber_directory_number",
                "mobileSubscriberDirectoryNumber",
                str,
                is_array=True,
            ),
        )


class GroupCPEConfigRebuildConfigFileRequest(OCIRequest):
    """
    Rebuild the group default config file for the specified device type.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
        force (bool): force *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
        "force",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "force",
                "force",
                bool,
            ),
        )


class GroupCPEConfigRebuildDeviceConfigFileRequest(OCIRequest):
    """
    Rebuild the config file for a specified device.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode: force

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        force (bool): force *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "force",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "force",
                "force",
                bool,
            ),
        )


class GroupCPEConfigReorderDeviceLinePortsRequest(OCIRequest):
    """
    Reorder the lines of a group device.

    You can not add or delete line ports, only re-ordering the list is allowed.  The
    ordered list of line ports can be obtained with the `GroupAccessDeviceGetRequest16()`
    command.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
        ordered_line_port_list (List[str]): orderedLinePortList
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
        "ordered_line_port_list",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "ordered_line_port_list",
                "orderedLinePortList",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCPEConfigResetDeviceRequest(OCIRequest):
    """
    Reset a specific group device.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupCPEConfigResetDeviceTypeRequest(OCIRequest):
    """
    Reset all the devices of the specified device type in a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class GroupCallCapacityManagementAddInstanceRequest(OCIRequest):
    """
    Adds a Call Capacity Management group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        max_active_calls_allowed (int): maxActiveCallsAllowed
        max_incoming_active_calls_allowed (int): maxIncomingActiveCallsAllowed *Optional*
        max_outgoing_active_calls_allowed (int): maxOutgoingActiveCallsAllowed *Optional*
        become_default_group_for_new_users (bool): becomeDefaultGroupForNewUsers
        user_id (List[str]): userId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "max_active_calls_allowed",
        "max_incoming_active_calls_allowed",
        "max_outgoing_active_calls_allowed",
        "become_default_group_for_new_users",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "max_active_calls_allowed",
                "maxActiveCallsAllowed",
                int,
                is_required=True,
            ),
            E(
                "max_incoming_active_calls_allowed",
                "maxIncomingActiveCallsAllowed",
                int,
            ),
            E(
                "max_outgoing_active_calls_allowed",
                "maxOutgoingActiveCallsAllowed",
                int,
            ),
            E(
                "become_default_group_for_new_users",
                "becomeDefaultGroupForNewUsers",
                bool,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_array=True,
            ),
        )


class GroupCallCapacityManagementAddUserListRequest(OCIRequest):
    """
    Adds one or more users to a Call Capacity Management group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        user_id (List[str]): userId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCallCapacityManagementDeleteInstanceListRequest(OCIRequest):
    """
    Deletes one or more Call Capacity Management groups.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (List[str]): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCallCapacityManagementDeleteUserListRequest(OCIRequest):
    """
    Deletes one or more users from a Call Capacity Management group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        user_id (List[str]): userId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCallCapacityManagementGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Capacity Management instances within a group.

    The response is either `GroupCallCapacityManagementGetInstanceListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCapacityManagementGetInstanceRequest(OCIRequest):
    """
    Gets a Call Capacity Management group.

    The response is either `GroupCallCapacityManagementGetInstanceResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterAddSupervisorListRequest(OCIRequest):
    """
    Add supervisor(s) to a call center.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        supervisor_user_id (List[str]): supervisorUserId
    """

    __slots__: List[str] = [
        "service_user_id",
        "supervisor_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "supervisor_user_id",
                "supervisorUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileAddAgentListRequest(OCIRequest):
    """
    Add agent(s) to a Agent Threshold Profile.

    When an agent is assigned (added )to a profile, it is automatically unassigned
    (deleted) from the previous profile it was assigned to.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        profile_name (str): profileName
        agent_user_id (List[str]): agentUserId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "profile_name",
        "agent_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileAddRequest(OCIRequest):
    """
    Add a new Call Center Agent Threshold Profile in a Group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        profile_name (str): profileName
        profile_description (str): profileDescription *Optional*
        threshold_current_call_state_idle_time_yellow (int):
            thresholdCurrentCallStateIdleTimeYellow *Optional*
        threshold_current_call_state_idle_time_red (int):
            thresholdCurrentCallStateIdleTimeRed *Optional*
        threshold_current_call_state_on_call_time_yellow (int):
            thresholdCurrentCallStateOnCallTimeYellow *Optional*
        threshold_current_call_state_on_call_time_red (int):
            thresholdCurrentCallStateOnCallTimeRed *Optional*
        threshold_current_agent_state_unavailable_time_yellow (int):
            thresholdCurrentAgentStateUnavailableTimeYellow *Optional*
        threshold_current_agent_state_unavailable_time_red (int):
            thresholdCurrentAgentStateUnavailableTimeRed *Optional*
        threshold_average_busy_in_time_yellow (int): thresholdAverageBusyInTimeYellow
            *Optional*
        threshold_average_busy_in_time_red (int): thresholdAverageBusyInTimeRed *Optional*
        threshold_average_busy_out_time_yellow (int): thresholdAverageBusyOutTimeYellow
            *Optional*
        threshold_average_busy_out_time_red (int): thresholdAverageBusyOutTimeRed
            *Optional*
        threshold_average_wrap_up_time_yellow (int): thresholdAverageWrapUpTimeYellow
            *Optional*
        threshold_average_wrap_up_time_red (int): thresholdAverageWrapUpTimeRed *Optional*
        enable_notification_email (bool): enableNotificationEmail
        notification_email_address (List[str]): notificationEmailAddress *Optional*
        agent_user_id (List[str]): agentUserId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "profile_name",
        "profile_description",
        "threshold_current_call_state_idle_time_yellow",
        "threshold_current_call_state_idle_time_red",
        "threshold_current_call_state_on_call_time_yellow",
        "threshold_current_call_state_on_call_time_red",
        "threshold_current_agent_state_unavailable_time_yellow",
        "threshold_current_agent_state_unavailable_time_red",
        "threshold_average_busy_in_time_yellow",
        "threshold_average_busy_in_time_red",
        "threshold_average_busy_out_time_yellow",
        "threshold_average_busy_out_time_red",
        "threshold_average_wrap_up_time_yellow",
        "threshold_average_wrap_up_time_red",
        "enable_notification_email",
        "notification_email_address",
        "agent_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
            E(
                "profile_description",
                "profileDescription",
                str,
            ),
            E(
                "threshold_current_call_state_idle_time_yellow",
                "thresholdCurrentCallStateIdleTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_idle_time_red",
                "thresholdCurrentCallStateIdleTimeRed",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_yellow",
                "thresholdCurrentCallStateOnCallTimeYellow",
                int,
            ),
            E(
                "threshold_current_call_state_on_call_time_red",
                "thresholdCurrentCallStateOnCallTimeRed",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_yellow",
                "thresholdCurrentAgentStateUnavailableTimeYellow",
                int,
            ),
            E(
                "threshold_current_agent_state_unavailable_time_red",
                "thresholdCurrentAgentStateUnavailableTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_in_time_yellow",
                "thresholdAverageBusyInTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_in_time_red",
                "thresholdAverageBusyInTimeRed",
                int,
            ),
            E(
                "threshold_average_busy_out_time_yellow",
                "thresholdAverageBusyOutTimeYellow",
                int,
            ),
            E(
                "threshold_average_busy_out_time_red",
                "thresholdAverageBusyOutTimeRed",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_yellow",
                "thresholdAverageWrapUpTimeYellow",
                int,
            ),
            E(
                "threshold_average_wrap_up_time_red",
                "thresholdAverageWrapUpTimeRed",
                int,
            ),
            E(
                "enable_notification_email",
                "enableNotificationEmail",
                bool,
                is_required=True,
            ),
            E(
                "notification_email_address",
                "notificationEmailAddress",
                str,
                is_array=True,
            ),
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_array=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a Agent Threshold Profile.

    Agents cannot be unassigned (deleted) directly from the default profile, they need to
    be assigned (added) to a different profile.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        profile_name (str): profileName
        agent_user_id (List[str]): agentUserId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "profile_name",
        "agent_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Call Center Agent Threshold Profile in a Group.

    The default profile cannot be deleted.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        profile_name (str): profileName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "profile_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Threshold Profiles in the Group.

    The response is either `GroupCallCenterAgentThresholdProfileGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterAgentThresholdProfileGetRequest(OCIRequest):
    """
    Gets an existing non-default Call Center Agent Threshold Profile in a Group.

    The response is either a `GroupCallCenterAgentThresholdProfileGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        profile_name (str): profileName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "profile_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "profile_name",
                "profileName",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterAgentUnavailableCodeAddRequest(OCIRequest):
    """
    Add a Call Center Agent Unavailable Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        is_active (bool): isActive
        code (str): code
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "is_active",
        "code",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupCallCenterAgentUnavailableCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Agent Unavailable Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterAgentUnavailableCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Unavailable Codes.

    The response is either `GroupCallCenterAgentUnavailableCodeGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterAgentUnavailableCodeGetRequest(OCIRequest):
    """
    Get a Call Center Agent Unavailable Code.

    The response is either `GroupCallCenterAgentUnavailableCodeGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterAgentUnavailableCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Agent Unavailable Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
        is_active (bool): isActive *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupCallCenterAgentUnavailableCodeSettingsGetRequest(OCIRequest):
    """
    Request the group level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either an `GroupCallCenterAgentUnavailableCodeSettingsGetResponse()`
    or an `ErrorResponse()`. Replaced by
    `GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4(OCIRequest):
    """
    Request the group level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either a
    `GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterBouncedCallGetRequest(OCIRequest):
    """
    Get a call center's bounced call settings.

    The response is either a `GroupCallCenterBouncedCallGetResponse()` or an
    `ErrorResponse()`. Replaced by: `GroupCallCenterBouncedCallGetRequest17()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterBouncedCallGetRequest17(OCIRequest):
    """
    Get a call center's bounced call settings.

    The response is either a `GroupCallCenterBouncedCallGetResponse17()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterBouncedCallModifyRequest(OCIRequest):
    """
    Modify a call center's bounced call settings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode and ignored in XS data mode: enableTransfer
    transferPhoneNumber bounceCallWhenAgentUnavailable alertCallCenterCallOnHold
    alertCallCenterCallOnHoldSeconds bounceCallCenterCallOnHold
    bounceCallCenterCallOnHoldSeconds

    Attributes:
        service_user_id (str): serviceUserId
        is_active (bool): isActive *Optional*
        number_of_rings_before_bouncing_call (int): numberOfRingsBeforeBouncingCall
            *Optional*
        enable_transfer (bool): enableTransfer *Optional*
        transfer_phone_number (str): transferPhoneNumber *Optional*
        bounce_call_when_agent_unavailable (bool): bounceCallWhenAgentUnavailable
            *Optional*
        alert_call_center_call_on_hold (bool): alertCallCenterCallOnHold *Optional*
        alert_call_center_call_on_hold_seconds (int): alertCallCenterCallOnHoldSeconds
            *Optional*
        bounce_call_center_call_on_hold (bool): bounceCallCenterCallOnHold *Optional*
        bounce_call_center_call_on_hold_seconds (int): bounceCallCenterCallOnHoldSeconds
            *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "is_active",
        "number_of_rings_before_bouncing_call",
        "enable_transfer",
        "transfer_phone_number",
        "bounce_call_when_agent_unavailable",
        "alert_call_center_call_on_hold",
        "alert_call_center_call_on_hold_seconds",
        "bounce_call_center_call_on_hold",
        "bounce_call_center_call_on_hold_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "number_of_rings_before_bouncing_call",
                "numberOfRingsBeforeBouncingCall",
                int,
            ),
            E(
                "enable_transfer",
                "enableTransfer",
                bool,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "bounce_call_when_agent_unavailable",
                "bounceCallWhenAgentUnavailable",
                bool,
            ),
            E(
                "alert_call_center_call_on_hold",
                "alertCallCenterCallOnHold",
                bool,
            ),
            E(
                "alert_call_center_call_on_hold_seconds",
                "alertCallCenterCallOnHoldSeconds",
                int,
            ),
            E(
                "bounce_call_center_call_on_hold",
                "bounceCallCenterCallOnHold",
                bool,
            ),
            E(
                "bounce_call_center_call_on_hold_seconds",
                "bounceCallCenterCallOnHoldSeconds",
                int,
            ),
        )


class GroupCallCenterCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupCallCenterCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Call Disposition Codes.

    The response is either `GroupCallCenterCallDispositionCodeGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.

    The response is either `GroupCallCenterCallDispositionCodeGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterCallDispositionCodeGetUsageListRequest(OCIRequest):
    """
    Get the list of Call Centers and Route Points using the specified disposition code.

    The response is either `GroupCallCenterCallDispositionCodeGetUsageListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
        is_active (bool): isActive *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupCallCenterComfortMessageBypassGetRequest(OCIRequest):
    """
    Get a call center's comfort message bypass settings.

    The response is either a `GroupCallCenterComfortMessageBypassGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterComfortMessageBypassGetRequest17(OCIRequest):
    """
    Get a call center's comfort message bypass settings.

    The response is either a `GroupCallCenterComfortMessageBypassGetResponse17()` or an
    `ErrorResponse()`. Replaced by: `GroupCallCenterComfortMessageBypassGetRequest20()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterComfortMessageBypassGetRequest20(OCIRequest):
    """
    Get a call center's comfort message bypass settings.

    The response is either a `GroupCallCenterComfortMessageBypassGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterCurrentAndPastDNISGetListRequest(OCIRequest):
    """
    Request to get all the past and current DNIS for the Call Center for the group.

    The response is either `GroupCallCenterCurrentAndPastDNISGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a call center.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        agent_user_id (List[str]): agentUserId
    """

    __slots__: List[str] = [
        "service_user_id",
        "agent_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "agent_user_id",
                "agentUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCallCenterDeleteInstanceRequest(OCIRequest):
    """
    Delete a Call Center instance from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterDeleteSupervisorListRequest(OCIRequest):
    """
    Delete supervisor(s) from a call center.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        supervisor_user_id (List[str]): supervisorUserId
    """

    __slots__: List[str] = [
        "service_user_id",
        "supervisor_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "supervisor_user_id",
                "supervisorUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCallCenterDistinctiveRingingGetRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for call center.

    The response is either a `GroupCallCenterDistinctiveRingingGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterDistinctiveRingingModifyRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for call center.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    element is only used in AS data mode and ignored in XS data mode:
    distinctiveRingingForceDeliveryRingPattern

    Attributes:
        service_user_id (str): serviceUserId
        distinctive_ringing_call_center_calls (bool): distinctiveRingingCallCenterCalls
            *Optional*
        distinctive_ringing_ring_pattern_for_call_center (str):
            distinctiveRingingRingPatternForCallCenter *Optional*
        distinctive_ringing_force_delivery_ring_pattern (str):
            distinctiveRingingForceDeliveryRingPattern *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "distinctive_ringing_call_center_calls",
        "distinctive_ringing_ring_pattern_for_call_center",
        "distinctive_ringing_force_delivery_ring_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "distinctive_ringing_call_center_calls",
                "distinctiveRingingCallCenterCalls",
                bool,
            ),
            E(
                "distinctive_ringing_ring_pattern_for_call_center",
                "distinctiveRingingRingPatternForCallCenter",
                str,
            ),
            E(
                "distinctive_ringing_force_delivery_ring_pattern",
                "distinctiveRingingForceDeliveryRingPattern",
                str,
            ),
        )


class GroupCallCenterEnhancedGetRequest(OCIRequest):
    """
    Request to get the Call Center Enhanced configuration data for a Call Center.

    The response is either `GroupCallCenterEnhancedGetResponse()` or `ErrorResponse()`.

    Replaced By: `GroupCallCenterGetInstanceResponse16()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedModifyRequest(OCIRequest):
    """
    Modify the Call Center Enhanced configuration data for a Call Center.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Replaced By: `GroupCallCenterModifyInstanceRequest16()`

    Attributes:
        service_user_id (str): serviceUserId
        override_agent_wrap_up_time (bool): overrideAgentWrapUpTime *Optional*
        wrap_up_seconds (int): wrapUpSeconds *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "override_agent_wrap_up_time",
        "wrap_up_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "override_agent_wrap_up_time",
                "overrideAgentWrapUpTime",
                bool,
            ),
            E(
                "wrap_up_seconds",
                "wrapUpSeconds",
                int,
            ),
        )


class GroupCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the group branding information.

    The response is either `GroupCallCenterEnhancedReportingBrandingGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest(OCIRequest):
    """
    Request to get all enabled call center report template for a group.

    The response is either a
    `GroupCallCenterEnhancedReportingGetAvailableReportTemplateListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get a group level call center enhanced reporting setting.

    The response is either a `GroupCallCenterEnhancedReportingGetResponse()` or an
    `ErrorResponse()`. Replaced by `GroupCallCenterEnhancedReportingGetRequest19()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingGetRequest19(OCIRequest):
    """
    Request to get a group level call center enhanced reporting setting.

    The response is either a `GroupCallCenterEnhancedReportingGetResponse19()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Request to modify group level call center enhanced reporting settings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. Replaced by
    `GroupCallCenterEnhancedReportingModifyRequest19()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        reporting_server (str): reportingServer *Optional*
        web_statistic_source (str): webStatisticSource *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "reporting_server",
        "web_statistic_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "reporting_server",
                "reportingServer",
                str,
            ),
            E(
                "web_statistic_source",
                "webStatisticSource",
                str,
            ),
        )


class GroupCallCenterEnhancedReportingModifyRequest19(OCIRequest):
    """
    Request to modify group level call center enhanced reporting settings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        reporting_server (str): reportingServer *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "reporting_server",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "reporting_server",
                "reportingServer",
                str,
            ),
        )


class GroupCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete a group level call center report template.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get group level call center report template list.

    The response is either a
    `GroupCallCenterEnhancedReportingReportTemplateGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get a group level call center report template.

    The response is either a `GroupCallCenterEnhancedReportingReportTemplateGetResponse()`
    or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingScheduledReportDeleteRequest(OCIRequest):
    """
    Request to delete a group level call center reporting scheduled report.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(OCIRequest):
    """
    Request to get all the call center reporting scheduled report in a group that uses a
    given group level report template.

    The response is either a
    `GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()`
    or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterEnhancedReportingScheduledReportGetRequest(OCIRequest):
    """
    Request to get a group level call center reporting scheduled report.

    The response is either a
    `GroupCallCenterEnhancedReportingScheduledReportGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterForcedForwardingGetRequest(OCIRequest):
    """
    Get a call center's forced forwarding settings.

    The response is either a `GroupCallCenterForcedForwardingGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterForcedForwardingGetRequest17(OCIRequest):
    """
    Get a call center's forced forwarding settings.

    The response is either a `GroupCallCenterForcedForwardingGetResponse17()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterForcedForwardingGetRequest20(OCIRequest):
    """
    Get a call center's forced forwarding settings.

    The response is either a `GroupCallCenterForcedForwardingGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetAnnouncementRequest(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a `GroupCallCenterGetAnnouncementResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetAnnouncementRequest14sp6(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a `GroupCallCenterGetAnnouncementResponse14sp6()` or an
    `ErrorResponse()`.

    Replaced By: `GroupCallCenterGetAnnouncementRequest16()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetAnnouncementRequest16(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a `GroupCallCenterGetAnnouncementResponse16()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetAnnouncementRequest17(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a `GroupCallCenterGetAnnouncementResponse17()` or an
    `ErrorResponse()`. Replaced by `GroupCallCenterGetAnnouncementRequest17sp4()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetAnnouncementRequest17sp4(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a `GroupCallCenterGetAnnouncementResponse17sp4()` or an
    `ErrorResponse()`. Replaced by: `GroupCallCenterGetAnnouncementRequest19()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetAnnouncementRequest19(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a `GroupCallCenterGetAnnouncementResponse19()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetAnnouncementRequest20(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a `GroupCallCenterGetAnnouncementResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetAnnouncementRequest22(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a `GroupCallCenterGetAnnouncementResponse22()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetDNISListRequest(OCIRequest):
    """
    Get a list of DNIS that are configured for a Call Center.

    The response is either `GroupCallCenterGetDNISListResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetDistinctiveRingingRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for call center.

    The response is either a `GroupCallCenterGetDistinctiveRingingResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceListRequest(OCIRequest):
    """
    Get a list of Call Center instances within a group.

    The response is either `GroupCallCenterGetInstanceListResponse()` or
    `ErrorResponse()`. It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
        )


class GroupCallCenterGetInstanceQueueStatusRequest(OCIRequest):
    """
    Get Call Center queue status.

    The response is either `GroupCallCenterGetInstanceQueueStatusResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse14()` or `ErrorResponse()`.

    Replaced By: `GroupCallCenterGetInstanceRequest14sp3()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest14sp3(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse14sp3()` or
    `ErrorResponse()`.

    Replaced By: `GroupCallCenterGetInstanceRequest14sp9()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest14sp9(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse14sp9()` or
    `ErrorResponse()`.

    Replaced By: `GroupCallCenterGetInstanceRequest16()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest16(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse16()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse17()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest17sp1(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse17sp1()` or
    `ErrorResponse()`. Replaced by: `GroupCallCenterGetInstanceRequest17sp3()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse17sp3()` or
    `ErrorResponse()`. Replaced by `GroupCallCenterGetInstanceRequest19()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse19()` or `ErrorResponse()`.
    Replaced by: `GroupCallCenterGetInstanceRequest19sp1()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse19sp1()` or
    `ErrorResponse()`. Replaced by `GroupCallCenterGetInstanceRequest22()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceRequest22(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either `GroupCallCenterGetInstanceResponse22()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceStatisticsReportingRequest(OCIRequest):
    """
    Request to get the call center statistics reporting settings.

    The response is either `GroupCallCenterGetInstanceStatisticsReportingResponse()` or
    `ErrorResponse()`.

    Replaced By: `GroupCallCenterGetInstanceStatisticsReportingRequest16()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceStatisticsReportingRequest16(OCIRequest):
    """
    Request to get the call center statistics reporting settings.

    The response is either `GroupCallCenterGetInstanceStatisticsReportingResponse16()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceStatisticsReportingRequest17sp1(OCIRequest):
    """
    Request to get the call center statistics reporting settings.

    The response is either `GroupCallCenterGetInstanceStatisticsReportingResponse17sp1()`
    or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetInstanceStatisticsRequest13mp8(OCIRequest):
    """
    Get Call Center queue and agent statistics.

    The response is either `GroupCallCenterGetInstanceStatisticsResponse13mp8()` or
    `ErrorResponse()`.

    Replaced By: `GroupCallCenterGetInstanceStatisticsRequest14sp9()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetRequest(OCIRequest):
    """
    Request the Group level data associated with Call Center.

    The response is either a `GroupCallCenterGetResponse()` or an `ErrorResponse()`.
    Replaced by `GroupCallCenterGetRequest17sp4()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the Group level data associated with Call Center.

    The response is either a `GroupCallCenterGetResponse17sp4()` or an `ErrorResponse()`.
    Replaced by: `GroupCallCenterGetRequest23()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetRequest23(OCIRequest):
    """
    Request the Group level data associated with Call Center.

    The response is either a `GroupCallCenterGetResponse23()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetRoutingPolicyRequest(OCIRequest):
    """
    Request the group call center routing policy.

    The response is either a `GroupCallCenterGetRoutingPolicyResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetSupervisorListRequest(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.

    Only users in the same group or enterprise as this call center can successfully
    execute this request.

    The response is either a `GroupCallCenterGetSupervisorListResponse()` or an
    `ErrorResponse()`.

    Replaced By: `GroupCallCenterSupervisorReportingGetRequest()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetSupervisorListRequest16(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.

    The response is either a `GroupCallCenterGetSupervisorListResponse16()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterGetUnlicensedAgentListRequest(OCIRequest):
    """
    Get a list of unlicensed users who are preventing the Call Center from upgrading to
    another type.

    The response is either `GroupCallCenterGetUnlicensedAgentListRequest()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        call_center_type (str): callCenterType
    """

    __slots__: List[str] = [
        "service_user_id",
        "call_center_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "call_center_type",
                "callCenterType",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterHolidayServiceGetRequest(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a `GroupCallCenterHolidayServiceGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterHolidayServiceGetRequest17(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a `GroupCallCenterHolidayServiceGetResponse17()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterHolidayServiceGetRequest17sp1(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a `GroupCallCenterHolidayServiceGetResponse17sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterHolidayServiceGetRequest20(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a `GroupCallCenterHolidayServiceGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterModifyDNISParametersRequest(OCIRequest):
    """
    Modify the setting that are configured for all the DNIS in a Call Center.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        display_dnis_number (bool): displayDNISNumber *Optional*
        display_dnis_name (bool): displayDNISName *Optional*
        promote_calls_from_priority1to0 (bool): promoteCallsFromPriority1to0 *Optional*
        promote_calls_from_priority2to1 (bool): promoteCallsFromPriority2to1 *Optional*
        promote_calls_from_priority3to2 (bool): promoteCallsFromPriority3to2 *Optional*
        promote_calls_from_priority1to0_seconds (int): promoteCallsFromPriority1to0Seconds
            *Optional*
        promote_calls_from_priority2to1_seconds (int): promoteCallsFromPriority2to1Seconds
            *Optional*
        promote_calls_from_priority3to2_seconds (int): promoteCallsFromPriority3to2Seconds
            *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "display_dnis_number",
        "display_dnis_name",
        "promote_calls_from_priority1to0",
        "promote_calls_from_priority2to1",
        "promote_calls_from_priority3to2",
        "promote_calls_from_priority1to0_seconds",
        "promote_calls_from_priority2to1_seconds",
        "promote_calls_from_priority3to2_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "display_dnis_number",
                "displayDNISNumber",
                bool,
            ),
            E(
                "display_dnis_name",
                "displayDNISName",
                bool,
            ),
            E(
                "promote_calls_from_priority1to0",
                "promoteCallsFromPriority1to0",
                bool,
            ),
            E(
                "promote_calls_from_priority2to1",
                "promoteCallsFromPriority2to1",
                bool,
            ),
            E(
                "promote_calls_from_priority3to2",
                "promoteCallsFromPriority3to2",
                bool,
            ),
            E(
                "promote_calls_from_priority1to0_seconds",
                "promoteCallsFromPriority1to0Seconds",
                int,
            ),
            E(
                "promote_calls_from_priority2to1_seconds",
                "promoteCallsFromPriority2to1Seconds",
                int,
            ),
            E(
                "promote_calls_from_priority3to2_seconds",
                "promoteCallsFromPriority3to2Seconds",
                int,
            ),
        )


class GroupCallCenterModifyDistinctiveRingingRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for call center.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        distinctive_ringing_call_center_calls (bool): distinctiveRingingCallCenterCalls
            *Optional*
        distinctive_ringing_ring_pattern_for_call_center (str):
            distinctiveRingingRingPatternForCallCenter *Optional*
        distinctive_ringing_force_delivery_ring_pattern (str):
            distinctiveRingingForceDeliveryRingPattern *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "distinctive_ringing_call_center_calls",
        "distinctive_ringing_ring_pattern_for_call_center",
        "distinctive_ringing_force_delivery_ring_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "distinctive_ringing_call_center_calls",
                "distinctiveRingingCallCenterCalls",
                bool,
            ),
            E(
                "distinctive_ringing_ring_pattern_for_call_center",
                "distinctiveRingingRingPatternForCallCenter",
                str,
            ),
            E(
                "distinctive_ringing_force_delivery_ring_pattern",
                "distinctiveRingingForceDeliveryRingPattern",
                str,
            ),
        )


class GroupCallCenterModifyInstanceStatisticsReportingRequest(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Replaced By: `GroupCallCenterModifyInstanceStatisticsReportingRequest14sp9()`

    Attributes:
        service_user_id (str): serviceUserId
        clear_today_statistics (bool): clearTodayStatistics *Optional*
        generate_daily_report (bool): generateDailyReport *Optional*
        collection_period_minutes (int): collectionPeriodMinutes *Optional*
        reporting_email_address1 (str): reportingEmailAddress1 *Optional*
        reporting_email_address2 (str): reportingEmailAddress2 *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "clear_today_statistics",
        "generate_daily_report",
        "collection_period_minutes",
        "reporting_email_address1",
        "reporting_email_address2",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "clear_today_statistics",
                "clearTodayStatistics",
                bool,
            ),
            E(
                "generate_daily_report",
                "generateDailyReport",
                bool,
            ),
            E(
                "collection_period_minutes",
                "collectionPeriodMinutes",
                int,
            ),
            E(
                "reporting_email_address1",
                "reportingEmailAddress1",
                str,
            ),
            E(
                "reporting_email_address2",
                "reportingEmailAddress2",
                str,
            ),
        )


class GroupCallCenterModifyInstanceStatisticsReportingRequest14sp9(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        generate_daily_report (bool): generateDailyReport *Optional*
        collection_period_minutes (int): collectionPeriodMinutes *Optional*
        reporting_email_address1 (str): reportingEmailAddress1 *Optional*
        reporting_email_address2 (str): reportingEmailAddress2 *Optional*
        statistics_source (str): statisticsSource *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "generate_daily_report",
        "collection_period_minutes",
        "reporting_email_address1",
        "reporting_email_address2",
        "statistics_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "generate_daily_report",
                "generateDailyReport",
                bool,
            ),
            E(
                "collection_period_minutes",
                "collectionPeriodMinutes",
                int,
            ),
            E(
                "reporting_email_address1",
                "reportingEmailAddress1",
                str,
            ),
            E(
                "reporting_email_address2",
                "reportingEmailAddress2",
                str,
            ),
            E(
                "statistics_source",
                "statisticsSource",
                str,
            ),
        )


class GroupCallCenterModifyInstanceStatisticsReportingRequest17sp1(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        generate_daily_report (bool): generateDailyReport *Optional*
        collection_period_minutes (int): collectionPeriodMinutes *Optional*
        reporting_email_address1 (str): reportingEmailAddress1 *Optional*
        reporting_email_address2 (str): reportingEmailAddress2 *Optional*
        statistics_source (str): statisticsSource *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "generate_daily_report",
        "collection_period_minutes",
        "reporting_email_address1",
        "reporting_email_address2",
        "statistics_source",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "generate_daily_report",
                "generateDailyReport",
                bool,
            ),
            E(
                "collection_period_minutes",
                "collectionPeriodMinutes",
                int,
            ),
            E(
                "reporting_email_address1",
                "reportingEmailAddress1",
                str,
            ),
            E(
                "reporting_email_address2",
                "reportingEmailAddress2",
                str,
            ),
            E(
                "statistics_source",
                "statisticsSource",
                str,
            ),
        )


class GroupCallCenterModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Call Center and the active status of Call
    Center instances.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode and ignored in XS data mode:
    useSystemDefaultUnavailableSettings forceAgentUnavailableOnDNDActivation
    forceAgentUnavailableOnPersonalCalls forceAgentUnavailableOnBouncedCallLimit
    numberConsecutiveBouncedCallsToForceAgentUnavailable
    forceAgentUnavailableOnNotReachable wrapUpDestination

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_system_default_guard_timer (bool): useSystemDefaultGuardTimer *Optional*
        enable_guard_timer (bool): enableGuardTimer *Optional*
        guard_timer_seconds (int): guardTimerSeconds *Optional*
        use_system_default_unavailable_settings (bool):
            useSystemDefaultUnavailableSettings *Optional*
        force_agent_unavailable_on_dnd_activation (bool):
            forceAgentUnavailableOnDNDActivation *Optional*
        force_agent_unavailable_on_personal_calls (bool):
            forceAgentUnavailableOnPersonalCalls *Optional*
        force_agent_unavailable_on_bounced_call_limit (bool):
            forceAgentUnavailableOnBouncedCallLimit *Optional*
        number_consecutive_bounced_calls_to_force_agent_unavailable (int):
            numberConsecutiveBouncedCallsToForceAgentUnavailable *Optional*
        force_agent_unavailable_on_not_reachable (bool):
            forceAgentUnavailableOnNotReachable *Optional*
        wrap_up_destination (str): wrapUpDestination *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_system_default_guard_timer",
        "enable_guard_timer",
        "guard_timer_seconds",
        "use_system_default_unavailable_settings",
        "force_agent_unavailable_on_dnd_activation",
        "force_agent_unavailable_on_personal_calls",
        "force_agent_unavailable_on_bounced_call_limit",
        "number_consecutive_bounced_calls_to_force_agent_unavailable",
        "force_agent_unavailable_on_not_reachable",
        "wrap_up_destination",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_system_default_guard_timer",
                "useSystemDefaultGuardTimer",
                bool,
            ),
            E(
                "enable_guard_timer",
                "enableGuardTimer",
                bool,
            ),
            E(
                "guard_timer_seconds",
                "guardTimerSeconds",
                int,
            ),
            E(
                "use_system_default_unavailable_settings",
                "useSystemDefaultUnavailableSettings",
                bool,
            ),
            E(
                "force_agent_unavailable_on_dnd_activation",
                "forceAgentUnavailableOnDNDActivation",
                bool,
            ),
            E(
                "force_agent_unavailable_on_personal_calls",
                "forceAgentUnavailableOnPersonalCalls",
                bool,
            ),
            E(
                "force_agent_unavailable_on_bounced_call_limit",
                "forceAgentUnavailableOnBouncedCallLimit",
                bool,
            ),
            E(
                "number_consecutive_bounced_calls_to_force_agent_unavailable",
                "numberConsecutiveBouncedCallsToForceAgentUnavailable",
                int,
            ),
            E(
                "force_agent_unavailable_on_not_reachable",
                "forceAgentUnavailableOnNotReachable",
                bool,
            ),
            E(
                "wrap_up_destination",
                "wrapUpDestination",
                str,
            ),
        )


class GroupCallCenterMonitoringGetRequest(OCIRequest):
    """
    Request the Group level data associated with Call Center Monitoring.

    The response is either a `GroupCallCenterMonitoringGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterMonitoringModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Call Center Monitoring The response is
    either a `SuccessResponse()` or an `ErrorResponse()`.


    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enable_supervisor_coaching (bool): enableSupervisorCoaching *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enable_supervisor_coaching",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enable_supervisor_coaching",
                "enableSupervisorCoaching",
                bool,
            ),
        )


class GroupCallCenterNightServiceGetRequest(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a `GroupCallCenterNightServiceGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterNightServiceGetRequest17(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a `GroupCallCenterNightServiceGetResponse17()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterNightServiceGetRequest17sp1(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a `GroupCallCenterNightServiceGetResponse17sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterNightServiceGetRequest20(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a `GroupCallCenterNightServiceGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterOverflowGetRequest(OCIRequest):
    """
    Get a call center's overflow settings.

    The response is either a `GroupCallCenterOverflowGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterOverflowGetRequest17(OCIRequest):
    """
    Get a call center's overflow settings.

    The response is either a `GroupCallCenterOverflowGetResponse17()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterOverflowGetRequest20(OCIRequest):
    """
    Get a call center's overflow settings.

    The response is either a `GroupCallCenterOverflowGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterQueueCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        code (str): code
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupCallCenterQueueCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        code (str): code
    """

    __slots__: List[str] = [
        "service_user_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterQueueCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Level and Organization Level Call Disposition Codes.

    The response is either `GroupCallCenterQueueCallDispositionCodeGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterQueueCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.

    The response is either `GroupCallCenterQueueCallDispositionCodeGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        code (str): code
    """

    __slots__: List[str] = [
        "service_user_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterQueueCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        code (str): code
        is_active (bool): isActive *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupCallCenterQueueCallDispositionCodeSettingsGetRequest(OCIRequest):
    """
    Request the user level data associated with Call Center Call Disposition Code
    Settings.

    The response is either a
    `GroupCallCenterQueueCallDispositionCodeSettingsGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterQueueStatusNotificationGetRequest(OCIRequest):
    """
    Get the status configuration for a given call center.

    The response is either a `GroupCallCenterQueueStatusNotificationGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterQueueStatusNotificationModifyRequest(OCIRequest):
    """
    Set the status configuration for a given call center.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        enable_queue_status_notification (bool): enableQueueStatusNotification *Optional*
        enable_queue_depth_threshold (bool): enableQueueDepthThreshold *Optional*
        enable_waiting_time_threshold (bool): enableWaitingTimeThreshold *Optional*
        number_of_calls_threshold (int): numberOfCallsThreshold *Optional*
        waiting_time_of_calls_threshold (int): waitingTimeOfCallsThreshold *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "enable_queue_status_notification",
        "enable_queue_depth_threshold",
        "enable_waiting_time_threshold",
        "number_of_calls_threshold",
        "waiting_time_of_calls_threshold",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "enable_queue_status_notification",
                "enableQueueStatusNotification",
                bool,
            ),
            E(
                "enable_queue_depth_threshold",
                "enableQueueDepthThreshold",
                bool,
            ),
            E(
                "enable_waiting_time_threshold",
                "enableWaitingTimeThreshold",
                bool,
            ),
            E(
                "number_of_calls_threshold",
                "numberOfCallsThreshold",
                int,
            ),
            E(
                "waiting_time_of_calls_threshold",
                "waitingTimeOfCallsThreshold",
                int,
            ),
        )


class GroupCallCenterQueueThresholdsGetRequest(OCIRequest):
    """
    Get a call center's queue Thresholds settings.

    The response is either a `GroupCallCenterQueueThresholdsGetRequest()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterStrandedCallGetRequest(OCIRequest):
    """
    Get a call center's stranded call settings.

    The response is either a `GroupCallCenterStrandedCallGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterStrandedCallGetRequest17(OCIRequest):
    """
    Get a call center's stranded call settings.

    The response is either a `GroupCallCenterStrandedCallGetResponse17()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterStrandedCallGetRequest20(OCIRequest):
    """
    Get a call center's stranded call settings.

    The response is either a `GroupCallCenterStrandedCallGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterStrandedCallUnavailableGetRequest(OCIRequest):
    """
    Get a call center's stranded calls - unavailable settings.

    The response is either a `GroupCallCenterStrandedCallUnavailableGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterStrandedCallUnavailableGetRequest20(OCIRequest):
    """
    Get a call center's stranded calls - unavailable settings.

    The response is either a `GroupCallCenterStrandedCallUnavailableGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallCenterSupervisorReportingGetRequest(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.

    Only users in the same group or enterprise as this call center can successfully
    execute this request.

    The response is either a `GroupCallCenterSupervisorReportingGetResponse()` or an
    `ErrorResponse()`.

    Replaced By: `GroupCallCenterGetSupervisorListRequest16()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCallParkAddInstanceRequest(OCIRequest):
    """
    Adds a Call Park group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        user_id (List[str]): userId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_array=True,
            ),
        )


class GroupCallParkAddInstanceRequest16sp2(OCIRequest):
    """
    Adds a Call Park group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        user_id (List[str]): userId *Optional*
        recall_alternate_user_id (str): recallAlternateUserId *Optional*
        recall_to (str): recallTo
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "user_id",
        "recall_alternate_user_id",
        "recall_to",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_array=True,
            ),
            E(
                "recall_alternate_user_id",
                "recallAlternateUserId",
                str,
            ),
            E(
                "recall_to",
                "recallTo",
                str,
                is_required=True,
            ),
        )


class GroupCallParkDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Call Park group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallParkGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Park group instances within a group.

    The response is either `GroupCallParkGetInstanceListResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallParkGetInstanceRequest(OCIRequest):
    """
    Gets a Call Park group.

    The response is either `GroupCallParkGetInstanceResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallParkGetInstanceRequest16sp2(OCIRequest):
    """
    Gets a Call Park group.

    The response is either `GroupCallParkGetInstanceResponse16sp2()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallParkGetRequest(OCIRequest):
    """
    Gets the Call Park Group settings.

    The response is either `GroupCallParkGetResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallParkGetRequest16sp2(OCIRequest):
    """
    Gets the Call Park Group settings.

    The response is either `GroupCallParkGetResponse16sp2()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallParkModifyRequest(OCIRequest):
    """
    Modifies the Group's Call Park settings.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        recall_timer_seconds (int): recallTimerSeconds *Optional*
        display_timer_seconds (int): displayTimerSeconds *Optional*
        enable_destination_announcement (bool): enableDestinationAnnouncement *Optional*
        recall_alternate_user_id (str): recallAlternateUserId *Optional*
        recall_ring_pattern (str): recallRingPattern *Optional*
        recall_to (str): recallTo *Optional*
        alternate_user_recall_timer_seconds (int): alternateUserRecallTimerSeconds
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "recall_timer_seconds",
        "display_timer_seconds",
        "enable_destination_announcement",
        "recall_alternate_user_id",
        "recall_ring_pattern",
        "recall_to",
        "alternate_user_recall_timer_seconds",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "recall_timer_seconds",
                "recallTimerSeconds",
                int,
            ),
            E(
                "display_timer_seconds",
                "displayTimerSeconds",
                int,
            ),
            E(
                "enable_destination_announcement",
                "enableDestinationAnnouncement",
                bool,
            ),
            E(
                "recall_alternate_user_id",
                "recallAlternateUserId",
                str,
            ),
            E(
                "recall_ring_pattern",
                "recallRingPattern",
                str,
            ),
            E(
                "recall_to",
                "recallTo",
                str,
            ),
            E(
                "alternate_user_recall_timer_seconds",
                "alternateUserRecallTimerSeconds",
                int,
            ),
        )


class GroupCallPickupAddInstanceRequest(OCIRequest):
    """
    Adds a Call Pickup group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        user_id (List[str]): userId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_array=True,
            ),
        )


class GroupCallPickupDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Call Pickup group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallPickupGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Pickup instances within a group.

    The response is either `GroupCallPickupGetInstanceListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallPickupGetInstanceRequest(OCIRequest):
    """
    Gets a Call Pickup group.

    The response is either `GroupCallPickupGetInstanceResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest14(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse14()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest14sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse14sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest14sp4(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse14sp4()` or an
    `ErrorResponse()`.

    Replaced By : `GroupCallProcessingGetPolicyRequest15()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest14sp7(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse14sp7()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Replaced By: `GroupCallProcessingGetPolicyRequest16()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest15(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse15()` or an
    `ErrorResponse()`.

    Replaced By: `GroupCallProcessingGetPolicyRequest16()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest15sp2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse15sp2()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest16(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse16()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest16sp2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse16sp2()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The useGroupDCLIDSetting controls the Dialable
    Caller ID settings (enableDialableCallerID)

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest17(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse17()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest17sp3(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse17sp3()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The useGroupDCLIDSetting controls the Dialable
    Caller ID settings (enableDialableCallerID) The following elements are only used in AS
    data mode: useGroupDCLIDSetting enableDialableCallerID Replaced by
    `GroupCallProcessingGetPolicyRequest17sp4()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest17sp4(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse17sp4()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName, allowConfigurableCLIDForRedirectingIdentity) The useGroupMediaSetting
    attribute controls the Media settings (medisPolicySelection, supportedMediaSetName)
    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls, useMaxSimultaneousVideoCalls,
    maxSimultaneousVideoCalls, useMaxCallTimeForAnsweredCalls,
    maxCallTimeForAnsweredCallsMinutes, useMaxCallTimeForUnansweredCalls,
    maxCallTimeForUnansweredCallsMinutes, useMaxConcurrentRedirectedCalls,
    useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID Replaced by
    `GroupCallProcessingGetPolicyRequest18()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest18(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse18()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName, allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute
    controls the Media settings (medisPolicySelection, supportedMediaSetName) The
    useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls, useMaxSimultaneousVideoCalls,
    maxSimultaneousVideoCalls, useMaxCallTimeForAnsweredCalls,
    maxCallTimeForAnsweredCallsMinutes, useMaxCallTimeForUnansweredCalls,
    maxCallTimeForUnansweredCallsMinutes, useMaxConcurrentRedirectedCalls,
    useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID allowDepartmentCLIDNameOverride

    Replaced By : `GroupCallProcessingGetPolicyRequest18sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest18sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse18sp1()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) Replaced by:
    `GroupCallProcessingGetPolicyRequest19sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest19sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse19sp1()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) Replaced by:
    `GroupCallProcessingGetPolicyRequest21sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest21sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse21sp1()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) Replaced by:
    `GroupCallProcessingGetPolicyRequest21sp2()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest21sp2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse21sp2()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing, routeOverrideDomain, routeOverridePrefix) Replaced
    by: `GroupCallProcessingGetPolicyRequest22()` in AS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest22(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse22()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations,
    useMaxConcurrentTerminatingAlertingRequests, maxConcurrentTerminatingAlertingRequests)
    The useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) Replaced by:
    `GroupCallProcessingGetPolicyRequest22V2()` in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest22V2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse22V2()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations,
    useMaxConcurrentTerminatingAlertingRequests, maxConcurrentTerminatingAlertingRequests)
    The useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) Replaced by:
    `GroupCallProcessingGetPolicyRequest22V3()` in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingGetPolicyRequest22V3(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a `GroupCallProcessingGetPolicyResponse22V3()` or an
    `ErrorResponse()`. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations,
    useMaxConcurrentTerminatingAlertingRequests, maxConcurrentTerminatingAlertingRequests)
    The useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallProcessingModifyPolicyRequest14(OCIRequest):
    """
    Modify the group level data associated with Call Processing Policy.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Replaced By : `GroupCallProcessingModifyPolicyRequest15()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_group_setting (bool): useGroupSetting *Optional*
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls *Optional*
        max_simultaneous_calls (int): maxSimultaneousCalls *Optional*
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls *Optional*
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls *Optional*
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
            *Optional*
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
            *Optional*
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
            *Optional*
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes *Optional*
        media_policy_selection (str): mediaPolicySelection *Optional*
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection *Optional*
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction *Optional*
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan *Optional*
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan *Optional*
        override_clid_restriction_for_external_calls_via_private_dialing_plan (bool):
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
            *Optional*
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
            *Optional*
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls *Optional*
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth *Optional*
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth *Optional*
        max_redirection_depth (int): maxRedirectionDepth *Optional*
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations *Optional*
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_group_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_external_calls_via_private_dialing_plan",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_group_setting",
                "useGroupSetting",
                bool,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
            ),
            E(
                "override_clid_restriction_for_external_calls_via_private_dialing_plan",
                "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
            ),
        )


class GroupCallProcessingModifyPolicyRequest14sp7(OCIRequest):
    """
    Modify the group level data associated with Call Processing Policy.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The
    useGroupCLIDSetting attribute controls the CLID settings (clidPolicy,
    emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity, useGroupName) The
    useGroupMediaSetting attribute controls the Media settings (medisPolicySelection,
    supportedMediaSetName) The useGroupCallLimitsSetting attribute controls the Call
    Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Replaced By: `GroupCallProcessingModifyPolicyRequest15sp2()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_group_clid_setting (bool): useGroupCLIDSetting *Optional*
        use_group_media_setting (bool): useGroupMediaSetting *Optional*
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting *Optional*
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
            *Optional*
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls *Optional*
        max_simultaneous_calls (int): maxSimultaneousCalls *Optional*
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls *Optional*
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls *Optional*
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
            *Optional*
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
            *Optional*
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
            *Optional*
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes *Optional*
        media_policy_selection (str): mediaPolicySelection *Optional*
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection *Optional*
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction *Optional*
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan *Optional*
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan *Optional*
        override_clid_restriction_for_external_calls_via_private_dialing_plan (bool):
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
            *Optional*
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
            *Optional*
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls *Optional*
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth *Optional*
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth *Optional*
        max_redirection_depth (int): maxRedirectionDepth *Optional*
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations *Optional*
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations *Optional*
        clid_policy (str): clidPolicy *Optional*
        emergency_clid_policy (str): emergencyClidPolicy *Optional*
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity *Optional*
        use_group_name (bool): useGroupName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_external_calls_via_private_dialing_plan",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
            ),
            E(
                "override_clid_restriction_for_external_calls_via_private_dialing_plan",
                "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
            ),
        )


class GroupCallProcessingModifyPolicyRequest15(OCIRequest):
    """
    Modify the group level data associated with Call Processing Policy.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Replaced By: `GroupCallProcessingModifyPolicyRequest15sp2()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_group_setting (bool): useGroupSetting *Optional*
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls *Optional*
        max_simultaneous_calls (int): maxSimultaneousCalls *Optional*
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls *Optional*
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls *Optional*
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
            *Optional*
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
            *Optional*
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
            *Optional*
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes *Optional*
        media_policy_selection (str): mediaPolicySelection *Optional*
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection *Optional*
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction *Optional*
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan *Optional*
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan *Optional*
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
            *Optional*
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
            *Optional*
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls *Optional*
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth *Optional*
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth *Optional*
        max_redirection_depth (int): maxRedirectionDepth *Optional*
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations *Optional*
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_group_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_group_setting",
                "useGroupSetting",
                bool,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
            ),
        )


class GroupCallProcessingModifyPolicyRequest15sp2(OCIRequest):
    """
    Modify the group level data associated with Call Processing Policy.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The
    useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowConfigurableCLIDForRedirectingIdentity, allowDepartmentCLIDNameOverride
    useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable,
    useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailabl) The
    allowDepartmentCLID attribute is automatically set to false when the useGroupName
    attribute is set to false.  The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations,
    useMaxConcurrentTerminatingAlertingRequests, maxConcurrentTerminatingAlertingRequests,
    includeRedirectionsInMaximumNumberOfConcurrentCalls) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing, routeOverrideDomain, routeOverridePrefix) The
    useGroupDCLIDSetting controls the Dialable Caller ID settings (enableDialableCallerID)
    The useGroupPhoneListLookupSetting controls whether or not to use the
    enterprise/service provider setting for the Phone List Lookup policy
    (enablePhoneListLookup) The following elements are only used in AS data mode:
    useGroupDCLIDSetting enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity allowDepartmentCLIDNameOverride The
    following elements are only used in AS data mode and ignored in XS data mode:
    useGroupPhoneListLookupSetting enablePhoneListLookup
    useMaxConcurrentTerminatingAlertingRequests maxConcurrentTerminatingAlertingRequests
    includeRedirectionsInMaximumNumberOfConcurrentCalls
    useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable
    useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable
    allowMobileDNForRedirectingIdentity enableGatewayRoutePolicy
    networkCallsGatewayRouteIdentity networkURLCallsGatewayRouteIdentity
    emergencyCallsGatewayRouteIdentity repairCallsGatewayRouteIdentity
    callTypingErrorsGatewayRouteIdentity The following elements are only used in XS data
    mode and ignored in AS data mode: routeOverrideDomain routeOverridePrefix

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_group_clid_setting (bool): useGroupCLIDSetting *Optional*
        use_group_media_setting (bool): useGroupMediaSetting *Optional*
        use_group_call_limits_setting (bool): useGroupCallLimitsSetting *Optional*
        use_group_translation_routing_setting (bool): useGroupTranslationRoutingSetting
            *Optional*
        use_group_dclid_setting (bool): useGroupDCLIDSetting *Optional*
        use_max_simultaneous_calls (bool): useMaxSimultaneousCalls *Optional*
        max_simultaneous_calls (int): maxSimultaneousCalls *Optional*
        use_max_simultaneous_video_calls (bool): useMaxSimultaneousVideoCalls *Optional*
        max_simultaneous_video_calls (int): maxSimultaneousVideoCalls *Optional*
        use_max_call_time_for_answered_calls (bool): useMaxCallTimeForAnsweredCalls
            *Optional*
        max_call_time_for_answered_calls_minutes (int): maxCallTimeForAnsweredCallsMinutes
            *Optional*
        use_max_call_time_for_unanswered_calls (bool): useMaxCallTimeForUnansweredCalls
            *Optional*
        max_call_time_for_unanswered_calls_minutes (int):
            maxCallTimeForUnansweredCallsMinutes *Optional*
        media_policy_selection (str): mediaPolicySelection *Optional*
        supported_media_set_name (str): supportedMediaSetName *Optional*
        network_usage_selection (str): networkUsageSelection *Optional*
        enforce_group_calling_line_identity_restriction (bool):
            enforceGroupCallingLineIdentityRestriction *Optional*
        allow_enterprise_group_call_typing_for_private_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPrivateDialingPlan *Optional*
        allow_enterprise_group_call_typing_for_public_dialing_plan (bool):
            allowEnterpriseGroupCallTypingForPublicDialingPlan *Optional*
        override_clid_restriction_for_private_call_category (bool):
            overrideCLIDRestrictionForPrivateCallCategory *Optional*
        use_enterprise_clid_for_private_call_category (bool):
            useEnterpriseCLIDForPrivateCallCategory *Optional*
        enable_enterprise_extension_dialing (bool): enableEnterpriseExtensionDialing
            *Optional*
        use_max_concurrent_redirected_calls (bool): useMaxConcurrentRedirectedCalls
            *Optional*
        max_concurrent_redirected_calls (int): maxConcurrentRedirectedCalls *Optional*
        use_max_find_me_follow_me_depth (bool): useMaxFindMeFollowMeDepth *Optional*
        max_find_me_follow_me_depth (int): maxFindMeFollowMeDepth *Optional*
        max_redirection_depth (int): maxRedirectionDepth *Optional*
        use_max_concurrent_find_me_follow_me_invocations (bool):
            useMaxConcurrentFindMeFollowMeInvocations *Optional*
        max_concurrent_find_me_follow_me_invocations (int):
            maxConcurrentFindMeFollowMeInvocations *Optional*
        clid_policy (str): clidPolicy *Optional*
        emergency_clid_policy (str): emergencyClidPolicy *Optional*
        allow_alternate_numbers_for_redirecting_identity (bool):
            allowAlternateNumbersForRedirectingIdentity *Optional*
        use_group_name (bool): useGroupName *Optional*
        block_calling_name_for_external_calls (bool): blockCallingNameForExternalCalls
            *Optional*
        enable_dialable_caller_id (bool): enableDialableCallerID *Optional*
        allow_configurable_clid_for_redirecting_identity (bool):
            allowConfigurableCLIDForRedirectingIdentity *Optional*
        allow_department_clid_name_override (bool): allowDepartmentCLIDNameOverride
            *Optional*
        enterprise_calls_clid_policy (str): enterpriseCallsCLIDPolicy *Optional*
        group_calls_clid_policy (str): groupCallsCLIDPolicy *Optional*
        use_group_phone_list_lookup_setting (bool): useGroupPhoneListLookupSetting
            *Optional*
        enable_phone_list_lookup (bool): enablePhoneListLookup *Optional*
        use_max_concurrent_terminating_alerting_requests (bool):
            useMaxConcurrentTerminatingAlertingRequests *Optional*
        max_concurrent_terminating_alerting_requests (int):
            maxConcurrentTerminatingAlertingRequests *Optional*
        include_redirections_in_maximum_number_of_concurrent_calls (bool):
            includeRedirectionsInMaximumNumberOfConcurrentCalls *Optional*
        use_user_phone_number_for_group_calls_when_internal_clid_unavailable (bool):
            useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable *Optional*
        use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable (bool):
            useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable *Optional*
        route_override_domain (str): routeOverrideDomain *Optional*
        route_override_prefix (str): routeOverridePrefix *Optional*
        allow_mobile_dn_for_redirecting_identity (bool):
            allowMobileDNForRedirectingIdentity *Optional*
        enable_gateway_route_policy (bool): enableGatewayRoutePolicy *Optional*
        network_calls_gateway_route_identity (str): networkCallsGatewayRouteIdentity
            *Optional*
        network_url_calls_gateway_route_identity (str):
            networkURLCallsGatewayRouteIdentity *Optional*
        emergency_calls_gateway_route_identity (str): emergencyCallsGatewayRouteIdentity
            *Optional*
        repair_calls_gateway_route_identity (str): repairCallsGatewayRouteIdentity
            *Optional*
        call_typing_errors_gateway_route_identity (str):
            callTypingErrorsGatewayRouteIdentity *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_group_clid_setting",
        "use_group_media_setting",
        "use_group_call_limits_setting",
        "use_group_translation_routing_setting",
        "use_group_dclid_setting",
        "use_max_simultaneous_calls",
        "max_simultaneous_calls",
        "use_max_simultaneous_video_calls",
        "max_simultaneous_video_calls",
        "use_max_call_time_for_answered_calls",
        "max_call_time_for_answered_calls_minutes",
        "use_max_call_time_for_unanswered_calls",
        "max_call_time_for_unanswered_calls_minutes",
        "media_policy_selection",
        "supported_media_set_name",
        "network_usage_selection",
        "enforce_group_calling_line_identity_restriction",
        "allow_enterprise_group_call_typing_for_private_dialing_plan",
        "allow_enterprise_group_call_typing_for_public_dialing_plan",
        "override_clid_restriction_for_private_call_category",
        "use_enterprise_clid_for_private_call_category",
        "enable_enterprise_extension_dialing",
        "use_max_concurrent_redirected_calls",
        "max_concurrent_redirected_calls",
        "use_max_find_me_follow_me_depth",
        "max_find_me_follow_me_depth",
        "max_redirection_depth",
        "use_max_concurrent_find_me_follow_me_invocations",
        "max_concurrent_find_me_follow_me_invocations",
        "clid_policy",
        "emergency_clid_policy",
        "allow_alternate_numbers_for_redirecting_identity",
        "use_group_name",
        "block_calling_name_for_external_calls",
        "enable_dialable_caller_id",
        "allow_configurable_clid_for_redirecting_identity",
        "allow_department_clid_name_override",
        "enterprise_calls_clid_policy",
        "group_calls_clid_policy",
        "use_group_phone_list_lookup_setting",
        "enable_phone_list_lookup",
        "use_max_concurrent_terminating_alerting_requests",
        "max_concurrent_terminating_alerting_requests",
        "include_redirections_in_maximum_number_of_concurrent_calls",
        "use_user_phone_number_for_group_calls_when_internal_clid_unavailable",
        "use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable",
        "route_override_domain",
        "route_override_prefix",
        "allow_mobile_dn_for_redirecting_identity",
        "enable_gateway_route_policy",
        "network_calls_gateway_route_identity",
        "network_url_calls_gateway_route_identity",
        "emergency_calls_gateway_route_identity",
        "repair_calls_gateway_route_identity",
        "call_typing_errors_gateway_route_identity",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_group_clid_setting",
                "useGroupCLIDSetting",
                bool,
            ),
            E(
                "use_group_media_setting",
                "useGroupMediaSetting",
                bool,
            ),
            E(
                "use_group_call_limits_setting",
                "useGroupCallLimitsSetting",
                bool,
            ),
            E(
                "use_group_translation_routing_setting",
                "useGroupTranslationRoutingSetting",
                bool,
            ),
            E(
                "use_group_dclid_setting",
                "useGroupDCLIDSetting",
                bool,
            ),
            E(
                "use_max_simultaneous_calls",
                "useMaxSimultaneousCalls",
                bool,
            ),
            E(
                "max_simultaneous_calls",
                "maxSimultaneousCalls",
                int,
            ),
            E(
                "use_max_simultaneous_video_calls",
                "useMaxSimultaneousVideoCalls",
                bool,
            ),
            E(
                "max_simultaneous_video_calls",
                "maxSimultaneousVideoCalls",
                int,
            ),
            E(
                "use_max_call_time_for_answered_calls",
                "useMaxCallTimeForAnsweredCalls",
                bool,
            ),
            E(
                "max_call_time_for_answered_calls_minutes",
                "maxCallTimeForAnsweredCallsMinutes",
                int,
            ),
            E(
                "use_max_call_time_for_unanswered_calls",
                "useMaxCallTimeForUnansweredCalls",
                bool,
            ),
            E(
                "max_call_time_for_unanswered_calls_minutes",
                "maxCallTimeForUnansweredCallsMinutes",
                int,
            ),
            E(
                "media_policy_selection",
                "mediaPolicySelection",
                str,
            ),
            E(
                "supported_media_set_name",
                "supportedMediaSetName",
                str,
            ),
            E(
                "network_usage_selection",
                "networkUsageSelection",
                str,
            ),
            E(
                "enforce_group_calling_line_identity_restriction",
                "enforceGroupCallingLineIdentityRestriction",
                bool,
            ),
            E(
                "allow_enterprise_group_call_typing_for_private_dialing_plan",
                "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
                bool,
            ),
            E(
                "allow_enterprise_group_call_typing_for_public_dialing_plan",
                "allowEnterpriseGroupCallTypingForPublicDialingPlan",
                bool,
            ),
            E(
                "override_clid_restriction_for_private_call_category",
                "overrideCLIDRestrictionForPrivateCallCategory",
                bool,
            ),
            E(
                "use_enterprise_clid_for_private_call_category",
                "useEnterpriseCLIDForPrivateCallCategory",
                bool,
            ),
            E(
                "enable_enterprise_extension_dialing",
                "enableEnterpriseExtensionDialing",
                bool,
            ),
            E(
                "use_max_concurrent_redirected_calls",
                "useMaxConcurrentRedirectedCalls",
                bool,
            ),
            E(
                "max_concurrent_redirected_calls",
                "maxConcurrentRedirectedCalls",
                int,
            ),
            E(
                "use_max_find_me_follow_me_depth",
                "useMaxFindMeFollowMeDepth",
                bool,
            ),
            E(
                "max_find_me_follow_me_depth",
                "maxFindMeFollowMeDepth",
                int,
            ),
            E(
                "max_redirection_depth",
                "maxRedirectionDepth",
                int,
            ),
            E(
                "use_max_concurrent_find_me_follow_me_invocations",
                "useMaxConcurrentFindMeFollowMeInvocations",
                bool,
            ),
            E(
                "max_concurrent_find_me_follow_me_invocations",
                "maxConcurrentFindMeFollowMeInvocations",
                int,
            ),
            E(
                "clid_policy",
                "clidPolicy",
                str,
            ),
            E(
                "emergency_clid_policy",
                "emergencyClidPolicy",
                str,
            ),
            E(
                "allow_alternate_numbers_for_redirecting_identity",
                "allowAlternateNumbersForRedirectingIdentity",
                bool,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
            ),
            E(
                "block_calling_name_for_external_calls",
                "blockCallingNameForExternalCalls",
                bool,
            ),
            E(
                "enable_dialable_caller_id",
                "enableDialableCallerID",
                bool,
            ),
            E(
                "allow_configurable_clid_for_redirecting_identity",
                "allowConfigurableCLIDForRedirectingIdentity",
                bool,
            ),
            E(
                "allow_department_clid_name_override",
                "allowDepartmentCLIDNameOverride",
                bool,
            ),
            E(
                "enterprise_calls_clid_policy",
                "enterpriseCallsCLIDPolicy",
                str,
            ),
            E(
                "group_calls_clid_policy",
                "groupCallsCLIDPolicy",
                str,
            ),
            E(
                "use_group_phone_list_lookup_setting",
                "useGroupPhoneListLookupSetting",
                bool,
            ),
            E(
                "enable_phone_list_lookup",
                "enablePhoneListLookup",
                bool,
            ),
            E(
                "use_max_concurrent_terminating_alerting_requests",
                "useMaxConcurrentTerminatingAlertingRequests",
                bool,
            ),
            E(
                "max_concurrent_terminating_alerting_requests",
                "maxConcurrentTerminatingAlertingRequests",
                int,
            ),
            E(
                "include_redirections_in_maximum_number_of_concurrent_calls",
                "includeRedirectionsInMaximumNumberOfConcurrentCalls",
                bool,
            ),
            E(
                "use_user_phone_number_for_group_calls_when_internal_clid_unavailable",
                "useUserPhoneNumberForGroupCallsWhenInternalCLIDUnavailable",
                bool,
            ),
            E(
                "use_user_phone_number_for_enterprise_calls_when_internal_clid_unavailable",
                "useUserPhoneNumberForEnterpriseCallsWhenInternalCLIDUnavailable",
                bool,
            ),
            E(
                "route_override_domain",
                "routeOverrideDomain",
                str,
            ),
            E(
                "route_override_prefix",
                "routeOverridePrefix",
                str,
            ),
            E(
                "allow_mobile_dn_for_redirecting_identity",
                "allowMobileDNForRedirectingIdentity",
                bool,
            ),
            E(
                "enable_gateway_route_policy",
                "enableGatewayRoutePolicy",
                bool,
            ),
            E(
                "network_calls_gateway_route_identity",
                "networkCallsGatewayRouteIdentity",
                str,
            ),
            E(
                "network_url_calls_gateway_route_identity",
                "networkURLCallsGatewayRouteIdentity",
                str,
            ),
            E(
                "emergency_calls_gateway_route_identity",
                "emergencyCallsGatewayRouteIdentity",
                str,
            ),
            E(
                "repair_calls_gateway_route_identity",
                "repairCallsGatewayRouteIdentity",
                str,
            ),
            E(
                "call_typing_errors_gateway_route_identity",
                "callTypingErrorsGatewayRouteIdentity",
                str,
            ),
        )


class GroupCallRecordingGetRequest(OCIRequest):
    """
    Get the Call Recording platform for a group.

    The response is either a `GroupCallRecordingGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallRecordingModifyRequest(OCIRequest):
    """
    Modify the Call Recording platform assignment for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    element is only nillable in XS data mode: name

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
            ),
        )


class GroupCallingLineIdGetRequest(OCIRequest):
    """
    Get the calling line id settings for a group.

    The response is either a `GroupCallingLineIdGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallingLineIdModifyRequest(OCIRequest):
    """
    Modify the calling line id settings for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_group_number (bool): useGroupNumber *Optional*
        use_group_name (bool): useGroupName *Optional*
        calling_line_id_phone_number (str): callingLineIdPhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_group_number",
        "use_group_name",
        "calling_line_id_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_group_number",
                "useGroupNumber",
                bool,
            ),
            E(
                "use_group_name",
                "useGroupName",
                bool,
            ),
            E(
                "calling_line_id_phone_number",
                "callingLineIdPhoneNumber",
                str,
            ),
        )


class GroupCallingPlanAddDigitPatternRequest(OCIRequest):
    """
    Add a new calling plan digit string.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        digit_pattern (str): digitPattern
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "digit_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "digit_pattern",
                "digitPattern",
                str,
                is_required=True,
            ),
        )


class GroupCallingPlanDeleteDigitPatternListRequest(OCIRequest):
    """
    Delete one or more calling plan digit strings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (List[str]): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCallingPlanGetDigitPatternListRequest(OCIRequest):
    """
    Get the list of calling plan digit strings for a group.

    The response is either a `GroupCallingPlanGetDigitPatternListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCallingPlanModifyDigitPatternRequest(OCIRequest):
    """
    Modify a calling plan digit string.

    The name is a key; it cannot be changed.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        digit_pattern (str): digitPattern *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "digit_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "digit_pattern",
                "digitPattern",
                str,
            ),
        )


class GroupCollaborateBridgeConsolidatedDeleteInstanceRequest(OCIRequest):
    """
    Delete a collaborate bridge from a group.

    The request fails when attempting to delete the default collaborate bridge.  If
    UnassignPhoneNumbersLevel is set to 'Group', the user's primary phone number, fax
    number and any alternate numbers, will be un-assigned from the group if the command is
    executed by a service provider administrator or above.  When set to 'Service
    Provider', they will be un-assigned from the group and service provider if the command
    is executed by a provisioning administrator or above.  When omitted, the number(s)
    will be left assigned to the group.  An `ErrorResponse()` will be returned if any
    number cannot be unassigned because of insufficient privilege.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        unassign_phone_numbers (str): unassignPhoneNumbers *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "unassign_phone_numbers",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "unassign_phone_numbers",
                "unassignPhoneNumbers",
                str,
            ),
        )


class GroupCollaborateBridgeDeleteInstanceRequest(OCIRequest):
    """
    Delete a collaborate bridge from a group.

    The request fails when attempting to delete the default collaborate bridge.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCollaborateBridgeGetInstanceListRequest(OCIRequest):
    """
    Get a list of collaborate bridges within a group.

    The response is either `GroupCollaborateBridgeGetInstanceListResponse()` or
    `ErrorResponse()`. It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        department_name (str): departmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "department_name",
                "departmentName",
                str,
            ),
        )


class GroupCollaborateBridgeGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a collaborate bridge.

    The response is either `GroupCollaborateBridgeGetInstanceResponse()` or
    `ErrorResponse()`. Replaced by: `GroupCollaborateBridgeGetInstanceRequest20sp1()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCollaborateBridgeGetInstanceRequest20sp1(OCIRequest):
    """
    Request to get all the information of a collaborate bridge.

    The response is either `GroupCollaborateBridgeGetInstanceResponse20sp1()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupCommonPhoneListDeleteListRequest(OCIRequest):
    """
    Delete one or more entries from a group's common phone list.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        entry_name (List[str]): entryName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "entry_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "entry_name",
                "entryName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCommonPhoneListModifyRequest(OCIRequest):
    """
    Modify an entry in a group's common phone list.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        entry_name (str): entryName
        new_entry_name (str): newEntryName *Optional*
        phone_number (str): phoneNumber *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "entry_name",
        "new_entry_name",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "entry_name",
                "entryName",
                str,
                is_required=True,
            ),
            E(
                "new_entry_name",
                "newEntryName",
                str,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
        )


class GroupCommunicationBarringAuthorizationCodeDeleteListRequest(OCIRequest):
    """
    Delete a list of Communication Barring Authorization codes from a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (List[str]): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupCommunicationBarringAuthorizationCodeGetListRequest(OCIRequest):
    """
    Get a list of Communication Barring Authorization Codes for a group.

    The response is either a `GroupCommunicationBarringAuthorizationCodeGetListResponse()`
    or an `ErorResponse()`. Replaced by:
    `GroupCommunicationBarringAuthorizationCodeGetListRequest21sp1()` in AS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCommunicationBarringAuthorizationCodeGetRequest(OCIRequest):
    """
    Request the group Communication Barring Authorization Code setting.

    The response is either a `GroupCommunicationBarringAuthorizationCodeGetResponse()` or
    an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupCommunicationBarringAuthorizationCodeModifyRequest(OCIRequest):
    """
    Modify the group Communication Barring Authorization Code settings The response is
    either a `SuccessResponse()` or an `ErrorResponse()`.


    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        code (str): code
        description (str): description *Optional*
        network_class_of_service (str): networkClassOfService *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "code",
        "description",
        "network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
            ),
        )


class GroupCommunicationBarringGetRequest(OCIRequest):
    """
    Gets Communication Barring setting for a group.

    The response is either a `GroupCommunicationBarringGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCommunicationBarringModifyRequest(OCIRequest):
    """
    Gets Communication Barring setting for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_default_service_provider_profile (bool): useDefaultServiceProviderProfile
            *Optional*
        profile (str): profile *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_default_service_provider_profile",
        "profile",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_default_service_provider_profile",
                "useDefaultServiceProviderProfile",
                bool,
            ),
            E(
                "profile",
                "profile",
                str,
            ),
        )


class GroupCommunicationBarringProfileGetAssignedListRequest(OCIRequest):
    """
    Get the list of all communication barring profiles assigned to the group.

    The response is either a `GroupCommunicationBarringProfileGetAssignedListResponse()`
    or an `ErrorResponse()`. This command only applies to groups in an Enterprise.  This
    command will fail for groups in a Service Provider.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCustomContactDirectoryAddRequest(OCIRequest):
    """
    Adds a Custom Contact Directory to a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`. Replace by:
    `GroupCustomContactDirectoryAddRequest17()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        user_id (List[str]): userId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_array=True,
            ),
        )


class GroupCustomContactDirectoryDeleteRequest(OCIRequest):
    """
    Deletes a Custom Contact Directory to a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCustomContactDirectoryGetListRequest(OCIRequest):
    """
    Gets the list of Custom Contact Directories for a group.

    The response is either `GroupCustomContactDirectoryGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCustomContactDirectoryGetRequest(OCIRequest):
    """
    Gets a Custom Contact Directory in a group.

    The response is either `GroupCustomContactDirectoryGetResponse()` or
    `ErrorResponse()`. Replace by: `GroupCustomContactDirectoryGetRequest17()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupCustomRingbackGroupGetRequest(OCIRequest):
    """
    Get the group's custom ring back service settings.

    The response is either a `GroupCustomRingbackGroupGetResponse()` or an
    `ErrorResponse()`.

    Replaced By: `GroupCustomRingbackGroupGetRequest16()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCustomRingbackGroupGetRequest16(OCIRequest):
    """
    Get the group's custom ring back service settings.

    The response is either a `GroupCustomRingbackGroupGetResponse16()` or an
    `ErrorResponse()`. Replaced by: `GroupCustomRingbackGroupGetRequest20()` in AS data
    mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupCustomRingbackGroupGetRequest20(OCIRequest):
    """
    Get the group's custom ring back service settings.

    The response is either a `GroupCustomRingbackGroupGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDeleteRequest(OCIRequest):
    """
    Delete a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDepartmentAdminDeleteRequest(OCIRequest):
    """
    Delete a group department administrator.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupDepartmentAdminGetRequest(OCIRequest):
    """
    Get a group department administrators profile.

    The response is either a `GroupDepartmentAdminGetResponse()` or an `ErrorResponse()`.
    Replaced by: `GroupDepartmentAdminGetRequest22()`

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupDepartmentAdminGetRequest22(OCIRequest):
    """
    Get a group department administrators profile.

    The response is either a `GroupDepartmentAdminGetResponse()` or an `ErrorResponse()`.
    Replaced by: `GroupDepartmentAdminGetRequest22V2()`

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupDepartmentAdminGetRequest22V2(OCIRequest):
    """
    Get a group department administrators profile.

    The response is either a `GroupDepartmentAdminGetResponse22V2()` or an
    `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class GroupDepartmentAdminModifyRequest(OCIRequest):
    """
    Modify a group department administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode and ignored in XS data mode.  accountDisabled

    Attributes:
        user_id (str): userId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        password (str): password *Optional*
        language (str): language *Optional*
        account_disabled (bool): accountDisabled *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "first_name",
        "last_name",
        "password",
        "language",
        "account_disabled",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "language",
                "language",
                str,
            ),
            E(
                "account_disabled",
                "accountDisabled",
                bool,
            ),
        )


class GroupDepartmentDeleteRequest(OCIRequest):
    """
    Delete a department from a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        department_name (str): departmentName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "department_name",
                "departmentName",
                str,
                is_required=True,
            ),
        )


class GroupDepartmentGetAvailableParentListRequest(OCIRequest):
    """
    Get a list of departments that could be the parent department of the specified
    department.

    The department itself and all its descendents are not eligible to be the parent
    department.  If the group belongs to an enterprise, it also returns the departments
    defined in the enterprise it belongs to.

    The response is either `GroupDepartmentGetAvailableParentListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        department_name (str): departmentName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "department_name",
                "departmentName",
                str,
                is_required=True,
            ),
        )


class GroupDepartmentGetListRequest(OCIRequest):
    """
    Request a list of departments in a group.

    You may request only the list of departments defined at the group-level, or you may
    request the list of all departments in the group including all the departments defined
    within the enterprise the group belongs to.

    The response is either `GroupDepartmentGetListResponse()` or `ErrorResponse()`.
    Replaced by: `GroupDepartmentGetListRequest18()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        include_enterprise_departments (bool): includeEnterpriseDepartments
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "include_enterprise_departments",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "include_enterprise_departments",
                "includeEnterpriseDepartments",
                bool,
                is_required=True,
            ),
        )


class GroupDepartmentGetListRequest18(OCIRequest):
    """
    Request a list of departments in a group.

    You may request only the list of departments defined at the group-level, or you may
    request the list of all departments in the group including all the departments defined
    within the enterprise the group belongs to.

    The response is either `GroupDepartmentGetListResponse18()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        include_enterprise_departments (bool): includeEnterpriseDepartments
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "include_enterprise_departments",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "include_enterprise_departments",
                "includeEnterpriseDepartments",
                bool,
                is_required=True,
            ),
        )


class GroupDepartmentGetRequest(OCIRequest):
    """
    Request the attributes of a department.

    The response is either a `GroupDepartmentGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        department_name (str): departmentName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "department_name",
                "departmentName",
                str,
                is_required=True,
            ),
        )


class GroupDeviceActivationPolicyGetRequest(OCIRequest):
    """
    Request the Device Activation policy of a group.

    The response is either a `GroupDeviceActivationPolicyGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDeviceActivationPolicyModifyRequest(OCIRequest):
    """
    Modify the Device Activation policy of a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_group_settings (bool): useGroupSettings *Optional*
        allow_activation_code_request_by_user (bool): allowActivationCodeRequestByUser
            *Optional*
        send_activation_code_in_email (bool): sendActivationCodeInEmail *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_group_settings",
        "allow_activation_code_request_by_user",
        "send_activation_code_in_email",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_group_settings",
                "useGroupSettings",
                bool,
            ),
            E(
                "allow_activation_code_request_by_user",
                "allowActivationCodeRequestByUser",
                bool,
            ),
            E(
                "send_activation_code_in_email",
                "sendActivationCodeInEmail",
                bool,
            ),
        )


class GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest(OCIRequest):
    """
    Request the number of access device of a particular device type and group.

    If countOnlyResetSupportedDevice is true, count only access devices if the device type
    supports reset.  By default unmanaged device types are not allowed and devices are
    counted only if their device type supports Device Management.  An error is returned if
    deviceType is specified but does not support device management.  When
    allowUnmanagedDeviceType is true, unmanaged device type will be counted and a
    successful response is returned.

    The response is either
    `GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
        count_only_reset_supported_device (bool): countOnlyResetSupportedDevice *Optional*
        allow_unmanaged_device_type (bool): allowUnmanagedDeviceType *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
        "count_only_reset_supported_device",
        "allow_unmanaged_device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "count_only_reset_supported_device",
                "countOnlyResetSupportedDevice",
                bool,
            ),
            E(
                "allow_unmanaged_device_type",
                "allowUnmanagedDeviceType",
                bool,
            ),
        )


class GroupDeviceManagementInProgressAndPendingEventCancelRequest(OCIRequest):
    """
    Cancel pending and in progress events.

    A list of individual events can be canceled.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        event_id (List[int]): eventId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "event_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "event_id",
                "eventId",
                int,
                is_required=True,
                is_array=True,
            ),
        )


class GroupDeviceTypeCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for an access device type used in a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
        tag_name (str): tagName
        tag_value (str): tagValue *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
        "tag_name",
        "tag_value",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
            ),
            E(
                "tag_value",
                "tagValue",
                str,
            ),
        )


class GroupDeviceTypeCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for an access device type used in a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
        tag_name (List[str]): tagName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
        "tag_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupDeviceTypeCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device type basis for a group.

    The response is either `GroupDeviceTypeCustomTagGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class GroupDeviceTypeCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for an access device type used in a
    group.

    The tagValueToEncrypt element can only be used by a system administrator.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    tagValueToEncrypt

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
        tag_name (str): tagName
        tag_value (str): tagValue *Optional*
        tag_value_to_encrypt (str): tagValueToEncrypt *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
        "tag_name",
        "tag_value",
        "tag_value_to_encrypt",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
            ),
            E(
                "tag_value",
                "tagValue",
                str,
            ),
            E(
                "tag_value_to_encrypt",
                "tagValueToEncrypt",
                str,
            ),
        )


class GroupDeviceTypeFileGetListRequest(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management System,
    on a per-group basis.

    The response is either `GroupDeviceTypeFileGetListResponse()` or `ErrorResponse()`.

    Replaced By: `GroupDeviceTypeFileGetListRequest14sp8()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class GroupDeviceTypeFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management System,
    on a per-group basis.

    The response is either `GroupDeviceTypeFileGetListResponse14sp8()` or
    `ErrorResponse()`. Replaced by: `GroupDeviceTypeFileGetListRequest21()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class GroupDeviceTypeFileGetListRequest21(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management System,
    on a per-group basis.

    The response is either `GroupDeviceTypeFileGetListResponse21()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class GroupDeviceTypeFileGetRequest(OCIRequest):
    """
    Request to get a group device type file.

    The response is either `GroupDeviceTypeFileGetResponse()` or `ErrorResponse()`.

    Replaced By: `GroupDeviceTypeFileGetRequest14sp8()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
        file_type (str): fileType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
        "file_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "file_type",
                "fileType",
                str,
                is_required=True,
            ),
        )


class GroupDeviceTypeFileGetRequest14sp8(OCIRequest):
    """
    Request to get a group device type file.

    The response is either `GroupDeviceTypeFileGetResponse14sp8()` or `ErrorResponse()`.
    Replaced by: `GroupDeviceTypeFileGetRequest16sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
        file_format (str): fileFormat
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
        "file_format",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "file_format",
                "fileFormat",
                str,
                is_required=True,
            ),
        )


class GroupDeviceTypeFileGetRequest16sp1(OCIRequest):
    """
    Request to get a group device type file.

    The response is either `GroupDeviceTypeFileGetResponse16sp1()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
        file_format (str): fileFormat
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
        "file_format",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "file_format",
                "fileFormat",
                str,
                is_required=True,
            ),
        )


class GroupDeviceTypeTagSetGetRequest(OCIRequest):
    """
    Request to get the custom configuration tag set defined for the group and device type.

    The response is either `GroupDeviceTypeTagSetGetResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class GroupDeviceTypeTagSetModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag set.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_type (str): deviceType
        tag_set_name (str): tagSetName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_type",
        "tag_set_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
            E(
                "tag_set_name",
                "tagSetName",
                str,
            ),
        )


class GroupDialPlanPolicyAddAccessCodeRequest(OCIRequest):
    """
    Request to add a Group level Dial Plan Access Code and its all attribues.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        access_code (str): accessCode
        include_code_for_network_translations_and_routing (bool):
            includeCodeForNetworkTranslationsAndRouting
        include_code_for_screening_services (bool): includeCodeForScreeningServices
        enable_secondary_dial_tone (bool): enableSecondaryDialTone
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "access_code",
        "include_code_for_network_translations_and_routing",
        "include_code_for_screening_services",
        "enable_secondary_dial_tone",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "access_code",
                "accessCode",
                str,
                is_required=True,
            ),
            E(
                "include_code_for_network_translations_and_routing",
                "includeCodeForNetworkTranslationsAndRouting",
                bool,
                is_required=True,
            ),
            E(
                "include_code_for_screening_services",
                "includeCodeForScreeningServices",
                bool,
                is_required=True,
            ),
            E(
                "enable_secondary_dial_tone",
                "enableSecondaryDialTone",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupDialPlanPolicyDeleteAccessCodeRequest(OCIRequest):
    """
    Request to delete a Group level Dial Plan Access Code and its all attribues.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        access_code (str): accessCode
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "access_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "access_code",
                "accessCode",
                str,
                is_required=True,
            ),
        )


class GroupDialPlanPolicyGetAccessCodeListRequest(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a `GroupDialPlanPolicyGetAccessCodeListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDialPlanPolicyGetAccessCodeRequest(OCIRequest):
    """
    Request access code data associated with Group level Dial Plan Policy access codes.

    The response is either a `GroupDialPlanPolicyGetAccessCodeResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        access_code (str): accessCode
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "access_code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "access_code",
                "accessCode",
                str,
                is_required=True,
            ),
        )


class GroupDialPlanPolicyGetRequest(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a `GroupDialPlanPolicyGetResponse()` or an `ErrorResponse()`.
    Replaced by: `GroupDialPlanPolicyGetRequest17()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDialPlanPolicyGetRequest17(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a `GroupDialPlanPolicyGetResponse17()` or an `ErrorResponse()`.
    Replaced by: `GroupDialPlanPolicyGetRequest22()` in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDialPlanPolicyGetRequest22(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a `GroupDialPlanPolicyGetResponse22()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDialPlanPolicyModifyAccessCodeRequest(OCIRequest):
    """
    Request to modify a Group level Dial Plan Access Code and its attribues.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        access_code (str): accessCode
        include_code_for_network_translations_and_routing (bool):
            includeCodeForNetworkTranslationsAndRouting *Optional*
        include_code_for_screening_services (bool): includeCodeForScreeningServices
            *Optional*
        enable_secondary_dial_tone (bool): enableSecondaryDialTone *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "access_code",
        "include_code_for_network_translations_and_routing",
        "include_code_for_screening_services",
        "enable_secondary_dial_tone",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "access_code",
                "accessCode",
                str,
                is_required=True,
            ),
            E(
                "include_code_for_network_translations_and_routing",
                "includeCodeForNetworkTranslationsAndRouting",
                bool,
            ),
            E(
                "include_code_for_screening_services",
                "includeCodeForScreeningServices",
                bool,
            ),
            E(
                "enable_secondary_dial_tone",
                "enableSecondaryDialTone",
                bool,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupDialPlanPolicyModifyRequest(OCIRequest):
    """
    Modify the Group level data associated with Dial Plan Policy.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode and ignored in XS data mode:
    overrideResolvedDeviceDigitMap deviceDigitMap

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_setting (str): useSetting *Optional*
        requires_access_code_for_public_calls (bool): requiresAccessCodeForPublicCalls
            *Optional*
        allow_e164_public_calls (bool): allowE164PublicCalls *Optional*
        prefer_e164_number_format_for_callback_services (bool):
            preferE164NumberFormatForCallbackServices *Optional*
        public_digit_map (str): publicDigitMap *Optional*
        private_digit_map (str): privateDigitMap *Optional*
        override_resolved_device_digit_map (bool): overrideResolvedDeviceDigitMap
            *Optional*
        device_digit_map (str): deviceDigitMap *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_setting",
        "requires_access_code_for_public_calls",
        "allow_e164_public_calls",
        "prefer_e164_number_format_for_callback_services",
        "public_digit_map",
        "private_digit_map",
        "override_resolved_device_digit_map",
        "device_digit_map",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_setting",
                "useSetting",
                str,
            ),
            E(
                "requires_access_code_for_public_calls",
                "requiresAccessCodeForPublicCalls",
                bool,
            ),
            E(
                "allow_e164_public_calls",
                "allowE164PublicCalls",
                bool,
            ),
            E(
                "prefer_e164_number_format_for_callback_services",
                "preferE164NumberFormatForCallbackServices",
                bool,
            ),
            E(
                "public_digit_map",
                "publicDigitMap",
                str,
            ),
            E(
                "private_digit_map",
                "privateDigitMap",
                str,
            ),
            E(
                "override_resolved_device_digit_map",
                "overrideResolvedDeviceDigitMap",
                bool,
            ),
            E(
                "device_digit_map",
                "deviceDigitMap",
                str,
            ),
        )


class GroupDialableCallerIDCriteriaAddRequest(OCIRequest):
    """
    Add a new Dialable Caller ID Criteria.

    Criteria are added at the bottom of the list with the lowest priority.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        description (str): description *Optional*
        prefix_digits (str): prefixDigits *Optional*
        match_call_type (List[str]): matchCallType *Optional*
        match_alternate_call_indicator (List[str]): matchAlternateCallIndicator *Optional*
        match_local_category (bool): matchLocalCategory
        match_national_category (bool): matchNationalCategory
        match_interlata_category (bool): matchInterlataCategory
        match_intralata_category (bool): matchIntralataCategory
        match_international_category (bool): matchInternationalCategory
        match_private_category (bool): matchPrivateCategory
        match_emergency_category (bool): matchEmergencyCategory
        match_other_category (bool): matchOtherCategory
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "description",
        "prefix_digits",
        "match_call_type",
        "match_alternate_call_indicator",
        "match_local_category",
        "match_national_category",
        "match_interlata_category",
        "match_intralata_category",
        "match_international_category",
        "match_private_category",
        "match_emergency_category",
        "match_other_category",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
            E(
                "prefix_digits",
                "prefixDigits",
                str,
            ),
            E(
                "match_call_type",
                "matchCallType",
                str,
                is_array=True,
            ),
            E(
                "match_alternate_call_indicator",
                "matchAlternateCallIndicator",
                str,
                is_array=True,
            ),
            E(
                "match_local_category",
                "matchLocalCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_national_category",
                "matchNationalCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_interlata_category",
                "matchInterlataCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_intralata_category",
                "matchIntralataCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_international_category",
                "matchInternationalCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_private_category",
                "matchPrivateCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_emergency_category",
                "matchEmergencyCategory",
                bool,
                is_required=True,
            ),
            E(
                "match_other_category",
                "matchOtherCategory",
                bool,
                is_required=True,
            ),
        )


class GroupDialableCallerIDCriteriaDeleteRequest(OCIRequest):
    """
    Delete a Dialable Caller ID Criteria.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupDialableCallerIDCriteriaGetRequest(OCIRequest):
    """
    Get an existing Dialable Caller ID Criteria.

    The response is either a `GroupDialableCallerIDCriteriaGetRequest()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupDialableCallerIDGetRequest(OCIRequest):
    """
    Get the Group's Dialable Caller ID settings and criteria list.

    The response is either a `GroupDialableCallerIDGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDigitCollectionGetRequest13mp4(OCIRequest):
    """
    Request the group's digit collection attributes.

    The response is either a `GroupDigitCollectionGetResponse13mp4()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDigitCollectionModifyRequest(OCIRequest):
    """
    Modifies the group's digit collection attributes.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_setting (str): useSetting *Optional*
        access_code (str): accessCode *Optional*
        public_digit_map (str): publicDigitMap *Optional*
        private_digit_map (str): privateDigitMap *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_setting",
        "access_code",
        "public_digit_map",
        "private_digit_map",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_setting",
                "useSetting",
                str,
            ),
            E(
                "access_code",
                "accessCode",
                str,
            ),
            E(
                "public_digit_map",
                "publicDigitMap",
                str,
            ),
            E(
                "private_digit_map",
                "privateDigitMap",
                str,
            ),
        )


class GroupDirectoryNumberHuntingGetAvailableUserListRequest(OCIRequest):
    """
    Request to get the agents of a call center or hunt group that are available to be
    assigned to a directory number hunting group.

    They are agents that are not already assigned to any other directory number hunting
    group.

    The response is either `GroupDirectoryNumberHuntingGetAvailableUserListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupDirectoryNumberHuntingGetRequest(OCIRequest):
    """
    Request to get the properties of the DNH service for a specified serviceUserId.

    It gets the agents of a call center or hunt group that are members of a directory
    number hunting group.  They are agents that are not already assigned to any other
    directory number hunting group.

    The response is either `GroupDirectoryNumberHuntingGetResponse()` or
    `ErrorResponse()`. Replaced by: `GroupDirectoryNumberHuntingGetRequest17sp1()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupDirectoryNumberHuntingGetRequest17sp1(OCIRequest):
    """
    Request to get the properties of the DNH service for a specified serviceUserId.

    It gets the agents of a call center or hunt group that are members of a directory
    number hunting group.  They are agents that are not already assigned to any other
    directory number hunting group.

    The response is either `GroupDirectoryNumberHuntingGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupDnGetActivationListRequest(OCIRequest):
    """
    Get the list of activated and deactivated DNs in a group.

    Ranges of DNs with identical assignment and activation properties are coalesced to a
    single table row entry.  Only DNs assigned to a users are listed in the response when
    the number activation Mode is set to "User Activation Enabled" Dns assigned to the
    IMRN pool are not listed in the response.

    The response is either a `GroupDnGetActivationListResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDnGetAvailableListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group and still available for assignment to
    users or service instances within the group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a `GroupDnGetAvailableListResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDnGetAvailableRangesListRequest(OCIRequest):
    """
    Get a list of group DNs that are not assigned to user, service instances or IMRN pool.

    The Dns are returned in a list of DNs or DN ranges and formated in E164 format for
    display.

    The response is either a `GroupDnGetAvailableRangeListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDnGetDetailedAvailableListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group and still available for assignment to
    users within the group with the department name, if the DN is assigned to the
    department.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a `GroupDnGetDetailedAvailableListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDnGetListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a `GroupDnGetListResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDnGetStatusListRequest(OCIRequest):
    """
    Validates DNs given in the request The response is `GroupDnGetStatusListResponse()`.


    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        dn (List[str]): dn
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "dn",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "dn",
                "dn",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupDnGetSummaryListRequest(OCIRequest):
    """
    Get the list of assigned and unassigned DN ranges in a group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a `GroupDnGetSummaryListResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDomainAssignListRequest(OCIRequest):
    """
    Assign a list of domains to a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        domain (List[str]): domain
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "domain",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "domain",
                "domain",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupDomainGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all domains assigned to a group.

    The response is either `GroupDomainGetAssignedListResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupDomainUnassignListRequest(OCIRequest):
    """
    Unassign a list of domains from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        domain (List[str]): domain
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "domain",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "domain",
                "domain",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupEmergencyCallNotificationGetRequest(OCIRequest):
    """
    Request the group level data associated with Emergency Call Notification.

    The response is either a `GroupEmergencyCallNotificationGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupEmergencyCallNotificationModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Emergency Call Notification.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        send_emergency_call_notification_email (bool): sendEmergencyCallNotificationEmail
            *Optional*
        emergency_call_notify_email_address (str): emergencyCallNotifyEmailAddress
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "send_emergency_call_notification_email",
        "emergency_call_notify_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "send_emergency_call_notification_email",
                "sendEmergencyCallNotificationEmail",
                bool,
            ),
            E(
                "emergency_call_notify_email_address",
                "emergencyCallNotifyEmailAddress",
                str,
            ),
        )


class GroupEmergencyZonesGetHomeZoneListRequest(OCIRequest):
    """
    Request the group level data associated with Emergency Zones.

    The response is either a `GroupEmergencyZonesGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupEmergencyZonesGetRequest(OCIRequest):
    """
    Request the group level data associated with Emergency Zones.

    The response is either a `GroupEmergencyZonesGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupEmergencyZonesModifyHomeZoneListRequest(OCIRequest):
    """
    Modify a list of home zones and/or home zone ranges.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        home_zone_ip_address_list (List[OCI.homeZoneIpAddressList]): homeZoneIpAddressList
            *Optional*
        home_zone_ip_address_range_list (List[OCI.homeZoneIpAddressRangeList]):
            homeZoneIpAddressRangeList *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "home_zone_ip_address_list",
        "home_zone_ip_address_range_list",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "home_zone_ip_address_list",
                "homeZoneIpAddressList",
                [
                    E(
                        "home_zone_ip_address",
                        "homeZoneIpAddress",
                        str,
                        is_required=True,
                    ),
                    E(
                        "new_home_zone_ip_address",
                        "newHomeZoneIpAddress",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_array=True,
                is_container=True,
            ),
            E(
                "home_zone_ip_address_range_list",
                "homeZoneIpAddressRangeList",
                [
                    E(
                        "home_zone_ip_address_range",
                        "homeZoneIpAddressRange",
                        OCI.IPAddressRange,
                        is_complex=True,
                        is_required=True,
                    ),
                    E(
                        "new_home_zone_ip_address_range",
                        "newHomeZoneIpAddressRange",
                        OCI.IPAddressRange,
                        is_complex=True,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_array=True,
                is_container=True,
            ),
        )


class GroupEmergencyZonesModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Emergency Zones.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        is_active (bool): isActive *Optional*
        emergency_zones_prohibition (str): emergencyZonesProhibition *Optional*
        send_emergency_call_notify_email (bool): sendEmergencyCallNotifyEmail *Optional*
        emergency_call_notify_email_address (str): emergencyCallNotifyEmailAddress
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "is_active",
        "emergency_zones_prohibition",
        "send_emergency_call_notify_email",
        "emergency_call_notify_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "emergency_zones_prohibition",
                "emergencyZonesProhibition",
                str,
            ),
            E(
                "send_emergency_call_notify_email",
                "sendEmergencyCallNotifyEmail",
                bool,
            ),
            E(
                "emergency_call_notify_email_address",
                "emergencyCallNotifyEmailAddress",
                str,
            ),
        )


class GroupEnhancedCallLogsSchemaInstanceGetRequest(OCIRequest):
    """
    Get the enhanced call log database schema instance associated with a group of a
    service provider.

    The response is either a `GroupEnhancedCallLogsSchemaInstanceGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupEnhancedCallLogsSchemaInstanceModifyRequest(OCIRequest):
    """
    Modify the Enhanced Call Logs schema instance associated with a group of a service
    provider.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
            ),
        )


class GroupEnterpriseTrunkAddRequest(OCIRequest):
    """
    Request to add an enterprise trunk in a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. Replaced by:
    `GroupEnterpriseTrunkAddRequest21()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        str,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.GroupEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
        )


class GroupEnterpriseTrunkAddRequest21(OCIRequest):
    """
    Request to add an enterprise trunk in a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
        maximum_reroute_attempts (int): maximumRerouteAttempts
        route_exhaustion_action (str): routeExhaustionAction
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
        enable_capacity_management (bool): enableCapacityManagement
        max_active_calls (int): maxActiveCalls *Optional*
        capacity_exceeded_trap_initial_calls (int): capacityExceededTrapInitialCalls
            *Optional*
        capacity_exceeded_trap_offset_calls (int): capacityExceededTrapOffsetCalls
            *Optional*
        maximum_active_incoming_calls_allowed (int): maximumActiveIncomingCallsAllowed
            *Optional*
        maximum_active_outgoing_calls_allowed (int): maximumActiveOutgoingCallsAllowed
            *Optional*
        minimum_active_calls_reserved (int): minimumActiveCallsReserved *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
        "enable_capacity_management",
        "max_active_calls",
        "capacity_exceeded_trap_initial_calls",
        "capacity_exceeded_trap_offset_calls",
        "maximum_active_incoming_calls_allowed",
        "maximum_active_outgoing_calls_allowed",
        "minimum_active_calls_reserved",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
                is_required=True,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
                is_required=True,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group",
                        "trunkGroup",
                        str,
                        is_array=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                        is_required=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                        is_required=True,
                    ),
                    E(
                        "priority_weighted_trunk_group",
                        "priorityWeightedTrunkGroup",
                        OCI.GroupEnterpriseTrunkPriorityWeightedTrunkGroup,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "enable_capacity_management",
                "enableCapacityManagement",
                bool,
                is_required=True,
            ),
            E(
                "max_active_calls",
                "maxActiveCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_initial_calls",
                "capacityExceededTrapInitialCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_offset_calls",
                "capacityExceededTrapOffsetCalls",
                int,
            ),
            E(
                "maximum_active_incoming_calls_allowed",
                "maximumActiveIncomingCallsAllowed",
                int,
            ),
            E(
                "maximum_active_outgoing_calls_allowed",
                "maximumActiveOutgoingCallsAllowed",
                int,
            ),
            E(
                "minimum_active_calls_reserved",
                "minimumActiveCallsReserved",
                int,
            ),
        )


class GroupEnterpriseTrunkAddUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
        user_id (List[str]): userId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupEnterpriseTrunkDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise trunk in a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
        )


class GroupEnterpriseTrunkDeleteUserListRequest(OCIRequest):
    """
    Request to delete users from an enterprise trunk in a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
        user_id (List[str]): userId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupEnterpriseTrunkForceAssignUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in a group.

    If the user is already assigned to another enterprise trunk, it will be unassigned
    from the old enterprise trunk and assigned to the new enterprise trunk specified in
    this request.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
        user_id (List[str]): userId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupEnterpriseTrunkGetListRequest(OCIRequest):
    """
    Request to get the list of all enterprise trunks defined in a group.

    The response is either a `GroupEnterpriseTrunkGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupEnterpriseTrunkGetRequest(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    `GroupEnterpriseTrunkGetResponse()` or an `ErrorResponse()`.

    Replaced by: `GroupEnterpriseTrunkGetRequest21()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
        )


class GroupEnterpriseTrunkGetRequest21(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    `GroupEnterpriseTrunkGetResponse21()` or an `ErrorResponse()`.


    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
        )


class GroupEnterpriseTrunkGetRequest22(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    `GroupEnterpriseTrunkGetResponse22()` or an `ErrorResponse()`.


    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
        )


class GroupEnterpriseTrunkModifyRequest(OCIRequest):
    """
    Request to modify an enterprise trunk in a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enterprise_trunk_name (str): enterpriseTrunkName
        new_enterprise_trunk_name (str): newEnterpriseTrunkName *Optional*
        maximum_reroute_attempts (int): maximumRerouteAttempts *Optional*
        route_exhaustion_action (str): routeExhaustionAction *Optional*
        route_exhaustion_forward_address (str): routeExhaustionForwardAddress *Optional*
        ordered_routing (OCI.orderedRouting): orderedRouting *Optional*
        priority_weighted_routing (OCI.priorityWeightedRouting): priorityWeightedRouting
            *Optional*
        enable_capacity_management (bool): enableCapacityManagement *Optional*
        max_active_calls (int): maxActiveCalls *Optional*
        capacity_exceeded_trap_initial_calls (int): capacityExceededTrapInitialCalls
            *Optional*
        capacity_exceeded_trap_offset_calls (int): capacityExceededTrapOffsetCalls
            *Optional*
        maximum_active_incoming_calls_allowed (int): maximumActiveIncomingCallsAllowed
            *Optional*
        maximum_active_outgoing_calls_allowed (int): maximumActiveOutgoingCallsAllowed
            *Optional*
        minimum_active_calls_reserved (int): minimumActiveCallsReserved *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enterprise_trunk_name",
        "new_enterprise_trunk_name",
        "maximum_reroute_attempts",
        "route_exhaustion_action",
        "route_exhaustion_forward_address",
        "ordered_routing",
        "priority_weighted_routing",
        "enable_capacity_management",
        "max_active_calls",
        "capacity_exceeded_trap_initial_calls",
        "capacity_exceeded_trap_offset_calls",
        "maximum_active_incoming_calls_allowed",
        "maximum_active_outgoing_calls_allowed",
        "minimum_active_calls_reserved",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enterprise_trunk_name",
                "enterpriseTrunkName",
                str,
                is_required=True,
            ),
            E(
                "new_enterprise_trunk_name",
                "newEnterpriseTrunkName",
                str,
            ),
            E(
                "maximum_reroute_attempts",
                "maximumRerouteAttempts",
                int,
            ),
            E(
                "route_exhaustion_action",
                "routeExhaustionAction",
                str,
            ),
            E(
                "route_exhaustion_forward_address",
                "routeExhaustionForwardAddress",
                str,
            ),
            E(
                "ordered_routing",
                "orderedRouting",
                [
                    E(
                        "trunk_group_list",
                        "trunkGroupList",
                        OCI.ReplacementGroupEnterpriseTrunkTrunkGroupList,
                        is_complex=True,
                    ),
                    E(
                        "ordering_algorithm",
                        "orderingAlgorithm",
                        str,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "priority_weighted_routing",
                "priorityWeightedRouting",
                [
                    E(
                        "maximum_reroute_attempts_within_priority",
                        "maximumRerouteAttemptsWithinPriority",
                        int,
                    ),
                    E(
                        "priority_weighted_trunk_group_list",
                        "priorityWeightedTrunkGroupList",
                        OCI.ReplacementGroupEnterpriseTrunkPriorityWeightedTrunkGroupList,
                        is_complex=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "enable_capacity_management",
                "enableCapacityManagement",
                bool,
            ),
            E(
                "max_active_calls",
                "maxActiveCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_initial_calls",
                "capacityExceededTrapInitialCalls",
                int,
            ),
            E(
                "capacity_exceeded_trap_offset_calls",
                "capacityExceededTrapOffsetCalls",
                int,
            ),
            E(
                "maximum_active_incoming_calls_allowed",
                "maximumActiveIncomingCallsAllowed",
                int,
            ),
            E(
                "maximum_active_outgoing_calls_allowed",
                "maximumActiveOutgoingCallsAllowed",
                int,
            ),
            E(
                "minimum_active_calls_reserved",
                "minimumActiveCallsReserved",
                int,
            ),
        )


class GroupExchangeIntegrationGetRequest(OCIRequest):
    """
    Request the group level configuration for Exchange Integration.

    The response is either a `GroupExchangeIntegrationGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupExistingUsersAssignUserServiceListRequest(OCIRequest):
    """
    Request to assign the user services and service packs to all existing users within the
    group.

    BroadSoft recommends using this command only for small groups with less than 100
    users.  This command will return an error if the group has over 500 users.  The
    recommended way to bulk assign/unassign services is Service Pack Migration.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_name (List[str]): serviceName *Optional*
        service_pack_name (List[str]): servicePackName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_name",
        "service_pack_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_name",
                "serviceName",
                str,
                is_array=True,
            ),
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_array=True,
            ),
        )


class GroupExistingUsersUnassignUserServiceListRequest(OCIRequest):
    """
    Requests to unassign the user services and service packs for all existing users within
    the group.

    BroadSoft recommends using this command only for small groups with less than 100
    users.  This command will return an error if the group has over 500 users.  The
    recommended way to bulk assign/unassign services is Service Pack Migration.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_name (List[str]): serviceName *Optional*
        service_pack_name (List[str]): servicePackName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_name",
        "service_pack_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_name",
                "serviceName",
                str,
                is_array=True,
            ),
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_array=True,
            ),
        )


class GroupExtensionLengthGetRequest(OCIRequest):
    """
    Request the group's extension length.

    The response is either a `GroupExtensionLengthGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupExtensionLengthGetRequest17(OCIRequest):
    """
    Request the group's extension length.

    The response is either a `GroupExtensionLengthGetResponse17()` or an
    `ErrorResponse()`. Replaced by: `GroupExtensionLengthGetRequest22()` in AS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupExtensionLengthGetRequest22(OCIRequest):
    """
    Request the group's extension length.

    The response is either a `GroupExtensionLengthGetResponse22()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupExtensionLengthModifyRequest(OCIRequest):
    """
    Modify the group's extension length.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        extension_length (int): extensionLength *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "extension_length",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "extension_length",
                "extensionLength",
                int,
            ),
        )


class GroupExtensionLengthModifyRequest17(OCIRequest):
    """
    Modify the group's extension length range.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode and ignored in XS data mode:
    useExterpriseExtensionLengthSetting

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        min_extension_length (int): minExtensionLength *Optional*
        max_extension_length (int): maxExtensionLength *Optional*
        default_extension_length (int): defaultExtensionLength *Optional*
        use_enterprise_extension_length_setting (bool):
            useEnterpriseExtensionLengthSetting *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "min_extension_length",
        "max_extension_length",
        "default_extension_length",
        "use_enterprise_extension_length_setting",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "min_extension_length",
                "minExtensionLength",
                int,
            ),
            E(
                "max_extension_length",
                "maxExtensionLength",
                int,
            ),
            E(
                "default_extension_length",
                "defaultExtensionLength",
                int,
            ),
            E(
                "use_enterprise_extension_length_setting",
                "useEnterpriseExtensionLengthSetting",
                bool,
            ),
        )


class GroupFeatureAccessCodeGetListRequest(OCIRequest):
    """
    Get the list of feature access codes for a group.

    The response is either a `GroupFeatureAccessCodeGetListResponse()` or an
    `ErrorResponse()`. Replaced by: `GroupFeatureAccessCodeGetRequest()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupFeatureAccessCodeGetRequest(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.

    The response is either a `GroupFeatureAccessCodeGetResponse()` or an
    `ErrorResponse()`. Returned Feature Access Codes may be group specific, or Service
    Provider Feature Access Codes, depending on FAC code level.  Replaced by:
    `GroupFeatureAccessCodeGetRequest21()` in AS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupFeatureAccessCodeGetRequest20(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.

    The response is either a `GroupFeatureAccessCodeGetResponse20()` or an
    `ErrorResponse()`. Returned Feature Access Codes may be group specific, or Service
    Provider Feature Access Codes, depending on FAC code level.  In release 20 the "Call
    Recording" FAC name is changed to "Call Recording - Start". Replaced by:
    `GroupFeatureAccessCodeGetRequest21()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupFeatureAccessCodeGetRequest21(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.

    The response is either a `GroupFeatureAccessCodeGetResponse21()` or an
    `ErrorResponse()`. Returned Feature Access Codes may be group specific, or Service
    Provider Feature Access Codes, depending on FAC code level.  In release 20 the "Call
    Recording" FAC name is changed to "Call Recording - Start".

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupFileRepositoryDeviceUserAddRequest(OCIRequest):
    """
    Add a new group file repository user.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        file_repository_name (str): fileRepositoryName
        user_name (str): userName
        password (str): password
        allow_put (bool): allowPut
        allow_delete (bool): allowDelete
        allow_get (bool): allowGet
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "file_repository_name",
        "user_name",
        "password",
        "allow_put",
        "allow_delete",
        "allow_get",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "file_repository_name",
                "fileRepositoryName",
                str,
                is_required=True,
            ),
            E(
                "user_name",
                "userName",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
                is_required=True,
            ),
            E(
                "allow_put",
                "allowPut",
                bool,
                is_required=True,
            ),
            E(
                "allow_delete",
                "allowDelete",
                bool,
                is_required=True,
            ),
            E(
                "allow_get",
                "allowGet",
                bool,
                is_required=True,
            ),
        )


class GroupFileRepositoryDeviceUserDeleteRequest(OCIRequest):
    """
    Delete a group file repository user.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        file_repository_name (str): fileRepositoryName
        user_name (str): userName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "file_repository_name",
        "user_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "file_repository_name",
                "fileRepositoryName",
                str,
                is_required=True,
            ),
            E(
                "user_name",
                "userName",
                str,
                is_required=True,
            ),
        )


class GroupFileRepositoryDeviceUserGetListRequest(OCIRequest):
    """
    Request the list of group users for a file repository in the system.

    The response is either a `GroupFileRepositoryDeviceUserGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        file_repository_name (str): fileRepositoryName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "file_repository_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "file_repository_name",
                "fileRepositoryName",
                str,
                is_required=True,
            ),
        )


class GroupFileRepositoryDeviceUserModifyRequest(OCIRequest):
    """
    Modify a group file repository user.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        file_repository_name (str): fileRepositoryName
        user_name (str): userName
        password (str): password *Optional*
        allow_put (bool): allowPut *Optional*
        allow_delete (bool): allowDelete *Optional*
        allow_get (bool): allowGet *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "file_repository_name",
        "user_name",
        "password",
        "allow_put",
        "allow_delete",
        "allow_get",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "file_repository_name",
                "fileRepositoryName",
                str,
                is_required=True,
            ),
            E(
                "user_name",
                "userName",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "allow_put",
                "allowPut",
                bool,
            ),
            E(
                "allow_delete",
                "allowDelete",
                bool,
            ),
            E(
                "allow_get",
                "allowGet",
                bool,
            ),
        )


class GroupFindMeFollowMeAddAlertingGroupRequest(OCIRequest):
    """
    Add an alerting group to a Find-me/Follow-me instance.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        alerting_group_name (str): alertingGroupName
        alerting_group_description (str): alertingGroupDescription *Optional*
        use_diversion_inhibitor (bool): useDiversionInhibitor
        answer_confirmation_required (bool): answerConfirmationRequired
        number_of_rings (int): numberOfRings
        phone_number (str): phoneNumber *Optional*
        user_id (str): userId *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "alerting_group_name",
        "alerting_group_description",
        "use_diversion_inhibitor",
        "answer_confirmation_required",
        "number_of_rings",
        "phone_number",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "alerting_group_name",
                "alertingGroupName",
                str,
                is_required=True,
            ),
            E(
                "alerting_group_description",
                "alertingGroupDescription",
                str,
            ),
            E(
                "use_diversion_inhibitor",
                "useDiversionInhibitor",
                bool,
                is_required=True,
            ),
            E(
                "answer_confirmation_required",
                "answerConfirmationRequired",
                bool,
                is_required=True,
            ),
            E(
                "number_of_rings",
                "numberOfRings",
                int,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
            ),
            E(
                "user_id",
                "userId",
                str,
            ),
        )


class GroupFindMeFollowMeDeleteAlertingGroupRequest(OCIRequest):
    """
    Delete an alerting group from a Find-me/Follow-me instance.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        alerting_group_name (str): alertingGroupName
    """

    __slots__: List[str] = [
        "service_user_id",
        "alerting_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "alerting_group_name",
                "alertingGroupName",
                str,
                is_required=True,
            ),
        )


class GroupFindMeFollowMeDeleteAlertingGroupSelectiveCriteriaRequest(OCIRequest):
    """
    Delete a criteria from the Find-me/Follow-me alerting group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        alerting_group_name (str): alertingGroupName
        criteria_name (str): criteriaName
    """

    __slots__: List[str] = [
        "service_user_id",
        "alerting_group_name",
        "criteria_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "alerting_group_name",
                "alertingGroupName",
                str,
                is_required=True,
            ),
            E(
                "criteria_name",
                "criteriaName",
                str,
                is_required=True,
            ),
        )


class GroupFindMeFollowMeDeleteInstanceRequest(OCIRequest):
    """
    Delete a Find-me/Follow-me instance from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupFindMeFollowMeGetAlertingGroupListRequest(OCIRequest):
    """
    Get a list of Find-me/Follow-me alerting groups within a group.

    The response is either `GroupFindMeFollowMeGetAlertingGroupListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupFindMeFollowMeGetAlertingGroupRequest(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me alerting group.

    The response is either `GroupFindMeFollowMeGetAlertingGroupResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        alerting_group_name (str): alertingGroupName
    """

    __slots__: List[str] = [
        "service_user_id",
        "alerting_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "alerting_group_name",
                "alertingGroupName",
                str,
                is_required=True,
            ),
        )


class GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest(OCIRequest):
    """
    Request to get all the information of a specific Find-me/Follow-me alerting group
    selective criteria.

    The response is either `GroupFindMeFollowMeGetAlertingGroupResponse()` or
    `ErrorResponse()`. Replaced by:
    `GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest21()`

    Attributes:
        service_user_id (str): serviceUserId
        alerting_group_name (str): alertingGroupName
        criteria_name (str): criteriaName
    """

    __slots__: List[str] = [
        "service_user_id",
        "alerting_group_name",
        "criteria_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "alerting_group_name",
                "alertingGroupName",
                str,
                is_required=True,
            ),
            E(
                "criteria_name",
                "criteriaName",
                str,
                is_required=True,
            ),
        )


class GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest21(OCIRequest):
    """
    Request to get all the information of a specific Find-me/Follow-me alerting group
    selective criteria.

    The response is either `GroupFindMeFollowMeGetAlertingGroupResponse21()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        alerting_group_name (str): alertingGroupName
        criteria_name (str): criteriaName
    """

    __slots__: List[str] = [
        "service_user_id",
        "alerting_group_name",
        "criteria_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "alerting_group_name",
                "alertingGroupName",
                str,
                is_required=True,
            ),
            E(
                "criteria_name",
                "criteriaName",
                str,
                is_required=True,
            ),
        )


class GroupFindMeFollowMeGetInstanceListRequest(OCIRequest):
    """
    Get a list of Find-me/Follow-me instances within a group.

    The response is either `GroupFindMeFollowMeGetInstanceListResponse()` or
    `ErrorResponse()`. It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
        )


class GroupFindMeFollowMeGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me instance.

    The response is either `GroupFindMeFollowMeGetInstanceResponse()` or
    `ErrorResponse()`. Replaced by: `GroupFindMeFollowMeGetInstanceRequest19sp1()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupFindMeFollowMeGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me instance.

    The response is either `GroupFindMeFollowMeGetInstanceResponse19sp1()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupFindMeFollowMeModifyAlertingGroupListRequest(OCIRequest):
    """
    Modify the priorities assigned to alerting groups The response is either a
    `SuccessResponse()` or an `ErrorResponse()`.

    NOTE: The command fails if all the alerting groups defined for the user are not
    provided.

    Attributes:
        service_user_id (str): serviceUserId
        alerting_group_name (List[str]): alertingGroupName *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "alerting_group_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "alerting_group_name",
                "alertingGroupName",
                str,
                is_array=True,
            ),
        )


class GroupFlexibleSeatingAccessDeviceGetListRequest(OCIRequest):
    """
    Requests the list of access devices available for assignment to a flexible seating
    host or guest.

    The list includes devices created at the system, service provider, and group levels
    that support device management.

    The response is either `GroupFlexibleSeatingAccessDeviceGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupFlexibleSeatingHostDeleteInstanceRequest(OCIRequest):
    """
    Delete a flexible seating host instance from a group.

    Host cannot be deleted when a guest is associated to a host.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupFlexibleSeatingHostGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a flexible seating host instance.

    The response is either `GroupFlexibleSeatingHostGetInstanceResponse()` or
    `ErrorResponse()`. Replaced by: `GroupFlexibleSeatingHostGetInstanceRequest22()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupFlexibleSeatingHostGetInstanceRequest22(OCIRequest):
    """
    Request to get all the information of a flexible seating host instance.

    The response is either `GroupFlexibleSeatingHostGetInstanceResponse22()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupFlexibleSeatingHostGuestAssociationGetRequest(OCIRequest):
    """
    Request the flexible seating host guest association details.

    The response is either a `GroupFlexibleSeatingHostGuestAssociationGetResponse()` or an
    `ErrorResponse()`. accessLevel is always set to Group for a Service Provider

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupFlexibleSeatingHostGuestAssociationModifyRequest(OCIRequest):
    """
    Modify the flexible seating host’s guest association attributes.

    The request fails if enforceAssociationLimit or associationLimitHours are changed when
    the host is associated to a guest.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        enforce_association_limit (bool): enforceAssociationLimit *Optional*
        association_limit_hours (int): associationLimitHours *Optional*
        access_level (str): accessLevel *Optional*
        remove_guest_association (bool): removeGuestAssociation *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "enforce_association_limit",
        "association_limit_hours",
        "access_level",
        "remove_guest_association",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "enforce_association_limit",
                "enforceAssociationLimit",
                bool,
            ),
            E(
                "association_limit_hours",
                "associationLimitHours",
                int,
            ),
            E(
                "access_level",
                "accessLevel",
                str,
            ),
            E(
                "remove_guest_association",
                "removeGuestAssociation",
                bool,
            ),
        )


class GroupFlexibleSeatingHostRoutingPoliciesGetRequest(OCIRequest):
    """
    Get a flexible seating host’s routing policies The response is either a
    `GroupFlexibleSeatingHostRoutingPoliciesGetResponse()` or an `ErrorResponse()`.


    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupFlexibleSeatingHostRoutingPoliciesModifyRequest(OCIRequest):
    """
    Modify a flexible seating host’s routing policies The response is either a
    `SuccessResponse()` or an `ErrorResponse()`.


    Attributes:
        service_user_id (str): serviceUserId
        allow_emergency_calls (bool): allowEmergencyCalls *Optional*
        allow_calls_to_voice_portal (bool): allowCallsToVoicePortal *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "allow_emergency_calls",
        "allow_calls_to_voice_portal",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "allow_emergency_calls",
                "allowEmergencyCalls",
                bool,
            ),
            E(
                "allow_calls_to_voice_portal",
                "allowCallsToVoicePortal",
                bool,
            ),
        )


class GroupGetAvailableLeafDeviceListRequest(OCIRequest):
    """
    Requests the list of available leaf devices that can be linked to a tree device within
    a specific group.

    A leaf device is a device associated with a device type that has the option
    supportLinks set to "Support Link to Device". It can be linked to only one tree
    device.  The list returned includes devices created at the system, service provider,
    and group levels.

    The response is either `GroupGetAvailableLeafDeviceListResponse()` or
    `ErrorResponse()`. Replaced by: `GroupGetAvailableLeafDeviceListRequest22()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGetAvailableLeafDeviceListRequest22(OCIRequest):
    """
    Requests the list of available leaf devices that can be linked to a tree device within
    a specific group.

    A leaf device is a device associated with a device type that has the option
    supportLinks set to "Support Link to Device" or "Support Link to Device and User". It
    can be linked to only one tree device.  The list returned includes devices created at
    the system, service provider, and group levels.  If the leafDeviceCategory is not set
    in the request, then linked leaf devices of all categories are requested, otherwise
    only the linked leaf devices of the specified category are requested.  The category
    values are: "Handset", "Base Station", "All".

    The response is either `GroupGetAvailableLeafDeviceListResponse22()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        leaf_device_category (str): leafDeviceCategory *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "leaf_device_category",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "leaf_device_category",
                "leafDeviceCategory",
                str,
            ),
        )


class GroupGetAvailableTreeDeviceListRequest(OCIRequest):
    """
    Requests the list of available tree devices to which leaf devices can be linked to
    within a specific group.

    A tree device is a device associated with a device type that has the option
    supportLinks set to "Support Links from Devices". Many leaf devices can be linked to
    it.  The list returned includes devices created at the system, service provider, and
    group levels.

    The response is either `GroupGetAvailableTreeDeviceListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGetDefaultRequest(OCIRequest):
    """
    Request the default profile for a group.

    The response is either a `GroupGetDefaultResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class GroupGetRequest(OCIRequest):
    """
    Get the profile for a group.

    The response is either a `GroupGetResponse()` or an `ErrorResponse()`.

    Replaced By: `GroupGetRequest14sp7()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGetRequest14sp7(OCIRequest):
    """
    Get the profile for a group.

    The response is either a `GroupGetResponse14sp7()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGetRequest22(OCIRequest):
    """
    Get the profile for a group.

    The response is either a `GroupGetResponse22()` or an `ErrorResponse()`. Replaced by
    `GroupGetRequest22V2()` in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGetRequest22V2(OCIRequest):
    """
    Get the profile for a group.

    The response is either a `GroupGetResponse22V2()` or an `ErrorResponse()`. Replaced
    by: `GroupGetRequest22V3()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGetRequest22V3(OCIRequest):
    """
    Get the profile for a group.

    The response is either a `GroupGetResponse22V3()` or an `ErrorResponse()`. Replaced by
    `GroupGetRequest22V4()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGetRequest22V4(OCIRequest):
    """
    Get the profile for a group.

    The response is either a `GroupGetResponse22V4()` or an `ErrorResponse()`. Replaced
    by: `GroupGetRequest22V5()` in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGetRequest22V5(OCIRequest):
    """
    Get the profile for a group.

    The response is either a `GroupGetResponse22V5()` or an `ErrorResponse()`. The
    following elements are only used in AS data mode and ignored in XS data mode:
    groupExternalId

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        group_id (str): groupId *Optional*
        group_external_id (str): groupExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "group_id",
                "groupId",
                str,
            ),
            E(
                "group_external_id",
                "groupExternalId",
                str,
            ),
        )


class GroupGetUserServiceAssignedUserListRequest(OCIRequest):
    """
    Get the list of users assigned the user service or service pack.

    The response is either a `GroupGetUserServiceAssignedUserListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_name (str): serviceName *Optional*
        service_pack_name (str): servicePackName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_name",
        "service_pack_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_name",
                "serviceName",
                str,
            ),
            E(
                "service_pack_name",
                "servicePackName",
                str,
            ),
        )


class GroupGroupNightForwardingGetRequest(OCIRequest):
    """
    Request to get the Group Night Forwarding group parameters.

    The response is either `GroupGroupNightForwardingGetResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGroupPagingAddOriginatorListRequest(OCIRequest):
    """
    Add originator(s) to a paging group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        originator_user_id (List[str]): originatorUserId
    """

    __slots__: List[str] = [
        "service_user_id",
        "originator_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "originator_user_id",
                "originatorUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupGroupPagingAddTargetListRequest(OCIRequest):
    """
    Add target(s) to a paging group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        target_user_id (List[str]): targetUserId
    """

    __slots__: List[str] = [
        "service_user_id",
        "target_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "target_user_id",
                "targetUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupGroupPagingDeleteInstanceRequest(OCIRequest):
    """
    Delete a Group Paging instance from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupGroupPagingDeleteOriginatorListRequest(OCIRequest):
    """
    Delete originator(s) from a paging group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        originator_user_id (List[str]): originatorUserId
    """

    __slots__: List[str] = [
        "service_user_id",
        "originator_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "originator_user_id",
                "originatorUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupGroupPagingDeleteTargetListRequest(OCIRequest):
    """
    Delete target(s) from a paging group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        target_user_id (List[str]): targetUserId
    """

    __slots__: List[str] = [
        "service_user_id",
        "target_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "target_user_id",
                "targetUserId",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupGroupPagingGetInstanceListRequest(OCIRequest):
    """
    Get a list of Paging Groups instances within a group.

    The response is either `GroupGroupPagingGetInstanceListResponse()` or
    `ErrorResponse()`. It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
        )


class GroupGroupPagingGetInstanceRequest(OCIRequest):
    """
    Replaced By `GroupGroupPagingGetInstanceRequest17sp3()` Request to get all the
    information of a Group Paging instance.

    The response is either `GroupGroupPagingGetInstanceResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupGroupPagingGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Group Paging instance.

    The response is either `GroupGroupPagingGetInstanceResponse17sp3()` or
    `ErrorResponse()`. Replaced by: `GroupGroupPagingGetInstanceRequest19sp1()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupGroupPagingGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Group Paging instance.

    The response is either `GroupGroupPagingGetInstanceResponse19sp1()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupGroupPagingGetOriginatorListRequest(OCIRequest):
    """
    Get a list of originators assigned to a paging group.

    The response is either a `GroupGroupPagingGetOriginatorListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupGroupPagingGetTargetListRequest(OCIRequest):
    """
    Get a list of targets assigned to a paging group.

    The response is either a `GroupGroupPagingGetTargetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupGroupPagingTargetsCapacityGetRequest(OCIRequest):
    """
    Request the maximum number of target users per paging group configured for a group.

    The response is either a `GroupGroupPagingTargetsCapacityGetResponse()` or an
    `ErrorResponse()`. Replaced by: `GroupGroupPagingTargetsCapacityGetRequest22()` in AS
    data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGroupPagingTargetsCapacityGetRequest22(OCIRequest):
    """
    Request the maximum number of target users per paging group configured for a group.

    The response is either a `GroupGroupPagingTargetsCapacityGetResponse22()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupGroupPagingTargetsCapacityModifyRequest(OCIRequest):
    """
    Modify the maximum number of target users per paging group configured for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. Replaced by:
    `GroupGroupPagingTargetsCapacityModifyRequest22()` in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        maximum_target_users (int): maximumTargetUsers *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "maximum_target_users",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "maximum_target_users",
                "maximumTargetUsers",
                int,
            ),
        )


class GroupGroupPagingTargetsCapacityModifyRequest22(OCIRequest):
    """
    Modify the maximum number of target users per paging group configured for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        maximum_target_users (int): maximumTargetUsers *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "maximum_target_users",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "maximum_target_users",
                "maximumTargetUsers",
                int,
            ),
        )


class GroupHolidayScheduleDeleteRequest(OCIRequest):
    """
    Delete a holiday schedule from a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        holiday_schedule_name (str): holidayScheduleName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "holiday_schedule_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "holiday_schedule_name",
                "holidayScheduleName",
                str,
                is_required=True,
            ),
        )


class GroupHolidayScheduleGetListRequest(OCIRequest):
    """
    Get a holiday schedule in a group.

    The response is either a `GroupHolidayScheduleGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupHolidayScheduleGetRequest(OCIRequest):
    """
    Get a holiday schedule in a group.

    The response is either a `GroupHolidayScheduleGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        holiday_schedule_name (str): holidayScheduleName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "holiday_schedule_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "holiday_schedule_name",
                "holidayScheduleName",
                str,
                is_required=True,
            ),
        )


class GroupHuntGroupConsolidatedDeleteInstanceRequest(OCIRequest):
    """
    Delete a Hunt Group instance from a group.

    If UnassignPhoneNumbersLevel is set to 'Group', the user's primary phone number, fax
    number and any alternate numbers, will be un-assigned from the group if the command is
    executed by a service provider administrator or above.  When set to 'Service
    Provider', they will be un-assigned from the group and service provider if the command
    is executed by a provisioning administrator or above.  When omitted, the number(s)
    will be left assigned to the group.  An `ErrorResponse()` will be returned if any
    number cannot be unassigned because of insufficient privilege.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        unassign_phone_numbers (str): unassignPhoneNumbers *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "unassign_phone_numbers",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "unassign_phone_numbers",
                "unassignPhoneNumbers",
                str,
            ),
        )


class GroupHuntGroupDeleteInstanceRequest(OCIRequest):
    """
    Delete a Hunt Group instance from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupHuntGroupGetInstanceListRequest(OCIRequest):
    """
    Get a list of Hunt Group instances within a group.

    The response is either `GroupHuntGroupGetInstanceListResponse()` or `ErrorResponse()`.
    It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
        )


class GroupHuntGroupGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either `GroupHuntGroupGetInstanceResponse14()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupHuntGroupGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either `GroupHuntGroupGetInstanceResponse17()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupHuntGroupGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either `GroupHuntGroupGetInstanceResponse17sp3()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupHuntGroupGetInstanceRequest17sp4(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either `GroupHuntGroupGetInstanceResponse17sp4()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupHuntGroupGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either `GroupHuntGroupGetInstanceResponse19()` or `ErrorResponse()`.
    Replaced by: `GroupHuntGroupGetInstanceRequest19sp1()` in AS data mode

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupHuntGroupGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either `GroupHuntGroupGetInstanceResponse19sp1()` or
    `ErrorResponse()`. Replaced by: `GroupHuntGroupGetInstanceRequest20()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupHuntGroupGetInstanceRequest20(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either `GroupHuntGroupGetInstanceResponse20()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupIMRNGetListRequest(OCIRequest):
    """
    Request a summary table of all DNs in a group IMRN pool.

    The response is either `GroupIMRNGetListResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupIncomingCallingPlanGetListRequest(OCIRequest):
    """
    Request the group's incoming calling plan settings.

    The response is either a `GroupIncomingCallingPlanGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupInstantGroupCallDeleteInstanceRequest(OCIRequest):
    """
    Request to delete an Instant Group Call service instance from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupInstantGroupCallGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Instant Group Call service instances within a group.

    The response is either `GroupInstantGroupCallGetInstanceListResponse()` or
    `ErrorResponse()`. It is possible to get the service instances within a specified
    department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
        )


class GroupInstantGroupCallGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.

    The response is either `GroupInstantGroupCallGetInstanceResponse14()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupInstantGroupCallGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.

    The response is either `GroupInstantGroupCallGetInstanceResponse17()` or
    `ErrorResponse()`. Replaced by: `GroupInstantGroupCallGetInstanceRequest19sp1()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupInstantGroupCallGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.

    The response is either `GroupInstantGroupCallGetInstanceResponse19sp1()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupIntegratedIMPGetRequest(OCIRequest):
    """
    Get the Integrated IMP service attributes for the group.

    The response is either `GroupIntegratedIMPGetResponse()` or `ErrorResponse()`.
    Replaced by: `GroupIntegratedIMPGetRequest21sp1()` in AS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupIntegratedIMPGetRequest21sp1(OCIRequest):
    """
    Get the Integrated IMP service attributes for the group.

    The response is either `GroupIntegratedIMPGetResponse21sp1()` or `ErrorResponse()`.
    Replaced by `GroupIntegratedIMPGetRequest22()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupIntegratedIMPGetRequest22(OCIRequest):
    """
    Get the Integrated IMP service attributes for the group.

    The response is either `GroupIntegratedIMPGetResponse22()` or `ErrorResponse()`.
    Replaced by `GroupIntegratedIMPGetRequest23()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupIntegratedIMPGetRequest23(OCIRequest):
    """
    Get the Integrated IMP service attributes for the group.

    The response is either `GroupIntegratedIMPGetResponse23()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupIntegratedIMPModifyRequest(OCIRequest):
    """
    Modify the Integrated IMP service attributes for the group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements can only be used by a reseller administrator or above:
    useServiceProviderMessagingServer provisioningUrl provisioningUserId
    provisioningPassword

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_service_provider_setting (bool): useServiceProviderSetting *Optional*
        service_domain (str): serviceDomain *Optional*
        use_service_provider_messaging_server (bool): useServiceProviderMessagingServer
            *Optional*
        provisioning_url (str): provisioningUrl *Optional*
        provisioning_user_id (str): provisioningUserId *Optional*
        provisioning_password (str): provisioningPassword *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_service_provider_setting",
        "service_domain",
        "use_service_provider_messaging_server",
        "provisioning_url",
        "provisioning_user_id",
        "provisioning_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_service_provider_setting",
                "useServiceProviderSetting",
                bool,
            ),
            E(
                "service_domain",
                "serviceDomain",
                str,
            ),
            E(
                "use_service_provider_messaging_server",
                "useServiceProviderMessagingServer",
                bool,
            ),
            E(
                "provisioning_url",
                "provisioningUrl",
                str,
            ),
            E(
                "provisioning_user_id",
                "provisioningUserId",
                str,
            ),
            E(
                "provisioning_password",
                "provisioningPassword",
                str,
            ),
        )


class GroupInterceptGroupGetRequest(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a `GroupInterceptGroupGetResponse()` or an `ErrorResponse()`.

    Replaced By: `GroupInterceptGroupGetRequest16()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupInterceptGroupGetRequest16(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a `GroupInterceptGroupGetResponse16()` or an `ErrorResponse()`.

    Replaced By: `GroupInterceptGroupGetRequest16sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupInterceptGroupGetRequest16sp1(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a `GroupInterceptGroupGetResponse16sp1()` or an
    `ErrorResponse()`. Replaced by: `GroupInterceptGroupGetRequest21sp1()` in AS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupInterceptGroupGetRequest21sp1(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a `GroupInterceptGroupGetResponse21sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupInventoryReportGetRequest(OCIRequest):
    """
    Request the group's inventory report.

    The response is either a `GroupInventoryReportGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        include_users (bool): includeUsers
        include_services (bool): includeServices
        include_dns (bool): includeDns
        include_access_devices (bool): includeAccessDevices
        include_departments (bool): includeDepartments
        report_delivery_email_address (str): reportDeliveryEmailAddress *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "include_users",
        "include_services",
        "include_dns",
        "include_access_devices",
        "include_departments",
        "report_delivery_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "include_users",
                "includeUsers",
                bool,
                is_required=True,
            ),
            E(
                "include_services",
                "includeServices",
                bool,
                is_required=True,
            ),
            E(
                "include_dns",
                "includeDns",
                bool,
                is_required=True,
            ),
            E(
                "include_access_devices",
                "includeAccessDevices",
                bool,
                is_required=True,
            ),
            E(
                "include_departments",
                "includeDepartments",
                bool,
                is_required=True,
            ),
            E(
                "report_delivery_email_address",
                "reportDeliveryEmailAddress",
                str,
            ),
        )


class GroupMWIDeliveryToMobileEndpointCustomTemplateDeleteRequest(OCIRequest):
    """
    Delete a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        language (str): language
        type (str): type
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "language",
        "type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
        )


class GroupMWIDeliveryToMobileEndpointCustomTemplateDeleteRequest23(OCIRequest):
    """
    Delete a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        language (str): language
        type (str): type
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "language",
        "type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
        )


class GroupMWIDeliveryToMobileEndpointCustomTemplateGetRequest(OCIRequest):
    """
    Request a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a `GroupMWIDeliveryToMobileEndpointCustomTemplateGetResponse()`
    or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        language (str): language
        type (str): type
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "language",
        "type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
        )


class GroupMWIDeliveryToMobileEndpointCustomTemplateGetRequest23(OCIRequest):
    """
    Request a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a
    `GroupMWIDeliveryToMobileEndpointCustomTemplateGetResponse23()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        language (str): language
        type (str): type
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "language",
        "type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "type",
                "type",
                str,
                is_required=True,
            ),
        )


class GroupMWIDeliveryToMobileEndpointGetRequest(OCIRequest):
    """
    Requests group MWI custom notifications settings.

    The response is either a `GroupMWIDeliveryToMobileEndpointGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupMeetMeConferencingDeleteInstanceRequest(OCIRequest):
    """
    Delete a Meet-Me Conferencing bridge from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupMeetMeConferencingGetInstanceListRequest(OCIRequest):
    """
    Get a list of Meet-Me Conferencing instances within a group.

    The response is either `GroupMeetMeConferencingGetInstanceListResponse()` or
    `ErrorResponse()`. It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        department_name (str): departmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "department_name",
                "departmentName",
                str,
            ),
        )


class GroupMeetMeConferencingGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either `GroupMeetMeConferencingGetInstanceResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupMeetMeConferencingGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either `GroupMeetMeConferencingGetInstanceResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupMeetMeConferencingGetInstanceRequest17sp4(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either `GroupMeetMeConferencingGetInstanceResponse17sp4()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupMeetMeConferencingGetInstanceRequest18(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either `GroupMeetMeConferencingGetInstanceResponse18()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupMeetMeConferencingGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either `GroupMeetMeConferencingGetInstanceResponse19()` or
    `ErrorResponse()`. Replaced by: `GroupMeetMeConferencingGetInstanceRequest19sp1()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupMeetMeConferencingGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either `GroupMeetMeConferencingGetInstanceResponse19sp1()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupMeetMeConferencingGetRequest(OCIRequest):
    """
    Request the group level data associated with Meet-Me Conferencing functions.

    The response is either a `GroupMeetMeConferencingGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupMusicOnHoldGetDepartmentListRequest(OCIRequest):
    """
    Returns a list of all departments that have a Music On Hold instance.

    The response is either `GroupMusicOnHoldGetDepartmentListResponse()` or
    `ErrorResponse()`. It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
        )


class GroupNetworkClassOfServiceAssignListRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to a group.

    The Element defaultNetworkClassOfService is required only for the first assignment,
    for subsequent assignments it is optional.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        network_class_of_service (List[str]): networkClassOfService *Optional*
        default_network_class_of_service (str): defaultNetworkClassOfService *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "network_class_of_service",
        "default_network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
                is_array=True,
            ),
            E(
                "default_network_class_of_service",
                "defaultNetworkClassOfService",
                str,
            ),
        )


class GroupNetworkClassOfServiceAssignToAllUsersRequest(OCIRequest):
    """
    Assign a Network Classes of Service to all users with in a group.

    The Network Classes of Service must be currently assigned to the group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        network_class_of_service (str): networkClassOfService
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
                is_required=True,
            ),
        )


class GroupNetworkClassOfServiceGetAssignedListRequest(OCIRequest):
    """
    Get a list of Network Classes of Service assigned to a group.

    The response is either a `GroupNetworkClassOfServiceGetAssignedListResponse()` or an
    `ErorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupNetworkClassOfServiceModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Network Classes of Service of a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        network_class_of_service (str): networkClassOfService
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
                is_required=True,
            ),
        )


class GroupNetworkClassOfServiceUnassignListRequest(OCIRequest):
    """
    Unassign a list of Network Classes of Service from a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        network_class_of_service (List[str]): networkClassOfService *Optional*
        default_network_class_of_service (str): defaultNetworkClassOfService *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "network_class_of_service",
        "default_network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
                is_array=True,
            ),
            E(
                "default_network_class_of_service",
                "defaultNetworkClassOfService",
                str,
            ),
        )


class GroupNewUserTemplateAssignUserServiceListRequest(OCIRequest):
    """
    Request to assign the user services and service packs to all new users created within
    the group after the completion of this request.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_name (List[str]): serviceName *Optional*
        service_pack_name (List[str]): servicePackName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_name",
        "service_pack_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_name",
                "serviceName",
                str,
                is_array=True,
            ),
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_array=True,
            ),
        )


class GroupNewUserTemplateUnassignUserServiceListRequest(OCIRequest):
    """
    Requests to unassign the user services and service packs for all new users created
    within the group after the completion of this request.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_name (List[str]): serviceName *Optional*
        service_pack_name (List[str]): servicePackName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_name",
        "service_pack_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_name",
                "serviceName",
                str,
                is_array=True,
            ),
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_array=True,
            ),
        )


class GroupOfficeZoneAssignListRequest(OCIRequest):
    """
    Assign a list of Office Zones to a group.

    The Element defaultOfficeZone is required only for the first assignment, for
    subsequent assignments it is optional.  Office Zones can only be assigned if the
    Location-Based Calling Restrictions has been authorized to the group otherwise the
    request will fail.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        office_zone_name (List[str]): officeZoneName *Optional*
        default_office_zone_name (str): defaultOfficeZoneName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "office_zone_name",
        "default_office_zone_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "office_zone_name",
                "officeZoneName",
                str,
                is_array=True,
            ),
            E(
                "default_office_zone_name",
                "defaultOfficeZoneName",
                str,
            ),
        )


class GroupOfficeZoneGetAssignedListRequest(OCIRequest):
    """
    Get a list of Office Zones assigned to a group.

    The response is either a `GroupOfficeZoneGetAssignedListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOfficeZoneUnassignListRequest(OCIRequest):
    """
    Unassign a list of OfficeZones from a group.

    Note: a new default must be provided if unassigning the current default.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        office_zone_name (List[str]): officeZoneName *Optional*
        default_office_zone_name (str): defaultOfficeZoneName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "office_zone_name",
        "default_office_zone_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "office_zone_name",
                "officeZoneName",
                str,
                is_array=True,
            ),
            E(
                "default_office_zone_name",
                "defaultOfficeZoneName",
                str,
            ),
        )


class GroupOutgoingCallingPlanAuthorizationCodeGetListRequest(OCIRequest):
    """
    Request the list of authorization codes for a group default and it's departments.

    The response is either a `GroupOutgoingCallingPlanAuthorizationCodeGetListResponse()`
    or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now call permissions for a group default and it's departments.

    The response is either a `GroupOutgoingCallingPlanCallMeNowGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanDigitPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now call permissions for digit patterns for a group default and
    it's departments.

    The response is either a `GroupOutgoingCallingPlanDigitPlanCallMeNowGetListResponse()`
    or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanDigitPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for digit patterns for a group default and it's
    departments.

    The response is either a
    `GroupOutgoingCallingPlanDigitPlanOriginatingGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanDigitPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the redirecting permissions for digit patterns for a group default and it's
    departments.

    The response is either a
    `GroupOutgoingCallingPlanDigitPlanRedirectingGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for a group default and it's departments.

    The response is either a `GroupOutgoingCallingPlanOriginatingGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanPinholeDigitPatternAddRequest(OCIRequest):
    """
    Add a new calling plan Pinhole digit string.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        digit_pattern (str): digitPattern
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "digit_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "digit_pattern",
                "digitPattern",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanPinholeDigitPatternDeleteListRequest(OCIRequest):
    """
    Delete one or more calling plan Pinhole digit strings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (List[str]): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest(OCIRequest):
    """
    Get the list of calling plan Pinhole digit strings for a group.

    The response is either a
    `GroupOutgoingCallingPlanPinholeDigitPatternGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanPinholeDigitPatternModifyRequest(OCIRequest):
    """
    Modify a calling plan Pinhole digit string.

    The name is a key; it cannot be changed.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        digit_pattern (str): digitPattern *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "digit_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "digit_pattern",
                "digitPattern",
                str,
            ),
        )


class GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now permissions for Pinhole digit patterns for a group default and
    its departments.

    The response is either a
    `GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for Pinhole digit patterns for a group default and
    its departments.

    The response is either a
    `GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the redirecting permissions for Pinhole digit patterns for a group default and
    its departments.

    The response is either a
    `GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanRedirectedGetListRequest(OCIRequest):
    """
    Request the call forwarded/transferred permissions for a group default and it's
    departments.

    The response is either a `GroupOutgoingCallingPlanRedirectedGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the initiating call forwards/transfer permissions for a group default and it's
    departments.

    The response is either a `GroupOutgoingCallingPlanRedirectingGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupOutgoingCallingPlanTransferNumbersGetListRequest(OCIRequest):
    """
    Request the list of transfer numbers for a group default and it's departments.

    The response is either a `GroupOutgoingCallingPlanTransferNumbersGetListResponse()` or
    an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPasswordRulesGetRequest(OCIRequest):
    """
    Requests the group's password rules setting that is applicable to users within the
    group.

    The response is either `GroupPasswordRulesGetResponse()` or `ErrorResponse()`.
    Replaced by: `GroupPasswordRulesGetRequest16()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPasswordRulesGetRequest16(OCIRequest):
    """
    Requests the group's password rules setting that is applicable to users within the
    group.

    The response is either `GroupPasswordRulesGetResponse16()` or `ErrorResponse()`.
    Replaced by: `GroupPasswordRulesGetRequest22()` in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPasswordRulesGetRequest22(OCIRequest):
    """
    Requests the group's password rules setting that is applicable to users within the
    group.

    The response is either `GroupPasswordRulesGetResponse22()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the group's password rules setting that apply to the users within
    the group.

    The following elements are only used in AS data mode and ignored in XS data mode:
    forcePasswordChangeAfterReset reenableLogin lockOutInMinutes

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        disallow_user_id (bool): disallowUserId *Optional*
        disallow_old_password (bool): disallowOldPassword *Optional*
        disallow_reversed_old_password (bool): disallowReversedOldPassword *Optional*
        restrict_min_digits (bool): restrictMinDigits *Optional*
        min_digits (int): minDigits *Optional*
        restrict_min_upper_case_letters (bool): restrictMinUpperCaseLetters *Optional*
        min_upper_case_letters (int): minUpperCaseLetters *Optional*
        restrict_min_lower_case_letters (bool): restrictMinLowerCaseLetters *Optional*
        min_lower_case_letters (int): minLowerCaseLetters *Optional*
        restrict_min_non_alphanumeric_characters (bool):
            restrictMinNonAlphanumericCharacters *Optional*
        min_non_alphanumeric_characters (int): minNonAlphanumericCharacters *Optional*
        min_length (int): minLength *Optional*
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        password_expires_days (int): passwordExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail *Optional*
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        disallow_previous_passwords (bool): disallowPreviousPasswords *Optional*
        number_of_previous_passwords (int): numberOfPreviousPasswords *Optional*
        force_password_change_after_reset (bool): forcePasswordChangeAfterReset *Optional*
        use_password_validation_service (bool): usePasswordValidationService *Optional*
        reenable_login (bool): reenableLogin *Optional*
        lock_out_in_minutes (int): lockOutInMinutes *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "disallow_user_id",
        "disallow_old_password",
        "disallow_reversed_old_password",
        "restrict_min_digits",
        "min_digits",
        "restrict_min_upper_case_letters",
        "min_upper_case_letters",
        "restrict_min_lower_case_letters",
        "min_lower_case_letters",
        "restrict_min_non_alphanumeric_characters",
        "min_non_alphanumeric_characters",
        "min_length",
        "max_failed_login_attempts",
        "password_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "disallow_previous_passwords",
        "number_of_previous_passwords",
        "force_password_change_after_reset",
        "use_password_validation_service",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "disallow_user_id",
                "disallowUserId",
                bool,
            ),
            E(
                "disallow_old_password",
                "disallowOldPassword",
                bool,
            ),
            E(
                "disallow_reversed_old_password",
                "disallowReversedOldPassword",
                bool,
            ),
            E(
                "restrict_min_digits",
                "restrictMinDigits",
                bool,
            ),
            E(
                "min_digits",
                "minDigits",
                int,
            ),
            E(
                "restrict_min_upper_case_letters",
                "restrictMinUpperCaseLetters",
                bool,
            ),
            E(
                "min_upper_case_letters",
                "minUpperCaseLetters",
                int,
            ),
            E(
                "restrict_min_lower_case_letters",
                "restrictMinLowerCaseLetters",
                bool,
            ),
            E(
                "min_lower_case_letters",
                "minLowerCaseLetters",
                int,
            ),
            E(
                "restrict_min_non_alphanumeric_characters",
                "restrictMinNonAlphanumericCharacters",
                bool,
            ),
            E(
                "min_non_alphanumeric_characters",
                "minNonAlphanumericCharacters",
                int,
            ),
            E(
                "min_length",
                "minLength",
                int,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "password_expires_days",
                "passwordExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "disallow_previous_passwords",
                "disallowPreviousPasswords",
                bool,
            ),
            E(
                "number_of_previous_passwords",
                "numberOfPreviousPasswords",
                int,
            ),
            E(
                "force_password_change_after_reset",
                "forcePasswordChangeAfterReset",
                bool,
            ),
            E(
                "use_password_validation_service",
                "usePasswordValidationService",
                bool,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
            ),
        )


class GroupPolicyGetRequest(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either `GroupPolicyGetResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetRequest14sp1(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either `GroupPolicyGetResponse14sp1()` or `ErrorResponse()`.

    Replaced By : `GroupPolicyGetRequest14sp4()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetRequest14sp4(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either `GroupPolicyGetResponse14sp4()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetRequest17(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either `GroupPolicyGetResponse17()` or `ErrorResponse()`. Replaced by:
    `GroupPolicyGetRequest20()` in AS data mode Replaced by: `GroupPolicyGetRequest22()`
    in XS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetRequest20(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either `GroupPolicyGetResponse20()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPolicyGetRequest22(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either `GroupPolicyGetResponse22()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPolicyModifyRequest(OCIRequest):
    """
    Request to modify the policies for a Group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode: userAutoAttendantNameDialingAccess Replaced
    by: `GroupPolicyModifyRequest22()` in AS and XS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        calling_plan_access (str): callingPlanAccess *Optional*
        extension_access (str): extensionAccess *Optional*
        ldap_integration_access (str): ldapIntegrationAccess *Optional*
        voice_messaging_access (str): voiceMessagingAccess *Optional*
        department_admin_user_access (str): departmentAdminUserAccess *Optional*
        department_admin_trunk_group_access (str): departmentAdminTrunkGroupAccess
            *Optional*
        department_admin_phone_number_extension_access (str):
            departmentAdminPhoneNumberExtensionAccess *Optional*
        department_admin_calling_line_id_number_access (str):
            departmentAdminCallingLineIdNumberAccess *Optional*
        user_authentication_access (str): userAuthenticationAccess *Optional*
        user_group_directory_access (str): userGroupDirectoryAccess *Optional*
        user_profile_access (str): userProfileAccess *Optional*
        user_enhanced_call_log_access (str): userEnhancedCallLogAccess *Optional*
        user_auto_attendant_name_dialing_access (str): userAutoAttendantNameDialingAccess
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "calling_plan_access",
        "extension_access",
        "ldap_integration_access",
        "voice_messaging_access",
        "department_admin_user_access",
        "department_admin_trunk_group_access",
        "department_admin_phone_number_extension_access",
        "department_admin_calling_line_id_number_access",
        "user_authentication_access",
        "user_group_directory_access",
        "user_profile_access",
        "user_enhanced_call_log_access",
        "user_auto_attendant_name_dialing_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "calling_plan_access",
                "callingPlanAccess",
                str,
            ),
            E(
                "extension_access",
                "extensionAccess",
                str,
            ),
            E(
                "ldap_integration_access",
                "ldapIntegrationAccess",
                str,
            ),
            E(
                "voice_messaging_access",
                "voiceMessagingAccess",
                str,
            ),
            E(
                "department_admin_user_access",
                "departmentAdminUserAccess",
                str,
            ),
            E(
                "department_admin_trunk_group_access",
                "departmentAdminTrunkGroupAccess",
                str,
            ),
            E(
                "department_admin_phone_number_extension_access",
                "departmentAdminPhoneNumberExtensionAccess",
                str,
            ),
            E(
                "department_admin_calling_line_id_number_access",
                "departmentAdminCallingLineIdNumberAccess",
                str,
            ),
            E(
                "user_authentication_access",
                "userAuthenticationAccess",
                str,
            ),
            E(
                "user_group_directory_access",
                "userGroupDirectoryAccess",
                str,
            ),
            E(
                "user_profile_access",
                "userProfileAccess",
                str,
            ),
            E(
                "user_enhanced_call_log_access",
                "userEnhancedCallLogAccess",
                str,
            ),
            E(
                "user_auto_attendant_name_dialing_access",
                "userAutoAttendantNameDialingAccess",
                str,
            ),
        )


class GroupPolicyModifyRequest22(OCIRequest):
    """
    Request to modify the policies for a Group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    elements are only used in AS data mode and ignored in XS data mode:
    userAutoAttendantNameDialingAccess

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        calling_plan_access (str): callingPlanAccess *Optional*
        extension_access (str): extensionAccess *Optional*
        voice_messaging_access (str): voiceMessagingAccess *Optional*
        department_admin_user_access (str): departmentAdminUserAccess *Optional*
        department_admin_trunk_group_access (str): departmentAdminTrunkGroupAccess
            *Optional*
        department_admin_phone_number_extension_access (str):
            departmentAdminPhoneNumberExtensionAccess *Optional*
        department_admin_calling_line_id_number_access (str):
            departmentAdminCallingLineIdNumberAccess *Optional*
        user_authentication_access (str): userAuthenticationAccess *Optional*
        user_group_directory_access (str): userGroupDirectoryAccess *Optional*
        user_profile_access (str): userProfileAccess *Optional*
        user_enhanced_call_log_access (str): userEnhancedCallLogAccess *Optional*
        user_auto_attendant_name_dialing_access (str): userAutoAttendantNameDialingAccess
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "calling_plan_access",
        "extension_access",
        "voice_messaging_access",
        "department_admin_user_access",
        "department_admin_trunk_group_access",
        "department_admin_phone_number_extension_access",
        "department_admin_calling_line_id_number_access",
        "user_authentication_access",
        "user_group_directory_access",
        "user_profile_access",
        "user_enhanced_call_log_access",
        "user_auto_attendant_name_dialing_access",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "calling_plan_access",
                "callingPlanAccess",
                str,
            ),
            E(
                "extension_access",
                "extensionAccess",
                str,
            ),
            E(
                "voice_messaging_access",
                "voiceMessagingAccess",
                str,
            ),
            E(
                "department_admin_user_access",
                "departmentAdminUserAccess",
                str,
            ),
            E(
                "department_admin_trunk_group_access",
                "departmentAdminTrunkGroupAccess",
                str,
            ),
            E(
                "department_admin_phone_number_extension_access",
                "departmentAdminPhoneNumberExtensionAccess",
                str,
            ),
            E(
                "department_admin_calling_line_id_number_access",
                "departmentAdminCallingLineIdNumberAccess",
                str,
            ),
            E(
                "user_authentication_access",
                "userAuthenticationAccess",
                str,
            ),
            E(
                "user_group_directory_access",
                "userGroupDirectoryAccess",
                str,
            ),
            E(
                "user_profile_access",
                "userProfileAccess",
                str,
            ),
            E(
                "user_enhanced_call_log_access",
                "userEnhancedCallLogAccess",
                str,
            ),
            E(
                "user_auto_attendant_name_dialing_access",
                "userAutoAttendantNameDialingAccess",
                str,
            ),
        )


class GroupPolycomPhoneServicesGetRequest(OCIRequest):
    """
    Request the group's Polycom Phone Services attributes.

    The response is either a `GroupPolycomPhoneServicesGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPolycomPhoneServicesModifyRequest(OCIRequest):
    """
    Modify the group's Polycom Phone Services attributes.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        include_group_common_phone_list_in_directory (bool):
            includeGroupCommonPhoneListInDirectory *Optional*
        include_group_custom_contact_directory_in_directory (bool):
            includeGroupCustomContactDirectoryInDirectory *Optional*
        group_custom_contact_directory (str): groupCustomContactDirectory *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "include_group_common_phone_list_in_directory",
        "include_group_custom_contact_directory_in_directory",
        "group_custom_contact_directory",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "include_group_common_phone_list_in_directory",
                "includeGroupCommonPhoneListInDirectory",
                bool,
            ),
            E(
                "include_group_custom_contact_directory_in_directory",
                "includeGroupCustomContactDirectoryInDirectory",
                bool,
            ),
            E(
                "group_custom_contact_directory",
                "groupCustomContactDirectory",
                str,
            ),
        )


class GroupPortalPasscodeRulesGetRequest(OCIRequest):
    """
    Requests the group's passcode rules setting.

    The response is either `GroupPortalPasscodeRulesGetResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPortalPasscodeRulesGetRequest19(OCIRequest):
    """
    Requests the group's passcode rules setting.

    The response is either `GroupPortalPasscodeRulesGetResponse()` or `ErrorResponse()`.
    Replaced by: GroupPortalPasscodeRulesGetRequestRI in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPortalPasscodeRulesModifyRequest(OCIRequest):
    """
    Request to modify the group's passcode rules setting.

    The response is either `SuccessResponse()` or `ErrorResponse()`. The following
    elements are only used in AS data mode: numberOfRepeatedDigits
    disallowRepeatedPatterns disallowContiguousSequences numberOfAscendingDigits
    numberOfDescendingDigits numberOfPreviousPasscodes reenableLogin lockOutInMinutes

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_rule_level (str): useRuleLevel *Optional*
        disallow_repeated_digits (bool): disallowRepeatedDigits *Optional*
        number_of_repeated_digits (int): numberOfRepeatedDigits *Optional*
        disallow_repeated_patterns (bool): disallowRepeatedPatterns *Optional*
        disallow_contiguous_sequences (bool): disallowContiguousSequences *Optional*
        number_of_ascending_digits (int): numberOfAscendingDigits *Optional*
        number_of_descending_digits (int): numberOfDescendingDigits *Optional*
        disallow_user_number (bool): disallowUserNumber *Optional*
        disallow_reversed_user_number (bool): disallowReversedUserNumber *Optional*
        disallow_old_passcode (bool): disallowOldPasscode *Optional*
        number_of_previous_passcodes (int): numberOfPreviousPasscodes *Optional*
        disallow_reversed_old_passcode (bool): disallowReversedOldPasscode *Optional*
        min_code_length (int): minCodeLength *Optional*
        max_code_length (int): maxCodeLength *Optional*
        disable_login_after_max_failed_login_attempts (bool):
            disableLoginAfterMaxFailedLoginAttempts *Optional*
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        expire_password (bool): expirePassword *Optional*
        passcode_expires_days (int): passcodeExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail *Optional*
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
        reenable_login (bool): reenableLogin *Optional*
        lock_out_in_minutes (int): lockOutInMinutes *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_rule_level",
        "disallow_repeated_digits",
        "number_of_repeated_digits",
        "disallow_repeated_patterns",
        "disallow_contiguous_sequences",
        "number_of_ascending_digits",
        "number_of_descending_digits",
        "disallow_user_number",
        "disallow_reversed_user_number",
        "disallow_old_passcode",
        "number_of_previous_passcodes",
        "disallow_reversed_old_passcode",
        "min_code_length",
        "max_code_length",
        "disable_login_after_max_failed_login_attempts",
        "max_failed_login_attempts",
        "expire_password",
        "passcode_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
        "reenable_login",
        "lock_out_in_minutes",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_rule_level",
                "useRuleLevel",
                str,
            ),
            E(
                "disallow_repeated_digits",
                "disallowRepeatedDigits",
                bool,
            ),
            E(
                "number_of_repeated_digits",
                "numberOfRepeatedDigits",
                int,
            ),
            E(
                "disallow_repeated_patterns",
                "disallowRepeatedPatterns",
                bool,
            ),
            E(
                "disallow_contiguous_sequences",
                "disallowContiguousSequences",
                bool,
            ),
            E(
                "number_of_ascending_digits",
                "numberOfAscendingDigits",
                int,
            ),
            E(
                "number_of_descending_digits",
                "numberOfDescendingDigits",
                int,
            ),
            E(
                "disallow_user_number",
                "disallowUserNumber",
                bool,
            ),
            E(
                "disallow_reversed_user_number",
                "disallowReversedUserNumber",
                bool,
            ),
            E(
                "disallow_old_passcode",
                "disallowOldPasscode",
                bool,
            ),
            E(
                "number_of_previous_passcodes",
                "numberOfPreviousPasscodes",
                int,
            ),
            E(
                "disallow_reversed_old_passcode",
                "disallowReversedOldPasscode",
                bool,
            ),
            E(
                "min_code_length",
                "minCodeLength",
                int,
            ),
            E(
                "max_code_length",
                "maxCodeLength",
                int,
            ),
            E(
                "disable_login_after_max_failed_login_attempts",
                "disableLoginAfterMaxFailedLoginAttempts",
                bool,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "expire_password",
                "expirePassword",
                bool,
            ),
            E(
                "passcode_expires_days",
                "passcodeExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
            E(
                "reenable_login",
                "reenableLogin",
                bool,
            ),
            E(
                "lock_out_in_minutes",
                "lockOutInMinutes",
                int,
            ),
        )


class GroupPreAlertingAnnouncementGetRequest(OCIRequest):
    """
    Get the group PreAlertingservice settings.

    The response is either a `GroupPreAlertingAnnouncementGetResponse()` or an
    `ErrorResponse()`. Replaced by: `GroupPreAlertingAnnouncementGetRequest20()` in AS
    data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPreAlertingAnnouncementGetRequest20(OCIRequest):
    """
    Get the group’s PreAlertingservice settings.

    The response is either a `GroupPreAlertingAnnouncementGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupPreferredCarrierGroupGetRequest(OCIRequest):
    """
    Requests the currently configured carriers for a group.

    The response is either a `GroupPreferredCarrierGroupGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberPrefixAssignListRequest(OCIRequest):
    """
    Assign a list of service provider number prefixes to a group.

    The number prefixes must have previously been added to the service provider.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        number_prefix (List[str]): numberPrefix *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "number_prefix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "number_prefix",
                "numberPrefix",
                str,
                is_array=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberPrefixGetAvailableListRequest(OCIRequest):
    """
    Request a list of number prefixess that are assigned to a group and still available
    for assignment to users within the group.

    The response is either
    `GroupRouteListEnterpriseTrunkNumberPrefixGetAvailableListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberPrefixGetSummaryListRequest(OCIRequest):
    """
    Get the list of assigned and unassigned enterprise trunknumber prefixes in a group.

    The response is either
    `GroupRouteListEnterpriseTrunkNumberPrefixGetSummaryListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberPrefixUnassignListRequest(OCIRequest):
    """
    Unassign a list of service provider number prefixes from a group.

    The number prefixes then become available for assignment to other groups.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        number_prefix (List[str]): numberPrefix *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "number_prefix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "number_prefix",
                "numberPrefix",
                str,
                is_array=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberRangeAssignListRequest(OCIRequest):
    """
    Assign a list of service provider number ranges to a group.

    The number ranges must have previously been added to the service provider.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        number_range_start (List[str]): numberRangeStart *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "number_range_start",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "number_range_start",
                "numberRangeStart",
                str,
                is_array=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of number ranges that are assigned to a group and still available for
    assignment to users within the group.

    The response is either
    `GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Get the list of assigned and unassigned enterprise trunknumber ranges in a group.

    The response is either
    `GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupRouteListEnterpriseTrunkNumberRangeUnassignListRequest(OCIRequest):
    """
    Unassign a list of service provider number ranges from a group.

    The number ranges then become available for assignment to other groups.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        number_range_start (List[str]): numberRangeStart *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "number_range_start",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "number_range_start",
                "numberRangeStart",
                str,
                is_array=True,
            ),
        )


class GroupRoutePointBouncedCallGetRequest(OCIRequest):
    """
    Get a route point's bounced call settings.

    The response is either a `GroupRoutePointBouncedCallGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointBouncedCallModifyRequest(OCIRequest):
    """
    Modify a route point's bounced call settings.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        is_active (bool): isActive *Optional*
        number_of_rings_before_bouncing_call (int): numberOfRingsBeforeBouncingCall
            *Optional*
        enable_transfer (bool): enableTransfer *Optional*
        transfer_phone_number (str): transferPhoneNumber *Optional*
        bounce_call_when_agent_unavailable (bool): bounceCallWhenAgentUnavailable
            *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "is_active",
        "number_of_rings_before_bouncing_call",
        "enable_transfer",
        "transfer_phone_number",
        "bounce_call_when_agent_unavailable",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "number_of_rings_before_bouncing_call",
                "numberOfRingsBeforeBouncingCall",
                int,
            ),
            E(
                "enable_transfer",
                "enableTransfer",
                bool,
            ),
            E(
                "transfer_phone_number",
                "transferPhoneNumber",
                str,
            ),
            E(
                "bounce_call_when_agent_unavailable",
                "bounceCallWhenAgentUnavailable",
                bool,
            ),
        )


class GroupRoutePointDeleteInstanceRequest(OCIRequest):
    """
    Delete a Route Point instance from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointDistinctiveRingingGetRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for route point.

    The response is either a `GroupRoutePointDistinctiveRingingGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointDistinctiveRingingModifyRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for route point.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        enable_distinctive_ringing (bool): enableDistinctiveRinging *Optional*
        distinctive_ringing_ring_pattern (str): distinctiveRingingRingPattern *Optional*
        distinctive_ringing_force_delivery_ring_pattern (str):
            distinctiveRingingForceDeliveryRingPattern *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "enable_distinctive_ringing",
        "distinctive_ringing_ring_pattern",
        "distinctive_ringing_force_delivery_ring_pattern",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "enable_distinctive_ringing",
                "enableDistinctiveRinging",
                bool,
            ),
            E(
                "distinctive_ringing_ring_pattern",
                "distinctiveRingingRingPattern",
                str,
            ),
            E(
                "distinctive_ringing_force_delivery_ring_pattern",
                "distinctiveRingingForceDeliveryRingPattern",
                str,
            ),
        )


class GroupRoutePointExternalSystemAssignListRequest(OCIRequest):
    """
    Assign a list of route point external systems to a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        route_point_external_system (List[str]): routePointExternalSystem *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "route_point_external_system",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "route_point_external_system",
                "routePointExternalSystem",
                str,
                is_array=True,
            ),
        )


class GroupRoutePointExternalSystemGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all Route Point External Systems assigned to a group.

    The response is either `GroupRoutePointExternalSystemGetAssignedListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointExternalSystemUnassignListRequest(OCIRequest):
    """
    Unassign a list of route point external systems from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        route_point_external_system (List[str]): routePointExternalSystem *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "route_point_external_system",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "route_point_external_system",
                "routePointExternalSystem",
                str,
                is_array=True,
            ),
        )


class GroupRoutePointForcedForwardingGetRequest(OCIRequest):
    """
    Get a route point's forced forwarding settings.

    The response is either a `GroupRoutePointForcedForwardingGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointForcedForwardingGetRequest20(OCIRequest):
    """
    Get a route point's forced forwarding settings.

    The response is either a `GroupRoutePointForcedForwardingGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetAnnouncementRequest(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a `GroupRoutePointGetAnnouncementResponse()` or an
    `ErrorResponse()`. Replaced by: `GroupRoutePointGetAnnouncementRequest19()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetAnnouncementRequest19(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a `GroupRoutePointGetAnnouncementResponse19()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetAnnouncementRequest20(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a `GroupRoutePointGetAnnouncementResponse20()` or an
    `ErrorResponse()`. Replaced by: `GroupRoutePointGetAnnouncementRequest22()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetAnnouncementRequest22(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a `GroupRoutePointGetAnnouncementResponse22()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetDNISListRequest(OCIRequest):
    """
    Get a list of DNIS that are configured for a Route Point.

    The response is either `GroupRoutePointGetDNISListResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetFailoverPolicyRequest(OCIRequest):
    """
    Get the route point failover policy.

    The response is either a `GroupRoutePointGetFailoverPolicyResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Route Point instance.

    The response is either `GroupRoutePointGetInstanceResponse()` or `ErrorResponse()`.
    Replaced by: `GroupRoutePointGetInstanceRequest19sp1()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Route Point instance.

    The response is either `GroupRoutePointGetInstanceResponse19sp1()` or
    `ErrorResponse()`. Replace by `GroupRoutePointGetInstanceRequest22()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetInstanceRequest22(OCIRequest):
    """
    Request to get all the information of a Route Point instance.

    The response is either `GroupRoutePointGetInstanceResponse19sp1()` or
    `ErrorResponse()`. Replaced by `GroupRoutePointGetInstanceRequest23()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointGetInstanceRequest23(OCIRequest):
    """
    Request to get all the information of a Route Point instance.

    The response is either `GroupRoutePointGetInstanceResponse19sp1()` or
    `ErrorResponse()`. The Following elements are only used in AS data mode and ignored in
    XS data mode: - sendCallAdmissionNotification, use value ‘false’ in XS data mode.  -
    callAdmissionTimerSeconds, use value ‘3’ in XS data mode.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointHolidayServiceGetRequest(OCIRequest):
    """
    Get a route point's holiday service settings.

    The response is either a `GroupRoutePointHolidayServiceGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointHolidayServiceGetRequest17sp1(OCIRequest):
    """
    Get a route point's holiday service settings.

    The response is either a `GroupRoutePointHolidayServiceGetResponse17sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointHolidayServiceGetRequest20(OCIRequest):
    """
    Get a route point's holiday service settings.

    The response is either a `GroupRoutePointHolidayServiceGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointManualFailoverRequest(OCIRequest):
    """
    Initiate manual failover for the Route Point.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointModifyDNISParametersRequest(OCIRequest):
    """
    Modify the setting that are configured for all the DNIS in a Route Point.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        display_dnis_number (bool): displayDNISNumber *Optional*
        display_dnis_name (bool): displayDNISName *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "display_dnis_number",
        "display_dnis_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "display_dnis_number",
                "displayDNISNumber",
                bool,
            ),
            E(
                "display_dnis_name",
                "displayDNISName",
                bool,
            ),
        )


class GroupRoutePointModifyFailoverPolicyRequest(OCIRequest):
    """
    Modify the route point failover policy.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        enable_failover_support (bool): enableFailoverSupport *Optional*
        external_system (str): externalSystem *Optional*
        failover_phone_number (str): failoverPhoneNumber *Optional*
        per_call_enable_failover_support (bool): perCallEnableFailoverSupport *Optional*
        per_call_call_failure_timeout_seconds (int): perCallCallFailureTimeoutSeconds
            *Optional*
        per_call_outbound_call_failure_timeout_seconds (int):
            perCallOutboundCallFailureTimeoutSeconds *Optional*
        per_call_failover_phone_number (str): perCallFailoverPhoneNumber *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "enable_failover_support",
        "external_system",
        "failover_phone_number",
        "per_call_enable_failover_support",
        "per_call_call_failure_timeout_seconds",
        "per_call_outbound_call_failure_timeout_seconds",
        "per_call_failover_phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "enable_failover_support",
                "enableFailoverSupport",
                bool,
            ),
            E(
                "external_system",
                "externalSystem",
                str,
            ),
            E(
                "failover_phone_number",
                "failoverPhoneNumber",
                str,
            ),
            E(
                "per_call_enable_failover_support",
                "perCallEnableFailoverSupport",
                bool,
            ),
            E(
                "per_call_call_failure_timeout_seconds",
                "perCallCallFailureTimeoutSeconds",
                int,
            ),
            E(
                "per_call_outbound_call_failure_timeout_seconds",
                "perCallOutboundCallFailureTimeoutSeconds",
                int,
            ),
            E(
                "per_call_failover_phone_number",
                "perCallFailoverPhoneNumber",
                str,
            ),
        )


class GroupRoutePointNightServiceGetRequest(OCIRequest):
    """
    Get a route point's night service settings.

    The response is either a `GroupRoutePointNightServiceGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointNightServiceGetRequest17sp1(OCIRequest):
    """
    Get a route point's night service settings.

    The response is either a `GroupRoutePointNightServiceGetResponse17sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointNightServiceGetRequest20(OCIRequest):
    """
    Get a route point's night service settings.

    The response is either a `GroupRoutePointNightServiceGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointOverflowGetRequest(OCIRequest):
    """
    Get a route point's overflow settings.

    The response is either a `GroupRoutePointOverflowGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointOverflowGetRequest20(OCIRequest):
    """
    Get a route point's overflow settings.

    The response is either a `GroupRoutePointOverflowGetResponse20()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointQueueCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Route Point Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        code (str): code
        is_active (bool): isActive
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupRoutePointQueueCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Route Point Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        code (str): code
    """

    __slots__: List[str] = [
        "service_user_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointQueueCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Route Point Level and Organization Level Call Disposition Codes.

    The response is either `GroupRoutePointQueueCallDispositionCodeGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointQueueCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Route Point Call Disposition Code.

    The response is either `GroupRoutePointQueueCallDispositionCodeGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        code (str): code
    """

    __slots__: List[str] = [
        "service_user_id",
        "code",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
        )


class GroupRoutePointQueueCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Route Point Call Disposition Code.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        code (str): code
        is_active (bool): isActive *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "code",
        "is_active",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "code",
                "code",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class GroupRoutePointQueueCallDispositionCodeSettingsGetRequest(OCIRequest):
    """
    Request the queue level data associated with Route Point Call Disposition Code
    Settings.

    The response is either an
    `GroupRoutePointQueueCallDispositionCodeSettingsGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupRoutingProfileGetRequest(OCIRequest):
    """
    Request the routing profile for the group.

    The response is either a `GroupRoutingProfileGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupRoutingProfileModifyRequest(OCIRequest):
    """
    Requests to modify the routing profile for a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        routing_profile (str): routingProfile *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "routing_profile",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "routing_profile",
                "routingProfile",
                str,
            ),
        )


class GroupScheduleAddRequest(OCIRequest):
    """
    Add a group schedule.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        schedule_name (str): scheduleName
        schedule_type (str): scheduleType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "schedule_name",
        "schedule_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "schedule_name",
                "scheduleName",
                str,
                is_required=True,
            ),
            E(
                "schedule_type",
                "scheduleType",
                str,
                is_required=True,
            ),
        )


class GroupScheduleGetListRequest(OCIRequest):
    """
    Get the list of a group schedules.

    The list can be filtered by schedule type.

    The response is either a `GroupScheduleGetListResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        schedule_type (str): scheduleType *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "schedule_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "schedule_type",
                "scheduleType",
                str,
            ),
        )


class GroupScheduleGetListRequest17sp1(OCIRequest):
    """
    Get the list of schedules viewable by a group.

    The list can be filtered by schedule type.

    The response is either a `GroupScheduleGetListResponse17sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        schedule_type (str): scheduleType *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "schedule_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "schedule_type",
                "scheduleType",
                str,
            ),
        )


class GroupSecurityClassificationCustomizationGetAvailableListRequest(OCIRequest):
    """
    Get the available group security classification list.

    If it is not customized, it returns the system default list.

    The response is either an
    `GroupSecurityClassificationCustomizationGetAvailableListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupSeriesCompletionAddInstanceRequest(OCIRequest):
    """
    Adds a Series Completion group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
        user_id (List[str]): userId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_array=True,
            ),
        )


class GroupSeriesCompletionDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Series Completion group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupSeriesCompletionGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Series Completion instances within a group.

    The response is either `GroupSeriesCompletionGetInstanceListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupSeriesCompletionGetInstanceRequest(OCIRequest):
    """
    Gets a Series Completion group.

    The response is either `GroupSeriesCompletionGetInstanceResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupServiceAssignListRequest(OCIRequest):
    """
    Assign one or more group services to the group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_name (List[str]): serviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_name",
                "serviceName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupServiceGetAuthorizationListRequest(OCIRequest):
    """
    Requests the group's service authorization status.

    The response is either `GroupServiceGetAuthorizationListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupServiceGetAuthorizationRequest(OCIRequest):
    """
    Requests the group's service authorization information for a specific service or
    service pack.

    The response is either `GroupServiceGetAuthorizationResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        user_service_name (str): userServiceName *Optional*
        group_service_name (str): groupServiceName *Optional*
        service_pack_name (str): servicePackName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "user_service_name",
        "group_service_name",
        "service_pack_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "user_service_name",
                "userServiceName",
                str,
            ),
            E(
                "group_service_name",
                "groupServiceName",
                str,
            ),
            E(
                "service_pack_name",
                "servicePackName",
                str,
            ),
        )


class GroupServiceGetAuthorizedListRequest(OCIRequest):
    """
    Requests the list of services and service packs authorized to a group.

    The response is either `GroupServiceGetAuthorizedListResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupServiceInstancePrivacyGetRequest(OCIRequest):
    """
    Request the data associated with Privacy for a service instance.

    The response is either a `GroupServiceInstancePrivacyGetResponse()`. Replaced by:
    `GroupServiceInstancePrivacyGetRequest17sp4()`

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupServiceInstancePrivacyGetRequest17sp4(OCIRequest):
    """
    Request the data associated with Privacy for a service instance.

    The response is either a `GroupServiceInstancePrivacyGetResponse17sp4()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupServiceInstancePrivacyModifyRequest(OCIRequest):
    """
    Modify the data associated with Privacy for a service instance.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        enable_directory_privacy (bool): enableDirectoryPrivacy *Optional*
        enable_auto_attendant_extension_dialing_privacy (bool):
            enableAutoAttendantExtensionDialingPrivacy *Optional*
        enable_auto_attendant_name_dialing_privacy (bool):
            enableAutoAttendantNameDialingPrivacy *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "enable_directory_privacy",
        "enable_auto_attendant_extension_dialing_privacy",
        "enable_auto_attendant_name_dialing_privacy",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "enable_directory_privacy",
                "enableDirectoryPrivacy",
                bool,
            ),
            E(
                "enable_auto_attendant_extension_dialing_privacy",
                "enableAutoAttendantExtensionDialingPrivacy",
                bool,
            ),
            E(
                "enable_auto_attendant_name_dialing_privacy",
                "enableAutoAttendantNameDialingPrivacy",
                bool,
            ),
        )


class GroupServiceIsAssignedRequest(OCIRequest):
    """
    Request to determine if a GroupService is assigned to the group.


    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_name (str): serviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_name",
                "serviceName",
                str,
                is_required=True,
            ),
        )


class GroupServicePhoneNumberLookupRequest(OCIRequest):
    """
    Lookup if the given number is defined in the specified service in the group.

    The response is `GroupServicePhoneNumberLookupResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_type (str): serviceType
        phone_number (str): phoneNumber
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_type",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_type",
                "serviceType",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
        )


class GroupServiceUnassignListRequest(OCIRequest):
    """
    Unassign one or more of the group's assigned services.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_name (List[str]): serviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_name",
                "serviceName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupSessionAdmissionControlGetRequest(OCIRequest):
    """
    Get the session admission control capacity for the group.

    The response is either a `GroupSessionAdmissionControlGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupSessionAdmissionControlGroupDeleteListRequest(OCIRequest):
    """
    Request to delete one or more session admission control groups for the group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (List[str]): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class GroupSessionAdmissionControlGroupGetListRequest(OCIRequest):
    """
    Request to get the list of session admission control group for the group.

    The response is either a `GroupSessionAdmissionControlGroupGetListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupSessionAdmissionControlGroupGetRequest(OCIRequest):
    """
    Request to get a session admission control group for the group.

    The response is either a `GroupSessionAdmissionControlGroupGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupSessionAdmissionControlGroupGetRequest19sp1(OCIRequest):
    """
    Request to get a session admission control group for the group.

    The response is either a `GroupSessionAdmissionControlGroupGetResponse19sp1()` or an
    `ErrorResponse()`. Replaced by: `GroupSessionAdmissionControlGroupGetRequest21sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupSessionAdmissionControlGroupGetRequest21sp1(OCIRequest):
    """
    Request to get a session admission control group for the group.

    The response is either a `GroupSessionAdmissionControlGroupGetResponse21sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        name (str): name
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "name",
                "name",
                str,
                is_required=True,
            ),
        )


class GroupSessionAdmissionControlModifyRequest(OCIRequest):
    """
    Request to modify session admission control capacity for the group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        restrict_aggregate_sessions (bool): restrictAggregateSessions *Optional*
        max_sessions (int): maxSessions *Optional*
        max_user_originating_sessions (int): maxUserOriginatingSessions *Optional*
        max_user_terminating_sessions (int): maxUserTerminatingSessions *Optional*
        count_intra_group_sessions (bool): countIntraGroupSessions *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "restrict_aggregate_sessions",
        "max_sessions",
        "max_user_originating_sessions",
        "max_user_terminating_sessions",
        "count_intra_group_sessions",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "restrict_aggregate_sessions",
                "restrictAggregateSessions",
                bool,
            ),
            E(
                "max_sessions",
                "maxSessions",
                int,
            ),
            E(
                "max_user_originating_sessions",
                "maxUserOriginatingSessions",
                int,
            ),
            E(
                "max_user_terminating_sessions",
                "maxUserTerminatingSessions",
                int,
            ),
            E(
                "count_intra_group_sessions",
                "countIntraGroupSessions",
                bool,
            ),
        )


class GroupShInterfaceGetUserListRequest(OCIRequest):
    """
    Returns a list of all Public User Identities and associated data in a group.

    The response is either a `GroupShInterfaceGetUserListResponse()` or an
    `ErrorResponse()`. Replaced by: `GroupShInterfaceGetUserListRequest21sp1()` in AS data
    mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupShInterfaceGetUserListRequest21sp1(OCIRequest):
    """
    Returns a list of all Public User Identities and associated data in a group.

    The response is either a `GroupShInterfaceGetUserListResponse21sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupSpeedDial100GetRequest(OCIRequest):
    """
    Get the speed dial 100 service settings for a group.

    The response is either a `GroupSpeedDial100GetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupSpeedDial100GetRequest17sp1(OCIRequest):
    """
    Get the speed dial 100 service settings for a group.

    The response is either a `GroupSpeedDial100GetResponse17sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupSpeedDial100ModifyRequest(OCIRequest):
    """
    Modify the speed dial 100 prefix setting for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        prefix (str): prefix *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "prefix",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "prefix",
                "prefix",
                str,
            ),
        )


class GroupStirShakenGetRequest(OCIRequest):
    """
    Get Group Stir Shaken service settings.

    The response is either `GroupStirShakenGetResponse()` or `ErrorResponse()`. Replaced
    by: `GroupStirShakenGetRequest23()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupStirShakenGetRequest23(OCIRequest):
    """
    Get Group Stir Shaken service settings.

    The response is either `GroupStirShakenGetResponse23()` or `ErrorResponse()`. Replaced
    by `GroupStirShakenGetRequest23V2()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupStirShakenGetRequest23V2(OCIRequest):
    """
    Get Group Stir Shaken service settings.

    The response is either `GroupStirShakenGetResponse23V2()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupStirShakenModifyRequest(OCIRequest):
    """
    Modify Group Stir Shaken service settings.


    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_parent_level_settings (bool): useParentLevelSettings *Optional*
        signing_policy (str): signingPolicy *Optional*
        tagging_policy (str): taggingPolicy *Optional*
        signing_service_url (str): signingServiceURL *Optional*
        tag_from_or_pai (str): tagFromOrPAI *Optional*
        verstat_tag (str): verstatTag *Optional*
        use_os_value_for_orig_id (bool): useOSValueForOrigId *Optional*
        orig_uuid (str): origUUID *Optional*
        attestation_level (str): attestationLevel *Optional*
        enable_verification (bool): enableVerification *Optional*
        verification_service_url (str): verificationServiceURL *Optional*
        verification_error_handling (str): verificationErrorHandling *Optional*
        proxy_verstat_to_cnam_subscribe (bool): proxyVerstatToCNAMSubscribe *Optional*
        use_unknown_headers_from_cnam_notify (bool): useUnknownHeadersFromCNAMNotify
            *Optional*
        enable_signing_for_unscreened_trunk_group_originations (bool):
            enableSigningForUnscreenedTrunkGroupOriginations *Optional*
        enable_tagging_for_unscreened_trunk_group_originations (bool):
            enableTaggingForUnscreenedTrunkGroupOriginations *Optional*
        unscreened_trunk_group_origination_attestation_level (str):
            unscreenedTrunkGroupOriginationAttestationLevel *Optional*
        include_tagged_headers_to_access_side (bool): includeTaggedHeadersToAccessSide
            *Optional*
        proxy_identity_header_to_access_side (bool): proxyIdentityHeaderToAccessSide
            *Optional*
        check_directory_numbers_for_attestation (bool):
            checkDirectoryNumbersForAttestation *Optional*
        match_unassigned_numbers_only (bool): matchUnassignedNumbersOnly *Optional*
        enable_tagging_for_redirected_calls (bool): enableTaggingForRedirectedCalls
            *Optional*
        prefer_ingress_tagging (bool): preferIngressTagging *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_parent_level_settings",
        "signing_policy",
        "tagging_policy",
        "signing_service_url",
        "tag_from_or_pai",
        "verstat_tag",
        "use_os_value_for_orig_id",
        "orig_uuid",
        "attestation_level",
        "enable_verification",
        "verification_service_url",
        "verification_error_handling",
        "proxy_verstat_to_cnam_subscribe",
        "use_unknown_headers_from_cnam_notify",
        "enable_signing_for_unscreened_trunk_group_originations",
        "enable_tagging_for_unscreened_trunk_group_originations",
        "unscreened_trunk_group_origination_attestation_level",
        "include_tagged_headers_to_access_side",
        "proxy_identity_header_to_access_side",
        "check_directory_numbers_for_attestation",
        "match_unassigned_numbers_only",
        "enable_tagging_for_redirected_calls",
        "prefer_ingress_tagging",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_parent_level_settings",
                "useParentLevelSettings",
                bool,
            ),
            E(
                "signing_policy",
                "signingPolicy",
                str,
            ),
            E(
                "tagging_policy",
                "taggingPolicy",
                str,
            ),
            E(
                "signing_service_url",
                "signingServiceURL",
                str,
            ),
            E(
                "tag_from_or_pai",
                "tagFromOrPAI",
                str,
            ),
            E(
                "verstat_tag",
                "verstatTag",
                str,
            ),
            E(
                "use_os_value_for_orig_id",
                "useOSValueForOrigId",
                bool,
            ),
            E(
                "orig_uuid",
                "origUUID",
                str,
            ),
            E(
                "attestation_level",
                "attestationLevel",
                str,
            ),
            E(
                "enable_verification",
                "enableVerification",
                bool,
            ),
            E(
                "verification_service_url",
                "verificationServiceURL",
                str,
            ),
            E(
                "verification_error_handling",
                "verificationErrorHandling",
                str,
            ),
            E(
                "proxy_verstat_to_cnam_subscribe",
                "proxyVerstatToCNAMSubscribe",
                bool,
            ),
            E(
                "use_unknown_headers_from_cnam_notify",
                "useUnknownHeadersFromCNAMNotify",
                bool,
            ),
            E(
                "enable_signing_for_unscreened_trunk_group_originations",
                "enableSigningForUnscreenedTrunkGroupOriginations",
                bool,
            ),
            E(
                "enable_tagging_for_unscreened_trunk_group_originations",
                "enableTaggingForUnscreenedTrunkGroupOriginations",
                bool,
            ),
            E(
                "unscreened_trunk_group_origination_attestation_level",
                "unscreenedTrunkGroupOriginationAttestationLevel",
                str,
            ),
            E(
                "include_tagged_headers_to_access_side",
                "includeTaggedHeadersToAccessSide",
                bool,
            ),
            E(
                "proxy_identity_header_to_access_side",
                "proxyIdentityHeaderToAccessSide",
                bool,
            ),
            E(
                "check_directory_numbers_for_attestation",
                "checkDirectoryNumbersForAttestation",
                bool,
            ),
            E(
                "match_unassigned_numbers_only",
                "matchUnassignedNumbersOnly",
                bool,
            ),
            E(
                "enable_tagging_for_redirected_calls",
                "enableTaggingForRedirectedCalls",
                bool,
            ),
            E(
                "prefer_ingress_tagging",
                "preferIngressTagging",
                bool,
            ),
        )


class GroupTemplateOnlyDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of template files used to support a VDM device defined at
    group level.

    The response is either `GroupTemplateOnlyDeviceFileGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupThirdPartyEmergencyCallingGetRequest(OCIRequest):
    """
    Get the third-party emergency call service settings for the Group.

    The response is either a `GroupThirdPartyEmergencyCallingGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupThirdPartyEmergencyCallingGetRequest22(OCIRequest):
    """
    Get the third-party emergency call service settings for the Group.

    The response is either a `GroupThirdPartyEmergencyCallingGetResponse22()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupThirdPartyEmergencyCallingModifyRequest(OCIRequest):
    """
    Modify the third-party emergency call service settings for the Group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        enable_device_management (bool): enableDeviceManagement *Optional*
        enable_routing (bool): enableRouting *Optional*
        customer_id (str): customerId *Optional*
        secret_key (str): secretKey *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "enable_device_management",
        "enable_routing",
        "customer_id",
        "secret_key",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "enable_device_management",
                "enableDeviceManagement",
                bool,
            ),
            E(
                "enable_routing",
                "enableRouting",
                bool,
            ),
            E(
                "customer_id",
                "customerId",
                str,
            ),
            E(
                "secret_key",
                "secretKey",
                str,
            ),
        )


class GroupThirdPartyVoiceMailSupportGetRequest(OCIRequest):
    """
    Request the group level data associated with Third-Party Voice Mail Support.

    The response is either a `GroupThirdPartyVoiceMailSupportGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupThirdPartyVoiceMailSupportModifyRequest(OCIRequest):
    """
    Modify the Third Party Voice Mail Support settings for a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        is_active (bool): isActive *Optional*
        group_server (str): groupServer *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "is_active",
        "group_server",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "is_active",
                "isActive",
                bool,
            ),
            E(
                "group_server",
                "groupServer",
                str,
            ),
        )


class GroupTimeScheduleDeleteRequest(OCIRequest):
    """
    Delete a time schedule from a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        time_schedule_name (str): timeScheduleName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "time_schedule_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "time_schedule_name",
                "timeScheduleName",
                str,
                is_required=True,
            ),
        )


class GroupTimeScheduleGetListRequest(OCIRequest):
    """
    Request a list of all time schedules in a group.

    The response is either a `GroupTimeScheduleGetListResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupTimeScheduleGetRequest(OCIRequest):
    """
    Request to get a group time schedule.

    The response is either a `GroupTimeScheduleGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        time_schedule_name (str): timeScheduleName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "time_schedule_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "time_schedule_name",
                "timeScheduleName",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupDeleteInstanceRequest(OCIRequest):
    """
    Delete a Trunk Group Instance from a group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupGetAvailableDetailListRequest(OCIRequest):
    """
    Requests the list of available trunk groups within a group.

    The response is either `GroupTrunkGroupGetAvailableDetailListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupGetInstanceListRequest14(OCIRequest):
    """
    Get a list of Trunk Groups for the group or enterprise.

    It is possible to restrict the results to a particular department, or expand the list
    to the entire enterprise.

    The response is either a `GroupTrunkGroupGetInstanceListResponse14()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
        include_enterprise_trunk_groups (bool): includeEnterpriseTrunkGroups *Optional*
        only_trunk_groups_with_device (bool): onlyTrunkGroupsWithDevice *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
        "include_enterprise_trunk_groups",
        "only_trunk_groups_with_device",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
            E(
                "include_enterprise_trunk_groups",
                "includeEnterpriseTrunkGroups",
                bool,
            ),
            E(
                "only_trunk_groups_with_device",
                "onlyTrunkGroupsWithDevice",
                bool,
            ),
        )


class GroupTrunkGroupGetInstanceListRequest14sp4(OCIRequest):
    """
    Get a list of Trunk Groups for the group or enterprise.

    It is possible to restrict the results to a particular department, or expand the list
    to the entire enterprise.

    The response is either a `GroupTrunkGroupGetInstanceListResponse14sp4()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
        include_enterprise_trunk_groups (bool): includeEnterpriseTrunkGroups *Optional*
        only_trunk_groups_with_device (bool): onlyTrunkGroupsWithDevice *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
        "include_enterprise_trunk_groups",
        "only_trunk_groups_with_device",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
            E(
                "include_enterprise_trunk_groups",
                "includeEnterpriseTrunkGroups",
                bool,
            ),
            E(
                "only_trunk_groups_with_device",
                "onlyTrunkGroupsWithDevice",
                bool,
            ),
        )


class GroupTrunkGroupGetInstanceRequest14(OCIRequest):
    """
    Get a Trunk Group Instance's profile.

    The response is either a `GroupTrunkGroupGetInstanceResponse14()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupGetInstanceRequest14sp1(OCIRequest):
    """
    Get a Trunk Group Instance's profile.

    The response is either a `GroupTrunkGroupGetInstanceResponse14sp1()` or an
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupGetRequest(OCIRequest):
    """
    Get the maximum permissible active trunk group calls for the group.

    The response is either a `GroupTrunkGroupGetResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupGetRequest14sp1(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active trunk group calls for the
    group.

    The response is either a `GroupTrunkGroupGetResponse14sp1()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupGetRequest14sp9(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active trunk group calls for the
    group.

    The response is either a `GroupTrunkGroupGetResponse14sp9()` or an `ErrorResponse()`.
    Deprecated by `GroupTrunkGroupGetRequest23()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupGetRequest23(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active trunk group calls for the
    group.

    The response is either a `GroupTrunkGroupGetResponse23()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupUserCreationTaskAddRequest(OCIRequest):
    """
    Add a user creation task for a trunk group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        task_name (str): taskName
        user_id_format (str): userIdFormat
        user_id_domain (str): userIdDomain
        populate_extension (bool): populateExtension
        line_port_format (str): linePortFormat
        line_port_domain (str): linePortDomain
        populate_contact (bool): populateContact
        contact_format (str): contactFormat *Optional*
        contact_domain (str): contactDomain *Optional*
        user_phone_numbers (OCI.userPhoneNumbers): userPhoneNumbers *Optional*
        user_extensions (OCI.userExtensions): userExtensions *Optional*
        service_pack_name (List[str]): servicePackName *Optional*
        user_service (List[str]): userService *Optional*
    """

    __slots__: List[str] = [
        "service_user_id",
        "task_name",
        "user_id_format",
        "user_id_domain",
        "populate_extension",
        "line_port_format",
        "line_port_domain",
        "populate_contact",
        "contact_format",
        "contact_domain",
        "user_phone_numbers",
        "user_extensions",
        "service_pack_name",
        "user_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "task_name",
                "taskName",
                str,
                is_required=True,
            ),
            E(
                "user_id_format",
                "userIdFormat",
                str,
                is_required=True,
            ),
            E(
                "user_id_domain",
                "userIdDomain",
                str,
                is_required=True,
            ),
            E(
                "populate_extension",
                "populateExtension",
                bool,
                is_required=True,
            ),
            E(
                "line_port_format",
                "linePortFormat",
                str,
                is_required=True,
            ),
            E(
                "line_port_domain",
                "linePortDomain",
                str,
                is_required=True,
            ),
            E(
                "populate_contact",
                "populateContact",
                bool,
                is_required=True,
            ),
            E(
                "contact_format",
                "contactFormat",
                str,
            ),
            E(
                "contact_domain",
                "contactDomain",
                str,
            ),
            E(
                "user_phone_numbers",
                "userPhoneNumbers",
                [
                    E(
                        "phone_number",
                        "phoneNumber",
                        str,
                        is_array=True,
                    ),
                    E(
                        "dn_range",
                        "dnRange",
                        OCI.DNRange,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "user_extensions",
                "userExtensions",
                [
                    E(
                        "extension",
                        "extension",
                        str,
                        is_array=True,
                    ),
                    E(
                        "extension_range",
                        "extensionRange",
                        OCI.ExtensionRange,
                        is_complex=True,
                        is_array=True,
                    ),
                ],
                is_complex=True,
                is_container=True,
            ),
            E(
                "service_pack_name",
                "servicePackName",
                str,
                is_array=True,
            ),
            E(
                "user_service",
                "userService",
                str,
                is_array=True,
            ),
        )


class GroupTrunkGroupUserCreationTaskDeleteRequest(OCIRequest):
    """
    Delete a user creation task for a trunk group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        task_name (str): taskName
    """

    __slots__: List[str] = [
        "service_user_id",
        "task_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "task_name",
                "taskName",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupUserCreationTaskGetListRequest(OCIRequest):
    """
    Get the list of user creation tasks for a trunk group.

    The response is either `GroupTrunkGroupUserCreationTaskGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupTrunkGroupUserCreationTaskGetRequest(OCIRequest):
    """
    Request the details of a specified user creation task for a trunk group.

    The response is either `GroupTrunkGroupUserCreationTaskGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
        task_name (str): taskName
    """

    __slots__: List[str] = [
        "service_user_id",
        "task_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
            E(
                "task_name",
                "taskName",
                str,
                is_required=True,
            ),
        )


class GroupUserLanguageModifyRequest(OCIRequest):
    """
    Request to modify language of the users within a group.

    If neither applyToUsers nor applyToServiceInstances is specified in the request,
    language is not changed for any user in the group.  If applyToUsers is specified,
    regular users within the group have the language modified.  If applyToServiceInstances
    is specified, the service instance users within the group have the language modified.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        language (str): language
        apply_to_users (bool): applyToUsers *Optional*
        apply_to_service_instances (bool): applyToServiceInstances *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "language",
        "apply_to_users",
        "apply_to_service_instances",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "language",
                "language",
                str,
                is_required=True,
            ),
            E(
                "apply_to_users",
                "applyToUsers",
                bool,
            ),
            E(
                "apply_to_service_instances",
                "applyToServiceInstances",
                bool,
            ),
        )


class GroupVirtualOnNetEnterpriseExtensionsDeleteUserRequest(OCIRequest):
    """
    Delete an existing Virtual On-Net user from a Group.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        phone_number (str): phoneNumber
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
        )


class GroupVirtualOnNetEnterpriseExtensionsGetUserRequest(OCIRequest):
    """
    Get an existing Virtual On-Net user from a Group.

    The response is either a `GroupVirtualOnNetEnterpriseExtensionsGetUserResponse()` or
    an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        phone_number (str): phoneNumber
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "phone_number",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
        )


class GroupVirtualOnNetEnterpriseExtensionsModifyUserRequest(OCIRequest):
    """
    Modify an existing Virtual On-Net user of a Group.

    The serviceProviderId, groupId and phoneNumber combination uniquely identifies a
    Virtual On-Net User.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        phone_number (str): phoneNumber
        extension (str): extension *Optional*
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        calling_line_id_first_name (str): callingLineIdFirstName *Optional*
        calling_line_id_last_name (str): callingLineIdLastName *Optional*
        virtual_on_net_call_type_name (str): virtualOnNetCallTypeName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "phone_number",
        "extension",
        "first_name",
        "last_name",
        "calling_line_id_first_name",
        "calling_line_id_last_name",
        "virtual_on_net_call_type_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "phone_number",
                "phoneNumber",
                str,
                is_required=True,
            ),
            E(
                "extension",
                "extension",
                str,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "calling_line_id_first_name",
                "callingLineIdFirstName",
                str,
            ),
            E(
                "calling_line_id_last_name",
                "callingLineIdLastName",
                str,
            ),
            E(
                "virtual_on_net_call_type_name",
                "virtualOnNetCallTypeName",
                str,
            ),
        )


class GroupVisualDeviceManagementGetDeviceInfoRequest(OCIRequest):
    """
    Get the information for a specified device supporting visual device management.

    The response is either a `GroupVisualDeviceManagementGetDeviceInfoResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetPasscodeRulesRequest(OCIRequest):
    """
    Requests the group's voice portal passcode rules setting.

    The response is either `GroupVoiceMessagingGroupGetPasscodeRulesResponse()` or
    `ErrorResponse()`.

    Replaced By: `GroupPortalPasscodeRulesGetRequest()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetRequest(OCIRequest):
    """
    Requests the group's Voice Messaging settings.

    The response is either `GroupVoiceMessagingGroupGetResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest(OCIRequest):
    """
    Get the group's voice portal branding settings.

    The response is either a `GroupVoiceMessagingGroupGetVoicePortalBrandingResponse()` or
    an `ErrorResponse()`.

    Replaced By: `GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16(OCIRequest):
    """
    Get the group's voice portal branding settings.

    The response is either a `GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16()`
    or an `ErrorResponse()`. Replaced by:
    `GroupVoiceMessagingGroupGetVoicePortalBrandingRequest20()` in AS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest20(OCIRequest):
    """
    Get the group's voice portal branding settings.

    The response is either a `GroupVoiceMessagingGroupGetVoicePortalBrandingResponse20()`
    or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalRequest14(OCIRequest):
    """
    Requests the group's voice messaging settings The response is either
    `GroupVoiceMessagingGroupGetVoicePortalResponse14()` or `ErrorResponse()`.

    Replaced by `GroupVoiceMessagingGroupGetVoicePortalRequest15()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalRequest15(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either `GroupVoiceMessagingGroupGetVoicePortalResponse15()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalRequest17(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either `GroupVoiceMessagingGroupGetVoicePortalResponse17()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalRequest17sp4(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either `GroupVoiceMessagingGroupGetVoicePortalResponse17sp4()` or
    `ErrorResponse()`. Replaced by: `GroupVoiceMessagingGroupGetVoicePortalRequest19sp1()`
    in AS data mode

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalRequest19sp1(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either `GroupVoiceMessagingGroupGetVoicePortalResponse19sp1()` or
    `ErrorResponse()`. Replaced by: `GroupVoiceMessagingGroupGetVoicePortalRequest21sp1()`
    in AS data mode.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupGetVoicePortalRequest21sp1(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either `GroupVoiceMessagingGroupGetVoicePortalResponse21sp1()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceMessagingGroupModifyPasscodeRulesRequest(OCIRequest):
    """
    Request to modify the group's voice portal passcode rules setting.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Replaced By: `GroupPortalPasscodeRulesModifyRequest()`

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_rule_level (str): useRuleLevel *Optional*
        disallow_repeated_digits (bool): disallowRepeatedDigits *Optional*
        disallow_user_number (bool): disallowUserNumber *Optional*
        disallow_reversed_user_number (bool): disallowReversedUserNumber *Optional*
        disallow_old_passcode (bool): disallowOldPasscode *Optional*
        disallow_reversed_old_passcode (bool): disallowReversedOldPasscode *Optional*
        min_code_length (int): minCodeLength *Optional*
        max_code_length (int): maxCodeLength *Optional*
        disable_login_after_max_failed_login_attempts (bool):
            disableLoginAfterMaxFailedLoginAttempts *Optional*
        max_failed_login_attempts (int): maxFailedLoginAttempts *Optional*
        expire_password (bool): expirePassword *Optional*
        passcode_expires_days (int): passcodeExpiresDays *Optional*
        send_login_disabled_notify_email (bool): sendLoginDisabledNotifyEmail *Optional*
        login_disabled_notify_email_address (str): loginDisabledNotifyEmailAddress
            *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_rule_level",
        "disallow_repeated_digits",
        "disallow_user_number",
        "disallow_reversed_user_number",
        "disallow_old_passcode",
        "disallow_reversed_old_passcode",
        "min_code_length",
        "max_code_length",
        "disable_login_after_max_failed_login_attempts",
        "max_failed_login_attempts",
        "expire_password",
        "passcode_expires_days",
        "send_login_disabled_notify_email",
        "login_disabled_notify_email_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_rule_level",
                "useRuleLevel",
                str,
            ),
            E(
                "disallow_repeated_digits",
                "disallowRepeatedDigits",
                bool,
            ),
            E(
                "disallow_user_number",
                "disallowUserNumber",
                bool,
            ),
            E(
                "disallow_reversed_user_number",
                "disallowReversedUserNumber",
                bool,
            ),
            E(
                "disallow_old_passcode",
                "disallowOldPasscode",
                bool,
            ),
            E(
                "disallow_reversed_old_passcode",
                "disallowReversedOldPasscode",
                bool,
            ),
            E(
                "min_code_length",
                "minCodeLength",
                int,
            ),
            E(
                "max_code_length",
                "maxCodeLength",
                int,
            ),
            E(
                "disable_login_after_max_failed_login_attempts",
                "disableLoginAfterMaxFailedLoginAttempts",
                bool,
            ),
            E(
                "max_failed_login_attempts",
                "maxFailedLoginAttempts",
                int,
            ),
            E(
                "expire_password",
                "expirePassword",
                bool,
            ),
            E(
                "passcode_expires_days",
                "passcodeExpiresDays",
                int,
            ),
            E(
                "send_login_disabled_notify_email",
                "sendLoginDisabledNotifyEmail",
                bool,
            ),
            E(
                "login_disabled_notify_email_address",
                "loginDisabledNotifyEmailAddress",
                str,
            ),
        )


class GroupVoiceMessagingGroupModifyRequest(OCIRequest):
    """
    Request to modify the group's voice messaging settings.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        use_mail_server_setting (str): useMailServerSetting *Optional*
        warn_caller_before_recording_voice_message (bool):
            warnCallerBeforeRecordingVoiceMessage *Optional*
        allow_users_configuring_advanced_settings (bool):
            allowUsersConfiguringAdvancedSettings *Optional*
        allow_compose_or_forward_message_to_entire_group (bool):
            allowComposeOrForwardMessageToEntireGroup *Optional*
        mail_server_net_address (str): mailServerNetAddress *Optional*
        mail_server_protocol (str): mailServerProtocol *Optional*
        real_delete_for_imap (bool): realDeleteForImap *Optional*
        max_mailbox_length_minutes (int): maxMailboxLengthMinutes *Optional*
        does_message_age (bool): doesMessageAge *Optional*
        hold_period_days (int): holdPeriodDays *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "use_mail_server_setting",
        "warn_caller_before_recording_voice_message",
        "allow_users_configuring_advanced_settings",
        "allow_compose_or_forward_message_to_entire_group",
        "mail_server_net_address",
        "mail_server_protocol",
        "real_delete_for_imap",
        "max_mailbox_length_minutes",
        "does_message_age",
        "hold_period_days",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "use_mail_server_setting",
                "useMailServerSetting",
                str,
            ),
            E(
                "warn_caller_before_recording_voice_message",
                "warnCallerBeforeRecordingVoiceMessage",
                bool,
            ),
            E(
                "allow_users_configuring_advanced_settings",
                "allowUsersConfiguringAdvancedSettings",
                bool,
            ),
            E(
                "allow_compose_or_forward_message_to_entire_group",
                "allowComposeOrForwardMessageToEntireGroup",
                bool,
            ),
            E(
                "mail_server_net_address",
                "mailServerNetAddress",
                str,
            ),
            E(
                "mail_server_protocol",
                "mailServerProtocol",
                str,
            ),
            E(
                "real_delete_for_imap",
                "realDeleteForImap",
                bool,
            ),
            E(
                "max_mailbox_length_minutes",
                "maxMailboxLengthMinutes",
                int,
            ),
            E(
                "does_message_age",
                "doesMessageAge",
                bool,
            ),
            E(
                "hold_period_days",
                "holdPeriodDays",
                int,
            ),
        )


class GroupVoiceXmlDeleteInstanceRequest(OCIRequest):
    """
    Delete a VoiceXML instance from a group.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceXmlGetInstanceListRequest(OCIRequest):
    """
    Get a list of VoiceXML instances within a group.

    The response is either `GroupVoiceXmlGetInstanceListResponse()` or `ErrorResponse()`.
    It is possible to get the instances within a specified department.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        group_department_name (str): groupDepartmentName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "group_department_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "group_department_name",
                "groupDepartmentName",
                str,
            ),
        )


class GroupVoiceXmlGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.

    The response is either `GroupVoiceXmlGetInstanceResponse()` or `ErrorResponse()`.
    Replaced by: `GroupVoiceXmlGetInstanceRequest19sp1()` in AS data mode

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceXmlGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.

    The response is either `GroupVoiceXmlGetInstanceResponse19sp1()` or `ErrorResponse()`.
    Replaced by: `GroupVoiceXmlGetInstanceRequest22()` in AS mode

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceXmlGetInstanceRequest22(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.

    The response is either `GroupVoiceXmlGetInstanceResponse22()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupVoiceXmlGetInstanceRequest23(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.

    The response is either `GroupVoiceXmlGetInstanceResponse23()` or `ErrorResponse()`.

    Attributes:
        service_user_id (str): serviceUserId
    """

    __slots__: List[str] = [
        "service_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_user_id",
                "serviceUserId",
                str,
                is_required=True,
            ),
        )


class GroupXsiPolicyProfileGetAssignedListRequest(OCIRequest):
    """
    Get a list of Xsi policy profile assigned.

    The response is either a `GroupXsiPolicyProfileGetAssignedListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        level (str): level *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "level",
                "level",
                str,
            ),
        )


class GroupXsiPolicyProfileModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Xsi policy profile for a group.

    It can only modify the user level default Xsi policy profile.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        group_id (str): groupId
        user_default_xsi_policy_profile (str): userDefaultXsiPolicyProfile *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "group_id",
        "user_default_xsi_policy_profile",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "group_id",
                "groupId",
                str,
                is_required=True,
            ),
            E(
                "user_default_xsi_policy_profile",
                "userDefaultXsiPolicyProfile",
                str,
            ),
        )


class LoginRequest13mp10(OCIRequest):
    """
    `LoginRequest13mp10()` is 2nd stage of the 2 stage OCI login process.

    The signedPassword is not required for external authentication login from a trusted
    host (ACL).

    Attributes:
        user_id (str): userId
        signed_password (str): signedPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "signed_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
        )


class LoginRequest14sp4(OCIRequest):
    """
    `LoginRequest14sp4()` is 2nd stage of the 2 stage OCI login process.

    The signedPassword is not required for external authentication login from a trusted
    host (ACL).

    Attributes:
        user_id (str): userId
        signed_password (str): signedPassword *Optional*
        plain_text_password (str): plainTextPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "signed_password",
        "plain_text_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "plain_text_password",
                "plainTextPassword",
                str,
            ),
        )


class LoginRequest21sp1(OCIRequest):
    """
    `LoginRequest21sp1()` is 2nd stage of the 2 stage OCI login process.

    The signedPassword is not required for external authentication login from a trusted
    host (ACL). Replaced by `LoginRequest22V3()` in AS data mode.

    Attributes:
        user_id (str): userId
        signed_password (str): signedPassword *Optional*
        plain_text_password (str): plainTextPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "signed_password",
        "plain_text_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
            E(
                "plain_text_password",
                "plainTextPassword",
                str,
            ),
        )


class LoginRequest22(OCIRequest):
    """
    Request to login to OCI.

    password is not required for external authentication login from a trusted host (ACL).
    Replaced by `LoginRequest22V2()` in AS data mode.

    Attributes:
        user_id (str): userId
        password (str): password *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
            ),
        )


class LoginRequest22V2(OCIRequest):
    """
    Request to login to OCI.

    password is not required for external authentication login from a trusted host (ACL).
    Replaced by `LoginRequest22V3()` in AS data mode.

    Attributes:
        user_id (str): userId
        password (str): password *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
            ),
        )


class LoginRequest22V3(OCIRequest):
    """
    Request to login to OCI.

    password is not required for external authentication login from a trusted host (ACL).
    Replaced by `LoginRequest22V4()` in AS data mode.

    Attributes:
        user_id (str): userId
        password (str): password *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
            ),
        )


class LoginRequest22V4(OCIRequest):
    """
    Request to login to OCI.

    password is not required for external authentication login from a trusted host (ACL).
    The following data element is only used in XS data mode and will be ignored in AS data
    mode: signedPassword, ignored in AS data mode unless the password element is not
    present then an error is returned.  Replaced by: `LoginRequest22V5()`.

    Attributes:
        user_id (str): userId
        password (str): password *Optional*
        signed_password (str): signedPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "signed_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
        )


class LoginRequest22V5(OCIRequest):
    """
    Request to login to OCI.

    password is not required for external authentication login from a trusted host (ACL).
    The following data element is only used in XS data mode and will be ignored in AS data
    mode: signedPassword, ignored in AS data mode unless the password element is not
    present then an error is returned.

    Attributes:
        user_id (str): userId
        password (str): password *Optional*
        signed_password (str): signedPassword *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "password",
        "signed_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "signed_password",
                "signedPassword",
                str,
            ),
        )


class LogoutRequest(OCIRequest):
    """
    `LogoutRequest()` is sent when an OCI user logs out or when connection is lost.

    This command can be sent either to the server, or to the client from OCS. Response is
    either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        reason (str): reason *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "reason",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "reason",
                "reason",
                str,
            ),
        )


class LongLivedTokenRevokeRequest(OCIRequest):
    """
    Revoke all previously issued long lived tokens.

    If the userId is not specified, revoke all tokens in the system.  If the userId is
    specified, revoke all tokens issued to the user.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        user_id (str): userId *Optional*
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
            ),
        )


class PasswordModifyRequest(OCIRequest):
    """
    Modify the password for a user/administrator.

    When oldPassword is specified, password rule applies.  If oldPassword in not
    specified, any password rule related to old password does not apply.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        old_password (str): oldPassword *Optional*
        new_password (str): newPassword
    """

    __slots__: List[str] = [
        "user_id",
        "old_password",
        "new_password",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "old_password",
                "oldPassword",
                str,
            ),
            E(
                "new_password",
                "newPassword",
                str,
                is_required=True,
            ),
        )


class PlaceModifyRequest(OCIRequest):
    """
    Request to configure a WebEx room/place to have the primary endpoint of WebEx Teams
    device.

    placeUserId refers to a WebEx room/place.  webExSIPAddress specifies the WebEx SIP
    address of the place.  The format of this parameter is: user@domain.  The user part
    specified in webExSIPAddress will be set to the lineport of the place’s primary
    endpoint.  The endpoint will have a static address with URI set to "sip:user@domain".
    The domain specified in webExSIPAddress will be: - added to the system if it does not
    exist yet.  - assigned to the service provider/enterprise which the place belongs to,
    if it has not been assigned yet.  - assigned to the group which the place belongs to,
    if it has not been assigned yet.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        place_user_id (str): placeUserId
        web_ex_sip_address (str): webExSIPAddress *Optional*
    """

    __slots__: List[str] = [
        "place_user_id",
        "web_ex_sip_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "place_user_id",
                "placeUserId",
                str,
                is_required=True,
            ),
            E(
                "web_ex_sip_address",
                "webExSIPAddress",
                str,
            ),
        )


class PublicClusterGetFullyQualifiedDomainNameRequest(OCIRequest):
    """
    Get the public cluster fully qualified domain name (FQDN).

    The response is either a `PublicClusterGetFullyQualifiedDomainNameResponse()` or an
    `ErrorResponse()`.
    """

    __slots__: List[str] = []

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return ()


class ResellerAddRequest(OCIRequest):
    """
    Add a reseller.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        reseller_name (str): resellerName *Optional*
        reseller_external_id (str): resellerExternalId *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "reseller_name",
        "reseller_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "reseller_name",
                "resellerName",
                str,
            ),
            E(
                "reseller_external_id",
                "resellerExternalId",
                str,
            ),
        )


class ResellerAdminAddRequest(OCIRequest):
    """
    Add a reseller administrator.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        user_id (str): userId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        password (str): password *Optional*
        language (str): language *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "user_id",
        "first_name",
        "last_name",
        "password",
        "language",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "language",
                "language",
                str,
            ),
        )


class ResellerAdminAlternateIdAddRequest(OCIRequest):
    """
    Request to add an alternate Id to a reseller admin.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        alternate_user_id (str): alternateUserId
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "alternate_user_id",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "alternate_user_id",
                "alternateUserId",
                str,
                is_required=True,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class ResellerAdminAlternateIdDeleteRequest(OCIRequest):
    """
    Request to delete an alternate admin user id of a reseller admin.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        alternate_user_id (str): alternateUserId
    """

    __slots__: List[str] = [
        "user_id",
        "alternate_user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "alternate_user_id",
                "alternateUserId",
                str,
                is_required=True,
            ),
        )


class ResellerAdminAlternateIdGetListRequest(OCIRequest):
    """
    Request to get the admin id and the list of alternate admin ids of an admin.

    The response is either `ResellerAdminAlternateIdGetListResponse()` or
    `ErrorResponse()`. The "userId" can be either the admin user Id or an alternate admin
    user Id.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class ResellerAdminAlternateIdModifyRequest(OCIRequest):
    """
    Request to modify an alternate id of a reseller admin.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        alternate_user_id (str): alternateUserId
        new_alternate_user_id (str): newAlternateUserId *Optional*
        description (str): description *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "alternate_user_id",
        "new_alternate_user_id",
        "description",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "alternate_user_id",
                "alternateUserId",
                str,
                is_required=True,
            ),
            E(
                "new_alternate_user_id",
                "newAlternateUserId",
                str,
            ),
            E(
                "description",
                "description",
                str,
            ),
        )


class ResellerAdminDeleteRequest(OCIRequest):
    """
    Delete a reseller administrator.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class ResellerAdminGetListRequest(OCIRequest):
    """
    Get a list of reseller administrators.

    The response is either a `ResellerAdminGetListResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerAdminGetRequest(OCIRequest):
    """
    Get a reseller administrators profile.

    The response is either a `ResellerAdminGetResponse()` or an `ErrorResponse()`.
    Replaced by `ResellerAdminGetRequest22()`

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class ResellerAdminGetRequest22(OCIRequest):
    """
    Get a reseller administrators profile.

    The response is either a `ResellerAdminGetResponse22()` or an `ErrorResponse()`.
    Replaced by: `ResellerAdminGetRequest22V2()`

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class ResellerAdminGetRequest22V2(OCIRequest):
    """
    Get a reseller administrators profile.

    The response is either a `ResellerAdminGetResponse22V2()` or an `ErrorResponse()`.

    Attributes:
        user_id (str): userId
    """

    __slots__: List[str] = [
        "user_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
        )


class ResellerAdminModifyRequest(OCIRequest):
    """
    Modify the profile for a reseller administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        user_id (str): userId
        first_name (str): firstName *Optional*
        last_name (str): lastName *Optional*
        password (str): password *Optional*
        language (str): language *Optional*
        account_disabled (bool): accountDisabled *Optional*
    """

    __slots__: List[str] = [
        "user_id",
        "first_name",
        "last_name",
        "password",
        "language",
        "account_disabled",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "user_id",
                "userId",
                str,
                is_required=True,
            ),
            E(
                "first_name",
                "firstName",
                str,
            ),
            E(
                "last_name",
                "lastName",
                str,
            ),
            E(
                "password",
                "password",
                str,
            ),
            E(
                "language",
                "language",
                str,
            ),
            E(
                "account_disabled",
                "accountDisabled",
                bool,
            ),
        )


class ResellerCallAdmissionControlPoliciesGetRequest(OCIRequest):
    """
    Get a reseller call admission control policies.

    The response is either a `ResellerCallAdmissionControlPoliciesGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerCallAdmissionControlPoliciesModifyRequest(OCIRequest):
    """
    Modify the reseller call admission control policies.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        enable_call_admission_control (bool): enableCallAdmissionControl *Optional*
        max_concurrent_network_sessions (int): maxConcurrentNetworkSessions *Optional*
        max_concurrent_network_sessions_threshold (int):
            maxConcurrentNetworkSessionsThreshold *Optional*
        max_network_calls_per_second (int): maxNetworkCallsPerSecond *Optional*
        max_network_calls_per_second_threshold (int): maxNetworkCallsPerSecondThreshold
            *Optional*
        max_concurrent_external_siprec_sessions (int): maxConcurrentExternalSIPRECSessions
            *Optional*
        max_concurrent_external_siprec_sessions_threshold (int):
            maxConcurrentExternalSIPRECSessionsThreshold *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "enable_call_admission_control",
        "max_concurrent_network_sessions",
        "max_concurrent_network_sessions_threshold",
        "max_network_calls_per_second",
        "max_network_calls_per_second_threshold",
        "max_concurrent_external_siprec_sessions",
        "max_concurrent_external_siprec_sessions_threshold",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "enable_call_admission_control",
                "enableCallAdmissionControl",
                bool,
            ),
            E(
                "max_concurrent_network_sessions",
                "maxConcurrentNetworkSessions",
                int,
            ),
            E(
                "max_concurrent_network_sessions_threshold",
                "maxConcurrentNetworkSessionsThreshold",
                int,
            ),
            E(
                "max_network_calls_per_second",
                "maxNetworkCallsPerSecond",
                int,
            ),
            E(
                "max_network_calls_per_second_threshold",
                "maxNetworkCallsPerSecondThreshold",
                int,
            ),
            E(
                "max_concurrent_external_siprec_sessions",
                "maxConcurrentExternalSIPRECSessions",
                int,
            ),
            E(
                "max_concurrent_external_siprec_sessions_threshold",
                "maxConcurrentExternalSIPRECSessionsThreshold",
                int,
            ),
        )


class ResellerCallCenterGetRequest(OCIRequest):
    """
    Request the reseller level data associated with Call Center.

    The response is either a `ResellerCallCenterGetResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerCallCenterModifyRequest(OCIRequest):
    """
    Modify the reseller level data associated with Call Center.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        default_from_address (str): defaultFromAddress *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "default_from_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "default_from_address",
                "defaultFromAddress",
                str,
            ),
        )


class ResellerCallNotifyGetRequest(OCIRequest):
    """
    Request the reseller level data associated with Call Notify.

    The response is either a `ResellerCallNotifyGetResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerCallNotifyModifyRequest(OCIRequest):
    """
    Modify the reseller level data associated with Call Notify.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        default_from_address (str): defaultFromAddress *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "default_from_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "default_from_address",
                "defaultFromAddress",
                str,
            ),
        )


class ResellerCallPoliciesGetRequest(OCIRequest):
    """
    Request the reseller level data associated with Call Policies.

    The response is either a `ResellerCallPoliciesGetResponse()` or an `ErrorResponse()`.
    Replaced by: `ResellerCallPoliciesGetRequest22()` in AS data mode.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerCallPoliciesGetRequest22(OCIRequest):
    """
    Request the reseller level data associated with Call Policies.

    The response is either a `ResellerCallPoliciesGetResponse22()` or an
    `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerCallPoliciesModifyRequest(OCIRequest):
    """
    Modify the reseller level data associated with Call Policies.

    The following elements are only used in AS data mode:
    forceRedirectingUserIdentityForRedirectedCalls
    applyRedirectingUserIdentityToNetworkLocations

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        force_redirecting_user_identity_for_redirected_calls (bool):
            forceRedirectingUserIdentityForRedirectedCalls *Optional*
        apply_redirecting_user_identity_to_network_locations (bool):
            applyRedirectingUserIdentityToNetworkLocations *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "force_redirecting_user_identity_for_redirected_calls",
        "apply_redirecting_user_identity_to_network_locations",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "force_redirecting_user_identity_for_redirected_calls",
                "forceRedirectingUserIdentityForRedirectedCalls",
                bool,
            ),
            E(
                "apply_redirecting_user_identity_to_network_locations",
                "applyRedirectingUserIdentityToNetworkLocations",
                bool,
            ),
        )


class ResellerCallRecordingGetRequest(OCIRequest):
    """
    Get the Call Recording attribute for a reseller.

    The response is either a `ResellerCallRecordingGetResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerCallRecordingModifyRequest(OCIRequest):
    """
    Modify the Call Recording attribute for a reseller.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        fqdn (str): FQDN *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "fqdn",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "fqdn",
                "FQDN",
                str,
            ),
        )


class ResellerCollaborateGetRequest(OCIRequest):
    """
    Request the reseller level data associated with Collaborate.

    The response is either a `ResellerCollaborateGetResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerCollaborateModifyRequest(OCIRequest):
    """
    Modify the reseller level data associated with Collaborate.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        collaborate_from_address (str): collaborateFromAddress *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "collaborate_from_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "collaborate_from_address",
                "collaborateFromAddress",
                str,
            ),
        )


class ResellerDeleteRequest(OCIRequest):
    """
    Delete a reseller.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId *Optional*
        reseller_external_id (str): resellerExternalId *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "reseller_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "reseller_external_id",
                "resellerExternalId",
                str,
            ),
        )


class ResellerDeviceActivationPolicyGetRequest(OCIRequest):
    """
    Request the Device Activation policy of a reseller.

    The response is either a `ResellerDeviceActivationPolicyGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerDeviceActivationPolicyModifyRequest(OCIRequest):
    """
    Modify the Device Activation policy of a reseller.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        use_reseller_settings (bool): useResellerSettings *Optional*
        allow_activation_code_request_by_user (bool): allowActivationCodeRequestByUser
            *Optional*
        send_activation_code_in_email (bool): sendActivationCodeInEmail *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "use_reseller_settings",
        "allow_activation_code_request_by_user",
        "send_activation_code_in_email",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "use_reseller_settings",
                "useResellerSettings",
                bool,
            ),
            E(
                "allow_activation_code_request_by_user",
                "allowActivationCodeRequestByUser",
                bool,
            ),
            E(
                "send_activation_code_in_email",
                "sendActivationCodeInEmail",
                bool,
            ),
        )


class ResellerEmergencyCallNotificationGetRequest(OCIRequest):
    """
    Request the reseller level data associated with Emergency Call Notification.

    The response is either a `ResellerEmergencyCallNotificationGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerEmergencyCallNotificationModifyRequest(OCIRequest):
    """
    Modify the reseller level data associated with Emergency Call Notification.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        default_from_address (str): defaultFromAddress *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "default_from_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "default_from_address",
                "defaultFromAddress",
                str,
            ),
        )


class ResellerEmergencyZonesGetRequest(OCIRequest):
    """
    Request the reseller level data associated with Emergency Zones.

    The response is either a `ResellerEmergencyZonesGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerEmergencyZonesModifyRequest(OCIRequest):
    """
    Modify the reseller level data associated with Emergency Zones.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        default_from_address (str): defaultFromAddress *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "default_from_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "default_from_address",
                "defaultFromAddress",
                str,
            ),
        )


class ResellerGetRequest(OCIRequest):
    """
    Get the profile for a reseller.

    The response is either `ResellerGetResponse()` or `ErrorResponse()`. Replaced by:
    `ResellerGetRequest22()`

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerGetRequest22(OCIRequest):
    """
    Get the profile for a reseller.

    The response is either `ResellerGetResponse22()` or `ErrorResponse()`. Replaced by:
    `ResellerGetRequest22V2()`

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerGetRequest22V2(OCIRequest):
    """
    Get the profile for a reseller.

    The response is either `ResellerGetResponse22V2()` or `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId *Optional*
        reseller_external_id (str): resellerExternalId *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "reseller_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "reseller_external_id",
                "resellerExternalId",
                str,
            ),
        )


class ResellerIntegratedIMPGetRequest(OCIRequest):
    """
    Get the Integrated IMP service attributes for the reseller.

    The response is either `ResellerIntegratedIMPGetResponse()` or `ErrorResponse()`.
    Replaced by: `ResellerIntegratedIMPGetRequest22()` in AS data mode

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerIntegratedIMPGetRequest22(OCIRequest):
    """
    Get the Integrated IMP service attributes for the reseller.

    The response is either `ResellerIntegratedIMPGetResponse22()` or `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerIntegratedIMPModifyRequest(OCIRequest):
    """
    Modify the Integrated IMP service attributes for the reseller.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        use_system_service_domain (bool): useSystemServiceDomain *Optional*
        service_domain (str): serviceDomain *Optional*
        service_port (int): servicePort *Optional*
        use_system_messaging_server (bool): useSystemMessagingServer *Optional*
        provisioning_url (str): provisioningUrl *Optional*
        provisioning_user_id (str): provisioningUserId *Optional*
        provisioning_password (str): provisioningPassword *Optional*
        bosh_url (str): boshURL *Optional*
        default_imp_id_type (str): defaultImpIdType *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "use_system_service_domain",
        "service_domain",
        "service_port",
        "use_system_messaging_server",
        "provisioning_url",
        "provisioning_user_id",
        "provisioning_password",
        "bosh_url",
        "default_imp_id_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "use_system_service_domain",
                "useSystemServiceDomain",
                bool,
            ),
            E(
                "service_domain",
                "serviceDomain",
                str,
            ),
            E(
                "service_port",
                "servicePort",
                int,
            ),
            E(
                "use_system_messaging_server",
                "useSystemMessagingServer",
                bool,
            ),
            E(
                "provisioning_url",
                "provisioningUrl",
                str,
            ),
            E(
                "provisioning_user_id",
                "provisioningUserId",
                str,
            ),
            E(
                "provisioning_password",
                "provisioningPassword",
                str,
            ),
            E(
                "bosh_url",
                "boshURL",
                str,
            ),
            E(
                "default_imp_id_type",
                "defaultImpIdType",
                str,
            ),
        )


class ResellerMailParametersGetRequest(OCIRequest):
    """
    Request the reseller Mail parameters.

    The response is either a `ResellerMailParametersGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerMailParametersModifyRequest(OCIRequest):
    """
    Request to modify the reseller Mail parameters.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        default_from_address (str): defaultFromAddress *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "default_from_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "default_from_address",
                "defaultFromAddress",
                str,
            ),
        )


class ResellerMeetMeConferencingGetRequest(OCIRequest):
    """
    Request the reseller level data associated with Meet-Me Conferencing functions.

    The response is either a `ResellerMeetMeConferencingGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerMeetMeConferencingGetRequest22(OCIRequest):
    """
    Request the reseller level data associated with Meet-Me Conferencing functions.

    The response is either a `ResellerMeetMeConferencingGetResponse22()` or an
    `ErrorResponse()`. The following data elements are only returned for System and
    Provisioning Administrators: maxAllocatedPorts.  The following data elements are only
    returned for System and Provisioning Administrators and AS Mode Only:
    disableUnlimitedMeetMePorts, enableMaxAllocatedPorts.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerMeetMeConferencingModifyRequest(OCIRequest):
    """
    Modify the reseller level data associated with Meet-Me Conferencing functions.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`. The following
    data elements are only modified for System and Provisioning Administrators:
    maxAllocatedPorts.  The following data elements are only modified for System and
    Provisioning Administrators and AS Mode only: disableUnlimitedMeetMePorts,
    enableMaxAllocatedPorts.

    Attributes:
        reseller_id (str): resellerId
        conference_from_address (str): conferenceFromAddress *Optional*
        max_allocated_ports (int): maxAllocatedPorts *Optional*
        disable_unlimited_meet_me_ports (bool): disableUnlimitedMeetMePorts *Optional*
        enable_max_allocated_ports (bool): enableMaxAllocatedPorts *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "conference_from_address",
        "max_allocated_ports",
        "disable_unlimited_meet_me_ports",
        "enable_max_allocated_ports",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "conference_from_address",
                "conferenceFromAddress",
                str,
            ),
            E(
                "max_allocated_ports",
                "maxAllocatedPorts",
                int,
            ),
            E(
                "disable_unlimited_meet_me_ports",
                "disableUnlimitedMeetMePorts",
                bool,
            ),
            E(
                "enable_max_allocated_ports",
                "enableMaxAllocatedPorts",
                bool,
            ),
        )


class ResellerModifyRequest(OCIRequest):
    """
    Modify the reseller profile.

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId *Optional*
        reseller_external_id (str): resellerExternalId *Optional*
        reseller_name (str): resellerName *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "reseller_external_id",
        "reseller_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
            ),
            E(
                "reseller_external_id",
                "resellerExternalId",
                str,
            ),
            E(
                "reseller_name",
                "resellerName",
                str,
            ),
        )


class ResellerNetworkClassOfServiceGetAssignedListRequest(OCIRequest):
    """
    Get a list of Network Classes of Service assigned to a reseller.

    The response is either a `ResellerNetworkClassOfServiceGetAssignedListResponse()` or
    an `ErorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerNetworkClassOfServiceModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Network Classes of Service of a reseller.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        network_class_of_service (str): networkClassOfService *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "network_class_of_service",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "network_class_of_service",
                "networkClassOfService",
                str,
            ),
        )


class ResellerResourcePriorityGetRequest(OCIRequest):
    """
    Get the Resource Priority service attributes for the reseller.

    The response is either `ResellerResourcePriorityGetResponse()` or `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerResourcePriorityModifyRequest(OCIRequest):
    """
    Modify the Resource Priority service attributes for the reseller.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        use_system_settings (bool): useSystemSettings *Optional*
        send_resource_priority_to_network (bool): sendResourcePriorityToNetwork *Optional*
        resource_priority (str): resourcePriority *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "use_system_settings",
        "send_resource_priority_to_network",
        "resource_priority",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "use_system_settings",
                "useSystemSettings",
                bool,
            ),
            E(
                "send_resource_priority_to_network",
                "sendResourcePriorityToNetwork",
                bool,
            ),
            E(
                "resource_priority",
                "resourcePriority",
                str,
            ),
        )


class ResellerServiceAuthorizationGetRequest(OCIRequest):
    """
    Get the reseller service authorization The response is either
    `ResellerServiceAuthorizationGetResponse()` or `ErrorResponse()`.


    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerStirShakenGetRequest(OCIRequest):
    """
    Get Reseller Stir Shaken service settings.

    The response is either `ResellerStirShakenGetResponse()` or `ErrorResponse()`.
    Replaced by `ResellerStirShakenGetRequest23()`

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerStirShakenGetRequest23(OCIRequest):
    """
    Get Reseller Stir Shaken service settings.

    The response is either `ResellerStirShakenGetResponse23()` or `ErrorResponse()`.
    Replaced by `ResellerStirShakenGetRequest23V2()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerStirShakenGetRequest23V2(OCIRequest):
    """
    Get Reseller Stir Shaken service settings.

    The response is either `ResellerStirShakenGetResponse23V2()` or `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerStirShakenModifyRequest(OCIRequest):
    """
    Modify reseller Stir Shaken service settings.


    Attributes:
        reseller_id (str): resellerId
        use_parent_level_settings (bool): useParentLevelSettings *Optional*
        signing_policy (str): signingPolicy *Optional*
        tagging_policy (str): taggingPolicy *Optional*
        sign_emergency_calls (bool): signEmergencyCalls *Optional*
        tag_emergency_calls (bool): tagEmergencyCalls *Optional*
        signing_service_url (str): signingServiceURL *Optional*
        tag_from_or_pai (str): tagFromOrPAI *Optional*
        verstat_tag (str): verstatTag *Optional*
        use_os_value_for_orig_id (bool): useOSValueForOrigId *Optional*
        orig_uuid (str): origUUID *Optional*
        attestation_level (str): attestationLevel *Optional*
        enable_verification (bool): enableVerification *Optional*
        verification_service_url (str): verificationServiceURL *Optional*
        verification_error_handling (str): verificationErrorHandling *Optional*
        proxy_verstat_to_cnam_subscribe (bool): proxyVerstatToCNAMSubscribe *Optional*
        use_unknown_headers_from_cnam_notify (bool): useUnknownHeadersFromCNAMNotify
            *Optional*
        enable_signing_for_unscreened_trunk_group_originations (bool):
            enableSigningForUnscreenedTrunkGroupOriginations *Optional*
        enable_tagging_for_unscreened_trunk_group_originations (bool):
            enableTaggingForUnscreenedTrunkGroupOriginations *Optional*
        unscreened_trunk_group_origination_attestation_level (str):
            unscreenedTrunkGroupOriginationAttestationLevel *Optional*
        verify_gets_calls (bool): verifyGETSCalls *Optional*
        include_tagged_headers_to_access_side (bool): includeTaggedHeadersToAccessSide
            *Optional*
        proxy_identity_header_to_access_side (bool): proxyIdentityHeaderToAccessSide
            *Optional*
        check_directory_numbers_for_attestation (bool):
            checkDirectoryNumbersForAttestation *Optional*
        match_unassigned_numbers_only (bool): matchUnassignedNumbersOnly *Optional*
        enable_tagging_for_redirected_calls (bool): enableTaggingForRedirectedCalls
            *Optional*
        prefer_ingress_tagging (bool): preferIngressTagging *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "use_parent_level_settings",
        "signing_policy",
        "tagging_policy",
        "sign_emergency_calls",
        "tag_emergency_calls",
        "signing_service_url",
        "tag_from_or_pai",
        "verstat_tag",
        "use_os_value_for_orig_id",
        "orig_uuid",
        "attestation_level",
        "enable_verification",
        "verification_service_url",
        "verification_error_handling",
        "proxy_verstat_to_cnam_subscribe",
        "use_unknown_headers_from_cnam_notify",
        "enable_signing_for_unscreened_trunk_group_originations",
        "enable_tagging_for_unscreened_trunk_group_originations",
        "unscreened_trunk_group_origination_attestation_level",
        "verify_gets_calls",
        "include_tagged_headers_to_access_side",
        "proxy_identity_header_to_access_side",
        "check_directory_numbers_for_attestation",
        "match_unassigned_numbers_only",
        "enable_tagging_for_redirected_calls",
        "prefer_ingress_tagging",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "use_parent_level_settings",
                "useParentLevelSettings",
                bool,
            ),
            E(
                "signing_policy",
                "signingPolicy",
                str,
            ),
            E(
                "tagging_policy",
                "taggingPolicy",
                str,
            ),
            E(
                "sign_emergency_calls",
                "signEmergencyCalls",
                bool,
            ),
            E(
                "tag_emergency_calls",
                "tagEmergencyCalls",
                bool,
            ),
            E(
                "signing_service_url",
                "signingServiceURL",
                str,
            ),
            E(
                "tag_from_or_pai",
                "tagFromOrPAI",
                str,
            ),
            E(
                "verstat_tag",
                "verstatTag",
                str,
            ),
            E(
                "use_os_value_for_orig_id",
                "useOSValueForOrigId",
                bool,
            ),
            E(
                "orig_uuid",
                "origUUID",
                str,
            ),
            E(
                "attestation_level",
                "attestationLevel",
                str,
            ),
            E(
                "enable_verification",
                "enableVerification",
                bool,
            ),
            E(
                "verification_service_url",
                "verificationServiceURL",
                str,
            ),
            E(
                "verification_error_handling",
                "verificationErrorHandling",
                str,
            ),
            E(
                "proxy_verstat_to_cnam_subscribe",
                "proxyVerstatToCNAMSubscribe",
                bool,
            ),
            E(
                "use_unknown_headers_from_cnam_notify",
                "useUnknownHeadersFromCNAMNotify",
                bool,
            ),
            E(
                "enable_signing_for_unscreened_trunk_group_originations",
                "enableSigningForUnscreenedTrunkGroupOriginations",
                bool,
            ),
            E(
                "enable_tagging_for_unscreened_trunk_group_originations",
                "enableTaggingForUnscreenedTrunkGroupOriginations",
                bool,
            ),
            E(
                "unscreened_trunk_group_origination_attestation_level",
                "unscreenedTrunkGroupOriginationAttestationLevel",
                str,
            ),
            E(
                "verify_gets_calls",
                "verifyGETSCalls",
                bool,
            ),
            E(
                "include_tagged_headers_to_access_side",
                "includeTaggedHeadersToAccessSide",
                bool,
            ),
            E(
                "proxy_identity_header_to_access_side",
                "proxyIdentityHeaderToAccessSide",
                bool,
            ),
            E(
                "check_directory_numbers_for_attestation",
                "checkDirectoryNumbersForAttestation",
                bool,
            ),
            E(
                "match_unassigned_numbers_only",
                "matchUnassignedNumbersOnly",
                bool,
            ),
            E(
                "enable_tagging_for_redirected_calls",
                "enableTaggingForRedirectedCalls",
                bool,
            ),
            E(
                "prefer_ingress_tagging",
                "preferIngressTagging",
                bool,
            ),
        )


class ResellerVoiceMessagingGroupGetRequest(OCIRequest):
    """
    Request the reseller level data associated with Voice Messaging.

    The response is either a `ResellerVoiceMessagingGroupGetResponse()` or an
    `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
    """

    __slots__: List[str] = [
        "reseller_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
        )


class ResellerVoiceMessagingGroupModifyRequest(OCIRequest):
    """
    Modify the reseller level data associated with Voice Messaging.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        delivery_from_address (str): deliveryFromAddress *Optional*
        notification_from_address (str): notificationFromAddress *Optional*
        voice_portal_lockout_from_address (str): voicePortalLockoutFromAddress *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "delivery_from_address",
        "notification_from_address",
        "voice_portal_lockout_from_address",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "delivery_from_address",
                "deliveryFromAddress",
                str,
            ),
            E(
                "notification_from_address",
                "notificationFromAddress",
                str,
            ),
            E(
                "voice_portal_lockout_from_address",
                "voicePortalLockoutFromAddress",
                str,
            ),
        )


class ResellerXsiPolicyProfileGetAssignedListRequest(OCIRequest):
    """
    Get a list of Xsi policy profile assigned.

    The response is either a `XsiPolicyProfileGetAssignedListResponse()` or an
    `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        level (str): level *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "level",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "level",
                "level",
                str,
            ),
        )


class ResellerXsiPolicyProfileModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Xsi policy profile for a reseller.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        reseller_id (str): resellerId
        sp_default_xsi_policy_profile (str): spDefaultXsiPolicyProfile *Optional*
        group_default_xsi_policy_profile (str): groupDefaultXsiPolicyProfile *Optional*
        user_default_xsi_policy_profile (str): userDefaultXsiPolicyProfile *Optional*
    """

    __slots__: List[str] = [
        "reseller_id",
        "sp_default_xsi_policy_profile",
        "group_default_xsi_policy_profile",
        "user_default_xsi_policy_profile",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "reseller_id",
                "resellerId",
                str,
                is_required=True,
            ),
            E(
                "sp_default_xsi_policy_profile",
                "spDefaultXsiPolicyProfile",
                str,
            ),
            E(
                "group_default_xsi_policy_profile",
                "groupDefaultXsiPolicyProfile",
                str,
            ),
            E(
                "user_default_xsi_policy_profile",
                "userDefaultXsiPolicyProfile",
                str,
            ),
        )


class ServiceProviderAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a service provider access device.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        tag_name (str): tagName
        tag_value (str): tagValue *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "tag_name",
        "tag_value",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
            ),
            E(
                "tag_value",
                "tagValue",
                str,
            ),
        )


class ServiceProviderAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a service provider access device.

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        tag_name (List[str]): tagName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "tag_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
                is_array=True,
            ),
        )


class ServiceProviderAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device profile basis.

    The response is either `ServiceProviderAccessDeviceCustomTagGetListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a service provider access device.

    The tagValueToEncrypt element can only be used by a system administrator.  The
    following elements are only used in XS data mode and ignored in AS data mode:
    tagValueToEncrypt

    The response is either a `SuccessResponse()` or an `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        tag_name (str): tagName
        tag_value (str): tagValue *Optional*
        tag_value_to_encrypt (str): tagValueToEncrypt *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "tag_name",
        "tag_value",
        "tag_value_to_encrypt",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "tag_name",
                "tagName",
                str,
                is_required=True,
            ),
            E(
                "tag_value",
                "tagValue",
                str,
            ),
            E(
                "tag_value_to_encrypt",
                "tagValueToEncrypt",
                str,
            ),
        )


class ServiceProviderAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified service provider access device.

    The following elements are only used in AS data mode and ignored in XS data mode:
    deviceExternalId

    The response is either `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class ServiceProviderAccessDeviceDeviceActivationGetRequest(OCIRequest):
    """
    Requests the activation information for a device configured at the Service Provider
    level.

    Returns a `ServiceProviderAccessDeviceDeviceActivationGetResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceDeviceActivationModifyRequest(OCIRequest):
    """
    Activates or deactivates a device configured at the Service Provider level.

    It is only possible for this request to activate a device which is deactivated.
    Trying to activate a device in the activating state will result in an error response
    since only the DAS is allowed to execute this operation.  Returns a
    `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        activate_device (bool): activateDevice
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "activate_device",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "activate_device",
                "activateDevice",
                bool,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either `ServiceProviderAccessDeviceFileGetListResponse()` or
    `ErrorResponse()`.

    Replaced By: `ServiceProviderAccessDeviceFileGetListRequest14sp8()`

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either `ServiceProviderAccessDeviceFileGetListResponse14sp8()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either `ServiceProviderAccessDeviceFileGetResponse()` or
    `ErrorResponse()`.

    Replaced By: `ServiceProviderAccessDeviceFileGetRequest14sp8()`

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        file_type (str): fileType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "file_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "file_type",
                "fileType",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either `ServiceProviderAccessDeviceFileGetResponse14sp8()` or
    `ErrorResponse()`. Replaced by: `ServiceProviderAccessDeviceFileGetRequest16sp1()`

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        file_format (str): fileFormat
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "file_format",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "file_format",
                "fileFormat",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either `ServiceProviderAccessDeviceFileGetResponse16sp1()` or
    `ErrorResponse()`. Replaced by: `ServiceProviderAccessDeviceFileGetRequest20()`

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        file_format (str): fileFormat
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "file_format",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "file_format",
                "fileFormat",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either `ServiceProviderAccessDeviceFileGetResponse20()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        file_format (str): fileFormat
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "file_format",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "file_format",
                "fileFormat",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGenerateActivationCodeRequest(OCIRequest):
    """
    Requests a new activation code for a device configured at the Service Provider level.

    Returns a `SuccessResponse()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetAvailableCustomTagListRequest(OCIRequest):
    """
    Get the list of all available custom tags managed by the Device Management System, on
    a per-device profile basis.

    The response is either
    `ServiceProviderAccessDeviceGetAvailableCustomTagListResponse()` or `ErrorResponse()`.
    The following elements are used in AS mode and ignored in XS data mode: tagSetName

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        tag_set_name (str): tagSetName *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "tag_set_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "tag_set_name",
                "tagSetName",
                str,
            ),
        )


class ServiceProviderAccessDeviceGetEnhancedConfigurationTypeListRequest(OCIRequest):
    """
    Requests the list of configurable device types of devices that have already been added
    to the service provider.

    The response is either
    `ServiceProviderAccessDeviceGetEnhancedConfigurationTypeListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
    """

    __slots__: List[str] = [
        "service_provider_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetEnhancedConfigurationTypeRequest(OCIRequest):
    """
    Requests the details of a specified configurable device type for a service provider.

    The response is either
    `ServiceProviderAccessDeviceGetEnhancedConfigurationTypeResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_type (str): deviceType
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_type",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_type",
                "deviceType",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetLinkedLeafDeviceListRequest(OCIRequest):
    """
    Requests the list of linked leaf devices for the service provider level tree device
    passed in the request.

    A tree device is a device associated with a device type that has the option
    supportLinks set to "Support Links from Devices". Many leaf devices can be linked to
    it.  A leaf device is a device associated with a device type that has the option
    supportLinks set to "Support Link to Device". It can be linked to only one tree
    device.  The list includes devices created at the system, service provider, and group
    levels.

    The response is either `ServiceProviderAccessDeviceGetLinkedLeafDeviceListResponse()`
    or `ErrorResponse()`. Replaced by:
    `ServiceProviderAccessDeviceGetLinkedLeafDeviceListRequest22()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetLinkedLeafDeviceListRequest22(OCIRequest):
    """
    Requests the list of linked leaf devices for the service provider level tree device
    passed in the request.

    A tree device is a device associated with a device type that has the option
    supportLinks set to "Support Links from Devices". Many leaf devices can be linked to
    it.  A leaf device is a device associated with a device type that has the option
    supportLinks set to "Support Link to Device" or "Support Link to Device and User". It
    can be linked to only one tree device.  The list includes devices created at the
    system, service provider, and group levels.  If the leafDeviceCategory is not set in
    the request, then linked leaf devices of all categories are requested, otherwise only
    the linked leaf devices of the specified category are requested.  The category values
    are: "Handset", "Base Station", "All".

    The response is either
    `ServiceProviderAccessDeviceGetLinkedLeafDeviceListResponse22()` or `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
        leaf_device_category (str): leafDeviceCategory *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "leaf_device_category",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
            E(
                "leaf_device_category",
                "leafDeviceCategory",
                str,
            ),
        )


class ServiceProviderAccessDeviceGetLinkedTreeDeviceRequest(OCIRequest):
    """
    Requests the tree device linked with the service provider level leaf device passed in
    the request.

    A tree device is a device associated with a device type that has the option
    supportLinks set to "Support Links from Devices". Many leaf devices can be linked to
    it.  A leaf device is a device associated with a device type that has the option
    supportLinks set to "Support Link to Device" or "Support Link to Device and User". It
    can be linked to only one tree device.

    The response is either `ServiceProviderAccessDeviceGetLinkedTreeDeviceResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetNativeTagsWithLogicListRequest(OCIRequest):
    """
    Get the list of all native tags with logic managed by the Device Management System, on
    a per-device profile basis.

    The response is either
    `ServiceProviderAccessDeviceGetNativeTagsWithLogicListResponse()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetRequest14(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either `ServiceProviderAccessDeviceGetResponse14()` or
    `ErrorResponse()`.

    Replaced By: `ServiceProviderAccessDeviceGetRequest14sp3()`

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either `ServiceProviderAccessDeviceGetResponse14sp3()` or
    `ErrorResponse()`.

    Replaced By: `ServiceProviderAccessDeviceGetRequest14sp6()`

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either `ServiceProviderAccessDeviceGetResponse14sp6()` or
    `ErrorResponse()`. Replaced by: `ServiceProviderAccessDeviceGetRequest16()`

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either `ServiceProviderAccessDeviceGetResponse16()` or
    `ErrorResponse()`. Replaced by: `ServiceProviderAccessDeviceGetRequest19()`

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either `ServiceProviderAccessDeviceGetResponse18sp1()` or
    `ErrorResponse()`. Replaced by: `ServiceProviderAccessDeviceGetRequest22()`.

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetRequest22(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either `ServiceProviderAccessDeviceGetResponse22()` or
    `ErrorResponse()`. Replaced by: `ServiceProviderAccessDeviceGetRequest24()`

    Attributes:
        service_provider_id (str): serviceProviderId
        device_name (str): deviceName
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
                is_required=True,
            ),
            E(
                "device_name",
                "deviceName",
                str,
                is_required=True,
            ),
        )


class ServiceProviderAccessDeviceGetRequest22V2(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The following elements are only used in AS data mode and ignored in XS data mode:
    deviceExternalId

    The response is either `ServiceProviderAccessDeviceGetResponse22V2()` or
    `ErrorResponse()`.

    Replaced By: `ServiceProviderAccessDeviceGetRequest24()`

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class ServiceProviderAccessDeviceGetRequest22V3(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either `ServiceProviderAccessDeviceGetResponse22V3()` or
    `ErrorResponse()`. The following elements are only used in AS data mode and ignored in
    XS data mode: deviceExternalId Replaced by:
    `ServiceProviderAccessDeviceGetRequest24()`

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class ServiceProviderAccessDeviceGetRequest22V4(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The following elements are only used in AS data mode and ignored in XS data mode:
    deviceExternalId

    The response is either `ServiceProviderAccessDeviceGetResponse22V4()` or
    `ErrorResponse()`.

    Replaced By: `ServiceProviderAccessDeviceGetRequest24V2()`

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class ServiceProviderAccessDeviceGetRequest22V5(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The following elements are only used in AS data mode and ignored in XS data mode:
    deviceExternalId

    The response is either `ServiceProviderAccessDeviceGetResponse22V5()` or
    `ErrorResponse()`.

    Replaced By: `ServiceProviderAccessDeviceGetRequest24V3()`

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class ServiceProviderAccessDeviceGetRequest24(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The following elements are only used in AS data mode and ignored in XS data mode:
    deviceExternalId

    The response is either `ServiceProviderAccessDeviceGetResponse24()` or
    `ErrorResponse()`. Replaced by: `ServiceProviderAccessDeviceGetRequest24V2()` in AS
    data mode.

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProviderId",
                str,
            ),
            E(
                "device_name",
                "deviceName",
                str,
            ),
            E(
                "device_external_id",
                "deviceExternalId",
                str,
            ),
        )


class ServiceProviderAccessDeviceGetRequest24V2(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The following elements are only used in AS data mode and ignored in XS data mode:
    deviceExternalId

    The response is either `ServiceProviderAccessDeviceGetResponse24V2()` or
    `ErrorResponse()`.

    Attributes:
        service_provider_id (str): serviceProviderId *Optional*
        device_name (str): deviceName *Optional*
        device_external_id (str): deviceExternalId *Optional*
    """

    __slots__: List[str] = [
        "service_provider_id",
        "device_name",
        "device_external_id",
    ]

    @classmethod
    def _elements(cls) -> Tuple[E, ...]:
        return (
            E(
                "service_provider_id",
                "serviceProvid