"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsQueueAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * (experimental) The action to write the data from an MQTT message to an Amazon SQS queue.
 *
 * @experimental
 */
class SqsQueueAction {
    /**
     * @param queue The Amazon SQS queue to which to write data.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(queue, props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_SqsQueueActionProps(props);
        this.queue = queue;
        this.role = props.role;
        this.useBase64 = props.useBase64;
    }
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['sqs:SendMessage'],
            resources: [this.queue.queueArn],
        }));
        return {
            configuration: {
                sqs: {
                    queueUrl: this.queue.queueUrl,
                    useBase64: this.useBase64,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.SqsQueueAction = SqsQueueAction;
_a = JSII_RTTI_SYMBOL_1;
SqsQueueAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.SqsQueueAction", version: "2.4.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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