/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import javax.swing.tree.DefaultMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLDefaultMutableTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(XMLDefaultMutableTreeNode.class);
    private transient Node xmlNode;

    @Deprecated
    public XMLDefaultMutableTreeNode() {
        log.warn("Constructor only intended for use in testing");
    }

    public XMLDefaultMutableTreeNode(Node root) throws SAXException {
        super(root.getNodeName());
        this.initAttributeNode(root, this);
        this.initRoot(root);
    }

    public XMLDefaultMutableTreeNode(String name, Node xmlNode) {
        super(name);
        this.xmlNode = xmlNode;
    }

    private void initRoot(Node xmlRoot) throws SAXException {
        NodeList childNodes = xmlRoot.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            this.initNode(childNode, this);
        }
    }

    private void initNode(Node node, XMLDefaultMutableTreeNode mTreeNode) throws SAXException {
        switch (node.getNodeType()) {
            case 1: {
                this.initElementNode(node, mTreeNode);
                break;
            }
            case 3: {
                this.initTextNode((Text)node, mTreeNode);
                break;
            }
            case 4: {
                this.initCDATASectionNode((CDATASection)node, mTreeNode);
                break;
            }
            case 8: {
                this.initCommentNode((Comment)node, mTreeNode);
                break;
            }
        }
    }

    private void initElementNode(Node node, DefaultMutableTreeNode mTreeNode) throws SAXException {
        String nodeName = node.getNodeName();
        NodeList childNodes = node.getChildNodes();
        XMLDefaultMutableTreeNode childTreeNode = new XMLDefaultMutableTreeNode(nodeName, node);
        mTreeNode.add(childTreeNode);
        this.initAttributeNode(node, childTreeNode);
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            this.initNode(childNode, childTreeNode);
        }
    }

    private void initAttributeNode(Node node, DefaultMutableTreeNode mTreeNode) throws SAXException {
        NamedNodeMap nm = node.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            Attr nmNode = (Attr)nm.item(i);
            String value = nmNode.getName() + " = \"" + nmNode.getValue() + "\"";
            XMLDefaultMutableTreeNode attributeNode = new XMLDefaultMutableTreeNode(value, nmNode);
            mTreeNode.add(attributeNode);
        }
    }

    private void initCommentNode(Comment node, DefaultMutableTreeNode mTreeNode) throws SAXException {
        String data = node.getData();
        if (data != null && data.length() > 0) {
            String value = "<!--" + node.getData() + "-->";
            XMLDefaultMutableTreeNode commentNode = new XMLDefaultMutableTreeNode(value, node);
            mTreeNode.add(commentNode);
        }
    }

    private void initCDATASectionNode(CDATASection node, DefaultMutableTreeNode mTreeNode) throws SAXException {
        String data = node.getData();
        if (data != null && data.length() > 0) {
            String value = "<!-[CDATA" + node.getData() + "]]>";
            XMLDefaultMutableTreeNode commentNode = new XMLDefaultMutableTreeNode(value, node);
            mTreeNode.add(commentNode);
        }
    }

    private void initTextNode(Text node, DefaultMutableTreeNode mTreeNode) throws SAXException {
        String text = node.getNodeValue().trim();
        if (text != null && text.length() > 0) {
            XMLDefaultMutableTreeNode textNode = new XMLDefaultMutableTreeNode(text, node);
            mTreeNode.add(textNode);
        }
    }

    public Node getXMLNode() {
        return this.xmlNode;
    }
}

