/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.canvas.awt;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import jetbrains.datalore.base.async.Async;
import jetbrains.datalore.base.async.Asyncs;
import jetbrains.datalore.base.event.MouseEvent;
import jetbrains.datalore.base.event.MouseEventSpec;
import jetbrains.datalore.base.geometry.Vector;
import jetbrains.datalore.base.observable.event.EventHandler;
import jetbrains.datalore.base.observable.event.EventHandlerExtKt;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.vis.canvas.AnimationProvider;
import jetbrains.datalore.vis.canvas.Canvas;
import jetbrains.datalore.vis.canvas.CanvasControl;
import jetbrains.datalore.vis.canvas.EventPeer;
import jetbrains.datalore.vis.canvas.awt.AwtAnimationTimerPeer;
import jetbrains.datalore.vis.canvas.awt.AwtCanvas;
import jetbrains.datalore.vis.canvas.awt.CanvasComponent;
import jetbrains.datalore.vis.canvas.awt.CanvasContainerPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u0012J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u001c\u0010.\u001a\u00020\u0016\"\u0004\b\u0000\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/01H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00062"}, d2={"Ljetbrains/datalore/vis/canvas/awt/AwtCanvasControl;", "Ljetbrains/datalore/vis/canvas/CanvasControl;", "size", "Ljetbrains/datalore/base/geometry/Vector;", "myEventPeer", "Ljetbrains/datalore/vis/canvas/EventPeer;", "Ljetbrains/datalore/base/event/MouseEventSpec;", "Ljetbrains/datalore/base/event/MouseEvent;", "myAnimationTimerPeer", "Ljetbrains/datalore/vis/canvas/awt/AwtAnimationTimerPeer;", "myPixelRatio", "", "(Ljetbrains/datalore/base/geometry/Vector;Ljetbrains/datalore/vis/canvas/EventPeer;Ljetbrains/datalore/vis/canvas/awt/AwtAnimationTimerPeer;D)V", "myComponent", "Ljetbrains/datalore/vis/canvas/awt/CanvasContainerPanel;", "myMappedCanvases", "Ljava/util/HashMap;", "Ljetbrains/datalore/vis/canvas/Canvas;", "Ljavax/swing/JComponent;", "getSize", "()Ljetbrains/datalore/base/geometry/Vector;", "addChild", "", "canvas", "index", "", "addEventHandler", "Ljetbrains/datalore/base/registration/Registration;", "eventSpec", "eventHandler", "Ljetbrains/datalore/base/observable/event/EventHandler;", "component", "createAnimationTimer", "Ljetbrains/datalore/vis/canvas/AnimationProvider$AnimationTimer;", "Ljetbrains/datalore/vis/canvas/AnimationProvider$AnimationEventHandler;", "createCanvas", "createSnapshot", "Ljetbrains/datalore/base/async/Async;", "Ljetbrains/datalore/vis/canvas/Canvas$Snapshot;", "bytes", "", "dataUrl", "", "imagePngBase64ToImage", "Ljava/awt/Image;", "removeChild", "schedule", "T", "f", "Lkotlin/Function0;", "vis-canvas"})
public final class AwtCanvasControl
implements CanvasControl {
    @NotNull
    private final Vector size;
    @NotNull
    private final EventPeer<MouseEventSpec, MouseEvent> myEventPeer;
    @NotNull
    private final AwtAnimationTimerPeer myAnimationTimerPeer;
    private final double myPixelRatio;
    @NotNull
    private final CanvasContainerPanel myComponent;
    @NotNull
    private final HashMap<Canvas, JComponent> myMappedCanvases;

    public AwtCanvasControl(@NotNull Vector size2, @NotNull EventPeer<MouseEventSpec, MouseEvent> myEventPeer, @NotNull AwtAnimationTimerPeer myAnimationTimerPeer, double myPixelRatio) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        Intrinsics.checkNotNullParameter(myEventPeer, (String)"myEventPeer");
        Intrinsics.checkNotNullParameter((Object)myAnimationTimerPeer, (String)"myAnimationTimerPeer");
        this.size = size2;
        this.myEventPeer = myEventPeer;
        this.myAnimationTimerPeer = myAnimationTimerPeer;
        this.myPixelRatio = myPixelRatio;
        this.myComponent = new CanvasContainerPanel(this.getSize());
        this.myMappedCanvases = new HashMap();
    }

    public /* synthetic */ AwtCanvasControl(Vector vector, EventPeer eventPeer, AwtAnimationTimerPeer awtAnimationTimerPeer, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d = 1.0;
        }
        this(vector, eventPeer, awtAnimationTimerPeer, d);
    }

    @Override
    @NotNull
    public Vector getSize() {
        return this.size;
    }

    @NotNull
    public final JComponent component() {
        return this.myComponent;
    }

    @Override
    public void addChild(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.addChild(this.myComponent.getComponentCount(), canvas);
    }

    @Override
    public void addChild(int index, @NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        CanvasComponent canvasComponent = new CanvasComponent((AwtCanvas)canvas);
        this.myComponent.add((Component)canvasComponent, this.myComponent.getComponentCount() - index);
        this.myComponent.revalidate();
        Map map2 = this.myMappedCanvases;
        boolean bl = false;
        map2.put(canvas, canvasComponent);
    }

    @Override
    public void removeChild(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.myComponent.remove(this.myMappedCanvases.get(canvas));
        this.myComponent.revalidate();
        this.myMappedCanvases.remove(canvas);
    }

    @Override
    @NotNull
    public AnimationProvider.AnimationTimer createAnimationTimer(@NotNull AnimationProvider.AnimationEventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        return new AnimationProvider.AnimationTimer(this, eventHandler){
            final /* synthetic */ AwtCanvasControl this$0;
            final /* synthetic */ AnimationProvider.AnimationEventHandler $eventHandler;
            {
                this.this$0 = $receiver;
                this.$eventHandler = $eventHandler;
            }

            public void start() {
                AwtCanvasControl.access$getMyAnimationTimerPeer$p(this.this$0).addHandler((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this){

                    public final void invoke(long p0) {
                        (this.receiver).handle(p0);
                    }
                }));
            }

            public void stop() {
                AwtCanvasControl.access$getMyAnimationTimerPeer$p(this.this$0).removeHandler((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this){

                    public final void invoke(long p0) {
                        (this.receiver).handle(p0);
                    }
                }));
            }

            public final void handle(long millisTime) {
                if (this.$eventHandler.onEvent(millisTime)) {
                    AwtCanvasControl.access$getMyComponent$p(this.this$0).repaint();
                }
            }
        };
    }

    @Override
    @NotNull
    public Canvas createCanvas(@NotNull Vector size2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        return AwtCanvas.Companion.create(size2, this.myPixelRatio);
    }

    private final Image imagePngBase64ToImage(String dataUrl) {
        String imageString;
        String mediaType = "data:image/png;base64,";
        String string = imageString = StringsKt.replace$default((String)dataUrl, (String)mediaType, (String)"", (boolean)false, (int)4, null);
        Object object = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UTF_8");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        try {
            InputStream inputStream = Base64.getDecoder().wrap(byteArrayInputStream);
            boolean bl2 = false;
            boolean bl3 = false;
            InputStream p0 = inputStream;
            boolean bl4 = false;
            object = ImageIO.read(p0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDecoder().wrap(byteAr\u2026tream).let(ImageIO::read)");
            return (Image)object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public Async<Canvas.Snapshot> createSnapshot(@NotNull String dataUrl) {
        Intrinsics.checkNotNullParameter((Object)dataUrl, (String)"dataUrl");
        return Asyncs.INSTANCE.constant(new AwtCanvas.AwtSnapshot(this.imagePngBase64ToImage(dataUrl)));
    }

    @Override
    @NotNull
    public Async<Canvas.Snapshot> createSnapshot(@NotNull byte[] bytes, @NotNull Vector size2) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        BufferedImage src = ImageIO.read(new ByteArrayInputStream(bytes));
        BufferedImage dst = new BufferedImage(size2.getX(), size2.getY(), 2);
        Graphics2D graphics2D = dst.createGraphics();
        if (graphics2D == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D graphics2D2 = graphics2D;
        graphics2D2.drawImage(src, 0, 0, size2.getX(), size2.getY(), null);
        return Asyncs.INSTANCE.constant(new AwtCanvas.AwtSnapshot(dst));
    }

    @Override
    @NotNull
    public Registration addEventHandler(@NotNull MouseEventSpec eventSpec, @NotNull EventHandler<? super MouseEvent> eventHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventSpec), (String)"eventSpec");
        Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
        return this.myEventPeer.addEventHandler((MouseEventSpec)((Enum)eventSpec), EventHandlerExtKt.handler((Function1)new Function1<MouseEvent, Unit>(eventHandler){
            final /* synthetic */ EventHandler<MouseEvent> $eventHandler;
            {
                this.$eventHandler = $eventHandler;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$eventHandler.onEvent(it);
            }
        }));
    }

    @Override
    public <T> void schedule(@NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.myAnimationTimerPeer.getExecutor().invoke((Object)new Function0<Unit>(f){
            final /* synthetic */ Function0<T> $f;
            {
                this.$f = $f;
                super(0);
            }

            public final void invoke() {
                this.$f.invoke();
            }
        });
    }

    public static final /* synthetic */ AwtAnimationTimerPeer access$getMyAnimationTimerPeer$p(AwtCanvasControl $this) {
        return $this.myAnimationTimerPeer;
    }

    public static final /* synthetic */ CanvasContainerPanel access$getMyComponent$p(AwtCanvasControl $this) {
        return $this.myComponent;
    }
}

