/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.tooltip.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.interact.TooltipAnchor;
import jetbrains.datalore.plot.builder.interact.MathUtil;
import jetbrains.datalore.plot.builder.interact.PlotTooltipBounds;
import jetbrains.datalore.plot.builder.interact.TooltipSpec;
import jetbrains.datalore.plot.builder.tooltip.TooltipBox;
import jetbrains.datalore.plot.builder.tooltip.layout.HorizontalTooltipExpander;
import jetbrains.datalore.plot.builder.tooltip.layout.LayoutManager;
import jetbrains.datalore.plot.builder.tooltip.layout.VerticalAlignmentResolver;
import jetbrains.datalore.plot.builder.tooltip.layout.VerticalTooltipRotatingExpander;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 82\u00020\u0001:\u000589:;<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J \u0010 \u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00142\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J(\u0010!\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0014H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u0010\u00100\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0014H\u0002J\u0010\u00100\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u001a\u00101\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00122\b\u00102\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u00103\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0019H\u0002J\u0010\u00105\u001a\u00020*2\u0006\u0010#\u001a\u00020\nH\u0002J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u00107\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager;", "", "myViewport", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "myPreferredHorizontalAlignment", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$HorizontalAlignment;", "(Ljetbrains/datalore/base/geometry/DoubleRectangle;Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$HorizontalAlignment;)V", "myCursorCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "myHorizontalSpace", "Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "myHorizontalTooltipSpace", "myVerticalAlignmentResolver", "Ljetbrains/datalore/plot/builder/tooltip/layout/VerticalAlignmentResolver;", "myVerticalSpace", "myVerticalTooltipSpace", "arrange", "", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "tooltips", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$MeasuredTooltip;", "cursorCoord", "tooltipBounds", "Ljetbrains/datalore/plot/builder/interact/PlotTooltipBounds;", "calculateAnchorX", "", "measuredTooltip", "horizontalAlignment", "calculateCornerTooltipsPosition", "calculateCursorTooltipPosition", "calculateDataTooltipsPosition", "restrictions", "calculateHorizontalTooltipPosition", "calculatePlotCornerTooltipPosition", "tooltipY", "verticalTooltipRange", "horizontalAnchor", "Ljetbrains/datalore/plot/base/interact/TooltipAnchor$HorizontalAnchor;", "calculateVerticalTooltipPosition", "alignment", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$VerticalAlignment;", "ignoreCursor", "", "fixOverlappingWithShifting", "isAxisTooltip", "tooltipSpec", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec;", "tooltip", "isCorner", "isTooltipWithinBounds", "bounds", "overlapsCursorHorizontalRange", "tooltipX", "overlapsCursorVerticalRange", "rearrangeWithoutOverlapping", "selectCorner", "Companion", "HorizontalAlignment", "MeasuredTooltip", "PositionedTooltip", "VerticalAlignment", "plot-builder"})
public final class LayoutManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleRectangle myViewport;
    @NotNull
    private final HorizontalAlignment myPreferredHorizontalAlignment;
    @NotNull
    private final MathUtil.DoubleRange myHorizontalSpace;
    @NotNull
    private MathUtil.DoubleRange myVerticalSpace;
    @NotNull
    private DoubleVector myCursorCoord;
    @NotNull
    private MathUtil.DoubleRange myHorizontalTooltipSpace;
    @NotNull
    private MathUtil.DoubleRange myVerticalTooltipSpace;
    private VerticalAlignmentResolver myVerticalAlignmentResolver;
    @NotNull
    private static final DoubleVector CURSOR_DIMENSION = new DoubleVector(10.0, 10.0);
    @NotNull
    private static final MathUtil.DoubleRange EMPTY_DOUBLE_RANGE = MathUtil.DoubleRange.Companion.withStartAndLength(0.0, 0.0);

    public LayoutManager(@NotNull DoubleRectangle myViewport, @NotNull HorizontalAlignment myPreferredHorizontalAlignment) {
        Intrinsics.checkNotNullParameter((Object)myViewport, (String)"myViewport");
        Intrinsics.checkNotNullParameter((Object)((Object)myPreferredHorizontalAlignment), (String)"myPreferredHorizontalAlignment");
        this.myViewport = myViewport;
        this.myPreferredHorizontalAlignment = myPreferredHorizontalAlignment;
        this.myHorizontalSpace = MathUtil.DoubleRange.Companion.withStartAndEnd(this.myViewport.getLeft(), this.myViewport.getRight());
        this.myVerticalSpace = MathUtil.DoubleRange.Companion.withStartAndEnd(0.0, 0.0);
        this.myCursorCoord = DoubleVector.Companion.getZERO();
        this.myHorizontalTooltipSpace = MathUtil.DoubleRange.Companion.withStartAndEnd(this.myViewport.getLeft(), this.myViewport.getRight());
        this.myVerticalTooltipSpace = MathUtil.DoubleRange.Companion.withStartAndEnd(this.myViewport.getTop(), this.myViewport.getBottom());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PositionedTooltip> arrange(@NotNull List<MeasuredTooltip> tooltips, @NotNull DoubleVector cursorCoord, @Nullable PlotTooltipBounds tooltipBounds) {
        void $this$filterNotTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        boolean bl;
        Collection<DoubleRectangle> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object v1;
        PlotTooltipBounds plotTooltipBounds;
        Object object;
        Object $this$firstOrNull$iv;
        boolean $i$f$firstOrNull;
        ArrayList<PositionedTooltip> desiredPosition;
        block17: {
            Object v0;
            boolean bl2;
            MeasuredTooltip it;
            block16: {
                Intrinsics.checkNotNullParameter(tooltips, (String)"tooltips");
                Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
                this.myCursorCoord = cursorCoord;
                this.myVerticalSpace = MathUtil.DoubleRange.Companion.withStartAndEnd(this.myViewport.getTop(), this.myViewport.getBottom());
                this.myVerticalAlignmentResolver = new VerticalAlignmentResolver(this.myVerticalSpace);
                if (tooltipBounds != null) {
                    this.myHorizontalTooltipSpace = MathUtil.DoubleRange.Companion.withStartAndLength(tooltipBounds.getPlacementArea().getOrigin().getX(), tooltipBounds.getPlacementArea().getDimension().getX());
                    this.myVerticalTooltipSpace = MathUtil.DoubleRange.Companion.withStartAndLength(tooltipBounds.getPlacementArea().getOrigin().getY(), tooltipBounds.getPlacementArea().getDimension().getY());
                }
                desiredPosition = new ArrayList<PositionedTooltip>();
                Iterable iterable = tooltips;
                $i$f$firstOrNull = false;
                for (Object t : $this$firstOrNull$iv) {
                    it = (MeasuredTooltip)t;
                    bl2 = false;
                    if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.X_AXIS_TOOLTIP)) continue;
                    v0 = t;
                    break block16;
                }
                v0 = null;
            }
            object = v0;
            if (object != null) {
                $this$firstOrNull$iv = object;
                $i$f$firstOrNull = false;
                boolean bl3 = false;
                TipLayoutHint.Kind[] kindArray = $this$firstOrNull$iv;
                boolean bl22 = false;
                PositionedTooltip positionedTooltip = this.calculateVerticalTooltipPosition((MeasuredTooltip)kindArray, VerticalAlignment.BOTTOM, true);
                if (this.isTooltipWithinBounds(positionedTooltip, (plotTooltipBounds = tooltipBounds) == null ? null : plotTooltipBounds.getHandlingArea())) {
                    desiredPosition.add(positionedTooltip);
                    double d = positionedTooltip.getStemCoord().getY();
                    double d2 = positionedTooltip.getTop$plot_builder();
                    boolean bl4 = false;
                    this.myVerticalSpace = MathUtil.DoubleRange.Companion.withStartAndEnd(this.myViewport.getTop(), Math.min(d, d2));
                    this.myVerticalAlignmentResolver = new VerticalAlignmentResolver(this.myVerticalSpace);
                }
            }
            $this$firstOrNull$iv = tooltips;
            $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                it = (MeasuredTooltip)t;
                bl2 = false;
                if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP)) continue;
                v1 = t;
                break block17;
            }
            v1 = null;
        }
        object = v1;
        if (object != null) {
            $this$firstOrNull$iv = object;
            $i$f$firstOrNull = false;
            boolean bl5 = false;
            TipLayoutHint.Kind[] kindArray = $this$firstOrNull$iv;
            boolean bl4 = false;
            PositionedTooltip positionedTooltip = LayoutManager.calculateHorizontalTooltipPosition$default(this, (MeasuredTooltip)kindArray, null, 2, null);
            if (this.isTooltipWithinBounds(positionedTooltip, (plotTooltipBounds = tooltipBounds) == null ? null : plotTooltipBounds.getHandlingArea())) {
                desiredPosition.add(positionedTooltip);
            }
        }
        object = tooltipBounds;
        if (!(object == null ? false : (($this$firstOrNull$iv = ((PlotTooltipBounds)object).getHandlingArea()) == null ? false : !$this$firstOrNull$iv.contains(cursorCoord)))) {
            object = desiredPosition;
            $this$firstOrNull$iv = this.calculateCornerTooltipsPosition(tooltips);
            $i$f$firstOrNull = false;
            CollectionsKt.addAll((Collection)object, (Iterable)$this$firstOrNull$iv);
        }
        object = desiredPosition;
        $this$firstOrNull$iv = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.Y_AXIS_TOOLTIP};
        $this$firstOrNull$iv = LayoutManager.Companion.select(desiredPosition, $this$firstOrNull$iv);
        List<MeasuredTooltip> list2 = tooltips;
        LayoutManager layoutManager = this;
        boolean $i$f$map = false;
        void var8_12 = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PositionedTooltip positionedTooltip = (PositionedTooltip)item$iv$iv;
            collection = collection2;
            bl = false;
            DoubleRectangle doubleRectangle = p0.rect$plot_builder();
            collection.add(doubleRectangle);
        }
        collection = (List)collection2;
        $this$map$iv = layoutManager.calculateDataTooltipsPosition(list2, (List<DoubleRectangle>)collection);
        boolean $i$f$filter232 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        Collection collection3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PositionedTooltip positionedTooltip = (PositionedTooltip)element$iv$iv;
            bl = false;
            PlotTooltipBounds plotTooltipBounds2 = tooltipBounds;
            if (!this.isTooltipWithinBounds(positionedTooltip, plotTooltipBounds2 == null ? null : plotTooltipBounds2.getHandlingArea())) continue;
            collection3.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection3;
        $i$f$filter232 = false;
        CollectionsKt.addAll((Collection)object, (Iterable)$this$filter$iv);
        Iterable $this$filterNot$iv = tooltips;
        boolean $i$f$filterNot = false;
        Iterable $i$f$filter232 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean bl6 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MeasuredTooltip p0 = (MeasuredTooltip)element$iv$iv;
            boolean bl7 = false;
            if (this.isAxisTooltip(p0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        $i$f$filterNot = false;
        if (!$this$filterNot$iv.isEmpty()) {
            boolean bl8;
            block18: {
                Iterable $this$all$iv = desiredPosition;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl8 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PositionedTooltip positionedTooltip = (PositionedTooltip)element$iv;
                        boolean bl5 = false;
                        if (this.isAxisTooltip(positionedTooltip)) continue;
                        bl8 = false;
                        break block18;
                    }
                    bl8 = true;
                }
            }
            if (bl8) {
                desiredPosition.clear();
            }
        }
        return this.rearrangeWithoutOverlapping((List<PositionedTooltip>)desiredPosition);
    }

    private final boolean isTooltipWithinBounds(PositionedTooltip tooltip, DoubleRectangle bounds) {
        boolean bl;
        if (bounds == null) {
            return true;
        }
        TipLayoutHint.Kind kind = tooltip.getHintKind$plot_builder();
        int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
        switch (n) {
            case 1: {
                bl = bounds.xRange().contains((Double)((Comparable)Double.valueOf(tooltip.getStemCoord().getX())));
                break;
            }
            case 2: {
                bl = bounds.yRange().contains((Double)((Comparable)Double.valueOf(tooltip.getStemCoord().getY())));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = bounds.contains(tooltip.getStemCoord());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final List<PositionedTooltip> calculateDataTooltipsPosition(List<MeasuredTooltip> tooltips, List<DoubleRectangle> restrictions) {
        ArrayList<PositionedTooltip> placementList = new ArrayList<PositionedTooltip>();
        for (MeasuredTooltip measuredTooltip : tooltips) {
            if (this.isCorner(measuredTooltip)) continue;
            TipLayoutHint.Kind kind = measuredTooltip.getHintKind$plot_builder();
            int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
            switch (n) {
                case 3: {
                    placementList.add(this.calculateVerticalTooltipPosition(measuredTooltip, VerticalAlignment.TOP, false));
                    break;
                }
                case 4: {
                    placementList.add(this.calculateHorizontalTooltipPosition(measuredTooltip, restrictions));
                    break;
                }
                case 5: {
                    placementList.add(this.calculateCursorTooltipPosition(measuredTooltip));
                    break;
                }
                case 6: {
                    placementList.add(this.calculateVerticalTooltipPosition(measuredTooltip, VerticalAlignment.BOTTOM, true));
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                }
            }
        }
        return placementList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PositionedTooltip> calculateCornerTooltipsPosition(List<MeasuredTooltip> tooltips) {
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        ArrayList<PositionedTooltip> placementList = new ArrayList<PositionedTooltip>();
        Iterable $this$filter$iv = tooltips;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MeasuredTooltip p0 = (MeasuredTooltip)element$iv$iv;
            boolean bl = false;
            if (!this.isCorner(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            TooltipAnchor key$iv$iv;
            MeasuredTooltip it = (MeasuredTooltip)element$iv$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it.getTooltipSpec$plot_builder().getAnchor());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            MathUtil.DoubleRange doubleRange;
            Map.Entry element$iv;
            Map.Entry $dstr$tooltipAnchor$cornerTooltips = element$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry bl4 = $dstr$tooltipAnchor$cornerTooltips;
            boolean bl5 = false;
            TooltipAnchor tooltipAnchor = (TooltipAnchor)bl4.getKey();
            Map.Entry entry = $dstr$tooltipAnchor$cornerTooltips;
            boolean bl6 = false;
            List cornerTooltips = (List)entry.getValue();
            value$iv$iv$iv = cornerTooltips;
            boolean bl7 = false;
            double d = 0.0;
            Iterator iterator3 = value$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void it;
                Object t = iterator3.next();
                MeasuredTooltip measuredTooltip = (MeasuredTooltip)t;
                double d2 = d;
                boolean bl8 = false;
                double d3 = it.getSize$plot_builder().getY();
                d = d2 + d3;
            }
            double tooltipsHeight = d + 5.0 * (double)cornerTooltips.size();
            TooltipAnchor.VerticalAnchor verticalAnchor = tooltipAnchor.getVerticalAnchor();
            int n = WhenMappings.$EnumSwitchMapping$1[verticalAnchor.ordinal()];
            switch (n) {
                case 1: {
                    doubleRange = LayoutManager.Companion.rightAligned(this.myVerticalTooltipSpace.start(), tooltipsHeight, 0.0);
                    break;
                }
                case 2: {
                    doubleRange = LayoutManager.Companion.leftAligned(this.myVerticalTooltipSpace.end(), tooltipsHeight, 0.0);
                    break;
                }
                case 3: {
                    doubleRange = LayoutManager.Companion.centered((this.myVerticalTooltipSpace.start() + this.myVerticalTooltipSpace.end()) / (double)2, tooltipsHeight);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            MathUtil.DoubleRange verticalTooltipRange = doubleRange;
            double tooltipY = 0.0;
            tooltipY = verticalTooltipRange.start();
            Iterable $this$forEach$iv2 = cornerTooltips;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MeasuredTooltip tooltip = (MeasuredTooltip)element$iv2;
                boolean bl9 = false;
                PositionedTooltip positionedTooltip = this.calculatePlotCornerTooltipPosition(tooltip, tooltipY, verticalTooltipRange, tooltipAnchor.getHorizontalAnchor());
                placementList.add(positionedTooltip);
                tooltipY += positionedTooltip.getHeight$plot_builder() + 5.0;
            }
        }
        return placementList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PositionedTooltip> rearrangeWithoutOverlapping(List<PositionedTooltip> tooltips) {
        Object e$iv;
        Object p0;
        Iterator iterator2;
        Object $this$forEach$iv;
        double d;
        Iterator p02;
        double d2;
        if (tooltips.isEmpty()) {
            return tooltips;
        }
        ArrayList<DoubleRectangle> restrictions = new ArrayList<DoubleRectangle>();
        ArrayList<PositionedTooltip> separatedTooltips = new ArrayList<PositionedTooltip>();
        TipLayoutHint.Kind[] kindArray = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.CURSOR_TOOLTIP, TipLayoutHint.Kind.X_AXIS_TOOLTIP, TipLayoutHint.Kind.Y_AXIS_TOOLTIP};
        Iterable $this$forEach$iv2 = LayoutManager.Companion.select(tooltips, kindArray);
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PositionedTooltip p03 = (PositionedTooltip)element$iv;
            boolean bl = false;
            LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, p03);
        }
        Object $i$f$forEach22 = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.HORIZONTAL_TOOLTIP};
        List horizontalsWithOverlappedCorners = LayoutManager.Companion.withOverlapped(LayoutManager.Companion.select(tooltips, $i$f$forEach22), this.selectCorner(tooltips));
        $i$f$forEach22 = horizontalsWithOverlappedCorners;
        boolean bl = false;
        boolean bl2 = false;
        Object horizontalTooltips = $i$f$forEach22;
        boolean bl3 = false;
        Object object = (Iterable)horizontalTooltips;
        boolean bl4 = false;
        double d3 = 0.0;
        Iterator iterator3 = object.iterator();
        while (iterator3.hasNext()) {
            Object t = iterator3.next();
            PositionedTooltip positionedTooltip = (PositionedTooltip)t;
            d2 = d3;
            boolean bl5 = false;
            d = ((PositionedTooltip)((Object)p02)).getHeight$plot_builder();
            d3 = d2 + d;
        }
        if (d3 < this.myVerticalSpace.length()) {
            object = new HorizontalTooltipExpander(this.myVerticalSpace).fixOverlapping((List<PositionedTooltip>)horizontalTooltips);
            boolean $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                p0 = (PositionedTooltip)element$iv;
                boolean bl6 = false;
                LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, (PositionedTooltip)p0);
            }
        } else {
            Object v0;
            PositionedTooltip $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable $i$f$forEach = (Iterable)horizontalTooltips;
            boolean $i$f$filter = false;
            void element$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            p02 = $this$filterTo$iv$iv.iterator();
            while (p02.hasNext()) {
                Object element$iv$iv = p02.next();
                PositionedTooltip it = (PositionedTooltip)element$iv$iv;
                boolean bl7 = false;
                if (!(it.getStemCoord().getY() < this.myCursorCoord.getY())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv2.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv2.next();
                if (!iterator$iv2.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    PositionedTooltip it = (PositionedTooltip)maxElem$iv;
                    boolean bl8 = false;
                    double maxValue$iv = it.getStemCoord().getY();
                    do {
                        e$iv = iterator$iv2.next();
                        PositionedTooltip it2 = (PositionedTooltip)e$iv;
                        $i$a$-maxByOrNull-LayoutManager$rearrangeWithoutOverlapping$2$4 = false;
                        double v$iv = it2.getStemCoord().getY();
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv2.hasNext());
                    v0 = maxElem$iv;
                }
            }
            $this$forEach$iv = v0;
            if ($this$forEach$iv != null) {
                $this$maxByOrNull$iv = $this$forEach$iv;
                boolean bl9 = false;
                boolean iterator$iv2 = false;
                p0 = $this$maxByOrNull$iv;
                boolean bl10 = false;
                LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, (PositionedTooltip)p0);
            }
        }
        Iterable $this$forEach$iv3 = CollectionsKt.minus((Iterable)this.selectCorner(tooltips), (Iterable)horizontalsWithOverlappedCorners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv3) {
            PositionedTooltip p04 = (PositionedTooltip)element$iv;
            boolean bl11 = false;
            LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, p04);
        }
        Object object2 = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.VERTICAL_TOOLTIP, TipLayoutHint.Kind.ROTATED_TOOLTIP};
        object2 = CollectionsKt.minus((Iterable)LayoutManager.Companion.select(tooltips, object2), (Iterable)this.selectCorner(tooltips));
        bl = false;
        boolean bl12 = false;
        Object verticalTooltips = object2;
        boolean bl13 = false;
        Iterable bl11 = (Iterable)verticalTooltips;
        boolean $this$maxByOrNull$iv = false;
        d3 = 0.0;
        for (Object bl10 : bl11) {
            e$iv = (PositionedTooltip)bl10;
            d2 = d3;
            boolean bl14 = false;
            d = ((PositionedTooltip)((Object)p02)).getWidth$plot_builder();
            d3 = d2 + d;
        }
        if (d3 < this.myHorizontalSpace.length()) {
            bl11 = this.fixOverlappingWithShifting(new VerticalTooltipRotatingExpander(this.myVerticalSpace, this.myHorizontalSpace).fixOverlapping((List<PositionedTooltip>)verticalTooltips, (List<DoubleRectangle>)restrictions));
            boolean $i$f$forEach3 = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                p0 = (PositionedTooltip)element$iv;
                boolean bl15 = false;
                LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, (PositionedTooltip)p0);
            }
        } else {
            Object v1;
            void $this$minByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$sortedBy$iv;
            $this$forEach$iv = (Iterable)verticalTooltips;
            boolean $i$f$sortedBy = false;
            boolean bl16 = false;
            object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PositionedTooltip it = (PositionedTooltip)a;
                    boolean bl2 = false;
                    Comparable comparable = Double.valueOf(it.getStemCoord().getX());
                    it = (PositionedTooltip)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Double d = it.getStemCoord().getX();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                }
            });
            boolean bl17 = false;
            bl16 = false;
            Iterable tooltips2 = object;
            boolean bl18 = false;
            Iterable bl15 = tooltips2;
            boolean $i$f$filter = false;
            void bl14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PositionedTooltip it = (PositionedTooltip)element$iv$iv;
                boolean bl19 = false;
                if (!(it.getStemCoord().getX() > this.myCursorCoord.getX())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    PositionedTooltip it = (PositionedTooltip)minElem$iv;
                    boolean bl20 = false;
                    double minValue$iv = it.getStemCoord().getX();
                    do {
                        Object e$iv2 = iterator$iv.next();
                        PositionedTooltip it3 = (PositionedTooltip)e$iv2;
                        $i$a$-minByOrNull-LayoutManager$rearrangeWithoutOverlapping$4$4$2 = false;
                        double v$iv = it3.getStemCoord().getX();
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv2;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            PositionedTooltip positionedTooltip = v1;
            object = positionedTooltip == null ? (PositionedTooltip)CollectionsKt.last((List)tooltips2) : positionedTooltip;
            bl17 = false;
            bl16 = false;
            Object p05 = object;
            boolean bl21 = false;
            LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, (PositionedTooltip)p05);
        }
        return separatedTooltips;
    }

    private final List<PositionedTooltip> fixOverlappingWithShifting(List<PositionedTooltip> tooltips) {
        ArrayList<PositionedTooltip> placementList = new ArrayList<PositionedTooltip>();
        Function1[] function1Array = new Function1[]{fixOverlappingWithShifting.1.INSTANCE, fixOverlappingWithShifting.2.INSTANCE};
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)tooltips, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PositionedTooltip positionedTooltip;
            PositionedTooltip tooltip = (PositionedTooltip)element$iv;
            boolean bl = false;
            if (LayoutManager.Companion.isOverlapped(placementList, tooltip)) {
                DoubleVector newPosition = new DoubleVector(((PositionedTooltip)CollectionsKt.last((List)placementList)).rect$plot_builder().getRight() + 5.0, tooltip.getTooltipCoord().getY());
                positionedTooltip = tooltip.moveTo$plot_builder(newPosition);
            } else {
                positionedTooltip = tooltip;
            }
            PositionedTooltip newTooltip = positionedTooltip;
            placementList.add(newTooltip);
        }
        return placementList;
    }

    private final PositionedTooltip calculateVerticalTooltipPosition(MeasuredTooltip measuredTooltip, VerticalAlignment alignment, boolean ignoreCursor) {
        VerticalAlignmentResolver verticalAlignmentResolver;
        double tooltipX = LayoutManager.Companion.centerInsideRange(measuredTooltip.getHintCoord$plot_builder().getX(), measuredTooltip.getSize$plot_builder().getX(), this.myHorizontalSpace);
        double stemY = 0.0;
        double tooltipY = 0.0;
        LayoutManager layoutManager = this;
        boolean bl = false;
        boolean bl2 = false;
        LayoutManager $this$calculateVerticalTooltipPosition_u24lambda_u2d30 = layoutManager;
        boolean bl3 = false;
        double targetCoordY = measuredTooltip.getHintCoord$plot_builder().getY();
        double stemLength = measuredTooltip.getStemLength$plot_builder();
        double targetTopPoint = targetCoordY - measuredTooltip.getHintRadius$plot_builder();
        double targetBottomPoint = targetCoordY + measuredTooltip.getHintRadius$plot_builder();
        double tooltipHeight = measuredTooltip.getSize$plot_builder().getY();
        MathUtil.DoubleRange topTooltipRange = LayoutManager.Companion.leftAligned(targetTopPoint, tooltipHeight, stemLength);
        MathUtil.DoubleRange doubleRange = LayoutManager.Companion.rightAligned(targetBottomPoint, tooltipHeight, stemLength);
        boolean bl4 = false;
        boolean bl5 = false;
        MathUtil.DoubleRange bottomTooltipRange = doubleRange;
        boolean bl6 = false;
        MathUtil.DoubleRange bottomTooltipRange2 = measuredTooltip.getHintKind$plot_builder() == TipLayoutHint.Kind.X_AXIS_TOOLTIP && !bottomTooltipRange.inside($this$calculateVerticalTooltipPosition_u24lambda_u2d30.myVerticalSpace) ? LayoutManager.Companion.leftAligned($this$calculateVerticalTooltipPosition_u24lambda_u2d30.myVerticalSpace.end(), tooltipHeight, stemLength) : bottomTooltipRange;
        MathUtil.DoubleRange cursorVerticalRange = !ignoreCursor && $this$calculateVerticalTooltipPosition_u24lambda_u2d30.overlapsCursorHorizontalRange(measuredTooltip, tooltipX) ? MathUtil.DoubleRange.Companion.withStartAndLength($this$calculateVerticalTooltipPosition_u24lambda_u2d30.myCursorCoord.getY(), CURSOR_DIMENSION.getY()) : EMPTY_DOUBLE_RANGE;
        VerticalAlignmentResolver verticalAlignmentResolver2 = $this$calculateVerticalTooltipPosition_u24lambda_u2d30.myVerticalAlignmentResolver;
        if (verticalAlignmentResolver2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myVerticalAlignmentResolver");
            verticalAlignmentResolver = null;
        } else {
            verticalAlignmentResolver = verticalAlignmentResolver2;
        }
        if (verticalAlignmentResolver.resolve(topTooltipRange, bottomTooltipRange2, alignment, cursorVerticalRange) == VerticalAlignment.TOP) {
            tooltipY = topTooltipRange.start();
            stemY = targetTopPoint;
        } else {
            tooltipY = bottomTooltipRange2.start();
            stemY = targetBottomPoint;
        }
        return new PositionedTooltip(measuredTooltip, new DoubleVector(tooltipX, tooltipY), new DoubleVector(measuredTooltip.getHintCoord$plot_builder().getX(), stemY));
    }

    /*
     * Unable to fully structure code
     */
    private final PositionedTooltip calculateHorizontalTooltipPosition(MeasuredTooltip measuredTooltip, List<DoubleRectangle> restrictions) {
        block14: {
            block15: {
                block13: {
                    block12: {
                        tooltipY = jetbrains.datalore.plot.builder.tooltip.layout.LayoutManager$Companion.access$centerInsideRange(LayoutManager.Companion, measuredTooltip.getHintCoord$plot_builder().getY(), measuredTooltip.getSize$plot_builder().getY(), this.myVerticalSpace);
                        tooltipX = 0.0;
                        stemX = 0.0;
                        var5_6 = this;
                        var6_7 = false;
                        var7_9 = false;
                        $this$calculateHorizontalTooltipPosition_u24lambda_u2d32 = var5_6;
                        $i$a$-run-LayoutManager$calculateHorizontalTooltipPosition$1 = false;
                        targetCoordX = measuredTooltip.getHintCoord$plot_builder().getX();
                        tooltipWidth = measuredTooltip.getSize$plot_builder().getX();
                        hintSize = measuredTooltip.getHintRadius$plot_builder();
                        stemLength = measuredTooltip.getStemLength$plot_builder();
                        margin = hintSize + stemLength;
                        leftTooltipPlacement = jetbrains.datalore.plot.builder.tooltip.layout.LayoutManager$Companion.access$leftAligned(LayoutManager.Companion, targetCoordX, tooltipWidth, margin);
                        rightTooltipPlacement = jetbrains.datalore.plot.builder.tooltip.layout.LayoutManager$Companion.access$rightAligned(LayoutManager.Companion, targetCoordX, tooltipWidth, margin);
                        if (!leftTooltipPlacement.inside($this$calculateHorizontalTooltipPosition_u24lambda_u2d32.myHorizontalSpace)) ** GOTO lbl-1000
                        $this$all$iv = restrictions;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v0 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                it = (DoubleRectangle)element$iv;
                                $i$a$-all-LayoutManager$calculateHorizontalTooltipPosition$1$canFitLeft$1 = false;
                                tooltipRect = new DoubleRectangle(new DoubleVector(leftTooltipPlacement.start(), tooltipY), measuredTooltip.getSize$plot_builder());
                                if (it.intersects(tooltipRect) == false) continue;
                                v0 = false;
                                break block12;
                            }
                            v0 = true;
                        }
                    }
                    if (v0) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    canFitLeft = v1;
                    canFitRight = rightTooltipPlacement.inside($this$calculateHorizontalTooltipPosition_u24lambda_u2d32.myHorizontalSpace);
                    if (measuredTooltip.getHintKind$plot_builder() != TipLayoutHint.Kind.Y_AXIS_TOOLTIP || canFitLeft) break block13;
                    tooltipX = 0.0;
                    stemX = targetCoordX;
                    break block14;
                }
                if (canFitLeft || canFitRight) break block15;
                var23_22 = $this$calculateHorizontalTooltipPosition_u24lambda_u2d32.myPreferredHorizontalAlignment;
                var24_24 = WhenMappings.$EnumSwitchMapping$2[var23_22.ordinal()];
                switch (var24_24) {
                    case 1: {
                        stemX = targetCoordX - hintSize;
                        tooltipX = stemX + stemLength;
                        break block14;
                    }
                    case 2: {
                        stemX = targetCoordX + hintSize;
                        tooltipX = stemX - tooltipWidth - stemLength;
                        break block14;
                    }
                    case 3: {
                        stemX = targetCoordX;
                        tooltipX = targetCoordX - tooltipWidth / (double)2;
                        break block14;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if ($this$calculateHorizontalTooltipPosition_u24lambda_u2d32.myPreferredHorizontalAlignment == HorizontalAlignment.LEFT && canFitLeft || !canFitRight) {
                tooltipX = leftTooltipPlacement.start();
                stemX = targetCoordX - hintSize;
            } else {
                tooltipX = rightTooltipPlacement.start();
                stemX = targetCoordX + hintSize;
            }
        }
        stemCoord = new DoubleVector(stemX, measuredTooltip.getHintCoord$plot_builder().getY());
        tooltipCoord = new DoubleVector(tooltipX, tooltipY);
        return new PositionedTooltip(measuredTooltip, tooltipCoord, stemCoord);
    }

    static /* synthetic */ PositionedTooltip calculateHorizontalTooltipPosition$default(LayoutManager layoutManager, MeasuredTooltip measuredTooltip, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return layoutManager.calculateHorizontalTooltipPosition(measuredTooltip, list2);
    }

    private final PositionedTooltip calculateCursorTooltipPosition(MeasuredTooltip measuredTooltip) {
        double tooltipX = LayoutManager.Companion.centerInsideRange(this.myCursorCoord.getX(), measuredTooltip.getSize$plot_builder().getX(), this.myHorizontalSpace);
        double targetCoordY = this.myCursorCoord.getY();
        double tooltipHeight = measuredTooltip.getSize$plot_builder().getY();
        double verticalMargin = measuredTooltip.getStemLength$plot_builder();
        MathUtil.DoubleRange topTooltipPlacement = LayoutManager.Companion.leftAligned(targetCoordY, tooltipHeight, verticalMargin);
        MathUtil.DoubleRange bottomTooltipPlacement = LayoutManager.Companion.rightAligned(targetCoordY, tooltipHeight, verticalMargin);
        double tooltipY = topTooltipPlacement.inside(this.myVerticalSpace) ? topTooltipPlacement.start() : bottomTooltipPlacement.start();
        DoubleVector tooltipCoord = new DoubleVector(tooltipX, tooltipY);
        return new PositionedTooltip(measuredTooltip, tooltipCoord, this.myCursorCoord);
    }

    private final double calculateAnchorX(MeasuredTooltip measuredTooltip, HorizontalAlignment horizontalAlignment) {
        double d;
        HorizontalAlignment horizontalAlignment2 = horizontalAlignment;
        int n = WhenMappings.$EnumSwitchMapping$2[horizontalAlignment2.ordinal()];
        switch (n) {
            case 2: {
                d = this.myHorizontalTooltipSpace.end() - measuredTooltip.getSize$plot_builder().getX();
                break;
            }
            case 1: {
                d = this.myHorizontalSpace.start() + this.myHorizontalTooltipSpace.start() + 5.0;
                break;
            }
            case 3: {
                d = (this.myHorizontalTooltipSpace.start() + this.myHorizontalTooltipSpace.end() - measuredTooltip.getSize$plot_builder().getX()) / (double)2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    private final PositionedTooltip calculatePlotCornerTooltipPosition(MeasuredTooltip measuredTooltip, double tooltipY, MathUtil.DoubleRange verticalTooltipRange, TooltipAnchor.HorizontalAnchor horizontalAnchor) {
        HorizontalAlignment horizontalAlignment;
        TooltipAnchor.HorizontalAnchor horizontalAnchor2 = horizontalAnchor;
        int n = WhenMappings.$EnumSwitchMapping$3[horizontalAnchor2.ordinal()];
        switch (n) {
            case 1: {
                horizontalAlignment = HorizontalAlignment.RIGHT;
                break;
            }
            case 2: {
                horizontalAlignment = HorizontalAlignment.LEFT;
                break;
            }
            case 3: {
                horizontalAlignment = HorizontalAlignment.CENTER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HorizontalAlignment horizontalAlignment2 = horizontalAlignment;
        double tooltipX = this.calculateAnchorX(measuredTooltip, horizontalAlignment2);
        boolean isOverlapX = this.overlapsCursorHorizontalRange(measuredTooltip, tooltipX);
        boolean isOverlapY = this.overlapsCursorVerticalRange(verticalTooltipRange);
        if (isOverlapX && isOverlapY) {
            tooltipX = this.calculateAnchorX(measuredTooltip, horizontalAlignment2.inversed());
        }
        DoubleVector tooltipCoord = new DoubleVector(tooltipX, tooltipY);
        return new PositionedTooltip(measuredTooltip, tooltipCoord, tooltipCoord);
    }

    private final boolean overlapsCursorHorizontalRange(MeasuredTooltip measuredTooltip, double tooltipX) {
        MathUtil.DoubleRange horizontalTooltipRange = MathUtil.DoubleRange.Companion.withStartAndLength(tooltipX, measuredTooltip.getSize$plot_builder().getX());
        MathUtil.DoubleRange cursorHorizontalRange = MathUtil.DoubleRange.Companion.withStartAndLength(this.myCursorCoord.getX(), CURSOR_DIMENSION.getX());
        return horizontalTooltipRange.overlaps(cursorHorizontalRange);
    }

    private final boolean overlapsCursorVerticalRange(MathUtil.DoubleRange verticalTooltipRange) {
        MathUtil.DoubleRange cursorVerticalRange = MathUtil.DoubleRange.Companion.withStartAndLength(this.myCursorCoord.getY(), CURSOR_DIMENSION.getY());
        return verticalTooltipRange.overlaps(cursorVerticalRange);
    }

    private final boolean isCorner(TooltipSpec tooltipSpec) {
        return tooltipSpec.getAnchor() != null;
    }

    private final boolean isCorner(MeasuredTooltip tooltip) {
        return this.isCorner(tooltip.getTooltipSpec$plot_builder());
    }

    private final boolean isCorner(PositionedTooltip tooltip) {
        return this.isCorner(tooltip.getTooltipSpec());
    }

    private final boolean isAxisTooltip(TooltipSpec tooltipSpec) {
        TipLayoutHint.Kind[] kindArray = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.X_AXIS_TOOLTIP, TipLayoutHint.Kind.Y_AXIS_TOOLTIP};
        return CollectionsKt.listOf((Object[])kindArray).contains((Object)tooltipSpec.getLayoutHint().getKind());
    }

    private final boolean isAxisTooltip(MeasuredTooltip tooltip) {
        return this.isAxisTooltip(tooltip.getTooltipSpec$plot_builder());
    }

    private final boolean isAxisTooltip(PositionedTooltip tooltip) {
        return this.isAxisTooltip(tooltip.getTooltipSpec());
    }

    /*
     * WARNING - void declaration
     */
    private final List<PositionedTooltip> selectCorner(List<PositionedTooltip> $this$selectCorner) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$selectCorner;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PositionedTooltip p0 = (PositionedTooltip)element$iv$iv;
            boolean bl = false;
            if (!this.isCorner(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void rearrangeWithoutOverlapping$fixate(ArrayList<PositionedTooltip> separatedTooltips, ArrayList<DoubleRectangle> restrictions, PositionedTooltip positionedTooltip) {
        separatedTooltips.add(positionedTooltip);
        restrictions.add(positionedTooltip.rect$plot_builder());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$VerticalAlignment;", "", "(Ljava/lang/String;I)V", "TOP", "BOTTOM", "plot-builder"})
    public static final class VerticalAlignment
    extends Enum<VerticalAlignment> {
        public static final /* enum */ VerticalAlignment TOP = new VerticalAlignment();
        public static final /* enum */ VerticalAlignment BOTTOM = new VerticalAlignment();
        private static final /* synthetic */ VerticalAlignment[] $VALUES;

        public static VerticalAlignment[] values() {
            return (VerticalAlignment[])$VALUES.clone();
        }

        public static VerticalAlignment valueOf(String value) {
            return Enum.valueOf(VerticalAlignment.class, value);
        }

        static {
            $VALUES = verticalAlignmentArray = new VerticalAlignment[]{VerticalAlignment.TOP, VerticalAlignment.BOTTOM};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0000j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$HorizontalAlignment;", "", "(Ljava/lang/String;I)V", "inversed", "LEFT", "RIGHT", "CENTER", "plot-builder"})
    public static final class HorizontalAlignment
    extends Enum<HorizontalAlignment> {
        public static final /* enum */ HorizontalAlignment LEFT = new HorizontalAlignment();
        public static final /* enum */ HorizontalAlignment RIGHT = new HorizontalAlignment();
        public static final /* enum */ HorizontalAlignment CENTER = new HorizontalAlignment();
        private static final /* synthetic */ HorizontalAlignment[] $VALUES;

        @NotNull
        public final HorizontalAlignment inversed() {
            HorizontalAlignment horizontalAlignment;
            HorizontalAlignment horizontalAlignment2 = this;
            int n = WhenMappings.$EnumSwitchMapping$0[horizontalAlignment2.ordinal()];
            switch (n) {
                case 1: {
                    horizontalAlignment = RIGHT;
                    break;
                }
                case 2: {
                    horizontalAlignment = LEFT;
                    break;
                }
                case 3: {
                    horizontalAlignment = CENTER;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return horizontalAlignment;
        }

        public static HorizontalAlignment[] values() {
            return (HorizontalAlignment[])$VALUES.clone();
        }

        public static HorizontalAlignment valueOf(String value) {
            return Enum.valueOf(HorizontalAlignment.class, value);
        }

        static {
            $VALUES = horizontalAlignmentArray = new HorizontalAlignment[]{HorizontalAlignment.LEFT, HorizontalAlignment.RIGHT, HorizontalAlignment.CENTER};
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HorizontalAlignment.values().length];
                nArray[HorizontalAlignment.LEFT.ordinal()] = 1;
                nArray[HorizontalAlignment.RIGHT.ordinal()] = 2;
                nArray[HorizontalAlignment.CENTER.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0012\u0012\u0006\u0010\b\u001a\u00020\u0000\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0015\u0010*\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b+J\r\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.R\u0014\u0010\u000b\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0014\u0010 \u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000eR\u0014\u0010(\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000e\u00a8\u0006/"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "", "measuredTooltip", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$MeasuredTooltip;", "tooltipCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "stemCoord", "(Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$MeasuredTooltip;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "positionedTooltip", "newTooltipCoord", "(Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "bottom", "", "getBottom$plot_builder", "()D", "height", "getHeight$plot_builder", "hintKind", "Ljetbrains/datalore/plot/base/interact/TipLayoutHint$Kind;", "getHintKind$plot_builder", "()Ljetbrains/datalore/plot/base/interact/TipLayoutHint$Kind;", "left", "getLeft$plot_builder", "right", "getRight$plot_builder", "getStemCoord", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "tooltipBox", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;", "getTooltipBox", "()Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;", "getTooltipCoord", "tooltipSize", "getTooltipSize$plot_builder", "tooltipSpec", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec;", "getTooltipSpec", "()Ljetbrains/datalore/plot/builder/interact/TooltipSpec;", "top", "getTop$plot_builder", "width", "getWidth$plot_builder", "moveTo", "moveTo$plot_builder", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "rect$plot_builder", "plot-builder"})
    public static final class PositionedTooltip {
        @NotNull
        private final TooltipBox tooltipBox;
        @NotNull
        private final DoubleVector tooltipSize;
        @NotNull
        private final TooltipSpec tooltipSpec;
        @NotNull
        private final DoubleVector tooltipCoord;
        @NotNull
        private final DoubleVector stemCoord;

        @NotNull
        public final TooltipBox getTooltipBox() {
            return this.tooltipBox;
        }

        @NotNull
        public final DoubleVector getTooltipSize$plot_builder() {
            return this.tooltipSize;
        }

        @NotNull
        public final TooltipSpec getTooltipSpec() {
            return this.tooltipSpec;
        }

        @NotNull
        public final DoubleVector getTooltipCoord() {
            return this.tooltipCoord;
        }

        @NotNull
        public final DoubleVector getStemCoord() {
            return this.stemCoord;
        }

        public final double getLeft$plot_builder() {
            return this.tooltipCoord.getX();
        }

        public final double getTop$plot_builder() {
            return this.tooltipCoord.getY();
        }

        public final double getWidth$plot_builder() {
            return this.tooltipSize.getX();
        }

        public final double getHeight$plot_builder() {
            return this.tooltipSize.getY();
        }

        public final double getBottom$plot_builder() {
            return this.tooltipCoord.getY() + this.getHeight$plot_builder();
        }

        public final double getRight$plot_builder() {
            return this.tooltipCoord.getX() + this.getWidth$plot_builder();
        }

        @NotNull
        public final TipLayoutHint.Kind getHintKind$plot_builder() {
            return this.tooltipSpec.getLayoutHint().getKind();
        }

        public PositionedTooltip(@NotNull MeasuredTooltip measuredTooltip, @NotNull DoubleVector tooltipCoord, @NotNull DoubleVector stemCoord) {
            Intrinsics.checkNotNullParameter((Object)measuredTooltip, (String)"measuredTooltip");
            Intrinsics.checkNotNullParameter((Object)tooltipCoord, (String)"tooltipCoord");
            Intrinsics.checkNotNullParameter((Object)stemCoord, (String)"stemCoord");
            this.tooltipSpec = measuredTooltip.getTooltipSpec$plot_builder();
            this.tooltipSize = measuredTooltip.getSize$plot_builder();
            this.tooltipBox = measuredTooltip.getTooltipBox$plot_builder();
            this.tooltipCoord = tooltipCoord;
            this.stemCoord = stemCoord;
        }

        private PositionedTooltip(PositionedTooltip positionedTooltip, DoubleVector newTooltipCoord) {
            this.tooltipSpec = positionedTooltip.tooltipSpec;
            this.tooltipSize = positionedTooltip.tooltipSize;
            this.tooltipBox = positionedTooltip.tooltipBox;
            this.stemCoord = positionedTooltip.stemCoord;
            this.tooltipCoord = newTooltipCoord;
        }

        @NotNull
        public final PositionedTooltip moveTo$plot_builder(@NotNull DoubleVector newTooltipCoord) {
            Intrinsics.checkNotNullParameter((Object)newTooltipCoord, (String)"newTooltipCoord");
            return new PositionedTooltip(this, newTooltipCoord);
        }

        @NotNull
        public final DoubleRectangle rect$plot_builder() {
            return new DoubleRectangle(this.tooltipCoord, this.tooltipSize);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$MeasuredTooltip;", "", "tooltipSpec", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec;", "tooltipBox", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;", "(Ljetbrains/datalore/plot/builder/interact/TooltipSpec;Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;)V", "size", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljetbrains/datalore/plot/builder/interact/TooltipSpec;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;)V", "hintCoord", "getHintCoord$plot_builder", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "hintKind", "Ljetbrains/datalore/plot/base/interact/TipLayoutHint$Kind;", "getHintKind$plot_builder", "()Ljetbrains/datalore/plot/base/interact/TipLayoutHint$Kind;", "hintRadius", "", "getHintRadius$plot_builder", "()D", "getSize$plot_builder", "stemLength", "getStemLength$plot_builder", "getTooltipBox$plot_builder", "()Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;", "getTooltipSpec$plot_builder", "()Ljetbrains/datalore/plot/builder/interact/TooltipSpec;", "plot-builder"})
    public static final class MeasuredTooltip {
        @NotNull
        private final TooltipSpec tooltipSpec;
        @NotNull
        private final DoubleVector size;
        @NotNull
        private final TooltipBox tooltipBox;

        public MeasuredTooltip(@NotNull TooltipSpec tooltipSpec, @NotNull DoubleVector size2, @NotNull TooltipBox tooltipBox) {
            Intrinsics.checkNotNullParameter((Object)tooltipSpec, (String)"tooltipSpec");
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            Intrinsics.checkNotNullParameter((Object)tooltipBox, (String)"tooltipBox");
            this.tooltipSpec = tooltipSpec;
            this.size = size2;
            this.tooltipBox = tooltipBox;
        }

        @NotNull
        public final TooltipSpec getTooltipSpec$plot_builder() {
            return this.tooltipSpec;
        }

        @NotNull
        public final DoubleVector getSize$plot_builder() {
            return this.size;
        }

        @NotNull
        public final TooltipBox getTooltipBox$plot_builder() {
            return this.tooltipBox;
        }

        public MeasuredTooltip(@NotNull TooltipSpec tooltipSpec, @NotNull TooltipBox tooltipBox) {
            Intrinsics.checkNotNullParameter((Object)tooltipSpec, (String)"tooltipSpec");
            Intrinsics.checkNotNullParameter((Object)tooltipBox, (String)"tooltipBox");
            this(tooltipSpec, tooltipBox.getContentRect().getDimension(), tooltipBox);
        }

        @NotNull
        public final DoubleVector getHintCoord$plot_builder() {
            DoubleVector doubleVector = this.tooltipSpec.getLayoutHint().getCoord();
            Intrinsics.checkNotNull((Object)doubleVector);
            return doubleVector;
        }

        @NotNull
        public final TipLayoutHint.Kind getHintKind$plot_builder() {
            return this.tooltipSpec.getLayoutHint().getKind();
        }

        public final double getHintRadius$plot_builder() {
            return this.tooltipSpec.getLayoutHint().getObjectRadius();
        }

        public final double getStemLength$plot_builder() {
            return this.tooltipSpec.getLayoutHint().getStemLength().getValue();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u001d\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0013J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u001a\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J1\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$Companion;", "", "()V", "CURSOR_DIMENSION", "Ljetbrains/datalore/base/geometry/DoubleVector;", "EMPTY_DOUBLE_RANGE", "Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "centerInsideRange", "", "position", "size", "range", "centered", "start", "length", "leftAligned", "margin", "moveIntoLimit", "limit", "moveIntoLimit$plot_builder", "rightAligned", "isOverlapped", "", "", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "tooltip", "select", "kinds", "", "Ljetbrains/datalore/plot/base/interact/TipLayoutHint$Kind;", "(Ljava/util/List;[Ljetbrains/datalore/plot/base/interact/TipLayoutHint$Kind;)Ljava/util/List;", "withOverlapped", "tooltips", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MathUtil.DoubleRange moveIntoLimit$plot_builder(@NotNull MathUtil.DoubleRange range, @NotNull MathUtil.DoubleRange limit) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
            if (range.inside(limit)) {
                return range;
            }
            if (range.start() < limit.start()) {
                return range.move(limit.start() - range.start());
            }
            return range.end() > limit.end() ? range.move(limit.end() - range.end()) : range;
        }

        private final MathUtil.DoubleRange centered(double start2, double length) {
            return MathUtil.DoubleRange.Companion.withStartAndLength(start2 - length / (double)2, length);
        }

        private final MathUtil.DoubleRange leftAligned(double start2, double length, double margin) {
            return MathUtil.DoubleRange.Companion.withStartAndLength(start2 - length - margin, length);
        }

        private final MathUtil.DoubleRange rightAligned(double start2, double length, double margin) {
            return MathUtil.DoubleRange.Companion.withStartAndLength(start2 + margin, length);
        }

        private final double centerInsideRange(double position, double size2, MathUtil.DoubleRange range) {
            return this.moveIntoLimit$plot_builder(this.centered(position, size2), range).start();
        }

        /*
         * WARNING - void declaration
         */
        private final List<PositionedTooltip> select(List<PositionedTooltip> $this$select, TipLayoutHint.Kind ... kinds) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$select;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PositionedTooltip it = (PositionedTooltip)element$iv$iv;
                boolean bl = false;
                if (!ArraysKt.contains((Object[])kinds, (Object)((Object)it.getHintKind$plot_builder()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isOverlapped(List<PositionedTooltip> $this$isOverlapped, PositionedTooltip tooltip) {
            Object v0;
            block1: {
                Iterable iterable = $this$isOverlapped;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    PositionedTooltip it = (PositionedTooltip)t;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)tooltip) && it.rect$plot_builder().intersects(tooltip.rect$plot_builder()))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        /*
         * WARNING - void declaration
         */
        private final List<PositionedTooltip> withOverlapped(List<PositionedTooltip> $this$withOverlapped, List<PositionedTooltip> tooltips) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = tooltips;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PositionedTooltip tooltip = (PositionedTooltip)element$iv$iv;
                boolean bl = false;
                if (!Companion.isOverlapped($this$withOverlapped, tooltip)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List overlapped = (List)destination$iv$iv;
            return CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)$this$withOverlapped, (Iterable)tooltips), (Iterable)overlapped);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[TipLayoutHint.Kind.values().length];
            nArray[TipLayoutHint.Kind.X_AXIS_TOOLTIP.ordinal()] = 1;
            nArray[TipLayoutHint.Kind.Y_AXIS_TOOLTIP.ordinal()] = 2;
            nArray[TipLayoutHint.Kind.VERTICAL_TOOLTIP.ordinal()] = 3;
            nArray[TipLayoutHint.Kind.HORIZONTAL_TOOLTIP.ordinal()] = 4;
            nArray[TipLayoutHint.Kind.CURSOR_TOOLTIP.ordinal()] = 5;
            nArray[TipLayoutHint.Kind.ROTATED_TOOLTIP.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TooltipAnchor.VerticalAnchor.values().length];
            nArray[TooltipAnchor.VerticalAnchor.TOP.ordinal()] = 1;
            nArray[TooltipAnchor.VerticalAnchor.BOTTOM.ordinal()] = 2;
            nArray[TooltipAnchor.VerticalAnchor.MIDDLE.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[HorizontalAlignment.values().length];
            nArray[HorizontalAlignment.LEFT.ordinal()] = 1;
            nArray[HorizontalAlignment.RIGHT.ordinal()] = 2;
            nArray[HorizontalAlignment.CENTER.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[TooltipAnchor.HorizontalAnchor.values().length];
            nArray[TooltipAnchor.HorizontalAnchor.RIGHT.ordinal()] = 1;
            nArray[TooltipAnchor.HorizontalAnchor.LEFT.ordinal()] = 2;
            nArray[TooltipAnchor.HorizontalAnchor.CENTER.ordinal()] = 3;
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

