/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.presentation.Defaults;
import jetbrains.datalore.plot.config.BunchConfig;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.PlotConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\bJ\u0016\u0010\u001a\u001a\u00020\u00142\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\n2\u000e\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0002J\u0016\u0010\u001e\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 H\u0002J\u001a\u0010\u001e\u001a\u00020\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007J?\u0010\"\u001a\u00020\n2\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\b\u0010$\u001a\u0004\u0018\u00010\n2\b\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010&\u00a8\u0006'"}, d2={"Ljetbrains/datalore/plot/PlotSizeHelper;", "", "()V", "bunchItemBoundsList", "", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "bunchSpec", "", "", "bunchItemSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "bunchItem", "Ljetbrains/datalore/plot/config/BunchConfig$BunchItem;", "bunchItemSize$plot_config_portable", "defaultSinglePlotSize", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "containsLiveMap", "", "extractDouble", "", "regex", "Lkotlin/text/Regex;", "text", "fetchPlotSizeFromSvg", "svg", "figureAspectRatio", "figureFpec", "getSizeOptionOrNull", "singlePlotSpec", "plotBunchSize", "bunchItemBoundsIterable", "", "plotBunchFpec", "singlePlotSize", "plotSpec", "plotSize", "plotMaxWidth", "(Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Ljetbrains/datalore/plot/builder/assemble/PlotFacets;Z)Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-config-portable"})
public final class PlotSizeHelper {
    @NotNull
    public static final PlotSizeHelper INSTANCE = new PlotSizeHelper();

    private PlotSizeHelper() {
    }

    @NotNull
    public final DoubleVector singlePlotSize(@NotNull Map<?, ?> plotSpec, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth, @NotNull PlotFacets facets, boolean containsLiveMap) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        if (plotSize2 != null) {
            doubleVector = plotSize2;
        } else {
            DoubleVector plotSizeSpec = this.getSizeOptionOrNull(plotSpec);
            if (plotSizeSpec != null) {
                doubleVector = plotSizeSpec;
            } else {
                DoubleVector defSize = this.defaultSinglePlotSize(facets, containsLiveMap);
                if (plotMaxWidth != null && plotMaxWidth < defSize.getX()) {
                    double d = 50.0;
                    double d2 = plotMaxWidth;
                    boolean bl = false;
                    doubleVector = defSize.mul(Math.max(d, d2) / defSize.getX());
                } else {
                    doubleVector = defSize;
                }
            }
        }
        return doubleVector;
    }

    private final List<DoubleRectangle> bunchItemBoundsList(Map<String, ? extends Object> bunchSpec) {
        BunchConfig bunchConfig = new BunchConfig(bunchSpec);
        if (bunchConfig.getBunchItems().isEmpty()) {
            throw new IllegalArgumentException("No plots in the bunch");
        }
        ArrayList<DoubleRectangle> plotBounds = new ArrayList<DoubleRectangle>();
        for (BunchConfig.BunchItem bunchItem : bunchConfig.getBunchItems()) {
            plotBounds.add(new DoubleRectangle(new DoubleVector(bunchItem.getX(), bunchItem.getY()), this.bunchItemSize$plot_config_portable(bunchItem)));
        }
        return plotBounds;
    }

    @NotNull
    public final DoubleVector bunchItemSize$plot_config_portable(@NotNull BunchConfig.BunchItem bunchItem) {
        Intrinsics.checkNotNullParameter((Object)bunchItem, (String)"bunchItem");
        return bunchItem.hasSize() ? bunchItem.getSize() : this.singlePlotSize(bunchItem.getFeatureSpec(), null, null, PlotFacets.Companion.undefined(), false);
    }

    private final DoubleVector defaultSinglePlotSize(PlotFacets facets, boolean containsLiveMap) {
        DoubleVector plotSize2 = Defaults.INSTANCE.getDEF_PLOT_SIZE();
        if (facets.isDefined()) {
            double panelWidth = Defaults.INSTANCE.getDEF_PLOT_SIZE().getX() * (0.5 + 0.5 / (double)facets.getColCount());
            double panelHeight = Defaults.INSTANCE.getDEF_PLOT_SIZE().getY() * (0.5 + 0.5 / (double)facets.getRowCount());
            plotSize2 = new DoubleVector(panelWidth * (double)facets.getColCount(), panelHeight * (double)facets.getRowCount());
        } else if (containsLiveMap) {
            plotSize2 = Defaults.INSTANCE.getDEF_LIVE_MAP_SIZE();
        }
        return plotSize2;
    }

    private final DoubleVector getSizeOptionOrNull(Map<?, ?> singlePlotSpec) {
        Map<?, ?> map2 = singlePlotSpec;
        String string = "ggsize";
        boolean bl = false;
        Map<?, ?> map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (!map3.containsKey(string)) {
            return null;
        }
        Map<String, Object> map4 = new OptionsAccessor(singlePlotSpec, null, 2, null).getMap("ggsize");
        OptionsAccessor sizeSpec = OptionsAccessor.Companion.over(map4);
        Double width2 = sizeSpec.getDouble("width");
        Double height = sizeSpec.getDouble("height");
        if (width2 == null || height == null) {
            return null;
        }
        return new DoubleVector(width2, height);
    }

    public final double figureAspectRatio(@NotNull Map<?, ?> figureFpec) {
        double d;
        Intrinsics.checkNotNullParameter(figureFpec, (String)"figureFpec");
        if (PlotConfig.Companion.isPlotSpec(figureFpec)) {
            DoubleVector doubleVector = this.getSizeOptionOrNull(figureFpec);
            if (doubleVector == null) {
                d = 1.5;
            } else {
                double d2;
                DoubleVector doubleVector2 = doubleVector;
                boolean bl = false;
                boolean bl2 = false;
                DoubleVector it = doubleVector2;
                boolean bl3 = false;
                d = d2 = it.getX() / it.getY();
            }
        } else if (PlotConfig.Companion.isGGBunchSpec(figureFpec)) {
            DoubleVector bunchSize = this.plotBunchSize(figureFpec);
            d = bunchSize.getX() / bunchSize.getY();
        } else {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Unexpected plot spec kind: ", (Object)PlotConfig.Companion.specKind(figureFpec)));
        }
        return d;
    }

    @NotNull
    public final DoubleVector plotBunchSize(@NotNull Map<String, ? extends Object> plotBunchFpec) {
        Intrinsics.checkNotNullParameter(plotBunchFpec, (String)"plotBunchFpec");
        boolean bl = PlotConfig.Companion.isGGBunchSpec(plotBunchFpec);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Plot Bunch is expected but was kind: ", (Object)PlotConfig.Companion.specKind(plotBunchFpec));
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.plotBunchSize((Iterable<DoubleRectangle>)this.bunchItemBoundsList(plotBunchFpec));
    }

    /*
     * WARNING - void declaration
     */
    private final DoubleVector plotBunchSize(Iterable<DoubleRectangle> bunchItemBoundsIterable) {
        void $this$fold$iv;
        Iterable<DoubleRectangle> iterable = bunchItemBoundsIterable;
        DoubleRectangle initial$iv = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bounds;
            DoubleRectangle doubleRectangle = (DoubleRectangle)element$iv;
            DoubleRectangle acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.union((DoubleRectangle)bounds);
        }
        return accumulator$iv.getDimension();
    }

    @NotNull
    public final DoubleVector fetchPlotSizeFromSvg(@NotNull String svg) {
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        MatchResult svgTagMatch = Regex.find$default((Regex)new Regex("<svg (.*)>"), (CharSequence)svg, (int)0, (int)2, null);
        boolean bl = svgTagMatch != null && svgTagMatch.getGroupValues().size() == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Couldn't find 'svg' tag";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String svgTag = (String)svgTagMatch.getGroupValues().get(1);
        double width2 = this.extractDouble(new Regex(".*width=\"(\\d+)\\.?(\\d+)?\""), svgTag);
        double height = this.extractDouble(new Regex(".*height=\"(\\d+)\\.?(\\d+)?\""), svgTag);
        return new DoubleVector(width2, height);
    }

    private final double extractDouble(Regex regex, String text) {
        double d;
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)text, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        MatchResult matchResult2 = matchResult;
        List values2 = matchResult2.getGroupValues();
        if (values2.size() < 3) {
            String string = String.valueOf(values2.get(1));
            boolean bl = false;
            d = Double.parseDouble(string);
        } else {
            String string = (String)values2.get(1) + '.' + (String)values2.get(2);
            boolean bl = false;
            d = Double.parseDouble(string);
        }
        return d;
    }
}

