/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculatorKt;
import jetbrains.datalore.base.spatial.LongitudeSegment;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0015*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0015B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJH\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u001c\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000b2\u001c\u0010\u000f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000bJB\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u001c\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/base/spatial/GeoBoundingBoxCalculator;", "TypeT", "", "myMapRect", "Ljetbrains/datalore/base/typedGeometry/Rect;", "myLoopX", "", "myLoopY", "(Ljetbrains/datalore/base/typedGeometry/Rect;ZZ)V", "calculateBoundingBox", "xSegments", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "Ljetbrains/datalore/base/spatial/Segment;", "ySegments", "calculateBoundingRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "segments", "mapRange", "loop", "Companion", "base-portable"})
public final class GeoBoundingBoxCalculator<TypeT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rect<TypeT> myMapRect;
    private final boolean myLoopX;
    private final boolean myLoopY;

    public GeoBoundingBoxCalculator(@NotNull Rect<TypeT> myMapRect, boolean myLoopX, boolean myLoopY) {
        Intrinsics.checkNotNullParameter(myMapRect, (String)"myMapRect");
        this.myMapRect = myMapRect;
        this.myLoopX = myLoopX;
        this.myLoopY = myLoopY;
    }

    @NotNull
    public final Rect<TypeT> calculateBoundingBox(@NotNull Sequence<Pair<Double, Double>> xSegments, @NotNull Sequence<Pair<Double, Double>> ySegments) {
        Intrinsics.checkNotNullParameter(xSegments, (String)"xSegments");
        Intrinsics.checkNotNullParameter(ySegments, (String)"ySegments");
        ClosedRange<Double> xRange = this.calculateBoundingRange(xSegments, FunctionsKt.xRange(this.myMapRect), this.myLoopX);
        ClosedRange<Double> yRange = this.calculateBoundingRange(ySegments, FunctionsKt.yRange(this.myMapRect), this.myLoopY);
        return new Rect(((Number)xRange.getLowerEnd()).doubleValue(), ((Number)yRange.getLowerEnd()).doubleValue(), GeoBoundingBoxCalculator.Companion.length(xRange), GeoBoundingBoxCalculator.Companion.length(yRange));
    }

    private final ClosedRange<Double> calculateBoundingRange(Sequence<Pair<Double, Double>> segments, ClosedRange<Double> mapRange, boolean loop2) {
        ClosedRange<Double> closedRange;
        if (loop2) {
            closedRange = Companion.calculateLoopLimitRange$base_portable(segments, mapRange);
        } else {
            Double d = SequencesKt.minOrNull((Sequence)SequencesKt.map(segments, (Function1)((Function1)calculateBoundingRange.1.INSTANCE)));
            Intrinsics.checkNotNull((Object)d);
            Comparable comparable = d;
            Double d2 = SequencesKt.maxOrNull((Sequence)SequencesKt.map(segments, (Function1)((Function1)calculateBoundingRange.2.INSTANCE)));
            Intrinsics.checkNotNull((Object)d2);
            closedRange = new ClosedRange<Double>((Double)comparable, (Double)((Comparable)d2));
        }
        return closedRange;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u001c\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bj\u0002`\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\b\u000bJ*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0012\u0010\u0012\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/base/spatial/GeoBoundingBoxCalculator$Companion;", "", "()V", "calculateLoopLimitRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "segments", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Ljetbrains/datalore/base/spatial/Segment;", "mapRange", "calculateLoopLimitRange$base_portable", "findMaxGapBetweenRanges", "ranges", "width", "invertRange", "range", "normalizeCenter", "length", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClosedRange<Double> calculateLoopLimitRange$base_portable(@NotNull Sequence<Pair<Double, Double>> segments, @NotNull ClosedRange<Double> mapRange) {
            Intrinsics.checkNotNullParameter(segments, (String)"segments");
            Intrinsics.checkNotNullParameter(mapRange, (String)"mapRange");
            Object object = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map(segments, (Function1)((Function1)new Function1<Pair<? extends Double, ? extends Double>, List<? extends ClosedRange<Double>>>(mapRange){
                final /* synthetic */ ClosedRange<Double> $mapRange;
                {
                    this.$mapRange = $mapRange;
                    super(1);
                }

                @NotNull
                public final List<ClosedRange<Double>> invoke(@NotNull Pair<Double, Double> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return LongitudeSegment.Companion.splitSegment(GeoBoundingBoxCalculatorKt.getStart(it), GeoBoundingBoxCalculatorKt.getEnd(it), ((Number)this.$mapRange.getLowerEnd()).doubleValue(), ((Number)this.$mapRange.getUpperEnd()).doubleValue());
                }
            })));
            boolean bl = false;
            boolean bl2 = false;
            Sequence $this$calculateLoopLimitRange_u24lambda_u2d0 = object;
            boolean bl3 = false;
            object = Companion.findMaxGapBetweenRanges((Sequence<? extends ClosedRange<Double>>)$this$calculateLoopLimitRange_u24lambda_u2d0, Companion.length(mapRange));
            bl = false;
            bl2 = false;
            Object $this$calculateLoopLimitRange_u24lambda_u2d1 = object;
            boolean bl4 = false;
            object = Companion.invertRange((ClosedRange<Double>)$this$calculateLoopLimitRange_u24lambda_u2d1, Companion.length(mapRange));
            bl = false;
            bl2 = false;
            Object $this$calculateLoopLimitRange_u24lambda_u2d2 = object;
            boolean bl5 = false;
            return Companion.normalizeCenter((ClosedRange<Double>)$this$calculateLoopLimitRange_u24lambda_u2d2, mapRange);
        }

        private final ClosedRange<Double> normalizeCenter(ClosedRange<Double> range, ClosedRange<Double> mapRange) {
            return mapRange.contains((Double)((Comparable)Double.valueOf((((Number)range.getUpperEnd()).doubleValue() + ((Number)range.getLowerEnd()).doubleValue()) / (double)2))) ? range : new ClosedRange<Comparable>(Double.valueOf(((Number)range.getLowerEnd()).doubleValue() - this.length(mapRange)), Double.valueOf(((Number)range.getUpperEnd()).doubleValue() - this.length(mapRange)));
        }

        private final ClosedRange<Double> findMaxGapBetweenRanges(Sequence<? extends ClosedRange<Double>> ranges, double width2) {
            double maxValue$iv;
            Object v0;
            Sequence sortedRanges;
            Sequence<? extends ClosedRange<Double>> $this$sortedBy$iv = ranges;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            Sequence $this$maxByOrNull$iv = sortedRanges = SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ClosedRange p0 = (ClosedRange)a;
                    boolean bl2 = false;
                    Comparable comparable = Double.valueOf(((Number)p0.getLowerEnd()).doubleValue());
                    p0 = (ClosedRange)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Double d = ((Number)p0.getLowerEnd()).doubleValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                }
            });
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    ClosedRange p0 = (ClosedRange)maxElem$iv;
                    boolean bl2 = false;
                    maxValue$iv = ((Number)p0.getUpperEnd()).doubleValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        ClosedRange p02 = (ClosedRange)e$iv;
                        $i$a$-maxByOrNull-GeoBoundingBoxCalculator$Companion$findMaxGapBetweenRanges$prevUpper$1 = false;
                        double v$iv = ((Number)p02.getUpperEnd()).doubleValue();
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            double prevUpper = ((Number)((ClosedRange)v0).getUpperEnd()).doubleValue();
            double nextLower = ((Number)((ClosedRange)SequencesKt.first((Sequence)sortedRanges)).getLowerEnd()).doubleValue();
            maxValue$iv = width2 + nextLower;
            boolean v$iv = false;
            double gapRight = Math.max(maxValue$iv, prevUpper);
            ClosedRange<Comparable> maxGapRange = new ClosedRange<Comparable>(Double.valueOf(prevUpper), Double.valueOf(gapRight));
            Iterator it = sortedRanges.iterator();
            prevUpper = ((Number)((ClosedRange)it.next()).getUpperEnd()).doubleValue();
            while (it.hasNext()) {
                ClosedRange range = (ClosedRange)it.next();
                nextLower = ((Number)range.getLowerEnd()).doubleValue();
                if (nextLower > prevUpper && nextLower - prevUpper > this.length(maxGapRange)) {
                    maxGapRange = new ClosedRange<Comparable>(Double.valueOf(prevUpper), Double.valueOf(nextLower));
                }
                double d = ((Number)range.getUpperEnd()).doubleValue();
                boolean bl3 = false;
                prevUpper = Math.max(prevUpper, d);
            }
            return maxGapRange;
        }

        private final ClosedRange<Double> invertRange(ClosedRange<Double> range, double width2) {
            return this.length(range) > width2 ? new ClosedRange<Double>(range.getLowerEnd(), range.getLowerEnd()) : (((Number)range.getUpperEnd()).doubleValue() > width2 ? jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator$Companion.invertRange$safeRange(((Number)range.getUpperEnd()).doubleValue() - width2, ((Number)range.getLowerEnd()).doubleValue()) : jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator$Companion.invertRange$safeRange(((Number)range.getUpperEnd()).doubleValue(), width2 + ((Number)range.getLowerEnd()).doubleValue()));
        }

        private final double length(ClosedRange<Double> $this$length) {
            return ((Number)$this$length.getUpperEnd()).doubleValue() - ((Number)$this$length.getLowerEnd()).doubleValue();
        }

        private static final ClosedRange<Double> invertRange$safeRange(double first2, double second) {
            boolean bl = false;
            bl = false;
            return new ClosedRange<Comparable>(Double.valueOf(Math.min(first2, second)), Double.valueOf(Math.max(first2, second)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

