/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.datetime.tz;

import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.Month;
import jetbrains.datalore.base.datetime.WeekDay;
import jetbrains.datalore.base.datetime.tz.DateSpec;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/base/datetime/tz/DateSpecs;", "", "()V", "first", "Ljetbrains/datalore/base/datetime/tz/DateSpec;", "weekDay", "Ljetbrains/datalore/base/datetime/WeekDay;", "month", "Ljetbrains/datalore/base/datetime/Month;", "number", "", "last", "base-portable"})
public final class DateSpecs {
    @NotNull
    public static final DateSpecs INSTANCE = new DateSpecs();

    private DateSpecs() {
    }

    @NotNull
    public final DateSpec last(@NotNull WeekDay weekDay, @NotNull Month month) {
        Intrinsics.checkNotNullParameter((Object)((Object)weekDay), (String)"weekDay");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return new DateSpec(weekDay, month){
            final /* synthetic */ WeekDay $weekDay;
            final /* synthetic */ Month $month;
            {
                this.$weekDay = $weekDay;
                this.$month = $month;
            }

            @NotNull
            public String getRRule() {
                return "RRULE:FREQ=YEARLY;BYDAY=-1" + this.$weekDay.getAbbreviation() + ";BYMONTH=" + (this.$month.ordinal() + 1);
            }

            @NotNull
            public Date getDate(int year) {
                int days = this.$month.getDaysInYear(year);
                int n = days;
                if (1 <= n) {
                    do {
                        int d;
                        Date date;
                        if ((date = new Date(d = n--, this.$month, year)).getWeekDay() != this.$weekDay) continue;
                        return date;
                    } while (1 <= n);
                }
                throw new RuntimeException();
            }
        };
    }

    @JvmOverloads
    @NotNull
    public final DateSpec first(@NotNull WeekDay weekDay, @NotNull Month month, int number) {
        Intrinsics.checkNotNullParameter((Object)((Object)weekDay), (String)"weekDay");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return new DateSpec(number, weekDay, month){
            final /* synthetic */ int $number;
            final /* synthetic */ WeekDay $weekDay;
            final /* synthetic */ Month $month;
            {
                this.$number = $number;
                this.$weekDay = $weekDay;
                this.$month = $month;
            }

            @NotNull
            public String getRRule() {
                return "RRULE:FREQ=YEARLY;BYDAY=" + this.$number + this.$weekDay.getAbbreviation() + ";BYMONTH=" + (this.$month.ordinal() + 1);
            }

            @NotNull
            public Date getDate(int year) {
                int days;
                int startDay = (this.$number - 1) * WeekDay.values().length + 1;
                int n = startDay;
                if (n <= (days = this.$month.getDaysInYear(year))) {
                    int d;
                    do {
                        Date date;
                        if ((date = new Date(d = n++, this.$month, year)).getWeekDay() != this.$weekDay) continue;
                        return date;
                    } while (d != days);
                }
                throw new RuntimeException();
            }
        };
    }

    public static /* synthetic */ DateSpec first$default(DateSpecs dateSpecs, WeekDay weekDay, Month month, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return dateSpecs.first(weekDay, month, n);
    }

    @JvmOverloads
    @NotNull
    public final DateSpec first(@NotNull WeekDay weekDay, @NotNull Month month) {
        Intrinsics.checkNotNullParameter((Object)((Object)weekDay), (String)"weekDay");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return DateSpecs.first$default(this, weekDay, month, 0, 4, null);
    }
}

