/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.datetime;

import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.base.datetime.Month;
import jetbrains.datalore.base.datetime.Time;
import jetbrains.datalore.base.datetime.tz.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\fJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/base/datetime/JvmDateTimeUtil;", "", "()V", "fromJavaDate", "Ljetbrains/datalore/base/datetime/DateTime;", "date", "Ljava/util/Date;", "sourceZone", "Ljetbrains/datalore/base/datetime/tz/TimeZone;", "targetZone", "now", "toJavaDate", "Ljetbrains/datalore/base/datetime/Date;", "time", "base-portable"})
public final class JvmDateTimeUtil {
    @NotNull
    public static final JvmDateTimeUtil INSTANCE = new JvmDateTimeUtil();

    private JvmDateTimeUtil() {
    }

    @Nullable
    public final java.util.Date toJavaDate(@Nullable DateTime time) {
        java.util.Date date;
        if (time == null) {
            date = null;
        } else {
            int n = time.getYear() - 1900;
            Month month = time.getMonth();
            Intrinsics.checkNotNull((Object)month);
            date = new java.util.Date(n, month.ordinal(), time.getDay(), time.getHours(), time.getMinutes(), time.getSeconds());
        }
        return date;
    }

    @Nullable
    public final java.util.Date toJavaDate(@Nullable Date date) {
        return date == null ? null : new java.util.Date(date.getYear() - 1900, date.getMonth().ordinal(), date.getDay());
    }

    @Nullable
    public final DateTime fromJavaDate(@Nullable java.util.Date date, @Nullable TimeZone sourceZone, @Nullable TimeZone targetZone) {
        if (date == null) {
            return null;
        }
        DateTime dateTime = this.fromJavaDate(date);
        if (sourceZone == null && targetZone == null) {
            return dateTime;
        }
        TimeZone timeZone = targetZone;
        Intrinsics.checkNotNull((Object)timeZone);
        DateTime dateTime2 = dateTime;
        Intrinsics.checkNotNull((Object)dateTime2);
        TimeZone timeZone2 = sourceZone;
        Intrinsics.checkNotNull((Object)timeZone2);
        dateTime = timeZone.convertTo(dateTime2, timeZone2);
        return dateTime;
    }

    @Nullable
    public final DateTime fromJavaDate(@Nullable java.util.Date date) {
        return date == null ? null : new DateTime(new Date(date.getDate(), Month.Companion.values()[date.getMonth()], 1900 + date.getYear()), new Time(date.getHours(), date.getMinutes(), date.getSeconds(), 0, 8, null));
    }

    @Nullable
    public final DateTime now() {
        return this.fromJavaDate(new java.util.Date(System.currentTimeMillis()));
    }

    @Nullable
    public final java.util.Date toJavaDate(@Nullable DateTime time, @NotNull TimeZone sourceZone, @NotNull TimeZone targetZone) {
        Intrinsics.checkNotNullParameter((Object)sourceZone, (String)"sourceZone");
        Intrinsics.checkNotNullParameter((Object)targetZone, (String)"targetZone");
        return time == null ? null : this.toJavaDate(sourceZone.convertTo(time, targetZone));
    }
}

