/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.util.Map;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jorphan.math.StatCalculatorLong;

public class SamplingStatCalculator {
    private final StatCalculatorLong calculator = new StatCalculatorLong();
    private double maxThroughput;
    private long firstTime;
    private String label;
    private volatile Sample currentSample;

    public SamplingStatCalculator() {
        this("");
    }

    public SamplingStatCalculator(String label) {
        this.label = label;
        this.init();
    }

    private void init() {
        this.firstTime = Long.MAX_VALUE;
        this.calculator.clear();
        this.maxThroughput = Double.MIN_VALUE;
        this.currentSample = new Sample();
    }

    public synchronized void clear() {
        this.init();
    }

    public Sample getCurrentSample() {
        return this.currentSample;
    }

    public long getElapsed() {
        if (this.getCurrentSample().getEndTime() == 0L) {
            return 0L;
        }
        return this.getCurrentSample().getEndTime() - this.firstTime;
    }

    public double getRate() {
        if (this.calculator.getCount() == 0L) {
            return 0.0;
        }
        return this.getCurrentSample().getThroughput();
    }

    public double getBytesPerSecond() {
        return this.getRatePerSecond(this.calculator.getTotalBytes());
    }

    public double getKBPerSecond() {
        return this.getBytesPerSecond() / 1024.0;
    }

    public double getSentBytesPerSecond() {
        return this.getRatePerSecond(this.calculator.getTotalSentBytes());
    }

    private double getRatePerSecond(long value) {
        double rate = 0.0;
        if (this.getElapsed() > 0L && value > 0L) {
            rate = (double)value / ((double)this.getElapsed() / 1000.0);
        }
        if (rate < 0.0) {
            rate = 0.0;
        }
        return rate;
    }

    public double getSentKBPerSecond() {
        return this.getSentBytesPerSecond() / 1024.0;
    }

    public double getAvgPageBytes() {
        long count = this.calculator.getCount();
        if (count == 0L) {
            return 0.0;
        }
        return (double)this.calculator.getTotalBytes() / (double)count;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample addSample(SampleResult res) {
        Sample s;
        boolean rbool;
        long cpercent;
        long cmedian;
        long cstdv;
        long cmean;
        long rtime;
        double throughput;
        long endTime;
        long eCount;
        StatCalculatorLong statCalculatorLong = this.calculator;
        synchronized (statCalculatorLong) {
            this.calculator.addValue(res.getTime(), res.getSampleCount());
            this.calculator.addBytes(res.getBytesAsLong());
            this.calculator.addSentBytes(res.getSentBytes());
            this.setStartTime(res);
            eCount = this.getCurrentSample().getErrorCount();
            eCount += (long)res.getErrorCount();
            endTime = this.getEndTime(res);
            long howLongRunning = endTime - this.firstTime;
            throughput = (double)this.calculator.getCount() / (double)howLongRunning * 1000.0;
            if (throughput > this.maxThroughput) {
                this.maxThroughput = throughput;
            }
            rtime = res.getTime();
            cmean = (long)this.calculator.getMean();
            cstdv = (long)this.calculator.getStandardDeviation();
            cmedian = (Long)this.calculator.getMedian();
            cpercent = (Long)this.calculator.getPercentPoint(0.5);
            rbool = res.isSuccessful();
        }
        long count = this.calculator.getCount();
        this.currentSample = s = new Sample(null, rtime, cmean, cstdv, cmedian, cpercent, throughput, eCount, rbool, count, endTime);
        return s;
    }

    private long getEndTime(SampleResult res) {
        long endTime = res.getEndTime();
        long lastTime = this.getCurrentSample().getEndTime();
        if (lastTime < endTime) {
            lastTime = endTime;
        }
        return lastTime;
    }

    private void setStartTime(SampleResult res) {
        long startTime = res.getStartTime();
        if (this.firstTime > startTime) {
            this.firstTime = startTime;
        }
    }

    public double getErrorPercentage() {
        double rval = 0.0;
        if (this.calculator.getCount() == 0L) {
            return rval;
        }
        rval = (double)this.getCurrentSample().getErrorCount() / (double)this.calculator.getCount();
        return rval;
    }

    public String toString() {
        return "Samples: " + this.getCount() + "  Avg: " + this.getMean() + "  Min: " + this.getMin() + "  Max: " + this.getMax() + "  Error Rate: " + this.getErrorPercentage() + "  Sample Rate: " + this.getRate();
    }

    public long getErrorCount() {
        return this.getCurrentSample().getErrorCount();
    }

    public double getMaxThroughput() {
        return this.maxThroughput;
    }

    public Map<Number, Number[]> getDistribution() {
        return this.calculator.getDistribution();
    }

    public Number getPercentPoint(double percent) {
        return this.calculator.getPercentPoint(percent);
    }

    public long getCount() {
        return this.calculator.getCount();
    }

    public Number getMax() {
        return this.calculator.getMax();
    }

    public double getMean() {
        return this.calculator.getMean();
    }

    public Number getMeanAsNumber() {
        return (long)this.calculator.getMean();
    }

    public Number getMedian() {
        return this.calculator.getMedian();
    }

    public Number getMin() {
        if ((Long)this.calculator.getMin() < 0L) {
            return 0L;
        }
        return this.calculator.getMin();
    }

    public Number getPercentPoint(float percent) {
        return this.calculator.getPercentPoint(percent);
    }

    public double getStandardDeviation() {
        return this.calculator.getStandardDeviation();
    }
}

